// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.2
// 	protoc        v5.26.0
// source: conversation/conversation.proto

package conversation

import (
	sdkws "github.com/openimsdk/protocol/sdkws"
	wrapperspb "github.com/openimsdk/protocol/wrapperspb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Conversation struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID           string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	ConversationID        string                 `protobuf:"bytes,2,opt,name=conversationID,proto3" json:"conversationID"`
	RecvMsgOpt            int32                  `protobuf:"varint,3,opt,name=recvMsgOpt,proto3" json:"recvMsgOpt"`
	ConversationType      int32                  `protobuf:"varint,4,opt,name=conversationType,proto3" json:"conversationType"`
	UserID                string                 `protobuf:"bytes,5,opt,name=userID,proto3" json:"userID"`
	GroupID               string                 `protobuf:"bytes,6,opt,name=groupID,proto3" json:"groupID"`
	IsPinned              bool                   `protobuf:"varint,7,opt,name=isPinned,proto3" json:"isPinned"`
	AttachedInfo          string                 `protobuf:"bytes,8,opt,name=attachedInfo,proto3" json:"attachedInfo"`
	IsPrivateChat         bool                   `protobuf:"varint,9,opt,name=isPrivateChat,proto3" json:"isPrivateChat"`
	GroupAtType           int32                  `protobuf:"varint,10,opt,name=groupAtType,proto3" json:"groupAtType"`
	Ex                    string                 `protobuf:"bytes,11,opt,name=ex,proto3" json:"ex"`
	BurnDuration          int32                  `protobuf:"varint,12,opt,name=burnDuration,proto3" json:"burnDuration"`
	MinSeq                int64                  `protobuf:"varint,13,opt,name=minSeq,proto3" json:"minSeq"`
	MaxSeq                int64                  `protobuf:"varint,14,opt,name=maxSeq,proto3" json:"maxSeq"`
	MsgDestructTime       int64                  `protobuf:"varint,15,opt,name=msgDestructTime,proto3" json:"msgDestructTime"`
	LatestMsgDestructTime int64                  `protobuf:"varint,16,opt,name=latestMsgDestructTime,proto3" json:"latestMsgDestructTime"`
	IsMsgDestruct         bool                   `protobuf:"varint,17,opt,name=isMsgDestruct,proto3" json:"isMsgDestruct"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Conversation) Reset() {
	*x = Conversation{}
	mi := &file_conversation_conversation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Conversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation) ProtoMessage() {}

func (x *Conversation) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation.ProtoReflect.Descriptor instead.
func (*Conversation) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{0}
}

func (x *Conversation) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *Conversation) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *Conversation) GetRecvMsgOpt() int32 {
	if x != nil {
		return x.RecvMsgOpt
	}
	return 0
}

func (x *Conversation) GetConversationType() int32 {
	if x != nil {
		return x.ConversationType
	}
	return 0
}

func (x *Conversation) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *Conversation) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *Conversation) GetIsPinned() bool {
	if x != nil {
		return x.IsPinned
	}
	return false
}

func (x *Conversation) GetAttachedInfo() string {
	if x != nil {
		return x.AttachedInfo
	}
	return ""
}

func (x *Conversation) GetIsPrivateChat() bool {
	if x != nil {
		return x.IsPrivateChat
	}
	return false
}

func (x *Conversation) GetGroupAtType() int32 {
	if x != nil {
		return x.GroupAtType
	}
	return 0
}

func (x *Conversation) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *Conversation) GetBurnDuration() int32 {
	if x != nil {
		return x.BurnDuration
	}
	return 0
}

func (x *Conversation) GetMinSeq() int64 {
	if x != nil {
		return x.MinSeq
	}
	return 0
}

func (x *Conversation) GetMaxSeq() int64 {
	if x != nil {
		return x.MaxSeq
	}
	return 0
}

func (x *Conversation) GetMsgDestructTime() int64 {
	if x != nil {
		return x.MsgDestructTime
	}
	return 0
}

func (x *Conversation) GetLatestMsgDestructTime() int64 {
	if x != nil {
		return x.LatestMsgDestructTime
	}
	return 0
}

func (x *Conversation) GetIsMsgDestruct() bool {
	if x != nil {
		return x.IsMsgDestruct
	}
	return false
}

type ConversationReq struct {
	state            protoimpl.MessageState  `protogen:"open.v1"`
	ConversationID   string                  `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	ConversationType int32                   `protobuf:"varint,2,opt,name=conversationType,proto3" json:"conversationType"`
	UserID           string                  `protobuf:"bytes,3,opt,name=userID,proto3" json:"userID"`
	GroupID          string                  `protobuf:"bytes,4,opt,name=groupID,proto3" json:"groupID"`
	RecvMsgOpt       *wrapperspb.Int32Value  `protobuf:"bytes,5,opt,name=recvMsgOpt,proto3" json:"recvMsgOpt"`
	IsPinned         *wrapperspb.BoolValue   `protobuf:"bytes,6,opt,name=isPinned,proto3" json:"isPinned"`
	AttachedInfo     *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=attachedInfo,proto3" json:"attachedInfo"`
	IsPrivateChat    *wrapperspb.BoolValue   `protobuf:"bytes,8,opt,name=isPrivateChat,proto3" json:"isPrivateChat"`
	Ex               *wrapperspb.StringValue `protobuf:"bytes,9,opt,name=ex,proto3" json:"ex"`
	BurnDuration     *wrapperspb.Int32Value  `protobuf:"bytes,10,opt,name=burnDuration,proto3" json:"burnDuration"`
	MinSeq           *wrapperspb.Int64Value  `protobuf:"bytes,11,opt,name=minSeq,proto3" json:"minSeq"`
	MaxSeq           *wrapperspb.Int64Value  `protobuf:"bytes,12,opt,name=maxSeq,proto3" json:"maxSeq"`
	GroupAtType      *wrapperspb.Int32Value  `protobuf:"bytes,13,opt,name=groupAtType,proto3" json:"groupAtType"`
	MsgDestructTime  *wrapperspb.Int64Value  `protobuf:"bytes,14,opt,name=msgDestructTime,proto3" json:"msgDestructTime"`
	IsMsgDestruct    *wrapperspb.BoolValue   `protobuf:"bytes,15,opt,name=isMsgDestruct,proto3" json:"isMsgDestruct"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ConversationReq) Reset() {
	*x = ConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationReq) ProtoMessage() {}

func (x *ConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationReq.ProtoReflect.Descriptor instead.
func (*ConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{1}
}

func (x *ConversationReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *ConversationReq) GetConversationType() int32 {
	if x != nil {
		return x.ConversationType
	}
	return 0
}

func (x *ConversationReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ConversationReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *ConversationReq) GetRecvMsgOpt() *wrapperspb.Int32Value {
	if x != nil {
		return x.RecvMsgOpt
	}
	return nil
}

func (x *ConversationReq) GetIsPinned() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsPinned
	}
	return nil
}

func (x *ConversationReq) GetAttachedInfo() *wrapperspb.StringValue {
	if x != nil {
		return x.AttachedInfo
	}
	return nil
}

func (x *ConversationReq) GetIsPrivateChat() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsPrivateChat
	}
	return nil
}

func (x *ConversationReq) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

func (x *ConversationReq) GetBurnDuration() *wrapperspb.Int32Value {
	if x != nil {
		return x.BurnDuration
	}
	return nil
}

func (x *ConversationReq) GetMinSeq() *wrapperspb.Int64Value {
	if x != nil {
		return x.MinSeq
	}
	return nil
}

func (x *ConversationReq) GetMaxSeq() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxSeq
	}
	return nil
}

func (x *ConversationReq) GetGroupAtType() *wrapperspb.Int32Value {
	if x != nil {
		return x.GroupAtType
	}
	return nil
}

func (x *ConversationReq) GetMsgDestructTime() *wrapperspb.Int64Value {
	if x != nil {
		return x.MsgDestructTime
	}
	return nil
}

func (x *ConversationReq) GetIsMsgDestruct() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsMsgDestruct
	}
	return nil
}

type SetConversationReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversation  *Conversation          `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationReq) Reset() {
	*x = SetConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationReq) ProtoMessage() {}

func (x *SetConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationReq.ProtoReflect.Descriptor instead.
func (*SetConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{2}
}

func (x *SetConversationReq) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

type SetConversationResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationResp) Reset() {
	*x = SetConversationResp{}
	mi := &file_conversation_conversation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationResp) ProtoMessage() {}

func (x *SetConversationResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationResp.ProtoReflect.Descriptor instead.
func (*SetConversationResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{3}
}

type GetConversationReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	OwnerUserID    string                 `protobuf:"bytes,2,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetConversationReq) Reset() {
	*x = GetConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationReq) ProtoMessage() {}

func (x *GetConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationReq.ProtoReflect.Descriptor instead.
func (*GetConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{4}
}

func (x *GetConversationReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *GetConversationReq) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

type GetConversationResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversation  *Conversation          `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationResp) Reset() {
	*x = GetConversationResp{}
	mi := &file_conversation_conversation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationResp) ProtoMessage() {}

func (x *GetConversationResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationResp.ProtoReflect.Descriptor instead.
func (*GetConversationResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{5}
}

func (x *GetConversationResp) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

type GetSortedConversationListReq struct {
	state           protoimpl.MessageState   `protogen:"open.v1"`
	UserID          string                   `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ConversationIDs []string                 `protobuf:"bytes,2,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	Pagination      *sdkws.RequestPagination `protobuf:"bytes,3,opt,name=pagination,proto3" json:"pagination"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetSortedConversationListReq) Reset() {
	*x = GetSortedConversationListReq{}
	mi := &file_conversation_conversation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSortedConversationListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSortedConversationListReq) ProtoMessage() {}

func (x *GetSortedConversationListReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSortedConversationListReq.ProtoReflect.Descriptor instead.
func (*GetSortedConversationListReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{6}
}

func (x *GetSortedConversationListReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GetSortedConversationListReq) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

func (x *GetSortedConversationListReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

type GetSortedConversationListResp struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	ConversationTotal int64                  `protobuf:"varint,1,opt,name=conversationTotal,proto3" json:"conversationTotal"`
	UnreadTotal       int64                  `protobuf:"varint,2,opt,name=unreadTotal,proto3" json:"unreadTotal"`
	ConversationElems []*ConversationElem    `protobuf:"bytes,3,rep,name=conversationElems,proto3" json:"conversationElems"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetSortedConversationListResp) Reset() {
	*x = GetSortedConversationListResp{}
	mi := &file_conversation_conversation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSortedConversationListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSortedConversationListResp) ProtoMessage() {}

func (x *GetSortedConversationListResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSortedConversationListResp.ProtoReflect.Descriptor instead.
func (*GetSortedConversationListResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{7}
}

func (x *GetSortedConversationListResp) GetConversationTotal() int64 {
	if x != nil {
		return x.ConversationTotal
	}
	return 0
}

func (x *GetSortedConversationListResp) GetUnreadTotal() int64 {
	if x != nil {
		return x.UnreadTotal
	}
	return 0
}

func (x *GetSortedConversationListResp) GetConversationElems() []*ConversationElem {
	if x != nil {
		return x.ConversationElems
	}
	return nil
}

type ConversationElem struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	RecvMsgOpt     int32                  `protobuf:"varint,2,opt,name=recvMsgOpt,proto3" json:"recvMsgOpt"`
	UnreadCount    int64                  `protobuf:"varint,3,opt,name=unreadCount,proto3" json:"unreadCount"`
	IsPinned       bool                   `protobuf:"varint,4,opt,name=IsPinned,proto3" json:"IsPinned"`
	MsgInfo        *MsgInfo               `protobuf:"bytes,5,opt,name=msgInfo,proto3" json:"msgInfo"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ConversationElem) Reset() {
	*x = ConversationElem{}
	mi := &file_conversation_conversation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationElem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationElem) ProtoMessage() {}

func (x *ConversationElem) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationElem.ProtoReflect.Descriptor instead.
func (*ConversationElem) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{8}
}

func (x *ConversationElem) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *ConversationElem) GetRecvMsgOpt() int32 {
	if x != nil {
		return x.RecvMsgOpt
	}
	return 0
}

func (x *ConversationElem) GetUnreadCount() int64 {
	if x != nil {
		return x.UnreadCount
	}
	return 0
}

func (x *ConversationElem) GetIsPinned() bool {
	if x != nil {
		return x.IsPinned
	}
	return false
}

func (x *ConversationElem) GetMsgInfo() *MsgInfo {
	if x != nil {
		return x.MsgInfo
	}
	return nil
}

type MsgInfo struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	ServerMsgID       string                 `protobuf:"bytes,1,opt,name=serverMsgID,proto3" json:"serverMsgID"`
	ClientMsgID       string                 `protobuf:"bytes,2,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	SessionType       int32                  `protobuf:"varint,3,opt,name=sessionType,proto3" json:"sessionType"`
	SendID            string                 `protobuf:"bytes,4,opt,name=sendID,proto3" json:"sendID"`
	RecvID            string                 `protobuf:"bytes,5,opt,name=recvID,proto3" json:"recvID"`
	SenderName        string                 `protobuf:"bytes,6,opt,name=senderName,proto3" json:"senderName"`
	FaceURL           string                 `protobuf:"bytes,7,opt,name=faceURL,proto3" json:"faceURL"`
	GroupID           string                 `protobuf:"bytes,8,opt,name=groupID,proto3" json:"groupID"`
	GroupName         string                 `protobuf:"bytes,9,opt,name=groupName,proto3" json:"groupName"`
	GroupFaceURL      string                 `protobuf:"bytes,10,opt,name=groupFaceURL,proto3" json:"groupFaceURL"`
	GroupType         int32                  `protobuf:"varint,11,opt,name=groupType,proto3" json:"groupType"`
	GroupMemberCount  uint32                 `protobuf:"varint,12,opt,name=groupMemberCount,proto3" json:"groupMemberCount"`
	LatestMsgRecvTime int64                  `protobuf:"varint,13,opt,name=LatestMsgRecvTime,proto3" json:"LatestMsgRecvTime"`
	MsgFrom           int32                  `protobuf:"varint,14,opt,name=msgFrom,proto3" json:"msgFrom"`
	ContentType       int32                  `protobuf:"varint,15,opt,name=contentType,proto3" json:"contentType"`
	Content           string                 `protobuf:"bytes,16,opt,name=content,proto3" json:"content"`
	Ex                string                 `protobuf:"bytes,17,opt,name=ex,proto3" json:"ex"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *MsgInfo) Reset() {
	*x = MsgInfo{}
	mi := &file_conversation_conversation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MsgInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MsgInfo) ProtoMessage() {}

func (x *MsgInfo) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MsgInfo.ProtoReflect.Descriptor instead.
func (*MsgInfo) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{9}
}

func (x *MsgInfo) GetServerMsgID() string {
	if x != nil {
		return x.ServerMsgID
	}
	return ""
}

func (x *MsgInfo) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *MsgInfo) GetSessionType() int32 {
	if x != nil {
		return x.SessionType
	}
	return 0
}

func (x *MsgInfo) GetSendID() string {
	if x != nil {
		return x.SendID
	}
	return ""
}

func (x *MsgInfo) GetRecvID() string {
	if x != nil {
		return x.RecvID
	}
	return ""
}

func (x *MsgInfo) GetSenderName() string {
	if x != nil {
		return x.SenderName
	}
	return ""
}

func (x *MsgInfo) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *MsgInfo) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *MsgInfo) GetGroupName() string {
	if x != nil {
		return x.GroupName
	}
	return ""
}

func (x *MsgInfo) GetGroupFaceURL() string {
	if x != nil {
		return x.GroupFaceURL
	}
	return ""
}

func (x *MsgInfo) GetGroupType() int32 {
	if x != nil {
		return x.GroupType
	}
	return 0
}

func (x *MsgInfo) GetGroupMemberCount() uint32 {
	if x != nil {
		return x.GroupMemberCount
	}
	return 0
}

func (x *MsgInfo) GetLatestMsgRecvTime() int64 {
	if x != nil {
		return x.LatestMsgRecvTime
	}
	return 0
}

func (x *MsgInfo) GetMsgFrom() int32 {
	if x != nil {
		return x.MsgFrom
	}
	return 0
}

func (x *MsgInfo) GetContentType() int32 {
	if x != nil {
		return x.ContentType
	}
	return 0
}

func (x *MsgInfo) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *MsgInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type GetConversationsReq struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID     string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	ConversationIDs []string               `protobuf:"bytes,2,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetConversationsReq) Reset() {
	*x = GetConversationsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsReq) ProtoMessage() {}

func (x *GetConversationsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsReq.ProtoReflect.Descriptor instead.
func (*GetConversationsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{10}
}

func (x *GetConversationsReq) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *GetConversationsReq) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type GetConversationsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversations []*Conversation        `protobuf:"bytes,2,rep,name=conversations,proto3" json:"conversations"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationsResp) Reset() {
	*x = GetConversationsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsResp) ProtoMessage() {}

func (x *GetConversationsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsResp.ProtoReflect.Descriptor instead.
func (*GetConversationsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{11}
}

func (x *GetConversationsResp) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

type GetAllConversationsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID   string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetAllConversationsReq) Reset() {
	*x = GetAllConversationsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAllConversationsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAllConversationsReq) ProtoMessage() {}

func (x *GetAllConversationsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAllConversationsReq.ProtoReflect.Descriptor instead.
func (*GetAllConversationsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{12}
}

func (x *GetAllConversationsReq) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

type GetAllConversationsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversations []*Conversation        `protobuf:"bytes,2,rep,name=conversations,proto3" json:"conversations"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetAllConversationsResp) Reset() {
	*x = GetAllConversationsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAllConversationsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAllConversationsResp) ProtoMessage() {}

func (x *GetAllConversationsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAllConversationsResp.ProtoReflect.Descriptor instead.
func (*GetAllConversationsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{13}
}

func (x *GetAllConversationsResp) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

type GetRecvMsgNotNotifyUserIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRecvMsgNotNotifyUserIDsReq) Reset() {
	*x = GetRecvMsgNotNotifyUserIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRecvMsgNotNotifyUserIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRecvMsgNotNotifyUserIDsReq) ProtoMessage() {}

func (x *GetRecvMsgNotNotifyUserIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRecvMsgNotNotifyUserIDsReq.ProtoReflect.Descriptor instead.
func (*GetRecvMsgNotNotifyUserIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{14}
}

func (x *GetRecvMsgNotNotifyUserIDsReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetRecvMsgNotNotifyUserIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRecvMsgNotNotifyUserIDsResp) Reset() {
	*x = GetRecvMsgNotNotifyUserIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRecvMsgNotNotifyUserIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRecvMsgNotNotifyUserIDsResp) ProtoMessage() {}

func (x *GetRecvMsgNotNotifyUserIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRecvMsgNotNotifyUserIDsResp.ProtoReflect.Descriptor instead.
func (*GetRecvMsgNotNotifyUserIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{15}
}

func (x *GetRecvMsgNotNotifyUserIDsResp) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type CreateSingleChatConversationsReq struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	RecvID           string                 `protobuf:"bytes,1,opt,name=recvID,proto3" json:"recvID"`
	SendID           string                 `protobuf:"bytes,2,opt,name=sendID,proto3" json:"sendID"`
	ConversationID   string                 `protobuf:"bytes,3,opt,name=conversationID,proto3" json:"conversationID"`
	ConversationType int32                  `protobuf:"varint,4,opt,name=conversationType,proto3" json:"conversationType"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CreateSingleChatConversationsReq) Reset() {
	*x = CreateSingleChatConversationsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleChatConversationsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleChatConversationsReq) ProtoMessage() {}

func (x *CreateSingleChatConversationsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleChatConversationsReq.ProtoReflect.Descriptor instead.
func (*CreateSingleChatConversationsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{16}
}

func (x *CreateSingleChatConversationsReq) GetRecvID() string {
	if x != nil {
		return x.RecvID
	}
	return ""
}

func (x *CreateSingleChatConversationsReq) GetSendID() string {
	if x != nil {
		return x.SendID
	}
	return ""
}

func (x *CreateSingleChatConversationsReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *CreateSingleChatConversationsReq) GetConversationType() int32 {
	if x != nil {
		return x.ConversationType
	}
	return 0
}

type CreateSingleChatConversationsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateSingleChatConversationsResp) Reset() {
	*x = CreateSingleChatConversationsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleChatConversationsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleChatConversationsResp) ProtoMessage() {}

func (x *CreateSingleChatConversationsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleChatConversationsResp.ProtoReflect.Descriptor instead.
func (*CreateSingleChatConversationsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{17}
}

type CreateGroupChatConversationsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	GroupID       string                 `protobuf:"bytes,2,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGroupChatConversationsReq) Reset() {
	*x = CreateGroupChatConversationsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGroupChatConversationsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupChatConversationsReq) ProtoMessage() {}

func (x *CreateGroupChatConversationsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupChatConversationsReq.ProtoReflect.Descriptor instead.
func (*CreateGroupChatConversationsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{18}
}

func (x *CreateGroupChatConversationsReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

func (x *CreateGroupChatConversationsReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type CreateGroupChatConversationsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGroupChatConversationsResp) Reset() {
	*x = CreateGroupChatConversationsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGroupChatConversationsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupChatConversationsResp) ProtoMessage() {}

func (x *CreateGroupChatConversationsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupChatConversationsResp.ProtoReflect.Descriptor instead.
func (*CreateGroupChatConversationsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{19}
}

type SetConversationMaxSeqReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	OwnerUserID    []string               `protobuf:"bytes,2,rep,name=ownerUserID,proto3" json:"ownerUserID"`
	MaxSeq         int64                  `protobuf:"varint,3,opt,name=maxSeq,proto3" json:"maxSeq"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SetConversationMaxSeqReq) Reset() {
	*x = SetConversationMaxSeqReq{}
	mi := &file_conversation_conversation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationMaxSeqReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationMaxSeqReq) ProtoMessage() {}

func (x *SetConversationMaxSeqReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationMaxSeqReq.ProtoReflect.Descriptor instead.
func (*SetConversationMaxSeqReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{20}
}

func (x *SetConversationMaxSeqReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *SetConversationMaxSeqReq) GetOwnerUserID() []string {
	if x != nil {
		return x.OwnerUserID
	}
	return nil
}

func (x *SetConversationMaxSeqReq) GetMaxSeq() int64 {
	if x != nil {
		return x.MaxSeq
	}
	return 0
}

type SetConversationMaxSeqResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationMaxSeqResp) Reset() {
	*x = SetConversationMaxSeqResp{}
	mi := &file_conversation_conversation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationMaxSeqResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationMaxSeqResp) ProtoMessage() {}

func (x *SetConversationMaxSeqResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationMaxSeqResp.ProtoReflect.Descriptor instead.
func (*SetConversationMaxSeqResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{21}
}

type SetConversationMinSeqReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	OwnerUserID    []string               `protobuf:"bytes,2,rep,name=ownerUserID,proto3" json:"ownerUserID"`
	MinSeq         int64                  `protobuf:"varint,3,opt,name=minSeq,proto3" json:"minSeq"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SetConversationMinSeqReq) Reset() {
	*x = SetConversationMinSeqReq{}
	mi := &file_conversation_conversation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationMinSeqReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationMinSeqReq) ProtoMessage() {}

func (x *SetConversationMinSeqReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationMinSeqReq.ProtoReflect.Descriptor instead.
func (*SetConversationMinSeqReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{22}
}

func (x *SetConversationMinSeqReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *SetConversationMinSeqReq) GetOwnerUserID() []string {
	if x != nil {
		return x.OwnerUserID
	}
	return nil
}

func (x *SetConversationMinSeqReq) GetMinSeq() int64 {
	if x != nil {
		return x.MinSeq
	}
	return 0
}

type SetConversationMinSeqResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationMinSeqResp) Reset() {
	*x = SetConversationMinSeqResp{}
	mi := &file_conversation_conversation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationMinSeqResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationMinSeqResp) ProtoMessage() {}

func (x *SetConversationMinSeqResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationMinSeqResp.ProtoReflect.Descriptor instead.
func (*SetConversationMinSeqResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{23}
}

type GetConversationIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationIDsReq) Reset() {
	*x = GetConversationIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationIDsReq) ProtoMessage() {}

func (x *GetConversationIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationIDsReq.ProtoReflect.Descriptor instead.
func (*GetConversationIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{24}
}

func (x *GetConversationIDsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetConversationIDsResp struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ConversationIDs []string               `protobuf:"bytes,1,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetConversationIDsResp) Reset() {
	*x = GetConversationIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationIDsResp) ProtoMessage() {}

func (x *GetConversationIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationIDsResp.ProtoReflect.Descriptor instead.
func (*GetConversationIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{25}
}

func (x *GetConversationIDsResp) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type SetConversationsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	Conversation  *ConversationReq       `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationsReq) Reset() {
	*x = SetConversationsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationsReq) ProtoMessage() {}

func (x *SetConversationsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationsReq.ProtoReflect.Descriptor instead.
func (*SetConversationsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{26}
}

func (x *SetConversationsReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

func (x *SetConversationsReq) GetConversation() *ConversationReq {
	if x != nil {
		return x.Conversation
	}
	return nil
}

type SetConversationsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetConversationsResp) Reset() {
	*x = SetConversationsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetConversationsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetConversationsResp) ProtoMessage() {}

func (x *SetConversationsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetConversationsResp.ProtoReflect.Descriptor instead.
func (*SetConversationsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{27}
}

type GetUserConversationIDsHashReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID   string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserConversationIDsHashReq) Reset() {
	*x = GetUserConversationIDsHashReq{}
	mi := &file_conversation_conversation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserConversationIDsHashReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserConversationIDsHashReq) ProtoMessage() {}

func (x *GetUserConversationIDsHashReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserConversationIDsHashReq.ProtoReflect.Descriptor instead.
func (*GetUserConversationIDsHashReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{28}
}

func (x *GetUserConversationIDsHashReq) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

type GetUserConversationIDsHashResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Hash          uint64                 `protobuf:"varint,1,opt,name=hash,proto3" json:"hash"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserConversationIDsHashResp) Reset() {
	*x = GetUserConversationIDsHashResp{}
	mi := &file_conversation_conversation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserConversationIDsHashResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserConversationIDsHashResp) ProtoMessage() {}

func (x *GetUserConversationIDsHashResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserConversationIDsHashResp.ProtoReflect.Descriptor instead.
func (*GetUserConversationIDsHashResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{29}
}

func (x *GetUserConversationIDsHashResp) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

type GetConversationsByConversationIDReq struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ConversationIDs []string               `protobuf:"bytes,1,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetConversationsByConversationIDReq) Reset() {
	*x = GetConversationsByConversationIDReq{}
	mi := &file_conversation_conversation_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsByConversationIDReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsByConversationIDReq) ProtoMessage() {}

func (x *GetConversationsByConversationIDReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsByConversationIDReq.ProtoReflect.Descriptor instead.
func (*GetConversationsByConversationIDReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{30}
}

func (x *GetConversationsByConversationIDReq) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type GetConversationsByConversationIDResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversations []*Conversation        `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationsByConversationIDResp) Reset() {
	*x = GetConversationsByConversationIDResp{}
	mi := &file_conversation_conversation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsByConversationIDResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsByConversationIDResp) ProtoMessage() {}

func (x *GetConversationsByConversationIDResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsByConversationIDResp.ProtoReflect.Descriptor instead.
func (*GetConversationsByConversationIDResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{31}
}

func (x *GetConversationsByConversationIDResp) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

type GetConversationOfflinePushUserIDsReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	UserIDs        []string               `protobuf:"bytes,2,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetConversationOfflinePushUserIDsReq) Reset() {
	*x = GetConversationOfflinePushUserIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationOfflinePushUserIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationOfflinePushUserIDsReq) ProtoMessage() {}

func (x *GetConversationOfflinePushUserIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationOfflinePushUserIDsReq.ProtoReflect.Descriptor instead.
func (*GetConversationOfflinePushUserIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{32}
}

func (x *GetConversationOfflinePushUserIDsReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *GetConversationOfflinePushUserIDsReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetConversationOfflinePushUserIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationOfflinePushUserIDsResp) Reset() {
	*x = GetConversationOfflinePushUserIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationOfflinePushUserIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationOfflinePushUserIDsResp) ProtoMessage() {}

func (x *GetConversationOfflinePushUserIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationOfflinePushUserIDsResp.ProtoReflect.Descriptor instead.
func (*GetConversationOfflinePushUserIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{33}
}

func (x *GetConversationOfflinePushUserIDsResp) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetConversationNotReceiveMessageUserIDsReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetConversationNotReceiveMessageUserIDsReq) Reset() {
	*x = GetConversationNotReceiveMessageUserIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationNotReceiveMessageUserIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationNotReceiveMessageUserIDsReq) ProtoMessage() {}

func (x *GetConversationNotReceiveMessageUserIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationNotReceiveMessageUserIDsReq.ProtoReflect.Descriptor instead.
func (*GetConversationNotReceiveMessageUserIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{34}
}

func (x *GetConversationNotReceiveMessageUserIDsReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

type GetConversationNotReceiveMessageUserIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationNotReceiveMessageUserIDsResp) Reset() {
	*x = GetConversationNotReceiveMessageUserIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationNotReceiveMessageUserIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationNotReceiveMessageUserIDsResp) ProtoMessage() {}

func (x *GetConversationNotReceiveMessageUserIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationNotReceiveMessageUserIDsResp.ProtoReflect.Descriptor instead.
func (*GetConversationNotReceiveMessageUserIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{35}
}

func (x *GetConversationNotReceiveMessageUserIDsResp) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type UpdateConversationReq struct {
	state                 protoimpl.MessageState  `protogen:"open.v1"`
	ConversationID        string                  `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	UserIDs               []string                `protobuf:"bytes,2,rep,name=userIDs,proto3" json:"userIDs"`
	RecvMsgOpt            *wrapperspb.Int32Value  `protobuf:"bytes,3,opt,name=recvMsgOpt,proto3" json:"recvMsgOpt"`
	IsPinned              *wrapperspb.BoolValue   `protobuf:"bytes,4,opt,name=isPinned,proto3" json:"isPinned"`
	AttachedInfo          *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=attachedInfo,proto3" json:"attachedInfo"`
	IsPrivateChat         *wrapperspb.BoolValue   `protobuf:"bytes,6,opt,name=isPrivateChat,proto3" json:"isPrivateChat"`
	Ex                    *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=ex,proto3" json:"ex"`
	BurnDuration          *wrapperspb.Int32Value  `protobuf:"bytes,8,opt,name=burnDuration,proto3" json:"burnDuration"`
	MinSeq                *wrapperspb.Int64Value  `protobuf:"bytes,9,opt,name=minSeq,proto3" json:"minSeq"`
	MaxSeq                *wrapperspb.Int64Value  `protobuf:"bytes,10,opt,name=maxSeq,proto3" json:"maxSeq"`
	GroupAtType           *wrapperspb.Int32Value  `protobuf:"bytes,11,opt,name=groupAtType,proto3" json:"groupAtType"`
	MsgDestructTime       *wrapperspb.Int64Value  `protobuf:"bytes,12,opt,name=msgDestructTime,proto3" json:"msgDestructTime"`
	IsMsgDestruct         *wrapperspb.BoolValue   `protobuf:"bytes,13,opt,name=isMsgDestruct,proto3" json:"isMsgDestruct"`
	LatestMsgDestructTime *wrapperspb.Int64Value  `protobuf:"bytes,14,opt,name=latestMsgDestructTime,proto3" json:"latestMsgDestructTime"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UpdateConversationReq) Reset() {
	*x = UpdateConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationReq) ProtoMessage() {}

func (x *UpdateConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationReq.ProtoReflect.Descriptor instead.
func (*UpdateConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateConversationReq) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *UpdateConversationReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

func (x *UpdateConversationReq) GetRecvMsgOpt() *wrapperspb.Int32Value {
	if x != nil {
		return x.RecvMsgOpt
	}
	return nil
}

func (x *UpdateConversationReq) GetIsPinned() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsPinned
	}
	return nil
}

func (x *UpdateConversationReq) GetAttachedInfo() *wrapperspb.StringValue {
	if x != nil {
		return x.AttachedInfo
	}
	return nil
}

func (x *UpdateConversationReq) GetIsPrivateChat() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsPrivateChat
	}
	return nil
}

func (x *UpdateConversationReq) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

func (x *UpdateConversationReq) GetBurnDuration() *wrapperspb.Int32Value {
	if x != nil {
		return x.BurnDuration
	}
	return nil
}

func (x *UpdateConversationReq) GetMinSeq() *wrapperspb.Int64Value {
	if x != nil {
		return x.MinSeq
	}
	return nil
}

func (x *UpdateConversationReq) GetMaxSeq() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxSeq
	}
	return nil
}

func (x *UpdateConversationReq) GetGroupAtType() *wrapperspb.Int32Value {
	if x != nil {
		return x.GroupAtType
	}
	return nil
}

func (x *UpdateConversationReq) GetMsgDestructTime() *wrapperspb.Int64Value {
	if x != nil {
		return x.MsgDestructTime
	}
	return nil
}

func (x *UpdateConversationReq) GetIsMsgDestruct() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsMsgDestruct
	}
	return nil
}

func (x *UpdateConversationReq) GetLatestMsgDestructTime() *wrapperspb.Int64Value {
	if x != nil {
		return x.LatestMsgDestructTime
	}
	return nil
}

type UpdateConversationResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateConversationResp) Reset() {
	*x = UpdateConversationResp{}
	mi := &file_conversation_conversation_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConversationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationResp) ProtoMessage() {}

func (x *UpdateConversationResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationResp.ProtoReflect.Descriptor instead.
func (*UpdateConversationResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{37}
}

type GetFullOwnerConversationIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IdHash        uint64                 `protobuf:"varint,1,opt,name=idHash,proto3" json:"idHash"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFullOwnerConversationIDsReq) Reset() {
	*x = GetFullOwnerConversationIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullOwnerConversationIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullOwnerConversationIDsReq) ProtoMessage() {}

func (x *GetFullOwnerConversationIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullOwnerConversationIDsReq.ProtoReflect.Descriptor instead.
func (*GetFullOwnerConversationIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{38}
}

func (x *GetFullOwnerConversationIDsReq) GetIdHash() uint64 {
	if x != nil {
		return x.IdHash
	}
	return 0
}

func (x *GetFullOwnerConversationIDsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetFullOwnerConversationIDsResp struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Version         uint64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID       string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Equal           bool                   `protobuf:"varint,3,opt,name=equal,proto3" json:"equal"`
	ConversationIDs []string               `protobuf:"bytes,4,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetFullOwnerConversationIDsResp) Reset() {
	*x = GetFullOwnerConversationIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullOwnerConversationIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullOwnerConversationIDsResp) ProtoMessage() {}

func (x *GetFullOwnerConversationIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullOwnerConversationIDsResp.ProtoReflect.Descriptor instead.
func (*GetFullOwnerConversationIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{39}
}

func (x *GetFullOwnerConversationIDsResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetFullOwnerConversationIDsResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetFullOwnerConversationIDsResp) GetEqual() bool {
	if x != nil {
		return x.Equal
	}
	return false
}

func (x *GetFullOwnerConversationIDsResp) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type GetIncrementalConversationReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Version       uint64                 `protobuf:"varint,3,opt,name=version,proto3" json:"version"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalConversationReq) Reset() {
	*x = GetIncrementalConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalConversationReq) ProtoMessage() {}

func (x *GetIncrementalConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalConversationReq.ProtoReflect.Descriptor instead.
func (*GetIncrementalConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{40}
}

func (x *GetIncrementalConversationReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GetIncrementalConversationReq) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalConversationReq) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

type GetIncrementalConversationResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Full          bool                   `protobuf:"varint,3,opt,name=full,proto3" json:"full"`
	Delete        []string               `protobuf:"bytes,4,rep,name=delete,proto3" json:"delete"`
	Insert        []*Conversation        `protobuf:"bytes,5,rep,name=insert,proto3" json:"insert"`
	Update        []*Conversation        `protobuf:"bytes,6,rep,name=update,proto3" json:"update"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalConversationResp) Reset() {
	*x = GetIncrementalConversationResp{}
	mi := &file_conversation_conversation_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalConversationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalConversationResp) ProtoMessage() {}

func (x *GetIncrementalConversationResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalConversationResp.ProtoReflect.Descriptor instead.
func (*GetIncrementalConversationResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{41}
}

func (x *GetIncrementalConversationResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetIncrementalConversationResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalConversationResp) GetFull() bool {
	if x != nil {
		return x.Full
	}
	return false
}

func (x *GetIncrementalConversationResp) GetDelete() []string {
	if x != nil {
		return x.Delete
	}
	return nil
}

func (x *GetIncrementalConversationResp) GetInsert() []*Conversation {
	if x != nil {
		return x.Insert
	}
	return nil
}

func (x *GetIncrementalConversationResp) GetUpdate() []*Conversation {
	if x != nil {
		return x.Update
	}
	return nil
}

type GetOwnerConversationReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	UserID        string                   `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOwnerConversationReq) Reset() {
	*x = GetOwnerConversationReq{}
	mi := &file_conversation_conversation_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOwnerConversationReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOwnerConversationReq) ProtoMessage() {}

func (x *GetOwnerConversationReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOwnerConversationReq.ProtoReflect.Descriptor instead.
func (*GetOwnerConversationReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{42}
}

func (x *GetOwnerConversationReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GetOwnerConversationReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

type GetOwnerConversationResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         int64                  `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Conversations []*Conversation        `protobuf:"bytes,2,rep,name=conversations,proto3" json:"conversations"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOwnerConversationResp) Reset() {
	*x = GetOwnerConversationResp{}
	mi := &file_conversation_conversation_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOwnerConversationResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOwnerConversationResp) ProtoMessage() {}

func (x *GetOwnerConversationResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOwnerConversationResp.ProtoReflect.Descriptor instead.
func (*GetOwnerConversationResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{43}
}

func (x *GetOwnerConversationResp) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetOwnerConversationResp) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

type GetConversationsNeedClearMsgReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationsNeedClearMsgReq) Reset() {
	*x = GetConversationsNeedClearMsgReq{}
	mi := &file_conversation_conversation_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsNeedClearMsgReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsNeedClearMsgReq) ProtoMessage() {}

func (x *GetConversationsNeedClearMsgReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsNeedClearMsgReq.ProtoReflect.Descriptor instead.
func (*GetConversationsNeedClearMsgReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{44}
}

type GetConversationsNeedClearMsgResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Conversations []*Conversation        `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetConversationsNeedClearMsgResp) Reset() {
	*x = GetConversationsNeedClearMsgResp{}
	mi := &file_conversation_conversation_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationsNeedClearMsgResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationsNeedClearMsgResp) ProtoMessage() {}

func (x *GetConversationsNeedClearMsgResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationsNeedClearMsgResp.ProtoReflect.Descriptor instead.
func (*GetConversationsNeedClearMsgResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{45}
}

func (x *GetConversationsNeedClearMsgResp) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

type GetNotNotifyConversationIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetNotNotifyConversationIDsReq) Reset() {
	*x = GetNotNotifyConversationIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNotNotifyConversationIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotNotifyConversationIDsReq) ProtoMessage() {}

func (x *GetNotNotifyConversationIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotNotifyConversationIDsReq.ProtoReflect.Descriptor instead.
func (*GetNotNotifyConversationIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{46}
}

func (x *GetNotNotifyConversationIDsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetNotNotifyConversationIDsResp struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ConversationIDs []string               `protobuf:"bytes,1,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetNotNotifyConversationIDsResp) Reset() {
	*x = GetNotNotifyConversationIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNotNotifyConversationIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotNotifyConversationIDsResp) ProtoMessage() {}

func (x *GetNotNotifyConversationIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotNotifyConversationIDsResp.ProtoReflect.Descriptor instead.
func (*GetNotNotifyConversationIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{47}
}

func (x *GetNotNotifyConversationIDsResp) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type GetPinnedConversationIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPinnedConversationIDsReq) Reset() {
	*x = GetPinnedConversationIDsReq{}
	mi := &file_conversation_conversation_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPinnedConversationIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPinnedConversationIDsReq) ProtoMessage() {}

func (x *GetPinnedConversationIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPinnedConversationIDsReq.ProtoReflect.Descriptor instead.
func (*GetPinnedConversationIDsReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{48}
}

func (x *GetPinnedConversationIDsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetPinnedConversationIDsResp struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ConversationIDs []string               `protobuf:"bytes,1,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetPinnedConversationIDsResp) Reset() {
	*x = GetPinnedConversationIDsResp{}
	mi := &file_conversation_conversation_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPinnedConversationIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPinnedConversationIDsResp) ProtoMessage() {}

func (x *GetPinnedConversationIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPinnedConversationIDsResp.ProtoReflect.Descriptor instead.
func (*GetPinnedConversationIDsResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{49}
}

func (x *GetPinnedConversationIDsResp) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type ClearUserConversationMsgReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Timestamp     int64                  `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp"`
	Limit         int32                  `protobuf:"varint,2,opt,name=limit,proto3" json:"limit"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClearUserConversationMsgReq) Reset() {
	*x = ClearUserConversationMsgReq{}
	mi := &file_conversation_conversation_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClearUserConversationMsgReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClearUserConversationMsgReq) ProtoMessage() {}

func (x *ClearUserConversationMsgReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClearUserConversationMsgReq.ProtoReflect.Descriptor instead.
func (*ClearUserConversationMsgReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{50}
}

func (x *ClearUserConversationMsgReq) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *ClearUserConversationMsgReq) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

type ClearUserConversationMsgResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Count         int32                  `protobuf:"varint,1,opt,name=count,proto3" json:"count"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClearUserConversationMsgResp) Reset() {
	*x = ClearUserConversationMsgResp{}
	mi := &file_conversation_conversation_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClearUserConversationMsgResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClearUserConversationMsgResp) ProtoMessage() {}

func (x *ClearUserConversationMsgResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClearUserConversationMsgResp.ProtoReflect.Descriptor instead.
func (*ClearUserConversationMsgResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{51}
}

func (x *ClearUserConversationMsgResp) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

type UpdateConversationsByUserReq struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	UserID        string                  `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Ex            *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=ex,proto3" json:"ex"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateConversationsByUserReq) Reset() {
	*x = UpdateConversationsByUserReq{}
	mi := &file_conversation_conversation_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConversationsByUserReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationsByUserReq) ProtoMessage() {}

func (x *UpdateConversationsByUserReq) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationsByUserReq.ProtoReflect.Descriptor instead.
func (*UpdateConversationsByUserReq) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{52}
}

func (x *UpdateConversationsByUserReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UpdateConversationsByUserReq) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

type UpdateConversationsByUserResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateConversationsByUserResp) Reset() {
	*x = UpdateConversationsByUserResp{}
	mi := &file_conversation_conversation_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConversationsByUserResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationsByUserResp) ProtoMessage() {}

func (x *UpdateConversationsByUserResp) ProtoReflect() protoreflect.Message {
	mi := &file_conversation_conversation_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationsByUserResp.ProtoReflect.Descriptor instead.
func (*UpdateConversationsByUserResp) Descriptor() ([]byte, []int) {
	return file_conversation_conversation_proto_rawDescGZIP(), []int{53}
}

var File_conversation_conversation_proto protoreflect.FileDescriptor

var file_conversation_conversation_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x11, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2f, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x70, 0x62, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x70, 0x62,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x04, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70,
	0x74, 0x12, 0x2a, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x24, 0x0a, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x41, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x75, 0x72, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x62,
	0x75, 0x72, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6d,
	0x69, 0x6e, 0x53, 0x65, 0x71, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x69, 0x6e,
	0x53, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x12, 0x28, 0x0a, 0x0f, 0x6d,
	0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x6d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d,
	0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x73, 0x67, 0x44,
	0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x69,
	0x73, 0x4d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x4d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x22, 0xb1, 0x06, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x2a, 0x0a,
	0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x3b, 0x0a, 0x0a, 0x72,
	0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x65,
	0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x69, 0x73, 0x50, 0x69,
	0x6e, 0x6e, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64,
	0x12, 0x40, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x40, 0x0a, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x61, 0x74, 0x12, 0x2c, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02,
	0x65, 0x78, 0x12, 0x3f, 0x0a, 0x0c, 0x62, 0x75, 0x72, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x62, 0x75, 0x72, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x12, 0x33, 0x0a, 0x06, 0x6d, 0x61, 0x78, 0x53,
	0x65, 0x71, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x12, 0x3d, 0x0a,
	0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x45, 0x0a, 0x0f,
	0x6d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x6d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0d, 0x69, 0x73, 0x4d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x69, 0x73, 0x4d, 0x73, 0x67, 0x44, 0x65, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x22, 0x5b, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x45, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x22, 0x5e, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12,
	0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x5c, 0x0a, 0x13, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x53,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc4, 0x01, 0x0a, 0x1d,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x2c, 0x0a,
	0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x74,
	0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x53, 0x0a,
	0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65,
	0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65,
	0x6d, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12,
	0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x49, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x49, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x36, 0x0a,
	0x07, 0x6d, 0x73, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x73, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6d, 0x73,
	0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x93, 0x04, 0x0a, 0x07, 0x4d, 0x73, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x73, 0x67, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x73,
	0x67, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x4d, 0x73, 0x67, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49,
	0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x76, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x63, 0x76, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55,
	0x52, 0x4c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52,
	0x4c, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x1c, 0x0a,
	0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x4c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x63, 0x76, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x11, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x63,
	0x76, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67, 0x46, 0x72, 0x6f, 0x6d,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x46, 0x72, 0x6f, 0x6d, 0x12,
	0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x65,
	0x78, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0x61, 0x0a, 0x13, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x5f,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x47, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x3a, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x62, 0x0a, 0x17, 0x47,
	0x65, 0x74, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x47, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x39, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4e, 0x6f, 0x74,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71,
	0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x3a, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x79, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x63, 0x76, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x63,
	0x76, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x12, 0x2a, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x23, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43,
	0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x22, 0x55, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x22, 0x0a, 0x20, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x7c, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x52, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x22, 0x1b, 0x0a,
	0x19, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x52, 0x65, 0x73, 0x70, 0x22, 0x7c, 0x0a, 0x18, 0x53, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e,
	0x53, 0x65, 0x71, 0x52, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x20,
	0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x12, 0x16, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x22, 0x1b, 0x0a, 0x19, 0x53, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x53, 0x65,
	0x71, 0x52, 0x65, 0x73, 0x70, 0x22, 0x2f, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16,
	0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x42, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x79, 0x0a, 0x13, 0x53, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x48, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x16, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22, 0x41, 0x0a,
	0x1d, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x71, 0x12, 0x20,
	0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x22, 0x34, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x22, 0x4f, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x52, 0x65, 0x71, 0x12, 0x28, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x6f, 0x0a, 0x24, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x47, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x68, 0x0a, 0x24, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71,
	0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x73, 0x22, 0x41, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x73, 0x22, 0x54, 0x0a, 0x2a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73,
	0x52, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x47, 0x0a, 0x2b, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f,
	0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x73, 0x22, 0xc6, 0x06, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x26,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73,
	0x12, 0x3b, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x12, 0x36, 0x0a,
	0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x69, 0x73, 0x50,
	0x69, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x74, 0x12, 0x2c, 0x0a, 0x02, 0x65, 0x78, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x02, 0x65, 0x78, 0x12, 0x3f, 0x0a, 0x0c, 0x62, 0x75, 0x72, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x62, 0x75, 0x72, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x53,
	0x65, 0x71, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x12, 0x33, 0x0a,
	0x06, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x53,
	0x65, 0x71, 0x12, 0x3d, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x45, 0x0a, 0x0f, 0x6d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0d, 0x69, 0x73, 0x4d, 0x73,
	0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x69, 0x73, 0x4d,
	0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x51, 0x0a, 0x15, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x4d, 0x73, 0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x73,
	0x67, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x18, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x22, 0x50, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x46, 0x75,
	0x6c, 0x6c, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x64, 0x48,
	0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x69, 0x64, 0x48, 0x61, 0x73,
	0x68, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x99, 0x01, 0x0a, 0x1f, 0x47, 0x65,
	0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x12, 0x28, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x6f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c,
	0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xfa, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x75, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x04, 0x66, 0x75, 0x6c, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x39, 0x0a,
	0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x22, 0x72, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x16,
	0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x47, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x21, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x4d,
	0x73, 0x67, 0x52, 0x65, 0x71, 0x22, 0x6b, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x43, 0x6c, 0x65,
	0x61, 0x72, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x47, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x38, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x4b, 0x0a, 0x1f,
	0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x35, 0x0a, 0x1b, 0x47, 0x65, 0x74,
	0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x22, 0x48, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x51, 0x0a, 0x1b, 0x43, 0x6c,
	0x65, 0x61, 0x72, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x71, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x34, 0x0a,
	0x1c, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x64, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x55, 0x73, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x2c, 0x0a, 0x02, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x65, 0x78, 0x22, 0x1f, 0x0a, 0x1d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x79, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x32, 0xae, 0x19, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x82, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x71, 0x1a, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x70, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x2c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x67, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x64, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x28, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x85, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x33, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4e, 0x6f, 0x74, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x79, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x8e, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x8b, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x34, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x68, 0x61, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x76,
	0x0a, 0x15, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x12, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x78,
	0x53, 0x65, 0x71, 0x52, 0x65, 0x71, 0x1a, 0x2e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x78, 0x53,
	0x65, 0x71, 0x52, 0x65, 0x73, 0x70, 0x12, 0x76, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x12,
	0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x52, 0x65, 0x71, 0x1a, 0x2e,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x52, 0x65, 0x73, 0x70, 0x12, 0x6d,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x73, 0x12, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71,
	0x1a, 0x2b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x67, 0x0a,
	0x10, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x85, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x73, 0x48, 0x61, 0x73, 0x68, 0x12, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x73, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x71, 0x1a, 0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x97,
	0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x12, 0x38, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x52, 0x65, 0x71, 0x1a, 0x39, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x52, 0x65, 0x73, 0x70, 0x12, 0x9a, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x66, 0x66, 0x6c,
	0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x39,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x3a, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0xac, 0x01, 0x0a, 0x27, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x65,
	0x69, 0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x73, 0x12, 0x3f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52,
	0x65, 0x71, 0x1a, 0x40, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x6d, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x2b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x88, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4f,
	0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x73, 0x12, 0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c,
	0x6c, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x34, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x85,
	0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x1a, 0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x73, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x2d, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x8b, 0x01, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x4e, 0x65, 0x65, 0x64, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x34, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x4d, 0x73, 0x67, 0x52,
	0x65, 0x71, 0x1a, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x43, 0x6c, 0x65,
	0x61, 0x72, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x88, 0x01, 0x0a, 0x1b, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x12, 0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x34,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x7f, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73,
	0x12, 0x30, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x52,
	0x65, 0x71, 0x1a, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x7f, 0x0a, 0x18, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73,
	0x67, 0x12, 0x30, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67,
	0x52, 0x65, 0x71, 0x1a, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x73, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x82, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x79,
	0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x79, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x42, 0x2c, 0x5a, 0x2a, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x73, 0x64, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_conversation_conversation_proto_rawDescOnce sync.Once
	file_conversation_conversation_proto_rawDescData = file_conversation_conversation_proto_rawDesc
)

func file_conversation_conversation_proto_rawDescGZIP() []byte {
	file_conversation_conversation_proto_rawDescOnce.Do(func() {
		file_conversation_conversation_proto_rawDescData = protoimpl.X.CompressGZIP(file_conversation_conversation_proto_rawDescData)
	})
	return file_conversation_conversation_proto_rawDescData
}

var file_conversation_conversation_proto_msgTypes = make([]protoimpl.MessageInfo, 54)
var file_conversation_conversation_proto_goTypes = []any{
	(*Conversation)(nil),                                // 0: openim.conversation.Conversation
	(*ConversationReq)(nil),                             // 1: openim.conversation.ConversationReq
	(*SetConversationReq)(nil),                          // 2: openim.conversation.SetConversationReq
	(*SetConversationResp)(nil),                         // 3: openim.conversation.SetConversationResp
	(*GetConversationReq)(nil),                          // 4: openim.conversation.GetConversationReq
	(*GetConversationResp)(nil),                         // 5: openim.conversation.GetConversationResp
	(*GetSortedConversationListReq)(nil),                // 6: openim.conversation.GetSortedConversationListReq
	(*GetSortedConversationListResp)(nil),               // 7: openim.conversation.GetSortedConversationListResp
	(*ConversationElem)(nil),                            // 8: openim.conversation.ConversationElem
	(*MsgInfo)(nil),                                     // 9: openim.conversation.MsgInfo
	(*GetConversationsReq)(nil),                         // 10: openim.conversation.GetConversationsReq
	(*GetConversationsResp)(nil),                        // 11: openim.conversation.GetConversationsResp
	(*GetAllConversationsReq)(nil),                      // 12: openim.conversation.GetAllConversationsReq
	(*GetAllConversationsResp)(nil),                     // 13: openim.conversation.GetAllConversationsResp
	(*GetRecvMsgNotNotifyUserIDsReq)(nil),               // 14: openim.conversation.GetRecvMsgNotNotifyUserIDsReq
	(*GetRecvMsgNotNotifyUserIDsResp)(nil),              // 15: openim.conversation.GetRecvMsgNotNotifyUserIDsResp
	(*CreateSingleChatConversationsReq)(nil),            // 16: openim.conversation.CreateSingleChatConversationsReq
	(*CreateSingleChatConversationsResp)(nil),           // 17: openim.conversation.CreateSingleChatConversationsResp
	(*CreateGroupChatConversationsReq)(nil),             // 18: openim.conversation.CreateGroupChatConversationsReq
	(*CreateGroupChatConversationsResp)(nil),            // 19: openim.conversation.CreateGroupChatConversationsResp
	(*SetConversationMaxSeqReq)(nil),                    // 20: openim.conversation.SetConversationMaxSeqReq
	(*SetConversationMaxSeqResp)(nil),                   // 21: openim.conversation.SetConversationMaxSeqResp
	(*SetConversationMinSeqReq)(nil),                    // 22: openim.conversation.SetConversationMinSeqReq
	(*SetConversationMinSeqResp)(nil),                   // 23: openim.conversation.SetConversationMinSeqResp
	(*GetConversationIDsReq)(nil),                       // 24: openim.conversation.GetConversationIDsReq
	(*GetConversationIDsResp)(nil),                      // 25: openim.conversation.GetConversationIDsResp
	(*SetConversationsReq)(nil),                         // 26: openim.conversation.SetConversationsReq
	(*SetConversationsResp)(nil),                        // 27: openim.conversation.SetConversationsResp
	(*GetUserConversationIDsHashReq)(nil),               // 28: openim.conversation.GetUserConversationIDsHashReq
	(*GetUserConversationIDsHashResp)(nil),              // 29: openim.conversation.GetUserConversationIDsHashResp
	(*GetConversationsByConversationIDReq)(nil),         // 30: openim.conversation.GetConversationsByConversationIDReq
	(*GetConversationsByConversationIDResp)(nil),        // 31: openim.conversation.GetConversationsByConversationIDResp
	(*GetConversationOfflinePushUserIDsReq)(nil),        // 32: openim.conversation.GetConversationOfflinePushUserIDsReq
	(*GetConversationOfflinePushUserIDsResp)(nil),       // 33: openim.conversation.GetConversationOfflinePushUserIDsResp
	(*GetConversationNotReceiveMessageUserIDsReq)(nil),  // 34: openim.conversation.GetConversationNotReceiveMessageUserIDsReq
	(*GetConversationNotReceiveMessageUserIDsResp)(nil), // 35: openim.conversation.GetConversationNotReceiveMessageUserIDsResp
	(*UpdateConversationReq)(nil),                       // 36: openim.conversation.UpdateConversationReq
	(*UpdateConversationResp)(nil),                      // 37: openim.conversation.UpdateConversationResp
	(*GetFullOwnerConversationIDsReq)(nil),              // 38: openim.conversation.GetFullOwnerConversationIDsReq
	(*GetFullOwnerConversationIDsResp)(nil),             // 39: openim.conversation.GetFullOwnerConversationIDsResp
	(*GetIncrementalConversationReq)(nil),               // 40: openim.conversation.GetIncrementalConversationReq
	(*GetIncrementalConversationResp)(nil),              // 41: openim.conversation.GetIncrementalConversationResp
	(*GetOwnerConversationReq)(nil),                     // 42: openim.conversation.GetOwnerConversationReq
	(*GetOwnerConversationResp)(nil),                    // 43: openim.conversation.GetOwnerConversationResp
	(*GetConversationsNeedClearMsgReq)(nil),             // 44: openim.conversation.GetConversationsNeedClearMsgReq
	(*GetConversationsNeedClearMsgResp)(nil),            // 45: openim.conversation.GetConversationsNeedClearMsgResp
	(*GetNotNotifyConversationIDsReq)(nil),              // 46: openim.conversation.GetNotNotifyConversationIDsReq
	(*GetNotNotifyConversationIDsResp)(nil),             // 47: openim.conversation.GetNotNotifyConversationIDsResp
	(*GetPinnedConversationIDsReq)(nil),                 // 48: openim.conversation.GetPinnedConversationIDsReq
	(*GetPinnedConversationIDsResp)(nil),                // 49: openim.conversation.GetPinnedConversationIDsResp
	(*ClearUserConversationMsgReq)(nil),                 // 50: openim.conversation.ClearUserConversationMsgReq
	(*ClearUserConversationMsgResp)(nil),                // 51: openim.conversation.ClearUserConversationMsgResp
	(*UpdateConversationsByUserReq)(nil),                // 52: openim.conversation.UpdateConversationsByUserReq
	(*UpdateConversationsByUserResp)(nil),               // 53: openim.conversation.UpdateConversationsByUserResp
	(*wrapperspb.Int32Value)(nil),                       // 54: openim.protobuf.Int32Value
	(*wrapperspb.BoolValue)(nil),                        // 55: openim.protobuf.BoolValue
	(*wrapperspb.StringValue)(nil),                      // 56: openim.protobuf.StringValue
	(*wrapperspb.Int64Value)(nil),                       // 57: openim.protobuf.Int64Value
	(*sdkws.RequestPagination)(nil),                     // 58: openim.sdkws.RequestPagination
}
var file_conversation_conversation_proto_depIdxs = []int32{
	54, // 0: openim.conversation.ConversationReq.recvMsgOpt:type_name -> openim.protobuf.Int32Value
	55, // 1: openim.conversation.ConversationReq.isPinned:type_name -> openim.protobuf.BoolValue
	56, // 2: openim.conversation.ConversationReq.attachedInfo:type_name -> openim.protobuf.StringValue
	55, // 3: openim.conversation.ConversationReq.isPrivateChat:type_name -> openim.protobuf.BoolValue
	56, // 4: openim.conversation.ConversationReq.ex:type_name -> openim.protobuf.StringValue
	54, // 5: openim.conversation.ConversationReq.burnDuration:type_name -> openim.protobuf.Int32Value
	57, // 6: openim.conversation.ConversationReq.minSeq:type_name -> openim.protobuf.Int64Value
	57, // 7: openim.conversation.ConversationReq.maxSeq:type_name -> openim.protobuf.Int64Value
	54, // 8: openim.conversation.ConversationReq.groupAtType:type_name -> openim.protobuf.Int32Value
	57, // 9: openim.conversation.ConversationReq.msgDestructTime:type_name -> openim.protobuf.Int64Value
	55, // 10: openim.conversation.ConversationReq.isMsgDestruct:type_name -> openim.protobuf.BoolValue
	0,  // 11: openim.conversation.SetConversationReq.conversation:type_name -> openim.conversation.Conversation
	0,  // 12: openim.conversation.GetConversationResp.conversation:type_name -> openim.conversation.Conversation
	58, // 13: openim.conversation.GetSortedConversationListReq.pagination:type_name -> openim.sdkws.RequestPagination
	8,  // 14: openim.conversation.GetSortedConversationListResp.conversationElems:type_name -> openim.conversation.ConversationElem
	9,  // 15: openim.conversation.ConversationElem.msgInfo:type_name -> openim.conversation.MsgInfo
	0,  // 16: openim.conversation.GetConversationsResp.conversations:type_name -> openim.conversation.Conversation
	0,  // 17: openim.conversation.GetAllConversationsResp.conversations:type_name -> openim.conversation.Conversation
	1,  // 18: openim.conversation.SetConversationsReq.conversation:type_name -> openim.conversation.ConversationReq
	0,  // 19: openim.conversation.GetConversationsByConversationIDResp.conversations:type_name -> openim.conversation.Conversation
	54, // 20: openim.conversation.UpdateConversationReq.recvMsgOpt:type_name -> openim.protobuf.Int32Value
	55, // 21: openim.conversation.UpdateConversationReq.isPinned:type_name -> openim.protobuf.BoolValue
	56, // 22: openim.conversation.UpdateConversationReq.attachedInfo:type_name -> openim.protobuf.StringValue
	55, // 23: openim.conversation.UpdateConversationReq.isPrivateChat:type_name -> openim.protobuf.BoolValue
	56, // 24: openim.conversation.UpdateConversationReq.ex:type_name -> openim.protobuf.StringValue
	54, // 25: openim.conversation.UpdateConversationReq.burnDuration:type_name -> openim.protobuf.Int32Value
	57, // 26: openim.conversation.UpdateConversationReq.minSeq:type_name -> openim.protobuf.Int64Value
	57, // 27: openim.conversation.UpdateConversationReq.maxSeq:type_name -> openim.protobuf.Int64Value
	54, // 28: openim.conversation.UpdateConversationReq.groupAtType:type_name -> openim.protobuf.Int32Value
	57, // 29: openim.conversation.UpdateConversationReq.msgDestructTime:type_name -> openim.protobuf.Int64Value
	55, // 30: openim.conversation.UpdateConversationReq.isMsgDestruct:type_name -> openim.protobuf.BoolValue
	57, // 31: openim.conversation.UpdateConversationReq.latestMsgDestructTime:type_name -> openim.protobuf.Int64Value
	0,  // 32: openim.conversation.GetIncrementalConversationResp.insert:type_name -> openim.conversation.Conversation
	0,  // 33: openim.conversation.GetIncrementalConversationResp.update:type_name -> openim.conversation.Conversation
	58, // 34: openim.conversation.GetOwnerConversationReq.pagination:type_name -> openim.sdkws.RequestPagination
	0,  // 35: openim.conversation.GetOwnerConversationResp.conversations:type_name -> openim.conversation.Conversation
	0,  // 36: openim.conversation.GetConversationsNeedClearMsgResp.conversations:type_name -> openim.conversation.Conversation
	56, // 37: openim.conversation.UpdateConversationsByUserReq.ex:type_name -> openim.protobuf.StringValue
	4,  // 38: openim.conversation.conversation.GetConversation:input_type -> openim.conversation.GetConversationReq
	6,  // 39: openim.conversation.conversation.GetSortedConversationList:input_type -> openim.conversation.GetSortedConversationListReq
	12, // 40: openim.conversation.conversation.GetAllConversations:input_type -> openim.conversation.GetAllConversationsReq
	10, // 41: openim.conversation.conversation.GetConversations:input_type -> openim.conversation.GetConversationsReq
	2,  // 42: openim.conversation.conversation.SetConversation:input_type -> openim.conversation.SetConversationReq
	14, // 43: openim.conversation.conversation.GetRecvMsgNotNotifyUserIDs:input_type -> openim.conversation.GetRecvMsgNotNotifyUserIDsReq
	16, // 44: openim.conversation.conversation.CreateSingleChatConversations:input_type -> openim.conversation.CreateSingleChatConversationsReq
	18, // 45: openim.conversation.conversation.CreateGroupChatConversations:input_type -> openim.conversation.CreateGroupChatConversationsReq
	20, // 46: openim.conversation.conversation.SetConversationMaxSeq:input_type -> openim.conversation.SetConversationMaxSeqReq
	22, // 47: openim.conversation.conversation.SetConversationMinSeq:input_type -> openim.conversation.SetConversationMinSeqReq
	24, // 48: openim.conversation.conversation.GetConversationIDs:input_type -> openim.conversation.GetConversationIDsReq
	26, // 49: openim.conversation.conversation.SetConversations:input_type -> openim.conversation.SetConversationsReq
	28, // 50: openim.conversation.conversation.GetUserConversationIDsHash:input_type -> openim.conversation.GetUserConversationIDsHashReq
	30, // 51: openim.conversation.conversation.GetConversationsByConversationID:input_type -> openim.conversation.GetConversationsByConversationIDReq
	32, // 52: openim.conversation.conversation.GetConversationOfflinePushUserIDs:input_type -> openim.conversation.GetConversationOfflinePushUserIDsReq
	34, // 53: openim.conversation.conversation.GetConversationNotReceiveMessageUserIDs:input_type -> openim.conversation.GetConversationNotReceiveMessageUserIDsReq
	36, // 54: openim.conversation.conversation.UpdateConversation:input_type -> openim.conversation.UpdateConversationReq
	38, // 55: openim.conversation.conversation.GetFullOwnerConversationIDs:input_type -> openim.conversation.GetFullOwnerConversationIDsReq
	40, // 56: openim.conversation.conversation.GetIncrementalConversation:input_type -> openim.conversation.GetIncrementalConversationReq
	42, // 57: openim.conversation.conversation.GetOwnerConversation:input_type -> openim.conversation.GetOwnerConversationReq
	44, // 58: openim.conversation.conversation.GetConversationsNeedClearMsg:input_type -> openim.conversation.GetConversationsNeedClearMsgReq
	46, // 59: openim.conversation.conversation.GetNotNotifyConversationIDs:input_type -> openim.conversation.GetNotNotifyConversationIDsReq
	48, // 60: openim.conversation.conversation.GetPinnedConversationIDs:input_type -> openim.conversation.GetPinnedConversationIDsReq
	50, // 61: openim.conversation.conversation.ClearUserConversationMsg:input_type -> openim.conversation.ClearUserConversationMsgReq
	52, // 62: openim.conversation.conversation.UpdateConversationsByUser:input_type -> openim.conversation.UpdateConversationsByUserReq
	5,  // 63: openim.conversation.conversation.GetConversation:output_type -> openim.conversation.GetConversationResp
	7,  // 64: openim.conversation.conversation.GetSortedConversationList:output_type -> openim.conversation.GetSortedConversationListResp
	13, // 65: openim.conversation.conversation.GetAllConversations:output_type -> openim.conversation.GetAllConversationsResp
	11, // 66: openim.conversation.conversation.GetConversations:output_type -> openim.conversation.GetConversationsResp
	3,  // 67: openim.conversation.conversation.SetConversation:output_type -> openim.conversation.SetConversationResp
	15, // 68: openim.conversation.conversation.GetRecvMsgNotNotifyUserIDs:output_type -> openim.conversation.GetRecvMsgNotNotifyUserIDsResp
	17, // 69: openim.conversation.conversation.CreateSingleChatConversations:output_type -> openim.conversation.CreateSingleChatConversationsResp
	19, // 70: openim.conversation.conversation.CreateGroupChatConversations:output_type -> openim.conversation.CreateGroupChatConversationsResp
	21, // 71: openim.conversation.conversation.SetConversationMaxSeq:output_type -> openim.conversation.SetConversationMaxSeqResp
	23, // 72: openim.conversation.conversation.SetConversationMinSeq:output_type -> openim.conversation.SetConversationMinSeqResp
	25, // 73: openim.conversation.conversation.GetConversationIDs:output_type -> openim.conversation.GetConversationIDsResp
	27, // 74: openim.conversation.conversation.SetConversations:output_type -> openim.conversation.SetConversationsResp
	29, // 75: openim.conversation.conversation.GetUserConversationIDsHash:output_type -> openim.conversation.GetUserConversationIDsHashResp
	31, // 76: openim.conversation.conversation.GetConversationsByConversationID:output_type -> openim.conversation.GetConversationsByConversationIDResp
	33, // 77: openim.conversation.conversation.GetConversationOfflinePushUserIDs:output_type -> openim.conversation.GetConversationOfflinePushUserIDsResp
	35, // 78: openim.conversation.conversation.GetConversationNotReceiveMessageUserIDs:output_type -> openim.conversation.GetConversationNotReceiveMessageUserIDsResp
	37, // 79: openim.conversation.conversation.UpdateConversation:output_type -> openim.conversation.UpdateConversationResp
	39, // 80: openim.conversation.conversation.GetFullOwnerConversationIDs:output_type -> openim.conversation.GetFullOwnerConversationIDsResp
	41, // 81: openim.conversation.conversation.GetIncrementalConversation:output_type -> openim.conversation.GetIncrementalConversationResp
	43, // 82: openim.conversation.conversation.GetOwnerConversation:output_type -> openim.conversation.GetOwnerConversationResp
	45, // 83: openim.conversation.conversation.GetConversationsNeedClearMsg:output_type -> openim.conversation.GetConversationsNeedClearMsgResp
	47, // 84: openim.conversation.conversation.GetNotNotifyConversationIDs:output_type -> openim.conversation.GetNotNotifyConversationIDsResp
	49, // 85: openim.conversation.conversation.GetPinnedConversationIDs:output_type -> openim.conversation.GetPinnedConversationIDsResp
	51, // 86: openim.conversation.conversation.ClearUserConversationMsg:output_type -> openim.conversation.ClearUserConversationMsgResp
	53, // 87: openim.conversation.conversation.UpdateConversationsByUser:output_type -> openim.conversation.UpdateConversationsByUserResp
	63, // [63:88] is the sub-list for method output_type
	38, // [38:63] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_conversation_conversation_proto_init() }
func file_conversation_conversation_proto_init() {
	if File_conversation_conversation_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_conversation_conversation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   54,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_conversation_conversation_proto_goTypes,
		DependencyIndexes: file_conversation_conversation_proto_depIdxs,
		MessageInfos:      file_conversation_conversation_proto_msgTypes,
	}.Build()
	File_conversation_conversation_proto = out.File
	file_conversation_conversation_proto_rawDesc = nil
	file_conversation_conversation_proto_goTypes = nil
	file_conversation_conversation_proto_depIdxs = nil
}
