// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.26.0
// source: msg/msg.proto

package msg

import (
	context "context"
	sdkws "github.com/openimsdk/protocol/sdkws"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Msg_GetMaxSeq_FullMethodName                        = "/openim.msg.msg/GetMaxSeq"
	Msg_GetMaxSeqs_FullMethodName                       = "/openim.msg.msg/GetMaxSeqs"
	Msg_GetHasReadSeqs_FullMethodName                   = "/openim.msg.msg/GetHasReadSeqs"
	Msg_GetMsgByConversationIDs_FullMethodName          = "/openim.msg.msg/GetMsgByConversationIDs"
	Msg_GetConversationMaxSeq_FullMethodName            = "/openim.msg.msg/GetConversationMaxSeq"
	Msg_PullMessageBySeqs_FullMethodName                = "/openim.msg.msg/PullMessageBySeqs"
	Msg_GetSeqMessage_FullMethodName                    = "/openim.msg.msg/GetSeqMessage"
	Msg_SearchMessage_FullMethodName                    = "/openim.msg.msg/SearchMessage"
	Msg_SendMsg_FullMethodName                          = "/openim.msg.msg/SendMsg"
	Msg_SetUserConversationsMinSeq_FullMethodName       = "/openim.msg.msg/SetUserConversationsMinSeq"
	Msg_ClearConversationsMsg_FullMethodName            = "/openim.msg.msg/ClearConversationsMsg"
	Msg_UserClearAllMsg_FullMethodName                  = "/openim.msg.msg/UserClearAllMsg"
	Msg_DeleteMsgs_FullMethodName                       = "/openim.msg.msg/DeleteMsgs"
	Msg_DeleteMsgPhysicalBySeq_FullMethodName           = "/openim.msg.msg/DeleteMsgPhysicalBySeq"
	Msg_DeleteMsgPhysical_FullMethodName                = "/openim.msg.msg/DeleteMsgPhysical"
	Msg_SetSendMsgStatus_FullMethodName                 = "/openim.msg.msg/SetSendMsgStatus"
	Msg_GetSendMsgStatus_FullMethodName                 = "/openim.msg.msg/GetSendMsgStatus"
	Msg_RevokeMsg_FullMethodName                        = "/openim.msg.msg/RevokeMsg"
	Msg_MarkMsgsAsRead_FullMethodName                   = "/openim.msg.msg/MarkMsgsAsRead"
	Msg_MarkConversationAsRead_FullMethodName           = "/openim.msg.msg/MarkConversationAsRead"
	Msg_SetConversationHasReadSeq_FullMethodName        = "/openim.msg.msg/SetConversationHasReadSeq"
	Msg_GetConversationsHasReadAndMaxSeq_FullMethodName = "/openim.msg.msg/GetConversationsHasReadAndMaxSeq"
	Msg_GetActiveUser_FullMethodName                    = "/openim.msg.msg/GetActiveUser"
	Msg_GetActiveGroup_FullMethodName                   = "/openim.msg.msg/GetActiveGroup"
	Msg_GetServerTime_FullMethodName                    = "/openim.msg.msg/GetServerTime"
	Msg_ClearMsg_FullMethodName                         = "/openim.msg.msg/ClearMsg"
	Msg_DestructMsgs_FullMethodName                     = "/openim.msg.msg/DestructMsgs"
	Msg_GetActiveConversation_FullMethodName            = "/openim.msg.msg/GetActiveConversation"
	Msg_SetUserConversationMaxSeq_FullMethodName        = "/openim.msg.msg/SetUserConversationMaxSeq"
	Msg_SetUserConversationMinSeq_FullMethodName        = "/openim.msg.msg/SetUserConversationMinSeq"
	Msg_GetLastMessageSeqByTime_FullMethodName          = "/openim.msg.msg/GetLastMessageSeqByTime"
	Msg_GetLastMessage_FullMethodName                   = "/openim.msg.msg/GetLastMessage"
)

// MsgClient is the client API for Msg service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MsgClient interface {
	// 获取最小最大seq（包括用户的，以及指定群组的）
	GetMaxSeq(ctx context.Context, in *sdkws.GetMaxSeqReq, opts ...grpc.CallOption) (*sdkws.GetMaxSeqResp, error)
	// 获取会话列表的最大seq
	GetMaxSeqs(ctx context.Context, in *GetMaxSeqsReq, opts ...grpc.CallOption) (*SeqsInfoResp, error)
	// 获取会话列表已读的最大seq
	GetHasReadSeqs(ctx context.Context, in *GetHasReadSeqsReq, opts ...grpc.CallOption) (*SeqsInfoResp, error)
	// 获取最新消息
	GetMsgByConversationIDs(ctx context.Context, in *GetMsgByConversationIDsReq, opts ...grpc.CallOption) (*GetMsgByConversationIDsResp, error)
	GetConversationMaxSeq(ctx context.Context, in *GetConversationMaxSeqReq, opts ...grpc.CallOption) (*GetConversationMaxSeqResp, error)
	// 拉取历史消息（包括用户的，以及指定群组的）
	PullMessageBySeqs(ctx context.Context, in *sdkws.PullMessageBySeqsReq, opts ...grpc.CallOption) (*sdkws.PullMessageBySeqsResp, error)
	GetSeqMessage(ctx context.Context, in *GetSeqMessageReq, opts ...grpc.CallOption) (*GetSeqMessageResp, error)
	SearchMessage(ctx context.Context, in *SearchMessageReq, opts ...grpc.CallOption) (*SearchMessageResp, error)
	// 发送消息
	SendMsg(ctx context.Context, in *SendMsgReq, opts ...grpc.CallOption) (*SendMsgResp, error)
	SetUserConversationsMinSeq(ctx context.Context, in *SetUserConversationsMinSeqReq, opts ...grpc.CallOption) (*SetUserConversationsMinSeqResp, error)
	// 全量清空指定会话消息 重置min seq 比最大seq大1
	ClearConversationsMsg(ctx context.Context, in *ClearConversationsMsgReq, opts ...grpc.CallOption) (*ClearConversationsMsgResp, error)
	// 删除用户全部消息 重置min seq 比最大seq大1
	UserClearAllMsg(ctx context.Context, in *UserClearAllMsgReq, opts ...grpc.CallOption) (*UserClearAllMsgResp, error)
	// 用户标记删除部分消息by Seq
	DeleteMsgs(ctx context.Context, in *DeleteMsgsReq, opts ...grpc.CallOption) (*DeleteMsgsResp, error)
	// seq物理删除消息
	DeleteMsgPhysicalBySeq(ctx context.Context, in *DeleteMsgPhysicalBySeqReq, opts ...grpc.CallOption) (*DeleteMsgPhysicalBySeqResp, error)
	// 物理删除消息by 时间
	DeleteMsgPhysical(ctx context.Context, in *DeleteMsgPhysicalReq, opts ...grpc.CallOption) (*DeleteMsgPhysicalResp, error)
	// 设置消息是否发送成功-针对api发送的消息
	SetSendMsgStatus(ctx context.Context, in *SetSendMsgStatusReq, opts ...grpc.CallOption) (*SetSendMsgStatusResp, error)
	// 获取消息发送状态
	GetSendMsgStatus(ctx context.Context, in *GetSendMsgStatusReq, opts ...grpc.CallOption) (*GetSendMsgStatusResp, error)
	RevokeMsg(ctx context.Context, in *RevokeMsgReq, opts ...grpc.CallOption) (*RevokeMsgResp, error)
	// mark as read
	MarkMsgsAsRead(ctx context.Context, in *MarkMsgsAsReadReq, opts ...grpc.CallOption) (*MarkMsgsAsReadResp, error)
	MarkConversationAsRead(ctx context.Context, in *MarkConversationAsReadReq, opts ...grpc.CallOption) (*MarkConversationAsReadResp, error)
	SetConversationHasReadSeq(ctx context.Context, in *SetConversationHasReadSeqReq, opts ...grpc.CallOption) (*SetConversationHasReadSeqResp, error)
	GetConversationsHasReadAndMaxSeq(ctx context.Context, in *GetConversationsHasReadAndMaxSeqReq, opts ...grpc.CallOption) (*GetConversationsHasReadAndMaxSeqResp, error)
	GetActiveUser(ctx context.Context, in *GetActiveUserReq, opts ...grpc.CallOption) (*GetActiveUserResp, error)
	GetActiveGroup(ctx context.Context, in *GetActiveGroupReq, opts ...grpc.CallOption) (*GetActiveGroupResp, error)
	GetServerTime(ctx context.Context, in *GetServerTimeReq, opts ...grpc.CallOption) (*GetServerTimeResp, error)
	ClearMsg(ctx context.Context, in *ClearMsgReq, opts ...grpc.CallOption) (*ClearMsgResp, error)
	DestructMsgs(ctx context.Context, in *DestructMsgsReq, opts ...grpc.CallOption) (*DestructMsgsResp, error)
	GetActiveConversation(ctx context.Context, in *GetActiveConversationReq, opts ...grpc.CallOption) (*GetActiveConversationResp, error)
	SetUserConversationMaxSeq(ctx context.Context, in *SetUserConversationMaxSeqReq, opts ...grpc.CallOption) (*SetUserConversationMaxSeqResp, error)
	SetUserConversationMinSeq(ctx context.Context, in *SetUserConversationMinSeqReq, opts ...grpc.CallOption) (*SetUserConversationMinSeqResp, error)
	GetLastMessageSeqByTime(ctx context.Context, in *GetLastMessageSeqByTimeReq, opts ...grpc.CallOption) (*GetLastMessageSeqByTimeResp, error)
	GetLastMessage(ctx context.Context, in *GetLastMessageReq, opts ...grpc.CallOption) (*GetLastMessageResp, error)
}

type msgClient struct {
	cc grpc.ClientConnInterface
}

func NewMsgClient(cc grpc.ClientConnInterface) MsgClient {
	return &msgClient{cc}
}

func (c *msgClient) GetMaxSeq(ctx context.Context, in *sdkws.GetMaxSeqReq, opts ...grpc.CallOption) (*sdkws.GetMaxSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(sdkws.GetMaxSeqResp)
	err := c.cc.Invoke(ctx, Msg_GetMaxSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetMaxSeqs(ctx context.Context, in *GetMaxSeqsReq, opts ...grpc.CallOption) (*SeqsInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SeqsInfoResp)
	err := c.cc.Invoke(ctx, Msg_GetMaxSeqs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetHasReadSeqs(ctx context.Context, in *GetHasReadSeqsReq, opts ...grpc.CallOption) (*SeqsInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SeqsInfoResp)
	err := c.cc.Invoke(ctx, Msg_GetHasReadSeqs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetMsgByConversationIDs(ctx context.Context, in *GetMsgByConversationIDsReq, opts ...grpc.CallOption) (*GetMsgByConversationIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetMsgByConversationIDsResp)
	err := c.cc.Invoke(ctx, Msg_GetMsgByConversationIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetConversationMaxSeq(ctx context.Context, in *GetConversationMaxSeqReq, opts ...grpc.CallOption) (*GetConversationMaxSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationMaxSeqResp)
	err := c.cc.Invoke(ctx, Msg_GetConversationMaxSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) PullMessageBySeqs(ctx context.Context, in *sdkws.PullMessageBySeqsReq, opts ...grpc.CallOption) (*sdkws.PullMessageBySeqsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(sdkws.PullMessageBySeqsResp)
	err := c.cc.Invoke(ctx, Msg_PullMessageBySeqs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetSeqMessage(ctx context.Context, in *GetSeqMessageReq, opts ...grpc.CallOption) (*GetSeqMessageResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSeqMessageResp)
	err := c.cc.Invoke(ctx, Msg_GetSeqMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SearchMessage(ctx context.Context, in *SearchMessageReq, opts ...grpc.CallOption) (*SearchMessageResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SearchMessageResp)
	err := c.cc.Invoke(ctx, Msg_SearchMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SendMsg(ctx context.Context, in *SendMsgReq, opts ...grpc.CallOption) (*SendMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SendMsgResp)
	err := c.cc.Invoke(ctx, Msg_SendMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SetUserConversationsMinSeq(ctx context.Context, in *SetUserConversationsMinSeqReq, opts ...grpc.CallOption) (*SetUserConversationsMinSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetUserConversationsMinSeqResp)
	err := c.cc.Invoke(ctx, Msg_SetUserConversationsMinSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) ClearConversationsMsg(ctx context.Context, in *ClearConversationsMsgReq, opts ...grpc.CallOption) (*ClearConversationsMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClearConversationsMsgResp)
	err := c.cc.Invoke(ctx, Msg_ClearConversationsMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) UserClearAllMsg(ctx context.Context, in *UserClearAllMsgReq, opts ...grpc.CallOption) (*UserClearAllMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserClearAllMsgResp)
	err := c.cc.Invoke(ctx, Msg_UserClearAllMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) DeleteMsgs(ctx context.Context, in *DeleteMsgsReq, opts ...grpc.CallOption) (*DeleteMsgsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteMsgsResp)
	err := c.cc.Invoke(ctx, Msg_DeleteMsgs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) DeleteMsgPhysicalBySeq(ctx context.Context, in *DeleteMsgPhysicalBySeqReq, opts ...grpc.CallOption) (*DeleteMsgPhysicalBySeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteMsgPhysicalBySeqResp)
	err := c.cc.Invoke(ctx, Msg_DeleteMsgPhysicalBySeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) DeleteMsgPhysical(ctx context.Context, in *DeleteMsgPhysicalReq, opts ...grpc.CallOption) (*DeleteMsgPhysicalResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteMsgPhysicalResp)
	err := c.cc.Invoke(ctx, Msg_DeleteMsgPhysical_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SetSendMsgStatus(ctx context.Context, in *SetSendMsgStatusReq, opts ...grpc.CallOption) (*SetSendMsgStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetSendMsgStatusResp)
	err := c.cc.Invoke(ctx, Msg_SetSendMsgStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetSendMsgStatus(ctx context.Context, in *GetSendMsgStatusReq, opts ...grpc.CallOption) (*GetSendMsgStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSendMsgStatusResp)
	err := c.cc.Invoke(ctx, Msg_GetSendMsgStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) RevokeMsg(ctx context.Context, in *RevokeMsgReq, opts ...grpc.CallOption) (*RevokeMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RevokeMsgResp)
	err := c.cc.Invoke(ctx, Msg_RevokeMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) MarkMsgsAsRead(ctx context.Context, in *MarkMsgsAsReadReq, opts ...grpc.CallOption) (*MarkMsgsAsReadResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MarkMsgsAsReadResp)
	err := c.cc.Invoke(ctx, Msg_MarkMsgsAsRead_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) MarkConversationAsRead(ctx context.Context, in *MarkConversationAsReadReq, opts ...grpc.CallOption) (*MarkConversationAsReadResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MarkConversationAsReadResp)
	err := c.cc.Invoke(ctx, Msg_MarkConversationAsRead_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SetConversationHasReadSeq(ctx context.Context, in *SetConversationHasReadSeqReq, opts ...grpc.CallOption) (*SetConversationHasReadSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetConversationHasReadSeqResp)
	err := c.cc.Invoke(ctx, Msg_SetConversationHasReadSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetConversationsHasReadAndMaxSeq(ctx context.Context, in *GetConversationsHasReadAndMaxSeqReq, opts ...grpc.CallOption) (*GetConversationsHasReadAndMaxSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationsHasReadAndMaxSeqResp)
	err := c.cc.Invoke(ctx, Msg_GetConversationsHasReadAndMaxSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetActiveUser(ctx context.Context, in *GetActiveUserReq, opts ...grpc.CallOption) (*GetActiveUserResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetActiveUserResp)
	err := c.cc.Invoke(ctx, Msg_GetActiveUser_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetActiveGroup(ctx context.Context, in *GetActiveGroupReq, opts ...grpc.CallOption) (*GetActiveGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetActiveGroupResp)
	err := c.cc.Invoke(ctx, Msg_GetActiveGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetServerTime(ctx context.Context, in *GetServerTimeReq, opts ...grpc.CallOption) (*GetServerTimeResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetServerTimeResp)
	err := c.cc.Invoke(ctx, Msg_GetServerTime_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) ClearMsg(ctx context.Context, in *ClearMsgReq, opts ...grpc.CallOption) (*ClearMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClearMsgResp)
	err := c.cc.Invoke(ctx, Msg_ClearMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) DestructMsgs(ctx context.Context, in *DestructMsgsReq, opts ...grpc.CallOption) (*DestructMsgsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DestructMsgsResp)
	err := c.cc.Invoke(ctx, Msg_DestructMsgs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetActiveConversation(ctx context.Context, in *GetActiveConversationReq, opts ...grpc.CallOption) (*GetActiveConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetActiveConversationResp)
	err := c.cc.Invoke(ctx, Msg_GetActiveConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SetUserConversationMaxSeq(ctx context.Context, in *SetUserConversationMaxSeqReq, opts ...grpc.CallOption) (*SetUserConversationMaxSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetUserConversationMaxSeqResp)
	err := c.cc.Invoke(ctx, Msg_SetUserConversationMaxSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) SetUserConversationMinSeq(ctx context.Context, in *SetUserConversationMinSeqReq, opts ...grpc.CallOption) (*SetUserConversationMinSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetUserConversationMinSeqResp)
	err := c.cc.Invoke(ctx, Msg_SetUserConversationMinSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetLastMessageSeqByTime(ctx context.Context, in *GetLastMessageSeqByTimeReq, opts ...grpc.CallOption) (*GetLastMessageSeqByTimeResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetLastMessageSeqByTimeResp)
	err := c.cc.Invoke(ctx, Msg_GetLastMessageSeqByTime_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *msgClient) GetLastMessage(ctx context.Context, in *GetLastMessageReq, opts ...grpc.CallOption) (*GetLastMessageResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetLastMessageResp)
	err := c.cc.Invoke(ctx, Msg_GetLastMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MsgServer is the server API for Msg service.
// All implementations must embed UnimplementedMsgServer
// for forward compatibility.
type MsgServer interface {
	// 获取最小最大seq（包括用户的，以及指定群组的）
	GetMaxSeq(context.Context, *sdkws.GetMaxSeqReq) (*sdkws.GetMaxSeqResp, error)
	// 获取会话列表的最大seq
	GetMaxSeqs(context.Context, *GetMaxSeqsReq) (*SeqsInfoResp, error)
	// 获取会话列表已读的最大seq
	GetHasReadSeqs(context.Context, *GetHasReadSeqsReq) (*SeqsInfoResp, error)
	// 获取最新消息
	GetMsgByConversationIDs(context.Context, *GetMsgByConversationIDsReq) (*GetMsgByConversationIDsResp, error)
	GetConversationMaxSeq(context.Context, *GetConversationMaxSeqReq) (*GetConversationMaxSeqResp, error)
	// 拉取历史消息（包括用户的，以及指定群组的）
	PullMessageBySeqs(context.Context, *sdkws.PullMessageBySeqsReq) (*sdkws.PullMessageBySeqsResp, error)
	GetSeqMessage(context.Context, *GetSeqMessageReq) (*GetSeqMessageResp, error)
	SearchMessage(context.Context, *SearchMessageReq) (*SearchMessageResp, error)
	// 发送消息
	SendMsg(context.Context, *SendMsgReq) (*SendMsgResp, error)
	SetUserConversationsMinSeq(context.Context, *SetUserConversationsMinSeqReq) (*SetUserConversationsMinSeqResp, error)
	// 全量清空指定会话消息 重置min seq 比最大seq大1
	ClearConversationsMsg(context.Context, *ClearConversationsMsgReq) (*ClearConversationsMsgResp, error)
	// 删除用户全部消息 重置min seq 比最大seq大1
	UserClearAllMsg(context.Context, *UserClearAllMsgReq) (*UserClearAllMsgResp, error)
	// 用户标记删除部分消息by Seq
	DeleteMsgs(context.Context, *DeleteMsgsReq) (*DeleteMsgsResp, error)
	// seq物理删除消息
	DeleteMsgPhysicalBySeq(context.Context, *DeleteMsgPhysicalBySeqReq) (*DeleteMsgPhysicalBySeqResp, error)
	// 物理删除消息by 时间
	DeleteMsgPhysical(context.Context, *DeleteMsgPhysicalReq) (*DeleteMsgPhysicalResp, error)
	// 设置消息是否发送成功-针对api发送的消息
	SetSendMsgStatus(context.Context, *SetSendMsgStatusReq) (*SetSendMsgStatusResp, error)
	// 获取消息发送状态
	GetSendMsgStatus(context.Context, *GetSendMsgStatusReq) (*GetSendMsgStatusResp, error)
	RevokeMsg(context.Context, *RevokeMsgReq) (*RevokeMsgResp, error)
	// mark as read
	MarkMsgsAsRead(context.Context, *MarkMsgsAsReadReq) (*MarkMsgsAsReadResp, error)
	MarkConversationAsRead(context.Context, *MarkConversationAsReadReq) (*MarkConversationAsReadResp, error)
	SetConversationHasReadSeq(context.Context, *SetConversationHasReadSeqReq) (*SetConversationHasReadSeqResp, error)
	GetConversationsHasReadAndMaxSeq(context.Context, *GetConversationsHasReadAndMaxSeqReq) (*GetConversationsHasReadAndMaxSeqResp, error)
	GetActiveUser(context.Context, *GetActiveUserReq) (*GetActiveUserResp, error)
	GetActiveGroup(context.Context, *GetActiveGroupReq) (*GetActiveGroupResp, error)
	GetServerTime(context.Context, *GetServerTimeReq) (*GetServerTimeResp, error)
	ClearMsg(context.Context, *ClearMsgReq) (*ClearMsgResp, error)
	DestructMsgs(context.Context, *DestructMsgsReq) (*DestructMsgsResp, error)
	GetActiveConversation(context.Context, *GetActiveConversationReq) (*GetActiveConversationResp, error)
	SetUserConversationMaxSeq(context.Context, *SetUserConversationMaxSeqReq) (*SetUserConversationMaxSeqResp, error)
	SetUserConversationMinSeq(context.Context, *SetUserConversationMinSeqReq) (*SetUserConversationMinSeqResp, error)
	GetLastMessageSeqByTime(context.Context, *GetLastMessageSeqByTimeReq) (*GetLastMessageSeqByTimeResp, error)
	GetLastMessage(context.Context, *GetLastMessageReq) (*GetLastMessageResp, error)
	mustEmbedUnimplementedMsgServer()
}

// UnimplementedMsgServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedMsgServer struct{}

func (UnimplementedMsgServer) GetMaxSeq(context.Context, *sdkws.GetMaxSeqReq) (*sdkws.GetMaxSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMaxSeq not implemented")
}
func (UnimplementedMsgServer) GetMaxSeqs(context.Context, *GetMaxSeqsReq) (*SeqsInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMaxSeqs not implemented")
}
func (UnimplementedMsgServer) GetHasReadSeqs(context.Context, *GetHasReadSeqsReq) (*SeqsInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHasReadSeqs not implemented")
}
func (UnimplementedMsgServer) GetMsgByConversationIDs(context.Context, *GetMsgByConversationIDsReq) (*GetMsgByConversationIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMsgByConversationIDs not implemented")
}
func (UnimplementedMsgServer) GetConversationMaxSeq(context.Context, *GetConversationMaxSeqReq) (*GetConversationMaxSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationMaxSeq not implemented")
}
func (UnimplementedMsgServer) PullMessageBySeqs(context.Context, *sdkws.PullMessageBySeqsReq) (*sdkws.PullMessageBySeqsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PullMessageBySeqs not implemented")
}
func (UnimplementedMsgServer) GetSeqMessage(context.Context, *GetSeqMessageReq) (*GetSeqMessageResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSeqMessage not implemented")
}
func (UnimplementedMsgServer) SearchMessage(context.Context, *SearchMessageReq) (*SearchMessageResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchMessage not implemented")
}
func (UnimplementedMsgServer) SendMsg(context.Context, *SendMsgReq) (*SendMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendMsg not implemented")
}
func (UnimplementedMsgServer) SetUserConversationsMinSeq(context.Context, *SetUserConversationsMinSeqReq) (*SetUserConversationsMinSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserConversationsMinSeq not implemented")
}
func (UnimplementedMsgServer) ClearConversationsMsg(context.Context, *ClearConversationsMsgReq) (*ClearConversationsMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearConversationsMsg not implemented")
}
func (UnimplementedMsgServer) UserClearAllMsg(context.Context, *UserClearAllMsgReq) (*UserClearAllMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserClearAllMsg not implemented")
}
func (UnimplementedMsgServer) DeleteMsgs(context.Context, *DeleteMsgsReq) (*DeleteMsgsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMsgs not implemented")
}
func (UnimplementedMsgServer) DeleteMsgPhysicalBySeq(context.Context, *DeleteMsgPhysicalBySeqReq) (*DeleteMsgPhysicalBySeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMsgPhysicalBySeq not implemented")
}
func (UnimplementedMsgServer) DeleteMsgPhysical(context.Context, *DeleteMsgPhysicalReq) (*DeleteMsgPhysicalResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMsgPhysical not implemented")
}
func (UnimplementedMsgServer) SetSendMsgStatus(context.Context, *SetSendMsgStatusReq) (*SetSendMsgStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSendMsgStatus not implemented")
}
func (UnimplementedMsgServer) GetSendMsgStatus(context.Context, *GetSendMsgStatusReq) (*GetSendMsgStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSendMsgStatus not implemented")
}
func (UnimplementedMsgServer) RevokeMsg(context.Context, *RevokeMsgReq) (*RevokeMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeMsg not implemented")
}
func (UnimplementedMsgServer) MarkMsgsAsRead(context.Context, *MarkMsgsAsReadReq) (*MarkMsgsAsReadResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkMsgsAsRead not implemented")
}
func (UnimplementedMsgServer) MarkConversationAsRead(context.Context, *MarkConversationAsReadReq) (*MarkConversationAsReadResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkConversationAsRead not implemented")
}
func (UnimplementedMsgServer) SetConversationHasReadSeq(context.Context, *SetConversationHasReadSeqReq) (*SetConversationHasReadSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConversationHasReadSeq not implemented")
}
func (UnimplementedMsgServer) GetConversationsHasReadAndMaxSeq(context.Context, *GetConversationsHasReadAndMaxSeqReq) (*GetConversationsHasReadAndMaxSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationsHasReadAndMaxSeq not implemented")
}
func (UnimplementedMsgServer) GetActiveUser(context.Context, *GetActiveUserReq) (*GetActiveUserResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveUser not implemented")
}
func (UnimplementedMsgServer) GetActiveGroup(context.Context, *GetActiveGroupReq) (*GetActiveGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveGroup not implemented")
}
func (UnimplementedMsgServer) GetServerTime(context.Context, *GetServerTimeReq) (*GetServerTimeResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerTime not implemented")
}
func (UnimplementedMsgServer) ClearMsg(context.Context, *ClearMsgReq) (*ClearMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearMsg not implemented")
}
func (UnimplementedMsgServer) DestructMsgs(context.Context, *DestructMsgsReq) (*DestructMsgsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestructMsgs not implemented")
}
func (UnimplementedMsgServer) GetActiveConversation(context.Context, *GetActiveConversationReq) (*GetActiveConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveConversation not implemented")
}
func (UnimplementedMsgServer) SetUserConversationMaxSeq(context.Context, *SetUserConversationMaxSeqReq) (*SetUserConversationMaxSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserConversationMaxSeq not implemented")
}
func (UnimplementedMsgServer) SetUserConversationMinSeq(context.Context, *SetUserConversationMinSeqReq) (*SetUserConversationMinSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserConversationMinSeq not implemented")
}
func (UnimplementedMsgServer) GetLastMessageSeqByTime(context.Context, *GetLastMessageSeqByTimeReq) (*GetLastMessageSeqByTimeResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLastMessageSeqByTime not implemented")
}
func (UnimplementedMsgServer) GetLastMessage(context.Context, *GetLastMessageReq) (*GetLastMessageResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLastMessage not implemented")
}
func (UnimplementedMsgServer) mustEmbedUnimplementedMsgServer() {}
func (UnimplementedMsgServer) testEmbeddedByValue()             {}

// UnsafeMsgServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MsgServer will
// result in compilation errors.
type UnsafeMsgServer interface {
	mustEmbedUnimplementedMsgServer()
}

func RegisterMsgServer(s grpc.ServiceRegistrar, srv MsgServer) {
	// If the following call pancis, it indicates UnimplementedMsgServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Msg_ServiceDesc, srv)
}

func _Msg_GetMaxSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(sdkws.GetMaxSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetMaxSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetMaxSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetMaxSeq(ctx, req.(*sdkws.GetMaxSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetMaxSeqs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMaxSeqsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetMaxSeqs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetMaxSeqs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetMaxSeqs(ctx, req.(*GetMaxSeqsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetHasReadSeqs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHasReadSeqsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetHasReadSeqs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetHasReadSeqs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetHasReadSeqs(ctx, req.(*GetHasReadSeqsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetMsgByConversationIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMsgByConversationIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetMsgByConversationIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetMsgByConversationIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetMsgByConversationIDs(ctx, req.(*GetMsgByConversationIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetConversationMaxSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationMaxSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetConversationMaxSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetConversationMaxSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetConversationMaxSeq(ctx, req.(*GetConversationMaxSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_PullMessageBySeqs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(sdkws.PullMessageBySeqsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).PullMessageBySeqs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_PullMessageBySeqs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).PullMessageBySeqs(ctx, req.(*sdkws.PullMessageBySeqsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetSeqMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSeqMessageReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetSeqMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetSeqMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetSeqMessage(ctx, req.(*GetSeqMessageReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SearchMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchMessageReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SearchMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SearchMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SearchMessage(ctx, req.(*SearchMessageReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SendMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SendMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SendMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SendMsg(ctx, req.(*SendMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SetUserConversationsMinSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUserConversationsMinSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SetUserConversationsMinSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SetUserConversationsMinSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SetUserConversationsMinSeq(ctx, req.(*SetUserConversationsMinSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_ClearConversationsMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClearConversationsMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).ClearConversationsMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_ClearConversationsMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).ClearConversationsMsg(ctx, req.(*ClearConversationsMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_UserClearAllMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserClearAllMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).UserClearAllMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_UserClearAllMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).UserClearAllMsg(ctx, req.(*UserClearAllMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_DeleteMsgs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMsgsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).DeleteMsgs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_DeleteMsgs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).DeleteMsgs(ctx, req.(*DeleteMsgsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_DeleteMsgPhysicalBySeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMsgPhysicalBySeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).DeleteMsgPhysicalBySeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_DeleteMsgPhysicalBySeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).DeleteMsgPhysicalBySeq(ctx, req.(*DeleteMsgPhysicalBySeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_DeleteMsgPhysical_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMsgPhysicalReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).DeleteMsgPhysical(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_DeleteMsgPhysical_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).DeleteMsgPhysical(ctx, req.(*DeleteMsgPhysicalReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SetSendMsgStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSendMsgStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SetSendMsgStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SetSendMsgStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SetSendMsgStatus(ctx, req.(*SetSendMsgStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetSendMsgStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSendMsgStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetSendMsgStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetSendMsgStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetSendMsgStatus(ctx, req.(*GetSendMsgStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_RevokeMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).RevokeMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_RevokeMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).RevokeMsg(ctx, req.(*RevokeMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_MarkMsgsAsRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkMsgsAsReadReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).MarkMsgsAsRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_MarkMsgsAsRead_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).MarkMsgsAsRead(ctx, req.(*MarkMsgsAsReadReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_MarkConversationAsRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkConversationAsReadReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).MarkConversationAsRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_MarkConversationAsRead_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).MarkConversationAsRead(ctx, req.(*MarkConversationAsReadReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SetConversationHasReadSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConversationHasReadSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SetConversationHasReadSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SetConversationHasReadSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SetConversationHasReadSeq(ctx, req.(*SetConversationHasReadSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetConversationsHasReadAndMaxSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationsHasReadAndMaxSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetConversationsHasReadAndMaxSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetConversationsHasReadAndMaxSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetConversationsHasReadAndMaxSeq(ctx, req.(*GetConversationsHasReadAndMaxSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetActiveUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActiveUserReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetActiveUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetActiveUser_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetActiveUser(ctx, req.(*GetActiveUserReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetActiveGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActiveGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetActiveGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetActiveGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetActiveGroup(ctx, req.(*GetActiveGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetServerTime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerTimeReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetServerTime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetServerTime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetServerTime(ctx, req.(*GetServerTimeReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_ClearMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClearMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).ClearMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_ClearMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).ClearMsg(ctx, req.(*ClearMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_DestructMsgs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestructMsgsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).DestructMsgs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_DestructMsgs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).DestructMsgs(ctx, req.(*DestructMsgsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetActiveConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActiveConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetActiveConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetActiveConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetActiveConversation(ctx, req.(*GetActiveConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SetUserConversationMaxSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUserConversationMaxSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SetUserConversationMaxSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SetUserConversationMaxSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SetUserConversationMaxSeq(ctx, req.(*SetUserConversationMaxSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_SetUserConversationMinSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUserConversationMinSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).SetUserConversationMinSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_SetUserConversationMinSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).SetUserConversationMinSeq(ctx, req.(*SetUserConversationMinSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetLastMessageSeqByTime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLastMessageSeqByTimeReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetLastMessageSeqByTime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetLastMessageSeqByTime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetLastMessageSeqByTime(ctx, req.(*GetLastMessageSeqByTimeReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Msg_GetLastMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLastMessageReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MsgServer).GetLastMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Msg_GetLastMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MsgServer).GetLastMessage(ctx, req.(*GetLastMessageReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Msg_ServiceDesc is the grpc.ServiceDesc for Msg service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Msg_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openim.msg.msg",
	HandlerType: (*MsgServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMaxSeq",
			Handler:    _Msg_GetMaxSeq_Handler,
		},
		{
			MethodName: "GetMaxSeqs",
			Handler:    _Msg_GetMaxSeqs_Handler,
		},
		{
			MethodName: "GetHasReadSeqs",
			Handler:    _Msg_GetHasReadSeqs_Handler,
		},
		{
			MethodName: "GetMsgByConversationIDs",
			Handler:    _Msg_GetMsgByConversationIDs_Handler,
		},
		{
			MethodName: "GetConversationMaxSeq",
			Handler:    _Msg_GetConversationMaxSeq_Handler,
		},
		{
			MethodName: "PullMessageBySeqs",
			Handler:    _Msg_PullMessageBySeqs_Handler,
		},
		{
			MethodName: "GetSeqMessage",
			Handler:    _Msg_GetSeqMessage_Handler,
		},
		{
			MethodName: "SearchMessage",
			Handler:    _Msg_SearchMessage_Handler,
		},
		{
			MethodName: "SendMsg",
			Handler:    _Msg_SendMsg_Handler,
		},
		{
			MethodName: "SetUserConversationsMinSeq",
			Handler:    _Msg_SetUserConversationsMinSeq_Handler,
		},
		{
			MethodName: "ClearConversationsMsg",
			Handler:    _Msg_ClearConversationsMsg_Handler,
		},
		{
			MethodName: "UserClearAllMsg",
			Handler:    _Msg_UserClearAllMsg_Handler,
		},
		{
			MethodName: "DeleteMsgs",
			Handler:    _Msg_DeleteMsgs_Handler,
		},
		{
			MethodName: "DeleteMsgPhysicalBySeq",
			Handler:    _Msg_DeleteMsgPhysicalBySeq_Handler,
		},
		{
			MethodName: "DeleteMsgPhysical",
			Handler:    _Msg_DeleteMsgPhysical_Handler,
		},
		{
			MethodName: "SetSendMsgStatus",
			Handler:    _Msg_SetSendMsgStatus_Handler,
		},
		{
			MethodName: "GetSendMsgStatus",
			Handler:    _Msg_GetSendMsgStatus_Handler,
		},
		{
			MethodName: "RevokeMsg",
			Handler:    _Msg_RevokeMsg_Handler,
		},
		{
			MethodName: "MarkMsgsAsRead",
			Handler:    _Msg_MarkMsgsAsRead_Handler,
		},
		{
			MethodName: "MarkConversationAsRead",
			Handler:    _Msg_MarkConversationAsRead_Handler,
		},
		{
			MethodName: "SetConversationHasReadSeq",
			Handler:    _Msg_SetConversationHasReadSeq_Handler,
		},
		{
			MethodName: "GetConversationsHasReadAndMaxSeq",
			Handler:    _Msg_GetConversationsHasReadAndMaxSeq_Handler,
		},
		{
			MethodName: "GetActiveUser",
			Handler:    _Msg_GetActiveUser_Handler,
		},
		{
			MethodName: "GetActiveGroup",
			Handler:    _Msg_GetActiveGroup_Handler,
		},
		{
			MethodName: "GetServerTime",
			Handler:    _Msg_GetServerTime_Handler,
		},
		{
			MethodName: "ClearMsg",
			Handler:    _Msg_ClearMsg_Handler,
		},
		{
			MethodName: "DestructMsgs",
			Handler:    _Msg_DestructMsgs_Handler,
		},
		{
			MethodName: "GetActiveConversation",
			Handler:    _Msg_GetActiveConversation_Handler,
		},
		{
			MethodName: "SetUserConversationMaxSeq",
			Handler:    _Msg_SetUserConversationMaxSeq_Handler,
		},
		{
			MethodName: "SetUserConversationMinSeq",
			Handler:    _Msg_SetUserConversationMinSeq_Handler,
		},
		{
			MethodName: "GetLastMessageSeqByTime",
			Handler:    _Msg_GetLastMessageSeqByTime_Handler,
		},
		{
			MethodName: "GetLastMessage",
			Handler:    _Msg_GetLastMessage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "msg/msg.proto",
}
