// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.26.0
// source: group/group.proto

package group

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Group_CreateGroup_FullMethodName                      = "/openim.group.group/createGroup"
	Group_JoinGroup_FullMethodName                        = "/openim.group.group/joinGroup"
	Group_QuitGroup_FullMethodName                        = "/openim.group.group/quitGroup"
	Group_GetGroupsInfo_FullMethodName                    = "/openim.group.group/getGroupsInfo"
	Group_SetGroupInfo_FullMethodName                     = "/openim.group.group/setGroupInfo"
	Group_SetGroupInfoEx_FullMethodName                   = "/openim.group.group/setGroupInfoEx"
	Group_GetGroupApplicationList_FullMethodName          = "/openim.group.group/getGroupApplicationList"
	Group_GetUserReqApplicationList_FullMethodName        = "/openim.group.group/getUserReqApplicationList"
	Group_GetGroupUsersReqApplicationList_FullMethodName  = "/openim.group.group/getGroupUsersReqApplicationList"
	Group_GetSpecifiedUserGroupRequestInfo_FullMethodName = "/openim.group.group/getSpecifiedUserGroupRequestInfo"
	Group_TransferGroupOwner_FullMethodName               = "/openim.group.group/transferGroupOwner"
	Group_GroupApplicationResponse_FullMethodName         = "/openim.group.group/groupApplicationResponse"
	Group_GetGroupMemberList_FullMethodName               = "/openim.group.group/getGroupMemberList"
	Group_GetGroupMembersInfo_FullMethodName              = "/openim.group.group/getGroupMembersInfo"
	Group_KickGroupMember_FullMethodName                  = "/openim.group.group/kickGroupMember"
	Group_GetJoinedGroupList_FullMethodName               = "/openim.group.group/getJoinedGroupList"
	Group_InviteUserToGroup_FullMethodName                = "/openim.group.group/inviteUserToGroup"
	Group_GetGroups_FullMethodName                        = "/openim.group.group/getGroups"
	Group_GetGroupMembersCMS_FullMethodName               = "/openim.group.group/getGroupMembersCMS"
	Group_DismissGroup_FullMethodName                     = "/openim.group.group/dismissGroup"
	Group_MuteGroupMember_FullMethodName                  = "/openim.group.group/muteGroupMember"
	Group_CancelMuteGroupMember_FullMethodName            = "/openim.group.group/cancelMuteGroupMember"
	Group_MuteGroup_FullMethodName                        = "/openim.group.group/muteGroup"
	Group_CancelMuteGroup_FullMethodName                  = "/openim.group.group/cancelMuteGroup"
	Group_SetGroupMemberInfo_FullMethodName               = "/openim.group.group/setGroupMemberInfo"
	Group_GetGroupAbstractInfo_FullMethodName             = "/openim.group.group/getGroupAbstractInfo"
	Group_GetUserInGroupMembers_FullMethodName            = "/openim.group.group/getUserInGroupMembers"
	Group_GetGroupMemberUserIDs_FullMethodName            = "/openim.group.group/getGroupMemberUserIDs"
	Group_GetGroupMemberRoleLevel_FullMethodName          = "/openim.group.group/GetGroupMemberRoleLevel"
	Group_GetGroupInfoCache_FullMethodName                = "/openim.group.group/GetGroupInfoCache"
	Group_GetGroupMemberCache_FullMethodName              = "/openim.group.group/GetGroupMemberCache"
	Group_GroupCreateCount_FullMethodName                 = "/openim.group.group/GroupCreateCount"
	Group_NotificationUserInfoUpdate_FullMethodName       = "/openim.group.group/NotificationUserInfoUpdate"
	Group_GetIncrementalGroupMember_FullMethodName        = "/openim.group.group/getIncrementalGroupMember"
	Group_BatchGetIncrementalGroupMember_FullMethodName   = "/openim.group.group/BatchGetIncrementalGroupMember"
	Group_GetIncrementalJoinGroup_FullMethodName          = "/openim.group.group/getIncrementalJoinGroup"
	Group_GetFullGroupMemberUserIDs_FullMethodName        = "/openim.group.group/GetFullGroupMemberUserIDs"
	Group_GetFullJoinGroupIDs_FullMethodName              = "/openim.group.group/GetFullJoinGroupIDs"
)

// GroupClient is the client API for Group service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GroupClient interface {
	// 创建群
	CreateGroup(ctx context.Context, in *CreateGroupReq, opts ...grpc.CallOption) (*CreateGroupResp, error)
	// 申请加群
	JoinGroup(ctx context.Context, in *JoinGroupReq, opts ...grpc.CallOption) (*JoinGroupResp, error)
	// 退出群
	QuitGroup(ctx context.Context, in *QuitGroupReq, opts ...grpc.CallOption) (*QuitGroupResp, error)
	// 获取指定群信息
	GetGroupsInfo(ctx context.Context, in *GetGroupsInfoReq, opts ...grpc.CallOption) (*GetGroupsInfoResp, error)
	// 设置群信息
	SetGroupInfo(ctx context.Context, in *SetGroupInfoReq, opts ...grpc.CallOption) (*SetGroupInfoResp, error)
	SetGroupInfoEx(ctx context.Context, in *SetGroupInfoExReq, opts ...grpc.CallOption) (*SetGroupInfoExResp, error)
	// （以管理员或群主身份）获取群的加群申请
	GetGroupApplicationList(ctx context.Context, in *GetGroupApplicationListReq, opts ...grpc.CallOption) (*GetGroupApplicationListResp, error)
	// 获取用户自己的主动加群申请
	GetUserReqApplicationList(ctx context.Context, in *GetUserReqApplicationListReq, opts ...grpc.CallOption) (*GetUserReqApplicationListResp, error)
	// 获取该群用户的加群申请
	GetGroupUsersReqApplicationList(ctx context.Context, in *GetGroupUsersReqApplicationListReq, opts ...grpc.CallOption) (*GetGroupUsersReqApplicationListResp, error)
	GetSpecifiedUserGroupRequestInfo(ctx context.Context, in *GetSpecifiedUserGroupRequestInfoReq, opts ...grpc.CallOption) (*GetSpecifiedUserGroupRequestInfoResp, error)
	// 转让群主
	TransferGroupOwner(ctx context.Context, in *TransferGroupOwnerReq, opts ...grpc.CallOption) (*TransferGroupOwnerResp, error)
	// 群主或管理员处理进群申请
	GroupApplicationResponse(ctx context.Context, in *GroupApplicationResponseReq, opts ...grpc.CallOption) (*GroupApplicationResponseResp, error)
	// 获取某个群的群成员
	GetGroupMemberList(ctx context.Context, in *GetGroupMemberListReq, opts ...grpc.CallOption) (*GetGroupMemberListResp, error)
	// 获取某个群的指定群成员
	GetGroupMembersInfo(ctx context.Context, in *GetGroupMembersInfoReq, opts ...grpc.CallOption) (*GetGroupMembersInfoResp, error)
	// 踢出群
	KickGroupMember(ctx context.Context, in *KickGroupMemberReq, opts ...grpc.CallOption) (*KickGroupMemberResp, error)
	// 获取某个人已加入群
	GetJoinedGroupList(ctx context.Context, in *GetJoinedGroupListReq, opts ...grpc.CallOption) (*GetJoinedGroupListResp, error)
	// 邀请某些人进群
	InviteUserToGroup(ctx context.Context, in *InviteUserToGroupReq, opts ...grpc.CallOption) (*InviteUserToGroupResp, error)
	GetGroups(ctx context.Context, in *GetGroupsReq, opts ...grpc.CallOption) (*GetGroupsResp, error)
	GetGroupMembersCMS(ctx context.Context, in *GetGroupMembersCMSReq, opts ...grpc.CallOption) (*GetGroupMembersCMSResp, error)
	// 解散群
	DismissGroup(ctx context.Context, in *DismissGroupReq, opts ...grpc.CallOption) (*DismissGroupResp, error)
	// 对某个群成员禁言
	MuteGroupMember(ctx context.Context, in *MuteGroupMemberReq, opts ...grpc.CallOption) (*MuteGroupMemberResp, error)
	// 对某个群成员取消禁言
	CancelMuteGroupMember(ctx context.Context, in *CancelMuteGroupMemberReq, opts ...grpc.CallOption) (*CancelMuteGroupMemberResp, error)
	// 对某个群禁言
	MuteGroup(ctx context.Context, in *MuteGroupReq, opts ...grpc.CallOption) (*MuteGroupResp, error)
	// 对某个群取消禁言
	CancelMuteGroup(ctx context.Context, in *CancelMuteGroupReq, opts ...grpc.CallOption) (*CancelMuteGroupResp, error)
	// 设置群成员信息
	SetGroupMemberInfo(ctx context.Context, in *SetGroupMemberInfoReq, opts ...grpc.CallOption) (*SetGroupMemberInfoResp, error)
	// 获取群信息hash值
	GetGroupAbstractInfo(ctx context.Context, in *GetGroupAbstractInfoReq, opts ...grpc.CallOption) (*GetGroupAbstractInfoResp, error)
	// 获取某个用户在指定群中的信息
	GetUserInGroupMembers(ctx context.Context, in *GetUserInGroupMembersReq, opts ...grpc.CallOption) (*GetUserInGroupMembersResp, error)
	// 获取群成员用户ID
	GetGroupMemberUserIDs(ctx context.Context, in *GetGroupMemberUserIDsReq, opts ...grpc.CallOption) (*GetGroupMemberUserIDsResp, error)
	// 查询群组中对应级别的成员
	GetGroupMemberRoleLevel(ctx context.Context, in *GetGroupMemberRoleLevelReq, opts ...grpc.CallOption) (*GetGroupMemberRoleLevelResp, error)
	GetGroupInfoCache(ctx context.Context, in *GetGroupInfoCacheReq, opts ...grpc.CallOption) (*GetGroupInfoCacheResp, error)
	GetGroupMemberCache(ctx context.Context, in *GetGroupMemberCacheReq, opts ...grpc.CallOption) (*GetGroupMemberCacheResp, error)
	GroupCreateCount(ctx context.Context, in *GroupCreateCountReq, opts ...grpc.CallOption) (*GroupCreateCountResp, error)
	NotificationUserInfoUpdate(ctx context.Context, in *NotificationUserInfoUpdateReq, opts ...grpc.CallOption) (*NotificationUserInfoUpdateResp, error)
	GetIncrementalGroupMember(ctx context.Context, in *GetIncrementalGroupMemberReq, opts ...grpc.CallOption) (*GetIncrementalGroupMemberResp, error)
	BatchGetIncrementalGroupMember(ctx context.Context, in *BatchGetIncrementalGroupMemberReq, opts ...grpc.CallOption) (*BatchGetIncrementalGroupMemberResp, error)
	GetIncrementalJoinGroup(ctx context.Context, in *GetIncrementalJoinGroupReq, opts ...grpc.CallOption) (*GetIncrementalJoinGroupResp, error)
	GetFullGroupMemberUserIDs(ctx context.Context, in *GetFullGroupMemberUserIDsReq, opts ...grpc.CallOption) (*GetFullGroupMemberUserIDsResp, error)
	GetFullJoinGroupIDs(ctx context.Context, in *GetFullJoinGroupIDsReq, opts ...grpc.CallOption) (*GetFullJoinGroupIDsResp, error)
}

type groupClient struct {
	cc grpc.ClientConnInterface
}

func NewGroupClient(cc grpc.ClientConnInterface) GroupClient {
	return &groupClient{cc}
}

func (c *groupClient) CreateGroup(ctx context.Context, in *CreateGroupReq, opts ...grpc.CallOption) (*CreateGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateGroupResp)
	err := c.cc.Invoke(ctx, Group_CreateGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) JoinGroup(ctx context.Context, in *JoinGroupReq, opts ...grpc.CallOption) (*JoinGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(JoinGroupResp)
	err := c.cc.Invoke(ctx, Group_JoinGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) QuitGroup(ctx context.Context, in *QuitGroupReq, opts ...grpc.CallOption) (*QuitGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(QuitGroupResp)
	err := c.cc.Invoke(ctx, Group_QuitGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupsInfo(ctx context.Context, in *GetGroupsInfoReq, opts ...grpc.CallOption) (*GetGroupsInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupsInfoResp)
	err := c.cc.Invoke(ctx, Group_GetGroupsInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) SetGroupInfo(ctx context.Context, in *SetGroupInfoReq, opts ...grpc.CallOption) (*SetGroupInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetGroupInfoResp)
	err := c.cc.Invoke(ctx, Group_SetGroupInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) SetGroupInfoEx(ctx context.Context, in *SetGroupInfoExReq, opts ...grpc.CallOption) (*SetGroupInfoExResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetGroupInfoExResp)
	err := c.cc.Invoke(ctx, Group_SetGroupInfoEx_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupApplicationList(ctx context.Context, in *GetGroupApplicationListReq, opts ...grpc.CallOption) (*GetGroupApplicationListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupApplicationListResp)
	err := c.cc.Invoke(ctx, Group_GetGroupApplicationList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetUserReqApplicationList(ctx context.Context, in *GetUserReqApplicationListReq, opts ...grpc.CallOption) (*GetUserReqApplicationListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUserReqApplicationListResp)
	err := c.cc.Invoke(ctx, Group_GetUserReqApplicationList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupUsersReqApplicationList(ctx context.Context, in *GetGroupUsersReqApplicationListReq, opts ...grpc.CallOption) (*GetGroupUsersReqApplicationListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupUsersReqApplicationListResp)
	err := c.cc.Invoke(ctx, Group_GetGroupUsersReqApplicationList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetSpecifiedUserGroupRequestInfo(ctx context.Context, in *GetSpecifiedUserGroupRequestInfoReq, opts ...grpc.CallOption) (*GetSpecifiedUserGroupRequestInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSpecifiedUserGroupRequestInfoResp)
	err := c.cc.Invoke(ctx, Group_GetSpecifiedUserGroupRequestInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) TransferGroupOwner(ctx context.Context, in *TransferGroupOwnerReq, opts ...grpc.CallOption) (*TransferGroupOwnerResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TransferGroupOwnerResp)
	err := c.cc.Invoke(ctx, Group_TransferGroupOwner_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GroupApplicationResponse(ctx context.Context, in *GroupApplicationResponseReq, opts ...grpc.CallOption) (*GroupApplicationResponseResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GroupApplicationResponseResp)
	err := c.cc.Invoke(ctx, Group_GroupApplicationResponse_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMemberList(ctx context.Context, in *GetGroupMemberListReq, opts ...grpc.CallOption) (*GetGroupMemberListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMemberListResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMemberList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMembersInfo(ctx context.Context, in *GetGroupMembersInfoReq, opts ...grpc.CallOption) (*GetGroupMembersInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMembersInfoResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMembersInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) KickGroupMember(ctx context.Context, in *KickGroupMemberReq, opts ...grpc.CallOption) (*KickGroupMemberResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(KickGroupMemberResp)
	err := c.cc.Invoke(ctx, Group_KickGroupMember_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetJoinedGroupList(ctx context.Context, in *GetJoinedGroupListReq, opts ...grpc.CallOption) (*GetJoinedGroupListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetJoinedGroupListResp)
	err := c.cc.Invoke(ctx, Group_GetJoinedGroupList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) InviteUserToGroup(ctx context.Context, in *InviteUserToGroupReq, opts ...grpc.CallOption) (*InviteUserToGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(InviteUserToGroupResp)
	err := c.cc.Invoke(ctx, Group_InviteUserToGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroups(ctx context.Context, in *GetGroupsReq, opts ...grpc.CallOption) (*GetGroupsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupsResp)
	err := c.cc.Invoke(ctx, Group_GetGroups_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMembersCMS(ctx context.Context, in *GetGroupMembersCMSReq, opts ...grpc.CallOption) (*GetGroupMembersCMSResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMembersCMSResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMembersCMS_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) DismissGroup(ctx context.Context, in *DismissGroupReq, opts ...grpc.CallOption) (*DismissGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DismissGroupResp)
	err := c.cc.Invoke(ctx, Group_DismissGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) MuteGroupMember(ctx context.Context, in *MuteGroupMemberReq, opts ...grpc.CallOption) (*MuteGroupMemberResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MuteGroupMemberResp)
	err := c.cc.Invoke(ctx, Group_MuteGroupMember_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) CancelMuteGroupMember(ctx context.Context, in *CancelMuteGroupMemberReq, opts ...grpc.CallOption) (*CancelMuteGroupMemberResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CancelMuteGroupMemberResp)
	err := c.cc.Invoke(ctx, Group_CancelMuteGroupMember_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) MuteGroup(ctx context.Context, in *MuteGroupReq, opts ...grpc.CallOption) (*MuteGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MuteGroupResp)
	err := c.cc.Invoke(ctx, Group_MuteGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) CancelMuteGroup(ctx context.Context, in *CancelMuteGroupReq, opts ...grpc.CallOption) (*CancelMuteGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CancelMuteGroupResp)
	err := c.cc.Invoke(ctx, Group_CancelMuteGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) SetGroupMemberInfo(ctx context.Context, in *SetGroupMemberInfoReq, opts ...grpc.CallOption) (*SetGroupMemberInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetGroupMemberInfoResp)
	err := c.cc.Invoke(ctx, Group_SetGroupMemberInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupAbstractInfo(ctx context.Context, in *GetGroupAbstractInfoReq, opts ...grpc.CallOption) (*GetGroupAbstractInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupAbstractInfoResp)
	err := c.cc.Invoke(ctx, Group_GetGroupAbstractInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetUserInGroupMembers(ctx context.Context, in *GetUserInGroupMembersReq, opts ...grpc.CallOption) (*GetUserInGroupMembersResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUserInGroupMembersResp)
	err := c.cc.Invoke(ctx, Group_GetUserInGroupMembers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMemberUserIDs(ctx context.Context, in *GetGroupMemberUserIDsReq, opts ...grpc.CallOption) (*GetGroupMemberUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMemberUserIDsResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMemberUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMemberRoleLevel(ctx context.Context, in *GetGroupMemberRoleLevelReq, opts ...grpc.CallOption) (*GetGroupMemberRoleLevelResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMemberRoleLevelResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMemberRoleLevel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupInfoCache(ctx context.Context, in *GetGroupInfoCacheReq, opts ...grpc.CallOption) (*GetGroupInfoCacheResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupInfoCacheResp)
	err := c.cc.Invoke(ctx, Group_GetGroupInfoCache_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetGroupMemberCache(ctx context.Context, in *GetGroupMemberCacheReq, opts ...grpc.CallOption) (*GetGroupMemberCacheResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGroupMemberCacheResp)
	err := c.cc.Invoke(ctx, Group_GetGroupMemberCache_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GroupCreateCount(ctx context.Context, in *GroupCreateCountReq, opts ...grpc.CallOption) (*GroupCreateCountResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GroupCreateCountResp)
	err := c.cc.Invoke(ctx, Group_GroupCreateCount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) NotificationUserInfoUpdate(ctx context.Context, in *NotificationUserInfoUpdateReq, opts ...grpc.CallOption) (*NotificationUserInfoUpdateResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NotificationUserInfoUpdateResp)
	err := c.cc.Invoke(ctx, Group_NotificationUserInfoUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetIncrementalGroupMember(ctx context.Context, in *GetIncrementalGroupMemberReq, opts ...grpc.CallOption) (*GetIncrementalGroupMemberResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalGroupMemberResp)
	err := c.cc.Invoke(ctx, Group_GetIncrementalGroupMember_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) BatchGetIncrementalGroupMember(ctx context.Context, in *BatchGetIncrementalGroupMemberReq, opts ...grpc.CallOption) (*BatchGetIncrementalGroupMemberResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGetIncrementalGroupMemberResp)
	err := c.cc.Invoke(ctx, Group_BatchGetIncrementalGroupMember_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetIncrementalJoinGroup(ctx context.Context, in *GetIncrementalJoinGroupReq, opts ...grpc.CallOption) (*GetIncrementalJoinGroupResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalJoinGroupResp)
	err := c.cc.Invoke(ctx, Group_GetIncrementalJoinGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetFullGroupMemberUserIDs(ctx context.Context, in *GetFullGroupMemberUserIDsReq, opts ...grpc.CallOption) (*GetFullGroupMemberUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFullGroupMemberUserIDsResp)
	err := c.cc.Invoke(ctx, Group_GetFullGroupMemberUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupClient) GetFullJoinGroupIDs(ctx context.Context, in *GetFullJoinGroupIDsReq, opts ...grpc.CallOption) (*GetFullJoinGroupIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFullJoinGroupIDsResp)
	err := c.cc.Invoke(ctx, Group_GetFullJoinGroupIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GroupServer is the server API for Group service.
// All implementations must embed UnimplementedGroupServer
// for forward compatibility.
type GroupServer interface {
	// 创建群
	CreateGroup(context.Context, *CreateGroupReq) (*CreateGroupResp, error)
	// 申请加群
	JoinGroup(context.Context, *JoinGroupReq) (*JoinGroupResp, error)
	// 退出群
	QuitGroup(context.Context, *QuitGroupReq) (*QuitGroupResp, error)
	// 获取指定群信息
	GetGroupsInfo(context.Context, *GetGroupsInfoReq) (*GetGroupsInfoResp, error)
	// 设置群信息
	SetGroupInfo(context.Context, *SetGroupInfoReq) (*SetGroupInfoResp, error)
	SetGroupInfoEx(context.Context, *SetGroupInfoExReq) (*SetGroupInfoExResp, error)
	// （以管理员或群主身份）获取群的加群申请
	GetGroupApplicationList(context.Context, *GetGroupApplicationListReq) (*GetGroupApplicationListResp, error)
	// 获取用户自己的主动加群申请
	GetUserReqApplicationList(context.Context, *GetUserReqApplicationListReq) (*GetUserReqApplicationListResp, error)
	// 获取该群用户的加群申请
	GetGroupUsersReqApplicationList(context.Context, *GetGroupUsersReqApplicationListReq) (*GetGroupUsersReqApplicationListResp, error)
	GetSpecifiedUserGroupRequestInfo(context.Context, *GetSpecifiedUserGroupRequestInfoReq) (*GetSpecifiedUserGroupRequestInfoResp, error)
	// 转让群主
	TransferGroupOwner(context.Context, *TransferGroupOwnerReq) (*TransferGroupOwnerResp, error)
	// 群主或管理员处理进群申请
	GroupApplicationResponse(context.Context, *GroupApplicationResponseReq) (*GroupApplicationResponseResp, error)
	// 获取某个群的群成员
	GetGroupMemberList(context.Context, *GetGroupMemberListReq) (*GetGroupMemberListResp, error)
	// 获取某个群的指定群成员
	GetGroupMembersInfo(context.Context, *GetGroupMembersInfoReq) (*GetGroupMembersInfoResp, error)
	// 踢出群
	KickGroupMember(context.Context, *KickGroupMemberReq) (*KickGroupMemberResp, error)
	// 获取某个人已加入群
	GetJoinedGroupList(context.Context, *GetJoinedGroupListReq) (*GetJoinedGroupListResp, error)
	// 邀请某些人进群
	InviteUserToGroup(context.Context, *InviteUserToGroupReq) (*InviteUserToGroupResp, error)
	GetGroups(context.Context, *GetGroupsReq) (*GetGroupsResp, error)
	GetGroupMembersCMS(context.Context, *GetGroupMembersCMSReq) (*GetGroupMembersCMSResp, error)
	// 解散群
	DismissGroup(context.Context, *DismissGroupReq) (*DismissGroupResp, error)
	// 对某个群成员禁言
	MuteGroupMember(context.Context, *MuteGroupMemberReq) (*MuteGroupMemberResp, error)
	// 对某个群成员取消禁言
	CancelMuteGroupMember(context.Context, *CancelMuteGroupMemberReq) (*CancelMuteGroupMemberResp, error)
	// 对某个群禁言
	MuteGroup(context.Context, *MuteGroupReq) (*MuteGroupResp, error)
	// 对某个群取消禁言
	CancelMuteGroup(context.Context, *CancelMuteGroupReq) (*CancelMuteGroupResp, error)
	// 设置群成员信息
	SetGroupMemberInfo(context.Context, *SetGroupMemberInfoReq) (*SetGroupMemberInfoResp, error)
	// 获取群信息hash值
	GetGroupAbstractInfo(context.Context, *GetGroupAbstractInfoReq) (*GetGroupAbstractInfoResp, error)
	// 获取某个用户在指定群中的信息
	GetUserInGroupMembers(context.Context, *GetUserInGroupMembersReq) (*GetUserInGroupMembersResp, error)
	// 获取群成员用户ID
	GetGroupMemberUserIDs(context.Context, *GetGroupMemberUserIDsReq) (*GetGroupMemberUserIDsResp, error)
	// 查询群组中对应级别的成员
	GetGroupMemberRoleLevel(context.Context, *GetGroupMemberRoleLevelReq) (*GetGroupMemberRoleLevelResp, error)
	GetGroupInfoCache(context.Context, *GetGroupInfoCacheReq) (*GetGroupInfoCacheResp, error)
	GetGroupMemberCache(context.Context, *GetGroupMemberCacheReq) (*GetGroupMemberCacheResp, error)
	GroupCreateCount(context.Context, *GroupCreateCountReq) (*GroupCreateCountResp, error)
	NotificationUserInfoUpdate(context.Context, *NotificationUserInfoUpdateReq) (*NotificationUserInfoUpdateResp, error)
	GetIncrementalGroupMember(context.Context, *GetIncrementalGroupMemberReq) (*GetIncrementalGroupMemberResp, error)
	BatchGetIncrementalGroupMember(context.Context, *BatchGetIncrementalGroupMemberReq) (*BatchGetIncrementalGroupMemberResp, error)
	GetIncrementalJoinGroup(context.Context, *GetIncrementalJoinGroupReq) (*GetIncrementalJoinGroupResp, error)
	GetFullGroupMemberUserIDs(context.Context, *GetFullGroupMemberUserIDsReq) (*GetFullGroupMemberUserIDsResp, error)
	GetFullJoinGroupIDs(context.Context, *GetFullJoinGroupIDsReq) (*GetFullJoinGroupIDsResp, error)
	mustEmbedUnimplementedGroupServer()
}

// UnimplementedGroupServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedGroupServer struct{}

func (UnimplementedGroupServer) CreateGroup(context.Context, *CreateGroupReq) (*CreateGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (UnimplementedGroupServer) JoinGroup(context.Context, *JoinGroupReq) (*JoinGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method JoinGroup not implemented")
}
func (UnimplementedGroupServer) QuitGroup(context.Context, *QuitGroupReq) (*QuitGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QuitGroup not implemented")
}
func (UnimplementedGroupServer) GetGroupsInfo(context.Context, *GetGroupsInfoReq) (*GetGroupsInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupsInfo not implemented")
}
func (UnimplementedGroupServer) SetGroupInfo(context.Context, *SetGroupInfoReq) (*SetGroupInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGroupInfo not implemented")
}
func (UnimplementedGroupServer) SetGroupInfoEx(context.Context, *SetGroupInfoExReq) (*SetGroupInfoExResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGroupInfoEx not implemented")
}
func (UnimplementedGroupServer) GetGroupApplicationList(context.Context, *GetGroupApplicationListReq) (*GetGroupApplicationListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupApplicationList not implemented")
}
func (UnimplementedGroupServer) GetUserReqApplicationList(context.Context, *GetUserReqApplicationListReq) (*GetUserReqApplicationListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserReqApplicationList not implemented")
}
func (UnimplementedGroupServer) GetGroupUsersReqApplicationList(context.Context, *GetGroupUsersReqApplicationListReq) (*GetGroupUsersReqApplicationListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupUsersReqApplicationList not implemented")
}
func (UnimplementedGroupServer) GetSpecifiedUserGroupRequestInfo(context.Context, *GetSpecifiedUserGroupRequestInfoReq) (*GetSpecifiedUserGroupRequestInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecifiedUserGroupRequestInfo not implemented")
}
func (UnimplementedGroupServer) TransferGroupOwner(context.Context, *TransferGroupOwnerReq) (*TransferGroupOwnerResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferGroupOwner not implemented")
}
func (UnimplementedGroupServer) GroupApplicationResponse(context.Context, *GroupApplicationResponseReq) (*GroupApplicationResponseResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupApplicationResponse not implemented")
}
func (UnimplementedGroupServer) GetGroupMemberList(context.Context, *GetGroupMemberListReq) (*GetGroupMemberListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMemberList not implemented")
}
func (UnimplementedGroupServer) GetGroupMembersInfo(context.Context, *GetGroupMembersInfoReq) (*GetGroupMembersInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMembersInfo not implemented")
}
func (UnimplementedGroupServer) KickGroupMember(context.Context, *KickGroupMemberReq) (*KickGroupMemberResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KickGroupMember not implemented")
}
func (UnimplementedGroupServer) GetJoinedGroupList(context.Context, *GetJoinedGroupListReq) (*GetJoinedGroupListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJoinedGroupList not implemented")
}
func (UnimplementedGroupServer) InviteUserToGroup(context.Context, *InviteUserToGroupReq) (*InviteUserToGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InviteUserToGroup not implemented")
}
func (UnimplementedGroupServer) GetGroups(context.Context, *GetGroupsReq) (*GetGroupsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroups not implemented")
}
func (UnimplementedGroupServer) GetGroupMembersCMS(context.Context, *GetGroupMembersCMSReq) (*GetGroupMembersCMSResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMembersCMS not implemented")
}
func (UnimplementedGroupServer) DismissGroup(context.Context, *DismissGroupReq) (*DismissGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DismissGroup not implemented")
}
func (UnimplementedGroupServer) MuteGroupMember(context.Context, *MuteGroupMemberReq) (*MuteGroupMemberResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MuteGroupMember not implemented")
}
func (UnimplementedGroupServer) CancelMuteGroupMember(context.Context, *CancelMuteGroupMemberReq) (*CancelMuteGroupMemberResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelMuteGroupMember not implemented")
}
func (UnimplementedGroupServer) MuteGroup(context.Context, *MuteGroupReq) (*MuteGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MuteGroup not implemented")
}
func (UnimplementedGroupServer) CancelMuteGroup(context.Context, *CancelMuteGroupReq) (*CancelMuteGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelMuteGroup not implemented")
}
func (UnimplementedGroupServer) SetGroupMemberInfo(context.Context, *SetGroupMemberInfoReq) (*SetGroupMemberInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGroupMemberInfo not implemented")
}
func (UnimplementedGroupServer) GetGroupAbstractInfo(context.Context, *GetGroupAbstractInfoReq) (*GetGroupAbstractInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupAbstractInfo not implemented")
}
func (UnimplementedGroupServer) GetUserInGroupMembers(context.Context, *GetUserInGroupMembersReq) (*GetUserInGroupMembersResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserInGroupMembers not implemented")
}
func (UnimplementedGroupServer) GetGroupMemberUserIDs(context.Context, *GetGroupMemberUserIDsReq) (*GetGroupMemberUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMemberUserIDs not implemented")
}
func (UnimplementedGroupServer) GetGroupMemberRoleLevel(context.Context, *GetGroupMemberRoleLevelReq) (*GetGroupMemberRoleLevelResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMemberRoleLevel not implemented")
}
func (UnimplementedGroupServer) GetGroupInfoCache(context.Context, *GetGroupInfoCacheReq) (*GetGroupInfoCacheResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupInfoCache not implemented")
}
func (UnimplementedGroupServer) GetGroupMemberCache(context.Context, *GetGroupMemberCacheReq) (*GetGroupMemberCacheResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupMemberCache not implemented")
}
func (UnimplementedGroupServer) GroupCreateCount(context.Context, *GroupCreateCountReq) (*GroupCreateCountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupCreateCount not implemented")
}
func (UnimplementedGroupServer) NotificationUserInfoUpdate(context.Context, *NotificationUserInfoUpdateReq) (*NotificationUserInfoUpdateResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NotificationUserInfoUpdate not implemented")
}
func (UnimplementedGroupServer) GetIncrementalGroupMember(context.Context, *GetIncrementalGroupMemberReq) (*GetIncrementalGroupMemberResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalGroupMember not implemented")
}
func (UnimplementedGroupServer) BatchGetIncrementalGroupMember(context.Context, *BatchGetIncrementalGroupMemberReq) (*BatchGetIncrementalGroupMemberResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetIncrementalGroupMember not implemented")
}
func (UnimplementedGroupServer) GetIncrementalJoinGroup(context.Context, *GetIncrementalJoinGroupReq) (*GetIncrementalJoinGroupResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalJoinGroup not implemented")
}
func (UnimplementedGroupServer) GetFullGroupMemberUserIDs(context.Context, *GetFullGroupMemberUserIDsReq) (*GetFullGroupMemberUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFullGroupMemberUserIDs not implemented")
}
func (UnimplementedGroupServer) GetFullJoinGroupIDs(context.Context, *GetFullJoinGroupIDsReq) (*GetFullJoinGroupIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFullJoinGroupIDs not implemented")
}
func (UnimplementedGroupServer) mustEmbedUnimplementedGroupServer() {}
func (UnimplementedGroupServer) testEmbeddedByValue()               {}

// UnsafeGroupServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GroupServer will
// result in compilation errors.
type UnsafeGroupServer interface {
	mustEmbedUnimplementedGroupServer()
}

func RegisterGroupServer(s grpc.ServiceRegistrar, srv GroupServer) {
	// If the following call pancis, it indicates UnimplementedGroupServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Group_ServiceDesc, srv)
}

func _Group_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_CreateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).CreateGroup(ctx, req.(*CreateGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_JoinGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).JoinGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_JoinGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).JoinGroup(ctx, req.(*JoinGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_QuitGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QuitGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).QuitGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_QuitGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).QuitGroup(ctx, req.(*QuitGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupsInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupsInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupsInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupsInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupsInfo(ctx, req.(*GetGroupsInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_SetGroupInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGroupInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).SetGroupInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_SetGroupInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).SetGroupInfo(ctx, req.(*SetGroupInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_SetGroupInfoEx_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGroupInfoExReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).SetGroupInfoEx(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_SetGroupInfoEx_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).SetGroupInfoEx(ctx, req.(*SetGroupInfoExReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupApplicationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupApplicationListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupApplicationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupApplicationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupApplicationList(ctx, req.(*GetGroupApplicationListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetUserReqApplicationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserReqApplicationListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetUserReqApplicationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetUserReqApplicationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetUserReqApplicationList(ctx, req.(*GetUserReqApplicationListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupUsersReqApplicationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupUsersReqApplicationListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupUsersReqApplicationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupUsersReqApplicationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupUsersReqApplicationList(ctx, req.(*GetGroupUsersReqApplicationListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetSpecifiedUserGroupRequestInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecifiedUserGroupRequestInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetSpecifiedUserGroupRequestInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetSpecifiedUserGroupRequestInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetSpecifiedUserGroupRequestInfo(ctx, req.(*GetSpecifiedUserGroupRequestInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_TransferGroupOwner_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferGroupOwnerReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).TransferGroupOwner(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_TransferGroupOwner_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).TransferGroupOwner(ctx, req.(*TransferGroupOwnerReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GroupApplicationResponse_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupApplicationResponseReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GroupApplicationResponse(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GroupApplicationResponse_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GroupApplicationResponse(ctx, req.(*GroupApplicationResponseReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMemberList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMemberListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMemberList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMemberList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMemberList(ctx, req.(*GetGroupMemberListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMembersInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMembersInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMembersInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMembersInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMembersInfo(ctx, req.(*GetGroupMembersInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_KickGroupMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KickGroupMemberReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).KickGroupMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_KickGroupMember_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).KickGroupMember(ctx, req.(*KickGroupMemberReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetJoinedGroupList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJoinedGroupListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetJoinedGroupList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetJoinedGroupList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetJoinedGroupList(ctx, req.(*GetJoinedGroupListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_InviteUserToGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InviteUserToGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).InviteUserToGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_InviteUserToGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).InviteUserToGroup(ctx, req.(*InviteUserToGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroups(ctx, req.(*GetGroupsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMembersCMS_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMembersCMSReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMembersCMS(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMembersCMS_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMembersCMS(ctx, req.(*GetGroupMembersCMSReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_DismissGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).DismissGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_DismissGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).DismissGroup(ctx, req.(*DismissGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_MuteGroupMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MuteGroupMemberReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).MuteGroupMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_MuteGroupMember_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).MuteGroupMember(ctx, req.(*MuteGroupMemberReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_CancelMuteGroupMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelMuteGroupMemberReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).CancelMuteGroupMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_CancelMuteGroupMember_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).CancelMuteGroupMember(ctx, req.(*CancelMuteGroupMemberReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_MuteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MuteGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).MuteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_MuteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).MuteGroup(ctx, req.(*MuteGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_CancelMuteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelMuteGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).CancelMuteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_CancelMuteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).CancelMuteGroup(ctx, req.(*CancelMuteGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_SetGroupMemberInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGroupMemberInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).SetGroupMemberInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_SetGroupMemberInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).SetGroupMemberInfo(ctx, req.(*SetGroupMemberInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupAbstractInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupAbstractInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupAbstractInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupAbstractInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupAbstractInfo(ctx, req.(*GetGroupAbstractInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetUserInGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserInGroupMembersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetUserInGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetUserInGroupMembers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetUserInGroupMembers(ctx, req.(*GetUserInGroupMembersReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMemberUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMemberUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMemberUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMemberUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMemberUserIDs(ctx, req.(*GetGroupMemberUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMemberRoleLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMemberRoleLevelReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMemberRoleLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMemberRoleLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMemberRoleLevel(ctx, req.(*GetGroupMemberRoleLevelReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupInfoCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupInfoCacheReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupInfoCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupInfoCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupInfoCache(ctx, req.(*GetGroupInfoCacheReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetGroupMemberCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupMemberCacheReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetGroupMemberCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetGroupMemberCache_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetGroupMemberCache(ctx, req.(*GetGroupMemberCacheReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GroupCreateCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupCreateCountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GroupCreateCount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GroupCreateCount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GroupCreateCount(ctx, req.(*GroupCreateCountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_NotificationUserInfoUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NotificationUserInfoUpdateReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).NotificationUserInfoUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_NotificationUserInfoUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).NotificationUserInfoUpdate(ctx, req.(*NotificationUserInfoUpdateReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetIncrementalGroupMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalGroupMemberReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetIncrementalGroupMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetIncrementalGroupMember_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetIncrementalGroupMember(ctx, req.(*GetIncrementalGroupMemberReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_BatchGetIncrementalGroupMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetIncrementalGroupMemberReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).BatchGetIncrementalGroupMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_BatchGetIncrementalGroupMember_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).BatchGetIncrementalGroupMember(ctx, req.(*BatchGetIncrementalGroupMemberReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetIncrementalJoinGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalJoinGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetIncrementalJoinGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetIncrementalJoinGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetIncrementalJoinGroup(ctx, req.(*GetIncrementalJoinGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetFullGroupMemberUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFullGroupMemberUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetFullGroupMemberUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetFullGroupMemberUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetFullGroupMemberUserIDs(ctx, req.(*GetFullGroupMemberUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Group_GetFullJoinGroupIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFullJoinGroupIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServer).GetFullJoinGroupIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Group_GetFullJoinGroupIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServer).GetFullJoinGroupIDs(ctx, req.(*GetFullJoinGroupIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Group_ServiceDesc is the grpc.ServiceDesc for Group service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Group_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openim.group.group",
	HandlerType: (*GroupServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "createGroup",
			Handler:    _Group_CreateGroup_Handler,
		},
		{
			MethodName: "joinGroup",
			Handler:    _Group_JoinGroup_Handler,
		},
		{
			MethodName: "quitGroup",
			Handler:    _Group_QuitGroup_Handler,
		},
		{
			MethodName: "getGroupsInfo",
			Handler:    _Group_GetGroupsInfo_Handler,
		},
		{
			MethodName: "setGroupInfo",
			Handler:    _Group_SetGroupInfo_Handler,
		},
		{
			MethodName: "setGroupInfoEx",
			Handler:    _Group_SetGroupInfoEx_Handler,
		},
		{
			MethodName: "getGroupApplicationList",
			Handler:    _Group_GetGroupApplicationList_Handler,
		},
		{
			MethodName: "getUserReqApplicationList",
			Handler:    _Group_GetUserReqApplicationList_Handler,
		},
		{
			MethodName: "getGroupUsersReqApplicationList",
			Handler:    _Group_GetGroupUsersReqApplicationList_Handler,
		},
		{
			MethodName: "getSpecifiedUserGroupRequestInfo",
			Handler:    _Group_GetSpecifiedUserGroupRequestInfo_Handler,
		},
		{
			MethodName: "transferGroupOwner",
			Handler:    _Group_TransferGroupOwner_Handler,
		},
		{
			MethodName: "groupApplicationResponse",
			Handler:    _Group_GroupApplicationResponse_Handler,
		},
		{
			MethodName: "getGroupMemberList",
			Handler:    _Group_GetGroupMemberList_Handler,
		},
		{
			MethodName: "getGroupMembersInfo",
			Handler:    _Group_GetGroupMembersInfo_Handler,
		},
		{
			MethodName: "kickGroupMember",
			Handler:    _Group_KickGroupMember_Handler,
		},
		{
			MethodName: "getJoinedGroupList",
			Handler:    _Group_GetJoinedGroupList_Handler,
		},
		{
			MethodName: "inviteUserToGroup",
			Handler:    _Group_InviteUserToGroup_Handler,
		},
		{
			MethodName: "getGroups",
			Handler:    _Group_GetGroups_Handler,
		},
		{
			MethodName: "getGroupMembersCMS",
			Handler:    _Group_GetGroupMembersCMS_Handler,
		},
		{
			MethodName: "dismissGroup",
			Handler:    _Group_DismissGroup_Handler,
		},
		{
			MethodName: "muteGroupMember",
			Handler:    _Group_MuteGroupMember_Handler,
		},
		{
			MethodName: "cancelMuteGroupMember",
			Handler:    _Group_CancelMuteGroupMember_Handler,
		},
		{
			MethodName: "muteGroup",
			Handler:    _Group_MuteGroup_Handler,
		},
		{
			MethodName: "cancelMuteGroup",
			Handler:    _Group_CancelMuteGroup_Handler,
		},
		{
			MethodName: "setGroupMemberInfo",
			Handler:    _Group_SetGroupMemberInfo_Handler,
		},
		{
			MethodName: "getGroupAbstractInfo",
			Handler:    _Group_GetGroupAbstractInfo_Handler,
		},
		{
			MethodName: "getUserInGroupMembers",
			Handler:    _Group_GetUserInGroupMembers_Handler,
		},
		{
			MethodName: "getGroupMemberUserIDs",
			Handler:    _Group_GetGroupMemberUserIDs_Handler,
		},
		{
			MethodName: "GetGroupMemberRoleLevel",
			Handler:    _Group_GetGroupMemberRoleLevel_Handler,
		},
		{
			MethodName: "GetGroupInfoCache",
			Handler:    _Group_GetGroupInfoCache_Handler,
		},
		{
			MethodName: "GetGroupMemberCache",
			Handler:    _Group_GetGroupMemberCache_Handler,
		},
		{
			MethodName: "GroupCreateCount",
			Handler:    _Group_GroupCreateCount_Handler,
		},
		{
			MethodName: "NotificationUserInfoUpdate",
			Handler:    _Group_NotificationUserInfoUpdate_Handler,
		},
		{
			MethodName: "getIncrementalGroupMember",
			Handler:    _Group_GetIncrementalGroupMember_Handler,
		},
		{
			MethodName: "BatchGetIncrementalGroupMember",
			Handler:    _Group_BatchGetIncrementalGroupMember_Handler,
		},
		{
			MethodName: "getIncrementalJoinGroup",
			Handler:    _Group_GetIncrementalJoinGroup_Handler,
		},
		{
			MethodName: "GetFullGroupMemberUserIDs",
			Handler:    _Group_GetFullGroupMemberUserIDs_Handler,
		},
		{
			MethodName: "GetFullJoinGroupIDs",
			Handler:    _Group_GetFullJoinGroupIDs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "group/group.proto",
}
