// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.26.0
// source: relation/relation.proto

package relation

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Friend_ApplyToAddFriend_FullMethodName               = "/openim.relation.friend/applyToAddFriend"
	Friend_GetPaginationFriendsApplyTo_FullMethodName    = "/openim.relation.friend/getPaginationFriendsApplyTo"
	Friend_GetPaginationFriendsApplyFrom_FullMethodName  = "/openim.relation.friend/getPaginationFriendsApplyFrom"
	Friend_GetDesignatedFriendsApply_FullMethodName      = "/openim.relation.friend/getDesignatedFriendsApply"
	Friend_GetIncrementalFriendsApplyTo_FullMethodName   = "/openim.relation.friend/getIncrementalFriendsApplyTo"
	Friend_GetIncrementalFriendsApplyFrom_FullMethodName = "/openim.relation.friend/getIncrementalFriendsApplyFrom"
	Friend_AddBlack_FullMethodName                       = "/openim.relation.friend/addBlack"
	Friend_RemoveBlack_FullMethodName                    = "/openim.relation.friend/removeBlack"
	Friend_IsFriend_FullMethodName                       = "/openim.relation.friend/isFriend"
	Friend_IsBlack_FullMethodName                        = "/openim.relation.friend/isBlack"
	Friend_GetPaginationBlacks_FullMethodName            = "/openim.relation.friend/getPaginationBlacks"
	Friend_GetSpecifiedBlacks_FullMethodName             = "/openim.relation.friend/GetSpecifiedBlacks"
	Friend_DeleteFriend_FullMethodName                   = "/openim.relation.friend/deleteFriend"
	Friend_RespondFriendApply_FullMethodName             = "/openim.relation.friend/respondFriendApply"
	Friend_UpdateFriends_FullMethodName                  = "/openim.relation.friend/updateFriends"
	Friend_SetFriendRemark_FullMethodName                = "/openim.relation.friend/setFriendRemark"
	Friend_ImportFriends_FullMethodName                  = "/openim.relation.friend/importFriends"
	Friend_GetDesignatedFriends_FullMethodName           = "/openim.relation.friend/getDesignatedFriends"
	Friend_GetPaginationFriends_FullMethodName           = "/openim.relation.friend/getPaginationFriends"
	Friend_GetFriendIDs_FullMethodName                   = "/openim.relation.friend/getFriendIDs"
	Friend_GetSpecifiedFriendsInfo_FullMethodName        = "/openim.relation.friend/GetSpecifiedFriendsInfo"
	Friend_GetIncrementalFriends_FullMethodName          = "/openim.relation.friend/getIncrementalFriends"
	Friend_GetIncrementalBlacks_FullMethodName           = "/openim.relation.friend/getIncrementalBlacks"
	Friend_GetFullFriendUserIDs_FullMethodName           = "/openim.relation.friend/getFullFriendUserIDs"
	Friend_NotificationUserInfoUpdate_FullMethodName     = "/openim.relation.friend/NotificationUserInfoUpdate"
	Friend_GetFriendInfo_FullMethodName                  = "/openim.relation.friend/getFriendInfo"
)

// FriendClient is the client API for Friend service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FriendClient interface {
	// Friend request
	ApplyToAddFriend(ctx context.Context, in *ApplyToAddFriendReq, opts ...grpc.CallOption) (*ApplyToAddFriendResp, error)
	// Get friend request list
	GetPaginationFriendsApplyTo(ctx context.Context, in *GetPaginationFriendsApplyToReq, opts ...grpc.CallOption) (*GetPaginationFriendsApplyToResp, error)
	// Get sent friend request list
	GetPaginationFriendsApplyFrom(ctx context.Context, in *GetPaginationFriendsApplyFromReq, opts ...grpc.CallOption) (*GetPaginationFriendsApplyFromResp, error)
	// Get specified friend request
	GetDesignatedFriendsApply(ctx context.Context, in *GetDesignatedFriendsApplyReq, opts ...grpc.CallOption) (*GetDesignatedFriendsApplyResp, error)
	// Get Incremental friends apply to list
	GetIncrementalFriendsApplyTo(ctx context.Context, in *GetIncrementalFriendsApplyToReq, opts ...grpc.CallOption) (*GetIncrementalFriendsApplyToResp, error)
	// Get Incremental friends apply from list
	GetIncrementalFriendsApplyFrom(ctx context.Context, in *GetIncrementalFriendsApplyFromReq, opts ...grpc.CallOption) (*GetIncrementalFriendsApplyFromResp, error)
	// Add black user
	AddBlack(ctx context.Context, in *AddBlackReq, opts ...grpc.CallOption) (*AddBlackResp, error)
	// Remove black user
	RemoveBlack(ctx context.Context, in *RemoveBlackReq, opts ...grpc.CallOption) (*RemoveBlackResp, error)
	// Check user is in friends list
	IsFriend(ctx context.Context, in *IsFriendReq, opts ...grpc.CallOption) (*IsFriendResp, error)
	// Check user is blacklist
	IsBlack(ctx context.Context, in *IsBlackReq, opts ...grpc.CallOption) (*IsBlackResp, error)
	// Get blacklist
	GetPaginationBlacks(ctx context.Context, in *GetPaginationBlacksReq, opts ...grpc.CallOption) (*GetPaginationBlacksResp, error)
	// Get specified blacklist
	GetSpecifiedBlacks(ctx context.Context, in *GetSpecifiedBlacksReq, opts ...grpc.CallOption) (*GetSpecifiedBlacksResp, error)
	// Delete friend
	DeleteFriend(ctx context.Context, in *DeleteFriendReq, opts ...grpc.CallOption) (*DeleteFriendResp, error)
	// Respond to friend request (Accept or Decline)
	RespondFriendApply(ctx context.Context, in *RespondFriendApplyReq, opts ...grpc.CallOption) (*RespondFriendApplyResp, error)
	// Favorited friend
	UpdateFriends(ctx context.Context, in *UpdateFriendsReq, opts ...grpc.CallOption) (*UpdateFriendsResp, error)
	// Set friend nickname
	SetFriendRemark(ctx context.Context, in *SetFriendRemarkReq, opts ...grpc.CallOption) (*SetFriendRemarkResp, error)
	// Import friends relationship
	ImportFriends(ctx context.Context, in *ImportFriendReq, opts ...grpc.CallOption) (*ImportFriendResp, error)
	// Paginate and retrieve friend list; do not return error if no results.
	GetDesignatedFriends(ctx context.Context, in *GetDesignatedFriendsReq, opts ...grpc.CallOption) (*GetDesignatedFriendsResp, error)
	// Get specified friend's information; return error if ID does not exist.
	GetPaginationFriends(ctx context.Context, in *GetPaginationFriendsReq, opts ...grpc.CallOption) (*GetPaginationFriendsResp, error)
	// Get friend IDs list
	GetFriendIDs(ctx context.Context, in *GetFriendIDsReq, opts ...grpc.CallOption) (*GetFriendIDsResp, error)
	// Get specified friends info
	GetSpecifiedFriendsInfo(ctx context.Context, in *GetSpecifiedFriendsInfoReq, opts ...grpc.CallOption) (*GetSpecifiedFriendsInfoResp, error)
	GetIncrementalFriends(ctx context.Context, in *GetIncrementalFriendsReq, opts ...grpc.CallOption) (*GetIncrementalFriendsResp, error)
	// Get Incremental blackslist
	GetIncrementalBlacks(ctx context.Context, in *GetIncrementalBlacksReq, opts ...grpc.CallOption) (*GetIncrementalBlacksResp, error)
	// Get full friend userIDs
	GetFullFriendUserIDs(ctx context.Context, in *GetFullFriendUserIDsReq, opts ...grpc.CallOption) (*GetFullFriendUserIDsResp, error)
	NotificationUserInfoUpdate(ctx context.Context, in *NotificationUserInfoUpdateReq, opts ...grpc.CallOption) (*NotificationUserInfoUpdateResp, error)
	GetFriendInfo(ctx context.Context, in *GetFriendInfoReq, opts ...grpc.CallOption) (*GetFriendInfoResp, error)
}

type friendClient struct {
	cc grpc.ClientConnInterface
}

func NewFriendClient(cc grpc.ClientConnInterface) FriendClient {
	return &friendClient{cc}
}

func (c *friendClient) ApplyToAddFriend(ctx context.Context, in *ApplyToAddFriendReq, opts ...grpc.CallOption) (*ApplyToAddFriendResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ApplyToAddFriendResp)
	err := c.cc.Invoke(ctx, Friend_ApplyToAddFriend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetPaginationFriendsApplyTo(ctx context.Context, in *GetPaginationFriendsApplyToReq, opts ...grpc.CallOption) (*GetPaginationFriendsApplyToResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPaginationFriendsApplyToResp)
	err := c.cc.Invoke(ctx, Friend_GetPaginationFriendsApplyTo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetPaginationFriendsApplyFrom(ctx context.Context, in *GetPaginationFriendsApplyFromReq, opts ...grpc.CallOption) (*GetPaginationFriendsApplyFromResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPaginationFriendsApplyFromResp)
	err := c.cc.Invoke(ctx, Friend_GetPaginationFriendsApplyFrom_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetDesignatedFriendsApply(ctx context.Context, in *GetDesignatedFriendsApplyReq, opts ...grpc.CallOption) (*GetDesignatedFriendsApplyResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDesignatedFriendsApplyResp)
	err := c.cc.Invoke(ctx, Friend_GetDesignatedFriendsApply_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetIncrementalFriendsApplyTo(ctx context.Context, in *GetIncrementalFriendsApplyToReq, opts ...grpc.CallOption) (*GetIncrementalFriendsApplyToResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalFriendsApplyToResp)
	err := c.cc.Invoke(ctx, Friend_GetIncrementalFriendsApplyTo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetIncrementalFriendsApplyFrom(ctx context.Context, in *GetIncrementalFriendsApplyFromReq, opts ...grpc.CallOption) (*GetIncrementalFriendsApplyFromResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalFriendsApplyFromResp)
	err := c.cc.Invoke(ctx, Friend_GetIncrementalFriendsApplyFrom_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) AddBlack(ctx context.Context, in *AddBlackReq, opts ...grpc.CallOption) (*AddBlackResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AddBlackResp)
	err := c.cc.Invoke(ctx, Friend_AddBlack_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) RemoveBlack(ctx context.Context, in *RemoveBlackReq, opts ...grpc.CallOption) (*RemoveBlackResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RemoveBlackResp)
	err := c.cc.Invoke(ctx, Friend_RemoveBlack_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) IsFriend(ctx context.Context, in *IsFriendReq, opts ...grpc.CallOption) (*IsFriendResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsFriendResp)
	err := c.cc.Invoke(ctx, Friend_IsFriend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) IsBlack(ctx context.Context, in *IsBlackReq, opts ...grpc.CallOption) (*IsBlackResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsBlackResp)
	err := c.cc.Invoke(ctx, Friend_IsBlack_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetPaginationBlacks(ctx context.Context, in *GetPaginationBlacksReq, opts ...grpc.CallOption) (*GetPaginationBlacksResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPaginationBlacksResp)
	err := c.cc.Invoke(ctx, Friend_GetPaginationBlacks_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetSpecifiedBlacks(ctx context.Context, in *GetSpecifiedBlacksReq, opts ...grpc.CallOption) (*GetSpecifiedBlacksResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSpecifiedBlacksResp)
	err := c.cc.Invoke(ctx, Friend_GetSpecifiedBlacks_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) DeleteFriend(ctx context.Context, in *DeleteFriendReq, opts ...grpc.CallOption) (*DeleteFriendResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteFriendResp)
	err := c.cc.Invoke(ctx, Friend_DeleteFriend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) RespondFriendApply(ctx context.Context, in *RespondFriendApplyReq, opts ...grpc.CallOption) (*RespondFriendApplyResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RespondFriendApplyResp)
	err := c.cc.Invoke(ctx, Friend_RespondFriendApply_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) UpdateFriends(ctx context.Context, in *UpdateFriendsReq, opts ...grpc.CallOption) (*UpdateFriendsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateFriendsResp)
	err := c.cc.Invoke(ctx, Friend_UpdateFriends_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) SetFriendRemark(ctx context.Context, in *SetFriendRemarkReq, opts ...grpc.CallOption) (*SetFriendRemarkResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetFriendRemarkResp)
	err := c.cc.Invoke(ctx, Friend_SetFriendRemark_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) ImportFriends(ctx context.Context, in *ImportFriendReq, opts ...grpc.CallOption) (*ImportFriendResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ImportFriendResp)
	err := c.cc.Invoke(ctx, Friend_ImportFriends_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetDesignatedFriends(ctx context.Context, in *GetDesignatedFriendsReq, opts ...grpc.CallOption) (*GetDesignatedFriendsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDesignatedFriendsResp)
	err := c.cc.Invoke(ctx, Friend_GetDesignatedFriends_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetPaginationFriends(ctx context.Context, in *GetPaginationFriendsReq, opts ...grpc.CallOption) (*GetPaginationFriendsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPaginationFriendsResp)
	err := c.cc.Invoke(ctx, Friend_GetPaginationFriends_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetFriendIDs(ctx context.Context, in *GetFriendIDsReq, opts ...grpc.CallOption) (*GetFriendIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFriendIDsResp)
	err := c.cc.Invoke(ctx, Friend_GetFriendIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetSpecifiedFriendsInfo(ctx context.Context, in *GetSpecifiedFriendsInfoReq, opts ...grpc.CallOption) (*GetSpecifiedFriendsInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSpecifiedFriendsInfoResp)
	err := c.cc.Invoke(ctx, Friend_GetSpecifiedFriendsInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetIncrementalFriends(ctx context.Context, in *GetIncrementalFriendsReq, opts ...grpc.CallOption) (*GetIncrementalFriendsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalFriendsResp)
	err := c.cc.Invoke(ctx, Friend_GetIncrementalFriends_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetIncrementalBlacks(ctx context.Context, in *GetIncrementalBlacksReq, opts ...grpc.CallOption) (*GetIncrementalBlacksResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalBlacksResp)
	err := c.cc.Invoke(ctx, Friend_GetIncrementalBlacks_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetFullFriendUserIDs(ctx context.Context, in *GetFullFriendUserIDsReq, opts ...grpc.CallOption) (*GetFullFriendUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFullFriendUserIDsResp)
	err := c.cc.Invoke(ctx, Friend_GetFullFriendUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) NotificationUserInfoUpdate(ctx context.Context, in *NotificationUserInfoUpdateReq, opts ...grpc.CallOption) (*NotificationUserInfoUpdateResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NotificationUserInfoUpdateResp)
	err := c.cc.Invoke(ctx, Friend_NotificationUserInfoUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *friendClient) GetFriendInfo(ctx context.Context, in *GetFriendInfoReq, opts ...grpc.CallOption) (*GetFriendInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFriendInfoResp)
	err := c.cc.Invoke(ctx, Friend_GetFriendInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FriendServer is the server API for Friend service.
// All implementations must embed UnimplementedFriendServer
// for forward compatibility.
type FriendServer interface {
	// Friend request
	ApplyToAddFriend(context.Context, *ApplyToAddFriendReq) (*ApplyToAddFriendResp, error)
	// Get friend request list
	GetPaginationFriendsApplyTo(context.Context, *GetPaginationFriendsApplyToReq) (*GetPaginationFriendsApplyToResp, error)
	// Get sent friend request list
	GetPaginationFriendsApplyFrom(context.Context, *GetPaginationFriendsApplyFromReq) (*GetPaginationFriendsApplyFromResp, error)
	// Get specified friend request
	GetDesignatedFriendsApply(context.Context, *GetDesignatedFriendsApplyReq) (*GetDesignatedFriendsApplyResp, error)
	// Get Incremental friends apply to list
	GetIncrementalFriendsApplyTo(context.Context, *GetIncrementalFriendsApplyToReq) (*GetIncrementalFriendsApplyToResp, error)
	// Get Incremental friends apply from list
	GetIncrementalFriendsApplyFrom(context.Context, *GetIncrementalFriendsApplyFromReq) (*GetIncrementalFriendsApplyFromResp, error)
	// Add black user
	AddBlack(context.Context, *AddBlackReq) (*AddBlackResp, error)
	// Remove black user
	RemoveBlack(context.Context, *RemoveBlackReq) (*RemoveBlackResp, error)
	// Check user is in friends list
	IsFriend(context.Context, *IsFriendReq) (*IsFriendResp, error)
	// Check user is blacklist
	IsBlack(context.Context, *IsBlackReq) (*IsBlackResp, error)
	// Get blacklist
	GetPaginationBlacks(context.Context, *GetPaginationBlacksReq) (*GetPaginationBlacksResp, error)
	// Get specified blacklist
	GetSpecifiedBlacks(context.Context, *GetSpecifiedBlacksReq) (*GetSpecifiedBlacksResp, error)
	// Delete friend
	DeleteFriend(context.Context, *DeleteFriendReq) (*DeleteFriendResp, error)
	// Respond to friend request (Accept or Decline)
	RespondFriendApply(context.Context, *RespondFriendApplyReq) (*RespondFriendApplyResp, error)
	// Favorited friend
	UpdateFriends(context.Context, *UpdateFriendsReq) (*UpdateFriendsResp, error)
	// Set friend nickname
	SetFriendRemark(context.Context, *SetFriendRemarkReq) (*SetFriendRemarkResp, error)
	// Import friends relationship
	ImportFriends(context.Context, *ImportFriendReq) (*ImportFriendResp, error)
	// Paginate and retrieve friend list; do not return error if no results.
	GetDesignatedFriends(context.Context, *GetDesignatedFriendsReq) (*GetDesignatedFriendsResp, error)
	// Get specified friend's information; return error if ID does not exist.
	GetPaginationFriends(context.Context, *GetPaginationFriendsReq) (*GetPaginationFriendsResp, error)
	// Get friend IDs list
	GetFriendIDs(context.Context, *GetFriendIDsReq) (*GetFriendIDsResp, error)
	// Get specified friends info
	GetSpecifiedFriendsInfo(context.Context, *GetSpecifiedFriendsInfoReq) (*GetSpecifiedFriendsInfoResp, error)
	GetIncrementalFriends(context.Context, *GetIncrementalFriendsReq) (*GetIncrementalFriendsResp, error)
	// Get Incremental blackslist
	GetIncrementalBlacks(context.Context, *GetIncrementalBlacksReq) (*GetIncrementalBlacksResp, error)
	// Get full friend userIDs
	GetFullFriendUserIDs(context.Context, *GetFullFriendUserIDsReq) (*GetFullFriendUserIDsResp, error)
	NotificationUserInfoUpdate(context.Context, *NotificationUserInfoUpdateReq) (*NotificationUserInfoUpdateResp, error)
	GetFriendInfo(context.Context, *GetFriendInfoReq) (*GetFriendInfoResp, error)
	mustEmbedUnimplementedFriendServer()
}

// UnimplementedFriendServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedFriendServer struct{}

func (UnimplementedFriendServer) ApplyToAddFriend(context.Context, *ApplyToAddFriendReq) (*ApplyToAddFriendResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyToAddFriend not implemented")
}
func (UnimplementedFriendServer) GetPaginationFriendsApplyTo(context.Context, *GetPaginationFriendsApplyToReq) (*GetPaginationFriendsApplyToResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaginationFriendsApplyTo not implemented")
}
func (UnimplementedFriendServer) GetPaginationFriendsApplyFrom(context.Context, *GetPaginationFriendsApplyFromReq) (*GetPaginationFriendsApplyFromResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaginationFriendsApplyFrom not implemented")
}
func (UnimplementedFriendServer) GetDesignatedFriendsApply(context.Context, *GetDesignatedFriendsApplyReq) (*GetDesignatedFriendsApplyResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDesignatedFriendsApply not implemented")
}
func (UnimplementedFriendServer) GetIncrementalFriendsApplyTo(context.Context, *GetIncrementalFriendsApplyToReq) (*GetIncrementalFriendsApplyToResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalFriendsApplyTo not implemented")
}
func (UnimplementedFriendServer) GetIncrementalFriendsApplyFrom(context.Context, *GetIncrementalFriendsApplyFromReq) (*GetIncrementalFriendsApplyFromResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalFriendsApplyFrom not implemented")
}
func (UnimplementedFriendServer) AddBlack(context.Context, *AddBlackReq) (*AddBlackResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddBlack not implemented")
}
func (UnimplementedFriendServer) RemoveBlack(context.Context, *RemoveBlackReq) (*RemoveBlackResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveBlack not implemented")
}
func (UnimplementedFriendServer) IsFriend(context.Context, *IsFriendReq) (*IsFriendResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsFriend not implemented")
}
func (UnimplementedFriendServer) IsBlack(context.Context, *IsBlackReq) (*IsBlackResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsBlack not implemented")
}
func (UnimplementedFriendServer) GetPaginationBlacks(context.Context, *GetPaginationBlacksReq) (*GetPaginationBlacksResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaginationBlacks not implemented")
}
func (UnimplementedFriendServer) GetSpecifiedBlacks(context.Context, *GetSpecifiedBlacksReq) (*GetSpecifiedBlacksResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecifiedBlacks not implemented")
}
func (UnimplementedFriendServer) DeleteFriend(context.Context, *DeleteFriendReq) (*DeleteFriendResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFriend not implemented")
}
func (UnimplementedFriendServer) RespondFriendApply(context.Context, *RespondFriendApplyReq) (*RespondFriendApplyResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondFriendApply not implemented")
}
func (UnimplementedFriendServer) UpdateFriends(context.Context, *UpdateFriendsReq) (*UpdateFriendsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFriends not implemented")
}
func (UnimplementedFriendServer) SetFriendRemark(context.Context, *SetFriendRemarkReq) (*SetFriendRemarkResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFriendRemark not implemented")
}
func (UnimplementedFriendServer) ImportFriends(context.Context, *ImportFriendReq) (*ImportFriendResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportFriends not implemented")
}
func (UnimplementedFriendServer) GetDesignatedFriends(context.Context, *GetDesignatedFriendsReq) (*GetDesignatedFriendsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDesignatedFriends not implemented")
}
func (UnimplementedFriendServer) GetPaginationFriends(context.Context, *GetPaginationFriendsReq) (*GetPaginationFriendsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaginationFriends not implemented")
}
func (UnimplementedFriendServer) GetFriendIDs(context.Context, *GetFriendIDsReq) (*GetFriendIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFriendIDs not implemented")
}
func (UnimplementedFriendServer) GetSpecifiedFriendsInfo(context.Context, *GetSpecifiedFriendsInfoReq) (*GetSpecifiedFriendsInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecifiedFriendsInfo not implemented")
}
func (UnimplementedFriendServer) GetIncrementalFriends(context.Context, *GetIncrementalFriendsReq) (*GetIncrementalFriendsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalFriends not implemented")
}
func (UnimplementedFriendServer) GetIncrementalBlacks(context.Context, *GetIncrementalBlacksReq) (*GetIncrementalBlacksResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalBlacks not implemented")
}
func (UnimplementedFriendServer) GetFullFriendUserIDs(context.Context, *GetFullFriendUserIDsReq) (*GetFullFriendUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFullFriendUserIDs not implemented")
}
func (UnimplementedFriendServer) NotificationUserInfoUpdate(context.Context, *NotificationUserInfoUpdateReq) (*NotificationUserInfoUpdateResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NotificationUserInfoUpdate not implemented")
}
func (UnimplementedFriendServer) GetFriendInfo(context.Context, *GetFriendInfoReq) (*GetFriendInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFriendInfo not implemented")
}
func (UnimplementedFriendServer) mustEmbedUnimplementedFriendServer() {}
func (UnimplementedFriendServer) testEmbeddedByValue()                {}

// UnsafeFriendServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FriendServer will
// result in compilation errors.
type UnsafeFriendServer interface {
	mustEmbedUnimplementedFriendServer()
}

func RegisterFriendServer(s grpc.ServiceRegistrar, srv FriendServer) {
	// If the following call pancis, it indicates UnimplementedFriendServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Friend_ServiceDesc, srv)
}

func _Friend_ApplyToAddFriend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyToAddFriendReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).ApplyToAddFriend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_ApplyToAddFriend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).ApplyToAddFriend(ctx, req.(*ApplyToAddFriendReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetPaginationFriendsApplyTo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPaginationFriendsApplyToReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetPaginationFriendsApplyTo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetPaginationFriendsApplyTo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetPaginationFriendsApplyTo(ctx, req.(*GetPaginationFriendsApplyToReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetPaginationFriendsApplyFrom_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPaginationFriendsApplyFromReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetPaginationFriendsApplyFrom(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetPaginationFriendsApplyFrom_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetPaginationFriendsApplyFrom(ctx, req.(*GetPaginationFriendsApplyFromReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetDesignatedFriendsApply_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDesignatedFriendsApplyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetDesignatedFriendsApply(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetDesignatedFriendsApply_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetDesignatedFriendsApply(ctx, req.(*GetDesignatedFriendsApplyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetIncrementalFriendsApplyTo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalFriendsApplyToReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetIncrementalFriendsApplyTo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetIncrementalFriendsApplyTo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetIncrementalFriendsApplyTo(ctx, req.(*GetIncrementalFriendsApplyToReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetIncrementalFriendsApplyFrom_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalFriendsApplyFromReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetIncrementalFriendsApplyFrom(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetIncrementalFriendsApplyFrom_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetIncrementalFriendsApplyFrom(ctx, req.(*GetIncrementalFriendsApplyFromReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_AddBlack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddBlackReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).AddBlack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_AddBlack_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).AddBlack(ctx, req.(*AddBlackReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_RemoveBlack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveBlackReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).RemoveBlack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_RemoveBlack_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).RemoveBlack(ctx, req.(*RemoveBlackReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_IsFriend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsFriendReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).IsFriend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_IsFriend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).IsFriend(ctx, req.(*IsFriendReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_IsBlack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsBlackReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).IsBlack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_IsBlack_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).IsBlack(ctx, req.(*IsBlackReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetPaginationBlacks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPaginationBlacksReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetPaginationBlacks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetPaginationBlacks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetPaginationBlacks(ctx, req.(*GetPaginationBlacksReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetSpecifiedBlacks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecifiedBlacksReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetSpecifiedBlacks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetSpecifiedBlacks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetSpecifiedBlacks(ctx, req.(*GetSpecifiedBlacksReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_DeleteFriend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFriendReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).DeleteFriend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_DeleteFriend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).DeleteFriend(ctx, req.(*DeleteFriendReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_RespondFriendApply_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondFriendApplyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).RespondFriendApply(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_RespondFriendApply_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).RespondFriendApply(ctx, req.(*RespondFriendApplyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_UpdateFriends_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFriendsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).UpdateFriends(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_UpdateFriends_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).UpdateFriends(ctx, req.(*UpdateFriendsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_SetFriendRemark_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFriendRemarkReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).SetFriendRemark(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_SetFriendRemark_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).SetFriendRemark(ctx, req.(*SetFriendRemarkReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_ImportFriends_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportFriendReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).ImportFriends(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_ImportFriends_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).ImportFriends(ctx, req.(*ImportFriendReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetDesignatedFriends_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDesignatedFriendsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetDesignatedFriends(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetDesignatedFriends_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetDesignatedFriends(ctx, req.(*GetDesignatedFriendsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetPaginationFriends_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPaginationFriendsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetPaginationFriends(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetPaginationFriends_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetPaginationFriends(ctx, req.(*GetPaginationFriendsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetFriendIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFriendIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetFriendIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetFriendIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetFriendIDs(ctx, req.(*GetFriendIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetSpecifiedFriendsInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecifiedFriendsInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetSpecifiedFriendsInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetSpecifiedFriendsInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetSpecifiedFriendsInfo(ctx, req.(*GetSpecifiedFriendsInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetIncrementalFriends_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalFriendsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetIncrementalFriends(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetIncrementalFriends_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetIncrementalFriends(ctx, req.(*GetIncrementalFriendsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetIncrementalBlacks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalBlacksReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetIncrementalBlacks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetIncrementalBlacks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetIncrementalBlacks(ctx, req.(*GetIncrementalBlacksReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetFullFriendUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFullFriendUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetFullFriendUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetFullFriendUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetFullFriendUserIDs(ctx, req.(*GetFullFriendUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_NotificationUserInfoUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NotificationUserInfoUpdateReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).NotificationUserInfoUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_NotificationUserInfoUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).NotificationUserInfoUpdate(ctx, req.(*NotificationUserInfoUpdateReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Friend_GetFriendInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFriendInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FriendServer).GetFriendInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Friend_GetFriendInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FriendServer).GetFriendInfo(ctx, req.(*GetFriendInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Friend_ServiceDesc is the grpc.ServiceDesc for Friend service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Friend_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openim.relation.friend",
	HandlerType: (*FriendServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "applyToAddFriend",
			Handler:    _Friend_ApplyToAddFriend_Handler,
		},
		{
			MethodName: "getPaginationFriendsApplyTo",
			Handler:    _Friend_GetPaginationFriendsApplyTo_Handler,
		},
		{
			MethodName: "getPaginationFriendsApplyFrom",
			Handler:    _Friend_GetPaginationFriendsApplyFrom_Handler,
		},
		{
			MethodName: "getDesignatedFriendsApply",
			Handler:    _Friend_GetDesignatedFriendsApply_Handler,
		},
		{
			MethodName: "getIncrementalFriendsApplyTo",
			Handler:    _Friend_GetIncrementalFriendsApplyTo_Handler,
		},
		{
			MethodName: "getIncrementalFriendsApplyFrom",
			Handler:    _Friend_GetIncrementalFriendsApplyFrom_Handler,
		},
		{
			MethodName: "addBlack",
			Handler:    _Friend_AddBlack_Handler,
		},
		{
			MethodName: "removeBlack",
			Handler:    _Friend_RemoveBlack_Handler,
		},
		{
			MethodName: "isFriend",
			Handler:    _Friend_IsFriend_Handler,
		},
		{
			MethodName: "isBlack",
			Handler:    _Friend_IsBlack_Handler,
		},
		{
			MethodName: "getPaginationBlacks",
			Handler:    _Friend_GetPaginationBlacks_Handler,
		},
		{
			MethodName: "GetSpecifiedBlacks",
			Handler:    _Friend_GetSpecifiedBlacks_Handler,
		},
		{
			MethodName: "deleteFriend",
			Handler:    _Friend_DeleteFriend_Handler,
		},
		{
			MethodName: "respondFriendApply",
			Handler:    _Friend_RespondFriendApply_Handler,
		},
		{
			MethodName: "updateFriends",
			Handler:    _Friend_UpdateFriends_Handler,
		},
		{
			MethodName: "setFriendRemark",
			Handler:    _Friend_SetFriendRemark_Handler,
		},
		{
			MethodName: "importFriends",
			Handler:    _Friend_ImportFriends_Handler,
		},
		{
			MethodName: "getDesignatedFriends",
			Handler:    _Friend_GetDesignatedFriends_Handler,
		},
		{
			MethodName: "getPaginationFriends",
			Handler:    _Friend_GetPaginationFriends_Handler,
		},
		{
			MethodName: "getFriendIDs",
			Handler:    _Friend_GetFriendIDs_Handler,
		},
		{
			MethodName: "GetSpecifiedFriendsInfo",
			Handler:    _Friend_GetSpecifiedFriendsInfo_Handler,
		},
		{
			MethodName: "getIncrementalFriends",
			Handler:    _Friend_GetIncrementalFriends_Handler,
		},
		{
			MethodName: "getIncrementalBlacks",
			Handler:    _Friend_GetIncrementalBlacks_Handler,
		},
		{
			MethodName: "getFullFriendUserIDs",
			Handler:    _Friend_GetFullFriendUserIDs_Handler,
		},
		{
			MethodName: "NotificationUserInfoUpdate",
			Handler:    _Friend_NotificationUserInfoUpdate_Handler,
		},
		{
			MethodName: "getFriendInfo",
			Handler:    _Friend_GetFriendInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "relation/relation.proto",
}
