// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.2
// 	protoc        v5.26.0
// source: group/group.proto

package group

import (
	sdkws "github.com/openimsdk/protocol/sdkws"
	wrapperspb "github.com/openimsdk/protocol/wrapperspb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MemberUserIDs []string               `protobuf:"bytes,1,rep,name=memberUserIDs,proto3" json:"memberUserIDs"`
	GroupInfo     *sdkws.GroupInfo       `protobuf:"bytes,2,opt,name=groupInfo,proto3" json:"groupInfo"`
	AdminUserIDs  []string               `protobuf:"bytes,3,rep,name=adminUserIDs,proto3" json:"adminUserIDs"`
	OwnerUserID   string                 `protobuf:"bytes,4,opt,name=ownerUserID,proto3" json:"ownerUserID"` //owner
	SendMessage   *bool                  `protobuf:"varint,5,opt,name=sendMessage,proto3,oneof" json:"sendMessage"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGroupReq) Reset() {
	*x = CreateGroupReq{}
	mi := &file_group_group_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupReq) ProtoMessage() {}

func (x *CreateGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupReq.ProtoReflect.Descriptor instead.
func (*CreateGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{0}
}

func (x *CreateGroupReq) GetMemberUserIDs() []string {
	if x != nil {
		return x.MemberUserIDs
	}
	return nil
}

func (x *CreateGroupReq) GetGroupInfo() *sdkws.GroupInfo {
	if x != nil {
		return x.GroupInfo
	}
	return nil
}

func (x *CreateGroupReq) GetAdminUserIDs() []string {
	if x != nil {
		return x.AdminUserIDs
	}
	return nil
}

func (x *CreateGroupReq) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *CreateGroupReq) GetSendMessage() bool {
	if x != nil && x.SendMessage != nil {
		return *x.SendMessage
	}
	return false
}

type CreateGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInfo     *sdkws.GroupInfo       `protobuf:"bytes,1,opt,name=groupInfo,proto3" json:"groupInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGroupResp) Reset() {
	*x = CreateGroupResp{}
	mi := &file_group_group_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupResp) ProtoMessage() {}

func (x *CreateGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupResp.ProtoReflect.Descriptor instead.
func (*CreateGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{1}
}

func (x *CreateGroupResp) GetGroupInfo() *sdkws.GroupInfo {
	if x != nil {
		return x.GroupInfo
	}
	return nil
}

type GetGroupsInfoReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupIDs      []string               `protobuf:"bytes,1,rep,name=groupIDs,proto3" json:"groupIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupsInfoReq) Reset() {
	*x = GetGroupsInfoReq{}
	mi := &file_group_group_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupsInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupsInfoReq) ProtoMessage() {}

func (x *GetGroupsInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupsInfoReq.ProtoReflect.Descriptor instead.
func (*GetGroupsInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{2}
}

func (x *GetGroupsInfoReq) GetGroupIDs() []string {
	if x != nil {
		return x.GroupIDs
	}
	return nil
}

type GetGroupsInfoResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInfos    []*sdkws.GroupInfo     `protobuf:"bytes,1,rep,name=groupInfos,proto3" json:"groupInfos"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupsInfoResp) Reset() {
	*x = GetGroupsInfoResp{}
	mi := &file_group_group_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupsInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupsInfoResp) ProtoMessage() {}

func (x *GetGroupsInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupsInfoResp.ProtoReflect.Descriptor instead.
func (*GetGroupsInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{3}
}

func (x *GetGroupsInfoResp) GetGroupInfos() []*sdkws.GroupInfo {
	if x != nil {
		return x.GroupInfos
	}
	return nil
}

type SetGroupInfoReq struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	GroupInfoForSet *sdkws.GroupInfoForSet `protobuf:"bytes,1,opt,name=groupInfoForSet,proto3" json:"groupInfoForSet"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SetGroupInfoReq) Reset() {
	*x = SetGroupInfoReq{}
	mi := &file_group_group_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupInfoReq) ProtoMessage() {}

func (x *SetGroupInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupInfoReq.ProtoReflect.Descriptor instead.
func (*SetGroupInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{4}
}

func (x *SetGroupInfoReq) GetGroupInfoForSet() *sdkws.GroupInfoForSet {
	if x != nil {
		return x.GroupInfoForSet
	}
	return nil
}

type SetGroupInfoResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetGroupInfoResp) Reset() {
	*x = SetGroupInfoResp{}
	mi := &file_group_group_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupInfoResp) ProtoMessage() {}

func (x *SetGroupInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupInfoResp.ProtoReflect.Descriptor instead.
func (*SetGroupInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{5}
}

type SetGroupInfoExReq struct {
	state             protoimpl.MessageState  `protogen:"open.v1"`
	GroupID           string                  `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	GroupName         *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=groupName,proto3" json:"groupName"`
	Notification      *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=notification,proto3" json:"notification"`
	Introduction      *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=introduction,proto3" json:"introduction"`
	FaceURL           *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=faceURL,proto3" json:"faceURL"`
	Ex                *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=ex,proto3" json:"ex"`
	NeedVerification  *wrapperspb.Int32Value  `protobuf:"bytes,7,opt,name=needVerification,proto3" json:"needVerification"`
	LookMemberInfo    *wrapperspb.Int32Value  `protobuf:"bytes,8,opt,name=lookMemberInfo,proto3" json:"lookMemberInfo"`
	ApplyMemberFriend *wrapperspb.Int32Value  `protobuf:"bytes,9,opt,name=applyMemberFriend,proto3" json:"applyMemberFriend"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SetGroupInfoExReq) Reset() {
	*x = SetGroupInfoExReq{}
	mi := &file_group_group_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupInfoExReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupInfoExReq) ProtoMessage() {}

func (x *SetGroupInfoExReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupInfoExReq.ProtoReflect.Descriptor instead.
func (*SetGroupInfoExReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{6}
}

func (x *SetGroupInfoExReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *SetGroupInfoExReq) GetGroupName() *wrapperspb.StringValue {
	if x != nil {
		return x.GroupName
	}
	return nil
}

func (x *SetGroupInfoExReq) GetNotification() *wrapperspb.StringValue {
	if x != nil {
		return x.Notification
	}
	return nil
}

func (x *SetGroupInfoExReq) GetIntroduction() *wrapperspb.StringValue {
	if x != nil {
		return x.Introduction
	}
	return nil
}

func (x *SetGroupInfoExReq) GetFaceURL() *wrapperspb.StringValue {
	if x != nil {
		return x.FaceURL
	}
	return nil
}

func (x *SetGroupInfoExReq) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

func (x *SetGroupInfoExReq) GetNeedVerification() *wrapperspb.Int32Value {
	if x != nil {
		return x.NeedVerification
	}
	return nil
}

func (x *SetGroupInfoExReq) GetLookMemberInfo() *wrapperspb.Int32Value {
	if x != nil {
		return x.LookMemberInfo
	}
	return nil
}

func (x *SetGroupInfoExReq) GetApplyMemberFriend() *wrapperspb.Int32Value {
	if x != nil {
		return x.ApplyMemberFriend
	}
	return nil
}

type SetGroupInfoExResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetGroupInfoExResp) Reset() {
	*x = SetGroupInfoExResp{}
	mi := &file_group_group_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupInfoExResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupInfoExResp) ProtoMessage() {}

func (x *SetGroupInfoExResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupInfoExResp.ProtoReflect.Descriptor instead.
func (*SetGroupInfoExResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{7}
}

type GetGroupApplicationListReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	FromUserID    string                   `protobuf:"bytes,2,opt,name=fromUserID,proto3" json:"fromUserID"` //owner or admin
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupApplicationListReq) Reset() {
	*x = GetGroupApplicationListReq{}
	mi := &file_group_group_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupApplicationListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupApplicationListReq) ProtoMessage() {}

func (x *GetGroupApplicationListReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupApplicationListReq.ProtoReflect.Descriptor instead.
func (*GetGroupApplicationListReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{8}
}

func (x *GetGroupApplicationListReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetGroupApplicationListReq) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

type GetGroupApplicationListResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         uint32                 `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	GroupRequests []*sdkws.GroupRequest  `protobuf:"bytes,2,rep,name=groupRequests,proto3" json:"groupRequests"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupApplicationListResp) Reset() {
	*x = GetGroupApplicationListResp{}
	mi := &file_group_group_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupApplicationListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupApplicationListResp) ProtoMessage() {}

func (x *GetGroupApplicationListResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupApplicationListResp.ProtoReflect.Descriptor instead.
func (*GetGroupApplicationListResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{9}
}

func (x *GetGroupApplicationListResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetGroupApplicationListResp) GetGroupRequests() []*sdkws.GroupRequest {
	if x != nil {
		return x.GroupRequests
	}
	return nil
}

type GetUserReqApplicationListReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	UserID        string                   `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserReqApplicationListReq) Reset() {
	*x = GetUserReqApplicationListReq{}
	mi := &file_group_group_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserReqApplicationListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserReqApplicationListReq) ProtoMessage() {}

func (x *GetUserReqApplicationListReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserReqApplicationListReq.ProtoReflect.Descriptor instead.
func (*GetUserReqApplicationListReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{10}
}

func (x *GetUserReqApplicationListReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetUserReqApplicationListReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetUserReqApplicationListResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         uint32                 `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	GroupRequests []*sdkws.GroupRequest  `protobuf:"bytes,2,rep,name=groupRequests,proto3" json:"groupRequests"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserReqApplicationListResp) Reset() {
	*x = GetUserReqApplicationListResp{}
	mi := &file_group_group_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserReqApplicationListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserReqApplicationListResp) ProtoMessage() {}

func (x *GetUserReqApplicationListResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserReqApplicationListResp.ProtoReflect.Descriptor instead.
func (*GetUserReqApplicationListResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{11}
}

func (x *GetUserReqApplicationListResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetUserReqApplicationListResp) GetGroupRequests() []*sdkws.GroupRequest {
	if x != nil {
		return x.GroupRequests
	}
	return nil
}

type GetSpecifiedUserGroupRequestInfoReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetSpecifiedUserGroupRequestInfoReq) Reset() {
	*x = GetSpecifiedUserGroupRequestInfoReq{}
	mi := &file_group_group_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpecifiedUserGroupRequestInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecifiedUserGroupRequestInfoReq) ProtoMessage() {}

func (x *GetSpecifiedUserGroupRequestInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecifiedUserGroupRequestInfoReq.ProtoReflect.Descriptor instead.
func (*GetSpecifiedUserGroupRequestInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{12}
}

func (x *GetSpecifiedUserGroupRequestInfoReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetSpecifiedUserGroupRequestInfoReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetSpecifiedUserGroupRequestInfoResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         uint32                 `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	GroupRequests []*sdkws.GroupRequest  `protobuf:"bytes,2,rep,name=groupRequests,proto3" json:"groupRequests"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetSpecifiedUserGroupRequestInfoResp) Reset() {
	*x = GetSpecifiedUserGroupRequestInfoResp{}
	mi := &file_group_group_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpecifiedUserGroupRequestInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecifiedUserGroupRequestInfoResp) ProtoMessage() {}

func (x *GetSpecifiedUserGroupRequestInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecifiedUserGroupRequestInfoResp.ProtoReflect.Descriptor instead.
func (*GetSpecifiedUserGroupRequestInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{13}
}

func (x *GetSpecifiedUserGroupRequestInfoResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetSpecifiedUserGroupRequestInfoResp) GetGroupRequests() []*sdkws.GroupRequest {
	if x != nil {
		return x.GroupRequests
	}
	return nil
}

type TransferGroupOwnerReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	GroupID        string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	OldOwnerUserID string                 `protobuf:"bytes,2,opt,name=oldOwnerUserID,proto3" json:"oldOwnerUserID"`
	NewOwnerUserID string                 `protobuf:"bytes,3,opt,name=newOwnerUserID,proto3" json:"newOwnerUserID"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *TransferGroupOwnerReq) Reset() {
	*x = TransferGroupOwnerReq{}
	mi := &file_group_group_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransferGroupOwnerReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferGroupOwnerReq) ProtoMessage() {}

func (x *TransferGroupOwnerReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferGroupOwnerReq.ProtoReflect.Descriptor instead.
func (*TransferGroupOwnerReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{14}
}

func (x *TransferGroupOwnerReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *TransferGroupOwnerReq) GetOldOwnerUserID() string {
	if x != nil {
		return x.OldOwnerUserID
	}
	return ""
}

func (x *TransferGroupOwnerReq) GetNewOwnerUserID() string {
	if x != nil {
		return x.NewOwnerUserID
	}
	return ""
}

type TransferGroupOwnerResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TransferGroupOwnerResp) Reset() {
	*x = TransferGroupOwnerResp{}
	mi := &file_group_group_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransferGroupOwnerResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferGroupOwnerResp) ProtoMessage() {}

func (x *TransferGroupOwnerResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferGroupOwnerResp.ProtoReflect.Descriptor instead.
func (*TransferGroupOwnerResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{15}
}

type JoinGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	ReqMessage    string                 `protobuf:"bytes,2,opt,name=reqMessage,proto3" json:"reqMessage"`
	JoinSource    int32                  `protobuf:"varint,3,opt,name=joinSource,proto3" json:"joinSource"`
	InviterUserID string                 `protobuf:"bytes,4,opt,name=inviterUserID,proto3" json:"inviterUserID"`
	Ex            string                 `protobuf:"bytes,5,opt,name=ex,proto3" json:"ex"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinGroupReq) Reset() {
	*x = JoinGroupReq{}
	mi := &file_group_group_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinGroupReq) ProtoMessage() {}

func (x *JoinGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinGroupReq.ProtoReflect.Descriptor instead.
func (*JoinGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{16}
}

func (x *JoinGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *JoinGroupReq) GetReqMessage() string {
	if x != nil {
		return x.ReqMessage
	}
	return ""
}

func (x *JoinGroupReq) GetJoinSource() int32 {
	if x != nil {
		return x.JoinSource
	}
	return 0
}

func (x *JoinGroupReq) GetInviterUserID() string {
	if x != nil {
		return x.InviterUserID
	}
	return ""
}

func (x *JoinGroupReq) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type JoinGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinGroupResp) Reset() {
	*x = JoinGroupResp{}
	mi := &file_group_group_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinGroupResp) ProtoMessage() {}

func (x *JoinGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinGroupResp.ProtoReflect.Descriptor instead.
func (*JoinGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{17}
}

type GroupApplicationResponseReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	FromUserID    string                 `protobuf:"bytes,2,opt,name=fromUserID,proto3" json:"fromUserID"` //
	HandledMsg    string                 `protobuf:"bytes,3,opt,name=handledMsg,proto3" json:"handledMsg"`
	HandleResult  int32                  `protobuf:"varint,4,opt,name=handleResult,proto3" json:"handleResult"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupApplicationResponseReq) Reset() {
	*x = GroupApplicationResponseReq{}
	mi := &file_group_group_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupApplicationResponseReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupApplicationResponseReq) ProtoMessage() {}

func (x *GroupApplicationResponseReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupApplicationResponseReq.ProtoReflect.Descriptor instead.
func (*GroupApplicationResponseReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{18}
}

func (x *GroupApplicationResponseReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GroupApplicationResponseReq) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *GroupApplicationResponseReq) GetHandledMsg() string {
	if x != nil {
		return x.HandledMsg
	}
	return ""
}

func (x *GroupApplicationResponseReq) GetHandleResult() int32 {
	if x != nil {
		return x.HandleResult
	}
	return 0
}

type GroupApplicationResponseResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupApplicationResponseResp) Reset() {
	*x = GroupApplicationResponseResp{}
	mi := &file_group_group_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupApplicationResponseResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupApplicationResponseResp) ProtoMessage() {}

func (x *GroupApplicationResponseResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupApplicationResponseResp.ProtoReflect.Descriptor instead.
func (*GroupApplicationResponseResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{19}
}

type QuitGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QuitGroupReq) Reset() {
	*x = QuitGroupReq{}
	mi := &file_group_group_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuitGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuitGroupReq) ProtoMessage() {}

func (x *QuitGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuitGroupReq.ProtoReflect.Descriptor instead.
func (*QuitGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{20}
}

func (x *QuitGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *QuitGroupReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type QuitGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QuitGroupResp) Reset() {
	*x = QuitGroupResp{}
	mi := &file_group_group_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuitGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuitGroupResp) ProtoMessage() {}

func (x *QuitGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuitGroupResp.ProtoReflect.Descriptor instead.
func (*QuitGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{21}
}

type GetGroupMemberListReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	GroupID       string                   `protobuf:"bytes,2,opt,name=groupID,proto3" json:"groupID"`
	Filter        int32                    `protobuf:"varint,3,opt,name=filter,proto3" json:"filter"`
	Keyword       string                   `protobuf:"bytes,4,opt,name=keyword,proto3" json:"keyword"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberListReq) Reset() {
	*x = GetGroupMemberListReq{}
	mi := &file_group_group_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberListReq) ProtoMessage() {}

func (x *GetGroupMemberListReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberListReq.ProtoReflect.Descriptor instead.
func (*GetGroupMemberListReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{22}
}

func (x *GetGroupMemberListReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetGroupMemberListReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupMemberListReq) GetFilter() int32 {
	if x != nil {
		return x.Filter
	}
	return 0
}

func (x *GetGroupMemberListReq) GetKeyword() string {
	if x != nil {
		return x.Keyword
	}
	return ""
}

type GetGroupMemberListResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Total         uint32                       `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,2,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberListResp) Reset() {
	*x = GetGroupMemberListResp{}
	mi := &file_group_group_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberListResp) ProtoMessage() {}

func (x *GetGroupMemberListResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberListResp.ProtoReflect.Descriptor instead.
func (*GetGroupMemberListResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{23}
}

func (x *GetGroupMemberListResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetGroupMemberListResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type GetGroupMembersInfoReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserIDs       []string               `protobuf:"bytes,2,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMembersInfoReq) Reset() {
	*x = GetGroupMembersInfoReq{}
	mi := &file_group_group_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMembersInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMembersInfoReq) ProtoMessage() {}

func (x *GetGroupMembersInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMembersInfoReq.ProtoReflect.Descriptor instead.
func (*GetGroupMembersInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{24}
}

func (x *GetGroupMembersInfoReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupMembersInfoReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetGroupMembersInfoResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,1,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMembersInfoResp) Reset() {
	*x = GetGroupMembersInfoResp{}
	mi := &file_group_group_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMembersInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMembersInfoResp) ProtoMessage() {}

func (x *GetGroupMembersInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMembersInfoResp.ProtoReflect.Descriptor instead.
func (*GetGroupMembersInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{25}
}

func (x *GetGroupMembersInfoResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type KickGroupMemberReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	KickedUserIDs []string               `protobuf:"bytes,2,rep,name=kickedUserIDs,proto3" json:"kickedUserIDs"`
	Reason        string                 `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason"`
	SendMessage   *bool                  `protobuf:"varint,4,opt,name=sendMessage,proto3,oneof" json:"sendMessage"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KickGroupMemberReq) Reset() {
	*x = KickGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KickGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KickGroupMemberReq) ProtoMessage() {}

func (x *KickGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KickGroupMemberReq.ProtoReflect.Descriptor instead.
func (*KickGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{26}
}

func (x *KickGroupMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *KickGroupMemberReq) GetKickedUserIDs() []string {
	if x != nil {
		return x.KickedUserIDs
	}
	return nil
}

func (x *KickGroupMemberReq) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *KickGroupMemberReq) GetSendMessage() bool {
	if x != nil && x.SendMessage != nil {
		return *x.SendMessage
	}
	return false
}

type KickGroupMemberResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KickGroupMemberResp) Reset() {
	*x = KickGroupMemberResp{}
	mi := &file_group_group_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KickGroupMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KickGroupMemberResp) ProtoMessage() {}

func (x *KickGroupMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KickGroupMemberResp.ProtoReflect.Descriptor instead.
func (*KickGroupMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{27}
}

type GetJoinedGroupListReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	FromUserID    string                   `protobuf:"bytes,2,opt,name=fromUserID,proto3" json:"fromUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetJoinedGroupListReq) Reset() {
	*x = GetJoinedGroupListReq{}
	mi := &file_group_group_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJoinedGroupListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJoinedGroupListReq) ProtoMessage() {}

func (x *GetJoinedGroupListReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJoinedGroupListReq.ProtoReflect.Descriptor instead.
func (*GetJoinedGroupListReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{28}
}

func (x *GetJoinedGroupListReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetJoinedGroupListReq) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

type GetJoinedGroupListResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         uint32                 `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Groups        []*sdkws.GroupInfo     `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetJoinedGroupListResp) Reset() {
	*x = GetJoinedGroupListResp{}
	mi := &file_group_group_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJoinedGroupListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJoinedGroupListResp) ProtoMessage() {}

func (x *GetJoinedGroupListResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJoinedGroupListResp.ProtoReflect.Descriptor instead.
func (*GetJoinedGroupListResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{29}
}

func (x *GetJoinedGroupListResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetJoinedGroupListResp) GetGroups() []*sdkws.GroupInfo {
	if x != nil {
		return x.Groups
	}
	return nil
}

type InviteUserToGroupReq struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	GroupID        string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	Reason         string                 `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason"`
	InvitedUserIDs []string               `protobuf:"bytes,3,rep,name=invitedUserIDs,proto3" json:"invitedUserIDs"`
	SendMessage    *bool                  `protobuf:"varint,4,opt,name=sendMessage,proto3,oneof" json:"sendMessage"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *InviteUserToGroupReq) Reset() {
	*x = InviteUserToGroupReq{}
	mi := &file_group_group_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InviteUserToGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InviteUserToGroupReq) ProtoMessage() {}

func (x *InviteUserToGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InviteUserToGroupReq.ProtoReflect.Descriptor instead.
func (*InviteUserToGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{30}
}

func (x *InviteUserToGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *InviteUserToGroupReq) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *InviteUserToGroupReq) GetInvitedUserIDs() []string {
	if x != nil {
		return x.InvitedUserIDs
	}
	return nil
}

func (x *InviteUserToGroupReq) GetSendMessage() bool {
	if x != nil && x.SendMessage != nil {
		return *x.SendMessage
	}
	return false
}

type InviteUserToGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InviteUserToGroupResp) Reset() {
	*x = InviteUserToGroupResp{}
	mi := &file_group_group_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InviteUserToGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InviteUserToGroupResp) ProtoMessage() {}

func (x *InviteUserToGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InviteUserToGroupResp.ProtoReflect.Descriptor instead.
func (*InviteUserToGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{31}
}

type GetGroupAllMemberReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	GroupID       string                   `protobuf:"bytes,2,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupAllMemberReq) Reset() {
	*x = GetGroupAllMemberReq{}
	mi := &file_group_group_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupAllMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupAllMemberReq) ProtoMessage() {}

func (x *GetGroupAllMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupAllMemberReq.ProtoReflect.Descriptor instead.
func (*GetGroupAllMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{32}
}

func (x *GetGroupAllMemberReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetGroupAllMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetGroupAllMemberResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,1,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupAllMemberResp) Reset() {
	*x = GetGroupAllMemberResp{}
	mi := &file_group_group_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupAllMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupAllMemberResp) ProtoMessage() {}

func (x *GetGroupAllMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupAllMemberResp.ProtoReflect.Descriptor instead.
func (*GetGroupAllMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{33}
}

func (x *GetGroupAllMemberResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type CMSGroup struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	GroupInfo          *sdkws.GroupInfo       `protobuf:"bytes,1,opt,name=groupInfo,proto3" json:"groupInfo"`
	GroupOwnerUserName string                 `protobuf:"bytes,2,opt,name=groupOwnerUserName,proto3" json:"groupOwnerUserName"`
	GroupOwnerUserID   string                 `protobuf:"bytes,3,opt,name=groupOwnerUserID,proto3" json:"groupOwnerUserID"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CMSGroup) Reset() {
	*x = CMSGroup{}
	mi := &file_group_group_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CMSGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CMSGroup) ProtoMessage() {}

func (x *CMSGroup) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CMSGroup.ProtoReflect.Descriptor instead.
func (*CMSGroup) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{34}
}

func (x *CMSGroup) GetGroupInfo() *sdkws.GroupInfo {
	if x != nil {
		return x.GroupInfo
	}
	return nil
}

func (x *CMSGroup) GetGroupOwnerUserName() string {
	if x != nil {
		return x.GroupOwnerUserName
	}
	return ""
}

func (x *CMSGroup) GetGroupOwnerUserID() string {
	if x != nil {
		return x.GroupOwnerUserID
	}
	return ""
}

type GetGroupsReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	GroupName     string                   `protobuf:"bytes,2,opt,name=groupName,proto3" json:"groupName"`
	GroupID       string                   `protobuf:"bytes,3,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupsReq) Reset() {
	*x = GetGroupsReq{}
	mi := &file_group_group_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupsReq) ProtoMessage() {}

func (x *GetGroupsReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupsReq.ProtoReflect.Descriptor instead.
func (*GetGroupsReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{35}
}

func (x *GetGroupsReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetGroupsReq) GetGroupName() string {
	if x != nil {
		return x.GroupName
	}
	return ""
}

func (x *GetGroupsReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetGroupsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         uint32                 `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Groups        []*CMSGroup            `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupsResp) Reset() {
	*x = GetGroupsResp{}
	mi := &file_group_group_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupsResp) ProtoMessage() {}

func (x *GetGroupsResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupsResp.ProtoReflect.Descriptor instead.
func (*GetGroupsResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{36}
}

func (x *GetGroupsResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetGroupsResp) GetGroups() []*CMSGroup {
	if x != nil {
		return x.Groups
	}
	return nil
}

type GetGroupMemberReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberReq) Reset() {
	*x = GetGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberReq) ProtoMessage() {}

func (x *GetGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberReq.ProtoReflect.Descriptor instead.
func (*GetGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{37}
}

func (x *GetGroupMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetGroupMembersCMSReq struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Pagination    *sdkws.RequestPagination `protobuf:"bytes,1,opt,name=pagination,proto3" json:"pagination"`
	GroupID       string                   `protobuf:"bytes,2,opt,name=groupID,proto3" json:"groupID"`
	UserName      string                   `protobuf:"bytes,3,opt,name=userName,proto3" json:"userName"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMembersCMSReq) Reset() {
	*x = GetGroupMembersCMSReq{}
	mi := &file_group_group_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMembersCMSReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMembersCMSReq) ProtoMessage() {}

func (x *GetGroupMembersCMSReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMembersCMSReq.ProtoReflect.Descriptor instead.
func (*GetGroupMembersCMSReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{38}
}

func (x *GetGroupMembersCMSReq) GetPagination() *sdkws.RequestPagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

func (x *GetGroupMembersCMSReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupMembersCMSReq) GetUserName() string {
	if x != nil {
		return x.UserName
	}
	return ""
}

type GetGroupMembersCMSResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Total         uint32                       `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,2,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMembersCMSResp) Reset() {
	*x = GetGroupMembersCMSResp{}
	mi := &file_group_group_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMembersCMSResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMembersCMSResp) ProtoMessage() {}

func (x *GetGroupMembersCMSResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMembersCMSResp.ProtoReflect.Descriptor instead.
func (*GetGroupMembersCMSResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{39}
}

func (x *GetGroupMembersCMSResp) GetTotal() uint32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetGroupMembersCMSResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type DismissGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	DeleteMember  bool                   `protobuf:"varint,2,opt,name=deleteMember,proto3" json:"deleteMember"`
	SendMessage   *bool                  `protobuf:"varint,3,opt,name=sendMessage,proto3,oneof" json:"sendMessage"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DismissGroupReq) Reset() {
	*x = DismissGroupReq{}
	mi := &file_group_group_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DismissGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissGroupReq) ProtoMessage() {}

func (x *DismissGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissGroupReq.ProtoReflect.Descriptor instead.
func (*DismissGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{40}
}

func (x *DismissGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *DismissGroupReq) GetDeleteMember() bool {
	if x != nil {
		return x.DeleteMember
	}
	return false
}

func (x *DismissGroupReq) GetSendMessage() bool {
	if x != nil && x.SendMessage != nil {
		return *x.SendMessage
	}
	return false
}

type DismissGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DismissGroupResp) Reset() {
	*x = DismissGroupResp{}
	mi := &file_group_group_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DismissGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissGroupResp) ProtoMessage() {}

func (x *DismissGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissGroupResp.ProtoReflect.Descriptor instead.
func (*DismissGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{41}
}

type MuteGroupMemberReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	MutedSeconds  uint32                 `protobuf:"varint,3,opt,name=mutedSeconds,proto3" json:"mutedSeconds"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MuteGroupMemberReq) Reset() {
	*x = MuteGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MuteGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteGroupMemberReq) ProtoMessage() {}

func (x *MuteGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteGroupMemberReq.ProtoReflect.Descriptor instead.
func (*MuteGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{42}
}

func (x *MuteGroupMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *MuteGroupMemberReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *MuteGroupMemberReq) GetMutedSeconds() uint32 {
	if x != nil {
		return x.MutedSeconds
	}
	return 0
}

type MuteGroupMemberResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MuteGroupMemberResp) Reset() {
	*x = MuteGroupMemberResp{}
	mi := &file_group_group_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MuteGroupMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteGroupMemberResp) ProtoMessage() {}

func (x *MuteGroupMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteGroupMemberResp.ProtoReflect.Descriptor instead.
func (*MuteGroupMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{43}
}

type CancelMuteGroupMemberReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CancelMuteGroupMemberReq) Reset() {
	*x = CancelMuteGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelMuteGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelMuteGroupMemberReq) ProtoMessage() {}

func (x *CancelMuteGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelMuteGroupMemberReq.ProtoReflect.Descriptor instead.
func (*CancelMuteGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{44}
}

func (x *CancelMuteGroupMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *CancelMuteGroupMemberReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type CancelMuteGroupMemberResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CancelMuteGroupMemberResp) Reset() {
	*x = CancelMuteGroupMemberResp{}
	mi := &file_group_group_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelMuteGroupMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelMuteGroupMemberResp) ProtoMessage() {}

func (x *CancelMuteGroupMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelMuteGroupMemberResp.ProtoReflect.Descriptor instead.
func (*CancelMuteGroupMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{45}
}

type MuteGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MuteGroupReq) Reset() {
	*x = MuteGroupReq{}
	mi := &file_group_group_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MuteGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteGroupReq) ProtoMessage() {}

func (x *MuteGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteGroupReq.ProtoReflect.Descriptor instead.
func (*MuteGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{46}
}

func (x *MuteGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type MuteGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MuteGroupResp) Reset() {
	*x = MuteGroupResp{}
	mi := &file_group_group_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MuteGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteGroupResp) ProtoMessage() {}

func (x *MuteGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteGroupResp.ProtoReflect.Descriptor instead.
func (*MuteGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{47}
}

type CancelMuteGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CancelMuteGroupReq) Reset() {
	*x = CancelMuteGroupReq{}
	mi := &file_group_group_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelMuteGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelMuteGroupReq) ProtoMessage() {}

func (x *CancelMuteGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelMuteGroupReq.ProtoReflect.Descriptor instead.
func (*CancelMuteGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{48}
}

func (x *CancelMuteGroupReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type CancelMuteGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CancelMuteGroupResp) Reset() {
	*x = CancelMuteGroupResp{}
	mi := &file_group_group_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelMuteGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelMuteGroupResp) ProtoMessage() {}

func (x *CancelMuteGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelMuteGroupResp.ProtoReflect.Descriptor instead.
func (*CancelMuteGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{49}
}

type SetGroupMemberInfo struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	GroupID       string                  `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID        string                  `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	Nickname      *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=nickname,proto3" json:"nickname"`
	FaceURL       *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=faceURL,proto3" json:"faceURL"`
	RoleLevel     *wrapperspb.Int32Value  `protobuf:"bytes,5,opt,name=roleLevel,proto3" json:"roleLevel"`
	Ex            *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=ex,proto3" json:"ex"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetGroupMemberInfo) Reset() {
	*x = SetGroupMemberInfo{}
	mi := &file_group_group_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupMemberInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupMemberInfo) ProtoMessage() {}

func (x *SetGroupMemberInfo) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupMemberInfo.ProtoReflect.Descriptor instead.
func (*SetGroupMemberInfo) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{50}
}

func (x *SetGroupMemberInfo) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *SetGroupMemberInfo) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *SetGroupMemberInfo) GetNickname() *wrapperspb.StringValue {
	if x != nil {
		return x.Nickname
	}
	return nil
}

func (x *SetGroupMemberInfo) GetFaceURL() *wrapperspb.StringValue {
	if x != nil {
		return x.FaceURL
	}
	return nil
}

func (x *SetGroupMemberInfo) GetRoleLevel() *wrapperspb.Int32Value {
	if x != nil {
		return x.RoleLevel
	}
	return nil
}

func (x *SetGroupMemberInfo) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

type SetGroupMemberInfoReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Members       []*SetGroupMemberInfo  `protobuf:"bytes,1,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetGroupMemberInfoReq) Reset() {
	*x = SetGroupMemberInfoReq{}
	mi := &file_group_group_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupMemberInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupMemberInfoReq) ProtoMessage() {}

func (x *SetGroupMemberInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupMemberInfoReq.ProtoReflect.Descriptor instead.
func (*SetGroupMemberInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{51}
}

func (x *SetGroupMemberInfoReq) GetMembers() []*SetGroupMemberInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type SetGroupMemberInfoResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetGroupMemberInfoResp) Reset() {
	*x = SetGroupMemberInfoResp{}
	mi := &file_group_group_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetGroupMemberInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGroupMemberInfoResp) ProtoMessage() {}

func (x *SetGroupMemberInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGroupMemberInfoResp.ProtoReflect.Descriptor instead.
func (*SetGroupMemberInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{52}
}

type GetGroupAbstractInfoReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupIDs      []string               `protobuf:"bytes,1,rep,name=groupIDs,proto3" json:"groupIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupAbstractInfoReq) Reset() {
	*x = GetGroupAbstractInfoReq{}
	mi := &file_group_group_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupAbstractInfoReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupAbstractInfoReq) ProtoMessage() {}

func (x *GetGroupAbstractInfoReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupAbstractInfoReq.ProtoReflect.Descriptor instead.
func (*GetGroupAbstractInfoReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{53}
}

func (x *GetGroupAbstractInfoReq) GetGroupIDs() []string {
	if x != nil {
		return x.GroupIDs
	}
	return nil
}

type GroupAbstractInfo struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	GroupID             string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	GroupMemberNumber   uint32                 `protobuf:"varint,2,opt,name=groupMemberNumber,proto3" json:"groupMemberNumber"`
	GroupMemberListHash uint64                 `protobuf:"varint,3,opt,name=groupMemberListHash,proto3" json:"groupMemberListHash"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GroupAbstractInfo) Reset() {
	*x = GroupAbstractInfo{}
	mi := &file_group_group_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupAbstractInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupAbstractInfo) ProtoMessage() {}

func (x *GroupAbstractInfo) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupAbstractInfo.ProtoReflect.Descriptor instead.
func (*GroupAbstractInfo) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{54}
}

func (x *GroupAbstractInfo) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GroupAbstractInfo) GetGroupMemberNumber() uint32 {
	if x != nil {
		return x.GroupMemberNumber
	}
	return 0
}

func (x *GroupAbstractInfo) GetGroupMemberListHash() uint64 {
	if x != nil {
		return x.GroupMemberListHash
	}
	return 0
}

type GetGroupAbstractInfoResp struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	GroupAbstractInfos []*GroupAbstractInfo   `protobuf:"bytes,1,rep,name=groupAbstractInfos,proto3" json:"groupAbstractInfos"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetGroupAbstractInfoResp) Reset() {
	*x = GetGroupAbstractInfoResp{}
	mi := &file_group_group_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupAbstractInfoResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupAbstractInfoResp) ProtoMessage() {}

func (x *GetGroupAbstractInfoResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupAbstractInfoResp.ProtoReflect.Descriptor instead.
func (*GetGroupAbstractInfoResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{55}
}

func (x *GetGroupAbstractInfoResp) GetGroupAbstractInfos() []*GroupAbstractInfo {
	if x != nil {
		return x.GroupAbstractInfos
	}
	return nil
}

type GetUserInGroupMembersReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	GroupIDs      []string               `protobuf:"bytes,2,rep,name=groupIDs,proto3" json:"groupIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserInGroupMembersReq) Reset() {
	*x = GetUserInGroupMembersReq{}
	mi := &file_group_group_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserInGroupMembersReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserInGroupMembersReq) ProtoMessage() {}

func (x *GetUserInGroupMembersReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserInGroupMembersReq.ProtoReflect.Descriptor instead.
func (*GetUserInGroupMembersReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{56}
}

func (x *GetUserInGroupMembersReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GetUserInGroupMembersReq) GetGroupIDs() []string {
	if x != nil {
		return x.GroupIDs
	}
	return nil
}

type GetUserInGroupMembersResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,1,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUserInGroupMembersResp) Reset() {
	*x = GetUserInGroupMembersResp{}
	mi := &file_group_group_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUserInGroupMembersResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUserInGroupMembersResp) ProtoMessage() {}

func (x *GetUserInGroupMembersResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUserInGroupMembersResp.ProtoReflect.Descriptor instead.
func (*GetUserInGroupMembersResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{57}
}

func (x *GetUserInGroupMembersResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type GetGroupMemberUserIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberUserIDsReq) Reset() {
	*x = GetGroupMemberUserIDsReq{}
	mi := &file_group_group_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberUserIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberUserIDsReq) ProtoMessage() {}

func (x *GetGroupMemberUserIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberUserIDsReq.ProtoReflect.Descriptor instead.
func (*GetGroupMemberUserIDsReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{58}
}

func (x *GetGroupMemberUserIDsReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetGroupMemberUserIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserIDs       []string               `protobuf:"bytes,1,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberUserIDsResp) Reset() {
	*x = GetGroupMemberUserIDsResp{}
	mi := &file_group_group_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberUserIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberUserIDsResp) ProtoMessage() {}

func (x *GetGroupMemberUserIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberUserIDsResp.ProtoReflect.Descriptor instead.
func (*GetGroupMemberUserIDsResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{59}
}

func (x *GetGroupMemberUserIDsResp) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetGroupMemberRoleLevelReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	RoleLevels    []int32                `protobuf:"varint,2,rep,packed,name=roleLevels,proto3" json:"roleLevels"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberRoleLevelReq) Reset() {
	*x = GetGroupMemberRoleLevelReq{}
	mi := &file_group_group_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberRoleLevelReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberRoleLevelReq) ProtoMessage() {}

func (x *GetGroupMemberRoleLevelReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberRoleLevelReq.ProtoReflect.Descriptor instead.
func (*GetGroupMemberRoleLevelReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{60}
}

func (x *GetGroupMemberRoleLevelReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupMemberRoleLevelReq) GetRoleLevels() []int32 {
	if x != nil {
		return x.RoleLevels
	}
	return nil
}

type GetGroupMemberRoleLevelResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Members       []*sdkws.GroupMemberFullInfo `protobuf:"bytes,1,rep,name=members,proto3" json:"members"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberRoleLevelResp) Reset() {
	*x = GetGroupMemberRoleLevelResp{}
	mi := &file_group_group_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberRoleLevelResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberRoleLevelResp) ProtoMessage() {}

func (x *GetGroupMemberRoleLevelResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberRoleLevelResp.ProtoReflect.Descriptor instead.
func (*GetGroupMemberRoleLevelResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{61}
}

func (x *GetGroupMemberRoleLevelResp) GetMembers() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Members
	}
	return nil
}

type GetGroupInfoCacheReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupInfoCacheReq) Reset() {
	*x = GetGroupInfoCacheReq{}
	mi := &file_group_group_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupInfoCacheReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupInfoCacheReq) ProtoMessage() {}

func (x *GetGroupInfoCacheReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupInfoCacheReq.ProtoReflect.Descriptor instead.
func (*GetGroupInfoCacheReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{62}
}

func (x *GetGroupInfoCacheReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetGroupInfoCacheResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInfo     *sdkws.GroupInfo       `protobuf:"bytes,1,opt,name=groupInfo,proto3" json:"groupInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupInfoCacheResp) Reset() {
	*x = GetGroupInfoCacheResp{}
	mi := &file_group_group_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupInfoCacheResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupInfoCacheResp) ProtoMessage() {}

func (x *GetGroupInfoCacheResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupInfoCacheResp.ProtoReflect.Descriptor instead.
func (*GetGroupInfoCacheResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{63}
}

func (x *GetGroupInfoCacheResp) GetGroupInfo() *sdkws.GroupInfo {
	if x != nil {
		return x.GroupInfo
	}
	return nil
}

type GetGroupMemberCacheReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	GroupMemberID string                 `protobuf:"bytes,2,opt,name=groupMemberID,proto3" json:"groupMemberID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberCacheReq) Reset() {
	*x = GetGroupMemberCacheReq{}
	mi := &file_group_group_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberCacheReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberCacheReq) ProtoMessage() {}

func (x *GetGroupMemberCacheReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberCacheReq.ProtoReflect.Descriptor instead.
func (*GetGroupMemberCacheReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{64}
}

func (x *GetGroupMemberCacheReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupMemberCacheReq) GetGroupMemberID() string {
	if x != nil {
		return x.GroupMemberID
	}
	return ""
}

type GetGroupMemberCacheResp struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Member        *sdkws.GroupMemberFullInfo `protobuf:"bytes,1,opt,name=member,proto3" json:"member"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupMemberCacheResp) Reset() {
	*x = GetGroupMemberCacheResp{}
	mi := &file_group_group_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupMemberCacheResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupMemberCacheResp) ProtoMessage() {}

func (x *GetGroupMemberCacheResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupMemberCacheResp.ProtoReflect.Descriptor instead.
func (*GetGroupMemberCacheResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{65}
}

func (x *GetGroupMemberCacheResp) GetMember() *sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Member
	}
	return nil
}

type GroupCreateCountReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Start         int64                  `protobuf:"varint,1,opt,name=start,proto3" json:"start"`
	End           int64                  `protobuf:"varint,2,opt,name=end,proto3" json:"end"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupCreateCountReq) Reset() {
	*x = GroupCreateCountReq{}
	mi := &file_group_group_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupCreateCountReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupCreateCountReq) ProtoMessage() {}

func (x *GroupCreateCountReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupCreateCountReq.ProtoReflect.Descriptor instead.
func (*GroupCreateCountReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{66}
}

func (x *GroupCreateCountReq) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *GroupCreateCountReq) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

type GroupCreateCountResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         int64                  `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	Before        int64                  `protobuf:"varint,2,opt,name=before,proto3" json:"before"`
	Count         map[string]int64       `protobuf:"bytes,3,rep,name=count,proto3" json:"count" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupCreateCountResp) Reset() {
	*x = GroupCreateCountResp{}
	mi := &file_group_group_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupCreateCountResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupCreateCountResp) ProtoMessage() {}

func (x *GroupCreateCountResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupCreateCountResp.ProtoReflect.Descriptor instead.
func (*GroupCreateCountResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{67}
}

func (x *GroupCreateCountResp) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GroupCreateCountResp) GetBefore() int64 {
	if x != nil {
		return x.Before
	}
	return 0
}

func (x *GroupCreateCountResp) GetCount() map[string]int64 {
	if x != nil {
		return x.Count
	}
	return nil
}

type GetGroupUsersReqApplicationListReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserIDs       []string               `protobuf:"bytes,2,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupUsersReqApplicationListReq) Reset() {
	*x = GetGroupUsersReqApplicationListReq{}
	mi := &file_group_group_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupUsersReqApplicationListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupUsersReqApplicationListReq) ProtoMessage() {}

func (x *GetGroupUsersReqApplicationListReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupUsersReqApplicationListReq.ProtoReflect.Descriptor instead.
func (*GetGroupUsersReqApplicationListReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{68}
}

func (x *GetGroupUsersReqApplicationListReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetGroupUsersReqApplicationListReq) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetGroupUsersReqApplicationListResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Total         int64                  `protobuf:"varint,1,opt,name=total,proto3" json:"total"`
	GroupRequests []*sdkws.GroupRequest  `protobuf:"bytes,2,rep,name=groupRequests,proto3" json:"groupRequests"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGroupUsersReqApplicationListResp) Reset() {
	*x = GetGroupUsersReqApplicationListResp{}
	mi := &file_group_group_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupUsersReqApplicationListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupUsersReqApplicationListResp) ProtoMessage() {}

func (x *GetGroupUsersReqApplicationListResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupUsersReqApplicationListResp.ProtoReflect.Descriptor instead.
func (*GetGroupUsersReqApplicationListResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{69}
}

func (x *GetGroupUsersReqApplicationListResp) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *GetGroupUsersReqApplicationListResp) GetGroupRequests() []*sdkws.GroupRequest {
	if x != nil {
		return x.GroupRequests
	}
	return nil
}

type NotificationUserInfoUpdateReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	OldUserInfo   *sdkws.UserInfo        `protobuf:"bytes,2,opt,name=oldUserInfo,proto3" json:"oldUserInfo"`
	NewUserInfo   *sdkws.UserInfo        `protobuf:"bytes,3,opt,name=newUserInfo,proto3" json:"newUserInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotificationUserInfoUpdateReq) Reset() {
	*x = NotificationUserInfoUpdateReq{}
	mi := &file_group_group_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationUserInfoUpdateReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationUserInfoUpdateReq) ProtoMessage() {}

func (x *NotificationUserInfoUpdateReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationUserInfoUpdateReq.ProtoReflect.Descriptor instead.
func (*NotificationUserInfoUpdateReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{70}
}

func (x *NotificationUserInfoUpdateReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *NotificationUserInfoUpdateReq) GetOldUserInfo() *sdkws.UserInfo {
	if x != nil {
		return x.OldUserInfo
	}
	return nil
}

func (x *NotificationUserInfoUpdateReq) GetNewUserInfo() *sdkws.UserInfo {
	if x != nil {
		return x.NewUserInfo
	}
	return nil
}

type NotificationUserInfoUpdateResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotificationUserInfoUpdateResp) Reset() {
	*x = NotificationUserInfoUpdateResp{}
	mi := &file_group_group_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationUserInfoUpdateResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationUserInfoUpdateResp) ProtoMessage() {}

func (x *NotificationUserInfoUpdateResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationUserInfoUpdateResp.ProtoReflect.Descriptor instead.
func (*NotificationUserInfoUpdateResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{71}
}

type GetIncrementalGroupMemberReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupID       string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Version       uint64                 `protobuf:"varint,3,opt,name=version,proto3" json:"version"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalGroupMemberReq) Reset() {
	*x = GetIncrementalGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalGroupMemberReq) ProtoMessage() {}

func (x *GetIncrementalGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalGroupMemberReq.ProtoReflect.Descriptor instead.
func (*GetIncrementalGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{72}
}

func (x *GetIncrementalGroupMemberReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GetIncrementalGroupMemberReq) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalGroupMemberReq) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

type GetIncrementalGroupMemberResp struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	Version       uint64                       `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID     string                       `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Full          bool                         `protobuf:"varint,3,opt,name=full,proto3" json:"full"`
	Delete        []string                     `protobuf:"bytes,4,rep,name=delete,proto3" json:"delete"`
	Insert        []*sdkws.GroupMemberFullInfo `protobuf:"bytes,5,rep,name=insert,proto3" json:"insert"`
	Update        []*sdkws.GroupMemberFullInfo `protobuf:"bytes,6,rep,name=update,proto3" json:"update"`
	Group         *sdkws.GroupInfo             `protobuf:"bytes,7,opt,name=group,proto3" json:"group"`
	SortVersion   uint64                       `protobuf:"varint,8,opt,name=sortVersion,proto3" json:"sortVersion"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalGroupMemberResp) Reset() {
	*x = GetIncrementalGroupMemberResp{}
	mi := &file_group_group_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalGroupMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalGroupMemberResp) ProtoMessage() {}

func (x *GetIncrementalGroupMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalGroupMemberResp.ProtoReflect.Descriptor instead.
func (*GetIncrementalGroupMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{73}
}

func (x *GetIncrementalGroupMemberResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetIncrementalGroupMemberResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalGroupMemberResp) GetFull() bool {
	if x != nil {
		return x.Full
	}
	return false
}

func (x *GetIncrementalGroupMemberResp) GetDelete() []string {
	if x != nil {
		return x.Delete
	}
	return nil
}

func (x *GetIncrementalGroupMemberResp) GetInsert() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Insert
	}
	return nil
}

func (x *GetIncrementalGroupMemberResp) GetUpdate() []*sdkws.GroupMemberFullInfo {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *GetIncrementalGroupMemberResp) GetGroup() *sdkws.GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GetIncrementalGroupMemberResp) GetSortVersion() uint64 {
	if x != nil {
		return x.SortVersion
	}
	return 0
}

type GetIncrementalJoinGroupReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Version       uint64                 `protobuf:"varint,3,opt,name=version,proto3" json:"version"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalJoinGroupReq) Reset() {
	*x = GetIncrementalJoinGroupReq{}
	mi := &file_group_group_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalJoinGroupReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalJoinGroupReq) ProtoMessage() {}

func (x *GetIncrementalJoinGroupReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalJoinGroupReq.ProtoReflect.Descriptor instead.
func (*GetIncrementalJoinGroupReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{74}
}

func (x *GetIncrementalJoinGroupReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GetIncrementalJoinGroupReq) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalJoinGroupReq) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

type GetIncrementalJoinGroupResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Full          bool                   `protobuf:"varint,3,opt,name=full,proto3" json:"full"`
	Delete        []string               `protobuf:"bytes,4,rep,name=delete,proto3" json:"delete"`
	Insert        []*sdkws.GroupInfo     `protobuf:"bytes,5,rep,name=insert,proto3" json:"insert"`
	Update        []*sdkws.GroupInfo     `protobuf:"bytes,6,rep,name=update,proto3" json:"update"`
	SortVersion   uint64                 `protobuf:"varint,7,opt,name=sortVersion,proto3" json:"sortVersion"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetIncrementalJoinGroupResp) Reset() {
	*x = GetIncrementalJoinGroupResp{}
	mi := &file_group_group_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIncrementalJoinGroupResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncrementalJoinGroupResp) ProtoMessage() {}

func (x *GetIncrementalJoinGroupResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncrementalJoinGroupResp.ProtoReflect.Descriptor instead.
func (*GetIncrementalJoinGroupResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{75}
}

func (x *GetIncrementalJoinGroupResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetIncrementalJoinGroupResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetIncrementalJoinGroupResp) GetFull() bool {
	if x != nil {
		return x.Full
	}
	return false
}

func (x *GetIncrementalJoinGroupResp) GetDelete() []string {
	if x != nil {
		return x.Delete
	}
	return nil
}

func (x *GetIncrementalJoinGroupResp) GetInsert() []*sdkws.GroupInfo {
	if x != nil {
		return x.Insert
	}
	return nil
}

func (x *GetIncrementalJoinGroupResp) GetUpdate() []*sdkws.GroupInfo {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *GetIncrementalJoinGroupResp) GetSortVersion() uint64 {
	if x != nil {
		return x.SortVersion
	}
	return 0
}

type GetFullGroupMemberUserIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IdHash        uint64                 `protobuf:"varint,1,opt,name=idHash,proto3" json:"idHash"`
	GroupID       string                 `protobuf:"bytes,2,opt,name=groupID,proto3" json:"groupID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFullGroupMemberUserIDsReq) Reset() {
	*x = GetFullGroupMemberUserIDsReq{}
	mi := &file_group_group_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullGroupMemberUserIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullGroupMemberUserIDsReq) ProtoMessage() {}

func (x *GetFullGroupMemberUserIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullGroupMemberUserIDsReq.ProtoReflect.Descriptor instead.
func (*GetFullGroupMemberUserIDsReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{76}
}

func (x *GetFullGroupMemberUserIDsReq) GetIdHash() uint64 {
	if x != nil {
		return x.IdHash
	}
	return 0
}

func (x *GetFullGroupMemberUserIDsReq) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

type GetFullGroupMemberUserIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Equal         bool                   `protobuf:"varint,3,opt,name=equal,proto3" json:"equal"`
	UserIDs       []string               `protobuf:"bytes,4,rep,name=userIDs,proto3" json:"userIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFullGroupMemberUserIDsResp) Reset() {
	*x = GetFullGroupMemberUserIDsResp{}
	mi := &file_group_group_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullGroupMemberUserIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullGroupMemberUserIDsResp) ProtoMessage() {}

func (x *GetFullGroupMemberUserIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullGroupMemberUserIDsResp.ProtoReflect.Descriptor instead.
func (*GetFullGroupMemberUserIDsResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{77}
}

func (x *GetFullGroupMemberUserIDsResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetFullGroupMemberUserIDsResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetFullGroupMemberUserIDsResp) GetEqual() bool {
	if x != nil {
		return x.Equal
	}
	return false
}

func (x *GetFullGroupMemberUserIDsResp) GetUserIDs() []string {
	if x != nil {
		return x.UserIDs
	}
	return nil
}

type GetFullJoinGroupIDsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IdHash        uint64                 `protobuf:"varint,1,opt,name=idHash,proto3" json:"idHash"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFullJoinGroupIDsReq) Reset() {
	*x = GetFullJoinGroupIDsReq{}
	mi := &file_group_group_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullJoinGroupIDsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullJoinGroupIDsReq) ProtoMessage() {}

func (x *GetFullJoinGroupIDsReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullJoinGroupIDsReq.ProtoReflect.Descriptor instead.
func (*GetFullJoinGroupIDsReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{78}
}

func (x *GetFullJoinGroupIDsReq) GetIdHash() uint64 {
	if x != nil {
		return x.IdHash
	}
	return 0
}

func (x *GetFullJoinGroupIDsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetFullJoinGroupIDsResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version"`
	VersionID     string                 `protobuf:"bytes,2,opt,name=versionID,proto3" json:"versionID"`
	Equal         bool                   `protobuf:"varint,3,opt,name=equal,proto3" json:"equal"`
	GroupIDs      []string               `protobuf:"bytes,4,rep,name=groupIDs,proto3" json:"groupIDs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFullJoinGroupIDsResp) Reset() {
	*x = GetFullJoinGroupIDsResp{}
	mi := &file_group_group_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFullJoinGroupIDsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFullJoinGroupIDsResp) ProtoMessage() {}

func (x *GetFullJoinGroupIDsResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFullJoinGroupIDsResp.ProtoReflect.Descriptor instead.
func (*GetFullJoinGroupIDsResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{79}
}

func (x *GetFullJoinGroupIDsResp) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetFullJoinGroupIDsResp) GetVersionID() string {
	if x != nil {
		return x.VersionID
	}
	return ""
}

func (x *GetFullJoinGroupIDsResp) GetEqual() bool {
	if x != nil {
		return x.Equal
	}
	return false
}

func (x *GetFullJoinGroupIDsResp) GetGroupIDs() []string {
	if x != nil {
		return x.GroupIDs
	}
	return nil
}

type BatchGetIncrementalGroupMemberReq struct {
	state         protoimpl.MessageState          `protogen:"open.v1"`
	UserID        string                          `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ReqList       []*GetIncrementalGroupMemberReq `protobuf:"bytes,2,rep,name=reqList,proto3" json:"reqList"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BatchGetIncrementalGroupMemberReq) Reset() {
	*x = BatchGetIncrementalGroupMemberReq{}
	mi := &file_group_group_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetIncrementalGroupMemberReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetIncrementalGroupMemberReq) ProtoMessage() {}

func (x *BatchGetIncrementalGroupMemberReq) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetIncrementalGroupMemberReq.ProtoReflect.Descriptor instead.
func (*BatchGetIncrementalGroupMemberReq) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{80}
}

func (x *BatchGetIncrementalGroupMemberReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *BatchGetIncrementalGroupMemberReq) GetReqList() []*GetIncrementalGroupMemberReq {
	if x != nil {
		return x.ReqList
	}
	return nil
}

type BatchGetIncrementalGroupMemberResp struct {
	state         protoimpl.MessageState                    `protogen:"open.v1"`
	RespList      map[string]*GetIncrementalGroupMemberResp `protobuf:"bytes,1,rep,name=respList,proto3" json:"respList" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BatchGetIncrementalGroupMemberResp) Reset() {
	*x = BatchGetIncrementalGroupMemberResp{}
	mi := &file_group_group_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetIncrementalGroupMemberResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetIncrementalGroupMemberResp) ProtoMessage() {}

func (x *BatchGetIncrementalGroupMemberResp) ProtoReflect() protoreflect.Message {
	mi := &file_group_group_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetIncrementalGroupMemberResp.ProtoReflect.Descriptor instead.
func (*BatchGetIncrementalGroupMemberResp) Descriptor() ([]byte, []int) {
	return file_group_group_proto_rawDescGZIP(), []int{81}
}

func (x *BatchGetIncrementalGroupMemberResp) GetRespList() map[string]*GetIncrementalGroupMemberResp {
	if x != nil {
		return x.RespList
	}
	return nil
}

var File_group_group_proto protoreflect.FileDescriptor

var file_group_group_proto_rawDesc = []byte{
	0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x1a, 0x11, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x70, 0x62,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xea, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x12, 0x24, 0x0a, 0x0d, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x25, 0x0a, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b,
	0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x48,
	0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x2e, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x1a, 0x0a, 0x08,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x22, 0x4c, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x37, 0x0a,
	0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x22, 0x5a, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x47, 0x0a, 0x0f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x46, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x46, 0x6f, 0x72, 0x53, 0x65,
	0x74, 0x52, 0x0f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x46, 0x6f, 0x72, 0x53,
	0x65, 0x74, 0x22, 0x12, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x22, 0xac, 0x04, 0x0a, 0x11, 0x53, 0x65, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x3a, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52,
	0x4c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x2c,
	0x0a, 0x02, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x65, 0x78, 0x12, 0x47, 0x0a, 0x10,
	0x6e, 0x65, 0x65, 0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x10, 0x6e, 0x65, 0x65, 0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x49, 0x0a, 0x11, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x22, 0x14, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x52, 0x65, 0x73, 0x70, 0x22, 0x7d, 0x0a, 0x1a, 0x47,
	0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72,
	0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x75, 0x0a, 0x1b, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12,
	0x40, 0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x22, 0x77, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x77, 0x0a, 0x1d, 0x47, 0x65,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x12, 0x40, 0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x22, 0x57, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x7e, 0x0a, 0x24,
	0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x40, 0x0a, 0x0d, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x81, 0x01, 0x0a,
	0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x12, 0x26, 0x0a, 0x0e, 0x6f, 0x6c, 0x64, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x6c, 0x64, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x4f,
	0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x6e, 0x65, 0x77, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x22, 0x18, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x22, 0x9e, 0x01, 0x0a, 0x0c, 0x4a,
	0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x71, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e,
	0x76, 0x69, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x0e, 0x0a, 0x02, 0x65,
	0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0x0f, 0x0a, 0x0d, 0x4a,
	0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22, 0x9b, 0x01, 0x0a,
	0x1b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x64, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x64, 0x4d, 0x73, 0x67, 0x12, 0x22, 0x0a, 0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x1e, 0x0a, 0x1c, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x22, 0x40, 0x0a, 0x0c, 0x51, 0x75,
	0x69, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x0f, 0x0a, 0x0d,
	0x51, 0x75, 0x69, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22, 0xa4, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x22, 0x6b, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x12, 0x3b, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x22, 0x4c, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x22,
	0x56, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x3b, 0x0a, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0xa3, 0x01, 0x0a, 0x12, 0x4b, 0x69, 0x63, 0x6b,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x18,
	0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x6b, 0x69, 0x63, 0x6b,
	0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0d, 0x6b, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b, 0x73,
	0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x15, 0x0a,
	0x13, 0x4b, 0x69, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x22, 0x78, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x65,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e,
	0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x5f,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x2f,
	0x0a, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22,
	0xa7, 0x01, 0x0a, 0x14, 0x49, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x54, 0x6f,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0e, 0x69, 0x6e,
	0x76, 0x69, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65,
	0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x17, 0x0a, 0x15, 0x49, 0x6e, 0x76,
	0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x54, 0x6f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x73, 0x70, 0x22, 0x71, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x6c,
	0x6c, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x54, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x41, 0x6c, 0x6c, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x3b,
	0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x9d, 0x01, 0x0a, 0x08,
	0x43, 0x4d, 0x53, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x2a, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x87, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a,
	0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x55, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x2e, 0x0a, 0x06,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x43, 0x4d, 0x53, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x2d, 0x0a, 0x11,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x8e, 0x01, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x43,
	0x4d, 0x53, 0x52, 0x65, 0x71, 0x12, 0x3f, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x43,
	0x4d, 0x53, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x3b, 0x0a, 0x07,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x0f, 0x44, 0x69,
	0x73, 0x6d, 0x69, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0b, 0x73,
	0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x12, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22, 0x6a, 0x0a, 0x12, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x22,
	0x0a, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x22, 0x4c, 0x0a, 0x18, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12,
	0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x1b, 0x0a, 0x19, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x22, 0x28, 0x0a, 0x0c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x0f,
	0x0a, 0x0d, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x2e, 0x0a, 0x12, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22,
	0x15, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22, 0xa1, 0x02, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x38, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x07, 0x66, 0x61, 0x63,
	0x65, 0x55, 0x52, 0x4c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52,
	0x4c, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x02,
	0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x65, 0x78, 0x22, 0x53, 0x0a, 0x15, 0x53, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x71, 0x12, 0x3a, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22,
	0x18, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x22, 0x35, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x12, 0x1a, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73,
	0x22, 0x8d, 0x01, 0x0a, 0x11, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x12, 0x2c, 0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x30,
	0x0a, 0x13, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73,
	0x74, 0x48, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x61, 0x73, 0x68,
	0x22, 0x6b, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x4f, 0x0a, 0x12,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x41, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x22, 0x4e, 0x0a,
	0x18, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x1a, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x22, 0x58, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x3b, 0x0a, 0x07, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x34, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73,
	0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x35, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x73, 0x22, 0x56, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a,
	0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x0a, 0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x22, 0x5a, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f,
	0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12, 0x3b, 0x0a, 0x07, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x30, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71,
	0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22, 0x4e, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x58, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x24,
	0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x49, 0x44, 0x22, 0x54, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x39, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x3d, 0x0a, 0x13, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0xc3, 0x01, 0x0a, 0x14, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x65, 0x66, 0x6f,
	0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x12, 0x43, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x38, 0x0a, 0x0a, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x58, 0x0a, 0x22, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x73, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12,
	0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x22, 0x7d, 0x0a, 0x23, 0x67, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x40, 0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0xab, 0x01, 0x0a, 0x1d, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x38, 0x0a, 0x0b, 0x6f, 0x6c, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0b, 0x6f, 0x6c, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x0b,
	0x6e, 0x65, 0x77, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x20, 0x0a, 0x1e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x22, 0x70, 0x0a, 0x1c, 0x67, 0x65, 0x74, 0x49,
	0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xca, 0x02, 0x0a, 0x1d, 0x67,
	0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x75, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x04, 0x66, 0x75, 0x6c, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x12, 0x39, 0x0a, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x6f, 0x72, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x6f, 0x72, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0x0a, 0x1a, 0x67, 0x65, 0x74, 0x49, 0x6e,
	0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a,
	0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x02, 0x0a, 0x1b, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x75, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x66, 0x75, 0x6c,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x69, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x73,
	0x6f, 0x72, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x73, 0x6f, 0x72, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x0a,
	0x1c, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a,
	0x06, 0x69, 0x64, 0x48, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x69,
	0x64, 0x48, 0x61, 0x73, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x22,
	0x87, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x12,
	0x18, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x22, 0x48, 0x0a, 0x16, 0x47, 0x65, 0x74,
	0x46, 0x75, 0x6c, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73,
	0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x64, 0x48, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x06, 0x69, 0x64, 0x48, 0x61, 0x73, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x22, 0x83, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4a,
	0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x12, 0x1a, 0x0a,
	0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x21, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12,
	0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x44, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x4c, 0x69,
	0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x52, 0x07, 0x72, 0x65, 0x71, 0x4c, 0x69, 0x73, 0x74, 0x22, 0xea, 0x01,
	0x0a, 0x22, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x5a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x4c, 0x69, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x4c, 0x69, 0x73, 0x74,
	0x1a, 0x68, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x2e, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x32, 0xbe, 0x1d, 0x0a, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x4a, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x1a, 0x1d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x44, 0x0a, 0x09, 0x6a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1a, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4a, 0x6f, 0x69,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x1a, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x44, 0x0a, 0x09, 0x71, 0x75, 0x69, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x51, 0x75, 0x69, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x1a,
	0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x51,
	0x75, 0x69, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x50, 0x0a, 0x0d,
	0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x1a, 0x1f, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x4d,
	0x0a, 0x0c, 0x73, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x1a, 0x1e, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x53, 0x0a,
	0x0e, 0x73, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x12,
	0x1f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53,
	0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x52, 0x65, 0x71,
	0x1a, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e,
	0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x6e, 0x0a, 0x17, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x28, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x74, 0x0a, 0x19, 0x67, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47,
	0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x2b, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x86, 0x01, 0x0a, 0x1f, 0x67, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x30, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x31,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x89, 0x01, 0x0a, 0x20, 0x67, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x1a, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x5f, 0x0a,
	0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x12, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x71,
	0x0a, 0x18, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x5f, 0x0a, 0x12, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x62, 0x0a, 0x13, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x1a,
	0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47,
	0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x56, 0x0a, 0x0f, 0x6b, 0x69, 0x63, 0x6b, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4b, 0x69, 0x63, 0x6b, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4b, 0x69, 0x63, 0x6b, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x5f,
	0x0a, 0x12, 0x67, 0x65, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x69, 0x6e,
	0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x5c, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x54, 0x6f, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x49, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x54, 0x6f,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x1a, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x49, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x54, 0x6f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x44, 0x0a,
	0x09, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x1a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x5f, 0x0a, 0x12, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x43, 0x4d, 0x53, 0x12, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x43, 0x4d, 0x53, 0x52, 0x65, 0x71, 0x1a, 0x24,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x43, 0x4d, 0x53,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x1a, 0x1e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x56, 0x0a, 0x0f, 0x6d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x68, 0x0a, 0x15, 0x63,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x27, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x44, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x1a, 0x1b,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4d, 0x75,
	0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x56, 0x0a, 0x0f, 0x63,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x20,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x1a, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x5f, 0x0a, 0x12, 0x73, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x1a, 0x24,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x53, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x65, 0x0a, 0x14, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x41, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x71, 0x1a, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x12, 0x68, 0x0a, 0x15, 0x67,
	0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x12, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x27, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x68, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x26,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x27, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x6e, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x28, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x5c, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x12, 0x22, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x6e, 0x66, 0x6f, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x62, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x12, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x25, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x59, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x22, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x77, 0x0a, 0x1a,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x2b, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x74, 0x0a, 0x19, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x2e, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x2b,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65,
	0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x12, 0x83, 0x01, 0x0a, 0x1e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2f,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a,
	0x30, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x6e, 0x0a, 0x17, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x28, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65, 0x74, 0x49,
	0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x67, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x74, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x12, 0x2a,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x75, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x2b, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c,
	0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x62, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x46, 0x75,
	0x6c, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x12, 0x24,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44,
	0x73, 0x52, 0x65, 0x71, 0x1a, 0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x4a, 0x6f, 0x69, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x73, 0x52, 0x65, 0x73, 0x70, 0x42, 0x25, 0x5a, 0x23, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x73, 0x64, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_group_group_proto_rawDescOnce sync.Once
	file_group_group_proto_rawDescData = file_group_group_proto_rawDesc
)

func file_group_group_proto_rawDescGZIP() []byte {
	file_group_group_proto_rawDescOnce.Do(func() {
		file_group_group_proto_rawDescData = protoimpl.X.CompressGZIP(file_group_group_proto_rawDescData)
	})
	return file_group_group_proto_rawDescData
}

var file_group_group_proto_msgTypes = make([]protoimpl.MessageInfo, 84)
var file_group_group_proto_goTypes = []any{
	(*CreateGroupReq)(nil),                       // 0: openim.group.CreateGroupReq
	(*CreateGroupResp)(nil),                      // 1: openim.group.CreateGroupResp
	(*GetGroupsInfoReq)(nil),                     // 2: openim.group.GetGroupsInfoReq
	(*GetGroupsInfoResp)(nil),                    // 3: openim.group.GetGroupsInfoResp
	(*SetGroupInfoReq)(nil),                      // 4: openim.group.SetGroupInfoReq
	(*SetGroupInfoResp)(nil),                     // 5: openim.group.SetGroupInfoResp
	(*SetGroupInfoExReq)(nil),                    // 6: openim.group.SetGroupInfoExReq
	(*SetGroupInfoExResp)(nil),                   // 7: openim.group.SetGroupInfoExResp
	(*GetGroupApplicationListReq)(nil),           // 8: openim.group.GetGroupApplicationListReq
	(*GetGroupApplicationListResp)(nil),          // 9: openim.group.GetGroupApplicationListResp
	(*GetUserReqApplicationListReq)(nil),         // 10: openim.group.GetUserReqApplicationListReq
	(*GetUserReqApplicationListResp)(nil),        // 11: openim.group.GetUserReqApplicationListResp
	(*GetSpecifiedUserGroupRequestInfoReq)(nil),  // 12: openim.group.GetSpecifiedUserGroupRequestInfoReq
	(*GetSpecifiedUserGroupRequestInfoResp)(nil), // 13: openim.group.GetSpecifiedUserGroupRequestInfoResp
	(*TransferGroupOwnerReq)(nil),                // 14: openim.group.TransferGroupOwnerReq
	(*TransferGroupOwnerResp)(nil),               // 15: openim.group.TransferGroupOwnerResp
	(*JoinGroupReq)(nil),                         // 16: openim.group.JoinGroupReq
	(*JoinGroupResp)(nil),                        // 17: openim.group.JoinGroupResp
	(*GroupApplicationResponseReq)(nil),          // 18: openim.group.GroupApplicationResponseReq
	(*GroupApplicationResponseResp)(nil),         // 19: openim.group.GroupApplicationResponseResp
	(*QuitGroupReq)(nil),                         // 20: openim.group.QuitGroupReq
	(*QuitGroupResp)(nil),                        // 21: openim.group.QuitGroupResp
	(*GetGroupMemberListReq)(nil),                // 22: openim.group.GetGroupMemberListReq
	(*GetGroupMemberListResp)(nil),               // 23: openim.group.GetGroupMemberListResp
	(*GetGroupMembersInfoReq)(nil),               // 24: openim.group.GetGroupMembersInfoReq
	(*GetGroupMembersInfoResp)(nil),              // 25: openim.group.GetGroupMembersInfoResp
	(*KickGroupMemberReq)(nil),                   // 26: openim.group.KickGroupMemberReq
	(*KickGroupMemberResp)(nil),                  // 27: openim.group.KickGroupMemberResp
	(*GetJoinedGroupListReq)(nil),                // 28: openim.group.GetJoinedGroupListReq
	(*GetJoinedGroupListResp)(nil),               // 29: openim.group.GetJoinedGroupListResp
	(*InviteUserToGroupReq)(nil),                 // 30: openim.group.InviteUserToGroupReq
	(*InviteUserToGroupResp)(nil),                // 31: openim.group.InviteUserToGroupResp
	(*GetGroupAllMemberReq)(nil),                 // 32: openim.group.GetGroupAllMemberReq
	(*GetGroupAllMemberResp)(nil),                // 33: openim.group.GetGroupAllMemberResp
	(*CMSGroup)(nil),                             // 34: openim.group.CMSGroup
	(*GetGroupsReq)(nil),                         // 35: openim.group.GetGroupsReq
	(*GetGroupsResp)(nil),                        // 36: openim.group.GetGroupsResp
	(*GetGroupMemberReq)(nil),                    // 37: openim.group.GetGroupMemberReq
	(*GetGroupMembersCMSReq)(nil),                // 38: openim.group.GetGroupMembersCMSReq
	(*GetGroupMembersCMSResp)(nil),               // 39: openim.group.GetGroupMembersCMSResp
	(*DismissGroupReq)(nil),                      // 40: openim.group.DismissGroupReq
	(*DismissGroupResp)(nil),                     // 41: openim.group.DismissGroupResp
	(*MuteGroupMemberReq)(nil),                   // 42: openim.group.MuteGroupMemberReq
	(*MuteGroupMemberResp)(nil),                  // 43: openim.group.MuteGroupMemberResp
	(*CancelMuteGroupMemberReq)(nil),             // 44: openim.group.CancelMuteGroupMemberReq
	(*CancelMuteGroupMemberResp)(nil),            // 45: openim.group.CancelMuteGroupMemberResp
	(*MuteGroupReq)(nil),                         // 46: openim.group.MuteGroupReq
	(*MuteGroupResp)(nil),                        // 47: openim.group.MuteGroupResp
	(*CancelMuteGroupReq)(nil),                   // 48: openim.group.CancelMuteGroupReq
	(*CancelMuteGroupResp)(nil),                  // 49: openim.group.CancelMuteGroupResp
	(*SetGroupMemberInfo)(nil),                   // 50: openim.group.SetGroupMemberInfo
	(*SetGroupMemberInfoReq)(nil),                // 51: openim.group.SetGroupMemberInfoReq
	(*SetGroupMemberInfoResp)(nil),               // 52: openim.group.SetGroupMemberInfoResp
	(*GetGroupAbstractInfoReq)(nil),              // 53: openim.group.GetGroupAbstractInfoReq
	(*GroupAbstractInfo)(nil),                    // 54: openim.group.GroupAbstractInfo
	(*GetGroupAbstractInfoResp)(nil),             // 55: openim.group.GetGroupAbstractInfoResp
	(*GetUserInGroupMembersReq)(nil),             // 56: openim.group.GetUserInGroupMembersReq
	(*GetUserInGroupMembersResp)(nil),            // 57: openim.group.GetUserInGroupMembersResp
	(*GetGroupMemberUserIDsReq)(nil),             // 58: openim.group.GetGroupMemberUserIDsReq
	(*GetGroupMemberUserIDsResp)(nil),            // 59: openim.group.GetGroupMemberUserIDsResp
	(*GetGroupMemberRoleLevelReq)(nil),           // 60: openim.group.GetGroupMemberRoleLevelReq
	(*GetGroupMemberRoleLevelResp)(nil),          // 61: openim.group.GetGroupMemberRoleLevelResp
	(*GetGroupInfoCacheReq)(nil),                 // 62: openim.group.GetGroupInfoCacheReq
	(*GetGroupInfoCacheResp)(nil),                // 63: openim.group.GetGroupInfoCacheResp
	(*GetGroupMemberCacheReq)(nil),               // 64: openim.group.GetGroupMemberCacheReq
	(*GetGroupMemberCacheResp)(nil),              // 65: openim.group.GetGroupMemberCacheResp
	(*GroupCreateCountReq)(nil),                  // 66: openim.group.GroupCreateCountReq
	(*GroupCreateCountResp)(nil),                 // 67: openim.group.GroupCreateCountResp
	(*GetGroupUsersReqApplicationListReq)(nil),   // 68: openim.group.getGroupUsersReqApplicationListReq
	(*GetGroupUsersReqApplicationListResp)(nil),  // 69: openim.group.getGroupUsersReqApplicationListResp
	(*NotificationUserInfoUpdateReq)(nil),        // 70: openim.group.notificationUserInfoUpdateReq
	(*NotificationUserInfoUpdateResp)(nil),       // 71: openim.group.notificationUserInfoUpdateResp
	(*GetIncrementalGroupMemberReq)(nil),         // 72: openim.group.getIncrementalGroupMemberReq
	(*GetIncrementalGroupMemberResp)(nil),        // 73: openim.group.getIncrementalGroupMemberResp
	(*GetIncrementalJoinGroupReq)(nil),           // 74: openim.group.getIncrementalJoinGroupReq
	(*GetIncrementalJoinGroupResp)(nil),          // 75: openim.group.getIncrementalJoinGroupResp
	(*GetFullGroupMemberUserIDsReq)(nil),         // 76: openim.group.GetFullGroupMemberUserIDsReq
	(*GetFullGroupMemberUserIDsResp)(nil),        // 77: openim.group.GetFullGroupMemberUserIDsResp
	(*GetFullJoinGroupIDsReq)(nil),               // 78: openim.group.GetFullJoinGroupIDsReq
	(*GetFullJoinGroupIDsResp)(nil),              // 79: openim.group.GetFullJoinGroupIDsResp
	(*BatchGetIncrementalGroupMemberReq)(nil),    // 80: openim.group.BatchGetIncrementalGroupMemberReq
	(*BatchGetIncrementalGroupMemberResp)(nil),   // 81: openim.group.BatchGetIncrementalGroupMemberResp
	nil,                               // 82: openim.group.GroupCreateCountResp.CountEntry
	nil,                               // 83: openim.group.BatchGetIncrementalGroupMemberResp.RespListEntry
	(*sdkws.GroupInfo)(nil),           // 84: openim.sdkws.GroupInfo
	(*sdkws.GroupInfoForSet)(nil),     // 85: openim.sdkws.GroupInfoForSet
	(*wrapperspb.StringValue)(nil),    // 86: openim.protobuf.StringValue
	(*wrapperspb.Int32Value)(nil),     // 87: openim.protobuf.Int32Value
	(*sdkws.RequestPagination)(nil),   // 88: openim.sdkws.RequestPagination
	(*sdkws.GroupRequest)(nil),        // 89: openim.sdkws.GroupRequest
	(*sdkws.GroupMemberFullInfo)(nil), // 90: openim.sdkws.GroupMemberFullInfo
	(*sdkws.UserInfo)(nil),            // 91: openim.sdkws.UserInfo
}
var file_group_group_proto_depIdxs = []int32{
	84, // 0: openim.group.CreateGroupReq.groupInfo:type_name -> openim.sdkws.GroupInfo
	84, // 1: openim.group.CreateGroupResp.groupInfo:type_name -> openim.sdkws.GroupInfo
	84, // 2: openim.group.GetGroupsInfoResp.groupInfos:type_name -> openim.sdkws.GroupInfo
	85, // 3: openim.group.SetGroupInfoReq.groupInfoForSet:type_name -> openim.sdkws.GroupInfoForSet
	86, // 4: openim.group.SetGroupInfoExReq.groupName:type_name -> openim.protobuf.StringValue
	86, // 5: openim.group.SetGroupInfoExReq.notification:type_name -> openim.protobuf.StringValue
	86, // 6: openim.group.SetGroupInfoExReq.introduction:type_name -> openim.protobuf.StringValue
	86, // 7: openim.group.SetGroupInfoExReq.faceURL:type_name -> openim.protobuf.StringValue
	86, // 8: openim.group.SetGroupInfoExReq.ex:type_name -> openim.protobuf.StringValue
	87, // 9: openim.group.SetGroupInfoExReq.needVerification:type_name -> openim.protobuf.Int32Value
	87, // 10: openim.group.SetGroupInfoExReq.lookMemberInfo:type_name -> openim.protobuf.Int32Value
	87, // 11: openim.group.SetGroupInfoExReq.applyMemberFriend:type_name -> openim.protobuf.Int32Value
	88, // 12: openim.group.GetGroupApplicationListReq.pagination:type_name -> openim.sdkws.RequestPagination
	89, // 13: openim.group.GetGroupApplicationListResp.groupRequests:type_name -> openim.sdkws.GroupRequest
	88, // 14: openim.group.GetUserReqApplicationListReq.pagination:type_name -> openim.sdkws.RequestPagination
	89, // 15: openim.group.GetUserReqApplicationListResp.groupRequests:type_name -> openim.sdkws.GroupRequest
	89, // 16: openim.group.GetSpecifiedUserGroupRequestInfoResp.groupRequests:type_name -> openim.sdkws.GroupRequest
	88, // 17: openim.group.GetGroupMemberListReq.pagination:type_name -> openim.sdkws.RequestPagination
	90, // 18: openim.group.GetGroupMemberListResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	90, // 19: openim.group.GetGroupMembersInfoResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	88, // 20: openim.group.GetJoinedGroupListReq.pagination:type_name -> openim.sdkws.RequestPagination
	84, // 21: openim.group.GetJoinedGroupListResp.groups:type_name -> openim.sdkws.GroupInfo
	88, // 22: openim.group.GetGroupAllMemberReq.pagination:type_name -> openim.sdkws.RequestPagination
	90, // 23: openim.group.GetGroupAllMemberResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	84, // 24: openim.group.CMSGroup.groupInfo:type_name -> openim.sdkws.GroupInfo
	88, // 25: openim.group.GetGroupsReq.pagination:type_name -> openim.sdkws.RequestPagination
	34, // 26: openim.group.GetGroupsResp.groups:type_name -> openim.group.CMSGroup
	88, // 27: openim.group.GetGroupMembersCMSReq.pagination:type_name -> openim.sdkws.RequestPagination
	90, // 28: openim.group.GetGroupMembersCMSResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	86, // 29: openim.group.SetGroupMemberInfo.nickname:type_name -> openim.protobuf.StringValue
	86, // 30: openim.group.SetGroupMemberInfo.faceURL:type_name -> openim.protobuf.StringValue
	87, // 31: openim.group.SetGroupMemberInfo.roleLevel:type_name -> openim.protobuf.Int32Value
	86, // 32: openim.group.SetGroupMemberInfo.ex:type_name -> openim.protobuf.StringValue
	50, // 33: openim.group.SetGroupMemberInfoReq.members:type_name -> openim.group.SetGroupMemberInfo
	54, // 34: openim.group.GetGroupAbstractInfoResp.groupAbstractInfos:type_name -> openim.group.GroupAbstractInfo
	90, // 35: openim.group.GetUserInGroupMembersResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	90, // 36: openim.group.GetGroupMemberRoleLevelResp.members:type_name -> openim.sdkws.GroupMemberFullInfo
	84, // 37: openim.group.GetGroupInfoCacheResp.groupInfo:type_name -> openim.sdkws.GroupInfo
	90, // 38: openim.group.GetGroupMemberCacheResp.member:type_name -> openim.sdkws.GroupMemberFullInfo
	82, // 39: openim.group.GroupCreateCountResp.count:type_name -> openim.group.GroupCreateCountResp.CountEntry
	89, // 40: openim.group.getGroupUsersReqApplicationListResp.groupRequests:type_name -> openim.sdkws.GroupRequest
	91, // 41: openim.group.notificationUserInfoUpdateReq.oldUserInfo:type_name -> openim.sdkws.UserInfo
	91, // 42: openim.group.notificationUserInfoUpdateReq.newUserInfo:type_name -> openim.sdkws.UserInfo
	90, // 43: openim.group.getIncrementalGroupMemberResp.insert:type_name -> openim.sdkws.GroupMemberFullInfo
	90, // 44: openim.group.getIncrementalGroupMemberResp.update:type_name -> openim.sdkws.GroupMemberFullInfo
	84, // 45: openim.group.getIncrementalGroupMemberResp.group:type_name -> openim.sdkws.GroupInfo
	84, // 46: openim.group.getIncrementalJoinGroupResp.insert:type_name -> openim.sdkws.GroupInfo
	84, // 47: openim.group.getIncrementalJoinGroupResp.update:type_name -> openim.sdkws.GroupInfo
	72, // 48: openim.group.BatchGetIncrementalGroupMemberReq.reqList:type_name -> openim.group.getIncrementalGroupMemberReq
	83, // 49: openim.group.BatchGetIncrementalGroupMemberResp.respList:type_name -> openim.group.BatchGetIncrementalGroupMemberResp.RespListEntry
	73, // 50: openim.group.BatchGetIncrementalGroupMemberResp.RespListEntry.value:type_name -> openim.group.getIncrementalGroupMemberResp
	0,  // 51: openim.group.group.createGroup:input_type -> openim.group.CreateGroupReq
	16, // 52: openim.group.group.joinGroup:input_type -> openim.group.JoinGroupReq
	20, // 53: openim.group.group.quitGroup:input_type -> openim.group.QuitGroupReq
	2,  // 54: openim.group.group.getGroupsInfo:input_type -> openim.group.GetGroupsInfoReq
	4,  // 55: openim.group.group.setGroupInfo:input_type -> openim.group.SetGroupInfoReq
	6,  // 56: openim.group.group.setGroupInfoEx:input_type -> openim.group.SetGroupInfoExReq
	8,  // 57: openim.group.group.getGroupApplicationList:input_type -> openim.group.GetGroupApplicationListReq
	10, // 58: openim.group.group.getUserReqApplicationList:input_type -> openim.group.GetUserReqApplicationListReq
	68, // 59: openim.group.group.getGroupUsersReqApplicationList:input_type -> openim.group.getGroupUsersReqApplicationListReq
	12, // 60: openim.group.group.getSpecifiedUserGroupRequestInfo:input_type -> openim.group.GetSpecifiedUserGroupRequestInfoReq
	14, // 61: openim.group.group.transferGroupOwner:input_type -> openim.group.TransferGroupOwnerReq
	18, // 62: openim.group.group.groupApplicationResponse:input_type -> openim.group.GroupApplicationResponseReq
	22, // 63: openim.group.group.getGroupMemberList:input_type -> openim.group.GetGroupMemberListReq
	24, // 64: openim.group.group.getGroupMembersInfo:input_type -> openim.group.GetGroupMembersInfoReq
	26, // 65: openim.group.group.kickGroupMember:input_type -> openim.group.KickGroupMemberReq
	28, // 66: openim.group.group.getJoinedGroupList:input_type -> openim.group.GetJoinedGroupListReq
	30, // 67: openim.group.group.inviteUserToGroup:input_type -> openim.group.InviteUserToGroupReq
	35, // 68: openim.group.group.getGroups:input_type -> openim.group.GetGroupsReq
	38, // 69: openim.group.group.getGroupMembersCMS:input_type -> openim.group.GetGroupMembersCMSReq
	40, // 70: openim.group.group.dismissGroup:input_type -> openim.group.DismissGroupReq
	42, // 71: openim.group.group.muteGroupMember:input_type -> openim.group.MuteGroupMemberReq
	44, // 72: openim.group.group.cancelMuteGroupMember:input_type -> openim.group.CancelMuteGroupMemberReq
	46, // 73: openim.group.group.muteGroup:input_type -> openim.group.MuteGroupReq
	48, // 74: openim.group.group.cancelMuteGroup:input_type -> openim.group.CancelMuteGroupReq
	51, // 75: openim.group.group.setGroupMemberInfo:input_type -> openim.group.SetGroupMemberInfoReq
	53, // 76: openim.group.group.getGroupAbstractInfo:input_type -> openim.group.GetGroupAbstractInfoReq
	56, // 77: openim.group.group.getUserInGroupMembers:input_type -> openim.group.GetUserInGroupMembersReq
	58, // 78: openim.group.group.getGroupMemberUserIDs:input_type -> openim.group.GetGroupMemberUserIDsReq
	60, // 79: openim.group.group.GetGroupMemberRoleLevel:input_type -> openim.group.GetGroupMemberRoleLevelReq
	62, // 80: openim.group.group.GetGroupInfoCache:input_type -> openim.group.GetGroupInfoCacheReq
	64, // 81: openim.group.group.GetGroupMemberCache:input_type -> openim.group.GetGroupMemberCacheReq
	66, // 82: openim.group.group.GroupCreateCount:input_type -> openim.group.GroupCreateCountReq
	70, // 83: openim.group.group.NotificationUserInfoUpdate:input_type -> openim.group.notificationUserInfoUpdateReq
	72, // 84: openim.group.group.getIncrementalGroupMember:input_type -> openim.group.getIncrementalGroupMemberReq
	80, // 85: openim.group.group.BatchGetIncrementalGroupMember:input_type -> openim.group.BatchGetIncrementalGroupMemberReq
	74, // 86: openim.group.group.getIncrementalJoinGroup:input_type -> openim.group.getIncrementalJoinGroupReq
	76, // 87: openim.group.group.GetFullGroupMemberUserIDs:input_type -> openim.group.GetFullGroupMemberUserIDsReq
	78, // 88: openim.group.group.GetFullJoinGroupIDs:input_type -> openim.group.GetFullJoinGroupIDsReq
	1,  // 89: openim.group.group.createGroup:output_type -> openim.group.CreateGroupResp
	17, // 90: openim.group.group.joinGroup:output_type -> openim.group.JoinGroupResp
	21, // 91: openim.group.group.quitGroup:output_type -> openim.group.QuitGroupResp
	3,  // 92: openim.group.group.getGroupsInfo:output_type -> openim.group.GetGroupsInfoResp
	5,  // 93: openim.group.group.setGroupInfo:output_type -> openim.group.SetGroupInfoResp
	7,  // 94: openim.group.group.setGroupInfoEx:output_type -> openim.group.SetGroupInfoExResp
	9,  // 95: openim.group.group.getGroupApplicationList:output_type -> openim.group.GetGroupApplicationListResp
	11, // 96: openim.group.group.getUserReqApplicationList:output_type -> openim.group.GetUserReqApplicationListResp
	69, // 97: openim.group.group.getGroupUsersReqApplicationList:output_type -> openim.group.getGroupUsersReqApplicationListResp
	13, // 98: openim.group.group.getSpecifiedUserGroupRequestInfo:output_type -> openim.group.GetSpecifiedUserGroupRequestInfoResp
	15, // 99: openim.group.group.transferGroupOwner:output_type -> openim.group.TransferGroupOwnerResp
	19, // 100: openim.group.group.groupApplicationResponse:output_type -> openim.group.GroupApplicationResponseResp
	23, // 101: openim.group.group.getGroupMemberList:output_type -> openim.group.GetGroupMemberListResp
	25, // 102: openim.group.group.getGroupMembersInfo:output_type -> openim.group.GetGroupMembersInfoResp
	27, // 103: openim.group.group.kickGroupMember:output_type -> openim.group.KickGroupMemberResp
	29, // 104: openim.group.group.getJoinedGroupList:output_type -> openim.group.GetJoinedGroupListResp
	31, // 105: openim.group.group.inviteUserToGroup:output_type -> openim.group.InviteUserToGroupResp
	36, // 106: openim.group.group.getGroups:output_type -> openim.group.GetGroupsResp
	39, // 107: openim.group.group.getGroupMembersCMS:output_type -> openim.group.GetGroupMembersCMSResp
	41, // 108: openim.group.group.dismissGroup:output_type -> openim.group.DismissGroupResp
	43, // 109: openim.group.group.muteGroupMember:output_type -> openim.group.MuteGroupMemberResp
	45, // 110: openim.group.group.cancelMuteGroupMember:output_type -> openim.group.CancelMuteGroupMemberResp
	47, // 111: openim.group.group.muteGroup:output_type -> openim.group.MuteGroupResp
	49, // 112: openim.group.group.cancelMuteGroup:output_type -> openim.group.CancelMuteGroupResp
	52, // 113: openim.group.group.setGroupMemberInfo:output_type -> openim.group.SetGroupMemberInfoResp
	55, // 114: openim.group.group.getGroupAbstractInfo:output_type -> openim.group.GetGroupAbstractInfoResp
	57, // 115: openim.group.group.getUserInGroupMembers:output_type -> openim.group.GetUserInGroupMembersResp
	59, // 116: openim.group.group.getGroupMemberUserIDs:output_type -> openim.group.GetGroupMemberUserIDsResp
	61, // 117: openim.group.group.GetGroupMemberRoleLevel:output_type -> openim.group.GetGroupMemberRoleLevelResp
	63, // 118: openim.group.group.GetGroupInfoCache:output_type -> openim.group.GetGroupInfoCacheResp
	65, // 119: openim.group.group.GetGroupMemberCache:output_type -> openim.group.GetGroupMemberCacheResp
	67, // 120: openim.group.group.GroupCreateCount:output_type -> openim.group.GroupCreateCountResp
	71, // 121: openim.group.group.NotificationUserInfoUpdate:output_type -> openim.group.notificationUserInfoUpdateResp
	73, // 122: openim.group.group.getIncrementalGroupMember:output_type -> openim.group.getIncrementalGroupMemberResp
	81, // 123: openim.group.group.BatchGetIncrementalGroupMember:output_type -> openim.group.BatchGetIncrementalGroupMemberResp
	75, // 124: openim.group.group.getIncrementalJoinGroup:output_type -> openim.group.getIncrementalJoinGroupResp
	77, // 125: openim.group.group.GetFullGroupMemberUserIDs:output_type -> openim.group.GetFullGroupMemberUserIDsResp
	79, // 126: openim.group.group.GetFullJoinGroupIDs:output_type -> openim.group.GetFullJoinGroupIDsResp
	89, // [89:127] is the sub-list for method output_type
	51, // [51:89] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_group_group_proto_init() }
func file_group_group_proto_init() {
	if File_group_group_proto != nil {
		return
	}
	file_group_group_proto_msgTypes[0].OneofWrappers = []any{}
	file_group_group_proto_msgTypes[26].OneofWrappers = []any{}
	file_group_group_proto_msgTypes[30].OneofWrappers = []any{}
	file_group_group_proto_msgTypes[40].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_group_group_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   84,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_group_group_proto_goTypes,
		DependencyIndexes: file_group_group_proto_depIdxs,
		MessageInfos:      file_group_group_proto_msgTypes,
	}.Build()
	File_group_group_proto = out.File
	file_group_group_proto_rawDesc = nil
	file_group_group_proto_goTypes = nil
	file_group_group_proto_depIdxs = nil
}
