// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.26.0
// source: conversation/conversation.proto

package conversation

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Conversation_GetConversation_FullMethodName                         = "/openim.conversation.conversation/GetConversation"
	Conversation_GetSortedConversationList_FullMethodName               = "/openim.conversation.conversation/GetSortedConversationList"
	Conversation_GetAllConversations_FullMethodName                     = "/openim.conversation.conversation/GetAllConversations"
	Conversation_GetConversations_FullMethodName                        = "/openim.conversation.conversation/GetConversations"
	Conversation_SetConversation_FullMethodName                         = "/openim.conversation.conversation/SetConversation"
	Conversation_GetRecvMsgNotNotifyUserIDs_FullMethodName              = "/openim.conversation.conversation/GetRecvMsgNotNotifyUserIDs"
	Conversation_CreateSingleChatConversations_FullMethodName           = "/openim.conversation.conversation/CreateSingleChatConversations"
	Conversation_CreateGroupChatConversations_FullMethodName            = "/openim.conversation.conversation/CreateGroupChatConversations"
	Conversation_SetConversationMaxSeq_FullMethodName                   = "/openim.conversation.conversation/SetConversationMaxSeq"
	Conversation_SetConversationMinSeq_FullMethodName                   = "/openim.conversation.conversation/SetConversationMinSeq"
	Conversation_GetConversationIDs_FullMethodName                      = "/openim.conversation.conversation/GetConversationIDs"
	Conversation_SetConversations_FullMethodName                        = "/openim.conversation.conversation/SetConversations"
	Conversation_GetUserConversationIDsHash_FullMethodName              = "/openim.conversation.conversation/GetUserConversationIDsHash"
	Conversation_GetConversationsByConversationID_FullMethodName        = "/openim.conversation.conversation/GetConversationsByConversationID"
	Conversation_GetConversationOfflinePushUserIDs_FullMethodName       = "/openim.conversation.conversation/GetConversationOfflinePushUserIDs"
	Conversation_GetConversationNotReceiveMessageUserIDs_FullMethodName = "/openim.conversation.conversation/GetConversationNotReceiveMessageUserIDs"
	Conversation_UpdateConversation_FullMethodName                      = "/openim.conversation.conversation/UpdateConversation"
	Conversation_GetFullOwnerConversationIDs_FullMethodName             = "/openim.conversation.conversation/GetFullOwnerConversationIDs"
	Conversation_GetIncrementalConversation_FullMethodName              = "/openim.conversation.conversation/GetIncrementalConversation"
	Conversation_GetOwnerConversation_FullMethodName                    = "/openim.conversation.conversation/GetOwnerConversation"
	Conversation_GetConversationsNeedClearMsg_FullMethodName            = "/openim.conversation.conversation/GetConversationsNeedClearMsg"
	Conversation_GetNotNotifyConversationIDs_FullMethodName             = "/openim.conversation.conversation/GetNotNotifyConversationIDs"
	Conversation_GetPinnedConversationIDs_FullMethodName                = "/openim.conversation.conversation/GetPinnedConversationIDs"
	Conversation_ClearUserConversationMsg_FullMethodName                = "/openim.conversation.conversation/ClearUserConversationMsg"
	Conversation_UpdateConversationsByUser_FullMethodName               = "/openim.conversation.conversation/UpdateConversationsByUser"
)

// ConversationClient is the client API for Conversation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationClient interface {
	GetConversation(ctx context.Context, in *GetConversationReq, opts ...grpc.CallOption) (*GetConversationResp, error)
	GetSortedConversationList(ctx context.Context, in *GetSortedConversationListReq, opts ...grpc.CallOption) (*GetSortedConversationListResp, error)
	GetAllConversations(ctx context.Context, in *GetAllConversationsReq, opts ...grpc.CallOption) (*GetAllConversationsResp, error)
	GetConversations(ctx context.Context, in *GetConversationsReq, opts ...grpc.CallOption) (*GetConversationsResp, error)
	SetConversation(ctx context.Context, in *SetConversationReq, opts ...grpc.CallOption) (*SetConversationResp, error)
	GetRecvMsgNotNotifyUserIDs(ctx context.Context, in *GetRecvMsgNotNotifyUserIDsReq, opts ...grpc.CallOption) (*GetRecvMsgNotNotifyUserIDsResp, error)
	CreateSingleChatConversations(ctx context.Context, in *CreateSingleChatConversationsReq, opts ...grpc.CallOption) (*CreateSingleChatConversationsResp, error)
	CreateGroupChatConversations(ctx context.Context, in *CreateGroupChatConversationsReq, opts ...grpc.CallOption) (*CreateGroupChatConversationsResp, error)
	SetConversationMaxSeq(ctx context.Context, in *SetConversationMaxSeqReq, opts ...grpc.CallOption) (*SetConversationMaxSeqResp, error)
	SetConversationMinSeq(ctx context.Context, in *SetConversationMinSeqReq, opts ...grpc.CallOption) (*SetConversationMinSeqResp, error)
	GetConversationIDs(ctx context.Context, in *GetConversationIDsReq, opts ...grpc.CallOption) (*GetConversationIDsResp, error)
	SetConversations(ctx context.Context, in *SetConversationsReq, opts ...grpc.CallOption) (*SetConversationsResp, error)
	GetUserConversationIDsHash(ctx context.Context, in *GetUserConversationIDsHashReq, opts ...grpc.CallOption) (*GetUserConversationIDsHashResp, error)
	GetConversationsByConversationID(ctx context.Context, in *GetConversationsByConversationIDReq, opts ...grpc.CallOption) (*GetConversationsByConversationIDResp, error)
	GetConversationOfflinePushUserIDs(ctx context.Context, in *GetConversationOfflinePushUserIDsReq, opts ...grpc.CallOption) (*GetConversationOfflinePushUserIDsResp, error)
	GetConversationNotReceiveMessageUserIDs(ctx context.Context, in *GetConversationNotReceiveMessageUserIDsReq, opts ...grpc.CallOption) (*GetConversationNotReceiveMessageUserIDsResp, error)
	UpdateConversation(ctx context.Context, in *UpdateConversationReq, opts ...grpc.CallOption) (*UpdateConversationResp, error)
	GetFullOwnerConversationIDs(ctx context.Context, in *GetFullOwnerConversationIDsReq, opts ...grpc.CallOption) (*GetFullOwnerConversationIDsResp, error)
	GetIncrementalConversation(ctx context.Context, in *GetIncrementalConversationReq, opts ...grpc.CallOption) (*GetIncrementalConversationResp, error)
	GetOwnerConversation(ctx context.Context, in *GetOwnerConversationReq, opts ...grpc.CallOption) (*GetOwnerConversationResp, error)
	GetConversationsNeedClearMsg(ctx context.Context, in *GetConversationsNeedClearMsgReq, opts ...grpc.CallOption) (*GetConversationsNeedClearMsgResp, error)
	GetNotNotifyConversationIDs(ctx context.Context, in *GetNotNotifyConversationIDsReq, opts ...grpc.CallOption) (*GetNotNotifyConversationIDsResp, error)
	GetPinnedConversationIDs(ctx context.Context, in *GetPinnedConversationIDsReq, opts ...grpc.CallOption) (*GetPinnedConversationIDsResp, error)
	ClearUserConversationMsg(ctx context.Context, in *ClearUserConversationMsgReq, opts ...grpc.CallOption) (*ClearUserConversationMsgResp, error)
	UpdateConversationsByUser(ctx context.Context, in *UpdateConversationsByUserReq, opts ...grpc.CallOption) (*UpdateConversationsByUserResp, error)
}

type conversationClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationClient(cc grpc.ClientConnInterface) ConversationClient {
	return &conversationClient{cc}
}

func (c *conversationClient) GetConversation(ctx context.Context, in *GetConversationReq, opts ...grpc.CallOption) (*GetConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetSortedConversationList(ctx context.Context, in *GetSortedConversationListReq, opts ...grpc.CallOption) (*GetSortedConversationListResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSortedConversationListResp)
	err := c.cc.Invoke(ctx, Conversation_GetSortedConversationList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetAllConversations(ctx context.Context, in *GetAllConversationsReq, opts ...grpc.CallOption) (*GetAllConversationsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetAllConversationsResp)
	err := c.cc.Invoke(ctx, Conversation_GetAllConversations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversations(ctx context.Context, in *GetConversationsReq, opts ...grpc.CallOption) (*GetConversationsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationsResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) SetConversation(ctx context.Context, in *SetConversationReq, opts ...grpc.CallOption) (*SetConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetConversationResp)
	err := c.cc.Invoke(ctx, Conversation_SetConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetRecvMsgNotNotifyUserIDs(ctx context.Context, in *GetRecvMsgNotNotifyUserIDsReq, opts ...grpc.CallOption) (*GetRecvMsgNotNotifyUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetRecvMsgNotNotifyUserIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetRecvMsgNotNotifyUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) CreateSingleChatConversations(ctx context.Context, in *CreateSingleChatConversationsReq, opts ...grpc.CallOption) (*CreateSingleChatConversationsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateSingleChatConversationsResp)
	err := c.cc.Invoke(ctx, Conversation_CreateSingleChatConversations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) CreateGroupChatConversations(ctx context.Context, in *CreateGroupChatConversationsReq, opts ...grpc.CallOption) (*CreateGroupChatConversationsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateGroupChatConversationsResp)
	err := c.cc.Invoke(ctx, Conversation_CreateGroupChatConversations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) SetConversationMaxSeq(ctx context.Context, in *SetConversationMaxSeqReq, opts ...grpc.CallOption) (*SetConversationMaxSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetConversationMaxSeqResp)
	err := c.cc.Invoke(ctx, Conversation_SetConversationMaxSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) SetConversationMinSeq(ctx context.Context, in *SetConversationMinSeqReq, opts ...grpc.CallOption) (*SetConversationMinSeqResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetConversationMinSeqResp)
	err := c.cc.Invoke(ctx, Conversation_SetConversationMinSeq_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversationIDs(ctx context.Context, in *GetConversationIDsReq, opts ...grpc.CallOption) (*GetConversationIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversationIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) SetConversations(ctx context.Context, in *SetConversationsReq, opts ...grpc.CallOption) (*SetConversationsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetConversationsResp)
	err := c.cc.Invoke(ctx, Conversation_SetConversations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetUserConversationIDsHash(ctx context.Context, in *GetUserConversationIDsHashReq, opts ...grpc.CallOption) (*GetUserConversationIDsHashResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUserConversationIDsHashResp)
	err := c.cc.Invoke(ctx, Conversation_GetUserConversationIDsHash_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversationsByConversationID(ctx context.Context, in *GetConversationsByConversationIDReq, opts ...grpc.CallOption) (*GetConversationsByConversationIDResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationsByConversationIDResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversationsByConversationID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversationOfflinePushUserIDs(ctx context.Context, in *GetConversationOfflinePushUserIDsReq, opts ...grpc.CallOption) (*GetConversationOfflinePushUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationOfflinePushUserIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversationOfflinePushUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversationNotReceiveMessageUserIDs(ctx context.Context, in *GetConversationNotReceiveMessageUserIDsReq, opts ...grpc.CallOption) (*GetConversationNotReceiveMessageUserIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationNotReceiveMessageUserIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversationNotReceiveMessageUserIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) UpdateConversation(ctx context.Context, in *UpdateConversationReq, opts ...grpc.CallOption) (*UpdateConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateConversationResp)
	err := c.cc.Invoke(ctx, Conversation_UpdateConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetFullOwnerConversationIDs(ctx context.Context, in *GetFullOwnerConversationIDsReq, opts ...grpc.CallOption) (*GetFullOwnerConversationIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFullOwnerConversationIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetFullOwnerConversationIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetIncrementalConversation(ctx context.Context, in *GetIncrementalConversationReq, opts ...grpc.CallOption) (*GetIncrementalConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetIncrementalConversationResp)
	err := c.cc.Invoke(ctx, Conversation_GetIncrementalConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetOwnerConversation(ctx context.Context, in *GetOwnerConversationReq, opts ...grpc.CallOption) (*GetOwnerConversationResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetOwnerConversationResp)
	err := c.cc.Invoke(ctx, Conversation_GetOwnerConversation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetConversationsNeedClearMsg(ctx context.Context, in *GetConversationsNeedClearMsgReq, opts ...grpc.CallOption) (*GetConversationsNeedClearMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetConversationsNeedClearMsgResp)
	err := c.cc.Invoke(ctx, Conversation_GetConversationsNeedClearMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetNotNotifyConversationIDs(ctx context.Context, in *GetNotNotifyConversationIDsReq, opts ...grpc.CallOption) (*GetNotNotifyConversationIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetNotNotifyConversationIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetNotNotifyConversationIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) GetPinnedConversationIDs(ctx context.Context, in *GetPinnedConversationIDsReq, opts ...grpc.CallOption) (*GetPinnedConversationIDsResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPinnedConversationIDsResp)
	err := c.cc.Invoke(ctx, Conversation_GetPinnedConversationIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) ClearUserConversationMsg(ctx context.Context, in *ClearUserConversationMsgReq, opts ...grpc.CallOption) (*ClearUserConversationMsgResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClearUserConversationMsgResp)
	err := c.cc.Invoke(ctx, Conversation_ClearUserConversationMsg_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationClient) UpdateConversationsByUser(ctx context.Context, in *UpdateConversationsByUserReq, opts ...grpc.CallOption) (*UpdateConversationsByUserResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateConversationsByUserResp)
	err := c.cc.Invoke(ctx, Conversation_UpdateConversationsByUser_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationServer is the server API for Conversation service.
// All implementations must embed UnimplementedConversationServer
// for forward compatibility.
type ConversationServer interface {
	GetConversation(context.Context, *GetConversationReq) (*GetConversationResp, error)
	GetSortedConversationList(context.Context, *GetSortedConversationListReq) (*GetSortedConversationListResp, error)
	GetAllConversations(context.Context, *GetAllConversationsReq) (*GetAllConversationsResp, error)
	GetConversations(context.Context, *GetConversationsReq) (*GetConversationsResp, error)
	SetConversation(context.Context, *SetConversationReq) (*SetConversationResp, error)
	GetRecvMsgNotNotifyUserIDs(context.Context, *GetRecvMsgNotNotifyUserIDsReq) (*GetRecvMsgNotNotifyUserIDsResp, error)
	CreateSingleChatConversations(context.Context, *CreateSingleChatConversationsReq) (*CreateSingleChatConversationsResp, error)
	CreateGroupChatConversations(context.Context, *CreateGroupChatConversationsReq) (*CreateGroupChatConversationsResp, error)
	SetConversationMaxSeq(context.Context, *SetConversationMaxSeqReq) (*SetConversationMaxSeqResp, error)
	SetConversationMinSeq(context.Context, *SetConversationMinSeqReq) (*SetConversationMinSeqResp, error)
	GetConversationIDs(context.Context, *GetConversationIDsReq) (*GetConversationIDsResp, error)
	SetConversations(context.Context, *SetConversationsReq) (*SetConversationsResp, error)
	GetUserConversationIDsHash(context.Context, *GetUserConversationIDsHashReq) (*GetUserConversationIDsHashResp, error)
	GetConversationsByConversationID(context.Context, *GetConversationsByConversationIDReq) (*GetConversationsByConversationIDResp, error)
	GetConversationOfflinePushUserIDs(context.Context, *GetConversationOfflinePushUserIDsReq) (*GetConversationOfflinePushUserIDsResp, error)
	GetConversationNotReceiveMessageUserIDs(context.Context, *GetConversationNotReceiveMessageUserIDsReq) (*GetConversationNotReceiveMessageUserIDsResp, error)
	UpdateConversation(context.Context, *UpdateConversationReq) (*UpdateConversationResp, error)
	GetFullOwnerConversationIDs(context.Context, *GetFullOwnerConversationIDsReq) (*GetFullOwnerConversationIDsResp, error)
	GetIncrementalConversation(context.Context, *GetIncrementalConversationReq) (*GetIncrementalConversationResp, error)
	GetOwnerConversation(context.Context, *GetOwnerConversationReq) (*GetOwnerConversationResp, error)
	GetConversationsNeedClearMsg(context.Context, *GetConversationsNeedClearMsgReq) (*GetConversationsNeedClearMsgResp, error)
	GetNotNotifyConversationIDs(context.Context, *GetNotNotifyConversationIDsReq) (*GetNotNotifyConversationIDsResp, error)
	GetPinnedConversationIDs(context.Context, *GetPinnedConversationIDsReq) (*GetPinnedConversationIDsResp, error)
	ClearUserConversationMsg(context.Context, *ClearUserConversationMsgReq) (*ClearUserConversationMsgResp, error)
	UpdateConversationsByUser(context.Context, *UpdateConversationsByUserReq) (*UpdateConversationsByUserResp, error)
	mustEmbedUnimplementedConversationServer()
}

// UnimplementedConversationServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedConversationServer struct{}

func (UnimplementedConversationServer) GetConversation(context.Context, *GetConversationReq) (*GetConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (UnimplementedConversationServer) GetSortedConversationList(context.Context, *GetSortedConversationListReq) (*GetSortedConversationListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSortedConversationList not implemented")
}
func (UnimplementedConversationServer) GetAllConversations(context.Context, *GetAllConversationsReq) (*GetAllConversationsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllConversations not implemented")
}
func (UnimplementedConversationServer) GetConversations(context.Context, *GetConversationsReq) (*GetConversationsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversations not implemented")
}
func (UnimplementedConversationServer) SetConversation(context.Context, *SetConversationReq) (*SetConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConversation not implemented")
}
func (UnimplementedConversationServer) GetRecvMsgNotNotifyUserIDs(context.Context, *GetRecvMsgNotNotifyUserIDsReq) (*GetRecvMsgNotNotifyUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecvMsgNotNotifyUserIDs not implemented")
}
func (UnimplementedConversationServer) CreateSingleChatConversations(context.Context, *CreateSingleChatConversationsReq) (*CreateSingleChatConversationsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSingleChatConversations not implemented")
}
func (UnimplementedConversationServer) CreateGroupChatConversations(context.Context, *CreateGroupChatConversationsReq) (*CreateGroupChatConversationsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroupChatConversations not implemented")
}
func (UnimplementedConversationServer) SetConversationMaxSeq(context.Context, *SetConversationMaxSeqReq) (*SetConversationMaxSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConversationMaxSeq not implemented")
}
func (UnimplementedConversationServer) SetConversationMinSeq(context.Context, *SetConversationMinSeqReq) (*SetConversationMinSeqResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConversationMinSeq not implemented")
}
func (UnimplementedConversationServer) GetConversationIDs(context.Context, *GetConversationIDsReq) (*GetConversationIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationIDs not implemented")
}
func (UnimplementedConversationServer) SetConversations(context.Context, *SetConversationsReq) (*SetConversationsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConversations not implemented")
}
func (UnimplementedConversationServer) GetUserConversationIDsHash(context.Context, *GetUserConversationIDsHashReq) (*GetUserConversationIDsHashResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserConversationIDsHash not implemented")
}
func (UnimplementedConversationServer) GetConversationsByConversationID(context.Context, *GetConversationsByConversationIDReq) (*GetConversationsByConversationIDResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationsByConversationID not implemented")
}
func (UnimplementedConversationServer) GetConversationOfflinePushUserIDs(context.Context, *GetConversationOfflinePushUserIDsReq) (*GetConversationOfflinePushUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationOfflinePushUserIDs not implemented")
}
func (UnimplementedConversationServer) GetConversationNotReceiveMessageUserIDs(context.Context, *GetConversationNotReceiveMessageUserIDsReq) (*GetConversationNotReceiveMessageUserIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationNotReceiveMessageUserIDs not implemented")
}
func (UnimplementedConversationServer) UpdateConversation(context.Context, *UpdateConversationReq) (*UpdateConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversation not implemented")
}
func (UnimplementedConversationServer) GetFullOwnerConversationIDs(context.Context, *GetFullOwnerConversationIDsReq) (*GetFullOwnerConversationIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFullOwnerConversationIDs not implemented")
}
func (UnimplementedConversationServer) GetIncrementalConversation(context.Context, *GetIncrementalConversationReq) (*GetIncrementalConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncrementalConversation not implemented")
}
func (UnimplementedConversationServer) GetOwnerConversation(context.Context, *GetOwnerConversationReq) (*GetOwnerConversationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOwnerConversation not implemented")
}
func (UnimplementedConversationServer) GetConversationsNeedClearMsg(context.Context, *GetConversationsNeedClearMsgReq) (*GetConversationsNeedClearMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationsNeedClearMsg not implemented")
}
func (UnimplementedConversationServer) GetNotNotifyConversationIDs(context.Context, *GetNotNotifyConversationIDsReq) (*GetNotNotifyConversationIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotNotifyConversationIDs not implemented")
}
func (UnimplementedConversationServer) GetPinnedConversationIDs(context.Context, *GetPinnedConversationIDsReq) (*GetPinnedConversationIDsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPinnedConversationIDs not implemented")
}
func (UnimplementedConversationServer) ClearUserConversationMsg(context.Context, *ClearUserConversationMsgReq) (*ClearUserConversationMsgResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearUserConversationMsg not implemented")
}
func (UnimplementedConversationServer) UpdateConversationsByUser(context.Context, *UpdateConversationsByUserReq) (*UpdateConversationsByUserResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversationsByUser not implemented")
}
func (UnimplementedConversationServer) mustEmbedUnimplementedConversationServer() {}
func (UnimplementedConversationServer) testEmbeddedByValue()                      {}

// UnsafeConversationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationServer will
// result in compilation errors.
type UnsafeConversationServer interface {
	mustEmbedUnimplementedConversationServer()
}

func RegisterConversationServer(s grpc.ServiceRegistrar, srv ConversationServer) {
	// If the following call pancis, it indicates UnimplementedConversationServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Conversation_ServiceDesc, srv)
}

func _Conversation_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversation(ctx, req.(*GetConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetSortedConversationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSortedConversationListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetSortedConversationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetSortedConversationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetSortedConversationList(ctx, req.(*GetSortedConversationListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetAllConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllConversationsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetAllConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetAllConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetAllConversations(ctx, req.(*GetAllConversationsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversations(ctx, req.(*GetConversationsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_SetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).SetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_SetConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).SetConversation(ctx, req.(*SetConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetRecvMsgNotNotifyUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecvMsgNotNotifyUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetRecvMsgNotNotifyUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetRecvMsgNotNotifyUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetRecvMsgNotNotifyUserIDs(ctx, req.(*GetRecvMsgNotNotifyUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_CreateSingleChatConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSingleChatConversationsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).CreateSingleChatConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_CreateSingleChatConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).CreateSingleChatConversations(ctx, req.(*CreateSingleChatConversationsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_CreateGroupChatConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupChatConversationsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).CreateGroupChatConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_CreateGroupChatConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).CreateGroupChatConversations(ctx, req.(*CreateGroupChatConversationsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_SetConversationMaxSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConversationMaxSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).SetConversationMaxSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_SetConversationMaxSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).SetConversationMaxSeq(ctx, req.(*SetConversationMaxSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_SetConversationMinSeq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConversationMinSeqReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).SetConversationMinSeq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_SetConversationMinSeq_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).SetConversationMinSeq(ctx, req.(*SetConversationMinSeqReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversationIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversationIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversationIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversationIDs(ctx, req.(*GetConversationIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_SetConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConversationsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).SetConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_SetConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).SetConversations(ctx, req.(*SetConversationsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetUserConversationIDsHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserConversationIDsHashReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetUserConversationIDsHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetUserConversationIDsHash_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetUserConversationIDsHash(ctx, req.(*GetUserConversationIDsHashReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversationsByConversationID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationsByConversationIDReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversationsByConversationID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversationsByConversationID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversationsByConversationID(ctx, req.(*GetConversationsByConversationIDReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversationOfflinePushUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationOfflinePushUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversationOfflinePushUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversationOfflinePushUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversationOfflinePushUserIDs(ctx, req.(*GetConversationOfflinePushUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversationNotReceiveMessageUserIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationNotReceiveMessageUserIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversationNotReceiveMessageUserIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversationNotReceiveMessageUserIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversationNotReceiveMessageUserIDs(ctx, req.(*GetConversationNotReceiveMessageUserIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_UpdateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).UpdateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_UpdateConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).UpdateConversation(ctx, req.(*UpdateConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetFullOwnerConversationIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFullOwnerConversationIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetFullOwnerConversationIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetFullOwnerConversationIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetFullOwnerConversationIDs(ctx, req.(*GetFullOwnerConversationIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetIncrementalConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncrementalConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetIncrementalConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetIncrementalConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetIncrementalConversation(ctx, req.(*GetIncrementalConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetOwnerConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOwnerConversationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetOwnerConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetOwnerConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetOwnerConversation(ctx, req.(*GetOwnerConversationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetConversationsNeedClearMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationsNeedClearMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetConversationsNeedClearMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetConversationsNeedClearMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetConversationsNeedClearMsg(ctx, req.(*GetConversationsNeedClearMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetNotNotifyConversationIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotNotifyConversationIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetNotNotifyConversationIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetNotNotifyConversationIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetNotNotifyConversationIDs(ctx, req.(*GetNotNotifyConversationIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_GetPinnedConversationIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPinnedConversationIDsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).GetPinnedConversationIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_GetPinnedConversationIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).GetPinnedConversationIDs(ctx, req.(*GetPinnedConversationIDsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_ClearUserConversationMsg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClearUserConversationMsgReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).ClearUserConversationMsg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_ClearUserConversationMsg_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).ClearUserConversationMsg(ctx, req.(*ClearUserConversationMsgReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversation_UpdateConversationsByUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationsByUserReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationServer).UpdateConversationsByUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversation_UpdateConversationsByUser_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationServer).UpdateConversationsByUser(ctx, req.(*UpdateConversationsByUserReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Conversation_ServiceDesc is the grpc.ServiceDesc for Conversation service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Conversation_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openim.conversation.conversation",
	HandlerType: (*ConversationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetConversation",
			Handler:    _Conversation_GetConversation_Handler,
		},
		{
			MethodName: "GetSortedConversationList",
			Handler:    _Conversation_GetSortedConversationList_Handler,
		},
		{
			MethodName: "GetAllConversations",
			Handler:    _Conversation_GetAllConversations_Handler,
		},
		{
			MethodName: "GetConversations",
			Handler:    _Conversation_GetConversations_Handler,
		},
		{
			MethodName: "SetConversation",
			Handler:    _Conversation_SetConversation_Handler,
		},
		{
			MethodName: "GetRecvMsgNotNotifyUserIDs",
			Handler:    _Conversation_GetRecvMsgNotNotifyUserIDs_Handler,
		},
		{
			MethodName: "CreateSingleChatConversations",
			Handler:    _Conversation_CreateSingleChatConversations_Handler,
		},
		{
			MethodName: "CreateGroupChatConversations",
			Handler:    _Conversation_CreateGroupChatConversations_Handler,
		},
		{
			MethodName: "SetConversationMaxSeq",
			Handler:    _Conversation_SetConversationMaxSeq_Handler,
		},
		{
			MethodName: "SetConversationMinSeq",
			Handler:    _Conversation_SetConversationMinSeq_Handler,
		},
		{
			MethodName: "GetConversationIDs",
			Handler:    _Conversation_GetConversationIDs_Handler,
		},
		{
			MethodName: "SetConversations",
			Handler:    _Conversation_SetConversations_Handler,
		},
		{
			MethodName: "GetUserConversationIDsHash",
			Handler:    _Conversation_GetUserConversationIDsHash_Handler,
		},
		{
			MethodName: "GetConversationsByConversationID",
			Handler:    _Conversation_GetConversationsByConversationID_Handler,
		},
		{
			MethodName: "GetConversationOfflinePushUserIDs",
			Handler:    _Conversation_GetConversationOfflinePushUserIDs_Handler,
		},
		{
			MethodName: "GetConversationNotReceiveMessageUserIDs",
			Handler:    _Conversation_GetConversationNotReceiveMessageUserIDs_Handler,
		},
		{
			MethodName: "UpdateConversation",
			Handler:    _Conversation_UpdateConversation_Handler,
		},
		{
			MethodName: "GetFullOwnerConversationIDs",
			Handler:    _Conversation_GetFullOwnerConversationIDs_Handler,
		},
		{
			MethodName: "GetIncrementalConversation",
			Handler:    _Conversation_GetIncrementalConversation_Handler,
		},
		{
			MethodName: "GetOwnerConversation",
			Handler:    _Conversation_GetOwnerConversation_Handler,
		},
		{
			MethodName: "GetConversationsNeedClearMsg",
			Handler:    _Conversation_GetConversationsNeedClearMsg_Handler,
		},
		{
			MethodName: "GetNotNotifyConversationIDs",
			Handler:    _Conversation_GetNotNotifyConversationIDs_Handler,
		},
		{
			MethodName: "GetPinnedConversationIDs",
			Handler:    _Conversation_GetPinnedConversationIDs_Handler,
		},
		{
			MethodName: "ClearUserConversationMsg",
			Handler:    _Conversation_ClearUserConversationMsg_Handler,
		},
		{
			MethodName: "UpdateConversationsByUser",
			Handler:    _Conversation_UpdateConversationsByUser_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "conversation/conversation.proto",
}
