// Copyright (c) Aptos
// SPDX-License-Identifier: Apache-2.0

use crate::account_config::constants::CORE_CODE_ADDRESS;
use move_core_types::{ident_str, identifier::IdentStr, language_storage::ModuleId};
use once_cell::sync::Lazy;

pub const EVENT_MODULE_IDENTIFIER: &IdentStr = ident_str!("Event");
pub static EVENT_MODULE: Lazy<ModuleId> =
    Lazy::new(|| ModuleId::new(CORE_CODE_ADDRESS, EVENT_MODULE_IDENTIFIER.to_owned()));
