/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.GLRenderWrapper;
import com.robotium.solo.Reflect;
import com.robotium.solo.Sleeper;
import com.robotium.solo.Solo;
import com.robotium.solo.Timeout;
import com.robotium.solo.ViewFetcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ScreenshotTaker {
    private static final long TIMEOUT_SCREENSHOT_MUTEX = TimeUnit.SECONDS.toMillis(2L);
    private final Object screenshotMutex = new Object();
    private final Solo.Config config;
    private final ActivityUtils activityUtils;
    private final String LOG_TAG = "Robotium";
    private ScreenshotSequenceThread screenshotSequenceThread = null;
    private HandlerThread screenShotSaverThread = null;
    private ScreenShotSaver screenShotSaver = null;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    ScreenshotTaker(Solo.Config config, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.config = config;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeScreenshot(String name, int quality) {
        View decorView = this.getScreenshotView();
        if (decorView == null) {
            return;
        }
        this.initScreenShotSaver();
        ScreenshotRunnable runnable = new ScreenshotRunnable(decorView, name, quality);
        Object object = this.screenshotMutex;
        synchronized (object) {
            this.activityUtils.getCurrentActivity(false).runOnUiThread((Runnable)runnable);
            try {
                this.screenshotMutex.wait(TIMEOUT_SCREENSHOT_MUTEX);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
    }

    public void startScreenshotSequence(String name, int quality, int frameDelay, int maxFrames) {
        this.initScreenShotSaver();
        if (this.screenshotSequenceThread != null) {
            throw new RuntimeException("only one screenshot sequence is supported at a time");
        }
        this.screenshotSequenceThread = new ScreenshotSequenceThread(name, quality, frameDelay, maxFrames);
        this.screenshotSequenceThread.start();
    }

    public void stopScreenshotSequence() {
        if (this.screenshotSequenceThread != null) {
            this.screenshotSequenceThread.interrupt();
            this.screenshotSequenceThread = null;
        }
    }

    private View getScreenshotView() {
        View decorView = this.viewFetcher.getRecentDecorView(this.viewFetcher.getWindowDecorViews());
        long endTime = SystemClock.uptimeMillis() + (long)Timeout.getSmallTimeout();
        while (decorView == null) {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                return null;
            }
            this.sleeper.sleepMini();
            decorView = this.viewFetcher.getRecentDecorView(this.viewFetcher.getWindowDecorViews());
        }
        this.wrapAllGLViews(decorView);
        return decorView;
    }

    private void wrapAllGLViews(View decorView) {
        ArrayList<GLSurfaceView> currentViews = this.viewFetcher.getCurrentViews(GLSurfaceView.class, true, decorView);
        CountDownLatch latch = new CountDownLatch(currentViews.size());
        for (GLSurfaceView glView : currentViews) {
            GLRenderWrapper wrapper;
            Object renderContainer = new Reflect(glView).field("mGLThread").type(GLSurfaceView.class).out(Object.class);
            GLSurfaceView.Renderer renderer = new Reflect(renderContainer).field("mRenderer").out(GLSurfaceView.Renderer.class);
            if (renderer == null) {
                renderer = new Reflect(glView).field("mRenderer").out(GLSurfaceView.Renderer.class);
                renderContainer = glView;
            }
            if (renderer == null) {
                latch.countDown();
                continue;
            }
            if (renderer instanceof GLRenderWrapper) {
                wrapper = (GLRenderWrapper)renderer;
                wrapper.setTakeScreenshot();
                wrapper.setLatch(latch);
                continue;
            }
            wrapper = new GLRenderWrapper(glView, renderer, latch);
            new Reflect(renderContainer).field("mRenderer").in(wrapper);
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private Bitmap getBitmapOfWebView(WebView webView) {
        Picture picture = webView.capturePicture();
        Bitmap b = Bitmap.createBitmap((int)picture.getWidth(), (int)picture.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        picture.draw(c);
        return b;
    }

    private Bitmap getBitmapOfView(View view) {
        view.destroyDrawingCache();
        view.buildDrawingCache(false);
        Bitmap orig = view.getDrawingCache();
        Bitmap.Config config = null;
        if (orig == null) {
            return null;
        }
        config = orig.getConfig();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        Bitmap b = orig.copy(config, false);
        orig.recycle();
        view.destroyDrawingCache();
        return b;
    }

    private String getFileName(String name) {
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy-hhmmss");
        String fileName = null;
        fileName = name == null ? (this.config.screenshotFileType == Solo.Config.ScreenshotFileType.JPEG ? sdf.format(new Date()).toString() + ".jpg" : sdf.format(new Date()).toString() + ".png") : (this.config.screenshotFileType == Solo.Config.ScreenshotFileType.JPEG ? name + ".jpg" : name + ".png");
        return fileName;
    }

    private void initScreenShotSaver() {
        if (this.screenShotSaverThread == null || this.screenShotSaver == null) {
            this.screenShotSaverThread = new HandlerThread("ScreenShotSaver");
            this.screenShotSaverThread.start();
            this.screenShotSaver = new ScreenShotSaver(this.screenShotSaverThread);
        }
    }

    private class ScreenShotSaver
    extends Handler {
        public ScreenShotSaver(HandlerThread thread) {
            super(thread.getLooper());
        }

        public void saveBitmap(Bitmap bitmap, String name, int quality) {
            Message message = this.obtainMessage();
            message.arg1 = quality;
            message.obj = bitmap;
            message.getData().putString("name", name);
            this.sendMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            Object object = ScreenshotTaker.this.screenshotMutex;
            synchronized (object) {
                String name = message.getData().getString("name");
                int quality = message.arg1;
                Bitmap b = (Bitmap)message.obj;
                if (b != null) {
                    this.saveFile(name, b, quality);
                    b.recycle();
                } else {
                    Log.d((String)"Robotium", (String)"NULL BITMAP!!");
                }
                ScreenshotTaker.this.screenshotMutex.notify();
            }
        }

        private void saveFile(String name, Bitmap b, int quality) {
            FileOutputStream fos = null;
            String fileName = ScreenshotTaker.this.getFileName(name);
            File directory = new File(((ScreenshotTaker)ScreenshotTaker.this).config.screenshotSavePath);
            directory.mkdir();
            File fileToSave = new File(directory, fileName);
            try {
                fos = new FileOutputStream(fileToSave);
                if (((ScreenshotTaker)ScreenshotTaker.this).config.screenshotFileType == Solo.Config.ScreenshotFileType.JPEG) {
                    if (!b.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)fos)) {
                        Log.d((String)"Robotium", (String)"Compress/Write failed");
                    }
                } else if (!b.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)fos)) {
                    Log.d((String)"Robotium", (String)"Compress/Write failed");
                }
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                Log.d((String)"Robotium", (String)"Can't save the screenshot! Requires write permission (android.permission.WRITE_EXTERNAL_STORAGE) in AndroidManifest.xml of the application under test.");
                e.printStackTrace();
            }
        }
    }

    private class ScreenshotRunnable
    implements Runnable {
        private View view;
        private String name;
        private int quality;

        public ScreenshotRunnable(View _view, String _name, int _quality) {
            this.view = _view;
            this.name = _name;
            this.quality = _quality;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.view != null) {
                Bitmap b = this.view instanceof WebView ? ScreenshotTaker.this.getBitmapOfWebView((WebView)this.view) : ScreenshotTaker.this.getBitmapOfView(this.view);
                if (b != null) {
                    ScreenshotTaker.this.screenShotSaver.saveBitmap(b, this.name, this.quality);
                    b = null;
                    return;
                }
                Log.d((String)"Robotium", (String)"NULL BITMAP!!");
            }
            Object object = ScreenshotTaker.this.screenshotMutex;
            synchronized (object) {
                ScreenshotTaker.this.screenshotMutex.notify();
            }
        }
    }

    private class ScreenshotSequenceThread
    extends Thread {
        private int seqno = 0;
        private String name;
        private int quality;
        private int frameDelay;
        private int maxFrames;
        private boolean keepRunning = true;

        public ScreenshotSequenceThread(String _name, int _quality, int _frameDelay, int _maxFrames) {
            this.name = _name;
            this.quality = _quality;
            this.frameDelay = _frameDelay;
            this.maxFrames = _maxFrames;
        }

        public void run() {
            while (this.seqno < this.maxFrames && this.keepRunning && !Thread.interrupted()) {
                this.doScreenshot();
                ++this.seqno;
                try {
                    Thread.sleep(this.frameDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
            ScreenshotTaker.this.screenshotSequenceThread = null;
        }

        public void doScreenshot() {
            View v = ScreenshotTaker.this.getScreenshotView();
            if (v == null) {
                this.keepRunning = false;
            }
            String final_name = this.name + "_" + this.seqno;
            ScreenshotRunnable r = new ScreenshotRunnable(v, final_name, this.quality);
            Log.d((String)"Robotium", (String)("taking screenshot " + final_name));
            ScreenshotTaker.this.activityUtils.getCurrentActivity(false).runOnUiThread((Runnable)r);
        }

        public void interrupt() {
            this.keepRunning = false;
            super.interrupt();
        }
    }
}

