// ThreeCanvas.js r41/ROME - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex},setHex:function(a){this.hex=~~a&16777215;this.updateRGB()},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;this.updateHex()},setHSV:function(a,b,c){var d,e,g,f,h,j;if(c==0)d=e=g=0;else switch(f=Math.floor(a*6),h=a*6-f,a=c*(1-b),j=c*(1-b*h),b=c*(1-b*(1-h)),f){case 1:d=j;e=c;g=a;break;case 2:d=a;e=c;g=b;break;case 3:d=a;e=j;g=c;break;case 4:d=b;e=a;g=c;break;case 5:d=c;e=a;g=j;break;case 6:case 0:d=c,e=b,g=a}this.setRGB(d,
e,g)},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},divideScalar:function(a){a?
(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},unit:function(){return this.normalize()}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){return this.divide(this,a)},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*
a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*
a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};
THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){return this.set(a.x,a.y,a.z,a.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d;d=c.position.clone().subSelf(a).dot(b);if(d<0)return!1;a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.position.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),c=c.clone().subSelf(b),
e=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(e),f=c.dot(c),c=c.dot(e),e=1/(a*f-b*b),f=(f*d-b*c)*e,a=(a*c-b*d)*e;return f>0&&a>0&&f+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a);if(!d||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a);if(!d||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)))return[];var e,g,f,h,j,k,m,p,l,n,i=a.geometry,
q=i.vertices,v=[],d=0;for(e=i.faces.length;d<e;d++)if(g=i.faces[d],l=this.origin.clone(),n=this.direction.clone(),k=a.matrixWorld,f=k.multiplyVector3(q[g.a].position.clone()),h=k.multiplyVector3(q[g.b].position.clone()),j=k.multiplyVector3(q[g.c].position.clone()),k=g instanceof THREE.Face4?k.multiplyVector3(q[g.d].position.clone()):null,m=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),p=n.dot(m),a.doubleSided||(a.flipSided?p>0:p<0))if(m=m.dot((new THREE.Vector3).sub(f,l))/p,l=l.addSelf(n.multiplyScalar(m)),
g instanceof THREE.Face3)c(l,f,h,j)&&(g={distance:this.origin.distanceTo(l),point:l,face:g,object:a},v.push(g));else if(g instanceof THREE.Face4&&(c(l,f,h,k)||c(l,h,j,k)))g={distance:this.origin.distanceTo(l),point:l,face:g,object:a},v.push(g);return v}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;f=e-c}var b,c,d,e,g,f,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,m,p){h=!1;b=f;c=g;d=m;e=p;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,m,p,l,n){h?(h=!1,b=f<m?f<l?f:l:m<l?m:l,c=g<p?g<n?g:n:p<n?p:n,d=f>m?f>l?f:l:m>l?m:l,e=g>p?g>n?g:n:p>n?p:n):(b=f<m?f<l?f<b?f:b:l<b?l:b:m<l?m<b?m:b:l<b?l:b,c=g<p?g<n?g<c?g:c:n<c?n:c:p<n?p<c?p:c:n<c?n:c,d=f>m?f>l?f>d?f:d:l>d?l:d:m>l?m>d?m:d:l>d?l:d,e=g>p?g>n?g>e?g:e:n>e?n:e:p>n?p>e?p:e:n>e?n:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.instersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(e,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,g,f,h,j,k,m,p,l,n,i,q){this.set(a||1,b||0,c||0,d||0,e||0,g||1,f||0,h||0,j||0,k||0,m||1,p||0,l||0,n||0,i||0,q||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,g,f,h,j,k,m,p,l,n,i,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=g;this.n23=f;this.n24=h;this.n31=j;this.n32=k;this.n33=m;this.n34=p;this.n41=l;this.n42=n;this.n43=i;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__v1,
e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());e.cross(g,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*
d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,j=a.n23,k=a.n24,m=a.n31,p=a.n32,l=a.n33,n=a.n34,i=a.n41,q=a.n42,v=a.n43,t=a.n44,G=b.n11,K=b.n12,x=b.n13,B=b.n14,o=b.n21,M=b.n22,
r=b.n23,u=b.n24,y=b.n31,Q=b.n32,$=b.n33,Z=b.n34;this.n11=c*G+d*o+e*y;this.n12=c*K+d*M+e*Q;this.n13=c*x+d*r+e*$;this.n14=c*B+d*u+e*Z+g;this.n21=f*G+h*o+j*y;this.n22=f*K+h*M+j*Q;this.n23=f*x+h*r+j*$;this.n24=f*B+h*u+j*Z+k;this.n31=m*G+p*o+l*y;this.n32=m*K+p*M+l*Q;this.n33=m*x+p*r+l*$;this.n34=m*B+p*u+l*Z+n;this.n41=i*G+q*o+v*y;this.n42=i*K+q*M+v*Q;this.n43=i*x+q*r+v*$;this.n44=i*B+q*u+v*Z+t;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=
this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=
this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,g=this.n22,f=this.n23,h=this.n24,j=this.n31,k=this.n32,m=this.n33,p=this.n34,l=this.n41,n=this.n42,i=this.n43,q=this.n44;return d*f*k*l-c*h*k*l-d*g*m*l+b*h*m*l+c*g*p*l-b*f*p*l-d*f*j*n+c*h*j*n+d*e*m*n-a*h*m*n-c*e*p*n+a*f*p*n+d*g*j*i-b*h*j*i-d*e*k*i+a*h*k*i+b*e*p*i-a*g*p*i-c*g*j*q+b*f*j*q+c*e*k*q-a*f*k*q-b*e*m*q+a*g*m*q},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=
this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;
this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=
this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,
b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,g=a.x,f=a.y,h=a.z,j=e*g,k=e*f;this.set(j*
g+c,j*f-d*h,j*h+d*f,0,j*f+d*h,k*f+c,k*h-d*g,0,j*h-d*f,k*h+d*g,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;
this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z,a=Math.cos(b),b=Math.sin(b),e=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),f=a*c,h=b*c;this.n11=e*g;this.n12=-e*d;this.n13=c;this.n21=h*g+a*d;this.n22=-h*d+a*g;this.n23=-b*e;this.n31=-f*g+b*d;this.n32=f*d+b*g;this.n33=a*e;return this},
setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,g=b+b,f=c+c,h=d+d,a=b*g,j=b*f;b*=h;var k=c*f;c*=h;d*=h;g*=e;f*=e;e*=h;this.n11=1-(k+d);this.n12=j-e;this.n13=b+f;this.n21=j+e;this.n22=1-(a+d);this.n23=c-g;this.n31=b-f;this.n32=c+g;this.n33=1-(a+k);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=
a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,j=a.n23,k=a.n24,m=a.n31,p=a.n32,l=a.n33,n=a.n34,i=a.n41,q=a.n42,v=a.n43,t=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=j*n*q-k*l*q+k*p*v-h*n*v-j*p*t+h*l*t;b.n12=g*l*q-e*n*q-g*p*v+d*n*v+e*p*t-d*l*t;b.n13=e*k*q-g*j*q+g*h*v-d*k*v-e*h*t+d*j*t;b.n14=g*j*p-e*k*p-g*h*l+d*k*l+e*h*n-d*j*n;b.n21=k*l*i-j*n*i-k*m*v+f*n*v+j*m*t-f*l*t;b.n22=e*n*i-g*l*i+g*m*v-c*n*v-e*m*t+c*l*t;b.n23=g*j*i-e*k*i-g*f*v+c*k*v+e*f*t-c*j*t;b.n24=
e*k*m-g*j*m+g*f*l-c*k*l-e*f*n+c*j*n;b.n31=h*n*i-k*p*i+k*m*q-f*n*q-h*m*t+f*p*t;b.n32=g*p*i-d*n*i-g*m*q+c*n*q+d*m*t-c*p*t;b.n33=e*k*i-g*h*i+g*f*q-c*k*q-d*f*t+c*h*t;b.n34=g*h*m-d*k*m-g*f*p+c*k*p+d*f*n-c*h*n;b.n41=j*p*i-h*l*i-j*m*q+f*l*q+h*m*v-f*p*v;b.n42=d*l*i-e*p*i+e*m*q-c*l*q-d*m*v+c*p*v;b.n43=e*h*i-d*j*i-e*f*q+c*j*q+d*f*v-c*h*v;b.n44=d*j*m-e*h*m+e*f*p-c*j*p-d*f*l+c*h*l;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,j=-a.n32*a.n11+a.n31*a.n12,k=a.n23*a.n12-a.n22*a.n13,m=-a.n23*a.n11+a.n21*a.n13,p=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*f+a.n31*k;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*g;c[3]=a*f;c[4]=a*h;c[5]=a*j;c[6]=a*k;c[7]=a*m;c[8]=a*p;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,g){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(g+e)/(g-e);f.n34=-2*g*e/(g-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,g){var f,h,j,k;f=new THREE.Matrix4;h=b-a;j=c-d;k=g-e;f.n11=2/h;f.n12=0;f.n13=0;f.n14=-((b+a)/h);f.n21=0;f.n22=2/j;f.n23=0;f.n24=-((c+d)/j);f.n31=0;f.n32=0;f.n33=-2/k;f.n34=-((g+e)/k);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.dynamic=!1;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;
this.visible=!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1)a.parent=void 0,this.children.splice(b,1)},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a)return e;if(b&&(e=e.getChildByName(a,b),e!==void 0))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,
this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),g=Math.cos(c),c=Math.sin(c),f=a*b,h=d*e;this.w=f*g-h*c;this.x=f*c+h*g;this.y=d*b*g+a*e*c;this.z=a*e*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*
d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},
multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,g=a.x,f=a.y,h=a.z,a=a.w;this.x=b*a+e*g+c*h-d*f;this.y=c*a+e*f+d*g-b*h;this.z=d*a+e*h+b*f-c*g;this.w=e*a-b*g-c*f-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,g=this.x,f=this.y,h=this.z,j=this.w,k=j*c+f*e-h*d,m=
j*d+h*c-g*e,p=j*e+g*d-f*c,c=-g*c-f*d-h*e;b.x=k*j+c*-g+m*-h-p*-f;b.y=m*j+c*-f+p*-g-k*-h;b.z=p*j+c*-h+k*-f-m*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;e=Math.sin((1-d)*g)/f;d=Math.sin(d*g)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,g,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),
c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,c,d,e,g,f,h=new THREE.Vector3,j=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],f=this.vertices[g.c],h.sub(f.position,c.position),j.sub(b.position,c.position),h.crossSelf(j);h.isZero()||
h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,e,g,r){h=a.vertices[b].position;j=a.vertices[c].position;k=a.vertices[d].position;m=f[e];p=f[g];l=f[r];n=j.x-h.x;i=k.x-h.x;q=j.y-h.y;v=k.y-h.y;t=j.z-h.z;G=k.z-h.z;K=p.u-m.u;x=l.u-m.u;B=p.v-m.v;o=l.v-m.v;M=1/(K*o-x*B);Q.set((o*n-B*i)*
M,(o*q-B*v)*M,(o*t-B*G)*M);$.set((K*i-x*n)*M,(K*v-x*q)*M,(K*G-x*t)*M);u[b].addSelf(Q);u[c].addSelf(Q);u[d].addSelf(Q);y[b].addSelf($);y[c].addSelf($);y[d].addSelf($)}var b,c,d,e,g,f,h,j,k,m,p,l,n,i,q,v,t,G,K,x,B,o,M,r,u=[],y=[],Q=new THREE.Vector3,$=new THREE.Vector3,Z=new THREE.Vector3,I=new THREE.Vector3,O=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)u[b]=new THREE.Vector3,y[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],f=this.faceVertexUvs[0][b],g instanceof
THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var R=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)O.copy(g.vertexNormals[d]),e=g[R[d]],r=u[e],Z.copy(r),Z.subSelf(O.multiplyScalar(O.dot(r))).normalize(),I.cross(g.vertexNormals[d],r),e=I.dot(y[e]),e=e<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(Z.x,Z.y,Z.z,e)}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===
void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,e,g,f,h={};c=0;for(d=this.faces.length;c<d;c++)f=this.faces[c],f instanceof THREE.Face3?(e=a(f.a,f.b),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.a,f.c),b(h,e,c)):f instanceof THREE.Face4&&(e=a(f.b,f.d),b(h,e,c),e=a(f.a,f.b),b(h,e,c),e=a(f.a,f.d),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.c,f.d),b(h,e,c));c=0;for(d=this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];g=f.vertexIndices[1];
f.faceIndices=h[a(e,g)].array;for(e=0;e<f.faceIndices.length;e++)g=f.faceIndices[e],f.faces.push(this.faces[g])}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a));this.target.position.addSelf(b.multiplyScalar(a))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==void 0?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.Material=function(a){this.id=THREE.MaterialCounter.value++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;
THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==
void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,g){this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==void 0?e:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;
THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=this.doubleSided=this.flipSided=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isPlaying=this.isAddedToDOM=this.isLoaded=!1;this.duration=-1;this.radius=b!==void 0?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==void 0?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==void 0?d:!0;this.sources=a instanceof Array?a:[a];for(var e,c=this.sources.length,a=0;a<c;a++)if(b=this.sources[a],b.toLowerCase(),b.indexOf(".mp3")!==-1?e="audio/mpeg":
b.indexOf(".ogg")!==-1?e="audio/ogg":b.indexOf(".wav")!==-1&&(e="audio/wav"),this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded)this.removeEventListener("canplay",this.onLoad,!0),a.isLoaded=!0,a.duration=this.duration,a.isPlaying&&a.play()};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded&&(this.domElement.play(),a))this.domElement.currentTime=a%this.duration};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(this.matrix.setPosition(this.position),b=!0);if(b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;for(var d=this.children.length,a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Sound?(b=this.sounds.indexOf(a),b!==-1&&this.sounds.splice(b,1)):a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var a=j[h]=j[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,f=a.z+a.w,e=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return f>=0&&e>=0&&g>=0&&h>=0?!0:f<0&&e<0||g<0&&h<0?!1:(f<0?c=Math.max(c,f/(f-e)):e<0&&(d=Math.min(d,f/(f-e))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,e,g=[],f,h,j=[],k,m,p=[],l,n=[],i,q,v=[],t,G,K=[],x=new THREE.Vector4,B=new THREE.Vector4,
o=new THREE.Matrix4,M=new THREE.Matrix4,r=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],u=new THREE.Vector4,y=new THREE.Vector4;this.projectVector=function(a,b){o.multiply(b.projectionMatrix,b.matrixWorldInverse);o.multiplyVector3(a);return a};this.unprojectVector=function(a,b){o.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));o.multiplyVector3(a);return a};this.projectObjects=function(a,c,f){var c=[],h,i,l;e=0;i=
a.objects;a=0;for(h=i.length;a<h;a++){l=i[a];var k;if(!(k=!l.visible))if(k=l instanceof THREE.Mesh){a:{k=void 0;for(var j=l.matrixWorld,n=-l.geometry.boundingSphere.radius*Math.max(l.scale.x,Math.max(l.scale.y,l.scale.z)),m=0;m<6;m++)if(k=r[m].x*j.n14+r[m].y*j.n24+r[m].z*j.n34+r[m].w,k<=n){k=!1;break a}k=!0}k=!k}if(!k)k=g[e]=g[e]||new THREE.RenderableObject,e++,d=k,x.copy(l.position),o.multiplyVector3(x),d.object=l,d.z=x.z,c.push(d)}f&&c.sort(b);return c};this.projectScene=function(d,e,g){var I=[],
O=e.near,R=e.far,L,D,z,N,w,J,H,S,x,s,E,C,F,T,W,ca,X;G=q=l=m=0;e.matrixAutoUpdate&&e.update(void 0,!0);d.update(void 0,!1,e);o.multiply(e.projectionMatrix,e.matrixWorldInverse);r[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);r[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);r[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);r[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);r[4].set(o.n41-o.n31,o.n42-o.n32,o.n43-o.n33,o.n44-o.n34);r[5].set(o.n41+o.n31,o.n42+o.n32,o.n43+
o.n33,o.n44+o.n34);for(L=0;L<6;L++)x=r[L],x.divideScalar(Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z));x=this.projectObjects(d,e,!0);d=0;for(L=x.length;d<L;d++)if(s=x[d].object,s.visible)if(E=s.matrixWorld,C=s.matrixRotationWorld,F=s.materials,T=s.overdraw,h=0,s instanceof THREE.Mesh){W=s.geometry;N=W.vertices;ca=W.faces;W=W.faceVertexUvs;D=0;for(z=N.length;D<z;D++)f=a(),f.positionWorld.copy(N[D].position),E.multiplyVector3(f.positionWorld),f.positionScreen.copy(f.positionWorld),o.multiplyVector4(f.positionScreen),
f.positionScreen.x/=f.positionScreen.w,f.positionScreen.y/=f.positionScreen.w,f.visible=f.positionScreen.z>O&&f.positionScreen.z<R;N=0;for(D=ca.length;N<D;N++){z=ca[N];if(z instanceof THREE.Face3)if(w=j[z.a],J=j[z.b],H=j[z.c],w.visible&&J.visible&&H.visible&&(s.doubleSided||s.flipSided!=(H.positionScreen.x-w.positionScreen.x)*(J.positionScreen.y-w.positionScreen.y)-(H.positionScreen.y-w.positionScreen.y)*(J.positionScreen.x-w.positionScreen.x)<0))S=p[m]=p[m]||new THREE.RenderableFace3,m++,k=S,k.v1.copy(w),
k.v2.copy(J),k.v3.copy(H);else continue;else if(z instanceof THREE.Face4)if(w=j[z.a],J=j[z.b],H=j[z.c],S=j[z.d],w.visible&&J.visible&&H.visible&&S.visible&&(s.doubleSided||s.flipSided!=((S.positionScreen.x-w.positionScreen.x)*(J.positionScreen.y-w.positionScreen.y)-(S.positionScreen.y-w.positionScreen.y)*(J.positionScreen.x-w.positionScreen.x)<0||(J.positionScreen.x-H.positionScreen.x)*(S.positionScreen.y-H.positionScreen.y)-(J.positionScreen.y-H.positionScreen.y)*(S.positionScreen.x-H.positionScreen.x)<
0)))X=n[l]=n[l]||new THREE.RenderableFace4,l++,k=X,k.v1.copy(w),k.v2.copy(J),k.v3.copy(H),k.v4.copy(S);else continue;k.normalWorld.copy(z.normal);C.multiplyVector3(k.normalWorld);k.centroidWorld.copy(z.centroid);E.multiplyVector3(k.centroidWorld);k.centroidScreen.copy(k.centroidWorld);o.multiplyVector3(k.centroidScreen);H=z.vertexNormals;w=0;for(J=H.length;w<J;w++)S=k.vertexNormalsWorld[w],S.copy(H[w]),C.multiplyVector3(S);w=0;for(J=W.length;w<J;w++)if(X=W[w][N]){H=0;for(S=X.length;H<S;H++)k.uvs[w][H]=
X[H]}k.meshMaterials=F;k.faceMaterials=z.materials;k.overdraw=T;k.z=k.centroidScreen.z;I.push(k)}}else if(s instanceof THREE.Line){M.multiply(o,E);N=s.geometry.vertices;w=a();w.positionScreen.copy(N[0].position);M.multiplyVector4(w.positionScreen);D=1;for(z=N.length;D<z;D++)if(w=a(),w.positionScreen.copy(N[D].position),M.multiplyVector4(w.positionScreen),J=j[h-2],u.copy(w.positionScreen),y.copy(J.positionScreen),c(u,y))u.multiplyScalar(1/u.w),y.multiplyScalar(1/y.w),E=v[q]=v[q]||new THREE.RenderableLine,
q++,i=E,i.v1.positionScreen.copy(u),i.v2.positionScreen.copy(y),i.z=Math.max(u.z,y.z),i.materials=s.materials,I.push(i)}else if(s instanceof THREE.Particle&&(B.set(s.matrixWorld.n14,s.matrixWorld.n24,s.matrixWorld.n34,1),o.multiplyVector4(B),B.z/=B.w,B.z>0&&B.z<1))E=K[G]=K[G]||new THREE.RenderableParticle,G++,t=E,t.x=B.x/B.w,t.y=B.y/B.w,t.z=B.z,t.rotation=s.rotation.z,t.scale.x=s.scale.x*Math.abs(t.x-(B.x+e.projectionMatrix.n11)/(B.w+e.projectionMatrix.n14)),t.scale.y=s.scale.y*Math.abs(t.y-(B.y+
e.projectionMatrix.n22)/(B.w+e.projectionMatrix.n24)),t.materials=s.materials,I.push(t);g&&I.sort(b);return I}};
THREE.CanvasRenderer=function(a){function b(a){if(t!=a)i.globalAlpha=t=a}function c(a){if(G!=a){switch(a){case THREE.NormalBlending:i.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:i.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:i.globalCompositeOperation="darker"}G=a}}function d(a){if(K!=a.hex)K=a.hex,i.strokeStyle="#"+g(K.toString(16))}function e(a){if(x!=a.hex)x=a.hex,i.fillStyle="#"+g(x.toString(16))}function g(a){for(;a.length<6;)a="0"+a;return a}
var f=this,h=null,j=new THREE.Projector,a=a||{},k=a.canvas!==void 0?a.canvas:document.createElement("canvas"),m,p,l,n,i=k.getContext("2d"),q=new THREE.Color(0),v=0,t=1,G=0,K=null,x=null,B=null,o=null,M=null,r,u,y,Q,$=new THREE.RenderableVertex,Z=new THREE.RenderableVertex,I,O,R,L,D,z,N,w,J,H,S,oa,s=new THREE.Color(0),E=new THREE.Color(0),C=new THREE.Color(0),F=new THREE.Color(0),T=new THREE.Color(0),W,ca,X,aa,Ba,Ca,Da,Ea,Fa,Ga,ka=new THREE.Rectangle,da=new THREE.Rectangle,V=new THREE.Rectangle,ya=
!1,ba=new THREE.Color,Y=new THREE.Color,sa=new THREE.Color,ta=new THREE.Color,P=new THREE.Vector3,pa,qa,za,ea,ra,ua,a=16;pa=document.createElement("canvas");pa.width=pa.height=2;qa=pa.getContext("2d");qa.fillStyle="rgba(0,0,0,1)";qa.fillRect(0,0,2,2);za=qa.getImageData(0,0,2,2);ea=za.data;ra=document.createElement("canvas");ra.width=ra.height=a;ua=ra.getContext("2d");ua.translate(-a/2,-a/2);ua.scale(a,a);a--;this.domElement=k;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,
faces:0};this.setSize=function(a,b){m=a;p=b;l=m/2;n=p/2;k.width=m;k.height=p;ka.set(-l,-n,l,n);t=1;G=0;M=o=B=x=K=null};this.setClearColor=function(a,b){q=a;v=b};this.setClearColorHex=function(a,b){q.setHex(a);v=b};this.clear=function(){i.setTransform(1,0,0,-1,l,n);if(!da.isEmpty())da.inflate(1),da.minSelf(ka),q.hex==0&&v==0?i.clearRect(da.getX(),da.getY(),da.getWidth(),da.getHeight()):(c(THREE.NormalBlending),b(1),i.fillStyle="rgba("+Math.floor(q.r*255)+","+Math.floor(q.g*255)+","+Math.floor(q.b*
255)+","+v+")",i.fillRect(da.getX(),da.getY(),da.getWidth(),da.getHeight())),da.empty()};this.render=function(a,g){function k(a){var b,c,d,e=a.lights;Y.setRGB(0,0,0);sa.setRGB(0,0,0);ta.setRGB(0,0,0);a=0;for(b=e.length;a<b;a++)c=e[a],d=c.color,c instanceof THREE.AmbientLight?(Y.r+=d.r,Y.g+=d.g,Y.b+=d.b):c instanceof THREE.DirectionalLight?(sa.r+=d.r,sa.g+=d.g,sa.b+=d.b):c instanceof THREE.PointLight&&(ta.r+=d.r,ta.g+=d.g,ta.b+=d.b)}function m(a,b,c,d){var e,f,g,h,i=a.lights,a=0;for(e=i.length;a<e;a++)f=
i[a],g=f.color,f instanceof THREE.DirectionalLight?(h=c.dot(f.position),h<=0||(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)):f instanceof THREE.PointLight&&(h=c.dot(P.sub(f.position,b).normalize()),h<=0||(h*=f.distance==0?1:1-Math.min(b.distanceTo(f.position)/f.distance,1),h!=0&&(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)))}function p(a,f,g){b(g.opacity);c(g.blending);var h,k,m,j,Aa,o;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)j=g.map.image,Aa=j.width>>1,o=j.height>>1,g=f.scale.x*
l,m=f.scale.y*n,h=g*Aa,k=m*o,V.set(a.x-h,a.y-k,a.x+h,a.y+k),ka.instersects(V)&&(i.save(),i.translate(a.x,a.y),i.rotate(-f.rotation),i.scale(g,-m),i.translate(-Aa,-o),i.drawImage(j,0,0),i.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=f.scale.x*l,k=f.scale.y*n,V.set(a.x-h,a.y-k,a.x+h,a.y+k),ka.instersects(V)&&(d(g.color),e(g.color),i.save(),i.translate(a.x,a.y),i.rotate(-f.rotation),i.scale(h,k),g.program(i),i.restore()))}function q(a,f,e,g){b(g.opacity);c(g.blending);i.beginPath();
i.moveTo(a.positionScreen.x,a.positionScreen.y);i.lineTo(f.positionScreen.x,f.positionScreen.y);i.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(B!=a)i.lineWidth=B=a;a=g.linecap;if(o!=a)i.lineCap=o=a;a=g.linejoin;if(M!=a)i.lineJoin=M=a;d(g.color);i.stroke();V.inflate(g.linewidth*2)}}function t(a,d,e,h,k,i,l,j,n){f.data.vertices+=3;f.data.faces++;b(j.opacity);c(j.blending);I=a.positionScreen.x;O=a.positionScreen.y;R=d.positionScreen.x;L=d.positionScreen.y;D=e.positionScreen.x;
z=e.positionScreen.y;x(I,O,R,L,D,z);if(j instanceof THREE.MeshBasicMaterial)if(j.map)j.map.mapping instanceof THREE.UVMapping&&(aa=l.uvs[0],ga(I,O,R,L,D,z,j.map.image,aa[h].u,aa[h].v,aa[k].u,aa[k].v,aa[i].u,aa[i].v));else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=g.matrixWorldInverse,P.copy(l.vertexNormalsWorld[0]),Ba=(P.x*a.n11+P.y*a.n12+P.z*a.n13)*0.5+0.5,Ca=-(P.x*a.n21+P.y*a.n22+P.z*a.n23)*0.5+0.5,P.copy(l.vertexNormalsWorld[1]),Da=(P.x*a.n11+P.y*a.n12+P.z*
a.n13)*0.5+0.5,Ea=-(P.x*a.n21+P.y*a.n22+P.z*a.n23)*0.5+0.5,P.copy(l.vertexNormalsWorld[2]),Fa=(P.x*a.n11+P.y*a.n12+P.z*a.n13)*0.5+0.5,Ga=-(P.x*a.n21+P.y*a.n22+P.z*a.n23)*0.5+0.5,ga(I,O,R,L,D,z,j.envMap.image,Ba,Ca,Da,Ea,Fa,Ga)}else j.wireframe?G(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshLambertMaterial)j.map&&!j.wireframe&&(j.map.mapping instanceof THREE.UVMapping&&(aa=l.uvs[0],ga(I,O,R,L,D,z,j.map.image,aa[h].u,aa[h].v,aa[k].u,
aa[k].v,aa[i].u,aa[i].v)),c(THREE.SubtractiveBlending)),ya?!j.wireframe&&j.shading==THREE.SmoothShading&&l.vertexNormalsWorld.length==3?(E.r=C.r=F.r=Y.r,E.g=C.g=F.g=Y.g,E.b=C.b=F.b=Y.b,m(n,l.v1.positionWorld,l.vertexNormalsWorld[0],E),m(n,l.v2.positionWorld,l.vertexNormalsWorld[1],C),m(n,l.v3.positionWorld,l.vertexNormalsWorld[2],F),T.r=(C.r+F.r)*0.5,T.g=(C.g+F.g)*0.5,T.b=(C.b+F.b)*0.5,X=va(E,C,F,T),ga(I,O,R,L,D,z,X,0,0,1,0,0,1)):(ba.r=Y.r,ba.g=Y.g,ba.b=Y.b,m(n,l.centroidWorld,l.normalWorld,ba),s.r=
Math.max(0,Math.min(j.color.r*ba.r,1)),s.g=Math.max(0,Math.min(j.color.g*ba.g,1)),s.b=Math.max(0,Math.min(j.color.b*ba.b,1)),s.updateHex(),j.wireframe?G(s,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(s)):j.wireframe?G(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshDepthMaterial)W=g.near,ca=g.far,E.r=E.g=E.b=1-la(a.positionScreen.z,W,ca),C.r=C.g=C.b=1-la(d.positionScreen.z,W,ca),F.r=F.g=F.b=1-la(e.positionScreen.z,
W,ca),T.r=(C.r+F.r)*0.5,T.g=(C.g+F.g)*0.5,T.b=(C.b+F.b)*0.5,X=va(E,C,F,T),ga(I,O,R,L,D,z,X,0,0,1,0,0,1);else if(j instanceof THREE.MeshNormalMaterial)s.r=ma(l.normalWorld.x),s.g=ma(l.normalWorld.y),s.b=ma(l.normalWorld.z),s.updateHex(),j.wireframe?G(s,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(s)}function v(a,d,e,h,j,l,k,i,n){f.data.vertices+=4;f.data.faces++;b(i.opacity);c(i.blending);if(i.map||i.envMap)t(a,d,h,0,1,3,k,i,n),t(j,e,l,1,2,3,k,i,n);else if(I=a.positionScreen.x,O=
a.positionScreen.y,R=d.positionScreen.x,L=d.positionScreen.y,D=e.positionScreen.x,z=e.positionScreen.y,N=h.positionScreen.x,w=h.positionScreen.y,J=j.positionScreen.x,H=j.positionScreen.y,S=l.positionScreen.x,oa=l.positionScreen.y,i instanceof THREE.MeshBasicMaterial)K(I,O,R,L,D,z,N,w),i.wireframe?G(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(i.color);else if(i instanceof THREE.MeshLambertMaterial)ya?!i.wireframe&&i.shading==THREE.SmoothShading&&k.vertexNormalsWorld.length==
4?(E.r=C.r=F.r=T.r=Y.r,E.g=C.g=F.g=T.g=Y.g,E.b=C.b=F.b=T.b=Y.b,m(n,k.v1.positionWorld,k.vertexNormalsWorld[0],E),m(n,k.v2.positionWorld,k.vertexNormalsWorld[1],C),m(n,k.v4.positionWorld,k.vertexNormalsWorld[3],F),m(n,k.v3.positionWorld,k.vertexNormalsWorld[2],T),X=va(E,C,F,T),x(I,O,R,L,N,w),ga(I,O,R,L,N,w,X,0,0,1,0,0,1),x(J,H,D,z,S,oa),ga(J,H,D,z,S,oa,X,1,0,1,1,0,1)):(ba.r=Y.r,ba.g=Y.g,ba.b=Y.b,m(n,k.centroidWorld,k.normalWorld,ba),s.r=Math.max(0,Math.min(i.color.r*ba.r,1)),s.g=Math.max(0,Math.min(i.color.g*
ba.g,1)),s.b=Math.max(0,Math.min(i.color.b*ba.b,1)),s.updateHex(),K(I,O,R,L,D,z,N,w),i.wireframe?G(s,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(s)):(K(I,O,R,L,D,z,N,w),i.wireframe?G(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(i.color));else if(i instanceof THREE.MeshNormalMaterial)s.r=ma(k.normalWorld.x),s.g=ma(k.normalWorld.y),s.b=ma(k.normalWorld.z),s.updateHex(),K(I,O,R,L,D,z,N,w),i.wireframe?G(s,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):
ha(s);else if(i instanceof THREE.MeshDepthMaterial)W=g.near,ca=g.far,E.r=E.g=E.b=1-la(a.positionScreen.z,W,ca),C.r=C.g=C.b=1-la(d.positionScreen.z,W,ca),F.r=F.g=F.b=1-la(h.positionScreen.z,W,ca),T.r=T.g=T.b=1-la(e.positionScreen.z,W,ca),X=va(E,C,F,T),x(I,O,R,L,N,w),ga(I,O,R,L,N,w,X,0,0,1,0,0,1),x(J,H,D,z,S,oa),ga(J,H,D,z,S,oa,X,1,0,1,1,0,1)}function x(a,b,c,d,e,f){i.beginPath();i.moveTo(a,b);i.lineTo(c,d);i.lineTo(e,f);i.lineTo(a,b);i.closePath()}function K(a,b,c,d,e,f,g,h){i.beginPath();i.moveTo(a,
b);i.lineTo(c,d);i.lineTo(e,f);i.lineTo(g,h);i.lineTo(a,b);i.closePath()}function G(a,b,c,e){if(B!=b)i.lineWidth=B=b;if(o!=c)i.lineCap=o=c;if(M!=e)i.lineJoin=M=e;d(a);i.stroke();V.inflate(b*2)}function ha(a){e(a);i.fill()}function ga(a,b,c,d,e,f,g,h,j,k,l,m,n){var o,p;o=g.width-1;p=g.height-1;h*=o;j*=p;k*=o;l*=p;m*=o;n*=p;c-=a;d-=b;e-=a;f-=b;k-=h;l-=j;m-=h;n-=j;o=k*n-m*l;o!=0&&(p=1/o,o=(n*c-l*e)*p,l=(n*d-l*f)*p,c=(k*e-m*c)*p,d=(k*f-m*d)*p,a=a-o*h-c*j,b=b-l*h-d*j,i.save(),i.transform(o,l,c,d,a,b),
i.clip(),i.drawImage(g,0,0),i.restore())}function va(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);ea[0]=e<0?0:e>255?255:e;ea[1]=f<0?0:f>255?255:f;ea[2]=a<0?0:a>255?255:a;ea[4]=g<0?0:g>255?255:g;ea[5]=h<0?0:h>255?255:h;ea[6]=b<0?0:b>255?255:b;ea[8]=i<0?0:i>255?255:i;ea[9]=j<0?0:j>255?255:j;ea[10]=c<0?0:c>255?255:c;ea[12]=k<0?0:k>255?255:k;ea[13]=l<0?0:l>255?255:l;
ea[14]=d<0?0:d>255?255:d;qa.putImageData(za,0,0);ua.drawImage(pa,0,0);return ra}function la(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function ma(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ia(a,b){var c=b.x-a.x,d=b.y-a.y,e=1/Math.sqrt(c*c+d*d);c*=e;d*=e;b.x+=c;b.y+=d;a.x-=c;a.y-=d}var wa,Ha,A,fa,ja,na,xa,U;this.autoClear?this.clear():i.setTransform(1,0,0,-1,l,n);f.data.vertices=0;f.data.faces=0;h=j.projectScene(a,g,this.sortElements);(ya=a.lights.length>0)&&k(a);wa=0;for(Ha=h.length;wa<Ha;wa++){A=
h[wa];V.empty();if(A instanceof THREE.RenderableParticle){r=A;r.x*=l;r.y*=n;fa=0;for(ja=A.materials.length;fa<ja;)U=A.materials[fa++],U.opacity!=0&&p(r,A,U,a)}else if(A instanceof THREE.RenderableLine){if(r=A.v1,u=A.v2,r.positionScreen.x*=l,r.positionScreen.y*=n,u.positionScreen.x*=l,u.positionScreen.y*=n,V.addPoint(r.positionScreen.x,r.positionScreen.y),V.addPoint(u.positionScreen.x,u.positionScreen.y),ka.instersects(V)){fa=0;for(ja=A.materials.length;fa<ja;)U=A.materials[fa++],U.opacity!=0&&q(r,
u,A,U,a)}}else if(A instanceof THREE.RenderableFace3){if(r=A.v1,u=A.v2,y=A.v3,r.positionScreen.x*=l,r.positionScreen.y*=n,u.positionScreen.x*=l,u.positionScreen.y*=n,y.positionScreen.x*=l,y.positionScreen.y*=n,A.overdraw&&(ia(r.positionScreen,u.positionScreen),ia(u.positionScreen,y.positionScreen),ia(y.positionScreen,r.positionScreen)),V.add3Points(r.positionScreen.x,r.positionScreen.y,u.positionScreen.x,u.positionScreen.y,y.positionScreen.x,y.positionScreen.y),ka.instersects(V)){fa=0;for(ja=A.meshMaterials.length;fa<
ja;)if(U=A.meshMaterials[fa++],U instanceof THREE.MeshFaceMaterial){na=0;for(xa=A.faceMaterials.length;na<xa;)(U=A.faceMaterials[na++])&&U.opacity!=0&&t(r,u,y,0,1,2,A,U,a)}else U.opacity!=0&&t(r,u,y,0,1,2,A,U,a)}}else if(A instanceof THREE.RenderableFace4&&(r=A.v1,u=A.v2,y=A.v3,Q=A.v4,r.positionScreen.x*=l,r.positionScreen.y*=n,u.positionScreen.x*=l,u.positionScreen.y*=n,y.positionScreen.x*=l,y.positionScreen.y*=n,Q.positionScreen.x*=l,Q.positionScreen.y*=n,$.positionScreen.copy(u.positionScreen),
Z.positionScreen.copy(Q.positionScreen),A.overdraw&&(ia(r.positionScreen,u.positionScreen),ia(u.positionScreen,Q.positionScreen),ia(Q.positionScreen,r.positionScreen),ia(y.positionScreen,$.positionScreen),ia(y.positionScreen,Z.positionScreen)),V.addPoint(r.positionScreen.x,r.positionScreen.y),V.addPoint(u.positionScreen.x,u.positionScreen.y),V.addPoint(y.positionScreen.x,y.positionScreen.y),V.addPoint(Q.positionScreen.x,Q.positionScreen.y),ka.instersects(V))){fa=0;for(ja=A.meshMaterials.length;fa<
ja;)if(U=A.meshMaterials[fa++],U instanceof THREE.MeshFaceMaterial){na=0;for(xa=A.faceMaterials.length;na<xa;)(U=A.faceMaterials[na++])&&U.opacity!=0&&v(r,u,y,Q,$,Z,A,U,a)}else U.opacity!=0&&v(r,u,y,Q,$,Z,A,U,a)}da.addRectangle(V)}i.setTransform(1,0,0,1,0,0)}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(void 0,!1,b);var c=a.sounds,d,e=c.length;for(d=0;d<e;d++)a=c[d],this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34),this.soundPosition.subSelf(b.position),a.isPlaying&&a.isLoaded&&(a.isAddedToDOM||a.addToDOM(this.domElement),a.calculateVolumeAndPan(this.soundPosition))}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
