// Three.js r29 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.autoUpdate=true;this.setHex(a)};
THREE.Color.prototype={setRGB:function(a,c,e){this.r=a;this.g=c;this.b=e;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGBA();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGBA:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+
","+~~(this.g*255)+","+~~(this.b*255)+")"},toString:function(){return"THREE.Color ( r: "+this.r+", g: "+this.g+", b: "+this.b+", hex: "+this.hex+" )"}};THREE.Vector2=function(a,c){this.x=a||0;this.y=c||0};
THREE.Vector2.prototype={set:function(a,c){this.x=a;this.y=c;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},unit:function(){this.multiplyScalar(1/this.length());return this},length:function(){return Math.sqrt(this.x*
this.x+this.y*this.y)},lengthSq:function(){return this.x*this.x+this.y*this.y},negate:function(){this.x=-this.x;this.y=-this.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},toString:function(){return"THREE.Vector2 ("+this.x+", "+this.y+")"}};THREE.Vector3=function(a,c,e){this.x=a||0;this.y=c||0;this.z=e||0};
THREE.Vector3.prototype={set:function(a,c,e){this.x=a;this.y=c;this.z=e;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},
cross:function(a,c){this.x=a.y*c.z-a.z*c.y;this.y=a.z*c.x-a.x*c.z;this.z=a.x*c.y-a.y*c.x;return this},crossSelf:function(a){var c=this.x,e=this.y,g=this.z;this.x=e*a.z-g*a.y;this.y=g*a.x-c*a.z;this.z=c*a.y-e*a.x;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){var c=
this.x-a.x,e=this.y-a.y;a=this.z-a.z;return Math.sqrt(c*c+e*e+a*a)},distanceToSquared:function(a){var c=this.x-a.x,e=this.y-a.y;a=this.z-a.z;return c*c+e*e+a*a},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z);a>0?this.multiplyScalar(1/a):this.set(0,
0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},toString:function(){return"THREE.Vector3 ( "+this.x+", "+this.y+", "+this.z+" )"}};THREE.Vector4=function(a,c,e,g){this.x=a||0;this.y=c||0;this.z=e||0;this.w=g||1};
THREE.Vector4.prototype={set:function(a,c,e,g){this.x=a;this.y=c;this.z=e;this.w=g;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w||1;return this},add:function(a,c){this.x=a.x+c.x;this.y=a.y+c.y;this.z=a.z+c.z;this.w=a.w+c.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,c){this.x=a.x-c.x;this.y=a.y-c.y;this.z=a.z-c.z;this.w=a.w-c.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;
return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;this.w/=a;return this},lerpSelf:function(a,c){this.x+=(a.x-this.x)*c;this.y+=(a.y-this.y)*c;this.z+=(a.z-this.z)*c;this.w+=(a.w-this.w)*c},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},toString:function(){return"THREE.Vector4 ("+this.x+", "+this.y+", "+this.z+", "+this.w+")"}};
THREE.Ray=function(a,c){this.origin=a||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var c,e,g=a.objects,b=[];a=0;for(c=g.length;a<c;a++){e=g[a];if(e instanceof THREE.Mesh)b=b.concat(this.intersectObject(e))}b.sort(function(d,n){return d.distance-n.distance});return b},intersectObject:function(a){function c(v,j,L,u){u=u.clone().subSelf(j);L=L.clone().subSelf(j);var w=v.clone().subSelf(j);v=u.dot(u);j=u.dot(L);u=u.dot(w);var H=L.dot(L);L=L.dot(w);w=1/(v*H-j*j);H=(H*u-j*L)*w;v=(v*L-j*u)*w;return H>0&&v>0&&H+v<1}var e,g,b,d,n,q,o,f,h,k,
i,m=a.geometry,l=m.vertices,s=[];e=0;for(g=m.faces.length;e<g;e++){b=m.faces[e];k=this.origin.clone();i=this.direction.clone();d=a.matrix.transform(l[b.a].position.clone());n=a.matrix.transform(l[b.b].position.clone());q=a.matrix.transform(l[b.c].position.clone());o=b instanceof THREE.Face4?a.matrix.transform(l[b.d].position.clone()):null;f=a.rotationMatrix.transform(b.normal.clone());h=i.dot(f);if(h<0){f=f.dot((new THREE.Vector3).sub(d,k))/h;k=k.addSelf(i.multiplyScalar(f));if(b instanceof THREE.Face3){if(c(k,
d,n,q)){b={distance:this.origin.distanceTo(k),point:k,face:b,object:a};s.push(b)}}else if(b instanceof THREE.Face4)if(c(k,d,n,o)||c(k,n,q,o)){b={distance:this.origin.distanceTo(k),point:k,face:b,object:a};s.push(b)}}}return s}};
THREE.Rectangle=function(){function a(){d=g-c;n=b-e}var c,e,g,b,d,n,q=true;this.getX=function(){return c};this.getY=function(){return e};this.getWidth=function(){return d};this.getHeight=function(){return n};this.getLeft=function(){return c};this.getTop=function(){return e};this.getRight=function(){return g};this.getBottom=function(){return b};this.set=function(o,f,h,k){q=false;c=o;e=f;g=h;b=k;a()};this.addPoint=function(o,f){if(q){q=false;c=o;e=f;g=o;b=f}else{c=Math.min(c,o);e=Math.min(e,f);g=Math.max(g,
o);b=Math.max(b,f)}a()};this.addRectangle=function(o){if(q){q=false;c=o.getLeft();e=o.getTop();g=o.getRight();b=o.getBottom()}else{c=Math.min(c,o.getLeft());e=Math.min(e,o.getTop());g=Math.max(g,o.getRight());b=Math.max(b,o.getBottom())}a()};this.inflate=function(o){c-=o;e-=o;g+=o;b+=o;a()};this.minSelf=function(o){c=Math.max(c,o.getLeft());e=Math.max(e,o.getTop());g=Math.min(g,o.getRight());b=Math.min(b,o.getBottom());a()};this.instersects=function(o){return Math.min(g,o.getRight())-Math.max(c,o.getLeft())>=
0&&Math.min(b,o.getBottom())-Math.max(e,o.getTop())>=0};this.empty=function(){q=true;b=g=e=c=0;a()};this.isEmpty=function(){return q};this.toString=function(){return"THREE.Rectangle ( left: "+c+", right: "+g+", top: "+e+", bottom: "+b+", width: "+d+", height: "+n+" )"}};THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a;a=this.m[1];this.m[1]=this.m[3];this.m[3]=a;a=this.m[2];this.m[2]=this.m[6];this.m[6]=a;a=this.m[5];this.m[5]=this.m[7];this.m[7]=a;return this}};
THREE.Matrix4=function(){};
THREE.Matrix4.prototype={n11:1,n12:0,n13:0,n14:0,n21:0,n22:1,n23:0,n24:0,n31:0,n32:0,n33:1,n34:0,n41:0,n42:0,n43:0,n44:1,identity:function(){this.n11=1;this.n21=this.n14=this.n13=this.n12=0;this.n22=1;this.n32=this.n31=this.n24=this.n23=0;this.n33=1;this.n43=this.n42=this.n41=this.n34=0;this.n44=1},copy:function(a){this.n11=a.n11;this.n12=a.n12;this.n13=a.n13;this.n14=a.n14;this.n21=a.n21;this.n22=a.n22;this.n23=a.n23;this.n24=a.n24;this.n31=a.n31;this.n32=a.n32;this.n33=a.n33;this.n34=a.n34;this.n41=
a.n41;this.n42=a.n42;this.n43=a.n43;this.n44=a.n44},lookAt:function(a,c,e){var g=new THREE.Vector3,b=new THREE.Vector3,d=new THREE.Vector3;d.sub(a,c).normalize();g.cross(e,d).normalize();b.cross(d,g).normalize();this.n11=g.x;this.n12=g.y;this.n13=g.z;this.n14=-g.dot(a);this.n21=b.x;this.n22=b.y;this.n23=b.z;this.n24=-b.dot(a);this.n31=d.x;this.n32=d.y;this.n33=d.z;this.n34=-d.dot(a);this.n43=this.n42=this.n41=0;this.n44=1},transform:function(a){var c=a.x,e=a.y,g=a.z,b=a.w||1;a.x=this.n11*c+this.n12*
e+this.n13*g+this.n14*b;a.y=this.n21*c+this.n22*e+this.n23*g+this.n24*b;a.z=this.n31*c+this.n32*e+this.n33*g+this.n34*b;b=this.n41*c+this.n42*e+this.n43*g+this.n44*b;if(a.w)a.w=b;else{c=1/b;a.x*=c;a.y*=c;a.z*=c}return a},crossVector:function(a){var c=new THREE.Vector4;c.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;c.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;c.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;c.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return c},
multiply:function(a,c){this.n11=a.n11*c.n11+a.n12*c.n21+a.n13*c.n31+a.n14*c.n41;this.n12=a.n11*c.n12+a.n12*c.n22+a.n13*c.n32+a.n14*c.n42;this.n13=a.n11*c.n13+a.n12*c.n23+a.n13*c.n33+a.n14*c.n43;this.n14=a.n11*c.n14+a.n12*c.n24+a.n13*c.n34+a.n14*c.n44;this.n21=a.n21*c.n11+a.n22*c.n21+a.n23*c.n31+a.n24*c.n41;this.n22=a.n21*c.n12+a.n22*c.n22+a.n23*c.n32+a.n24*c.n42;this.n23=a.n21*c.n13+a.n22*c.n23+a.n23*c.n33+a.n24*c.n43;this.n24=a.n21*c.n14+a.n22*c.n24+a.n23*c.n34+a.n24*c.n44;this.n31=a.n31*c.n11+a.n32*
c.n21+a.n33*c.n31+a.n34*c.n41;this.n32=a.n31*c.n12+a.n32*c.n22+a.n33*c.n32+a.n34*c.n42;this.n33=a.n31*c.n13+a.n32*c.n23+a.n33*c.n33+a.n34*c.n43;this.n34=a.n31*c.n14+a.n32*c.n24+a.n33*c.n34+a.n34*c.n44;this.n41=a.n41*c.n11+a.n42*c.n21+a.n43*c.n31+a.n44*c.n41;this.n42=a.n41*c.n12+a.n42*c.n22+a.n43*c.n32+a.n44*c.n42;this.n43=a.n41*c.n13+a.n42*c.n23+a.n43*c.n33+a.n44*c.n43;this.n44=a.n41*c.n14+a.n42*c.n24+a.n43*c.n34+a.n44*c.n44},multiplySelf:function(a){var c=this.n11,e=this.n12,g=this.n13,b=this.n14,
d=this.n21,n=this.n22,q=this.n23,o=this.n24,f=this.n31,h=this.n32,k=this.n33,i=this.n34,m=this.n41,l=this.n42,s=this.n43,v=this.n44;this.n11=c*a.n11+e*a.n21+g*a.n31+b*a.n41;this.n12=c*a.n12+e*a.n22+g*a.n32+b*a.n42;this.n13=c*a.n13+e*a.n23+g*a.n33+b*a.n43;this.n14=c*a.n14+e*a.n24+g*a.n34+b*a.n44;this.n21=d*a.n11+n*a.n21+q*a.n31+o*a.n41;this.n22=d*a.n12+n*a.n22+q*a.n32+o*a.n42;this.n23=d*a.n13+n*a.n23+q*a.n33+o*a.n43;this.n24=d*a.n14+n*a.n24+q*a.n34+o*a.n44;this.n31=f*a.n11+h*a.n21+k*a.n31+i*a.n41;
this.n32=f*a.n12+h*a.n22+k*a.n32+i*a.n42;this.n33=f*a.n13+h*a.n23+k*a.n33+i*a.n43;this.n34=f*a.n14+h*a.n24+k*a.n34+i*a.n44;this.n41=m*a.n11+l*a.n21+s*a.n31+v*a.n41;this.n42=m*a.n12+l*a.n22+s*a.n32+v*a.n42;this.n43=m*a.n13+l*a.n23+s*a.n33+v*a.n43;this.n44=m*a.n14+l*a.n24+s*a.n34+v*a.n44},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=
a},determinant:function(){return this.n14*this.n23*this.n32*this.n41-this.n13*this.n24*this.n32*this.n41-this.n14*this.n22*this.n33*this.n41+this.n12*this.n24*this.n33*this.n41+this.n13*this.n22*this.n34*this.n41-this.n12*this.n23*this.n34*this.n41-this.n14*this.n23*this.n31*this.n42+this.n13*this.n24*this.n31*this.n42+this.n14*this.n21*this.n33*this.n42-this.n11*this.n24*this.n33*this.n42-this.n13*this.n21*this.n34*this.n42+this.n11*this.n23*this.n34*this.n42+this.n14*this.n22*this.n31*this.n43-
this.n12*this.n24*this.n31*this.n43-this.n14*this.n21*this.n32*this.n43+this.n11*this.n24*this.n32*this.n43+this.n12*this.n21*this.n34*this.n43-this.n11*this.n22*this.n34*this.n43-this.n13*this.n22*this.n31*this.n44+this.n12*this.n23*this.n31*this.n44+this.n13*this.n21*this.n32*this.n44-this.n11*this.n23*this.n32*this.n44-this.n12*this.n21*this.n33*this.n44+this.n11*this.n22*this.n33*this.n44},transpose:function(){function a(c,e,g){var b=c[e];c[e]=c[g];c[g]=b}a(this,"n21","n12");a(this,"n31","n13");
a(this,"n32","n23");a(this,"n41","n14");a(this,"n42","n24");a(this,"n43","n34");return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){return[this.n11,this.n21,this.n31,this.n41,this.n12,this.n22,this.n32,this.n42,this.n13,this.n23,this.n33,
this.n43,this.n14,this.n24,this.n34,this.n44]},toString:function(){return"| "+this.n11+" "+this.n12+" "+this.n13+" "+this.n14+" |\n| "+this.n21+" "+this.n22+" "+this.n23+" "+this.n24+" |\n| "+this.n31+" "+this.n32+" "+this.n33+" "+this.n34+" |\n| "+this.n41+" "+this.n42+" "+this.n43+" "+this.n44+" |"}};THREE.Matrix4.translationMatrix=function(a,c,e){var g=new THREE.Matrix4;g.n14=a;g.n24=c;g.n34=e;return g};THREE.Matrix4.scaleMatrix=function(a,c,e){var g=new THREE.Matrix4;g.n11=a;g.n22=c;g.n33=e;return g};
THREE.Matrix4.rotationXMatrix=function(a){var c=new THREE.Matrix4;c.n22=c.n33=Math.cos(a);c.n32=Math.sin(a);c.n23=-c.n32;return c};THREE.Matrix4.rotationYMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n33=Math.cos(a);c.n13=Math.sin(a);c.n31=-c.n13;return c};THREE.Matrix4.rotationZMatrix=function(a){var c=new THREE.Matrix4;c.n11=c.n22=Math.cos(a);c.n21=Math.sin(a);c.n12=-c.n21;return c};
THREE.Matrix4.rotationAxisAngleMatrix=function(a,c){var e=new THREE.Matrix4,g=Math.cos(c),b=Math.sin(c),d=1-g,n=a.x,q=a.y,o=a.z;e.n11=d*n*n+g;e.n12=d*n*q-b*o;e.n13=d*n*o+b*q;e.n21=d*n*q+b*o;e.n22=d*q*q+g;e.n23=d*q*o-b*n;e.n31=d*n*o-b*q;e.n32=d*q*o+b*n;e.n33=d*o*o+g;return e};
THREE.Matrix4.makeInvert=function(a){var c=new THREE.Matrix4;c.n11=a.n23*a.n34*a.n42-a.n24*a.n33*a.n42+a.n24*a.n32*a.n43-a.n22*a.n34*a.n43-a.n23*a.n32*a.n44+a.n22*a.n33*a.n44;c.n12=a.n14*a.n33*a.n42-a.n13*a.n34*a.n42-a.n14*a.n32*a.n43+a.n12*a.n34*a.n43+a.n13*a.n32*a.n44-a.n12*a.n33*a.n44;c.n13=a.n13*a.n24*a.n42-a.n14*a.n23*a.n42+a.n14*a.n22*a.n43-a.n12*a.n24*a.n43-a.n13*a.n22*a.n44+a.n12*a.n23*a.n44;c.n14=a.n14*a.n23*a.n32-a.n13*a.n24*a.n32-a.n14*a.n22*a.n33+a.n12*a.n24*a.n33+a.n13*a.n22*a.n34-a.n12*
a.n23*a.n34;c.n21=a.n24*a.n33*a.n41-a.n23*a.n34*a.n41-a.n24*a.n31*a.n43+a.n21*a.n34*a.n43+a.n23*a.n31*a.n44-a.n21*a.n33*a.n44;c.n22=a.n13*a.n34*a.n41-a.n14*a.n33*a.n41+a.n14*a.n31*a.n43-a.n11*a.n34*a.n43-a.n13*a.n31*a.n44+a.n11*a.n33*a.n44;c.n23=a.n14*a.n23*a.n41-a.n13*a.n24*a.n41-a.n14*a.n21*a.n43+a.n11*a.n24*a.n43+a.n13*a.n21*a.n44-a.n11*a.n23*a.n44;c.n24=a.n13*a.n24*a.n31-a.n14*a.n23*a.n31+a.n14*a.n21*a.n33-a.n11*a.n24*a.n33-a.n13*a.n21*a.n34+a.n11*a.n23*a.n34;c.n31=a.n22*a.n34*a.n41-a.n24*a.n32*
a.n41+a.n24*a.n31*a.n42-a.n21*a.n34*a.n42-a.n22*a.n31*a.n44+a.n21*a.n32*a.n44;c.n32=a.n14*a.n32*a.n41-a.n12*a.n34*a.n41-a.n14*a.n31*a.n42+a.n11*a.n34*a.n42+a.n12*a.n31*a.n44-a.n11*a.n32*a.n44;c.n33=a.n13*a.n24*a.n41-a.n14*a.n22*a.n41+a.n14*a.n21*a.n42-a.n11*a.n24*a.n42-a.n12*a.n21*a.n44+a.n11*a.n22*a.n44;c.n34=a.n14*a.n22*a.n31-a.n12*a.n24*a.n31-a.n14*a.n21*a.n32+a.n11*a.n24*a.n32+a.n12*a.n21*a.n34-a.n11*a.n22*a.n34;c.n41=a.n23*a.n32*a.n41-a.n22*a.n33*a.n41-a.n23*a.n31*a.n42+a.n21*a.n33*a.n42+a.n22*
a.n31*a.n43-a.n21*a.n32*a.n43;c.n42=a.n12*a.n33*a.n41-a.n13*a.n32*a.n41+a.n13*a.n31*a.n42-a.n11*a.n33*a.n42-a.n12*a.n31*a.n43+a.n11*a.n32*a.n43;c.n43=a.n13*a.n22*a.n41-a.n12*a.n23*a.n41-a.n13*a.n21*a.n42+a.n11*a.n23*a.n42+a.n12*a.n21*a.n43-a.n11*a.n22*a.n43;c.n44=a.n12*a.n23*a.n31-a.n13*a.n22*a.n31+a.n13*a.n21*a.n32-a.n11*a.n23*a.n32-a.n12*a.n21*a.n33+a.n11*a.n22*a.n33;c.multiplyScalar(1/a.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(a){var c=a.flatten();a=new THREE.Matrix3;var e=c[10]*c[5]-c[6]*c[9],g=-c[10]*c[1]+c[2]*c[9],b=c[6]*c[1]-c[2]*c[5],d=-c[10]*c[4]+c[6]*c[8],n=c[10]*c[0]-c[2]*c[8],q=-c[6]*c[0]+c[2]*c[4],o=c[9]*c[4]-c[5]*c[8],f=-c[9]*c[0]+c[1]*c[8],h=c[5]*c[0]-c[1]*c[4];c=c[0]*e+c[1]*d+c[2]*o;if(c==0)throw"matrix not invertible";c=1/c;a.m[0]=c*e;a.m[1]=c*g;a.m[2]=c*b;a.m[3]=c*d;a.m[4]=c*n;a.m[5]=c*q;a.m[6]=c*o;a.m[7]=c*f;a.m[8]=c*h;return a};
THREE.Matrix4.makeFrustum=function(a,c,e,g,b,d){var n,q,o;n=new THREE.Matrix4;q=2*b/(c-a);o=2*b/(g-e);a=(c+a)/(c-a);e=(g+e)/(g-e);g=-(d+b)/(d-b);b=-2*d*b/(d-b);n.n11=q;n.n12=0;n.n13=a;n.n14=0;n.n21=0;n.n22=o;n.n23=e;n.n24=0;n.n31=0;n.n32=0;n.n33=g;n.n34=b;n.n41=0;n.n42=0;n.n43=-1;n.n44=0;return n};THREE.Matrix4.makePerspective=function(a,c,e,g){var b;a=e*Math.tan(a*Math.PI/360);b=-a;return THREE.Matrix4.makeFrustum(b*c,a*c,b,a,e,g)};
THREE.Matrix4.makeOrtho=function(a,c,e,g,b,d){var n,q,o,f;n=new THREE.Matrix4;q=c-a;o=e-g;f=d-b;a=(c+a)/q;e=(e+g)/o;b=(d+b)/f;n.n11=2/q;n.n12=0;n.n13=0;n.n14=-a;n.n21=0;n.n22=2/o;n.n23=0;n.n24=-e;n.n31=0;n.n32=0;n.n33=-2/f;n.n34=-b;n.n41=0;n.n42=0;n.n43=0;n.n44=1;return n};
THREE.Vertex=function(a,c){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=c||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.__visible=true};THREE.Vertex.prototype={toString:function(){return"THREE.Vertex ( position: "+this.position+", normal: "+this.normal+" )"}};
THREE.Face3=function(a,c,e,g,b){this.a=a;this.b=c;this.c=e;this.centroid=new THREE.Vector3;this.normal=g instanceof THREE.Vector3?g:new THREE.Vector3;this.vertexNormals=g instanceof Array?g:[];this.material=b instanceof Array?b:[b]};THREE.Face3.prototype={toString:function(){return"THREE.Face3 ( "+this.a+", "+this.b+", "+this.c+" )"}};
THREE.Face4=function(a,c,e,g,b,d){this.a=a;this.b=c;this.c=e;this.d=g;this.centroid=new THREE.Vector3;this.normal=b instanceof THREE.Vector3?b:new THREE.Vector3;this.vertexNormals=b instanceof Array?b:[];this.material=d instanceof Array?d:[d]};THREE.Face4.prototype={toString:function(){return"THREE.Face4 ( "+this.a+", "+this.b+", "+this.c+" "+this.d+" )"}};THREE.UV=function(a,c){this.u=a||0;this.v=c||0};
THREE.UV.prototype={copy:function(a){this.u=a.u;this.v=a.v},toString:function(){return"THREE.UV ("+this.u+", "+this.v+")"}};THREE.Geometry=function(){this.vertices=[];this.faces=[];this.uvs=[]};
THREE.Geometry.prototype={computeCentroids:function(){var a,c,e;a=0;for(c=this.faces.length;a<c;a++){e=this.faces[a];e.centroid.set(0,0,0);e.centroid.addSelf(this.vertices[e.a].position);e.centroid.addSelf(this.vertices[e.b].position);e.centroid.addSelf(this.vertices[e.c].position);if(e instanceof THREE.Face3)e.centroid.divideScalar(3);else if(e instanceof THREE.Face4){e.centroid.addSelf(this.vertices[e.d].position);e.centroid.divideScalar(4)}}},computeNormals:function(a){var c,e,g,b,d,n,q=new THREE.Vector3,
o=new THREE.Vector3;g=0;for(b=this.vertices.length;g<b;g++){d=this.vertices[g];d.normal.set(0,0,0)}g=0;for(b=this.faces.length;g<b;g++){d=this.faces[g];if(a&&d.vertexNormals.length){q.set(0,0,0);c=0;for(e=d.normal.length;c<e;c++)q.addSelf(d.vertexNormals[c]);q.divideScalar(3)}else{c=this.vertices[d.a];e=this.vertices[d.b];n=this.vertices[d.c];q.sub(n.position,e.position);o.sub(c.position,e.position);q.crossSelf(o)}q.isZero()||q.normalize();d.normal.copy(q)}},computeBoundingBox:function(){if(this.vertices.length>
0){this.bbox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var a=1,c=this.vertices.length;a<c;a++){vertex=this.vertices[a];if(vertex.position.x<this.bbox.x[0])this.bbox.x[0]=vertex.position.x;else if(vertex.position.x>this.bbox.x[1])this.bbox.x[1]=vertex.position.x;if(vertex.position.y<this.bbox.y[0])this.bbox.y[0]=vertex.position.y;else if(vertex.position.y>
this.bbox.y[1])this.bbox.y[1]=vertex.position.y;if(vertex.position.z<this.bbox.z[0])this.bbox.z[0]=vertex.position.z;else if(vertex.position.z>this.bbox.z[1])this.bbox.z[1]=vertex.position.z}}},toString:function(){return"THREE.Geometry ( vertices: "+this.vertices+", faces: "+this.faces+" )"}};
THREE.Camera=function(a,c,e,g){this.position=new THREE.Vector3(0,0,0);this.target={position:new THREE.Vector3(0,0,0)};this.up=new THREE.Vector3(0,1,0);this.matrix=new THREE.Matrix4;this.projectionMatrix=THREE.Matrix4.makePerspective(a,c,e,g);this.autoUpdateMatrix=true;this.updateMatrix=function(){this.matrix.lookAt(this.position,this.target.position,this.up)};this.toString=function(){return"THREE.Camera ( "+this.position+", "+this.target.position+" )"}};THREE.Light=function(a){this.color=new THREE.Color(a)};
THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.PointLight;
THREE.Object3D=function(){this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.translationMatrix=new THREE.Matrix4;this.rotationMatrix=new THREE.Matrix4;this.scaleMatrix=new THREE.Matrix4;this.screen=new THREE.Vector3;this.autoUpdateMatrix=this.visible=true;this.updateMatrix=function(){this.matrixPosition=THREE.Matrix4.translationMatrix(this.position.x,this.position.y,this.position.z);this.rotationMatrix=THREE.Matrix4.rotationXMatrix(this.rotation.x);
this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationYMatrix(this.rotation.y));this.rotationMatrix.multiplySelf(THREE.Matrix4.rotationZMatrix(this.rotation.z));this.scaleMatrix=THREE.Matrix4.scaleMatrix(this.scale.x,this.scale.y,this.scale.z);this.matrix.copy(this.matrixPosition);this.matrix.multiplySelf(this.rotationMatrix);this.matrix.multiplySelf(this.scaleMatrix)}};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a instanceof Array?a:[a];this.autoUpdateMatrix=false};
THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.material=c instanceof Array?c:[c]};THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,c,e){THREE.Object3D.call(this);this.geometry=a;this.material=c instanceof Array?c:[c];this.overdraw=this.doubleSided=this.flipSided=false;this.materialFaceGroup={};this.sortFacesByMaterial();e&&this.normalizeUVs();this.geometry.computeBoundingBox()};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;
THREE.Mesh.prototype.sortFacesByMaterial=function(){function a(h){var k=[];c=0;for(e=h.length;c<e;c++)h[c]==undefined?k.push("undefined"):k.push(h[c].toString());return k.join("_")}var c,e,g,b,d,n,q,o,f={};g=0;for(b=this.geometry.faces.length;g<b;g++){d=this.geometry.faces[g];n=d.material;q=a(n);if(f[q]==undefined)f[q]={hash:q,counter:0};o=f[q].hash+"_"+f[q].counter;if(this.materialFaceGroup[o]==undefined)this.materialFaceGroup[o]={faces:[],material:n,vertices:0};d=d instanceof THREE.Face3?3:4;if(this.materialFaceGroup[o].vertices+
d>65535){f[q].counter+=1;o=f[q].hash+"_"+f[q].counter;if(this.materialFaceGroup[o]==undefined)this.materialFaceGroup[o]={faces:[],material:n,vertices:0}}this.materialFaceGroup[o].faces.push(g);this.materialFaceGroup[o].vertices+=d}};THREE.Mesh.prototype.normalizeUVs=function(){var a,c,e,g,b;a=0;for(c=this.geometry.uvs.length;a<c;a++){b=this.geometry.uvs[a];e=0;for(g=b.length;e<g;e++){if(b[e].u!=1)b[e].u-=Math.floor(b[e].u);if(b[e].v!=1)b[e].v-=Math.floor(b[e].v)}}};THREE.FlatShading=0;
THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;
THREE.LineBasicMaterial=function(a){this.color=new THREE.Color(16711680);this.opacity=1;this.blending=THREE.NormalBlending;this.linewidth=1;this.linejoin=this.linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.linewidth!==undefined)this.linewidth=a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin}this.toString=function(){return"THREE.LineBasicMaterial (<br/>color: "+
this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>linewidth: "+this.linewidth+"<br/>linecap: "+this.linecap+"<br/>linejoin: "+this.linejoin+"<br/>)"}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MeshBasicMaterialCounter.value++;this.color=new THREE.Color(15658734);this.env_map=this.map=null;this.combine=THREE.Multiply;this.reflectivity=1;this.refraction_ratio=0.98;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.env_map!==
undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;
if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}this.toString=function(){return"THREE.MeshBasicMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>wireframe: "+
this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>)"}};THREE.MeshBasicMaterialCounter={value:0};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MeshLambertMaterialCounter.value++;this.color=new THREE.Color(15658734);this.env_map=this.map=null;this.combine=THREE.Multiply;this.reflectivity=1;this.refraction_ratio=0.98;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap="round";if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;
if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;
if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=a.wireframe_linejoin}this.toString=function(){return"THREE.MeshLambertMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>blending: "+
this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/> )"}};THREE.MeshLambertMaterialCounter={value:0};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MeshPhongMaterialCounter.value++;this.color=new THREE.Color(15658734);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.env_map=this.specular_map=this.map=null;this.combine=THREE.Multiply;this.reflectivity=1;this.refraction_ratio=0.98;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;this.wireframe_linejoin=this.wireframe_linecap=
"round";if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.map!==undefined)this.map=a.map;if(a.specular_map!==undefined)this.specular_map=a.specular_map;if(a.env_map!==undefined)this.env_map=a.env_map;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=
a.reflectivity;if(a.refraction_ratio!==undefined)this.refraction_ratio=a.refraction_ratio;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth;if(a.wireframe_linecap!==undefined)this.wireframe_linecap=a.wireframe_linecap;if(a.wireframe_linejoin!==undefined)this.wireframe_linejoin=
a.wireframe_linejoin}this.toString=function(){return"THREE.MeshPhongMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>ambient: "+this.ambient+"<br/>specular: "+this.specular+"<br/>shininess: "+this.shininess+"<br/>map: "+this.map+"<br/>specular_map: "+this.specular_map+"<br/>env_map: "+this.env_map+"<br/>combine: "+this.combine+"<br/>reflectivity: "+this.reflectivity+"<br/>refraction_ratio: "+this.refraction_ratio+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>wireframe: "+
this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>wireframe_linecap: "+this.wireframe_linecap+"<br/>wireframe_linejoin: "+this.wireframe_linejoin+"<br/>"+ +")"}};THREE.MeshPhongMaterialCounter={value:0};
THREE.MeshDepthMaterial=function(a){this.near=1;this.far=1E3;this.opacity=1;this.blending=THREE.NormalBlending;if(a){if(a.near!==undefined)this.near=a.near;if(a.far!==undefined)this.far=a.far;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.__2near=2*this.near;this.__farPlusNear=this.far+this.near;this.__farMinusNear=this.far-this.near;this.toString=function(){return"THREE.MeshDepthMaterial"}};
THREE.MeshNormalMaterial=function(a){this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.MeshNormalMaterial"}};THREE.MeshFaceMaterial=function(){this.toString=function(){return"THREE.MeshFaceMaterial"}};
THREE.MeshCubeMaterial=function(a){this.id=THREE.MeshCubeMaterial.value++;this.env_map=null;this.blending=THREE.NormalBlending;if(a)if(a.env_map!==undefined)this.env_map=a.env_map;this.toString=function(){return"THREE.MeshCubeMaterial( id: "+this.id+"<br/>env_map: "+this.env_map+" )"}};THREE.MeshCubeMaterialCounter={value:0};
THREE.ParticleBasicMaterial=function(a){this.color=new THREE.Color(16711680);this.map=null;this.opacity=1;this.blending=THREE.NormalBlending;this.offset=new THREE.Vector2;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.ParticleBasicMaterial (<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>blending: "+
this.blending+"<br/>)"}};THREE.ParticleCircleMaterial=function(a){this.color=new THREE.Color(16711680);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.ParticleCircleMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};
THREE.ParticleDOMMaterial=function(a){this.domElement=a;this.toString=function(){return"THREE.ParticleDOMMaterial ( domElement: "+this.domElement+" )"}};THREE.Texture=function(a,c,e,g){this.image=a;this.loaded=false;this.mapping=c!==undefined?c:THREE.UVMapping;this.wrap_s=e!==undefined?e:THREE.ClampToEdge;this.wrap_t=g!==undefined?g:THREE.ClampToEdge;this.toString=function(){return"THREE.Texture (<br/>image: "+this.image+"<br/>wrap_s: "+this.wrap_s+"<br/>wrap_t: "+this.wrap_t+"<br/>)"}};
THREE.UVMapping=0;THREE.ReflectionMap=1;THREE.RefractionMap=2;THREE.Multiply=0;THREE.Mix=1;THREE.Repeat=0;THREE.ClampToEdge=1;THREE.MirroredRepeat=2;THREE.TextureCube=function(a,c){this.image=a;this.mapping=c?c:THREE.ReflectionMap;this.toString=function(){return"THREE.TextureCube (<br/>image: "+this.image+"<br/>mapping: "+this.mapping+"<br/>)"}};
THREE.Scene=function(){this.objects=[];this.lights=[];this.addObject=function(a){this.objects.push(a)};this.removeObject=function(a){a=this.objects.indexOf(a);a!==-1&&this.objects.splice(a,1)};this.addLight=function(a){this.lights.push(a)};this.removeLight=function(a){a=this.lights.indexOf(a);a!==-1&&this.lights.splice(a,1)};this.toString=function(){return"THREE.Scene ( "+this.objects+" )"}};
THREE.Projector=function(){function a(L,u){var w=0,H=1,A=L.z+L.w,I=u.z+u.w,p=-L.z+L.w,x=-u.z+u.w;if(A>=0&&I>=0&&p>=0&&x>=0)return true;else if(A<0&&I<0||p<0&&x<0)return false;else{if(A<0)w=Math.max(w,A/(A-I));else if(I<0)H=Math.min(H,A/(A-I));if(p<0)w=Math.max(w,p/(p-x));else if(x<0)H=Math.min(H,p/(p-x));if(H<w)return false;else{L.lerpSelf(u,w);u.lerpSelf(L,1-H);return true}}}var c=null,e,g,b,d=[],n,q,o=[],f,h,k=[],i=new THREE.Vector4,m=new THREE.Matrix4,l=new THREE.Matrix4,s=new THREE.Vector4,v=
new THREE.Vector4,j;this.projectScene=function(L,u){var w,H,A,I,p,x,Y,C,Z,O,aa,ca,M,Q,r,E,K;c=[];b=_face4Count=q=h=0;u.autoUpdateMatrix&&u.updateMatrix();m.multiply(u.projectionMatrix,u.matrix);Y=L.objects;w=0;for(H=Y.length;w<H;w++){C=Y[w];C.autoUpdateMatrix&&C.updateMatrix();Z=C.matrix;O=C.rotationMatrix;aa=C.material;ca=C.overdraw;if(C instanceof THREE.Mesh){M=C.geometry.vertices;A=0;for(I=M.length;A<I;A++){Q=M[A];Q.positionWorld.copy(Q.position);Z.transform(Q.positionWorld);r=Q.positionScreen;
r.copy(Q.positionWorld);m.transform(r);r.multiplyScalar(1/r.w);Q.__visible=r.z>0&&r.z<1}Q=C.geometry.faces;A=0;for(I=Q.length;A<I;A++){r=Q[A];if(r instanceof THREE.Face3){p=M[r.a];x=M[r.b];E=M[r.c];if(p.__visible&&x.__visible&&E.__visible)if(C.doubleSided||C.flipSided!=(E.positionScreen.x-p.positionScreen.x)*(x.positionScreen.y-p.positionScreen.y)-(E.positionScreen.y-p.positionScreen.y)*(x.positionScreen.x-p.positionScreen.x)<0){e=d[b]=d[b]||new THREE.RenderableFace3;e.v1.positionWorld.copy(p.positionWorld);
e.v2.positionWorld.copy(x.positionWorld);e.v3.positionWorld.copy(E.positionWorld);e.v1.positionScreen.copy(p.positionScreen);e.v2.positionScreen.copy(x.positionScreen);e.v3.positionScreen.copy(E.positionScreen);e.normalWorld.copy(r.normal);O.transform(e.normalWorld);e.centroidWorld.copy(r.centroid);Z.transform(e.centroidWorld);e.centroidScreen.copy(e.centroidWorld);m.transform(e.centroidScreen);E=r.vertexNormals;j=e.vertexNormalsWorld;p=0;for(x=E.length;p<x;p++){K=j[p].copy(E[p]);O.transform(K)}e.z=
e.centroidScreen.z;e.meshMaterial=aa;e.faceMaterial=r.material;e.overdraw=ca;if(C.geometry.uvs[A]){e.uvs[0]=C.geometry.uvs[A][0];e.uvs[1]=C.geometry.uvs[A][1];e.uvs[2]=C.geometry.uvs[A][2]}c.push(e);b++}}else if(r instanceof THREE.Face4){p=M[r.a];x=M[r.b];E=M[r.c];K=M[r.d];if(p.__visible&&x.__visible&&E.__visible&&K.__visible)if(C.doubleSided||C.flipSided!=((K.positionScreen.x-p.positionScreen.x)*(x.positionScreen.y-p.positionScreen.y)-(K.positionScreen.y-p.positionScreen.y)*(x.positionScreen.x-p.positionScreen.x)<
0||(x.positionScreen.x-E.positionScreen.x)*(K.positionScreen.y-E.positionScreen.y)-(x.positionScreen.y-E.positionScreen.y)*(K.positionScreen.x-E.positionScreen.x)<0)){e=d[b]=d[b]||new THREE.RenderableFace3;e.v1.positionWorld.copy(p.positionWorld);e.v2.positionWorld.copy(x.positionWorld);e.v3.positionWorld.copy(K.positionWorld);e.v1.positionScreen.copy(p.positionScreen);e.v2.positionScreen.copy(x.positionScreen);e.v3.positionScreen.copy(K.positionScreen);e.normalWorld.copy(r.normal);O.transform(e.normalWorld);
e.centroidWorld.copy(r.centroid);Z.transform(e.centroidWorld);e.centroidScreen.copy(e.centroidWorld);m.transform(e.centroidScreen);e.z=e.centroidScreen.z;e.meshMaterial=aa;e.faceMaterial=r.material;e.overdraw=ca;if(C.geometry.uvs[A]){e.uvs[0]=C.geometry.uvs[A][0];e.uvs[1]=C.geometry.uvs[A][1];e.uvs[2]=C.geometry.uvs[A][3]}c.push(e);b++;g=d[b]=d[b]||new THREE.RenderableFace3;g.v1.positionWorld.copy(x.positionWorld);g.v2.positionWorld.copy(E.positionWorld);g.v3.positionWorld.copy(K.positionWorld);g.v1.positionScreen.copy(x.positionScreen);
g.v2.positionScreen.copy(E.positionScreen);g.v3.positionScreen.copy(K.positionScreen);g.normalWorld.copy(e.normalWorld);g.centroidWorld.copy(e.centroidWorld);g.centroidScreen.copy(e.centroidScreen);g.z=g.centroidScreen.z;g.meshMaterial=aa;g.faceMaterial=r.material;g.overdraw=ca;if(C.geometry.uvs[A]){g.uvs[0]=C.geometry.uvs[A][1];g.uvs[1]=C.geometry.uvs[A][2];g.uvs[2]=C.geometry.uvs[A][3]}c.push(g);b++}}}}else if(C instanceof THREE.Line){l.multiply(m,Z);M=C.geometry.vertices;Q=M[0];Q.positionScreen.copy(Q.position);
l.transform(Q.positionScreen);A=1;for(I=M.length;A<I;A++){p=M[A];p.positionScreen.copy(p.position);l.transform(p.positionScreen);x=M[A-1];s.copy(p.positionScreen);v.copy(x.positionScreen);if(a(s,v)){s.multiplyScalar(1/s.w);v.multiplyScalar(1/v.w);n=o[q]=o[q]||new THREE.RenderableLine;n.v1.positionScreen.copy(s);n.v2.positionScreen.copy(v);n.z=Math.max(s.z,v.z);n.material=C.material;c.push(n);q++}}}else if(C instanceof THREE.Particle){i.set(C.position.x,C.position.y,C.position.z,1);m.transform(i);
i.z/=i.w;if(i.z>0&&i.z<1){f=k[h]=k[h]||new THREE.RenderableParticle;f.x=i.x/i.w;f.y=i.y/i.w;f.z=i.z;f.rotation=C.rotation.z;f.scale.x=C.scale.x*Math.abs(f.x-(i.x+u.projectionMatrix.n11)/(i.w+u.projectionMatrix.n14));f.scale.y=C.scale.y*Math.abs(f.y-(i.y+u.projectionMatrix.n22)/(i.w+u.projectionMatrix.n24));f.material=C.material;c.push(f);h++}}}c.sort(function(U,z){return z.z-U.z});return c};this.unprojectVector=function(L,u){var w=new THREE.Matrix4;w.multiply(THREE.Matrix4.makeInvert(u.matrix),THREE.Matrix4.makeInvert(u.projectionMatrix));
w.transform(L);return L}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,c=new THREE.Projector,e,g,b,d;this.domElement=document.createElement("div");this.setSize=function(n,q){e=n;g=q;b=e/2;d=g/2};this.render=function(n,q){var o,f,h,k,i,m,l,s;a=c.projectScene(n,q);o=0;for(f=a.length;o<f;o++){i=a[o];if(i instanceof THREE.RenderableParticle){l=i.x*b+b;s=i.y*d+d;h=0;for(k=i.material.length;h<k;h++){m=i.material[h];if(m instanceof THREE.ParticleDOMMaterial){m=m.domElement;m.style.left=l+"px";m.style.top=s+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(D,T,P,B){var t,F,W,N,S=D.lights;D=0;for(t=S.length;D<t;D++){F=S[D];W=F.color;N=F.intensity;if(F instanceof THREE.DirectionalLight){F=P.dot(F.position)*N;if(F>0){B.r+=W.r*F;B.g+=W.g*F;B.b+=W.b*F}}else if(F instanceof THREE.PointLight){ra.sub(F.position,T);ra.normalize();F=P.dot(ra)*N;if(F>0){B.r+=W.r*F;B.g+=W.g*F;B.b+=W.b*F}}}}function c(D,T,P,B,t,F){if(t.opacity!=0){d(t.opacity);n(t.blending);Y=D.positionScreen.x;C=D.positionScreen.y;Z=T.positionScreen.x;
O=T.positionScreen.y;aa=P.positionScreen.x;ca=P.positionScreen.y;var W=Y,N=C,S=Z,X=O,V=aa,ba=ca;j.beginPath();j.moveTo(W,N);j.lineTo(S,X);j.lineTo(V,ba);j.lineTo(W,N);j.closePath();if(t instanceof THREE.MeshBasicMaterial)if(t.map)b(Y,C,Z,O,aa,ca,t.map.image,B.uvs[0].u,B.uvs[0].v,B.uvs[1].u,B.uvs[1].v,B.uvs[2].u,B.uvs[2].v);else t.wireframe?e(t.color.__styleString,t.wireframe_linewidth):g(t.color.__styleString);else if(t instanceof THREE.MeshLambertMaterial){if(t.map&&!t.wireframe){b(Y,C,Z,O,aa,ca,
t.map.image,B.uvs[0].u,B.uvs[0].v,B.uvs[1].u,B.uvs[1].v,B.uvs[2].u,B.uvs[2].v);n(THREE.SubtractiveBlending)}if(da)if(t.shading==THREE.SmoothShading&&!t.wireframe){Q.r=r.r=E.r=ea.r;Q.g=r.g=E.g=ea.g;Q.b=r.b=E.b=ea.b;a(F,B.v1.positionWorld,B.vertexNormalsWorld[0],Q);a(F,B.v2.positionWorld,B.vertexNormalsWorld[1],r);a(F,B.v3.positionWorld,B.vertexNormalsWorld[2],E);K.r=(r.r+E.r)*0.5;K.g=(r.g+E.g)*0.5;K.b=(r.b+E.b)*0.5;R=q(Q,r,E,K);b(Y,C,Z,O,aa,ca,R,0,0,1,0,0,1)}else{fa.r=ea.r;fa.g=ea.g;fa.b=ea.b;a(F,
B.centroidWorld,B.normalWorld,fa);M.r=t.color.r*fa.r;M.g=t.color.g*fa.g;M.b=t.color.b*fa.b;M.updateStyleString();t.wireframe?e(M.__styleString,t.wireframe_linewidth):g(M.__styleString)}else t.wireframe?e(t.color.__styleString,t.wireframe_linewidth):g(t.color.__styleString)}else if(t instanceof THREE.MeshDepthMaterial){U=t.__2near;z=t.__farPlusNear;y=t.__farMinusNear;Q.r=Q.g=Q.b=1-U/(z-D.positionScreen.z*y);r.r=r.g=r.b=1-U/(z-T.positionScreen.z*y);E.r=E.g=E.b=1-U/(z-P.positionScreen.z*y);K.r=(r.r+
E.r)*0.5;K.g=(r.g+E.g)*0.5;K.b=(r.b+E.b)*0.5;R=q(Q,r,E,K);b(Y,C,Z,O,aa,ca,R,0,0,1,0,0,1)}else if(t instanceof THREE.MeshNormalMaterial){M.r=o(B.normalWorld.x);M.g=o(B.normalWorld.y);M.b=o(B.normalWorld.z);M.updateStyleString();t.wireframe?e(M.__styleString,t.wireframe_linewidth):g(M.__styleString)}}}function e(D,T){if(w!=D)j.strokeStyle=w=D;if(A!=T)j.lineWidth=A=T;j.stroke()}function g(D){if(H!=D)j.fillStyle=H=D;j.fill()}function b(D,T,P,B,t,F,W,N,S,X,V,ba,ja){var ia=W.width-1,ga=W.height-1;N*=ia;
S*=ga;X*=ia;V*=ga;ba*=ia;ja*=ga;P-=D;B-=T;t-=D;F-=T;X-=N;V-=S;ba-=N;ja-=S;ga=1/(X*ja-ba*V);ia=(ja*P-V*t)*ga;V=(ja*B-V*F)*ga;P=(X*t-ba*P)*ga;B=(X*F-ba*B)*ga;D=D-ia*N-P*S;T=T-V*N-B*S;j.save();j.transform(ia,V,P,B,D,T);j.clip();j.drawImage(W,0,0);j.restore()}function d(D){if(L!=D)j.globalAlpha=L=D}function n(D){if(u!=D){switch(D){case THREE.NormalBlending:j.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:j.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:j.globalCompositeOperation=
"darker"}u=D}}function q(D,T,P,B){ha[0]=~~(D.r*255);ha[1]=~~(D.g*255);ha[2]=~~(D.b*255);ha[4]=~~(T.r*255);ha[5]=~~(T.g*255);ha[6]=~~(T.b*255);ha[8]=~~(P.r*255);ha[9]=~~(P.g*255);ha[10]=~~(P.b*255);ha[12]=~~(B.r*255);ha[13]=~~(B.g*255);ha[14]=~~(B.b*255);na.putImageData(sa,0,0);qa.drawImage(oa,0,0);return pa}function o(D){return D<0?Math.min((1+D)*0.5,0.5):0.5+Math.min(D*0.5,0.5)}function f(D,T){var P=T.x-D.x,B=T.y-D.y,t=1/Math.sqrt(P*P+B*B);P*=t;B*=t;T.x+=P;T.y+=B;D.x-=P;D.y-=B}var h=null,k=new THREE.Projector,
i=document.createElement("canvas"),m,l,s,v,j=i.getContext("2d"),L=1,u=0,w=null,H=null,A=1,I,p,x,Y,C,Z,O,aa,ca,M=new THREE.Color,Q=new THREE.Color,r=new THREE.Color,E=new THREE.Color,K=new THREE.Color,U,z,y,R,$=new THREE.Rectangle,G=new THREE.Rectangle,J=new THREE.Rectangle,da=false,fa=new THREE.Color,ea=new THREE.Color,ka=new THREE.Color,la=new THREE.Color,va=Math.PI*2,ra=new THREE.Vector3;new THREE.UV;new THREE.UV;new THREE.UV;new THREE.UV;var oa,na,sa,ha,pa,qa,ma=16;oa=document.createElement("canvas");
oa.width=oa.height=2;na=oa.getContext("2d");na.fillStyle="rgba(0,0,0,1)";na.fillRect(0,0,2,2);sa=na.getImageData(0,0,2,2);ha=sa.data;pa=document.createElement("canvas");pa.width=pa.height=ma;qa=pa.getContext("2d");qa.translate(-ma/2,-ma/2);qa.scale(ma,ma);ma--;this.domElement=i;this.autoClear=true;this.setSize=function(D,T){m=D;l=T;s=m/2;v=l/2;i.width=m;i.height=l;$.set(-s,-v,s,v)};this.clear=function(){if(!G.isEmpty()){G.inflate(1);G.minSelf($);j.clearRect(G.getX(),G.getY(),G.getWidth(),G.getHeight());
G.empty()}};this.render=function(D,T){var P,B,t,F,W,N,S,X;j.setTransform(1,0,0,-1,s,v);this.autoClear&&this.clear();h=k.projectScene(D,T);if(da=D.lights.length>0){W=D.lights;ea.setRGB(0,0,0);ka.setRGB(0,0,0);la.setRGB(0,0,0);P=0;for(B=W.length;P<B;P++){t=W[P];F=t.color;if(t instanceof THREE.AmbientLight){ea.r+=F.r;ea.g+=F.g;ea.b+=F.b}else if(t instanceof THREE.DirectionalLight){ka.r+=F.r;ka.g+=F.g;ka.b+=F.b}else if(t instanceof THREE.PointLight){la.r+=F.r;la.g+=F.g;la.b+=F.b}}}P=0;for(B=h.length;P<
B;P++){t=h[P];J.empty();if(t instanceof THREE.RenderableParticle){I=t;I.x*=s;I.y*=v;F=0;for(W=t.material.length;F<W;F++){N=I;S=t;var V=t.material[F];if(V.opacity!=0){d(V.opacity);n(V.blending);X=void 0;var ba=void 0,ja=void 0,ia=void 0,ga=void 0,ta=void 0,ua=void 0;if(V instanceof THREE.ParticleBasicMaterial){if(V.map){ga=V.map;ta=ga.width>>1;ua=ga.height>>1;ja=S.scale.x*s;ia=S.scale.y*v;X=ja*ta;ba=ia*ua;J.set(N.x-X,N.y-ba,N.x+X,N.y+ba);if($.instersects(J)){j.save();j.translate(N.x,N.y);j.rotate(-S.rotation);
j.scale(ja,-ia);j.translate(-ta,-ua);j.drawImage(ga,0,0);j.restore()}}}else if(V instanceof THREE.ParticleCircleMaterial){if(da){fa.r=ea.r+ka.r+la.r;fa.g=ea.g+ka.g+la.g;fa.b=ea.b+ka.b+la.b;M.r=V.color.r*fa.r;M.g=V.color.g*fa.g;M.b=V.color.b*fa.b;M.updateStyleString()}else M.__styleString=V.color.__styleString;X=S.scale.x*s;ba=S.scale.y*v;J.set(N.x-X,N.y-ba,N.x+X,N.y+ba);if($.instersects(J)){V=M.__styleString;if(H!=V)j.fillStyle=H=V;j.save();j.translate(N.x,N.y);j.rotate(-S.rotation);j.scale(X,ba);
j.beginPath();j.arc(0,0,1,0,va,true);j.closePath();j.fill();j.restore()}}}}}else if(t instanceof THREE.RenderableLine){I=t.v1;p=t.v2;I.positionScreen.x*=s;I.positionScreen.y*=v;p.positionScreen.x*=s;p.positionScreen.y*=v;J.addPoint(I.positionScreen.x,I.positionScreen.y);J.addPoint(p.positionScreen.x,p.positionScreen.y);if($.instersects(J)){F=0;for(W=t.material.length;F<W;){S=I;X=p;N=t.material[F++];if(N.opacity!=0){d(N.opacity);n(N.blending);j.beginPath();j.moveTo(S.positionScreen.x,S.positionScreen.y);
j.lineTo(X.positionScreen.x,X.positionScreen.y);j.closePath();if(N instanceof THREE.LineBasicMaterial){M.__styleString=N.color.__styleString;S=N.linewidth;if(A!=S)j.lineWidth=A=S;S=M.__styleString;if(w!=S)j.strokeStyle=w=S;j.stroke();J.inflate(N.linewidth*2)}}}}}else if(t instanceof THREE.RenderableFace3){I=t.v1;p=t.v2;x=t.v3;I.positionScreen.x*=s;I.positionScreen.y*=v;p.positionScreen.x*=s;p.positionScreen.y*=v;x.positionScreen.x*=s;x.positionScreen.y*=v;if(t.overdraw){f(I.positionScreen,p.positionScreen);
f(p.positionScreen,x.positionScreen);f(x.positionScreen,I.positionScreen)}J.addPoint(I.positionScreen.x,I.positionScreen.y);J.addPoint(p.positionScreen.x,p.positionScreen.y);J.addPoint(x.positionScreen.x,x.positionScreen.y);if($.instersects(J)){F=0;for(W=t.meshMaterial.length;F<W;){X=t.meshMaterial[F++];if(X instanceof THREE.MeshFaceMaterial){N=0;for(S=t.faceMaterial.length;N<S;)(X=t.faceMaterial[N++])&&c(I,p,x,t,X,D)}else c(I,p,x,t,X,D)}}}G.addRectangle(J)}j.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(r,E,K){var U,z,y,R;U=0;for(z=r.lights.length;U<z;U++){y=r.lights[U];if(y instanceof THREE.DirectionalLight){R=E.normalWorld.dot(y.position)*y.intensity;if(R>0){K.r+=y.color.r*R;K.g+=y.color.g*R;K.b+=y.color.b*R}}else if(y instanceof THREE.PointLight){x.sub(y.position,E.centroidWorld);x.normalize();R=E.normalWorld.dot(x)*y.intensity;if(R>0){K.r+=y.color.r*R;K.g+=y.color.g*R;K.b+=y.color.b*R}}}}function c(r,E,K,U,z,y){O=g(aa++);O.setAttribute("d","M "+r.positionScreen.x+
" "+r.positionScreen.y+" L "+E.positionScreen.x+" "+E.positionScreen.y+" L "+K.positionScreen.x+","+K.positionScreen.y+"z");if(z instanceof THREE.MeshBasicMaterial)u.__styleString=z.color.__styleString;else if(z instanceof THREE.MeshLambertMaterial)if(L){w.r=H.r;w.g=H.g;w.b=H.b;a(y,U,w);u.r=z.color.r*w.r;u.g=z.color.g*w.g;u.b=z.color.b*w.b;u.updateStyleString()}else u.__styleString=z.color.__styleString;else if(z instanceof THREE.MeshDepthMaterial){p=1-z.__2near/(z.__farPlusNear-U.z*z.__farMinusNear);
u.setRGB(p,p,p)}else z instanceof THREE.MeshNormalMaterial&&u.setRGB(b(U.normalWorld.x),b(U.normalWorld.y),b(U.normalWorld.z));z.wireframe?O.setAttribute("style","fill: none; stroke: "+u.__styleString+"; stroke-width: "+z.wireframe_linewidth+"; stroke-opacity: "+z.opacity+"; stroke-linecap: "+z.wireframe_linecap+"; stroke-linejoin: "+z.wireframe_linejoin):O.setAttribute("style","fill: "+u.__styleString+"; fill-opacity: "+z.opacity);q.appendChild(O)}function e(r,E,K,U,z,y,R){O=g(aa++);O.setAttribute("d",
"M "+r.positionScreen.x+" "+r.positionScreen.y+" L "+E.positionScreen.x+" "+E.positionScreen.y+" L "+K.positionScreen.x+","+K.positionScreen.y+" L "+U.positionScreen.x+","+U.positionScreen.y+"z");if(y instanceof THREE.MeshBasicMaterial)u.__styleString=y.color.__styleString;else if(y instanceof THREE.MeshLambertMaterial)if(L){w.r=H.r;w.g=H.g;w.b=H.b;a(R,z,w);u.r=y.color.r*w.r;u.g=y.color.g*w.g;u.b=y.color.b*w.b;u.updateStyleString()}else u.__styleString=y.color.__styleString;else if(y instanceof THREE.MeshDepthMaterial){p=
1-y.__2near/(y.__farPlusNear-z.z*y.__farMinusNear);u.setRGB(p,p,p)}else y instanceof THREE.MeshNormalMaterial&&u.setRGB(b(z.normalWorld.x),b(z.normalWorld.y),b(z.normalWorld.z));y.wireframe?O.setAttribute("style","fill: none; stroke: "+u.__styleString+"; stroke-width: "+y.wireframe_linewidth+"; stroke-opacity: "+y.opacity+"; stroke-linecap: "+y.wireframe_linecap+"; stroke-linejoin: "+y.wireframe_linejoin):O.setAttribute("style","fill: "+u.__styleString+"; fill-opacity: "+y.opacity);q.appendChild(O)}
function g(r){if(Y[r]==null){Y[r]=document.createElementNS("http://www.w3.org/2000/svg","path");Q==0&&Y[r].setAttribute("shape-rendering","crispEdges");return Y[r]}return Y[r]}function b(r){return r<0?Math.min((1+r)*0.5,0.5):0.5+Math.min(r*0.5,0.5)}var d=null,n=new THREE.Projector,q=document.createElementNS("http://www.w3.org/2000/svg","svg"),o,f,h,k,i,m,l,s,v=new THREE.Rectangle,j=new THREE.Rectangle,L=false,u=new THREE.Color(16777215),w=new THREE.Color(16777215),H=new THREE.Color(0),A=new THREE.Color(0),
I=new THREE.Color(0),p,x=new THREE.Vector3,Y=[],C=[],Z=[],O,aa,ca,M,Q=1;this.domElement=q;this.autoClear=true;this.setQuality=function(r){switch(r){case "high":Q=1;break;case "low":Q=0}};this.setSize=function(r,E){o=r;f=E;h=o/2;k=f/2;q.setAttribute("viewBox",-h+" "+-k+" "+o+" "+f);q.setAttribute("width",o);q.setAttribute("height",f);v.set(-h,-k,h,k)};this.clear=function(){for(;q.childNodes.length>0;)q.removeChild(q.childNodes[0])};this.render=function(r,E){var K,U,z,y,R,$,G,J;this.autoClear&&this.clear();
d=n.projectScene(r,E);M=ca=aa=0;if(L=r.lights.length>0){G=r.lights;H.setRGB(0,0,0);A.setRGB(0,0,0);I.setRGB(0,0,0);K=0;for(U=G.length;K<U;K++){z=G[K];y=z.color;if(z instanceof THREE.AmbientLight){H.r+=y.r;H.g+=y.g;H.b+=y.b}else if(z instanceof THREE.DirectionalLight){A.r+=y.r;A.g+=y.g;A.b+=y.b}else if(z instanceof THREE.PointLight){I.r+=y.r;I.g+=y.g;I.b+=y.b}}}K=0;for(U=d.length;K<U;K++){G=d[K];j.empty();if(G instanceof THREE.RenderableParticle){i=G;i.x*=h;i.y*=-k;z=0;for(y=G.material.length;z<y;z++)if(J=
G.material[z]){R=i;$=G;J=J;var da=ca++;if(C[da]==null){C[da]=document.createElementNS("http://www.w3.org/2000/svg","circle");Q==0&&C[da].setAttribute("shape-rendering","crispEdges")}O=C[da];O.setAttribute("cx",R.x);O.setAttribute("cy",R.y);O.setAttribute("r",$.scale.x*h);if(J instanceof THREE.ParticleCircleMaterial){if(L){w.r=H.r+A.r+I.r;w.g=H.g+A.g+I.g;w.b=H.b+A.b+I.b;u.r=J.color.r*w.r;u.g=J.color.g*w.g;u.b=J.color.b*w.b;u.updateStyleString()}else u=J.color;O.setAttribute("style","fill: "+u.__styleString)}q.appendChild(O)}}else if(G instanceof
THREE.RenderableLine){i=G.v1;m=G.v2;i.positionScreen.x*=h;i.positionScreen.y*=-k;m.positionScreen.x*=h;m.positionScreen.y*=-k;j.addPoint(i.positionScreen.x,i.positionScreen.y);j.addPoint(m.positionScreen.x,m.positionScreen.y);if(v.instersects(j)){z=0;for(y=G.material.length;z<y;)if(J=G.material[z++]){R=i;$=m;J=J;da=M++;if(Z[da]==null){Z[da]=document.createElementNS("http://www.w3.org/2000/svg","line");Q==0&&Z[da].setAttribute("shape-rendering","crispEdges")}O=Z[da];O.setAttribute("x1",R.positionScreen.x);
O.setAttribute("y1",R.positionScreen.y);O.setAttribute("x2",$.positionScreen.x);O.setAttribute("y2",$.positionScreen.y);if(J instanceof THREE.LineBasicMaterial){u.__styleString=J.color.__styleString;O.setAttribute("style","fill: none; stroke: "+u.__styleString+"; stroke-width: "+J.linewidth+"; stroke-opacity: "+J.opacity+"; stroke-linecap: "+J.linecap+"; stroke-linejoin: "+J.linejoin);q.appendChild(O)}}}}else if(G instanceof THREE.RenderableFace3){i=G.v1;m=G.v2;l=G.v3;i.positionScreen.x*=h;i.positionScreen.y*=
-k;m.positionScreen.x*=h;m.positionScreen.y*=-k;l.positionScreen.x*=h;l.positionScreen.y*=-k;j.addPoint(i.positionScreen.x,i.positionScreen.y);j.addPoint(m.positionScreen.x,m.positionScreen.y);j.addPoint(l.positionScreen.x,l.positionScreen.y);if(v.instersects(j)){z=0;for(y=G.meshMaterial.length;z<y;){J=G.meshMaterial[z++];if(J instanceof THREE.MeshFaceMaterial){R=0;for($=G.faceMaterial.length;R<$;)(J=G.faceMaterial[R++])&&c(i,m,l,G,J,r)}else J&&c(i,m,l,G,J,r)}}}else if(G instanceof THREE.RenderableFace4){i=
G.v1;m=G.v2;l=G.v3;s=G.v4;i.positionScreen.x*=h;i.positionScreen.y*=-k;m.positionScreen.x*=h;m.positionScreen.y*=-k;l.positionScreen.x*=h;l.positionScreen.y*=-k;s.positionScreen.x*=h;s.positionScreen.y*=-k;j.addPoint(i.positionScreen.x,i.positionScreen.y);j.addPoint(m.positionScreen.x,m.positionScreen.y);j.addPoint(l.positionScreen.x,l.positionScreen.y);j.addPoint(s.positionScreen.x,s.positionScreen.y);if(v.instersects(j)){z=0;for(y=G.meshMaterial.length;z<y;){J=G.meshMaterial[z++];if(J instanceof
THREE.MeshFaceMaterial){R=0;for($=G.faceMaterial.length;R<$;)(J=G.faceMaterial[R++])&&e(i,m,l,s,G,J,r)}else J&&e(i,m,l,s,G,J,r)}}}}}};
THREE.WebGLRenderer=function(a){function c(f,h){var k;if(f=="fragment")k=b.createShader(b.FRAGMENT_SHADER);else if(f=="vertex")k=b.createShader(b.VERTEX_SHADER);b.shaderSource(k,h);b.compileShader(k);if(!b.getShaderParameter(k,b.COMPILE_STATUS)){alert(b.getShaderInfoLog(k));return null}return k}function e(f){switch(f){case THREE.Repeat:return b.REPEAT;case THREE.ClampToEdge:return b.CLAMP_TO_EDGE;case THREE.MirroredRepeat:return b.MIRRORED_REPEAT}return 0}var g=document.createElement("canvas"),b,
d,n=new THREE.Matrix4,q;a=function(f,h){if(f){var k,i,m,l=pointLights=maxDirLights=maxPointLights=0;k=0;for(i=f.lights.length;k<i;k++){m=f.lights[k];m instanceof THREE.DirectionalLight&&l++;m instanceof THREE.PointLight&&pointLights++}if(pointLights+l<=h){maxDirLights=l;maxPointLights=pointLights}else{maxDirLights=Math.ceil(h*l/(pointLights+l));maxPointLights=h-maxDirLights}return{directional:maxDirLights,point:maxPointLights}}return{directional:1,point:h-1}}(a,4);this.domElement=g;this.autoClear=
true;try{b=g.getContext("experimental-webgl",{antialias:true})}catch(o){}if(!b){alert("WebGL not supported");throw"cannot create webgl context";}b.clearColor(0,0,0,1);b.clearDepth(1);b.enable(b.DEPTH_TEST);b.depthFunc(b.LEQUAL);b.frontFace(b.CCW);b.cullFace(b.BACK);b.enable(b.CULL_FACE);b.enable(b.BLEND);b.blendFunc(b.ONE,b.ONE_MINUS_SRC_ALPHA);b.clearColor(0,0,0,0);(function(f,h){d=b.createProgram();b.attachShader(d,c("fragment",["#ifdef GL_ES\nprecision highp float;\n#endif",f?"#define MAX_DIR_LIGHTS "+
f:"",h?"#define MAX_POINT_LIGHTS "+h:"","uniform int material;\nuniform bool enableMap;\nuniform bool enableCubeMap;\nuniform bool mixEnvMap;\nuniform samplerCube tCube;\nuniform float mReflectivity;\nuniform sampler2D tMap;\nuniform vec4 mColor;\nuniform float mOpacity;\nuniform vec4 mAmbient;\nuniform vec4 mSpecular;\nuniform float mShininess;\nuniform float m2Near;\nuniform float mFarPlusNear;\nuniform float mFarMinusNear;\nuniform int pointLightNumber;\nuniform int directionalLightNumber;",f?
"uniform mat4 viewMatrix;":"",f?"uniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];":"","varying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vLightWeighting;",h?"varying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];":"","varying vec3 vViewPosition;\nvarying vec3 vReflect;\nuniform vec3 cameraPosition;\nvoid main() {\nvec4 mapColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nvec4 cubeColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nif ( enableMap ) {\nmapColor = texture2D( tMap, vUv );\n}\nif ( enableCubeMap ) {\ncubeColor.r = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) ).r;\ncubeColor.g = textureCube( tCube, vec3( -vReflect.x + 0.005, vReflect.yz ) ).g;\ncubeColor.b = textureCube( tCube, vec3( -vReflect.x + 0.01, vReflect.yz ) ).b;\n}\nif ( material == 5 ) { \nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( -wPos.x, wPos.yz ) );\n} else if ( material == 4 ) { \ngl_FragColor = vec4( 0.5*normalize( vNormal ) + vec3(0.5, 0.5, 0.5), mOpacity );\n} else if ( material == 3 ) { \nfloat w = 0.5;\ngl_FragColor = vec4( w, w, w, mOpacity );\n} else if ( material == 2 ) { \nvec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );",
h?"vec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );":"",h?"vec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );":"",h?"for( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {":"",h?"vec3 pointVector = normalize( vPointLightVector[ i ] );":"",h?"vec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );":"",h?"float pointDotNormalHalf = dot( normal, pointHalfVector );":"",h?"float pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );":"",h?"float pointSpecularWeight = 0.0;":"",h?"if ( pointDotNormalHalf >= 0.0 )":
"",h?"pointSpecularWeight = pow( pointDotNormalHalf, mShininess );":"",h?"pointDiffuse  += mColor * pointDiffuseWeight;":"",h?"pointSpecular += mSpecular * pointSpecularWeight;":"",h?"}":"",f?"vec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );":"",f?"vec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );":"",f?"for( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {":"",f?"vec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );":"",f?"vec3 dirVector = normalize( lDirection.xyz );":"",f?"vec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );":
"",f?"float dirDotNormalHalf = dot( normal, dirHalfVector );":"",f?"float dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );":"",f?"float dirSpecularWeight = 0.0;":"",f?"if ( dirDotNormalHalf >= 0.0 )":"",f?"dirSpecularWeight = pow( dirDotNormalHalf, mShininess );":"",f?"dirDiffuse  += mColor * dirDiffuseWeight;":"",f?"dirSpecular += mSpecular * dirSpecularWeight;":"",f?"}":"","vec4 totalLight = mAmbient;",f?"totalLight += dirDiffuse + dirSpecular;":"",h?"totalLight += pointDiffuse + pointSpecular;":
"","if ( mixEnvMap ) {\ngl_FragColor = vec4( mix( mapColor.rgb * totalLight.xyz * vLightWeighting, cubeColor.rgb, mReflectivity ), mapColor.a );\n} else {\ngl_FragColor = vec4( mapColor.rgb * cubeColor.rgb * totalLight.xyz * vLightWeighting, mapColor.a );\n}\n} else if ( material == 1 ) {\nif ( mixEnvMap ) {\ngl_FragColor = vec4( mix( mColor.rgb * mapColor.rgb * vLightWeighting, cubeColor.rgb, mReflectivity ), mColor.a * mapColor.a );\n} else {\ngl_FragColor = vec4( mColor.rgb * mapColor.rgb * cubeColor.rgb * vLightWeighting, mColor.a * mapColor.a );\n}\n} else {\nif ( mixEnvMap ) {\ngl_FragColor = mix( mColor * mapColor, cubeColor, mReflectivity );\n} else {\ngl_FragColor = mColor * mapColor * cubeColor;\n}\n}\n}"].join("\n")));
b.attachShader(d,c("vertex",[f?"#define MAX_DIR_LIGHTS "+f:"",h?"#define MAX_POINT_LIGHTS "+h:"","attribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nuniform vec3 cameraPosition;\nuniform bool enableLighting;\nuniform bool useRefract;\nuniform int pointLightNumber;\nuniform int directionalLightNumber;\nuniform vec3 ambientLightColor;",f?"uniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];":"",f?"uniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];":"",h?"uniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];":
"",h?"uniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];":"","uniform mat4 objMatrix;\nuniform mat4 viewMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat3 normalMatrix;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vLightWeighting;",h?"varying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];":"","varying vec3 vViewPosition;\nvarying vec3 vReflect;\nuniform float mRefractionRatio;\nvoid main(void) {\nvec4 mPosition = objMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 nWorld = mat3( objMatrix[0].xyz, objMatrix[1].xyz, objMatrix[2].xyz ) * normal;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec3 transformedNormal = normalize( normalMatrix * normal );\nif ( !enableLighting ) {\nvLightWeighting = vec3( 1.0, 1.0, 1.0 );\n} else {\nvLightWeighting = ambientLightColor;",
f?"for( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {":"",f?"vec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );":"",f?"float directionalLightWeighting = max( dot( transformedNormal, normalize(lDirection.xyz ) ), 0.0 );":"",f?"vLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;":"",f?"}":"",h?"for( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {":"",h?"vec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );":"",h?"vPointLightVector[ i ] = normalize( lPosition.xyz - mvPosition.xyz );":
"",h?"float pointLightWeighting = max( dot( transformedNormal, vPointLightVector[ i ] ), 0.0 );":"",h?"vLightWeighting += pointLightColor[ i ] * pointLightWeighting;":"",h?"}":"","}\nvNormal = transformedNormal;\nvUv = uv;\nif ( useRefract ) {\nvReflect = refract( normalize(mPosition.xyz - cameraPosition), normalize(nWorld.xyz), mRefractionRatio );\n} else {\nvReflect = reflect( normalize(mPosition.xyz - cameraPosition), normalize(nWorld.xyz) );\n}\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")));
b.linkProgram(d);if(!b.getProgramParameter(d,b.LINK_STATUS)){alert("Could not initialise shaders");alert("VALIDATE_STATUS: "+b.getProgramParameter(d,b.VALIDATE_STATUS));alert(b.getError())}b.useProgram(d);d.viewMatrix=b.getUniformLocation(d,"viewMatrix");d.modelViewMatrix=b.getUniformLocation(d,"modelViewMatrix");d.projectionMatrix=b.getUniformLocation(d,"projectionMatrix");d.normalMatrix=b.getUniformLocation(d,"normalMatrix");d.objMatrix=b.getUniformLocation(d,"objMatrix");d.cameraPosition=b.getUniformLocation(d,
"cameraPosition");d.enableLighting=b.getUniformLocation(d,"enableLighting");d.ambientLightColor=b.getUniformLocation(d,"ambientLightColor");if(f){d.directionalLightNumber=b.getUniformLocation(d,"directionalLightNumber");d.directionalLightColor=b.getUniformLocation(d,"directionalLightColor");d.directionalLightDirection=b.getUniformLocation(d,"directionalLightDirection")}if(h){d.pointLightNumber=b.getUniformLocation(d,"pointLightNumber");d.pointLightColor=b.getUniformLocation(d,"pointLightColor");d.pointLightPosition=
b.getUniformLocation(d,"pointLightPosition")}d.material=b.getUniformLocation(d,"material");d.mColor=b.getUniformLocation(d,"mColor");d.mOpacity=b.getUniformLocation(d,"mOpacity");d.mReflectivity=b.getUniformLocation(d,"mReflectivity");d.mAmbient=b.getUniformLocation(d,"mAmbient");d.mSpecular=b.getUniformLocation(d,"mSpecular");d.mShininess=b.getUniformLocation(d,"mShininess");d.enableMap=b.getUniformLocation(d,"enableMap");b.uniform1i(d.enableMap,0);d.tMap=b.getUniformLocation(d,"tMap");b.uniform1i(d.tMap,
0);d.enableCubeMap=b.getUniformLocation(d,"enableCubeMap");b.uniform1i(d.enableCubeMap,0);d.tCube=b.getUniformLocation(d,"tCube");b.uniform1i(d.tCube,1);d.mixEnvMap=b.getUniformLocation(d,"mixEnvMap");b.uniform1i(d.mixEnvMap,0);d.mRefractionRatio=b.getUniformLocation(d,"mRefractionRatio");d.useRefract=b.getUniformLocation(d,"useRefract");b.uniform1i(d.useRefract,0);d.m2Near=b.getUniformLocation(d,"m2Near");d.mFarPlusNear=b.getUniformLocation(d,"mFarPlusNear");d.mFarMinusNear=b.getUniformLocation(d,
"mFarMinusNear");d.position=b.getAttribLocation(d,"position");b.enableVertexAttribArray(d.position);d.normal=b.getAttribLocation(d,"normal");b.enableVertexAttribArray(d.normal);d.uv=b.getAttribLocation(d,"uv");b.enableVertexAttribArray(d.uv);d.viewMatrixArray=new Float32Array(16);d.modelViewMatrixArray=new Float32Array(16);d.projectionMatrixArray=new Float32Array(16)})(a.directional,a.point);this.setSize=function(f,h){g.width=f;g.height=h;b.viewport(0,0,g.width,g.height)};this.clear=function(){b.clear(b.COLOR_BUFFER_BIT|
b.DEPTH_BUFFER_BIT)};this.setupLights=function(f){var h,k,i,m,l=[],s=[],v=[];m=[];var j=[];b.uniform1i(d.enableLighting,f.lights.length);h=0;for(k=f.lights.length;h<k;h++){i=f.lights[h];if(i instanceof THREE.AmbientLight)l.push(i);else if(i instanceof THREE.DirectionalLight)v.push(i);else i instanceof THREE.PointLight&&s.push(i)}h=f=i=m=0;for(k=l.length;h<k;h++){f+=l[h].color.r;i+=l[h].color.g;m+=l[h].color.b}b.uniform3f(d.ambientLightColor,f,i,m);m=[];j=[];h=0;for(k=v.length;h<k;h++){i=v[h];m.push(i.color.r*
i.intensity);m.push(i.color.g*i.intensity);m.push(i.color.b*i.intensity);j.push(i.position.x);j.push(i.position.y);j.push(i.position.z)}if(v.length){b.uniform1i(d.directionalLightNumber,v.length);b.uniform3fv(d.directionalLightDirection,j);b.uniform3fv(d.directionalLightColor,m)}m=[];j=[];h=0;for(k=s.length;h<k;h++){i=s[h];m.push(i.color.r*i.intensity);m.push(i.color.g*i.intensity);m.push(i.color.b*i.intensity);j.push(i.position.x);j.push(i.position.y);j.push(i.position.z)}if(s.length){b.uniform1i(d.pointLightNumber,
s.length);b.uniform3fv(d.pointLightPosition,j);b.uniform3fv(d.pointLightColor,m)}};this.createBuffers=function(f,h){var k,i,m,l,s,v,j,L,u=[],w=[],H=[],A=[],I=[],p=0,x=f.materialFaceGroup[h],Y;m=false;k=0;for(i=f.material.length;k<i;k++){meshMaterial=f.material[k];if(meshMaterial instanceof THREE.MeshFaceMaterial){s=0;for(Y=x.material.length;s<Y;s++)if(x.material[s]&&x.material[s].shading!=undefined&&x.material[s].shading==THREE.SmoothShading){m=true;break}}else if(meshMaterial&&meshMaterial.shading!=
undefined&&meshMaterial.shading==THREE.SmoothShading){m=true;break}if(m)break}Y=m;k=0;for(i=x.faces.length;k<i;k++){m=x.faces[k];l=f.geometry.faces[m];s=l.vertexNormals;faceNormal=l.normal;m=f.geometry.uvs[m];if(l instanceof THREE.Face3){v=f.geometry.vertices[l.a].position;j=f.geometry.vertices[l.b].position;L=f.geometry.vertices[l.c].position;H.push(v.x,v.y,v.z);H.push(j.x,j.y,j.z);H.push(L.x,L.y,L.z);if(s.length==3&&Y)for(l=0;l<3;l++)A.push(s[l].x,s[l].y,s[l].z);else for(l=0;l<3;l++)A.push(faceNormal.x,
faceNormal.y,faceNormal.z);if(m)for(l=0;l<3;l++)I.push(m[l].u,m[l].v);u.push(p,p+1,p+2);w.push(p,p+1);w.push(p,p+2);w.push(p+1,p+2);p+=3}else if(l instanceof THREE.Face4){v=f.geometry.vertices[l.a].position;j=f.geometry.vertices[l.b].position;L=f.geometry.vertices[l.c].position;l=f.geometry.vertices[l.d].position;H.push(v.x,v.y,v.z);H.push(j.x,j.y,j.z);H.push(L.x,L.y,L.z);H.push(l.x,l.y,l.z);if(s.length==4&&Y)for(l=0;l<4;l++)A.push(s[l].x,s[l].y,s[l].z);else for(l=0;l<4;l++)A.push(faceNormal.x,faceNormal.y,
faceNormal.z);if(m)for(l=0;l<4;l++)I.push(m[l].u,m[l].v);u.push(p,p+1,p+2);u.push(p,p+2,p+3);w.push(p,p+1);w.push(p,p+2);w.push(p,p+3);w.push(p+1,p+2);w.push(p+2,p+3);p+=4}}if(H.length){x.__webGLVertexBuffer=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,x.__webGLVertexBuffer);b.bufferData(b.ARRAY_BUFFER,new Float32Array(H),b.STATIC_DRAW);x.__webGLNormalBuffer=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,x.__webGLNormalBuffer);b.bufferData(b.ARRAY_BUFFER,new Float32Array(A),b.STATIC_DRAW);x.__webGLUVBuffer=
b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,x.__webGLUVBuffer);b.bufferData(b.ARRAY_BUFFER,new Float32Array(I),b.STATIC_DRAW);x.__webGLFaceBuffer=b.createBuffer();b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,x.__webGLFaceBuffer);b.bufferData(b.ELEMENT_ARRAY_BUFFER,new Uint16Array(u),b.STATIC_DRAW);x.__webGLLineBuffer=b.createBuffer();b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,x.__webGLLineBuffer);b.bufferData(b.ELEMENT_ARRAY_BUFFER,new Uint16Array(w),b.STATIC_DRAW);x.__webGLFaceCount=u.length;x.__webGLLineCount=
w.length}};this.renderBuffer=function(f,h){var k,i,m,l,s,v,j,L,u,w;if(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshBasicMaterial){k=f.color;i=f.opacity;l=f.wireframe;s=f.wireframe_linewidth;j=f.map;L=f.env_map;v=f.combine==THREE.Mix;m=f.reflectivity;w=f.env_map&&f.env_map.mapping==THREE.RefractionMap;u=f.refraction_ratio;b.uniform4f(d.mColor,k.r*i,k.g*i,k.b*i,i);b.uniform1i(d.mixEnvMap,v);b.uniform1f(d.mReflectivity,m);b.uniform1i(d.useRefract,
w);b.uniform1f(d.mRefractionRatio,u)}if(f instanceof THREE.MeshNormalMaterial){i=f.opacity;b.uniform1f(d.mOpacity,i);b.uniform1i(d.material,4)}else if(f instanceof THREE.MeshDepthMaterial){i=f.opacity;l=f.wireframe;s=f.wireframe_linewidth;b.uniform1f(d.mOpacity,i);b.uniform1f(d.m2Near,f.__2near);b.uniform1f(d.mFarPlusNear,f.__farPlusNear);b.uniform1f(d.mFarMinusNear,f.__farMinusNear);b.uniform1i(d.material,3)}else if(f instanceof THREE.MeshPhongMaterial){k=f.ambient;m=f.specular;v=f.shininess;b.uniform4f(d.mAmbient,
k.r,k.g,k.b,i);b.uniform4f(d.mSpecular,m.r,m.g,m.b,i);b.uniform1f(d.mShininess,v);b.uniform1i(d.material,2)}else if(f instanceof THREE.MeshLambertMaterial)b.uniform1i(d.material,1);else if(f instanceof THREE.MeshBasicMaterial)b.uniform1i(d.material,0);else if(f instanceof THREE.MeshCubeMaterial){b.uniform1i(d.material,5);L=f.env_map}if(j){if(!f.map.__webGLTexture&&f.map.image.loaded){f.map.__webGLTexture=b.createTexture();b.bindTexture(b.TEXTURE_2D,f.map.__webGLTexture);b.texImage2D(b.TEXTURE_2D,
0,b.RGBA,b.RGBA,b.UNSIGNED_BYTE,f.map.image);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,e(f.map.wrap_s));b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,e(f.map.wrap_t));b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR_MIPMAP_LINEAR);b.generateMipmap(b.TEXTURE_2D);b.bindTexture(b.TEXTURE_2D,null)}b.activeTexture(b.TEXTURE0);b.bindTexture(b.TEXTURE_2D,f.map.__webGLTexture);b.uniform1i(d.tMap,0);b.uniform1i(d.enableMap,1)}else b.uniform1i(d.enableMap,
0);if(L){if(f.env_map&&f.env_map instanceof THREE.TextureCube&&f.env_map.image.length==6){if(!f.env_map.image.__webGLTextureCube&&!f.env_map.image.__cubeMapInitialized&&f.env_map.image.loadCount==6){f.env_map.image.__webGLTextureCube=b.createTexture();b.bindTexture(b.TEXTURE_CUBE_MAP,f.env_map.image.__webGLTextureCube);b.texParameteri(b.TEXTURE_CUBE_MAP,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_CUBE_MAP,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_CUBE_MAP,b.TEXTURE_MAG_FILTER,
b.LINEAR);b.texParameteri(b.TEXTURE_CUBE_MAP,b.TEXTURE_MIN_FILTER,b.LINEAR_MIPMAP_LINEAR);for(i=0;i<6;++i)b.texImage2D(b.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,b.RGBA,b.RGBA,b.UNSIGNED_BYTE,f.env_map.image[i]);b.generateMipmap(b.TEXTURE_CUBE_MAP);b.bindTexture(b.TEXTURE_CUBE_MAP,null);f.env_map.image.__cubeMapInitialized=true}b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_CUBE_MAP,f.env_map.image.__webGLTextureCube);b.uniform1i(d.tCube,1)}b.uniform1i(d.enableCubeMap,1)}else b.uniform1i(d.enableCubeMap,
0);b.bindBuffer(b.ARRAY_BUFFER,h.__webGLVertexBuffer);b.vertexAttribPointer(d.position,3,b.FLOAT,false,0,0);b.bindBuffer(b.ARRAY_BUFFER,h.__webGLNormalBuffer);b.vertexAttribPointer(d.normal,3,b.FLOAT,false,0,0);if(j){b.bindBuffer(b.ARRAY_BUFFER,h.__webGLUVBuffer);b.enableVertexAttribArray(d.uv);b.vertexAttribPointer(d.uv,2,b.FLOAT,false,0,0)}else b.disableVertexAttribArray(d.uv);if(l){b.lineWidth(s);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h.__webGLLineBuffer);b.drawElements(b.LINES,h.__webGLLineCount,
b.UNSIGNED_SHORT,0)}else{b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h.__webGLFaceBuffer);b.drawElements(b.TRIANGLES,h.__webGLFaceCount,b.UNSIGNED_SHORT,0)}};this.renderPass=function(f,h,k,i){var m,l,s,v,j;s=0;for(v=f.material.length;s<v;s++){m=f.material[s];if(m instanceof THREE.MeshFaceMaterial){m=0;for(l=h.material.length;m<l;m++)if((j=h.material[m])&&j.blending==k&&j.opacity<1==i){this.setBlending(j.blending);this.renderBuffer(j,h)}}else if((j=m)&&j.blending==k&&j.opacity<1==i){this.setBlending(j.blending);
this.renderBuffer(j,h)}}};this.render=function(f,h){var k,i;this.initWebGLObjects(f);this.autoClear&&this.clear();h.autoUpdateMatrix&&h.updateMatrix();b.uniform3f(d.cameraPosition,h.position.x,h.position.y,h.position.z);this.setupLights(f);k=0;for(i=f.__webGLObjects.length;k<i;k++){webGLObject=f.__webGLObjects[k];if(webGLObject.__object.visible){this.setupMatrices(webGLObject.__object,h);this.renderPass(webGLObject.__object,webGLObject,THREE.NormalBlending,false)}}k=0;for(i=f.__webGLObjects.length;k<
i;k++){webGLObject=f.__webGLObjects[k];if(webGLObject.__object.visible){this.setupMatrices(webGLObject.__object,h);this.renderPass(webGLObject.__object,webGLObject,THREE.AdditiveBlending,false);this.renderPass(webGLObject.__object,webGLObject,THREE.SubtractiveBlending,false);this.renderPass(webGLObject.__object,webGLObject,THREE.AdditiveBlending,true);this.renderPass(webGLObject.__object,webGLObject,THREE.SubtractiveBlending,true);this.renderPass(webGLObject.__object,webGLObject,THREE.NormalBlending,
true)}}};this.initWebGLObjects=function(f){var h,k,i,m,l;if(!f.__webGLObjects)f.__webGLObjects=[];h=0;for(k=f.objects.length;h<k;h++){i=f.objects[h];if(i instanceof THREE.Mesh)for(m in i.materialFaceGroup){l=i.materialFaceGroup[m];if(!l.__webGLVertexBuffer){this.createBuffers(i,m);l.__object=i;f.__webGLObjects.push(l)}}}};this.removeObject=function(f,h){var k,i;for(k=f.__webGLObjects.length-1;k>=0;k--){i=f.__webGLObjects[k].__object;h==i&&f.__webGLObjects.splice(k,1)}};this.setupMatrices=function(f,
h){f.autoUpdateMatrix&&f.updateMatrix();n.multiply(h.matrix,f.matrix);d.viewMatrixArray=new Float32Array(h.matrix.flatten());d.modelViewMatrixArray=new Float32Array(n.flatten());d.projectionMatrixArray=new Float32Array(h.projectionMatrix.flatten());q=THREE.Matrix4.makeInvert3x3(n).transpose();d.normalMatrixArray=new Float32Array(q.m);b.uniformMatrix4fv(d.viewMatrix,false,d.viewMatrixArray);b.uniformMatrix4fv(d.modelViewMatrix,false,d.modelViewMatrixArray);b.uniformMatrix4fv(d.projectionMatrix,false,
d.projectionMatrixArray);b.uniformMatrix3fv(d.normalMatrix,false,d.normalMatrixArray);b.uniformMatrix4fv(d.objMatrix,false,new Float32Array(f.matrix.flatten()))};this.setBlending=function(f){switch(f){case THREE.AdditiveBlending:b.blendEquation(b.FUNC_ADD);b.blendFunc(b.ONE,b.ONE);break;case THREE.SubtractiveBlending:b.blendFunc(b.DST_COLOR,b.ZERO);break;default:b.blendEquation(b.FUNC_ADD);b.blendFunc(b.ONE,b.ONE_MINUS_SRC_ALPHA)}};this.setFaceCulling=function(f,h){if(f){!h||h=="ccw"?b.frontFace(b.CCW):
b.frontFace(b.CW);if(f=="back")b.cullFace(b.BACK);else f=="front"?b.cullFace(b.FRONT):b.cullFace(b.FRONT_AND_BACK);b.enable(b.CULL_FACE)}else b.disable(b.CULL_FACE)}};
THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.meshMaterial=null;this.overdraw=false;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.material=null};