// ThreeWebGL.js r33 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,setRGB:function(a,b,d){this.r=a;this.g=b;this.b=d;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,d){var e,g,k,i,n,j;if(d==0)e=g=k=0;else{i=Math.floor(a*6);n=a*6-i;a=d*(1-b);j=d*(1-b*n);b=d*(1-b*(1-n));switch(i){case 1:e=j;g=d;k=a;break;case 2:e=a;g=d;k=b;break;case 3:e=a;g=j;k=d;break;case 4:e=b;g=a;k=d;break;case 5:e=d;g=a;k=j;break;case 6:case 0:e=d;g=b;k=a}}this.r=e;this.g=g;this.b=k;if(this.autoUpdate){this.updateHex();
this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,d){this.set(a||0,b||0,d||0)};
THREE.Vector3.prototype={set:function(a,b,d){this.x=a;this.y=b;this.z=d;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,d=this.y,e=this.z;this.set(d*a.z-e*a.y,e*a.x-b*a.z,b*a.y-d*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,d=this.y-a.y;a=this.z-a.z;return b*b+d*d+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,d,e){this.set(a||0,b||0,d||0,e||1)};
THREE.Vector4.prototype={set:function(a,b,d,e){this.x=a;this.y=b;this.z=d;this.w=e;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,d,e=a.objects,g=[];a=0;for(b=e.length;a<b;a++){d=e[a];d instanceof THREE.Mesh&&(g=g.concat(this.intersectObject(d)))}g.sort(function(k,i){return k.distance-i.distance});return g},intersectObject:function(a){function b(K,J,R,L){L=L.clone().subSelf(J);R=R.clone().subSelf(J);var P=K.clone().subSelf(J);K=L.dot(L);J=L.dot(R);L=L.dot(P);var c=R.dot(R);R=R.dot(P);P=1/(K*c-J*J);c=(c*L-J*R)*P;K=(K*R-J*L)*P;return c>0&&K>0&&c+K<1}var d,e,g,k,i,n,j,t,x,w,
z,A=a.geometry,E=A.vertices,H=[];d=0;for(e=A.faces.length;d<e;d++){g=A.faces[d];w=this.origin.clone();z=this.direction.clone();j=a.matrixWorld;k=j.multiplyVector3(E[g.a].position.clone());i=j.multiplyVector3(E[g.b].position.clone());n=j.multiplyVector3(E[g.c].position.clone());j=g instanceof THREE.Face4?j.multiplyVector3(E[g.d].position.clone()):null;t=a.matrixRotationWorld.multiplyVector3(g.normal.clone());x=z.dot(t);if(x<0){t=t.dot((new THREE.Vector3).sub(k,w))/x;w=w.addSelf(z.multiplyScalar(t));
if(g instanceof THREE.Face3){if(b(w,k,i,n)){g={distance:this.origin.distanceTo(w),point:w,face:g,object:a};H.push(g)}}else if(g instanceof THREE.Face4&&(b(w,k,i,j)||b(w,i,n,j))){g={distance:this.origin.distanceTo(w),point:w,face:g,object:a};H.push(g)}}}return H}};
THREE.Rectangle=function(){function a(){k=e-b;i=g-d}var b,d,e,g,k,i,n=!0;this.getX=function(){return b};this.getY=function(){return d};this.getWidth=function(){return k};this.getHeight=function(){return i};this.getLeft=function(){return b};this.getTop=function(){return d};this.getRight=function(){return e};this.getBottom=function(){return g};this.set=function(j,t,x,w){n=!1;b=j;d=t;e=x;g=w;a()};this.addPoint=function(j,t){if(n){n=!1;b=j;d=t;e=j;g=t}else{b=b<j?b:j;d=d<t?d:t;e=e>j?e:j;g=g>t?g:t}a()};
this.add3Points=function(j,t,x,w,z,A){if(n){n=!1;b=j<x?j<z?j:z:x<z?x:z;d=t<w?t<A?t:A:w<A?w:A;e=j>x?j>z?j:z:x>z?x:z;g=t>w?t>A?t:A:w>A?w:A}else{b=j<x?j<z?j<b?j:b:z<b?z:b:x<z?x<b?x:b:z<b?z:b;d=t<w?t<A?t<d?t:d:A<d?A:d:w<A?w<d?w:d:A<d?A:d;e=j>x?j>z?j>e?j:e:z>e?z:e:x>z?x>e?x:e:z>e?z:e;g=t>w?t>A?t>g?t:g:A>g?A:g:w>A?w>g?w:g:A>g?A:g}a()};this.addRectangle=function(j){if(n){n=!1;b=j.getLeft();d=j.getTop();e=j.getRight();g=j.getBottom()}else{b=b<j.getLeft()?b:j.getLeft();d=d<j.getTop()?d:j.getTop();e=e>j.getRight()?
e:j.getRight();g=g>j.getBottom()?g:j.getBottom()}a()};this.inflate=function(j){b-=j;d-=j;e+=j;g+=j;a()};this.minSelf=function(j){b=b>j.getLeft()?b:j.getLeft();d=d>j.getTop()?d:j.getTop();e=e<j.getRight()?e:j.getRight();g=g<j.getBottom()?g:j.getBottom();a()};this.instersects=function(j){return Math.min(e,j.getRight())-Math.max(b,j.getLeft())>=0&&Math.min(g,j.getBottom())-Math.max(d,j.getTop())>=0};this.empty=function(){n=!0;g=e=d=b=0;a()};this.isEmpty=function(){return n}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,d,e,g,k,i,n,j,t,x,w,z,A,E,H){this.set(a||1,b||0,d||0,e||0,g||0,k||1,i||0,n||0,j||0,t||0,x||1,w||0,z||0,A||0,E||0,H||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,d,e,g,k,i,n,j,t,x,w,z,A,E,H){this.n11=a;this.n12=b;this.n13=d;this.n14=e;this.n21=g;this.n22=k;this.n23=i;this.n24=n;this.n31=j;this.n32=t;this.n33=x;this.n34=w;this.n41=z;this.n42=A;this.n43=E;this.n44=H;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,d){var e=THREE.Matrix4.__tmpVec1,
g=THREE.Matrix4.__tmpVec2,k=THREE.Matrix4.__tmpVec3;k.sub(a,b).normalize();e.cross(d,k).normalize();g.cross(k,e).normalize();this.n11=e.x;this.n12=g.x;this.n13=k.x;this.n14=a.x;this.n21=e.y;this.n22=g.y;this.n23=k.y;this.n24=a.y;this.n31=e.z;this.n32=g.z;this.n33=k.z;this.n34=a.z;return this},multiplyVector3:function(a){var b=a.x,d=a.y,e=a.z,g=1/(this.n41*b+this.n42*d+this.n43*e+this.n44);a.x=(this.n11*b+this.n12*d+this.n13*e+this.n14)*g;a.y=(this.n21*b+this.n22*d+this.n23*e+this.n24)*g;a.z=(this.n31*
b+this.n32*d+this.n33*e+this.n34)*g;return a},multiplyVector3OnlyZ:function(a){var b=a.x,d=a.y;a=a.z;return(this.n31*b+this.n32*d+this.n33*a+this.n34)*(1/(this.n41*b+this.n42*d+this.n43*a+this.n44))},multiplyVector4:function(a){var b=a.x,d=a.y,e=a.z,g=a.w;a.x=this.n11*b+this.n12*d+this.n13*e+this.n14*g;a.y=this.n21*b+this.n22*d+this.n23*e+this.n24*g;a.z=this.n31*b+this.n32*d+this.n33*e+this.n34*g;a.w=this.n41*b+this.n42*d+this.n43*e+this.n44*g;return a},crossVector:function(a){var b=new THREE.Vector4;
b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var d=a.n11,e=a.n12,g=a.n13,k=a.n14,i=a.n21,n=a.n22,j=a.n23,t=a.n24,x=a.n31,w=a.n32,z=a.n33,A=a.n34,E=a.n41,H=a.n42,K=a.n43,J=a.n44,R=b.n11,L=b.n12,P=b.n13,c=b.n14,aa=b.n21,ba=b.n22,ca=b.n23,ga=b.n24,da=b.n31,ja=b.n32,na=b.n33,$=b.n34;this.n11=
d*R+e*aa+g*da;this.n12=d*L+e*ba+g*ja;this.n13=d*P+e*ca+g*na;this.n14=d*c+e*ga+g*$+k;this.n21=i*R+n*aa+j*da;this.n22=i*L+n*ba+j*ja;this.n23=i*P+n*ca+j*na;this.n24=i*c+n*ga+j*$+t;this.n31=x*R+w*aa+z*da;this.n32=x*L+w*ba+z*ja;this.n33=x*P+w*ca+z*na;this.n34=x*c+w*ga+z*$+A;this.n41=E*R+H*aa+K*da;this.n42=E*L+H*ba+K*ja;this.n43=E*P+H*ca+K*na;this.n44=E*c+H*ga+K*$+J;return this},multiplyToArray:function(a,b,d){var e=a.n11,g=a.n12,k=a.n13,i=a.n14,n=a.n21,j=a.n22,t=a.n23,x=a.n24,w=a.n31,z=a.n32,A=a.n33,E=
a.n34,H=a.n41,K=a.n42,J=a.n43;a=a.n44;var R=b.n11,L=b.n12,P=b.n13,c=b.n14,aa=b.n21,ba=b.n22,ca=b.n23,ga=b.n24,da=b.n31,ja=b.n32,na=b.n33,$=b.n34,qa=b.n41,wa=b.n42,ua=b.n43;b=b.n44;this.n11=e*R+g*aa+k*da+i*qa;this.n12=e*L+g*ba+k*ja+i*wa;this.n13=e*P+g*ca+k*na+i*ua;this.n14=e*c+g*ga+k*$+i*b;this.n21=n*R+j*aa+t*da+x*qa;this.n22=n*L+j*ba+t*ja+x*wa;this.n23=n*P+j*ca+t*na+x*ua;this.n24=n*c+j*ga+t*$+x*b;this.n31=w*R+z*aa+A*da+E*qa;this.n32=w*L+z*ba+A*ja+E*wa;this.n33=w*P+z*ca+A*na+E*ua;this.n34=w*c+z*ga+
A*$+E*b;this.n41=H*R+K*aa+J*da+a*qa;this.n42=H*L+K*ba+J*ja+a*wa;this.n43=H*P+K*ca+J*na+a*ua;this.n44=H*c+K*ga+J*$+a*b;d[0]=this.n11;d[1]=this.n21;d[2]=this.n31;d[3]=this.n41;d[4]=this.n12;d[5]=this.n22;d[6]=this.n32;d[7]=this.n42;d[8]=this.n13;d[9]=this.n23;d[10]=this.n33;d[11]=this.n43;d[12]=this.n14;d[13]=this.n24;d[14]=this.n34;d[15]=this.n44;return this},multiplySelf:function(a){var b=this.n11,d=this.n12,e=this.n13,g=this.n14,k=this.n21,i=this.n22,n=this.n23,j=this.n24,t=this.n31,x=this.n32,w=
this.n33,z=this.n34,A=this.n41,E=this.n42,H=this.n43,K=this.n44,J=a.n11,R=a.n21,L=a.n31,P=a.n12,c=a.n22,aa=a.n32,ba=a.n13,ca=a.n23,ga=a.n33,da=a.n14,ja=a.n24;a=a.n34;this.n11=b*J+d*R+e*L;this.n12=b*P+d*c+e*aa;this.n13=b*ba+d*ca+e*ga;this.n14=b*da+d*ja+e*a+g;this.n21=k*J+i*R+n*L;this.n22=k*P+i*c+n*aa;this.n23=k*ba+i*ca+n*ga;this.n24=k*da+i*ja+n*a+j;this.n31=t*J+x*R+w*L;this.n32=t*P+x*c+w*aa;this.n33=t*ba+x*ca+w*ga;this.n34=t*da+x*ja+w*a+z;this.n41=A*J+E*R+H*L;this.n42=A*P+E*c+H*aa;this.n43=A*ba+E*
ca+H*ga;this.n44=A*da+E*ja+H*a+K;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,d=this.n13,e=this.n14,g=this.n21,k=this.n22,i=this.n23,n=this.n24,j=this.n31,t=this.n32,x=this.n33,w=this.n34,z=this.n41,A=this.n42,E=this.n43,H=this.n44;return e*i*t*z-d*n*t*
z-e*k*x*z+b*n*x*z+d*k*w*z-b*i*w*z-e*i*j*A+d*n*j*A+e*g*x*A-a*n*x*A-d*g*w*A+a*i*w*A+e*k*j*E-b*n*j*E-e*g*t*E+a*n*t*E+b*g*w*E-a*k*w*E-d*k*j*H+b*i*j*H+d*g*t*H-a*i*t*H-b*g*x*H+a*k*x*H},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=
this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flattenToArray(this.flat);return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;
a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,d){this.set(1,0,0,a,0,1,0,b,0,0,1,d,0,0,0,1);return this},setScale:function(a,b,d){this.set(a,0,0,
0,0,b,0,0,0,0,d,0,0,0,0,1);return this},setRotX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotAxis:function(a,b){var d=Math.cos(b),e=Math.sin(b),g=1-d,k=a.x,i=a.y,n=a.z,j=g*k,t=g*i;this.set(j*k+d,j*i-e*n,j*n+e*i,0,j*i+e*n,t*i+
d,t*n-e*k,0,j*n-e*i,t*n+e*k,g*n*n+d,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},setRotationFromEuler:function(a){var b=a.x,d=a.y,e=a.z;a=Math.cos(b);b=Math.sin(b);var g=Math.cos(d);d=Math.sin(d);var k=Math.cos(e);e=Math.sin(e);var i=a*d,n=b*d;this.n11=g*k;this.n12=-g*e;this.n13=d;this.n21=n*k+a*e;this.n22=-n*e+a*k;this.n23=-b*g;this.n31=-i*k+b*e;this.n32=i*e+b*k;this.n33=a*g},setRotationFromQuaternion:function(a){var b=a.x,d=a.y,e=a.z,g=a.w,
k=b+b,i=d+d,n=e+e;a=b*k;var j=b*i;b*=n;var t=d*i;d*=n;e*=n;k*=g;i*=g;g*=n;this.n11=1-(t+e);this.n12=j-g;this.n13=b+i;this.n21=j+g;this.n22=1-(a+e);this.n23=d-k;this.n31=b-i;this.n32=d+k;this.n33=1-(a+t)},scale:function(a){var b=a.x,d=a.y;a=a.z;this.n11*=b;this.n12*=d;this.n13*=a;this.n21*=b;this.n22*=d;this.n23*=a;this.n31*=b;this.n32*=d;this.n33*=a;this.n41*=b;this.n42*=d;this.n43*=a;return this}};THREE.Matrix4.translationMatrix=function(a,b,d){var e=new THREE.Matrix4;e.setTranslation(a,b,d);return e};
THREE.Matrix4.scaleMatrix=function(a,b,d){var e=new THREE.Matrix4;e.setScale(a,b,d);return e};THREE.Matrix4.rotationXMatrix=function(a){var b=new THREE.Matrix4;b.setRotX(a);return b};THREE.Matrix4.rotationYMatrix=function(a){var b=new THREE.Matrix4;b.setRotY(a);return b};THREE.Matrix4.rotationZMatrix=function(a){var b=new THREE.Matrix4;b.setRotZ(a);return b};THREE.Matrix4.rotationAxisAngleMatrix=function(a,b){var d=new THREE.Matrix4;d.setRotAxis(a,b);return d};
THREE.Matrix4.makeInvert=function(a,b){var d=a.n11,e=a.n12,g=a.n13,k=a.n14,i=a.n21,n=a.n22,j=a.n23,t=a.n24,x=a.n31,w=a.n32,z=a.n33,A=a.n34,E=a.n41,H=a.n42,K=a.n43,J=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=j*A*H-t*z*H+t*w*K-n*A*K-j*w*J+n*z*J;b.n12=k*z*H-g*A*H-k*w*K+e*A*K+g*w*J-e*z*J;b.n13=g*t*H-k*j*H+k*n*K-e*t*K-g*n*J+e*j*J;b.n14=k*j*w-g*t*w-k*n*z+e*t*z+g*n*A-e*j*A;b.n21=t*z*E-j*A*E-t*x*K+i*A*K+j*x*J-i*z*J;b.n22=g*A*E-k*z*E+k*x*K-d*A*K-g*x*J+d*z*J;b.n23=k*j*E-g*t*E-k*i*K+d*t*K+g*i*J-d*j*J;
b.n24=g*t*x-k*j*x+k*i*z-d*t*z-g*i*A+d*j*A;b.n31=n*A*E-t*w*E+t*x*H-i*A*H-n*x*J+i*w*J;b.n32=k*w*E-e*A*E-k*x*H+d*A*H+e*x*J-d*w*J;b.n33=g*t*E-k*n*E+k*i*H-d*t*H-e*i*J+d*n*J;b.n34=k*n*x-e*t*x-k*i*w+d*t*w+e*i*A-d*n*A;b.n41=j*w*E-n*z*E-j*x*H+i*z*H+n*x*K-i*w*K;b.n42=e*z*E-g*w*E+g*x*H-d*z*H-e*x*K+d*w*K;b.n43=g*n*E-e*j*E-g*i*H+d*j*H+e*i*K-d*n*K;b.n44=e*j*x-g*n*x+g*i*w-d*j*w-e*i*z+d*n*z;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,d=b.m,e=a.n33*a.n22-a.n32*a.n23,g=-a.n33*a.n21+a.n31*a.n23,k=a.n32*a.n21-a.n31*a.n22,i=-a.n33*a.n12+a.n32*a.n13,n=a.n33*a.n11-a.n31*a.n13,j=-a.n32*a.n11+a.n31*a.n12,t=a.n23*a.n12-a.n22*a.n13,x=-a.n23*a.n11+a.n21*a.n13,w=a.n22*a.n11-a.n21*a.n12;a=a.n11*e+a.n21*i+a.n31*t;if(a==0)throw"matrix not invertible";a=1/a;d[0]=a*e;d[1]=a*g;d[2]=a*k;d[3]=a*i;d[4]=a*n;d[5]=a*j;d[6]=a*t;d[7]=a*x;d[8]=a*w;return b};
THREE.Matrix4.makeFrustum=function(a,b,d,e,g,k){var i;i=new THREE.Matrix4;i.n11=2*g/(b-a);i.n12=0;i.n13=(b+a)/(b-a);i.n14=0;i.n21=0;i.n22=2*g/(e-d);i.n23=(e+d)/(e-d);i.n24=0;i.n31=0;i.n32=0;i.n33=-(k+g)/(k-g);i.n34=-2*k*g/(k-g);i.n41=0;i.n42=0;i.n43=-1;i.n44=0;return i};THREE.Matrix4.makePerspective=function(a,b,d,e){var g;a=d*Math.tan(a*Math.PI/360);g=-a;return THREE.Matrix4.makeFrustum(g*b,a*b,g,a,d,e)};
THREE.Matrix4.makeOrtho=function(a,b,d,e,g,k){var i,n,j,t;i=new THREE.Matrix4;n=b-a;j=d-e;t=k-g;i.n11=2/n;i.n12=0;i.n13=0;i.n14=-((b+a)/n);i.n21=0;i.n22=2/j;i.n23=0;i.n24=-((d+e)/j);i.n31=0;i.n32=0;i.n33=-2/t;i.n34=-((k+g)/t);i.n41=0;i.n42=0;i.n43=0;i.n44=1;return i};THREE.Matrix4.__tmpVec1=new THREE.Vector3;THREE.Matrix4.__tmpVec2=new THREE.Vector3;THREE.Matrix4.__tmpVec3=new THREE.Vector3;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.parent=undefined;this.children=[];this.position=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixNeedsUpdate=!0;this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;
this.visible=!0};
THREE.Object3D.prototype={addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b instanceof THREE.Scene===!1&&b!==undefined;)b=b.parent;b!==undefined&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);
if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}return!0},update:function(a,b,d){if(this.visible){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);b=1/this.scale.x;a=1/this.scale.y;var e=1/this.scale.z;this.matrixRotationWorld.n11=this.matrixWorld.n11*b;this.matrixRotationWorld.n21=
this.matrixWorld.n21*b;this.matrixRotationWorld.n31=this.matrixWorld.n31*b;this.matrixRotationWorld.n12=this.matrixWorld.n12*a;this.matrixRotationWorld.n22=this.matrixWorld.n22*a;this.matrixRotationWorld.n32=this.matrixWorld.n32*a;this.matrixRotationWorld.n13=this.matrixWorld.n13*e;this.matrixRotationWorld.n23=this.matrixWorld.n23*e;this.matrixRotationWorld.n33=this.matrixWorld.n33*e;this.matrixNeedsUpdate=!1;b=!0}a=0;for(e=this.children.length;a<e;a++)this.children[a].update(this.matrixWorld,b,d)}}};
THREE.Object3DCounter={value:0};THREE.Quaternion=function(a,b,d,e){this.set(a||0,b||0,d||0,e!==undefined?e:1)};
THREE.Quaternion.prototype={set:function(a,b,d,e){this.x=a;this.y=b;this.z=d;this.w=e;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,d=a.x*b,e=a.y*b,g=a.z*b;a=Math.cos(e);e=Math.sin(e);b=Math.cos(-g);g=Math.sin(-g);var k=Math.cos(d);d=Math.sin(d);var i=a*b,n=e*g;this.w=i*k-n*d;this.x=i*d+n*k;this.y=e*b*k+a*g*d;this.z=a*g*k-e*b*d;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var b=this.x,d=this.y,e=this.z,g=this.w,k=a.x,i=a.y,n=a.z;a=a.w;this.x=b*a+g*k+d*n-e*i;this.y=d*a+g*i+e*k-b*n;this.z=e*a+g*n+b*i-d*k;this.w=g*a-b*k-d*i-e*n;return this},
multiplyVector3:function(a,b){b||(b=a);var d=a.x,e=a.y,g=a.z,k=this.x,i=this.y,n=this.z,j=this.w,t=j*d+i*g-n*e,x=j*e+n*d-k*g,w=j*g+k*e-i*d;d=-k*d-i*e-n*g;b.x=t*j+d*-k+x*-n-w*-i;b.y=x*j+d*-i+w*-k-t*-n;b.z=w*j+d*-n+t*-i-x*-k;return b}};
THREE.Quaternion.slerp=function(a,b,d,e){var g=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(g)>=1){d.w=a.w;d.x=a.x;d.y=a.y;d.z=a.z;return d}var k=Math.acos(g),i=Math.sqrt(1-g*g);if(Math.abs(i)<0.001){d.w=0.5*(a.w+b.w);d.x=0.5*(a.x+b.x);d.y=0.5*(a.y+b.y);d.z=0.5*(a.z+b.z);return d}g=Math.sin((1-e)*k)/i;e=Math.sin(e*k)/i;d.w=a.w*g+b.w*e;d.x=a.x*g+b.x*e;d.y=a.y*g+b.y*e;d.z=a.z*g+b.z*e;return d};
THREE.Vertex=function(a,b){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=b||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=!0};
THREE.Face3=function(a,b,d,e,g){this.a=a;this.b=b;this.c=d;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=g instanceof Array?g:[g]};THREE.Face4=function(a,b,d,e,g,k){this.a=a;this.b=b;this.c=d;this.d=e;this.centroid=new THREE.Vector3;this.normal=g instanceof THREE.Vector3?g:new THREE.Vector3;this.vertexNormals=g instanceof Array?g:[];this.materials=k instanceof Array?k:[k]};
THREE.UV=function(a,b){this.set(a||0,b||0)};THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.faces=[];this.uvs=[];this.uvs2=[];this.colors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,d;a=0;for(b=this.faces.length;a<b;a++){d=this.faces[a];d.centroid.set(0,0,0);if(d instanceof THREE.Face3){d.centroid.addSelf(this.vertices[d.a].position);d.centroid.addSelf(this.vertices[d.b].position);d.centroid.addSelf(this.vertices[d.c].position);d.centroid.divideScalar(3)}else if(d instanceof THREE.Face4){d.centroid.addSelf(this.vertices[d.a].position);d.centroid.addSelf(this.vertices[d.b].position);d.centroid.addSelf(this.vertices[d.c].position);
d.centroid.addSelf(this.vertices[d.d].position);d.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,d,e,g,k,i,n=new THREE.Vector3,j=new THREE.Vector3;e=0;for(g=this.vertices.length;e<g;e++){k=this.vertices[e];k.normal.set(0,0,0)}e=0;for(g=this.faces.length;e<g;e++){k=this.faces[e];if(a&&k.vertexNormals.length){n.set(0,0,0);b=0;for(d=k.normal.length;b<d;b++)n.addSelf(k.vertexNormals[b]);n.divideScalar(3)}else{b=this.vertices[k.a];d=this.vertices[k.b];i=this.vertices[k.c];n.sub(i.position,
d.position);j.sub(b.position,d.position);n.crossSelf(j)}n.isZero()||n.normalize();k.normal.copy(n)}},computeVertexNormals:function(){var a,b,d,e;if(this.__tmpVertices==undefined){e=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)e[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){d=this.faces[a];if(d instanceof THREE.Face3)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(d instanceof THREE.Face4)d.vertexNormals=[new THREE.Vector3,
new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{e=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)e[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){d=this.faces[a];if(d instanceof THREE.Face3){e[d.a].addSelf(d.normal);e[d.b].addSelf(d.normal);e[d.c].addSelf(d.normal)}else if(d instanceof THREE.Face4){e[d.a].addSelf(d.normal);e[d.b].addSelf(d.normal);e[d.c].addSelf(d.normal);e[d.d].addSelf(d.normal)}}a=0;for(b=this.vertices.length;a<b;a++)e[a].normalize();a=0;for(b=this.faces.length;a<
b;a++){d=this.faces[a];if(d instanceof THREE.Face3){d.vertexNormals[0].copy(e[d.a]);d.vertexNormals[1].copy(e[d.b]);d.vertexNormals[2].copy(e[d.c])}else if(d instanceof THREE.Face4){d.vertexNormals[0].copy(e[d.a]);d.vertexNormals[1].copy(e[d.b]);d.vertexNormals[2].copy(e[d.c]);d.vertexNormals[3].copy(e[d.d])}}},computeTangents:function(){function a($,qa,wa,ua,Aa,Ha,Ia){k=$.vertices[qa].position;i=$.vertices[wa].position;n=$.vertices[ua].position;j=g[Aa];t=g[Ha];x=g[Ia];w=i.x-k.x;z=n.x-k.x;A=i.y-k.y;
E=n.y-k.y;H=i.z-k.z;K=n.z-k.z;J=t.u-j.u;R=x.u-j.u;L=t.v-j.v;P=x.v-j.v;c=1/(J*P-R*L);ca.set((P*w-L*z)*c,(P*A-L*E)*c,(P*H-L*K)*c);ga.set((J*z-R*w)*c,(J*E-R*A)*c,(J*K-R*H)*c);aa[qa].addSelf(ca);aa[wa].addSelf(ca);aa[ua].addSelf(ca);ba[qa].addSelf(ga);ba[wa].addSelf(ga);ba[ua].addSelf(ga)}var b,d,e,g,k,i,n,j,t,x,w,z,A,E,H,K,J,R,L,P,c,aa=[],ba=[],ca=new THREE.Vector3,ga=new THREE.Vector3,da=new THREE.Vector3,ja=new THREE.Vector3,na=new THREE.Vector3;b=0;for(d=this.vertices.length;b<d;b++){aa[b]=new THREE.Vector3;
ba[b]=new THREE.Vector3}b=0;for(d=this.faces.length;b<d;b++){e=this.faces[b];g=this.uvs[b];if(e instanceof THREE.Face3){a(this,e.a,e.b,e.c,0,1,2);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);this.vertices[e.c].normal.copy(e.vertexNormals[2])}else if(e instanceof THREE.Face4){a(this,e.a,e.b,e.c,0,1,2);a(this,e.a,e.b,e.d,0,1,3);this.vertices[e.a].normal.copy(e.vertexNormals[0]);this.vertices[e.b].normal.copy(e.vertexNormals[1]);this.vertices[e.c].normal.copy(e.vertexNormals[2]);
this.vertices[e.d].normal.copy(e.vertexNormals[3])}}b=0;for(d=this.vertices.length;b<d;b++){na.copy(this.vertices[b].normal);e=aa[b];da.copy(e);da.subSelf(na.multiplyScalar(na.dot(e))).normalize();ja.cross(this.vertices[b].normal,e);e=ja.dot(ba[b]);e=e<0?-1:1;this.vertices[b].tangent.set(da.x,da.y,da.z,e)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],
z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,d=this.vertices.length;b<d;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>
this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,d=this.vertices.length;b<d;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(x){var w=[];b=0;for(d=x.length;b<d;b++)x[b]==undefined?w.push("undefined"):w.push(x[b].id);return w.join("_")}var b,d,e,g,k,i,n,j,t={};e=0;for(g=this.faces.length;e<g;e++){k=this.faces[e];
i=k.materials;n=a(i);t[n]==undefined&&(t[n]={hash:n,counter:0});j=t[n].hash+"_"+t[n].counter;this.geometryChunks[j]==undefined&&(this.geometryChunks[j]={faces:[],materials:i,vertices:0});k=k instanceof THREE.Face3?3:4;if(this.geometryChunks[j].vertices+k>65535){t[n].counter+=1;j=t[n].hash+"_"+t[n].counter;this.geometryChunks[j]==undefined&&(this.geometryChunks[j]={faces:[],materials:i,vertices:0})}this.geometryChunks[j].faces.push(e);this.geometryChunks[j].vertices+=k}}};THREE.GeometryIdCounter=0;
THREE.Camera=function(a,b,d,e,g){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=d||0.1;this.far=e||2E3;this.target=g||new THREE.Object3D;this.useTarget=!0;this.up=new THREE.Vector3(0,1,0);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.tmpVec=new THREE.Vector3;this.translateX=function(k,i){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(k);this.tmpVec.crossSelf(this.up);if(i)this.tmpVec.y=0;this.position.addSelf(this.tmpVec);
this.target.position.addSelf(this.tmpVec)};this.translateZ=function(k,i){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(k);if(i)this.tmpVec.y=0;this.position.subSelf(this.tmpVec);this.target.position.subSelf(this.tmpVec)};this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,d){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,
this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,d)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.FlatShading=0;THREE.SmoothShading=1;
THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.BillboardBlending=3;THREE.ReverseSubtractiveBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==
undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==
undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.vertexShader=this.fragmentShader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.fragmentShader!==undefined)this.fragmentShader=a.fragmentShader;if(a.vertexShader!==undefined)this.vertexShader=
a.vertexShader;if(a.uniforms!==undefined)this.uniforms=a.uniforms;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==
undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==
undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};THREE.ParticleCircleMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.Texture=function(a,b,d,e,g,k){this.image=a;this.mapping=b!==undefined?b:new THREE.UVMapping;this.wrapS=d!==undefined?d:THREE.ClampToEdgeWrapping;this.wrapT=e!==undefined?e:THREE.ClampToEdgeWrapping;this.magFilter=g!==undefined?g:THREE.LinearFilter;this.minFilter=k!==undefined?k:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};
THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;
THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;
THREE.RenderTarget=function(a,b,d){this.width=a;this.height=b;d=d||{};this.wrapS=d.wrapS!==undefined?d.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=d.wrapT!==undefined?d.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=d.magFilter!==undefined?d.magFilter:THREE.LinearFilter;this.minFilter=d.minFilter!==undefined?d.minFilter:THREE.LinearMipMapLinearFilter;this.format=d.format!==undefined?d.format:THREE.RGBFormat;this.type=d.type!==undefined?d.type:THREE.UnsignedByteType};
var Uniforms={clone:function(a){var b,d,e,g={};for(b in a){g[b]={};for(d in a[b]){e=a[b][d];g[b][d]=e instanceof THREE.Color||e instanceof THREE.Vector3||e instanceof THREE.Texture?e.clone():e}}return g},merge:function(a){var b,d,e,g={};for(b=0;b<a.length;b++){e=this.clone(a[b]);for(d in e)g[d]=e[d]}return g}};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(a,b,d){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=d!=undefined?d:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;
THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,d){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var e,g=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(e=0;e<g;e++){a=this.children[e];a instanceof THREE.Bone?a.update(this.skinMatrix,b,d):a.update(this.matrixWorld,!0,d)}}else for(e=0;e<g;e++)this.children[e].update(this.skinMatrix,
b,d)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.Sound=function(a,b,d,e){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,d!==undefined?d:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=e!==undefined?e:!0;this.sources=a instanceof Array?a:[a];var g;d=this.sources.length;for(a=0;a<d;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)g=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)g="audio/ogg";else b.indexOf(".wav")!==-1&&(g="audio/wav");if(this.domElement.canPlayType(g)){g=document.createElement("source");g.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(g);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,d){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var e=this.children.length;for(a=0;a<e;a++)this.children[a].update(this.matrixWorld,b,d)};THREE.Scene=function(){THREE.Object3D.call(this);this.objects=[];this.lights=[];this.sounds=[];this.fog=null;this.matrixAutoUpdate=!1};
THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else a instanceof THREE.Camera||a instanceof THREE.Bone||this.objects.indexOf(a)===-1&&this.objects.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};
THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);b!==-1&&this.objects.splice(b,1)}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(a,b,d){this.color=new THREE.Color(a);this.near=b||1;this.far=d||1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=b||2.5E-4};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,d){d&&a.update(undefined,!1,b);d=a.sounds;var e,g=d.length;for(e=0;e<g;e++){a=d[e];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.WebGLRenderer=function(a){function b(f,o,m){var h,l,v,r=f.vertices,q=r.length,s=f.colors,G=s.length,F=f.__vertexArray,I=f.__colorArray,S=f.__sortArray,y=f.__dirtyVertices,M=f.__dirtyColors;if(m.sortParticles){qa.multiplySelf(m.matrixWorld);for(h=0;h<q;h++){l=r[h].position;Aa.copy(l);qa.multiplyVector3(Aa);S[h]=[Aa.z,h]}S.sort(function(ea,Z){return Z[0]-ea[0]});for(h=0;h<q;h++){l=r[S[h][1]].position;v=h*3;F[v]=l.x;F[v+1]=l.y;F[v+2]=l.z}for(h=0;h<G;h++){v=h*3;color=s[S[h][1]];I[v]=color.r;I[v+
1]=color.g;I[v+2]=color.b}}else{if(y)for(h=0;h<q;h++){l=r[h].position;v=h*3;F[v]=l.x;F[v+1]=l.y;F[v+2]=l.z}if(M)for(h=0;h<G;h++){color=s[h];v=h*3;I[v]=color.r;I[v+1]=color.g;I[v+2]=color.b}}if(y||m.sortParticles){c.bindBuffer(c.ARRAY_BUFFER,f.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,F,o)}if(M||m.sortParticles){c.bindBuffer(c.ARRAY_BUFFER,f.__webGLColorBuffer);c.bufferData(c.ARRAY_BUFFER,I,o)}}function d(f,o){f.fragmentShader=o.fragmentShader;f.vertexShader=o.vertexShader;f.uniforms=Uniforms.clone(o.uniforms)}
function e(f,o,m,h,l){h.program||ca.initMaterial(h,o,m);var v=h.program,r=v.uniforms,q=h.uniforms;if(v!=aa){c.useProgram(v);aa=v;c.uniformMatrix4fv(r.projectionMatrix,!1,wa)}if(m&&(h instanceof THREE.MeshBasicMaterial||h instanceof THREE.MeshLambertMaterial||h instanceof THREE.MeshPhongMaterial||h instanceof THREE.LineBasicMaterial||h instanceof THREE.ParticleBasicMaterial)){q.fogColor.value.setHex(m.color.hex);if(m instanceof THREE.Fog){q.fogNear.value=m.near;q.fogFar.value=m.far}else if(m instanceof
THREE.FogExp2)q.fogDensity.value=m.density}if(h instanceof THREE.MeshPhongMaterial||h instanceof THREE.MeshLambertMaterial){var s,G,F=0,I=0,S=0,y,M,ea,Z=ca.lights,Q=Z.directional.colors,O=Z.directional.positions,N=Z.point.colors,ra=Z.point.positions,u=0,ma=0;m=G=G=0;for(s=o.length;m<s;m++){G=o[m];y=G.color;M=G.position;ea=G.intensity;if(G instanceof THREE.AmbientLight){F+=y.r;I+=y.g;S+=y.b}else if(G instanceof THREE.DirectionalLight){G=u*3;Q[G]=y.r*ea;Q[G+1]=y.g*ea;Q[G+2]=y.b*ea;O[G]=M.x;O[G+1]=M.y;
O[G+2]=M.z;u+=1}else if(G instanceof THREE.PointLight){G=ma*3;N[G]=y.r*ea;N[G+1]=y.g*ea;N[G+2]=y.b*ea;ra[G]=M.x;ra[G+1]=M.y;ra[G+2]=M.z;ma+=1}}for(m=u*3;m<Q.length;m++)Q[m]=0;for(m=ma*3;m<N.length;m++)N[m]=0;Z.point.length=ma;Z.directional.length=u;Z.ambient[0]=F;Z.ambient[1]=I;Z.ambient[2]=S;o=ca.lights;q.enableLighting.value=o.directional.length+o.point.length;q.ambientLightColor.value=o.ambient;q.directionalLightColor.value=o.directional.colors;q.directionalLightDirection.value=o.directional.positions;
q.pointLightColor.value=o.point.colors;q.pointLightPosition.value=o.point.positions}if(h instanceof THREE.MeshBasicMaterial||h instanceof THREE.MeshLambertMaterial||h instanceof THREE.MeshPhongMaterial){q.diffuse.value.setRGB(h.color.r*h.opacity,h.color.g*h.opacity,h.color.b*h.opacity);q.opacity.value=h.opacity;q.map.texture=h.map;q.lightMap.texture=h.lightMap;q.envMap.texture=h.envMap;q.reflectivity.value=h.reflectivity;q.refractionRatio.value=h.refractionRatio;q.combine.value=h.combine;q.useRefract.value=
h.envMap&&h.envMap.mapping instanceof THREE.CubeRefractionMapping}if(h instanceof THREE.LineBasicMaterial){q.diffuse.value.setRGB(h.color.r*h.opacity,h.color.g*h.opacity,h.color.b*h.opacity);q.opacity.value=h.opacity}else if(h instanceof THREE.ParticleBasicMaterial){q.psColor.value.setRGB(h.color.r*h.opacity,h.color.g*h.opacity,h.color.b*h.opacity);q.opacity.value=h.opacity;q.size.value=h.size;q.map.texture=h.map}else if(h instanceof THREE.MeshPhongMaterial){q.ambient.value.setRGB(h.ambient.r,h.ambient.g,
h.ambient.b);q.specular.value.setRGB(h.specular.r,h.specular.g,h.specular.b);q.shininess.value=h.shininess}else if(h instanceof THREE.MeshDepthMaterial){q.mNear.value=f.near;q.mFar.value=f.far;q.opacity.value=h.opacity}else if(h instanceof THREE.MeshNormalMaterial)q.opacity.value=h.opacity;for(var ka in q)if(F=v.uniforms[ka]){m=q[ka];s=m.type;o=m.value;if(s=="i")c.uniform1i(F,o);else if(s=="f")c.uniform1f(F,o);else if(s=="fv1")c.uniform1fv(F,o);else if(s=="fv")c.uniform3fv(F,o);else if(s=="v2")c.uniform2f(F,
o.x,o.y);else if(s=="v3")c.uniform3f(F,o.x,o.y,o.z);else if(s=="c")c.uniform3f(F,o.r,o.g,o.b);else if(s=="t"){c.uniform1i(F,o);if(m=m.texture)if(m.image instanceof Array&&m.image.length==6){if(m.image.length==6){if(m.needsUpdate){if(!m.image.__webGLTextureCube)m.image.__webGLTextureCube=c.createTexture();c.bindTexture(c.TEXTURE_CUBE_MAP,m.image.__webGLTextureCube);c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE);c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE);
c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_MAG_FILTER,c.LINEAR);c.texParameteri(c.TEXTURE_CUBE_MAP,c.TEXTURE_MIN_FILTER,c.LINEAR_MIPMAP_LINEAR);for(s=0;s<6;++s)c.texImage2D(c.TEXTURE_CUBE_MAP_POSITIVE_X+s,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,m.image[s]);c.generateMipmap(c.TEXTURE_CUBE_MAP);c.bindTexture(c.TEXTURE_CUBE_MAP,null);m.needsUpdate=!1}c.activeTexture(c.TEXTURE0+o);c.bindTexture(c.TEXTURE_CUBE_MAP,m.image.__webGLTextureCube)}}else{if(m.needsUpdate){if(m.__wasSetOnce){c.bindTexture(c.TEXTURE_2D,
m.__webGLTexture);c.texSubImage2D(c.TEXTURE_2D,0,0,0,c.RGBA,c.UNSIGNED_BYTE,m.image);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,L(m.wrapS));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,L(m.wrapT));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,L(m.magFilter));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,L(m.minFilter));c.generateMipmap(c.TEXTURE_2D);c.bindTexture(c.TEXTURE_2D,null)}else{m.__webGLTexture=c.createTexture();c.bindTexture(c.TEXTURE_2D,m.__webGLTexture);c.texImage2D(c.TEXTURE_2D,
0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,m.image);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,L(m.wrapS));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,L(m.wrapT));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,L(m.magFilter));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,L(m.minFilter));c.generateMipmap(c.TEXTURE_2D);c.bindTexture(c.TEXTURE_2D,null);m.__wasSetOnce=!0}m.needsUpdate=!1}c.activeTexture(c.TEXTURE0+o);c.bindTexture(c.TEXTURE_2D,m.__webGLTexture)}}}c.uniformMatrix4fv(r.modelViewMatrix,
!1,l._modelViewMatrixArray);c.uniformMatrix3fv(r.normalMatrix,!1,l._normalMatrixArray);(h instanceof THREE.MeshShaderMaterial||h instanceof THREE.MeshPhongMaterial||h.envMap)&&c.uniform3f(r.cameraPosition,f.position.x,f.position.y,f.position.z);(h instanceof THREE.MeshShaderMaterial||h.envMap||h.skinning)&&c.uniformMatrix4fv(r.objectMatrix,!1,l._objectMatrixArray);(h instanceof THREE.MeshPhongMaterial||h instanceof THREE.MeshLambertMaterial||h instanceof THREE.MeshShaderMaterial||h.skinning)&&c.uniformMatrix4fv(r.viewMatrix,
!1,ua);if(h.skinning){c.uniformMatrix4fv(r.cameraInverseMatrix,!1,ua);c.uniformMatrix4fv(r.boneGlobalMatrices,!1,l.boneMatrices)}return v}function g(f,o,m,h,l,v){f=e(f,o,m,h,v).attributes;c.bindBuffer(c.ARRAY_BUFFER,l.__webGLVertexBuffer);c.vertexAttribPointer(f.position,3,c.FLOAT,!1,0,0);if(f.color>=0){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLColorBuffer);c.vertexAttribPointer(f.color,3,c.FLOAT,!1,0,0)}if(f.normal>=0){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLNormalBuffer);c.vertexAttribPointer(f.normal,
3,c.FLOAT,!1,0,0)}if(f.tangent>=0){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLTangentBuffer);c.vertexAttribPointer(f.tangent,4,c.FLOAT,!1,0,0)}if(f.uv>=0)if(l.__webGLUVBuffer){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLUVBuffer);c.vertexAttribPointer(f.uv,2,c.FLOAT,!1,0,0);c.enableVertexAttribArray(f.uv)}else c.disableVertexAttribArray(f.uv);if(f.uv2>=0)if(l.__webGLUV2Buffer){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLUV2Buffer);c.vertexAttribPointer(f.uv2,2,c.FLOAT,!1,0,0);c.enableVertexAttribArray(f.uv2)}else c.disableVertexAttribArray(f.uv2);
if(h.skinning&&f.skinVertexA>=0&&f.skinVertexB>=0&&f.skinIndex>=0&&f.skinWeight>=0){c.bindBuffer(c.ARRAY_BUFFER,l.__webGLSkinVertexABuffer);c.vertexAttribPointer(f.skinVertexA,4,c.FLOAT,!1,0,0);c.bindBuffer(c.ARRAY_BUFFER,l.__webGLSkinVertexBBuffer);c.vertexAttribPointer(f.skinVertexB,4,c.FLOAT,!1,0,0);c.bindBuffer(c.ARRAY_BUFFER,l.__webGLSkinIndicesBuffer);c.vertexAttribPointer(f.skinIndex,4,c.FLOAT,!1,0,0);c.bindBuffer(c.ARRAY_BUFFER,l.__webGLSkinWeightsBuffer);c.vertexAttribPointer(f.skinWeight,
4,c.FLOAT,!1,0,0)}if(v instanceof THREE.Mesh)if(h.wireframe){c.lineWidth(h.wireframeLinewidth);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,l.__webGLLineBuffer);c.drawElements(c.LINES,l.__webGLLineCount,c.UNSIGNED_SHORT,0)}else{c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,l.__webGLFaceBuffer);c.drawElements(c.TRIANGLES,l.__webGLFaceCount,c.UNSIGNED_SHORT,0)}else if(v instanceof THREE.Line){v=v.type==THREE.LineStrip?c.LINE_STRIP:c.LINES;c.lineWidth(h.linewidth);c.drawArrays(v,0,l.__webGLLineCount)}else if(v instanceof
THREE.ParticleSystem)c.drawArrays(c.POINTS,0,l.__webGLParticleCount);else v instanceof THREE.Ribbon&&c.drawArrays(c.TRIANGLE_STRIP,0,l.__webGLVertexCount)}function k(f,o){if(!f.__webGLVertexBuffer)f.__webGLVertexBuffer=c.createBuffer();if(!f.__webGLNormalBuffer)f.__webGLNormalBuffer=c.createBuffer();if(f.hasPos){c.bindBuffer(c.ARRAY_BUFFER,f.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,f.positionArray,c.DYNAMIC_DRAW);c.enableVertexAttribArray(o.attributes.position);c.vertexAttribPointer(o.attributes.position,
3,c.FLOAT,!1,0,0)}if(f.hasNormal){c.bindBuffer(c.ARRAY_BUFFER,f.__webGLNormalBuffer);c.bufferData(c.ARRAY_BUFFER,f.normalArray,c.DYNAMIC_DRAW);c.enableVertexAttribArray(o.attributes.normal);c.vertexAttribPointer(o.attributes.normal,3,c.FLOAT,!1,0,0)}c.drawArrays(c.TRIANGLES,0,f.count);f.count=0}function i(f){if(ga!=f.doubleSided){f.doubleSided?c.disable(c.CULL_FACE):c.enable(c.CULL_FACE);ga=f.doubleSided}if(da!=f.flipSided){f.flipSided?c.frontFace(c.CW):c.frontFace(c.CCW);da=f.flipSided}}function n(f){if(na!=
f){f?c.enable(c.DEPTH_TEST):c.disable(c.DEPTH_TEST);na=f}}function j(f){$[0].set(f.n41-f.n11,f.n42-f.n12,f.n43-f.n13,f.n44-f.n14);$[1].set(f.n41+f.n11,f.n42+f.n12,f.n43+f.n13,f.n44+f.n14);$[2].set(f.n41+f.n21,f.n42+f.n22,f.n43+f.n23,f.n44+f.n24);$[3].set(f.n41-f.n21,f.n42-f.n22,f.n43-f.n23,f.n44-f.n24);$[4].set(f.n41-f.n31,f.n42-f.n32,f.n43-f.n33,f.n44-f.n34);$[5].set(f.n41+f.n31,f.n42+f.n32,f.n43+f.n33,f.n44+f.n34);var o;for(f=0;f<6;f++){o=$[f];o.divideScalar(Math.sqrt(o.x*o.x+o.y*o.y+o.z*o.z))}}
function t(f){for(var o=f.matrixWorld,m=-f.geometry.boundingSphere.radius*Math.max(f.scale.x,Math.max(f.scale.y,f.scale.z)),h=0;h<6;h++){f=$[h].x*o.n14+$[h].y*o.n24+$[h].z*o.n34+$[h].w;if(f<=m)return!1}return!0}function x(f,o){f.list[f.count]=o;f.count+=1}function w(f){var o,m,h=f.object,l=f.opaque,v=f.transparent;v.count=0;f=l.count=0;for(o=h.materials.length;f<o;f++){m=h.materials[f];m.opacity&&m.opacity<1||m.blending!=THREE.NormalBlending?x(v,m):x(l,m)}}function z(f){var o,m,h,l,v=f.object,r=f.buffer,
q=f.opaque,s=f.transparent;s.count=0;f=q.count=0;for(h=v.materials.length;f<h;f++){o=v.materials[f];if(o instanceof THREE.MeshFaceMaterial){o=0;for(m=r.materials.length;o<m;o++)(l=r.materials[o])&&(l.opacity&&l.opacity<1||l.blending!=THREE.NormalBlending?x(s,l):x(q,l))}else{l=o;l.opacity&&l.opacity<1||l.blending!=THREE.NormalBlending?x(s,l):x(q,l)}}}function A(f,o){return o.z-f.z}function E(f,o,m,h,l){if(o[m]==undefined){f.push({buffer:h,object:l,opaque:{list:[],count:0},transparent:{list:[],count:0}});
o[m]=1}}function H(f,o){f._modelViewMatrix.multiplyToArray(o.matrixWorldInverse,f.matrixWorld,f._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(f._modelViewMatrix).transposeIntoArray(f._normalMatrixArray)}function K(f){if(f!=ja){switch(f){case THREE.AdditiveBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ONE,c.ONE);break;case THREE.SubtractiveBlending:c.blendFunc(c.DST_COLOR,c.ZERO);break;case THREE.BillboardBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.SRC_ALPHA,c.ONE_MINUS_SRC_ALPHA);
break;case THREE.ReverseSubtractiveBlending:c.blendEquation(c.FUNC_REVERSE_SUBTRACT);c.blendFunc(c.ONE,c.ONE);break;default:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ONE,c.ONE_MINUS_SRC_ALPHA)}ja=f}}function J(f,o){if(f&&!f.__webGLFramebuffer){f.__webGLFramebuffer=c.createFramebuffer();f.__webGLRenderbuffer=c.createRenderbuffer();f.__webGLTexture=c.createTexture();c.bindRenderbuffer(c.RENDERBUFFER,f.__webGLRenderbuffer);c.renderbufferStorage(c.RENDERBUFFER,c.DEPTH_COMPONENT16,f.width,f.height);c.bindTexture(c.TEXTURE_2D,
f.__webGLTexture);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,L(f.wrapS));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,L(f.wrapT));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,L(f.magFilter));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,L(f.minFilter));c.texImage2D(c.TEXTURE_2D,0,L(f.format),f.width,f.height,0,L(f.format),L(f.type),null);c.bindFramebuffer(c.FRAMEBUFFER,f.__webGLFramebuffer);c.framebufferTexture2D(c.FRAMEBUFFER,c.COLOR_ATTACHMENT0,c.TEXTURE_2D,f.__webGLTexture,0);c.framebufferRenderbuffer(c.FRAMEBUFFER,
c.DEPTH_ATTACHMENT,c.RENDERBUFFER,f.__webGLRenderbuffer);c.bindTexture(c.TEXTURE_2D,null);c.bindRenderbuffer(c.RENDERBUFFER,null);c.bindFramebuffer(c.FRAMEBUFFER,null)}var m,h,l;if(f){m=f.__webGLFramebuffer;h=f.width;l=f.height}else{m=null;h=P.width;l=P.height}if(m!=ba){c.bindFramebuffer(c.FRAMEBUFFER,m);c.viewport(0,0,h,l);o&&c.clear(c.COLOR_BUFFER_BIT|c.DEPTH_BUFFER_BIT);ba=m}}function R(f,o){var m;if(f=="fragment")m=c.createShader(c.FRAGMENT_SHADER);else f=="vertex"&&(m=c.createShader(c.VERTEX_SHADER));
c.shaderSource(m,o);c.compileShader(m);if(!c.getShaderParameter(m,c.COMPILE_STATUS)){alert(c.getShaderInfoLog(m));return null}return m}function L(f){switch(f){case THREE.RepeatWrapping:return c.REPEAT;case THREE.ClampToEdgeWrapping:return c.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return c.MIRRORED_REPEAT;case THREE.NearestFilter:return c.NEAREST;case THREE.NearestMipMapNearestFilter:return c.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return c.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return c.LINEAR;
case THREE.LinearMipMapNearestFilter:return c.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return c.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return c.BYTE;case THREE.UnsignedByteType:return c.UNSIGNED_BYTE;case THREE.ShortType:return c.SHORT;case THREE.UnsignedShortType:return c.UNSIGNED_SHORT;case THREE.IntType:return c.INT;case THREE.UnsignedShortType:return c.UNSIGNED_INT;case THREE.FloatType:return c.FLOAT;case THREE.AlphaFormat:return c.ALPHA;case THREE.RGBFormat:return c.RGB;case THREE.RGBAFormat:return c.RGBA;
case THREE.LuminanceFormat:return c.LUMINANCE;case THREE.LuminanceAlphaFormat:return c.LUMINANCE_ALPHA}return 0}var P=document.createElement("canvas"),c,aa=null,ba=null,ca=this,ga=null,da=null,ja=null,na=null,$=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],qa=new THREE.Matrix4,wa=new Float32Array(16),ua=new Float32Array(16),Aa=new THREE.Vector4,Ha=!0,Ia=new THREE.Color(0),Oa=0;if(a){if(a.antialias!==undefined)Ha=a.antialias;a.clearColor!==
undefined&&Ia.setHex(a.clearColor);if(a.clearAlpha!==undefined)Oa=a.clearAlpha}this.domElement=P;this.autoClear=!0;this.sortObjects=!1;(function(f,o,m){try{c=P.getContext("experimental-webgl",{antialias:f})}catch(h){console.log(h)}if(!c)throw"cannot create webgl context";c.clearColor(0,0,0,1);c.clearDepth(1);c.enable(c.DEPTH_TEST);c.depthFunc(c.LEQUAL);c.frontFace(c.CCW);c.cullFace(c.BACK);c.enable(c.CULL_FACE);c.enable(c.BLEND);c.blendFunc(c.ONE,c.ONE_MINUS_SRC_ALPHA);c.clearColor(o.r,o.g,o.b,m);
_cullEnabled=!0})(Ha,Ia,Oa);this.context=c;this.lights={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[]}};this.setSize=function(f,o){P.width=f;P.height=o;c.viewport(0,0,P.width,P.height)};this.setClearColorHex=function(f,o){var m=new THREE.Color(f);c.clearColor(m.r,m.g,m.b,o)};this.setClearColor=function(f,o){c.clearColor(f.r,f.g,f.b,o)};this.clear=function(){c.clear(c.COLOR_BUFFER_BIT|c.DEPTH_BUFFER_BIT)};this.initMaterial=function(f,o,m){var h,
l;if(f instanceof THREE.MeshDepthMaterial)d(f,THREE.ShaderLib.depth);else if(f instanceof THREE.MeshNormalMaterial)d(f,THREE.ShaderLib.normal);else if(f instanceof THREE.MeshBasicMaterial)d(f,THREE.ShaderLib.basic);else if(f instanceof THREE.MeshLambertMaterial)d(f,THREE.ShaderLib.lambert);else if(f instanceof THREE.MeshPhongMaterial)d(f,THREE.ShaderLib.phong);else if(f instanceof THREE.LineBasicMaterial)d(f,THREE.ShaderLib.basic);else f instanceof THREE.ParticleBasicMaterial&&d(f,THREE.ShaderLib.particle_basic);
var v,r,q,s;l=q=s=0;for(v=o.length;l<v;l++){r=o[l];r instanceof THREE.DirectionalLight&&q++;r instanceof THREE.PointLight&&s++}if(s+q<=4)o=q;else{o=Math.ceil(4*q/(s+q));s=4-o}l={directional:o,point:s};s=f.fragmentShader;o=f.vertexShader;v={fog:m,map:f.map,envMap:f.envMap,lightMap:f.lightMap,vertexColors:f.vertexColors,skinning:f.skinning,maxDirLights:l.directional,maxPointLights:l.point};m=c.createProgram();l=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+v.maxDirLights,
"#define MAX_POINT_LIGHTS "+v.maxPointLights,v.fog?"#define USE_FOG":"",v.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",v.map?"#define USE_MAP":"",v.envMap?"#define USE_ENVMAP":"",v.lightMap?"#define USE_LIGHTMAP":"",v.vertexColors?"#define USE_COLOR":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");v=[c.getParameter(c.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+v.maxDirLights,"#define MAX_POINT_LIGHTS "+v.maxPointLights,v.map?
"#define USE_MAP":"",v.envMap?"#define USE_ENVMAP":"",v.lightMap?"#define USE_LIGHTMAP":"",v.vertexColors?"#define USE_COLOR":"",v.skinning?"#define USE_SKINNING":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec3 color;\nattribute vec2 uv;\nattribute vec2 uv2;\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n"].join("\n");
c.attachShader(m,R("fragment",l+s));c.attachShader(m,R("vertex",v+o));c.linkProgram(m);c.getProgramParameter(m,c.LINK_STATUS)||alert("Could not initialise shaders\nVALIDATE_STATUS: "+c.getProgramParameter(m,c.VALIDATE_STATUS)+", gl error ["+c.getError()+"]");m.uniforms={};m.attributes={};f.program=m;m=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices"];for(h in f.uniforms)m.push(h);h=f.program;s=0;for(o=m.length;s<
o;s++){l=m[s];h.uniforms[l]=c.getUniformLocation(h,l)}h=f.program;m=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];s=0;for(o=m.length;s<o;s++){l=m[s];h.attributes[l]=c.getAttribLocation(h,l)}h=f.program.attributes;c.enableVertexAttribArray(h.position);h.color>=0&&c.enableVertexAttribArray(h.color);h.normal>=0&&c.enableVertexAttribArray(h.normal);h.tangent>=0&&c.enableVertexAttribArray(h.tangent);if(f.skinning&&h.skinVertexA>=0&&h.skinVertexB>=
0&&h.skinIndex>=0&&h.skinWeight>=0){c.enableVertexAttribArray(h.skinVertexA);c.enableVertexAttribArray(h.skinVertexB);c.enableVertexAttribArray(h.skinIndex);c.enableVertexAttribArray(h.skinWeight)}};this.render=function(f,o,m,h){var l,v,r,q,s,G,F,I,S=f.lights,y=f.fog;o.matrixAutoUpdate&&o.update();o.matrixWorldInverse.flattenToArray(ua);o.projectionMatrix.flattenToArray(wa);qa.multiply(o.projectionMatrix,o.matrixWorldInverse);j(qa);THREE.AnimationHandler&&THREE.AnimationHandler.update();f.update(undefined,
!1,o);this.initWebGLObjects(f,o);J(m,h!==undefined?h:!0);this.autoClear&&this.clear();s=f.__webGLObjects.length;for(h=0;h<s;h++){l=f.__webGLObjects[h];F=l.object;if(F.visible)if(!(F instanceof THREE.Mesh)||t(F)){F.matrixWorld.flattenToArray(F._objectMatrixArray);H(F,o);z(l);l.render=!0;if(this.sortObjects){Aa.copy(F.position);qa.multiplyVector3(Aa);l.z=Aa.z}}else l.render=!1;else l.render=!1}this.sortObjects&&f.__webGLObjects.sort(A);G=f.__webGLObjectsImmediate.length;for(h=0;h<G;h++){l=f.__webGLObjectsImmediate[h];
F=l.object;if(F.visible){F.matrixAutoUpdate&&F.matrixWorld.flattenToArray(F._objectMatrixArray);H(F,o);w(l)}}K(THREE.NormalBlending);for(h=0;h<s;h++){l=f.__webGLObjects[h];if(l.render){F=l.object;I=l.buffer;r=l.opaque;i(F);for(l=0;l<r.count;l++){q=r.list[l];n(q.depthTest);g(o,S,y,q,I,F)}}}for(h=0;h<G;h++){l=f.__webGLObjectsImmediate[h];F=l.object;if(F.visible){r=l.opaque;i(F);for(l=0;l<r.count;l++){q=r.list[l];n(q.depthTest);v=e(o,S,y,q,F);F.render(function(M){k(M,v)})}}}for(h=0;h<s;h++){l=f.__webGLObjects[h];
if(l.render){F=l.object;I=l.buffer;r=l.transparent;i(F);for(l=0;l<r.count;l++){q=r.list[l];K(q.blending);n(q.depthTest);g(o,S,y,q,I,F)}}}for(h=0;h<G;h++){l=f.__webGLObjectsImmediate[h];F=l.object;if(F.visible){r=l.transparent;i(F);for(l=0;l<r.count;l++){q=r.list[l];K(q.blending);n(q.depthTest);v=e(o,S,y,q,F);F.render(function(M){k(M,v)})}}}if(m&&m.minFilter!==THREE.NearestFilter&&m.minFilter!==THREE.LinearFilter){c.bindTexture(c.TEXTURE_2D,m.__webGLTexture);c.generateMipmap(c.TEXTURE_2D);c.bindTexture(c.TEXTURE_2D,
null)}};this.initWebGLObjects=function(f,o){var m,h,l;if(!f.__webGLObjects){f.__webGLObjects=[];f.__webGLObjectsMap={};f.__webGLObjectsImmediate=[]}m=0;for(h=f.objects.length;m<h;m++){l=f.objects[m];var v=f,r=o,q=void 0,s=void 0,G=void 0,F=void 0;s=l.geometry;if(v.__webGLObjectsMap[l.id]==undefined){v.__webGLObjectsMap[l.id]={};l._modelViewMatrix=new THREE.Matrix4;l._normalMatrixArray=new Float32Array(9);l._modelViewMatrixArray=new Float32Array(16);l._objectMatrixArray=new Float32Array(16);l.matrixWorld.flattenToArray(l._objectMatrixArray)}F=
v.__webGLObjectsMap[l.id];objlist=v.__webGLObjects;if(l instanceof THREE.Mesh){for(q in s.geometryChunks){G=s.geometryChunks[q];if(!G.__webGLVertexBuffer){r=G;r.__webGLVertexBuffer=c.createBuffer();r.__webGLNormalBuffer=c.createBuffer();r.__webGLTangentBuffer=c.createBuffer();r.__webGLColorBuffer=c.createBuffer();r.__webGLUVBuffer=c.createBuffer();r.__webGLUV2Buffer=c.createBuffer();r.__webGLSkinVertexABuffer=c.createBuffer();r.__webGLSkinVertexBBuffer=c.createBuffer();r.__webGLSkinIndicesBuffer=
c.createBuffer();r.__webGLSkinWeightsBuffer=c.createBuffer();r.__webGLFaceBuffer=c.createBuffer();r.__webGLLineBuffer=c.createBuffer();r=G;var I=l,S=void 0,y=void 0,M=0,ea=v=0,Z=I.geometry.faces,Q=r.faces;S=0;for(y=Q.length;S<y;S++){fi=Q[S];face=Z[fi];if(face instanceof THREE.Face3){M+=3;v+=1;ea+=3}else if(face instanceof THREE.Face4){M+=4;v+=2;ea+=4}}r.__vertexArray=new Float32Array(M*3);r.__normalArray=new Float32Array(M*3);r.__tangentArray=new Float32Array(M*4);r.__colorArray=new Float32Array(M*
3);r.__uvArray=new Float32Array(M*2);r.__uv2Array=new Float32Array(M*2);r.__skinVertexAArray=new Float32Array(M*4);r.__skinVertexBArray=new Float32Array(M*4);r.__skinIndexArray=new Float32Array(M*4);r.__skinWeightArray=new Float32Array(M*4);r.__faceArray=new Uint16Array(v*3);r.__lineArray=new Uint16Array(ea*2);y=S=r;M=void 0;Z=void 0;var O=void 0,N=void 0;O=void 0;Q=!1;M=0;for(Z=I.materials.length;M<Z;M++){O=I.materials[M];if(O instanceof THREE.MeshFaceMaterial){O=0;for(N=y.materials.length;O<N;O++)if(y.materials[O]&&
y.materials[O].shading!=undefined&&y.materials[O].shading==THREE.SmoothShading){Q=!0;break}}else if(O&&O.shading!=undefined&&O.shading==THREE.SmoothShading){Q=!0;break}if(Q)break}S.__needsSmoothNormals=Q;r.__webGLFaceCount=v*3;r.__webGLLineCount=ea*2;s.__dirtyVertices=!0;s.__dirtyElements=!0;s.__dirtyUvs=!0;s.__dirtyNormals=!0;s.__dirtyTangents=!0;s.__dirtyColors=!0}if(s.__dirtyVertices||s.__dirtyElements||s.__dirtyUvs||s.__dirtyNormals||s.__dirtyColors||s.__dirtyTangents){r=G;v=c.DYNAMIC_DRAW;ea=
void 0;S=void 0;var ra=void 0,u=void 0,ma=void 0,ka=void 0,va=void 0;ra=void 0;var B=void 0,C=void 0,D=void 0,T=void 0;B=void 0;C=void 0;D=void 0;u=void 0;B=void 0;C=void 0;D=void 0;T=void 0;B=void 0;C=void 0;D=void 0;T=void 0;B=void 0;C=void 0;D=void 0;T=void 0;B=void 0;C=void 0;D=void 0;T=void 0;B=void 0;C=void 0;D=void 0;T=void 0;u=void 0;ka=void 0;ma=void 0;va=void 0;var oa=N=O=Q=Z=M=I=y=0,fa=0,p=0,ha=r.__vertexArray,Fa=r.__uvArray,Ga=r.__uv2Array,ta=r.__normalArray,U=r.__tangentArray,ia=r.__colorArray,
V=r.__skinVertexAArray,W=r.__skinVertexBArray,X=r.__skinIndexArray,Y=r.__skinWeightArray,xa=r.__faceArray,pa=r.__lineArray,Pa=r.__needsSmoothNormals,la=l.geometry,Ja=la.__dirtyVertices,Ka=la.__dirtyElements,Ea=la.__dirtyUvs,La=la.__dirtyNormals,Ma=la.__dirtyTangents,Na=la.__dirtyColors,sa=la.vertices,Qa=r.faces,Ra=la.faces,Sa=la.uvs,Ta=la.uvs2,ya=la.colors,Ba=la.skinVerticesA,Ca=la.skinVerticesB,Da=la.skinIndices,za=la.skinWeights;ea=0;for(S=Qa.length;ea<S;ea++){ra=Qa[ea];u=Ra[ra];va=Sa[ra];ra=Ta[ra];
ma=u.vertexNormals;ka=u.normal;if(u instanceof THREE.Face3){if(Ja){B=sa[u.a].position;C=sa[u.b].position;D=sa[u.c].position;ha[I]=B.x;ha[I+1]=B.y;ha[I+2]=B.z;ha[I+3]=C.x;ha[I+4]=C.y;ha[I+5]=C.z;ha[I+6]=D.x;ha[I+7]=D.y;ha[I+8]=D.z;I+=9}if(za.length){B=za[u.a];C=za[u.b];D=za[u.c];Y[p]=B.x;Y[p+1]=B.y;Y[p+2]=B.z;Y[p+3]=B.w;Y[p+4]=C.x;Y[p+5]=C.y;Y[p+6]=C.z;Y[p+7]=C.w;Y[p+8]=D.x;Y[p+9]=D.y;Y[p+10]=D.z;Y[p+11]=D.w;B=Da[u.a];C=Da[u.b];D=Da[u.c];X[p]=B.x;X[p+1]=B.y;X[p+2]=B.z;X[p+3]=B.w;X[p+4]=C.x;X[p+5]=
C.y;X[p+6]=C.z;X[p+7]=C.w;X[p+8]=D.x;X[p+9]=D.y;X[p+10]=D.z;X[p+11]=D.w;B=Ba[u.a];C=Ba[u.b];D=Ba[u.c];V[p]=B.x;V[p+1]=B.y;V[p+2]=B.z;V[p+3]=1;V[p+4]=C.x;V[p+5]=C.y;V[p+6]=C.z;V[p+7]=1;V[p+8]=D.x;V[p+9]=D.y;V[p+10]=D.z;V[p+11]=1;B=Ca[u.a];C=Ca[u.b];D=Ca[u.c];W[p]=B.x;W[p+1]=B.y;W[p+2]=B.z;W[p+3]=1;W[p+4]=C.x;W[p+5]=C.y;W[p+6]=C.z;W[p+7]=1;W[p+8]=D.x;W[p+9]=D.y;W[p+10]=D.z;W[p+11]=1;p+=12}if(Na&&ya.length){B=ya[u.a];C=ya[u.b];D=ya[u.c];ia[fa]=B.r;ia[fa+1]=B.g;ia[fa+2]=B.b;ia[fa+3]=C.r;ia[fa+4]=C.g;
ia[fa+5]=C.b;ia[fa+6]=D.r;ia[fa+7]=D.g;ia[fa+8]=D.b;fa+=9}if(Ma&&la.hasTangents){B=sa[u.a].tangent;C=sa[u.b].tangent;D=sa[u.c].tangent;U[N]=B.x;U[N+1]=B.y;U[N+2]=B.z;U[N+3]=B.w;U[N+4]=C.x;U[N+5]=C.y;U[N+6]=C.z;U[N+7]=C.w;U[N+8]=D.x;U[N+9]=D.y;U[N+10]=D.z;U[N+11]=D.w;N+=12}if(La)if(ma.length==3&&Pa)for(u=0;u<3;u++){ka=ma[u];ta[O]=ka.x;ta[O+1]=ka.y;ta[O+2]=ka.z;O+=3}else for(u=0;u<3;u++){ta[O]=ka.x;ta[O+1]=ka.y;ta[O+2]=ka.z;O+=3}if(Ea&&va)for(u=0;u<3;u++){ma=va[u];Fa[M]=ma.u;Fa[M+1]=ma.v;M+=2}if(Ea&&
ra)for(u=0;u<3;u++){va=ra[u];Ga[Z]=va.u;Ga[Z+1]=va.v;Z+=2}if(Ka){xa[Q]=y;xa[Q+1]=y+1;xa[Q+2]=y+2;Q+=3;pa[oa]=y;pa[oa+1]=y+1;pa[oa+2]=y;pa[oa+3]=y+2;pa[oa+4]=y+1;pa[oa+5]=y+2;oa+=6;y+=3}}else if(u instanceof THREE.Face4){if(Ja){B=sa[u.a].position;C=sa[u.b].position;D=sa[u.c].position;T=sa[u.d].position;ha[I]=B.x;ha[I+1]=B.y;ha[I+2]=B.z;ha[I+3]=C.x;ha[I+4]=C.y;ha[I+5]=C.z;ha[I+6]=D.x;ha[I+7]=D.y;ha[I+8]=D.z;ha[I+9]=T.x;ha[I+10]=T.y;ha[I+11]=T.z;I+=12}if(za.length){B=za[u.a];C=za[u.b];D=za[u.c];T=za[u.d];
Y[p]=B.x;Y[p+1]=B.y;Y[p+2]=B.z;Y[p+3]=B.w;Y[p+4]=C.x;Y[p+5]=C.y;Y[p+6]=C.z;Y[p+7]=C.w;Y[p+8]=D.x;Y[p+9]=D.y;Y[p+10]=D.z;Y[p+11]=D.w;Y[p+12]=T.x;Y[p+13]=T.y;Y[p+14]=T.z;Y[p+15]=T.w;B=Da[u.a];C=Da[u.b];D=Da[u.c];T=Da[u.d];X[p]=B.x;X[p+1]=B.y;X[p+2]=B.z;X[p+3]=B.w;X[p+4]=C.x;X[p+5]=C.y;X[p+6]=C.z;X[p+7]=C.w;X[p+8]=D.x;X[p+9]=D.y;X[p+10]=D.z;X[p+11]=D.w;X[p+12]=T.x;X[p+13]=T.y;X[p+14]=T.z;X[p+15]=T.w;B=Ba[u.a];C=Ba[u.b];D=Ba[u.c];T=Ba[u.d];V[p]=B.x;V[p+1]=B.y;V[p+2]=B.z;V[p+3]=1;V[p+4]=C.x;V[p+5]=C.y;
V[p+6]=C.z;V[p+7]=1;V[p+8]=D.x;V[p+9]=D.y;V[p+10]=D.z;V[p+11]=1;V[p+12]=T.x;V[p+13]=T.y;V[p+14]=T.z;V[p+15]=1;B=Ca[u.a];C=Ca[u.b];D=Ca[u.c];T=Ca[u.d];W[p]=B.x;W[p+1]=B.y;W[p+2]=B.z;W[p+3]=1;W[p+4]=C.x;W[p+5]=C.y;W[p+6]=C.z;W[p+7]=1;W[p+8]=D.x;W[p+9]=D.y;W[p+10]=D.z;W[p+11]=1;W[p+12]=T.x;W[p+13]=T.y;W[p+14]=T.z;W[p+15]=1;p+=16}if(Na&&ya.length){B=ya[u.a];C=ya[u.b];D=ya[u.c];T=ya[u.d];ia[fa]=B.r;ia[fa+1]=B.g;ia[fa+2]=B.b;ia[fa+3]=C.r;ia[fa+4]=C.g;ia[fa+5]=C.b;ia[fa+6]=D.r;ia[fa+7]=D.g;ia[fa+8]=D.b;
ia[fa+9]=T.r;ia[fa+10]=T.g;ia[fa+11]=T.b;fa+=12}if(Ma&&la.hasTangents){B=sa[u.a].tangent;C=sa[u.b].tangent;D=sa[u.c].tangent;u=sa[u.d].tangent;U[N]=B.x;U[N+1]=B.y;U[N+2]=B.z;U[N+3]=B.w;U[N+4]=C.x;U[N+5]=C.y;U[N+6]=C.z;U[N+7]=C.w;U[N+8]=D.x;U[N+9]=D.y;U[N+10]=D.z;U[N+11]=D.w;U[N+12]=u.x;U[N+13]=u.y;U[N+14]=u.z;U[N+15]=u.w;N+=16}if(La)if(ma.length==4&&Pa)for(u=0;u<4;u++){ka=ma[u];ta[O]=ka.x;ta[O+1]=ka.y;ta[O+2]=ka.z;O+=3}else for(u=0;u<4;u++){ta[O]=ka.x;ta[O+1]=ka.y;ta[O+2]=ka.z;O+=3}if(Ea&&va)for(u=
0;u<4;u++){ma=va[u];Fa[M]=ma.u;Fa[M+1]=ma.v;M+=2}if(Ea&&ra)for(u=0;u<4;u++){va=ra[u];Ga[Z]=va.u;Ga[Z+1]=va.v;Z+=2}if(Ka){xa[Q]=y;xa[Q+1]=y+1;xa[Q+2]=y+2;xa[Q+3]=y;xa[Q+4]=y+2;xa[Q+5]=y+3;Q+=6;pa[oa]=y;pa[oa+1]=y+1;pa[oa+2]=y;pa[oa+3]=y+3;pa[oa+4]=y+1;pa[oa+5]=y+2;pa[oa+6]=y+2;pa[oa+7]=y+3;oa+=8;y+=4}}}if(Ja){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,ha,v)}if(Na&&ya.length){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLColorBuffer);c.bufferData(c.ARRAY_BUFFER,ia,v)}if(La){c.bindBuffer(c.ARRAY_BUFFER,
r.__webGLNormalBuffer);c.bufferData(c.ARRAY_BUFFER,ta,v)}if(Ma&&la.hasTangents){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLTangentBuffer);c.bufferData(c.ARRAY_BUFFER,U,v)}if(Ea&&M>0){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLUVBuffer);c.bufferData(c.ARRAY_BUFFER,Fa,v)}if(Ea&&Z>0){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLUV2Buffer);c.bufferData(c.ARRAY_BUFFER,Ga,v)}if(Ka){c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.__webGLFaceBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,xa,v);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.__webGLLineBuffer);
c.bufferData(c.ELEMENT_ARRAY_BUFFER,pa,v)}if(p>0){c.bindBuffer(c.ARRAY_BUFFER,r.__webGLSkinVertexABuffer);c.bufferData(c.ARRAY_BUFFER,V,v);c.bindBuffer(c.ARRAY_BUFFER,r.__webGLSkinVertexBBuffer);c.bufferData(c.ARRAY_BUFFER,W,v);c.bindBuffer(c.ARRAY_BUFFER,r.__webGLSkinIndicesBuffer);c.bufferData(c.ARRAY_BUFFER,X,v);c.bindBuffer(c.ARRAY_BUFFER,r.__webGLSkinWeightsBuffer);c.bufferData(c.ARRAY_BUFFER,Y,v)}}E(objlist,F,q,G,l)}s.__dirtyVertices=!1;s.__dirtyElements=!1;s.__dirtyUvs=!1;s.__dirtyNormals=
!1;s.__dirtyTangents=!1;s.__dirtyColors=!1}else if(l instanceof THREE.Ribbon){if(!s.__webGLVertexBuffer){q=s;q.__webGLVertexBuffer=c.createBuffer();q.__webGLColorBuffer=c.createBuffer();q=s;G=q.vertices.length;q.__vertexArray=new Float32Array(G*3);q.__colorArray=new Float32Array(G*3);q.__webGLVertexCount=G;s.__dirtyVertices=!0;s.__dirtyColors=!0}if(s.__dirtyVertices||s.__dirtyColors){q=s;G=c.DYNAMIC_DRAW;y=void 0;y=void 0;I=void 0;r=void 0;M=q.vertices;v=q.colors;Z=M.length;ea=v.length;Q=q.__vertexArray;
S=q.__colorArray;O=q.__dirtyColors;if(q.__dirtyVertices){for(y=0;y<Z;y++){I=M[y].position;r=y*3;Q[r]=I.x;Q[r+1]=I.y;Q[r+2]=I.z}c.bindBuffer(c.ARRAY_BUFFER,q.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,Q,G)}if(O){for(y=0;y<ea;y++){color=v[y];r=y*3;S[r]=color.r;S[r+1]=color.g;S[r+2]=color.b}c.bindBuffer(c.ARRAY_BUFFER,q.__webGLColorBuffer);c.bufferData(c.ARRAY_BUFFER,S,G)}}E(objlist,F,0,s,l);s.__dirtyVertices=!1;s.__dirtyColors=!1}else if(l instanceof THREE.Line){if(!s.__webGLVertexBuffer){q=s;
q.__webGLVertexBuffer=c.createBuffer();q.__webGLColorBuffer=c.createBuffer();q=s;G=q.vertices.length;q.__vertexArray=new Float32Array(G*3);q.__colorArray=new Float32Array(G*3);q.__webGLLineCount=G;s.__dirtyVertices=!0;s.__dirtyColors=!0}if(s.__dirtyVertices||s.__dirtyColors){q=s;G=c.DYNAMIC_DRAW;y=void 0;y=void 0;I=void 0;r=void 0;M=q.vertices;v=q.colors;Z=M.length;ea=v.length;Q=q.__vertexArray;S=q.__colorArray;O=q.__dirtyColors;if(q.__dirtyVertices){for(y=0;y<Z;y++){I=M[y].position;r=y*3;Q[r]=I.x;
Q[r+1]=I.y;Q[r+2]=I.z}c.bindBuffer(c.ARRAY_BUFFER,q.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,Q,G)}if(O){for(y=0;y<ea;y++){color=v[y];r=y*3;S[r]=color.r;S[r+1]=color.g;S[r+2]=color.b}c.bindBuffer(c.ARRAY_BUFFER,q.__webGLColorBuffer);c.bufferData(c.ARRAY_BUFFER,S,G)}}E(objlist,F,0,s,l);s.__dirtyVertices=!1;s.__dirtyColors=!1}else if(l instanceof THREE.ParticleSystem){if(!s.__webGLVertexBuffer){q=s;q.__webGLVertexBuffer=c.createBuffer();q.__webGLColorBuffer=c.createBuffer();q=s;G=q.vertices.length;
q.__vertexArray=new Float32Array(G*3);q.__colorArray=new Float32Array(G*3);q.__sortArray=[];q.__webGLParticleCount=G;s.__dirtyVertices=!0;s.__dirtyColors=!0}(s.__dirtyVertices||s.__dirtyColors||l.sortParticles)&&b(s,c.DYNAMIC_DRAW,l,r);E(objlist,F,0,s,l);s.__dirtyVertices=!1;s.__dirtyColors=!1}else if(THREE.MarchingCubes!==undefined&&l instanceof THREE.MarchingCubes){s=F;if(s[0]==undefined){v.__webGLObjectsImmediate.push({object:l,opaque:{list:[],count:0},transparent:{list:[],count:0}});s[0]=1}}}};
this.removeObject=function(f,o){var m,h;for(m=f.__webGLObjects.length-1;m>=0;m--){h=f.__webGLObjects[m].object;o==h&&f.__webGLObjects.splice(m,1)}};this.setFaceCulling=function(f,o){if(f){!o||o=="ccw"?c.frontFace(c.CCW):c.frontFace(c.CW);if(f=="back")c.cullFace(c.BACK);else f=="front"?c.cullFace(c.FRONT):c.cullFace(c.FRONT_AND_BACK);c.enable(c.CULL_FACE)}else c.disable(c.CULL_FACE)};this.supportsVertexTextures=function(){return c.getParameter(c.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.Snippets={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",
lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[20];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif"};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",
value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.Snippets.color_pars_fragment,
THREE.Snippets.map_pars_fragment,THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:[THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,THREE.Snippets.envmap_pars_vertex,THREE.Snippets.color_pars_vertex,
THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_pars_fragment,
THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,
THREE.Snippets.envmap_pars_vertex,THREE.Snippets.lights_pars_vertex,THREE.Snippets.color_pars_vertex,THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.Snippets.lights_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,
THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_pars_fragment,THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,
THREE.Snippets.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.Snippets.lights_fragment,THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,THREE.Snippets.envmap_pars_vertex,
THREE.Snippets.lights_pars_vertex,THREE.Snippets.color_pars_vertex,THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.Snippets.lights_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_particle_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.Snippets.map_particle_fragment,THREE.Snippets.color_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;",
THREE.Snippets.color_pars_vertex,"void main() {",THREE.Snippets.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\ngl_Position = projectionMatrix * mvPosition;\ngl_PointSize = size;\n}"].join("\n")}};
