// ThreeExtras.js r33 - http://github.com/mrdoob/three.js
var GeometryUtils={merge:function(a,d){var b=d instanceof THREE.Mesh,f=a.vertices.length,g=b?d.geometry:d,c=a.vertices,e=g.vertices,h=a.faces,j=g.faces,l=a.uvs;g=g.uvs;b&&d.matrixAutoUpdate&&d.updateMatrix();for(var m=0,v=e.length;m<v;m++){var q=new THREE.Vertex(e[m].position.clone());b&&d.matrix.multiplyVector3(q.position);c.push(q)}m=0;for(v=j.length;m<v;m++){e=j[m];var n,p=e.vertexNormals;if(e instanceof THREE.Face3)n=new THREE.Face3(e.a+f,e.b+f,e.c+f);else e instanceof THREE.Face4&&(n=new THREE.Face4(e.a+
f,e.b+f,e.c+f,e.d+f));n.centroid.copy(e.centroid);n.normal.copy(e.normal);b=0;for(c=p.length;b<c;b++){q=p[b];n.vertexNormals.push(q.clone())}n.materials=e.materials.slice();h.push(n)}m=0;for(v=g.length;m<v;m++){f=g[m];h=[];b=0;for(c=f.length;b<c;b++)h.push(new THREE.UV(f[b].u,f[b].v));l.push(h)}}},ImageUtils={loadTexture:function(a,d,b){var f=new Image,g=new THREE.Texture(f,d);f.onload=function(){g.needsUpdate=!0;b&&b(this)};f.src=a;return g},loadTextureCube:function(a,d,b){var f,g=[],c=new THREE.Texture(g,
d);d=g.loadCount=0;for(f=a.length;d<f;++d){g[d]=new Image;g[d].onload=function(){g.loadCount+=1;if(g.loadCount==6)c.needsUpdate=!0;b&&b(this)};g[d].src=a[d]}return c}},SceneUtils={loadScene:function(a,d,b,f){a=new Worker(a);a.postMessage(0);a.onmessage=function(g){function c(){for(m in A.objects)if(!F.objects[m]){t=A.objects[m];if(k=F.geometries[t.geometry]){J=[];for(i=0;i<t.materials.length;i++)J[i]=F.materials[t.materials[i]];z=t.position;r=t.rotation;s=t.scale;object=new THREE.Mesh(k,J);object.position.set(z[0],
z[1],z[2]);object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=t.visible;F.scene.addObject(object);F.objects[m]=object}}}function e(P){return function(Q){F.geometries[P]=Q;c();H-=1;h()}}function h(){f({total_models:K,total_textures:M,loaded_models:K-H,loaded_textures:M-I},F);H==0&&I==0&&b(F)}var j,l,m,v,q,n,p,t,z,w,x,k,D,E,J,A,C,H,I,K,M,F;A=g.data;C=new THREE.Loader;I=H=0;F={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},
fogs:{}};g=function(){I-=1;h()};for(q in A.cameras){w=A.cameras[q];if(w.type=="perspective")D=new THREE.Camera(w.fov,w.aspect,w.near,w.far);else if(w.type=="ortho"){D=new THREE.Camera;D.projectionMatrix=THREE.Matrix4.makeOrtho(w.left,w.right,w.top,w.bottom,w.near,w.far)}z=w.position;w=w.target;D.position.set(z[0],z[1],z[2]);D.target.position.set(w[0],w[1],w[2]);F.cameras[q]=D}for(v in A.lights){q=A.lights[v];if(q.type=="directional"){z=q.direction;light=new THREE.DirectionalLight;light.position.set(z[0],
z[1],z[2]);light.position.normalize()}else if(q.type=="point"){z=q.position;light=new THREE.PointLight;light.position.set(z[0],z[1],z[2])}w=q.color;i=q.intensity||1;light.color.setRGB(w[0]*i,w[1]*i,w[2]*i);F.scene.addLight(light);F.lights[v]=light}for(n in A.fogs){v=A.fogs[n];if(v.type=="linear")E=new THREE.Fog(0,v.near,v.far);else v.type=="exp2"&&(E=new THREE.FogExp2(0,v.density));w=v.color;E.color.setRGB(w[0],w[1],w[2]);F.fogs[n]=E}if(F.cameras&&A.defaults.camera)F.currentCamera=F.cameras[A.defaults.camera];
if(F.fogs&&A.defaults.fog)F.scene.fog=F.fogs[A.defaults.fog];w=A.defaults.bgcolor;F.bgColor=new THREE.Color;F.bgColor.setRGB(w[0],w[1],w[2]);F.bgColorAlpha=A.defaults.bgalpha;for(j in A.geometries){n=A.geometries[j];if(n.type=="bin_mesh"||n.type=="ascii_mesh")H+=1}K=H;for(j in A.geometries){n=A.geometries[j];if(n.type=="cube"){k=new Cube(n.width,n.height,n.depth,n.segmentsWidth,n.segmentsHeight,null,n.flipped,n.sides);F.geometries[j]=k}else if(n.type=="plane"){k=new Plane(n.width,n.height,n.segmentsWidth,
n.segmentsHeight);F.geometries[j]=k}else if(n.type=="sphere"){k=new Sphere(n.radius,n.segmentsWidth,n.segmentsHeight);F.geometries[j]=k}else if(n.type=="cylinder"){k=new Cylinder(n.numSegs,n.topRad,n.botRad,n.height,n.topOffset,n.botOffset);F.geometries[j]=k}else if(n.type=="torus"){k=new Torus(n.radius,n.tube,n.segmentsR,n.segmentsT);F.geometries[j]=k}else if(n.type=="icosahedron"){k=new Icosahedron(n.subdivisions);F.geometries[j]=k}else if(n.type=="bin_mesh")C.loadBinary({model:n.url,callback:e(j)});
else n.type=="ascii_mesh"&&C.loadAscii({model:n.url,callback:e(j)})}for(p in A.textures){j=A.textures[p];I+=j.url instanceof Array?j.url.length:1}M=I;for(p in A.textures){j=A.textures[p];if(j.mapping!=undefined&&THREE[j.mapping]!=undefined)j.mapping=new THREE[j.mapping];if(j.url instanceof Array)n=ImageUtils.loadTextureCube(j.url,j.mapping,g);else{n=ImageUtils.loadTexture(j.url,j.mapping,g);if(THREE[j.minFilter]!=undefined)n.minFilter=THREE[j.minFilter];if(THREE[j.magFilter]!=undefined)n.magFilter=
THREE[j.magFilter]}F.textures[p]=n}for(l in A.materials){p=A.materials[l];for(x in p.parameters)if(x=="envMap"||x=="map"||x=="lightMap")p.parameters[x]=F.textures[p.parameters[x]];else if(x=="shading")p.parameters[x]=p.parameters[x]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(x=="blending")p.parameters[x]=THREE[p.parameters[x]]?THREE[p.parameters[x]]:THREE.NormalBlending;else x=="combine"&&(p.parameters[x]=p.parameters[x]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation);p=new THREE[p.type](p.parameters);
F.materials[l]=p}c();d(F)}},addMesh:function(a,d,b,f,g,c,e,h,j,l){d=new THREE.Mesh(d,l);d.scale.x=d.scale.y=d.scale.z=b;d.position.x=f;d.position.y=g;d.position.z=c;d.rotation.x=e;d.rotation.y=h;d.rotation.z=j;a.addObject(d);return d},addPanoramaCubeWebGL:function(a,d,b){var f=ShaderUtils.lib.cube;f.uniforms.tCube.texture=b;b=new THREE.MeshShaderMaterial({fragmentShader:f.fragmentShader,vertexShader:f.vertexShader,uniforms:f.uniforms});d=new THREE.Mesh(new Cube(d,d,d,1,1,null,!0),b);a.addObject(d);
return d},addPanoramaCube:function(a,d,b){var f=[];f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[4])}));f.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));d=new THREE.Mesh(new Cube(d,d,d,1,1,f,!0),new THREE.MeshFaceMaterial);
a.addObject(d);return d},addPanoramaCubePlanes:function(a,d,b){var f=d/2;d=new Plane(d,d);var g=Math.PI,c=Math.PI/2;SceneUtils.addMesh(a,d,1,0,0,-f,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));SceneUtils.addMesh(a,d,1,-f,0,0,0,c,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));SceneUtils.addMesh(a,d,1,f,0,0,0,-c,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));SceneUtils.addMesh(a,d,1,0,f,0,c,0,g,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));
SceneUtils.addMesh(a,d,1,0,-f,0,-c,0,g,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}))}},ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var d,b,f,g,c=2*Math.ceil(a*3)+1;c>25&&(c=25);g=(c-1)*0.5;b=Array(c);for(d=f=0;d<c;++d){b[d]=Math.exp(-((d-g)*(d-g))/(2*a*a));f+=b[d]}for(d=0;d<c;++d)b[d]/=f;return b}},Cube=function(a,d,b,f,g,c,e,h){function j(t,z,w,x,k,D,E,J){var A,C,H=f||1,I=g||1,K=H+1,M=I+1,F=k/2,P=D/2;k/=H;var Q=D/I,R=l.vertices.length;if(t=="x"&&z=="y"||t=="y"&&z=="x")A="z";else if(t=="x"&&z=="z"||t=="z"&&z=="x")A="y";else if(t==
"z"&&z=="y"||t=="y"&&z=="z")A="x";for(C=0;C<M;C++)for(D=0;D<K;D++){var S=new THREE.Vector3;S[t]=(D*k-F)*w;S[z]=(C*Q-P)*x;S[A]=E;l.vertices.push(new THREE.Vertex(S))}for(C=0;C<I;C++)for(D=0;D<H;D++){l.faces.push(new THREE.Face4(D+K*C+R,D+K*(C+1)+R,D+1+K*(C+1)+R,D+1+K*C+R,null,J));l.uvs.push([new THREE.UV(D/H,C/I),new THREE.UV(D/H,(C+1)/I),new THREE.UV((D+1)/H,(C+1)/I),new THREE.UV((D+1)/H,C/I)])}}THREE.Geometry.call(this);var l=this,m=a/2,v=d/2,q=b/2;e=e?-1:1;if(c!==undefined)if(c instanceof Array)this.materials=
c;else{this.materials=[];for(var n=0;n<6;n++)this.materials.push([c])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(h!=undefined)for(var p in h)this.sides[p]!=undefined&&(this.sides[p]=h[p]);this.sides.px&&j("z","y",1*e,-1,b,d,-m,this.materials[0]);this.sides.nx&&j("z","y",-1*e,-1,b,d,m,this.materials[1]);this.sides.py&&j("x","z",1*e,1,a,b,v,this.materials[2]);this.sides.ny&&j("x","z",1*e,-1,a,b,-v,this.materials[3]);this.sides.pz&&j("x","y",1*e,-1,a,d,q,this.materials[4]);
this.sides.nz&&j("x","y",-1*e,-1,a,d,-q,this.materials[5]);(function(){for(var t=[],z=[],w=0,x=l.vertices.length;w<x;w++){for(var k=l.vertices[w],D=!1,E=0,J=t.length;E<J;E++){var A=t[E];if(k.position.x==A.position.x&&k.position.y==A.position.y&&k.position.z==A.position.z){z[w]=E;D=!0;break}}if(!D){z[w]=t.length;t.push(new THREE.Vertex(k.position.clone()))}}w=0;for(x=l.faces.length;w<x;w++){k=l.faces[w];k.a=z[k.a];k.b=z[k.b];k.c=z[k.c];k.d=z[k.d]}l.vertices=t})();this.computeCentroids();this.computeFaceNormals();
this.sortFacesByMaterial()};Cube.prototype=new THREE.Geometry;Cube.prototype.constructor=Cube;
var Cylinder=function(a,d,b,f,g){function c(l,m,v){e.vertices.push(new THREE.Vertex(new THREE.Vector3(l,m,v)))}THREE.Geometry.call(this);var e=this,h=Math.PI,j;for(j=0;j<a;j++)c(Math.sin(2*h*j/a)*d,Math.cos(2*h*j/a)*d,0);for(j=0;j<a;j++)c(Math.sin(2*h*j/a)*b,Math.cos(2*h*j/a)*b,f);for(j=0;j<a;j++)e.faces.push(new THREE.Face4(j,j+a,a+(j+1)%a,(j+1)%a));if(b!=0){c(0,0,-g);for(j=a;j<a+a/2;j++)e.faces.push(new THREE.Face4(2*a,(2*j-2*a)%a,(2*j-2*a+1)%a,(2*j-2*a+2)%a))}if(d!=0){c(0,0,f+g);for(j=a+a/2;j<
2*a;j++)e.faces.push(new THREE.Face4((2*j-2*a+2)%a+a,(2*j-2*a+1)%a+a,(2*j-2*a)%a+a,2*a+1))}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};Cylinder.prototype=new THREE.Geometry;Cylinder.prototype.constructor=Cylinder;
var Plane=function(a,d,b,f){THREE.Geometry.call(this);var g,c=a/2,e=d/2;b=b||1;f=f||1;var h=b+1,j=f+1;a/=b;var l=d/f;for(g=0;g<j;g++)for(d=0;d<h;d++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(d*a-c,-(g*l-e),0)));for(g=0;g<f;g++)for(d=0;d<b;d++){this.faces.push(new THREE.Face4(d+h*g,d+h*(g+1),d+1+h*(g+1),d+1+h*g));this.uvs.push([new THREE.UV(d/b,g/f),new THREE.UV(d/b,(g+1)/f),new THREE.UV((d+1)/b,(g+1)/f),new THREE.UV((d+1)/b,g/f)])}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};
Plane.prototype=new THREE.Geometry;Plane.prototype.constructor=Plane;
var Sphere=function(a,d,b){THREE.Geometry.call(this);var f,g=Math.PI,c=Math.max(3,d||8),e=Math.max(2,b||6);d=[];for(b=0;b<e+1;b++){f=b/e;var h=a*Math.cos(f*g),j=a*Math.sin(f*g),l=[],m=0;for(f=0;f<c;f++){var v=2*f/c,q=j*Math.sin(v*g);v=j*Math.cos(v*g);(b==0||b==e)&&f>0||(m=this.vertices.push(new THREE.Vertex(new THREE.Vector3(v,h,q)))-1);l.push(m)}d.push(l)}var n,p,t;g=d.length;for(b=0;b<g;b++){c=d[b].length;if(b>0)for(f=0;f<c;f++){l=f==c-1;e=d[b][l?0:f+1];h=d[b][l?c-1:f];j=d[b-1][l?c-1:f];l=d[b-1][l?
0:f+1];q=b/(g-1);n=(b-1)/(g-1);p=(f+1)/c;v=f/c;m=new THREE.UV(1-p,q);q=new THREE.UV(1-v,q);v=new THREE.UV(1-v,n);var z=new THREE.UV(1-p,n);if(b<d.length-1){n=this.vertices[e].position.clone();p=this.vertices[h].position.clone();t=this.vertices[j].position.clone();n.normalize();p.normalize();t.normalize();this.faces.push(new THREE.Face3(e,h,j,[new THREE.Vector3(n.x,n.y,n.z),new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(t.x,t.y,t.z)]));this.uvs.push([m,q,v])}if(b>1){n=this.vertices[e].position.clone();
p=this.vertices[j].position.clone();t=this.vertices[l].position.clone();n.normalize();p.normalize();t.normalize();this.faces.push(new THREE.Face3(e,j,l,[new THREE.Vector3(n.x,n.y,n.z),new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(t.x,t.y,t.z)]));this.uvs.push([m,v,z])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial();this.boundingSphere={radius:a}};Sphere.prototype=new THREE.Geometry;Sphere.prototype.constructor=Sphere;
var Torus=function(a,d,b,f){this.radius=a||100;this.tube=d||40;this.segmentsR=b||8;this.segmentsT=f||6;a=[];THREE.Geometry.call(this);for(d=0;d<=this.segmentsR;++d)for(b=0;b<=this.segmentsT;++b){f=b/this.segmentsT*2*Math.PI;var g=d/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(g))*Math.cos(f),(this.radius+this.tube*Math.cos(g))*Math.sin(f),this.tube*Math.sin(g))));a.push([b/this.segmentsT,1-d/this.segmentsR])}for(d=1;d<=this.segmentsR;++d)for(b=
1;b<=this.segmentsT;++b){f=(this.segmentsT+1)*d+b;g=(this.segmentsT+1)*d+b-1;var c=(this.segmentsT+1)*(d-1)+b-1,e=(this.segmentsT+1)*(d-1)+b;this.faces.push(new THREE.Face4(f,g,c,e));this.uvs.push([new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[g][0],a[g][1]),new THREE.UV(a[c][0],a[c][1]),new THREE.UV(a[e][0],a[e][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()};Torus.prototype=new THREE.Geometry;Torus.prototype.constructor=Torus;
var Icosahedron=function(a){function d(v,q,n){var p=Math.sqrt(v*v+q*q+n*n);return g.vertices.push(new THREE.Vertex(new THREE.Vector3(v/p,q/p,n/p)))-1}function b(v,q,n,p){p.faces.push(new THREE.Face3(v,q,n))}function f(v,q){var n=g.vertices[v].position,p=g.vertices[q].position;return d((n.x+p.x)/2,(n.y+p.y)/2,(n.z+p.z)/2)}var g=this,c=new THREE.Geometry,e;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;d(-1,a,0);d(1,a,0);d(-1,-a,0);d(1,-a,0);d(0,-1,a);d(0,1,a);d(0,-1,-a);d(0,
1,-a);d(a,0,-1);d(a,0,1);d(-a,0,-1);d(-a,0,1);b(0,11,5,c);b(0,5,1,c);b(0,1,7,c);b(0,7,10,c);b(0,10,11,c);b(1,5,9,c);b(5,11,4,c);b(11,10,2,c);b(10,7,6,c);b(7,1,8,c);b(3,9,4,c);b(3,4,2,c);b(3,2,6,c);b(3,6,8,c);b(3,8,9,c);b(4,9,5,c);b(2,4,11,c);b(6,2,10,c);b(8,6,7,c);b(9,8,1,c);for(a=0;a<this.subdivisions;a++){e=new THREE.Geometry;for(var h in c.faces){var j=f(c.faces[h].a,c.faces[h].b),l=f(c.faces[h].b,c.faces[h].c),m=f(c.faces[h].c,c.faces[h].a);b(c.faces[h].a,j,m,e);b(c.faces[h].b,l,j,e);b(c.faces[h].c,
m,l,e);b(j,l,m,e)}c.faces=e.faces}g.faces=c.faces;delete c;delete e;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()};Icosahedron.prototype=new THREE.Geometry;Icosahedron.prototype.constructor=Icosahedron;
function LathedObject(a,d,b){THREE.Geometry.call(this);this.nsteps=d||12;this.latheAngle=b||2*Math.PI;d=this.latheAngle/this.nsteps;for(var f=[],g=[],c=[],e=[],h=0;h<a.length;h++){this.vertices.push(new THREE.Vertex(a[h]));g[h]=this.vertices.length-1;f[h]=new THREE.Vector3(a[h].x,a[h].y,a[h].z)}for(var j=THREE.Matrix4.rotationZMatrix(this.stepSize),l=0;l<=this.latheAngle+0.001;l+=this.stepSize){for(h=0;h<f.length;h++)if(l<b){f[h]=j.multiplyVector3(f[h].clone());this.vertices.push(new THREE.Vertex(f[h]));
c[h]=this.vertices.length-1}else c=e;l==0&&(e=g);for(h=0;h<g.length-1;h++){this.faces.push(new THREE.Face4(c[h],c[h+1],g[h+1],g[h]));this.uvs.push([new THREE.UV(l/b,h/a.length),new THREE.UV(l/b,(h+1)/a.length),new THREE.UV((l-d)/b,(h+1)/a.length),new THREE.UV((l-d)/b,h/a.length)])}g=c;c=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()}LathedObject.prototype=new THREE.Geometry;LathedObject.prototype.constructor=LathedObject;
if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}
THREE.MarchingCubes=function(a,d){THREE.Object3D.call(this);this.materials=d instanceof Array?d:[d];this.init=function(b){this.isolation=80;this.size=b;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(b,f,g){return b+(f-b)*g};this.VIntX=function(b,f,g,c,e,h,j,l,m,v){e=(e-m)/(v-m);m=this.normal_cache;f[c]=h+e*this.delta;f[c+1]=j;f[c+2]=l;g[c]=this.lerp(m[b],m[b+3],e);g[c+1]=this.lerp(m[b+1],m[b+4],e);g[c+2]=this.lerp(m[b+2],m[b+5],e)};this.VIntY=function(b,f,g,c,e,h,j,l,m,v){e=(e-m)/(v-m);m=this.normal_cache;f[c]=h;f[c+1]=j+e*this.delta;f[c+
2]=l;f=b+this.yd*3;g[c]=this.lerp(m[b],m[f],e);g[c+1]=this.lerp(m[b+1],m[f+1],e);g[c+2]=this.lerp(m[b+2],m[f+2],e)};this.VIntZ=function(b,f,g,c,e,h,j,l,m,v){e=(e-m)/(v-m);m=this.normal_cache;f[c]=h;f[c+1]=j;f[c+2]=l+e*this.delta;f=b+this.zd*3;g[c]=this.lerp(m[b],m[f],e);g[c+1]=this.lerp(m[b+1],m[f+1],e);g[c+2]=this.lerp(m[b+2],m[f+2],e)};this.compNorm=function(b){var f=b*3;if(this.normal_cache[f]==0){this.normal_cache[f]=this.field[b-1]-this.field[b+1];this.normal_cache[f+1]=this.field[b-this.yd]-
this.field[b+this.yd];this.normal_cache[f+2]=this.field[b-this.zd]-this.field[b+this.zd]}};this.polygonize=function(b,f,g,c,e,h){var j=c+1,l=c+this.yd,m=c+this.zd,v=j+this.yd,q=j+this.zd,n=c+this.yd+this.zd,p=j+this.yd+this.zd,t=0,z=this.field[c],w=this.field[j],x=this.field[l],k=this.field[v],D=this.field[m],E=this.field[q],J=this.field[n],A=this.field[p];z<e&&(t|=1);w<e&&(t|=2);x<e&&(t|=8);k<e&&(t|=4);D<e&&(t|=16);E<e&&(t|=32);J<e&&(t|=128);A<e&&(t|=64);var C=THREE.edgeTable[t];if(C==0)return 0;
var H=this.delta,I=b+H,K=f+H;H=g+H;if(C&1){this.compNorm(c);this.compNorm(j);this.VIntX(c*3,this.vlist,this.nlist,0,e,b,f,g,z,w)}if(C&2){this.compNorm(j);this.compNorm(v);this.VIntY(j*3,this.vlist,this.nlist,3,e,I,f,g,w,k)}if(C&4){this.compNorm(l);this.compNorm(v);this.VIntX(l*3,this.vlist,this.nlist,6,e,b,K,g,x,k)}if(C&8){this.compNorm(c);this.compNorm(l);this.VIntY(c*3,this.vlist,this.nlist,9,e,b,f,g,z,x)}if(C&16){this.compNorm(m);this.compNorm(q);this.VIntX(m*3,this.vlist,this.nlist,12,e,b,f,H,
D,E)}if(C&32){this.compNorm(q);this.compNorm(p);this.VIntY(q*3,this.vlist,this.nlist,15,e,I,f,H,E,A)}if(C&64){this.compNorm(n);this.compNorm(p);this.VIntX(n*3,this.vlist,this.nlist,18,e,b,K,H,J,A)}if(C&128){this.compNorm(m);this.compNorm(n);this.VIntY(m*3,this.vlist,this.nlist,21,e,b,f,H,D,J)}if(C&256){this.compNorm(c);this.compNorm(m);this.VIntZ(c*3,this.vlist,this.nlist,24,e,b,f,g,z,D)}if(C&512){this.compNorm(j);this.compNorm(q);this.VIntZ(j*3,this.vlist,this.nlist,27,e,I,f,g,w,E)}if(C&1024){this.compNorm(v);
this.compNorm(p);this.VIntZ(v*3,this.vlist,this.nlist,30,e,I,K,g,k,A)}if(C&2048){this.compNorm(l);this.compNorm(n);this.VIntZ(l*3,this.vlist,this.nlist,33,e,b,K,g,x,J)}t<<=4;for(e=c=0;THREE.triTable[t+e]!=-1;){b=t+e;f=b+1;g=b+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[b],3*THREE.triTable[f],3*THREE.triTable[g],h);e+=3;c++}return c};this.posnormtriv=function(b,f,g,c,e,h){var j=this.count*3;this.positionArray[j]=b[g];this.positionArray[j+1]=b[g+1];this.positionArray[j+2]=b[g+2];this.positionArray[j+
3]=b[c];this.positionArray[j+4]=b[c+1];this.positionArray[j+5]=b[c+2];this.positionArray[j+6]=b[e];this.positionArray[j+7]=b[e+1];this.positionArray[j+8]=b[e+2];this.normalArray[j]=f[g];this.normalArray[j+1]=f[g+1];this.normalArray[j+2]=f[g+2];this.normalArray[j+3]=f[c];this.normalArray[j+4]=f[c+1];this.normalArray[j+5]=f[c+2];this.normalArray[j+6]=f[e];this.normalArray[j+7]=f[e+1];this.normalArray[j+8]=f[e+2];this.hasPos=!0;this.hasNormal=!0;this.count+=3;this.count>=this.maxCount-3&&h(this)};this.begin=
function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(b){if(this.count!=0){for(var f=this.count*3;f<this.positionArray.length;f++)this.positionArray[f]=0;b(this)}};this.addBall=function(b,f,g,c,e){var h=this.size*Math.sqrt(c/e),j=g*this.size,l=f*this.size,m=b*this.size,v=Math.floor(j-h);v<1&&(v=1);j=Math.floor(j+h);j>this.size-1&&(j=this.size-1);var q=Math.floor(l-h);q<1&&(q=1);l=Math.floor(l+h);l>this.size-1&&(l=this.size-1);var n=Math.floor(m-h);n<1&&(n=1);h=Math.floor(m+h);
h>this.size-1&&(h=this.size-1);for(var p,t,z,w,x,k;v<j;v++){m=this.size2*v;t=v/this.size-g;x=t*t;for(t=q;t<l;t++){z=m+this.size*t;p=t/this.size-f;k=p*p;for(p=n;p<h;p++){w=p/this.size-b;w=c/(1.0E-6+w*w+k+x)-e;w>0&&(this.field[z+p]+=w)}}}};this.addPlaneX=function(b,f){var g,c,e,h,j,l=this.size,m=this.yd,v=this.zd,q=this.field,n=l*Math.sqrt(b/f);n>l&&(n=l);for(g=0;g<n;g++){c=g/l;c*=c;h=b/(1.0E-4+c)-f;if(h>0)for(c=0;c<l;c++){j=g+c*m;for(e=0;e<l;e++)q[v*e+j]+=h}}};this.addPlaneY=function(b,f){var g,c,
e,h,j,l,m=this.size,v=this.yd,q=this.zd,n=this.field,p=m*Math.sqrt(b/f);p>m&&(p=m);for(c=0;c<p;c++){g=c/m;g*=g;h=b/(1.0E-4+g)-f;if(h>0){j=c*v;for(g=0;g<m;g++){l=j+g;for(e=0;e<m;e++)n[q*e+l]+=h}}}};this.addPlaneZ=function(b,f){var g,c,e,h,j,l;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(b/f);dist>size&&(dist=size);for(e=0;e<dist;e++){g=e/size;g*=g;h=b/(1.0E-4+g)-f;if(h>0){j=zd*e;for(c=0;c<size;c++){l=j+c*yd;for(g=0;g<size;g++)field[l+g]+=h}}}};this.reset=function(){var b;
for(b=0;b<this.size3;b++){this.normal_cache[b*3]=0;this.field[b]=0}};this.render=function(b){this.begin();var f,g,c,e,h,j,l,m,v,q=this.size-2;for(e=1;e<q;e++){v=this.size2*e;l=(e-this.halfsize)/this.halfsize;for(c=1;c<q;c++){m=v+this.size*c;j=(c-this.halfsize)/this.halfsize;for(g=1;g<q;g++){h=(g-this.halfsize)/this.halfsize;f=m+g;this.polygonize(h,j,l,f,this.isolation,b)}}}this.end(b)};this.generateGeometry=function(){var b=0,f=new THREE.Geometry;this.render(function(g){var c,e,h,j,l,m,v,q;for(c=
0;c<g.count;c++){l=c*3;v=l+1;q=l+2;e=g.positionArray[l];h=g.positionArray[v];j=g.positionArray[q];m=new THREE.Vector3(e,h,j);e=g.normalArray[l];h=g.normalArray[v];j=g.normalArray[q];l=new THREE.Vector3(e,h,j);l.normalize();l=new THREE.Vertex(m,l);f.vertices.push(l)}nfaces=g.count/3;for(c=0;c<nfaces;c++){l=(b+c)*3;v=l+1;q=l+2;m=f.vertices[l].normal;e=f.vertices[v].normal;h=f.vertices[q].normal;l=new THREE.Face3(l,v,q,[m,e,h]);f.faces.push(l)}b+=nfaces;g.count=0});f.sortFacesByMaterial();return f};
this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?this.addStatusElement():null};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="#b00";a.style.color="#fff";a.style.width="140px";a.style.padding="0.25em 0.25em 0.25em 0.5em";a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var d="Loaded ";d+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";this.statusDomElement.innerHTML=
d},loadAsciiOld:function(a,d){var b=document.createElement("script");b.type="text/javascript";b.onload=d;b.src=a;document.getElementsByTagName("head")[0].appendChild(b)},loadAscii:function(a){var d=a.model,b=a.callback,f=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(d);a=(new Date).getTime();d=new Worker(d);d.onmessage=function(g){THREE.Loader.prototype.createModel(g.data,b,f)};d.postMessage(a)},loadBinary:function(a){var d=a.model,b=a.callback,f=a.texture_path?a.texture_path:
THREE.Loader.prototype.extractUrlbase(d),g=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(d);a=(new Date).getTime();d=new Worker(d);var c=this.showProgress?THREE.Loader.prototype.updateProgress:null;d.onmessage=function(e){THREE.Loader.prototype.loadAjaxBuffers(e.data.buffers,e.data.materials,b,g,f,c)};d.onerror=function(e){alert("worker.onerror: "+e.message+"\n"+e.data);e.preventDefault()};d.postMessage(a)},loadAjaxBuffers:function(a,d,b,f,g,c){var e=new XMLHttpRequest,h=f+"/"+a,j=0;
e.onreadystatechange=function(){if(e.readyState==4)e.status==200||e.status==0?THREE.Loader.prototype.createBinModel(e.responseText,b,g,d):alert("Couldn't load ["+h+"] ["+e.status+"]");else if(e.readyState==3){if(c){j==0&&(j=e.getResponseHeader("Content-Length"));c({total:j,loaded:e.responseText.length})}}else e.readyState==2&&(j=e.getResponseHeader("Content-Length"))};e.open("GET",h,!0);e.overrideMimeType("text/plain; charset=x-user-defined");e.setRequestHeader("Content-Type","text/plain");e.send(null)},
createBinModel:function(a,d,b,f){var g=function(c){function e(o,u){var y=m(o,u),B=m(o,u+1),G=m(o,u+2),L=m(o,u+3),N=(L<<1&255|G>>7)-127;y|=(G&127)<<16|B<<8;if(y==0&&N==-127)return 0;return(1-2*(L>>7))*(1+y*Math.pow(2,-23))*Math.pow(2,N)}function h(o,u){var y=m(o,u),B=m(o,u+1),G=m(o,u+2);return(m(o,u+3)<<24)+(G<<16)+(B<<8)+y}function j(o,u){var y=m(o,u);return(m(o,u+1)<<8)+y}function l(o,u){var y=m(o,u);return y>127?y-256:y}function m(o,u){return o.charCodeAt(u)&255}function v(o){var u,y,B;u=h(a,o);
y=h(a,o+J);B=h(a,o+A);o=j(a,o+C);THREE.Loader.prototype.f3(w,u,y,B,o)}function q(o){var u,y,B,G,L,N;u=h(a,o);y=h(a,o+J);B=h(a,o+A);G=j(a,o+C);L=h(a,o+H);N=h(a,o+I);o=h(a,o+K);THREE.Loader.prototype.f3n(w,D,u,y,B,G,L,N,o)}function n(o){var u,y,B,G;u=h(a,o);y=h(a,o+M);B=h(a,o+F);G=h(a,o+P);o=j(a,o+Q);THREE.Loader.prototype.f4(w,u,y,B,G,o)}function p(o){var u,y,B,G,L,N,Y,Z;u=h(a,o);y=h(a,o+M);B=h(a,o+F);G=h(a,o+P);L=j(a,o+Q);N=h(a,o+R);Y=h(a,o+S);Z=h(a,o+$);o=h(a,o+aa);THREE.Loader.prototype.f4n(w,D,
u,y,B,G,L,N,Y,Z,o)}function t(o){var u,y;u=h(a,o);y=h(a,o+ba);o=h(a,o+ca);THREE.Loader.prototype.uv3(w.uvs,E[u*2],E[u*2+1],E[y*2],E[y*2+1],E[o*2],E[o*2+1])}function z(o){var u,y,B;u=h(a,o);y=h(a,o+da);B=h(a,o+ea);o=h(a,o+fa);THREE.Loader.prototype.uv4(w.uvs,E[u*2],E[u*2+1],E[y*2],E[y*2+1],E[B*2],E[B*2+1],E[o*2],E[o*2+1])}var w=this,x=0,k,D=[],E=[],J,A,C,H,I,K,M,F,P,Q,R,S,$,aa,ba,ca,da,ea,fa,T,U,V,W,X,O;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(w,f,c);k={signature:a.substr(x,
8),header_bytes:m(a,x+8),vertex_coordinate_bytes:m(a,x+9),normal_coordinate_bytes:m(a,x+10),uv_coordinate_bytes:m(a,x+11),vertex_index_bytes:m(a,x+12),normal_index_bytes:m(a,x+13),uv_index_bytes:m(a,x+14),material_index_bytes:m(a,x+15),nvertices:h(a,x+16),nnormals:h(a,x+16+4),nuvs:h(a,x+16+8),ntri_flat:h(a,x+16+12),ntri_smooth:h(a,x+16+16),ntri_flat_uv:h(a,x+16+20),ntri_smooth_uv:h(a,x+16+24),nquad_flat:h(a,x+16+28),nquad_smooth:h(a,x+16+32),nquad_flat_uv:h(a,x+16+36),nquad_smooth_uv:h(a,x+16+40)};
x+=k.header_bytes;J=k.vertex_index_bytes;A=k.vertex_index_bytes*2;C=k.vertex_index_bytes*3;H=k.vertex_index_bytes*3+k.material_index_bytes;I=k.vertex_index_bytes*3+k.material_index_bytes+k.normal_index_bytes;K=k.vertex_index_bytes*3+k.material_index_bytes+k.normal_index_bytes*2;M=k.vertex_index_bytes;F=k.vertex_index_bytes*2;P=k.vertex_index_bytes*3;Q=k.vertex_index_bytes*4;R=k.vertex_index_bytes*4+k.material_index_bytes;S=k.vertex_index_bytes*4+k.material_index_bytes+k.normal_index_bytes;$=k.vertex_index_bytes*
4+k.material_index_bytes+k.normal_index_bytes*2;aa=k.vertex_index_bytes*4+k.material_index_bytes+k.normal_index_bytes*3;ba=k.uv_index_bytes;ca=k.uv_index_bytes*2;da=k.uv_index_bytes;ea=k.uv_index_bytes*2;fa=k.uv_index_bytes*3;c=k.vertex_index_bytes*3+k.material_index_bytes;O=k.vertex_index_bytes*4+k.material_index_bytes;T=k.ntri_flat*c;U=k.ntri_smooth*(c+k.normal_index_bytes*3);V=k.ntri_flat_uv*(c+k.uv_index_bytes*3);W=k.ntri_smooth_uv*(c+k.normal_index_bytes*3+k.uv_index_bytes*3);X=k.nquad_flat*
O;c=k.nquad_smooth*(O+k.normal_index_bytes*4);O=k.nquad_flat_uv*(O+k.uv_index_bytes*4);x+=function(o){for(var u,y,B,G=k.vertex_coordinate_bytes*3,L=o+k.nvertices*G;o<L;o+=G){u=e(a,o);y=e(a,o+k.vertex_coordinate_bytes);B=e(a,o+k.vertex_coordinate_bytes*2);THREE.Loader.prototype.v(w,u,y,B)}return k.nvertices*G}(x);x+=function(o){for(var u,y,B,G=k.normal_coordinate_bytes*3,L=o+k.nnormals*G;o<L;o+=G){u=l(a,o);y=l(a,o+k.normal_coordinate_bytes);B=l(a,o+k.normal_coordinate_bytes*2);D.push(u/127,y/127,B/
127)}return k.nnormals*G}(x);x+=function(o){for(var u,y,B=k.uv_coordinate_bytes*2,G=o+k.nuvs*B;o<G;o+=B){u=e(a,o);y=e(a,o+k.uv_coordinate_bytes);E.push(u,y)}return k.nuvs*B}(x);T=x+T;U=T+U;V=U+V;W=V+W;X=W+X;c=X+c;O=c+O;(function(o){var u,y=k.vertex_index_bytes*3+k.material_index_bytes,B=y+k.uv_index_bytes*3,G=o+k.ntri_flat_uv*B;for(u=o;u<G;u+=B){v(u);t(u+y)}return G-o})(U);(function(o){var u,y=k.vertex_index_bytes*3+k.material_index_bytes+k.normal_index_bytes*3,B=y+k.uv_index_bytes*3,G=o+k.ntri_smooth_uv*
B;for(u=o;u<G;u+=B){q(u);t(u+y)}return G-o})(V);(function(o){var u,y=k.vertex_index_bytes*4+k.material_index_bytes,B=y+k.uv_index_bytes*4,G=o+k.nquad_flat_uv*B;for(u=o;u<G;u+=B){n(u);z(u+y)}return G-o})(c);(function(o){var u,y=k.vertex_index_bytes*4+k.material_index_bytes+k.normal_index_bytes*4,B=y+k.uv_index_bytes*4,G=o+k.nquad_smooth_uv*B;for(u=o;u<G;u+=B){p(u);z(u+y)}return G-o})(O);(function(o){var u,y=k.vertex_index_bytes*3+k.material_index_bytes,B=o+k.ntri_flat*y;for(u=o;u<B;u+=y)v(u);return B-
o})(x);(function(o){var u,y=k.vertex_index_bytes*3+k.material_index_bytes+k.normal_index_bytes*3,B=o+k.ntri_smooth*y;for(u=o;u<B;u+=y)q(u);return B-o})(T);(function(o){var u,y=k.vertex_index_bytes*4+k.material_index_bytes,B=o+k.nquad_flat*y;for(u=o;u<B;u+=y)n(u);return B-o})(W);(function(o){var u,y=k.vertex_index_bytes*4+k.material_index_bytes+k.normal_index_bytes*4,B=o+k.nquad_smooth*y;for(u=o;u<B;u+=y)p(u);return B-o})(X);this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};
g.prototype=new THREE.Geometry;g.prototype.constructor=g;d(new g(b))},createModel:function(a,d,b){var f=function(g){var c=this;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(c,a.materials,g);(function(){var e,h,j,l,m;e=0;for(h=a.vertices.length;e<h;e+=3){j=a.vertices[e];l=a.vertices[e+1];m=a.vertices[e+2];THREE.Loader.prototype.v(c,j,l,m)}if(a.colors){e=0;for(h=a.colors.length;e<h;e+=3){j=a.colors[e];l=a.colors[e+1];m=a.colors[e+2];THREE.Loader.prototype.vc(c,j,l,m)}}})();(function(){function e(p,
t){THREE.Loader.prototype.f3(c,p[t],p[t+1],p[t+2],p[t+3])}function h(p,t){THREE.Loader.prototype.f3n(c,a.normals,p[t],p[t+1],p[t+2],p[t+3],p[t+4],p[t+5],p[t+6])}function j(p,t){THREE.Loader.prototype.f4(c,p[t],p[t+1],p[t+2],p[t+3],p[t+4])}function l(p,t){THREE.Loader.prototype.f4n(c,a.normals,p[t],p[t+1],p[t+2],p[t+3],p[t+4],p[t+5],p[t+6],p[t+7],p[t+8])}function m(p,t){var z,w,x,k,D,E,J,A,C;z=p[t];w=p[t+1];x=p[t+2];k=a.uvs[z*2];J=a.uvs[z*2+1];D=a.uvs[w*2];A=a.uvs[w*2+1];E=a.uvs[x*2];C=a.uvs[x*2+1];
THREE.Loader.prototype.uv3(c.uvs,k,J,D,A,E,C);if(a.uvs2&&a.uvs2.length){k=a.uvs2[z*2];J=a.uvs2[z*2+1];D=a.uvs2[w*2];A=a.uvs2[w*2+1];E=a.uvs2[x*2];C=a.uvs2[x*2+1];THREE.Loader.prototype.uv3(c.uvs2,k,1-J,D,1-A,E,1-C)}}function v(p,t){var z,w,x,k,D,E,J,A,C,H,I,K;z=p[t];w=p[t+1];x=p[t+2];k=p[t+3];D=a.uvs[z*2];C=a.uvs[z*2+1];E=a.uvs[w*2];H=a.uvs[w*2+1];J=a.uvs[x*2];I=a.uvs[x*2+1];A=a.uvs[k*2];K=a.uvs[k*2+1];THREE.Loader.prototype.uv4(c.uvs,D,C,E,H,J,I,A,K);if(a.uvs2){D=a.uvs2[z*2];C=a.uvs2[z*2+1];E=a.uvs2[w*
2];H=a.uvs2[w*2+1];J=a.uvs2[x*2];I=a.uvs2[x*2+1];A=a.uvs2[k*2];K=a.uvs2[k*2+1];THREE.Loader.prototype.uv4(c.uvs2,D,1-C,E,1-H,J,1-I,A,1-K)}}var q,n;q=0;for(n=a.trianglesUvs.length;q<n;q+=7){e(a.trianglesUvs,q);m(a.trianglesUvs,q+4)}q=0;for(n=a.trianglesNormalsUvs.length;q<n;q+=10){h(a.trianglesNormalsUvs,q);m(a.trianglesNormalsUvs,q+7)}q=0;for(n=a.quadsUvs.length;q<n;q+=9){j(a.quadsUvs,q);v(a.quadsUvs,q+5)}q=0;for(n=a.quadsNormalsUvs.length;q<n;q+=13){l(a.quadsNormalsUvs,q);v(a.quadsNormalsUvs,q+9)}q=
0;for(n=a.triangles.length;q<n;q+=4)e(a.triangles,q);q=0;for(n=a.trianglesNormals.length;q<n;q+=7)h(a.trianglesNormals,q);q=0;for(n=a.quads.length;q<n;q+=5)j(a.quads,q);q=0;for(n=a.quadsNormals.length;q<n;q+=9)l(a.quadsNormals,q)})();(function(){var e,h,j,l;if(a.skinWeights){e=0;for(h=a.skinWeights.length;e<h;e+=2){j=a.skinWeights[e];l=a.skinWeights[e+1];THREE.Loader.prototype.sw(c,j,l,0,0)}}if(a.skinIndices){e=0;for(h=a.skinIndices.length;e<h;e+=2){j=a.skinIndices[e];l=a.skinIndices[e+1];THREE.Loader.prototype.si(c,
j,l,0,0)}}THREE.Loader.prototype.bones(c,a.bones);THREE.Loader.prototype.animation(c,a.animation)})();this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;d(new f(b))},bones:function(a,d){a.bones=d},animation:function(a,d){a.animation=d},si:function(a,d,b,f,g){a.skinIndices.push(new THREE.Vector4(d,b,f,g))},sw:function(a,d,b,f,g){a.skinWeights.push(new THREE.Vector4(d,b,f,g))},v:function(a,d,b,f){a.vertices.push(new THREE.Vertex(new THREE.Vector3(d,
b,f)))},vc:function(a,d,b,f){var g=new THREE.Color(16777215);g.setRGB(d,b,f);a.colors.push(g)},f3:function(a,d,b,f,g){a.faces.push(new THREE.Face3(d,b,f,null,a.materials[g]))},f4:function(a,d,b,f,g,c){a.faces.push(new THREE.Face4(d,b,f,g,null,a.materials[c]))},f3n:function(a,d,b,f,g,c,e,h,j){c=a.materials[c];var l=d[h*3],m=d[h*3+1];h=d[h*3+2];var v=d[j*3],q=d[j*3+1];j=d[j*3+2];a.faces.push(new THREE.Face3(b,f,g,[new THREE.Vector3(d[e*3],d[e*3+1],d[e*3+2]),new THREE.Vector3(l,m,h),new THREE.Vector3(v,
q,j)],c))},f4n:function(a,d,b,f,g,c,e,h,j,l,m){e=a.materials[e];var v=d[j*3],q=d[j*3+1];j=d[j*3+2];var n=d[l*3],p=d[l*3+1];l=d[l*3+2];var t=d[m*3],z=d[m*3+1];m=d[m*3+2];a.faces.push(new THREE.Face4(b,f,g,c,[new THREE.Vector3(d[h*3],d[h*3+1],d[h*3+2]),new THREE.Vector3(v,q,j),new THREE.Vector3(n,p,l),new THREE.Vector3(t,z,m)],e))},uv3:function(a,d,b,f,g,c,e){var h=[];h.push(new THREE.UV(d,b));h.push(new THREE.UV(f,g));h.push(new THREE.UV(c,e));a.push(h)},uv4:function(a,d,b,f,g,c,e,h,j){var l=[];l.push(new THREE.UV(d,
b));l.push(new THREE.UV(f,g));l.push(new THREE.UV(c,e));l.push(new THREE.UV(h,j));a.push(l)},init_materials:function(a,d,b){a.materials=[];for(var f=0;f<d.length;++f)a.materials[f]=[THREE.Loader.prototype.createMaterial(d[f],b)]},createMaterial:function(a,d){function b(h){h=Math.log(h)/Math.LN2;return Math.floor(h)==h}function f(h,j){var l=new Image;l.onload=function(){if(!b(this.width)||!b(this.height)){var m=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),v=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));h.image.width=m;h.image.height=v;h.image.getContext("2d").drawImage(this,0,0,m,v)}else h.image=this;h.needsUpdate=!0};l.src=j}var g,c,e;g="MeshLambertMaterial";c={color:15658734,opacity:1,map:null,lightMap:null,vertexColors:a.vertexColors};a.shading&&a.shading=="Phong"&&(g="MeshPhongMaterial");if(a.mapDiffuse&&d){e=document.createElement("canvas");c.map=new THREE.Texture(e);f(c.map,d+"/"+a.mapDiffuse)}else if(a.colorDiffuse){e=(a.colorDiffuse[0]*255<<16)+(a.colorDiffuse[1]*255<<8)+a.colorDiffuse[2]*
255;c.color=e;c.opacity=a.transparency}else if(a.DbgColor)c.color=a.DbgColor;if(a.mapLightmap&&d){e=document.createElement("canvas");c.lightMap=new THREE.Texture(e);f(c.lightMap,d+"/"+a.mapLightmap)}return new THREE[g](c)},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")}};
