// ThreeCanvas.js r33 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,c){var d,e,f,h,j,g;if(c==0)d=e=f=0;else{h=Math.floor(a*6);j=a*6-h;a=c*(1-b);g=c*(1-b*j);b=c*(1-b*(1-j));switch(h){case 1:d=g;e=c;f=a;break;case 2:d=a;e=c;f=b;break;case 3:d=a;e=g;f=c;break;case 4:d=b;e=a;f=c;break;case 5:d=c;e=a;f=g;break;case 6:case 0:d=c;e=b;f=a}}this.r=d;this.g=e;this.b=f;if(this.autoUpdate){this.updateHex();
this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.set(c*a.z-d*a.y,d*a.x-b*a.z,b*a.y-c*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,c,d=a.objects,e=[];a=0;for(b=d.length;a<b;a++){c=d[a];c instanceof THREE.Mesh&&(e=e.concat(this.intersectObject(c)))}e.sort(function(f,h){return f.distance-h.distance});return e},intersectObject:function(a){function b(r,k,D,C){C=C.clone().subSelf(k);D=D.clone().subSelf(k);var I=r.clone().subSelf(k);r=C.dot(C);k=C.dot(D);C=C.dot(I);var F=D.dot(D);D=D.dot(I);I=1/(r*F-k*k);F=(F*C-k*D)*I;r=(r*D-k*C)*I;return F>0&&r>0&&F+r<1}var c,d,e,f,h,j,g,i,n,l,
o,q=a.geometry,s=q.vertices,t=[];c=0;for(d=q.faces.length;c<d;c++){e=q.faces[c];l=this.origin.clone();o=this.direction.clone();g=a.matrixWorld;f=g.multiplyVector3(s[e.a].position.clone());h=g.multiplyVector3(s[e.b].position.clone());j=g.multiplyVector3(s[e.c].position.clone());g=e instanceof THREE.Face4?g.multiplyVector3(s[e.d].position.clone()):null;i=a.matrixRotationWorld.multiplyVector3(e.normal.clone());n=o.dot(i);if(n<0){i=i.dot((new THREE.Vector3).sub(f,l))/n;l=l.addSelf(o.multiplyScalar(i));
if(e instanceof THREE.Face3){if(b(l,f,h,j)){e={distance:this.origin.distanceTo(l),point:l,face:e,object:a};t.push(e)}}else if(e instanceof THREE.Face4&&(b(l,f,h,g)||b(l,h,j,g))){e={distance:this.origin.distanceTo(l),point:l,face:e,object:a};t.push(e)}}}return t}};
THREE.Rectangle=function(){function a(){f=d-b;h=e-c}var b,c,d,e,f,h,j=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(g,i,n,l){j=!1;b=g;c=i;d=n;e=l;a()};this.addPoint=function(g,i){if(j){j=!1;b=g;c=i;d=g;e=i}else{b=b<g?b:g;c=c<i?c:i;d=d>g?d:g;e=e>i?e:i}a()};
this.add3Points=function(g,i,n,l,o,q){if(j){j=!1;b=g<n?g<o?g:o:n<o?n:o;c=i<l?i<q?i:q:l<q?l:q;d=g>n?g>o?g:o:n>o?n:o;e=i>l?i>q?i:q:l>q?l:q}else{b=g<n?g<o?g<b?g:b:o<b?o:b:n<o?n<b?n:b:o<b?o:b;c=i<l?i<q?i<c?i:c:q<c?q:c:l<q?l<c?l:c:q<c?q:c;d=g>n?g>o?g>d?g:d:o>d?o:d:n>o?n>d?n:d:o>d?o:d;e=i>l?i>q?i>e?i:e:q>e?q:e:l>q?l>e?l:e:q>e?q:e}a()};this.addRectangle=function(g){if(j){j=!1;b=g.getLeft();c=g.getTop();d=g.getRight();e=g.getBottom()}else{b=b<g.getLeft()?b:g.getLeft();c=c<g.getTop()?c:g.getTop();d=d>g.getRight()?
d:g.getRight();e=e>g.getBottom()?e:g.getBottom()}a()};this.inflate=function(g){b-=g;c-=g;d+=g;e+=g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();d=d<g.getRight()?d:g.getRight();e=e<g.getBottom()?e:g.getBottom();a()};this.instersects=function(g){return Math.min(d,g.getRight())-Math.max(b,g.getLeft())>=0&&Math.min(e,g.getBottom())-Math.max(c,g.getTop())>=0};this.empty=function(){j=!0;e=d=c=b=0;a()};this.isEmpty=function(){return j}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,f,h,j,g,i,n,l,o,q,s,t){this.set(a||1,b||0,c||0,d||0,e||0,f||1,h||0,j||0,g||0,i||0,n||1,l||0,o||0,q||0,s||0,t||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,f,h,j,g,i,n,l,o,q,s,t){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=h;this.n24=j;this.n31=g;this.n32=i;this.n33=n;this.n34=l;this.n41=o;this.n42=q;this.n43=s;this.n44=t;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__tmpVec1,
e=THREE.Matrix4.__tmpVec2,f=THREE.Matrix4.__tmpVec3;f.sub(a,b).normalize();d.cross(c,f).normalize();e.cross(f,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n14=a.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n24=a.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;this.n34=a.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*
b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector3OnlyZ:function(a){var b=a.x,c=a.y;a=a.z;return(this.n31*b+this.n32*c+this.n33*a+this.n34)*(1/(this.n41*b+this.n42*c+this.n43*a+this.n44))},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},crossVector:function(a){var b=new THREE.Vector4;
b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,h=a.n21,j=a.n22,g=a.n23,i=a.n24,n=a.n31,l=a.n32,o=a.n33,q=a.n34,s=a.n41,t=a.n42,r=a.n43,k=a.n44,D=b.n11,C=b.n12,I=b.n13,F=b.n14,N=b.n21,A=b.n22,w=b.n23,J=b.n24,u=b.n31,K=b.n32,E=b.n33,y=b.n34;this.n11=c*
D+d*N+e*u;this.n12=c*C+d*A+e*K;this.n13=c*I+d*w+e*E;this.n14=c*F+d*J+e*y+f;this.n21=h*D+j*N+g*u;this.n22=h*C+j*A+g*K;this.n23=h*I+j*w+g*E;this.n24=h*F+j*J+g*y+i;this.n31=n*D+l*N+o*u;this.n32=n*C+l*A+o*K;this.n33=n*I+l*w+o*E;this.n34=n*F+l*J+o*y+q;this.n41=s*D+t*N+r*u;this.n42=s*C+t*A+r*K;this.n43=s*I+t*w+r*E;this.n44=s*F+t*J+r*y+k;return this},multiplyToArray:function(a,b,c){var d=a.n11,e=a.n12,f=a.n13,h=a.n14,j=a.n21,g=a.n22,i=a.n23,n=a.n24,l=a.n31,o=a.n32,q=a.n33,s=a.n34,t=a.n41,r=a.n42,k=a.n43;
a=a.n44;var D=b.n11,C=b.n12,I=b.n13,F=b.n14,N=b.n21,A=b.n22,w=b.n23,J=b.n24,u=b.n31,K=b.n32,E=b.n33,y=b.n34,B=b.n41,T=b.n42,x=b.n43;b=b.n44;this.n11=d*D+e*N+f*u+h*B;this.n12=d*C+e*A+f*K+h*T;this.n13=d*I+e*w+f*E+h*x;this.n14=d*F+e*J+f*y+h*b;this.n21=j*D+g*N+i*u+n*B;this.n22=j*C+g*A+i*K+n*T;this.n23=j*I+g*w+i*E+n*x;this.n24=j*F+g*J+i*y+n*b;this.n31=l*D+o*N+q*u+s*B;this.n32=l*C+o*A+q*K+s*T;this.n33=l*I+o*w+q*E+s*x;this.n34=l*F+o*J+q*y+s*b;this.n41=t*D+r*N+k*u+a*B;this.n42=t*C+r*A+k*K+a*T;this.n43=t*
I+r*w+k*E+a*x;this.n44=t*F+r*J+k*y+a*b;c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){var b=this.n11,c=this.n12,d=this.n13,e=this.n14,f=this.n21,h=this.n22,j=this.n23,g=this.n24,i=this.n31,n=this.n32,l=this.n33,o=this.n34,q=this.n41,s=this.n42,t=this.n43,r=this.n44,k=a.n11,D=a.n21,
C=a.n31,I=a.n12,F=a.n22,N=a.n32,A=a.n13,w=a.n23,J=a.n33,u=a.n14,K=a.n24;a=a.n34;this.n11=b*k+c*D+d*C;this.n12=b*I+c*F+d*N;this.n13=b*A+c*w+d*J;this.n14=b*u+c*K+d*a+e;this.n21=f*k+h*D+j*C;this.n22=f*I+h*F+j*N;this.n23=f*A+h*w+j*J;this.n24=f*u+h*K+j*a+g;this.n31=i*k+n*D+l*C;this.n32=i*I+n*F+l*N;this.n33=i*A+n*w+l*J;this.n34=i*u+n*K+l*a+o;this.n41=q*k+s*D+t*C;this.n42=q*I+s*F+t*N;this.n43=q*A+s*w+t*J;this.n44=q*u+s*K+t*a+r;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=
a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,h=this.n23,j=this.n24,g=this.n31,i=this.n32,n=this.n33,l=this.n34,o=this.n41,q=this.n42,s=this.n43,t=this.n44;return d*h*i*o-c*j*i*o-d*f*n*o+b*j*n*o+c*f*l*o-b*h*l*o-d*h*g*q+c*j*g*q+d*e*n*q-a*j*n*q-c*e*l*q+a*h*l*q+d*f*g*s-b*j*g*s-d*e*i*s+a*j*i*s+b*e*
l*s-a*f*l*s-c*f*g*t+b*h*g*t+c*e*i*t-a*h*i*t-b*e*n*t+a*f*n*t},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;
a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flattenToArray(this.flat);return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=
this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,
b,-a,0,0,a,b,0,0,0,0,1);return this},setRotY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,h=a.y,j=a.z,g=e*f,i=e*h;this.set(g*f+c,g*h-d*j,g*j+d*h,0,g*h+d*j,i*h+c,i*j-d*f,0,g*j-d*h,i*j+d*f,e*j*j+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;
this.n34=a.z;return this},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z;a=Math.cos(b);b=Math.sin(b);var e=Math.cos(c);c=Math.sin(c);var f=Math.cos(d);d=Math.sin(d);var h=a*c,j=b*c;this.n11=e*f;this.n12=-e*d;this.n13=c;this.n21=j*f+a*d;this.n22=-j*d+a*f;this.n23=-b*e;this.n31=-h*f+b*d;this.n32=h*d+b*f;this.n33=a*e},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,h=c+c,j=d+d;a=b*f;var g=b*h;b*=j;var i=c*h;c*=j;d*=j;f*=e;h*=e;e*=j;this.n11=1-(i+d);this.n12=g-e;this.n13=
b+h;this.n21=g+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-h;this.n32=c+f;this.n33=1-(a+i)},scale:function(a){var b=a.x,c=a.y;a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this}};THREE.Matrix4.translationMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setTranslation(a,b,c);return d};THREE.Matrix4.scaleMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setScale(a,b,c);return d};
THREE.Matrix4.rotationXMatrix=function(a){var b=new THREE.Matrix4;b.setRotX(a);return b};THREE.Matrix4.rotationYMatrix=function(a){var b=new THREE.Matrix4;b.setRotY(a);return b};THREE.Matrix4.rotationZMatrix=function(a){var b=new THREE.Matrix4;b.setRotZ(a);return b};THREE.Matrix4.rotationAxisAngleMatrix=function(a,b){var c=new THREE.Matrix4;c.setRotAxis(a,b);return c};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,h=a.n21,j=a.n22,g=a.n23,i=a.n24,n=a.n31,l=a.n32,o=a.n33,q=a.n34,s=a.n41,t=a.n42,r=a.n43,k=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=g*q*t-i*o*t+i*l*r-j*q*r-g*l*k+j*o*k;b.n12=f*o*t-e*q*t-f*l*r+d*q*r+e*l*k-d*o*k;b.n13=e*i*t-f*g*t+f*j*r-d*i*r-e*j*k+d*g*k;b.n14=f*g*l-e*i*l-f*j*o+d*i*o+e*j*q-d*g*q;b.n21=i*o*s-g*q*s-i*n*r+h*q*r+g*n*k-h*o*k;b.n22=e*q*s-f*o*s+f*n*r-c*q*r-e*n*k+c*o*k;b.n23=f*g*s-e*i*s-f*h*r+c*i*r+e*h*k-c*g*k;
b.n24=e*i*n-f*g*n+f*h*o-c*i*o-e*h*q+c*g*q;b.n31=j*q*s-i*l*s+i*n*t-h*q*t-j*n*k+h*l*k;b.n32=f*l*s-d*q*s-f*n*t+c*q*t+d*n*k-c*l*k;b.n33=e*i*s-f*j*s+f*h*t-c*i*t-d*h*k+c*j*k;b.n34=f*j*n-d*i*n-f*h*l+c*i*l+d*h*q-c*j*q;b.n41=g*l*s-j*o*s-g*n*t+h*o*t+j*n*r-h*l*r;b.n42=d*o*s-e*l*s+e*n*t-c*o*t-d*n*r+c*l*r;b.n43=e*j*s-d*g*s-e*h*t+c*g*t+d*h*r-c*j*r;b.n44=d*g*n-e*j*n+e*h*l-c*g*l-d*h*o+c*j*o;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,j=a.n33*a.n11-a.n31*a.n13,g=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,n=-a.n23*a.n11+a.n21*a.n13,l=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*h+a.n31*i;if(a==0)throw"matrix not invertible";a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*h;c[4]=a*j;c[5]=a*g;c[6]=a*i;c[7]=a*n;c[8]=a*l;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var h;h=new THREE.Matrix4;h.n11=2*e/(b-a);h.n12=0;h.n13=(b+a)/(b-a);h.n14=0;h.n21=0;h.n22=2*e/(d-c);h.n23=(d+c)/(d-c);h.n24=0;h.n31=0;h.n32=0;h.n33=-(f+e)/(f-e);h.n34=-2*f*e/(f-e);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,b,c,d){var e;a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var h,j,g,i;h=new THREE.Matrix4;j=b-a;g=c-d;i=f-e;h.n11=2/j;h.n12=0;h.n13=0;h.n14=-((b+a)/j);h.n21=0;h.n22=2/g;h.n23=0;h.n24=-((c+d)/g);h.n31=0;h.n32=0;h.n33=-2/i;h.n34=-((f+e)/i);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__tmpVec1=new THREE.Vector3;THREE.Matrix4.__tmpVec2=new THREE.Vector3;THREE.Matrix4.__tmpVec3=new THREE.Vector3;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.parent=undefined;this.children=[];this.position=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixNeedsUpdate=!0;this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;
this.visible=!0};
THREE.Object3D.prototype={addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b instanceof THREE.Scene===!1&&b!==undefined;)b=b.parent;b!==undefined&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);
if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}return!0},update:function(a,b,c){if(this.visible){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);b=1/this.scale.x;a=1/this.scale.y;var d=1/this.scale.z;this.matrixRotationWorld.n11=this.matrixWorld.n11*b;this.matrixRotationWorld.n21=
this.matrixWorld.n21*b;this.matrixRotationWorld.n31=this.matrixWorld.n31*b;this.matrixRotationWorld.n12=this.matrixWorld.n12*a;this.matrixRotationWorld.n22=this.matrixWorld.n22*a;this.matrixRotationWorld.n32=this.matrixWorld.n32*a;this.matrixRotationWorld.n13=this.matrixWorld.n13*d;this.matrixRotationWorld.n23=this.matrixWorld.n23*d;this.matrixRotationWorld.n33=this.matrixWorld.n33*d;this.matrixNeedsUpdate=!1;b=!0}a=0;for(d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}}};
THREE.Object3DCounter={value:0};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b;a=Math.cos(d);d=Math.sin(d);b=Math.cos(-e);e=Math.sin(-e);var f=Math.cos(c);c=Math.sin(c);var h=a*b,j=d*e;this.w=h*f-j*c;this.x=h*c+j*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,f=a.x,h=a.y,j=a.z;a=a.w;this.x=b*a+e*f+c*j-d*h;this.y=c*a+e*h+d*f-b*j;this.z=d*a+e*j+b*h-c*f;this.w=e*a-b*f-c*h-d*j;return this},
multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,h=this.y,j=this.z,g=this.w,i=g*c+h*e-j*d,n=g*d+j*c-f*e,l=g*e+f*d-h*c;c=-f*c-h*d-j*e;b.x=i*g+c*-f+n*-j-l*-h;b.y=n*g+c*-h+l*-f-i*-j;b.z=l*g+c*-j+i*-h-n*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var f=Math.acos(e),h=Math.sqrt(1-e*e);if(Math.abs(h)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}e=Math.sin((1-d)*f)/h;d=Math.sin(d*f)/h;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};
THREE.Vertex=function(a,b){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=b||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=!0};
THREE.Face3=function(a,b,c,d,e){this.a=a;this.b=b;this.c=c;this.centroid=new THREE.Vector3;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.materials=e instanceof Array?e:[e]};THREE.Face4=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.d=d;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=f instanceof Array?f:[f]};
THREE.UV=function(a,b){this.set(a||0,b||0)};THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.faces=[];this.uvs=[];this.uvs2=[];this.colors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,c,d,e,f,h,j=new THREE.Vector3,g=new THREE.Vector3;d=0;for(e=this.vertices.length;d<e;d++){f=this.vertices[d];f.normal.set(0,0,0)}d=0;for(e=this.faces.length;d<e;d++){f=this.faces[d];if(a&&f.vertexNormals.length){j.set(0,0,0);b=0;for(c=f.normal.length;b<c;b++)j.addSelf(f.vertexNormals[b]);j.divideScalar(3)}else{b=this.vertices[f.a];c=this.vertices[f.b];h=this.vertices[f.c];j.sub(h.position,
c.position);g.sub(b.position,c.position);j.crossSelf(g)}j.isZero()||j.normalize();f.normal.copy(j)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,
new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<
b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeTangents:function(){function a(y,B,T,x,P,Y,L){f=y.vertices[B].position;h=y.vertices[T].position;j=y.vertices[x].position;g=e[P];i=e[Y];n=e[L];l=h.x-f.x;o=j.x-f.x;q=h.y-f.y;s=j.y-f.y;
t=h.z-f.z;r=j.z-f.z;k=i.u-g.u;D=n.u-g.u;C=i.v-g.v;I=n.v-g.v;F=1/(k*I-D*C);w.set((I*l-C*o)*F,(I*q-C*s)*F,(I*t-C*r)*F);J.set((k*o-D*l)*F,(k*s-D*q)*F,(k*r-D*t)*F);N[B].addSelf(w);N[T].addSelf(w);N[x].addSelf(w);A[B].addSelf(J);A[T].addSelf(J);A[x].addSelf(J)}var b,c,d,e,f,h,j,g,i,n,l,o,q,s,t,r,k,D,C,I,F,N=[],A=[],w=new THREE.Vector3,J=new THREE.Vector3,u=new THREE.Vector3,K=new THREE.Vector3,E=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++){N[b]=new THREE.Vector3;A[b]=new THREE.Vector3}b=0;
for(c=this.faces.length;b<c;b++){d=this.faces[b];e=this.uvs[b];if(d instanceof THREE.Face3){a(this,d.a,d.b,d.c,0,1,2);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2])}else if(d instanceof THREE.Face4){a(this,d.a,d.b,d.c,0,1,2);a(this,d.a,d.b,d.d,0,1,3);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2]);
this.vertices[d.d].normal.copy(d.vertexNormals[3])}}b=0;for(c=this.vertices.length;b<c;b++){E.copy(this.vertices[b].normal);d=N[b];u.copy(d);u.subSelf(E.multiplyScalar(E.dot(d))).normalize();K.cross(this.vertices[b].normal,d);d=K.dot(A[b]);d=d<0?-1:1;this.vertices[b].tangent.set(u.x,u.y,u.z,d)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],
z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>
this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(n){var l=[];b=0;for(c=n.length;b<c;b++)n[b]==undefined?l.push("undefined"):l.push(n[b].id);return l.join("_")}var b,c,d,e,f,h,j,g,i={};d=0;for(e=this.faces.length;d<e;d++){f=this.faces[d];
h=f.materials;j=a(h);i[j]==undefined&&(i[j]={hash:j,counter:0});g=i[j].hash+"_"+i[j].counter;this.geometryChunks[g]==undefined&&(this.geometryChunks[g]={faces:[],materials:h,vertices:0});f=f instanceof THREE.Face3?3:4;if(this.geometryChunks[g].vertices+f>65535){i[j].counter+=1;g=i[j].hash+"_"+i[j].counter;this.geometryChunks[g]==undefined&&(this.geometryChunks[g]={faces:[],materials:h,vertices:0})}this.geometryChunks[g].faces.push(d);this.geometryChunks[g].vertices+=f}}};THREE.GeometryIdCounter=0;
THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.up=new THREE.Vector3(0,1,0);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.tmpVec=new THREE.Vector3;this.translateX=function(f,h){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(f);this.tmpVec.crossSelf(this.up);if(h)this.tmpVec.y=0;this.position.addSelf(this.tmpVec);
this.target.position.addSelf(this.tmpVec)};this.translateZ=function(f,h){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(f);if(h)this.tmpVec.y=0;this.position.subSelf(this.tmpVec);this.target.position.subSelf(this.tmpVec)};this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,
this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.FlatShading=0;THREE.SmoothShading=1;
THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.BillboardBlending=3;THREE.ReverseSubtractiveBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==
undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==
undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==
undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};THREE.ParticleCircleMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.Texture=function(a,b,c,d,e,f){this.image=a;this.mapping=b!==undefined?b:new THREE.UVMapping;this.wrapS=c!==undefined?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==undefined?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==undefined?e:THREE.LinearFilter;this.minFilter=f!==undefined?f:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};
THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;
THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var e;c=this.sources.length;for(a=0;a<c;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)e=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)e="audio/ogg";else b.indexOf(".wav")!==-1&&(e="audio/wav");if(this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Scene=function(){THREE.Object3D.call(this);this.objects=[];this.lights=[];this.sounds=[];this.fog=null;this.matrixAutoUpdate=!1};
THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else a instanceof THREE.Camera||a instanceof THREE.Bone||this.objects.indexOf(a)===-1&&this.objects.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};
THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);b!==-1&&this.objects.splice(b,1)}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(A,w){return w.z-A.z}function b(A,w){var J=0,u=1,K=A.z+A.w,E=w.z+w.w,y=-A.z+A.w,B=-w.z+w.w;if(K>=0&&E>=0&&y>=0&&B>=0)return!0;else if(K<0&&E<0||y<0&&B<0)return!1;else{if(K<0)J=Math.max(J,K/(K-E));else E<0&&(u=Math.min(u,K/(K-E)));if(y<0)J=Math.max(J,y/(y-B));else B<0&&(u=Math.min(u,y/(y-B)));if(u<J)return!1;else{A.lerpSelf(w,J);w.lerpSelf(A,1-u);return!0}}}var c,d,e=[],f,h,j,g=[],i,n,l=[],o,q,s=[],t=new THREE.Vector4,r=new THREE.Vector4,k=new THREE.Matrix4,D=new THREE.Matrix4,
C=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],I=new THREE.Vector4,F=new THREE.Vector4,N;this.projectObjects=function(A,w,J){w=[];var u,K,E;d=0;K=A.objects;A=0;for(u=K.length;A<u;A++){E=K[A];var y;if(!(y=!E.visible))if(y=E instanceof THREE.Mesh){a:{y=void 0;for(var B=E.matrixWorld,T=-E.geometry.boundingSphere.radius*Math.max(E.scale.x,Math.max(E.scale.y,E.scale.z)),x=0;x<6;x++){y=C[x].x*B.n14+C[x].y*B.n24+C[x].z*B.n34+C[x].w;if(y<=T){y=
!1;break a}}y=!0}y=!y}if(!y){c=e[d]=e[d]||new THREE.RenderableObject;t.copy(E.position);k.multiplyVector3(t);c.object=E;c.z=t.z;w.push(c);d++}}J&&w.sort(a);return w};this.projectScene=function(A,w,J){var u=[],K=w.near,E=w.far,y,B,T,x,P,Y,L,ja,ka,la,ma,$,O,H,U,Q;j=n=q=0;w.matrixAutoUpdate&&w.update();k.multiply(w.projectionMatrix,w.matrixWorldInverse);C[0].set(k.n41-k.n11,k.n42-k.n12,k.n43-k.n13,k.n44-k.n14);C[1].set(k.n41+k.n11,k.n42+k.n12,k.n43+k.n13,k.n44+k.n14);C[2].set(k.n41+k.n21,k.n42+k.n22,
k.n43+k.n23,k.n44+k.n24);C[3].set(k.n41-k.n21,k.n42-k.n22,k.n43-k.n23,k.n44-k.n24);C[4].set(k.n41-k.n31,k.n42-k.n32,k.n43-k.n33,k.n44-k.n34);C[5].set(k.n41+k.n31,k.n42+k.n32,k.n43+k.n33,k.n44+k.n34);for(y=0;y<6;y++){Y=C[y];Y.divideScalar(Math.sqrt(Y.x*Y.x+Y.y*Y.y+Y.z*Y.z))}A.update(undefined,!1,w);Y=this.projectObjects(A,w,!0);A=0;for(y=Y.length;A<y;A++){L=Y[A].object;if(L.visible){ja=L.matrixWorld;ma=L.matrixRotationWorld;ka=L.materials;la=L.overdraw;if(L instanceof THREE.Mesh){$=L.geometry;O=$.vertices;
B=0;for(T=O.length;B<T;B++){H=O[B];H.positionWorld.copy(H.position);ja.multiplyVector3(H.positionWorld);x=H.positionScreen;x.copy(H.positionWorld);k.multiplyVector4(x);x.x/=x.w;x.y/=x.w;H.__visible=x.z>K&&x.z<E}$=$.faces;B=0;for(T=$.length;B<T;B++){H=$[B];if(H instanceof THREE.Face3){x=O[H.a];P=O[H.b];U=O[H.c];if(x.__visible&&P.__visible&&U.__visible&&(L.doubleSided||L.flipSided!=(U.positionScreen.x-x.positionScreen.x)*(P.positionScreen.y-x.positionScreen.y)-(U.positionScreen.y-x.positionScreen.y)*
(P.positionScreen.x-x.positionScreen.x)<0)){f=g[j]=g[j]||new THREE.RenderableFace3;f.v1.positionWorld.copy(x.positionWorld);f.v2.positionWorld.copy(P.positionWorld);f.v3.positionWorld.copy(U.positionWorld);f.v1.positionScreen.copy(x.positionScreen);f.v2.positionScreen.copy(P.positionScreen);f.v3.positionScreen.copy(U.positionScreen);f.normalWorld.copy(H.normal);ma.multiplyVector3(f.normalWorld);f.centroidWorld.copy(H.centroid);ja.multiplyVector3(f.centroidWorld);f.centroidScreen.copy(f.centroidWorld);
k.multiplyVector3(f.centroidScreen);U=H.vertexNormals;N=f.vertexNormalsWorld;x=0;for(P=U.length;x<P;x++){Q=N[x]=N[x]||new THREE.Vector3;Q.copy(U[x]);ma.multiplyVector3(Q)}f.z=f.centroidScreen.z;f.meshMaterials=ka;f.faceMaterials=H.materials;f.overdraw=la;if(L.geometry.uvs[B]){f.uvs[0]=L.geometry.uvs[B][0];f.uvs[1]=L.geometry.uvs[B][1];f.uvs[2]=L.geometry.uvs[B][2]}u.push(f);j++}}else if(H instanceof THREE.Face4){x=O[H.a];P=O[H.b];U=O[H.c];Q=O[H.d];if(x.__visible&&P.__visible&&U.__visible&&Q.__visible&&
(L.doubleSided||L.flipSided!=((Q.positionScreen.x-x.positionScreen.x)*(P.positionScreen.y-x.positionScreen.y)-(Q.positionScreen.y-x.positionScreen.y)*(P.positionScreen.x-x.positionScreen.x)<0||(P.positionScreen.x-U.positionScreen.x)*(Q.positionScreen.y-U.positionScreen.y)-(P.positionScreen.y-U.positionScreen.y)*(Q.positionScreen.x-U.positionScreen.x)<0))){f=g[j]=g[j]||new THREE.RenderableFace3;f.v1.positionWorld.copy(x.positionWorld);f.v2.positionWorld.copy(P.positionWorld);f.v3.positionWorld.copy(Q.positionWorld);
f.v1.positionScreen.copy(x.positionScreen);f.v2.positionScreen.copy(P.positionScreen);f.v3.positionScreen.copy(Q.positionScreen);f.normalWorld.copy(H.normal);ma.multiplyVector3(f.normalWorld);f.centroidWorld.copy(H.centroid);ja.multiplyVector3(f.centroidWorld);f.centroidScreen.copy(f.centroidWorld);k.multiplyVector3(f.centroidScreen);f.z=f.centroidScreen.z;f.meshMaterials=ka;f.faceMaterials=H.materials;f.overdraw=la;if(L.geometry.uvs[B]){f.uvs[0]=L.geometry.uvs[B][0];f.uvs[1]=L.geometry.uvs[B][1];
f.uvs[2]=L.geometry.uvs[B][3]}u.push(f);j++;h=g[j]=g[j]||new THREE.RenderableFace3;h.v1.positionWorld.copy(P.positionWorld);h.v2.positionWorld.copy(U.positionWorld);h.v3.positionWorld.copy(Q.positionWorld);h.v1.positionScreen.copy(P.positionScreen);h.v2.positionScreen.copy(U.positionScreen);h.v3.positionScreen.copy(Q.positionScreen);h.normalWorld.copy(f.normalWorld);h.centroidWorld.copy(f.centroidWorld);h.centroidScreen.copy(f.centroidScreen);h.z=h.centroidScreen.z;h.meshMaterials=ka;h.faceMaterials=
H.materials;h.overdraw=la;if(L.geometry.uvs[B]){h.uvs[0]=L.geometry.uvs[B][1];h.uvs[1]=L.geometry.uvs[B][2];h.uvs[2]=L.geometry.uvs[B][3]}u.push(h);j++}}}}else if(L instanceof THREE.Line){D.multiply(k,ja);O=L.geometry.vertices;H=O[0];H.positionScreen.copy(H.position);D.multiplyVector4(H.positionScreen);B=1;for(T=O.length;B<T;B++){x=O[B];x.positionScreen.copy(x.position);D.multiplyVector4(x.positionScreen);P=O[B-1];I.copy(x.positionScreen);F.copy(P.positionScreen);if(b(I,F)){I.multiplyScalar(1/I.w);
F.multiplyScalar(1/F.w);i=l[n]=l[n]||new THREE.RenderableLine;i.v1.positionScreen.copy(I);i.v2.positionScreen.copy(F);i.z=Math.max(I.z,F.z);i.materials=L.materials;u.push(i);n++}}}else if(L instanceof THREE.Particle){r.set(L.position.x,L.position.y,L.position.z,1);k.multiplyVector4(r);r.z/=r.w;if(r.z>0&&r.z<1){o=s[q]=s[q]||new THREE.RenderableParticle;o.x=r.x/r.w;o.y=r.y/r.w;o.z=r.z;o.rotation=L.rotation.z;o.scale.x=L.scale.x*Math.abs(o.x-(r.x+w.projectionMatrix.n11)/(r.w+w.projectionMatrix.n14));
o.scale.y=L.scale.y*Math.abs(o.y-(r.y+w.projectionMatrix.n22)/(r.w+w.projectionMatrix.n24));o.materials=L.materials;u.push(o);q++}}}}J&&u.sort(a);return u};this.unprojectVector=function(A,w){var J=w.matrixWorld.clone();J.multiplySelf(THREE.Matrix4.makeInvert(w.projectionMatrix));J.multiplyVector3(A);return A}};
THREE.CanvasRenderer=function(){function a(V){if(o!=V)i.globalAlpha=o=V}function b(V){if(q!=V){switch(V){case THREE.NormalBlending:i.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:i.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:i.globalCompositeOperation="darker"}q=V}}var c=null,d=new THREE.Projector,e=document.createElement("canvas"),f,h,j,g,i=e.getContext("2d"),n=new THREE.Color(0),l=0,o=1,q=0,s=null,t=null,r=1,k,D,C,I,F,N,A,w,J,u=new THREE.Color,
K=new THREE.Color,E=new THREE.Color,y=new THREE.Color,B=new THREE.Color,T,x,P,Y,L,ja,ka,la,ma,$=new THREE.Rectangle,O=new THREE.Rectangle,H=new THREE.Rectangle,U=!1,Q=new THREE.Color,aa=new THREE.Color,na=new THREE.Color,oa=new THREE.Color,La=Math.PI*2,R=new THREE.Vector3,ra,sa,Ca,ba,ta,xa,pa=16;ra=document.createElement("canvas");ra.width=ra.height=2;sa=ra.getContext("2d");sa.fillStyle="rgba(0,0,0,1)";sa.fillRect(0,0,2,2);Ca=sa.getImageData(0,0,2,2);ba=Ca.data;ta=document.createElement("canvas");
ta.width=ta.height=pa;xa=ta.getContext("2d");xa.translate(-pa/2,-pa/2);xa.scale(pa,pa);pa--;this.domElement=e;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setSize=function(V,da){f=V;h=da;j=f/2;g=h/2;e.width=f;e.height=h;$.set(-j,-g,j,g);o=1;q=0;t=s=null;r=1};this.setClearColor=function(V,da){n=V;l=da;O.set(-j,-g,j,g);i.setTransform(1,0,0,-1,j,g);this.clear()};this.setClearColorHex=function(V,da){n.setHex(V);l=da;O.set(-j,-g,j,g);i.setTransform(1,0,0,-1,j,g);this.clear()};this.clear=
function(){i.setTransform(1,0,0,-1,j,g);if(!O.isEmpty()){O.inflate(1);O.minSelf($);if(n.hex==0&&l==0)i.clearRect(O.getX(),O.getY(),O.getWidth(),O.getHeight());else{b(THREE.NormalBlending);a(1);i.fillStyle="rgba("+Math.floor(n.r*255)+","+Math.floor(n.g*255)+","+Math.floor(n.b*255)+","+l+")";i.fillRect(O.getX(),O.getY(),O.getWidth(),O.getHeight())}O.empty()}};this.render=function(V,da){function Ma(m){var G,z,p,v=m.lights;aa.setRGB(0,0,0);na.setRGB(0,0,0);oa.setRGB(0,0,0);m=0;for(G=v.length;m<G;m++){z=
v[m];p=z.color;if(z instanceof THREE.AmbientLight){aa.r+=p.r;aa.g+=p.g;aa.b+=p.b}else if(z instanceof THREE.DirectionalLight){na.r+=p.r;na.g+=p.g;na.b+=p.b}else if(z instanceof THREE.PointLight){oa.r+=p.r;oa.g+=p.g;oa.b+=p.b}}}function ya(m,G,z,p){var v,M,W,X,Z=m.lights;m=0;for(v=Z.length;m<v;m++){M=Z[m];W=M.color;X=M.intensity;if(M instanceof THREE.DirectionalLight){M=z.dot(M.position)*X;if(M>0){p.r+=W.r*M;p.g+=W.g*M;p.b+=W.b*M}}else if(M instanceof THREE.PointLight){R.sub(M.position,G);R.normalize();
M=z.dot(R)*X;if(M>0){p.r+=W.r*M;p.g+=W.g*M;p.b+=W.b*M}}}}function Na(m,G,z){if(z.opacity!=0){a(z.opacity);b(z.blending);var p,v,M,W,X,Z;if(z instanceof THREE.ParticleBasicMaterial){if(z.map){W=z.map.image;X=W.width>>1;Z=W.height>>1;v=G.scale.x*j;M=G.scale.y*g;z=v*X;p=M*Z;H.set(m.x-z,m.y-p,m.x+z,m.y+p);if($.instersects(H)){i.save();i.translate(m.x,m.y);i.rotate(-G.rotation);i.scale(v,-M);i.translate(-X,-Z);i.drawImage(W,0,0);i.restore()}}}else if(z instanceof THREE.ParticleCircleMaterial){if(U){Q.r=
aa.r+na.r+oa.r;Q.g=aa.g+na.g+oa.g;Q.b=aa.b+na.b+oa.b;u.r=z.color.r*Q.r;u.g=z.color.g*Q.g;u.b=z.color.b*Q.b;u.updateStyleString()}else u.__styleString=z.color.__styleString;z=G.scale.x*j;p=G.scale.y*g;H.set(m.x-z,m.y-p,m.x+z,m.y+p);if($.instersects(H)){v=u.__styleString;if(t!=v)i.fillStyle=t=v;i.save();i.translate(m.x,m.y);i.rotate(-G.rotation);i.scale(z,p);i.beginPath();i.arc(0,0,1,0,La,!0);i.closePath();i.fill();i.restore()}}}}function Oa(m,G,z,p){if(p.opacity!=0){a(p.opacity);b(p.blending);i.beginPath();
i.moveTo(m.positionScreen.x,m.positionScreen.y);i.lineTo(G.positionScreen.x,G.positionScreen.y);i.closePath();if(p instanceof THREE.LineBasicMaterial){u.__styleString=p.color.__styleString;m=p.linewidth;if(r!=m)i.lineWidth=r=m;m=u.__styleString;if(s!=m)i.strokeStyle=s=m;i.stroke();H.inflate(p.linewidth*2)}}}function Ha(m,G,z,p,v,M){if(v.opacity!=0){a(v.opacity);b(v.blending);I=m.positionScreen.x;F=m.positionScreen.y;N=G.positionScreen.x;A=G.positionScreen.y;w=z.positionScreen.x;J=z.positionScreen.y;
i.beginPath();i.moveTo(I,F);i.lineTo(N,A);i.lineTo(w,J);i.lineTo(I,F);i.closePath();if(v instanceof THREE.MeshBasicMaterial)if(v.map)v.map.mapping instanceof THREE.UVMapping&&ua(I,F,N,A,w,J,v.map.image,p.uvs[0].u,p.uvs[0].v,p.uvs[1].u,p.uvs[1].v,p.uvs[2].u,p.uvs[2].v);else if(v.envMap){if(v.envMap.mapping instanceof THREE.SphericalReflectionMapping){m=da.matrixWorldInverse;R.copy(p.vertexNormalsWorld[0]);Y=(R.x*m.n11+R.y*m.n12+R.z*m.n13)*0.5+0.5;L=-(R.x*m.n21+R.y*m.n22+R.z*m.n23)*0.5+0.5;R.copy(p.vertexNormalsWorld[1]);
ja=(R.x*m.n11+R.y*m.n12+R.z*m.n13)*0.5+0.5;ka=-(R.x*m.n21+R.y*m.n22+R.z*m.n23)*0.5+0.5;R.copy(p.vertexNormalsWorld[2]);la=(R.x*m.n11+R.y*m.n12+R.z*m.n13)*0.5+0.5;ma=-(R.x*m.n21+R.y*m.n22+R.z*m.n23)*0.5+0.5;ua(I,F,N,A,w,J,v.envMap.image,Y,L,ja,ka,la,ma)}}else v.wireframe?za(v.color.__styleString,v.wireframeLinewidth):Aa(v.color.__styleString);else if(v instanceof THREE.MeshLambertMaterial){if(v.map&&!v.wireframe){v.map.mapping instanceof THREE.UVMapping&&ua(I,F,N,A,w,J,v.map.image,p.uvs[0].u,p.uvs[0].v,
p.uvs[1].u,p.uvs[1].v,p.uvs[2].u,p.uvs[2].v);b(THREE.SubtractiveBlending)}if(U)if(!v.wireframe&&v.shading==THREE.SmoothShading&&p.vertexNormalsWorld.length==3){K.r=E.r=y.r=aa.r;K.g=E.g=y.g=aa.g;K.b=E.b=y.b=aa.b;ya(M,p.v1.positionWorld,p.vertexNormalsWorld[0],K);ya(M,p.v2.positionWorld,p.vertexNormalsWorld[1],E);ya(M,p.v3.positionWorld,p.vertexNormalsWorld[2],y);B.r=(E.r+y.r)*0.5;B.g=(E.g+y.g)*0.5;B.b=(E.b+y.b)*0.5;P=Ia(K,E,y,B);ua(I,F,N,A,w,J,P,0,0,1,0,0,1)}else{Q.r=aa.r;Q.g=aa.g;Q.b=aa.b;ya(M,p.centroidWorld,
p.normalWorld,Q);u.r=v.color.r*Q.r;u.g=v.color.g*Q.g;u.b=v.color.b*Q.b;u.updateStyleString();v.wireframe?za(u.__styleString,v.wireframeLinewidth):Aa(u.__styleString)}else v.wireframe?za(v.color.__styleString,v.wireframeLinewidth):Aa(v.color.__styleString)}else if(v instanceof THREE.MeshDepthMaterial){T=da.near;x=da.far;K.r=K.g=K.b=1-Da(m.positionScreen.z,T,x);E.r=E.g=E.b=1-Da(G.positionScreen.z,T,x);y.r=y.g=y.b=1-Da(z.positionScreen.z,T,x);B.r=(E.r+y.r)*0.5;B.g=(E.g+y.g)*0.5;B.b=(E.b+y.b)*0.5;P=Ia(K,
E,y,B);ua(I,F,N,A,w,J,P,0,0,1,0,0,1)}else if(v instanceof THREE.MeshNormalMaterial){u.r=Ea(p.normalWorld.x);u.g=Ea(p.normalWorld.y);u.b=Ea(p.normalWorld.z);u.updateStyleString();v.wireframe?za(u.__styleString,v.wireframeLinewidth):Aa(u.__styleString)}}}function za(m,G){if(s!=m)i.strokeStyle=s=m;if(r!=G)i.lineWidth=r=G;i.stroke();H.inflate(G*2)}function Aa(m){if(t!=m)i.fillStyle=t=m;i.fill()}function ua(m,G,z,p,v,M,W,X,Z,ga,ca,ha,va){var ea,ia;ea=W.width-1;ia=W.height-1;X*=ea;Z*=ia;ga*=ea;ca*=ia;ha*=
ea;va*=ia;z-=m;p-=G;v-=m;M-=G;ga-=X;ca-=Z;ha-=X;va-=Z;ea=ga*va-ha*ca;if(ea!=0){ia=1/ea;ea=(va*z-ca*v)*ia;ca=(va*p-ca*M)*ia;z=(ga*v-ha*z)*ia;p=(ga*M-ha*p)*ia;m=m-ea*X-z*Z;G=G-ca*X-p*Z;i.save();i.transform(ea,ca,z,p,m,G);i.clip();i.drawImage(W,0,0);i.restore()}}function Ia(m,G,z,p){var v=~~(m.r*255),M=~~(m.g*255);m=~~(m.b*255);var W=~~(G.r*255),X=~~(G.g*255);G=~~(G.b*255);var Z=~~(z.r*255),ga=~~(z.g*255);z=~~(z.b*255);var ca=~~(p.r*255),ha=~~(p.g*255);p=~~(p.b*255);ba[0]=v<0?0:v>255?255:v;ba[1]=M<0?
0:M>255?255:M;ba[2]=m<0?0:m>255?255:m;ba[4]=W<0?0:W>255?255:W;ba[5]=X<0?0:X>255?255:X;ba[6]=G<0?0:G>255?255:G;ba[8]=Z<0?0:Z>255?255:Z;ba[9]=ga<0?0:ga>255?255:ga;ba[10]=z<0?0:z>255?255:z;ba[12]=ca<0?0:ca>255?255:ca;ba[13]=ha<0?0:ha>255?255:ha;ba[14]=p<0?0:p>255?255:p;sa.putImageData(Ca,0,0);xa.drawImage(ra,0,0);return ta}function Da(m,G,z){m=(m-G)/(z-G);return m*m*(3-2*m)}function Ea(m){m=(m+1)*0.5;return m<0?0:m>1?1:m}function Fa(m,G){var z=G.x-m.x,p=G.y-m.y,v=1/Math.sqrt(z*z+p*p);z*=v;p*=v;G.x+=
z;G.y+=p;m.x-=z;m.y-=p}var Ba,Ja,S,fa,qa,Ga,Ka,wa;this.autoClear?this.clear():i.setTransform(1,0,0,-1,j,g);c=d.projectScene(V,da,this.sortElements);(U=V.lights.length>0)&&Ma(V);Ba=0;for(Ja=c.length;Ba<Ja;Ba++){S=c[Ba];H.empty();if(S instanceof THREE.RenderableParticle){k=S;k.x*=j;k.y*=g;fa=0;for(qa=S.materials.length;fa<qa;fa++)Na(k,S,S.materials[fa],V)}else if(S instanceof THREE.RenderableLine){k=S.v1;D=S.v2;k.positionScreen.x*=j;k.positionScreen.y*=g;D.positionScreen.x*=j;D.positionScreen.y*=g;
H.addPoint(k.positionScreen.x,k.positionScreen.y);H.addPoint(D.positionScreen.x,D.positionScreen.y);if($.instersects(H)){fa=0;for(qa=S.materials.length;fa<qa;)Oa(k,D,S,S.materials[fa++],V)}}else if(S instanceof THREE.RenderableFace3){k=S.v1;D=S.v2;C=S.v3;k.positionScreen.x*=j;k.positionScreen.y*=g;D.positionScreen.x*=j;D.positionScreen.y*=g;C.positionScreen.x*=j;C.positionScreen.y*=g;if(S.overdraw){Fa(k.positionScreen,D.positionScreen);Fa(D.positionScreen,C.positionScreen);Fa(C.positionScreen,k.positionScreen)}H.add3Points(k.positionScreen.x,
k.positionScreen.y,D.positionScreen.x,D.positionScreen.y,C.positionScreen.x,C.positionScreen.y);if($.instersects(H)){fa=0;for(qa=S.meshMaterials.length;fa<qa;){wa=S.meshMaterials[fa++];if(wa instanceof THREE.MeshFaceMaterial){Ga=0;for(Ka=S.faceMaterials.length;Ga<Ka;)(wa=S.faceMaterials[Ga++])&&Ha(k,D,C,S,wa,V)}else Ha(k,D,C,S,wa,V)}}}O.addRectangle(H)}i.setTransform(1,0,0,1,0,0)}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(undefined,!1,b);c=a.sounds;var d,e=c.length;for(d=0;d<e;d++){a=c[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
