// Three.js r33 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,c){var d,f,g,h,k,j;if(c==0)d=f=g=0;else{h=Math.floor(a*6);k=a*6-h;a=c*(1-b);j=c*(1-b*k);b=c*(1-b*(1-k));switch(h){case 1:d=j;f=c;g=a;break;case 2:d=a;f=c;g=b;break;case 3:d=a;f=j;g=c;break;case 4:d=b;f=a;g=c;break;case 5:d=c;f=a;g=j;break;case 6:case 0:d=c;f=b;g=a}}this.r=d;this.g=f;this.b=g;if(this.autoUpdate){this.updateHex();
this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.set(c*a.z-d*a.y,d*a.x-b*a.z,b*a.y-c*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,c,d=a.objects,f=[];a=0;for(b=d.length;a<b;a++){c=d[a];c instanceof THREE.Mesh&&(f=f.concat(this.intersectObject(c)))}f.sort(function(g,h){return g.distance-h.distance});return f},intersectObject:function(a){function b(H,u,I,o){o=o.clone().subSelf(u);I=I.clone().subSelf(u);var M=H.clone().subSelf(u);H=o.dot(o);u=o.dot(I);o=o.dot(M);var e=I.dot(I);I=I.dot(M);M=1/(H*e-u*u);e=(e*o-u*I)*M;H=(H*I-u*o)*M;return e>0&&H>0&&e+H<1}var c,d,f,g,h,k,j,l,n,v,
p,q=a.geometry,w=q.vertices,B=[];c=0;for(d=q.faces.length;c<d;c++){f=q.faces[c];v=this.origin.clone();p=this.direction.clone();j=a.matrixWorld;g=j.multiplyVector3(w[f.a].position.clone());h=j.multiplyVector3(w[f.b].position.clone());k=j.multiplyVector3(w[f.c].position.clone());j=f instanceof THREE.Face4?j.multiplyVector3(w[f.d].position.clone()):null;l=a.matrixRotationWorld.multiplyVector3(f.normal.clone());n=p.dot(l);if(n<0){l=l.dot((new THREE.Vector3).sub(g,v))/n;v=v.addSelf(p.multiplyScalar(l));
if(f instanceof THREE.Face3){if(b(v,g,h,k)){f={distance:this.origin.distanceTo(v),point:v,face:f,object:a};B.push(f)}}else if(f instanceof THREE.Face4&&(b(v,g,h,j)||b(v,h,k,j))){f={distance:this.origin.distanceTo(v),point:v,face:f,object:a};B.push(f)}}}return B}};
THREE.Rectangle=function(){function a(){g=d-b;h=f-c}var b,c,d,f,g,h,k=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(j,l,n,v){k=!1;b=j;c=l;d=n;f=v;a()};this.addPoint=function(j,l){if(k){k=!1;b=j;c=l;d=j;f=l}else{b=b<j?b:j;c=c<l?c:l;d=d>j?d:j;f=f>l?f:l}a()};
this.add3Points=function(j,l,n,v,p,q){if(k){k=!1;b=j<n?j<p?j:p:n<p?n:p;c=l<v?l<q?l:q:v<q?v:q;d=j>n?j>p?j:p:n>p?n:p;f=l>v?l>q?l:q:v>q?v:q}else{b=j<n?j<p?j<b?j:b:p<b?p:b:n<p?n<b?n:b:p<b?p:b;c=l<v?l<q?l<c?l:c:q<c?q:c:v<q?v<c?v:c:q<c?q:c;d=j>n?j>p?j>d?j:d:p>d?p:d:n>p?n>d?n:d:p>d?p:d;f=l>v?l>q?l>f?l:f:q>f?q:f:v>q?v>f?v:f:q>f?q:f}a()};this.addRectangle=function(j){if(k){k=!1;b=j.getLeft();c=j.getTop();d=j.getRight();f=j.getBottom()}else{b=b<j.getLeft()?b:j.getLeft();c=c<j.getTop()?c:j.getTop();d=d>j.getRight()?
d:j.getRight();f=f>j.getBottom()?f:j.getBottom()}a()};this.inflate=function(j){b-=j;c-=j;d+=j;f+=j;a()};this.minSelf=function(j){b=b>j.getLeft()?b:j.getLeft();c=c>j.getTop()?c:j.getTop();d=d<j.getRight()?d:j.getRight();f=f<j.getBottom()?f:j.getBottom();a()};this.instersects=function(j){return Math.min(d,j.getRight())-Math.max(b,j.getLeft())>=0&&Math.min(f,j.getBottom())-Math.max(c,j.getTop())>=0};this.empty=function(){k=!0;f=d=c=b=0;a()};this.isEmpty=function(){return k}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,f,g,h,k,j,l,n,v,p,q,w,B){this.set(a||1,b||0,c||0,d||0,f||0,g||1,h||0,k||0,j||0,l||0,n||1,v||0,p||0,q||0,w||0,B||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,f,g,h,k,j,l,n,v,p,q,w,B){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=f;this.n22=g;this.n23=h;this.n24=k;this.n31=j;this.n32=l;this.n33=n;this.n34=v;this.n41=p;this.n42=q;this.n43=w;this.n44=B;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__tmpVec1,
f=THREE.Matrix4.__tmpVec2,g=THREE.Matrix4.__tmpVec3;g.sub(a,b).normalize();d.cross(c,g).normalize();f.cross(g,d).normalize();this.n11=d.x;this.n12=f.x;this.n13=g.x;this.n14=a.x;this.n21=d.y;this.n22=f.y;this.n23=g.y;this.n24=a.y;this.n31=d.z;this.n32=f.z;this.n33=g.z;this.n34=a.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,f=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*f;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*f;a.z=(this.n31*
b+this.n32*c+this.n33*d+this.n34)*f;return a},multiplyVector3OnlyZ:function(a){var b=a.x,c=a.y;a=a.z;return(this.n31*b+this.n32*c+this.n33*a+this.n34)*(1/(this.n41*b+this.n42*c+this.n43*a+this.n44))},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,f=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*f;return a},crossVector:function(a){var b=new THREE.Vector4;
b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,h=a.n21,k=a.n22,j=a.n23,l=a.n24,n=a.n31,v=a.n32,p=a.n33,q=a.n34,w=a.n41,B=a.n42,H=a.n43,u=a.n44,I=b.n11,o=b.n12,M=b.n13,e=b.n14,ba=b.n21,O=b.n22,P=b.n23,V=b.n24,T=b.n31,Y=b.n32,da=b.n33,J=b.n34;this.n11=
c*I+d*ba+f*T;this.n12=c*o+d*O+f*Y;this.n13=c*M+d*P+f*da;this.n14=c*e+d*V+f*J+g;this.n21=h*I+k*ba+j*T;this.n22=h*o+k*O+j*Y;this.n23=h*M+k*P+j*da;this.n24=h*e+k*V+j*J+l;this.n31=n*I+v*ba+p*T;this.n32=n*o+v*O+p*Y;this.n33=n*M+v*P+p*da;this.n34=n*e+v*V+p*J+q;this.n41=w*I+B*ba+H*T;this.n42=w*o+B*O+H*Y;this.n43=w*M+B*P+H*da;this.n44=w*e+B*V+H*J+u;return this},multiplyToArray:function(a,b,c){var d=a.n11,f=a.n12,g=a.n13,h=a.n14,k=a.n21,j=a.n22,l=a.n23,n=a.n24,v=a.n31,p=a.n32,q=a.n33,w=a.n34,B=a.n41,H=a.n42,
u=a.n43;a=a.n44;var I=b.n11,o=b.n12,M=b.n13,e=b.n14,ba=b.n21,O=b.n22,P=b.n23,V=b.n24,T=b.n31,Y=b.n32,da=b.n33,J=b.n34,$=b.n41,ra=b.n42,Z=b.n43;b=b.n44;this.n11=d*I+f*ba+g*T+h*$;this.n12=d*o+f*O+g*Y+h*ra;this.n13=d*M+f*P+g*da+h*Z;this.n14=d*e+f*V+g*J+h*b;this.n21=k*I+j*ba+l*T+n*$;this.n22=k*o+j*O+l*Y+n*ra;this.n23=k*M+j*P+l*da+n*Z;this.n24=k*e+j*V+l*J+n*b;this.n31=v*I+p*ba+q*T+w*$;this.n32=v*o+p*O+q*Y+w*ra;this.n33=v*M+p*P+q*da+w*Z;this.n34=v*e+p*V+q*J+w*b;this.n41=B*I+H*ba+u*T+a*$;this.n42=B*o+H*
O+u*Y+a*ra;this.n43=B*M+H*P+u*da+a*Z;this.n44=B*e+H*V+u*J+a*b;c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){var b=this.n11,c=this.n12,d=this.n13,f=this.n14,g=this.n21,h=this.n22,k=this.n23,j=this.n24,l=this.n31,n=this.n32,v=this.n33,p=this.n34,q=this.n41,w=this.n42,B=this.n43,H=
this.n44,u=a.n11,I=a.n21,o=a.n31,M=a.n12,e=a.n22,ba=a.n32,O=a.n13,P=a.n23,V=a.n33,T=a.n14,Y=a.n24;a=a.n34;this.n11=b*u+c*I+d*o;this.n12=b*M+c*e+d*ba;this.n13=b*O+c*P+d*V;this.n14=b*T+c*Y+d*a+f;this.n21=g*u+h*I+k*o;this.n22=g*M+h*e+k*ba;this.n23=g*O+h*P+k*V;this.n24=g*T+h*Y+k*a+j;this.n31=l*u+n*I+v*o;this.n32=l*M+n*e+v*ba;this.n33=l*O+n*P+v*V;this.n34=l*T+n*Y+v*a+p;this.n41=q*u+w*I+B*o;this.n42=q*M+w*e+B*ba;this.n43=q*O+w*P+B*V;this.n44=q*T+w*Y+B*a+H;return this},multiplyScalar:function(a){this.n11*=
a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,f=this.n21,g=this.n22,h=this.n23,k=this.n24,j=this.n31,l=this.n32,n=this.n33,v=this.n34,p=this.n41,q=this.n42,w=this.n43,B=this.n44;return d*h*l*p-c*k*l*p-d*g*n*p+b*k*n*p+c*g*v*p-b*h*v*p-d*h*j*q+c*k*j*q+d*f*n*q-a*k*n*q-c*f*v*q+a*h*v*q+
d*g*j*w-b*k*j*w-d*f*l*w+a*k*l*w+b*f*v*w-a*g*v*w-c*g*j*B+b*h*j*B+c*f*l*B-a*h*l*B-b*f*n*B+a*g*n*B},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;
a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flattenToArray(this.flat);return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,
b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,
0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),f=1-c,g=a.x,h=a.y,k=a.z,j=f*g,l=f*h;this.set(j*g+c,j*h-d*k,j*k+d*h,0,j*h+d*k,l*h+c,l*k-d*g,0,j*k-d*h,l*k+d*g,f*k*k+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=
a.y;this.n34=a.z;return this},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z;a=Math.cos(b);b=Math.sin(b);var f=Math.cos(c);c=Math.sin(c);var g=Math.cos(d);d=Math.sin(d);var h=a*c,k=b*c;this.n11=f*g;this.n12=-f*d;this.n13=c;this.n21=k*g+a*d;this.n22=-k*d+a*g;this.n23=-b*f;this.n31=-h*g+b*d;this.n32=h*d+b*g;this.n33=a*f},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,f=a.w,g=b+b,h=c+c,k=d+d;a=b*g;var j=b*h;b*=k;var l=c*h;c*=k;d*=k;g*=f;h*=f;f*=k;this.n11=1-(l+d);this.n12=j-f;this.n13=
b+h;this.n21=j+f;this.n22=1-(a+d);this.n23=c-g;this.n31=b-h;this.n32=c+g;this.n33=1-(a+l)},scale:function(a){var b=a.x,c=a.y;a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this}};THREE.Matrix4.translationMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setTranslation(a,b,c);return d};THREE.Matrix4.scaleMatrix=function(a,b,c){var d=new THREE.Matrix4;d.setScale(a,b,c);return d};
THREE.Matrix4.rotationXMatrix=function(a){var b=new THREE.Matrix4;b.setRotX(a);return b};THREE.Matrix4.rotationYMatrix=function(a){var b=new THREE.Matrix4;b.setRotY(a);return b};THREE.Matrix4.rotationZMatrix=function(a){var b=new THREE.Matrix4;b.setRotZ(a);return b};THREE.Matrix4.rotationAxisAngleMatrix=function(a,b){var c=new THREE.Matrix4;c.setRotAxis(a,b);return c};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,h=a.n21,k=a.n22,j=a.n23,l=a.n24,n=a.n31,v=a.n32,p=a.n33,q=a.n34,w=a.n41,B=a.n42,H=a.n43,u=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=j*q*B-l*p*B+l*v*H-k*q*H-j*v*u+k*p*u;b.n12=g*p*B-f*q*B-g*v*H+d*q*H+f*v*u-d*p*u;b.n13=f*l*B-g*j*B+g*k*H-d*l*H-f*k*u+d*j*u;b.n14=g*j*v-f*l*v-g*k*p+d*l*p+f*k*q-d*j*q;b.n21=l*p*w-j*q*w-l*n*H+h*q*H+j*n*u-h*p*u;b.n22=f*q*w-g*p*w+g*n*H-c*q*H-f*n*u+c*p*u;b.n23=g*j*w-f*l*w-g*h*H+c*l*H+f*h*u-c*j*u;
b.n24=f*l*n-g*j*n+g*h*p-c*l*p-f*h*q+c*j*q;b.n31=k*q*w-l*v*w+l*n*B-h*q*B-k*n*u+h*v*u;b.n32=g*v*w-d*q*w-g*n*B+c*q*B+d*n*u-c*v*u;b.n33=f*l*w-g*k*w+g*h*B-c*l*B-d*h*u+c*k*u;b.n34=g*k*n-d*l*n-g*h*v+c*l*v+d*h*q-c*k*q;b.n41=j*v*w-k*p*w-j*n*B+h*p*B+k*n*H-h*v*H;b.n42=d*p*w-f*v*w+f*n*B-c*p*B-d*n*H+c*v*H;b.n43=f*k*w-d*j*w-f*h*B+c*j*B+d*h*H-c*k*H;b.n44=d*j*n-f*k*n+f*h*v-c*j*v-d*h*p+c*k*p;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,k=a.n33*a.n11-a.n31*a.n13,j=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,n=-a.n23*a.n11+a.n21*a.n13,v=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*h+a.n31*l;if(a==0)throw"matrix not invertible";a=1/a;c[0]=a*d;c[1]=a*f;c[2]=a*g;c[3]=a*h;c[4]=a*k;c[5]=a*j;c[6]=a*l;c[7]=a*n;c[8]=a*v;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,f,g){var h;h=new THREE.Matrix4;h.n11=2*f/(b-a);h.n12=0;h.n13=(b+a)/(b-a);h.n14=0;h.n21=0;h.n22=2*f/(d-c);h.n23=(d+c)/(d-c);h.n24=0;h.n31=0;h.n32=0;h.n33=-(g+f)/(g-f);h.n34=-2*g*f/(g-f);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,b,c,d){var f;a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,f,g){var h,k,j,l;h=new THREE.Matrix4;k=b-a;j=c-d;l=g-f;h.n11=2/k;h.n12=0;h.n13=0;h.n14=-((b+a)/k);h.n21=0;h.n22=2/j;h.n23=0;h.n24=-((c+d)/j);h.n31=0;h.n32=0;h.n33=-2/l;h.n34=-((g+f)/l);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__tmpVec1=new THREE.Vector3;THREE.Matrix4.__tmpVec2=new THREE.Vector3;THREE.Matrix4.__tmpVec3=new THREE.Vector3;
THREE.Object3D=function(){this.id=THREE.Object3DCounter.value++;this.parent=undefined;this.children=[];this.position=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixNeedsUpdate=!0;this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;
this.visible=!0};
THREE.Object3D.prototype={addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b instanceof THREE.Scene===!1&&b!==undefined;)b=b.parent;b!==undefined&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);
if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}return!0},update:function(a,b,c){if(this.visible){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);b=1/this.scale.x;a=1/this.scale.y;var d=1/this.scale.z;this.matrixRotationWorld.n11=this.matrixWorld.n11*b;this.matrixRotationWorld.n21=
this.matrixWorld.n21*b;this.matrixRotationWorld.n31=this.matrixWorld.n31*b;this.matrixRotationWorld.n12=this.matrixWorld.n12*a;this.matrixRotationWorld.n22=this.matrixWorld.n22*a;this.matrixRotationWorld.n32=this.matrixWorld.n32*a;this.matrixRotationWorld.n13=this.matrixWorld.n13*d;this.matrixRotationWorld.n23=this.matrixWorld.n23*d;this.matrixRotationWorld.n33=this.matrixWorld.n33*d;this.matrixNeedsUpdate=!1;b=!0}a=0;for(d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}}};
THREE.Object3DCounter={value:0};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b;a=Math.cos(d);d=Math.sin(d);b=Math.cos(-f);f=Math.sin(-f);var g=Math.cos(c);c=Math.sin(c);var h=a*b,k=d*f;this.w=h*g-k*c;this.x=h*c+k*g;this.y=d*b*g+a*f*c;this.z=a*f*g-d*b*c;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,f=this.w,g=a.x,h=a.y,k=a.z;a=a.w;this.x=b*a+f*g+c*k-d*h;this.y=c*a+f*h+d*g-b*k;this.z=d*a+f*k+b*h-c*g;this.w=f*a-b*g-c*h-d*k;return this},
multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,g=this.x,h=this.y,k=this.z,j=this.w,l=j*c+h*f-k*d,n=j*d+k*c-g*f,v=j*f+g*d-h*c;c=-g*c-h*d-k*f;b.x=l*j+c*-g+n*-k-v*-h;b.y=n*j+c*-h+v*-g-l*-k;b.z=v*j+c*-k+l*-h-n*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(f)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var g=Math.acos(f),h=Math.sqrt(1-f*f);if(Math.abs(h)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}f=Math.sin((1-d)*g)/h;d=Math.sin(d*g)/h;c.w=a.w*f+b.w*d;c.x=a.x*f+b.x*d;c.y=a.y*f+b.y*d;c.z=a.z*f+b.z*d;return c};
THREE.Vertex=function(a,b){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=b||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=!0};
THREE.Face3=function(a,b,c,d,f){this.a=a;this.b=b;this.c=c;this.centroid=new THREE.Vector3;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.materials=f instanceof Array?f:[f]};THREE.Face4=function(a,b,c,d,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.centroid=new THREE.Vector3;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.materials=g instanceof Array?g:[g]};
THREE.UV=function(a,b){this.set(a||0,b||0)};THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.faces=[];this.uvs=[];this.uvs2=[];this.colors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.geometryChunks={};this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,c,d,f,g,h,k=new THREE.Vector3,j=new THREE.Vector3;d=0;for(f=this.vertices.length;d<f;d++){g=this.vertices[d];g.normal.set(0,0,0)}d=0;for(f=this.faces.length;d<f;d++){g=this.faces[d];if(a&&g.vertexNormals.length){k.set(0,0,0);b=0;for(c=g.normal.length;b<c;b++)k.addSelf(g.vertexNormals[b]);k.divideScalar(3)}else{b=this.vertices[g.a];c=this.vertices[g.b];h=this.vertices[g.c];k.sub(h.position,
c.position);j.sub(b.position,c.position);k.crossSelf(j)}k.isZero()||k.normalize();g.normal.copy(k)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,
new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<
b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeTangents:function(){function a(J,$,ra,Z,la,ja,fa){g=J.vertices[$].position;h=J.vertices[ra].position;k=J.vertices[Z].position;j=f[la];l=f[ja];n=f[fa];v=h.x-g.x;p=k.x-g.x;q=h.y-g.y;w=
k.y-g.y;B=h.z-g.z;H=k.z-g.z;u=l.u-j.u;I=n.u-j.u;o=l.v-j.v;M=n.v-j.v;e=1/(u*M-I*o);P.set((M*v-o*p)*e,(M*q-o*w)*e,(M*B-o*H)*e);V.set((u*p-I*v)*e,(u*w-I*q)*e,(u*H-I*B)*e);ba[$].addSelf(P);ba[ra].addSelf(P);ba[Z].addSelf(P);O[$].addSelf(V);O[ra].addSelf(V);O[Z].addSelf(V)}var b,c,d,f,g,h,k,j,l,n,v,p,q,w,B,H,u,I,o,M,e,ba=[],O=[],P=new THREE.Vector3,V=new THREE.Vector3,T=new THREE.Vector3,Y=new THREE.Vector3,da=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++){ba[b]=new THREE.Vector3;O[b]=new THREE.Vector3}b=
0;for(c=this.faces.length;b<c;b++){d=this.faces[b];f=this.uvs[b];if(d instanceof THREE.Face3){a(this,d.a,d.b,d.c,0,1,2);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2])}else if(d instanceof THREE.Face4){a(this,d.a,d.b,d.c,0,1,2);a(this,d.a,d.b,d.d,0,1,3);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2]);
this.vertices[d.d].normal.copy(d.vertexNormals[3])}}b=0;for(c=this.vertices.length;b<c;b++){da.copy(this.vertices[b].normal);d=ba[b];T.copy(d);T.subSelf(da.multiplyScalar(da.dot(d))).normalize();Y.cross(this.vertices[b].normal,d);d=Y.dot(O[b]);d=d<0?-1:1;this.vertices[b].tangent.set(T.x,T.y,T.z,d)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],
z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>
this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},sortFacesByMaterial:function(){function a(n){var v=[];b=0;for(c=n.length;b<c;b++)n[b]==undefined?v.push("undefined"):v.push(n[b].id);return v.join("_")}var b,c,d,f,g,h,k,j,l={};d=0;for(f=this.faces.length;d<f;d++){g=this.faces[d];
h=g.materials;k=a(h);l[k]==undefined&&(l[k]={hash:k,counter:0});j=l[k].hash+"_"+l[k].counter;this.geometryChunks[j]==undefined&&(this.geometryChunks[j]={faces:[],materials:h,vertices:0});g=g instanceof THREE.Face3?3:4;if(this.geometryChunks[j].vertices+g>65535){l[k].counter+=1;j=l[k].hash+"_"+l[k].counter;this.geometryChunks[j]==undefined&&(this.geometryChunks[j]={faces:[],materials:h,vertices:0})}this.geometryChunks[j].faces.push(d);this.geometryChunks[j].vertices+=g}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(){function a(p,q,w,B,H,u,I){p=(w-p)*0.5;B=(B-q)*0.5;return(2*(q-w)+p+B)*I+(-3*(q-w)-2*p-B)*u+p*H+q}var b=[],c={x:0,y:0,z:0},d,f,g,h,k,j,l,n,v;this.get2DPoint=function(p,q){d=(p.length-1)*q;f=Math.floor(d);g=d-f;b[0]=f==0?f:f-1;b[1]=f;b[2]=f>p.length-2?f:f+1;b[3]=f>p.length-3?f:f+2;j=p[b[0]];l=p[b[1]];n=p[b[2]];v=p[b[3]];h=g*g;k=g*h;c.x=a(j.x,l.x,n.x,v.x,g,h,k);c.y=a(j.y,l.y,n.y,v.y,g,h,k);c.z=a(j.z,l.z,n.z,v.z,g,h,k);return c}};
THREE.AnimationHandler=function(){var a=[],b={};b.update=function(c){for(var d=0;d<a.length;d++)a[d].update(c)};b.add=function(c){a.indexOf(c)===-1&&a.push(c)};b.remove=function(c){a.indexOf(c)!==-1&&a.splice(childIndex,1)};b.initData=function(c){if(c.initialized!==!0){for(var d=0;d<c.hierarchy.length;d++)for(var f=0;f<c.hierarchy[d].keys.length;f++){if(c.hierarchy[d].keys[f].time<0)c.hierarchy[d].keys[f].time=0;c.hierarchy[d].keys[f].index=f;if(c.hierarchy[d].keys[f].rot!==undefined&&!(c.hierarchy[d].keys[f].rot instanceof
THREE.Quaternion)){var g=c.hierarchy[d].keys[f].rot;c.hierarchy[d].keys[f].rot=new THREE.Quaternion(g[0],g[1],g[2],g[3])}}f=parseInt(c.length*c.fps,10);c.JIT={};c.JIT.hierarchy=[];for(d=0;d<c.hierarchy.length;d++)c.JIT.hierarchy.push(Array(f));c.initialized=!0}};return b}();
THREE.Animation=function(a,b){this.root=a;this.data=b;this.hierarchy=[];this.startTime=0;this.isPlaying=!1;this.loop=!0;this.offset=0;this.data.initialized||THREE.AnimationHandler.initData(this.data);if(a instanceof THREE.SkinnedMesh)for(var c=0;c<this.root.bones.length;c++)this.hierarchy.push(this.root.bones[c])};
THREE.Animation.prototype.play=function(){if(!this.isPlaying){this.isPlaying=!0;this.startTime=(new Date).getTime()*0.001;for(var a=0;a<this.hierarchy.length;a++){this.hierarchy[a].useQuaternion=!0;this.hierarchy[a].matrixAutoUpdate=!0;if(this.hierarchy[a].prevKey===undefined){this.hierarchy[a].prevKey={pos:0,rot:0,scl:0};this.hierarchy[a].nextKey={pos:0,rot:0,scl:0}}this.hierarchy[a].prevKey.pos=this.data.hierarchy[a].keys[0];this.hierarchy[a].prevKey.rot=this.data.hierarchy[a].keys[0];this.hierarchy[a].prevKey.scl=
this.data.hierarchy[a].keys[0];this.hierarchy[a].nextKey.pos=this.getNextKeyWith("pos",a,1);this.hierarchy[a].nextKey.rot=this.getNextKeyWith("rot",a,1);this.hierarchy[a].nextKey.scl=this.getNextKeyWith("scl",a,1)}this.update();THREE.AnimationHandler.add(this)}};THREE.Animation.prototype.pause=function(){THREE.AnimationHandler.remove(this)};THREE.Animation.prototype.stop=function(){this.isPlaying=!1;THREE.AnimationHandler.remove(this)};
THREE.Animation.prototype.update=function(){if(this.isPlaying){var a=["pos","rot","scl"],b,c,d,f,g,h,k=this.data.JIT.hierarchy,j=(new Date).getTime()*0.001-this.startTime+this.offset,l=j;if(j>this.data.length){for(;j>this.data.length;)j-=this.data.length;this.startTime=(new Date).getTime()*0.001-j;j=(new Date).getTime()*0.001-this.startTime}h=Math.min(parseInt(j*this.data.fps),parseInt(this.data.length*this.data.fps));for(var n=0,v=this.hierarchy.length;n<v;n++){g=this.hierarchy[n];if(k[n][h]!==undefined){g.skinMatrix=
k[n][h];g.matrixAutoUpdate=!1;g.matrixNeedsUpdate=!1;g.skinMatrix.flattenToArrayOffset(this.root.boneMatrices,n*16)}else for(var p=0;p<3;p++){c=a[p];d=g.prevKey[c];f=g.nextKey[c];if(f.time<l){if(j<l)if(this.loop){d=this.data.hierarchy[n].keys[0];f=this.getNextKeyWith(c,n,1)}else{this.stop();return}else{do{d=f;f=this.getNextKeyWith(c,n,f.index+1)}while(f.time<j)}g.prevKey[c]=d;g.nextKey[c]=f}g.matrixAutoUpdate=!0;g.matrixNeedsUpdate=!0;b=(j-d.time)/(f.time-d.time);d=d[c];f=f[c];if(c==="rot"){if(b<
0||b>1){console.log("Scale out of bounds:"+b);b=b<0?0:1}THREE.Quaternion.slerp(d,f,g.quaternion,b)}else{c=c==="pos"?g.position:g.scale;c.x=d[0]+(f[0]-d[0])*b;c.y=d[1]+(f[1]-d[1])*b;c.z=d[2]+(f[2]-d[2])*b}}}if(k[0][h]===undefined){this.hierarchy[0].update(undefined,!0);for(n=0;n<this.hierarchy.length;n++)k[n][h]=this.hierarchy[n].skinMatrix.clone()}}};THREE.Animation.prototype.updateObject=function(){};
THREE.Animation.prototype.getNextKeyWith=function(a,b,c){for(var d=this.data.hierarchy[b].keys;c<d.length;c++)if(d[c][a]!==undefined)return d[c];return this.data.hierarchy[b].keys[0]};
THREE.Camera=function(a,b,c,d,f){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=f||new THREE.Object3D;this.useTarget=!0;this.up=new THREE.Vector3(0,1,0);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.tmpVec=new THREE.Vector3;this.translateX=function(g,h){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(g);this.tmpVec.crossSelf(this.up);if(h)this.tmpVec.y=0;this.position.addSelf(this.tmpVec);
this.target.position.addSelf(this.tmpVec)};this.translateZ=function(g,h){this.tmpVec.sub(this.target.position,this.position).normalize().multiplyScalar(g);if(h)this.tmpVec.y=0;this.position.subSelf(this.tmpVec);this.target.position.subSelf(this.tmpVec)};this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,
this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};function bind(a,b){return function(){b.apply(a,arguments)}}function clamp_bottom(a,b){return a<b?b:a}function clamp(a,b,c){return a<b?b:a>c?c:a}
THREE.QuakeCamera=function(a){THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.domElement=document;if(a){if(a.movementSpeed!==undefined)this.movementSpeed=a.movementSpeed;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.noFly!==undefined)this.noFly=a.noFly;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.autoForward!==
undefined)this.autoForward=a.autoForward;if(a.heightSpeed!==undefined)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==undefined)this.heightCoef=a.heightCoef;if(a.heightMin!==undefined)this.heightMin=a.heightMin;if(a.heightMax!==undefined)this.heightMax=a.heightMax;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phy=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.moveForward=!1;this.moveBackward=!1;this.moveLeft=!1;this.moveRight=!1;this.windowHalfX=
window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(b){b.preventDefault();b.stopPropagation();switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.onMouseUp=function(b){b.preventDefault();b.stopPropagation();switch(b.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}};this.onMouseMove=function(b){this.mouseX=b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.onKeyDown=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0}};this.onKeyUp=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){this.autoSpeedFactor=this.heightSpeed?(clamp(this.position.y,this.heightMin,this.heightMax)-this.heightMin)*this.heightCoef:0;(this.moveForward||this.autoForward)&&
this.translateZ(-(this.movementSpeed+this.autoSpeedFactor),this.noFly);this.moveBackward&&this.translateZ(this.movementSpeed,this.noFly);this.moveLeft&&this.translateX(-this.movementSpeed,this.noFly);this.moveRight&&this.translateX(this.movementSpeed,this.noFly);this.lon+=this.mouseX*this.lookSpeed;this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var b=this.target.position,c=this.position;
b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},!1);this.domElement.addEventListener("mousemove",bind(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",bind(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",bind(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",
bind(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",bind(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;
THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.FlatShading=0;THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.BillboardBlending=3;THREE.ReverseSubtractiveBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};
THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==
undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==
undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.vertexShader=this.fragmentShader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.fragmentShader!==undefined)this.fragmentShader=a.fragmentShader;if(a.vertexShader!==undefined)this.vertexShader=
a.vertexShader;if(a.uniforms!==undefined)this.uniforms=a.uniforms;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==
undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==
undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};THREE.ParticleCircleMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleDOMMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.domElement=a};THREE.Texture=function(a,b,c,d,f,g){this.image=a;this.mapping=b!==undefined?b:new THREE.UVMapping;this.wrapS=c!==undefined?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==undefined?d:THREE.ClampToEdgeWrapping;this.magFilter=f!==undefined?f:THREE.LinearFilter;this.minFilter=g!==undefined?g:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;
THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;
THREE.RenderTarget=function(a,b,c){this.width=a;this.height=b;c=c||{};this.wrapS=c.wrapS!==undefined?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=c.wrapT!==undefined?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=c.magFilter!==undefined?c.magFilter:THREE.LinearFilter;this.minFilter=c.minFilter!==undefined?c.minFilter:THREE.LinearMipMapLinearFilter;this.format=c.format!==undefined?c.format:THREE.RGBFormat;this.type=c.type!==undefined?c.type:THREE.UnsignedByteType};
var Uniforms={clone:function(a){var b,c,d,f={};for(b in a){f[b]={};for(c in a[b]){d=a[b][c];f[b][c]=d instanceof THREE.Color||d instanceof THREE.Vector3||d instanceof THREE.Texture?d.clone():d}}return f},merge:function(a){var b,c,d,f={};for(b=0;b<a.length;b++){d=this.clone(a[b]);for(c in d)f[c]=d[c]}return f}};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;
THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<f;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}}else for(d=0;d<f;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};if(!window.Float32Array)window.Float32Array=Array;
THREE.SkinnedMesh=function(a,b){THREE.Mesh.call(this,a,b);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,d,f,g,h,k;if(this.geometry.bones!==undefined){for(c=0;c<this.geometry.bones.length;c++){f=this.geometry.bones[c];g=f.pos;h=f.rotq;k=f.scl;d=this.addBone();d.name=f.name;d.position.set(g[0],g[1],g[2]);d.quaternion.set(h[0],h[1],h[2],h[3]);k!==undefined?d.scale.set(k[0],k[1],k[2]):d.scale.set(1,1,1)}for(c=0;c<this.bones.length;c++){f=this.geometry.bones[c];d=this.bones[c];
f.parent===-1?this.addChild(d):this.bones[f.parent].addChild(d)}this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(a,b,c){if(this.visible){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d,f=this.children.length;for(d=0;d<f;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.identityMatrix,!1,c):a.update(this.matrixWorld,b,c)}}};
THREE.SkinnedMesh.prototype.addBone=function(a){a===undefined&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.pose=function(){this.update(undefined,!0);for(var a,b=[],c=0;c<this.bones.length;c++){a=this.bones[c];b.push(THREE.Matrix4.makeInvert(a.skinMatrix));a.skinMatrix.flattenToArrayOffset(this.boneMatrices,c*16)}if(this.geometry.skinVerticesA===undefined){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var d;for(a=0;a<this.geometry.skinIndices.length;a++){c=this.geometry.vertices[a].position;var f=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y;
d=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(b[f].multiplyVector3(d));d=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(b[g].multiplyVector3(d));if(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y!==1){c=(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y))*0.5;this.geometry.skinWeights[a].x+=c;this.geometry.skinWeights[a].y+=c}}}};
THREE.Ribbon=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.flipSided=!1;this.doubleSided=!1};THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var f;c=this.sources.length;for(a=0;a<c;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)f=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)f="audio/ogg";else b.indexOf(".wav")!==-1&&(f="audio/wav");if(this.domElement.canPlayType(f)){f=document.createElement("source");f.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(f);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;
THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(a,b){b===undefined&&(b=0);b=Math.abs(b);for(var c=0;c<this.LODs.length;c++)if(b<this.LODs[c].visibleAtDistance)break;this.LODs.splice(c,0,{visibleAtDistance:b,object3D:a});this.addChild(a)};
THREE.LOD.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixNeedsUpdate=!1;b=!0}if(this.LODs.length>1){a=c.matrixWorldInverse;a=-(a.n31*this.position.x+a.n32*this.position.y+a.n33*this.position.z+a.n34);this.LODs[0].object3D.visible=!0;for(var d=1;d<this.LODs.length;d++)if(a>=this.LODs[d].visibleAtDistance){this.LODs[d-1].object3D.visible=!1;this.LODs[d].object3D.visible=
!0}else break;for(;d<this.LODs.length;d++)this.LODs[d].object3D.visible=!1}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Scene=function(){THREE.Object3D.call(this);this.objects=[];this.lights=[];this.sounds=[];this.fog=null;this.matrixAutoUpdate=!1};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;
THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else a instanceof THREE.Camera||a instanceof THREE.Bone||this.objects.indexOf(a)===-1&&this.objects.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);b!==-1&&this.objects.splice(b,1)}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(a,b,c){this.color=new THREE.Color(a);this.near=b||1;this.far=c||1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=b||2.5E-4};
THREE.Projector=function(){function a(O,P){return P.z-O.z}function b(O,P){var V=0,T=1,Y=O.z+O.w,da=P.z+P.w,J=-O.z+O.w,$=-P.z+P.w;if(Y>=0&&da>=0&&J>=0&&$>=0)return!0;else if(Y<0&&da<0||J<0&&$<0)return!1;else{if(Y<0)V=Math.max(V,Y/(Y-da));else da<0&&(T=Math.min(T,Y/(Y-da)));if(J<0)V=Math.max(V,J/(J-$));else $<0&&(T=Math.min(T,J/(J-$)));if(T<V)return!1;else{O.lerpSelf(P,V);P.lerpSelf(O,1-T);return!0}}}var c,d,f=[],g,h,k,j=[],l,n,v=[],p,q,w=[],B=new THREE.Vector4,H=new THREE.Vector4,u=new THREE.Matrix4,
I=new THREE.Matrix4,o=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],M=new THREE.Vector4,e=new THREE.Vector4,ba;this.projectObjects=function(O,P,V){P=[];var T,Y,da;d=0;Y=O.objects;O=0;for(T=Y.length;O<T;O++){da=Y[O];var J;if(!(J=!da.visible))if(J=da instanceof THREE.Mesh){a:{J=void 0;for(var $=da.matrixWorld,ra=-da.geometry.boundingSphere.radius*Math.max(da.scale.x,Math.max(da.scale.y,da.scale.z)),Z=0;Z<6;Z++){J=o[Z].x*$.n14+o[Z].y*$.n24+
o[Z].z*$.n34+o[Z].w;if(J<=ra){J=!1;break a}}J=!0}J=!J}if(!J){c=f[d]=f[d]||new THREE.RenderableObject;B.copy(da.position);u.multiplyVector3(B);c.object=da;c.z=B.z;P.push(c);d++}}V&&P.sort(a);return P};this.projectScene=function(O,P,V){var T=[],Y=P.near,da=P.far,J,$,ra,Z,la,ja,fa,sa,m,A,x,t,y,C,D,E;k=n=q=0;P.matrixAutoUpdate&&P.update();u.multiply(P.projectionMatrix,P.matrixWorldInverse);o[0].set(u.n41-u.n11,u.n42-u.n12,u.n43-u.n13,u.n44-u.n14);o[1].set(u.n41+u.n11,u.n42+u.n12,u.n43+u.n13,u.n44+u.n14);
o[2].set(u.n41+u.n21,u.n42+u.n22,u.n43+u.n23,u.n44+u.n24);o[3].set(u.n41-u.n21,u.n42-u.n22,u.n43-u.n23,u.n44-u.n24);o[4].set(u.n41-u.n31,u.n42-u.n32,u.n43-u.n33,u.n44-u.n34);o[5].set(u.n41+u.n31,u.n42+u.n32,u.n43+u.n33,u.n44+u.n34);for(J=0;J<6;J++){ja=o[J];ja.divideScalar(Math.sqrt(ja.x*ja.x+ja.y*ja.y+ja.z*ja.z))}O.update(undefined,!1,P);ja=this.projectObjects(O,P,!0);O=0;for(J=ja.length;O<J;O++){fa=ja[O].object;if(fa.visible){sa=fa.matrixWorld;x=fa.matrixRotationWorld;m=fa.materials;A=fa.overdraw;
if(fa instanceof THREE.Mesh){t=fa.geometry;y=t.vertices;$=0;for(ra=y.length;$<ra;$++){C=y[$];C.positionWorld.copy(C.position);sa.multiplyVector3(C.positionWorld);Z=C.positionScreen;Z.copy(C.positionWorld);u.multiplyVector4(Z);Z.x/=Z.w;Z.y/=Z.w;C.__visible=Z.z>Y&&Z.z<da}t=t.faces;$=0;for(ra=t.length;$<ra;$++){C=t[$];if(C instanceof THREE.Face3){Z=y[C.a];la=y[C.b];D=y[C.c];if(Z.__visible&&la.__visible&&D.__visible&&(fa.doubleSided||fa.flipSided!=(D.positionScreen.x-Z.positionScreen.x)*(la.positionScreen.y-
Z.positionScreen.y)-(D.positionScreen.y-Z.positionScreen.y)*(la.positionScreen.x-Z.positionScreen.x)<0)){g=j[k]=j[k]||new THREE.RenderableFace3;g.v1.positionWorld.copy(Z.positionWorld);g.v2.positionWorld.copy(la.positionWorld);g.v3.positionWorld.copy(D.positionWorld);g.v1.positionScreen.copy(Z.positionScreen);g.v2.positionScreen.copy(la.positionScreen);g.v3.positionScreen.copy(D.positionScreen);g.normalWorld.copy(C.normal);x.multiplyVector3(g.normalWorld);g.centroidWorld.copy(C.centroid);sa.multiplyVector3(g.centroidWorld);
g.centroidScreen.copy(g.centroidWorld);u.multiplyVector3(g.centroidScreen);D=C.vertexNormals;ba=g.vertexNormalsWorld;Z=0;for(la=D.length;Z<la;Z++){E=ba[Z]=ba[Z]||new THREE.Vector3;E.copy(D[Z]);x.multiplyVector3(E)}g.z=g.centroidScreen.z;g.meshMaterials=m;g.faceMaterials=C.materials;g.overdraw=A;if(fa.geometry.uvs[$]){g.uvs[0]=fa.geometry.uvs[$][0];g.uvs[1]=fa.geometry.uvs[$][1];g.uvs[2]=fa.geometry.uvs[$][2]}T.push(g);k++}}else if(C instanceof THREE.Face4){Z=y[C.a];la=y[C.b];D=y[C.c];E=y[C.d];if(Z.__visible&&
la.__visible&&D.__visible&&E.__visible&&(fa.doubleSided||fa.flipSided!=((E.positionScreen.x-Z.positionScreen.x)*(la.positionScreen.y-Z.positionScreen.y)-(E.positionScreen.y-Z.positionScreen.y)*(la.positionScreen.x-Z.positionScreen.x)<0||(la.positionScreen.x-D.positionScreen.x)*(E.positionScreen.y-D.positionScreen.y)-(la.positionScreen.y-D.positionScreen.y)*(E.positionScreen.x-D.positionScreen.x)<0))){g=j[k]=j[k]||new THREE.RenderableFace3;g.v1.positionWorld.copy(Z.positionWorld);g.v2.positionWorld.copy(la.positionWorld);
g.v3.positionWorld.copy(E.positionWorld);g.v1.positionScreen.copy(Z.positionScreen);g.v2.positionScreen.copy(la.positionScreen);g.v3.positionScreen.copy(E.positionScreen);g.normalWorld.copy(C.normal);x.multiplyVector3(g.normalWorld);g.centroidWorld.copy(C.centroid);sa.multiplyVector3(g.centroidWorld);g.centroidScreen.copy(g.centroidWorld);u.multiplyVector3(g.centroidScreen);g.z=g.centroidScreen.z;g.meshMaterials=m;g.faceMaterials=C.materials;g.overdraw=A;if(fa.geometry.uvs[$]){g.uvs[0]=fa.geometry.uvs[$][0];
g.uvs[1]=fa.geometry.uvs[$][1];g.uvs[2]=fa.geometry.uvs[$][3]}T.push(g);k++;h=j[k]=j[k]||new THREE.RenderableFace3;h.v1.positionWorld.copy(la.positionWorld);h.v2.positionWorld.copy(D.positionWorld);h.v3.positionWorld.copy(E.positionWorld);h.v1.positionScreen.copy(la.positionScreen);h.v2.positionScreen.copy(D.positionScreen);h.v3.positionScreen.copy(E.positionScreen);h.normalWorld.copy(g.normalWorld);h.centroidWorld.copy(g.centroidWorld);h.centroidScreen.copy(g.centroidScreen);h.z=h.centroidScreen.z;
h.meshMaterials=m;h.faceMaterials=C.materials;h.overdraw=A;if(fa.geometry.uvs[$]){h.uvs[0]=fa.geometry.uvs[$][1];h.uvs[1]=fa.geometry.uvs[$][2];h.uvs[2]=fa.geometry.uvs[$][3]}T.push(h);k++}}}}else if(fa instanceof THREE.Line){I.multiply(u,sa);y=fa.geometry.vertices;C=y[0];C.positionScreen.copy(C.position);I.multiplyVector4(C.positionScreen);$=1;for(ra=y.length;$<ra;$++){Z=y[$];Z.positionScreen.copy(Z.position);I.multiplyVector4(Z.positionScreen);la=y[$-1];M.copy(Z.positionScreen);e.copy(la.positionScreen);
if(b(M,e)){M.multiplyScalar(1/M.w);e.multiplyScalar(1/e.w);l=v[n]=v[n]||new THREE.RenderableLine;l.v1.positionScreen.copy(M);l.v2.positionScreen.copy(e);l.z=Math.max(M.z,e.z);l.materials=fa.materials;T.push(l);n++}}}else if(fa instanceof THREE.Particle){H.set(fa.position.x,fa.position.y,fa.position.z,1);u.multiplyVector4(H);H.z/=H.w;if(H.z>0&&H.z<1){p=w[q]=w[q]||new THREE.RenderableParticle;p.x=H.x/H.w;p.y=H.y/H.w;p.z=H.z;p.rotation=fa.rotation.z;p.scale.x=fa.scale.x*Math.abs(p.x-(H.x+P.projectionMatrix.n11)/
(H.w+P.projectionMatrix.n14));p.scale.y=fa.scale.y*Math.abs(p.y-(H.y+P.projectionMatrix.n22)/(H.w+P.projectionMatrix.n24));p.materials=fa.materials;T.push(p);q++}}}}V&&T.sort(a);return T};this.unprojectVector=function(O,P){var V=P.matrixWorld.clone();V.multiplySelf(THREE.Matrix4.makeInvert(P.projectionMatrix));V.multiplyVector3(O);return O}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,b=new THREE.Projector,c,d,f,g;this.domElement=document.createElement("div");this.setSize=function(h,k){c=h;d=k;f=c/2;g=d/2};this.render=function(h,k){var j,l,n,v,p,q,w,B;a=b.projectScene(h,k);j=0;for(l=a.length;j<l;j++){p=a[j];if(p instanceof THREE.RenderableParticle){w=p.x*f+f;B=p.y*g+g;n=0;for(v=p.material.length;n<v;n++){q=p.material[n];if(q instanceof THREE.ParticleDOMMaterial){q=q.domElement;q.style.left=w+"px";q.style.top=B+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(va){if(p!=va)l.globalAlpha=p=va}function b(va){if(q!=va){switch(va){case THREE.NormalBlending:l.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:l.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:l.globalCompositeOperation="darker"}q=va}}var c=null,d=new THREE.Projector,f=document.createElement("canvas"),g,h,k,j,l=f.getContext("2d"),n=new THREE.Color(0),v=0,p=1,q=0,w=null,B=null,H=1,u,I,o,M,e,ba,O,P,V,T=new THREE.Color,
Y=new THREE.Color,da=new THREE.Color,J=new THREE.Color,$=new THREE.Color,ra,Z,la,ja,fa,sa,m,A,x,t=new THREE.Rectangle,y=new THREE.Rectangle,C=new THREE.Rectangle,D=!1,E=new THREE.Color,K=new THREE.Color,W=new THREE.Color,z=new THREE.Color,F=Math.PI*2,L=new THREE.Vector3,G,U,pa,ka,oa,na,ma=16;G=document.createElement("canvas");G.width=G.height=2;U=G.getContext("2d");U.fillStyle="rgba(0,0,0,1)";U.fillRect(0,0,2,2);pa=U.getImageData(0,0,2,2);ka=pa.data;oa=document.createElement("canvas");oa.width=oa.height=
ma;na=oa.getContext("2d");na.translate(-ma/2,-ma/2);na.scale(ma,ma);ma--;this.domElement=f;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setSize=function(va,Q){g=va;h=Q;k=g/2;j=h/2;f.width=g;f.height=h;t.set(-k,-j,k,j);p=1;q=0;B=w=null;H=1};this.setClearColor=function(va,Q){n=va;v=Q;y.set(-k,-j,k,j);l.setTransform(1,0,0,-1,k,j);this.clear()};this.setClearColorHex=function(va,Q){n.setHex(va);v=Q;y.set(-k,-j,k,j);l.setTransform(1,0,0,-1,k,j);this.clear()};this.clear=function(){l.setTransform(1,
0,0,-1,k,j);if(!y.isEmpty()){y.inflate(1);y.minSelf(t);if(n.hex==0&&v==0)l.clearRect(y.getX(),y.getY(),y.getWidth(),y.getHeight());else{b(THREE.NormalBlending);a(1);l.fillStyle="rgba("+Math.floor(n.r*255)+","+Math.floor(n.g*255)+","+Math.floor(n.b*255)+","+v+")";l.fillRect(y.getX(),y.getY(),y.getWidth(),y.getHeight())}y.empty()}};this.render=function(va,Q){function Ia(R){var ga,ha,S,ea=R.lights;K.setRGB(0,0,0);W.setRGB(0,0,0);z.setRGB(0,0,0);R=0;for(ga=ea.length;R<ga;R++){ha=ea[R];S=ha.color;if(ha instanceof
THREE.AmbientLight){K.r+=S.r;K.g+=S.g;K.b+=S.b}else if(ha instanceof THREE.DirectionalLight){W.r+=S.r;W.g+=S.g;W.b+=S.b}else if(ha instanceof THREE.PointLight){z.r+=S.r;z.g+=S.g;z.b+=S.b}}}function Ea(R,ga,ha,S){var ea,qa,Aa,Ga,Ha=R.lights;R=0;for(ea=Ha.length;R<ea;R++){qa=Ha[R];Aa=qa.color;Ga=qa.intensity;if(qa instanceof THREE.DirectionalLight){qa=ha.dot(qa.position)*Ga;if(qa>0){S.r+=Aa.r*qa;S.g+=Aa.g*qa;S.b+=Aa.b*qa}}else if(qa instanceof THREE.PointLight){L.sub(qa.position,ga);L.normalize();qa=
ha.dot(L)*Ga;if(qa>0){S.r+=Aa.r*qa;S.g+=Aa.g*qa;S.b+=Aa.b*qa}}}}function Ka(R,ga,ha){if(ha.opacity!=0){a(ha.opacity);b(ha.blending);var S,ea,qa,Aa,Ga,Ha;if(ha instanceof THREE.ParticleBasicMaterial){if(ha.map){Aa=ha.map.image;Ga=Aa.width>>1;Ha=Aa.height>>1;ea=ga.scale.x*k;qa=ga.scale.y*j;ha=ea*Ga;S=qa*Ha;C.set(R.x-ha,R.y-S,R.x+ha,R.y+S);if(t.instersects(C)){l.save();l.translate(R.x,R.y);l.rotate(-ga.rotation);l.scale(ea,-qa);l.translate(-Ga,-Ha);l.drawImage(Aa,0,0);l.restore()}}}else if(ha instanceof
THREE.ParticleCircleMaterial){if(D){E.r=K.r+W.r+z.r;E.g=K.g+W.g+z.g;E.b=K.b+W.b+z.b;T.r=ha.color.r*E.r;T.g=ha.color.g*E.g;T.b=ha.color.b*E.b;T.updateStyleString()}else T.__styleString=ha.color.__styleString;ha=ga.scale.x*k;S=ga.scale.y*j;C.set(R.x-ha,R.y-S,R.x+ha,R.y+S);if(t.instersects(C)){ea=T.__styleString;if(B!=ea)l.fillStyle=B=ea;l.save();l.translate(R.x,R.y);l.rotate(-ga.rotation);l.scale(ha,S);l.beginPath();l.arc(0,0,1,0,F,!0);l.closePath();l.fill();l.restore()}}}}function ca(R,ga,ha,S){if(S.opacity!=
0){a(S.opacity);b(S.blending);l.beginPath();l.moveTo(R.positionScreen.x,R.positionScreen.y);l.lineTo(ga.positionScreen.x,ga.positionScreen.y);l.closePath();if(S instanceof THREE.LineBasicMaterial){T.__styleString=S.color.__styleString;R=S.linewidth;if(H!=R)l.lineWidth=H=R;R=T.__styleString;if(w!=R)l.strokeStyle=w=R;l.stroke();C.inflate(S.linewidth*2)}}}function aa(R,ga,ha,S,ea,qa){if(ea.opacity!=0){a(ea.opacity);b(ea.blending);M=R.positionScreen.x;e=R.positionScreen.y;ba=ga.positionScreen.x;O=ga.positionScreen.y;
P=ha.positionScreen.x;V=ha.positionScreen.y;l.beginPath();l.moveTo(M,e);l.lineTo(ba,O);l.lineTo(P,V);l.lineTo(M,e);l.closePath();if(ea instanceof THREE.MeshBasicMaterial)if(ea.map)ea.map.mapping instanceof THREE.UVMapping&&Fa(M,e,ba,O,P,V,ea.map.image,S.uvs[0].u,S.uvs[0].v,S.uvs[1].u,S.uvs[1].v,S.uvs[2].u,S.uvs[2].v);else if(ea.envMap){if(ea.envMap.mapping instanceof THREE.SphericalReflectionMapping){R=Q.matrixWorldInverse;L.copy(S.vertexNormalsWorld[0]);ja=(L.x*R.n11+L.y*R.n12+L.z*R.n13)*0.5+0.5;
fa=-(L.x*R.n21+L.y*R.n22+L.z*R.n23)*0.5+0.5;L.copy(S.vertexNormalsWorld[1]);sa=(L.x*R.n11+L.y*R.n12+L.z*R.n13)*0.5+0.5;m=-(L.x*R.n21+L.y*R.n22+L.z*R.n23)*0.5+0.5;L.copy(S.vertexNormalsWorld[2]);A=(L.x*R.n11+L.y*R.n12+L.z*R.n13)*0.5+0.5;x=-(L.x*R.n21+L.y*R.n22+L.z*R.n23)*0.5+0.5;Fa(M,e,ba,O,P,V,ea.envMap.image,ja,fa,sa,m,A,x)}}else ea.wireframe?X(ea.color.__styleString,ea.wireframeLinewidth):ta(ea.color.__styleString);else if(ea instanceof THREE.MeshLambertMaterial){if(ea.map&&!ea.wireframe){ea.map.mapping instanceof
THREE.UVMapping&&Fa(M,e,ba,O,P,V,ea.map.image,S.uvs[0].u,S.uvs[0].v,S.uvs[1].u,S.uvs[1].v,S.uvs[2].u,S.uvs[2].v);b(THREE.SubtractiveBlending)}if(D)if(!ea.wireframe&&ea.shading==THREE.SmoothShading&&S.vertexNormalsWorld.length==3){Y.r=da.r=J.r=K.r;Y.g=da.g=J.g=K.g;Y.b=da.b=J.b=K.b;Ea(qa,S.v1.positionWorld,S.vertexNormalsWorld[0],Y);Ea(qa,S.v2.positionWorld,S.vertexNormalsWorld[1],da);Ea(qa,S.v3.positionWorld,S.vertexNormalsWorld[2],J);$.r=(da.r+J.r)*0.5;$.g=(da.g+J.g)*0.5;$.b=(da.b+J.b)*0.5;la=Ca(Y,
da,J,$);Fa(M,e,ba,O,P,V,la,0,0,1,0,0,1)}else{E.r=K.r;E.g=K.g;E.b=K.b;Ea(qa,S.centroidWorld,S.normalWorld,E);T.r=ea.color.r*E.r;T.g=ea.color.g*E.g;T.b=ea.color.b*E.b;T.updateStyleString();ea.wireframe?X(T.__styleString,ea.wireframeLinewidth):ta(T.__styleString)}else ea.wireframe?X(ea.color.__styleString,ea.wireframeLinewidth):ta(ea.color.__styleString)}else if(ea instanceof THREE.MeshDepthMaterial){ra=Q.near;Z=Q.far;Y.r=Y.g=Y.b=1-N(R.positionScreen.z,ra,Z);da.r=da.g=da.b=1-N(ga.positionScreen.z,ra,
Z);J.r=J.g=J.b=1-N(ha.positionScreen.z,ra,Z);$.r=(da.r+J.r)*0.5;$.g=(da.g+J.g)*0.5;$.b=(da.b+J.b)*0.5;la=Ca(Y,da,J,$);Fa(M,e,ba,O,P,V,la,0,0,1,0,0,1)}else if(ea instanceof THREE.MeshNormalMaterial){T.r=Da(S.normalWorld.x);T.g=Da(S.normalWorld.y);T.b=Da(S.normalWorld.z);T.updateStyleString();ea.wireframe?X(T.__styleString,ea.wireframeLinewidth):ta(T.__styleString)}}}function X(R,ga){if(w!=R)l.strokeStyle=w=R;if(H!=ga)l.lineWidth=H=ga;l.stroke();C.inflate(ga*2)}function ta(R){if(B!=R)l.fillStyle=B=
R;l.fill()}function Fa(R,ga,ha,S,ea,qa,Aa,Ga,Ha,La,Ba,Ma,Ta){var Na,Oa;Na=Aa.width-1;Oa=Aa.height-1;Ga*=Na;Ha*=Oa;La*=Na;Ba*=Oa;Ma*=Na;Ta*=Oa;ha-=R;S-=ga;ea-=R;qa-=ga;La-=Ga;Ba-=Ha;Ma-=Ga;Ta-=Ha;Na=La*Ta-Ma*Ba;if(Na!=0){Oa=1/Na;Na=(Ta*ha-Ba*ea)*Oa;Ba=(Ta*S-Ba*qa)*Oa;ha=(La*ea-Ma*ha)*Oa;S=(La*qa-Ma*S)*Oa;R=R-Na*Ga-ha*Ha;ga=ga-Ba*Ga-S*Ha;l.save();l.transform(Na,Ba,ha,S,R,ga);l.clip();l.drawImage(Aa,0,0);l.restore()}}function Ca(R,ga,ha,S){var ea=~~(R.r*255),qa=~~(R.g*255);R=~~(R.b*255);var Aa=~~(ga.r*
255),Ga=~~(ga.g*255);ga=~~(ga.b*255);var Ha=~~(ha.r*255),La=~~(ha.g*255);ha=~~(ha.b*255);var Ba=~~(S.r*255),Ma=~~(S.g*255);S=~~(S.b*255);ka[0]=ea<0?0:ea>255?255:ea;ka[1]=qa<0?0:qa>255?255:qa;ka[2]=R<0?0:R>255?255:R;ka[4]=Aa<0?0:Aa>255?255:Aa;ka[5]=Ga<0?0:Ga>255?255:Ga;ka[6]=ga<0?0:ga>255?255:ga;ka[8]=Ha<0?0:Ha>255?255:Ha;ka[9]=La<0?0:La>255?255:La;ka[10]=ha<0?0:ha>255?255:ha;ka[12]=Ba<0?0:Ba>255?255:Ba;ka[13]=Ma<0?0:Ma>255?255:Ma;ka[14]=S<0?0:S>255?255:S;U.putImageData(pa,0,0);na.drawImage(G,0,0);
return oa}function N(R,ga,ha){R=(R-ga)/(ha-ga);return R*R*(3-2*R)}function Da(R){R=(R+1)*0.5;return R<0?0:R>1?1:R}function Ra(R,ga){var ha=ga.x-R.x,S=ga.y-R.y,ea=1/Math.sqrt(ha*ha+S*S);ha*=ea;S*=ea;ga.x+=ha;ga.y+=S;R.x-=ha;R.y-=S}var Pa,Ja,ia,xa,ua,ya,za,wa;this.autoClear?this.clear():l.setTransform(1,0,0,-1,k,j);c=d.projectScene(va,Q,this.sortElements);(D=va.lights.length>0)&&Ia(va);Pa=0;for(Ja=c.length;Pa<Ja;Pa++){ia=c[Pa];C.empty();if(ia instanceof THREE.RenderableParticle){u=ia;u.x*=k;u.y*=j;
xa=0;for(ua=ia.materials.length;xa<ua;xa++)Ka(u,ia,ia.materials[xa],va)}else if(ia instanceof THREE.RenderableLine){u=ia.v1;I=ia.v2;u.positionScreen.x*=k;u.positionScreen.y*=j;I.positionScreen.x*=k;I.positionScreen.y*=j;C.addPoint(u.positionScreen.x,u.positionScreen.y);C.addPoint(I.positionScreen.x,I.positionScreen.y);if(t.instersects(C)){xa=0;for(ua=ia.materials.length;xa<ua;)ca(u,I,ia,ia.materials[xa++],va)}}else if(ia instanceof THREE.RenderableFace3){u=ia.v1;I=ia.v2;o=ia.v3;u.positionScreen.x*=
k;u.positionScreen.y*=j;I.positionScreen.x*=k;I.positionScreen.y*=j;o.positionScreen.x*=k;o.positionScreen.y*=j;if(ia.overdraw){Ra(u.positionScreen,I.positionScreen);Ra(I.positionScreen,o.positionScreen);Ra(o.positionScreen,u.positionScreen)}C.add3Points(u.positionScreen.x,u.positionScreen.y,I.positionScreen.x,I.positionScreen.y,o.positionScreen.x,o.positionScreen.y);if(t.instersects(C)){xa=0;for(ua=ia.meshMaterials.length;xa<ua;){wa=ia.meshMaterials[xa++];if(wa instanceof THREE.MeshFaceMaterial){ya=
0;for(za=ia.faceMaterials.length;ya<za;)(wa=ia.faceMaterials[ya++])&&aa(u,I,o,ia,wa,va)}else aa(u,I,o,ia,wa,va)}}}y.addRectangle(C)}l.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(ja,fa,sa){var m,A,x,t;m=0;for(A=ja.lights.length;m<A;m++){x=ja.lights[m];if(x instanceof THREE.DirectionalLight){t=fa.normalWorld.dot(x.position)*x.intensity;if(t>0){sa.r+=x.color.r*t;sa.g+=x.color.g*t;sa.b+=x.color.b*t}}else if(x instanceof THREE.PointLight){V.sub(x.position,fa.centroidWorld);V.normalize();t=fa.normalWorld.dot(V)*x.intensity;if(t>0){sa.r+=x.color.r*t;sa.g+=x.color.g*t;sa.b+=x.color.b*t}}}}function b(ja,fa,sa,m,A,x){J=d($++);J.setAttribute("d",
"M "+ja.positionScreen.x+" "+ja.positionScreen.y+" L "+fa.positionScreen.x+" "+fa.positionScreen.y+" L "+sa.positionScreen.x+","+sa.positionScreen.y+"z");if(A instanceof THREE.MeshBasicMaterial)o.__styleString=A.color.__styleString;else if(A instanceof THREE.MeshLambertMaterial)if(I){M.r=e.r;M.g=e.g;M.b=e.b;a(x,m,M);o.r=A.color.r*M.r;o.g=A.color.g*M.g;o.b=A.color.b*M.b;o.updateStyleString()}else o.__styleString=A.color.__styleString;else if(A instanceof THREE.MeshDepthMaterial){P=1-A.__2near/(A.__farPlusNear-
m.z*A.__farMinusNear);o.setRGB(P,P,P)}else A instanceof THREE.MeshNormalMaterial&&o.setRGB(f(m.normalWorld.x),f(m.normalWorld.y),f(m.normalWorld.z));A.wireframe?J.setAttribute("style","fill: none; stroke: "+o.__styleString+"; stroke-width: "+A.wireframeLinewidth+"; stroke-opacity: "+A.opacity+"; stroke-linecap: "+A.wireframeLinecap+"; stroke-linejoin: "+A.wireframeLinejoin):J.setAttribute("style","fill: "+o.__styleString+"; fill-opacity: "+A.opacity);k.appendChild(J)}function c(ja,fa,sa,m,A,x,t){J=
d($++);J.setAttribute("d","M "+ja.positionScreen.x+" "+ja.positionScreen.y+" L "+fa.positionScreen.x+" "+fa.positionScreen.y+" L "+sa.positionScreen.x+","+sa.positionScreen.y+" L "+m.positionScreen.x+","+m.positionScreen.y+"z");if(x instanceof THREE.MeshBasicMaterial)o.__styleString=x.color.__styleString;else if(x instanceof THREE.MeshLambertMaterial)if(I){M.r=e.r;M.g=e.g;M.b=e.b;a(t,A,M);o.r=x.color.r*M.r;o.g=x.color.g*M.g;o.b=x.color.b*M.b;o.updateStyleString()}else o.__styleString=x.color.__styleString;
else if(x instanceof THREE.MeshDepthMaterial){P=1-x.__2near/(x.__farPlusNear-A.z*x.__farMinusNear);o.setRGB(P,P,P)}else x instanceof THREE.MeshNormalMaterial&&o.setRGB(f(A.normalWorld.x),f(A.normalWorld.y),f(A.normalWorld.z));x.wireframe?J.setAttribute("style","fill: none; stroke: "+o.__styleString+"; stroke-width: "+x.wireframeLinewidth+"; stroke-opacity: "+x.opacity+"; stroke-linecap: "+x.wireframeLinecap+"; stroke-linejoin: "+x.wireframeLinejoin):J.setAttribute("style","fill: "+o.__styleString+
"; fill-opacity: "+x.opacity);k.appendChild(J)}function d(ja){if(T[ja]==null){T[ja]=document.createElementNS("http://www.w3.org/2000/svg","path");la==0&&T[ja].setAttribute("shape-rendering","crispEdges")}return T[ja]}function f(ja){return ja<0?Math.min((1+ja)*0.5,0.5):0.5+Math.min(ja*0.5,0.5)}var g=null,h=new THREE.Projector,k=document.createElementNS("http://www.w3.org/2000/svg","svg"),j,l,n,v,p,q,w,B,H=new THREE.Rectangle,u=new THREE.Rectangle,I=!1,o=new THREE.Color(16777215),M=new THREE.Color(16777215),
e=new THREE.Color(0),ba=new THREE.Color(0),O=new THREE.Color(0),P,V=new THREE.Vector3,T=[],Y=[],da=[],J,$,ra,Z,la=1;this.domElement=k;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setQuality=function(ja){switch(ja){case "high":la=1;break;case "low":la=0}};this.setSize=function(ja,fa){j=ja;l=fa;n=j/2;v=l/2;k.setAttribute("viewBox",-n+" "+-v+" "+j+" "+l);k.setAttribute("width",j);k.setAttribute("height",l);H.set(-n,-v,n,v)};this.clear=function(){for(;k.childNodes.length>0;)k.removeChild(k.childNodes[0])};
this.render=function(ja,fa){var sa,m,A,x,t,y,C,D;this.autoClear&&this.clear();g=h.projectScene(ja,fa,this.sortElements);Z=ra=$=0;if(I=ja.lights.length>0){C=ja.lights;e.setRGB(0,0,0);ba.setRGB(0,0,0);O.setRGB(0,0,0);sa=0;for(m=C.length;sa<m;sa++){A=C[sa];x=A.color;if(A instanceof THREE.AmbientLight){e.r+=x.r;e.g+=x.g;e.b+=x.b}else if(A instanceof THREE.DirectionalLight){ba.r+=x.r;ba.g+=x.g;ba.b+=x.b}else if(A instanceof THREE.PointLight){O.r+=x.r;O.g+=x.g;O.b+=x.b}}}sa=0;for(m=g.length;sa<m;sa++){C=
g[sa];u.empty();if(C instanceof THREE.RenderableParticle){p=C;p.x*=n;p.y*=-v;A=0;for(x=C.materials.length;A<x;A++)if(D=C.materials[A]){t=p;y=C;var E=ra++;if(Y[E]==null){Y[E]=document.createElementNS("http://www.w3.org/2000/svg","circle");la==0&&Y[E].setAttribute("shape-rendering","crispEdges")}J=Y[E];J.setAttribute("cx",t.x);J.setAttribute("cy",t.y);J.setAttribute("r",y.scale.x*n);if(D instanceof THREE.ParticleCircleMaterial){if(I){M.r=e.r+ba.r+O.r;M.g=e.g+ba.g+O.g;M.b=e.b+ba.b+O.b;o.r=D.color.r*
M.r;o.g=D.color.g*M.g;o.b=D.color.b*M.b;o.updateStyleString()}else o=D.color;J.setAttribute("style","fill: "+o.__styleString)}k.appendChild(J)}}else if(C instanceof THREE.RenderableLine){p=C.v1;q=C.v2;p.positionScreen.x*=n;p.positionScreen.y*=-v;q.positionScreen.x*=n;q.positionScreen.y*=-v;u.addPoint(p.positionScreen.x,p.positionScreen.y);u.addPoint(q.positionScreen.x,q.positionScreen.y);if(H.instersects(u)){A=0;for(x=C.materials.length;A<x;)if(D=C.materials[A++]){t=p;y=q;E=Z++;if(da[E]==null){da[E]=
document.createElementNS("http://www.w3.org/2000/svg","line");la==0&&da[E].setAttribute("shape-rendering","crispEdges")}J=da[E];J.setAttribute("x1",t.positionScreen.x);J.setAttribute("y1",t.positionScreen.y);J.setAttribute("x2",y.positionScreen.x);J.setAttribute("y2",y.positionScreen.y);if(D instanceof THREE.LineBasicMaterial){o.__styleString=D.color.__styleString;J.setAttribute("style","fill: none; stroke: "+o.__styleString+"; stroke-width: "+D.linewidth+"; stroke-opacity: "+D.opacity+"; stroke-linecap: "+
D.linecap+"; stroke-linejoin: "+D.linejoin);k.appendChild(J)}}}}else if(C instanceof THREE.RenderableFace3){p=C.v1;q=C.v2;w=C.v3;p.positionScreen.x*=n;p.positionScreen.y*=-v;q.positionScreen.x*=n;q.positionScreen.y*=-v;w.positionScreen.x*=n;w.positionScreen.y*=-v;u.addPoint(p.positionScreen.x,p.positionScreen.y);u.addPoint(q.positionScreen.x,q.positionScreen.y);u.addPoint(w.positionScreen.x,w.positionScreen.y);if(H.instersects(u)){A=0;for(x=C.meshMaterials.length;A<x;){D=C.meshMaterials[A++];if(D instanceof
THREE.MeshFaceMaterial){t=0;for(y=C.faceMaterials.length;t<y;)(D=C.faceMaterials[t++])&&b(p,q,w,C,D,ja)}else D&&b(p,q,w,C,D,ja)}}}else if(C instanceof THREE.RenderableFace4){p=C.v1;q=C.v2;w=C.v3;B=C.v4;p.positionScreen.x*=n;p.positionScreen.y*=-v;q.positionScreen.x*=n;q.positionScreen.y*=-v;w.positionScreen.x*=n;w.positionScreen.y*=-v;B.positionScreen.x*=n;B.positionScreen.y*=-v;u.addPoint(p.positionScreen.x,p.positionScreen.y);u.addPoint(q.positionScreen.x,q.positionScreen.y);u.addPoint(w.positionScreen.x,
w.positionScreen.y);u.addPoint(B.positionScreen.x,B.positionScreen.y);if(H.instersects(u)){A=0;for(x=C.meshMaterials.length;A<x;){D=C.meshMaterials[A++];if(D instanceof THREE.MeshFaceMaterial){t=0;for(y=C.faceMaterials.length;t<y;)(D=C.faceMaterials[t++])&&c(p,q,w,B,C,D,ja)}else D&&c(p,q,w,B,C,D,ja)}}}}}};
THREE.WebGLRenderer=function(a){function b(m,A,x){var t,y,C,D=m.vertices,E=D.length,K=m.colors,W=K.length,z=m.__vertexArray,F=m.__colorArray,L=m.__sortArray,G=m.__dirtyVertices,U=m.__dirtyColors;if(x.sortParticles){$.multiplySelf(x.matrixWorld);for(t=0;t<E;t++){y=D[t].position;la.copy(y);$.multiplyVector3(la);L[t]=[la.z,t]}L.sort(function(pa,ka){return ka[0]-pa[0]});for(t=0;t<E;t++){y=D[L[t][1]].position;C=t*3;z[C]=y.x;z[C+1]=y.y;z[C+2]=y.z}for(t=0;t<W;t++){C=t*3;color=K[L[t][1]];F[C]=color.r;F[C+
1]=color.g;F[C+2]=color.b}}else{if(G)for(t=0;t<E;t++){y=D[t].position;C=t*3;z[C]=y.x;z[C+1]=y.y;z[C+2]=y.z}if(U)for(t=0;t<W;t++){color=K[t];C=t*3;F[C]=color.r;F[C+1]=color.g;F[C+2]=color.b}}if(G||x.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,m.__webGLVertexBuffer);e.bufferData(e.ARRAY_BUFFER,z,A)}if(U||x.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,m.__webGLColorBuffer);e.bufferData(e.ARRAY_BUFFER,F,A)}}function c(m,A){m.fragmentShader=A.fragmentShader;m.vertexShader=A.vertexShader;m.uniforms=Uniforms.clone(A.uniforms)}
function d(m,A,x,t,y){t.program||P.initMaterial(t,A,x);var C=t.program,D=C.uniforms,E=t.uniforms;if(C!=ba){e.useProgram(C);ba=C;e.uniformMatrix4fv(D.projectionMatrix,!1,ra)}if(x&&(t instanceof THREE.MeshBasicMaterial||t instanceof THREE.MeshLambertMaterial||t instanceof THREE.MeshPhongMaterial||t instanceof THREE.LineBasicMaterial||t instanceof THREE.ParticleBasicMaterial)){E.fogColor.value.setHex(x.color.hex);if(x instanceof THREE.Fog){E.fogNear.value=x.near;E.fogFar.value=x.far}else if(x instanceof
THREE.FogExp2)E.fogDensity.value=x.density}if(t instanceof THREE.MeshPhongMaterial||t instanceof THREE.MeshLambertMaterial){var K,W,z=0,F=0,L=0,G,U,pa,ka=P.lights,oa=ka.directional.colors,na=ka.directional.positions,ma=ka.point.colors,va=ka.point.positions,Q=0,Ia=0;x=W=W=0;for(K=A.length;x<K;x++){W=A[x];G=W.color;U=W.position;pa=W.intensity;if(W instanceof THREE.AmbientLight){z+=G.r;F+=G.g;L+=G.b}else if(W instanceof THREE.DirectionalLight){W=Q*3;oa[W]=G.r*pa;oa[W+1]=G.g*pa;oa[W+2]=G.b*pa;na[W]=U.x;
na[W+1]=U.y;na[W+2]=U.z;Q+=1}else if(W instanceof THREE.PointLight){W=Ia*3;ma[W]=G.r*pa;ma[W+1]=G.g*pa;ma[W+2]=G.b*pa;va[W]=U.x;va[W+1]=U.y;va[W+2]=U.z;Ia+=1}}for(x=Q*3;x<oa.length;x++)oa[x]=0;for(x=Ia*3;x<ma.length;x++)ma[x]=0;ka.point.length=Ia;ka.directional.length=Q;ka.ambient[0]=z;ka.ambient[1]=F;ka.ambient[2]=L;A=P.lights;E.enableLighting.value=A.directional.length+A.point.length;E.ambientLightColor.value=A.ambient;E.directionalLightColor.value=A.directional.colors;E.directionalLightDirection.value=
A.directional.positions;E.pointLightColor.value=A.point.colors;E.pointLightPosition.value=A.point.positions}if(t instanceof THREE.MeshBasicMaterial||t instanceof THREE.MeshLambertMaterial||t instanceof THREE.MeshPhongMaterial){E.diffuse.value.setRGB(t.color.r*t.opacity,t.color.g*t.opacity,t.color.b*t.opacity);E.opacity.value=t.opacity;E.map.texture=t.map;E.lightMap.texture=t.lightMap;E.envMap.texture=t.envMap;E.reflectivity.value=t.reflectivity;E.refractionRatio.value=t.refractionRatio;E.combine.value=
t.combine;E.useRefract.value=t.envMap&&t.envMap.mapping instanceof THREE.CubeRefractionMapping}if(t instanceof THREE.LineBasicMaterial){E.diffuse.value.setRGB(t.color.r*t.opacity,t.color.g*t.opacity,t.color.b*t.opacity);E.opacity.value=t.opacity}else if(t instanceof THREE.ParticleBasicMaterial){E.psColor.value.setRGB(t.color.r*t.opacity,t.color.g*t.opacity,t.color.b*t.opacity);E.opacity.value=t.opacity;E.size.value=t.size;E.map.texture=t.map}else if(t instanceof THREE.MeshPhongMaterial){E.ambient.value.setRGB(t.ambient.r,
t.ambient.g,t.ambient.b);E.specular.value.setRGB(t.specular.r,t.specular.g,t.specular.b);E.shininess.value=t.shininess}else if(t instanceof THREE.MeshDepthMaterial){E.mNear.value=m.near;E.mFar.value=m.far;E.opacity.value=t.opacity}else if(t instanceof THREE.MeshNormalMaterial)E.opacity.value=t.opacity;for(var Ea in E)if(z=C.uniforms[Ea]){x=E[Ea];K=x.type;A=x.value;if(K=="i")e.uniform1i(z,A);else if(K=="f")e.uniform1f(z,A);else if(K=="fv1")e.uniform1fv(z,A);else if(K=="fv")e.uniform3fv(z,A);else if(K==
"v2")e.uniform2f(z,A.x,A.y);else if(K=="v3")e.uniform3f(z,A.x,A.y,A.z);else if(K=="c")e.uniform3f(z,A.r,A.g,A.b);else if(K=="t"){e.uniform1i(z,A);if(x=x.texture)if(x.image instanceof Array&&x.image.length==6){if(x.image.length==6){if(x.needsUpdate){if(!x.image.__webGLTextureCube)x.image.__webGLTextureCube=e.createTexture();e.bindTexture(e.TEXTURE_CUBE_MAP,x.image.__webGLTextureCube);e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_WRAP_T,
e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_MAG_FILTER,e.LINEAR);e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_MIN_FILTER,e.LINEAR_MIPMAP_LINEAR);for(K=0;K<6;++K)e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+K,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,x.image[K]);e.generateMipmap(e.TEXTURE_CUBE_MAP);e.bindTexture(e.TEXTURE_CUBE_MAP,null);x.needsUpdate=!1}e.activeTexture(e.TEXTURE0+A);e.bindTexture(e.TEXTURE_CUBE_MAP,x.image.__webGLTextureCube)}}else{if(x.needsUpdate){if(x.__wasSetOnce){e.bindTexture(e.TEXTURE_2D,
x.__webGLTexture);e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,x.image);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,o(x.wrapS));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,o(x.wrapT));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,o(x.magFilter));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,o(x.minFilter));e.generateMipmap(e.TEXTURE_2D);e.bindTexture(e.TEXTURE_2D,null)}else{x.__webGLTexture=e.createTexture();e.bindTexture(e.TEXTURE_2D,x.__webGLTexture);e.texImage2D(e.TEXTURE_2D,
0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,x.image);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,o(x.wrapS));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,o(x.wrapT));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,o(x.magFilter));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,o(x.minFilter));e.generateMipmap(e.TEXTURE_2D);e.bindTexture(e.TEXTURE_2D,null);x.__wasSetOnce=!0}x.needsUpdate=!1}e.activeTexture(e.TEXTURE0+A);e.bindTexture(e.TEXTURE_2D,x.__webGLTexture)}}}e.uniformMatrix4fv(D.modelViewMatrix,
!1,y._modelViewMatrixArray);e.uniformMatrix3fv(D.normalMatrix,!1,y._normalMatrixArray);(t instanceof THREE.MeshShaderMaterial||t instanceof THREE.MeshPhongMaterial||t.envMap)&&e.uniform3f(D.cameraPosition,m.position.x,m.position.y,m.position.z);(t instanceof THREE.MeshShaderMaterial||t.envMap||t.skinning)&&e.uniformMatrix4fv(D.objectMatrix,!1,y._objectMatrixArray);(t instanceof THREE.MeshPhongMaterial||t instanceof THREE.MeshLambertMaterial||t instanceof THREE.MeshShaderMaterial||t.skinning)&&e.uniformMatrix4fv(D.viewMatrix,
!1,Z);if(t.skinning){e.uniformMatrix4fv(D.cameraInverseMatrix,!1,Z);e.uniformMatrix4fv(D.boneGlobalMatrices,!1,y.boneMatrices)}return C}function f(m,A,x,t,y,C){m=d(m,A,x,t,C).attributes;e.bindBuffer(e.ARRAY_BUFFER,y.__webGLVertexBuffer);e.vertexAttribPointer(m.position,3,e.FLOAT,!1,0,0);if(m.color>=0){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLColorBuffer);e.vertexAttribPointer(m.color,3,e.FLOAT,!1,0,0)}if(m.normal>=0){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLNormalBuffer);e.vertexAttribPointer(m.normal,3,
e.FLOAT,!1,0,0)}if(m.tangent>=0){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLTangentBuffer);e.vertexAttribPointer(m.tangent,4,e.FLOAT,!1,0,0)}if(m.uv>=0)if(y.__webGLUVBuffer){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLUVBuffer);e.vertexAttribPointer(m.uv,2,e.FLOAT,!1,0,0);e.enableVertexAttribArray(m.uv)}else e.disableVertexAttribArray(m.uv);if(m.uv2>=0)if(y.__webGLUV2Buffer){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLUV2Buffer);e.vertexAttribPointer(m.uv2,2,e.FLOAT,!1,0,0);e.enableVertexAttribArray(m.uv2)}else e.disableVertexAttribArray(m.uv2);
if(t.skinning&&m.skinVertexA>=0&&m.skinVertexB>=0&&m.skinIndex>=0&&m.skinWeight>=0){e.bindBuffer(e.ARRAY_BUFFER,y.__webGLSkinVertexABuffer);e.vertexAttribPointer(m.skinVertexA,4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,y.__webGLSkinVertexBBuffer);e.vertexAttribPointer(m.skinVertexB,4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,y.__webGLSkinIndicesBuffer);e.vertexAttribPointer(m.skinIndex,4,e.FLOAT,!1,0,0);e.bindBuffer(e.ARRAY_BUFFER,y.__webGLSkinWeightsBuffer);e.vertexAttribPointer(m.skinWeight,
4,e.FLOAT,!1,0,0)}if(C instanceof THREE.Mesh)if(t.wireframe){e.lineWidth(t.wireframeLinewidth);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,y.__webGLLineBuffer);e.drawElements(e.LINES,y.__webGLLineCount,e.UNSIGNED_SHORT,0)}else{e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,y.__webGLFaceBuffer);e.drawElements(e.TRIANGLES,y.__webGLFaceCount,e.UNSIGNED_SHORT,0)}else if(C instanceof THREE.Line){C=C.type==THREE.LineStrip?e.LINE_STRIP:e.LINES;e.lineWidth(t.linewidth);e.drawArrays(C,0,y.__webGLLineCount)}else if(C instanceof
THREE.ParticleSystem)e.drawArrays(e.POINTS,0,y.__webGLParticleCount);else C instanceof THREE.Ribbon&&e.drawArrays(e.TRIANGLE_STRIP,0,y.__webGLVertexCount)}function g(m,A){if(!m.__webGLVertexBuffer)m.__webGLVertexBuffer=e.createBuffer();if(!m.__webGLNormalBuffer)m.__webGLNormalBuffer=e.createBuffer();if(m.hasPos){e.bindBuffer(e.ARRAY_BUFFER,m.__webGLVertexBuffer);e.bufferData(e.ARRAY_BUFFER,m.positionArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(A.attributes.position);e.vertexAttribPointer(A.attributes.position,
3,e.FLOAT,!1,0,0)}if(m.hasNormal){e.bindBuffer(e.ARRAY_BUFFER,m.__webGLNormalBuffer);e.bufferData(e.ARRAY_BUFFER,m.normalArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(A.attributes.normal);e.vertexAttribPointer(A.attributes.normal,3,e.FLOAT,!1,0,0)}e.drawArrays(e.TRIANGLES,0,m.count);m.count=0}function h(m){if(V!=m.doubleSided){m.doubleSided?e.disable(e.CULL_FACE):e.enable(e.CULL_FACE);V=m.doubleSided}if(T!=m.flipSided){m.flipSided?e.frontFace(e.CW):e.frontFace(e.CCW);T=m.flipSided}}function k(m){if(da!=
m){m?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST);da=m}}function j(m){J[0].set(m.n41-m.n11,m.n42-m.n12,m.n43-m.n13,m.n44-m.n14);J[1].set(m.n41+m.n11,m.n42+m.n12,m.n43+m.n13,m.n44+m.n14);J[2].set(m.n41+m.n21,m.n42+m.n22,m.n43+m.n23,m.n44+m.n24);J[3].set(m.n41-m.n21,m.n42-m.n22,m.n43-m.n23,m.n44-m.n24);J[4].set(m.n41-m.n31,m.n42-m.n32,m.n43-m.n33,m.n44-m.n34);J[5].set(m.n41+m.n31,m.n42+m.n32,m.n43+m.n33,m.n44+m.n34);var A;for(m=0;m<6;m++){A=J[m];A.divideScalar(Math.sqrt(A.x*A.x+A.y*A.y+A.z*A.z))}}
function l(m){for(var A=m.matrixWorld,x=-m.geometry.boundingSphere.radius*Math.max(m.scale.x,Math.max(m.scale.y,m.scale.z)),t=0;t<6;t++){m=J[t].x*A.n14+J[t].y*A.n24+J[t].z*A.n34+J[t].w;if(m<=x)return!1}return!0}function n(m,A){m.list[m.count]=A;m.count+=1}function v(m){var A,x,t=m.object,y=m.opaque,C=m.transparent;C.count=0;m=y.count=0;for(A=t.materials.length;m<A;m++){x=t.materials[m];x.opacity&&x.opacity<1||x.blending!=THREE.NormalBlending?n(C,x):n(y,x)}}function p(m){var A,x,t,y,C=m.object,D=m.buffer,
E=m.opaque,K=m.transparent;K.count=0;m=E.count=0;for(t=C.materials.length;m<t;m++){A=C.materials[m];if(A instanceof THREE.MeshFaceMaterial){A=0;for(x=D.materials.length;A<x;A++)(y=D.materials[A])&&(y.opacity&&y.opacity<1||y.blending!=THREE.NormalBlending?n(K,y):n(E,y))}else{y=A;y.opacity&&y.opacity<1||y.blending!=THREE.NormalBlending?n(K,y):n(E,y)}}}function q(m,A){return A.z-m.z}function w(m,A,x,t,y){if(A[x]==undefined){m.push({buffer:t,object:y,opaque:{list:[],count:0},transparent:{list:[],count:0}});
A[x]=1}}function B(m,A){m._modelViewMatrix.multiplyToArray(A.matrixWorldInverse,m.matrixWorld,m._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(m._modelViewMatrix).transposeIntoArray(m._normalMatrixArray)}function H(m){if(m!=Y){switch(m){case THREE.AdditiveBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ONE,e.ONE);break;case THREE.SubtractiveBlending:e.blendFunc(e.DST_COLOR,e.ZERO);break;case THREE.BillboardBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);
break;case THREE.ReverseSubtractiveBlending:e.blendEquation(e.FUNC_REVERSE_SUBTRACT);e.blendFunc(e.ONE,e.ONE);break;default:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ONE,e.ONE_MINUS_SRC_ALPHA)}Y=m}}function u(m,A){if(m&&!m.__webGLFramebuffer){m.__webGLFramebuffer=e.createFramebuffer();m.__webGLRenderbuffer=e.createRenderbuffer();m.__webGLTexture=e.createTexture();e.bindRenderbuffer(e.RENDERBUFFER,m.__webGLRenderbuffer);e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_COMPONENT16,m.width,m.height);e.bindTexture(e.TEXTURE_2D,
m.__webGLTexture);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,o(m.wrapS));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,o(m.wrapT));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,o(m.magFilter));e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,o(m.minFilter));e.texImage2D(e.TEXTURE_2D,0,o(m.format),m.width,m.height,0,o(m.format),o(m.type),null);e.bindFramebuffer(e.FRAMEBUFFER,m.__webGLFramebuffer);e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,m.__webGLTexture,0);e.framebufferRenderbuffer(e.FRAMEBUFFER,
e.DEPTH_ATTACHMENT,e.RENDERBUFFER,m.__webGLRenderbuffer);e.bindTexture(e.TEXTURE_2D,null);e.bindRenderbuffer(e.RENDERBUFFER,null);e.bindFramebuffer(e.FRAMEBUFFER,null)}var x,t,y;if(m){x=m.__webGLFramebuffer;t=m.width;y=m.height}else{x=null;t=M.width;y=M.height}if(x!=O){e.bindFramebuffer(e.FRAMEBUFFER,x);e.viewport(0,0,t,y);A&&e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT);O=x}}function I(m,A){var x;if(m=="fragment")x=e.createShader(e.FRAGMENT_SHADER);else m=="vertex"&&(x=e.createShader(e.VERTEX_SHADER));
e.shaderSource(x,A);e.compileShader(x);if(!e.getShaderParameter(x,e.COMPILE_STATUS)){alert(e.getShaderInfoLog(x));return null}return x}function o(m){switch(m){case THREE.RepeatWrapping:return e.REPEAT;case THREE.ClampToEdgeWrapping:return e.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return e.MIRRORED_REPEAT;case THREE.NearestFilter:return e.NEAREST;case THREE.NearestMipMapNearestFilter:return e.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return e.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return e.LINEAR;
case THREE.LinearMipMapNearestFilter:return e.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return e.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return e.BYTE;case THREE.UnsignedByteType:return e.UNSIGNED_BYTE;case THREE.ShortType:return e.SHORT;case THREE.UnsignedShortType:return e.UNSIGNED_SHORT;case THREE.IntType:return e.INT;case THREE.UnsignedShortType:return e.UNSIGNED_INT;case THREE.FloatType:return e.FLOAT;case THREE.AlphaFormat:return e.ALPHA;case THREE.RGBFormat:return e.RGB;case THREE.RGBAFormat:return e.RGBA;
case THREE.LuminanceFormat:return e.LUMINANCE;case THREE.LuminanceAlphaFormat:return e.LUMINANCE_ALPHA}return 0}var M=document.createElement("canvas"),e,ba=null,O=null,P=this,V=null,T=null,Y=null,da=null,J=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],$=new THREE.Matrix4,ra=new Float32Array(16),Z=new Float32Array(16),la=new THREE.Vector4,ja=!0,fa=new THREE.Color(0),sa=0;if(a){if(a.antialias!==undefined)ja=a.antialias;a.clearColor!==undefined&&
fa.setHex(a.clearColor);if(a.clearAlpha!==undefined)sa=a.clearAlpha}this.domElement=M;this.autoClear=!0;this.sortObjects=!1;(function(m,A,x){try{e=M.getContext("experimental-webgl",{antialias:m})}catch(t){console.log(t)}if(!e)throw"cannot create webgl context";e.clearColor(0,0,0,1);e.clearDepth(1);e.enable(e.DEPTH_TEST);e.depthFunc(e.LEQUAL);e.frontFace(e.CCW);e.cullFace(e.BACK);e.enable(e.CULL_FACE);e.enable(e.BLEND);e.blendFunc(e.ONE,e.ONE_MINUS_SRC_ALPHA);e.clearColor(A.r,A.g,A.b,x);_cullEnabled=
!0})(ja,fa,sa);this.context=e;this.lights={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[]}};this.setSize=function(m,A){M.width=m;M.height=A;e.viewport(0,0,M.width,M.height)};this.setClearColorHex=function(m,A){var x=new THREE.Color(m);e.clearColor(x.r,x.g,x.b,A)};this.setClearColor=function(m,A){e.clearColor(m.r,m.g,m.b,A)};this.clear=function(){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT)};this.initMaterial=function(m,A,x){var t,y;if(m instanceof
THREE.MeshDepthMaterial)c(m,THREE.ShaderLib.depth);else if(m instanceof THREE.MeshNormalMaterial)c(m,THREE.ShaderLib.normal);else if(m instanceof THREE.MeshBasicMaterial)c(m,THREE.ShaderLib.basic);else if(m instanceof THREE.MeshLambertMaterial)c(m,THREE.ShaderLib.lambert);else if(m instanceof THREE.MeshPhongMaterial)c(m,THREE.ShaderLib.phong);else if(m instanceof THREE.LineBasicMaterial)c(m,THREE.ShaderLib.basic);else m instanceof THREE.ParticleBasicMaterial&&c(m,THREE.ShaderLib.particle_basic);var C,
D,E,K;y=E=K=0;for(C=A.length;y<C;y++){D=A[y];D instanceof THREE.DirectionalLight&&E++;D instanceof THREE.PointLight&&K++}if(K+E<=4)A=E;else{A=Math.ceil(4*E/(K+E));K=4-A}y={directional:A,point:K};K=m.fragmentShader;A=m.vertexShader;C={fog:x,map:m.map,envMap:m.envMap,lightMap:m.lightMap,vertexColors:m.vertexColors,skinning:m.skinning,maxDirLights:y.directional,maxPointLights:y.point};x=e.createProgram();y=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+C.maxDirLights,"#define MAX_POINT_LIGHTS "+
C.maxPointLights,C.fog?"#define USE_FOG":"",C.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",C.map?"#define USE_MAP":"",C.envMap?"#define USE_ENVMAP":"",C.lightMap?"#define USE_LIGHTMAP":"",C.vertexColors?"#define USE_COLOR":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");C=[e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+C.maxDirLights,"#define MAX_POINT_LIGHTS "+C.maxPointLights,C.map?"#define USE_MAP":"",C.envMap?
"#define USE_ENVMAP":"",C.lightMap?"#define USE_LIGHTMAP":"",C.vertexColors?"#define USE_COLOR":"",C.skinning?"#define USE_SKINNING":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec3 color;\nattribute vec2 uv;\nattribute vec2 uv2;\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n"].join("\n");
e.attachShader(x,I("fragment",y+K));e.attachShader(x,I("vertex",C+A));e.linkProgram(x);e.getProgramParameter(x,e.LINK_STATUS)||alert("Could not initialise shaders\nVALIDATE_STATUS: "+e.getProgramParameter(x,e.VALIDATE_STATUS)+", gl error ["+e.getError()+"]");x.uniforms={};x.attributes={};m.program=x;x=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices"];for(t in m.uniforms)x.push(t);t=m.program;K=0;for(A=x.length;K<
A;K++){y=x[K];t.uniforms[y]=e.getUniformLocation(t,y)}t=m.program;x=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];K=0;for(A=x.length;K<A;K++){y=x[K];t.attributes[y]=e.getAttribLocation(t,y)}t=m.program.attributes;e.enableVertexAttribArray(t.position);t.color>=0&&e.enableVertexAttribArray(t.color);t.normal>=0&&e.enableVertexAttribArray(t.normal);t.tangent>=0&&e.enableVertexAttribArray(t.tangent);if(m.skinning&&t.skinVertexA>=0&&t.skinVertexB>=
0&&t.skinIndex>=0&&t.skinWeight>=0){e.enableVertexAttribArray(t.skinVertexA);e.enableVertexAttribArray(t.skinVertexB);e.enableVertexAttribArray(t.skinIndex);e.enableVertexAttribArray(t.skinWeight)}};this.render=function(m,A,x,t){var y,C,D,E,K,W,z,F,L=m.lights,G=m.fog;A.matrixAutoUpdate&&A.update();A.matrixWorldInverse.flattenToArray(Z);A.projectionMatrix.flattenToArray(ra);$.multiply(A.projectionMatrix,A.matrixWorldInverse);j($);THREE.AnimationHandler&&THREE.AnimationHandler.update();m.update(undefined,
!1,A);this.initWebGLObjects(m,A);u(x,t!==undefined?t:!0);this.autoClear&&this.clear();K=m.__webGLObjects.length;for(t=0;t<K;t++){y=m.__webGLObjects[t];z=y.object;if(z.visible)if(!(z instanceof THREE.Mesh)||l(z)){z.matrixWorld.flattenToArray(z._objectMatrixArray);B(z,A);p(y);y.render=!0;if(this.sortObjects){la.copy(z.position);$.multiplyVector3(la);y.z=la.z}}else y.render=!1;else y.render=!1}this.sortObjects&&m.__webGLObjects.sort(q);W=m.__webGLObjectsImmediate.length;for(t=0;t<W;t++){y=m.__webGLObjectsImmediate[t];
z=y.object;if(z.visible){z.matrixAutoUpdate&&z.matrixWorld.flattenToArray(z._objectMatrixArray);B(z,A);v(y)}}H(THREE.NormalBlending);for(t=0;t<K;t++){y=m.__webGLObjects[t];if(y.render){z=y.object;F=y.buffer;D=y.opaque;h(z);for(y=0;y<D.count;y++){E=D.list[y];k(E.depthTest);f(A,L,G,E,F,z)}}}for(t=0;t<W;t++){y=m.__webGLObjectsImmediate[t];z=y.object;if(z.visible){D=y.opaque;h(z);for(y=0;y<D.count;y++){E=D.list[y];k(E.depthTest);C=d(A,L,G,E,z);z.render(function(U){g(U,C)})}}}for(t=0;t<K;t++){y=m.__webGLObjects[t];
if(y.render){z=y.object;F=y.buffer;D=y.transparent;h(z);for(y=0;y<D.count;y++){E=D.list[y];H(E.blending);k(E.depthTest);f(A,L,G,E,F,z)}}}for(t=0;t<W;t++){y=m.__webGLObjectsImmediate[t];z=y.object;if(z.visible){D=y.transparent;h(z);for(y=0;y<D.count;y++){E=D.list[y];H(E.blending);k(E.depthTest);C=d(A,L,G,E,z);z.render(function(U){g(U,C)})}}}if(x&&x.minFilter!==THREE.NearestFilter&&x.minFilter!==THREE.LinearFilter){e.bindTexture(e.TEXTURE_2D,x.__webGLTexture);e.generateMipmap(e.TEXTURE_2D);e.bindTexture(e.TEXTURE_2D,
null)}};this.initWebGLObjects=function(m,A){var x,t,y;if(!m.__webGLObjects){m.__webGLObjects=[];m.__webGLObjectsMap={};m.__webGLObjectsImmediate=[]}x=0;for(t=m.objects.length;x<t;x++){y=m.objects[x];var C=m,D=A,E=void 0,K=void 0,W=void 0,z=void 0;K=y.geometry;if(C.__webGLObjectsMap[y.id]==undefined){C.__webGLObjectsMap[y.id]={};y._modelViewMatrix=new THREE.Matrix4;y._normalMatrixArray=new Float32Array(9);y._modelViewMatrixArray=new Float32Array(16);y._objectMatrixArray=new Float32Array(16);y.matrixWorld.flattenToArray(y._objectMatrixArray)}z=
C.__webGLObjectsMap[y.id];objlist=C.__webGLObjects;if(y instanceof THREE.Mesh){for(E in K.geometryChunks){W=K.geometryChunks[E];if(!W.__webGLVertexBuffer){D=W;D.__webGLVertexBuffer=e.createBuffer();D.__webGLNormalBuffer=e.createBuffer();D.__webGLTangentBuffer=e.createBuffer();D.__webGLColorBuffer=e.createBuffer();D.__webGLUVBuffer=e.createBuffer();D.__webGLUV2Buffer=e.createBuffer();D.__webGLSkinVertexABuffer=e.createBuffer();D.__webGLSkinVertexBBuffer=e.createBuffer();D.__webGLSkinIndicesBuffer=
e.createBuffer();D.__webGLSkinWeightsBuffer=e.createBuffer();D.__webGLFaceBuffer=e.createBuffer();D.__webGLLineBuffer=e.createBuffer();D=W;var F=y,L=void 0,G=void 0,U=0,pa=C=0,ka=F.geometry.faces,oa=D.faces;L=0;for(G=oa.length;L<G;L++){fi=oa[L];face=ka[fi];if(face instanceof THREE.Face3){U+=3;C+=1;pa+=3}else if(face instanceof THREE.Face4){U+=4;C+=2;pa+=4}}D.__vertexArray=new Float32Array(U*3);D.__normalArray=new Float32Array(U*3);D.__tangentArray=new Float32Array(U*4);D.__colorArray=new Float32Array(U*
3);D.__uvArray=new Float32Array(U*2);D.__uv2Array=new Float32Array(U*2);D.__skinVertexAArray=new Float32Array(U*4);D.__skinVertexBArray=new Float32Array(U*4);D.__skinIndexArray=new Float32Array(U*4);D.__skinWeightArray=new Float32Array(U*4);D.__faceArray=new Uint16Array(C*3);D.__lineArray=new Uint16Array(pa*2);G=L=D;U=void 0;ka=void 0;var na=void 0,ma=void 0;na=void 0;oa=!1;U=0;for(ka=F.materials.length;U<ka;U++){na=F.materials[U];if(na instanceof THREE.MeshFaceMaterial){na=0;for(ma=G.materials.length;na<
ma;na++)if(G.materials[na]&&G.materials[na].shading!=undefined&&G.materials[na].shading==THREE.SmoothShading){oa=!0;break}}else if(na&&na.shading!=undefined&&na.shading==THREE.SmoothShading){oa=!0;break}if(oa)break}L.__needsSmoothNormals=oa;D.__webGLFaceCount=C*3;D.__webGLLineCount=pa*2;K.__dirtyVertices=!0;K.__dirtyElements=!0;K.__dirtyUvs=!0;K.__dirtyNormals=!0;K.__dirtyTangents=!0;K.__dirtyColors=!0}if(K.__dirtyVertices||K.__dirtyElements||K.__dirtyUvs||K.__dirtyNormals||K.__dirtyColors||K.__dirtyTangents){D=
W;C=e.DYNAMIC_DRAW;pa=void 0;L=void 0;var va=void 0,Q=void 0,Ia=void 0,Ea=void 0,Ka=void 0;va=void 0;var ca=void 0,aa=void 0,X=void 0,ta=void 0;ca=void 0;aa=void 0;X=void 0;Q=void 0;ca=void 0;aa=void 0;X=void 0;ta=void 0;ca=void 0;aa=void 0;X=void 0;ta=void 0;ca=void 0;aa=void 0;X=void 0;ta=void 0;ca=void 0;aa=void 0;X=void 0;ta=void 0;ca=void 0;aa=void 0;X=void 0;ta=void 0;Q=void 0;Ea=void 0;Ia=void 0;Ka=void 0;var Fa=ma=na=oa=ka=U=F=G=0,Ca=0,N=0,Da=D.__vertexArray,Ra=D.__uvArray,Pa=D.__uv2Array,
Ja=D.__normalArray,ia=D.__tangentArray,xa=D.__colorArray,ua=D.__skinVertexAArray,ya=D.__skinVertexBArray,za=D.__skinIndexArray,wa=D.__skinWeightArray,R=D.__faceArray,ga=D.__lineArray,ha=D.__needsSmoothNormals,S=y.geometry,ea=S.__dirtyVertices,qa=S.__dirtyElements,Aa=S.__dirtyUvs,Ga=S.__dirtyNormals,Ha=S.__dirtyTangents,La=S.__dirtyColors,Ba=S.vertices,Ma=D.faces,Ta=S.faces,Na=S.uvs,Oa=S.uvs2,Qa=S.colors,Ua=S.skinVerticesA,Va=S.skinVerticesB,Wa=S.skinIndices,Sa=S.skinWeights;pa=0;for(L=Ma.length;pa<
L;pa++){va=Ma[pa];Q=Ta[va];Ka=Na[va];va=Oa[va];Ia=Q.vertexNormals;Ea=Q.normal;if(Q instanceof THREE.Face3){if(ea){ca=Ba[Q.a].position;aa=Ba[Q.b].position;X=Ba[Q.c].position;Da[F]=ca.x;Da[F+1]=ca.y;Da[F+2]=ca.z;Da[F+3]=aa.x;Da[F+4]=aa.y;Da[F+5]=aa.z;Da[F+6]=X.x;Da[F+7]=X.y;Da[F+8]=X.z;F+=9}if(Sa.length){ca=Sa[Q.a];aa=Sa[Q.b];X=Sa[Q.c];wa[N]=ca.x;wa[N+1]=ca.y;wa[N+2]=ca.z;wa[N+3]=ca.w;wa[N+4]=aa.x;wa[N+5]=aa.y;wa[N+6]=aa.z;wa[N+7]=aa.w;wa[N+8]=X.x;wa[N+9]=X.y;wa[N+10]=X.z;wa[N+11]=X.w;ca=Wa[Q.a];aa=
Wa[Q.b];X=Wa[Q.c];za[N]=ca.x;za[N+1]=ca.y;za[N+2]=ca.z;za[N+3]=ca.w;za[N+4]=aa.x;za[N+5]=aa.y;za[N+6]=aa.z;za[N+7]=aa.w;za[N+8]=X.x;za[N+9]=X.y;za[N+10]=X.z;za[N+11]=X.w;ca=Ua[Q.a];aa=Ua[Q.b];X=Ua[Q.c];ua[N]=ca.x;ua[N+1]=ca.y;ua[N+2]=ca.z;ua[N+3]=1;ua[N+4]=aa.x;ua[N+5]=aa.y;ua[N+6]=aa.z;ua[N+7]=1;ua[N+8]=X.x;ua[N+9]=X.y;ua[N+10]=X.z;ua[N+11]=1;ca=Va[Q.a];aa=Va[Q.b];X=Va[Q.c];ya[N]=ca.x;ya[N+1]=ca.y;ya[N+2]=ca.z;ya[N+3]=1;ya[N+4]=aa.x;ya[N+5]=aa.y;ya[N+6]=aa.z;ya[N+7]=1;ya[N+8]=X.x;ya[N+9]=X.y;ya[N+
10]=X.z;ya[N+11]=1;N+=12}if(La&&Qa.length){ca=Qa[Q.a];aa=Qa[Q.b];X=Qa[Q.c];xa[Ca]=ca.r;xa[Ca+1]=ca.g;xa[Ca+2]=ca.b;xa[Ca+3]=aa.r;xa[Ca+4]=aa.g;xa[Ca+5]=aa.b;xa[Ca+6]=X.r;xa[Ca+7]=X.g;xa[Ca+8]=X.b;Ca+=9}if(Ha&&S.hasTangents){ca=Ba[Q.a].tangent;aa=Ba[Q.b].tangent;X=Ba[Q.c].tangent;ia[ma]=ca.x;ia[ma+1]=ca.y;ia[ma+2]=ca.z;ia[ma+3]=ca.w;ia[ma+4]=aa.x;ia[ma+5]=aa.y;ia[ma+6]=aa.z;ia[ma+7]=aa.w;ia[ma+8]=X.x;ia[ma+9]=X.y;ia[ma+10]=X.z;ia[ma+11]=X.w;ma+=12}if(Ga)if(Ia.length==3&&ha)for(Q=0;Q<3;Q++){Ea=Ia[Q];
Ja[na]=Ea.x;Ja[na+1]=Ea.y;Ja[na+2]=Ea.z;na+=3}else for(Q=0;Q<3;Q++){Ja[na]=Ea.x;Ja[na+1]=Ea.y;Ja[na+2]=Ea.z;na+=3}if(Aa&&Ka)for(Q=0;Q<3;Q++){Ia=Ka[Q];Ra[U]=Ia.u;Ra[U+1]=Ia.v;U+=2}if(Aa&&va)for(Q=0;Q<3;Q++){Ka=va[Q];Pa[ka]=Ka.u;Pa[ka+1]=Ka.v;ka+=2}if(qa){R[oa]=G;R[oa+1]=G+1;R[oa+2]=G+2;oa+=3;ga[Fa]=G;ga[Fa+1]=G+1;ga[Fa+2]=G;ga[Fa+3]=G+2;ga[Fa+4]=G+1;ga[Fa+5]=G+2;Fa+=6;G+=3}}else if(Q instanceof THREE.Face4){if(ea){ca=Ba[Q.a].position;aa=Ba[Q.b].position;X=Ba[Q.c].position;ta=Ba[Q.d].position;Da[F]=
ca.x;Da[F+1]=ca.y;Da[F+2]=ca.z;Da[F+3]=aa.x;Da[F+4]=aa.y;Da[F+5]=aa.z;Da[F+6]=X.x;Da[F+7]=X.y;Da[F+8]=X.z;Da[F+9]=ta.x;Da[F+10]=ta.y;Da[F+11]=ta.z;F+=12}if(Sa.length){ca=Sa[Q.a];aa=Sa[Q.b];X=Sa[Q.c];ta=Sa[Q.d];wa[N]=ca.x;wa[N+1]=ca.y;wa[N+2]=ca.z;wa[N+3]=ca.w;wa[N+4]=aa.x;wa[N+5]=aa.y;wa[N+6]=aa.z;wa[N+7]=aa.w;wa[N+8]=X.x;wa[N+9]=X.y;wa[N+10]=X.z;wa[N+11]=X.w;wa[N+12]=ta.x;wa[N+13]=ta.y;wa[N+14]=ta.z;wa[N+15]=ta.w;ca=Wa[Q.a];aa=Wa[Q.b];X=Wa[Q.c];ta=Wa[Q.d];za[N]=ca.x;za[N+1]=ca.y;za[N+2]=ca.z;za[N+
3]=ca.w;za[N+4]=aa.x;za[N+5]=aa.y;za[N+6]=aa.z;za[N+7]=aa.w;za[N+8]=X.x;za[N+9]=X.y;za[N+10]=X.z;za[N+11]=X.w;za[N+12]=ta.x;za[N+13]=ta.y;za[N+14]=ta.z;za[N+15]=ta.w;ca=Ua[Q.a];aa=Ua[Q.b];X=Ua[Q.c];ta=Ua[Q.d];ua[N]=ca.x;ua[N+1]=ca.y;ua[N+2]=ca.z;ua[N+3]=1;ua[N+4]=aa.x;ua[N+5]=aa.y;ua[N+6]=aa.z;ua[N+7]=1;ua[N+8]=X.x;ua[N+9]=X.y;ua[N+10]=X.z;ua[N+11]=1;ua[N+12]=ta.x;ua[N+13]=ta.y;ua[N+14]=ta.z;ua[N+15]=1;ca=Va[Q.a];aa=Va[Q.b];X=Va[Q.c];ta=Va[Q.d];ya[N]=ca.x;ya[N+1]=ca.y;ya[N+2]=ca.z;ya[N+3]=1;ya[N+
4]=aa.x;ya[N+5]=aa.y;ya[N+6]=aa.z;ya[N+7]=1;ya[N+8]=X.x;ya[N+9]=X.y;ya[N+10]=X.z;ya[N+11]=1;ya[N+12]=ta.x;ya[N+13]=ta.y;ya[N+14]=ta.z;ya[N+15]=1;N+=16}if(La&&Qa.length){ca=Qa[Q.a];aa=Qa[Q.b];X=Qa[Q.c];ta=Qa[Q.d];xa[Ca]=ca.r;xa[Ca+1]=ca.g;xa[Ca+2]=ca.b;xa[Ca+3]=aa.r;xa[Ca+4]=aa.g;xa[Ca+5]=aa.b;xa[Ca+6]=X.r;xa[Ca+7]=X.g;xa[Ca+8]=X.b;xa[Ca+9]=ta.r;xa[Ca+10]=ta.g;xa[Ca+11]=ta.b;Ca+=12}if(Ha&&S.hasTangents){ca=Ba[Q.a].tangent;aa=Ba[Q.b].tangent;X=Ba[Q.c].tangent;Q=Ba[Q.d].tangent;ia[ma]=ca.x;ia[ma+1]=
ca.y;ia[ma+2]=ca.z;ia[ma+3]=ca.w;ia[ma+4]=aa.x;ia[ma+5]=aa.y;ia[ma+6]=aa.z;ia[ma+7]=aa.w;ia[ma+8]=X.x;ia[ma+9]=X.y;ia[ma+10]=X.z;ia[ma+11]=X.w;ia[ma+12]=Q.x;ia[ma+13]=Q.y;ia[ma+14]=Q.z;ia[ma+15]=Q.w;ma+=16}if(Ga)if(Ia.length==4&&ha)for(Q=0;Q<4;Q++){Ea=Ia[Q];Ja[na]=Ea.x;Ja[na+1]=Ea.y;Ja[na+2]=Ea.z;na+=3}else for(Q=0;Q<4;Q++){Ja[na]=Ea.x;Ja[na+1]=Ea.y;Ja[na+2]=Ea.z;na+=3}if(Aa&&Ka)for(Q=0;Q<4;Q++){Ia=Ka[Q];Ra[U]=Ia.u;Ra[U+1]=Ia.v;U+=2}if(Aa&&va)for(Q=0;Q<4;Q++){Ka=va[Q];Pa[ka]=Ka.u;Pa[ka+1]=Ka.v;ka+=
2}if(qa){R[oa]=G;R[oa+1]=G+1;R[oa+2]=G+2;R[oa+3]=G;R[oa+4]=G+2;R[oa+5]=G+3;oa+=6;ga[Fa]=G;ga[Fa+1]=G+1;ga[Fa+2]=G;ga[Fa+3]=G+3;ga[Fa+4]=G+1;ga[Fa+5]=G+2;ga[Fa+6]=G+2;ga[Fa+7]=G+3;Fa+=8;G+=4}}}if(ea){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLVertexBuffer);e.bufferData(e.ARRAY_BUFFER,Da,C)}if(La&&Qa.length){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLColorBuffer);e.bufferData(e.ARRAY_BUFFER,xa,C)}if(Ga){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLNormalBuffer);e.bufferData(e.ARRAY_BUFFER,Ja,C)}if(Ha&&S.hasTangents){e.bindBuffer(e.ARRAY_BUFFER,
D.__webGLTangentBuffer);e.bufferData(e.ARRAY_BUFFER,ia,C)}if(Aa&&U>0){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLUVBuffer);e.bufferData(e.ARRAY_BUFFER,Ra,C)}if(Aa&&ka>0){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLUV2Buffer);e.bufferData(e.ARRAY_BUFFER,Pa,C)}if(qa){e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,D.__webGLFaceBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,R,C);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,D.__webGLLineBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,ga,C)}if(N>0){e.bindBuffer(e.ARRAY_BUFFER,D.__webGLSkinVertexABuffer);
e.bufferData(e.ARRAY_BUFFER,ua,C);e.bindBuffer(e.ARRAY_BUFFER,D.__webGLSkinVertexBBuffer);e.bufferData(e.ARRAY_BUFFER,ya,C);e.bindBuffer(e.ARRAY_BUFFER,D.__webGLSkinIndicesBuffer);e.bufferData(e.ARRAY_BUFFER,za,C);e.bindBuffer(e.ARRAY_BUFFER,D.__webGLSkinWeightsBuffer);e.bufferData(e.ARRAY_BUFFER,wa,C)}}w(objlist,z,E,W,y)}K.__dirtyVertices=!1;K.__dirtyElements=!1;K.__dirtyUvs=!1;K.__dirtyNormals=!1;K.__dirtyTangents=!1;K.__dirtyColors=!1}else if(y instanceof THREE.Ribbon){if(!K.__webGLVertexBuffer){E=
K;E.__webGLVertexBuffer=e.createBuffer();E.__webGLColorBuffer=e.createBuffer();E=K;W=E.vertices.length;E.__vertexArray=new Float32Array(W*3);E.__colorArray=new Float32Array(W*3);E.__webGLVertexCount=W;K.__dirtyVertices=!0;K.__dirtyColors=!0}if(K.__dirtyVertices||K.__dirtyColors){E=K;W=e.DYNAMIC_DRAW;G=void 0;G=void 0;F=void 0;D=void 0;U=E.vertices;C=E.colors;ka=U.length;pa=C.length;oa=E.__vertexArray;L=E.__colorArray;na=E.__dirtyColors;if(E.__dirtyVertices){for(G=0;G<ka;G++){F=U[G].position;D=G*3;
oa[D]=F.x;oa[D+1]=F.y;oa[D+2]=F.z}e.bindBuffer(e.ARRAY_BUFFER,E.__webGLVertexBuffer);e.bufferData(e.ARRAY_BUFFER,oa,W)}if(na){for(G=0;G<pa;G++){color=C[G];D=G*3;L[D]=color.r;L[D+1]=color.g;L[D+2]=color.b}e.bindBuffer(e.ARRAY_BUFFER,E.__webGLColorBuffer);e.bufferData(e.ARRAY_BUFFER,L,W)}}w(objlist,z,0,K,y);K.__dirtyVertices=!1;K.__dirtyColors=!1}else if(y instanceof THREE.Line){if(!K.__webGLVertexBuffer){E=K;E.__webGLVertexBuffer=e.createBuffer();E.__webGLColorBuffer=e.createBuffer();E=K;W=E.vertices.length;
E.__vertexArray=new Float32Array(W*3);E.__colorArray=new Float32Array(W*3);E.__webGLLineCount=W;K.__dirtyVertices=!0;K.__dirtyColors=!0}if(K.__dirtyVertices||K.__dirtyColors){E=K;W=e.DYNAMIC_DRAW;G=void 0;G=void 0;F=void 0;D=void 0;U=E.vertices;C=E.colors;ka=U.length;pa=C.length;oa=E.__vertexArray;L=E.__colorArray;na=E.__dirtyColors;if(E.__dirtyVertices){for(G=0;G<ka;G++){F=U[G].position;D=G*3;oa[D]=F.x;oa[D+1]=F.y;oa[D+2]=F.z}e.bindBuffer(e.ARRAY_BUFFER,E.__webGLVertexBuffer);e.bufferData(e.ARRAY_BUFFER,
oa,W)}if(na){for(G=0;G<pa;G++){color=C[G];D=G*3;L[D]=color.r;L[D+1]=color.g;L[D+2]=color.b}e.bindBuffer(e.ARRAY_BUFFER,E.__webGLColorBuffer);e.bufferData(e.ARRAY_BUFFER,L,W)}}w(objlist,z,0,K,y);K.__dirtyVertices=!1;K.__dirtyColors=!1}else if(y instanceof THREE.ParticleSystem){if(!K.__webGLVertexBuffer){E=K;E.__webGLVertexBuffer=e.createBuffer();E.__webGLColorBuffer=e.createBuffer();E=K;W=E.vertices.length;E.__vertexArray=new Float32Array(W*3);E.__colorArray=new Float32Array(W*3);E.__sortArray=[];
E.__webGLParticleCount=W;K.__dirtyVertices=!0;K.__dirtyColors=!0}(K.__dirtyVertices||K.__dirtyColors||y.sortParticles)&&b(K,e.DYNAMIC_DRAW,y,D);w(objlist,z,0,K,y);K.__dirtyVertices=!1;K.__dirtyColors=!1}else if(THREE.MarchingCubes!==undefined&&y instanceof THREE.MarchingCubes){K=z;if(K[0]==undefined){C.__webGLObjectsImmediate.push({object:y,opaque:{list:[],count:0},transparent:{list:[],count:0}});K[0]=1}}}};this.removeObject=function(m,A){var x,t;for(x=m.__webGLObjects.length-1;x>=0;x--){t=m.__webGLObjects[x].object;
A==t&&m.__webGLObjects.splice(x,1)}};this.setFaceCulling=function(m,A){if(m){!A||A=="ccw"?e.frontFace(e.CCW):e.frontFace(e.CW);if(m=="back")e.cullFace(e.BACK);else m=="front"?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK);e.enable(e.CULL_FACE)}else e.disable(e.CULL_FACE)};this.supportsVertexTextures=function(){return e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.Snippets={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",
lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[20];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif"};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",
value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.Snippets.color_pars_fragment,
THREE.Snippets.map_pars_fragment,THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:[THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,THREE.Snippets.envmap_pars_vertex,THREE.Snippets.color_pars_vertex,
THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_pars_fragment,
THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,
THREE.Snippets.envmap_pars_vertex,THREE.Snippets.lights_pars_vertex,THREE.Snippets.color_pars_vertex,THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.Snippets.lights_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,
THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_pars_fragment,THREE.Snippets.lightmap_pars_fragment,THREE.Snippets.envmap_pars_fragment,THREE.Snippets.fog_pars_fragment,
THREE.Snippets.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.Snippets.lights_fragment,THREE.Snippets.map_fragment,THREE.Snippets.lightmap_fragment,THREE.Snippets.color_fragment,THREE.Snippets.envmap_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.Snippets.map_pars_vertex,THREE.Snippets.lightmap_pars_vertex,THREE.Snippets.envmap_pars_vertex,
THREE.Snippets.lights_pars_vertex,THREE.Snippets.color_pars_vertex,THREE.Snippets.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.Snippets.map_vertex,THREE.Snippets.lightmap_vertex,THREE.Snippets.envmap_vertex,THREE.Snippets.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.Snippets.lights_vertex,THREE.Snippets.skinning_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.Snippets.color_pars_fragment,THREE.Snippets.map_particle_pars_fragment,THREE.Snippets.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.Snippets.map_particle_fragment,THREE.Snippets.color_fragment,THREE.Snippets.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;",
THREE.Snippets.color_pars_vertex,"void main() {",THREE.Snippets.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\ngl_Position = projectionMatrix * mvPosition;\ngl_PointSize = size;\n}"].join("\n")}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(undefined,!1,b);c=a.sounds;var d,f=c.length;for(d=0;d<f;d++){a=c[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
var GeometryUtils={merge:function(a,b){var c=b instanceof THREE.Mesh,d=a.vertices.length,f=c?b.geometry:b,g=a.vertices,h=f.vertices,k=a.faces,j=f.faces,l=a.uvs;f=f.uvs;c&&b.matrixAutoUpdate&&b.updateMatrix();for(var n=0,v=h.length;n<v;n++){var p=new THREE.Vertex(h[n].position.clone());c&&b.matrix.multiplyVector3(p.position);g.push(p)}n=0;for(v=j.length;n<v;n++){h=j[n];var q,w=h.vertexNormals;if(h instanceof THREE.Face3)q=new THREE.Face3(h.a+d,h.b+d,h.c+d);else h instanceof THREE.Face4&&(q=new THREE.Face4(h.a+
d,h.b+d,h.c+d,h.d+d));q.centroid.copy(h.centroid);q.normal.copy(h.normal);c=0;for(g=w.length;c<g;c++){p=w[c];q.vertexNormals.push(p.clone())}q.materials=h.materials.slice();k.push(q)}n=0;for(v=f.length;n<v;n++){d=f[n];k=[];c=0;for(g=d.length;c<g;c++)k.push(new THREE.UV(d[c].u,d[c].v));l.push(k)}}},ImageUtils={loadTexture:function(a,b,c){var d=new Image,f=new THREE.Texture(d,b);d.onload=function(){f.needsUpdate=!0;c&&c(this)};d.src=a;return f},loadTextureCube:function(a,b,c){var d,f=[],g=new THREE.Texture(f,
b);b=f.loadCount=0;for(d=a.length;b<d;++b){f[b]=new Image;f[b].onload=function(){f.loadCount+=1;if(f.loadCount==6)g.needsUpdate=!0;c&&c(this)};f[b].src=a[b]}return g}},SceneUtils={loadScene:function(a,b,c,d){a=new Worker(a);a.postMessage(0);a.onmessage=function(f){function g(){for(n in O.objects)if(!J.objects[n]){B=O.objects[n];if(o=J.geometries[B.geometry]){ba=[];for(i=0;i<B.materials.length;i++)ba[i]=J.materials[B.materials[i]];H=B.position;r=B.rotation;s=B.scale;object=new THREE.Mesh(o,ba);object.position.set(H[0],
H[1],H[2]);object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=B.visible;J.scene.addObject(object);J.objects[n]=object}}}function h($){return function(ra){J.geometries[$]=ra;g();V-=1;k()}}function k(){d({total_models:Y,total_textures:da,loaded_models:Y-V,loaded_textures:da-T},J);V==0&&T==0&&c(J)}var j,l,n,v,p,q,w,B,H,u,I,o,M,e,ba,O,P,V,T,Y,da,J;O=f.data;P=new THREE.Loader;T=V=0;J={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},
fogs:{}};f=function(){T-=1;k()};for(p in O.cameras){u=O.cameras[p];if(u.type=="perspective")M=new THREE.Camera(u.fov,u.aspect,u.near,u.far);else if(u.type=="ortho"){M=new THREE.Camera;M.projectionMatrix=THREE.Matrix4.makeOrtho(u.left,u.right,u.top,u.bottom,u.near,u.far)}H=u.position;u=u.target;M.position.set(H[0],H[1],H[2]);M.target.position.set(u[0],u[1],u[2]);J.cameras[p]=M}for(v in O.lights){p=O.lights[v];if(p.type=="directional"){H=p.direction;light=new THREE.DirectionalLight;light.position.set(H[0],
H[1],H[2]);light.position.normalize()}else if(p.type=="point"){H=p.position;light=new THREE.PointLight;light.position.set(H[0],H[1],H[2])}u=p.color;i=p.intensity||1;light.color.setRGB(u[0]*i,u[1]*i,u[2]*i);J.scene.addLight(light);J.lights[v]=light}for(q in O.fogs){v=O.fogs[q];if(v.type=="linear")e=new THREE.Fog(0,v.near,v.far);else v.type=="exp2"&&(e=new THREE.FogExp2(0,v.density));u=v.color;e.color.setRGB(u[0],u[1],u[2]);J.fogs[q]=e}if(J.cameras&&O.defaults.camera)J.currentCamera=J.cameras[O.defaults.camera];
if(J.fogs&&O.defaults.fog)J.scene.fog=J.fogs[O.defaults.fog];u=O.defaults.bgcolor;J.bgColor=new THREE.Color;J.bgColor.setRGB(u[0],u[1],u[2]);J.bgColorAlpha=O.defaults.bgalpha;for(j in O.geometries){q=O.geometries[j];if(q.type=="bin_mesh"||q.type=="ascii_mesh")V+=1}Y=V;for(j in O.geometries){q=O.geometries[j];if(q.type=="cube"){o=new Cube(q.width,q.height,q.depth,q.segmentsWidth,q.segmentsHeight,null,q.flipped,q.sides);J.geometries[j]=o}else if(q.type=="plane"){o=new Plane(q.width,q.height,q.segmentsWidth,
q.segmentsHeight);J.geometries[j]=o}else if(q.type=="sphere"){o=new Sphere(q.radius,q.segmentsWidth,q.segmentsHeight);J.geometries[j]=o}else if(q.type=="cylinder"){o=new Cylinder(q.numSegs,q.topRad,q.botRad,q.height,q.topOffset,q.botOffset);J.geometries[j]=o}else if(q.type=="torus"){o=new Torus(q.radius,q.tube,q.segmentsR,q.segmentsT);J.geometries[j]=o}else if(q.type=="icosahedron"){o=new Icosahedron(q.subdivisions);J.geometries[j]=o}else if(q.type=="bin_mesh")P.loadBinary({model:q.url,callback:h(j)});
else q.type=="ascii_mesh"&&P.loadAscii({model:q.url,callback:h(j)})}for(w in O.textures){j=O.textures[w];T+=j.url instanceof Array?j.url.length:1}da=T;for(w in O.textures){j=O.textures[w];if(j.mapping!=undefined&&THREE[j.mapping]!=undefined)j.mapping=new THREE[j.mapping];if(j.url instanceof Array)q=ImageUtils.loadTextureCube(j.url,j.mapping,f);else{q=ImageUtils.loadTexture(j.url,j.mapping,f);if(THREE[j.minFilter]!=undefined)q.minFilter=THREE[j.minFilter];if(THREE[j.magFilter]!=undefined)q.magFilter=
THREE[j.magFilter]}J.textures[w]=q}for(l in O.materials){w=O.materials[l];for(I in w.parameters)if(I=="envMap"||I=="map"||I=="lightMap")w.parameters[I]=J.textures[w.parameters[I]];else if(I=="shading")w.parameters[I]=w.parameters[I]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(I=="blending")w.parameters[I]=THREE[w.parameters[I]]?THREE[w.parameters[I]]:THREE.NormalBlending;else I=="combine"&&(w.parameters[I]=w.parameters[I]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation);w=new THREE[w.type](w.parameters);
J.materials[l]=w}g();b(J)}},addMesh:function(a,b,c,d,f,g,h,k,j,l){b=new THREE.Mesh(b,l);b.scale.x=b.scale.y=b.scale.z=c;b.position.x=d;b.position.y=f;b.position.z=g;b.rotation.x=h;b.rotation.y=k;b.rotation.z=j;a.addObject(b);return b},addPanoramaCubeWebGL:function(a,b,c){var d=ShaderUtils.lib.cube;d.uniforms.tCube.texture=c;c=new THREE.MeshShaderMaterial({fragmentShader:d.fragmentShader,vertexShader:d.vertexShader,uniforms:d.uniforms});b=new THREE.Mesh(new Cube(b,b,b,1,1,null,!0),c);a.addObject(b);
return b},addPanoramaCube:function(a,b,c){var d=[];d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[4])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));b=new THREE.Mesh(new Cube(b,b,b,1,1,d,!0),new THREE.MeshFaceMaterial);
a.addObject(b);return b},addPanoramaCubePlanes:function(a,b,c){var d=b/2;b=new Plane(b,b);var f=Math.PI,g=Math.PI/2;SceneUtils.addMesh(a,b,1,0,0,-d,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));SceneUtils.addMesh(a,b,1,-d,0,0,0,g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));SceneUtils.addMesh(a,b,1,d,0,0,0,-g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));SceneUtils.addMesh(a,b,1,0,d,0,g,0,f,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));
SceneUtils.addMesh(a,b,1,0,-d,0,-g,0,f,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}))}},ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var b,c,d,f,g=2*Math.ceil(a*3)+1;g>25&&(g=25);f=(g-1)*0.5;c=Array(g);for(b=d=0;b<g;++b){c[b]=Math.exp(-((b-f)*(b-f))/(2*a*a));d+=c[b]}for(b=0;b<g;++b)c[b]/=d;return c}},Cube=function(a,b,c,d,f,g,h,k){function j(B,H,u,I,o,M,e,ba){var O,P,V=d||1,T=f||1,Y=V+1,da=T+1,J=o/2,$=M/2;o/=V;var ra=M/T,Z=l.vertices.length;if(B=="x"&&H=="y"||B=="y"&&H=="x")O="z";else if(B=="x"&&H=="z"||B=="z"&&H=="x")O="y";
else if(B=="z"&&H=="y"||B=="y"&&H=="z")O="x";for(P=0;P<da;P++)for(M=0;M<Y;M++){var la=new THREE.Vector3;la[B]=(M*o-J)*u;la[H]=(P*ra-$)*I;la[O]=e;l.vertices.push(new THREE.Vertex(la))}for(P=0;P<T;P++)for(M=0;M<V;M++){l.faces.push(new THREE.Face4(M+Y*P+Z,M+Y*(P+1)+Z,M+1+Y*(P+1)+Z,M+1+Y*P+Z,null,ba));l.uvs.push([new THREE.UV(M/V,P/T),new THREE.UV(M/V,(P+1)/T),new THREE.UV((M+1)/V,(P+1)/T),new THREE.UV((M+1)/V,P/T)])}}THREE.Geometry.call(this);var l=this,n=a/2,v=b/2,p=c/2;h=h?-1:1;if(g!==undefined)if(g instanceof
Array)this.materials=g;else{this.materials=[];for(var q=0;q<6;q++)this.materials.push([g])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(k!=undefined)for(var w in k)this.sides[w]!=undefined&&(this.sides[w]=k[w]);this.sides.px&&j("z","y",1*h,-1,c,b,-n,this.materials[0]);this.sides.nx&&j("z","y",-1*h,-1,c,b,n,this.materials[1]);this.sides.py&&j("x","z",1*h,1,a,c,v,this.materials[2]);this.sides.ny&&j("x","z",1*h,-1,a,c,-v,this.materials[3]);this.sides.pz&&j("x","y",1*h,-1,
a,b,p,this.materials[4]);this.sides.nz&&j("x","y",-1*h,-1,a,b,-p,this.materials[5]);(function(){for(var B=[],H=[],u=0,I=l.vertices.length;u<I;u++){for(var o=l.vertices[u],M=!1,e=0,ba=B.length;e<ba;e++){var O=B[e];if(o.position.x==O.position.x&&o.position.y==O.position.y&&o.position.z==O.position.z){H[u]=e;M=!0;break}}if(!M){H[u]=B.length;B.push(new THREE.Vertex(o.position.clone()))}}u=0;for(I=l.faces.length;u<I;u++){o=l.faces[u];o.a=H[o.a];o.b=H[o.b];o.c=H[o.c];o.d=H[o.d]}l.vertices=B})();this.computeCentroids();
this.computeFaceNormals();this.sortFacesByMaterial()};Cube.prototype=new THREE.Geometry;Cube.prototype.constructor=Cube;
var Cylinder=function(a,b,c,d,f){function g(l,n,v){h.vertices.push(new THREE.Vertex(new THREE.Vector3(l,n,v)))}THREE.Geometry.call(this);var h=this,k=Math.PI,j;for(j=0;j<a;j++)g(Math.sin(2*k*j/a)*b,Math.cos(2*k*j/a)*b,0);for(j=0;j<a;j++)g(Math.sin(2*k*j/a)*c,Math.cos(2*k*j/a)*c,d);for(j=0;j<a;j++)h.faces.push(new THREE.Face4(j,j+a,a+(j+1)%a,(j+1)%a));if(c!=0){g(0,0,-f);for(j=a;j<a+a/2;j++)h.faces.push(new THREE.Face4(2*a,(2*j-2*a)%a,(2*j-2*a+1)%a,(2*j-2*a+2)%a))}if(b!=0){g(0,0,d+f);for(j=a+a/2;j<
2*a;j++)h.faces.push(new THREE.Face4((2*j-2*a+2)%a+a,(2*j-2*a+1)%a+a,(2*j-2*a)%a+a,2*a+1))}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};Cylinder.prototype=new THREE.Geometry;Cylinder.prototype.constructor=Cylinder;
var Plane=function(a,b,c,d){THREE.Geometry.call(this);var f,g=a/2,h=b/2;c=c||1;d=d||1;var k=c+1,j=d+1;a/=c;var l=b/d;for(f=0;f<j;f++)for(b=0;b<k;b++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(b*a-g,-(f*l-h),0)));for(f=0;f<d;f++)for(b=0;b<c;b++){this.faces.push(new THREE.Face4(b+k*f,b+k*(f+1),b+1+k*(f+1),b+1+k*f));this.uvs.push([new THREE.UV(b/c,f/d),new THREE.UV(b/c,(f+1)/d),new THREE.UV((b+1)/c,(f+1)/d),new THREE.UV((b+1)/c,f/d)])}this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};
Plane.prototype=new THREE.Geometry;Plane.prototype.constructor=Plane;
var Sphere=function(a,b,c){THREE.Geometry.call(this);var d,f=Math.PI,g=Math.max(3,b||8),h=Math.max(2,c||6);b=[];for(c=0;c<h+1;c++){d=c/h;var k=a*Math.cos(d*f),j=a*Math.sin(d*f),l=[],n=0;for(d=0;d<g;d++){var v=2*d/g,p=j*Math.sin(v*f);v=j*Math.cos(v*f);(c==0||c==h)&&d>0||(n=this.vertices.push(new THREE.Vertex(new THREE.Vector3(v,k,p)))-1);l.push(n)}b.push(l)}var q,w,B;f=b.length;for(c=0;c<f;c++){g=b[c].length;if(c>0)for(d=0;d<g;d++){l=d==g-1;h=b[c][l?0:d+1];k=b[c][l?g-1:d];j=b[c-1][l?g-1:d];l=b[c-1][l?
0:d+1];p=c/(f-1);q=(c-1)/(f-1);w=(d+1)/g;v=d/g;n=new THREE.UV(1-w,p);p=new THREE.UV(1-v,p);v=new THREE.UV(1-v,q);var H=new THREE.UV(1-w,q);if(c<b.length-1){q=this.vertices[h].position.clone();w=this.vertices[k].position.clone();B=this.vertices[j].position.clone();q.normalize();w.normalize();B.normalize();this.faces.push(new THREE.Face3(h,k,j,[new THREE.Vector3(q.x,q.y,q.z),new THREE.Vector3(w.x,w.y,w.z),new THREE.Vector3(B.x,B.y,B.z)]));this.uvs.push([n,p,v])}if(c>1){q=this.vertices[h].position.clone();
w=this.vertices[j].position.clone();B=this.vertices[l].position.clone();q.normalize();w.normalize();B.normalize();this.faces.push(new THREE.Face3(h,j,l,[new THREE.Vector3(q.x,q.y,q.z),new THREE.Vector3(w.x,w.y,w.z),new THREE.Vector3(B.x,B.y,B.z)]));this.uvs.push([n,v,H])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial();this.boundingSphere={radius:a}};Sphere.prototype=new THREE.Geometry;Sphere.prototype.constructor=Sphere;
var Torus=function(a,b,c,d){this.radius=a||100;this.tube=b||40;this.segmentsR=c||8;this.segmentsT=d||6;a=[];THREE.Geometry.call(this);for(b=0;b<=this.segmentsR;++b)for(c=0;c<=this.segmentsT;++c){d=c/this.segmentsT*2*Math.PI;var f=b/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(f))*Math.cos(d),(this.radius+this.tube*Math.cos(f))*Math.sin(d),this.tube*Math.sin(f))));a.push([c/this.segmentsT,1-b/this.segmentsR])}for(b=1;b<=this.segmentsR;++b)for(c=
1;c<=this.segmentsT;++c){d=(this.segmentsT+1)*b+c;f=(this.segmentsT+1)*b+c-1;var g=(this.segmentsT+1)*(b-1)+c-1,h=(this.segmentsT+1)*(b-1)+c;this.faces.push(new THREE.Face4(d,f,g,h));this.uvs.push([new THREE.UV(a[d][0],a[d][1]),new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[g][0],a[g][1]),new THREE.UV(a[h][0],a[h][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()};Torus.prototype=new THREE.Geometry;Torus.prototype.constructor=Torus;
var Icosahedron=function(a){function b(v,p,q){var w=Math.sqrt(v*v+p*p+q*q);return f.vertices.push(new THREE.Vertex(new THREE.Vector3(v/w,p/w,q/w)))-1}function c(v,p,q,w){w.faces.push(new THREE.Face3(v,p,q))}function d(v,p){var q=f.vertices[v].position,w=f.vertices[p].position;return b((q.x+w.x)/2,(q.y+w.y)/2,(q.z+w.z)/2)}var f=this,g=new THREE.Geometry,h;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;b(-1,a,0);b(1,a,0);b(-1,-a,0);b(1,-a,0);b(0,-1,a);b(0,1,a);b(0,-1,-a);b(0,
1,-a);b(a,0,-1);b(a,0,1);b(-a,0,-1);b(-a,0,1);c(0,11,5,g);c(0,5,1,g);c(0,1,7,g);c(0,7,10,g);c(0,10,11,g);c(1,5,9,g);c(5,11,4,g);c(11,10,2,g);c(10,7,6,g);c(7,1,8,g);c(3,9,4,g);c(3,4,2,g);c(3,2,6,g);c(3,6,8,g);c(3,8,9,g);c(4,9,5,g);c(2,4,11,g);c(6,2,10,g);c(8,6,7,g);c(9,8,1,g);for(a=0;a<this.subdivisions;a++){h=new THREE.Geometry;for(var k in g.faces){var j=d(g.faces[k].a,g.faces[k].b),l=d(g.faces[k].b,g.faces[k].c),n=d(g.faces[k].c,g.faces[k].a);c(g.faces[k].a,j,n,h);c(g.faces[k].b,l,j,h);c(g.faces[k].c,
n,l,h);c(j,l,n,h)}g.faces=h.faces}f.faces=g.faces;delete g;delete h;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()};Icosahedron.prototype=new THREE.Geometry;Icosahedron.prototype.constructor=Icosahedron;
function LathedObject(a,b,c){THREE.Geometry.call(this);this.nsteps=b||12;this.latheAngle=c||2*Math.PI;b=this.latheAngle/this.nsteps;for(var d=[],f=[],g=[],h=[],k=0;k<a.length;k++){this.vertices.push(new THREE.Vertex(a[k]));f[k]=this.vertices.length-1;d[k]=new THREE.Vector3(a[k].x,a[k].y,a[k].z)}for(var j=THREE.Matrix4.rotationZMatrix(this.stepSize),l=0;l<=this.latheAngle+0.001;l+=this.stepSize){for(k=0;k<d.length;k++)if(l<c){d[k]=j.multiplyVector3(d[k].clone());this.vertices.push(new THREE.Vertex(d[k]));
g[k]=this.vertices.length-1}else g=h;l==0&&(h=f);for(k=0;k<f.length-1;k++){this.faces.push(new THREE.Face4(g[k],g[k+1],f[k+1],f[k]));this.uvs.push([new THREE.UV(l/c,k/a.length),new THREE.UV(l/c,(k+1)/a.length),new THREE.UV((l-b)/c,(k+1)/a.length),new THREE.UV((l-b)/c,k/a.length)])}f=g;g=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.sortFacesByMaterial()}LathedObject.prototype=new THREE.Geometry;LathedObject.prototype.constructor=LathedObject;
if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b];this.init=function(c){this.isolation=80;this.size=c;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(c,d,f){return c+(d-c)*f};this.VIntX=function(c,d,f,g,h,k,j,l,n,v){h=(h-n)/(v-n);n=this.normal_cache;d[g]=k+h*this.delta;d[g+1]=j;d[g+2]=l;f[g]=this.lerp(n[c],n[c+3],h);f[g+1]=this.lerp(n[c+1],n[c+4],h);f[g+2]=this.lerp(n[c+2],n[c+5],h)};this.VIntY=function(c,d,f,g,h,k,j,l,n,v){h=(h-n)/(v-n);n=this.normal_cache;d[g]=k;d[g+1]=j+h*this.delta;d[g+
2]=l;d=c+this.yd*3;f[g]=this.lerp(n[c],n[d],h);f[g+1]=this.lerp(n[c+1],n[d+1],h);f[g+2]=this.lerp(n[c+2],n[d+2],h)};this.VIntZ=function(c,d,f,g,h,k,j,l,n,v){h=(h-n)/(v-n);n=this.normal_cache;d[g]=k;d[g+1]=j;d[g+2]=l+h*this.delta;d=c+this.zd*3;f[g]=this.lerp(n[c],n[d],h);f[g+1]=this.lerp(n[c+1],n[d+1],h);f[g+2]=this.lerp(n[c+2],n[d+2],h)};this.compNorm=function(c){var d=c*3;if(this.normal_cache[d]==0){this.normal_cache[d]=this.field[c-1]-this.field[c+1];this.normal_cache[d+1]=this.field[c-this.yd]-
this.field[c+this.yd];this.normal_cache[d+2]=this.field[c-this.zd]-this.field[c+this.zd]}};this.polygonize=function(c,d,f,g,h,k){var j=g+1,l=g+this.yd,n=g+this.zd,v=j+this.yd,p=j+this.zd,q=g+this.yd+this.zd,w=j+this.yd+this.zd,B=0,H=this.field[g],u=this.field[j],I=this.field[l],o=this.field[v],M=this.field[n],e=this.field[p],ba=this.field[q],O=this.field[w];H<h&&(B|=1);u<h&&(B|=2);I<h&&(B|=8);o<h&&(B|=4);M<h&&(B|=16);e<h&&(B|=32);ba<h&&(B|=128);O<h&&(B|=64);var P=THREE.edgeTable[B];if(P==0)return 0;
var V=this.delta,T=c+V,Y=d+V;V=f+V;if(P&1){this.compNorm(g);this.compNorm(j);this.VIntX(g*3,this.vlist,this.nlist,0,h,c,d,f,H,u)}if(P&2){this.compNorm(j);this.compNorm(v);this.VIntY(j*3,this.vlist,this.nlist,3,h,T,d,f,u,o)}if(P&4){this.compNorm(l);this.compNorm(v);this.VIntX(l*3,this.vlist,this.nlist,6,h,c,Y,f,I,o)}if(P&8){this.compNorm(g);this.compNorm(l);this.VIntY(g*3,this.vlist,this.nlist,9,h,c,d,f,H,I)}if(P&16){this.compNorm(n);this.compNorm(p);this.VIntX(n*3,this.vlist,this.nlist,12,h,c,d,V,
M,e)}if(P&32){this.compNorm(p);this.compNorm(w);this.VIntY(p*3,this.vlist,this.nlist,15,h,T,d,V,e,O)}if(P&64){this.compNorm(q);this.compNorm(w);this.VIntX(q*3,this.vlist,this.nlist,18,h,c,Y,V,ba,O)}if(P&128){this.compNorm(n);this.compNorm(q);this.VIntY(n*3,this.vlist,this.nlist,21,h,c,d,V,M,ba)}if(P&256){this.compNorm(g);this.compNorm(n);this.VIntZ(g*3,this.vlist,this.nlist,24,h,c,d,f,H,M)}if(P&512){this.compNorm(j);this.compNorm(p);this.VIntZ(j*3,this.vlist,this.nlist,27,h,T,d,f,u,e)}if(P&1024){this.compNorm(v);
this.compNorm(w);this.VIntZ(v*3,this.vlist,this.nlist,30,h,T,Y,f,o,O)}if(P&2048){this.compNorm(l);this.compNorm(q);this.VIntZ(l*3,this.vlist,this.nlist,33,h,c,Y,f,I,ba)}B<<=4;for(h=g=0;THREE.triTable[B+h]!=-1;){c=B+h;d=c+1;f=c+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[c],3*THREE.triTable[d],3*THREE.triTable[f],k);h+=3;g++}return g};this.posnormtriv=function(c,d,f,g,h,k){var j=this.count*3;this.positionArray[j]=c[f];this.positionArray[j+1]=c[f+1];this.positionArray[j+2]=c[f+2];this.positionArray[j+
3]=c[g];this.positionArray[j+4]=c[g+1];this.positionArray[j+5]=c[g+2];this.positionArray[j+6]=c[h];this.positionArray[j+7]=c[h+1];this.positionArray[j+8]=c[h+2];this.normalArray[j]=d[f];this.normalArray[j+1]=d[f+1];this.normalArray[j+2]=d[f+2];this.normalArray[j+3]=d[g];this.normalArray[j+4]=d[g+1];this.normalArray[j+5]=d[g+2];this.normalArray[j+6]=d[h];this.normalArray[j+7]=d[h+1];this.normalArray[j+8]=d[h+2];this.hasPos=!0;this.hasNormal=!0;this.count+=3;this.count>=this.maxCount-3&&k(this)};this.begin=
function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(c){if(this.count!=0){for(var d=this.count*3;d<this.positionArray.length;d++)this.positionArray[d]=0;c(this)}};this.addBall=function(c,d,f,g,h){var k=this.size*Math.sqrt(g/h),j=f*this.size,l=d*this.size,n=c*this.size,v=Math.floor(j-k);v<1&&(v=1);j=Math.floor(j+k);j>this.size-1&&(j=this.size-1);var p=Math.floor(l-k);p<1&&(p=1);l=Math.floor(l+k);l>this.size-1&&(l=this.size-1);var q=Math.floor(n-k);q<1&&(q=1);k=Math.floor(n+k);
k>this.size-1&&(k=this.size-1);for(var w,B,H,u,I,o;v<j;v++){n=this.size2*v;B=v/this.size-f;I=B*B;for(B=p;B<l;B++){H=n+this.size*B;w=B/this.size-d;o=w*w;for(w=q;w<k;w++){u=w/this.size-c;u=g/(1.0E-6+u*u+o+I)-h;u>0&&(this.field[H+w]+=u)}}}};this.addPlaneX=function(c,d){var f,g,h,k,j,l=this.size,n=this.yd,v=this.zd,p=this.field,q=l*Math.sqrt(c/d);q>l&&(q=l);for(f=0;f<q;f++){g=f/l;g*=g;k=c/(1.0E-4+g)-d;if(k>0)for(g=0;g<l;g++){j=f+g*n;for(h=0;h<l;h++)p[v*h+j]+=k}}};this.addPlaneY=function(c,d){var f,g,
h,k,j,l,n=this.size,v=this.yd,p=this.zd,q=this.field,w=n*Math.sqrt(c/d);w>n&&(w=n);for(g=0;g<w;g++){f=g/n;f*=f;k=c/(1.0E-4+f)-d;if(k>0){j=g*v;for(f=0;f<n;f++){l=j+f;for(h=0;h<n;h++)q[p*h+l]+=k}}}};this.addPlaneZ=function(c,d){var f,g,h,k,j,l;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(c/d);dist>size&&(dist=size);for(h=0;h<dist;h++){f=h/size;f*=f;k=c/(1.0E-4+f)-d;if(k>0){j=zd*h;for(g=0;g<size;g++){l=j+g*yd;for(f=0;f<size;f++)field[l+f]+=k}}}};this.reset=function(){var c;
for(c=0;c<this.size3;c++){this.normal_cache[c*3]=0;this.field[c]=0}};this.render=function(c){this.begin();var d,f,g,h,k,j,l,n,v,p=this.size-2;for(h=1;h<p;h++){v=this.size2*h;l=(h-this.halfsize)/this.halfsize;for(g=1;g<p;g++){n=v+this.size*g;j=(g-this.halfsize)/this.halfsize;for(f=1;f<p;f++){k=(f-this.halfsize)/this.halfsize;d=n+f;this.polygonize(k,j,l,d,this.isolation,c)}}}this.end(c)};this.generateGeometry=function(){var c=0,d=new THREE.Geometry;this.render(function(f){var g,h,k,j,l,n,v,p;for(g=
0;g<f.count;g++){l=g*3;v=l+1;p=l+2;h=f.positionArray[l];k=f.positionArray[v];j=f.positionArray[p];n=new THREE.Vector3(h,k,j);h=f.normalArray[l];k=f.normalArray[v];j=f.normalArray[p];l=new THREE.Vector3(h,k,j);l.normalize();l=new THREE.Vertex(n,l);d.vertices.push(l)}nfaces=f.count/3;for(g=0;g<nfaces;g++){l=(c+g)*3;v=l+1;p=l+2;n=d.vertices[l].normal;h=d.vertices[v].normal;k=d.vertices[p].normal;l=new THREE.Face3(l,v,p,[n,h,k]);d.faces.push(l)}c+=nfaces;f.count=0});d.sortFacesByMaterial();return d};
this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?this.addStatusElement():null};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="#b00";a.style.color="#fff";a.style.width="140px";a.style.padding="0.25em 0.25em 0.25em 0.5em";a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ";b+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";this.statusDomElement.innerHTML=
b},loadAsciiOld:function(a,b){var c=document.createElement("script");c.type="text/javascript";c.onload=b;c.src=a;document.getElementsByTagName("head")[0].appendChild(c)},loadAscii:function(a){var b=a.model,c=a.callback,d=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(b);a=(new Date).getTime();b=new Worker(b);b.onmessage=function(f){THREE.Loader.prototype.createModel(f.data,c,d)};b.postMessage(a)},loadBinary:function(a){var b=a.model,c=a.callback,d=a.texture_path?a.texture_path:
THREE.Loader.prototype.extractUrlbase(b),f=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(b);a=(new Date).getTime();b=new Worker(b);var g=this.showProgress?THREE.Loader.prototype.updateProgress:null;b.onmessage=function(h){THREE.Loader.prototype.loadAjaxBuffers(h.data.buffers,h.data.materials,c,f,d,g)};b.onerror=function(h){alert("worker.onerror: "+h.message+"\n"+h.data);h.preventDefault()};b.postMessage(a)},loadAjaxBuffers:function(a,b,c,d,f,g){var h=new XMLHttpRequest,k=d+"/"+a,j=0;
h.onreadystatechange=function(){if(h.readyState==4)h.status==200||h.status==0?THREE.Loader.prototype.createBinModel(h.responseText,c,f,b):alert("Couldn't load ["+k+"] ["+h.status+"]");else if(h.readyState==3){if(g){j==0&&(j=h.getResponseHeader("Content-Length"));g({total:j,loaded:h.responseText.length})}}else h.readyState==2&&(j=h.getResponseHeader("Content-Length"))};h.open("GET",k,!0);h.overrideMimeType("text/plain; charset=x-user-defined");h.setRequestHeader("Content-Type","text/plain");h.send(null)},
createBinModel:function(a,b,c,d){var f=function(g){function h(z,F){var L=n(z,F),G=n(z,F+1),U=n(z,F+2),pa=n(z,F+3),ka=(pa<<1&255|U>>7)-127;L|=(U&127)<<16|G<<8;if(L==0&&ka==-127)return 0;return(1-2*(pa>>7))*(1+L*Math.pow(2,-23))*Math.pow(2,ka)}function k(z,F){var L=n(z,F),G=n(z,F+1),U=n(z,F+2);return(n(z,F+3)<<24)+(U<<16)+(G<<8)+L}function j(z,F){var L=n(z,F);return(n(z,F+1)<<8)+L}function l(z,F){var L=n(z,F);return L>127?L-256:L}function n(z,F){return z.charCodeAt(F)&255}function v(z){var F,L,G;F=
k(a,z);L=k(a,z+ba);G=k(a,z+O);z=j(a,z+P);THREE.Loader.prototype.f3(u,F,L,G,z)}function p(z){var F,L,G,U,pa,ka;F=k(a,z);L=k(a,z+ba);G=k(a,z+O);U=j(a,z+P);pa=k(a,z+V);ka=k(a,z+T);z=k(a,z+Y);THREE.Loader.prototype.f3n(u,M,F,L,G,U,pa,ka,z)}function q(z){var F,L,G,U;F=k(a,z);L=k(a,z+da);G=k(a,z+J);U=k(a,z+$);z=j(a,z+ra);THREE.Loader.prototype.f4(u,F,L,G,U,z)}function w(z){var F,L,G,U,pa,ka,oa,na;F=k(a,z);L=k(a,z+da);G=k(a,z+J);U=k(a,z+$);pa=j(a,z+ra);ka=k(a,z+Z);oa=k(a,z+la);na=k(a,z+ja);z=k(a,z+fa);THREE.Loader.prototype.f4n(u,
M,F,L,G,U,pa,ka,oa,na,z)}function B(z){var F,L;F=k(a,z);L=k(a,z+sa);z=k(a,z+m);THREE.Loader.prototype.uv3(u.uvs,e[F*2],e[F*2+1],e[L*2],e[L*2+1],e[z*2],e[z*2+1])}function H(z){var F,L,G;F=k(a,z);L=k(a,z+A);G=k(a,z+x);z=k(a,z+t);THREE.Loader.prototype.uv4(u.uvs,e[F*2],e[F*2+1],e[L*2],e[L*2+1],e[G*2],e[G*2+1],e[z*2],e[z*2+1])}var u=this,I=0,o,M=[],e=[],ba,O,P,V,T,Y,da,J,$,ra,Z,la,ja,fa,sa,m,A,x,t,y,C,D,E,K,W;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(u,d,g);o={signature:a.substr(I,
8),header_bytes:n(a,I+8),vertex_coordinate_bytes:n(a,I+9),normal_coordinate_bytes:n(a,I+10),uv_coordinate_bytes:n(a,I+11),vertex_index_bytes:n(a,I+12),normal_index_bytes:n(a,I+13),uv_index_bytes:n(a,I+14),material_index_bytes:n(a,I+15),nvertices:k(a,I+16),nnormals:k(a,I+16+4),nuvs:k(a,I+16+8),ntri_flat:k(a,I+16+12),ntri_smooth:k(a,I+16+16),ntri_flat_uv:k(a,I+16+20),ntri_smooth_uv:k(a,I+16+24),nquad_flat:k(a,I+16+28),nquad_smooth:k(a,I+16+32),nquad_flat_uv:k(a,I+16+36),nquad_smooth_uv:k(a,I+16+40)};
I+=o.header_bytes;ba=o.vertex_index_bytes;O=o.vertex_index_bytes*2;P=o.vertex_index_bytes*3;V=o.vertex_index_bytes*3+o.material_index_bytes;T=o.vertex_index_bytes*3+o.material_index_bytes+o.normal_index_bytes;Y=o.vertex_index_bytes*3+o.material_index_bytes+o.normal_index_bytes*2;da=o.vertex_index_bytes;J=o.vertex_index_bytes*2;$=o.vertex_index_bytes*3;ra=o.vertex_index_bytes*4;Z=o.vertex_index_bytes*4+o.material_index_bytes;la=o.vertex_index_bytes*4+o.material_index_bytes+o.normal_index_bytes;ja=
o.vertex_index_bytes*4+o.material_index_bytes+o.normal_index_bytes*2;fa=o.vertex_index_bytes*4+o.material_index_bytes+o.normal_index_bytes*3;sa=o.uv_index_bytes;m=o.uv_index_bytes*2;A=o.uv_index_bytes;x=o.uv_index_bytes*2;t=o.uv_index_bytes*3;g=o.vertex_index_bytes*3+o.material_index_bytes;W=o.vertex_index_bytes*4+o.material_index_bytes;y=o.ntri_flat*g;C=o.ntri_smooth*(g+o.normal_index_bytes*3);D=o.ntri_flat_uv*(g+o.uv_index_bytes*3);E=o.ntri_smooth_uv*(g+o.normal_index_bytes*3+o.uv_index_bytes*3);
K=o.nquad_flat*W;g=o.nquad_smooth*(W+o.normal_index_bytes*4);W=o.nquad_flat_uv*(W+o.uv_index_bytes*4);I+=function(z){for(var F,L,G,U=o.vertex_coordinate_bytes*3,pa=z+o.nvertices*U;z<pa;z+=U){F=h(a,z);L=h(a,z+o.vertex_coordinate_bytes);G=h(a,z+o.vertex_coordinate_bytes*2);THREE.Loader.prototype.v(u,F,L,G)}return o.nvertices*U}(I);I+=function(z){for(var F,L,G,U=o.normal_coordinate_bytes*3,pa=z+o.nnormals*U;z<pa;z+=U){F=l(a,z);L=l(a,z+o.normal_coordinate_bytes);G=l(a,z+o.normal_coordinate_bytes*2);M.push(F/
127,L/127,G/127)}return o.nnormals*U}(I);I+=function(z){for(var F,L,G=o.uv_coordinate_bytes*2,U=z+o.nuvs*G;z<U;z+=G){F=h(a,z);L=h(a,z+o.uv_coordinate_bytes);e.push(F,L)}return o.nuvs*G}(I);y=I+y;C=y+C;D=C+D;E=D+E;K=E+K;g=K+g;W=g+W;(function(z){var F,L=o.vertex_index_bytes*3+o.material_index_bytes,G=L+o.uv_index_bytes*3,U=z+o.ntri_flat_uv*G;for(F=z;F<U;F+=G){v(F);B(F+L)}return U-z})(C);(function(z){var F,L=o.vertex_index_bytes*3+o.material_index_bytes+o.normal_index_bytes*3,G=L+o.uv_index_bytes*3,
U=z+o.ntri_smooth_uv*G;for(F=z;F<U;F+=G){p(F);B(F+L)}return U-z})(D);(function(z){var F,L=o.vertex_index_bytes*4+o.material_index_bytes,G=L+o.uv_index_bytes*4,U=z+o.nquad_flat_uv*G;for(F=z;F<U;F+=G){q(F);H(F+L)}return U-z})(g);(function(z){var F,L=o.vertex_index_bytes*4+o.material_index_bytes+o.normal_index_bytes*4,G=L+o.uv_index_bytes*4,U=z+o.nquad_smooth_uv*G;for(F=z;F<U;F+=G){w(F);H(F+L)}return U-z})(W);(function(z){var F,L=o.vertex_index_bytes*3+o.material_index_bytes,G=z+o.ntri_flat*L;for(F=
z;F<G;F+=L)v(F);return G-z})(I);(function(z){var F,L=o.vertex_index_bytes*3+o.material_index_bytes+o.normal_index_bytes*3,G=z+o.ntri_smooth*L;for(F=z;F<G;F+=L)p(F);return G-z})(y);(function(z){var F,L=o.vertex_index_bytes*4+o.material_index_bytes,G=z+o.nquad_flat*L;for(F=z;F<G;F+=L)q(F);return G-z})(E);(function(z){var F,L=o.vertex_index_bytes*4+o.material_index_bytes+o.normal_index_bytes*4,G=z+o.nquad_smooth*L;for(F=z;F<G;F+=L)w(F);return G-z})(K);this.computeCentroids();this.computeFaceNormals();
this.sortFacesByMaterial()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;b(new f(c))},createModel:function(a,b,c){var d=function(f){var g=this;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(g,a.materials,f);(function(){var h,k,j,l,n;h=0;for(k=a.vertices.length;h<k;h+=3){j=a.vertices[h];l=a.vertices[h+1];n=a.vertices[h+2];THREE.Loader.prototype.v(g,j,l,n)}if(a.colors){h=0;for(k=a.colors.length;h<k;h+=3){j=a.colors[h];l=a.colors[h+1];n=a.colors[h+2];THREE.Loader.prototype.vc(g,
j,l,n)}}})();(function(){function h(w,B){THREE.Loader.prototype.f3(g,w[B],w[B+1],w[B+2],w[B+3])}function k(w,B){THREE.Loader.prototype.f3n(g,a.normals,w[B],w[B+1],w[B+2],w[B+3],w[B+4],w[B+5],w[B+6])}function j(w,B){THREE.Loader.prototype.f4(g,w[B],w[B+1],w[B+2],w[B+3],w[B+4])}function l(w,B){THREE.Loader.prototype.f4n(g,a.normals,w[B],w[B+1],w[B+2],w[B+3],w[B+4],w[B+5],w[B+6],w[B+7],w[B+8])}function n(w,B){var H,u,I,o,M,e,ba,O,P;H=w[B];u=w[B+1];I=w[B+2];o=a.uvs[H*2];ba=a.uvs[H*2+1];M=a.uvs[u*2];O=
a.uvs[u*2+1];e=a.uvs[I*2];P=a.uvs[I*2+1];THREE.Loader.prototype.uv3(g.uvs,o,ba,M,O,e,P);if(a.uvs2&&a.uvs2.length){o=a.uvs2[H*2];ba=a.uvs2[H*2+1];M=a.uvs2[u*2];O=a.uvs2[u*2+1];e=a.uvs2[I*2];P=a.uvs2[I*2+1];THREE.Loader.prototype.uv3(g.uvs2,o,1-ba,M,1-O,e,1-P)}}function v(w,B){var H,u,I,o,M,e,ba,O,P,V,T,Y;H=w[B];u=w[B+1];I=w[B+2];o=w[B+3];M=a.uvs[H*2];P=a.uvs[H*2+1];e=a.uvs[u*2];V=a.uvs[u*2+1];ba=a.uvs[I*2];T=a.uvs[I*2+1];O=a.uvs[o*2];Y=a.uvs[o*2+1];THREE.Loader.prototype.uv4(g.uvs,M,P,e,V,ba,T,O,Y);
if(a.uvs2){M=a.uvs2[H*2];P=a.uvs2[H*2+1];e=a.uvs2[u*2];V=a.uvs2[u*2+1];ba=a.uvs2[I*2];T=a.uvs2[I*2+1];O=a.uvs2[o*2];Y=a.uvs2[o*2+1];THREE.Loader.prototype.uv4(g.uvs2,M,1-P,e,1-V,ba,1-T,O,1-Y)}}var p,q;p=0;for(q=a.trianglesUvs.length;p<q;p+=7){h(a.trianglesUvs,p);n(a.trianglesUvs,p+4)}p=0;for(q=a.trianglesNormalsUvs.length;p<q;p+=10){k(a.trianglesNormalsUvs,p);n(a.trianglesNormalsUvs,p+7)}p=0;for(q=a.quadsUvs.length;p<q;p+=9){j(a.quadsUvs,p);v(a.quadsUvs,p+5)}p=0;for(q=a.quadsNormalsUvs.length;p<q;p+=
13){l(a.quadsNormalsUvs,p);v(a.quadsNormalsUvs,p+9)}p=0;for(q=a.triangles.length;p<q;p+=4)h(a.triangles,p);p=0;for(q=a.trianglesNormals.length;p<q;p+=7)k(a.trianglesNormals,p);p=0;for(q=a.quads.length;p<q;p+=5)j(a.quads,p);p=0;for(q=a.quadsNormals.length;p<q;p+=9)l(a.quadsNormals,p)})();(function(){var h,k,j,l;if(a.skinWeights){h=0;for(k=a.skinWeights.length;h<k;h+=2){j=a.skinWeights[h];l=a.skinWeights[h+1];THREE.Loader.prototype.sw(g,j,l,0,0)}}if(a.skinIndices){h=0;for(k=a.skinIndices.length;h<k;h+=
2){j=a.skinIndices[h];l=a.skinIndices[h+1];THREE.Loader.prototype.si(g,j,l,0,0)}}THREE.Loader.prototype.bones(g,a.bones);THREE.Loader.prototype.animation(g,a.animation)})();this.computeCentroids();this.computeFaceNormals();this.sortFacesByMaterial()};d.prototype=new THREE.Geometry;d.prototype.constructor=d;b(new d(c))},bones:function(a,b){a.bones=b},animation:function(a,b){a.animation=b},si:function(a,b,c,d,f){a.skinIndices.push(new THREE.Vector4(b,c,d,f))},sw:function(a,b,c,d,f){a.skinWeights.push(new THREE.Vector4(b,
c,d,f))},v:function(a,b,c,d){a.vertices.push(new THREE.Vertex(new THREE.Vector3(b,c,d)))},vc:function(a,b,c,d){var f=new THREE.Color(16777215);f.setRGB(b,c,d);a.colors.push(f)},f3:function(a,b,c,d,f){a.faces.push(new THREE.Face3(b,c,d,null,a.materials[f]))},f4:function(a,b,c,d,f,g){a.faces.push(new THREE.Face4(b,c,d,f,null,a.materials[g]))},f3n:function(a,b,c,d,f,g,h,k,j){g=a.materials[g];var l=b[k*3],n=b[k*3+1];k=b[k*3+2];var v=b[j*3],p=b[j*3+1];j=b[j*3+2];a.faces.push(new THREE.Face3(c,d,f,[new THREE.Vector3(b[h*
3],b[h*3+1],b[h*3+2]),new THREE.Vector3(l,n,k),new THREE.Vector3(v,p,j)],g))},f4n:function(a,b,c,d,f,g,h,k,j,l,n){h=a.materials[h];var v=b[j*3],p=b[j*3+1];j=b[j*3+2];var q=b[l*3],w=b[l*3+1];l=b[l*3+2];var B=b[n*3],H=b[n*3+1];n=b[n*3+2];a.faces.push(new THREE.Face4(c,d,f,g,[new THREE.Vector3(b[k*3],b[k*3+1],b[k*3+2]),new THREE.Vector3(v,p,j),new THREE.Vector3(q,w,l),new THREE.Vector3(B,H,n)],h))},uv3:function(a,b,c,d,f,g,h){var k=[];k.push(new THREE.UV(b,c));k.push(new THREE.UV(d,f));k.push(new THREE.UV(g,
h));a.push(k)},uv4:function(a,b,c,d,f,g,h,k,j){var l=[];l.push(new THREE.UV(b,c));l.push(new THREE.UV(d,f));l.push(new THREE.UV(g,h));l.push(new THREE.UV(k,j));a.push(l)},init_materials:function(a,b,c){a.materials=[];for(var d=0;d<b.length;++d)a.materials[d]=[THREE.Loader.prototype.createMaterial(b[d],c)]},createMaterial:function(a,b){function c(k){k=Math.log(k)/Math.LN2;return Math.floor(k)==k}function d(k,j){var l=new Image;l.onload=function(){if(!c(this.width)||!c(this.height)){var n=Math.pow(2,
Math.round(Math.log(this.width)/Math.LN2)),v=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));k.image.width=n;k.image.height=v;k.image.getContext("2d").drawImage(this,0,0,n,v)}else k.image=this;k.needsUpdate=!0};l.src=j}var f,g,h;f="MeshLambertMaterial";g={color:15658734,opacity:1,map:null,lightMap:null,vertexColors:a.vertexColors};a.shading&&a.shading=="Phong"&&(f="MeshPhongMaterial");if(a.mapDiffuse&&b){h=document.createElement("canvas");g.map=new THREE.Texture(h);d(g.map,b+"/"+a.mapDiffuse)}else if(a.colorDiffuse){h=
(a.colorDiffuse[0]*255<<16)+(a.colorDiffuse[1]*255<<8)+a.colorDiffuse[2]*255;g.color=h;g.opacity=a.transparency}else if(a.DbgColor)g.color=a.DbgColor;if(a.mapLightmap&&b){h=document.createElement("canvas");g.lightMap=new THREE.Texture(h);d(g.lightMap,b+"/"+a.mapLightmap)}return new THREE[f](g)},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")}};
