// Three.js r29 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.autoUpdate=true;this.setHex(a)};
THREE.Color.prototype={setRGB:function(a,b,f){this.r=a;this.g=b;this.b=f;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGBA();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGBA:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+
","+~~(this.g*255)+","+~~(this.b*255)+")"},toString:function(){return"THREE.Color ( r: "+this.r+", g: "+this.g+", b: "+this.b+", hex: "+this.hex+" )"}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},unit:function(){this.multiplyScalar(1/this.length());return this},length:function(){return Math.sqrt(this.x*
this.x+this.y*this.y)},lengthSq:function(){return this.x*this.x+this.y*this.y},negate:function(){this.x=-this.x;this.y=-this.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},toString:function(){return"THREE.Vector2 ("+this.x+", "+this.y+")"}};THREE.Vector3=function(a,b,f){this.x=a||0;this.y=b||0;this.z=f||0};
THREE.Vector3.prototype={set:function(a,b,f){this.x=a;this.y=b;this.z=f;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,f=this.y,c=this.z;this.x=f*a.z-c*a.y;this.y=c*a.x-b*a.z;this.z=b*a.y-f*a.x;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},
distanceToSquared:function(a){var b=this.x-a.x,f=this.y-a.y;a=this.z-a.z;return b*b+f*f+a*a},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},normalize:function(){this.length()>0?this.multiplyScalar(1/this.length()):this.multiplyScalar(0);return this},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<
1.0E-4&&Math.abs(this.y)<1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},toString:function(){return"THREE.Vector3 ( "+this.x+", "+this.y+", "+this.z+" )"}};THREE.Vector4=function(a,b,f,c){this.x=a||0;this.y=b||0;this.z=f||0;this.w=c||1};
THREE.Vector4.prototype={set:function(a,b,f,c){this.x=a;this.y=b;this.z=f;this.w=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w||1;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;
return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){this.x/=a;this.y/=a;this.z/=a;this.w/=a;return this},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},toString:function(){return"THREE.Vector4 ("+this.x+", "+this.y+", "+this.z+", "+this.w+")"}};
THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,f,c=a.objects,d=[];a=0;for(b=c.length;a<b;a++){f=c[a];if(f instanceof THREE.Mesh)d=d.concat(this.intersectObject(f))}d.sort(function(j,o){return j.distance-o.distance});return d},intersectObject:function(a){function b(w,i,z,r){r=r.clone().subSelf(i);z=z.clone().subSelf(i);var C=w.clone().subSelf(i);w=r.dot(r);i=r.dot(z);r=r.dot(C);var u=z.dot(z);z=z.dot(C);C=1/(w*u-i*i);u=(u*r-i*z)*C;w=(w*z-i*r)*C;return u>0&&w>0&&u+w<1}var f,c,d,j,o,t,e,g,l,h,
m,s=a.geometry,n=s.vertices,q=[];f=0;for(c=s.faces.length;f<c;f++){d=s.faces[f];h=this.origin.clone();m=this.direction.clone();j=a.matrix.transform(n[d.a].position.clone());o=a.matrix.transform(n[d.b].position.clone());t=a.matrix.transform(n[d.c].position.clone());e=d instanceof THREE.Face4?a.matrix.transform(n[d.d].position.clone()):null;g=a.matrixRotation.transform(d.normal.clone());l=m.dot(g);if(l<0){g=g.dot((new THREE.Vector3).sub(j,h))/l;h=h.addSelf(m.multiplyScalar(g));if(d instanceof THREE.Face3){if(b(h,
j,o,t)){d={distance:this.origin.distanceTo(h),point:h,face:d,object:a};q.push(d)}}else if(d instanceof THREE.Face4)if(b(h,j,o,e)||b(h,o,t,e)){d={distance:this.origin.distanceTo(h),point:h,face:d,object:a};q.push(d)}}}return q}};
THREE.Rectangle=function(){function a(){j=c-b;o=d-f}var b,f,c,d,j,o,t=true;this.getX=function(){return b};this.getY=function(){return f};this.getWidth=function(){return j};this.getHeight=function(){return o};this.getLeft=function(){return b};this.getTop=function(){return f};this.getRight=function(){return c};this.getBottom=function(){return d};this.set=function(e,g,l,h){t=false;b=e;f=g;c=l;d=h;a()};this.addPoint=function(e,g){if(t){t=false;b=e;f=g;c=e;d=g}else{b=Math.min(b,e);f=Math.min(f,g);c=Math.max(c,
e);d=Math.max(d,g)}a()};this.addRectangle=function(e){if(t){t=false;b=e.getLeft();f=e.getTop();c=e.getRight();d=e.getBottom()}else{b=Math.min(b,e.getLeft());f=Math.min(f,e.getTop());c=Math.max(c,e.getRight());d=Math.max(d,e.getBottom())}a()};this.inflate=function(e){b-=e;f-=e;c+=e;d+=e;a()};this.minSelf=function(e){b=Math.max(b,e.getLeft());f=Math.max(f,e.getTop());c=Math.min(c,e.getRight());d=Math.min(d,e.getBottom());a()};this.instersects=function(e){return Math.min(c,e.getRight())-Math.max(b,e.getLeft())>=
0&&Math.min(d,e.getBottom())-Math.max(f,e.getTop())>=0};this.empty=function(){t=true;d=c=f=b=0;a()};this.isEmpty=function(){return t};this.toString=function(){return"THREE.Rectangle ( left: "+b+", right: "+c+", top: "+f+", bottom: "+d+", width: "+j+", height: "+o+" )"}};THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a;a=this.m[1];this.m[1]=this.m[3];this.m[3]=a;a=this.m[2];this.m[2]=this.m[6];this.m[6]=a;a=this.m[5];this.m[5]=this.m[7];this.m[7]=a;return this}};
THREE.Matrix4=function(){this._x=new THREE.Vector3;this._y=new THREE.Vector3;this._z=new THREE.Vector3};
THREE.Matrix4.prototype={n11:1,n12:0,n13:0,n14:0,n21:0,n22:1,n23:0,n24:0,n31:0,n32:0,n33:1,n34:0,n41:0,n42:0,n43:0,n44:1,identity:function(){this.n11=1;this.n21=this.n14=this.n13=this.n12=0;this.n22=1;this.n32=this.n31=this.n24=this.n23=0;this.n33=1;this.n43=this.n42=this.n41=this.n34=0;this.n44=1},copy:function(a){this.n11=a.n11;this.n12=a.n12;this.n13=a.n13;this.n14=a.n14;this.n21=a.n21;this.n22=a.n22;this.n23=a.n23;this.n24=a.n24;this.n31=a.n31;this.n32=a.n32;this.n33=a.n33;this.n34=a.n34;this.n41=
a.n41;this.n42=a.n42;this.n43=a.n43;this.n44=a.n44},lookAt:function(a,b,f){var c=this._x,d=this._y,j=this._z;j.sub(a,b);j.normalize();c.cross(f,j);c.normalize();d.cross(j,c);d.normalize();this.n11=c.x;this.n12=c.y;this.n13=c.z;this.n14=-c.dot(a);this.n21=d.x;this.n22=d.y;this.n23=d.z;this.n24=-d.dot(a);this.n31=j.x;this.n32=j.y;this.n33=j.z;this.n34=-j.dot(a);this.n43=this.n42=this.n41=0;this.n44=1},transform:function(a){var b=a.x,f=a.y,c=a.z,d=a.w?a.w:1;a.x=this.n11*b+this.n12*f+this.n13*c+this.n14*
d;a.y=this.n21*b+this.n22*f+this.n23*c+this.n24*d;a.z=this.n31*b+this.n32*f+this.n33*c+this.n34*d;d=this.n41*b+this.n42*f+this.n43*c+this.n44*d;if(a.w)a.w=d;else{a.x/=d;a.y/=d;a.z/=d}return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,
b){this.n11=a.n11*b.n11+a.n12*b.n21+a.n13*b.n31+a.n14*b.n41;this.n12=a.n11*b.n12+a.n12*b.n22+a.n13*b.n32+a.n14*b.n42;this.n13=a.n11*b.n13+a.n12*b.n23+a.n13*b.n33+a.n14*b.n43;this.n14=a.n11*b.n14+a.n12*b.n24+a.n13*b.n34+a.n14*b.n44;this.n21=a.n21*b.n11+a.n22*b.n21+a.n23*b.n31+a.n24*b.n41;this.n22=a.n21*b.n12+a.n22*b.n22+a.n23*b.n32+a.n24*b.n42;this.n23=a.n21*b.n13+a.n22*b.n23+a.n23*b.n33+a.n24*b.n43;this.n24=a.n21*b.n14+a.n22*b.n24+a.n23*b.n34+a.n24*b.n44;this.n31=a.n31*b.n11+a.n32*b.n21+a.n33*b.n31+
a.n34*b.n41;this.n32=a.n31*b.n12+a.n32*b.n22+a.n33*b.n32+a.n34*b.n42;this.n33=a.n31*b.n13+a.n32*b.n23+a.n33*b.n33+a.n34*b.n43;this.n34=a.n31*b.n14+a.n32*b.n24+a.n33*b.n34+a.n34*b.n44;this.n41=a.n41*b.n11+a.n42*b.n21+a.n43*b.n31+a.n44*b.n41;this.n42=a.n41*b.n12+a.n42*b.n22+a.n43*b.n32+a.n44*b.n42;this.n43=a.n41*b.n13+a.n42*b.n23+a.n43*b.n33+a.n44*b.n43;this.n44=a.n41*b.n14+a.n42*b.n24+a.n43*b.n34+a.n44*b.n44},multiplySelf:function(a){var b=this.n11,f=this.n12,c=this.n13,d=this.n14,j=this.n21,o=this.n22,
t=this.n23,e=this.n24,g=this.n31,l=this.n32,h=this.n33,m=this.n34,s=this.n41,n=this.n42,q=this.n43,w=this.n44;this.n11=b*a.n11+f*a.n21+c*a.n31+d*a.n41;this.n12=b*a.n12+f*a.n22+c*a.n32+d*a.n42;this.n13=b*a.n13+f*a.n23+c*a.n33+d*a.n43;this.n14=b*a.n14+f*a.n24+c*a.n34+d*a.n44;this.n21=j*a.n11+o*a.n21+t*a.n31+e*a.n41;this.n22=j*a.n12+o*a.n22+t*a.n32+e*a.n42;this.n23=j*a.n13+o*a.n23+t*a.n33+e*a.n43;this.n24=j*a.n14+o*a.n24+t*a.n34+e*a.n44;this.n31=g*a.n11+l*a.n21+h*a.n31+m*a.n41;this.n32=g*a.n12+l*a.n22+
h*a.n32+m*a.n42;this.n33=g*a.n13+l*a.n23+h*a.n33+m*a.n43;this.n34=g*a.n14+l*a.n24+h*a.n34+m*a.n44;this.n41=s*a.n11+n*a.n21+q*a.n31+w*a.n41;this.n42=s*a.n12+n*a.n22+q*a.n32+w*a.n42;this.n43=s*a.n13+n*a.n23+q*a.n33+w*a.n43;this.n44=s*a.n14+n*a.n24+q*a.n34+w*a.n44},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a},determinant:function(){return this.n14*
this.n23*this.n32*this.n41-this.n13*this.n24*this.n32*this.n41-this.n14*this.n22*this.n33*this.n41+this.n12*this.n24*this.n33*this.n41+this.n13*this.n22*this.n34*this.n41-this.n12*this.n23*this.n34*this.n41-this.n14*this.n23*this.n31*this.n42+this.n13*this.n24*this.n31*this.n42+this.n14*this.n21*this.n33*this.n42-this.n11*this.n24*this.n33*this.n42-this.n13*this.n21*this.n34*this.n42+this.n11*this.n23*this.n34*this.n42+this.n14*this.n22*this.n31*this.n43-this.n12*this.n24*this.n31*this.n43-this.n14*
this.n21*this.n32*this.n43+this.n11*this.n24*this.n32*this.n43+this.n12*this.n21*this.n34*this.n43-this.n11*this.n22*this.n34*this.n43-this.n13*this.n22*this.n31*this.n44+this.n12*this.n23*this.n31*this.n44+this.n13*this.n21*this.n32*this.n44-this.n11*this.n23*this.n32*this.n44-this.n12*this.n21*this.n33*this.n44+this.n11*this.n22*this.n33*this.n44},transpose:function(){function a(b,f,c){var d=b[f];b[f]=b[c];b[c]=d}a(this,"n21","n12");a(this,"n31","n13");a(this,"n32","n23");a(this,"n41","n14");a(this,
"n42","n24");a(this,"n43","n34");return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){return[this.n11,this.n21,this.n31,this.n41,this.n12,this.n22,this.n32,this.n42,this.n13,this.n23,this.n33,this.n43,this.n14,this.n24,this.n34,this.n44]},
toString:function(){return"| "+this.n11+" "+this.n12+" "+this.n13+" "+this.n14+" |\n| "+this.n21+" "+this.n22+" "+this.n23+" "+this.n24+" |\n| "+this.n31+" "+this.n32+" "+this.n33+" "+this.n34+" |\n| "+this.n41+" "+this.n42+" "+this.n43+" "+this.n44+" |"}};THREE.Matrix4.translationMatrix=function(a,b,f){var c=new THREE.Matrix4;c.n14=a;c.n24=b;c.n34=f;return c};THREE.Matrix4.scaleMatrix=function(a,b,f){var c=new THREE.Matrix4;c.n11=a;c.n22=b;c.n33=f;return c};
THREE.Matrix4.rotationXMatrix=function(a){var b=new THREE.Matrix4;b.n22=b.n33=Math.cos(a);b.n32=Math.sin(a);b.n23=-b.n32;return b};THREE.Matrix4.rotationYMatrix=function(a){var b=new THREE.Matrix4;b.n11=b.n33=Math.cos(a);b.n13=Math.sin(a);b.n31=-b.n13;return b};THREE.Matrix4.rotationZMatrix=function(a){var b=new THREE.Matrix4;b.n11=b.n22=Math.cos(a);b.n21=Math.sin(a);b.n12=-b.n21;return b};
THREE.Matrix4.rotationAxisAngleMatrix=function(a,b){var f=new THREE.Matrix4,c=Math.cos(b),d=Math.sin(b),j=1-c,o=a.x,t=a.y,e=a.z;f.n11=j*o*o+c;f.n12=j*o*t-d*e;f.n13=j*o*e+d*t;f.n21=j*o*t+d*e;f.n22=j*t*t+c;f.n23=j*t*e-d*o;f.n31=j*o*e-d*t;f.n32=j*t*e+d*o;f.n33=j*e*e+c;return f};
THREE.Matrix4.makeInvert=function(a){var b=new THREE.Matrix4;b.n11=a.n23*a.n34*a.n42-a.n24*a.n33*a.n42+a.n24*a.n32*a.n43-a.n22*a.n34*a.n43-a.n23*a.n32*a.n44+a.n22*a.n33*a.n44;b.n12=a.n14*a.n33*a.n42-a.n13*a.n34*a.n42-a.n14*a.n32*a.n43+a.n12*a.n34*a.n43+a.n13*a.n32*a.n44-a.n12*a.n33*a.n44;b.n13=a.n13*a.n24*a.n42-a.n14*a.n23*a.n42+a.n14*a.n22*a.n43-a.n12*a.n24*a.n43-a.n13*a.n22*a.n44+a.n12*a.n23*a.n44;b.n14=a.n14*a.n23*a.n32-a.n13*a.n24*a.n32-a.n14*a.n22*a.n33+a.n12*a.n24*a.n33+a.n13*a.n22*a.n34-a.n12*
a.n23*a.n34;b.n21=a.n24*a.n33*a.n41-a.n23*a.n34*a.n41-a.n24*a.n31*a.n43+a.n21*a.n34*a.n43+a.n23*a.n31*a.n44-a.n21*a.n33*a.n44;b.n22=a.n13*a.n34*a.n41-a.n14*a.n33*a.n41+a.n14*a.n31*a.n43-a.n11*a.n34*a.n43-a.n13*a.n31*a.n44+a.n11*a.n33*a.n44;b.n23=a.n14*a.n23*a.n41-a.n13*a.n24*a.n41-a.n14*a.n21*a.n43+a.n11*a.n24*a.n43+a.n13*a.n21*a.n44-a.n11*a.n23*a.n44;b.n24=a.n13*a.n24*a.n31-a.n14*a.n23*a.n31+a.n14*a.n21*a.n33-a.n11*a.n24*a.n33-a.n13*a.n21*a.n34+a.n11*a.n23*a.n34;b.n31=a.n22*a.n34*a.n41-a.n24*a.n32*
a.n41+a.n24*a.n31*a.n42-a.n21*a.n34*a.n42-a.n22*a.n31*a.n44+a.n21*a.n32*a.n44;b.n32=a.n14*a.n32*a.n41-a.n12*a.n34*a.n41-a.n14*a.n31*a.n42+a.n11*a.n34*a.n42+a.n12*a.n31*a.n44-a.n11*a.n32*a.n44;b.n33=a.n13*a.n24*a.n41-a.n14*a.n22*a.n41+a.n14*a.n21*a.n42-a.n11*a.n24*a.n42-a.n12*a.n21*a.n44+a.n11*a.n22*a.n44;b.n34=a.n14*a.n22*a.n31-a.n12*a.n24*a.n31-a.n14*a.n21*a.n32+a.n11*a.n24*a.n32+a.n12*a.n21*a.n34-a.n11*a.n22*a.n34;b.n41=a.n23*a.n32*a.n41-a.n22*a.n33*a.n41-a.n23*a.n31*a.n42+a.n21*a.n33*a.n42+a.n22*
a.n31*a.n43-a.n21*a.n32*a.n43;b.n42=a.n12*a.n33*a.n41-a.n13*a.n32*a.n41+a.n13*a.n31*a.n42-a.n11*a.n33*a.n42-a.n12*a.n31*a.n43+a.n11*a.n32*a.n43;b.n43=a.n13*a.n22*a.n41-a.n12*a.n23*a.n41-a.n13*a.n21*a.n42+a.n11*a.n23*a.n42+a.n12*a.n21*a.n43-a.n11*a.n22*a.n43;b.n44=a.n12*a.n23*a.n31-a.n13*a.n22*a.n31+a.n13*a.n21*a.n32-a.n11*a.n23*a.n32-a.n12*a.n21*a.n33+a.n11*a.n22*a.n33;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.flatten();a=new THREE.Matrix3;var f=b[10]*b[5]-b[6]*b[9],c=-b[10]*b[1]+b[2]*b[9],d=b[6]*b[1]-b[2]*b[5],j=-b[10]*b[4]+b[6]*b[8],o=b[10]*b[0]-b[2]*b[8],t=-b[6]*b[0]+b[2]*b[4],e=b[9]*b[4]-b[5]*b[8],g=-b[9]*b[0]+b[1]*b[8],l=b[5]*b[0]-b[1]*b[4];b=b[0]*f+b[1]*j+b[2]*e;if(b==0)throw"matrix not invertible";b=1/b;a.m[0]=b*f;a.m[1]=b*c;a.m[2]=b*d;a.m[3]=b*j;a.m[4]=b*o;a.m[5]=b*t;a.m[6]=b*e;a.m[7]=b*g;a.m[8]=b*l;return a};
THREE.Matrix4.makeFrustum=function(a,b,f,c,d,j){var o,t,e;o=new THREE.Matrix4;t=2*d/(b-a);e=2*d/(c-f);a=(b+a)/(b-a);f=(c+f)/(c-f);c=-(j+d)/(j-d);d=-2*j*d/(j-d);o.n11=t;o.n12=0;o.n13=a;o.n14=0;o.n21=0;o.n22=e;o.n23=f;o.n24=0;o.n31=0;o.n32=0;o.n33=c;o.n34=d;o.n41=0;o.n42=0;o.n43=-1;o.n44=0;return o};THREE.Matrix4.makePerspective=function(a,b,f,c){var d;a=f*Math.tan(a*Math.PI/360);d=-a;return THREE.Matrix4.makeFrustum(d*b,a*b,d,a,f,c)};
THREE.Matrix4.makeOrtho=function(a,b,f,c,d,j){var o,t,e,g;o=new THREE.Matrix4;t=b-a;e=f-c;g=j-d;a=(b+a)/t;f=(f+c)/e;d=(j+d)/g;o.n11=2/t;o.n12=0;o.n13=0;o.n14=-a;o.n21=0;o.n22=2/e;o.n23=0;o.n24=-f;o.n31=0;o.n32=0;o.n33=-2/g;o.n34=-d;o.n41=0;o.n42=0;o.n43=0;o.n44=1;return o};
THREE.Vertex=function(a,b){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=b||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.__visible=true};THREE.Vertex.prototype={toString:function(){return"THREE.Vertex ( position: "+this.position+", normal: "+this.normal+" )"}};
THREE.Face3=function(a,b,f,c,d){this.a=a;this.b=b;this.c=f;this.centroid=new THREE.Vector3;this.normal=c instanceof THREE.Vector3?c:new THREE.Vector3;this.vertexNormals=c instanceof Array?c:[];this.material=d instanceof Array?d:[d]};THREE.Face3.prototype={toString:function(){return"THREE.Face3 ( "+this.a+", "+this.b+", "+this.c+" )"}};
THREE.Face4=function(a,b,f,c,d,j){this.a=a;this.b=b;this.c=f;this.d=c;this.centroid=new THREE.Vector3;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.material=j instanceof Array?j:[j]};THREE.Face4.prototype={toString:function(){return"THREE.Face4 ( "+this.a+", "+this.b+", "+this.c+" "+this.d+" )"}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={copy:function(a){this.u=a.u;this.v=a.v},toString:function(){return"THREE.UV ("+this.u+", "+this.v+")"}};THREE.Geometry=function(){this.vertices=[];this.faces=[];this.uvs=[]};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,f;a=0;for(b=this.faces.length;a<b;a++){f=this.faces[a];f.centroid.set(0,0,0);if(f instanceof THREE.Face3){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);f.centroid.divideScalar(3)}else if(f instanceof THREE.Face4){f.centroid.addSelf(this.vertices[f.a].position);f.centroid.addSelf(this.vertices[f.b].position);f.centroid.addSelf(this.vertices[f.c].position);
f.centroid.addSelf(this.vertices[f.d].position);f.centroid.divideScalar(4)}}},computeNormals:function(a){var b,f,c,d,j,o,t=new THREE.Vector3,e=new THREE.Vector3;c=0;for(d=this.vertices.length;c<d;c++){j=this.vertices[c];j.normal.set(0,0,0)}c=0;for(d=this.faces.length;c<d;c++){j=this.faces[c];if(a&&j.vertexNormals.length){t.set(0,0,0);b=0;for(f=j.normal.length;b<f;b++)t.addSelf(j.vertexNormals[b]);t.divideScalar(3)}else{b=this.vertices[j.a];f=this.vertices[j.b];o=this.vertices[j.c];t.sub(o.position,
f.position);e.sub(b.position,f.position);t.crossSelf(e)}t.isZero()||t.normalize();j.normal.copy(t)}},computeBoundingBox:function(){if(this.vertices.length>0){this.bbox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var a=1,b=this.vertices.length;a<b;a++){vertex=this.vertices[a];if(vertex.position.x<this.bbox.x[0])this.bbox.x[0]=vertex.position.x;else if(vertex.position.x>
this.bbox.x[1])this.bbox.x[1]=vertex.position.x;if(vertex.position.y<this.bbox.y[0])this.bbox.y[0]=vertex.position.y;else if(vertex.position.y>this.bbox.y[1])this.bbox.y[1]=vertex.position.y;if(vertex.position.z<this.bbox.z[0])this.bbox.z[0]=vertex.position.z;else if(vertex.position.z>this.bbox.z[1])this.bbox.z[1]=vertex.position.z}}},toString:function(){return"THREE.Geometry ( vertices: "+this.vertices+", faces: "+this.faces+" )"}};
THREE.Camera=function(a,b,f,c){this.position=new THREE.Vector3(0,0,0);this.target={position:new THREE.Vector3(0,0,0)};this.up=new THREE.Vector3(0,1,0);this.matrix=new THREE.Matrix4;this.projectionMatrix=THREE.Matrix4.makePerspective(a,b,f,c);this.autoUpdateMatrix=true;this.updateMatrix=function(){this.matrix.lookAt(this.position,this.target.position,this.up)};this.toString=function(){return"THREE.Camera ( "+this.position+", "+this.target.position+" )"}};
THREE.Light=function(a){this.color=new THREE.Color(-16777216|a)};THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.PointLight;
THREE.Object3D=function(){this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.matrix=new THREE.Matrix4;this.matrixTranslation=new THREE.Matrix4;this.matrixRotation=new THREE.Matrix4;this.matrixScale=new THREE.Matrix4;this.screen=new THREE.Vector3;this.autoUpdateMatrix=true;this.updateMatrix=function(){this.matrixPosition=THREE.Matrix4.translationMatrix(this.position.x,this.position.y,this.position.z);this.matrixRotation=THREE.Matrix4.rotationXMatrix(this.rotation.x);
this.matrixRotation.multiplySelf(THREE.Matrix4.rotationYMatrix(this.rotation.y));this.matrixRotation.multiplySelf(THREE.Matrix4.rotationZMatrix(this.rotation.z));this.matrixScale=THREE.Matrix4.scaleMatrix(this.scale.x,this.scale.y,this.scale.z);this.matrix.copy(this.matrixPosition);this.matrix.multiplySelf(this.matrixRotation);this.matrix.multiplySelf(this.matrixScale)}};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a instanceof Array?a:[a];this.autoUpdateMatrix=false};
THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b instanceof Array?b:[b]};THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b,f){THREE.Object3D.call(this);this.geometry=a;this.material=b instanceof Array?b:[b];this.overdraw=this.doubleSided=this.flipSided=false;this.materialFaceGroup={};this.sortFacesByMaterial();f&&this.normalizeUVs();this.geometry.computeBoundingBox()};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;
THREE.Mesh.prototype.sortFacesByMaterial=function(){function a(l){var h=[];b=0;for(f=l.length;b<f;b++)l[b]==undefined?h.push("undefined"):h.push(l[b].toString());return h.join("_")}var b,f,c,d,j,o,t,e,g={};c=0;for(d=this.geometry.faces.length;c<d;c++){j=this.geometry.faces[c];o=j.material;t=a(o);if(g[t]==undefined)g[t]={hash:t,counter:0};e=g[t].hash+"_"+g[t].counter;if(this.materialFaceGroup[e]==undefined)this.materialFaceGroup[e]={faces:[],material:o,vertices:0};j=j instanceof THREE.Face3?3:4;if(this.materialFaceGroup[e].vertices+
j>65535){g[t].counter+=1;e=g[t].hash+"_"+g[t].counter;if(this.materialFaceGroup[e]==undefined)this.materialFaceGroup[e]={faces:[],material:o,vertices:0}}this.materialFaceGroup[e].faces.push(c);this.materialFaceGroup[e].vertices+=j}};THREE.Mesh.prototype.normalizeUVs=function(){var a,b,f,c,d;a=0;for(b=this.geometry.uvs.length;a<b;a++){d=this.geometry.uvs[a];f=0;for(c=d.length;f<c;f++){if(d[f].u!=1)d[f].u-=Math.floor(d[f].u);if(d[f].v!=1)d[f].v-=Math.floor(d[f].v)}}};THREE.FlatShading=0;
THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;
THREE.LineBasicMaterial=function(a){this.color=new THREE.Color(16711680);this.opacity=1;this.blending=THREE.NormalBlending;this.linewidth=1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.linewidth!==undefined)this.linewidth=a.linewidth}this.toString=function(){return"THREE.LineBasicMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>linewidth: "+
this.linewidth+"<br/>)"}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MeshBasicMaterialCounter.value++;this.color=new THREE.Color(15658734);this.map=null;this.opacity=1;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==
undefined)this.wireframe_linewidth=a.wireframe_linewidth}this.toString=function(){return"THREE.MeshBasicMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>)"}};THREE.MeshBasicMaterialCounter={value:0};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MeshLambertMaterialCounter.value++;this.color=new THREE.Color(15658734);this.map=null;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;
if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth}this.toString=function(){return"THREE.MeshLambertMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>shading: "+this.shading+"<br/>blending: "+this.blending+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_size: "+this.wireframe_linewidth+"<br/> )"}};THREE.MeshLambertMaterialCounter={value:0};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MeshPhongMaterialCounter.value++;this.color=new THREE.Color(15658734);this.map=null;this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.specular_map=null;this.shininess=30;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=false;this.wireframe_linewidth=1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.map!==undefined)this.map=a.map;if(a.ambient!==undefined)this.ambient=
new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.specular_map!==undefined)this.specular_map=a.specular_map;if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframe_linewidth!==undefined)this.wireframe_linewidth=a.wireframe_linewidth}this.toString=
function(){return"THREE.MeshPhongMaterial (<br/>id: "+this.id+"<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>ambient: "+this.ambient+"<br/>specular: "+this.specular+"<br/>specular_map: "+this.specular_map+"<br/>shininess: "+this.shininess+"<br/>alpha: "+this.opacity+"<br/>shading: "+this.shading+"<br/>wireframe: "+this.wireframe+"<br/>wireframe_linewidth: "+this.wireframe_linewidth+"<br/>"+ +")"}};THREE.MeshPhongMaterialCounter={value:0};
THREE.MeshDepthMaterial=function(a){this.near=1;this.far=1E3;this.opacity=1;this.blending=THREE.NormalBlending;if(a){if(a.near!==undefined)this.near=a.near;if(a.far!==undefined)this.far=a.far;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.__2near=2*this.near;this.__farPlusNear=this.far+this.near;this.__farMinusNear=this.far-this.near;this.toString=function(){return"THREE.MeshDepthMaterial"}};
THREE.MeshNormalMaterial=function(a){this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.MeshNormalMaterial"}};THREE.MeshFaceMaterial=function(){this.toString=function(){return"THREE.MeshFaceMaterial"}};
THREE.ParticleBasicMaterial=function(a){this.color=new THREE.Color(16711680);this.map=null;this.opacity=1;this.blending=THREE.NormalBlending;this.offset=new THREE.Vector2;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.map!==undefined)this.map=a.map;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.ParticleBasicMaterial (<br/>color: "+this.color+"<br/>map: "+this.map+"<br/>opacity: "+this.opacity+"<br/>blending: "+
this.blending+"<br/>)"}};THREE.ParticleCircleMaterial=function(a){this.color=new THREE.Color(16711680);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}this.toString=function(){return"THREE.ParticleCircleMaterial (<br/>color: "+this.color+"<br/>opacity: "+this.opacity+"<br/>blending: "+this.blending+"<br/>)"}};
THREE.ParticleDOMMaterial=function(a){this.domElement=a;this.toString=function(){return"THREE.ParticleDOMMaterial ( domElement: "+this.domElement+" )"}};THREE.Texture=function(a,b){this.image=a;this.mapping=b?b:THREE.UVMapping;this.toString=function(){return"THREE.Texture (<br/>image: "+this.image+"<br/>mapping: "+this.mapping+"<br/>)"}};THREE.UVMapping=0;THREE.ReflectionMap=1;THREE.CubeMap=2;
THREE.Scene=function(){this.objects=[];this.lights=[];this.addObject=function(a){this.objects.push(a)};this.removeObject=function(a){a=this.objects.indexOf(a);a!==-1&&this.objects.splice(a,1)};this.addLight=function(a){this.lights.push(a)};this.removeLight=function(a){a=this.lights.indexOf(a);a!==-1&&this.lights.splice(a,1)};this.toString=function(){return"THREE.Scene ( "+this.objects+" )"}};
THREE.Projector=function(){function a(i,z){var r;r=0;var C=1,u=i.z+i.w,K=z.z+z.w,v=-i.z+i.w,p=-z.z+z.w;if(u>=0&&K>=0&&v>=0&&p>=0)r=true;else if(u<0&&K<0||v<0&&p<0)r=false;else{if(u<0)r=Math.max(r,u/(u-K));else if(K<0)C=Math.min(C,u/(u-K));if(v<0)r=Math.max(r,v/(v-p));else if(p<0)C=Math.min(C,v/(v-p));if(C<r)r=false;else{i.lerpSelf(z,r);z.lerpSelf(i,1-C);r=true}}return r}var b=null,f,c,d=[],j,o,t=[],e,g,l=[],h,m,s=[],n=new THREE.Vector4,q=new THREE.Matrix4,w=new THREE.Matrix4;this.projectScene=function(i,
z){var r,C,u,K,v,p,x,L,X,F,R,V,S,B;b=[];m=g=o=c=0;z.autoUpdateMatrix&&z.updateMatrix();q.multiply(z.projectionMatrix,z.matrix);v=i.objects;r=0;for(C=v.length;r<C;r++){p=v[r];x=p.matrix;p.autoUpdateMatrix&&p.updateMatrix();if(p instanceof THREE.Mesh){w.multiply(q,x);L=p.geometry.vertices;u=0;for(K=L.length;u<K;u++){X=L[u];F=X.positionScreen;F.copy(X.position);w.transform(F);F.multiplyScalar(1/F.w);X.__visible=F.z>0&&F.z<1}X=p.geometry.faces;u=0;for(K=X.length;u<K;u++){F=X[u];if(F instanceof THREE.Face3){R=
L[F.a];V=L[F.b];S=L[F.c];if(R.__visible&&V.__visible&&S.__visible)if(p.doubleSided||p.flipSided!=(S.positionScreen.x-R.positionScreen.x)*(V.positionScreen.y-R.positionScreen.y)-(S.positionScreen.y-R.positionScreen.y)*(V.positionScreen.x-R.positionScreen.x)<0){f=d[c]=d[c]||new THREE.RenderableFace3;f.v1.positionScreen.copy(R.positionScreen);f.v2.positionScreen.copy(V.positionScreen);f.v3.positionScreen.copy(S.positionScreen);f.normalWorld.copy(F.normal);p.matrixRotation.transform(f.normalWorld);f.centroidWorld.copy(F.centroid);
x.transform(f.centroidWorld);f.centroidScreen.copy(f.centroidWorld);q.transform(f.centroidScreen);f.z=f.centroidScreen.z;f.meshMaterial=p.material;f.faceMaterial=F.material;f.overdraw=p.overdraw;f.uvs=p.geometry.uvs[u];f.color=F.color;b.push(f);c++}}else if(F instanceof THREE.Face4){R=L[F.a];V=L[F.b];S=L[F.c];B=L[F.d];if(R.__visible&&V.__visible&&S.__visible&&B.__visible)if(p.doubleSided||p.flipSided!=((B.positionScreen.x-R.positionScreen.x)*(V.positionScreen.y-R.positionScreen.y)-(B.positionScreen.y-
R.positionScreen.y)*(V.positionScreen.x-R.positionScreen.x)<0||(V.positionScreen.x-S.positionScreen.x)*(B.positionScreen.y-S.positionScreen.y)-(V.positionScreen.y-S.positionScreen.y)*(B.positionScreen.x-S.positionScreen.x)<0)){j=t[o]=t[o]||new THREE.RenderableFace4;j.v1.positionScreen.copy(R.positionScreen);j.v2.positionScreen.copy(V.positionScreen);j.v3.positionScreen.copy(S.positionScreen);j.v4.positionScreen.copy(B.positionScreen);j.normalWorld.copy(F.normal);p.matrixRotation.transform(j.normalWorld);
j.centroidWorld.copy(F.centroid);x.transform(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);q.transform(j.centroidScreen);j.z=j.centroidScreen.z;j.meshMaterial=p.material;j.faceMaterial=F.material;j.overdraw=p.overdraw;j.uvs=p.geometry.uvs[u];j.color=F.color;b.push(j);o++}}}}else if(p instanceof THREE.Line){w.multiply(q,x);L=p.geometry.vertices;u=0;for(K=L.length;u<K;u++){X=L[u];X.positionScreen.copy(X.position);w.transform(X.positionScreen)}u=1;for(K=L.length;u<K;u++){x=L[u];X=L[u-1];if(a(x.positionScreen,
X.positionScreen)){x.positionScreen.multiplyScalar(1/x.positionScreen.w);X.positionScreen.multiplyScalar(1/X.positionScreen.w);e=l[g]=l[g]||new THREE.RenderableLine;e.v1.positionScreen.copy(x.positionScreen);e.v2.positionScreen.copy(X.positionScreen);e.z=Math.max(x.positionScreen.z,X.positionScreen.z);e.material=p.material;b.push(e);g++}}}else if(p instanceof THREE.Particle){n.set(p.position.x,p.position.y,p.position.z,1);z.matrix.transform(n);z.projectionMatrix.transform(n);p.screen.set(n.x/n.w,
n.y/n.w,n.z/n.w);if(p.screen.z>0&&p.screen.z<1){h=s[m]=s[m]||new THREE.RenderableParticle;h.x=p.screen.x;h.y=p.screen.y;h.z=p.screen.z;h.rotation=p.rotation.z;h.scale.x=p.scale.x*Math.abs(n.x/n.w-(n.x+z.projectionMatrix.n11)/(n.w+z.projectionMatrix.n14));h.scale.y=p.scale.y*Math.abs(n.y/n.w-(n.y+z.projectionMatrix.n22)/(n.w+z.projectionMatrix.n24));h.material=p.material;h.color=p.color;b.push(h);m++}}}b.sort(function(W,N){return N.z-W.z});return b};this.unprojectVector=function(i,z){var r=new THREE.Matrix4;
r.multiply(THREE.Matrix4.makeInvert(z.matrix),THREE.Matrix4.makeInvert(z.projectionMatrix));r.transform(i);return i}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,b=new THREE.Projector,f,c,d,j;this.domElement=document.createElement("div");this.setSize=function(o,t){f=o;c=t;d=f/2;j=c/2};this.render=function(o,t){var e,g,l,h,m,s,n,q;a=b.projectScene(o,t);e=0;for(g=a.length;e<g;e++){m=a[e];if(m instanceof THREE.RenderableParticle){n=m.x*d+d;q=m.y*j+j;l=0;for(h=m.material.length;l<h;l++){s=m.material[l];if(s instanceof THREE.ParticleDOMMaterial){s=s.domElement;s.style.left=n+"px";s.style.top=q+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(G,M,I){var J,k,H;lights=G.lights;G=0;for(J=lights.length;G<J;G++){k=lights[G];H=k.color;if(k instanceof THREE.DirectionalLight){k=M.normalWorld.dot(k.position)*k.intensity;if(k>0){I.r+=H.r*k;I.g+=H.g*k;I.b+=H.b*k}}else if(k instanceof THREE.PointLight){Ha.sub(k.position,M.centroidWorld);Ha.normalize();k=M.normalWorld.dot(Ha)*k.intensity;if(k>0){I.r+=H.r*k;I.g+=H.g*k;I.b+=H.b*k}}}}function b(G,M,I,J,k,H){R=G.positionScreen.x;V=G.positionScreen.y;S=M.positionScreen.x;
B=M.positionScreen.y;W=I.positionScreen.x;N=I.positionScreen.y;if(k.opacity!=z)i.globalAlpha=z=k.opacity;k.blending!=r&&o(k.blending);if(k.map){fa=k.map.image;oa=fa.width-1;pa=fa.height-1;da.u=J.uvs[0].u*oa;da.v=J.uvs[0].v*pa;$.u=J.uvs[1].u*oa;$.v=J.uvs[1].v*pa;ea.u=J.uvs[2].u*oa;ea.v=J.uvs[2].v*pa;j(fa,R,V,S,B,W,N,da.u,da.v,$.u,$.v,ea.u,ea.v)}else if(k instanceof THREE.MeshBasicMaterial)c(R,V,S,B,W,N,k.color,k.wireframe,k.wireframe_linewidth);else if(k instanceof THREE.MeshLambertMaterial){if(Da){ba.r=
ga.r;ba.g=ga.g;ba.b=ga.b;a(H,J,ba);P.r=k.color.r*ba.r;P.g=k.color.g*ba.g;P.b=k.color.b*ba.b;P.updateStyleString()}else P.__styleString=k.color.__styleString;c(R,V,S,B,W,N,P,k.wireframe,k.wireframe_linewidth)}else if(k instanceof THREE.MeshDepthMaterial){qa=k.__2near;ra=k.__farPlusNear;sa=k.__farMinusNear;U=~~((1-qa/(ra-G.positionScreen.z*sa))*255);ha=~~((1-qa/(ra-M.positionScreen.z*sa))*255);ma=~~((1-qa/(ra-I.positionScreen.z*sa))*255);fa=t([U,U,U],[ha,ha,ha],[ma,ma,ma],[ma,ma,ma]);da.u=0;da.v=0;
$.u=ka;$.v=0;ea.u=0;ea.v=ka;j(fa,R,V,S,B,W,N,da.u,da.v,$.u,$.v,ea.u,ea.v)}else if(k instanceof THREE.MeshNormalMaterial){P.r=e(J.normalWorld.x);P.g=e(J.normalWorld.y);P.b=e(J.normalWorld.z);P.updateStyleString();c(R,V,S,B,W,N,P,k.wireframe,k.wireframe_linewidth)}}function f(G,M,I,J,k,H,Q,y,T){R=G.positionScreen.x;V=G.positionScreen.y;S=M.positionScreen.x;B=M.positionScreen.y;W=I.positionScreen.x;N=I.positionScreen.y;Z=J.positionScreen.x;E=J.positionScreen.y;A=k.positionScreen.x;Y=k.positionScreen.y;
na=H.positionScreen.x;O=H.positionScreen.y;if(y.opacity!=z)i.globalAlpha=z=y.opacity;y.blending!=r&&o(y.blending);if(y.map){fa=y.map.image;oa=fa.width-1;pa=fa.height-1;da.copy(Q.uvs[0]);$.copy(Q.uvs[1]);ea.copy(Q.uvs[2]);ia.copy(Q.uvs[3]);da.u*=oa;da.v*=pa;$.u*=oa;$.v*=pa;ea.u*=oa;ea.v*=pa;ia.u*=oa;ia.v*=pa;j(fa,R,V,S,B,Z,E,da.u,da.v,$.u,$.v,ia.u,ia.v);j(fa,A,Y,W,N,na,O,$.u,$.v,ea.u,ea.v,ia.u,ia.v)}else if(y instanceof THREE.MeshBasicMaterial)d(R,V,S,B,W,N,Z,E,y.color,y.wireframe,y.wireframe_linewidth);
else if(y instanceof THREE.MeshLambertMaterial){if(Da){ba.r=ga.r;ba.g=ga.g;ba.b=ga.b;a(T,Q,ba);P.r=y.color.r*ba.r;P.g=y.color.g*ba.g;P.b=y.color.b*ba.b;P.updateStyleString()}else P.__styleString=y.color.__styleString;d(R,V,S,B,W,N,Z,E,P,y.wireframe,y.wireframe_linewidth)}else if(y instanceof THREE.MeshDepthMaterial){qa=y.__2near;ra=y.__farPlusNear;sa=y.__farMinusNear;U=~~((1-qa/(ra-G.positionScreen.z*sa))*255);ha=~~((1-qa/(ra-M.positionScreen.z*sa))*255);ma=~~((1-qa/(ra-I.positionScreen.z*sa))*255);
Ea=~~((1-qa/(ra-J.positionScreen.z*sa))*255);fa=t([U,U,U],[ha,ha,ha],[Ea,Ea,Ea],[ma,ma,ma]);da.u=0;da.v=0;$.u=ka;$.v=0;ea.u=ka;ea.v=ka;ia.u=0;ia.v=ka;j(fa,R,V,S,B,Z,E,da.u,da.v,$.u,$.v,ia.u,ia.v);j(fa,A,Y,W,N,na,O,$.u,$.v,ea.u,ea.v,ia.u,ia.v)}else if(y instanceof THREE.MeshNormalMaterial){P.r=e(Q.normalWorld.x);P.g=e(Q.normalWorld.y);P.b=e(Q.normalWorld.z);P.updateStyleString();d(R,V,S,B,W,N,Z,E,P,y.wireframe,y.wireframe_linewidth)}}function c(G,M,I,J,k,H,Q,y,T){i.beginPath();i.moveTo(G,M);i.lineTo(I,
J);i.lineTo(k,H);i.lineTo(G,M);i.closePath();if(y){if(K!=T)i.lineWidth=K=T;if(C!=Q.__styleString)i.strokeStyle=C=Q.__styleString;i.stroke();aa.inflate(T*2)}else{if(u!=Q.__styleString)i.fillStyle=u=Q.__styleString;i.fill()}}function d(G,M,I,J,k,H,Q,y,T,D,ca){i.beginPath();i.moveTo(G,M);i.lineTo(I,J);i.lineTo(k,H);i.lineTo(Q,y);i.lineTo(G,M);i.closePath();if(D){if(K!=ca)i.lineWidth=K=ca;if(C!=T.__styleString)i.strokeStyle=C=T.__styleString;i.stroke();aa.inflate(ca*2)}else{if(u!=T.__styleString)i.fillStyle=
u=T.__styleString;i.fill()}}function j(G,M,I,J,k,H,Q,y,T,D,ca,la,ta){i.beginPath();i.moveTo(M,I);i.lineTo(J,k);i.lineTo(H,Q);i.closePath();J-=M;k-=I;H-=M;Q-=I;D-=y;ca-=T;la-=y;ta-=T;var ua=1/(D*ta-la*ca),za=(ta*J-ca*H)*ua;ca=(ta*k-ca*Q)*ua;J=(D*H-la*J)*ua;k=(D*Q-la*k)*ua;M=M-za*y-J*T;I=I-ca*y-k*T;i.save();i.transform(za,ca,J,k,M,I);i.clip();i.drawImage(G,0,0);i.restore()}function o(G){switch(G){case THREE.NormalBlending:i.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:i.globalCompositeOperation=
"lighter";break;case THREE.SubtractiveBlending:i.globalCompositeOperation="darker"}r=G}function t(G,M,I,J){ja[0]=G[0];ja[1]=G[1];ja[2]=G[2];ja[4]=M[0];ja[5]=M[1];ja[6]=M[2];ja[8]=I[0];ja[9]=I[1];ja[10]=I[2];ja[12]=J[0];ja[13]=J[1];ja[14]=J[2];Aa.putImageData(Ia,0,0);Fa.drawImage(Ba,0,0);return Ca}function e(G){return G<0?Math.min((1+G)*0.5,0.5):0.5+Math.min(G*0.5,0.5)}function g(G,M){var I=M.x-G.x,J=M.y-G.y,k=1/Math.sqrt(I*I+J*J);I*=k;J*=k;M.x+=I;M.y+=J;G.x-=I;G.y-=J}var l=null,h=new THREE.Projector,
m=document.createElement("canvas"),s,n,q,w,i=m.getContext("2d"),z=1,r=0,C=null,u=null,K=1,v,p,x,L,X=new THREE.Vertex,F=new THREE.Vertex,R,V,S,B,W,N,Z,E,A,Y,na,O,U,ha,ma,Ea,qa,ra,sa,fa,oa,pa,wa=new THREE.Rectangle,va=new THREE.Rectangle,aa=new THREE.Rectangle,Da=false,P=new THREE.Color(4294967295),ba=new THREE.Color(4294967295),ga=new THREE.Color(4278190080),xa=new THREE.Color(4278190080),ya=new THREE.Color(4278190080),Ma=Math.PI*2,Ha=new THREE.Vector3,da=new THREE.UV,$=new THREE.UV,ea=new THREE.UV,
ia=new THREE.UV,Ba,Aa,Ia,ja,Ca,Fa,ka=16;Ba=document.createElement("canvas");Ba.width=Ba.height=2;Aa=Ba.getContext("2d");Aa.fillStyle="rgba(0,0,0,1)";Aa.fillRect(0,0,2,2);Ia=Aa.getImageData(0,0,2,2);ja=Ia.data;Ca=document.createElement("canvas");Ca.width=Ca.height=ka;Fa=Ca.getContext("2d");Fa.translate(-ka/2,-ka/2);Fa.scale(ka,ka);ka--;this.domElement=m;this.autoClear=true;this.setSize=function(G,M){s=G;n=M;q=s/2;w=n/2;m.width=s;m.height=n;i.lineJoin="round";i.lineCap="round";wa.set(-q,-w,q,w)};this.clear=
function(){if(!va.isEmpty()){va.inflate(1);va.minSelf(wa);i.setTransform(1,0,0,-1,q,w);i.clearRect(va.getX(),va.getY(),va.getWidth(),va.getHeight());va.empty()}};this.render=function(G,M){var I,J,k,H,Q,y,T,D;this.autoClear&&this.clear();l=h.projectScene(G,M);i.setTransform(1,0,0,-1,q,w);if(Da=G.lights.length>0){Q=G.lights;ga.setRGB(0,0,0);xa.setRGB(0,0,0);ya.setRGB(0,0,0);I=0;for(J=Q.length;I<J;I++){k=Q[I];H=k.color;if(k instanceof THREE.AmbientLight){ga.r+=H.r;ga.g+=H.g;ga.b+=H.b}else if(k instanceof
THREE.DirectionalLight){xa.r+=H.r;xa.g+=H.g;xa.b+=H.b}else if(k instanceof THREE.PointLight){ya.r+=H.r;ya.g+=H.g;ya.b+=H.b}}}I=0;for(J=l.length;I<J;I++){k=l[I];aa.empty();if(k instanceof THREE.RenderableParticle){v=k;v.x*=q;v.y*=w;H=0;for(Q=k.material.length;H<Q;H++)if(D=k.material[H]){y=v;T=k;D=D;var ca=void 0,la=void 0,ta=void 0,ua=void 0,za=void 0,Ja=void 0,Ga=void 0,Ka=void 0,La=void 0;if(D.opacity!=z)i.globalAlpha=z=D.opacity;D.blending!=r&&o(D.blending);if(D instanceof THREE.ParticleBasicMaterial){Ga=
D.bitmap;Ka=Ga.width/2;La=Ga.height/2;ta=T.scale.x*q;ua=T.scale.y*w;ca=ta*Ka;la=ua*La;za=D.offset.x*ta;Ja=D.offset.y*ua;aa.set(y.x+za-ca,y.y+Ja-la,y.x+za+ca,y.y+Ja+la);if(wa.instersects(aa)){i.save();i.translate(y.x,y.y);i.rotate(-T.rotation);i.scale(ta,-ua);i.translate(-Ka+D.offset.x,-La-D.offset.y);i.drawImage(Ga,0,0);i.restore()}}else if(D instanceof THREE.ParticleCircleMaterial){if(Da){ba.r=ga.r+xa.r+ya.r;ba.g=ga.g+xa.g+ya.g;ba.b=ga.b+xa.b+ya.b;P.r=D.color.r*ba.r;P.g=D.color.g*ba.g;P.b=D.color.b*
ba.b;P.updateStyleString()}else P.__styleString=D.color.__styleString;ca=T.scale.x*q;la=T.scale.y*w;aa.set(y.x-ca,y.y-la,y.x+ca,y.y+la);if(wa.instersects(aa)){if(u!==P.__styleString)i.fillStyle=u=P.__styleString;i.save();i.translate(y.x,y.y);i.rotate(-T.rotation);i.scale(ca,la);i.beginPath();i.arc(0,0,1,0,Ma,true);i.closePath();i.fill();i.restore()}}}}else if(k instanceof THREE.RenderableLine){v=k.v1;p=k.v2;v.positionScreen.x*=q;v.positionScreen.y*=w;p.positionScreen.x*=q;p.positionScreen.y*=w;aa.addPoint(v.positionScreen.x,
v.positionScreen.y);aa.addPoint(p.positionScreen.x,p.positionScreen.y);if(!wa.instersects(aa))continue;H=0;for(Q=k.material.length;H<Q;)if(D=k.material[H++]){y=v;T=p;D=D;if(D.opacity!=z)i.globalAlpha=z=D.opacity;D.blending!=r&&o(D.blending);i.beginPath();i.moveTo(y.positionScreen.x,y.positionScreen.y);i.lineTo(T.positionScreen.x,T.positionScreen.y);i.closePath();if(D instanceof THREE.LineBasicMaterial){P.__styleString=D.color.__styleString;if(K!=D.linewidth)i.lineWidth=K=D.linewidth;if(C!=P.__styleString)i.strokeStyle=
C=P.__styleString;i.stroke();aa.inflate(D.linewidth*2)}}}else if(k instanceof THREE.RenderableFace3){v=k.v1;p=k.v2;x=k.v3;v.positionScreen.x*=q;v.positionScreen.y*=w;p.positionScreen.x*=q;p.positionScreen.y*=w;x.positionScreen.x*=q;x.positionScreen.y*=w;if(k.overdraw){g(v.positionScreen,p.positionScreen);g(p.positionScreen,x.positionScreen);g(x.positionScreen,v.positionScreen)}aa.addPoint(v.positionScreen.x,v.positionScreen.y);aa.addPoint(p.positionScreen.x,p.positionScreen.y);aa.addPoint(x.positionScreen.x,
x.positionScreen.y);if(!wa.instersects(aa))continue;H=0;for(Q=k.meshMaterial.length;H<Q;){D=k.meshMaterial[H++];if(D instanceof THREE.MeshFaceMaterial){y=0;for(T=k.faceMaterial.length;y<T;)(D=k.faceMaterial[y++])&&b(v,p,x,k,D,G)}else D&&b(v,p,x,k,D,G)}}else if(k instanceof THREE.RenderableFace4){v=k.v1;p=k.v2;x=k.v3;L=k.v4;v.positionScreen.x*=q;v.positionScreen.y*=w;p.positionScreen.x*=q;p.positionScreen.y*=w;x.positionScreen.x*=q;x.positionScreen.y*=w;L.positionScreen.x*=q;L.positionScreen.y*=w;
X.positionScreen.copy(p.positionScreen);F.positionScreen.copy(L.positionScreen);if(k.overdraw){g(v.positionScreen,p.positionScreen);g(p.positionScreen,L.positionScreen);g(L.positionScreen,v.positionScreen)}if(k.overdraw){g(x.positionScreen,X.positionScreen);g(x.positionScreen,F.positionScreen)}aa.addPoint(v.positionScreen.x,v.positionScreen.y);aa.addPoint(p.positionScreen.x,p.positionScreen.y);aa.addPoint(x.positionScreen.x,x.positionScreen.y);aa.addPoint(L.positionScreen.x,L.positionScreen.y);if(!wa.instersects(aa))continue;
H=0;for(Q=k.meshMaterial.length;H<Q;){D=k.meshMaterial[H++];if(D instanceof THREE.MeshFaceMaterial){y=0;for(T=k.faceMaterial.length;y<T;)(D=k.faceMaterial[y++])&&f(v,p,x,L,X,F,k,D,G)}else D&&f(v,p,x,L,X,F,k,D,G)}}va.addRectangle(aa)}i.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(B,W,N){var Z,E,A,Y;Z=0;for(E=B.lights.length;Z<E;Z++){A=B.lights[Z];if(A instanceof THREE.DirectionalLight){Y=W.normalWorld.dot(A.position)*A.intensity;if(Y>0){N.r+=A.color.r*Y;N.g+=A.color.g*Y;N.b+=A.color.b*Y}}else if(A instanceof THREE.PointLight){x.sub(A.position,W.centroidWorld);x.normalize();Y=W.normalWorld.dot(x)*A.intensity;if(Y>0){N.r+=A.color.r*Y;N.g+=A.color.g*Y;N.b+=A.color.b*Y}}}}function b(B,W,N,Z,E,A){F=c(R++);F.setAttribute("d","M "+B.positionScreen.x+
" "+B.positionScreen.y+" L "+W.positionScreen.x+" "+W.positionScreen.y+" L "+N.positionScreen.x+","+N.positionScreen.y+"z");if(E instanceof THREE.MeshBasicMaterial)r.__styleString=E.color.__styleString;else if(E instanceof THREE.MeshLambertMaterial)if(z){C.r=u.r;C.g=u.g;C.b=u.b;a(A,Z,C);r.r=E.color.r*C.r;r.g=E.color.g*C.g;r.b=E.color.b*C.b;r.updateStyleString()}else r.__styleString=E.color.__styleString;else if(E instanceof THREE.MeshDepthMaterial){p=1-E.__2near/(E.__farPlusNear-Z.z*E.__farMinusNear);
r.setRGB(p,p,p)}else E instanceof THREE.MeshNormalMaterial&&r.setRGB(d(Z.normalWorld.x),d(Z.normalWorld.y),d(Z.normalWorld.z));E.wireframe?F.setAttribute("style","fill: none; stroke: "+r.__styleString+"; stroke-width: "+E.wireframe_linewidth+"; stroke-opacity: "+E.opacity+"; stroke-linecap: round; stroke-linejoin: round"):F.setAttribute("style","fill: "+r.__styleString+"; fill-opacity: "+E.opacity);t.appendChild(F)}function f(B,W,N,Z,E,A,Y){F=c(R++);F.setAttribute("d","M "+B.positionScreen.x+" "+
B.positionScreen.y+" L "+W.positionScreen.x+" "+W.positionScreen.y+" L "+N.positionScreen.x+","+N.positionScreen.y+" L "+Z.positionScreen.x+","+Z.positionScreen.y+"z");if(A instanceof THREE.MeshBasicMaterial)r.__styleString=A.color.__styleString;else if(A instanceof THREE.MeshLambertMaterial)if(z){C.r=u.r;C.g=u.g;C.b=u.b;a(Y,E,C);r.r=A.color.r*C.r;r.g=A.color.g*C.g;r.b=A.color.b*C.b;r.updateStyleString()}else r.__styleString=A.color.__styleString;else if(A instanceof THREE.MeshDepthMaterial){p=1-
A.__2near/(A.__farPlusNear-E.z*A.__farMinusNear);r.setRGB(p,p,p)}else A instanceof THREE.MeshNormalMaterial&&r.setRGB(d(E.normalWorld.x),d(E.normalWorld.y),d(E.normalWorld.z));A.wireframe?F.setAttribute("style","fill: none; stroke: "+r.__styleString+"; stroke-width: "+A.wireframe_linewidth+"; stroke-opacity: "+A.opacity+"; stroke-linecap: round; stroke-linejoin: round"):F.setAttribute("style","fill: "+r.__styleString+"; fill-opacity: "+A.opacity);t.appendChild(F)}function c(B){if(L[B]==null){L[B]=
document.createElementNS("http://www.w3.org/2000/svg","path");S==0&&L[B].setAttribute("shape-rendering","crispEdges");return L[B]}return L[B]}function d(B){return B<0?Math.min((1+B)*0.5,0.5):0.5+Math.min(B*0.5,0.5)}var j=null,o=new THREE.Projector,t=document.createElementNS("http://www.w3.org/2000/svg","svg"),e,g,l,h,m,s,n,q,w=new THREE.Rectangle,i=new THREE.Rectangle,z=false,r=new THREE.Color(4294967295),C=new THREE.Color(4294967295),u=new THREE.Color(4278190080),K=new THREE.Color(4278190080),v=
new THREE.Color(4278190080),p,x=new THREE.Vector3,L=[],X=[],F,R,V,S=1;this.domElement=t;this.autoClear=true;this.setQuality=function(B){switch(B){case "high":S=1;break;case "low":S=0}};this.setSize=function(B,W){e=B;g=W;l=e/2;h=g/2;t.setAttribute("viewBox",-l+" "+-h+" "+e+" "+g);t.setAttribute("width",e);t.setAttribute("height",g);w.set(-l,-h,l,h)};this.clear=function(){for(;t.childNodes.length>0;)t.removeChild(t.childNodes[0])};this.render=function(B,W){var N,Z,E,A,Y,na,O,U;this.autoClear&&this.clear();
j=o.projectScene(B,W);V=R=0;if(z=B.lights.length>0){O=B.lights;u.setRGB(0,0,0);K.setRGB(0,0,0);v.setRGB(0,0,0);N=0;for(Z=O.length;N<Z;N++){E=O[N];A=E.color;if(E instanceof THREE.AmbientLight){u.r+=A.r;u.g+=A.g;u.b+=A.b}else if(E instanceof THREE.DirectionalLight){K.r+=A.r;K.g+=A.g;K.b+=A.b}else if(E instanceof THREE.PointLight){v.r+=A.r;v.g+=A.g;v.b+=A.b}}}N=0;for(Z=j.length;N<Z;N++){O=j[N];i.empty();if(O instanceof THREE.RenderableParticle){m=O;m.x*=l;m.y*=-h;E=0;for(A=O.material.length;E<A;E++)if(U=
O.material[E]){Y=m;na=O;U=U;var ha=V++;if(X[ha]==null){X[ha]=document.createElementNS("http://www.w3.org/2000/svg","circle");S==0&&X[ha].setAttribute("shape-rendering","crispEdges")}F=X[ha];F.setAttribute("cx",Y.x);F.setAttribute("cy",Y.y);F.setAttribute("r",na.scale.x*l);if(U instanceof THREE.ParticleCircleMaterial){if(z){C.r=u.r+K.r+v.r;C.g=u.g+K.g+v.g;C.b=u.b+K.b+v.b;r.r=U.color.r*C.r;r.g=U.color.g*C.g;r.b=U.color.b*C.b;r.updateStyleString()}else r=U.color;F.setAttribute("style","fill: "+r.__styleString)}t.appendChild(F)}}else if(O instanceof
THREE.RenderableFace3){m=O.v1;s=O.v2;n=O.v3;m.positionScreen.x*=l;m.positionScreen.y*=-h;s.positionScreen.x*=l;s.positionScreen.y*=-h;n.positionScreen.x*=l;n.positionScreen.y*=-h;i.addPoint(m.positionScreen.x,m.positionScreen.y);i.addPoint(s.positionScreen.x,s.positionScreen.y);i.addPoint(n.positionScreen.x,n.positionScreen.y);if(w.instersects(i)){E=0;for(A=O.meshMaterial.length;E<A;){U=O.meshMaterial[E++];if(U instanceof THREE.MeshFaceMaterial){Y=0;for(na=O.faceMaterial.length;Y<na;)(U=O.faceMaterial[Y++])&&
b(m,s,n,O,U,B)}else U&&b(m,s,n,O,U,B)}}}else if(O instanceof THREE.RenderableFace4){m=O.v1;s=O.v2;n=O.v3;q=O.v4;m.positionScreen.x*=l;m.positionScreen.y*=-h;s.positionScreen.x*=l;s.positionScreen.y*=-h;n.positionScreen.x*=l;n.positionScreen.y*=-h;q.positionScreen.x*=l;q.positionScreen.y*=-h;i.addPoint(m.positionScreen.x,m.positionScreen.y);i.addPoint(s.positionScreen.x,s.positionScreen.y);i.addPoint(n.positionScreen.x,n.positionScreen.y);i.addPoint(q.positionScreen.x,q.positionScreen.y);if(w.instersects(i)){E=
0;for(A=O.meshMaterial.length;E<A;){U=O.meshMaterial[E++];if(U instanceof THREE.MeshFaceMaterial){Y=0;for(na=O.faceMaterial.length;Y<na;)(U=O.faceMaterial[Y++])&&f(m,s,n,q,O,U,B)}else U&&f(m,s,n,q,O,U,B)}}}}}};
THREE.WebGLRenderer=function(a){function b(e,g){var l;if(e=="fragment")l=c.createShader(c.FRAGMENT_SHADER);else if(e=="vertex")l=c.createShader(c.VERTEX_SHADER);c.shaderSource(l,g);c.compileShader(l);if(!c.getShaderParameter(l,c.COMPILE_STATUS)){alert(c.getShaderInfoLog(l));return null}return l}var f=document.createElement("canvas"),c,d,j=new THREE.Matrix4,o;a=function(e,g){if(e){var l,h,m,s=pointLights=maxDirLights=maxPointLights=0;l=0;for(h=e.lights.length;l<h;l++){m=e.lights[l];m instanceof THREE.DirectionalLight&&
s++;m instanceof THREE.PointLight&&pointLights++}if(pointLights+s<=g){maxDirLights=s;maxPointLights=pointLights}else{maxDirLights=Math.ceil(g*s/(pointLights+s));maxPointLights=g-maxDirLights}return{directional:maxDirLights,point:maxPointLights}}return{directional:1,point:g-1}}(a,5);this.domElement=f;this.autoClear=true;try{c=f.getContext("experimental-webgl",{antialias:true})}catch(t){}if(!c){alert("WebGL not supported");throw"cannot create webgl context";}c.clearColor(0,0,0,1);c.clearDepth(1);c.enable(c.DEPTH_TEST);
c.depthFunc(c.LEQUAL);c.frontFace(c.CCW);c.cullFace(c.BACK);c.enable(c.CULL_FACE);c.enable(c.BLEND);c.blendFunc(c.ONE,c.ONE_MINUS_SRC_ALPHA);c.clearColor(0,0,0,0);(function(e,g){d=c.createProgram();c.attachShader(d,b("fragment",["#ifdef GL_ES\nprecision highp float;\n#endif",e?"#define MAX_DIR_LIGHTS "+e:"",g?"#define MAX_POINT_LIGHTS "+g:"","uniform int material;\nuniform bool enableMap;\nuniform sampler2D tMap;\nuniform vec4 mColor;\nuniform float mOpacity;\nuniform vec4 mAmbient;\nuniform vec4 mSpecular;\nuniform float mShininess;\nuniform float m2Near;\nuniform float mFarPlusNear;\nuniform float mFarMinusNear;\nuniform int pointLightNumber;\nuniform int directionalLightNumber;",
e?"uniform mat4 viewMatrix;":"",e?"uniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];":"","varying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vLightWeighting;",g?"varying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];":"","varying vec3 vViewPosition;\nvoid main() {\nvec4 mapColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nif ( enableMap ) {\nmapColor = texture2D( tMap, vUv );\n}\nif ( material == 4 ) { \ngl_FragColor = vec4( 0.5*normalize( vNormal ) + vec3(0.5, 0.5, 0.5), mOpacity );\n} else if ( material == 3 ) { \nfloat w = 0.5;\ngl_FragColor = vec4( w, w, w, mOpacity );\n} else if ( material == 2 ) { \nvec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );",
g?"vec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );":"",g?"vec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );":"",g?"for( int i = 0; i < pointLightNumber; i++ ) {":"",g?"vec3 pointVector = normalize( vPointLightVector[ i ] );":"",g?"vec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );":"",g?"float pointDotNormalHalf = dot( normal, pointHalfVector );":"",g?"float pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );":"",g?"float pointSpecularWeight = 0.0;":"",g?"if ( pointDotNormalHalf >= 0.0 )":
"",g?"pointSpecularWeight = pow( pointDotNormalHalf, mShininess );":"",g?"pointDiffuse  += mColor * pointDiffuseWeight;":"",g?"pointSpecular += mSpecular * pointSpecularWeight;":"",g?"}":"",e?"vec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );":"",e?"vec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );":"",e?"for( int i = 0; i < directionalLightNumber; i++ ) {":"",e?"vec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );":"",e?"vec3 dirVector = normalize( lDirection.xyz );":"",e?"vec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );":
"",e?"float dirDotNormalHalf = dot( normal, dirHalfVector );":"",e?"float dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );":"",e?"float dirSpecularWeight = 0.0;":"",e?"if ( dirDotNormalHalf >= 0.0 )":"",e?"dirSpecularWeight = pow( dirDotNormalHalf, mShininess );":"",e?"dirDiffuse  += mColor * dirDiffuseWeight;":"",e?"dirSpecular += mSpecular * dirSpecularWeight;":"",e?"}":"","vec4 totalLight = mAmbient;",e?"totalLight += dirDiffuse + dirSpecular;":"",g?"totalLight += pointDiffuse + pointSpecular;":
"","gl_FragColor = vec4( mapColor.rgb * totalLight.xyz * vLightWeighting, mapColor.a );\n} else if ( material == 1 ) {\ngl_FragColor = vec4( mColor.rgb * mapColor.rgb * vLightWeighting, mColor.a * mapColor.a );\n} else {\ngl_FragColor = mColor * mapColor;\n}\n}"].join("\n")));c.attachShader(d,b("vertex",[e?"#define MAX_DIR_LIGHTS "+e:"",g?"#define MAX_POINT_LIGHTS "+g:"","attribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nuniform vec3 cameraPosition;\nuniform bool enableLighting;\nuniform int pointLightNumber;\nuniform int directionalLightNumber;\nuniform vec3 ambientLightColor;",
e?"uniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];":"",e?"uniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];":"",g?"uniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];":"",g?"uniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];":"","uniform mat4 objMatrix;\nuniform mat4 viewMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat3 normalMatrix;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vLightWeighting;",g?"varying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];":
"","varying vec3 vViewPosition;\nvarying vec3 vFragPosition;\nvoid main(void) {\nvec4 mPosition = objMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec3 transformedNormal = normalize( normalMatrix * normal );\nif ( !enableLighting ) {\nvLightWeighting = vec3( 1.0, 1.0, 1.0 );\n} else {\nvLightWeighting = ambientLightColor;",e?"for( int i = 0; i < directionalLightNumber; i++ ) {":"",e?"vec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );":
"",e?"float directionalLightWeighting = max( dot( transformedNormal, normalize(lDirection.xyz ) ), 0.0 );":"",e?"vLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;":"",e?"}":"",g?"for( int i = 0; i < pointLightNumber; i++ ) {":"",g?"vec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );":"",g?"vPointLightVector[ i ] = normalize( lPosition.xyz - mvPosition.xyz );":"",g?"float pointLightWeighting = max( dot( transformedNormal, vPointLightVector[ i ] ), 0.0 );":"",
g?"vLightWeighting += pointLightColor[ i ] * pointLightWeighting;":"",g?"}":"","}\nvNormal = transformedNormal;\nvUv = uv;\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")));c.linkProgram(d);c.getProgramParameter(d,c.LINK_STATUS)||alert("Could not initialise shaders");c.useProgram(d);d.viewMatrix=c.getUniformLocation(d,"viewMatrix");d.modelViewMatrix=c.getUniformLocation(d,"modelViewMatrix");d.projectionMatrix=c.getUniformLocation(d,"projectionMatrix");d.normalMatrix=c.getUniformLocation(d,
"normalMatrix");d.objMatrix=c.getUniformLocation(d,"objMatrix");d.cameraPosition=c.getUniformLocation(d,"cameraPosition");d.enableLighting=c.getUniformLocation(d,"enableLighting");d.ambientLightColor=c.getUniformLocation(d,"ambientLightColor");if(e){d.directionalLightNumber=c.getUniformLocation(d,"directionalLightNumber");d.directionalLightColor=c.getUniformLocation(d,"directionalLightColor");d.directionalLightDirection=c.getUniformLocation(d,"directionalLightDirection")}if(g){d.pointLightNumber=
c.getUniformLocation(d,"pointLightNumber");d.pointLightColor=c.getUniformLocation(d,"pointLightColor");d.pointLightPosition=c.getUniformLocation(d,"pointLightPosition")}d.material=c.getUniformLocation(d,"material");d.mColor=c.getUniformLocation(d,"mColor");d.mOpacity=c.getUniformLocation(d,"mOpacity");d.mAmbient=c.getUniformLocation(d,"mAmbient");d.mSpecular=c.getUniformLocation(d,"mSpecular");d.mShininess=c.getUniformLocation(d,"mShininess");d.enableMap=c.getUniformLocation(d,"enableMap");c.uniform1i(d.enableMap,
0);d.tMap=c.getUniformLocation(d,"tMap");c.uniform1i(d.tMap,0);d.m2Near=c.getUniformLocation(d,"m2Near");d.mFarPlusNear=c.getUniformLocation(d,"mFarPlusNear");d.mFarMinusNear=c.getUniformLocation(d,"mFarMinusNear");d.position=c.getAttribLocation(d,"position");c.enableVertexAttribArray(d.position);d.normal=c.getAttribLocation(d,"normal");c.enableVertexAttribArray(d.normal);d.uv=c.getAttribLocation(d,"uv");c.enableVertexAttribArray(d.uv);d.viewMatrixArray=new Float32Array(16);d.modelViewMatrixArray=
new Float32Array(16);d.projectionMatrixArray=new Float32Array(16)})(a.directional,a.point);this.setSize=function(e,g){f.width=e;f.height=g;c.viewport(0,0,f.width,f.height)};this.clear=function(){c.clear(c.COLOR_BUFFER_BIT|c.DEPTH_BUFFER_BIT)};this.setupLights=function(e){var g,l,h,m,s=[],n=[],q=[];m=[];var w=[];c.uniform1i(d.enableLighting,e.lights.length);g=0;for(l=e.lights.length;g<l;g++){h=e.lights[g];if(h instanceof THREE.AmbientLight)s.push(h);else if(h instanceof THREE.DirectionalLight)q.push(h);
else h instanceof THREE.PointLight&&n.push(h)}g=e=h=m=0;for(l=s.length;g<l;g++){e+=s[g].color.r;h+=s[g].color.g;m+=s[g].color.b}c.uniform3f(d.ambientLightColor,e,h,m);m=[];w=[];g=0;for(l=q.length;g<l;g++){h=q[g];m.push(h.color.r*h.intensity);m.push(h.color.g*h.intensity);m.push(h.color.b*h.intensity);w.push(h.position.x);w.push(h.position.y);w.push(h.position.z)}if(q.length){c.uniform1i(d.directionalLightNumber,q.length);c.uniform3fv(d.directionalLightDirection,w);c.uniform3fv(d.directionalLightColor,
m)}m=[];w=[];g=0;for(l=n.length;g<l;g++){h=n[g];m.push(h.color.r*h.intensity);m.push(h.color.g*h.intensity);m.push(h.color.b*h.intensity);w.push(h.position.x);w.push(h.position.y);w.push(h.position.z)}if(n.length){c.uniform1i(d.pointLightNumber,n.length);c.uniform3fv(d.pointLightPosition,w);c.uniform3fv(d.pointLightColor,m)}};this.createBuffers=function(e,g){var l,h,m,s,n,q,w,i,z,r=e.materialFaceGroup[g],C=[],u=[],K=[],v=[],p=[],x=0,L=false;l=0;for(h=e.material.length;l<h;l++){meshMaterial=e.material[l];
if(meshMaterial instanceof THREE.MeshFaceMaterial){n=0;for(q=r.material.length;n<q;n++)if(r.material[n].shading!=undefined&&r.material[n].shading==THREE.SmoothShading){L=true;break}}else if(meshMaterial.shading!=undefined&&meshMaterial.shading==THREE.SmoothShading){L=true;break}if(L)break}l=0;for(h=r.faces.length;l<h;l++){m=r.faces[l];s=e.geometry.faces[m];n=s.vertexNormals;q=s.normal;m=e.geometry.uvs[m];if(s instanceof THREE.Face3){w=e.geometry.vertices[s.a].position;i=e.geometry.vertices[s.b].position;
z=e.geometry.vertices[s.c].position;K.push(w.x,w.y,w.z);K.push(i.x,i.y,i.z);K.push(z.x,z.y,z.z);if(n.length==3&&L){v.push(n[0].x,n[0].y,n[0].z);v.push(n[1].x,n[1].y,n[1].z);v.push(n[2].x,n[2].y,n[2].z)}else{v.push(q.x,q.y,q.z);v.push(q.x,q.y,q.z);v.push(q.x,q.y,q.z)}if(m){p.push(m[0].u,m[0].v);p.push(m[1].u,m[1].v);p.push(m[2].u,m[2].v)}C.push(x,x+1,x+2);u.push(x,x+1);u.push(x,x+2);u.push(x+1,x+2);x+=3}else if(s instanceof THREE.Face4){w=e.geometry.vertices[s.a].position;i=e.geometry.vertices[s.b].position;
z=e.geometry.vertices[s.c].position;s=e.geometry.vertices[s.d].position;K.push(w.x,w.y,w.z);K.push(i.x,i.y,i.z);K.push(z.x,z.y,z.z);K.push(s.x,s.y,s.z);if(n.length==4&&L){v.push(n[0].x,n[0].y,n[0].z);v.push(n[1].x,n[1].y,n[1].z);v.push(n[2].x,n[2].y,n[2].z);v.push(n[3].x,n[3].y,n[3].z)}else{v.push(q.x,q.y,q.z);v.push(q.x,q.y,q.z);v.push(q.x,q.y,q.z);v.push(q.x,q.y,q.z)}if(m){p.push(m[0].u,m[0].v);p.push(m[1].u,m[1].v);p.push(m[2].u,m[2].v);p.push(m[3].u,m[3].v)}C.push(x,x+1,x+2);C.push(x,x+2,x+3);
u.push(x,x+1);u.push(x,x+2);u.push(x,x+3);u.push(x+1,x+2);u.push(x+2,x+3);x+=4}}if(K.length){r.__webGLVertexBuffer=c.createBuffer();c.bindBuffer(c.ARRAY_BUFFER,r.__webGLVertexBuffer);c.bufferData(c.ARRAY_BUFFER,new Float32Array(K),c.STATIC_DRAW);r.__webGLNormalBuffer=c.createBuffer();c.bindBuffer(c.ARRAY_BUFFER,r.__webGLNormalBuffer);c.bufferData(c.ARRAY_BUFFER,new Float32Array(v),c.STATIC_DRAW);r.__webGLUVBuffer=c.createBuffer();c.bindBuffer(c.ARRAY_BUFFER,r.__webGLUVBuffer);c.bufferData(c.ARRAY_BUFFER,
new Float32Array(p),c.STATIC_DRAW);r.__webGLFaceBuffer=c.createBuffer();c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.__webGLFaceBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,new Uint16Array(C),c.STATIC_DRAW);r.__webGLLineBuffer=c.createBuffer();c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.__webGLLineBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,new Uint16Array(u),c.STATIC_DRAW);r.__webGLFaceCount=C.length;r.__webGLLineCount=u.length}};this.renderBuffer=function(e,g){var l,h,m,s,n,q,w;if(e instanceof THREE.MeshPhongMaterial||
e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshBasicMaterial){l=e.color;h=e.opacity;m=e.wireframe;s=e.wireframe_linewidth;w=e.map;c.uniform4f(d.mColor,l.r*h,l.g*h,l.b*h,h)}if(e instanceof THREE.MeshNormalMaterial){h=e.opacity;c.uniform1f(d.mOpacity,h);c.uniform1i(d.material,4)}else if(e instanceof THREE.MeshDepthMaterial){h=e.opacity;m=e.wireframe;s=e.wireframe_linewidth;c.uniform1f(d.mOpacity,h);c.uniform1f(d.m2Near,e.__2near);c.uniform1f(d.mFarPlusNear,e.__farPlusNear);c.uniform1f(d.mFarMinusNear,
e.__farMinusNear);c.uniform1i(d.material,3)}else if(e instanceof THREE.MeshPhongMaterial){l=e.ambient;n=e.specular;q=e.shininess;c.uniform4f(d.mAmbient,l.r,l.g,l.b,h);c.uniform4f(d.mSpecular,n.r,n.g,n.b,h);c.uniform1f(d.mShininess,q);c.uniform1i(d.material,2)}else if(e instanceof THREE.MeshLambertMaterial)c.uniform1i(d.material,1);else e instanceof THREE.MeshBasicMaterial&&c.uniform1i(d.material,0);if(w){if(!e.__webGLTexture&&e.map.loaded){e.__webGLTexture=c.createTexture();c.bindTexture(c.TEXTURE_2D,
e.__webGLTexture);c.texImage2D(c.TEXTURE_2D,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,e.map.image);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR_MIPMAP_LINEAR);c.generateMipmap(c.TEXTURE_2D);c.bindTexture(c.TEXTURE_2D,null)}c.activeTexture(c.TEXTURE0);c.bindTexture(c.TEXTURE_2D,e.__webGLTexture);c.uniform1i(d.tMap,0);c.uniform1i(d.enableMap,1)}else c.uniform1i(d.enableMap,0);c.bindBuffer(c.ARRAY_BUFFER,g.__webGLVertexBuffer);c.vertexAttribPointer(d.position,
3,c.FLOAT,false,0,0);c.bindBuffer(c.ARRAY_BUFFER,g.__webGLNormalBuffer);c.vertexAttribPointer(d.normal,3,c.FLOAT,false,0,0);if(w){c.bindBuffer(c.ARRAY_BUFFER,g.__webGLUVBuffer);c.enableVertexAttribArray(d.uv);c.vertexAttribPointer(d.uv,2,c.FLOAT,false,0,0)}else c.disableVertexAttribArray(d.uv);if(m){c.lineWidth(s);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,g.__webGLLineBuffer);c.drawElements(c.LINES,g.__webGLLineCount,c.UNSIGNED_SHORT,0)}else{c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,g.__webGLFaceBuffer);c.drawElements(c.TRIANGLES,
g.__webGLFaceCount,c.UNSIGNED_SHORT,0)}};this.renderPass=function(e,g,l){var h,m,s,n,q;s=0;for(n=e.material.length;s<n;s++){h=e.material[s];if(h instanceof THREE.MeshFaceMaterial){h=0;for(m=g.material.length;h<m;h++){q=g.material[h];if(q.blending==l){this.setBlending(q.blending);this.renderBuffer(q,g)}}}else{q=h;if(q.blending==l){this.setBlending(q.blending);this.renderBuffer(q,g)}}}};this.render=function(e,g){var l,h;this.initWebGLObjects(e);this.autoClear&&this.clear();g.autoUpdateMatrix&&g.updateMatrix();
c.uniform3f(d.cameraPosition,g.position.x,g.position.y,g.position.z);this.setupLights(e);l=0;for(h=e.__webGLObjects.length;l<h;l++){webGLObject=e.__webGLObjects[l];this.setupMatrices(webGLObject.__object,g);this.renderPass(webGLObject.__object,webGLObject,THREE.NormalBlending)}l=0;for(h=e.__webGLObjects.length;l<h;l++){webGLObject=e.__webGLObjects[l];this.setupMatrices(webGLObject.__object,g);this.renderPass(webGLObject.__object,webGLObject,THREE.AdditiveBlending);this.renderPass(webGLObject.__object,
webGLObject,THREE.SubtractiveBlending)}};this.initWebGLObjects=function(e){var g,l,h,m,s;if(!e.__webGLObjects)e.__webGLObjects=[];g=0;for(l=e.objects.length;g<l;g++){h=e.objects[g];if(h instanceof THREE.Mesh)for(m in h.materialFaceGroup){s=h.materialFaceGroup[m];if(!s.__webGLVertexBuffer){this.createBuffers(h,m);s.__object=h;e.__webGLObjects.push(s)}}}};this.setupMatrices=function(e,g){e.autoUpdateMatrix&&e.updateMatrix();j.multiply(g.matrix,e.matrix);d.viewMatrixArray=new Float32Array(g.matrix.flatten());
d.modelViewMatrixArray=new Float32Array(j.flatten());d.projectionMatrixArray=new Float32Array(g.projectionMatrix.flatten());o=THREE.Matrix4.makeInvert3x3(j).transpose();d.normalMatrixArray=new Float32Array(o.m);c.uniformMatrix4fv(d.viewMatrix,false,d.viewMatrixArray);c.uniformMatrix4fv(d.modelViewMatrix,false,d.modelViewMatrixArray);c.uniformMatrix4fv(d.projectionMatrix,false,d.projectionMatrixArray);c.uniformMatrix3fv(d.normalMatrix,false,d.normalMatrixArray);c.uniformMatrix4fv(d.objMatrix,false,
new Float32Array(e.matrix.flatten()))};this.setBlending=function(e){switch(e){case THREE.AdditiveBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ONE,c.ONE);break;case THREE.SubtractiveBlending:c.blendFunc(c.DST_COLOR,c.ZERO);break;default:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ONE,c.ONE_MINUS_SRC_ALPHA)}};this.setFaceCulling=function(e,g){if(e){!g||g=="ccw"?c.frontFace(c.CCW):c.frontFace(c.CW);if(e=="back")c.cullFace(c.BACK);else e=="front"?c.cullFace(c.FRONT):c.cullFace(c.FRONT_AND_BACK);c.enable(c.CULL_FACE)}else c.disable(c.CULL_FACE)}};
THREE.RenderableFace3=function(){this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.material=this.color=this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.v4=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.material=this.color=this.z=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=this.color=null};
THREE.RenderableLine=function(){this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.material=this.color=this.z=null};
