/**
 * External dependencies
 */
import { connect } from 'react-redux';
import { get } from 'lodash';

/**
 * WordPress dependencies
 */
import { withAPIData } from '@wordpress/components';
import { compose } from '@wordpress/element';

/**
 * Internal Dependencies
 */
import { getCurrentPostType } from '../../store/selectors';

export function PostVisibilityCheck( { user, render } ) {
	const canEdit = get( user.data, [ 'post_type_capabilities', 'publish_posts' ], false );

	return render( { canEdit } );
}

const applyConnect = connect(
	( state ) => {
		return {
			postType: getCurrentPostType( state ),
		};
	},
);

const applyWithAPIData = withAPIData( ( props ) => {
	const { postType } = props;

	return {
		user: `/wp/v2/users/me?post_type=${ postType }&context=edit`,
	};
} );

export default compose( [
	applyConnect,
	applyWithAPIData,
] )( PostVisibilityCheck );
