"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Originally pulled from https://github.com/JasonEtco/actions-toolkit/blob/master/src/github.ts
const graphql_1 = require("@octokit/graphql");
const rest_1 = __importDefault(require("@octokit/rest"));
const Context = __importStar(require("./context"));
// We need this in order to extend Octokit
rest_1.default.prototype = new rest_1.default();
module.exports.context = new Context.Context();
class GitHub extends rest_1.default {
    constructor(token) {
        super({ auth: `token ${token}` });
        this.graphql = graphql_1.defaults({
            headers: { authorization: `token ${token}` }
        });
    }
}
exports.GitHub = GitHub;
//# sourceMappingURL=github.js.map