import ExecutionEnvironment from "@docusaurus/ExecutionEnvironment";
import React, { useEffect, useRef } from "react";
import styles from "./globe.module.css";

let Globe = undefined;
if (ExecutionEnvironment.canUseDOM) {
  Globe = require("react-globe.gl").default;
}

let locations = [
  // North America
  [39.0438, -77.4874], //Ashburn, VA
  [33.749, -84.388], //Atlanta, GA
  [41.8781, -87.6298], //Chicago, IL
  [39.7392, -104.9903], //Denver, CO
  [32.7767, -96.797], //Dallas, TX
  [34.0522, -118.2437], //Los Angeles, CA
  [25.7617, -80.1918], //Miami, FL
  [45.5017, -73.5673], //Monteral, Canada
  [40.7128, -74.006], //New York, NY
  [37.4419, -122.143], //Palo Alto, CA
  [37.3382, -121.8863], //San Jose, CA
  [37.3541, -121.9552], //Santa Clara, CA
  [47.6062, -122.3321], //Seattle, WA - 12
  [20.5888, -100.3899], //Querétaro, Mexico
  [43.6532, -79.3832], //Toronto, Canada

  // South America
  [4.711, -74.0721], //Bogotá, Colombia
  [-34.6037, -58.3816], //Buenos Aires, Argentina
  [-22.9068, -43.1729], //Rio de Janeiro, Brazil
  [-33.4489, -70.6693], //Santiago, Chile
  [-23.5558, -46.6396], //São Paulo, Brazil

  // Europe
  [52.3727598, 4.8936041], //Amsterdam, Netherlands - 20
  [47.4979937, 19.0403594], //Budapest, Hungary
  [44.4361414, 26.1027202], //Bucharest, Romania
  [53.3497645, -6.2602732], //Dublin, Ireland
  [50.1106444, 8.6820917], //Frankfurt, Germany
  [53.550341, 10.000654], //Hamburg, Germany
  [50.4500336, 30.5241361], //Kiev, Ukraine
  [38.7077507, -9.1365919], //Lisbon, Portugal
  [51.5073219, -0.1276474], //London, UK
  [40.4167047, -3.7035825], //Madrid, Spain
  [43.2961743, 5.3699525], //Marseille, France
  [45.4641943, 9.1896346], //Milan, Italy
  [48.1371079, 11.5753822], //Munich, Germany
  [55.7504461, 37.6174943], //Moscow, Russia
  [48.8588897, 2.320041], //Paris, France
  [50.0596288, 14.4464593], //Prague, Czech Republic
  [41.8933203, 12.4829321], //Rome, Italy
  [59.938732, 30.316229], //Saint Petersburg, Russia
  [42.6978634, 23.3221789], //Sofia, Bulgaria
  [59.3251172, 18.0710935], //Stockholm, Sweden
  [52.2319581, 21.0067249], //Warsaw, Poland
  [45.8131847, 15.9771774], //Zagreb, Croatia
  [47.3744489, 8.5410422], //Zürich, Switzerland

  // Middle East
  [25.1244604, 56.3355085], //Fujairah, United Arab Emirates
  [23.5882019, 58.3829448], //Muscat, Oman

  // Asia Pacific
  [13.0836939, 80.270186], //Chennai, India
  [22.350627, 114.1849161], //Hong Kong SAR, China
  [-6.1753942, 106.827183], //Jakarta, Indonesia
  [3.1516964, 101.6942371], //Kuala Lumpur, Malaysia
  [28.6517178, 77.2219388], //Delhi, India
  [34.6198813, 135.490357], //Osaka, Japan
  [19.0759899, 72.8773928], //Mumbai, India
  [37.5666791, 126.9782914], //Seoul, South Korea
  [1.357107, 103.8194992], //Singapore - 53
  [25.0375198, 121.5636796], //Taipei, Taiwan
  [35.6828387, 139.7594549], //Tokyo, Japan

  // Oceania
  [-33.8548157, 151.2164539], //Sydney, Australia
  [-37.8142176, 144.9631608], //Melbourne, Australia

  // Africa
  [-26.205, 28.049722], //Johannesburg, South Africa
  [-4.05052, 39.667169], //Mombasa, Kenya
  [6.4550575, 3.3941795], //Lagos, Nigeria
];

let colors = ["#CFD8DC", "#90A4AE", "#607D8B"];

let arcsData = [];

for (let i = 0; i < 300; i++) {
  let startLocation = locations[Math.floor(Math.random() * locations.length)];
  let endLocation = locations[Math.floor(Math.random() * locations.length)];
  arcsData.push({
    startLat: startLocation[0],
    startLng: startLocation[1],
    endLat: endLocation[0],
    endLng: endLocation[1],

    color: [colors[Math.floor(Math.random() * colors.length)], colors[Math.floor(Math.random() * colors.length)]],
  });
}

// prettier-ignore
let continents = {
  "type": "FeatureCollection",
                                                                                  
  "features": [
  { "type": "Feature", "properties": { "CONTINENT": "Asia" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ 93.275543212890625, 80.26361083984375 ], [ 93.148040771484375, 80.313873291015625 ], [ 91.424911499023438, 80.31011962890625 ], [ 92.604049682617188, 80.39044189453125 ], [ 91.903045654296875, 80.458595275878906 ], [ 92.774436950683594, 80.515960693359375 ], [ 93.325546264648438, 80.805816650390625 ], [ 92.493659973144531, 80.767555236816406 ], [ 93.160469055175781, 80.933731079101562 ], [ 93.059295654296875, 80.991790771484375 ], [ 95.538734436035156, 81.219429016113281 ], [ 95.122207641601562, 81.270828247070312 ], [ 95.787765502929688, 81.279983520507812 ], [ 97.965827941894531, 80.710060119628906 ], [ 97.129150390625, 80.662765502929688 ], [ 97.016937255859375, 80.529632568359375 ], [ 97.42095947265625, 80.313591003417969 ], [ 97.15887451171875, 80.233596801757812 ], [ 95.564697265625, 80.192474365234375 ], [ 93.719711303710938, 79.994140625 ], [ 92.076301574707031, 80.16949462890625 ], [ 92.881027221679688, 80.170677185058594 ], [ 92.1361083984375, 80.287490844726562 ], [ 93.275543212890625, 80.26361083984375 ] ] ], [ [ [ 91.029708862304688, 81.0555419921875 ], [ 90.0010986328125, 81.09832763671875 ], [ 89.893600463867188, 81.168594360351562 ], [ 91.57720947265625, 81.143051147460938 ], [ 91.029708862304688, 81.0555419921875 ] ] ], [ [ [ 79.2177734375, 80.954681396484375 ], [ 79.708602905273438, 80.97943115234375 ], [ 80.435951232910156, 80.930397033691406 ], [ 78.974983215332031, 80.833602905273438 ], [ 79.2177734375, 80.954681396484375 ] ] ], [ [ [ 99.60137939453125, 79.291366577148438 ], [ 99.044700622558594, 79.287757873535156 ], [ 99.942481994628906, 78.960685729980469 ], [ 98.342483520507812, 78.779159545898438 ], [ 95.533050537109375, 79.105255126953125 ], [ 95.007766723632812, 79.040267944335938 ], [ 94.324638366699219, 79.2506103515625 ], [ 94.332489013671875, 79.465545654296875 ], [ 93.713729858398438, 79.456863403320312 ], [ 93.985542297363281, 79.492340087890625 ], [ 93.688034057617188, 79.539009094238281 ], [ 93.879005432128906, 79.599433898925781 ], [ 93.22442626953125, 79.437759399414062 ], [ 93.126922607421875, 79.466026306152344 ], [ 93.310264587402344, 79.495391845703125 ], [ 92.855117797851562, 79.557479858398438 ], [ 94.6160888671875, 79.811920166015625 ], [ 94.223876953125, 79.900123596191406 ], [ 94.9366455078125, 80.09942626953125 ], [ 97.534149169921875, 80.169708251953125 ], [ 98.034423828125, 80.067489624023438 ], [ 97.201789855957031, 79.705406188964844 ], [ 98.392768859863281, 79.869430541992188 ], [ 98.528594970703125, 80.052474975585938 ], [ 100.015266418457031, 79.82415771484375 ], [ 99.60137939453125, 79.291366577148438 ] ] ], [ [ [ 91.086654663085938, 80.048599243164062 ], [ 90.864425659179688, 80.057205200195312 ], [ 92.907760620117188, 80.021926879882812 ], [ 93.808731079101562, 79.891792297363281 ], [ 93.006378173828125, 79.703598022460938 ], [ 91.921646118164062, 79.673309326171875 ], [ 92.349990844726562, 79.727767944335938 ], [ 91.073043823242188, 79.848602294921875 ], [ 91.239974975585938, 79.93414306640625 ], [ 91.086654663085938, 80.048599243164062 ] ] ], [ [ [ 93.988250732421875, 80.009780883789062 ], [ 94.271102905273438, 80.036102294921875 ], [ 94.323326110839844, 80.025260925292969 ], [ 93.927474975585938, 79.96832275390625 ], [ 93.988250732421875, 80.009780883789062 ] ] ], [ [ [ 91.618865966796875, 79.649429321289062 ], [ 91.233047485351562, 79.694427490234375 ], [ 91.124420166015625, 79.722488403320312 ], [ 91.858451843261719, 79.668312072753906 ], [ 91.618865966796875, 79.649429321289062 ] ] ], [ [ [ 99.9427490234375, 79.578872680664062 ], [ 99.94219970703125, 79.684417724609375 ], [ 100.30511474609375, 79.667205810546875 ], [ 100.026931762695312, 79.628036499023438 ], [ 99.9427490234375, 79.578872680664062 ] ] ], [ [ [ 76.617843627929688, 79.543563842773438 ], [ 76.1705322265625, 79.564422607421875 ], [ 76.044013977050781, 79.637908935546875 ], [ 77.617347717285156, 79.508880615234375 ], [ 76.617843627929688, 79.543563842773438 ] ] ], [ [ [ 91.8309326171875, 79.4114990234375 ], [ 92.284423828125, 79.449417114257812 ], [ 92.467483520507812, 79.429977416992188 ], [ 92.24359130859375, 79.379974365234375 ], [ 91.8309326171875, 79.4114990234375 ] ] ], [ [ [ 92.597640991210938, 79.402053833007812 ], [ 92.771926879882812, 79.439422607421875 ], [ 92.985816955566406, 79.413597106933594 ], [ 92.706649780273438, 79.377761840820312 ], [ 92.597640991210938, 79.402053833007812 ] ] ], [ [ [ 105.252777099609375, 78.47998046875 ], [ 102.718048095703125, 78.159988403320312 ], [ 99.34136962890625, 78.019989013671875 ], [ 99.994430541992188, 78.33526611328125 ], [ 100.372344970703125, 78.741783142089844 ], [ 101.1644287109375, 78.755271911621094 ], [ 100.780960083007812, 78.863868713378906 ], [ 100.887763977050781, 78.973182678222656 ], [ 101.619979858398438, 78.980262756347656 ], [ 100.991165161132812, 79.0631103515625 ], [ 101.197196960449219, 79.205825805664062 ], [ 101.776382446289062, 79.367477416992188 ], [ 102.243316650390625, 79.239151000976562 ], [ 102.140266418457031, 79.3599853515625 ], [ 102.3055419921875, 79.425537109375 ], [ 103.154632568359375, 79.311302185058594 ], [ 102.825546264648438, 79.223037719726562 ], [ 102.399436950683594, 78.826652526855469 ], [ 102.914703369140625, 79.052474975585938 ], [ 103.946929931640625, 79.133331298828125 ], [ 104.605819702148438, 78.775825500488281 ], [ 105.158332824707031, 78.811370849609375 ], [ 105.413177490234375, 78.571090698242188 ], [ 105.252777099609375, 78.47998046875 ] ] ], [ [ [ 106.190811157226562, 78.189971923828125 ], [ 105.992752075195312, 78.214157104492188 ], [ 106.759857177734375, 78.306785583496094 ], [ 106.714996337890625, 78.256942749023438 ], [ 106.190811157226562, 78.189971923828125 ] ] ], [ [ [ 93.739974975585938, 78.151382446289062 ], [ 93.572219848632812, 78.166656494140625 ], [ 93.524429321289062, 78.203323364257812 ], [ 93.640274047851562, 78.222763061523438 ], [ 93.739974975585938, 78.151382446289062 ] ] ], [ [ [ 107.438873291015625, 78.049423217773438 ], [ 106.4930419921875, 78.12164306640625 ], [ 106.494979858398438, 78.15887451171875 ], [ 107.699142456054688, 78.135269165039062 ], [ 107.438873291015625, 78.049423217773438 ] ] ], [ [ [ 57.202217102050781, 25.991661071777344 ], [ 57.032211303710938, 26.822498321533203 ], [ 56.808883666992188, 27.123607635498047 ], [ 56.132766723632812, 27.160274505615234 ], [ 54.788463592529297, 26.490411758422852 ], [ 54.296939849853516, 26.716104507446289 ], [ 53.686935424804688, 26.732772827148438 ], [ 52.608329772949219, 27.348190307617188 ], [ 52.499717712402344, 27.608608245849609 ], [ 51.430274963378906, 27.937774658203125 ], [ 51.054718017578125, 28.738748550415039 ], [ 50.801036834716797, 28.929788589477539 ], [ 50.923748016357422, 29.064580917358398 ], [ 50.638881683349609, 29.14277458190918 ], [ 50.639163970947266, 29.470415115356445 ], [ 50.038047790527344, 30.2127685546875 ], [ 49.555057525634766, 30.007219314575195 ], [ 49.004711151123047, 30.297357559204102 ], [ 48.928874969482422, 30.387046813964844 ], [ 49.263462066650391, 30.429092407226562 ], [ 49.03887939453125, 30.519161224365234 ], [ 48.866378784179688, 30.359024047851562 ], [ 48.917354583740234, 30.040689468383789 ], [ 48.534015655517578, 29.924579620361328 ], [ 47.959434509277344, 30.033050537109375 ], [ 48.166866302490234, 29.565135955810547 ], [ 47.955963134765625, 29.623744964599609 ], [ 47.707221984863281, 29.375831604003906 ], [ 48.028602600097656, 29.344993591308594 ], [ 48.877498626708984, 27.833606719970703 ], [ 48.838874816894531, 27.619716644287109 ], [ 49.236515045166016, 27.544300079345703 ], [ 49.308738708496094, 27.444856643676758 ], [ 49.127975463867188, 27.442287445068359 ], [ 49.40887451171875, 27.127216339111328 ], [ 49.542213439941406, 27.171104431152344 ], [ 50.154998779296875, 26.663053512573242 ], [ 49.996379852294922, 26.742496490478516 ], [ 50.219444274902344, 26.300277709960938 ], [ 49.993888854980469, 26.019996643066406 ], [ 50.482772827148438, 25.413887023925781 ], [ 50.775409698486328, 24.720830917358398 ], [ 50.756381988525391, 25.499580383300781 ], [ 50.951801300048828, 25.599164962768555 ], [ 51.036941528320312, 26.042427062988281 ], [ 51.244857788085938, 26.152498245239258 ], [ 51.567214965820312, 25.907705307006836 ], [ 51.475379943847656, 25.521768569946289 ], [ 51.611942291259766, 25.013748168945312 ], [ 51.366249084472656, 24.589582443237305 ], [ 51.214370727539062, 24.634441375732422 ], [ 51.298927307128906, 24.519674301147461 ], [ 51.487216949462891, 24.583330154418945 ], [ 51.282356262207031, 24.299999237060547 ], [ 51.725830078125, 24.2611083984375 ], [ 51.815975189208984, 23.997983932495117 ], [ 52.085968017578125, 23.955970764160156 ], [ 52.626247406005859, 24.196804046630859 ], [ 53.587772369384766, 24.044166564941406 ], [ 54.123744964599609, 24.141664505004883 ], [ 54.427497863769531, 24.28569221496582 ], [ 54.650276184082031, 24.746944427490234 ], [ 55.859439849853516, 25.720415115356445 ], [ 56.201900482177734, 26.260860443115234 ], [ 56.303886413574219, 26.20111083984375 ], [ 56.401523590087891, 26.219789505004883 ], [ 56.310970306396484, 26.222705841064453 ], [ 56.404212951660156, 26.36871337890625 ], [ 56.471385955810547, 26.14215087890625 ], [ 56.320690155029297, 26.166942596435547 ], [ 56.423881530761719, 25.950275421142578 ], [ 56.264301300048828, 25.659442901611328 ], [ 56.619785308837891, 24.477567672729492 ], [ 57.171314239501953, 23.934440612792969 ], [ 58.609298706054688, 23.632774353027344 ], [ 59.397773742675781, 22.680553436279297 ], [ 59.801731109619141, 22.536872863769531 ], [ 59.828605651855469, 22.291664123535156 ], [ 58.520687103271484, 20.419509887695312 ], [ 58.211521148681641, 20.397220611572266 ], [ 58.2137451171875, 20.612775802612305 ], [ 57.828189849853516, 20.21624755859375 ], [ 57.687633514404297, 19.708332061767578 ], [ 57.805690765380859, 18.970972061157227 ], [ 56.810436248779297, 18.744396209716797 ], [ 56.352321624755859, 17.941177368164062 ], [ 55.43603515625, 17.826108932495117 ], [ 55.031940460205078, 17.014719009399414 ], [ 54.092636108398438, 17.014305114746094 ], [ 52.596382141113281, 16.477218627929688 ], [ 52.227077484130859, 16.166177749633789 ], [ 52.189163208007812, 15.605276107788086 ], [ 49.094303131103516, 14.516804695129395 ], [ 48.698051452636719, 14.039999008178711 ], [ 47.990135192871094, 14.047082901000977 ], [ 47.394439697265625, 13.646388053894043 ], [ 46.691524505615234, 13.428054809570312 ], [ 45.659023284912109, 13.339165687561035 ], [ 45.042316436767578, 12.752385139465332 ], [ 44.590412139892578, 12.817081451416016 ], [ 43.949855804443359, 12.59465217590332 ], [ 43.4788818359375, 12.674999237060547 ], [ 43.230274200439453, 13.269721031188965 ], [ 43.279441833496094, 13.720276832580566 ], [ 43.086662292480469, 13.993331909179688 ], [ 42.935829162597656, 14.95777702331543 ], [ 42.681106567382812, 15.208332061767578 ], [ 42.810340881347656, 15.262012481689453 ], [ 42.693885803222656, 15.700277328491211 ], [ 42.834579467773438, 15.883332252502441 ], [ 42.789333343505859, 16.460830688476562 ], [ 42.547908782958984, 16.998260498046875 ], [ 42.370552062988281, 17.039997100830078 ], [ 42.307079315185547, 17.447635650634766 ], [ 41.678886413574219, 17.949443817138672 ], [ 40.756938934326172, 19.764165878295898 ], [ 39.660690307617188, 20.43791389465332 ], [ 39.174858093261719, 21.104024887084961 ], [ 38.993049621582031, 21.836940765380859 ], [ 39.062774658203125, 22.583332061767578 ], [ 38.446868896484375, 23.789094924926758 ], [ 37.442359924316406, 24.375137329101562 ], [ 37.154510498046875, 24.840137481689453 ], [ 37.235549926757812, 25.182498931884766 ], [ 35.160552978515625, 28.056663513183594 ], [ 34.572147369384766, 28.09589958190918 ], [ 35.003677368164062, 29.528192520141602 ], [ 34.877777099609375, 29.532497406005859 ], [ 34.216659545898438, 31.323329925537109 ], [ 34.708328247070312, 31.947637557983398 ], [ 34.953189849853516, 32.823398590087891 ], [ 35.634437561035156, 34.012771606445312 ], [ 35.648883819580078, 34.281105041503906 ], [ 35.983608245849609, 34.527496337890625 ], [ 35.919025421142578, 35.422634124755859 ], [ 35.73388671875, 35.5816650390625 ], [ 35.978439331054688, 36.002609252929688 ], [ 35.785545349121094, 36.314846038818359 ], [ 36.190059661865234, 36.597286224365234 ], [ 36.193328857421875, 36.791938781738281 ], [ 36.011203765869141, 36.923191070556641 ], [ 35.347072601318359, 36.544990539550781 ], [ 34.659431457519531, 36.805274963378906 ], [ 33.988601684570312, 36.27777099609375 ], [ 32.771659851074219, 36.028884887695312 ], [ 32.3680419921875, 36.175132751464844 ], [ 32.064712524414062, 36.516387939453125 ], [ 31.046661376953125, 36.849151611328125 ], [ 30.616525650024414, 36.843605041503906 ], [ 30.404857635498047, 36.204921722412109 ], [ 30.208608627319336, 36.303874969482422 ], [ 29.677215576171875, 36.118331909179688 ], [ 29.148050308227539, 36.34832763671875 ], [ 29.052497863769531, 36.681106567382812 ], [ 28.456386566162109, 36.880828857421875 ], [ 28.261940002441406, 36.845127105712891 ], [ 28.272636413574219, 36.736934661865234 ], [ 27.98388671875, 36.552772521972656 ], [ 28.120136260986328, 36.797077178955078 ], [ 27.475276947021484, 36.649993896484375 ], [ 27.358951568603516, 36.704299926757812 ], [ 28.025829315185547, 36.822776794433594 ], [ 28.324787139892578, 37.038185119628906 ], [ 27.254999160766602, 36.964996337890625 ], [ 27.324302673339844, 37.153045654296875 ], [ 27.59527587890625, 37.232490539550781 ], [ 27.42108154296875, 37.407905578613281 ], [ 27.194925308227539, 37.352348327636719 ], [ 27.268329620361328, 37.953598022460938 ], [ 26.275829315185547, 38.264434814453125 ], [ 26.509857177734375, 38.425479888916016 ], [ 26.388120651245117, 38.447006225585938 ], [ 26.398330688476562, 38.666938781738281 ], [ 26.691801071166992, 38.310855865478516 ], [ 27.156452178955078, 38.452804565429688 ], [ 26.733745574951172, 38.641937255859375 ], [ 27.062980651855469, 38.873184204101562 ], [ 26.801660537719727, 38.955825805664062 ], [ 26.869720458984375, 39.097908020019531 ], [ 26.644721984863281, 39.263053894042969 ], [ 26.951801300048828, 39.550827026367188 ], [ 26.109994888305664, 39.457630157470703 ], [ 26.157497406005859, 39.946659088134766 ], [ 26.704301834106445, 40.378879547119141 ], [ 27.118606567382812, 40.452766418457031 ], [ 27.511661529541016, 40.305553436279297 ], [ 27.877841949462891, 40.375858306884766 ], [ 27.754858016967773, 40.529720306396484 ], [ 28.020133972167969, 40.487705230712891 ], [ 27.953193664550781, 40.35693359375 ], [ 29.055761337280273, 40.366798400878906 ], [ 29.141695022583008, 40.437908172607422 ], [ 28.776729583740234, 40.527076721191406 ], [ 29.933954238891602, 40.722209930419922 ], [ 29.129440307617188, 40.914443969726562 ], [ 29.025554656982422, 41.034431457519531 ], [ 29.159999847412109, 41.224575042724609 ], [ 31.233469009399414, 41.089298248291016 ], [ 32.277496337890625, 41.719436645507812 ], [ 33.338600158691406, 42.019851684570312 ], [ 34.715545654296875, 41.942489624023438 ], [ 34.9788818359375, 42.091941833496094 ], [ 35.286651611328125, 41.713050842285156 ], [ 36.056102752685547, 41.688743591308594 ], [ 36.4315185546875, 41.242076873779297 ], [ 36.80999755859375, 41.355552673339844 ], [ 37.129299163818359, 41.146797180175781 ], [ 38.355823516845703, 40.910270690917969 ], [ 39.414226531982422, 41.106731414794922 ], [ 40.149993896484375, 40.920272827148438 ], [ 41.384952545166016, 41.373710632324219 ], [ 41.776092529296875, 41.841926574707031 ], [ 41.456100463867188, 42.71429443359375 ], [ 40.002967834472656, 43.379264831542969 ], [ 40.211376190185547, 43.584716796875 ], [ 41.597484588623047, 43.221508026123047 ], [ 42.855197906494141, 43.177761077880859 ], [ 43.829154968261719, 42.749366760253906 ], [ 43.777278900146484, 42.604015350341797 ], [ 45.165122985839844, 42.703327178955078 ], [ 45.750827789306641, 42.487758636474609 ], [ 45.655124664306641, 42.199989318847656 ], [ 46.761726379394531, 41.8604736328125 ], [ 47.274646759033203, 41.321098327636719 ], [ 47.915470123291016, 41.224987030029297 ], [ 48.770950317382812, 42.04534912109375 ], [ 49.760623931884766, 42.710758209228516 ], [ 49.2109375, 43.471668243408203 ], [ 48.6861572265625, 44.754344940185547 ], [ 49.448314666748047, 45.530384063720703 ], [ 50.038501739501953, 45.858478546142578 ], [ 49.325145721435547, 46.086944580078125 ], [ 49.222526550292969, 46.346305847167969 ], [ 48.576171875, 46.561031341552734 ], [ 48.544574737548828, 46.754154205322266 ], [ 49.027206420898438, 46.776092529296875 ], [ 48.143039703369141, 47.749713897705078 ], [ 47.255828857421875, 47.750831604003906 ], [ 47.121238708496094, 48.272075653076172 ], [ 46.499160766601562, 48.417495727539062 ], [ 47.059574127197266, 49.133602142333984 ], [ 46.804019927978516, 49.338462829589844 ], [ 46.931381225585938, 49.865829467773438 ], [ 47.302490234375, 50.031936645507812 ], [ 47.485687255859375, 50.417629241943359 ], [ 47.939437866210938, 50.250965118408203 ], [ 48.248744964599609, 49.871379852294922 ], [ 48.790554046630859, 49.939434051513672 ], [ 48.914714813232422, 50.032768249511719 ], [ 48.697486877441406, 50.591934204101562 ], [ 49.425827026367188, 50.851387023925781 ], [ 49.474712371826172, 51.124019622802734 ], [ 50.368598937988281, 51.327423095703125 ], [ 50.600410461425781, 51.637771606445312 ], [ 50.812351226806641, 51.59429931640625 ], [ 50.773300170898438, 51.769180297851562 ], [ 51.384712219238281, 51.640548706054688 ], [ 51.2994384765625, 51.481239318847656 ], [ 51.711936950683594, 51.461936950683594 ], [ 51.871379852294922, 51.671798706054688 ], [ 52.341800689697266, 51.780754089355469 ], [ 52.607631683349609, 51.456382751464844 ], [ 53.423744201660156, 51.492633819580078 ], [ 54.501659393310547, 50.859230041503906 ], [ 54.398395538330078, 50.625892639160156 ], [ 54.523933410644531, 50.528839111328125 ], [ 54.701797485351562, 50.609645843505859 ], [ 54.548606872558594, 50.922218322753906 ], [ 54.647216796875, 51.036941528320312 ], [ 55.692489624023438, 50.532493591308594 ], [ 56.501865386962891, 51.080829620361328 ], [ 57.127353668212891, 51.084712982177734 ], [ 57.463535308837891, 50.865272521972656 ], [ 57.736103057861328, 50.910408020019531 ], [ 57.792682647705078, 51.116317749023438 ], [ 58.3377685546875, 51.156097412109375 ], [ 58.601387023925781, 51.046661376953125 ], [ 58.665542602539062, 50.80499267578125 ], [ 59.488742828369141, 50.630405426025391 ], [ 59.542495727539062, 50.478324890136719 ], [ 59.814403533935547, 50.546276092529297 ], [ 60.052909851074219, 50.864162445068359 ], [ 60.698043823242188, 50.661659240722656 ], [ 61.422351837158203, 50.800617218017578 ], [ 61.685821533203125, 51.265830993652344 ], [ 60.052009582519531, 51.883186340332031 ], [ 59.913806915283203, 52.100273132324219 ], [ 60.144157409667969, 52.423740386962891 ], [ 59.250274658203125, 52.498878479003906 ], [ 59.179851531982422, 52.277908325195312 ], [ 58.789302825927734, 52.45068359375 ], [ 58.748950958251953, 52.856246948242188 ], [ 59.027355194091797, 53.018051147460938 ], [ 58.824504852294922, 53.203945159912109 ], [ 58.921524047851562, 53.932907104492188 ], [ 59.334712982177734, 54.184852600097656 ], [ 59.736656188964844, 54.138046264648438 ], [ 59.676105499267578, 54.487075805664062 ], [ 59.936309814453125, 54.861591339111328 ], [ 59.638328552246094, 54.911727905273438 ], [ 59.247909545898438, 54.613254547119141 ], [ 57.970268249511719, 54.388187408447266 ], [ 57.153045654296875, 54.853187561035156 ], [ 57.209438323974609, 55.225543975830078 ], [ 57.433742523193359, 55.327217102050781 ], [ 58.139438629150391, 55.221240997314453 ], [ 57.998603820800781, 54.917770385742188 ], [ 58.30499267578125, 55.175407409667969 ], [ 58.614994049072266, 54.949020385742188 ], [ 58.818328857421875, 55.039993286132812 ], [ 58.581172943115234, 55.137210845947266 ], [ 58.734992980957031, 55.268882751464844 ], [ 59.641658782958984, 55.558670043945312 ], [ 59.237628936767578, 55.596656799316406 ], [ 59.31353759765625, 55.776451110839844 ], [ 59.159191131591797, 55.792911529541016 ], [ 59.174297332763672, 55.997768402099609 ], [ 59.292354583740234, 56.134090423583984 ], [ 57.466381072998047, 56.121932983398438 ], [ 57.321662902832031, 56.482765197753906 ], [ 57.416938781738281, 56.642494201660156 ], [ 57.221691131591797, 56.850963592529297 ], [ 58.070968627929688, 57.047496795654297 ], [ 57.971931457519531, 57.532215118408203 ], [ 58.198875427246094, 57.689155578613281 ], [ 58.532493591308594, 57.566940307617188 ], [ 58.856941223144531, 57.729988098144531 ], [ 58.600967407226562, 58.005687713623047 ], [ 58.677352905273438, 58.106002807617188 ], [ 59.449123382568359, 58.488044738769531 ], [ 59.385829925537109, 58.7056884765625 ], [ 59.083465576171875, 58.760276794433594 ], [ 59.182281494140625, 59.163673400878906 ], [ 58.310966491699219, 59.460407257080078 ], [ 58.447349548339844, 59.692493438720703 ], [ 58.982490539550781, 59.949996948242188 ], [ 59.473598480224609, 60.809574127197266 ], [ 59.256385803222656, 61.260826110839844 ], [ 59.421104431152344, 61.426521301269531 ], [ 59.405963897705078, 62.144996643066406 ], [ 59.642910003662109, 62.518390655517578 ], [ 59.397315979003906, 62.739158630371094 ], [ 59.484573364257812, 62.891033172607422 ], [ 59.225959777832031, 63.035549163818359 ], [ 59.577560424804688, 63.932868957519531 ], [ 59.857425689697266, 64.146514892578125 ], [ 59.579647064208984, 64.243873596191406 ], [ 59.483116149902344, 64.48797607421875 ], [ 59.684432983398438, 64.8116455078125 ], [ 60.086940765380859, 65.04290771484375 ], [ 60.418045043945312, 65.054702758789062 ], [ 60.627628326416016, 64.885406494140625 ], [ 61.840827941894531, 65.669288635253906 ], [ 62.849575042724609, 65.871017456054688 ], [ 62.853607177734375, 66.07110595703125 ], [ 63.301727294921875, 66.245468139648438 ], [ 63.226238250732422, 66.32916259765625 ], [ 63.408599853515625, 66.452774047851562 ], [ 65.080276489257812, 66.884429931640625 ], [ 65.223602294921875, 67.146102905273438 ], [ 66.108871459960938, 67.481231689453125 ], [ 65.794013977050781, 67.56866455078125 ], [ 66.210540771484375, 67.696090698242188 ], [ 66.021377563476562, 67.804359436035156 ], [ 66.092414855957031, 67.926300048828125 ], [ 65.284988403320312, 68.011932373046875 ], [ 65.27581787109375, 68.23553466796875 ], [ 65.65228271484375, 68.557273864746094 ], [ 65.31219482421875, 68.806640625 ], [ 64.522216796875, 68.903045654296875 ], [ 64.937339782714844, 69.262214660644531 ], [ 65.870254516601562, 69.127197265625 ], [ 65.662376403808594, 69.114822387695312 ], [ 66.581375122070312, 68.90582275390625 ], [ 67.054977416992188, 68.856369018554688 ], [ 68.159423828125, 68.411376953125 ], [ 68.264999389648438, 68.187484741210938 ], [ 68.528594970703125, 68.277206420898438 ], [ 69.109848022460938, 68.869430541992188 ], [ 68.9627685546875, 68.906097412109375 ], [ 69.217483520507812, 68.955825805664062 ], [ 68.4547119140625, 68.980819702148438 ], [ 68.052482604980469, 69.275405883789062 ], [ 68.099151611328125, 69.544563293457031 ], [ 67.0101318359375, 69.699150085449219 ], [ 66.94769287109375, 69.5318603515625 ], [ 66.793731689453125, 69.580268859863281 ], [ 66.899429321289062, 70.02581787109375 ], [ 67.327774047851562, 70.097488403320312 ], [ 67.089851379394531, 70.214157104492188 ], [ 67.336997985839844, 70.758049011230469 ], [ 66.68511962890625, 70.763465881347656 ], [ 66.621231079101562, 70.891105651855469 ], [ 66.887908935546875, 71.080268859863281 ], [ 66.619560241699219, 71.045120239257812 ], [ 66.9033203125, 71.28692626953125 ], [ 67.9688720703125, 71.540542602539062 ], [ 68.465545654296875, 71.818893432617188 ], [ 68.9764404296875, 72.694282531738281 ], [ 69.327354431152344, 72.945396423339844 ], [ 71.538589477539062, 72.911376953125 ], [ 72.823875427246094, 72.711380004882812 ], [ 72.725265502929688, 72.60595703125 ], [ 72.862762451171875, 72.268325805664062 ], [ 72.318344116210938, 71.833648681640625 ], [ 72.364151000976562, 71.719741821289062 ], [ 71.806228637695312, 71.463325500488281 ], [ 72.591094970703125, 71.155258178710938 ], [ 72.839431762695312, 70.868316650390625 ], [ 72.681854248046875, 70.614768981933594 ], [ 72.774429321289062, 70.41998291015625 ], [ 72.432479858398438, 70.2894287109375 ], [ 72.608596801757812, 70.183868408203125 ], [ 72.490531921386719, 70.049285888671875 ], [ 72.686782836914062, 69.843460083007812 ], [ 72.534294128417969, 69.625396728515625 ], [ 72.553863525390625, 68.976654052734375 ], [ 73.513320922851562, 68.586929321289062 ], [ 73.638877868652344, 68.441505432128906 ], [ 73.102691650390625, 68.218803405761719 ], [ 73.204360961914062, 67.854560852050781 ], [ 73.032760620117188, 67.723182678222656 ], [ 72.55609130859375, 67.601654052734375 ], [ 72.376792907714844, 67.316650390625 ], [ 72.047760009765625, 67.297691345214844 ], [ 72.212760925292969, 67.151374816894531 ], [ 71.774429321289062, 66.945526123046875 ], [ 71.410263061523438, 66.966934204101562 ], [ 71.550956726074219, 66.644294738769531 ], [ 70.6866455078125, 66.508880615234375 ], [ 70.292686462402344, 66.620819091796875 ], [ 70.679153442382812, 66.713043212890625 ], [ 70.705406188964844, 66.7601318359375 ], [ 70.3306884765625, 66.67706298828125 ], [ 69.891937255859375, 66.831939697265625 ], [ 68.971649169921875, 66.806373596191406 ], [ 69.376930236816406, 66.5101318359375 ], [ 72.0, 66.219436645507812 ], [ 72.34332275390625, 66.298179626464844 ], [ 72.474151611328125, 66.604156494140625 ], [ 73.852767944335938, 66.984565734863281 ], [ 73.903457641601562, 67.289840698242188 ], [ 74.739974975585938, 67.691650390625 ], [ 74.72589111328125, 68.1492919921875 ], [ 74.338592529296875, 68.370880126953125 ], [ 74.450538635253906, 68.689285278320312 ], [ 74.640548706054688, 68.769149780273438 ], [ 76.582489013671875, 68.970542907714844 ], [ 76.641372680664062, 68.76776123046875 ], [ 77.320823669433594, 68.518386840820312 ], [ 77.164840698242188, 68.291786193847656 ], [ 77.359848022460938, 68.228462219238281 ], [ 77.19622802734375, 67.973663330078125 ], [ 77.300117492675781, 67.909080505371094 ], [ 77.084297180175781, 67.784843444824219 ], [ 77.785537719726562, 67.561920166015625 ], [ 79.041168212890625, 67.573432922363281 ], [ 77.466377258300781, 67.7591552734375 ], [ 77.55859375, 68.143875122070312 ], [ 78.1710205078125, 68.268043518066406 ], [ 77.779159545898438, 68.516380310058594 ], [ 77.644157409667969, 68.904708862304688 ], [ 76.001388549804688, 69.238876342773438 ], [ 74.749420166015625, 69.078872680664062 ], [ 73.748451232910156, 69.171234130859375 ], [ 73.895889282226562, 69.414779663085938 ], [ 73.515754699707031, 69.742904663085938 ], [ 73.687957763671875, 70.134567260742188 ], [ 74.293319702148438, 70.497207641601562 ], [ 74.320541381835938, 70.655258178710938 ], [ 73.526657104492188, 71.263046264648438 ], [ 73.016380310058594, 71.418525695800781 ], [ 73.503311157226562, 71.662765502929688 ], [ 73.525527954101562, 71.815818786621094 ], [ 74.97442626953125, 72.122207641601562 ], [ 75.109428405761719, 72.391380310058594 ], [ 74.829986572265625, 72.834152221679688 ], [ 75.360260009765625, 72.805252075195312 ], [ 75.712417602539062, 72.558174133300781 ], [ 75.552619934082031, 72.483314514160156 ], [ 75.746368408203125, 72.268600463867188 ], [ 75.22235107421875, 71.841255187988281 ], [ 75.495475769042969, 71.659431457519531 ], [ 75.267349243164062, 71.361236572265625 ], [ 76.843597412109375, 71.188583374023438 ], [ 76.915817260742188, 71.069717407226562 ], [ 77.004570007324219, 71.182487487792969 ], [ 77.679840087890625, 71.156929016113281 ], [ 78.43609619140625, 70.885818481445312 ], [ 79.031097412109375, 70.934707641601562 ], [ 79.1085205078125, 71.007072448730469 ], [ 78.549713134765625, 70.955551147460938 ], [ 78.51971435546875, 71.101654052734375 ], [ 78.248321533203125, 71.097488403320312 ], [ 78.296371459960938, 71.250129699707031 ], [ 77.93914794921875, 71.253326416015625 ], [ 77.982345581054688, 71.372894287109375 ], [ 77.5172119140625, 71.298873901367188 ], [ 76.264015197753906, 71.574714660644531 ], [ 76.097488403320312, 71.9285888671875 ], [ 76.89776611328125, 72.05108642578125 ], [ 77.560256958007812, 71.83221435546875 ], [ 78.104736328125, 71.876144409179688 ], [ 78.226890563964844, 71.95635986328125 ], [ 78.015823364257812, 72.099990844726562 ], [ 77.373237609863281, 72.097412109375 ], [ 78.538040161132812, 72.403594970703125 ], [ 80.826095581054688, 72.086929321289062 ], [ 80.636581420898438, 72.051162719726562 ], [ 81.653045654296875, 71.708038330078125 ], [ 83.261642456054688, 71.721084594726562 ], [ 82.85772705078125, 71.393081665039062 ], [ 82.257217407226562, 71.256660461425781 ], [ 82.355812072753906, 71.088737487792969 ], [ 82.201934814453125, 70.98858642578125 ], [ 82.408592224121094, 70.769645690917969 ], [ 82.080963134765625, 70.564567565917969 ], [ 82.346099853515625, 70.198593139648438 ], [ 82.158111572265625, 70.572761535644531 ], [ 82.433311462402344, 70.608871459960938 ], [ 82.66387939453125, 70.94720458984375 ], [ 83.109703063964844, 70.89068603515625 ], [ 83.018180847167969, 70.426231384277344 ], [ 82.643043518066406, 70.233596801757812 ], [ 83.10693359375, 70.068603515625 ], [ 83.193588256835938, 70.123306274414062 ], [ 83.133460998535156, 70.204566955566406 ], [ 82.95166015625, 70.320541381835938 ], [ 83.531661987304688, 70.339157104492188 ], [ 83.745529174804688, 70.459991455078125 ], [ 83.150199890136719, 71.238037109375 ], [ 83.626365661621094, 71.625396728515625 ], [ 83.37164306640625, 71.8297119140625 ], [ 82.193244934082031, 72.094154357910156 ], [ 82.309288024902344, 72.191505432128906 ], [ 82.19873046875, 72.280410766601562 ], [ 80.726371765136719, 72.523040771484375 ], [ 80.82366943359375, 72.619216918945312 ], [ 80.627059936523438, 72.707351684570312 ], [ 80.81109619140625, 72.973320007324219 ], [ 80.238868713378906, 73.175399780273438 ], [ 80.569915771484375, 73.222480773925781 ], [ 80.253044128417969, 73.323043823242188 ], [ 80.674705505371094, 73.501930236816406 ], [ 80.518600463867188, 73.573463439941406 ], [ 87.047477722167969, 73.8701171875 ], [ 85.785957336425781, 73.470542907714844 ], [ 85.839569091796875, 73.323745727539062 ], [ 86.783599853515625, 72.99407958984375 ], [ 85.841796875, 73.451095581054688 ], [ 87.183311462402344, 73.619422912597656 ], [ 87.666099548339844, 73.890823364257812 ], [ 87.321792602539062, 73.830543518066406 ], [ 86.980438232421875, 74.028610229492188 ], [ 87.366783142089844, 74.042617797851562 ], [ 85.949638366699219, 74.282623291015625 ], [ 86.45526123046875, 74.453598022460938 ], [ 86.900001525878906, 74.371040344238281 ], [ 86.738037109375, 74.297210693359375 ], [ 87.13275146484375, 74.369140625 ], [ 85.789154052734375, 74.630813598632812 ], [ 86.114425659179688, 74.743309020996094 ], [ 86.035606384277344, 74.811019897460938 ], [ 86.913040161132812, 74.61248779296875 ], [ 86.761932373046875, 74.702774047851562 ], [ 87.379631042480469, 74.9461669921875 ], [ 87.181716918945312, 74.981369018554688 ], [ 87.775398254394531, 75.024642944335938 ], [ 86.9033203125, 75.079856872558594 ], [ 86.98651123046875, 75.149299621582031 ], [ 87.987197875976562, 75.099990844726562 ], [ 89.252777099609375, 75.5030517578125 ], [ 89.53387451171875, 75.446640014648438 ], [ 89.959716796875, 75.571380615234375 ], [ 91.619705200195312, 75.63720703125 ], [ 91.709426879882812, 75.735260009765625 ], [ 93.346649169921875, 75.829986572265625 ], [ 94.155189514160156, 75.946784973144531 ], [ 92.865264892578125, 75.948318481445312 ], [ 93.18109130859375, 76.099716186523438 ], [ 96.197196960449219, 76.081520080566406 ], [ 95.574851989746094, 75.88818359375 ], [ 95.743865966796875, 75.850540161132812 ], [ 96.511932373046875, 76.009994506835938 ], [ 96.629974365234375, 75.954437255859375 ], [ 96.442901611328125, 75.868453979492188 ], [ 97.2894287109375, 76.0394287109375 ], [ 97.38970947265625, 76.041236877441406 ], [ 97.18359375, 75.92803955078125 ], [ 97.821380615234375, 75.979705810546875 ], [ 97.547904968261719, 76.049980163574219 ], [ 98.745529174804688, 76.261932373046875 ], [ 99.276931762695312, 76.214157104492188 ], [ 99.099769592285156, 76.160125732421875 ], [ 99.765617370605469, 76.034294128417969 ], [ 99.617485046386719, 75.835540771484375 ], [ 99.223457336425781, 75.758598327636719 ], [ 99.093048095703125, 75.561927795410156 ], [ 100.186256408691406, 75.168533325195312 ], [ 99.802337646484375, 75.476234436035156 ], [ 99.174209594726562, 75.56866455078125 ], [ 99.30609130859375, 75.76776123046875 ], [ 99.595680236816406, 75.775688171386719 ], [ 99.894989013671875, 75.918594360351562 ], [ 99.877197265625, 76.091659545898438 ], [ 98.836105346679688, 76.506103515625 ], [ 100.864151000976562, 76.532485961914062 ], [ 102.240814208984375, 76.379005432128906 ], [ 100.878311157226562, 76.551376342773438 ], [ 101.231163024902344, 76.751579284667969 ], [ 100.849716186523438, 76.878585815429688 ], [ 102.0555419921875, 77.383041381835938 ], [ 104.071380615234375, 77.732208251953125 ], [ 105.871917724609375, 77.5635986328125 ], [ 106.282478332519531, 77.3660888671875 ], [ 104.123313903808594, 77.089569091796875 ], [ 105.909988403320312, 77.141372680664062 ], [ 105.448455810546875, 76.976097106933594 ], [ 106.813873291015625, 77.04998779296875 ], [ 107.498176574707031, 76.918388366699219 ], [ 106.392906188964844, 76.512077331542969 ], [ 107.875808715820312, 76.535263061523438 ], [ 107.944137573242188, 76.731658935546875 ], [ 111.103866577148438, 76.755264282226562 ], [ 112.190040588378906, 76.470260620117188 ], [ 111.9063720703125, 76.364425659179688 ], [ 112.265823364257812, 76.45220947265625 ], [ 112.744285583496094, 76.325965881347656 ], [ 112.512489318847656, 76.238517761230469 ], [ 112.852767944335938, 76.144851684570312 ], [ 112.575057983398438, 76.045677185058594 ], [ 113.255821228027344, 76.143318176269531 ], [ 112.933448791503906, 76.255409240722656 ], [ 113.242752075195312, 76.26220703125 ], [ 113.46630859375, 76.13824462890625 ], [ 113.547492980957031, 75.866653442382812 ], [ 113.891372680664062, 75.845054626464844 ], [ 113.509429931640625, 75.532485961914062 ], [ 113.594985961914062, 75.657623291015625 ], [ 112.349700927734375, 75.847137451171875 ], [ 112.869140625, 75.705551147460938 ], [ 112.828048706054688, 75.5474853515625 ], [ 113.284500122070312, 75.644294738769531 ], [ 113.717483520507812, 75.408599853515625 ], [ 111.786651611328125, 74.664016723632812 ], [ 109.577476501464844, 74.307205200195312 ], [ 109.9698486328125, 74.297203063964844 ], [ 108.189697265625, 73.670257568359375 ], [ 107.138877868652344, 73.61151123046875 ], [ 106.804557800292969, 73.341934204101562 ], [ 106.067626953125, 73.274154663085938 ], [ 105.8388671875, 73.004920959472656 ], [ 105.211929321289062, 72.76470947265625 ], [ 106.283309936523438, 72.961654663085938 ], [ 106.171928405761719, 73.095130920410156 ], [ 106.34332275390625, 73.188728332519531 ], [ 108.353042602539062, 73.219711303710938 ], [ 108.205474853515625, 73.277900695800781 ], [ 109.424568176269531, 73.414840698242188 ], [ 109.177825927734375, 73.539634704589844 ], [ 109.813873291015625, 73.459152221679688 ], [ 110.914321899414062, 73.696685791015625 ], [ 109.757766723632812, 73.65887451171875 ], [ 109.526931762695312, 73.779983520507812 ], [ 110.200408935546875, 74.024444580078125 ], [ 111.001388549804688, 73.904434204101562 ], [ 111.140266418457031, 74.029159545898438 ], [ 111.518333435058594, 74.048599243164062 ], [ 111.20318603515625, 73.969429016113281 ], [ 112.248321533203125, 73.706939697265625 ], [ 112.874687194824219, 73.759719848632812 ], [ 112.887771606445312, 73.964996337890625 ], [ 113.424423217773438, 73.640823364257812 ], [ 113.135261535644531, 73.448173522949219 ], [ 113.495391845703125, 73.336929321289062 ], [ 113.519706726074219, 73.112762451171875 ], [ 113.475120544433594, 72.961585998535156 ], [ 113.089569091796875, 72.835128784179688 ], [ 113.185394287109375, 72.719429016113281 ], [ 113.533866882324219, 72.634994506835938 ], [ 114.044708251953125, 72.597213745117188 ], [ 113.155685424804688, 72.819984436035156 ], [ 113.534561157226562, 72.96734619140625 ], [ 113.543045043945312, 73.238456726074219 ], [ 114.02789306640625, 73.344436645507812 ], [ 113.470542907714844, 73.500961303710938 ], [ 115.456939697265625, 73.703048706054688 ], [ 118.634429931640625, 73.5716552734375 ], [ 118.985885620117188, 73.485260009765625 ], [ 118.47137451171875, 73.479713439941406 ], [ 118.388870239257812, 73.238731384277344 ], [ 119.817756652832031, 72.935806274414062 ], [ 121.865806579589844, 72.968048095703125 ], [ 122.053306579589844, 72.891937255859375 ], [ 123.3438720703125, 72.72747802734375 ], [ 124.738037109375, 72.623733520507812 ], [ 125.647491455078125, 72.341934204101562 ], [ 126.094711303710938, 72.270538330078125 ], [ 126.364982604980469, 72.352203369140625 ], [ 126.803314208984375, 72.016525268554688 ], [ 127.131217956542969, 71.848037719726562 ], [ 127.215263366699219, 71.394569396972656 ], [ 127.311500549316406, 71.490531921386719 ], [ 127.188018798828125, 71.747207641601562 ], [ 127.326080322265625, 71.894989013671875 ], [ 126.720115661621094, 72.387481689453125 ], [ 127.658599853515625, 72.347488403320312 ], [ 128.711639404296875, 71.770538330078125 ], [ 129.182296752929688, 71.803451538085938 ], [ 129.072479248046875, 72.001937866210938 ], [ 129.527175903320312, 71.719917297363281 ], [ 128.843826293945312, 71.604293823242188 ], [ 129.184356689453125, 71.5908203125 ], [ 129.74383544921875, 71.12109375 ], [ 130.577178955078125, 70.869430541992188 ], [ 130.783584594726562, 70.971794128417969 ], [ 130.897613525390625, 70.754997253417969 ], [ 131.1302490234375, 70.731094360351562 ], [ 131.535797119140625, 70.877761840820312 ], [ 131.843017578125, 71.201370239257812 ], [ 132.175735473632812, 71.218177795410156 ], [ 131.946624755859375, 71.289154052734375 ], [ 132.71844482421875, 71.941093444824219 ], [ 132.71551513671875, 71.768463134765625 ], [ 133.67913818359375, 71.433319091796875 ], [ 134.45245361328125, 71.367477416992188 ], [ 135.9649658203125, 71.631927490234375 ], [ 137.451904296875, 71.341094970703125 ], [ 137.803863525390625, 71.115814208984375 ], [ 138.067886352539062, 71.136024475097656 ], [ 137.783584594726562, 71.245124816894531 ], [ 138.215789794921875, 71.259017944335938 ], [ 137.825653076171875, 71.386932373046875 ], [ 138.066070556640625, 71.5736083984375 ], [ 138.732879638671875, 71.642486572265625 ], [ 139.202880859375, 71.412353515625 ], [ 139.932464599609375, 71.4849853515625 ], [ 139.644363403320312, 71.911651611328125 ], [ 139.336639404296875, 71.945526123046875 ], [ 140.19427490234375, 72.206375122070312 ], [ 139.08746337890625, 72.230262756347656 ], [ 139.541351318359375, 72.494430541992188 ], [ 141.024139404296875, 72.5858154296875 ], [ 140.578445434570312, 72.871231079101562 ], [ 140.74884033203125, 72.889434814453125 ], [ 146.838714599609375, 72.343803405761719 ], [ 144.968292236328125, 72.434982299804688 ], [ 144.5355224609375, 72.231094360351562 ], [ 144.143447875976562, 72.263465881347656 ], [ 144.431640625, 72.168869018554688 ], [ 145.08636474609375, 72.2591552734375 ], [ 146.917327880859375, 72.299842834472656 ], [ 145.96466064453125, 71.846939086914062 ], [ 145.996627807617188, 72.030059814453125 ], [ 146.341079711914062, 72.124977111816406 ], [ 145.985443115234375, 72.065536499023438 ], [ 145.69134521484375, 72.252777099609375 ], [ 145.61822509765625, 72.082069396972656 ], [ 145.801849365234375, 71.927139282226562 ], [ 144.967391967773438, 71.9658203125 ], [ 145.214035034179688, 71.839569091796875 ], [ 144.920669555664062, 71.693313598632812 ], [ 145.31884765625, 71.658035278320312 ], [ 146.079681396484375, 71.79095458984375 ], [ 147.18218994140625, 72.323318481445312 ], [ 149.18524169921875, 72.222488403320312 ], [ 150.0712890625, 71.884078979492188 ], [ 149.668319702148438, 71.761520385742188 ], [ 149.337982177734375, 71.9002685546875 ], [ 148.840744018554688, 71.8033447265625 ], [ 149.0374755859375, 71.758880615234375 ], [ 148.82940673828125, 71.672126770019531 ], [ 149.9619140625, 71.657211303710938 ], [ 150.0980224609375, 71.587066650390625 ], [ 149.865646362304688, 71.463188171386719 ], [ 150.667892456054688, 71.483108520507812 ], [ 150.023590087890625, 71.207489013671875 ], [ 150.675262451171875, 71.388320922851562 ], [ 150.606338500976562, 71.2783203125 ], [ 151.4619140625, 71.341102600097656 ], [ 152.13482666015625, 70.995048522949219 ], [ 151.659576416015625, 70.984153747558594 ], [ 152.538299560546875, 70.8377685546875 ], [ 155.93719482421875, 71.094436645507812 ], [ 159.044692993164062, 70.869834899902344 ], [ 160.035247802734375, 70.409019470214844 ], [ 160.094696044921875, 70.24456787109375 ], [ 159.79498291015625, 70.13720703125 ], [ 159.72967529296875, 69.834716796875 ], [ 160.99920654296875, 69.579780578613281 ], [ 160.96844482421875, 69.114494323730469 ], [ 161.410812377929688, 68.976509094238281 ], [ 161.066070556640625, 68.563308715820312 ], [ 160.837875366210938, 68.523735046386719 ], [ 161.135940551757812, 68.560958862304688 ], [ 161.577178955078125, 68.912071228027344 ], [ 161.434967041015625, 69.376785278320312 ], [ 161.609054565429688, 69.425262451171875 ], [ 161.810791015625, 69.5283203125 ], [ 164.014434814453125, 69.767486572265625 ], [ 164.532470703125, 69.59942626953125 ], [ 166.860504150390625, 69.49053955078125 ], [ 167.777206420898438, 69.776092529296875 ], [ 168.239822387695312, 69.551368713378906 ], [ 168.2833251953125, 69.241653442382812 ], [ 169.365524291992188, 69.080406188964844 ], [ 169.589279174804688, 68.777076721191406 ], [ 170.6119384765625, 68.756332397460938 ], [ 170.4422607421875, 68.839645385742188 ], [ 170.7049560546875, 68.804428100585938 ], [ 171.03192138671875, 69.042205810546875 ], [ 170.609130859375, 69.580276489257812 ], [ 170.122451782226562, 69.613594055175781 ], [ 170.56719970703125, 69.778045654296875 ], [ 170.471893310546875, 70.1341552734375 ], [ 172.638580322265625, 69.965682983398438 ], [ 173.201644897460938, 69.779434204101562 ], [ 173.475723266601562, 69.833320617675781 ], [ 173.205108642578125, 69.924430847167969 ], [ 173.458587646484375, 69.952484130859375 ], [ 176.084396362304688, 69.892906188964844 ], [ 176.741058349609375, 69.66693115234375 ], [ 178.770538330078125, 69.407485961914062 ], [ 179.065521240234375, 69.323738098144531 ], [ 178.651565551757812, 69.309417724609375 ], [ 179.296920776367188, 69.262283325195312 ], [ 180.0, 68.9801025390625 ], [ 180.0, 65.06890869140625 ], [ 179.459976196289062, 64.812896728515625 ], [ 178.522216796875, 64.588043212890625 ], [ 178.749282836914062, 64.683380126953125 ], [ 177.605789184570312, 64.720405578613281 ], [ 176.91607666015625, 65.082489013671875 ], [ 176.307205200195312, 65.046653747558594 ], [ 176.957199096679688, 65.038040161132812 ], [ 177.298660278320312, 64.8306884765625 ], [ 176.452194213867188, 64.80609130859375 ], [ 176.059967041015625, 64.948028564453125 ], [ 175.69219970703125, 64.778045654296875 ], [ 175.068572998046875, 64.763046264648438 ], [ 174.450180053710938, 64.686363220214844 ], [ 175.68218994140625, 64.754165649414062 ], [ 176.064971923828125, 64.901382446289062 ], [ 176.422683715820312, 64.704078674316406 ], [ 176.147750854492188, 64.629150390625 ], [ 176.109893798828125, 64.544219970703125 ], [ 177.48760986328125, 64.758743286132812 ], [ 177.361007690429688, 64.54449462890625 ], [ 177.63189697265625, 64.318878173828125 ], [ 178.087738037109375, 64.19970703125 ], [ 178.3460693359375, 64.295822143554688 ], [ 178.48358154296875, 64.065536499023438 ], [ 178.37689208984375, 63.972213745117188 ], [ 178.663864135742188, 63.943740844726562 ], [ 178.757476806640625, 63.639991760253906 ], [ 178.261093139648438, 63.574508666992188 ], [ 178.704147338867188, 63.573329925537109 ], [ 178.680389404296875, 63.38360595703125 ], [ 178.778656005859375, 63.585338592529297 ], [ 179.002212524414062, 63.320137023925781 ], [ 178.855789184570312, 63.399158477783203 ], [ 178.82177734375, 63.339157104492188 ], [ 179.411651611328125, 63.138881683349609 ], [ 179.23565673828125, 63.005687713623047 ], [ 179.539840698242188, 62.842212677001953 ], [ 179.553726196289062, 62.619712829589844 ], [ 179.1292724609375, 62.4788818359375 ], [ 179.101348876953125, 62.289302825927734 ], [ 177.338287353515625, 62.576103210449219 ], [ 177.452606201171875, 62.809921264648438 ], [ 177.1917724609375, 62.703464508056641 ], [ 176.974411010742188, 62.864021301269531 ], [ 176.929702758789062, 62.664573669433594 ], [ 177.264144897460938, 62.578742980957031 ], [ 174.604400634765625, 61.978530883789062 ], [ 174.7236328125, 61.885410308837891 ], [ 174.59356689453125, 61.829994201660156 ], [ 173.541778564453125, 61.744300842285156 ], [ 173.494400024414062, 61.563949584960938 ], [ 173.160797119140625, 61.404159545898438 ], [ 172.713851928710938, 61.427215576171875 ], [ 172.956085205078125, 61.302772521972656 ], [ 172.342941284179688, 61.219017028808594 ], [ 172.453033447265625, 61.041107177734375 ], [ 172.01824951171875, 61.092281341552734 ], [ 172.201217651367188, 60.962909698486328 ], [ 170.641937255859375, 60.417495727539062 ], [ 170.242462158203125, 59.910125732421875 ], [ 169.264984130859375, 60.619438171386719 ], [ 168.188873291015625, 60.5816650390625 ], [ 167.050262451171875, 60.323883056640625 ], [ 166.13775634765625, 59.815269470214844 ], [ 166.34857177734375, 60.486381530761719 ], [ 164.996627807617188, 60.126655578613281 ], [ 165.182464599609375, 59.981101989746094 ], [ 164.823577880859375, 59.781658172607422 ], [ 164.46856689453125, 60.111381530761719 ], [ 164.14630126953125, 59.867214202880859 ], [ 164.04400634765625, 60.030269622802734 ], [ 163.639968872070312, 60.045894622802734 ], [ 163.699203491210938, 59.897281646728516 ], [ 163.3602294921875, 59.823883056640625 ], [ 163.389556884765625, 59.629158020019531 ], [ 163.179275512695312, 59.566520690917969 ], [ 163.328857421875, 59.388050079345703 ], [ 163.06109619140625, 59.240547180175781 ], [ 163.191909790039062, 59.129295349121094 ], [ 163.18719482421875, 59.04791259765625 ], [ 162.882049560546875, 59.127490997314453 ], [ 163.03289794921875, 58.996246337890625 ], [ 162.40594482421875, 58.679573059082031 ], [ 161.938583374023438, 58.067630767822266 ], [ 162.339263916015625, 57.691379547119141 ], [ 162.563720703125, 57.949714660644531 ], [ 163.20941162109375, 57.839576721191406 ], [ 163.2823486328125, 57.739994049072266 ], [ 163.07275390625, 57.501663208007812 ], [ 162.742385864257812, 57.359439849853516 ], [ 162.781646728515625, 56.854438781738281 ], [ 162.902481079101562, 56.707218170166016 ], [ 163.210800170898438, 56.741798400878906 ], [ 163.349960327148438, 56.195960998535156 ], [ 163.033721923828125, 56.017910003662109 ], [ 162.645263671875, 56.191932678222656 ], [ 163.0738525390625, 56.477489471435547 ], [ 162.9852294921875, 56.547492980957031 ], [ 162.39385986328125, 56.389644622802734 ], [ 162.567123413085938, 56.273323059082031 ], [ 162.086074829101562, 56.100963592529297 ], [ 161.711349487304688, 55.490272521972656 ], [ 162.113006591796875, 54.763534545898438 ], [ 161.738418579101562, 54.507495880126953 ], [ 160.728286743164062, 54.529296875 ], [ 160.005828857421875, 54.13916015625 ], [ 159.817474365234375, 53.658599853515625 ], [ 159.962188720703125, 53.516384124755859 ], [ 159.798248291015625, 53.521240234375 ], [ 160.050384521484375, 53.095130920410156 ], [ 159.61468505859375, 53.259437561035156 ], [ 158.724960327148438, 52.89068603515625 ], [ 158.439422607421875, 53.027214050292969 ], [ 158.446075439453125, 52.902488708496094 ], [ 158.6422119140625, 52.901798248291016 ], [ 158.547210693359375, 52.622768402099609 ], [ 158.41912841796875, 52.652214050292969 ], [ 158.55511474609375, 52.311103820800781 ], [ 158.277679443359375, 51.941307067871094 ], [ 156.668304443359375, 50.881660461425781 ], [ 156.7452392578125, 51.077911376953125 ], [ 156.52081298828125, 51.315685272216797 ], [ 156.281356811523438, 52.521034240722656 ], [ 156.379486083984375, 52.450141906738281 ], [ 156.440658569335938, 52.515480041503906 ], [ 156.102325439453125, 52.852630615234375 ], [ 155.54412841796875, 55.303604125976562 ], [ 155.942062377929688, 56.653533935546875 ], [ 156.98052978515625, 57.420825958251953 ], [ 156.760177612304688, 57.738254547119141 ], [ 158.233306884765625, 58.019439697265625 ], [ 159.702178955078125, 58.851387023925781 ], [ 159.78997802734375, 59.083877563476562 ], [ 160.483779907226562, 59.542842864990234 ], [ 161.83746337890625, 60.187492370605469 ], [ 161.9124755859375, 60.419715881347656 ], [ 163.643310546875, 60.875404357910156 ], [ 163.7291259765625, 60.936653137207031 ], [ 163.509979248046875, 61.046943664550781 ], [ 164.014984130859375, 61.330272674560547 ], [ 163.748565673828125, 61.450824737548828 ], [ 164.071502685546875, 61.783607482910156 ], [ 164.120513916015625, 62.277072906494141 ], [ 164.613845825195312, 62.474296569824219 ], [ 165.284561157226562, 62.316658020019531 ], [ 165.09405517578125, 62.455753326416016 ], [ 165.629989624023438, 62.442764282226562 ], [ 164.366485595703125, 62.711795806884766 ], [ 163.257354736328125, 62.542636871337891 ], [ 163.1644287109375, 62.444709777832031 ], [ 163.350997924804688, 62.3619384765625 ], [ 163.125656127929688, 62.284019470214844 ], [ 162.952392578125, 61.801242828369141 ], [ 163.283309936523438, 61.661796569824219 ], [ 163.00555419921875, 61.518325805664062 ], [ 162.838165283203125, 61.719570159912109 ], [ 162.653732299804688, 61.693042755126953 ], [ 162.743865966796875, 61.598880767822266 ], [ 162.409698486328125, 61.673465728759766 ], [ 160.7960205078125, 60.738113403320312 ], [ 160.138931274414062, 60.589225769042969 ], [ 160.391357421875, 61.025825500488281 ], [ 159.780685424804688, 60.943462371826172 ], [ 159.946624755859375, 61.1361083984375 ], [ 159.854400634765625, 61.312767028808594 ], [ 160.366363525390625, 61.765830993652344 ], [ 160.354949951171875, 61.947486877441406 ], [ 159.5252685546875, 61.664852142333984 ], [ 159.247467041015625, 61.922218322753906 ], [ 158.021377563476562, 61.730129241943359 ], [ 157.48663330078125, 61.803321838378906 ], [ 156.695526123046875, 61.533744812011719 ], [ 156.656234741210938, 61.209716796875 ], [ 156.0849609375, 61.012496948242188 ], [ 155.89678955078125, 60.762214660644531 ], [ 154.231491088867188, 59.878742218017578 ], [ 154.2974853515625, 59.637496948242188 ], [ 154.108718872070312, 59.462909698486328 ], [ 154.501434326171875, 59.433048248291016 ], [ 154.437881469726562, 59.548469543457031 ], [ 155.186279296875, 59.361621856689453 ], [ 155.1402587890625, 59.204109191894531 ], [ 154.74163818359375, 59.126937866210938 ], [ 154.451080322265625, 59.219985961914062 ], [ 154.022064208984375, 59.046104431152344 ], [ 153.361618041992188, 59.241661071777344 ], [ 152.877166748046875, 58.917495727539062 ], [ 152.357177734375, 59.023323059082031 ], [ 151.3087158203125, 58.839019775390625 ], [ 151.076766967773438, 59.106033325195312 ], [ 152.284271240234375, 59.220062255859375 ], [ 151.748565673828125, 59.296104431152344 ], [ 151.3861083984375, 59.57110595703125 ], [ 150.713165283203125, 59.443042755126953 ], [ 150.4427490234375, 59.482494354248047 ], [ 150.7069091796875, 59.575412750244141 ], [ 149.592041015625, 59.771240234375 ], [ 149.033493041992188, 59.631553649902344 ], [ 149.209060668945312, 59.468948364257812 ], [ 148.743011474609375, 59.491661071777344 ], [ 148.721771240234375, 59.369991302490234 ], [ 148.962188720703125, 59.380130767822266 ], [ 148.898040771484375, 59.239158630371094 ], [ 148.411026000976562, 59.262424468994141 ], [ 148.212738037109375, 59.41888427734375 ], [ 147.4891357421875, 59.239715576171875 ], [ 146.51165771484375, 59.461105346679688 ], [ 146.325241088867188, 59.390621185302734 ], [ 146.314544677734375, 59.182491302490234 ], [ 145.990509033203125, 59.148880004882812 ], [ 145.797470092773438, 59.265132904052734 ], [ 145.908447265625, 59.413322448730469 ], [ 145.66558837890625, 59.424652099609375 ], [ 143.211090087890625, 59.376655578613281 ], [ 142.58746337890625, 59.237770080566406 ], [ 140.790252685546875, 58.308464050292969 ], [ 140.501220703125, 57.826522827148438 ], [ 138.65277099609375, 56.985549926757812 ], [ 137.725799560546875, 56.174995422363281 ], [ 135.21746826171875, 54.930274963378906 ], [ 135.261383056640625, 54.720542907714844 ], [ 135.730941772460938, 54.571659088134766 ], [ 136.812179565429688, 54.650199890136719 ], [ 136.805526733398438, 54.131660461425781 ], [ 136.654006958007812, 53.919574737548828 ], [ 136.76080322265625, 53.768600463867188 ], [ 137.175537109375, 53.838047027587891 ], [ 137.28265380859375, 54.037704467773438 ], [ 137.063278198242188, 54.137496948242188 ], [ 137.19244384765625, 54.217491149902344 ], [ 137.741134643554688, 54.307422637939453 ], [ 137.29327392578125, 54.074996948242188 ], [ 137.855789184570312, 53.961936950683594 ], [ 137.212112426757812, 53.582008361816406 ], [ 137.345245361328125, 53.5252685546875 ], [ 137.89892578125, 53.573257446289062 ], [ 138.553863525390625, 53.989433288574219 ], [ 138.57135009765625, 53.814994812011719 ], [ 138.239547729492188, 53.559295654296875 ], [ 138.465240478515625, 53.521102905273438 ], [ 138.770263671875, 54.004714965820312 ], [ 138.703582763671875, 54.313323974609375 ], [ 139.3369140625, 54.183326721191406 ], [ 139.801849365234375, 54.292354583740234 ], [ 140.240203857421875, 54.049991607666016 ], [ 140.255874633789062, 53.862632751464844 ], [ 140.55523681640625, 53.647773742675781 ], [ 141.414825439453125, 53.293609619140625 ], [ 141.435806274414062, 53.153739929199219 ], [ 141.178314208984375, 52.981376647949219 ], [ 140.713333129882812, 53.115756988525391 ], [ 141.282745361328125, 52.716384887695312 ], [ 141.124267578125, 52.430545806884766 ], [ 141.506927490234375, 52.211799621582031 ], [ 141.3096923828125, 52.033050537109375 ], [ 141.422683715820312, 51.923046112060547 ], [ 140.908309936523438, 51.612354278564453 ], [ 140.461624145507812, 50.701797485351562 ], [ 140.516220092773438, 50.17144775390625 ], [ 140.689727783203125, 50.090095520019531 ], [ 140.410675048828125, 49.865547180175781 ], [ 140.55389404296875, 49.556797027587891 ], [ 140.3399658203125, 49.271934509277344 ], [ 140.38873291015625, 48.965824127197266 ], [ 140.17608642578125, 48.450126647949219 ], [ 139.284011840820312, 47.814300537109375 ], [ 138.55523681640625, 47.018882751464844 ], [ 138.062469482421875, 46.181102752685547 ], [ 135.891921997070312, 44.401729583740234 ], [ 135.422332763671875, 43.756107330322266 ], [ 133.94024658203125, 42.891380310058594 ], [ 133.15484619140625, 42.682632446289062 ], [ 132.461898803710938, 42.933601379394531 ], [ 132.31121826171875, 42.846378326416016 ], [ 132.351348876953125, 43.292285919189453 ], [ 131.9488525390625, 43.063743591308594 ], [ 131.844696044921875, 43.083255767822266 ], [ 132.050796508789062, 43.313045501708984 ], [ 131.810516357421875, 43.325553894042969 ], [ 131.223159790039062, 42.558322906494141 ], [ 130.714202880859375, 42.685615539550781 ], [ 130.869049072265625, 42.523807525634766 ], [ 130.723846435546875, 42.307910919189453 ], [ 130.420806884765625, 42.311935424804688 ], [ 129.760528564453125, 41.730545043945312 ], [ 129.702041625976562, 40.8306884765625 ], [ 127.517631530761719, 39.739574432373047 ], [ 127.560188293457031, 39.311138153076172 ], [ 127.374687194824219, 39.372215270996094 ], [ 127.399711608886719, 39.195270538330078 ], [ 128.36273193359375, 38.676864624023438 ], [ 129.429443359375, 37.059856414794922 ], [ 129.39202880859375, 36.022823333740234 ], [ 129.586868286132812, 36.003856658935547 ], [ 129.23748779296875, 35.189903259277344 ], [ 128.57275390625, 35.169990539550781 ], [ 128.382064819335938, 35.039165496826172 ], [ 128.501373291015625, 35.008331298828125 ], [ 128.405960083007812, 34.832771301269531 ], [ 128.3349609375, 34.946517944335938 ], [ 127.597068786621094, 34.940128326416016 ], [ 127.745811462402344, 34.72540283203125 ], [ 127.637901306152344, 34.615966796875 ], [ 127.418319702148438, 34.818603515625 ], [ 127.512763977050781, 34.590824127197266 ], [ 127.389427185058594, 34.471099853515625 ], [ 127.126220703125, 34.551380157470703 ], [ 127.335121154785156, 34.740131378173828 ], [ 126.889427185058594, 34.412490844726562 ], [ 126.780746459960938, 34.585407257080078 ], [ 126.597206115722656, 34.299854278564453 ], [ 126.478317260742188, 34.345268249511719 ], [ 126.292137145996094, 34.745758056640625 ], [ 126.45166015625, 34.578048706054688 ], [ 126.660263061523438, 34.810131072998047 ], [ 126.375564575195312, 34.7913818359375 ], [ 126.43359375, 34.963607788085938 ], [ 126.248733520507812, 35.113468170166016 ], [ 126.457206726074219, 35.068885803222656 ], [ 126.387496948242188, 35.336936950683594 ], [ 126.684417724609375, 35.533393859863281 ], [ 126.477066040039062, 35.637908935546875 ], [ 126.80108642578125, 35.861663818359375 ], [ 126.6326904296875, 35.965682983398438 ], [ 126.761932373046875, 35.995269775390625 ], [ 126.872016906738281, 36.056247711181641 ], [ 126.544418334960938, 36.136405944824219 ], [ 126.497207641601562, 36.723876953125 ], [ 126.293052673339844, 36.581939697265625 ], [ 126.125816345214844, 36.70721435546875 ], [ 126.294845581054688, 36.962074279785156 ], [ 126.286994934082031, 36.793048858642578 ], [ 126.401092529296875, 36.851936340332031 ], [ 126.345123291015625, 36.991382598876953 ], [ 126.474807739257812, 36.843185424804688 ], [ 126.500816345214844, 37.051246643066406 ], [ 126.772071838378906, 36.967487335205078 ], [ 126.833038330078125, 36.760898590087891 ], [ 126.992202758789062, 36.910820007324219 ], [ 126.754783630371094, 37.04791259765625 ], [ 126.869422912597656, 37.174301147460938 ], [ 126.660957336425781, 37.159015655517578 ], [ 126.861846923828125, 37.265548706054688 ], [ 126.549285888671875, 37.645061492919922 ], [ 126.688491821289062, 37.833908081054688 ], [ 126.388595581054688, 37.887214660644531 ], [ 126.104835510253906, 37.741241455078125 ], [ 125.605262756347656, 38.026100158691406 ], [ 125.72442626953125, 37.910820007324219 ], [ 125.342758178710938, 37.671379089355469 ], [ 125.509712219238281, 37.885547637939453 ], [ 124.982902526855469, 37.933292388916016 ], [ 125.256858825683594, 38.077285766601562 ], [ 124.670051574707031, 38.1195068359375 ], [ 124.993309020996094, 38.586376190185547 ], [ 125.652069091796875, 38.629436492919922 ], [ 125.140541076660156, 38.798118591308594 ], [ 125.450439453125, 39.572357177734375 ], [ 125.120254516601562, 39.558742523193359 ], [ 124.745292663574219, 39.773220062255859 ], [ 124.635879516601562, 39.598011016845703 ], [ 124.323951721191406, 39.9158935546875 ], [ 124.388595581054688, 40.022491455078125 ], [ 124.37359619140625, 40.093620300292969 ], [ 124.128028869628906, 39.827774047851562 ], [ 123.242202758789062, 39.814296722412109 ], [ 123.216659545898438, 39.673881530761719 ], [ 121.648040771484375, 38.996383666992188 ], [ 121.69818115234375, 38.861103057861328 ], [ 121.187339782714844, 38.719085693359375 ], [ 121.088668823242188, 38.912212371826172 ], [ 121.679428100585938, 39.090129852294922 ], [ 121.59942626953125, 39.218597412109375 ], [ 121.7510986328125, 39.351661682128906 ], [ 121.5091552734375, 39.367355346679688 ], [ 121.431663513183594, 39.511665344238281 ], [ 121.228347778320312, 39.528465270996094 ], [ 121.533004760742188, 39.623218536376953 ], [ 121.46832275390625, 39.811378479003906 ], [ 121.880950927734375, 40.0030517578125 ], [ 122.298660278320312, 40.505619049072266 ], [ 122.052131652832031, 40.738742828369141 ], [ 121.177467346191406, 40.92193603515625 ], [ 120.446784973144531, 40.196102142333984 ], [ 119.526443481445312, 39.872421264648438 ], [ 118.971519470214844, 39.156932830810547 ], [ 118.327278137207031, 39.040828704833984 ], [ 118.055259704589844, 39.223045349121094 ], [ 117.799423217773438, 39.1533203125 ], [ 117.536376953125, 38.675552368164062 ], [ 117.672210693359375, 38.38665771484375 ], [ 118.110527038574219, 38.146385192871094 ], [ 118.837760925292969, 38.152904510498047 ], [ 119.035537719726562, 37.878322601318359 ], [ 118.940811157226562, 37.342491149902344 ], [ 119.158866882324219, 37.171104431152344 ], [ 119.7672119140625, 37.151382446289062 ], [ 119.8529052734375, 37.352283477783203 ], [ 120.737068176269531, 37.834991455078125 ], [ 121.579986572265625, 37.424575805664062 ], [ 122.128173828125, 37.552562713623047 ], [ 122.181373596191406, 37.418327331542969 ], [ 122.558578491210938, 37.396244049072266 ], [ 122.597213745117188, 37.209991455078125 ], [ 122.35443115234375, 36.827774047851562 ], [ 121.956649780273438, 37.000274658203125 ], [ 121.594436645507812, 36.758888244628906 ], [ 120.820541381835938, 36.645271301269531 ], [ 120.738235473632812, 36.555408477783203 ], [ 120.959991455078125, 36.526382446289062 ], [ 120.875259399414062, 36.375823974609375 ], [ 120.70623779296875, 36.422771453857422 ], [ 120.695625305175781, 36.1407470703125 ], [ 120.343589782714844, 36.041900634765625 ], [ 120.307807922363281, 36.263446807861328 ], [ 120.088851928710938, 36.199981689453125 ], [ 120.237762451171875, 35.959434509277344 ], [ 119.647453308105469, 35.578926086425781 ], [ 119.200393676757812, 35.029575347900391 ], [ 119.197479248046875, 34.76971435546875 ], [ 120.248733520507812, 34.311450958251953 ], [ 120.885818481445312, 32.974990844726562 ], [ 120.837486267089844, 32.638885498046875 ], [ 121.334846496582031, 32.429576873779297 ], [ 121.441230773925781, 32.113327026367188 ], [ 121.896514892578125, 31.741523742675781 ], [ 121.827476501464844, 31.678329467773438 ], [ 121.291519165039062, 31.870273590087891 ], [ 120.944427490234375, 31.866386413574219 ], [ 120.6019287109375, 32.093605041503906 ], [ 120.099006652832031, 31.945550918579102 ], [ 119.82666015625, 32.306381225585938 ], [ 119.761787414550781, 32.327289581298828 ], [ 119.63165283203125, 32.262771606445312 ], [ 119.885047912597656, 31.991939544677734 ], [ 120.136375427246094, 31.903884887695312 ], [ 120.702621459960938, 31.988327026367188 ], [ 120.719635009765625, 31.819440841674805 ], [ 121.668052673339844, 31.308887481689453 ], [ 121.882766723632812, 30.979856491088867 ], [ 121.846931457519531, 30.853052139282227 ], [ 120.991508483886719, 30.568885803222656 ], [ 120.814422607421875, 30.335552215576172 ], [ 120.458587646484375, 30.392980575561523 ], [ 120.149986267089844, 30.196939468383789 ], [ 120.508186340332031, 30.310274124145508 ], [ 120.791580200195312, 30.06464958190918 ], [ 121.280807495117188, 30.304580688476562 ], [ 121.677757263183594, 29.963050842285156 ], [ 122.119560241699219, 29.882112503051758 ], [ 121.448318481445312, 29.511665344238281 ], [ 121.974357604980469, 29.589162826538086 ], [ 121.93359375, 29.195274353027344 ], [ 121.811920166015625, 29.183883666992188 ], [ 121.796920776367188, 29.372356414794922 ], [ 121.744354248046875, 29.197286605834961 ], [ 121.56109619140625, 29.291107177734375 ], [ 121.413520812988281, 29.163396835327148 ], [ 121.691360473632812, 29.021942138671875 ], [ 121.490814208984375, 28.935897827148438 ], [ 121.611297607421875, 28.72797966003418 ], [ 121.146377563476562, 28.84214973449707 ], [ 121.484428405761719, 28.669925689697266 ], [ 121.64166259765625, 28.347217559814453 ], [ 121.341926574707031, 28.138885498046875 ], [ 121.165122985839844, 28.382774353027344 ], [ 120.935256958007812, 27.982217788696289 ], [ 120.5908203125, 28.079441070556641 ], [ 120.839988708496094, 27.872287750244141 ], [ 120.581161499023438, 27.593191146850586 ], [ 120.665542602539062, 27.450828552246094 ], [ 120.507492065429688, 27.207771301269531 ], [ 120.189559936523438, 27.28277587890625 ], [ 120.421096801757812, 27.147636413574219 ], [ 120.033180236816406, 26.898052215576172 ], [ 120.127960205078125, 26.644647598266602 ], [ 119.860260009765625, 26.517776489257812 ], [ 120.073310852050781, 26.788225173950195 ], [ 119.866783142089844, 26.648883819580078 ], [ 119.78790283203125, 26.796108245849609 ], [ 119.550262451171875, 26.756248474121094 ], [ 119.820404052734375, 26.442216873168945 ], [ 119.577476501464844, 26.473884582519531 ], [ 119.658042907714844, 26.338607788085938 ], [ 119.948867797851562, 26.367774963378906 ], [ 119.425262451171875, 25.996940612792969 ], [ 119.097488403320312, 26.140413284301758 ], [ 119.354011535644531, 25.937875747680664 ], [ 119.705825805664062, 25.990690231323242 ], [ 119.580741882324219, 25.679960250854492 ], [ 119.45220947265625, 25.682218551635742 ], [ 119.645401000976562, 25.353330612182617 ], [ 119.314949035644531, 25.606489181518555 ], [ 119.105262756347656, 25.420967102050781 ], [ 119.352554321289062, 25.253189086914062 ], [ 119.272628784179688, 25.172079086303711 ], [ 118.874870300292969, 25.242599487304688 ], [ 119.011444091796875, 24.947633743286133 ], [ 118.572906494140625, 24.882913589477539 ], [ 118.763114929199219, 24.756732940673828 ], [ 118.622756958007812, 24.543888092041016 ], [ 118.239700317382812, 24.536384582519531 ], [ 118.168800354003906, 24.681938171386719 ], [ 118.019882202148438, 24.440237045288086 ], [ 117.794731140136719, 24.460186004638672 ], [ 118.123725891113281, 24.258747100830078 ], [ 117.763320922851562, 23.917217254638672 ], [ 117.762626647949219, 24.05999755859375 ], [ 117.614700317382812, 23.863609313964844 ], [ 117.304702758789062, 23.758331298828125 ], [ 117.1956787109375, 23.624370574951172 ], [ 116.917938232421875, 23.659187316894531 ], [ 116.760330200195312, 23.354995727539062 ], [ 116.532203674316406, 23.420238494873047 ], [ 116.787071228027344, 23.236660003662109 ], [ 116.513893127441406, 23.210826873779297 ], [ 116.481719970703125, 22.939022064208984 ], [ 115.797760009765625, 22.739162445068359 ], [ 115.640266418457031, 22.884162902832031 ], [ 115.536651611328125, 22.658885955810547 ], [ 115.161376953125, 22.808330535888672 ], [ 114.888893127441406, 22.702774047851562 ], [ 114.936653137207031, 22.649997711181641 ], [ 114.872207641601562, 22.533054351806641 ], [ 114.718048095703125, 22.640274047851562 ], [ 114.778182983398438, 22.814023971557617 ], [ 114.520828247070312, 22.699718475341797 ], [ 114.613594055175781, 22.504232406616211 ], [ 114.222267150878906, 22.550041198730469 ], [ 114.388526916503906, 22.429925918579102 ], [ 114.296104431152344, 22.260560989379883 ], [ 114.198028564453125, 22.31805419921875 ], [ 113.905609130859375, 22.367355346679688 ], [ 114.03369140625, 22.508739471435547 ], [ 113.860809326171875, 22.474437713623047 ], [ 113.523338317871094, 23.016645431518555 ], [ 113.8218994140625, 23.117240905761719 ], [ 113.68359375, 23.152704238891602 ], [ 113.479278564453125, 23.050830841064453 ], [ 113.362899780273438, 22.879858016967773 ], [ 113.564773559570312, 22.549442291259766 ], [ 113.552680969238281, 22.187009811401367 ], [ 113.168731689453125, 22.567008972167969 ], [ 113.386787414550781, 22.179647445678711 ], [ 113.222618103027344, 22.040691375732422 ], [ 113.084846496582031, 22.204854965209961 ], [ 112.940048217773438, 21.869300842285156 ], [ 112.824020385742188, 21.964717864990234 ], [ 112.281936645507812, 21.701385498046875 ], [ 111.892135620117188, 21.916105270385742 ], [ 111.966926574707031, 21.751388549804688 ], [ 111.676231384277344, 21.778192520141602 ], [ 111.783172607421875, 21.612636566162109 ], [ 111.643951416015625, 21.526803970336914 ], [ 111.028457641601562, 21.525276184082031 ], [ 110.532760620117188, 21.211383819580078 ], [ 110.394355773925781, 21.373220443725586 ], [ 110.159355163574219, 20.843814849853516 ], [ 110.375534057617188, 20.840829849243164 ], [ 110.323883056640625, 20.639995574951172 ], [ 110.527351379394531, 20.486175537109375 ], [ 110.27886962890625, 20.246105194091797 ], [ 109.924423217773438, 20.233604431152344 ], [ 110.006866455078125, 20.431800842285156 ], [ 109.66290283203125, 20.924161911010742 ], [ 109.941093444824219, 21.446941375732422 ], [ 109.660469055175781, 21.50568962097168 ], [ 109.573318481445312, 21.72332763671875 ], [ 109.534431457519531, 21.494993209838867 ], [ 109.14276123046875, 21.396663665771484 ], [ 109.137496948242188, 21.583053588867188 ], [ 108.910957336425781, 21.616106033325195 ], [ 108.870246887207031, 21.798885345458984 ], [ 108.740257263183594, 21.598884582519531 ], [ 108.469215393066406, 21.93562126159668 ], [ 108.466239929199219, 21.558746337890625 ], [ 108.333602905273438, 21.689994812011719 ], [ 108.207969665527344, 21.499160766601562 ], [ 107.854843139648438, 21.525552749633789 ], [ 107.594779968261719, 21.292776107788086 ], [ 107.416511535644531, 21.325967788696289 ], [ 107.366928100585938, 21.265274047851562 ], [ 107.370674133300781, 21.025691986083984 ], [ 107.154426574707031, 20.924995422363281 ], [ 107.146507263183594, 21.036142349243164 ], [ 106.862625122070312, 20.871177673339844 ], [ 106.791374206542969, 21.02610969543457 ], [ 106.646652221679688, 21.021663665771484 ], [ 106.776931762695312, 20.699161529541016 ], [ 106.597213745117188, 20.632591247558594 ], [ 106.527626037597656, 20.240133285522461 ], [ 105.956794738769531, 19.923049926757812 ], [ 105.638565063476562, 18.890653610229492 ], [ 106.509918212890625, 17.956111907958984 ], [ 106.42498779296875, 17.741661071777344 ], [ 106.698867797851562, 17.39971923828125 ], [ 107.811508178710938, 16.312009811401367 ], [ 108.188583374023438, 16.199161529541016 ], [ 108.201164245605469, 15.999441146850586 ], [ 108.246574401855469, 16.15437126159668 ], [ 108.330825805664062, 16.150413513183594 ], [ 108.305816650390625, 15.948331832885742 ], [ 108.624977111816406, 15.482219696044922 ], [ 108.82916259765625, 15.421942710876465 ], [ 109.461860656738281, 12.860969543457031 ], [ 109.197334289550781, 12.631525993347168 ], [ 109.346931457519531, 12.394928932189941 ], [ 109.146995544433594, 12.432082176208496 ], [ 109.269989013671875, 11.892498016357422 ], [ 109.183113098144531, 12.116941452026367 ], [ 109.221099853515625, 11.756109237670898 ], [ 109.021682739257812, 11.36225414276123 ], [ 107.266189575195312, 10.376129150390625 ], [ 106.998580932617188, 10.655061721801758 ], [ 106.967147827148438, 10.474618911743164 ], [ 106.904136657714844, 10.631385803222656 ], [ 106.763031005859375, 10.680551528930664 ], [ 106.591552734375, 10.429691314697266 ], [ 106.732467651367188, 10.47048282623291 ], [ 106.78424072265625, 10.279789924621582 ], [ 106.42431640625, 10.311384201049805 ], [ 106.778030395507812, 10.082359313964844 ], [ 106.603858947753906, 9.974094390869141 ], [ 106.296630859375, 10.254998207092285 ], [ 106.688438415527344, 9.893887519836426 ], [ 106.60711669921875, 9.810866355895996 ], [ 106.11480712890625, 10.234067916870117 ], [ 106.570671081542969, 9.741386413574219 ], [ 106.54302978515625, 9.583608627319336 ], [ 106.398452758789062, 9.532360076904297 ], [ 105.823715209960938, 10.004223823547363 ], [ 106.194541931152344, 9.36846923828125 ], [ 105.53387451171875, 9.129441261291504 ], [ 105.121299743652344, 8.625065803527832 ], [ 104.742752075195312, 8.604997634887695 ], [ 104.92254638671875, 8.745205879211426 ], [ 104.798934936523438, 8.792220115661621 ], [ 104.880531311035156, 9.764443397521973 ], [ 105.112747192382812, 9.854788780212402 ], [ 104.981773376464844, 10.10444164276123 ], [ 104.610237121582031, 10.168888092041016 ], [ 104.251289367675781, 10.566178321838379 ], [ 103.634986877441406, 10.490205764770508 ], [ 103.516082763671875, 10.638053894042969 ], [ 103.71942138671875, 10.88749885559082 ], [ 103.555656433105469, 11.155345916748047 ], [ 103.348861694335938, 10.884721755981445 ], [ 103.12969970703125, 10.883052825927734 ], [ 102.960250854492188, 11.54416561126709 ], [ 103.076393127441406, 11.712739944458008 ], [ 102.895881652832031, 11.82676887512207 ], [ 102.935653686523438, 11.591386795043945 ], [ 102.641517639160156, 12.17499828338623 ], [ 102.3377685546875, 12.195276260375977 ], [ 102.355743408203125, 12.358676910400391 ], [ 102.243461608886719, 12.306525230407715 ], [ 102.060676574707031, 12.566247940063477 ], [ 101.756584167480469, 12.704997062683105 ], [ 100.932212829589844, 12.611387252807617 ], [ 100.976348876953125, 13.462808609008789 ], [ 100.222213745117188, 13.468330383300781 ], [ 99.956787109375, 13.29107666015625 ], [ 100.104011535644531, 13.044720649719238 ], [ 99.961654663085938, 12.674442291259766 ], [ 100.020820617675781, 12.194649696350098 ], [ 99.15081787109375, 10.364718437194824 ], [ 99.237205505371094, 9.257289886474609 ], [ 99.84539794921875, 9.300414085388184 ], [ 99.958602905273438, 8.625274658203125 ], [ 100.238021850585938, 8.406665802001953 ], [ 100.578094482421875, 7.220138072967529 ], [ 100.207618713378906, 7.777360439300537 ], [ 100.182884216308594, 7.515554904937744 ], [ 100.424827575683594, 7.157776832580566 ], [ 100.590545654296875, 7.209120273590088 ], [ 101.025527954101562, 6.847221374511719 ], [ 101.545539855957031, 6.848471164703369 ], [ 101.786781311035156, 6.477082252502441 ], [ 102.333877563476562, 6.175554275512695 ], [ 103.181922912597656, 5.282776832580566 ], [ 103.49371337890625, 4.308749198913574 ], [ 103.33636474609375, 3.744096755981445 ], [ 103.476425170898438, 3.498680114746094 ], [ 103.438018798828125, 2.925832986831665 ], [ 103.820243835449219, 2.575902462005615 ], [ 104.253593444824219, 1.633333206176758 ], [ 104.211639404296875, 1.340624809265137 ], [ 103.958511352539062, 1.644305229187012 ], [ 103.998512268066406, 1.435694098472595 ], [ 103.824897766113281, 1.475971937179565 ], [ 103.683494567871094, 1.445554971694946 ], [ 103.512138366699219, 1.269528150558472 ], [ 103.374549865722656, 1.533471941947937 ], [ 101.285736083984375, 2.843541145324707 ], [ 101.290107727050781, 3.274860620498657 ], [ 100.697044372558594, 3.910416126251221 ], [ 100.868507385253906, 4.022360324859619 ], [ 100.601913452148438, 4.221665382385254 ], [ 100.60552978515625, 4.798332214355469 ], [ 100.362319946289062, 5.084373950958252 ], [ 100.35552978515625, 5.963888168334961 ], [ 100.090179443359375, 6.533436298370361 ], [ 99.683868408203125, 6.882777214050293 ], [ 99.745681762695312, 7.117915630340576 ], [ 99.390823364257812, 7.301665782928467 ], [ 99.259811401367188, 7.655801773071289 ], [ 98.771934509277344, 8.018471717834473 ], [ 98.6558837890625, 8.379928588867188 ], [ 98.436294555664062, 8.147984504699707 ], [ 98.274154663085938, 8.274442672729492 ], [ 98.328048706054688, 9.207498550415039 ], [ 98.745399475097656, 10.32763671875 ], [ 98.551399230957031, 9.986907005310059 ], [ 98.460746765136719, 10.728747367858887 ], [ 98.709426879882812, 10.916247367858887 ], [ 98.747200012207031, 11.674859046936035 ], [ 98.88372802734375, 11.697219848632812 ], [ 98.598457336425781, 11.749303817749023 ], [ 98.7208251953125, 12.013887405395508 ], [ 98.70587158203125, 12.224465370178223 ], [ 98.533729553222656, 12.254640579223633 ], [ 98.703590393066406, 12.340045928955078 ], [ 98.580337524414062, 13.17833137512207 ], [ 98.186233520507812, 14.054997444152832 ], [ 98.14068603515625, 13.538192749023438 ], [ 98.087211608886719, 14.17986011505127 ], [ 97.797256469726562, 14.881961822509766 ], [ 97.724571228027344, 15.846664428710938 ], [ 97.569709777832031, 16.065204620361328 ], [ 97.737289428710938, 16.560764312744141 ], [ 97.378036499023438, 16.4949951171875 ], [ 96.878036499023438, 17.449996948242188 ], [ 96.77777099609375, 16.703884124755859 ], [ 96.377479553222656, 16.502498626708984 ], [ 96.241928100585938, 16.803733825683594 ], [ 96.268325805664062, 16.389717102050781 ], [ 96.006805419921875, 16.383068084716797 ], [ 95.4285888671875, 15.729719161987305 ], [ 95.278045654296875, 15.789998054504395 ], [ 95.365402221679688, 15.991942405700684 ], [ 95.360603332519531, 16.141452789306641 ], [ 95.217559814453125, 15.786316871643066 ], [ 95.13720703125, 16.137218475341797 ], [ 95.040611267089844, 15.808331489562988 ], [ 94.848182678222656, 15.782151222229004 ], [ 94.988517761230469, 16.236175537109375 ], [ 94.657073974609375, 15.850831031799316 ], [ 94.791656494140625, 16.148662567138672 ], [ 94.563735961914062, 15.93860912322998 ], [ 94.680953979492188, 16.123884201049805 ], [ 94.6866455078125, 16.189579010009766 ], [ 94.642768859863281, 16.337913513183594 ], [ 94.250961303710938, 15.95888614654541 ], [ 94.232765197753906, 16.350830078125 ], [ 94.612342834472656, 17.547426223754883 ], [ 94.23858642578125, 18.737773895263672 ], [ 94.03839111328125, 18.847078323364258 ], [ 94.051292419433594, 19.221565246582031 ], [ 93.874305725097656, 19.255973815917969 ], [ 93.978248596191406, 19.362634658813477 ], [ 93.985710144042969, 19.457145690917969 ], [ 93.60040283203125, 19.717493057250977 ], [ 93.724357604980469, 19.932426452636719 ], [ 93.137870788574219, 20.065725326538086 ], [ 93.242965698242188, 19.831802368164062 ], [ 93.100547790527344, 19.975828170776367 ], [ 93.126640319824219, 19.839302062988281 ], [ 92.981925964355469, 20.074441909790039 ], [ 93.109153747558594, 20.171245574951172 ], [ 92.994148254394531, 20.149299621582031 ], [ 93.082077026367188, 20.53919792175293 ], [ 92.867683410644531, 20.119510650634766 ], [ 92.769775390625, 20.203224182128906 ], [ 92.891937255859375, 20.322772979736328 ], [ 92.796096801757812, 20.489994049072266 ], [ 92.644325256347656, 20.685829162597656 ], [ 92.737197875976562, 20.263191223144531 ], [ 92.261932373046875, 21.054309844970703 ], [ 92.300537109375, 20.760274887084961 ], [ 92.048042297363281, 21.164995193481445 ], [ 92.0394287109375, 21.660274505615234 ], [ 91.704437255859375, 22.480548858642578 ], [ 91.455825805664062, 22.789997100830078 ], [ 91.230674743652344, 22.586385726928711 ], [ 90.831520080566406, 22.688327789306641 ], [ 90.624565124511719, 23.058401107788086 ], [ 90.709640502929688, 23.549650192260742 ], [ 90.473602294921875, 23.575828552246094 ], [ 90.548042297363281, 23.384302139282227 ], [ 90.310806274414062, 23.435829162597656 ], [ 90.613182067871094, 23.218328475952148 ], [ 90.424400329589844, 22.77018928527832 ], [ 90.617340087890625, 22.344997406005859 ], [ 90.435951232910156, 22.073051452636719 ], [ 90.401382446289062, 22.260555267333984 ], [ 90.269989013671875, 21.846940994262695 ], [ 90.0233154296875, 21.863468170166016 ], [ 90.238449096679688, 22.182842254638672 ], [ 90.048141479492188, 21.983022689819336 ], [ 90.074089050292969, 22.158884048461914 ], [ 89.915817260742188, 22.037220001220703 ], [ 90.0, 22.48375129699707 ], [ 89.841377258300781, 22.260969161987305 ], [ 89.883735656738281, 21.894647598266602 ], [ 89.581100463867188, 21.70166015625 ], [ 89.615119934082031, 22.319580078125 ], [ 89.528251647949219, 21.990690231323242 ], [ 89.534042358398438, 22.063930511474609 ], [ 89.474708557128906, 22.289163589477539 ], [ 89.418243408203125, 21.713813781738281 ], [ 89.35498046875, 21.966035842895508 ], [ 89.207450866699219, 21.652183532714844 ], [ 89.054458618164062, 22.129405975341797 ], [ 89.084365844726562, 21.625204086303711 ], [ 88.712005615234375, 21.562288284301758 ], [ 88.676780700683594, 22.197147369384766 ], [ 88.572219848632812, 21.55999755859375 ], [ 88.500267028808594, 21.948049545288086 ], [ 88.450401306152344, 21.611385345458984 ], [ 88.30633544921875, 21.610586166381836 ], [ 88.29547119140625, 21.776594161987305 ], [ 88.261207580566406, 21.796915054321289 ], [ 88.257492065429688, 21.548746109008789 ], [ 88.199256896972656, 22.151905059814453 ], [ 87.906097412109375, 22.420412063598633 ], [ 88.166519165039062, 22.089719772338867 ], [ 87.796371459960938, 21.698883056640625 ], [ 86.96331787109375, 21.381938934326172 ], [ 86.828048706054688, 21.152496337890625 ], [ 87.025558471679688, 20.674827575683594 ], [ 86.421226501464844, 19.984926223754883 ], [ 86.196365356445312, 20.074996948242188 ], [ 86.355255126953125, 19.965827941894531 ], [ 85.451385498046875, 19.660274505615234 ], [ 85.575004577636719, 19.835481643676758 ], [ 85.434883117675781, 19.887008666992188 ], [ 85.125190734863281, 19.507284164428711 ], [ 85.249443054199219, 19.649532318115234 ], [ 85.382492065429688, 19.612495422363281 ], [ 84.726585388183594, 19.124000549316406 ], [ 84.115882873535156, 18.302080154418945 ], [ 82.362068176269531, 17.098329544067383 ], [ 82.30169677734375, 16.583053588867188 ], [ 81.727264404296875, 16.310829162597656 ], [ 81.321014404296875, 16.367080688476562 ], [ 81.013336181640625, 15.783435821533203 ], [ 80.882621765136719, 16.011941909790039 ], [ 80.825271606445312, 15.751943588256836 ], [ 80.684707641601562, 15.899999618530273 ], [ 80.279434204101562, 15.699165344238281 ], [ 80.049079895019531, 15.055553436279297 ], [ 80.30914306640625, 13.438053131103516 ], [ 80.152481079101562, 13.718053817749023 ], [ 80.049423217773438, 13.620553016662598 ], [ 80.348739624023438, 13.342636108398438 ], [ 80.160263061523438, 12.473052978515625 ], [ 79.764297485351562, 11.656249046325684 ], [ 79.858108520507812, 10.285831451416016 ], [ 79.324356079101562, 10.279929161071777 ], [ 78.943313598632812, 9.598331451416016 ], [ 79.0091552734375, 9.3316650390625 ], [ 79.3316650390625, 9.264165878295898 ], [ 79.44622802734375, 9.159928321838379 ], [ 78.967903137207031, 9.273331642150879 ], [ 78.409988403320312, 9.096942901611328 ], [ 78.192474365234375, 8.904165267944336 ], [ 78.062065124511719, 8.366247177124023 ], [ 77.536102294921875, 8.071943283081055 ], [ 76.99859619140625, 8.365274429321289 ], [ 76.575820922851562, 8.876941680908203 ], [ 76.663734436035156, 9.003817558288574 ], [ 76.534149169921875, 8.964998245239258 ], [ 76.380264282226562, 9.281387329101562 ], [ 76.244422912597656, 9.961213111877441 ], [ 76.352897644042969, 9.526387214660645 ], [ 76.498870849609375, 9.530415534973145 ], [ 75.717758178710938, 11.365274429321289 ], [ 75.193870544433594, 12.010137557983398 ], [ 74.855255126953125, 12.754997253417969 ], [ 74.41192626953125, 14.483331680297852 ], [ 74.097969055175781, 14.787463188171387 ], [ 73.788597106933594, 15.398990631103516 ], [ 73.949501037597656, 15.398541450500488 ], [ 73.447479248046875, 16.058609008789062 ], [ 72.853866577148438, 18.660552978515625 ], [ 73.054183959960938, 19.004716873168945 ], [ 72.773216247558594, 18.945932388305664 ], [ 72.779014587402344, 19.310552597045898 ], [ 73.042625427246094, 19.21104621887207 ], [ 72.753746032714844, 19.372772216796875 ], [ 72.664154052734375, 19.870830535888672 ], [ 72.934417724609375, 20.77471923828125 ], [ 72.564849853515625, 21.375064849853516 ], [ 73.127128601074219, 21.757844924926758 ], [ 72.546028137207031, 21.663883209228516 ], [ 72.722625732421875, 21.990131378173828 ], [ 72.501655578613281, 21.974924087524414 ], [ 72.580680847167969, 22.198329925537109 ], [ 72.914772033691406, 22.271108627319336 ], [ 72.155189514160156, 22.281246185302734 ], [ 72.325408935546875, 22.151523590087891 ], [ 72.038902282714844, 21.939022064208984 ], [ 72.163177490234375, 21.837356567382812 ], [ 71.998313903808594, 21.853885650634766 ], [ 72.289154052734375, 21.610828399658203 ], [ 72.108100891113281, 21.204092025756836 ], [ 70.825126647949219, 20.695966720581055 ], [ 70.060806274414062, 21.144439697265625 ], [ 68.945953369140625, 22.289302825927734 ], [ 69.071380615234375, 22.480756759643555 ], [ 69.220390319824219, 22.273956298828125 ], [ 70.16998291015625, 22.550830841064453 ], [ 70.509719848632812, 23.098190307617188 ], [ 69.71026611328125, 22.742771148681641 ], [ 68.752487182617188, 23.089164733886719 ], [ 68.404151916503906, 23.512636184692383 ], [ 68.741363525390625, 23.844161987304688 ], [ 68.255683898925781, 23.579580307006836 ], [ 68.157379150390625, 23.891868591308594 ], [ 68.15081787109375, 23.68804931640625 ], [ 68.015625, 23.935205459594727 ], [ 68.019439697265625, 23.766456604003906 ], [ 67.519218444824219, 23.876548767089844 ], [ 67.151100158691406, 24.613052368164062 ], [ 67.235397338867188, 24.772914886474609 ], [ 66.651374816894531, 24.82853889465332 ], [ 66.732757568359375, 25.197494506835938 ], [ 66.438034057617188, 25.593330383300781 ], [ 66.144142150878906, 25.507272720336914 ], [ 66.500053405761719, 25.403814315795898 ], [ 64.762908935546875, 25.320550918579102 ], [ 64.648735046386719, 25.162494659423828 ], [ 64.093666076660156, 25.328468322753906 ], [ 64.117347717285156, 25.453187942504883 ], [ 63.429161071777344, 25.214996337890625 ], [ 62.556938171386719, 25.259443283081055 ], [ 61.760829925537109, 25.032081604003906 ], [ 61.782875061035156, 25.174211502075195 ], [ 61.396240234375, 25.080829620361328 ], [ 60.622631072998047, 25.269857406616211 ], [ 60.55096435546875, 25.441106796264648 ], [ 60.410270690917969, 25.397773742675781 ], [ 60.466796875, 25.265970230102539 ], [ 58.128185272216797, 25.542913436889648 ], [ 57.951240539550781, 25.699993133544922 ], [ 57.319091796875, 25.771455764770508 ], [ 57.202217102050781, 25.991661071777344 ] ] ], [ [ [ 91.931655883789062, 77.599716186523438 ], [ 91.779983520507812, 77.6241455078125 ], [ 91.739982604980469, 77.643600463867188 ], [ 92.037696838378906, 77.626228332519531 ], [ 91.931655883789062, 77.599716186523438 ] ] ], [ [ [ 82.167694091796875, 77.51580810546875 ], [ 82.443862915039062, 77.510269165039062 ], [ 82.577629089355469, 77.470268249511719 ], [ 82.123031616210938, 77.50262451171875 ], [ 82.167694091796875, 77.51580810546875 ] ] ], [ [ [ 106.523712158203125, 77.386917114257812 ], [ 106.73193359375, 77.466384887695312 ], [ 106.904159545898438, 77.444976806640625 ], [ 106.646652221679688, 77.376083374023438 ], [ 106.523712158203125, 77.386917114257812 ] ] ], [ [ [ 107.35443115234375, 77.228866577148438 ], [ 107.203109741210938, 77.234428405761719 ], [ 107.414993286132812, 77.356643676757812 ], [ 107.689697265625, 77.26416015625 ], [ 107.35443115234375, 77.228866577148438 ] ] ], [ [ [ 89.167831420898438, 77.1644287109375 ], [ 89.143600463867188, 77.238037109375 ], [ 89.263046264648438, 77.296371459960938 ], [ 89.6845703125, 77.281097412109375 ], [ 89.167831420898438, 77.1644287109375 ] ] ], [ [ [ 96.520858764648438, 77.201583862304688 ], [ 96.166091918945312, 76.989151000976562 ], [ 95.231239318847656, 76.996658325195312 ], [ 95.593048095703125, 77.078048706054688 ], [ 96.520858764648438, 77.201583862304688 ] ] ], [ [ [ 88.934402465820312, 77.141006469726562 ], [ 88.645545959472656, 77.1029052734375 ], [ 88.783050537109375, 77.004989624023438 ], [ 88.627197265625, 77.076095581054688 ], [ 88.650543212890625, 77.119140625 ], [ 88.710540771484375, 77.13916015625 ], [ 88.934402465820312, 77.141006469726562 ] ] ], [ [ [ 156.496856689453125, 77.147064208984375 ], [ 156.677459716796875, 77.140548706054688 ], [ 156.731765747070312, 77.122756958007812 ], [ 156.436355590820312, 77.132064819335938 ], [ 156.496856689453125, 77.147064208984375 ] ] ], [ [ [ 96.343246459960938, 76.916549682617188 ], [ 96.221923828125, 76.885818481445312 ], [ 95.9427490234375, 76.9063720703125 ], [ 96.18719482421875, 76.938308715820312 ], [ 96.343246459960938, 76.916549682617188 ] ] ], [ [ [ 97.851654052734375, 76.766098022460938 ], [ 97.739974975585938, 76.812759399414062 ], [ 97.72943115234375, 76.818328857421875 ], [ 97.91943359375, 76.83831787109375 ], [ 97.851654052734375, 76.766098022460938 ] ] ], [ [ [ 97.439697265625, 76.733596801757812 ], [ 97.359420776367188, 76.749420166015625 ], [ 97.105125427246094, 76.76416015625 ], [ 97.615814208984375, 76.776382446289062 ], [ 97.439697265625, 76.733596801757812 ] ] ], [ [ [ 148.401123046875, 76.634201049804688 ], [ 148.746612548828125, 76.745819091796875 ], [ 149.314422607421875, 76.75360107421875 ], [ 149.168853759765625, 76.650543212890625 ], [ 148.401123046875, 76.634201049804688 ] ] ], [ [ [ 97.519989013671875, 76.580825805664062 ], [ 97.317489624023438, 76.603179931640625 ], [ 97.440536499023438, 76.714996337890625 ], [ 97.519989013671875, 76.580825805664062 ] ] ], [ [ [ 95.648452758789062, 76.673416137695312 ], [ 95.831382751464844, 76.681785583496094 ], [ 95.497207641601562, 76.647216796875 ], [ 95.412765502929688, 76.69970703125 ], [ 95.648452758789062, 76.673416137695312 ] ] ], [ [ [ 95.12408447265625, 76.712356567382812 ], [ 95.324432373046875, 76.657073974609375 ], [ 94.814704895019531, 76.645545959472656 ], [ 95.0716552734375, 76.679428100585938 ], [ 95.12408447265625, 76.712356567382812 ] ] ], [ [ [ 96.464080810546875, 76.706008911132812 ], [ 96.242202758789062, 76.609710693359375 ], [ 95.890548706054688, 76.617897033691406 ], [ 95.973312377929688, 76.672210693359375 ], [ 96.464080810546875, 76.706008911132812 ] ] ], [ [ [ 112.574996948242188, 76.441925048828125 ], [ 112.424697875976562, 76.45526123046875 ], [ 111.956649780273438, 76.598602294921875 ], [ 112.507217407226562, 76.627471923828125 ], [ 112.713600158691406, 76.513740539550781 ], [ 112.574996948242188, 76.441925048828125 ] ] ], [ [ [ 93.951812744140625, 76.609817504882812 ], [ 94.294143676757812, 76.585540771484375 ], [ 94.357208251953125, 76.574432373046875 ], [ 93.872200012207031, 76.589157104492188 ], [ 93.951812744140625, 76.609817504882812 ] ] ], [ [ [ 113.118759155273438, 76.3699951171875 ], [ 113.258880615234375, 76.436370849609375 ], [ 113.44219970703125, 76.363868713378906 ], [ 113.306930541992188, 76.359146118164062 ], [ 113.118759155273438, 76.3699951171875 ] ] ], [ [ [ 96.758880615234375, 76.173599243164062 ], [ 96.834426879882812, 76.346939086914062 ], [ 97.073043823242188, 76.30303955078125 ], [ 96.858322143554688, 76.272216796875 ], [ 97.038314819335938, 76.233047485351562 ], [ 96.758880615234375, 76.173599243164062 ] ] ], [ [ [ 96.350540161132812, 76.097488403320312 ], [ 96.176925659179688, 76.152206420898438 ], [ 95.26361083984375, 76.213043212890625 ], [ 95.3458251953125, 76.285537719726562 ], [ 96.339431762695312, 76.303863525390625 ], [ 96.645133972167969, 76.260963439941406 ], [ 96.56915283203125, 76.1502685546875 ], [ 96.362197875976562, 76.26220703125 ], [ 96.350540161132812, 76.097488403320312 ] ] ], [ [ [ 94.751007080078125, 76.254165649414062 ], [ 94.997482299804688, 76.269149780273438 ], [ 94.84027099609375, 76.179428100585938 ], [ 94.411231994628906, 76.207763671875 ], [ 94.751007080078125, 76.254165649414062 ] ] ], [ [ [ 144.925811767578125, 75.458038330078125 ], [ 144.673446655273438, 75.32818603515625 ], [ 144.936370849609375, 75.266242980957031 ], [ 144.348297119140625, 75.04443359375 ], [ 143.365509033203125, 75.067214965820312 ], [ 142.497055053710938, 75.362411499023438 ], [ 143.023162841796875, 75.6845703125 ], [ 142.447479248046875, 75.711105346679688 ], [ 142.1402587890625, 75.5908203125 ], [ 142.2130126953125, 75.333328247070312 ], [ 142.634979248046875, 75.093597412109375 ], [ 143.698516845703125, 74.93719482421875 ], [ 142.487457275390625, 74.8116455078125 ], [ 141.973358154296875, 74.93865966796875 ], [ 142.35614013671875, 74.929420471191406 ], [ 142.1705322265625, 75.004165649414062 ], [ 140.058486938476562, 74.831306457519531 ], [ 139.646942138671875, 74.979156494140625 ], [ 139.462600708007812, 74.928596496582031 ], [ 139.498580932617188, 74.76165771484375 ], [ 139.0960693359375, 74.647216796875 ], [ 138.0252685546875, 74.804428100585938 ], [ 136.86065673828125, 75.352066040039062 ], [ 137.40496826171875, 75.352203369140625 ], [ 137.13177490234375, 75.417343139648438 ], [ 137.2874755859375, 75.59185791015625 ], [ 136.96844482421875, 75.606132507324219 ], [ 137.205230712890625, 75.784149169921875 ], [ 137.740234375, 75.745819091796875 ], [ 137.449981689453125, 75.9547119140625 ], [ 138.832183837890625, 76.220260620117188 ], [ 140.496917724609375, 75.793319702148438 ], [ 140.4791259765625, 75.6361083984375 ], [ 141.055938720703125, 75.642349243164062 ], [ 140.869613647460938, 75.738800048828125 ], [ 140.971893310546875, 76.039154052734375 ], [ 141.612548828125, 76.017036437988281 ], [ 141.35662841796875, 76.1805419921875 ], [ 142.56024169921875, 75.857757568359375 ], [ 143.900543212890625, 75.837203979492188 ], [ 145.382110595703125, 75.515472412109375 ], [ 144.925811767578125, 75.458038330078125 ] ] ], [ [ [ 152.5596923828125, 76.1197509765625 ], [ 152.457321166992188, 76.15985107421875 ], [ 152.80303955078125, 76.1583251953125 ], [ 152.76885986328125, 76.111648559570312 ], [ 152.5596923828125, 76.1197509765625 ] ] ], [ [ [ 140.895538330078125, 76.059494018554688 ], [ 140.9366455078125, 76.135818481445312 ], [ 141.077041625976562, 76.112480163574219 ], [ 141.078857421875, 76.0858154296875 ], [ 140.895538330078125, 76.059494018554688 ] ] ], [ [ [ 97.3372802734375, 76.102081298828125 ], [ 97.026092529296875, 76.0 ], [ 96.695121765136719, 76.007492065429688 ], [ 96.766937255859375, 76.028045654296875 ], [ 97.3372802734375, 76.102081298828125 ] ] ], [ [ [ 82.8922119140625, 75.909423828125 ], [ 82.772491455078125, 75.944427490234375 ], [ 82.258186340332031, 75.962348937988281 ], [ 83.299560546875, 75.938034057617188 ], [ 82.8922119140625, 75.909423828125 ] ] ], [ [ [ 81.636367797851562, 75.92791748046875 ], [ 82.251937866210938, 75.876922607421875 ], [ 82.254020690917969, 75.865959167480469 ], [ 81.550811767578125, 75.923599243164062 ], [ 81.636367797851562, 75.92791748046875 ] ] ], [ [ [ 135.447509765625, 75.374374389648438 ], [ 135.7080078125, 75.849990844726562 ], [ 136.178451538085938, 75.6160888671875 ], [ 135.930267333984375, 75.396102905273438 ], [ 135.447509765625, 75.374374389648438 ] ] ], [ [ [ 140.745941162109375, 75.65185546875 ], [ 140.59661865234375, 75.652206420898438 ], [ 140.519439697265625, 75.702911376953125 ], [ 140.769989013671875, 75.677200317382812 ], [ 140.745941162109375, 75.65185546875 ] ] ], [ [ [ 146.50726318359375, 75.587188720703125 ], [ 146.972198486328125, 75.33831787109375 ], [ 148.38775634765625, 75.416091918945312 ], [ 148.57073974609375, 75.374214172363281 ], [ 148.4464111328125, 75.281723022460938 ], [ 148.578033447265625, 75.21331787109375 ], [ 150.953033447265625, 75.139434814453125 ], [ 150.633575439453125, 74.892623901367188 ], [ 149.69580078125, 74.760818481445312 ], [ 148.256103515625, 74.789154052734375 ], [ 146.074142456054688, 75.223731994628906 ], [ 146.50726318359375, 75.587188720703125 ] ] ], [ [ [ 82.150466918945312, 75.497589111328125 ], [ 82.009719848632812, 75.438873291015625 ], [ 82.289566040039062, 75.334434509277344 ], [ 82.039154052734375, 75.34027099609375 ], [ 82.011932373046875, 75.172210693359375 ], [ 81.495536804199219, 75.354568481445312 ], [ 82.150466918945312, 75.497589111328125 ] ] ], [ [ [ 87.01483154296875, 74.988143920898438 ], [ 87.1361083984375, 74.939010620117188 ], [ 86.690536499023438, 74.901092529296875 ], [ 86.83526611328125, 74.826385498046875 ], [ 86.211105346679688, 74.898605346679688 ], [ 87.01483154296875, 74.988143920898438 ] ] ], [ [ [ 86.467620849609375, 74.818756103515625 ], [ 86.748870849609375, 74.797210693359375 ], [ 86.7833251953125, 74.78082275390625 ], [ 86.599990844726562, 74.7510986328125 ], [ 86.467620849609375, 74.818756103515625 ] ] ], [ [ [ 85.470916748046875, 74.812240600585938 ], [ 85.701934814453125, 74.725540161132812 ], [ 85.097068786621094, 74.751655578613281 ], [ 85.334716796875, 74.770263671875 ], [ 85.470916748046875, 74.812240600585938 ] ] ], [ [ [ 79.164398193359375, 74.605239868164062 ], [ 79.279434204101562, 74.656646728515625 ], [ 79.612197875976562, 74.594985961914062 ], [ 79.49859619140625, 74.518051147460938 ], [ 79.164398193359375, 74.605239868164062 ] ] ], [ [ [ 85.640289306640625, 74.541244506835938 ], [ 85.385269165039062, 74.451095581054688 ], [ 85.145126342773438, 74.527488708496094 ], [ 85.310806274414062, 74.581375122070312 ], [ 85.640289306640625, 74.541244506835938 ] ] ], [ [ [ 85.856369018554688, 74.439697265625 ], [ 85.660957336425781, 74.473594665527344 ], [ 85.8236083984375, 74.570266723632812 ], [ 86.212631225585938, 74.522628784179688 ], [ 85.856369018554688, 74.439697265625 ] ] ], [ [ [ 112.787773132324219, 74.091934204101562 ], [ 112.159416198730469, 74.134719848632812 ], [ 111.455963134765625, 74.321586608886719 ], [ 111.877761840820312, 74.345260620117188 ], [ 112.078872680664062, 74.548599243164062 ], [ 113.41998291015625, 74.42498779296875 ], [ 112.787773132324219, 74.091934204101562 ] ] ], [ [ [ 84.69219970703125, 74.50274658203125 ], [ 84.94219970703125, 74.474296569824219 ], [ 84.374420166015625, 74.452484130859375 ], [ 84.432479858398438, 74.466934204101562 ], [ 84.69219970703125, 74.50274658203125 ] ] ], [ [ [ 85.201217651367188, 74.42138671875 ], [ 85.506378173828125, 74.434707641601562 ], [ 85.585823059082031, 74.417762756347656 ], [ 85.404708862304688, 74.388885498046875 ], [ 85.201217651367188, 74.42138671875 ] ] ], [ [ [ 115.917236328125, 74.295883178710938 ], [ 115.9930419921875, 74.37469482421875 ], [ 116.127197265625, 74.310806274414062 ], [ 116.048027038574219, 74.284988403320312 ], [ 115.917236328125, 74.295883178710938 ] ] ], [ [ [ 140.4486083984375, 73.901611328125 ], [ 140.109954833984375, 74.0313720703125 ], [ 140.09661865234375, 74.188583374023438 ], [ 140.69635009765625, 74.282211303710938 ], [ 141.117050170898438, 74.164985656738281 ], [ 141.020538330078125, 73.992752075195312 ], [ 140.4486083984375, 73.901611328125 ] ] ], [ [ [ 135.4176025390625, 74.24774169921875 ], [ 136.034149169921875, 74.08831787109375 ], [ 136.270965576171875, 73.932754516601562 ], [ 136.07080078125, 73.896942138671875 ], [ 135.4176025390625, 74.24774169921875 ] ] ], [ [ [ 82.564697265625, 74.159317016601562 ], [ 82.733871459960938, 74.095405578613281 ], [ 82.319847106933594, 74.093597412109375 ], [ 82.351654052734375, 74.138046264648438 ], [ 82.564697265625, 74.159317016601562 ] ] ], [ [ [ 82.829421997070312, 74.083633422851562 ], [ 83.202774047851562, 74.14971923828125 ], [ 83.618453979492188, 74.081657409667969 ], [ 83.44970703125, 74.037765502929688 ], [ 82.829421997070312, 74.083633422851562 ] ] ], [ [ [ 83.977508544921875, 74.026046752929688 ], [ 84.396652221679688, 74.043045043945312 ], [ 84.416656494140625, 73.964996337890625 ], [ 83.882209777832031, 74.0101318359375 ], [ 83.977508544921875, 74.026046752929688 ] ] ], [ [ [ 124.509452819824219, 73.83770751953125 ], [ 124.370529174804688, 73.844985961914062 ], [ 124.2894287109375, 73.887626647949219 ], [ 124.660400390625, 73.894851684570312 ], [ 124.509452819824219, 73.83770751953125 ] ] ], [ [ [ 141.160797119140625, 73.877334594726562 ], [ 142.513031005859375, 73.838882446289062 ], [ 143.431915283203125, 73.522491455078125 ], [ 143.505828857421875, 73.230270385742188 ], [ 139.653594970703125, 73.402206420898438 ], [ 140.41607666015625, 73.483047485351562 ], [ 141.160797119140625, 73.877334594726562 ] ] ], [ [ [ 86.878585815429688, 73.623031616210938 ], [ 87.1785888671875, 73.814422607421875 ], [ 87.254440307617188, 73.765823364257812 ], [ 87.089431762695312, 73.663040161132812 ], [ 86.878585815429688, 73.623031616210938 ] ] ], [ [ [ 123.554977416992188, 73.208328247070312 ], [ 123.221786499023438, 73.40179443359375 ], [ 123.373313903808594, 73.659156799316406 ], [ 123.965545654296875, 73.619979858398438 ], [ 123.884696960449219, 73.766098022460938 ], [ 124.358596801757812, 73.8035888671875 ], [ 125.583877563476562, 73.540817260742188 ], [ 125.566238403320312, 73.402488708496094 ], [ 126.317344665527344, 73.543182373046875 ], [ 126.157066345214844, 73.377059936523438 ], [ 126.5302734375, 73.35693359375 ], [ 126.710891723632812, 73.081031799316406 ], [ 126.293869018554688, 72.89971923828125 ], [ 126.381645202636719, 72.795745849609375 ], [ 126.246231079101562, 72.5252685546875 ], [ 126.34832763671875, 72.379974365234375 ], [ 126.165817260742188, 72.301925659179688 ], [ 124.71832275390625, 72.676376342773438 ], [ 122.432350158691406, 72.977180480957031 ], [ 123.181228637695312, 72.917343139648438 ], [ 123.376922607421875, 73.16290283203125 ], [ 123.658866882324219, 73.168045043945312 ], [ 123.554977416992188, 73.208328247070312 ] ] ], [ [ [ 86.896270751953125, 73.693069458007812 ], [ 86.736648559570312, 73.595260620117188 ], [ 86.394989013671875, 73.58831787109375 ], [ 86.535263061523438, 73.645263671875 ], [ 86.896270751953125, 73.693069458007812 ] ] ], [ [ [ 125.792137145996094, 73.506622314453125 ], [ 125.708328247070312, 73.5908203125 ], [ 125.803863525390625, 73.638885498046875 ], [ 125.837196350097656, 73.5252685546875 ], [ 125.792137145996094, 73.506622314453125 ] ] ], [ [ [ 80.336380004882812, 73.5 ], [ 80.135269165039062, 73.524993896484375 ], [ 80.056640625, 73.555816650390625 ], [ 80.403594970703125, 73.546096801757812 ], [ 80.336380004882812, 73.5 ] ] ], [ [ [ 75.306320190429688, 73.4183349609375 ], [ 75.62109375, 73.54998779296875 ], [ 76.074851989746094, 73.560951232910156 ], [ 75.880264282226562, 73.457489013671875 ], [ 75.306320190429688, 73.4183349609375 ] ] ], [ [ [ 76.081436157226562, 73.527511596679688 ], [ 76.21026611328125, 73.553863525390625 ], [ 76.657485961914062, 73.47943115234375 ], [ 76.76422119140625, 73.432342529296875 ], [ 76.081436157226562, 73.527511596679688 ] ] ], [ [ [ 127.400100708007812, 73.517776489257812 ], [ 127.662200927734375, 73.538040161132812 ], [ 128.059005737304688, 73.484428405761719 ], [ 127.675537109375, 73.497756958007812 ], [ 127.400100708007812, 73.517776489257812 ] ] ], [ [ [ 126.771926879882812, 73.076385498046875 ], [ 126.626083374023438, 73.377761840820312 ], [ 127.041656494140625, 73.537765502929688 ], [ 127.976646423339844, 73.470260620117188 ], [ 128.352737426757812, 73.353034973144531 ], [ 128.25762939453125, 73.268051147460938 ], [ 128.966766357421875, 73.166854858398438 ], [ 128.7808837890625, 73.072624206542969 ], [ 129.118560791015625, 73.097763061523438 ], [ 126.589431762695312, 72.535812377929688 ], [ 126.555259704589844, 72.404571533203125 ], [ 126.330963134765625, 72.4779052734375 ], [ 126.445816040039062, 72.789840698242188 ], [ 126.332000732421875, 72.890823364257812 ], [ 126.771926879882812, 73.076385498046875 ] ] ], [ [ [ 69.873504638671875, 73.050552368164062 ], [ 70.063034057617188, 73.23248291015625 ], [ 69.961105346679688, 73.400543212890625 ], [ 70.48553466796875, 73.4930419921875 ], [ 71.247482299804688, 73.45416259765625 ], [ 70.9991455078125, 73.28887939453125 ], [ 71.210540771484375, 73.268051147460938 ], [ 71.454986572265625, 73.346649169921875 ], [ 71.677764892578125, 73.210823059082031 ], [ 69.873504638671875, 73.050552368164062 ] ] ], [ [ [ 126.49224853515625, 73.392059326171875 ], [ 126.468048095703125, 73.443862915039062 ], [ 126.658332824707031, 73.458602905273438 ], [ 126.613029479980469, 73.399436950683594 ], [ 126.49224853515625, 73.392059326171875 ] ] ], [ [ [ 71.143646240234375, 73.33856201171875 ], [ 71.247207641601562, 73.411102294921875 ], [ 71.359146118164062, 73.393325805664062 ], [ 71.2208251953125, 73.281936645507812 ], [ 71.143646240234375, 73.33856201171875 ] ] ], [ [ [ 76.184371948242188, 73.171066284179688 ], [ 76.123588562011719, 73.204154968261719 ], [ 76.736099243164062, 73.150543212890625 ], [ 76.4688720703125, 73.129150390625 ], [ 76.184371948242188, 73.171066284179688 ] ] ], [ [ [ 120.0, 73.038192749023438 ], [ 119.808868408203125, 73.034149169921875 ], [ 119.632614135742188, 73.118034362792969 ], [ 120.2752685546875, 73.095405578613281 ], [ 120.0, 73.038192749023438 ] ] ], [ [ [ 74.0958251953125, 73.026931762695312 ], [ 74.427200317382812, 73.131927490234375 ], [ 74.884994506835938, 73.086654663085938 ], [ 74.962493896484375, 73.05303955078125 ], [ 74.703048706054688, 73.074432373046875 ], [ 74.654434204101562, 72.855819702148438 ], [ 74.0958251953125, 73.026931762695312 ] ] ], [ [ [ 78.67572021484375, 72.90167236328125 ], [ 79.216094970703125, 73.092483520507812 ], [ 79.581100463867188, 72.747337341308594 ], [ 78.604705810546875, 72.80303955078125 ], [ 78.67572021484375, 72.90167236328125 ] ] ], [ [ [ 122.016036987304688, 72.931961059570312 ], [ 122.177467346191406, 72.953598022460938 ], [ 122.374008178710938, 72.894302368164062 ], [ 122.328598022460938, 72.891937255859375 ], [ 122.016036987304688, 72.931961059570312 ] ] ], [ [ [ 128.95635986328125, 72.906646728515625 ], [ 128.782058715820312, 72.912483215332031 ], [ 129.19537353515625, 72.924285888671875 ], [ 129.16302490234375, 72.914154052734375 ], [ 128.95635986328125, 72.906646728515625 ] ] ], [ [ [ 122.317146301269531, 72.944931030273438 ], [ 123.187477111816406, 72.8680419921875 ], [ 123.601791381835938, 72.774993896484375 ], [ 122.752777099609375, 72.82110595703125 ], [ 122.317146301269531, 72.944931030273438 ] ] ], [ [ [ 129.14080810546875, 72.781661987304688 ], [ 128.326904296875, 72.808868408203125 ], [ 128.2919921875, 72.869697570800781 ], [ 129.29803466796875, 72.800262451171875 ], [ 129.14080810546875, 72.781661987304688 ] ] ], [ [ [ 127.31817626953125, 72.650711059570312 ], [ 128.279144287109375, 72.787200927734375 ], [ 129.343505859375, 72.704010009765625 ], [ 129.186920166015625, 72.653594970703125 ], [ 128.634429931640625, 72.700546264648438 ], [ 127.31817626953125, 72.650711059570312 ] ] ], [ [ [ 128.10052490234375, 72.6319580078125 ], [ 128.68829345703125, 72.672210693359375 ], [ 128.972198486328125, 72.5908203125 ], [ 128.6533203125, 72.523605346679688 ], [ 128.10052490234375, 72.6319580078125 ] ] ], [ [ [ 126.675666809082031, 72.428939819335938 ], [ 127.800537109375, 72.641372680664062 ], [ 128.7080078125, 72.464157104492188 ], [ 129.261932373046875, 72.46331787109375 ], [ 129.499282836914062, 72.327491760253906 ], [ 129.355377197265625, 72.254989624023438 ], [ 129.558731079101562, 72.222068786621094 ], [ 128.76361083984375, 72.07415771484375 ], [ 127.549713134765625, 72.433319091796875 ], [ 126.675666809082031, 72.428939819335938 ] ] ], [ [ [ 76.868270874023438, 72.343841552734375 ], [ 77.620254516601562, 72.630538940429688 ], [ 78.391380310058594, 72.485954284667969 ], [ 77.782485961914062, 72.296646118164062 ], [ 76.868270874023438, 72.343841552734375 ] ] ], [ [ [ 126.673309326171875, 72.187484741210938 ], [ 126.527481079101562, 72.29498291015625 ], [ 126.53887939453125, 72.352203369140625 ], [ 126.663597106933594, 72.347900390625 ], [ 126.673309326171875, 72.187484741210938 ] ] ], [ [ [ 127.004501342773438, 72.0 ], [ 127.156631469726562, 71.955825805664062 ], [ 127.174064636230469, 71.939559936523438 ], [ 126.90277099609375, 72.0233154296875 ], [ 127.004501342773438, 72.0 ] ] ], [ [ [ 138.468841552734375, 71.6533203125 ], [ 138.373565673828125, 71.683036804199219 ], [ 138.7210693359375, 71.686370849609375 ], [ 138.663299560546875, 71.673309326171875 ], [ 138.468841552734375, 71.6533203125 ] ] ], [ [ [ -180.0, 70.997207641601562 ], [ -180.0, 71.535842895507812 ], [ -179.62860107421875, 71.577194213867188 ], [ -178.568603515625, 71.56414794921875 ], [ -177.441543579101562, 71.229347229003906 ], [ -177.930435180664062, 71.0394287109375 ], [ -179.274444580078125, 70.907760620117188 ], [ -180.0, 70.997207641601562 ] ] ], [ [ [ 137.964599609375, 71.507965087890625 ], [ 137.676910400390625, 71.411651611328125 ], [ 136.992874145507812, 71.518600463867188 ], [ 137.750274658203125, 71.594436645507812 ], [ 137.964599609375, 71.507965087890625 ] ] ], [ [ [ 180.0, 71.535858154296875 ], [ 180.0, 70.997207641601562 ], [ 178.791015625, 70.796401977539062 ], [ 178.619400024414062, 71.031509399414062 ], [ 180.0, 71.535858154296875 ] ] ], [ [ [ 82.354812622070312, 70.902557373046875 ], [ 82.348602294921875, 70.988311767578125 ], [ 82.5030517578125, 70.958877563476562 ], [ 82.414703369140625, 70.878585815429688 ], [ 82.354812622070312, 70.902557373046875 ] ] ], [ [ [ 83.16314697265625, 70.891830444335938 ], [ 83.071937561035156, 70.936370849609375 ], [ 83.052474975585938, 70.9769287109375 ], [ 83.257080078125, 70.903594970703125 ], [ 83.16314697265625, 70.891830444335938 ] ] ], [ [ [ 160.71978759765625, 70.818511962890625 ], [ 160.469970703125, 70.823883056640625 ], [ 160.407196044921875, 70.91595458984375 ], [ 160.64471435546875, 70.896377563476562 ], [ 160.71978759765625, 70.818511962890625 ] ] ], [ [ [ 83.067611694335938, 70.416259765625 ], [ 83.214157104492188, 70.807205200195312 ], [ 83.45721435546875, 70.744979858398438 ], [ 83.288314819335938, 70.673309326171875 ], [ 83.301651000976562, 70.456375122070312 ], [ 83.067611694335938, 70.416259765625 ] ] ], [ [ [ 161.691680908203125, 70.745407104492188 ], [ 161.648590087890625, 70.748321533203125 ], [ 161.463287353515625, 70.8035888671875 ], [ 161.657745361328125, 70.80859375 ], [ 161.691680908203125, 70.745407104492188 ] ] ], [ [ [ 83.403610229492188, 70.511276245117188 ], [ 83.368316650390625, 70.567764282226562 ], [ 83.572906494140625, 70.572494506835938 ], [ 83.483871459960938, 70.489425659179688 ], [ 83.403610229492188, 70.511276245117188 ] ] ], [ [ [ 83.60650634765625, 70.454360961914062 ], [ 83.533599853515625, 70.377197265625 ], [ 83.37969970703125, 70.364990234375 ], [ 83.558319091796875, 70.52276611328125 ], [ 83.60650634765625, 70.454360961914062 ] ] ], [ [ [ 82.7825927734375, 70.19781494140625 ], [ 82.955551147460938, 70.24609375 ], [ 83.112899780273438, 70.140266418457031 ], [ 82.972488403320312, 70.131088256835938 ], [ 82.7825927734375, 70.19781494140625 ] ] ], [ [ [ 169.4127197265625, 69.763778686523438 ], [ 169.205535888671875, 69.573883056640625 ], [ 168.8682861328125, 69.567764282226562 ], [ 167.751922607421875, 69.827484130859375 ], [ 168.270263671875, 70.020538330078125 ], [ 169.407196044921875, 69.870819091796875 ], [ 169.4127197265625, 69.763778686523438 ] ] ], [ [ [ 161.730499267578125, 69.556610107421875 ], [ 161.654281616210938, 69.629142761230469 ], [ 161.847198486328125, 69.646942138671875 ], [ 161.854537963867188, 69.583740234375 ], [ 161.730499267578125, 69.556610107421875 ] ] ], [ [ [ 161.372467041015625, 69.405853271484375 ], [ 161.428436279296875, 69.459571838378906 ], [ 161.39581298828125, 69.587486267089844 ], [ 161.6221923828125, 69.588592529296875 ], [ 161.6192626953125, 69.449287414550781 ], [ 161.372467041015625, 69.405853271484375 ] ] ], [ [ [ 67.032882690429688, 69.497360229492188 ], [ 67.301651000976562, 69.595260620117188 ], [ 67.366378784179688, 69.539703369140625 ], [ 67.252487182617188, 69.4447021484375 ], [ 67.032882690429688, 69.497360229492188 ] ] ], [ [ [ 161.4227294921875, 68.88677978515625 ], [ 161.469696044921875, 68.987762451171875 ], [ 161.134429931640625, 69.089706420898438 ], [ 161.096343994140625, 69.470535278320312 ], [ 161.375244140625, 69.535820007324219 ], [ 161.320663452148438, 69.237754821777344 ], [ 161.519989013671875, 68.966934204101562 ], [ 161.4227294921875, 68.88677978515625 ] ] ], [ [ [ 67.000625610351562, 69.3934326171875 ], [ 66.939842224121094, 69.446929931640625 ], [ 67.217483520507812, 69.407211303710938 ], [ 67.131088256835938, 69.361373901367188 ], [ 67.000625610351562, 69.3934326171875 ] ] ], [ [ [ 65.9541015625, 69.095962524414062 ], [ 66.233871459960938, 69.074432373046875 ], [ 66.537628173828125, 68.946792602539062 ], [ 66.156646728515625, 69.07110595703125 ], [ 65.9541015625, 69.095962524414062 ] ] ], [ [ [ -169.694961547851562, 66.068061828613281 ], [ -170.45086669921875, 65.9163818359375 ], [ -170.635589599609375, 65.61053466796875 ], [ -171.542388916015625, 65.835548400878906 ], [ -171.02349853515625, 65.579147338867188 ], [ -171.12542724609375, 65.47650146484375 ], [ -172.08251953125, 65.484420776367188 ], [ -171.814041137695312, 65.521095275878906 ], [ -172.802642822265625, 65.674697875976562 ], [ -172.1905517578125, 65.446624755859375 ], [ -172.244720458984375, 65.245513916015625 ], [ -172.683074951171875, 65.227767944335938 ], [ -172.128982543945312, 65.083175659179688 ], [ -172.4647216796875, 64.920257568359375 ], [ -173.045562744140625, 64.863021850585938 ], [ -173.195220947265625, 64.778167724609375 ], [ -172.898529052734375, 64.830375671386719 ], [ -172.773773193359375, 64.779708862304688 ], [ -173.084945678710938, 64.662612915039062 ], [ -172.3558349609375, 64.45831298828125 ], [ -173.025726318359375, 64.496780395507812 ], [ -172.898086547851562, 64.337196350097656 ], [ -173.19140625, 64.254425048828125 ], [ -173.434188842773438, 64.327415466308594 ], [ -173.284317016601562, 64.520538330078125 ], [ -173.415573120117188, 64.616645812988281 ], [ -173.363052368164062, 64.464988708496094 ], [ -173.673080444335938, 64.346794128417969 ], [ -174.84637451171875, 64.77777099609375 ], [ -175.448883056640625, 64.784423828125 ], [ -175.913360595703125, 65.016365051269531 ], [ -175.780609130859375, 65.160797119140625 ], [ -176.07806396484375, 65.470260620117188 ], [ -177.06805419921875, 65.609710693359375 ], [ -178.557388305664062, 65.514152526855469 ], [ -178.456100463867188, 65.72747802734375 ], [ -178.909454345703125, 65.993865966796875 ], [ -178.542510986328125, 66.163314819335938 ], [ -178.526153564453125, 66.402908325195312 ], [ -178.909591674804688, 66.1705322265625 ], [ -179.170989990234375, 66.414848327636719 ], [ -179.175140380859375, 66.291053771972656 ], [ -179.423919677734375, 66.340675354003906 ], [ -179.283782958984375, 66.166786193847656 ], [ -179.689193725585938, 66.183578491210938 ], [ -179.800308227539062, 65.874137878417969 ], [ -179.320831298828125, 65.530120849609375 ], [ -180.0, 65.06890869140625 ], [ -180.0, 68.9801025390625 ], [ -178.923370361328125, 68.768325805664062 ], [ -178.49041748046875, 68.584556579589844 ], [ -178.715576171875, 68.65582275390625 ], [ -178.740402221679688, 68.542892456054688 ], [ -178.035720825195312, 68.423294067382812 ], [ -177.9505615234375, 68.289962768554688 ], [ -177.706130981445312, 68.336647033691406 ], [ -178.376678466796875, 68.550521850585938 ], [ -177.6322021484375, 68.324691772460938 ], [ -177.680328369140625, 68.223876953125 ], [ -175.463623046875, 67.707473754882812 ], [ -175.19110107421875, 67.51080322265625 ], [ -175.3759765625, 67.343040466308594 ], [ -174.833892822265625, 67.386085510253906 ], [ -174.954757690429688, 67.104011535644531 ], [ -174.744598388671875, 66.765678405761719 ], [ -174.994873046875, 66.671989440917969 ], [ -174.506439208984375, 66.55218505859375 ], [ -174.467376708984375, 66.303443908691406 ], [ -174.02435302734375, 66.479827880859375 ], [ -174.036819458007812, 66.213516235351562 ], [ -173.761962890625, 66.449493408203125 ], [ -174.302383422851562, 66.581924438476562 ], [ -173.995849609375, 66.69134521484375 ], [ -174.125274658203125, 66.9891357421875 ], [ -174.651153564453125, 67.06011962890625 ], [ -173.6763916015625, 67.132064819335938 ], [ -173.172943115234375, 67.059005737304688 ], [ -173.35723876953125, 66.839569091796875 ], [ -173.15509033203125, 66.860382080078125 ], [ -173.13641357421875, 66.996627807617188 ], [ -172.436203002929688, 66.937675476074219 ], [ -173.011962890625, 67.056076049804688 ], [ -171.726104736328125, 66.955245971679688 ], [ -170.484207153320312, 66.320404052734375 ], [ -170.637481689453125, 66.239105224609375 ], [ -170.349578857421875, 66.2916259765625 ], [ -170.181884765625, 66.202400207519531 ], [ -170.331253051757812, 66.178733825683594 ], [ -169.694961547851562, 66.068061828613281 ] ] ], [ [ [ 69.823135375976562, 66.488525390625 ], [ 69.41943359375, 66.76971435546875 ], [ 69.126922607421875, 66.791923522949219 ], [ 69.457763671875, 66.798599243164062 ], [ 69.533599853515625, 66.719985961914062 ], [ 69.644989013671875, 66.68719482421875 ], [ 69.541877746582031, 66.755844116210938 ], [ 70.08526611328125, 66.688865661621094 ], [ 70.102485656738281, 66.527763366699219 ], [ 69.823135375976562, 66.488525390625 ] ] ], [ [ [ -172.675994873046875, 64.731246948242188 ], [ -172.43975830078125, 64.861373901367188 ], [ -172.167266845703125, 64.772476196289062 ], [ -172.590576171875, 64.70330810546875 ], [ -172.675994873046875, 64.731246948242188 ] ] ], [ [ [ -172.7503662109375, 64.67144775390625 ], [ -172.532257080078125, 64.661376953125 ], [ -172.490829467773438, 64.6312255859375 ], [ -172.62860107421875, 64.617202758789062 ], [ -172.7503662109375, 64.67144775390625 ] ] ], [ [ [ 163.385528564453125, 58.559402465820312 ], [ 163.691925048828125, 58.7449951171875 ], [ 163.841842651367188, 58.9949951171875 ], [ 163.69940185546875, 59.014442443847656 ], [ 164.55303955078125, 59.237213134765625 ], [ 164.704132080078125, 59.024711608886719 ], [ 164.6513671875, 58.882766723632812 ], [ 163.457183837890625, 58.46527099609375 ], [ 163.385528564453125, 58.559402465820312 ] ] ], [ [ [ 150.454559326171875, 59.017799377441406 ], [ 150.658599853515625, 59.153877258300781 ], [ 150.747467041015625, 59.101936340332031 ], [ 150.534423828125, 59.001388549804688 ], [ 150.454559326171875, 59.017799377441406 ] ] ], [ [ [ 166.246246337890625, 55.329627990722656 ], [ 166.248580932617188, 55.147075653076172 ], [ 166.66400146484375, 54.677494049072266 ], [ 165.8319091796875, 55.303321838378906 ], [ 166.246246337890625, 55.329627990722656 ] ] ], [ [ [ 137.2213134765625, 54.773719787597656 ], [ 137.566925048828125, 55.188880920410156 ], [ 138.20538330078125, 55.040691375732422 ], [ 137.707183837890625, 54.618324279785156 ], [ 137.48663330078125, 54.872489929199219 ], [ 137.2213134765625, 54.773719787597656 ] ] ], [ [ [ 136.667266845703125, 54.905059814453125 ], [ 136.808319091796875, 55.018051147460938 ], [ 137.187881469726562, 55.105411529541016 ], [ 137.04608154296875, 54.917495727539062 ], [ 136.667266845703125, 54.905059814453125 ] ] ], [ [ [ 167.4329833984375, 54.863075256347656 ], [ 167.73358154296875, 54.756942749023438 ], [ 168.112594604492188, 54.509304046630859 ], [ 167.546356201171875, 54.759162902832031 ], [ 167.4329833984375, 54.863075256347656 ] ] ], [ [ [ 137.642791748046875, 54.387451171875 ], [ 137.5496826171875, 54.509857177734375 ], [ 137.614120483398438, 54.5645751953125 ], [ 137.645538330078125, 54.507499694824219 ], [ 137.642791748046875, 54.387451171875 ] ] ], [ [ [ 137.718017578125, 54.380882263183594 ], [ 137.840240478515625, 54.498882293701172 ], [ 137.91387939453125, 54.507774353027344 ], [ 137.8319091796875, 54.392494201660156 ], [ 137.718017578125, 54.380882263183594 ] ] ], [ [ [ 143.431365966796875, 46.019439697265625 ], [ 143.356201171875, 46.559852600097656 ], [ 142.5263671875, 46.6824951171875 ], [ 142.08758544921875, 45.891658782958984 ], [ 141.819427490234375, 46.485824584960938 ], [ 142.05706787109375, 47.078880310058594 ], [ 141.963027954101562, 47.599990844726562 ], [ 142.18768310546875, 47.953952789306641 ], [ 141.85369873046875, 48.757144927978516 ], [ 142.140533447265625, 49.552490234375 ], [ 142.043167114257812, 50.542079925537109 ], [ 142.26776123046875, 51.104438781738281 ], [ 141.648040771484375, 51.88665771484375 ], [ 141.639007568359375, 52.313465118408203 ], [ 141.923431396484375, 53.013187408447266 ], [ 141.770126342773438, 53.367771148681641 ], [ 142.220245361328125, 53.518463134765625 ], [ 142.274688720703125, 53.369712829589844 ], [ 142.47247314453125, 53.386241912841797 ], [ 142.68109130859375, 53.516799926757812 ], [ 142.50177001953125, 53.663463592529297 ], [ 142.799209594726562, 53.703945159912109 ], [ 142.76983642578125, 53.838394165039062 ], [ 142.610458374023438, 53.692558288574219 ], [ 142.720657348632812, 53.927631378173828 ], [ 142.39385986328125, 54.237495422363281 ], [ 142.639434814453125, 54.262771606445312 ], [ 142.713424682617188, 54.424575805664062 ], [ 143.009078979492188, 54.130825042724609 ], [ 142.88134765625, 53.80804443359375 ], [ 143.329132080078125, 52.914436340332031 ], [ 143.30615234375, 52.478256225585938 ], [ 143.199554443359375, 52.345546722412109 ], [ 143.255950927734375, 52.593044281005859 ], [ 143.15277099609375, 52.381660461425781 ], [ 143.124969482421875, 51.960548400878906 ], [ 143.314971923828125, 51.72943115234375 ], [ 143.21942138671875, 51.525825500488281 ], [ 143.367172241210938, 51.638881683349609 ], [ 143.449981689453125, 51.498603820800781 ], [ 143.381195068359375, 51.345615386962891 ], [ 143.523025512695312, 51.267772674560547 ], [ 143.794845581054688, 50.293743133544922 ], [ 144.740692138671875, 48.645301818847656 ], [ 143.981903076171875, 49.268882751464844 ], [ 143.289703369140625, 49.397632598876953 ], [ 143.660110473632812, 49.307628631591797 ], [ 142.98663330078125, 49.095550537109375 ], [ 142.535675048828125, 47.796661376953125 ], [ 143.017547607421875, 47.24853515625 ], [ 143.174072265625, 46.706314086914062 ], [ 143.49163818359375, 46.808601379394531 ], [ 143.601898193359375, 46.38360595703125 ], [ 143.431365966796875, 46.019439697265625 ] ] ], [ [ [ 155.44769287109375, 50.880012512207031 ], [ 155.58026123046875, 50.934158325195312 ], [ 155.669708251953125, 50.856658935546875 ], [ 155.556915283203125, 50.804161071777344 ], [ 155.44769287109375, 50.880012512207031 ] ] ], [ [ [ 156.400848388671875, 50.625640869140625 ], [ 156.18914794921875, 50.6744384765625 ], [ 156.175262451171875, 50.753608703613281 ], [ 156.46844482421875, 50.86749267578125 ], [ 156.400848388671875, 50.625640869140625 ] ] ], [ [ [ 155.226165771484375, 50.052597045898438 ], [ 155.24774169921875, 50.301383972167969 ], [ 155.6654052734375, 50.388050079345703 ], [ 156.114410400390625, 50.751102447509766 ], [ 156.150955200195312, 50.521938323974609 ], [ 155.89276123046875, 50.26361083984375 ], [ 155.226165771484375, 50.052597045898438 ] ] ], [ [ [ 154.593902587890625, 49.291030883789062 ], [ 154.746200561523438, 49.589019775390625 ], [ 154.9044189453125, 49.620826721191406 ], [ 154.807205200195312, 49.299995422363281 ], [ 154.593902587890625, 49.291030883789062 ] ] ], [ [ [ 154.4647216796875, 49.167922973632812 ], [ 154.583038330078125, 49.145828247070312 ], [ 154.595932006835938, 49.109020233154297 ], [ 154.487335205078125, 49.080829620361328 ], [ 154.4647216796875, 49.167922973632812 ] ] ], [ [ [ 153.980804443359375, 48.734687805175781 ], [ 154.116073608398438, 48.897769927978516 ], [ 154.229827880859375, 48.899017333984375 ], [ 154.06329345703125, 48.742767333984375 ], [ 153.980804443359375, 48.734687805175781 ] ] ], [ [ [ 152.20660400390625, 47.125015258789062 ], [ 152.015670776367188, 46.891799926757812 ], [ 151.712188720703125, 46.801101684570312 ], [ 152.221221923828125, 47.173187255859375 ], [ 152.20660400390625, 47.125015258789062 ] ] ], [ [ [ 149.473541259765625, 45.603317260742188 ], [ 149.92913818359375, 46.007499694824219 ], [ 150.498565673828125, 46.192489624023438 ], [ 150.15887451171875, 45.899993896484375 ], [ 149.473541259765625, 45.603317260742188 ] ] ], [ [ [ 146.883026123046875, 44.396942138671875 ], [ 147.111907958984375, 44.79388427734375 ], [ 147.89227294921875, 45.227001190185547 ], [ 147.904144287109375, 45.404159545898438 ], [ 148.074417114257812, 45.248325347900391 ], [ 148.851913452148438, 45.477767944335938 ], [ 148.77532958984375, 45.313949584960938 ], [ 147.612457275390625, 44.960826873779297 ], [ 146.883026123046875, 44.396942138671875 ] ] ], [ [ [ 143.7813720703125, 42.749160766601562 ], [ 143.37384033203125, 42.361663818359375 ], [ 143.243148803710938, 41.924716949462891 ], [ 141.79052734375, 42.60638427734375 ], [ 140.990249633789062, 42.297008514404297 ], [ 140.75225830078125, 42.55096435546875 ], [ 140.470657348632812, 42.570827484130859 ], [ 140.298721313476562, 42.241241455078125 ], [ 141.194412231445312, 41.794956207275391 ], [ 140.980789184570312, 41.705131530761719 ], [ 140.666366577148438, 41.824161529541016 ], [ 140.198989868164062, 41.397285461425781 ], [ 139.979415893554688, 41.5882568359375 ], [ 140.13763427734375, 41.983600616455078 ], [ 139.769760131835938, 42.312076568603516 ], [ 139.863632202148438, 42.653186798095703 ], [ 140.529632568359375, 43.007492065429688 ], [ 140.356216430664062, 43.316520690917969 ], [ 141.158523559570312, 43.138534545898438 ], [ 141.411087036132812, 43.29693603515625 ], [ 141.338226318359375, 43.711585998535156 ], [ 141.64581298828125, 43.942214965820312 ], [ 141.795669555664062, 44.616661071777344 ], [ 141.573577880859375, 45.209854125976562 ], [ 141.9710693359375, 45.486381530761719 ], [ 143.776229858398438, 44.094085693359375 ], [ 144.791641235351562, 43.917697906494141 ], [ 145.338851928710938, 44.344154357910156 ], [ 145.070663452148438, 43.777492523193359 ], [ 145.356842041015625, 43.553188323974609 ], [ 145.2081298828125, 43.600906372070312 ], [ 145.256103515625, 43.317634582519531 ], [ 145.812408447265625, 43.365478515625 ], [ 145.003448486328125, 42.984298706054688 ], [ 144.29193115234375, 42.993324279785156 ], [ 143.7813720703125, 42.749160766601562 ] ] ], [ [ [ 140.99493408203125, 45.448951721191406 ], [ 141.07440185546875, 45.414154052734375 ], [ 141.030410766601562, 45.266521453857422 ], [ 140.968154907226562, 45.459854125976562 ], [ 140.99493408203125, 45.448951721191406 ] ] ], [ [ [ 141.175872802734375, 45.242340087890625 ], [ 141.27191162109375, 45.219985961914062 ], [ 141.33038330078125, 45.146102905273438 ], [ 141.165802001953125, 45.128044128417969 ], [ 141.175872802734375, 45.242340087890625 ] ] ], [ [ [ 146.1607666015625, 44.506622314453125 ], [ 146.568023681640625, 44.438323974609375 ], [ 145.94024658203125, 44.128044128417969 ], [ 145.559478759765625, 43.657279968261719 ], [ 145.437469482421875, 43.716934204101562 ], [ 146.1607666015625, 44.506622314453125 ] ] ], [ [ [ 146.87493896484375, 43.860794067382812 ], [ 146.7802734375, 43.751937866210938 ], [ 146.597320556640625, 43.734432220458984 ], [ 146.607589721679688, 43.805267333984375 ], [ 146.87493896484375, 43.860794067382812 ] ] ], [ [ [ 131.92279052734375, 42.99505615234375 ], [ 131.824127197265625, 42.953323364257812 ], [ 131.753326416015625, 42.987216949462891 ], [ 131.83648681640625, 43.062767028808594 ], [ 131.92279052734375, 42.99505615234375 ] ] ], [ [ [ 139.453033447265625, 42.213607788085938 ], [ 139.561904907226562, 42.232143402099609 ], [ 139.454544067382812, 42.047634124755859 ], [ 139.407745361328125, 42.150825500488281 ], [ 139.453033447265625, 42.213607788085938 ] ] ], [ [ [ 26.361095428466797, 41.711051940917969 ], [ 26.621383666992188, 41.973052978515625 ], [ 27.070270538330078, 42.089988708496094 ], [ 27.569580078125, 41.909263610839844 ], [ 28.013053894042969, 41.982215881347656 ], [ 27.967634201049805, 41.828468322753906 ], [ 28.216941833496094, 41.523597717285156 ], [ 29.107391357421875, 41.221553802490234 ], [ 28.827182769775391, 40.955974578857422 ], [ 28.527078628540039, 41.079715728759766 ], [ 27.505342483520508, 40.981307983398438 ], [ 27.291526794433594, 40.700267791748047 ], [ 26.725410461425781, 40.478050231933594 ], [ 26.164405822753906, 40.051971435546875 ], [ 26.211593627929688, 40.322147369384766 ], [ 26.825828552246094, 40.591587066650391 ], [ 26.057357788085938, 40.653598785400391 ], [ 26.36041259765625, 40.953880310058594 ], [ 26.324996948242188, 41.234710693359375 ], [ 26.635759353637695, 41.364715576171875 ], [ 26.570270538330078, 41.611381530761719 ], [ 26.361095428466797, 41.711051940917969 ] ] ], [ [ [ 139.938507080078125, 40.428604125976562 ], [ 139.852325439453125, 40.598186492919922 ], [ 140.26885986328125, 40.806655883789062 ], [ 140.34552001953125, 41.247074127197266 ], [ 140.6392822265625, 41.181381225585938 ], [ 140.721908569335938, 40.830829620361328 ], [ 140.882736206054688, 40.991519927978516 ], [ 141.13482666015625, 40.856941223144531 ], [ 141.261383056640625, 41.192764282226562 ], [ 140.791656494140625, 41.123321533203125 ], [ 140.838577270507812, 41.400547027587891 ], [ 140.923019409179688, 41.529575347900391 ], [ 141.417755126953125, 41.373878479003906 ], [ 141.46051025390625, 40.593879699707031 ], [ 141.82025146484375, 40.2672119140625 ], [ 142.0697021484375, 39.546661376953125 ], [ 141.848159790039062, 39.019855499267578 ], [ 141.6361083984375, 38.994853973388672 ], [ 141.533050537109375, 38.780548095703125 ], [ 141.519424438476562, 38.263465881347656 ], [ 141.095794677734375, 38.36444091796875 ], [ 140.953582763671875, 38.148048400878906 ], [ 140.97454833984375, 36.984714508056641 ], [ 140.746063232421875, 36.779159545898438 ], [ 140.565521240234375, 36.247489929199219 ], [ 140.837188720703125, 35.743324279785156 ], [ 140.4508056640625, 35.503883361816406 ], [ 140.332183837890625, 35.129852294921875 ], [ 139.772064208984375, 34.951377868652344 ], [ 140.113143920898438, 35.552356719970703 ], [ 139.96856689453125, 35.660820007324219 ], [ 139.646087646484375, 35.457492828369141 ], [ 139.678726196289062, 35.137214660644531 ], [ 139.557891845703125, 35.285552978515625 ], [ 139.173309326171875, 35.238048553466797 ], [ 139.138580322265625, 34.874710083007812 ], [ 138.850387573242188, 34.593185424804688 ], [ 138.767898559570312, 34.954643249511719 ], [ 138.90594482421875, 35.034782409667969 ], [ 138.7412109375, 35.123462677001953 ], [ 138.33245849609375, 34.858047485351562 ], [ 138.214141845703125, 34.599159240722656 ], [ 137.028793334960938, 34.567840576171875 ], [ 137.348297119140625, 34.718742370605469 ], [ 137.026779174804688, 34.759300231933594 ], [ 136.977890014648438, 34.919021606445312 ], [ 136.973846435546875, 34.685409545898438 ], [ 136.87774658203125, 34.720268249511719 ], [ 136.849838256835938, 35.079025268554688 ], [ 136.521087646484375, 34.676658630371094 ], [ 136.915679931640625, 34.433605194091797 ], [ 136.897689819335938, 34.266521453857422 ], [ 136.343841552734375, 34.189712524414062 ], [ 135.772216796875, 33.454994201660156 ], [ 135.064682006835938, 33.875545501708984 ], [ 135.1324462890625, 34.317214965820312 ], [ 135.452606201171875, 34.548187255859375 ], [ 135.333587646484375, 34.71832275390625 ], [ 135.0635986328125, 34.616935729980469 ], [ 134.674697875976562, 34.77777099609375 ], [ 134.250274658203125, 34.71527099609375 ], [ 133.932464599609375, 34.583324432373047 ], [ 134.042068481445312, 34.584716796875 ], [ 133.936843872070312, 34.450820922851562 ], [ 133.703033447265625, 34.521659851074219 ], [ 132.632171630859375, 34.195266723632812 ], [ 132.370651245117188, 34.359298706054688 ], [ 132.050537109375, 33.772491455078125 ], [ 131.74578857421875, 34.053604125976562 ], [ 130.893310546875, 33.921661376953125 ], [ 130.944686889648438, 34.41387939453125 ], [ 131.406097412109375, 34.422077178955078 ], [ 132.638885498046875, 35.286384582519531 ], [ 132.633651733398438, 35.421104431152344 ], [ 133.091064453125, 35.582496643066406 ], [ 133.401641845703125, 35.445266723632812 ], [ 135.222198486328125, 35.762214660644531 ], [ 135.193435668945312, 35.525405883789062 ], [ 135.38720703125, 35.466384887695312 ], [ 135.461090087890625, 35.588043212890625 ], [ 135.736358642578125, 35.483879089355469 ], [ 136.01470947265625, 35.740966796875 ], [ 136.07275390625, 35.648605346679688 ], [ 135.961074829101562, 35.976097106933594 ], [ 136.71246337890625, 36.751388549804688 ], [ 136.78692626953125, 37.362213134765625 ], [ 137.356353759765625, 37.504714965820312 ], [ 136.86328125, 37.0877685546875 ], [ 137.04443359375, 37.056655883789062 ], [ 137.00555419921875, 36.82916259765625 ], [ 137.302459716796875, 36.746383666992188 ], [ 138.580535888671875, 37.398605346679688 ], [ 138.83856201171875, 37.806938171386719 ], [ 139.426223754882812, 38.154575347900391 ], [ 139.78997802734375, 38.84332275390625 ], [ 140.07080078125, 39.585548400878906 ], [ 140.010528564453125, 39.841934204101562 ], [ 139.703155517578125, 39.929439544677734 ], [ 140.008331298828125, 40.192764282226562 ], [ 139.938507080078125, 40.428604125976562 ] ] ], [ [ [ 27.601661682128906, 40.571937561035156 ], [ 27.532634735107422, 40.649440765380859 ], [ 27.733535766601562, 40.635406494140625 ], [ 27.719858169555664, 40.614021301269531 ], [ 27.601661682128906, 40.571937561035156 ] ] ], [ [ [ 25.731666564941406, 40.093040466308594 ], [ 25.776664733886719, 40.212211608886719 ], [ 26.012428283691406, 40.154022216796875 ], [ 25.958053588867188, 40.121101379394531 ], [ 25.731666564941406, 40.093040466308594 ] ] ], [ [ [ 121.409416198730469, 39.361381530761719 ], [ 121.259017944335938, 39.380409240722656 ], [ 121.263328552246094, 39.435962677001953 ], [ 121.4305419921875, 39.4708251953125 ], [ 121.409416198730469, 39.361381530761719 ] ] ], [ [ [ 138.5111083984375, 38.281105041503906 ], [ 138.510543823242188, 37.915271759033203 ], [ 138.218292236328125, 37.800827026367188 ], [ 138.337188720703125, 37.966659545898438 ], [ 138.242462158203125, 38.074996948242188 ], [ 138.5111083984375, 38.281105041503906 ] ] ], [ [ [ 126.443603515625, 37.806343078613281 ], [ 126.516654968261719, 37.758468627929688 ], [ 126.513893127441406, 37.597213745117188 ], [ 126.373031616210938, 37.623184204101562 ], [ 126.443603515625, 37.806343078613281 ] ] ], [ [ [ 126.421096801757812, 36.399436950683594 ], [ 126.337066650390625, 36.436378479003906 ], [ 126.344429016113281, 36.589714050292969 ], [ 126.377479553222656, 36.588466644287109 ], [ 126.421096801757812, 36.399436950683594 ] ] ], [ [ [ 133.298553466796875, 36.318275451660156 ], [ 133.37677001953125, 36.198184967041016 ], [ 133.256362915039062, 36.151935577392578 ], [ 133.18914794921875, 36.26971435546875 ], [ 133.298553466796875, 36.318275451660156 ] ] ], [ [ [ 33.899162292480469, 34.959716796875 ], [ 32.713882446289062, 34.640274047851562 ], [ 32.405826568603516, 34.749858856201172 ], [ 32.269859313964844, 35.078884124755859 ], [ 34.586036682128906, 35.688606262207031 ], [ 33.9405517578125, 35.2994384765625 ], [ 34.085273742675781, 34.961662292480469 ], [ 33.899162292480469, 34.959716796875 ] ] ], [ [ [ 128.72821044921875, 34.943046569824219 ], [ 128.742462158203125, 34.784854888916016 ], [ 128.588211059570312, 34.701240539550781 ], [ 128.494415283203125, 34.880271911621094 ], [ 128.72821044921875, 34.943046569824219 ] ] ], [ [ [ 127.937713623046875, 34.901924133300781 ], [ 128.0733642578125, 34.803256988525391 ], [ 128.059127807617188, 34.700614929199219 ], [ 127.858863830566406, 34.721794128417969 ], [ 127.937713623046875, 34.901924133300781 ] ] ], [ [ [ 129.473052978515625, 34.685615539550781 ], [ 129.47607421875, 34.534439086914062 ], [ 129.336502075195312, 34.294715881347656 ], [ 129.300262451171875, 34.556938171386719 ], [ 129.473052978515625, 34.685615539550781 ] ] ], [ [ [ 134.76220703125, 34.184432983398438 ], [ 134.66693115234375, 34.296943664550781 ], [ 135.019973754882812, 34.590824127197266 ], [ 134.946502685546875, 34.261383056640625 ], [ 134.76220703125, 34.184432983398438 ] ] ], [ [ [ 126.381118774414062, 34.491653442382812 ], [ 126.2591552734375, 34.37054443359375 ], [ 126.101646423339844, 34.396659851074219 ], [ 126.241096496582031, 34.571659088134766 ], [ 126.381118774414062, 34.491653442382812 ] ] ], [ [ [ 134.37158203125, 34.512413024902344 ], [ 134.349273681640625, 34.4315185546875 ], [ 134.19384765625, 34.47137451171875 ], [ 134.277908325195312, 34.542217254638672 ], [ 134.37158203125, 34.512413024902344 ] ] ], [ [ [ 133.5875244140625, 34.024330139160156 ], [ 133.89385986328125, 34.359992980957031 ], [ 134.152328491210938, 34.383880615234375 ], [ 134.579132080078125, 34.224159240722656 ], [ 134.74468994140625, 33.817356109619141 ], [ 134.383087158203125, 33.623046875 ], [ 134.186553955078125, 33.24200439453125 ], [ 133.747604370117188, 33.516384124755859 ], [ 133.281509399414062, 33.362907409667969 ], [ 132.96441650390625, 32.743049621582031 ], [ 132.483016967773438, 32.895549774169922 ], [ 132.534698486328125, 33.244712829589844 ], [ 132.366714477539062, 33.467731475830078 ], [ 132.018722534179688, 33.340476989746094 ], [ 132.63983154296875, 33.673740386962891 ], [ 132.896926879882812, 34.106105804443359 ], [ 133.145950317382812, 33.912349700927734 ], [ 133.5875244140625, 34.024330139160156 ] ] ], [ [ [ 129.330780029296875, 34.229698181152344 ], [ 129.270263671875, 34.103324890136719 ], [ 129.1851806640625, 34.100337982177734 ], [ 129.210525512695312, 34.317356109619141 ], [ 129.330780029296875, 34.229698181152344 ] ] ], [ [ [ 132.49810791015625, 34.255081176757812 ], [ 132.48370361328125, 34.129989624023438 ], [ 132.446075439453125, 34.114852905273438 ], [ 132.386444091796875, 34.245342254638672 ], [ 132.49810791015625, 34.255081176757812 ] ] ], [ [ [ 132.427215576171875, 33.896697998046875 ], [ 132.331634521484375, 33.849159240722656 ], [ 132.184829711914062, 33.904853820800781 ], [ 132.246063232421875, 33.947486877441406 ], [ 132.427215576171875, 33.896697998046875 ] ] ], [ [ [ 131.8743896484375, 32.731269836425781 ], [ 131.6851806640625, 32.534923553466797 ], [ 131.334548950195312, 31.369232177734375 ], [ 131.071624755859375, 31.448745727539062 ], [ 131.129119873046875, 31.267358779907227 ], [ 130.668243408203125, 30.999580383300781 ], [ 130.798721313476562, 31.314302444458008 ], [ 130.60211181640625, 31.585899353027344 ], [ 130.807952880859375, 31.6824951171875 ], [ 130.644989013671875, 31.714160919189453 ], [ 130.534423828125, 31.528884887695312 ], [ 130.6383056640625, 31.182285308837891 ], [ 130.2310791015625, 31.247493743896484 ], [ 130.336212158203125, 31.625968933105469 ], [ 130.1624755859375, 32.006942749023438 ], [ 130.564559936523438, 32.435268402099609 ], [ 130.58746337890625, 32.631935119628906 ], [ 130.450241088867188, 32.619434356689453 ], [ 130.606918334960938, 32.783466339111328 ], [ 130.211090087890625, 33.170829772949219 ], [ 130.096206665039062, 32.854019165039062 ], [ 130.314132690429688, 32.861934661865234 ], [ 130.339401245117188, 32.659297943115234 ], [ 130.176910400390625, 32.5872802734375 ], [ 130.088150024414062, 32.784439086914062 ], [ 129.746063232421875, 32.561103820800781 ], [ 129.85760498046875, 32.718742370605469 ], [ 129.685516357421875, 32.838043212890625 ], [ 129.687530517578125, 33.078571319580078 ], [ 129.804000854492188, 32.858463287353516 ], [ 129.969970703125, 32.863052368164062 ], [ 129.570144653320312, 33.209506988525391 ], [ 129.588577270507812, 33.364021301269531 ], [ 129.834335327148438, 33.292224884033203 ], [ 129.8692626953125, 33.527214050292969 ], [ 130.003326416015625, 33.439430236816406 ], [ 130.20745849609375, 33.650825500488281 ], [ 130.365371704101562, 33.584018707275391 ], [ 130.53497314453125, 33.877212524414062 ], [ 130.982177734375, 33.881103515625 ], [ 131.098770141601562, 33.612560272216797 ], [ 131.692474365234375, 33.624160766601562 ], [ 131.70086669921875, 33.414714813232422 ], [ 131.501937866210938, 33.315547943115234 ], [ 131.896682739257812, 33.247180938720703 ], [ 131.816558837890625, 33.119644165039062 ], [ 131.989410400390625, 32.830551147460938 ], [ 131.8743896484375, 32.731269836425781 ] ] ], [ [ [ 129.720794677734375, 33.697486877441406 ], [ 129.65887451171875, 33.749164581298828 ], [ 129.699554443359375, 33.855968475341797 ], [ 129.79412841796875, 33.762771606445312 ], [ 129.720794677734375, 33.697486877441406 ] ] ], [ [ [ 126.83966064453125, 33.536369323730469 ], [ 126.845268249511719, 33.309993743896484 ], [ 126.157760620117188, 33.278877258300781 ], [ 126.314979553222656, 33.451522827148438 ], [ 126.83966064453125, 33.536369323730469 ] ] ], [ [ [ 129.5379638671875, 33.307487487792969 ], [ 129.484405517578125, 33.208602905273438 ], [ 129.361068725585938, 33.169715881347656 ], [ 129.5616455078125, 33.388328552246094 ], [ 129.5379638671875, 33.307487487792969 ] ] ], [ [ [ 129.123687744140625, 33.068519592285156 ], [ 129.18304443359375, 32.986106872558594 ], [ 129.055526733398438, 32.818672180175781 ], [ 129.00555419921875, 32.934989929199219 ], [ 129.123687744140625, 33.068519592285156 ] ] ], [ [ [ 128.65240478515625, 32.696640014648438 ], [ 128.81329345703125, 32.792495727539062 ], [ 128.901016235351562, 32.646869659423828 ], [ 128.6102294921875, 32.611663818359375 ], [ 128.65240478515625, 32.696640014648438 ] ] ], [ [ [ 130.0, 32.188316345214844 ], [ 129.987457275390625, 32.409431457519531 ], [ 130.15386962890625, 32.543609619140625 ], [ 130.207611083984375, 32.333461761474609 ], [ 130.0, 32.188316345214844 ] ] ], [ [ [ 130.2393798828125, 32.460350036621094 ], [ 130.3319091796875, 32.516387939453125 ], [ 130.448028564453125, 32.505271911621094 ], [ 130.358856201171875, 32.37054443359375 ], [ 130.2393798828125, 32.460350036621094 ] ] ], [ [ [ 119.712738037109375, 32.266738891601562 ], [ 119.825675964355469, 32.265968322753906 ], [ 119.897346496582031, 32.07110595703125 ], [ 119.785324096679688, 32.128810882568359 ], [ 119.712738037109375, 32.266738891601562 ] ] ], [ [ [ 121.203857421875, 31.800537109375 ], [ 121.333053588867188, 31.818328857421875 ], [ 121.87359619140625, 31.499717712402344 ], [ 121.546371459960938, 31.531108856201172 ], [ 121.203857421875, 31.800537109375 ] ] ], [ [ [ 131.0718994140625, 30.826675415039062 ], [ 130.969696044921875, 30.390552520751953 ], [ 130.879119873046875, 30.354995727539062 ], [ 130.944137573242188, 30.678537368774414 ], [ 131.0718994140625, 30.826675415039062 ] ] ], [ [ [ 130.523529052734375, 30.443096160888672 ], [ 130.668182373046875, 30.380134582519531 ], [ 130.598297119140625, 30.243606567382812 ], [ 130.388458251953125, 30.349578857421875 ], [ 130.523529052734375, 30.443096160888672 ] ] ], [ [ [ 122.086700439453125, 30.300846099853516 ], [ 122.2098388671875, 30.339580535888672 ], [ 122.235260009765625, 30.311107635498047 ], [ 122.19970703125, 30.237773895263672 ], [ 122.086700439453125, 30.300846099853516 ] ] ], [ [ [ 121.969993591308594, 30.066661834716797 ], [ 122.106369018554688, 30.132495880126953 ], [ 122.326377868652344, 30.010137557983398 ], [ 122.278114318847656, 29.931245803833008 ], [ 121.969993591308594, 30.066661834716797 ] ] ], [ [ [ 48.18853759765625, 29.981929779052734 ], [ 48.359443664550781, 29.744998931884766 ], [ 48.228321075439453, 29.59527587890625 ], [ 48.079986572265625, 29.773330688476562 ], [ 48.18853759765625, 29.981929779052734 ] ] ], [ [ [ 122.123260498046875, 29.686355590820312 ], [ 122.033668518066406, 29.713537216186523 ], [ 122.058456420898438, 29.776248931884766 ], [ 122.184707641601562, 29.687774658203125 ], [ 122.123260498046875, 29.686355590820312 ] ] ], [ [ [ 129.690460205078125, 28.497718811035156 ], [ 129.373291015625, 28.116315841674805 ], [ 129.143310546875, 28.252496719360352 ], [ 129.326629638671875, 28.352218627929688 ], [ 129.690460205078125, 28.497718811035156 ] ] ], [ [ [ 121.129966735839844, 28.098606109619141 ], [ 121.200958251953125, 28.204092025756836 ], [ 121.265403747558594, 28.182355880737305 ], [ 121.204986572265625, 28.055274963378906 ], [ 121.129966735839844, 28.098606109619141 ] ] ], [ [ [ 128.933624267578125, 27.901103973388672 ], [ 129.029281616210938, 27.771663665771484 ], [ 128.953445434570312, 27.677078247070312 ], [ 128.880661010742188, 27.822080612182617 ], [ 128.933624267578125, 27.901103973388672 ] ] ], [ [ [ 56.288330078125, 26.949970245361328 ], [ 55.987213134765625, 26.727771759033203 ], [ 55.283607482910156, 26.558609008789062 ], [ 55.769989013671875, 26.792774200439453 ], [ 55.754581451416016, 26.952077865600586 ], [ 56.288330078125, 26.949970245361328 ] ] ], [ [ [ 55.703746795654297, 26.812356948852539 ], [ 55.626380920410156, 26.833053588867188 ], [ 55.692626953125, 26.929994583129883 ], [ 55.734992980957031, 26.838050842285156 ], [ 55.703746795654297, 26.812356948852539 ] ] ], [ [ [ 128.287200927734375, 26.854995727539062 ], [ 128.2713623046875, 26.658329010009766 ], [ 127.849716186523438, 26.436382293701172 ], [ 127.813026428222656, 26.155551910400391 ], [ 127.652214050292969, 26.085691452026367 ], [ 127.717544555664062, 26.432079315185547 ], [ 127.959991455078125, 26.547357559204102 ], [ 127.883880615234375, 26.667495727539062 ], [ 128.067474365234375, 26.642494201660156 ], [ 128.287200927734375, 26.854995727539062 ] ] ], [ [ [ 50.650550842285156, 26.244720458984375 ], [ 50.613048553466797, 26.246942520141602 ], [ 50.611248016357422, 26.279165267944336 ], [ 50.653953552246094, 26.270622253417969 ], [ 50.650550842285156, 26.244720458984375 ] ] ], [ [ [ 50.593048095703125, 26.15083122253418 ], [ 50.619720458984375, 25.980831146240234 ], [ 50.573329925537109, 25.809722900390625 ], [ 50.458885192871094, 26.224441528320312 ], [ 50.593048095703125, 26.15083122253418 ] ] ], [ [ [ 50.771942138671875, 25.571941375732422 ], [ 50.744720458984375, 25.589443206787109 ], [ 50.741661071777344, 25.683052062988281 ], [ 50.794715881347656, 25.727359771728516 ], [ 50.771942138671875, 25.571941375732422 ] ] ], [ [ [ 119.7005615234375, 25.42608642578125 ], [ 119.691917419433594, 25.598745346069336 ], [ 119.779640197753906, 25.655550003051758 ], [ 119.842628479003906, 25.541942596435547 ], [ 119.7005615234375, 25.42608642578125 ] ] ], [ [ [ 120.239700317382812, 23.829998016357422 ], [ 121.060539245605469, 25.048608779907227 ], [ 121.563179016113281, 25.283609390258789 ], [ 122.000404357910156, 25.007219314575195 ], [ 121.818191528320312, 24.850275039672852 ], [ 121.839706420898438, 24.476383209228516 ], [ 121.453048706054688, 23.327220916748047 ], [ 120.969711303710938, 22.568328857421875 ], [ 120.82415771484375, 21.927772521972656 ], [ 120.053939819335938, 23.044370651245117 ], [ 120.239700317382812, 23.829998016357422 ] ] ], [ [ [ 125.288307189941406, 24.865550994873047 ], [ 125.349700927734375, 24.781248092651367 ], [ 125.446372985839844, 24.732772827148438 ], [ 125.259162902832031, 24.72735595703125 ], [ 125.288307189941406, 24.865550994873047 ] ] ], [ [ [ 124.094917297363281, 24.439495086669922 ], [ 124.217208862304688, 24.445135116577148 ], [ 124.325057983398438, 24.58610725402832 ], [ 124.231651306152344, 24.34013557434082 ], [ 124.094917297363281, 24.439495086669922 ] ] ], [ [ [ 118.07855224609375, 24.43914794921875 ], [ 118.096847534179688, 24.552150726318359 ], [ 118.178306579589844, 24.529163360595703 ], [ 118.145957946777344, 24.432077407836914 ], [ 118.07855224609375, 24.43914794921875 ] ] ], [ [ [ 118.293373107910156, 24.419841766357422 ], [ 118.393051147460938, 24.515830993652344 ], [ 118.437759399414062, 24.495828628540039 ], [ 118.420951843261719, 24.397634506225586 ], [ 118.293373107910156, 24.419841766357422 ] ] ], [ [ [ 54.472637176513672, 24.419773101806641 ], [ 54.330581665039062, 24.456779479980469 ], [ 54.386688232421875, 24.512886047363281 ], [ 54.472637176513672, 24.419773101806641 ] ] ], [ [ [ 123.792251586914062, 24.405242919921875 ], [ 123.936508178710938, 24.354301452636719 ], [ 123.872894287109375, 24.253887176513672 ], [ 123.678863525390625, 24.316108703613281 ], [ 123.792251586914062, 24.405242919921875 ] ] ], [ [ [ 53.784164428710938, 24.124996185302734 ], [ 53.624717712402344, 24.169719696044922 ], [ 53.964855194091797, 24.179443359375 ], [ 53.946384429931641, 24.139997482299805 ], [ 53.784164428710938, 24.124996185302734 ] ] ], [ [ [ 117.467147827148438, 23.755619049072266 ], [ 117.4144287109375, 23.602218627929688 ], [ 117.310531616210938, 23.581941604614258 ], [ 117.369842529296875, 23.76222038269043 ], [ 117.467147827148438, 23.755619049072266 ] ] ], [ [ [ 117.115493774414062, 23.473850250244141 ], [ 117.121650695800781, 23.400758743286133 ], [ 116.945114135742188, 23.43450927734375 ], [ 117.100540161132812, 23.489299774169922 ], [ 117.115493774414062, 23.473850250244141 ] ] ], [ [ [ 113.604766845703125, 22.766773223876953 ], [ 113.551933288574219, 22.75555419921875 ], [ 113.389213562011719, 22.894231796264648 ], [ 113.492202758789062, 22.894439697265625 ], [ 113.604766845703125, 22.766773223876953 ] ] ], [ [ [ 90.519439697265625, 22.685829162597656 ], [ 90.469917297363281, 22.867288589477539 ], [ 90.68359375, 22.853885650634766 ], [ 90.541618347167969, 22.783195495605469 ], [ 90.519439697265625, 22.685829162597656 ] ] ], [ [ [ 90.671371459960938, 21.987216949462891 ], [ 90.676651000976562, 22.445549011230469 ], [ 90.550811767578125, 22.639717102050781 ], [ 90.662483215332031, 22.783193588256836 ], [ 90.878860473632812, 22.436660766601562 ], [ 90.671371459960938, 21.987216949462891 ] ] ], [ [ [ 91.513046264648438, 22.345550537109375 ], [ 91.405258178710938, 22.482772827148438 ], [ 91.432823181152344, 22.622703552246094 ], [ 91.559982299804688, 22.435272216796875 ], [ 91.513046264648438, 22.345550537109375 ] ] ], [ [ [ 91.027206420898438, 22.083885192871094 ], [ 91.073043823242188, 22.507499694824219 ], [ 91.089706420898438, 22.524024963378906 ], [ 91.174697875976562, 22.218605041503906 ], [ 91.027206420898438, 22.083885192871094 ] ] ], [ [ [ 114.049697875976562, 22.328880310058594 ], [ 113.964996337890625, 22.218051910400391 ], [ 113.832176208496094, 22.200420379638672 ], [ 113.885406494140625, 22.282636642456055 ], [ 114.049697875976562, 22.328880310058594 ] ] ], [ [ [ 114.144523620605469, 22.28618049621582 ], [ 114.234962463378906, 22.266082763671875 ], [ 114.244010925292969, 22.200765609741211 ], [ 114.200798034667969, 22.194736480712891 ], [ 114.144523620605469, 22.28618049621582 ] ] ], [ [ [ 90.517486572265625, 21.988048553466797 ], [ 90.486366271972656, 22.077079772949219 ], [ 90.610740661621094, 22.161661148071289 ], [ 90.56317138671875, 22.033052444458008 ], [ 90.517486572265625, 21.988048553466797 ] ] ], [ [ [ 88.146347045898438, 21.865554809570312 ], [ 88.132347106933594, 21.620552062988281 ], [ 88.064979553222656, 21.629718780517578 ], [ 88.05303955078125, 21.720829010009766 ], [ 88.146347045898438, 21.865554809570312 ] ] ], [ [ [ 112.793586730957031, 21.574165344238281 ], [ 112.702766418457031, 21.684719085693359 ], [ 112.833602905273438, 21.774166107177734 ], [ 112.868873596191406, 21.763193130493164 ], [ 112.793586730957031, 21.574165344238281 ] ] ], [ [ [ 91.886932373046875, 21.47332763671875 ], [ 91.8438720703125, 21.6905517578125 ], [ 91.884010314941406, 21.754997253417969 ], [ 91.982208251953125, 21.611663818359375 ], [ 91.886932373046875, 21.47332763671875 ] ] ], [ [ [ 111.816383361816406, 21.556941986083984 ], [ 111.838600158691406, 21.641384124755859 ], [ 112.000816345214844, 21.653745651245117 ], [ 111.995246887207031, 21.615272521972656 ], [ 111.816383361816406, 21.556941986083984 ] ] ], [ [ [ 107.471946716308594, 21.271419525146484 ], [ 107.600273132324219, 21.205272674560547 ], [ 107.379219055175781, 21.048191070556641 ], [ 107.375534057617188, 21.081247329711914 ], [ 107.471946716308594, 21.271419525146484 ] ] ], [ [ [ 110.5313720703125, 21.198596954345703 ], [ 110.611503601074219, 21.193815231323242 ], [ 110.536933898925781, 21.097496032714844 ], [ 110.442481994628906, 21.157077789306641 ], [ 110.5313720703125, 21.198596954345703 ] ] ], [ [ [ 110.45556640625, 21.057418823242188 ], [ 110.498031616210938, 20.955829620361328 ], [ 110.248451232910156, 20.980550765991211 ], [ 110.32916259765625, 21.075553894042969 ], [ 110.45556640625, 21.057418823242188 ] ] ], [ [ [ 106.910598754882812, 20.834396362304688 ], [ 107.03338623046875, 20.855690002441406 ], [ 107.101516723632812, 20.799440383911133 ], [ 107.047760009765625, 20.703884124755859 ], [ 106.910598754882812, 20.834396362304688 ] ] ], [ [ [ 58.654998779296875, 20.168331146240234 ], [ 58.651451110839844, 20.370412826538086 ], [ 58.919506072998047, 20.682289123535156 ], [ 58.951107025146484, 20.5111083984375 ], [ 58.654998779296875, 20.168331146240234 ] ] ], [ [ [ 92.79052734375, 20.438156127929688 ], [ 92.860260009765625, 20.325828552246094 ], [ 92.842758178710938, 20.299720764160156 ], [ 92.768524169921875, 20.297286987304688 ], [ 92.79052734375, 20.438156127929688 ] ] ], [ [ [ 110.85498046875, 19.528884887695312 ], [ 110.48321533203125, 19.167612075805664 ], [ 110.525543212890625, 18.800830841064453 ], [ 110.050254821777344, 18.385202407836914 ], [ 109.759437561035156, 18.391523361206055 ], [ 109.703598022460938, 18.197772979736328 ], [ 108.687057495117188, 18.505620956420898 ], [ 108.628311157226562, 19.280277252197266 ], [ 109.293869018554688, 19.759998321533203 ], [ 109.165260314941406, 19.723604202270508 ], [ 109.257209777832031, 19.899717330932617 ], [ 109.4658203125, 19.828609466552734 ], [ 109.610809326171875, 19.993885040283203 ], [ 110.665542602539062, 20.13360595703125 ], [ 110.942481994628906, 19.978605270385742 ], [ 111.02154541015625, 19.638294219970703 ], [ 110.85498046875, 19.528884887695312 ] ] ], [ [ [ 93.419906616210938, 19.950576782226562 ], [ 93.49859619140625, 19.880550384521484 ], [ 93.511512756347656, 19.7445068359375 ], [ 93.437759399414062, 19.799442291259766 ], [ 93.419906616210938, 19.950576782226562 ] ] ], [ [ [ 93.96728515625, 19.369354248046875 ], [ 93.797340393066406, 19.269371032714844 ], [ 93.651649475097656, 19.513608932495117 ], [ 93.73748779296875, 19.549163818359375 ], [ 93.96728515625, 19.369354248046875 ] ] ], [ [ [ 93.870391845703125, 19.254657745361328 ], [ 93.94219970703125, 18.862495422363281 ], [ 93.483322143554688, 19.386383056640625 ], [ 93.547203063964844, 19.428468704223633 ], [ 93.741928100585938, 19.249439239501953 ], [ 93.870391845703125, 19.254657745361328 ] ] ], [ [ [ 121.513320922851562, 19.249160766601562 ], [ 121.393882751464844, 19.3155517578125 ], [ 121.39569091796875, 19.391107559204102 ], [ 121.528877258300781, 19.390274047851562 ], [ 121.513320922851562, 19.249160766601562 ] ] ], [ [ [ 121.85443115234375, 18.818885803222656 ], [ 121.872756958007812, 18.9788818359375 ], [ 121.948799133300781, 19.003053665161133 ], [ 121.988037109375, 18.944717407226562 ], [ 121.85443115234375, 18.818885803222656 ] ] ], [ [ [ 93.638076782226562, 18.887180328369141 ], [ 93.747901916503906, 18.870689392089844 ], [ 93.705825805664062, 18.669023513793945 ], [ 93.489425659179688, 18.852497100830078 ], [ 93.638076782226562, 18.887180328369141 ] ] ], [ [ [ 119.892585754394531, 15.80112361907959 ], [ 119.752769470214844, 15.960414886474609 ], [ 119.82415771484375, 16.364997863769531 ], [ 120.156646728515625, 16.036109924316406 ], [ 120.42608642578125, 16.169116973876953 ], [ 120.317207336425781, 16.631107330322266 ], [ 120.459991455078125, 17.411663055419922 ], [ 120.338592529296875, 17.571662902832031 ], [ 120.585273742675781, 18.511386871337891 ], [ 121.153587341308594, 18.625274658203125 ], [ 121.94970703125, 18.268886566162109 ], [ 122.238876342773438, 18.514997482299805 ], [ 122.342483520507812, 18.310552597045898 ], [ 122.173179626464844, 18.075136184692383 ], [ 122.170257568359375, 17.607219696044922 ], [ 122.518333435058594, 17.043888092041016 ], [ 122.206382751464844, 16.234161376953125 ], [ 121.563308715820312, 15.903053283691406 ], [ 121.643051147460938, 15.713052749633789 ], [ 121.380256652832031, 15.302497863769531 ], [ 121.695266723632812, 14.696664810180664 ], [ 121.73553466796875, 14.16847038269043 ], [ 121.910537719726562, 14.009164810180664 ], [ 122.233322143554688, 13.897220611572266 ], [ 122.256790161132812, 14.239997863769531 ], [ 122.3035888671875, 14.101108551025391 ], [ 122.473312377929688, 14.340553283691406 ], [ 122.71331787109375, 14.33833122253418 ], [ 123.03887939453125, 14.069442749023438 ], [ 123.099990844726562, 13.667497634887695 ], [ 123.318458557128906, 13.789303779602051 ], [ 123.229713439941406, 14.002222061157227 ], [ 123.343048095703125, 14.086942672729492 ], [ 123.970123291015625, 13.751804351806641 ], [ 123.579986572265625, 13.718330383300781 ], [ 123.533172607421875, 13.571248054504395 ], [ 123.869735717773438, 13.232115745544434 ], [ 123.761795043945312, 13.063469886779785 ], [ 124.190948486328125, 13.064998626708984 ], [ 124.09637451171875, 12.553609848022461 ], [ 123.850128173828125, 12.727357864379883 ], [ 124.0263671875, 12.963747978210449 ], [ 123.729156494140625, 12.853609085083008 ], [ 123.323883056640625, 13.008609771728516 ], [ 123.201507568359375, 13.417984962463379 ], [ 122.560997009277344, 13.936567306518555 ], [ 122.60748291015625, 13.163887023925781 ], [ 122.403587341308594, 13.5191650390625 ], [ 121.749916076660156, 13.964789390563965 ], [ 121.279426574707031, 13.593887329101562 ], [ 120.879432678222656, 13.902498245239258 ], [ 120.716659545898438, 13.925275802612305 ], [ 120.66241455078125, 13.768887519836426 ], [ 120.592208862304688, 14.231109619140625 ], [ 120.9910888671875, 14.549165725708008 ], [ 120.548667907714844, 14.823261260986328 ], [ 120.610404968261719, 14.488053321838379 ], [ 120.493316650390625, 14.429719924926758 ], [ 120.245246887207031, 14.847776412963867 ], [ 120.087348937988281, 14.78347110748291 ], [ 119.892585754394531, 15.80112361907959 ] ] ], [ [ [ 41.8861083984375, 16.999443054199219 ], [ 41.939506530761719, 16.975761413574219 ], [ 41.987911224365234, 16.755344390869141 ], [ 41.83721923828125, 16.868610382080078 ], [ 41.8861083984375, 16.999443054199219 ] ] ], [ [ [ 112.337486267089844, 16.943607330322266 ], [ 112.333877563476562, 16.943607330322266 ], [ 112.330833435058594, 16.949161529541016 ], [ 112.337486267089844, 16.949996948242188 ], [ 112.337486267089844, 16.943607330322266 ] ] ], [ [ [ 42.170555114746094, 16.562774658203125 ], [ 41.838607788085938, 16.718887329101562 ], [ 41.753608703613281, 16.876110076904297 ], [ 41.944999694824219, 16.710830688476562 ], [ 42.075691223144531, 16.810276031494141 ], [ 42.170555114746094, 16.562774658203125 ] ] ], [ [ [ 112.747207641601562, 16.653606414794922 ], [ 112.741928100585938, 16.6552734375 ], [ 112.735328674316406, 16.6668701171875 ], [ 112.74713134765625, 16.660549163818359 ], [ 112.747207641601562, 16.653606414794922 ] ] ], [ [ [ 97.518630981445312, 16.505332946777344 ], [ 97.616653442382812, 16.46527099609375 ], [ 97.557479858398438, 16.230827331542969 ], [ 97.4658203125, 16.318052291870117 ], [ 97.518630981445312, 16.505332946777344 ] ] ], [ [ [ 111.713882446289062, 16.447494506835938 ], [ 111.705848693847656, 16.460723876953125 ], [ 111.716522216796875, 16.451522827148438 ], [ 111.713882446289062, 16.447494506835938 ] ] ], [ [ [ 94.648025512695312, 16.245029449462891 ], [ 94.651382446289062, 16.11444091796875 ], [ 94.415817260742188, 15.868053436279297 ], [ 94.381507873535156, 15.984441757202148 ], [ 94.648025512695312, 16.245029449462891 ] ] ], [ [ [ 42.588882446289062, 15.270832061767578 ], [ 42.568470001220703, 15.389860153198242 ], [ 42.644996643066406, 15.457221031188965 ], [ 42.651386260986328, 15.39083194732666 ], [ 42.588882446289062, 15.270832061767578 ] ] ], [ [ [ 121.939697265625, 14.626941680908203 ], [ 121.807685852050781, 14.923470497131348 ], [ 121.935806274414062, 15.056941986083984 ], [ 122.014434814453125, 15.037359237670898 ], [ 122.058319091796875, 14.96221923828125 ], [ 121.939697265625, 14.626941680908203 ] ] ], [ [ [ 122.248031616210938, 14.718053817749023 ], [ 122.117202758789062, 14.796665191650391 ], [ 122.098182678222656, 14.836665153503418 ], [ 122.211517333984375, 14.839719772338867 ], [ 122.248031616210938, 14.718053817749023 ] ] ], [ [ [ 122.171096801757812, 13.998607635498047 ], [ 121.995529174804688, 14.104719161987305 ], [ 121.91748046875, 14.185276031494141 ], [ 122.125808715820312, 14.08763599395752 ], [ 122.171096801757812, 13.998607635498047 ] ] ], [ [ [ 124.208038330078125, 13.515275955200195 ], [ 124.030548095703125, 13.663887023925781 ], [ 124.208320617675781, 14.098746299743652 ], [ 124.418052673339844, 13.793193817138672 ], [ 124.208038330078125, 13.515275955200195 ] ] ], [ [ [ 42.781105041503906, 13.909442901611328 ], [ 42.689163208007812, 14.01361083984375 ], [ 42.768192291259766, 14.066527366638184 ], [ 42.799858093261719, 13.996944427490234 ], [ 42.781105041503906, 13.909442901611328 ] ] ], [ [ [ 120.274696350097656, 13.668331146240234 ], [ 120.108871459960938, 13.779165267944336 ], [ 120.081932067871094, 13.852358818054199 ], [ 120.238876342773438, 13.808053970336914 ], [ 120.274696350097656, 13.668331146240234 ] ] ], [ [ [ 92.885734558105469, 12.89845085144043 ], [ 92.810806274414062, 12.920831680297852 ], [ 92.840682983398438, 13.327497482299805 ], [ 93.04498291015625, 13.570137023925781 ], [ 93.045257568359375, 13.065553665161133 ], [ 92.885734558105469, 12.89845085144043 ] ] ], [ [ [ 122.030899047851562, 13.200820922851562 ], [ 121.837196350097656, 13.334720611572266 ], [ 121.874420166015625, 13.541387557983398 ], [ 122.126640319824219, 13.456386566162109 ], [ 122.030899047851562, 13.200820922851562 ] ] ], [ [ [ 121.439697265625, 12.351663589477539 ], [ 121.123176574707031, 12.244997024536133 ], [ 120.688026428222656, 13.135831832885742 ], [ 120.321090698242188, 13.475831031799316 ], [ 120.990325927734375, 13.518402099609375 ], [ 121.502212524414062, 13.148887634277344 ], [ 121.439697265625, 12.351663589477539 ] ] ], [ [ [ 123.369140625, 12.691387176513672 ], [ 122.950263977050781, 13.031109809875488 ], [ 122.931236267089844, 13.109164237976074 ], [ 123.045265197753906, 13.136666297912598 ], [ 123.369140625, 12.691387176513672 ] ] ], [ [ [ 92.874420166015625, 12.306665420532227 ], [ 92.829513549804688, 12.318642616271973 ], [ 92.791236877441406, 12.319204330444336 ], [ 92.758880615234375, 12.304998397827148 ], [ 92.718048095703125, 12.341108322143555 ], [ 92.736373901367188, 12.809720993041992 ], [ 92.918258666992188, 12.913265228271484 ], [ 92.991653442382812, 12.524999618530273 ], [ 92.874420166015625, 12.306665420532227 ] ] ], [ [ [ 54.220832824707031, 12.650554656982422 ], [ 54.473468780517578, 12.548748970031738 ], [ 54.1240234375, 12.348193168640137 ], [ 53.6361083984375, 12.328887939453125 ], [ 53.330829620361328, 12.545970916748047 ], [ 53.499717712402344, 12.717221260070801 ], [ 54.220832824707031, 12.650554656982422 ] ] ], [ [ [ 122.018051147460938, 12.09416389465332 ], [ 121.917762756347656, 12.302914619445801 ], [ 122.122756958007812, 12.676942825317383 ], [ 122.111366271972656, 12.415275573730469 ], [ 122.018051147460938, 12.09416389465332 ] ] ], [ [ [ 123.787200927734375, 12.342220306396484 ], [ 123.690261840820312, 12.454998016357422 ], [ 123.584297180175781, 12.658610343933105 ], [ 123.727767944335938, 12.601663589477539 ], [ 123.787200927734375, 12.342220306396484 ] ] ], [ [ [ 98.31231689453125, 12.36848258972168 ], [ 98.300537109375, 12.632705688476562 ], [ 98.321929931640625, 12.671110153198242 ], [ 98.467758178710938, 12.5 ], [ 98.31231689453125, 12.36848258972168 ] ] ], [ [ [ 123.164703369140625, 11.904165267944336 ], [ 123.245742797851562, 12.605761528015137 ], [ 123.910812377929688, 12.189165115356445 ], [ 124.079093933105469, 11.727913856506348 ], [ 123.53692626953125, 12.205414772033691 ], [ 123.164703369140625, 11.904165267944336 ] ] ], [ [ [ 125.7510986328125, 11.008888244628906 ], [ 125.6644287109375, 11.134304046630859 ], [ 125.269439697265625, 11.128053665161133 ], [ 124.971237182617188, 11.446248054504395 ], [ 124.849082946777344, 11.464789390563965 ], [ 125.037071228027344, 11.752914428710938 ], [ 124.469993591308594, 12.104164123535156 ], [ 124.257766723632812, 12.551109313964844 ], [ 125.1483154296875, 12.576525688171387 ], [ 125.296943664550781, 12.457498550415039 ], [ 125.515823364257812, 12.171110153198242 ], [ 125.4456787109375, 11.612914085388184 ], [ 125.640609741210938, 11.351454734802246 ], [ 125.542068481445312, 11.189512252807617 ], [ 125.664566040039062, 11.194441795349121 ], [ 125.7510986328125, 11.008888244628906 ] ] ], [ [ [ 122.640266418457031, 12.264444351196289 ], [ 122.43359375, 12.413331985473633 ], [ 122.459022521972656, 12.48478889465332 ], [ 122.66943359375, 12.483608245849609 ], [ 122.640266418457031, 12.264444351196289 ] ] ], [ [ [ 97.987640380859375, 12.291379928588867 ], [ 97.949417114257812, 12.379997253417969 ], [ 98.105262756347656, 12.398470878601074 ], [ 98.00555419921875, 12.281942367553711 ], [ 97.987640380859375, 12.291379928588867 ] ] ], [ [ [ 120.200607299804688, 12.0 ], [ 119.9730224609375, 12.024164199829102 ], [ 119.888046264648438, 12.333608627319336 ], [ 120.332748413085938, 12.083608627319336 ], [ 120.200607299804688, 12.0 ] ] ], [ [ [ 92.7542724609375, 12.07133674621582 ], [ 92.790374755859375, 12.202005386352539 ], [ 92.755271911621094, 12.279797554016113 ], [ 92.876373291015625, 12.301942825317383 ], [ 92.7542724609375, 12.07133674621582 ] ] ], [ [ [ 98.066024780273438, 12.171442031860352 ], [ 98.057479858398438, 12.281041145324707 ], [ 98.121017456054688, 12.280206680297852 ], [ 98.139083862304688, 12.142082214355469 ], [ 98.066024780273438, 12.171442031860352 ] ] ], [ [ [ 52.341384887695312, 12.144721984863281 ], [ 52.178886413574219, 12.171943664550781 ], [ 52.085552215576172, 12.223540306091309 ], [ 52.395271301269531, 12.196527481079102 ], [ 52.341384887695312, 12.144721984863281 ] ] ], [ [ [ 92.754058837890625, 12.067880630493164 ], [ 92.795822143554688, 11.901943206787109 ], [ 92.716514587402344, 11.491801261901855 ], [ 92.52532958984375, 11.855414390563965 ], [ 92.709846496582031, 12.234302520751953 ], [ 92.754058837890625, 12.067880630493164 ] ] ], [ [ [ 102.42645263671875, 12.0 ], [ 102.291351318359375, 11.974441528320312 ], [ 102.251937866210938, 12.150693893432617 ], [ 102.35400390625, 12.112636566162109 ], [ 102.42645263671875, 12.0 ] ] ], [ [ [ 98.518997192382812, 12.0 ], [ 98.573043823242188, 11.99055290222168 ], [ 98.659988403320312, 11.933053970336914 ], [ 98.479156494140625, 11.887221336364746 ], [ 98.438583374023438, 12.111387252807617 ], [ 98.518997192382812, 12.0 ] ] ], [ [ [ 119.952766418457031, 11.656665802001953 ], [ 119.872482299804688, 11.892775535583496 ], [ 119.88372802734375, 11.975136756896973 ], [ 120.070541381835938, 11.864997863769531 ], [ 119.952766418457031, 11.656665802001953 ] ] ], [ [ [ 123.095260620117188, 11.236663818359375 ], [ 122.729156494140625, 10.800830841064453 ], [ 121.909835815429688, 10.444581031799316 ], [ 122.10137939453125, 11.648332595825195 ], [ 121.849418640136719, 11.75847053527832 ], [ 121.888175964355469, 11.899581909179688 ], [ 122.586647033691406, 11.521110534667969 ], [ 122.830833435058594, 11.608608245849609 ], [ 122.880256652832031, 11.430275917053223 ], [ 123.146942138671875, 11.598608016967773 ], [ 123.095260620117188, 11.236663818359375 ] ] ], [ [ [ 98.413314819335938, 11.610872268676758 ], [ 98.370254516601562, 11.783748626708984 ], [ 98.541648864746094, 11.798470497131348 ], [ 98.546028137207031, 11.60978889465332 ], [ 98.413314819335938, 11.610872268676758 ] ] ], [ [ [ 98.165542602539062, 11.453330993652344 ], [ 98.270133972167969, 11.794720649719238 ], [ 98.291236877441406, 11.797080993652344 ], [ 98.28082275390625, 11.481664657592773 ], [ 98.165542602539062, 11.453330993652344 ] ] ], [ [ [ 102.560226440429688, 11.754396438598633 ], [ 102.604690551757812, 11.696942329406738 ], [ 102.59344482421875, 11.564233779907227 ], [ 102.531768798828125, 11.602705955505371 ], [ 102.560226440429688, 11.754396438598633 ] ] ], [ [ [ 124.82720947265625, 11.528055191040039 ], [ 124.769989013671875, 11.565554618835449 ], [ 124.725540161132812, 11.727983474731445 ], [ 124.842758178710938, 11.591665267944336 ], [ 124.82720947265625, 11.528055191040039 ] ] ], [ [ [ 124.488037109375, 11.461664199829102 ], [ 124.4447021484375, 11.485830307006836 ], [ 124.337760925292969, 11.677567481994629 ], [ 124.5313720703125, 11.679719924926758 ], [ 124.619140625, 11.522082328796387 ], [ 124.488037109375, 11.461664199829102 ] ] ], [ [ [ 125.180267333984375, 10.543331146240234 ], [ 125.259086608886719, 10.263053894042969 ], [ 125.120529174804688, 10.176942825317383 ], [ 124.978317260742188, 10.374580383300781 ], [ 124.977760314941406, 10.040276527404785 ], [ 124.76470947265625, 10.196386337280273 ], [ 124.761932373046875, 10.81805419921875 ], [ 124.596794128417969, 11.010416030883789 ], [ 124.421371459960938, 10.913331985473633 ], [ 124.316383361816406, 11.56694221496582 ], [ 124.64111328125, 11.29305362701416 ], [ 124.95025634765625, 11.421734809875488 ], [ 125.015060424804688, 10.743400573730469 ], [ 125.180267333984375, 10.543331146240234 ] ] ], [ [ [ 119.82916259765625, 11.376663208007812 ], [ 119.765266418457031, 11.40110969543457 ], [ 119.714431762695312, 11.472149848937988 ], [ 119.8731689453125, 11.504859924316406 ], [ 119.82916259765625, 11.376663208007812 ] ] ], [ [ [ 92.62664794921875, 11.353609085083008 ], [ 92.596305847167969, 11.373886108398438 ], [ 92.64019775390625, 11.512221336364746 ], [ 92.702629089355469, 11.383609771728516 ], [ 92.62664794921875, 11.353609085083008 ] ] ], [ [ [ 117.244979858398438, 8.564998626708984 ], [ 118.755516052246094, 10.12385082244873 ], [ 118.80108642578125, 10.034721374511719 ], [ 119.006515502929688, 10.439303398132324 ], [ 119.131584167480469, 10.383678436279297 ], [ 119.313446044921875, 10.584164619445801 ], [ 119.216644287109375, 10.955483436584473 ], [ 119.455543518066406, 10.723956108093262 ], [ 119.302749633789062, 11.006110191345215 ], [ 119.5010986328125, 11.413610458374023 ], [ 119.484016418457031, 10.879302978515625 ], [ 119.715850830078125, 10.51093578338623 ], [ 119.328598022460938, 10.309443473815918 ], [ 119.201934814453125, 10.048470497131348 ], [ 118.753326416015625, 9.92499828338623 ], [ 118.753364562988281, 9.654507637023926 ], [ 118.348594665527344, 9.18860912322998 ], [ 117.201583862304688, 8.327359199523926 ], [ 117.244979858398438, 8.564998626708984 ] ] ], [ [ [ 123.333602905273438, 9.410276412963867 ], [ 123.374000549316406, 9.990692138671875 ], [ 124.050262451171875, 11.277498245239258 ], [ 124.019989013671875, 10.387012481689453 ], [ 123.636512756347656, 10.069859504699707 ], [ 123.333602905273438, 9.410276412963867 ] ] ], [ [ [ 72.776931762695312, 11.185555458068848 ], [ 72.771171569824219, 11.192428588867188 ], [ 72.788444519042969, 11.251248359680176 ], [ 72.7783203125, 11.188886642456055 ], [ 72.776931762695312, 11.185555458068848 ] ] ], [ [ [ 122.813873291015625, 10.051109313964844 ], [ 122.952476501464844, 10.894444465637207 ], [ 123.504714965820312, 10.937359809875488 ], [ 123.563873291015625, 10.794164657592773 ], [ 123.138671875, 9.82965087890625 ], [ 123.315536499023438, 9.319164276123047 ], [ 123.129280090332031, 9.044998168945312 ], [ 122.939010620117188, 9.074164390563965 ], [ 122.866371154785156, 9.324026107788086 ], [ 122.41387939453125, 9.658332824707031 ], [ 122.453872680664062, 9.974859237670898 ], [ 122.813873291015625, 10.051109313964844 ] ] ], [ [ [ 98.283843994140625, 10.725276947021484 ], [ 98.076995849609375, 10.887221336364746 ], [ 98.139854431152344, 10.975552558898926 ], [ 98.212203979492188, 10.947776794433594 ], [ 98.283843994140625, 10.725276947021484 ] ] ], [ [ [ 92.560470581054688, 10.776969909667969 ], [ 92.507492065429688, 10.531387329101562 ], [ 92.359291076660156, 10.542637825012207 ], [ 92.35693359375, 10.789859771728516 ], [ 92.498039245605469, 10.900832176208496 ], [ 92.560470581054688, 10.776969909667969 ] ] ], [ [ [ 72.198867797851562, 10.863609313964844 ], [ 72.179977416992188, 10.817497253417969 ], [ 72.170806884765625, 10.81242847442627 ], [ 72.1805419921875, 10.848052978515625 ], [ 72.198867797851562, 10.863609313964844 ] ] ], [ [ [ 125.766387939453125, 10.685555458068848 ], [ 125.661239624023438, 10.754096031188965 ], [ 125.695320129394531, 10.82319164276123 ], [ 125.822288513183594, 10.717983245849609 ], [ 125.766387939453125, 10.685555458068848 ] ] ], [ [ [ 122.543869018554688, 10.403053283691406 ], [ 122.479713439941406, 10.487775802612305 ], [ 122.672203063964844, 10.744857788085938 ], [ 122.731086730957031, 10.617774963378906 ], [ 122.543869018554688, 10.403053283691406 ] ] ], [ [ [ 115.821929931640625, 10.711942672729492 ], [ 115.814422607421875, 10.724441528320312 ], [ 115.834014892578125, 10.730691909790039 ], [ 115.840812683105469, 10.721108436584473 ], [ 115.821929931640625, 10.711942672729492 ] ] ], [ [ [ 106.781723022460938, 10.663169860839844 ], [ 106.856475830078125, 10.6038818359375 ], [ 106.8419189453125, 10.4022216796875 ], [ 106.755538940429688, 10.481386184692383 ], [ 106.781723022460938, 10.663169860839844 ] ] ], [ [ [ 119.816940307617188, 10.439165115356445 ], [ 119.760826110839844, 10.558748245239258 ], [ 119.997062683105469, 10.595344543457031 ], [ 119.993316650390625, 10.527498245239258 ], [ 119.816940307617188, 10.439165115356445 ] ] ], [ [ [ 72.649993896484375, 10.56694221496582 ], [ 72.633323669433594, 10.550681114196777 ], [ 72.626289367675781, 10.551109313964844 ], [ 72.652069091796875, 10.573538780212402 ], [ 72.649993896484375, 10.56694221496582 ] ] ], [ [ [ 125.646652221679688, 9.821664810180664 ], [ 125.475273132324219, 10.131109237670898 ], [ 125.63665771484375, 10.466665267944336 ], [ 125.711654663085938, 9.892359733581543 ], [ 125.646652221679688, 9.821664810180664 ] ] ], [ [ [ 104.01239013671875, 10.439432144165039 ], [ 104.0828857421875, 10.364858627319336 ], [ 104.026382446289062, 10.080275535583496 ], [ 103.83837890625, 10.367705345153809 ], [ 104.01239013671875, 10.439432144165039 ] ] ], [ [ [ 124.528587341308594, 10.055553436279297 ], [ 124.599220275878906, 9.761734008789062 ], [ 124.357208251953125, 9.623608589172363 ], [ 123.956939697265625, 9.598608016967773 ], [ 123.791793823242188, 9.733330726623535 ], [ 124.152488708496094, 10.148055076599121 ], [ 124.528587341308594, 10.055553436279297 ] ] ], [ [ [ 125.279708862304688, 9.90777587890625 ], [ 125.124420166015625, 10.082775115966797 ], [ 125.128517150878906, 10.155553817749023 ], [ 125.215957641601562, 10.124024391174316 ], [ 125.279708862304688, 9.90777587890625 ] ] ], [ [ [ 73.646652221679688, 10.084720611572266 ], [ 73.645263671875, 10.068609237670898 ], [ 73.636032104492188, 10.053122520446777 ], [ 73.642692565917969, 10.096803665161133 ], [ 73.646652221679688, 10.084720611572266 ] ] ], [ [ [ 98.283615112304688, 10.00697135925293 ], [ 98.136024475097656, 9.839581489562988 ], [ 98.114631652832031, 9.859580993652344 ], [ 98.175117492675781, 10.014442443847656 ], [ 98.283615112304688, 10.00697135925293 ] ] ], [ [ [ 126.031936645507812, 9.742496490478516 ], [ 125.945533752441406, 9.830831527709961 ], [ 126.073043823242188, 10.05201244354248 ], [ 126.174705505371094, 9.805136680603027 ], [ 126.031936645507812, 9.742496490478516 ] ] ], [ [ [ 79.835952758789062, 7.268310546875 ], [ 79.697898864746094, 8.194442749023438 ], [ 79.814567565917969, 7.984443664550781 ], [ 79.919082641601562, 8.937637329101562 ], [ 80.194976806640625, 9.47027587890625 ], [ 80.051094055175781, 9.592497825622559 ], [ 80.610328674316406, 9.444720268249512 ], [ 79.93914794921875, 9.703052520751953 ], [ 80.1136474609375, 9.802998542785645 ], [ 80.441917419433594, 9.577012062072754 ], [ 80.140548706054688, 9.792221069335938 ], [ 80.2420654296875, 9.828192710876465 ], [ 80.824432373046875, 9.261943817138672 ], [ 80.917762756347656, 8.939304351806641 ], [ 81.232070922851562, 8.64861011505127 ], [ 81.139289855957031, 8.491525650024414 ], [ 81.358314514160156, 8.491107940673828 ], [ 81.391937255859375, 8.149442672729492 ], [ 81.855819702148438, 7.405277252197266 ], [ 81.890548706054688, 7.000555038452148 ], [ 81.661102294921875, 6.439998626708984 ], [ 80.589569091796875, 5.918054580688477 ], [ 80.082763671875, 6.168054580688477 ], [ 79.835952758789062, 7.268310546875 ] ] ], [ [ [ 122.32916259765625, 7.308332443237305 ], [ 122.149986267089844, 6.905277252197266 ], [ 121.947196960449219, 6.959999084472656 ], [ 122.225395202636719, 7.964165687561035 ], [ 122.923027038574219, 8.15083122253418 ], [ 123.025688171386719, 8.488747596740723 ], [ 123.304702758789062, 8.523054122924805 ], [ 123.378593444824219, 8.725275993347168 ], [ 123.818046569824219, 8.47694206237793 ], [ 123.866371154785156, 8.160415649414062 ], [ 123.667198181152344, 7.954443454742432 ], [ 124.224006652832031, 8.212497711181641 ], [ 124.432212829589844, 8.615274429321289 ], [ 124.72747802734375, 8.486385345458984 ], [ 124.800811767578125, 8.999581336975098 ], [ 125.090553283691406, 8.825275421142578 ], [ 125.51470947265625, 9.00666618347168 ], [ 125.440261840820312, 9.809164047241211 ], [ 126.18609619140625, 9.242774963378906 ], [ 126.334991455078125, 8.841803550720215 ], [ 126.084434509277344, 8.609720230102539 ], [ 126.3922119140625, 8.507499694824219 ], [ 126.365806579589844, 7.882498741149902 ], [ 126.551933288574219, 7.692220687866211 ], [ 126.581863403320312, 7.284304618835449 ], [ 126.280685424804688, 6.921248912811279 ], [ 126.348312377929688, 6.800484657287598 ], [ 126.165267944335938, 6.881665229797363 ], [ 126.191650390625, 6.272221565246582 ], [ 125.856094360351562, 7.345276832580566 ], [ 125.651512145996094, 7.234582424163818 ], [ 125.377616882324219, 6.723609924316406 ], [ 125.702766418457031, 6.024999141693115 ], [ 125.405548095703125, 5.563332557678223 ], [ 125.191650390625, 5.767221450805664 ], [ 125.259429931640625, 6.093332767486572 ], [ 124.956939697265625, 5.851387977600098 ], [ 124.067489624023438, 6.379165649414062 ], [ 123.96832275390625, 6.926665306091309 ], [ 124.268600463867188, 7.374443054199219 ], [ 124.011932373046875, 7.64861011505127 ], [ 123.458877563476562, 7.810554504394531 ], [ 123.403053283691406, 7.356388092041016 ], [ 123.111099243164062, 7.519999504089355 ], [ 123.117210388183594, 7.728888034820557 ], [ 122.992759704589844, 7.455485343933105 ], [ 122.812759399414062, 7.436943054199219 ], [ 122.816940307617188, 7.732221603393555 ], [ 122.658866882324219, 7.781110763549805 ], [ 122.32916259765625, 7.308332443237305 ] ] ], [ [ [ 125.943862915039062, 9.555831909179688 ], [ 125.90179443359375, 9.612358093261719 ], [ 125.940811157226562, 9.755693435668945 ], [ 125.9910888671875, 9.661943435668945 ], [ 125.943862915039062, 9.555831909179688 ] ] ], [ [ [ 114.372207641601562, 9.69972038269043 ], [ 114.368316650390625, 9.704998016357422 ], [ 114.37359619140625, 9.708332061767578 ], [ 114.377761840820312, 9.706108093261719 ], [ 114.372207641601562, 9.69972038269043 ] ] ], [ [ [ 100.077316284179688, 9.545204162597656 ], [ 100.019989013671875, 9.422636985778809 ], [ 99.941017150878906, 9.422567367553711 ], [ 99.932205200195312, 9.546943664550781 ], [ 100.077316284179688, 9.545204162597656 ] ] ], [ [ [ 123.586380004882812, 9.088886260986328 ], [ 123.457206726074219, 9.190553665161133 ], [ 123.628585815429688, 9.296804428100586 ], [ 123.707633972167969, 9.138054847717285 ], [ 123.586380004882812, 9.088886260986328 ] ] ], [ [ [ 92.786651611328125, 9.238605499267578 ], [ 92.808311462402344, 9.149860382080078 ], [ 92.731369018554688, 9.127358436584473 ], [ 92.7127685546875, 9.210275650024414 ], [ 92.786651611328125, 9.238605499267578 ] ] ], [ [ [ 124.771652221679688, 9.07472038269043 ], [ 124.635269165039062, 9.169998168945312 ], [ 124.672760009765625, 9.253053665161133 ], [ 124.776924133300781, 9.209442138671875 ], [ 124.771652221679688, 9.07472038269043 ] ] ], [ [ [ 79.756103515625, 9.102497100830078 ], [ 79.90081787109375, 9.03277587890625 ], [ 79.894989013671875, 8.986663818359375 ], [ 79.696090698242188, 9.093469619750977 ], [ 79.756103515625, 9.102497100830078 ] ] ], [ [ [ 117.29498291015625, 8.181665420532227 ], [ 117.268051147460938, 8.306108474731445 ], [ 117.318534851074219, 8.330623626708984 ], [ 117.344146728515625, 8.206733703613281 ], [ 117.29498291015625, 8.181665420532227 ] ] ], [ [ [ 73.081939697265625, 8.30305290222168 ], [ 73.065811157226562, 8.263053894042969 ], [ 73.031028747558594, 8.247496604919434 ], [ 73.020408630371094, 8.262429237365723 ], [ 73.081939697265625, 8.30305290222168 ] ] ], [ [ [ 93.534072875976562, 8.208826065063477 ], [ 93.534774780273438, 8.037636756896973 ], [ 93.483245849609375, 7.990693092346191 ], [ 93.447128295898438, 8.162360191345215 ], [ 93.534072875976562, 8.208826065063477 ] ] ], [ [ [ 98.332763671875, 8.162193298339844 ], [ 98.441085815429688, 7.906109809875488 ], [ 98.309074401855469, 7.757221698760986 ], [ 98.282073974609375, 8.183331489562988 ], [ 98.332763671875, 8.162193298339844 ] ] ], [ [ [ 98.536941528320312, 8.107353210449219 ], [ 98.610816955566406, 8.051109313964844 ], [ 98.598388671875, 7.899026870727539 ], [ 98.574920654296875, 7.913540840148926 ], [ 98.536941528320312, 8.107353210449219 ] ] ], [ [ [ 117.015266418457031, 7.805276870727539 ], [ 116.949996948242188, 8.032220840454102 ], [ 117.066787719726562, 8.077915191650391 ], [ 117.093315124511719, 7.907082557678223 ], [ 117.015266418457031, 7.805276870727539 ] ] ], [ [ [ 93.391448974609375, 8.011722564697266 ], [ 93.450271606445312, 7.929165840148926 ], [ 93.453598022460938, 7.868957042694092 ], [ 93.309005737304688, 7.925415515899658 ], [ 93.391448974609375, 8.011722564697266 ] ] ], [ [ [ 93.695541381835938, 7.410284042358398 ], [ 93.727272033691406, 7.324027061462402 ], [ 93.620399475097656, 7.249721527099609 ], [ 93.617622375488281, 7.367082118988037 ], [ 93.695541381835938, 7.410284042358398 ] ] ], [ [ [ 122.832763671875, 7.275277137756348 ], [ 122.80615234375, 7.422359943389893 ], [ 122.929977416992188, 7.422776222229004 ], [ 122.975608825683594, 7.365137577056885 ], [ 122.832763671875, 7.275277137756348 ] ] ], [ [ [ 116.85693359375, 7.183887481689453 ], [ 116.878730773925781, 7.274165630340576 ], [ 117.000885009765625, 7.35291576385498 ], [ 117.018043518066406, 7.266735553741455 ], [ 116.85693359375, 7.183887481689453 ] ] ], [ [ [ 117.09326171875, 7.293454170227051 ], [ 117.268180847167969, 7.343887805938721 ], [ 117.250534057617188, 7.179165363311768 ], [ 117.066444396972656, 7.105068206787109 ], [ 117.09326171875, 7.293454170227051 ] ] ], [ [ [ 93.8680419921875, 7.182302474975586 ], [ 93.9296875, 6.949165344238281 ], [ 93.827064514160156, 6.745831966400146 ], [ 93.643600463867188, 7.118609428405762 ], [ 93.8680419921875, 7.182302474975586 ] ] ], [ [ [ 125.767486572265625, 6.887499809265137 ], [ 125.6634521484375, 7.098610401153564 ], [ 125.698448181152344, 7.190276145935059 ], [ 125.796791076660156, 7.119443416595459 ], [ 125.767486572265625, 6.887499809265137 ] ] ], [ [ [ 72.97998046875, 7.027776718139648 ], [ 72.982719421386719, 7.012985229492188 ], [ 72.974220275878906, 7.027568817138672 ], [ 72.97998046875, 7.027776718139648 ] ] ], [ [ [ 111.896377563476562, -3.573889255523682 ], [ 111.751686096191406, -2.749826431274414 ], [ 111.547203063964844, -3.024166822433472 ], [ 111.335823059082031, -2.921111106872559 ], [ 110.962486267089844, -3.096388816833496 ], [ 110.756790161132812, -3.034166812896729 ], [ 110.93359375, -2.886944770812988 ], [ 110.666091918945312, -3.081666707992554 ], [ 110.55108642578125, -2.869166374206543 ], [ 110.23193359375, -2.971110820770264 ], [ 110.125808715820312, -2.046944618225098 ], [ 109.903587341308594, -1.828333616256714 ], [ 110.057746887207031, -1.333889007568359 ], [ 109.729713439941406, -0.953611135482788 ], [ 109.279983520507812, -0.868055462837219 ], [ 109.258186340332031, -0.669305562973022 ], [ 109.514427185058594, -0.726944446563721 ], [ 109.151092529296875, -0.546666741371155 ], [ 109.042633056640625, -0.248888909816742 ], [ 109.194427490234375, -0.199166655540466 ], [ 109.165542602539062, 0.106388881802559 ], [ 108.918594360351562, 0.315138846635818 ], [ 108.845489501953125, 0.810562133789062 ], [ 108.958602905273438, 1.176666498184204 ], [ 109.095832824707031, 1.211666345596313 ], [ 109.263603210449219, 1.394583106040955 ], [ 108.981239318847656, 1.214444160461426 ], [ 109.062187194824219, 1.523333311080933 ], [ 109.648567199707031, 2.073408603668213 ], [ 109.928031921386719, 1.690485715866089 ], [ 110.330543518066406, 1.801527619361877 ], [ 110.733680725097656, 1.540133714675903 ], [ 110.687477111816406, 1.444721937179565 ], [ 110.821929931640625, 1.568055391311646 ], [ 111.155548095703125, 1.363888740539551 ], [ 111.378311157226562, 1.345972061157227 ], [ 111.0, 1.572083115577698 ], [ 111.369979858398438, 2.146666526794434 ], [ 111.172752380371094, 2.145971775054932 ], [ 111.183036804199219, 2.262221813201904 ], [ 111.225395202636719, 2.422499656677246 ], [ 111.368110656738281, 2.339094400405884 ], [ 111.450271606445312, 2.368610382080078 ], [ 111.448455810546875, 2.694721698760986 ], [ 113.010536193847656, 3.160554885864258 ], [ 113.92608642578125, 4.244165420532227 ], [ 113.974845886230469, 4.591943740844727 ], [ 114.300811767578125, 4.595554351806641 ], [ 115.051376342773438, 5.050276756286621 ], [ 115.049980163574219, 4.798332214355469 ], [ 115.378860473632812, 4.911665916442871 ], [ 115.57415771484375, 5.179165840148926 ], [ 115.380256652832031, 5.400971412658691 ], [ 115.848876953125, 5.563887596130371 ], [ 116.754173278808594, 7.018054962158203 ], [ 116.79998779296875, 6.576665878295898 ], [ 117.178306579589844, 6.990276336669922 ], [ 117.288040161132812, 6.6398606300354 ], [ 117.739288330078125, 6.386943817138672 ], [ 117.60040283203125, 6.192498683929443 ], [ 117.674835205078125, 5.982360363006592 ], [ 117.5030517578125, 5.896110534667969 ], [ 118.006866455078125, 6.061248302459717 ], [ 118.124687194824219, 5.86402702331543 ], [ 117.908172607421875, 5.797568321228027 ], [ 117.955474853515625, 5.685068130493164 ], [ 118.37359619140625, 5.807498931884766 ], [ 119.27581787109375, 5.344999313354492 ], [ 119.069717407226562, 5.069999694824219 ], [ 118.70166015625, 4.94305419921875 ], [ 118.354278564453125, 5.035832405090332 ], [ 118.140548706054688, 4.888332366943359 ], [ 118.282341003417969, 4.680832386016846 ], [ 118.5948486328125, 4.521249294281006 ], [ 118.549568176269531, 4.350971221923828 ], [ 117.995887756347656, 4.224165916442871 ], [ 117.693038940429688, 4.374720573425293 ], [ 117.39276123046875, 4.139721870422363 ], [ 117.782211303710938, 3.788888454437256 ], [ 117.760269165039062, 3.639166355133057 ], [ 117.071868896484375, 3.642707824707031 ], [ 117.031379699707031, 3.600693941116333 ], [ 117.20526123046875, 3.613471746444702 ], [ 117.204986572265625, 3.539999961853027 ], [ 117.237617492675781, 3.489721775054932 ], [ 117.442474365234375, 3.432360649108887 ], [ 117.275398254394531, 3.219999074935913 ], [ 117.618316650390625, 3.088957786560059 ], [ 117.671653747558594, 2.801110744476318 ], [ 118.091926574707031, 2.314444065093994 ], [ 117.829292297363281, 2.104166269302368 ], [ 117.871917724609375, 1.87666654586792 ], [ 119.001930236816406, 0.967083156108856 ], [ 118.794563293457031, 0.800277709960938 ], [ 118.3438720703125, 0.843055367469788 ], [ 117.893051147460938, 1.117777466773987 ], [ 118.034988403320312, 0.810277700424194 ], [ 117.742202758789062, 0.739722013473511 ], [ 117.467483520507812, 0.103611096739769 ], [ 117.444786071777344, -0.523969113826752 ], [ 117.631355285644531, -0.424027770757675 ], [ 117.623451232910156, -0.777222216129303 ], [ 117.265853881835938, -0.82164740562439 ], [ 116.923599243164062, -1.254444599151611 ], [ 116.740257263183594, -1.027916789054871 ], [ 116.755546569824219, -1.367500066757202 ], [ 116.22393798828125, -1.779027819633484 ], [ 116.445457458496094, -1.783194422721863 ], [ 116.32720947265625, -2.147500038146973 ], [ 116.604156494140625, -2.229722023010254 ], [ 116.514717102050781, -2.555277824401855 ], [ 116.30657958984375, -2.517986059188843 ], [ 116.274429321289062, -3.0 ], [ 116.131927490234375, -2.823333740234375 ], [ 116.216377258300781, -3.142777919769287 ], [ 115.966239929199219, -3.608750104904175 ], [ 114.637069702148438, -4.185068607330322 ], [ 114.481086730957031, -3.498610973358154 ], [ 114.102203369140625, -3.356389045715332 ], [ 113.671096801757812, -3.476110935211182 ], [ 113.605819702148438, -3.172638893127441 ], [ 113.365814208984375, -3.260833501815796 ], [ 113.034713745117188, -2.98972225189209 ], [ 112.651657104492188, -3.415277481079102 ], [ 112.245819091796875, -3.313889026641846 ], [ 111.896377563476562, -3.573889255523682 ] ] ], [ [ [ 73.163314819335938, 6.774443626403809 ], [ 73.143875122070312, 6.733887672424316 ], [ 73.131263732910156, 6.731075286865234 ], [ 73.162063598632812, 6.78215217590332 ], [ 73.163314819335938, 6.774443626403809 ] ] ], [ [ [ 117.342742919921875, 6.672527313232422 ], [ 117.467903137207031, 6.761388778686523 ], [ 117.514854431152344, 6.705832481384277 ], [ 117.433319091796875, 6.628332138061523 ], [ 117.342742919921875, 6.672527313232422 ] ] ], [ [ [ 121.99053955078125, 6.408332824707031 ], [ 121.792762756347656, 6.63055419921875 ], [ 122.07568359375, 6.752499580383301 ], [ 122.238311767578125, 6.592221260070801 ], [ 121.99053955078125, 6.408332824707031 ] ] ], [ [ [ 99.662811279296875, 6.702995300292969 ], [ 99.702278137207031, 6.54249906539917 ], [ 99.652626037597656, 6.494790554046631 ], [ 99.596649169921875, 6.585277080535889 ], [ 99.662811279296875, 6.702995300292969 ] ] ], [ [ [ 99.852951049804688, 6.464153289794922 ], [ 99.923019409179688, 6.333610057830811 ], [ 99.73956298828125, 6.248887538909912 ], [ 99.6422119140625, 6.42208194732666 ], [ 99.852951049804688, 6.464153289794922 ] ] ], [ [ [ 73.049148559570312, 6.441665649414062 ], [ 73.043975830078125, 6.431075096130371 ], [ 73.043106079101562, 6.443818092346191 ], [ 73.049148559570312, 6.441665649414062 ] ] ], [ [ [ 120.547210693359375, 6.240276336669922 ], [ 120.47991943359375, 6.257290840148926 ], [ 120.60040283203125, 6.394651889801025 ], [ 120.578598022460938, 6.252221584320068 ], [ 120.547210693359375, 6.240276336669922 ] ] ], [ [ [ 121.288040161132812, 5.854166030883789 ], [ 121.23193359375, 5.941943168640137 ], [ 120.869430541992188, 5.953887939453125 ], [ 121.128311157226562, 6.086666107177734 ], [ 121.4271240234375, 5.977637767791748 ], [ 121.288040161132812, 5.854166030883789 ] ] ], [ [ [ 72.931930541992188, 5.969165802001953 ], [ 72.929840087890625, 5.956804752349854 ], [ 72.927825927734375, 5.971457481384277 ], [ 72.931930541992188, 5.969165802001953 ] ] ], [ [ [ 95.38018798828125, 5.837541580200195 ], [ 95.292465209960938, 5.785554885864258 ], [ 95.210945129394531, 5.90347146987915 ], [ 95.337333679199219, 5.894443511962891 ], [ 95.38018798828125, 5.837541580200195 ] ] ], [ [ [ 73.393051147460938, 5.737776756286621 ], [ 73.392349243164062, 5.726804733276367 ], [ 73.380744934082031, 5.709235191345215 ], [ 73.389366149902344, 5.740554332733154 ], [ 73.393051147460938, 5.737776756286621 ] ] ], [ [ [ 102.976005554199219, 0.64347892999649 ], [ 103.070823669433594, 0.436110973358154 ], [ 102.571014404296875, 0.17624993622303 ], [ 102.430313110351562, 0.2445138245821 ], [ 102.587188720703125, 0.152499943971634 ], [ 103.351089477539062, 0.536110877990723 ], [ 103.739692687988281, 0.281111061573029 ], [ 103.811180114746094, -0.00350043666549 ], [ 103.272346496582031, -0.259583353996277 ], [ 103.492889404296875, -0.218333318829536 ], [ 103.342361450195312, -0.364096313714981 ], [ 103.597564697265625, -0.434999972581863 ], [ 103.360809326171875, -0.702222228050232 ], [ 103.7410888671875, -0.995555520057678 ], [ 104.377761840820312, -1.039305686950684 ], [ 104.489433288574219, -1.924999952316284 ], [ 104.87664794921875, -2.115555763244629 ], [ 104.531791687011719, -2.77138876914978 ], [ 104.864974975585938, -2.288750171661377 ], [ 105.606369018554688, -2.393333435058594 ], [ 105.80859375, -2.896667003631592 ], [ 106.055252075195312, -3.031388759613037 ], [ 105.816093444824219, -3.675000190734863 ], [ 105.95623779296875, -3.855278015136719 ], [ 105.809982299804688, -4.242499351501465 ], [ 105.904426574707031, -4.548610687255859 ], [ 105.728874206542969, -5.898264408111572 ], [ 105.271934509277344, -5.44416618347168 ], [ 105.141586303710938, -5.795346736907959 ], [ 104.543174743652344, -5.508056163787842 ], [ 104.714302062988281, -5.918055534362793 ], [ 104.560775756835938, -5.929747581481934 ], [ 103.891098022460938, -5.11138916015625 ], [ 102.326103210449219, -4.006111145019531 ], [ 102.221229553222656, -3.649027585983276 ], [ 101.626922607421875, -3.246110916137695 ], [ 100.905548095703125, -2.31944465637207 ], [ 100.866378784179688, -1.926388740539551 ], [ 100.293586730957031, -0.806388854980469 ], [ 99.635818481445312, 0.076944425702095 ], [ 99.139595031738281, 0.257916629314423 ], [ 98.703834533691406, 1.559791445732117 ], [ 98.770713806152344, 1.748610734939575 ], [ 97.750251770019531, 2.270832777023315 ], [ 97.596923828125, 2.866943836212158 ], [ 96.8802490234375, 3.677499294281006 ], [ 96.488861083984375, 3.763610363006592 ], [ 95.531082153320312, 4.68277645111084 ], [ 95.23358154296875, 5.570138454437256 ], [ 95.609130859375, 5.626665115356445 ], [ 96.347747802734375, 5.222776412963867 ], [ 97.51483154296875, 5.249444007873535 ], [ 97.91302490234375, 4.886387825012207 ], [ 98.017196655273438, 4.55111026763916 ], [ 98.276779174804688, 4.426804542541504 ], [ 98.270523071289062, 4.142498970031738 ], [ 99.980804443359375, 2.94374942779541 ], [ 99.955116271972656, 2.690277099609375 ], [ 100.00518798828125, 2.601110696792603 ], [ 100.033859252929688, 2.734721660614014 ], [ 100.132949829101562, 2.526874542236328 ], [ 100.205108642578125, 2.705971717834473 ], [ 100.412193298339844, 2.293055057525635 ], [ 100.942459106445312, 1.820555448532104 ], [ 100.799972534179688, 2.225554943084717 ], [ 101.057952880859375, 2.283610582351685 ], [ 101.4105224609375, 1.717221975326538 ], [ 102.135528564453125, 1.373332977294922 ], [ 102.210800170898438, 1.014999628067017 ], [ 102.4256591796875, 0.797499775886536 ], [ 102.976005554199219, 0.64347892999649 ] ] ], [ [ [ 100.308273315429688, 5.44611930847168 ], [ 100.28704833984375, 5.254443645477295 ], [ 100.203857421875, 5.271110534667969 ], [ 100.185798645019531, 5.462291240692139 ], [ 100.308273315429688, 5.44611930847168 ] ] ], [ [ [ 73.62969970703125, 5.418609619140625 ], [ 73.637275695800781, 5.409443378448486 ], [ 73.632484436035156, 5.387638092041016 ], [ 73.622268676757812, 5.418332576751709 ], [ 73.62969970703125, 5.418609619140625 ] ] ], [ [ [ 119.858322143554688, 5.049165725708008 ], [ 119.824981689453125, 5.147221565246582 ], [ 120.211448669433594, 5.346596240997314 ], [ 120.225601196289062, 5.126734733581543 ], [ 119.858322143554688, 5.049165725708008 ] ] ], [ [ [ 72.97943115234375, 4.895554542541504 ], [ 72.968177795410156, 4.878332138061523 ], [ 72.975822448730469, 4.899999141693115 ], [ 72.97943115234375, 4.895554542541504 ] ] ], [ [ [ 118.394622802734375, 4.67604923248291 ], [ 118.478866577148438, 4.689165115356445 ], [ 118.596031188964844, 4.638332843780518 ], [ 118.529708862304688, 4.600276947021484 ], [ 118.394622802734375, 4.67604923248291 ] ] ], [ [ [ 126.749710083007812, 3.983888626098633 ], [ 126.690536499023438, 4.069999694824219 ], [ 126.741859436035156, 4.539790630340576 ], [ 126.915817260742188, 4.275832653045654 ], [ 126.749710083007812, 3.983888626098633 ] ] ], [ [ [ 72.95721435546875, 4.438331604003906 ], [ 72.95623779296875, 4.419304370880127 ], [ 72.942543029785156, 4.425901412963867 ], [ 72.949844360351562, 4.43972110748291 ], [ 72.95721435546875, 4.438331604003906 ] ] ], [ [ [ 117.903556823730469, 4.174042701721191 ], [ 117.867263793945312, 4.026665687561035 ], [ 117.638893127441406, 4.228610038757324 ], [ 117.74609375, 4.2583327293396 ], [ 117.903556823730469, 4.174042701721191 ] ] ], [ [ [ 108.061576843261719, 3.85186767578125 ], [ 107.991653442382812, 4.024166107177734 ], [ 108.251388549804688, 4.179999351501465 ], [ 108.397491455078125, 3.976943969726562 ], [ 108.321098327636719, 3.682638168334961 ], [ 108.117202758789062, 3.676110744476318 ], [ 108.201393127441406, 3.796388626098633 ], [ 108.061576843261719, 3.85186767578125 ] ] ], [ [ [ 73.497482299804688, 4.178332328796387 ], [ 73.505752563476562, 4.176596164703369 ], [ 73.504989624023438, 4.164999008178711 ], [ 73.491920471191406, 4.169235229492188 ], [ 73.497482299804688, 4.178332328796387 ] ] ], [ [ [ 117.610786437988281, 4.102150917053223 ], [ 117.744979858398438, 4.077499389648438 ], [ 117.728591918945312, 4.000277519226074 ], [ 117.605812072753906, 4.026041030883789 ], [ 117.610786437988281, 4.102150917053223 ] ] ], [ [ [ 126.70526123046875, 3.79444408416748 ], [ 126.610809326171875, 3.976804971694946 ], [ 126.603172302246094, 4.036873817443848 ], [ 126.723106384277344, 3.912152051925659 ], [ 126.70526123046875, 3.79444408416748 ] ] ], [ [ [ 125.880813598632812, 3.361944198608398 ], [ 125.645271301269531, 3.658471584320068 ], [ 125.673866271972656, 3.724165916442871 ], [ 125.912071228027344, 3.489166259765625 ], [ 125.880813598632812, 3.361944198608398 ] ] ], [ [ [ 117.235260009765625, 3.579721450805664 ], [ 117.390823364257812, 3.561944007873535 ], [ 117.517486572265625, 3.474443912506104 ], [ 117.266098022460938, 3.499166011810303 ], [ 117.235260009765625, 3.579721450805664 ] ] ], [ [ [ 117.5546875, 3.433342456817627 ], [ 117.67803955078125, 3.411388397216797 ], [ 117.631927490234375, 3.258888721466064 ], [ 117.5576171875, 3.318054914474487 ], [ 117.5546875, 3.433342456817627 ] ] ], [ [ [ 73.583602905273438, 3.374444007873535 ], [ 73.59136962890625, 3.372776985168457 ], [ 73.583877563476562, 3.366388320922852 ], [ 73.581375122070312, 3.368054866790771 ], [ 73.583602905273438, 3.374444007873535 ] ] ], [ [ [ 72.978042602539062, 3.110277652740479 ], [ 72.9849853515625, 3.108333110809326 ], [ 72.982208251953125, 3.101943969726562 ], [ 72.972763061523438, 3.104722023010254 ], [ 72.978042602539062, 3.110277652740479 ] ] ], [ [ [ 105.706298828125, 2.84358024597168 ], [ 105.683868408203125, 3.006388664245605 ], [ 105.700958251953125, 3.059860467910767 ], [ 105.848114013671875, 2.977152109146118 ], [ 105.706298828125, 2.84358024597168 ] ] ], [ [ [ 108.781768798828125, 2.899802207946777 ], [ 108.844154357910156, 2.993610620498657 ], [ 108.895263671875, 2.989721775054932 ], [ 108.839424133300781, 2.848332643508911 ], [ 108.781768798828125, 2.899802207946777 ] ] ], [ [ [ 72.870254516601562, 2.969165802001953 ], [ 72.872306823730469, 2.95854115486145 ], [ 72.863388061523438, 2.966596603393555 ], [ 72.870254516601562, 2.969165802001953 ] ] ], [ [ [ 73.586105346679688, 2.961666107177734 ], [ 73.577629089355469, 2.951006412506104 ], [ 73.585403442382812, 2.965624570846558 ], [ 73.586105346679688, 2.961666107177734 ] ] ], [ [ [ 96.484130859375, 2.371110439300537 ], [ 96.332130432128906, 2.352569103240967 ], [ 95.696914672851562, 2.818888664245605 ], [ 95.883316040039062, 2.918888568878174 ], [ 96.484130859375, 2.371110439300537 ] ] ], [ [ [ 104.187942504882812, 2.867785930633545 ], [ 104.220726013183594, 2.721874237060547 ], [ 104.167747497558594, 2.705277442932129 ], [ 104.123291015625, 2.781666278839111 ], [ 104.187942504882812, 2.867785930633545 ] ] ], [ [ [ 125.44586181640625, 2.752497673034668 ], [ 125.42608642578125, 2.644305229187012 ], [ 125.38970947265625, 2.629443645477295 ], [ 125.380821228027344, 2.792916297912598 ], [ 125.44586181640625, 2.752497673034668 ] ] ], [ [ [ 111.311836242675781, 2.497216701507568 ], [ 111.293319702148438, 2.733333110809326 ], [ 111.328948974609375, 2.780346870422363 ], [ 111.411514282226562, 2.376388311386108 ], [ 111.311836242675781, 2.497216701507568 ] ] ], [ [ [ 128.276641845703125, 2.017295360565186 ], [ 128.232177734375, 2.306110382080078 ], [ 128.576416015625, 2.629096508026123 ], [ 128.619964599609375, 2.215277194976807 ], [ 128.276641845703125, 2.017295360565186 ] ] ], [ [ [ 73.35443115234375, 2.437221527099609 ], [ 73.368728637695312, 2.407638072967529 ], [ 73.365257263183594, 2.384166240692139 ], [ 73.350677490234375, 2.438055038452148 ], [ 73.35443115234375, 2.437221527099609 ] ] ], [ [ [ 97.342742919921875, 2.053632259368896 ], [ 97.320816040039062, 2.030277252197266 ], [ 97.108306884765625, 2.221943855285645 ], [ 97.284553527832031, 2.225763082504272 ], [ 97.342742919921875, 2.053632259368896 ] ] ], [ [ [ 127.8135986328125, 0.79444432258606 ], [ 128.16644287109375, 1.132152438163757 ], [ 128.18829345703125, 1.378055334091187 ], [ 128.72454833984375, 1.556944251060486 ], [ 128.697479248046875, 1.101944208145142 ], [ 128.2120361328125, 0.779652655124664 ], [ 128.674301147460938, 0.552812337875366 ], [ 128.683029174804688, 0.357291579246521 ], [ 128.829559326171875, 0.299999922513962 ], [ 128.9049072265625, 0.203263863921165 ], [ 128.0738525390625, 0.466111063957214 ], [ 127.879142761230469, 0.299513816833496 ], [ 128.03692626953125, -0.403333365917206 ], [ 128.40179443359375, -0.888194441795349 ], [ 128.021087646484375, -0.693194448947906 ], [ 127.6639404296875, -0.215138882398605 ], [ 127.522628784179688, 0.601527631282806 ], [ 127.614356994628906, 0.852777600288391 ], [ 127.394989013671875, 1.061666488647461 ], [ 127.568183898925781, 1.739166259765625 ], [ 128.054061889648438, 2.192430019378662 ], [ 127.855674743652344, 1.916249632835388 ], [ 128.012619018554688, 1.714721918106079 ], [ 127.989700317382812, 1.346666574478149 ], [ 127.629844665527344, 0.982083201408386 ], [ 127.8135986328125, 0.79444432258606 ] ] ], [ [ [ 101.7742919921875, 1.939500570297241 ], [ 101.601638793945312, 1.709166049957275 ], [ 101.393714904785156, 1.915555238723755 ], [ 101.642051696777344, 2.119999408721924 ], [ 101.7742919921875, 1.939500570297241 ] ] ], [ [ [ 73.553314208984375, 1.932499647140503 ], [ 73.550537109375, 1.898194193840027 ], [ 73.541923522949219, 1.891249656677246 ], [ 73.551513671875, 1.936666369438171 ], [ 73.553314208984375, 1.932499647140503 ] ] ], [ [ [ 98.57781982421875, 1.622818946838379 ], [ 98.448013305664062, 1.640555381774902 ], [ 98.428573608398438, 1.681249737739563 ], [ 98.5550537109375, 1.681666374206543 ], [ 98.57781982421875, 1.622818946838379 ] ] ], [ [ [ 120.827232360839844, 1.234058737754822 ], [ 121.0938720703125, 1.324166536331177 ], [ 121.572769165039062, 1.058333158493042 ], [ 122.464431762695312, 0.999166488647461 ], [ 122.8463134765625, 0.814672827720642 ], [ 123.203048706054688, 0.956666588783264 ], [ 123.839157104492188, 0.829444289207458 ], [ 124.589706420898438, 1.191388487815857 ], [ 124.555816650390625, 1.369999885559082 ], [ 124.971099853515625, 1.694721937179565 ], [ 125.249008178710938, 1.508610963821411 ], [ 124.24609375, 0.374999940395355 ], [ 123.645828247070312, 0.281111061573029 ], [ 123.262771606445312, 0.31333327293396 ], [ 123.068038940429688, 0.509583234786987 ], [ 121.79248046875, 0.422638803720474 ], [ 121.537338256835938, 0.538055419921875 ], [ 121.104850769042969, 0.407222151756287 ], [ 120.549148559570312, 0.536110997200012 ], [ 120.242202758789062, 0.344999969005585 ], [ 120.019989013671875, -0.075277775526047 ], [ 120.066093444824219, -0.613055467605591 ], [ 120.51361083984375, -1.000277996063232 ], [ 120.664573669433594, -1.393888831138611 ], [ 121.080551147460938, -1.424583315849304 ], [ 121.622207641601562, -0.805000066757202 ], [ 121.927757263183594, -0.963333368301392 ], [ 122.2269287109375, -0.760833382606506 ], [ 122.917625427246094, -0.764861166477203 ], [ 122.730331420898438, -0.654166698455811 ], [ 123.070831298828125, -0.559722185134888 ], [ 123.454986572265625, -0.765555620193481 ], [ 123.333747863769531, -1.056111216545105 ], [ 123.153053283691406, -0.896666765213013 ], [ 122.819992065429688, -0.913333415985107 ], [ 122.377059936523438, -1.4897221326828 ], [ 121.836647033691406, -1.691388845443726 ], [ 121.665534973144531, -1.924860954284668 ], [ 121.298721313476562, -1.800416707992554 ], [ 122.476226806640625, -3.160902738571167 ], [ 122.198593139648438, -3.5813889503479 ], [ 122.59942626953125, -3.88361120223999 ], [ 122.683998107910156, -4.139028072357178 ], [ 122.857757568359375, -4.076389312744141 ], [ 122.89373779296875, -4.398055553436279 ], [ 122.104713439941406, -4.526111602783203 ], [ 122.078048706054688, -4.843611717224121 ], [ 121.552413940429688, -4.745694160461426 ], [ 121.614700317382812, -4.064722061157227 ], [ 120.864990234375, -3.485000133514404 ], [ 121.069572448730469, -3.205138921737671 ], [ 121.071929931640625, -2.742499828338623 ], [ 120.686920166015625, -2.6438889503479 ], [ 120.201934814453125, -2.963333368301392 ], [ 120.408599853515625, -3.25861120223999 ], [ 120.422210693359375, -4.678333282470703 ], [ 120.266098022460938, -5.152777671813965 ], [ 120.463462829589844, -5.619791507720947 ], [ 120.328880310058594, -5.512084007263184 ], [ 119.672622680664062, -5.701250076293945 ], [ 119.354911804199219, -5.400069713592529 ], [ 119.623306274414062, -4.328056335449219 ], [ 119.506103515625, -3.527222156524658 ], [ 119.293045043945312, -3.427639007568359 ], [ 118.925682067871094, -3.57319450378418 ], [ 118.888603210449219, -2.893194675445557 ], [ 118.759162902832031, -2.774166584014893 ], [ 119.143531799316406, -2.453124761581421 ], [ 119.211380004882812, -2.011944770812988 ], [ 119.354011535644531, -1.936110973358154 ], [ 119.308868408203125, -1.265277862548828 ], [ 119.5172119140625, -0.876388788223267 ], [ 119.718597412109375, -0.653611183166504 ], [ 119.863037109375, -0.843888878822327 ], [ 119.795883178710938, -0.115833334624767 ], [ 119.625648498535156, 0.000208333134651 ], [ 119.829986572265625, -0.093472227454185 ], [ 119.778053283691406, 0.229722172021866 ], [ 120.257217407226562, 0.971944332122803 ], [ 120.574844360351562, 0.776944398880005 ], [ 120.827232360839844, 1.234058737754822 ] ] ], [ [ [ 102.495246887207031, 1.436335563659668 ], [ 102.491912841796875, 1.259721755981445 ], [ 102.308853149414062, 1.420555114746094 ], [ 102.100517272949219, 1.465832710266113 ], [ 101.994071960449219, 1.606943964958191 ], [ 102.495246887207031, 1.436335563659668 ] ] ], [ [ [ 97.810791015625, 0.549722075462341 ], [ 97.699272155761719, 0.578055441379547 ], [ 97.11468505859375, 1.393333196640015 ], [ 97.482467651367188, 1.46999979019165 ], [ 97.909347534179688, 1.039235949516296 ], [ 97.810791015625, 0.549722075462341 ] ] ], [ [ [ 103.99053955078125, 1.383290767669678 ], [ 103.8419189453125, 1.259027600288391 ], [ 103.640945434570312, 1.31833291053772 ], [ 103.713592529296875, 1.429443836212158 ], [ 103.99053955078125, 1.383290767669678 ] ] ], [ [ [ 102.477432250976562, 1.206051349639893 ], [ 102.373291015625, 0.925277590751648 ], [ 102.210945129394531, 1.403610587120056 ], [ 102.288993835449219, 1.406249523162842 ], [ 102.477432250976562, 1.206051349639893 ] ] ], [ [ [ 104.666893005371094, 1.023826599121094 ], [ 104.58331298828125, 0.819166541099548 ], [ 104.231361389160156, 1.084999799728394 ], [ 104.408714294433594, 1.196805357933044 ], [ 104.666893005371094, 1.023826599121094 ] ] ], [ [ [ 104.153053283691406, 1.135360717773438 ], [ 104.078323364257812, 0.985555410385132 ], [ 103.90087890625, 1.089583158493042 ], [ 104.096076965332031, 1.187777519226074 ], [ 104.153053283691406, 1.135360717773438 ] ] ], [ [ [ 103.08306884765625, 0.837141275405884 ], [ 102.761558532714844, 1.029624819755554 ], [ 102.692733764648438, 1.023333072662354 ], [ 102.712608337402344, 1.149999618530273 ], [ 103.037193298339844, 1.037777423858643 ], [ 103.08306884765625, 0.837141275405884 ] ] ], [ [ [ 103.051567077636719, 0.78606379032135 ], [ 102.500808715820312, 0.793055295944214 ], [ 102.473297119140625, 1.117777347564697 ], [ 102.888031005859375, 0.939027547836304 ], [ 103.051567077636719, 0.78606379032135 ] ] ], [ [ [ 103.435531616210938, 1.025212287902832 ], [ 103.349403381347656, 1.004999756813049 ], [ 103.339828491210938, 1.118054986000061 ], [ 103.3857421875, 1.12506890296936 ], [ 103.435531616210938, 1.025212287902832 ] ] ], [ [ [ 104.175537109375, 0.790833234786987 ], [ 104.098037719726562, 0.882222056388855 ], [ 104.094711303710938, 0.947222113609314 ], [ 104.260826110839844, 0.86597204208374 ], [ 104.175537109375, 0.790833234786987 ] ] ], [ [ [ 103.50665283203125, 0.740299820899963 ], [ 103.402481079101562, 0.660833120346069 ], [ 103.373008728027344, 0.888263702392578 ], [ 103.4669189453125, 0.808888673782349 ], [ 103.50665283203125, 0.740299820899963 ] ] ], [ [ [ 103.296890258789062, 0.588943123817444 ], [ 103.273033142089844, 0.529999852180481 ], [ 103.135246276855469, 0.54361093044281 ], [ 103.204421997070312, 0.702499747276306 ], [ 103.296890258789062, 0.588943123817444 ] ] ], [ [ [ 73.51361083984375, 0.387777745723724 ], [ 73.5101318359375, 0.380486041307449 ], [ 73.507972717285156, 0.390416622161865 ], [ 73.51361083984375, 0.387777745723724 ] ] ], [ [ [ 104.696929931640625, 0.022777773439884 ], [ 104.593154907226562, 0.097222208976746 ], [ 104.491905212402344, 0.2336805164814 ], [ 104.541221618652344, 0.224722191691399 ], [ 104.696929931640625, 0.022777773439884 ] ] ], [ [ [ 73.095535278320312, 0.228055506944656 ], [ 73.101234436035156, 0.229166626930237 ], [ 73.106788635253906, 0.214166641235352 ], [ 73.095748901367188, 0.221111074090004 ], [ 73.095535278320312, 0.228055506944656 ] ] ], [ [ [ 98.805328369140625, 0.094265088438988 ], [ 98.637657165527344, 0.077361099421978 ], [ 98.514328002929688, 0.135555535554886 ], [ 98.762802124023438, 0.171666651964188 ], [ 98.805328369140625, 0.094265088438988 ] ] ], [ [ [ 129.536376953125, -0.222499996423721 ], [ 129.29193115234375, 0.031388882547617 ], [ 129.28997802734375, 0.043055549263954 ], [ 129.543167114257812, -0.143055558204651 ], [ 129.536376953125, -0.222499996423721 ] ] ], [ [ [ 104.929428100585938, -0.334166705608368 ], [ 104.442893981933594, -0.22249998152256 ], [ 104.524978637695312, 0.010416666045785 ], [ 104.888893127441406, -0.193611085414886 ], [ 104.929428100585938, -0.334166705608368 ] ] ], [ [ [ 98.544143676757812, -0.386388897895813 ], [ 98.29193115234375, -0.015277778729796 ], [ 98.300811767578125, -0.007222223095596 ], [ 98.45220947265625, -0.073888897895813 ], [ 98.544143676757812, -0.386388897895813 ] ] ], [ [ [ 130.842864990234375, -0.441044896841049 ], [ 130.680221557617188, -0.303431868553162 ], [ 130.219329833984375, -0.211249992251396 ], [ 130.82470703125, -0.008672382682562 ], [ 131.299835205078125, -0.167638882994652 ], [ 131.25555419921875, -0.387777805328369 ], [ 130.977874755859375, -0.36388885974884 ], [ 130.614334106445312, -0.08909722417593 ], [ 130.917755126953125, -0.321250051259995 ], [ 130.842864990234375, -0.441044896841049 ] ] ], [ [ [ 103.721153259277344, -0.272436857223511 ], [ 103.752777099609375, -0.353333353996277 ], [ 103.453590393066406, -0.359861105680466 ], [ 103.538307189941406, -0.232222199440002 ], [ 103.721153259277344, -0.272436857223511 ] ] ], [ [ [ 98.502212524414062, -0.466386318206787 ], [ 98.326095581054688, -0.539722204208374 ], [ 98.423179626464844, -0.249583348631859 ], [ 98.511932373046875, -0.370555520057678 ], [ 98.502212524414062, -0.466386318206787 ] ] ], [ [ [ 127.243270874023438, -0.267774045467377 ], [ 127.254020690917969, -0.497638881206512 ], [ 127.116371154785156, -0.525000095367432 ], [ 127.105674743652344, -0.294444441795349 ], [ 127.243270874023438, -0.267774045467377 ] ] ], [ [ [ 73.435256958007812, -0.283611118793488 ], [ 73.442474365234375, -0.286319434642792 ], [ 73.446022033691406, -0.304999977350235 ], [ 73.429771423339844, -0.285902768373489 ], [ 73.435256958007812, -0.283611118793488 ] ] ], [ [ [ 127.531303405761719, -0.31034904718399 ], [ 127.68414306640625, -0.467777788639069 ], [ 127.649154663085938, -0.704305589199066 ], [ 127.895751953125, -0.777916729450226 ], [ 127.815254211425781, -0.871805489063263 ], [ 127.457206726074219, -0.813194394111633 ], [ 127.302619934082031, -0.516805589199066 ], [ 127.32012939453125, -0.343055576086044 ], [ 127.531303405761719, -0.31034904718399 ] ] ], [ [ [ 122.048660278320312, -0.378620803356171 ], [ 121.91650390625, -0.416805535554886 ], [ 121.855537414550781, -0.363333344459534 ], [ 121.947486877441406, -0.312638849020004 ], [ 122.048660278320312, -0.378620803356171 ] ] ], [ [ [ 104.485206604003906, -0.348013758659363 ], [ 104.596366882324219, -0.46986111998558 ], [ 104.493446350097656, -0.626944422721863 ], [ 104.250114440917969, -0.474722236394882 ], [ 104.485206604003906, -0.348013758659363 ] ] ], [ [ [ 136.04913330078125, -2.698055267333984 ], [ 136.409423828125, -2.217499732971191 ], [ 137.188156127929688, -2.104166746139526 ], [ 137.131072998046875, -1.79277777671814 ], [ 137.87579345703125, -1.473055362701416 ], [ 139.78082275390625, -2.36138916015625 ], [ 140.162338256835938, -2.326666831970215 ], [ 140.721893310546875, -2.490000247955322 ], [ 140.7271728515625, -2.637083292007446 ], [ 141.214141845703125, -2.622221946716309 ], [ 142.551910400390625, -3.21833324432373 ], [ 143.518447875976562, -3.435555458068848 ], [ 144.016937255859375, -3.810555458068848 ], [ 144.51373291015625, -3.822222471237183 ], [ 145.735504150390625, -4.802777290344238 ], [ 145.766387939453125, -5.48527717590332 ], [ 147.46661376953125, -5.970859527587891 ], [ 147.82635498046875, -6.337222099304199 ], [ 147.819427490234375, -6.713055610656738 ], [ 146.9710693359375, -6.74305534362793 ], [ 146.945663452148438, -6.956666946411133 ], [ 147.1785888671875, -7.463889122009277 ], [ 147.73162841796875, -7.939999580383301 ], [ 148.13525390625, -8.066110610961914 ], [ 148.23052978515625, -8.559722900390625 ], [ 148.444412231445312, -8.676944732666016 ], [ 148.5888671875, -9.070278167724609 ], [ 149.314483642578125, -9.019792556762695 ], [ 149.219970703125, -9.474721908569336 ], [ 150.008880615234375, -9.631387710571289 ], [ 150.053726196289062, -9.722360610961914 ], [ 149.717193603515625, -9.833471298217773 ], [ 149.914154052734375, -10.04888916015625 ], [ 150.878021240234375, -10.229999542236328 ], [ 150.369110107421875, -10.321945190429688 ], [ 150.689956665039062, -10.563194274902344 ], [ 150.209686279296875, -10.700555801391602 ], [ 149.851638793945312, -10.548611640930176 ], [ 150.078857421875, -10.462778091430664 ], [ 149.74774169921875, -10.342777252197266 ], [ 147.95245361328125, -10.145833969116211 ], [ 147.0587158203125, -9.469999313354492 ], [ 146.89581298828125, -9.278472900390625 ], [ 146.971267700195312, -9.02993106842041 ], [ 146.586639404296875, -8.999166488647461 ], [ 146.089691162109375, -8.091110229492188 ], [ 144.879669189453125, -7.782500267028809 ], [ 144.862457275390625, -7.610555648803711 ], [ 144.599395751953125, -7.6602783203125 ], [ 144.522903442382812, -7.502916812896729 ], [ 144.508331298828125, -7.61805534362793 ], [ 144.408584594726562, -7.519861221313477 ], [ 144.467742919921875, -7.74305534362793 ], [ 144.314117431640625, -7.617916107177734 ], [ 144.217376708984375, -7.794652462005615 ], [ 143.664825439453125, -7.467648506164551 ], [ 143.9580078125, -7.978622436523438 ], [ 143.360382080078125, -7.901111125946045 ], [ 143.611907958984375, -8.243888854980469 ], [ 142.97662353515625, -8.344165802001953 ], [ 142.69635009765625, -8.267499923706055 ], [ 142.440109252929688, -8.332082748413086 ], [ 142.382598876953125, -8.189305305480957 ], [ 142.3277587890625, -8.163888931274414 ], [ 142.139007568359375, -8.223888397216797 ], [ 142.32440185546875, -8.183332443237305 ], [ 142.439422607421875, -8.371387481689453 ], [ 143.09661865234375, -8.463611602783203 ], [ 143.39276123046875, -8.770278930664062 ], [ 143.365097045898438, -9.012223243713379 ], [ 142.638885498046875, -9.334722518920898 ], [ 142.206497192382812, -9.165000915527344 ], [ 141.119964599609375, -9.230971336364746 ], [ 139.9852294921875, -8.193611145019531 ], [ 140.147903442382812, -7.885833740234375 ], [ 139.915802001953125, -8.114721298217773 ], [ 139.366363525390625, -8.206388473510742 ], [ 139.218292236328125, -8.089166641235352 ], [ 138.910263061523438, -8.298333168029785 ], [ 138.836639404296875, -8.130000114440918 ], [ 138.991912841796875, -7.867499828338623 ], [ 139.09454345703125, -7.561805248260498 ], [ 138.662200927734375, -7.200972080230713 ], [ 139.050537109375, -7.251667022705078 ], [ 139.175811767578125, -7.238888740539551 ], [ 139.22247314453125, -7.162500381469727 ], [ 138.84747314453125, -7.153888702392578 ], [ 138.562896728515625, -6.906527996063232 ], [ 139.1866455078125, -6.967569351196289 ], [ 138.681915283203125, -6.720555305480957 ], [ 138.167724609375, -5.793333053588867 ], [ 138.35162353515625, -5.680277347564697 ], [ 138.071243286132812, -5.731319427490234 ], [ 138.06524658203125, -5.408958435058594 ], [ 135.928314208984375, -4.498610496520996 ], [ 135.204681396484375, -4.459722518920898 ], [ 134.646224975585938, -4.125555038452148 ], [ 134.694976806640625, -3.939722061157227 ], [ 134.967605590820312, -3.941110849380493 ], [ 134.67303466796875, -3.915138721466064 ], [ 134.521636962890625, -4.026389122009277 ], [ 134.212051391601562, -3.960000038146973 ], [ 134.163864135742188, -3.776944398880005 ], [ 133.636795043945312, -3.489027738571167 ], [ 133.828857421875, -2.961666584014893 ], [ 133.399139404296875, -3.732499599456787 ], [ 133.451080322265625, -3.869305610656738 ], [ 133.237457275390625, -4.076389312744141 ], [ 132.912200927734375, -4.097917079925537 ], [ 132.750823974609375, -3.71833324432373 ], [ 132.92706298828125, -3.55472207069397 ], [ 132.819000244140625, -3.305416584014893 ], [ 131.9569091796875, -2.787014007568359 ], [ 132.3177490234375, -2.682222366333008 ], [ 132.722747802734375, -2.817222595214844 ], [ 133.245803833007812, -2.417499780654907 ], [ 133.648590087890625, -2.543889045715332 ], [ 133.6785888671875, -2.718055248260498 ], [ 133.955535888671875, -2.329166889190674 ], [ 133.946975708007812, -2.210555791854858 ], [ 133.7884521484375, -2.256736278533936 ], [ 133.934280395507812, -2.104097127914429 ], [ 133.64581298828125, -2.237222194671631 ], [ 132.298995971679688, -2.268472194671631 ], [ 132.041229248046875, -2.085694551467896 ], [ 131.8824462890625, -1.642222166061401 ], [ 130.963592529296875, -1.403055429458618 ], [ 131.24884033203125, -1.096944570541382 ], [ 131.25555419921875, -0.82277774810791 ], [ 131.873016357421875, -0.693888902664185 ], [ 132.26971435546875, -0.384166717529297 ], [ 132.713150024414062, -0.367083311080933 ], [ 133.389434814453125, -0.724722146987915 ], [ 134.111083984375, -0.835277795791626 ], [ 134.029495239257812, -0.966944396495819 ], [ 134.2803955078125, -1.360555648803711 ], [ 134.088287353515625, -1.677916526794434 ], [ 134.159698486328125, -2.31944465637207 ], [ 134.462890625, -2.861303806304932 ], [ 134.485794067382812, -2.525555610656738 ], [ 134.642074584960938, -2.521597385406494 ], [ 134.698028564453125, -2.970138788223267 ], [ 134.854690551757812, -2.906805515289307 ], [ 134.812606811523438, -3.123888731002808 ], [ 134.994949340820312, -3.336527824401855 ], [ 135.491912841796875, -3.358333587646484 ], [ 136.04913330078125, -2.698055267333984 ] ] ], [ [ [ 121.91217041015625, -0.47421658039093 ], [ 121.890266418457031, -0.513888955116272 ], [ 121.640823364257812, -0.533611178398132 ], [ 121.741363525390625, -0.418611109256744 ], [ 121.91217041015625, -0.47421658039093 ] ] ], [ [ [ 130.637481689453125, -0.419167995452881 ], [ 130.65887451171875, -0.518611192703247 ], [ 130.465301513671875, -0.52527779340744 ], [ 130.479827880859375, -0.450694441795349 ], [ 130.637481689453125, -0.419167995452881 ] ] ], [ [ [ 73.099151611328125, -0.602777719497681 ], [ 73.109420776367188, -0.620000004768372 ], [ 73.115196228027344, -0.64166671037674 ], [ 73.090606689453125, -0.585347175598145 ], [ 73.099151611328125, -0.602777719497681 ] ] ], [ [ [ 127.238601684570312, -0.614409923553467 ], [ 127.318252563476562, -0.794583380222321 ], [ 127.277618408203125, -0.808333396911621 ], [ 127.153587341308594, -0.770000100135803 ], [ 127.238601684570312, -0.614409923553467 ] ] ], [ [ [ 135.460845947265625, -0.662425756454468 ], [ 135.851638793945312, -0.703472197055817 ], [ 136.386367797851562, -1.115208268165588 ], [ 135.88427734375, -1.185555458068848 ], [ 135.7572021484375, -0.825555562973022 ], [ 135.4620361328125, -0.797902047634125 ], [ 135.460845947265625, -0.662425756454468 ] ] ], [ [ [ 130.841033935546875, -0.770539402961731 ], [ 130.838287353515625, -0.863055467605591 ], [ 130.397628784179688, -0.923888862133026 ], [ 130.48663330078125, -0.835277795791626 ], [ 130.841033935546875, -0.770539402961731 ] ] ], [ [ [ 130.89935302734375, -0.891444563865662 ], [ 131.074676513671875, -0.972777724266052 ], [ 130.96136474609375, -1.356944561004639 ], [ 130.639297485351562, -0.986944437026978 ], [ 130.89935302734375, -0.891444563865662 ] ] ], [ [ [ 99.282211303710938, -1.739444255828857 ], [ 99.225677490234375, -1.622152805328369 ], [ 99.112205505371094, -1.805277824401855 ], [ 98.876228332519531, -1.676944375038147 ], [ 98.603042602539062, -1.223055362701416 ], [ 98.657485961914062, -0.971111118793488 ], [ 98.929153442382812, -0.950277805328369 ], [ 99.282211303710938, -1.739444255828857 ] ] ], [ [ [ 134.8944091796875, -0.943319797515869 ], [ 134.992050170898438, -1.073889017105103 ], [ 134.87994384765625, -1.140833377838135 ], [ 134.79913330078125, -1.025555610656738 ], [ 134.8944091796875, -0.943319797515869 ] ] ], [ [ [ 109.756378173828125, -1.032516002655029 ], [ 109.77581787109375, -1.142361044883728 ], [ 109.418586730957031, -1.263333559036255 ], [ 109.492477416992188, -0.979722142219543 ], [ 109.756378173828125, -1.032516002655029 ] ] ], [ [ [ 129.8782958984375, -1.145562887191772 ], [ 129.959259033203125, -1.173472166061401 ], [ 129.741485595703125, -1.210972189903259 ], [ 129.76580810546875, -1.172222137451172 ], [ 129.8782958984375, -1.145562887191772 ] ] ], [ [ [ 123.553863525390625, -1.305000066757202 ], [ 123.181510925292969, -1.624027729034424 ], [ 123.129150390625, -1.331111192703247 ], [ 122.906784057617188, -1.591805577278137 ], [ 122.805671691894531, -1.454444408416748 ], [ 122.922210693359375, -1.176944494247437 ], [ 123.194839477539062, -1.153055429458618 ], [ 123.230552673339844, -1.398888826370239 ], [ 123.371231079101562, -1.225485920906067 ], [ 123.553863525390625, -1.305000066757202 ] ] ], [ [ [ 127.56610107421875, -1.177743911743164 ], [ 127.614700317382812, -1.25777792930603 ], [ 127.456932067871094, -1.242499947547913 ], [ 127.506523132324219, -1.185833334922791 ], [ 127.56610107421875, -1.177743911743164 ] ] ], [ [ [ 127.394668579101562, -1.573360919952393 ], [ 127.643600463867188, -1.328333377838135 ], [ 128.159286499023438, -1.643194437026978 ], [ 127.544143676757812, -1.74222207069397 ], [ 127.394668579101562, -1.573360919952393 ] ] ], [ [ [ 106.659713745117188, -2.974444389343262 ], [ 106.717758178710938, -3.098333358764648 ], [ 106.519401550292969, -3.102489471435547 ], [ 105.972618103027344, -2.814861059188843 ], [ 105.747344970703125, -2.13159704208374 ], [ 105.137557983398438, -2.075833559036255 ], [ 105.393333435058594, -1.606666803359985 ], [ 105.60498046875, -1.535972237586975 ], [ 105.781097412109375, -1.795000076293945 ], [ 105.709152221679688, -1.547500133514404 ], [ 106.02679443359375, -1.574722290039062 ], [ 106.270408630371094, -2.374305486679077 ], [ 106.781661987304688, -2.591944217681885 ], [ 106.659713745117188, -2.974444389343262 ] ] ], [ [ [ 108.955902099609375, -1.570859670639038 ], [ 108.851791381835938, -1.670277714729309 ], [ 108.795745849609375, -1.582083344459534 ], [ 108.896377563476562, -1.537500143051147 ], [ 108.955902099609375, -1.570859670639038 ] ] ], [ [ [ 135.505035400390625, -1.600396394729614 ], [ 136.8035888671875, -1.747499942779541 ], [ 136.900665283203125, -1.796180605888367 ], [ 136.218841552734375, -1.874444484710693 ], [ 135.505035400390625, -1.600396394729614 ] ] ], [ [ [ 124.4249267578125, -1.657118320465088 ], [ 125.290740966796875, -1.733263850212097 ], [ 125.319984436035156, -1.887430548667908 ], [ 124.405326843261719, -2.016111135482788 ], [ 124.4249267578125, -1.657118320465088 ] ] ], [ [ [ 130.350555419921875, -1.68020486831665 ], [ 130.381500244140625, -2.010972499847412 ], [ 130.12078857421875, -2.066111087799072 ], [ 129.717941284179688, -1.888194441795349 ], [ 130.350555419921875, -1.68020486831665 ] ] ], [ [ [ 125.415847778320312, -1.783883333206177 ], [ 125.653594970703125, -1.824444532394409 ], [ 126.348876953125, -1.819861054420471 ], [ 125.466659545898438, -1.940000057220459 ], [ 125.415847778320312, -1.783883333206177 ] ] ], [ [ [ 125.959152221679688, -1.978546380996704 ], [ 126.086799621582031, -2.421388864517212 ], [ 126.053451538085938, -2.48277735710144 ], [ 125.861923217773438, -2.086666584014893 ], [ 125.959152221679688, -1.978546380996704 ] ] ], [ [ [ 99.859146118164062, -2.376487731933594 ], [ 99.568603515625, -2.220138549804688 ], [ 99.5726318359375, -2.026388883590698 ], [ 99.684982299804688, -2.068749904632568 ], [ 99.859146118164062, -2.376487731933594 ] ] ], [ [ [ 100.203018188476562, -2.758927822113037 ], [ 100.015968322753906, -2.839027643203735 ], [ 99.973876953125, -2.496527910232544 ], [ 100.159568786621094, -2.629305362701416 ], [ 100.203018188476562, -2.758927822113037 ] ] ], [ [ [ 107.708686828613281, -2.557814598083496 ], [ 108.263046264648438, -2.751389026641846 ], [ 108.077384948730469, -3.227360725402832 ], [ 107.869705200195312, -3.05180549621582 ], [ 107.612129211425781, -3.212083101272583 ], [ 107.708686828613281, -2.557814598083496 ] ] ], [ [ [ 100.459426879882812, -3.333889007568359 ], [ 100.191360473632812, -2.975832939147949 ], [ 100.197479248046875, -2.78694486618042 ], [ 100.469711303710938, -3.023889064788818 ], [ 100.459426879882812, -3.333889007568359 ] ] ], [ [ [ 130.8299560546875, -3.872777462005615 ], [ 129.888580322265625, -3.334444284439087 ], [ 129.516098022460938, -3.297500133514404 ], [ 129.517822265625, -3.469930171966553 ], [ 128.968292236328125, -3.353611469268799 ], [ 128.882675170898438, -3.209374904632568 ], [ 128.470382690429688, -3.460694551467896 ], [ 128.181869506835938, -3.074097394943237 ], [ 127.918319702148438, -3.559444427490234 ], [ 127.856086730957031, -3.186666488647461 ], [ 128.171920776367188, -2.856944561004639 ], [ 129.133026123046875, -2.963263750076294 ], [ 129.526641845703125, -2.783611297607422 ], [ 130.589065551757812, -3.140347242355347 ], [ 130.873977661132812, -3.592985868453979 ], [ 130.8299560546875, -3.872777462005615 ] ] ], [ [ [ 106.825523376464844, -2.900552749633789 ], [ 106.9073486328125, -2.935277700424194 ], [ 106.891517639160156, -3.023472309112549 ], [ 106.723869323730469, -2.967569351196289 ], [ 106.825523376464844, -2.900552749633789 ] ] ], [ [ [ 126.127899169921875, -3.119681358337402 ], [ 126.993873596191406, -3.144999980926514 ], [ 127.096229553222656, -3.370208263397217 ], [ 127.260543823242188, -3.37749981880188 ], [ 127.236648559570312, -3.617499828338623 ], [ 126.693038940429688, -3.834930419921875 ], [ 126.508041381835938, -3.7688889503479 ], [ 126.044143676757812, -3.42680549621582 ], [ 126.127899169921875, -3.119681358337402 ] ] ], [ [ [ 127.708076477050781, -3.160594463348389 ], [ 127.7894287109375, -3.179652690887451 ], [ 127.787269592285156, -3.24548602104187 ], [ 127.638328552246094, -3.22458291053772 ], [ 127.708076477050781, -3.160594463348389 ] ] ], [ [ [ 116.27105712890625, -3.285253047943115 ], [ 116.305320739746094, -3.907222032546997 ], [ 116.055259704589844, -4.042361259460449 ], [ 116.012771606445312, -3.632777690887451 ], [ 116.27105712890625, -3.285253047943115 ] ] ], [ [ [ 127.573089599609375, -3.266746997833252 ], [ 127.623870849609375, -3.315277576446533 ], [ 127.643051147460938, -3.361944675445557 ], [ 127.481086730957031, -3.293333530426025 ], [ 127.573089599609375, -3.266746997833252 ] ] ], [ [ [ 116.429527282714844, -3.404972553253174 ], [ 116.4033203125, -3.584166526794434 ], [ 116.38067626953125, -3.644583463668823 ], [ 116.316940307617188, -3.540972471237183 ], [ 116.429527282714844, -3.404972553253174 ] ] ], [ [ [ 128.58380126953125, -3.494435787200928 ], [ 128.70635986328125, -3.501944541931152 ], [ 128.72314453125, -3.616319417953491 ], [ 128.62689208984375, -3.623471975326538 ], [ 128.58380126953125, -3.494435787200928 ] ] ], [ [ [ 128.036376953125, -3.593055248260498 ], [ 128.276092529296875, -3.511528015136719 ], [ 128.346771240234375, -3.532778024673462 ], [ 128.234954833984375, -3.729722023010254 ], [ 127.942466735839844, -3.771389007568359 ], [ 128.036376953125, -3.593055248260498 ] ] ], [ [ [ 128.440582275390625, -3.519957065582275 ], [ 128.510528564453125, -3.526666641235352 ], [ 128.56219482421875, -3.591249942779541 ], [ 128.385879516601562, -3.638402938842773 ], [ 128.440582275390625, -3.519957065582275 ] ] ], [ [ [ 123.046096801757812, -3.978620052337646 ], [ 123.253883361816406, -4.062777519226074 ], [ 123.146232604980469, -4.242708206176758 ], [ 122.957763671875, -4.100277900695801 ], [ 123.046096801757812, -3.978620052337646 ] ] ], [ [ [ 133.329010009765625, -4.107851028442383 ], [ 133.552764892578125, -4.233611106872559 ], [ 133.615509033203125, -4.300555229187012 ], [ 133.326370239257812, -4.170693874359131 ], [ 133.329010009765625, -4.107851028442383 ] ] ], [ [ [ 123.075546264648438, -4.403510093688965 ], [ 123.21539306640625, -4.821805953979492 ], [ 123.0455322265625, -4.757500648498535 ], [ 122.979713439941406, -5.107222557067871 ], [ 123.214637756347656, -5.293680191040039 ], [ 122.655441284179688, -5.685033798217773 ], [ 122.568603515625, -5.50694465637207 ], [ 122.781097412109375, -5.129721641540527 ], [ 122.85443115234375, -4.600555419921875 ], [ 123.075546264648438, -4.403510093688965 ] ] ], [ [ [ 145.95135498046875, -4.764445304870605 ], [ 145.873153686523438, -4.669722080230713 ], [ 145.978439331054688, -4.52791690826416 ], [ 146.05413818359375, -4.661389350891113 ], [ 145.95135498046875, -4.764445304870605 ] ] ], [ [ [ 122.709152221679688, -4.618332862854004 ], [ 122.643592834472656, -5.352360725402832 ], [ 122.284706115722656, -5.381735801696777 ], [ 122.374214172363281, -4.755902767181396 ], [ 122.709152221679688, -4.618332862854004 ] ] ], [ [ [ 121.981353759765625, -5.081107139587402 ], [ 122.053581237792969, -5.424721717834473 ], [ 121.961799621582031, -5.476666927337646 ], [ 121.808311462402344, -5.269166946411133 ], [ 121.981353759765625, -5.081107139587402 ] ] ], [ [ [ 147.135528564453125, -5.451111793518066 ], [ 147.002471923828125, -5.303888320922852 ], [ 147.12481689453125, -5.191527366638184 ], [ 147.228851318359375, -5.363888740539551 ], [ 147.135528564453125, -5.451111793518066 ] ] ], [ [ [ 123.585540771484375, -5.255278587341309 ], [ 123.63275146484375, -5.290833473205566 ], [ 123.633110046386719, -5.373610973358154 ], [ 123.528053283691406, -5.296944618225098 ], [ 123.585540771484375, -5.255278587341309 ] ] ], [ [ [ 102.3780517578125, -5.487199783325195 ], [ 102.256942749023438, -5.454444885253906 ], [ 102.099845886230469, -5.335139274597168 ], [ 102.380813598632812, -5.372499465942383 ], [ 102.3780517578125, -5.487199783325195 ] ] ], [ [ [ 133.1824951171875, -5.309759140014648 ], [ 133.111907958984375, -5.591667175292969 ], [ 132.83953857421875, -6.000277996063232 ], [ 133.1141357421875, -5.30222225189209 ], [ 133.1824951171875, -5.309759140014648 ] ] ], [ [ [ 134.51617431640625, -5.436432838439941 ], [ 134.6927490234375, -5.530278205871582 ], [ 134.730239868164062, -5.977083206176758 ], [ 134.630218505859375, -5.934860706329346 ], [ 134.302337646484375, -6.022777557373047 ], [ 134.380966186523438, -5.806735992431641 ], [ 134.2091064453125, -5.704027652740479 ], [ 134.35992431640625, -5.706110954284668 ], [ 134.51617431640625, -5.436432838439941 ] ] ], [ [ [ 147.990478515625, -5.856037139892578 ], [ 147.76995849609375, -5.622219085693359 ], [ 147.782073974609375, -5.492499828338623 ], [ 148.0653076171875, -5.627584457397461 ], [ 147.990478515625, -5.856037139892578 ] ] ], [ [ [ 132.738555908203125, -5.67884349822998 ], [ 132.80914306640625, -5.833611488342285 ], [ 132.739456176757812, -5.950208187103271 ], [ 132.634979248046875, -5.616110801696777 ], [ 132.738555908203125, -5.67884349822998 ] ] ], [ [ [ 112.694671630859375, -5.731356620788574 ], [ 112.724632263183594, -5.839861392974854 ], [ 112.590324401855469, -5.845069408416748 ], [ 112.5877685546875, -5.784583568572998 ], [ 112.694671630859375, -5.731356620788574 ] ] ], [ [ [ 120.495613098144531, -5.787199020385742 ], [ 120.561370849609375, -6.02791690826416 ], [ 120.479911804199219, -6.482222080230713 ], [ 120.440261840820312, -5.911389350891113 ], [ 120.495613098144531, -5.787199020385742 ] ] ], [ [ [ 110.056396484375, -7.897513866424561 ], [ 108.879966735839844, -7.641111373901367 ], [ 108.186920166015625, -7.786388397216797 ], [ 107.468864440917969, -7.504583835601807 ], [ 106.567207336425781, -7.41694450378418 ], [ 106.384719848632812, -7.296667098999023 ], [ 106.506797790527344, -6.978333473205566 ], [ 106.018333435058594, -6.831389427185059 ], [ 105.483444213867188, -6.869166374206543 ], [ 105.215957641601562, -6.775215625762939 ], [ 105.491363525390625, -6.80888843536377 ], [ 106.075820922851562, -5.881943702697754 ], [ 106.755500793457031, -6.100801944732666 ], [ 106.994712829589844, -6.081111907958984 ], [ 107.023880004882812, -5.914444446563721 ], [ 107.305816650390625, -5.953611373901367 ], [ 107.650543212890625, -6.25 ], [ 108.313179016113281, -6.261667251586914 ], [ 108.620819091796875, -6.774167060852051 ], [ 109.2813720703125, -6.882499694824219 ], [ 110.393600463867188, -6.97902774810791 ], [ 110.729843139648438, -6.459166526794434 ], [ 110.927345275878906, -6.41118049621582 ], [ 111.148735046386719, -6.697291374206543 ], [ 111.491218566894531, -6.630069255828857 ], [ 112.094436645507812, -6.911666870117188 ], [ 112.560256958007812, -6.912221908569336 ], [ 112.604774475097656, -7.200208187103271 ], [ 112.828590393066406, -7.292500019073486 ], [ 112.7783203125, -7.543889045715332 ], [ 113.172210693359375, -7.744999885559082 ], [ 114.038040161132812, -7.611944198608398 ], [ 114.439971923828125, -7.79444408416748 ], [ 114.37261962890625, -8.523472785949707 ], [ 114.621650695800781, -8.743887901306152 ], [ 113.232757568359375, -8.281112670898438 ], [ 112.646652221679688, -8.434165954589844 ], [ 111.787002563476562, -8.260695457458496 ], [ 111.651092529296875, -8.362499237060547 ], [ 110.718048095703125, -8.197222709655762 ], [ 110.056396484375, -7.897513866424561 ] ] ], [ [ [ 134.478271484375, -5.98877477645874 ], [ 134.766937255859375, -6.090000152587891 ], [ 134.605514526367188, -6.369582653045654 ], [ 134.268524169921875, -6.114930629730225 ], [ 134.478271484375, -5.98877477645874 ] ] ], [ [ [ 134.214508056640625, -6.026357650756836 ], [ 134.231765747070312, -6.14097261428833 ], [ 134.404006958007812, -6.28166675567627 ], [ 134.333038330078125, -6.326389312744141 ], [ 134.119964599609375, -6.134166717529297 ], [ 134.214508056640625, -6.026357650756836 ] ] ], [ [ [ 134.120941162109375, -6.170351982116699 ], [ 134.515731811523438, -6.59250020980835 ], [ 134.200531005859375, -6.920833110809326 ], [ 134.051498413085938, -6.777639389038086 ], [ 134.120941162109375, -6.170351982116699 ] ] ], [ [ [ 134.452789306640625, -6.288033485412598 ], [ 134.597747802734375, -6.407222747802734 ], [ 134.543869018554688, -6.533611297607422 ], [ 134.34552001953125, -6.359722137451172 ], [ 134.452789306640625, -6.288033485412598 ] ] ], [ [ [ 134.885498046875, -6.308499336242676 ], [ 134.833221435546875, -6.469722270965576 ], [ 134.816070556640625, -6.470000267028809 ], [ 134.7935791015625, -6.378055572509766 ], [ 134.885498046875, -6.308499336242676 ] ] ], [ [ [ 105.2611083984375, -6.533262252807617 ], [ 105.195533752441406, -6.683472156524658 ], [ 105.117477416992188, -6.62624979019165 ], [ 105.1644287109375, -6.566666603088379 ], [ 105.2611083984375, -6.533262252807617 ] ] ], [ [ [ 134.7100830078125, -6.591372489929199 ], [ 134.72161865234375, -6.690555572509766 ], [ 134.646499633789062, -6.769861698150635 ], [ 134.6263427734375, -6.715556144714355 ], [ 134.7100830078125, -6.591372489929199 ] ] ], [ [ [ 138.6341552734375, -6.729499816894531 ], [ 138.738555908203125, -6.76805591583252 ], [ 138.785812377929688, -6.837708473205566 ], [ 138.68524169921875, -6.857222557067871 ], [ 138.6341552734375, -6.729499816894531 ] ] ], [ [ [ 115.293327331542969, -6.83879280090332 ], [ 115.461929321289062, -6.850555419921875 ], [ 115.570480346679688, -6.9211106300354 ], [ 115.2955322265625, -7.008264541625977 ], [ 115.293327331542969, -6.83879280090332 ] ] ], [ [ [ 112.939422607421875, -6.893333435058594 ], [ 113.94110107421875, -6.865416049957275 ], [ 114.127960205078125, -6.973263740539551 ], [ 113.503883361816406, -7.225277900695801 ], [ 112.716934204101562, -7.148750305175781 ], [ 112.939422607421875, -6.893333435058594 ] ] ], [ [ [ 120.658073425292969, -7.022478103637695 ], [ 120.775543212890625, -7.060277462005615 ], [ 120.769706726074219, -7.134166717529297 ], [ 120.637771606445312, -7.122082710266113 ], [ 120.658073425292969, -7.022478103637695 ] ] ], [ [ [ 114.326950073242188, -7.063972473144531 ], [ 114.396102905273438, -7.101388931274414 ], [ 114.402481079101562, -7.181111335754395 ], [ 114.326240539550781, -7.164722442626953 ], [ 114.326950073242188, -7.063972473144531 ] ] ], [ [ [ 128.62353515625, -7.06525993347168 ], [ 128.703033447265625, -7.119721412658691 ], [ 128.63720703125, -7.219722270965576 ], [ 128.526092529296875, -7.140139579772949 ], [ 128.62353515625, -7.06525993347168 ] ] ], [ [ [ 131.91607666015625, -7.104166984558105 ], [ 131.97259521484375, -7.251389026641846 ], [ 131.728164672851562, -7.155555725097656 ], [ 131.75054931640625, -7.116457939147949 ], [ 131.91607666015625, -7.104166984558105 ] ] ], [ [ [ 131.645721435546875, -7.116655349731445 ], [ 131.630096435546875, -7.629166126251221 ], [ 131.329269409179688, -8.01430606842041 ], [ 131.108566284179688, -7.998472213745117 ], [ 131.237045288085938, -7.49097204208374 ], [ 131.645721435546875, -7.116655349731445 ] ] ], [ [ [ 72.432540893554688, -7.434738159179688 ], [ 72.357902526855469, -7.269652843475342 ], [ 72.434349060058594, -7.426596641540527 ], [ 72.444694519042969, -7.233471870422363 ], [ 72.494285583496094, -7.299166202545166 ], [ 72.432540893554688, -7.434738159179688 ] ] ], [ [ [ 120.830802917480469, -7.265214920043945 ], [ 120.995407104492188, -7.280694484710693 ], [ 121.063034057617188, -7.302083015441895 ], [ 120.791656494140625, -7.289166450500488 ], [ 120.830802917480469, -7.265214920043945 ] ] ], [ [ [ 138.55975341796875, -7.379084587097168 ], [ 138.806915283203125, -7.383194446563721 ], [ 139.036651611328125, -7.613888740539551 ], [ 138.848846435546875, -8.078332901000977 ], [ 138.379547119140625, -8.410555839538574 ], [ 137.644912719726562, -8.435138702392578 ], [ 138.01824951171875, -7.625207901000977 ], [ 138.55975341796875, -7.379084587097168 ] ] ], [ [ [ 131.03692626953125, -7.417499542236328 ], [ 131.165115356445312, -7.403888702392578 ], [ 131.177261352539062, -7.411874771118164 ], [ 131.06024169921875, -7.512500762939453 ], [ 131.03692626953125, -7.417499542236328 ] ] ], [ [ [ 127.41607666015625, -7.512544631958008 ], [ 127.485260009765625, -7.580000877380371 ], [ 127.359283447265625, -7.65458345413208 ], [ 127.366790771484375, -7.51597261428833 ], [ 127.41607666015625, -7.512544631958008 ] ] ], [ [ [ 125.972213745117188, -7.658611297607422 ], [ 126.618453979492188, -7.564999580383301 ], [ 126.790542602539062, -7.749721527099609 ], [ 125.782760620117188, -8.020417213439941 ], [ 125.972213745117188, -7.658611297607422 ] ] ], [ [ [ 129.632171630859375, -7.798572540283203 ], [ 129.842529296875, -7.841249942779541 ], [ 129.7672119140625, -8.060417175292969 ], [ 129.584136962890625, -7.907777786254883 ], [ 129.632171630859375, -7.798572540283203 ] ] ], [ [ [ 114.478591918945312, -8.090036392211914 ], [ 114.9940185546875, -8.186388969421387 ], [ 115.1956787109375, -8.058055877685547 ], [ 115.709846496582031, -8.404444694519043 ], [ 115.102622985839844, -8.846804618835449 ], [ 115.161941528320312, -8.67823600769043 ], [ 114.609283447265625, -8.395694732666016 ], [ 114.478591918945312, -8.090036392211914 ] ] ], [ [ [ 121.016387939453125, -8.949722290039062 ], [ 120.538040161132812, -8.793333053588867 ], [ 119.893882751464844, -8.850276947021484 ], [ 119.8035888671875, -8.567777633666992 ], [ 120.522491455078125, -8.257223129272461 ], [ 121.513603210449219, -8.60666561126709 ], [ 122.0394287109375, -8.443611145019531 ], [ 122.288307189941406, -8.644445419311523 ], [ 122.890953063964844, -8.284790992736816 ], [ 122.741813659667969, -8.225832939147949 ], [ 122.800262451171875, -8.110832214355469 ], [ 122.979698181152344, -8.147361755371094 ], [ 122.828048706054688, -8.604026794433594 ], [ 121.016387939453125, -8.949722290039062 ] ] ], [ [ [ 118.469993591308594, -8.872499465942383 ], [ 118.405120849609375, -8.589583396911621 ], [ 118.168594360351562, -8.865138053894043 ], [ 117.438873291015625, -9.041667938232422 ], [ 117.047760009765625, -9.110762596130371 ], [ 116.74359130859375, -8.981804847717285 ], [ 116.803306579589844, -8.591318130493164 ], [ 117.1502685546875, -8.368471145629883 ], [ 117.563522338867188, -8.412222862243652 ], [ 117.966377258300781, -8.74860954284668 ], [ 118.257003784179688, -8.660833358764648 ], [ 117.70574951171875, -8.237221717834473 ], [ 117.945533752441406, -8.082638740539551 ], [ 118.316299438476562, -8.374651908874512 ], [ 118.651725769042969, -8.297916412353516 ], [ 118.664741516113281, -8.54527759552002 ], [ 118.773323059082031, -8.313194274902344 ], [ 118.999916076660156, -8.315763473510742 ], [ 119.150543212890625, -8.750555992126465 ], [ 118.750877380371094, -8.715208053588867 ], [ 118.94317626953125, -8.84104061126709 ], [ 118.469993591308594, -8.872499465942383 ] ] ], [ [ [ 130.765533447265625, -8.354999542236328 ], [ 131.013519287109375, -8.090277671813965 ], [ 131.178314208984375, -8.13124942779541 ], [ 130.8218994140625, -8.349443435668945 ], [ 130.765533447265625, -8.354999542236328 ] ] ], [ [ [ 127.79779052734375, -8.103855133056641 ], [ 128.10052490234375, -8.138612747192383 ], [ 128.127731323242188, -8.168611526489258 ], [ 128.0252685546875, -8.267499923706055 ], [ 127.79779052734375, -8.103855133056641 ] ] ], [ [ [ 124.474990844726562, -8.135869979858398 ], [ 125.087493896484375, -8.155416488647461 ], [ 125.13970947265625, -8.32569408416748 ], [ 124.359153747558594, -8.459999084472656 ], [ 124.474990844726562, -8.135869979858398 ] ] ], [ [ [ 119.088287353515625, -8.136320114135742 ], [ 119.134719848632812, -8.206943511962891 ], [ 119.045127868652344, -8.264167785644531 ], [ 119.023880004882812, -8.167778015136719 ], [ 119.088287353515625, -8.136320114135742 ] ] ], [ [ [ 125.647491455078125, -8.150043487548828 ], [ 125.592483520507812, -8.307500839233398 ], [ 125.526092529296875, -8.306110382080078 ], [ 125.524696350097656, -8.229999542236328 ], [ 125.647491455078125, -8.150043487548828 ] ] ], [ [ [ 117.536102294921875, -8.390834808349609 ], [ 117.481369018554688, -8.191389083862305 ], [ 117.6795654296875, -8.15916633605957 ], [ 117.691368103027344, -8.183750152587891 ], [ 117.536102294921875, -8.390834808349609 ] ] ], [ [ [ 138.823028564453125, -8.173055648803711 ], [ 138.898590087890625, -8.40534782409668 ], [ 138.557052612304688, -8.365832328796387 ], [ 138.707183837890625, -8.183332443237305 ], [ 138.823028564453125, -8.173055648803711 ] ] ], [ [ [ 128.858642578125, -8.188899993896484 ], [ 128.969696044921875, -8.183889389038086 ], [ 129.03289794921875, -8.243332862854004 ], [ 128.92498779296875, -8.262639999389648 ], [ 128.858642578125, -8.188899993896484 ] ] ], [ [ [ 123.980796813964844, -8.342777252197266 ], [ 124.106369018554688, -8.371944427490234 ], [ 124.299835205078125, -8.208194732666016 ], [ 124.125526428222656, -8.552223205566406 ], [ 123.911102294921875, -8.458611488342285 ], [ 123.980796813964844, -8.342777252197266 ] ] ], [ [ [ 123.406097412109375, -8.596944808959961 ], [ 123.219009399414062, -8.532013893127441 ], [ 123.469894409179688, -8.355110168457031 ], [ 123.402481079101562, -8.275001525878906 ], [ 123.582206726074219, -8.378055572509766 ], [ 123.787620544433594, -8.184721946716309 ], [ 123.932472229003906, -8.235485076904297 ], [ 123.406097412109375, -8.596944808959961 ] ] ], [ [ [ 116.339813232421875, -8.218549728393555 ], [ 116.734909057617188, -8.365484237670898 ], [ 116.582832336425781, -8.896180152893066 ], [ 115.857757568359375, -8.822568893432617 ], [ 116.073036193847656, -8.731111526489258 ], [ 116.10247802734375, -8.406389236450195 ], [ 116.339813232421875, -8.218549728393555 ] ] ], [ [ [ 123.090812683105469, -8.285736083984375 ], [ 123.217491149902344, -8.233610153198242 ], [ 123.346649169921875, -8.283473014831543 ], [ 123.017555236816406, -8.409999847412109 ], [ 123.090812683105469, -8.285736083984375 ] ] ], [ [ [ 125.124107360839844, -8.654200553894043 ], [ 127.004989624023438, -8.324443817138672 ], [ 127.30859375, -8.410556793212891 ], [ 126.474563598632812, -8.95111083984375 ], [ 125.352760314941406, -9.295416831970215 ], [ 124.426376342773438, -10.167499542236328 ], [ 123.811653137207031, -10.375831604003906 ], [ 123.488311767578125, -10.316389083862305 ], [ 123.76220703125, -10.078887939453125 ], [ 123.575271606445312, -10.02833366394043 ], [ 123.674697875976562, -9.629444122314453 ], [ 124.951896667480469, -8.950126647949219 ], [ 125.124107360839844, -8.654200553894043 ] ] ], [ [ [ 143.57275390625, -8.493888854980469 ], [ 143.354949951171875, -8.418056488037109 ], [ 143.314422607421875, -8.380138397216797 ], [ 143.578506469726562, -8.375485420227051 ], [ 143.57275390625, -8.493888854980469 ] ] ], [ [ [ 143.6324462890625, -8.734443664550781 ], [ 143.240509033203125, -8.487220764160156 ], [ 143.182540893554688, -8.42347240447998 ], [ 143.467193603515625, -8.527778625488281 ], [ 143.6324462890625, -8.734443664550781 ] ] ], [ [ [ 119.3778076171875, -8.718201637268066 ], [ 119.415679931640625, -8.445694923400879 ], [ 119.455459594726562, -8.429990768432617 ], [ 119.58526611328125, -8.559999465942383 ], [ 119.3778076171875, -8.718201637268066 ] ] ], [ [ [ 122.925590515136719, -8.611922264099121 ], [ 122.988037109375, -8.456666946411133 ], [ 123.174285888671875, -8.438889503479004 ], [ 123.169151306152344, -8.472499847412109 ], [ 122.925590515136719, -8.611922264099121 ] ] ], [ [ [ 119.699417114257812, -8.723113059997559 ], [ 119.609634399414062, -8.776666641235352 ], [ 119.633056640625, -8.600795745849609 ], [ 119.719993591308594, -8.686944961547852 ], [ 119.699417114257812, -8.723113059997559 ] ] ], [ [ [ 115.589981079101562, -8.806110382080078 ], [ 115.469711303710938, -8.732082366943359 ], [ 115.510414123535156, -8.671388626098633 ], [ 115.602828979492188, -8.70270824432373 ], [ 115.589981079101562, -8.806110382080078 ] ] ], [ [ [ 143.234710693359375, -9.107110977172852 ], [ 143.263778686523438, -9.125205039978027 ], [ 143.24102783203125, -9.162215232849121 ], [ 143.195785522460938, -9.135074615478516 ], [ 143.234710693359375, -9.107110977172852 ] ] ], [ [ [ 150.33441162109375, -9.526666641235352 ], [ 150.109542846679688, -9.370693206787109 ], [ 150.193588256835938, -9.209444046020508 ], [ 150.330947875976562, -9.273611068725586 ], [ 150.33441162109375, -9.526666641235352 ] ] ], [ [ [ 119.200546264648438, -9.747499465942383 ], [ 118.933242797851562, -9.559444427490234 ], [ 119.033531188964844, -9.431249618530273 ], [ 119.939834594726562, -9.289652824401855 ], [ 120.833183288574219, -10.077361106872559 ], [ 120.627197265625, -10.238887786865234 ], [ 120.220260620117188, -10.248332977294922 ], [ 119.629837036132812, -9.772223472595215 ], [ 119.200546264648438, -9.747499465942383 ] ] ], [ [ [ 150.846923828125, -9.718055725097656 ], [ 150.514434814453125, -9.623332977294922 ], [ 150.439132690429688, -9.357082366943359 ], [ 150.804412841796875, -9.432777404785156 ], [ 150.846923828125, -9.718055725097656 ] ] ], [ [ [ 151.2291259765625, -10.20111083984375 ], [ 150.94970703125, -10.105554580688477 ], [ 150.762619018554688, -9.707846641540527 ], [ 151.118087768554688, -10.046597480773926 ], [ 151.282760620117188, -9.925278663635254 ], [ 151.2291259765625, -10.20111083984375 ] ] ], [ [ [ 123.416351318359375, -10.153305053710938 ], [ 123.506721496582031, -10.180417060852051 ], [ 123.321243286132812, -10.341110229492188 ], [ 123.309700012207031, -10.275972366333008 ], [ 123.416351318359375, -10.153305053710938 ] ] ], [ [ [ 105.701400756835938, -10.510970115661621 ], [ 105.628997802734375, -10.437310218811035 ], [ 105.736602783203125, -10.384079933166504 ], [ 105.751899719238281, -10.483750343322754 ], [ 105.701400756835938, -10.510970115661621 ] ] ], [ [ [ 121.726356506347656, -10.544683456420898 ], [ 121.894989013671875, -10.421667098999023 ], [ 122.003326416015625, -10.455278396606445 ], [ 121.87109375, -10.607500076293945 ], [ 121.726356506347656, -10.544683456420898 ] ] ], [ [ [ 122.856307983398438, -10.759742736816406 ], [ 123.075271606445312, -10.681249618530273 ], [ 123.390960693359375, -10.438055038452148 ], [ 123.394439697265625, -10.684165954589844 ], [ 123.198318481445312, -10.823055267333984 ], [ 122.848861694335938, -10.929653167724609 ], [ 122.856307983398438, -10.759742736816406 ] ] ], [ [ [ 150.880523681640625, -10.652778625488281 ], [ 150.785247802734375, -10.634723663330078 ], [ 150.7930908203125, -10.541666984558105 ], [ 150.896240234375, -10.550416946411133 ], [ 150.880523681640625, -10.652778625488281 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "North America" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -25.281669616699219, 71.39166259765625 ], [ -25.623889923095703, 71.537200927734375 ], [ -26.950275421142578, 71.578598022460938 ], [ -27.693889617919922, 71.930267333984375 ], [ -28.617221832275391, 72.131362915039062 ], [ -28.358333587646484, 72.015129089355469 ], [ -28.461109161376953, 71.9366455078125 ], [ -27.326807022094727, 71.712631225585938 ], [ -28.466941833496094, 71.552474975585938 ], [ -25.877777099609375, 71.500274658203125 ], [ -25.410276412963867, 71.274848937988281 ], [ -26.784168243408203, 70.9305419921875 ], [ -27.500833511352539, 70.937477111816406 ], [ -27.920692443847656, 71.129981994628906 ], [ -27.617361068725586, 70.951095581054688 ], [ -28.405414581298828, 70.977066040039062 ], [ -27.915693283081055, 70.869560241699219 ], [ -28.305416107177734, 70.559837341308594 ], [ -29.236942291259766, 70.445396423339844 ], [ -26.326946258544922, 70.378799438476562 ], [ -28.589445114135742, 70.089431762695312 ], [ -27.434722900390625, 69.95416259765625 ], [ -26.898887634277344, 70.24859619140625 ], [ -26.307502746582031, 70.19775390625 ], [ -25.261112213134766, 70.413604736328125 ], [ -25.346389770507812, 70.282211303710938 ], [ -25.031112670898438, 70.363037109375 ], [ -23.560558319091797, 70.106094360351562 ], [ -22.081110000610352, 70.137138366699219 ], [ -23.274030685424805, 69.859848022460938 ], [ -22.90916633605957, 69.809974670410156 ], [ -23.000415802001953, 69.756660461425781 ], [ -23.365001678466797, 69.855545043945312 ], [ -23.244789123535156, 69.752212524414062 ], [ -23.929304122924805, 69.752204895019531 ], [ -23.580694198608398, 69.625816345214844 ], [ -23.819446563720703, 69.507492065429688 ], [ -24.347221374511719, 69.601997375488281 ], [ -24.073541641235352, 69.479637145996094 ], [ -24.6522216796875, 69.394439697265625 ], [ -24.664165496826172, 69.246932983398438 ], [ -25.209720611572266, 69.274429321289062 ], [ -24.992774963378906, 69.163314819335938 ], [ -25.305557250976562, 69.018600463867188 ], [ -25.609443664550781, 69.103591918945312 ], [ -25.443471908569336, 68.964714050292969 ], [ -26.363334655761719, 68.66748046875 ], [ -27.619998931884766, 68.476089477539062 ], [ -28.01611328125, 68.562759399414062 ], [ -28.008892059326172, 68.451789855957031 ], [ -28.8477783203125, 68.318603515625 ], [ -29.187221527099609, 68.390548706054688 ], [ -29.118749618530273, 68.282211303710938 ], [ -29.376945495605469, 68.199417114257812 ], [ -29.866109848022461, 68.413185119628906 ], [ -30.196945190429688, 68.242477416992188 ], [ -30.025835037231445, 68.113037109375 ], [ -30.709720611572266, 68.260818481445312 ], [ -30.81361198425293, 68.244491577148438 ], [ -30.422916412353516, 68.065254211425781 ], [ -31.571666717529297, 68.066940307617188 ], [ -31.700555801391602, 68.096656799316406 ], [ -31.67864990234375, 68.178329467773438 ], [ -31.745830535888672, 68.207344055175781 ], [ -31.53034782409668, 68.234291076660156 ], [ -32.007225036621094, 68.261932373046875 ], [ -32.475830078125, 68.621917724609375 ], [ -32.421112060546875, 68.507354736328125 ], [ -32.557502746582031, 68.487762451171875 ], [ -32.133331298828125, 68.196090698242188 ], [ -32.391670227050781, 68.22637939453125 ], [ -32.400276184082031, 68.199417114257812 ], [ -31.999164581298828, 68.095260620117188 ], [ -32.131942749023438, 67.848876953125 ], [ -33.1986083984375, 67.688034057617188 ], [ -33.057914733886719, 67.635055541992188 ], [ -33.273193359375, 67.403739929199219 ], [ -33.595970153808594, 67.371292114257812 ], [ -33.366252899169922, 67.247482299804688 ], [ -33.973052978515625, 66.99053955078125 ], [ -34.270553588867188, 66.574569702148438 ], [ -34.426670074462891, 66.742340087890625 ], [ -34.409370422363281, 66.539009094238281 ], [ -34.719993591308594, 66.33831787109375 ], [ -34.984169006347656, 66.284149169921875 ], [ -35.124996185302734, 66.416786193847656 ], [ -35.232566833496094, 66.311782836914062 ], [ -35.042087554931641, 66.250679016113281 ], [ -35.203887939453125, 66.237762451171875 ], [ -35.8558349609375, 66.432479858398438 ], [ -35.5513916015625, 66.243171691894531 ], [ -35.587501525878906, 66.110260009765625 ], [ -36.331947326660156, 65.907211303710938 ], [ -36.347084045410156, 66.082763671875 ], [ -36.569168090820312, 66.074851989746094 ], [ -36.514446258544922, 65.989700317382812 ], [ -36.985137939453125, 65.8377685546875 ], [ -37.080413818359375, 66.061363220214844 ], [ -37.19305419921875, 65.769149780273438 ], [ -37.810764312744141, 66.029289245605469 ], [ -37.183891296386719, 66.340545654296875 ], [ -38.106109619140625, 66.386932373046875 ], [ -37.694370269775391, 66.264297485351562 ], [ -37.992710113525391, 66.241508483886719 ], [ -37.855350494384766, 66.1982421875 ], [ -38.05194091796875, 65.912490844726562 ], [ -38.480693817138672, 66.013328552246094 ], [ -38.102985382080078, 65.802276611328125 ], [ -38.246528625488281, 65.628311157226562 ], [ -38.751945495605469, 65.690948486328125 ], [ -38.599441528320312, 65.577903747558594 ], [ -39.057502746582031, 65.559417724609375 ], [ -39.324447631835938, 65.715545654296875 ], [ -39.20111083984375, 65.583602905273438 ], [ -39.660274505615234, 65.679985046386719 ], [ -39.829444885253906, 65.495819091796875 ], [ -40.096389770507812, 65.567214965820312 ], [ -40.215003967285156, 65.493453979492188 ], [ -39.793403625488281, 65.415191650390625 ], [ -39.941665649414062, 65.364990234375 ], [ -39.755561828613281, 65.242752075195312 ], [ -40.256393432617188, 65.016387939453125 ], [ -40.596107482910156, 65.134994506835938 ], [ -41.155414581298828, 64.962348937988281 ], [ -40.600837707519531, 64.68109130859375 ], [ -40.636806488037109, 64.4658203125 ], [ -40.357013702392578, 64.354217529296875 ], [ -40.788055419921875, 64.384429931640625 ], [ -41.506950378417969, 64.325820922851562 ], [ -41.567989349365234, 64.263877868652344 ], [ -40.567779541015625, 64.109146118164062 ], [ -40.837635040283203, 63.94415283203125 ], [ -40.619720458984375, 63.922767639160156 ], [ -40.515975952148438, 63.699573516845703 ], [ -41.617774963378906, 63.792221069335938 ], [ -40.748336791992188, 63.509162902832031 ], [ -41.173835754394531, 63.512020111083984 ], [ -41.001388549804688, 63.405826568603516 ], [ -41.118194580078125, 63.385269165039062 ], [ -41.3941650390625, 63.552215576171875 ], [ -41.239860534667969, 63.406169891357422 ], [ -41.581947326660156, 63.488327026367188 ], [ -41.113334655761719, 63.307212829589844 ], [ -41.687217712402344, 63.524993896484375 ], [ -41.896392822265625, 63.470542907714844 ], [ -41.855972290039062, 63.397491455078125 ], [ -41.470966339111328, 63.217628479003906 ], [ -41.487419128417969, 63.169624328613281 ], [ -41.432430267333984, 63.120964050292969 ], [ -42.023056030273438, 63.246940612792969 ], [ -41.538818359375, 63.032146453857422 ], [ -41.730278015136719, 63.029716491699219 ], [ -42.173194885253906, 63.203048706054688 ], [ -41.999725341796875, 63.031379699707031 ], [ -41.617916107177734, 62.989299774169922 ], [ -41.751670837402344, 62.840682983398438 ], [ -42.323890686035156, 62.809158325195312 ], [ -42.303611755371094, 62.941658020019531 ], [ -42.527778625488281, 62.723045349121094 ], [ -43.144443511962891, 62.75860595703125 ], [ -42.16534423828125, 62.38262939453125 ], [ -42.980415344238281, 62.510967254638672 ], [ -42.261947631835938, 62.242351531982422 ], [ -42.543617248535156, 61.945823669433594 ], [ -42.115837097167969, 62.006660461425781 ], [ -42.416248321533203, 61.915199279785156 ], [ -42.191452026367188, 61.862079620361328 ], [ -42.3255615234375, 61.761383056640625 ], [ -42.768890380859375, 61.81805419921875 ], [ -42.864307403564453, 61.779296875 ], [ -42.317642211914062, 61.642635345458984 ], [ -42.434722900390625, 61.557212829589844 ], [ -43.079170227050781, 61.593605041503906 ], [ -42.528263092041016, 61.527076721191406 ], [ -42.50750732421875, 61.355270385742188 ], [ -43.24444580078125, 61.337352752685547 ], [ -42.664302825927734, 61.256526947021484 ], [ -42.577919006347656, 61.193462371826172 ], [ -43.0897216796875, 61.197486877441406 ], [ -42.634029388427734, 61.101173400878906 ], [ -43.612361907958984, 61.126380920410156 ], [ -42.707775115966797, 61.059158325195312 ], [ -43.008613586425781, 60.883880615234375 ], [ -43.483608245849609, 60.935684204101562 ], [ -42.790840148925781, 60.801101684570312 ], [ -43.524650573730469, 60.836936950683594 ], [ -42.751876831054688, 60.684226989746094 ], [ -43.068611145019531, 60.498878479003906 ], [ -43.314861297607422, 60.550895690917969 ], [ -43.208610534667969, 60.464439392089844 ], [ -43.697776794433594, 60.715686798095703 ], [ -43.629997253417969, 60.548606872558594 ], [ -44.199581146240234, 60.590892791748047 ], [ -43.314651489257812, 60.440963745117188 ], [ -43.587638854980469, 60.305267333984375 ], [ -43.166248321533203, 60.396244049072266 ], [ -43.0927734375, 60.257217407226562 ], [ -43.322013854980469, 60.213672637939453 ], [ -43.08721923828125, 60.100273132324219 ], [ -44.1138916015625, 60.183601379394531 ], [ -43.993888854980469, 60.3074951171875 ], [ -44.102779388427734, 60.383884429931641 ], [ -44.082504272460938, 60.287563323974609 ], [ -44.454303741455078, 60.149436950683594 ], [ -44.586662292480469, 59.988327026367188 ], [ -44.961944580078125, 60.0302734375 ], [ -45.169029235839844, 60.092212677001953 ], [ -44.824447631835938, 60.189987182617188 ], [ -44.470832824707031, 60.557212829589844 ], [ -44.887363433837891, 60.215549468994141 ], [ -45.202499389648438, 60.186935424804688 ], [ -44.629371643066406, 60.734088897705078 ], [ -45.2177734375, 60.434158325195312 ], [ -45.099166870117188, 60.645828247070312 ], [ -45.487358093261719, 60.491867065429688 ], [ -45.313331604003906, 60.699996948242188 ], [ -45.574722290039062, 60.469154357910156 ], [ -45.681381225585938, 60.637031555175781 ], [ -45.977981567382812, 60.577911376953125 ], [ -45.677902221679688, 60.673030853271484 ], [ -45.852085113525391, 60.695682525634766 ], [ -45.252780914306641, 60.90582275390625 ], [ -45.384170532226562, 61.007217407226562 ], [ -45.686386108398438, 60.774711608886719 ], [ -46.222354888916016, 60.758052825927734 ], [ -45.489723205566406, 60.989158630371094 ], [ -45.252227783203125, 61.107215881347656 ], [ -45.215900421142578, 61.203807830810547 ], [ -45.370830535888672, 61.090129852294922 ], [ -45.500556945800781, 61.233329772949219 ], [ -45.631385803222656, 61.007217407226562 ], [ -46.0655517578125, 60.921104431152344 ], [ -45.653610229492188, 61.142219543457031 ], [ -45.866668701171875, 61.215133666992188 ], [ -45.790000915527344, 61.334991455078125 ], [ -46.009727478027344, 61.223045349121094 ], [ -45.839580535888672, 61.162769317626953 ], [ -45.915000915527344, 61.09027099609375 ], [ -46.229438781738281, 60.974708557128906 ], [ -46.405796051025391, 61.082386016845703 ], [ -46.862220764160156, 60.797355651855469 ], [ -47.023056030273438, 60.976097106933594 ], [ -48.226943969726562, 60.81610107421875 ], [ -47.689857482910156, 61.006801605224609 ], [ -48.406665802001953, 60.992076873779297 ], [ -47.836803436279297, 61.040134429931641 ], [ -48.216392517089844, 61.180274963378906 ], [ -47.920696258544922, 61.322566986083984 ], [ -48.4102783203125, 61.132209777832031 ], [ -48.321681976318359, 61.206310272216797 ], [ -48.639167785644531, 61.210407257080078 ], [ -48.378608703613281, 61.363883972167969 ], [ -49.065277099609375, 61.399436950683594 ], [ -48.232704162597656, 61.535896301269531 ], [ -48.344161987304688, 61.604995727539062 ], [ -48.948883056640625, 61.465545654296875 ], [ -49.297500610351562, 61.5574951171875 ], [ -48.599212646484375, 61.636337280273438 ], [ -49.149028778076172, 61.7198486328125 ], [ -48.775276184082031, 61.987213134765625 ], [ -49.238052368164062, 61.711662292480469 ], [ -49.354171752929688, 61.765548706054688 ], [ -49.2147216796875, 61.88360595703125 ], [ -49.438606262207031, 61.84130859375 ], [ -48.842567443847656, 62.076107025146484 ], [ -49.091804504394531, 62.076797485351562 ], [ -49.032222747802734, 62.213047027587891 ], [ -49.158191680908203, 62.020687103271484 ], [ -49.669448852539062, 61.99554443359375 ], [ -49.688606262207031, 62.116939544677734 ], [ -49.42083740234375, 62.089988708496094 ], [ -49.293891906738281, 62.172218322753906 ], [ -49.638336181640625, 62.150825500488281 ], [ -49.394775390625, 62.24688720703125 ], [ -49.83721923828125, 62.237495422363281 ], [ -50.315624237060547, 62.494300842285156 ], [ -49.947494506835938, 62.827217102050781 ], [ -50.277778625488281, 62.703323364257812 ], [ -50.150833129882812, 62.930824279785156 ], [ -49.699718475341797, 63.055267333984375 ], [ -50.193584442138672, 62.932743072509766 ], [ -50.369720458984375, 62.781661987304688 ], [ -50.149993896484375, 63.015274047851562 ], [ -50.593887329101562, 62.969985961914062 ], [ -50.606391906738281, 63.094436645507812 ], [ -50.059844970703125, 63.228752136230469 ], [ -50.570281982421875, 63.227210998535156 ], [ -50.794281005859375, 63.196895599365234 ], [ -50.920486450195312, 63.141796112060547 ], [ -50.803195953369141, 63.249717712402344 ], [ -51.059440612792969, 63.184158325195312 ], [ -51.107364654541016, 63.340404510498047 ], [ -50.279651641845703, 63.400615692138672 ], [ -51.158332824707031, 63.378044128417969 ], [ -50.746734619140625, 63.550407409667969 ], [ -51.131805419921875, 63.620269775390625 ], [ -50.549030303955078, 63.609855651855469 ], [ -50.507640838623047, 63.669158935546875 ], [ -51.081943511962891, 63.665409088134766 ], [ -51.184371948242188, 63.622421264648438 ], [ -51.168609619140625, 63.502777099609375 ], [ -51.547782897949219, 63.740547180175781 ], [ -50.924308776855469, 63.930965423583984 ], [ -51.430831909179688, 63.803604125976562 ], [ -51.362220764160156, 63.966934204101562 ], [ -51.65777587890625, 64.010543823242188 ], [ -50.048061370849609, 64.195671081542969 ], [ -50.552082061767578, 64.1795654296875 ], [ -50.475555419921875, 64.291091918945312 ], [ -51.445831298828125, 64.078048706054688 ], [ -51.74847412109375, 64.202072143554688 ], [ -50.950836181640625, 64.218048095703125 ], [ -50.846389770507812, 64.252082824707031 ], [ -51.037223815917969, 64.271102905273438 ], [ -50.856391906738281, 64.415542602539062 ], [ -50.352226257324219, 64.38275146484375 ], [ -50.176181793212891, 64.446792602539062 ], [ -50.908191680908203, 64.594985961914062 ], [ -50.525276184082031, 64.704986572265625 ], [ -50.134304046630859, 64.476516723632812 ], [ -49.587776184082031, 64.353591918945312 ], [ -50.063678741455078, 64.52783203125 ], [ -49.991527557373047, 64.699432373046875 ], [ -50.209724426269531, 64.741653442382812 ], [ -49.998821258544922, 64.864700317382812 ], [ -50.564029693603516, 64.770408630371094 ], [ -50.69305419921875, 64.994140625 ], [ -50.981941223144531, 65.216796875 ], [ -50.634098052978516, 64.758323669433594 ], [ -51.143333435058594, 64.613601684570312 ], [ -51.023887634277344, 64.754714965820312 ], [ -51.224166870117188, 64.76220703125 ], [ -51.665000915527344, 64.30609130859375 ], [ -52.004726409912109, 64.201797485351562 ], [ -52.116249084472656, 64.722763061523438 ], [ -51.249862670898438, 65.015472412109375 ], [ -52.211387634277344, 64.806640625 ], [ -52.011390686035156, 64.979156494140625 ], [ -52.280281066894531, 65.076095581054688 ], [ -52.099723815917969, 65.239151000976562 ], [ -52.310207366943359, 65.201858520507812 ], [ -52.222770690917969, 65.327774047851562 ], [ -52.5191650390625, 65.185256958007812 ], [ -52.562152862548828, 65.320053100585938 ], [ -51.719303131103516, 65.583465576171875 ], [ -51.899234771728516, 65.621711730957031 ], [ -51.694442749023438, 65.698593139648438 ], [ -50.546947479248047, 65.707695007324219 ], [ -51.484725952148438, 65.763046264648438 ], [ -51.948051452636719, 65.65887451171875 ], [ -51.934440612792969, 65.546371459960938 ], [ -52.495903015136719, 65.387969970703125 ], [ -52.612083435058594, 65.480674743652344 ], [ -52.469161987304688, 65.640823364257812 ], [ -52.805000305175781, 65.548599243164062 ], [ -52.607223510742188, 65.658599853515625 ], [ -52.768817901611328, 65.6356201171875 ], [ -52.688121795654297, 65.8045654296875 ], [ -52.810554504394531, 65.671646118164062 ], [ -53.233325958251953, 65.682830810546875 ], [ -52.875, 65.80303955078125 ], [ -53.265003204345703, 65.742828369140625 ], [ -52.6986083984375, 65.935531616210938 ], [ -52.319999694824219, 65.868865966796875 ], [ -51.813888549804688, 65.964706420898438 ], [ -51.831947326660156, 66.055816650390625 ], [ -52.3175048828125, 65.899154663085938 ], [ -52.618057250976562, 65.97998046875 ], [ -53.151664733886719, 65.855819702148438 ], [ -53.233329772949219, 65.92303466796875 ], [ -52.878467559814453, 66.019294738769531 ], [ -53.467010498046875, 65.972412109375 ], [ -51.271385192871094, 66.8438720703125 ], [ -50.354446411132812, 66.827484130859375 ], [ -51.007503509521484, 66.902214050292969 ], [ -50.001110076904297, 66.9764404296875 ], [ -50.9486083984375, 66.978591918945312 ], [ -53.006668090820312, 66.193313598632812 ], [ -53.620834350585938, 66.143875122070312 ], [ -53.12249755859375, 66.284706115722656 ], [ -53.615833282470703, 66.241790771484375 ], [ -53.629024505615234, 66.506240844726562 ], [ -52.417362213134766, 66.544288635253906 ], [ -53.451942443847656, 66.637496948242188 ], [ -52.586666107177734, 66.703041076660156 ], [ -53.204723358154297, 66.744560241699219 ], [ -52.852497100830078, 66.779701232910156 ], [ -53.112533569335938, 66.759986877441406 ], [ -52.982772827148438, 66.853042602539062 ], [ -52.336112976074219, 66.810531616210938 ], [ -52.232563018798828, 66.837486267089844 ], [ -52.498336791992188, 66.912490844726562 ], [ -53.675003051757812, 66.913604736328125 ], [ -53.825836181640625, 66.978034973144531 ], [ -53.222080230712891, 66.990814208984375 ], [ -53.961109161376953, 67.074295043945312 ], [ -53.816665649414062, 67.178863525390625 ], [ -52.151390075683594, 67.369979858398438 ], [ -51.52471923828125, 67.323043823242188 ], [ -51.189437866210938, 67.12359619140625 ], [ -50.350486755371094, 67.184318542480469 ], [ -51.173332214355469, 67.139434814453125 ], [ -51.523960113525391, 67.349494934082031 ], [ -51.151664733886719, 67.423309326171875 ], [ -53.252227783203125, 67.320541381835938 ], [ -53.79833984375, 67.202774047851562 ], [ -53.803611755371094, 67.4144287109375 ], [ -52.496109008789062, 67.76971435546875 ], [ -51.809440612792969, 67.625808715820312 ], [ -51.330284118652344, 67.675811767578125 ], [ -50.700553894042969, 67.491653442382812 ], [ -50.195831298828125, 67.46734619140625 ], [ -50.070972442626953, 67.511383056640625 ], [ -50.849998474121094, 67.603591918945312 ], [ -49.941108703613281, 67.692337036132812 ], [ -51.010974884033203, 67.624702453613281 ], [ -51.231109619140625, 67.712493896484375 ], [ -50.417503356933594, 67.844436645507812 ], [ -50.779441833496094, 67.906646728515625 ], [ -50.678054809570312, 67.850540161132812 ], [ -51.173614501953125, 67.75860595703125 ], [ -51.33111572265625, 67.868865966796875 ], [ -50.973674774169922, 67.883316040039062 ], [ -51.05999755859375, 67.974151611328125 ], [ -51.564308166503906, 67.933586120605469 ], [ -51.320419311523438, 67.813735961914062 ], [ -51.713058471679688, 67.694976806640625 ], [ -51.840831756591797, 67.734848022460938 ], [ -51.628887176513672, 67.76873779296875 ], [ -52.340137481689453, 67.822212219238281 ], [ -51.574031829833984, 67.965408325195312 ], [ -51.613334655761719, 67.974151611328125 ], [ -53.729438781738281, 67.536651611328125 ], [ -53.539443969726562, 67.7108154296875 ], [ -53.627777099609375, 67.814697265625 ], [ -52.959140777587891, 67.977813720703125 ], [ -53.191383361816406, 68.041648864746094 ], [ -53.081672668457031, 68.062759399414062 ], [ -52.748336791992188, 67.96832275390625 ], [ -52.21221923828125, 67.92303466796875 ], [ -52.062358856201172, 67.976516723632812 ], [ -53.450000762939453, 68.151374816894531 ], [ -53.321113586425781, 68.184417724609375 ], [ -52.427497863769531, 68.0635986328125 ], [ -52.797225952148438, 68.177902221679688 ], [ -51.857780456542969, 68.04193115234375 ], [ -51.188606262207031, 68.0635986328125 ], [ -50.569450378417969, 67.90081787109375 ], [ -50.1441650390625, 67.939422607421875 ], [ -51.434719085693359, 68.200126647949219 ], [ -50.971382141113281, 68.177619934082031 ], [ -51.220832824707031, 68.273605346679688 ], [ -51.182777404785156, 68.394432067871094 ], [ -50.819999694824219, 68.50360107421875 ], [ -51.645004272460938, 68.407760620117188 ], [ -51.240837097167969, 68.28997802734375 ], [ -52.419166564941406, 68.1805419921875 ], [ -53.38861083984375, 68.329025268554688 ], [ -53.079727172851562, 68.323043823242188 ], [ -52.603889465332031, 68.453323364257812 ], [ -52.461669921875, 68.54498291015625 ], [ -50.865837097167969, 68.614700317382812 ], [ -50.987220764160156, 68.73248291015625 ], [ -50.655551910400391, 68.823326110839844 ], [ -51.288822174072266, 68.747001647949219 ], [ -50.966110229492188, 68.932487487792969 ], [ -51.114448547363281, 68.926925659179688 ], [ -51.074306488037109, 69.130119323730469 ], [ -50.217498779296875, 68.956649780273438 ], [ -50.243888854980469, 69.075271606445312 ], [ -50.680282592773438, 69.102767944335938 ], [ -50.141666412353516, 69.173866271972656 ], [ -50.467636108398438, 69.198173522949219 ], [ -50.397499084472656, 69.3408203125 ], [ -51.120273590087891, 69.200401306152344 ], [ -50.8558349609375, 69.461105346679688 ], [ -50.204719543457031, 69.521926879882812 ], [ -50.882778167724609, 69.495536804199219 ], [ -50.800552368164062, 69.6422119140625 ], [ -50.407218933105469, 69.595954895019531 ], [ -50.815418243408203, 69.707626342773438 ], [ -50.191665649414062, 69.757492065429688 ], [ -50.589302062988281, 69.923728942871094 ], [ -50.217636108398438, 70.0242919921875 ], [ -52.312774658203125, 70.046646118164062 ], [ -54.627220153808594, 70.653045654296875 ], [ -54.128608703613281, 70.82916259765625 ], [ -52.970832824707031, 70.764434814453125 ], [ -50.546527862548828, 70.339988708496094 ], [ -50.678054809570312, 70.395271301269531 ], [ -50.509727478027344, 70.526092529296875 ], [ -50.947776794433594, 70.420257568359375 ], [ -51.34527587890625, 70.564155578613281 ], [ -50.888893127441406, 70.50555419921875 ], [ -50.741107940673828, 70.545257568359375 ], [ -50.979026794433594, 70.626365661621094 ], [ -50.640838623046875, 70.641372680664062 ], [ -51.440967559814453, 70.725753784179688 ], [ -50.635555267333984, 70.721656799316406 ], [ -50.844444274902344, 70.870674133300781 ], [ -51.952499389648438, 71.021102905273438 ], [ -51.189994812011719, 70.953872680664062 ], [ -50.918060302734375, 71.020263671875 ], [ -52.245903015136719, 71.121917724609375 ], [ -51.526111602783203, 71.278038024902344 ], [ -51.645553588867188, 71.361373901367188 ], [ -52.555137634277344, 71.176231384277344 ], [ -52.28277587890625, 71.254714965820312 ], [ -52.185554504394531, 71.379150390625 ], [ -51.345970153808594, 71.484153747558594 ], [ -52.986179351806641, 71.418037414550781 ], [ -51.802780151367188, 71.594436645507812 ], [ -51.643405914306641, 71.708953857421875 ], [ -53.250556945800781, 71.702774047851562 ], [ -52.687149047851562, 71.999984741210938 ], [ -53.321945190429688, 71.822219848632812 ], [ -53.406105041503906, 72.044708251953125 ], [ -53.856533050537109, 72.318870544433594 ], [ -53.610557556152344, 72.36248779296875 ], [ -53.953891754150391, 72.324851989746094 ], [ -53.397361755371094, 71.848182678222656 ], [ -53.916389465332031, 71.738319396972656 ], [ -53.775001525878906, 71.633331298828125 ], [ -54.10028076171875, 71.707489013671875 ], [ -53.855140686035156, 71.555679321289062 ], [ -53.915550231933594, 71.441925048828125 ], [ -54.8255615234375, 71.352767944335938 ], [ -55.258338928222656, 71.49053955078125 ], [ -55.117565155029297, 71.388458251953125 ], [ -55.323616027832031, 71.386932373046875 ], [ -55.678817749023438, 71.626922607421875 ], [ -55.574722290039062, 71.64068603515625 ], [ -55.9052734375, 71.679977416992188 ], [ -54.826530456542969, 71.917068481445312 ], [ -54.536666870117188, 72.041366577148438 ], [ -54.389305114746094, 72.222969055175781 ], [ -54.861946105957031, 71.9427490234375 ], [ -55.29833984375, 71.9285888671875 ], [ -55.580001831054688, 71.998870849609375 ], [ -54.686943054199219, 72.367210388183594 ], [ -55.626388549804688, 72.457489013671875 ], [ -54.299308776855469, 72.481231689453125 ], [ -55.017364501953125, 72.523460388183594 ], [ -54.630275726318359, 72.61962890625 ], [ -54.870552062988281, 72.642486572265625 ], [ -54.654998779296875, 72.764999389648438 ], [ -54.924308776855469, 72.775543212890625 ], [ -54.605415344238281, 72.826377868652344 ], [ -54.850555419921875, 73.014434814453125 ], [ -55.695137023925781, 73.064155578613281 ], [ -55.142921447753906, 73.184288024902344 ], [ -55.456668853759766, 73.254852294921875 ], [ -55.089622497558594, 73.354278564453125 ], [ -56.071807861328125, 73.645965576171875 ], [ -55.611251831054688, 73.723731994628906 ], [ -55.944927215576172, 73.854148864746094 ], [ -55.641250610351562, 73.869148254394531 ], [ -56.12249755859375, 74.00665283203125 ], [ -55.973331451416016, 74.031517028808594 ], [ -56.409858703613281, 74.06915283203125 ], [ -56.129165649414062, 74.2783203125 ], [ -57.323337554931641, 74.104705810546875 ], [ -56.129581451416016, 74.38067626953125 ], [ -56.794448852539062, 74.445877075195312 ], [ -56.249443054199219, 74.480545043945312 ], [ -56.192913055419922, 74.550262451171875 ], [ -57.015007019042969, 74.671371459960938 ], [ -57.187221527099609, 74.772216796875 ], [ -56.861114501953125, 74.806930541992188 ], [ -57.026390075683594, 74.91387939453125 ], [ -58.139583587646484, 75.046928405761719 ], [ -57.918056488037109, 75.162345886230469 ], [ -58.334724426269531, 75.265274047851562 ], [ -58.300197601318359, 75.387374877929688 ], [ -58.68804931640625, 75.342208862304688 ], [ -58.159580230712891, 75.508598327636719 ], [ -58.598468780517578, 75.671714782714844 ], [ -58.423614501953125, 75.719711303710938 ], [ -59.061668395996094, 75.70416259765625 ], [ -59.216110229492188, 75.872207641601562 ], [ -59.78472900390625, 75.796371459960938 ], [ -59.592639923095703, 75.907905578613281 ], [ -60.738052368164062, 75.993316650390625 ], [ -60.878608703613281, 76.152481079101562 ], [ -62.239723205566406, 76.286651611328125 ], [ -62.778610229492188, 76.193588256835938 ], [ -63.38555908203125, 76.372756958007812 ], [ -64.012222290039062, 76.134719848632812 ], [ -64.412216186523438, 76.347213745117188 ], [ -64.44110107421875, 76.228866577148438 ], [ -64.685546875, 76.255134582519531 ], [ -64.599998474121094, 76.129425048828125 ], [ -65.328338623046875, 76.174697875976562 ], [ -65.479721069335938, 76.018600463867188 ], [ -65.886802673339844, 76.100616455078125 ], [ -65.556938171386719, 76.236648559570312 ], [ -65.769454956054688, 76.275543212890625 ], [ -66.19415283203125, 76.2802734375 ], [ -66.433059692382812, 76.082763671875 ], [ -66.960006713867188, 76.26361083984375 ], [ -67.305274963378906, 76.165122985839844 ], [ -66.48388671875, 75.908599853515625 ], [ -68.500564575195312, 76.086929321289062 ], [ -69.631515502929688, 76.3736572265625 ], [ -67.982223510742188, 76.679428100585938 ], [ -70.099655151367188, 76.80157470703125 ], [ -69.5433349609375, 77.001800537109375 ], [ -69.672500610351562, 77.012496948242188 ], [ -70.547225952148438, 76.788589477539062 ], [ -71.375274658203125, 77.05609130859375 ], [ -70.149169921875, 77.24053955078125 ], [ -68.540557861328125, 77.166091918945312 ], [ -66.4486083984375, 77.133880615234375 ], [ -66.17138671875, 77.190254211425781 ], [ -69.101669311523438, 77.271926879882812 ], [ -67.6199951171875, 77.386383056640625 ], [ -66.238327026367188, 77.24859619140625 ], [ -66.657012939453125, 77.412483215332031 ], [ -66.055557250976562, 77.491363525390625 ], [ -66.723335266113281, 77.678451538085938 ], [ -68.3447265625, 77.49859619140625 ], [ -68.699432373046875, 77.66387939453125 ], [ -68.8155517578125, 77.651382446289062 ], [ -68.605690002441406, 77.519294738769531 ], [ -69.250289916992188, 77.453048706054688 ], [ -70.288887023925781, 77.566795349121094 ], [ -69.501113891601562, 77.684707641601562 ], [ -69.481391906738281, 77.752632141113281 ], [ -70.602783203125, 77.67803955078125 ], [ -69.974929809570312, 77.834571838378906 ], [ -71.32000732421875, 77.76361083984375 ], [ -71.43902587890625, 77.790962219238281 ], [ -71.2288818359375, 77.878585815429688 ], [ -73.053604125976562, 78.157211303710938 ], [ -72.4566650390625, 78.286376953125 ], [ -72.849441528320312, 78.31414794921875 ], [ -72.552215576171875, 78.521102905273438 ], [ -68.8074951171875, 78.828323364257812 ], [ -69.168319702148438, 78.921859741210938 ], [ -68.340560913085938, 79.063034057617188 ], [ -65.976669311523438, 79.101654052734375 ], [ -64.835281372070312, 79.521926879882812 ], [ -65.0513916015625, 80.016937255859375 ], [ -63.784873962402344, 80.144851684570312 ], [ -64.205001831054688, 80.25054931640625 ], [ -64.902496337890625, 80.063308715820312 ], [ -67.049728393554688, 80.057479858398438 ], [ -67.483612060546875, 80.190811157226562 ], [ -67.481948852539062, 80.32415771484375 ], [ -63.680557250976562, 81.143875122070312 ], [ -62.794448852539062, 80.7510986328125 ], [ -63.371109008789062, 81.152488708496094 ], [ -61.056663513183594, 81.119705200195312 ], [ -60.891944885253906, 81.165542602539062 ], [ -61.311180114746094, 81.353248596191406 ], [ -60.769027709960938, 81.496795654296875 ], [ -61.452224731445312, 81.7530517578125 ], [ -60.806663513183594, 81.879974365234375 ], [ -58.899444580078125, 81.864700317382812 ], [ -58.642501831054688, 81.675537109375 ], [ -56.519996643066406, 81.331100463867188 ], [ -59.465831756591797, 81.992759704589844 ], [ -55.902496337890625, 82.268051147460938 ], [ -55.113334655761719, 82.156646728515625 ], [ -55.602222442626953, 82.28082275390625 ], [ -54.450279235839844, 82.364151000976562 ], [ -53.559722900390625, 82.1160888671875 ], [ -53.500839233398438, 81.906097412109375 ], [ -53.808052062988281, 81.566513061523438 ], [ -53.473052978515625, 81.501663208007812 ], [ -53.547782897949219, 81.668594360351562 ], [ -52.938606262207031, 81.856369018554688 ], [ -52.964164733886719, 82.029434204101562 ], [ -49.903610229492188, 81.609420776367188 ], [ -49.619789123535156, 81.64019775390625 ], [ -51.066387176513672, 81.935256958007812 ], [ -49.435134887695312, 81.929008483886719 ], [ -50.694999694824219, 82.182479858398438 ], [ -51.083885192871094, 82.50360107421875 ], [ -49.191665649414062, 82.469985961914062 ], [ -44.639999389648438, 81.754165649414062 ], [ -44.183326721191406, 81.834152221679688 ], [ -44.921806335449219, 81.987899780273438 ], [ -44.50250244140625, 82.089706420898438 ], [ -44.793476104736328, 82.188522338867188 ], [ -44.618057250976562, 82.276657104492188 ], [ -42.300834655761719, 82.214988708496094 ], [ -43.830284118652344, 82.3358154296875 ], [ -43.728469848632812, 82.404151916503906 ], [ -45.763336181640625, 82.761932373046875 ], [ -42.142776489257812, 82.76165771484375 ], [ -41.682777404785156, 82.478042602539062 ], [ -41.608894348144531, 82.64166259765625 ], [ -41.899166107177734, 82.730262756347656 ], [ -41.550277709960938, 82.736648559570312 ], [ -39.753337860107422, 82.401519775390625 ], [ -40.011947631835938, 82.559982299804688 ], [ -39.904998779296875, 82.671646118164062 ], [ -40.135276794433594, 82.714431762695312 ], [ -42.191108703613281, 82.851654052734375 ], [ -45.993057250976562, 82.844436645507812 ], [ -46.889026641845703, 82.9627685546875 ], [ -45.986110687255859, 82.917343139648438 ], [ -46.701251983642578, 83.0030517578125 ], [ -46.033058166503906, 83.088592529296875 ], [ -45.082221984863281, 82.929702758789062 ], [ -44.7550048828125, 82.964431762695312 ], [ -43.98944091796875, 82.91192626953125 ], [ -43.365974426269531, 82.919151306152344 ], [ -45.521106719970703, 83.12109375 ], [ -45.411109924316406, 83.152206420898438 ], [ -42.872772216796875, 83.092758178710938 ], [ -43.98309326171875, 83.2010498046875 ], [ -42.651107788085938, 83.272491455078125 ], [ -38.574447631835938, 82.744140625 ], [ -39.147220611572266, 82.979423522949219 ], [ -37.270278930664062, 83.005264282226562 ], [ -38.79736328125, 83.05609130859375 ], [ -36.877914428710938, 83.148605346679688 ], [ -38.678054809570312, 83.20526123046875 ], [ -38.855278015136719, 83.249427795410156 ], [ -38.856391906738281, 83.431655883789062 ], [ -37.796112060546875, 83.359146118164062 ], [ -38.058609008789062, 83.431365966796875 ], [ -37.625831604003906, 83.504165649414062 ], [ -36.43804931640625, 83.361099243164062 ], [ -36.900833129882812, 83.492477416992188 ], [ -30.388332366943359, 83.602203369140625 ], [ -25.653402328491211, 83.290473937988281 ], [ -26.956108093261719, 83.143600463867188 ], [ -30.047500610351562, 83.171371459960938 ], [ -31.929164886474609, 83.051651000976562 ], [ -33.387779235839844, 83.150543212890625 ], [ -32.472217559814453, 83.043876647949219 ], [ -35.617916107177734, 82.902626037597656 ], [ -35.296394348144531, 82.886383056640625 ], [ -35.550971984863281, 82.761383056640625 ], [ -35.43499755859375, 82.741363525390625 ], [ -34.886947631835938, 82.9063720703125 ], [ -33.924446105957031, 82.9033203125 ], [ -33.881942749023438, 82.78887939453125 ], [ -33.536949157714844, 82.94525146484375 ], [ -31.643611907958984, 82.929153442382812 ], [ -30.059444427490234, 83.125534057617188 ], [ -28.177497863769531, 83.04193115234375 ], [ -25.142223358154297, 83.162765502929688 ], [ -24.750835418701172, 83.003738403320312 ], [ -25.899028778076172, 82.776092529296875 ], [ -23.992774963378906, 82.911651611328125 ], [ -23.842222213745117, 82.895126342773438 ], [ -24.022224426269531, 82.757217407226562 ], [ -23.378887176513672, 82.848876953125 ], [ -21.316389083862305, 82.610954284667969 ], [ -22.481666564941406, 82.330825805664062 ], [ -25.068889617919922, 82.152481079101562 ], [ -31.591388702392578, 82.208328247070312 ], [ -29.908193588256836, 82.095268249511719 ], [ -33.098335266113281, 81.773880004882812 ], [ -33.018333435058594, 81.6563720703125 ], [ -28.997219085693359, 81.994430541992188 ], [ -25.202499389648438, 81.98651123046875 ], [ -25.428333282470703, 81.748031616210938 ], [ -27.628471374511719, 81.489013671875 ], [ -27.18638801574707, 81.405960083007812 ], [ -27.570972442626953, 81.38970947265625 ], [ -27.32861328125, 81.380813598632812 ], [ -24.210556030273438, 81.708328247070312 ], [ -24.002223968505859, 82.009719848632812 ], [ -22.3013916015625, 82.084426879882812 ], [ -22.016944885253906, 81.93304443359375 ], [ -21.973609924316406, 81.733047485351562 ], [ -22.231109619140625, 81.4658203125 ], [ -22.968053817749023, 81.290397644042969 ], [ -22.765279769897461, 81.263740539550781 ], [ -24.511669158935547, 80.540817260742188 ], [ -23.671943664550781, 80.716659545898438 ], [ -23.559444427490234, 80.889434814453125 ], [ -19.940834045410156, 81.68304443359375 ], [ -20.305557250976562, 81.451095581054688 ], [ -18.017223358154297, 81.468048095703125 ], [ -17.608888626098633, 81.605400085449219 ], [ -17.859582901000977, 81.731513977050781 ], [ -17.353889465332031, 81.701934814453125 ], [ -17.534725189208984, 81.853591918945312 ], [ -16.700553894042969, 81.931930541992188 ], [ -14.768056869506836, 81.918319702148438 ], [ -12.157639503479004, 81.600677490234375 ], [ -14.027223587036133, 81.141937255859375 ], [ -14.975276947021484, 81.128311157226562 ], [ -15.138958930969238, 81.084640502929688 ], [ -14.650556564331055, 80.946929931640625 ], [ -16.005001068115234, 80.728591918945312 ], [ -17.959163665771484, 80.805252075195312 ], [ -18.577777862548828, 80.625259399414062 ], [ -20.087501525878906, 80.68719482421875 ], [ -21.248886108398438, 80.571586608886719 ], [ -17.438610076904297, 80.62969970703125 ], [ -16.119234085083008, 80.506935119628906 ], [ -17.113887786865234, 80.236923217773438 ], [ -19.700832366943359, 80.285812377929688 ], [ -20.554861068725586, 80.103179931640625 ], [ -20.366111755371094, 80.085960388183594 ], [ -20.752361297607422, 79.862350463867188 ], [ -20.326946258544922, 79.760543823242188 ], [ -19.877639770507812, 79.844291687011719 ], [ -20.257225036621094, 79.881362915039062 ], [ -20.053333282470703, 79.979705810546875 ], [ -19.289443969726562, 80.103317260742188 ], [ -17.450761795043945, 80.05657958984375 ], [ -18.222499847412109, 79.754989624023438 ], [ -19.228610992431641, 79.78887939453125 ], [ -19.631389617919922, 79.661376953125 ], [ -19.799999237060547, 79.457969665527344 ], [ -19.656387329101562, 79.350265502929688 ], [ -19.864583969116211, 79.151931762695312 ], [ -19.573612213134766, 79.331100463867188 ], [ -19.091667175292969, 79.29998779296875 ], [ -19.206386566162109, 79.218048095703125 ], [ -19.079444885253906, 79.202491760253906 ], [ -19.30986213684082, 79.170814514160156 ], [ -19.19677734375, 79.278938293457031 ], [ -19.378334045410156, 79.274993896484375 ], [ -20.091110229492188, 79.0635986328125 ], [ -19.914722442626953, 78.964157104492188 ], [ -20.018058776855469, 78.877197265625 ], [ -21.183609008789062, 78.807273864746094 ], [ -20.928333282470703, 78.691642761230469 ], [ -21.424373626708984, 78.649223327636719 ], [ -20.909860610961914, 78.621231079101562 ], [ -21.373054504394531, 78.3055419921875 ], [ -21.288055419921875, 78.212203979492188 ], [ -21.757919311523438, 78.132484436035156 ], [ -21.409303665161133, 78.10748291015625 ], [ -22.036945343017578, 77.685676574707031 ], [ -21.429531097412109, 77.674858093261719 ], [ -21.724998474121094, 77.549148559570312 ], [ -21.578334808349609, 77.56414794921875 ], [ -20.866390228271484, 78.015274047851562 ], [ -20.311946868896484, 77.870819091796875 ], [ -19.239997863769531, 77.763046264648438 ], [ -18.958747863769531, 77.629905700683594 ], [ -20.256946563720703, 77.729156494140625 ], [ -20.913887023925781, 77.666091918945312 ], [ -20.246803283691406, 77.558036804199219 ], [ -20.480831146240234, 77.568328857421875 ], [ -20.651525497436523, 77.548179626464844 ], [ -20.403888702392578, 77.507217407226562 ], [ -21.049583435058594, 77.544845581054688 ], [ -20.040557861328125, 77.458038330078125 ], [ -20.772085189819336, 77.4134521484375 ], [ -19.7066650390625, 77.386932373046875 ], [ -19.420833587646484, 77.239974975585938 ], [ -18.395832061767578, 77.342758178710938 ], [ -18.144721984863281, 77.087493896484375 ], [ -18.305278778076172, 76.80609130859375 ], [ -20.723052978515625, 76.988311767578125 ], [ -21.033613204956055, 76.945808410644531 ], [ -20.580417633056641, 76.921783447265625 ], [ -21.727914810180664, 76.88165283203125 ], [ -20.939441680908203, 76.842483520507812 ], [ -21.604999542236328, 76.64471435546875 ], [ -22.240554809570312, 76.857208251953125 ], [ -22.738887786865234, 76.704437255859375 ], [ -22.333749771118164, 76.512214660644531 ], [ -22.184165954589844, 76.63720703125 ], [ -21.814445495605469, 76.59027099609375 ], [ -21.679164886474609, 76.521934509277344 ], [ -22.034168243408203, 76.467689514160156 ], [ -21.675346374511719, 76.484710693359375 ], [ -21.919998168945312, 76.426651000976562 ], [ -22.4022216796875, 76.49859619140625 ], [ -22.504030227661133, 76.446640014648438 ], [ -22.189998626708984, 76.412490844726562 ], [ -21.570972442626953, 76.434005737304688 ], [ -21.682220458984375, 76.239151000976562 ], [ -20.561389923095703, 76.133880615234375 ], [ -20.422222137451172, 76.136245727539062 ], [ -21.085208892822266, 76.295677185058594 ], [ -20.399444580078125, 76.2188720703125 ], [ -19.929443359375, 76.25860595703125 ], [ -19.66722297668457, 76.12969970703125 ], [ -20.360279083251953, 75.981094360351562 ], [ -21.981525421142578, 75.99053955078125 ], [ -19.757225036621094, 75.889434814453125 ], [ -19.33680534362793, 75.402069091796875 ], [ -19.610000610351562, 75.133041381835938 ], [ -22.089443206787109, 75.654983520507812 ], [ -22.283611297607422, 75.657341003417969 ], [ -21.406805038452148, 75.454299926757812 ], [ -22.51055908203125, 75.540817260742188 ], [ -20.52972412109375, 75.163040161132812 ], [ -21.229721069335938, 75.111923217773438 ], [ -21.740413665771484, 74.976509094238281 ], [ -21.928886413574219, 75.078323364257812 ], [ -22.434789657592773, 75.166297912597656 ], [ -21.765556335449219, 74.954986572265625 ], [ -20.629722595214844, 75.057205200195312 ], [ -20.761945724487305, 74.849853515625 ], [ -20.615554809570312, 74.730819702148438 ], [ -21.102500915527344, 74.655258178710938 ], [ -19.392776489257812, 74.684707641601562 ], [ -19.28264045715332, 74.524566650390625 ], [ -18.978193283081055, 74.48345947265625 ], [ -19.68499755859375, 74.23748779296875 ], [ -20.363334655761719, 74.443038940429688 ], [ -21.259166717529297, 74.471649169921875 ], [ -21.661109924316406, 74.44720458984375 ], [ -22.082778930664062, 74.59832763671875 ], [ -21.764169692993164, 74.4224853515625 ], [ -22.479164123535156, 74.309700012207031 ], [ -22.05555534362793, 74.285820007324219 ], [ -22.163055419921875, 74.112762451171875 ], [ -22.491525650024414, 74.076377868652344 ], [ -21.986248016357422, 74.000328063964844 ], [ -21.821666717529297, 73.651092529296875 ], [ -21.706247329711914, 73.695121765136719 ], [ -21.914443969726562, 74.010543823242188 ], [ -21.748607635498047, 74.058319091796875 ], [ -20.279445648193359, 73.876922607421875 ], [ -20.533058166503906, 73.7208251953125 ], [ -20.428333282470703, 73.473876953125 ], [ -21.560832977294922, 73.478042602539062 ], [ -22.379165649414062, 73.25054931640625 ], [ -23.506389617919922, 73.4447021484375 ], [ -24.032222747802734, 73.702484130859375 ], [ -22.694442749023438, 73.54443359375 ], [ -22.185554504394531, 73.623313903808594 ], [ -22.747219085693359, 73.563034057617188 ], [ -24.044166564941406, 73.814697265625 ], [ -24.45263671875, 73.698455810546875 ], [ -24.463054656982422, 73.535812377929688 ], [ -25.688749313354492, 73.952346801757812 ], [ -24.675416946411133, 73.518386840820312 ], [ -25.31500244140625, 73.461654663085938 ], [ -26.012500762939453, 73.242202758789062 ], [ -27.337501525878906, 73.492477416992188 ], [ -27.457916259765625, 73.442062377929688 ], [ -26.389720916748047, 73.248664855957031 ], [ -27.72833251953125, 73.131790161132812 ], [ -27.406387329101562, 73.1099853515625 ], [ -27.49749755859375, 72.924423217773438 ], [ -27.265003204345703, 73.119705200195312 ], [ -26.449165344238281, 73.193588256835938 ], [ -25.051250457763672, 73.080963134765625 ], [ -25.159721374511719, 72.927474975585938 ], [ -26.027225494384766, 72.787200927734375 ], [ -26.716388702392578, 72.87109375 ], [ -27.387777328491211, 72.840682983398438 ], [ -26.305139541625977, 72.725685119628906 ], [ -26.462776184082031, 72.572219848632812 ], [ -25.566665649414062, 72.833053588867188 ], [ -24.842498779296875, 72.719436645507812 ], [ -24.609930038452148, 72.5242919921875 ], [ -25.907499313354492, 72.4154052734375 ], [ -25.288335800170898, 72.383041381835938 ], [ -25.513057708740234, 72.120254516601562 ], [ -25.193611145019531, 72.357757568359375 ], [ -24.588333129882812, 72.421096801757812 ], [ -22.494441986083984, 71.89276123046875 ], [ -23.129306793212891, 71.627891540527344 ], [ -22.429721832275391, 71.79498291015625 ], [ -22.636112213134766, 71.577079772949219 ], [ -21.898054122924805, 71.738311767578125 ], [ -22.503473281860352, 71.551933288574219 ], [ -22.471109390258789, 71.260688781738281 ], [ -21.805557250976562, 71.509429931640625 ], [ -21.672361373901367, 71.402763366699219 ], [ -21.814582824707031, 71.313591003417969 ], [ -21.607776641845703, 71.324432373046875 ], [ -21.961666107177734, 71.263885498046875 ], [ -21.683332443237305, 71.154083251953125 ], [ -22.328193664550781, 71.053802490234375 ], [ -21.679027557373047, 71.066375732421875 ], [ -21.702220916748047, 70.822769165039062 ], [ -21.926666259765625, 70.806022644042969 ], [ -21.639720916748047, 70.795402526855469 ], [ -21.549654006958008, 70.705955505371094 ], [ -21.777225494384766, 70.582351684570312 ], [ -21.475831985473633, 70.541648864746094 ], [ -22.373056411743164, 70.440597534179688 ], [ -22.506946563720703, 70.850540161132812 ], [ -22.622776031494141, 70.446640014648438 ], [ -23.349027633666992, 70.439979553222656 ], [ -24.021945953369141, 70.652206420898438 ], [ -24.192497253417969, 71.013046264648438 ], [ -24.739997863769531, 71.33221435546875 ], [ -25.281669616699219, 71.39166259765625 ] ] ], [ [ [ -39.581947326660156, 83.346939086914062 ], [ -39.173614501953125, 83.393051147460938 ], [ -38.905277252197266, 83.292488098144531 ], [ -39.621940612792969, 83.336929321289062 ], [ -39.581947326660156, 83.346939086914062 ] ] ], [ [ [ -38.948333740234375, 83.113601684570312 ], [ -40.05194091796875, 83.256103515625 ], [ -40.673332214355469, 83.2802734375 ], [ -40.297500610351562, 83.34942626953125 ], [ -38.643474578857422, 83.118171691894531 ], [ -38.948333740234375, 83.113601684570312 ] ] ], [ [ [ -41.25250244140625, 83.285263061523438 ], [ -41.614723205566406, 83.302200317382812 ], [ -41.682777404785156, 83.312202453613281 ], [ -41.456390380859375, 83.32720947265625 ], [ -41.25250244140625, 83.285263061523438 ] ] ], [ [ [ -42.416389465332031, 83.252487182617188 ], [ -42.35028076171875, 83.274993896484375 ], [ -41.959999084472656, 83.253463745117188 ], [ -42.148887634277344, 83.241363525390625 ], [ -42.416389465332031, 83.252487182617188 ] ] ], [ [ [ -41.597496032714844, 83.215545654296875 ], [ -41.424171447753906, 83.242202758789062 ], [ -41.003059387207031, 83.213737487792969 ], [ -41.159439086914062, 83.206649780273438 ], [ -41.597496032714844, 83.215545654296875 ] ] ], [ [ [ -38.569999694824219, 83.139724731445312 ], [ -38.659721374511719, 83.164703369140625 ], [ -38.009170532226562, 83.152481079101562 ], [ -38.318611145019531, 83.13360595703125 ], [ -38.569999694824219, 83.139724731445312 ] ] ], [ [ [ -39.875274658203125, 82.978591918945312 ], [ -40.595550537109375, 83.009429931640625 ], [ -41.482635498046875, 83.162208557128906 ], [ -40.836944580078125, 83.163604736328125 ], [ -39.875274658203125, 82.978591918945312 ] ] ], [ [ [ -39.6138916015625, 82.994430541992188 ], [ -40.363334655761719, 83.083053588867188 ], [ -40.543403625488281, 83.149429321289062 ], [ -39.281665802001953, 83.083740234375 ], [ -39.6138916015625, 82.994430541992188 ] ] ], [ [ [ -87.648895263671875, 76.338043212890625 ], [ -88.432075500488281, 76.400123596191406 ], [ -88.353050231933594, 76.517768859863281 ], [ -88.518890380859375, 76.816085815429688 ], [ -88.692634582519531, 76.7047119140625 ], [ -88.49554443359375, 76.552200317382812 ], [ -88.631942749023438, 76.397216796875 ], [ -88.710006713867188, 76.594985961914062 ], [ -88.947219848632812, 76.405258178710938 ], [ -89.672637939453125, 76.566925048828125 ], [ -89.413612365722656, 76.677345275878906 ], [ -89.524581909179688, 76.848869323730469 ], [ -88.545280456542969, 77.099151611328125 ], [ -86.739990234375, 77.174148559570312 ], [ -87.247077941894531, 77.300819396972656 ], [ -86.841529846191406, 77.355049133300781 ], [ -87.704856872558594, 77.358596801757812 ], [ -87.702781677246094, 77.5394287109375 ], [ -88.220626831054688, 77.663246154785156 ], [ -88.068069458007812, 77.820266723632812 ], [ -86.422225952148438, 77.830825805664062 ], [ -85.981109619140625, 77.708602905273438 ], [ -85.790763854980469, 77.422203063964844 ], [ -84.479446411132812, 77.29443359375 ], [ -84.6138916015625, 77.386100769042969 ], [ -83.467567443847656, 77.349288940429688 ], [ -83.829170227050781, 77.4517822265625 ], [ -83.216110229492188, 77.577774047851562 ], [ -82.325210571289062, 78.07269287109375 ], [ -82.692489624023438, 78.04498291015625 ], [ -83.898345947265625, 77.49053955078125 ], [ -84.769866943359375, 77.521102905273438 ], [ -84.868949890136719, 77.567207336425781 ], [ -84.520004272460938, 77.664703369140625 ], [ -84.433120727539062, 77.725959777832031 ], [ -84.952499389648438, 77.60137939453125 ], [ -85.345626831054688, 77.732406616210938 ], [ -85.053604125976562, 77.830551147460938 ], [ -85.401390075683594, 77.816650390625 ], [ -84.379714965820312, 77.9063720703125 ], [ -85.673538208007812, 77.938591003417969 ], [ -84.296867370605469, 78.076446533203125 ], [ -85.084304809570312, 78.095611572265625 ], [ -84.9949951171875, 78.163040161132812 ], [ -84.127220153808594, 78.175537109375 ], [ -84.970001220703125, 78.210823059082031 ], [ -84.577987670898438, 78.351264953613281 ], [ -84.866386413574219, 78.370674133300781 ], [ -84.625968933105469, 78.589286804199219 ], [ -85.486114501953125, 78.10247802734375 ], [ -86.288124084472656, 78.078804016113281 ], [ -85.83306884765625, 78.379974365234375 ], [ -86.7630615234375, 78.114990234375 ], [ -87.532363891601562, 78.140609741210938 ], [ -87.096870422363281, 78.204147338867188 ], [ -87.497772216796875, 78.219711303710938 ], [ -87.525138854980469, 78.413322448730469 ], [ -86.863296508789062, 78.556022644042969 ], [ -87.120269775390625, 78.579566955566406 ], [ -86.856948852539062, 78.7349853515625 ], [ -85.064163208007812, 78.919143676757812 ], [ -82.308334350585938, 78.568878173828125 ], [ -82.582572937011719, 78.704566955566406 ], [ -82.254730224609375, 78.740814208984375 ], [ -83.252716064453125, 78.833595275878906 ], [ -81.705833435058594, 78.841232299804688 ], [ -81.484024047851562, 79.045745849609375 ], [ -82.503067016601562, 78.88275146484375 ], [ -84.748046875, 79.031936645507812 ], [ -84.503616333007812, 79.144439697265625 ], [ -83.896392822265625, 79.038040161132812 ], [ -83.474716186523438, 79.024154663085938 ], [ -83.371734619140625, 79.047760009765625 ], [ -84.303329467773438, 79.1866455078125 ], [ -85.059585571289062, 79.623863220214844 ], [ -86.479164123535156, 79.761665344238281 ], [ -86.367218017578125, 79.9627685546875 ], [ -85.265907287597656, 79.917274475097656 ], [ -86.474586486816406, 80.006240844726562 ], [ -86.658126831054688, 80.124702453613281 ], [ -86.514724731445312, 80.299148559570312 ], [ -83.781951904296875, 80.245819091796875 ], [ -82.153060913085938, 79.858871459960938 ], [ -81.619857788085938, 79.619903564453125 ], [ -81.72833251953125, 79.589706420898438 ], [ -80.63055419921875, 79.56414794921875 ], [ -79.760978698730469, 79.698738098144531 ], [ -81.4244384765625, 79.7127685546875 ], [ -81.659934997558594, 79.893035888671875 ], [ -81.420272827148438, 79.943588256835938 ], [ -83.197219848632812, 80.314704895019531 ], [ -78.063888549804688, 80.564697265625 ], [ -79.960418701171875, 80.611366271972656 ], [ -76.486320495605469, 80.869285583496094 ], [ -78.935691833496094, 80.878448486328125 ], [ -78.4385986328125, 81.164703369140625 ], [ -76.8558349609375, 81.445526123046875 ], [ -78.8175048828125, 81.106094360351562 ], [ -79.489128112792969, 81.191261291503906 ], [ -79.081642150878906, 81.089103698730469 ], [ -79.609443664550781, 80.821937561035156 ], [ -80.919448852539062, 80.655548095703125 ], [ -83.027496337890625, 80.538589477539062 ], [ -83.169166564941406, 80.570404052734375 ], [ -81.762992858886719, 80.814002990722656 ], [ -83.56597900390625, 80.741508483886719 ], [ -83.129714965820312, 80.822418212890625 ], [ -83.2569580078125, 80.838592529296875 ], [ -83.861526489257812, 80.758323669433594 ], [ -83.724372863769531, 80.641372680664062 ], [ -83.934722900390625, 80.534423828125 ], [ -86.148345947265625, 80.531661987304688 ], [ -86.73895263671875, 80.603317260742188 ], [ -85.6058349609375, 80.975814819335938 ], [ -82.785003662109375, 81.125534057617188 ], [ -82.368331909179688, 81.17706298828125 ], [ -85.681671142578125, 81.049423217773438 ], [ -87.5947265625, 80.628585815429688 ], [ -89.454444885253906, 80.910018920898438 ], [ -86.67193603515625, 81.005264282226562 ], [ -84.737289428710938, 81.284286499023438 ], [ -89.820846557617188, 81.010818481445312 ], [ -90.351943969726562, 81.16748046875 ], [ -88.945968627929688, 81.247062683105469 ], [ -89.948402404785156, 81.327766418457031 ], [ -88.846954345703125, 81.499710083007812 ], [ -87.248062133789062, 81.488876342773438 ], [ -88.352218627929688, 81.5797119140625 ], [ -90.44305419921875, 81.366653442382812 ], [ -90.847183227539062, 81.441574096679688 ], [ -89.592361450195312, 81.621856689453125 ], [ -90.296951293945312, 81.698593139648438 ], [ -91.401397705078125, 81.526382446289062 ], [ -91.44415283203125, 81.583602905273438 ], [ -91.953048706054688, 81.660400390625 ], [ -90.436660766601562, 81.887496948242188 ], [ -89.35638427734375, 81.81109619140625 ], [ -89.203681945800781, 81.883285522460938 ], [ -89.371658325195312, 81.935806274414062 ], [ -88.038330078125, 82.103866577148438 ], [ -86.768341064453125, 81.890274047851562 ], [ -87.128746032714844, 81.966102600097656 ], [ -86.35638427734375, 82.0535888671875 ], [ -85.422500610351562, 81.85748291015625 ], [ -85.730209350585938, 81.986167907714844 ], [ -84.61346435546875, 81.888458251953125 ], [ -86.868461608886719, 82.197479248046875 ], [ -85.6199951171875, 82.24359130859375 ], [ -85.364509582519531, 82.284042358398438 ], [ -85.910758972167969, 82.428939819335938 ], [ -85.046951293945312, 82.48193359375 ], [ -83.516403198242188, 82.316940307617188 ], [ -82.95306396484375, 82.119979858398438 ], [ -83.076400756835938, 82.061920166015625 ], [ -81.885696411132812, 82.036857604980469 ], [ -83.027786254882812, 82.235260009765625 ], [ -82.654449462890625, 82.282211303710938 ], [ -79.236808776855469, 81.816085815429688 ], [ -82.728675842285156, 82.398391723632812 ], [ -81.541946411132812, 82.500541687011719 ], [ -82.391883850097656, 82.616020202636719 ], [ -82.215286254882812, 82.668594360351562 ], [ -80.579872131347656, 82.544570922851562 ], [ -81.579170227050781, 82.79296875 ], [ -81.473052978515625, 82.824996948242188 ], [ -79.861663818359375, 82.644149780273438 ], [ -79.9722900390625, 82.692619323730469 ], [ -79.829727172851562, 82.708877563476562 ], [ -79.384735107421875, 82.672760009765625 ], [ -78.511955261230469, 82.679008483886719 ], [ -80.430000305175781, 82.890823364257812 ], [ -79.90472412109375, 82.951095581054688 ], [ -78.1441650390625, 82.823318481445312 ], [ -77.768341064453125, 82.9224853515625 ], [ -75.894309997558594, 82.590126037597656 ], [ -76.23388671875, 82.444976806640625 ], [ -75.402923583984375, 82.616920471191406 ], [ -77.379096984863281, 82.990127563476562 ], [ -77.183883666992188, 83.03387451171875 ], [ -74.435821533203125, 83.027206420898438 ], [ -72.633895874023438, 82.694427490234375 ], [ -72.500694274902344, 82.72137451171875 ], [ -73.640342712402344, 82.923797607421875 ], [ -71.712783813476562, 83.098876953125 ], [ -71.589317321777344, 83.088180541992188 ], [ -71.789718627929688, 83.010826110839844 ], [ -70.871383666992188, 82.881088256835938 ], [ -71.481277465820312, 83.006866455078125 ], [ -70.260009765625, 83.113876342773438 ], [ -66.3004150390625, 82.930679321289062 ], [ -68.642501831054688, 82.628585815429688 ], [ -65.767776489257812, 82.843048095703125 ], [ -65.162773132324219, 82.765335083007812 ], [ -65.341178894042969, 82.795051574707031 ], [ -65.11090087890625, 82.851234436035156 ], [ -65.258056640625, 82.877471923828125 ], [ -64.729721069335938, 82.904159545898438 ], [ -64.926383972167969, 82.872200012207031 ], [ -63.490837097167969, 82.825271606445312 ], [ -63.389720916748047, 82.764572143554688 ], [ -63.842639923095703, 82.717483520507812 ], [ -62.935413360595703, 82.577354431152344 ], [ -63.368053436279297, 82.441925048828125 ], [ -62.245002746582031, 82.528045654296875 ], [ -62.352920532226562, 82.483734130859375 ], [ -61.076393127441406, 82.320831298828125 ], [ -64.355270385742188, 81.72637939453125 ], [ -68.156661987304688, 81.56109619140625 ], [ -69.297210693359375, 81.714569091796875 ], [ -68.367530822753906, 81.547477722167969 ], [ -68.849235534667969, 81.543869018554688 ], [ -68.579452514648438, 81.514434814453125 ], [ -66.623115539550781, 81.513809204101562 ], [ -70.208198547363281, 81.176788330078125 ], [ -64.443946838378906, 81.48199462890625 ], [ -67.562210083007812, 80.935531616210938 ], [ -69.427490234375, 80.38275146484375 ], [ -70.284439086914062, 80.351089477539062 ], [ -70.314163208007812, 80.464431762695312 ], [ -70.819442749023438, 80.558868408203125 ], [ -70.448333740234375, 80.34027099609375 ], [ -69.962921142578125, 80.254295349121094 ], [ -70.136940002441406, 80.195396423339844 ], [ -72.416671752929688, 80.209159851074219 ], [ -71.899307250976562, 80.110816955566406 ], [ -72.306381225585938, 80.057479858398438 ], [ -70.503822326660156, 80.09381103515625 ], [ -71.456672668457031, 79.902275085449219 ], [ -70.913337707519531, 79.882621765136719 ], [ -71.183883666992188, 79.777481079101562 ], [ -72.267227172851562, 79.659149169921875 ], [ -74.2388916015625, 79.88720703125 ], [ -74.83966064453125, 79.847343444824219 ], [ -73.384735107421875, 79.748870849609375 ], [ -73.130439758300781, 79.560440063476562 ], [ -74.964447021484375, 79.513046264648438 ], [ -74.883750915527344, 79.412208557128906 ], [ -75.058334350585938, 79.373870849609375 ], [ -77.151527404785156, 79.545539855957031 ], [ -75.895347595214844, 79.35345458984375 ], [ -77.359161376953125, 79.455551147460938 ], [ -77.166877746582031, 79.331657409667969 ], [ -78.051315307617188, 79.350814819335938 ], [ -74.4969482421875, 79.224990844726562 ], [ -74.820281982421875, 79.174903869628906 ], [ -74.442840576171875, 79.059074401855469 ], [ -77.777496337890625, 79.208877563476562 ], [ -78.246528625488281, 79.171989440917969 ], [ -76.083480834960938, 79.096519470214844 ], [ -78.885414123535156, 79.061782836914062 ], [ -77.70916748046875, 79.009086608886719 ], [ -78.291389465332031, 78.793731689453125 ], [ -78.248046875, 78.770263671875 ], [ -77.711944580078125, 78.966094970703125 ], [ -76.710556030273438, 79.0283203125 ], [ -75.726249694824219, 78.96734619140625 ], [ -76.449928283691406, 78.856201171875 ], [ -76.4031982421875, 78.839012145996094 ], [ -75.31610107421875, 78.8922119140625 ], [ -74.775009155273438, 78.829986572265625 ], [ -74.723472595214844, 78.704437255859375 ], [ -75.048049926757812, 78.528045654296875 ], [ -76.68634033203125, 78.514533996582031 ], [ -75.057220458984375, 78.312759399414062 ], [ -76.9102783203125, 78.198310852050781 ], [ -75.582366943359375, 78.111442565917969 ], [ -75.922775268554688, 77.956649780273438 ], [ -78.260833740234375, 77.995254516601562 ], [ -78.415382385253906, 77.910118103027344 ], [ -77.72430419921875, 77.603874206542969 ], [ -78.256668090820312, 77.381927490234375 ], [ -80.45611572265625, 77.296096801757812 ], [ -81.927009582519531, 77.683586120605469 ], [ -81.673469543457031, 77.53338623046875 ], [ -81.739990234375, 77.438865661621094 ], [ -81.167221069335938, 77.33380126953125 ], [ -82.15875244140625, 77.298171997070312 ], [ -81.796661376953125, 77.157485961914062 ], [ -81.149169921875, 77.274703979492188 ], [ -80.115409851074219, 77.198455810546875 ], [ -80.373046875, 77.071380615234375 ], [ -79.2550048828125, 77.218597412109375 ], [ -79.004447937011719, 77.100265502929688 ], [ -79.386810302734375, 76.931365966796875 ], [ -78.748336791992188, 76.822494506835938 ], [ -78.320281982421875, 77.01165771484375 ], [ -77.890342712402344, 76.949775695800781 ], [ -77.776947021484375, 76.654296875 ], [ -78.370964050292969, 76.46026611328125 ], [ -78.781944274902344, 76.572212219238281 ], [ -79.312774658203125, 76.2974853515625 ], [ -81.053329467773438, 76.128036499023438 ], [ -80.7781982421875, 76.4215087890625 ], [ -82.049163818359375, 76.511520385742188 ], [ -81.785728454589844, 76.676361083984375 ], [ -82.282913208007812, 76.634437561035156 ], [ -82.725006103515625, 76.81915283203125 ], [ -82.460556030273438, 76.6361083984375 ], [ -82.087501525878906, 76.559150695800781 ], [ -82.219512939453125, 76.526443481445312 ], [ -82.131591796875, 76.445121765136719 ], [ -82.997085571289062, 76.427902221679688 ], [ -83.405418395996094, 76.758880615234375 ], [ -83.519485473632812, 76.705741882324219 ], [ -83.189849853515625, 76.42095947265625 ], [ -84.284439086914062, 76.657760620117188 ], [ -84.203117370605469, 76.452964782714844 ], [ -85.0513916015625, 76.51416015625 ], [ -84.383323669433594, 76.315605163574219 ], [ -85.1744384765625, 76.2802734375 ], [ -86.372222900390625, 76.386383056640625 ], [ -86.218475341796875, 76.52178955078125 ], [ -86.594161987304688, 76.634994506835938 ], [ -86.34222412109375, 76.51220703125 ], [ -86.770553588867188, 76.350814819335938 ], [ -87.572708129882812, 76.612274169921875 ], [ -87.409446716308594, 76.35040283203125 ], [ -87.648895263671875, 76.338043212890625 ] ] ], [ [ [ -78.419448852539062, 82.899154663085938 ], [ -78.361663818359375, 82.958602905273438 ], [ -78.120414733886719, 82.941291809082031 ], [ -78.365829467773438, 82.88360595703125 ], [ -78.419448852539062, 82.899154663085938 ] ] ], [ [ [ -46.799995422363281, 82.839981079101562 ], [ -47.188331604003906, 82.911376953125 ], [ -47.254863739013672, 82.928169250488281 ], [ -46.410831451416016, 82.835823059082031 ], [ -46.799995422363281, 82.839981079101562 ] ] ], [ [ [ -48.303054809570312, 82.786102294921875 ], [ -48.413055419921875, 82.861099243164062 ], [ -47.446388244628906, 82.801788330078125 ], [ -47.6552734375, 82.778045654296875 ], [ -48.303054809570312, 82.786102294921875 ] ] ], [ [ [ -45.040000915527344, 82.0535888671875 ], [ -46.941383361816406, 82.370529174804688 ], [ -47.746112823486328, 82.628036499023438 ], [ -46.157501220703125, 82.659713745117188 ], [ -44.42388916015625, 82.384994506835938 ], [ -45.050277709960938, 82.22442626953125 ], [ -44.737499237060547, 82.09332275390625 ], [ -45.040000915527344, 82.0535888671875 ] ] ], [ [ [ -48.295280456542969, 82.411651611328125 ], [ -48.427780151367188, 82.46832275390625 ], [ -48.863613128662109, 82.541236877441406 ], [ -48.035976409912109, 82.466514587402344 ], [ -48.295280456542969, 82.411651611328125 ] ] ], [ [ [ -51.241363525390625, 81.982513427734375 ], [ -53.066947937011719, 82.094146728515625 ], [ -53.356254577636719, 82.221519470214844 ], [ -52.818336486816406, 82.316665649414062 ], [ -51.241363525390625, 81.982513427734375 ] ] ], [ [ [ -52.191940307617188, 82.21527099609375 ], [ -52.293891906738281, 82.277481079101562 ], [ -51.801872253417969, 82.216033935546875 ], [ -52.007781982421875, 82.207489013671875 ], [ -52.191940307617188, 82.21527099609375 ] ] ], [ [ [ -19.005001068115234, 82.003875732421875 ], [ -19.012500762939453, 82.038314819335938 ], [ -19.412776947021484, 82.20318603515625 ], [ -18.794862747192383, 81.989425659179688 ], [ -19.005001068115234, 82.003875732421875 ] ] ], [ [ [ -20.214443206787109, 81.89276123046875 ], [ -20.724720001220703, 82.054428100585938 ], [ -20.781944274902344, 82.133880615234375 ], [ -20.306667327880859, 82.130538940429688 ], [ -19.74458122253418, 81.875251770019531 ], [ -20.214443206787109, 81.89276123046875 ] ] ], [ [ [ -18.585556030273438, 81.646652221679688 ], [ -19.173053741455078, 81.749420166015625 ], [ -19.243747711181641, 81.780685424804688 ], [ -18.307571411132812, 81.661857604980469 ], [ -18.585556030273438, 81.646652221679688 ] ] ], [ [ [ -20.930553436279297, 81.606369018554688 ], [ -20.767780303955078, 81.678314208984375 ], [ -20.903610229492188, 81.730270385742188 ], [ -20.164722442626953, 81.679290771484375 ], [ -20.930553436279297, 81.606369018554688 ] ] ], [ [ [ -91.761672973632812, 81.54803466796875 ], [ -91.863616943359375, 81.555252075195312 ], [ -91.958335876464844, 81.597900390625 ], [ -91.582229614257812, 81.578048706054688 ], [ -91.761672973632812, 81.54803466796875 ] ] ], [ [ [ -66.644454956054688, 81.56219482421875 ], [ -66.927215576171875, 81.583602905273438 ], [ -66.296661376953125, 81.584716796875 ], [ -66.430557250976562, 81.572219848632812 ], [ -66.644454956054688, 81.56219482421875 ] ] ], [ [ [ -93.866943359375, 80.518325805664062 ], [ -93.786666870117188, 80.528800964355469 ], [ -94.664375305175781, 80.663558959960938 ], [ -94.10833740234375, 80.7188720703125 ], [ -95.5272216796875, 80.819290161132812 ], [ -95.148750305175781, 80.882484436035156 ], [ -95.472007751464844, 80.896133422851562 ], [ -95.183059692382812, 81.01971435546875 ], [ -94.408615112304688, 80.965545654296875 ], [ -93.907218933105469, 81.039985656738281 ], [ -94.31304931640625, 81.11553955078125 ], [ -93.094650268554688, 81.158393859863281 ], [ -94.385696411132812, 81.254432678222656 ], [ -94.240829467773438, 81.350814819335938 ], [ -92.148056030273438, 81.236373901367188 ], [ -90.602493286132812, 80.644744873046875 ], [ -90.741378784179688, 80.56219482421875 ], [ -89.059158325195312, 80.461380004882812 ], [ -89.258544921875, 80.289222717285156 ], [ -88.77667236328125, 80.131362915039062 ], [ -88.154441833496094, 80.093803405761719 ], [ -88.624168395996094, 80.246231079101562 ], [ -88.615280151367188, 80.40386962890625 ], [ -87.675140380859375, 80.407066345214844 ], [ -87.564720153808594, 80.18060302734375 ], [ -88.05596923828125, 80.122474670410156 ], [ -87.0433349609375, 79.964996337890625 ], [ -87.463623046875, 79.831375122070312 ], [ -86.963401794433594, 79.90533447265625 ], [ -87.398612976074219, 79.513465881347656 ], [ -86.33416748046875, 79.645538330078125 ], [ -86.044166564941406, 79.567207336425781 ], [ -86.070846557617188, 79.43414306640625 ], [ -85.68194580078125, 79.613311767578125 ], [ -84.905563354492188, 79.271026611328125 ], [ -86.702224731445312, 78.95526123046875 ], [ -86.986656188964844, 79.052200317382812 ], [ -86.970840454101562, 78.896102905273438 ], [ -87.615829467773438, 78.645263671875 ], [ -88.002372741699219, 78.815681457519531 ], [ -87.729087829589844, 79.073951721191406 ], [ -88.162506103515625, 78.99053955078125 ], [ -88.223678588867188, 78.78790283203125 ], [ -87.908340454101562, 78.548599243164062 ], [ -88.205276489257812, 78.452484130859375 ], [ -88.79638671875, 78.611236572265625 ], [ -88.539718627929688, 78.419563293457031 ], [ -88.817779541015625, 78.154434204101562 ], [ -89.980560302734375, 78.609710693359375 ], [ -90.10028076171875, 78.552482604980469 ], [ -89.985000610351562, 78.43609619140625 ], [ -89.461669921875, 78.168380737304688 ], [ -90.24249267578125, 78.336105346679688 ], [ -90.73992919921875, 78.320953369140625 ], [ -90.270767211914062, 78.18463134765625 ], [ -90.433883666992188, 78.136383056640625 ], [ -92.058334350585938, 78.208877563476562 ], [ -92.972770690917969, 78.485954284667969 ], [ -91.637847900390625, 78.544845581054688 ], [ -93.277778625488281, 78.585823059082031 ], [ -93.808197021484375, 78.768043518066406 ], [ -93.043426513671875, 78.749771118164062 ], [ -94.288055419921875, 78.983734130859375 ], [ -93.294998168945312, 79.16693115234375 ], [ -90.370536804199219, 79.245574951171875 ], [ -92.2388916015625, 79.205551147460938 ], [ -92.685272216796875, 79.255546569824219 ], [ -91.124580383300781, 79.388603210449219 ], [ -93.098892211914062, 79.482208251953125 ], [ -93.012603759765625, 79.392280578613281 ], [ -93.32000732421875, 79.448318481445312 ], [ -93.8699951171875, 79.263885498046875 ], [ -94.376388549804688, 79.420539855957031 ], [ -95.087554931640625, 79.270751953125 ], [ -95.779029846191406, 79.419425964355469 ], [ -95.73638916015625, 79.537490844726562 ], [ -94.699432373046875, 79.612197875976562 ], [ -94.287704467773438, 79.76165771484375 ], [ -95.85333251953125, 79.646102905273438 ], [ -96.611381530761719, 79.881996154785156 ], [ -96.15625, 79.914848327636719 ], [ -96.672843933105469, 80.012771606445312 ], [ -96.396461486816406, 80.04547119140625 ], [ -96.802085876464844, 80.088874816894531 ], [ -94.416946411132812, 79.978866577148438 ], [ -94.748886108398438, 80.079986572265625 ], [ -94.090904235839844, 80.174911499023438 ], [ -95.367767333984375, 80.118316650390625 ], [ -95.686454772949219, 80.179908752441406 ], [ -95.2384033203125, 80.236824035644531 ], [ -96.671524047851562, 80.344566345214844 ], [ -95.438880920410156, 80.339706420898438 ], [ -95.979995727539062, 80.584716796875 ], [ -93.866943359375, 80.518325805664062 ] ] ], [ [ [ -95.065277099609375, 80.6805419921875 ], [ -94.970001220703125, 80.637771606445312 ], [ -96.149169921875, 80.664703369140625 ], [ -95.491378784179688, 80.699996948242188 ], [ -95.065277099609375, 80.6805419921875 ] ] ], [ [ [ -66.878875732421875, 80.637771606445312 ], [ -66.82806396484375, 80.687759399414062 ], [ -66.532501220703125, 80.61859130859375 ], [ -66.76666259765625, 80.60693359375 ], [ -66.878875732421875, 80.637771606445312 ] ] ], [ [ [ -19.085556030273438, 80.15081787109375 ], [ -19.940834045410156, 80.056930541992188 ], [ -20.013334274291992, 80.094703674316406 ], [ -19.724166870117188, 80.244705200195312 ], [ -19.085556030273438, 80.15081787109375 ] ] ], [ [ [ -98.830001831054688, 79.6644287109375 ], [ -100.121109008789062, 79.88665771484375 ], [ -100.193328857421875, 80.03387451171875 ], [ -99.759170532226562, 80.14971923828125 ], [ -98.868881225585938, 80.077774047851562 ], [ -98.6441650390625, 79.797203063964844 ], [ -98.830001831054688, 79.6644287109375 ] ] ], [ [ [ -100.0625, 78.638885498046875 ], [ -99.536872863769531, 78.581031799316406 ], [ -99.862907409667969, 78.439071655273438 ], [ -99.791732788085938, 78.300399780273438 ], [ -98.945831298828125, 78.058731079101562 ], [ -99.024932861328125, 77.891510009765625 ], [ -100.329727172851562, 77.825271606445312 ], [ -101.062767028808594, 78.198593139648438 ], [ -102.133056640625, 78.282760620117188 ], [ -102.618606567382812, 78.241363525390625 ], [ -102.777786254882812, 78.376373291015625 ], [ -104.467498779296875, 78.265274047851562 ], [ -105.04888916015625, 78.49407958984375 ], [ -103.527153015136719, 78.496437072753906 ], [ -103.399986267089844, 78.61553955078125 ], [ -104.039825439453125, 78.62664794921875 ], [ -103.32208251953125, 78.731437683105469 ], [ -104.170547485351562, 78.765823364257812 ], [ -103.825416564941406, 78.895263671875 ], [ -104.20361328125, 78.991653442382812 ], [ -105.011947631835938, 78.8035888671875 ], [ -104.680824279785156, 79.003738403320312 ], [ -105.552909851074219, 79.022346496582031 ], [ -105.624565124511719, 79.167068481445312 ], [ -105.439987182617188, 79.32916259765625 ], [ -103.722503662109375, 79.35693359375 ], [ -102.614372253417969, 79.090476989746094 ], [ -102.720840454101562, 78.938308715820312 ], [ -102.587226867675781, 78.874839782714844 ], [ -101.648902893066406, 79.075820922851562 ], [ -100.985969543457031, 78.934280395507812 ], [ -101.179588317871094, 78.801651000976562 ], [ -99.894935607910156, 78.692893981933594 ], [ -100.0625, 78.638885498046875 ] ] ], [ [ [ -19.314445495605469, 79.231369018554688 ], [ -19.375, 79.126373291015625 ], [ -19.500556945800781, 79.184700012207031 ], [ -19.406387329101562, 79.22747802734375 ], [ -19.314445495605469, 79.231369018554688 ] ] ], [ [ [ -17.721385955810547, 79.219436645507812 ], [ -17.55694580078125, 79.153045654296875 ], [ -18.119998931884766, 78.997756958007812 ], [ -18.085277557373047, 79.096099853515625 ], [ -17.721385955810547, 79.219436645507812 ] ] ], [ [ [ -85.9244384765625, 79.053863525390625 ], [ -85.321395874023438, 79.053863525390625 ], [ -85.1683349609375, 79.017768859863281 ], [ -86.480690002441406, 78.894569396972656 ], [ -85.9244384765625, 79.053863525390625 ] ] ], [ [ [ -19.416110992431641, 78.72442626953125 ], [ -19.52972412109375, 78.730270385742188 ], [ -19.755834579467773, 78.792900085449219 ], [ -19.188610076904297, 78.949844360351562 ], [ -19.3477783203125, 78.813728332519531 ], [ -19.182220458984375, 78.803863525390625 ], [ -19.41874885559082, 78.786239624023438 ], [ -19.161388397216797, 78.768882751464844 ], [ -19.416110992431641, 78.72442626953125 ] ] ], [ [ [ -18.292778015136719, 78.739425659179688 ], [ -18.288055419921875, 78.860260009765625 ], [ -18.075557708740234, 78.817764282226562 ], [ -18.111946105957031, 78.788040161132812 ], [ -18.292778015136719, 78.739425659179688 ] ] ], [ [ [ -96.829452514648438, 77.789154052734375 ], [ -97.763412475585938, 78.028732299804688 ], [ -96.855972290039062, 78.106094360351562 ], [ -98.062156677246094, 78.306228637695312 ], [ -98.410690307617188, 78.495956420898438 ], [ -98.020698547363281, 78.539566040039062 ], [ -98.365409851074219, 78.765830993652344 ], [ -97.07806396484375, 78.749710083007812 ], [ -94.834693908691406, 78.357444763183594 ], [ -95.393684387207031, 78.229217529296875 ], [ -94.888473510742188, 78.105819702148438 ], [ -95.106529235839844, 77.952491760253906 ], [ -96.829452514648438, 77.789154052734375 ] ] ], [ [ [ -74.33416748046875, 78.675262451171875 ], [ -74.614166259765625, 78.702774047851562 ], [ -74.707916259765625, 78.729705810546875 ], [ -74.169235229492188, 78.714706420898438 ], [ -74.33416748046875, 78.675262451171875 ] ] ], [ [ [ -110.0, 78.324455261230469 ], [ -113.142227172851562, 78.268325805664062 ], [ -113.333328247070312, 78.330818176269531 ], [ -110.460281372070312, 78.757492065429688 ], [ -109.257919311523438, 78.483863830566406 ], [ -109.404998779296875, 78.306365966796875 ], [ -110.0, 78.324455261230469 ] ] ], [ [ [ -18.323333740234375, 78.667755126953125 ], [ -18.595554351806641, 78.573883056640625 ], [ -18.735206604003906, 78.606857299804688 ], [ -18.528888702392578, 78.6805419921875 ], [ -18.323333740234375, 78.667755126953125 ] ] ], [ [ [ -88.052780151367188, 78.445526123046875 ], [ -88.2550048828125, 78.247207641601562 ], [ -88.406112670898438, 78.262214660644531 ], [ -88.235275268554688, 78.426925659179688 ], [ -88.052780151367188, 78.445526123046875 ] ] ], [ [ [ -19.21221923828125, 78.410812377929688 ], [ -19.081666946411133, 78.36151123046875 ], [ -19.400138854980469, 78.392906188964844 ], [ -19.32611083984375, 78.420257568359375 ], [ -19.21221923828125, 78.410812377929688 ] ] ], [ [ [ -19.583332061767578, 78.378860473632812 ], [ -19.489997863769531, 78.321792602539062 ], [ -19.710277557373047, 78.298599243164062 ], [ -19.681665420532227, 78.384429931640625 ], [ -19.583332061767578, 78.378860473632812 ] ] ], [ [ [ -19.214443206787109, 78.234710693359375 ], [ -19.351110458374023, 78.280265808105469 ], [ -18.886110305786133, 78.293037414550781 ], [ -18.901943206787109, 78.285263061523438 ], [ -19.214443206787109, 78.234710693359375 ] ] ], [ [ [ -94.5150146484375, 78.278045654296875 ], [ -94.3447265625, 78.214706420898438 ], [ -94.308052062988281, 78.18206787109375 ], [ -94.693183898925781, 78.26165771484375 ], [ -94.5150146484375, 78.278045654296875 ] ] ], [ [ [ -102.897506713867188, 78.269149780273438 ], [ -102.778892517089844, 78.208946228027344 ], [ -103.280975341796875, 78.160682678222656 ], [ -103.062767028808594, 78.258041381835938 ], [ -102.897506713867188, 78.269149780273438 ] ] ], [ [ [ -101.681671142578125, 78.22747802734375 ], [ -101.602500915527344, 78.161788940429688 ], [ -101.88055419921875, 78.160263061523438 ], [ -101.753341674804688, 78.227203369140625 ], [ -101.681671142578125, 78.22747802734375 ] ] ], [ [ [ -20.354999542236328, 78.20166015625 ], [ -20.551666259765625, 78.159423828125 ], [ -20.780834197998047, 78.193588256835938 ], [ -20.30583381652832, 78.21026611328125 ], [ -20.354999542236328, 78.20166015625 ] ] ], [ [ [ -18.868057250976562, 78.159423828125 ], [ -19.061389923095703, 78.073883056640625 ], [ -19.188678741455078, 78.119422912597656 ], [ -18.83125114440918, 78.172760009765625 ], [ -18.868057250976562, 78.159423828125 ] ] ], [ [ [ -110.0, 78.105827331542969 ], [ -109.583198547363281, 78.0384521484375 ], [ -110.899444580078125, 77.8514404296875 ], [ -110.105003356933594, 77.774993896484375 ], [ -110.040557861328125, 77.637496948242188 ], [ -110.877212524414062, 77.411376953125 ], [ -112.413063049316406, 77.356094360351562 ], [ -113.201377868652344, 77.526657104492188 ], [ -113.318611145019531, 77.81011962890625 ], [ -112.294998168945312, 78.010543823242188 ], [ -110.0, 78.105827331542969 ] ] ], [ [ [ -114.193046569824219, 77.698028564453125 ], [ -114.730293273925781, 77.818878173828125 ], [ -115.112701416015625, 77.957489013671875 ], [ -114.303329467773438, 78.070541381835938 ], [ -113.57611083984375, 77.81414794921875 ], [ -114.193046569824219, 77.698028564453125 ] ] ], [ [ [ -21.11944580078125, 77.9991455078125 ], [ -21.310279846191406, 77.885543823242188 ], [ -21.429164886474609, 77.911376953125 ], [ -21.246944427490234, 78.001663208007812 ], [ -21.11944580078125, 77.9991455078125 ] ] ], [ [ [ -19.756946563720703, 77.892486572265625 ], [ -19.229164123535156, 77.8297119140625 ], [ -20.487220764160156, 77.95721435546875 ], [ -19.965000152587891, 77.970260620117188 ], [ -20.069446563720703, 77.959014892578125 ], [ -19.756946563720703, 77.892486572265625 ] ] ], [ [ [ -17.674999237060547, 77.89971923828125 ], [ -17.584861755371094, 77.835128784179688 ], [ -17.732776641845703, 77.708602905273438 ], [ -18.240068435668945, 77.681365966796875 ], [ -17.674999237060547, 77.89971923828125 ] ] ], [ [ [ -101.671943664550781, 77.893325805664062 ], [ -100.926803588867188, 77.738800048828125 ], [ -102.067779541015625, 77.682205200195312 ], [ -102.529716491699219, 77.834152221679688 ], [ -101.671943664550781, 77.893325805664062 ] ] ], [ [ [ -77.676101684570312, 77.864700317382812 ], [ -77.568618774414062, 77.849716186523438 ], [ -77.95361328125, 77.8316650390625 ], [ -77.880279541015625, 77.848037719726562 ], [ -77.676101684570312, 77.864700317382812 ] ] ], [ [ [ -93.174713134765625, 77.70416259765625 ], [ -93.570556640625, 77.437759399414062 ], [ -95.864166259765625, 77.462203979492188 ], [ -96.328887939453125, 77.60498046875 ], [ -95.465286254882812, 77.808029174804688 ], [ -93.174713134765625, 77.70416259765625 ] ] ], [ [ [ -105.648902893066406, 77.74859619140625 ], [ -105.027786254882812, 77.546371459960938 ], [ -105.014167785644531, 77.409980773925781 ], [ -104.36651611328125, 77.227348327636719 ], [ -104.740280151367188, 77.108596801757812 ], [ -105.2469482421875, 77.193862915039062 ], [ -106.091949462890625, 77.726509094238281 ], [ -105.648902893066406, 77.74859619140625 ] ] ], [ [ [ -20.119167327880859, 77.669708251953125 ], [ -20.011112213134766, 77.6064453125 ], [ -20.437221527099609, 77.631790161132812 ], [ -20.168331146240234, 77.685806274414062 ], [ -20.119167327880859, 77.669708251953125 ] ] ], [ [ [ -90.366943359375, 77.19775390625 ], [ -91.14666748046875, 77.362197875976562 ], [ -91.206954956054688, 77.568603515625 ], [ -90.24249267578125, 77.61248779296875 ], [ -89.638206481933594, 77.33624267578125 ], [ -90.366943359375, 77.19775390625 ] ] ], [ [ [ -85.259735107421875, 77.586654663085938 ], [ -85.011123657226562, 77.573883056640625 ], [ -84.813888549804688, 77.497207641601562 ], [ -85.536941528320312, 77.541923522949219 ], [ -85.259735107421875, 77.586654663085938 ] ] ], [ [ [ -19.847221374511719, 77.544143676757812 ], [ -19.860000610351562, 77.502212524414062 ], [ -20.040834426879883, 77.563453674316406 ], [ -19.977497100830078, 77.583053588867188 ], [ -19.847221374511719, 77.544143676757812 ] ] ], [ [ [ -120.049156188964844, 75.838882446289062 ], [ -120.462921142578125, 75.819847106933594 ], [ -120.43499755859375, 76.0030517578125 ], [ -120.857223510742188, 76.196640014648438 ], [ -121.011817932128906, 76.137138366699219 ], [ -120.935699462890625, 75.956375122070312 ], [ -120.990135192871094, 75.940673828125 ], [ -122.139579772949219, 76.033599853515625 ], [ -122.51666259765625, 75.928314208984375 ], [ -122.725692749023438, 75.970954895019531 ], [ -122.473541259765625, 76.108528137207031 ], [ -122.699996948242188, 76.114143371582031 ], [ -122.574172973632812, 76.166091918945312 ], [ -123.03778076171875, 76.084716796875 ], [ -122.57861328125, 76.353591918945312 ], [ -121.54998779296875, 76.434707641601562 ], [ -121.212509155273438, 76.64971923828125 ], [ -120.40167236328125, 76.797210693359375 ], [ -119.153343200683594, 77.325820922851562 ], [ -116.787353515625, 77.318321228027344 ], [ -116.653617858886719, 77.385200500488281 ], [ -117.148750305175781, 77.455268859863281 ], [ -116.487777709960938, 77.550262451171875 ], [ -115.389732360839844, 77.309280395507812 ], [ -116.274864196777344, 77.186927795410156 ], [ -116.24249267578125, 77.044143676757812 ], [ -115.734573364257812, 76.943588256835938 ], [ -116.362846374511719, 76.913528442382812 ], [ -115.894378662109375, 76.698944091796875 ], [ -117.039993286132812, 76.537490844726562 ], [ -116.937210083007812, 76.349151611328125 ], [ -117.095550537109375, 76.295257568359375 ], [ -118.052223205566406, 76.407066345214844 ], [ -117.737701416015625, 76.776725769042969 ], [ -118.328483581542969, 76.770683288574219 ], [ -118.495002746582031, 76.712203979492188 ], [ -118.31610107421875, 76.57470703125 ], [ -118.969924926757812, 76.495956420898438 ], [ -118.64862060546875, 76.428863525390625 ], [ -118.62554931640625, 76.29443359375 ], [ -119.075843811035156, 76.083328247070312 ], [ -119.654998779296875, 76.30303955078125 ], [ -119.568405151367188, 76.171928405761719 ], [ -119.797080993652344, 76.110466003417969 ], [ -119.485137939453125, 75.968185424804688 ], [ -120.049156188964844, 75.838882446289062 ] ] ], [ [ [ -66.260284423828125, 77.486923217773438 ], [ -66.680282592773438, 77.488876342773438 ], [ -66.73138427734375, 77.507217407226562 ], [ -66.19512939453125, 77.505409240722656 ], [ -66.260284423828125, 77.486923217773438 ] ] ], [ [ [ -71.238601684570312, 77.456100463867188 ], [ -70.726943969726562, 77.464706420898438 ], [ -70.056381225585938, 77.399154663085938 ], [ -71.0755615234375, 77.371368408203125 ], [ -71.238601684570312, 77.456100463867188 ] ] ], [ [ [ -72.235549926757812, 77.45416259765625 ], [ -71.375274658203125, 77.390274047851562 ], [ -71.348892211914062, 77.362762451171875 ], [ -72.573616027832031, 77.411376953125 ], [ -72.235549926757812, 77.45416259765625 ] ] ], [ [ [ -91.072235107421875, 77.253326416015625 ], [ -90.81500244140625, 77.240264892578125 ], [ -90.715980529785156, 77.204017639160156 ], [ -91.299163818359375, 77.217758178710938 ], [ -91.072235107421875, 77.253326416015625 ] ] ], [ [ [ -95.372222900390625, 77.238037109375 ], [ -95.210700988769531, 77.175125122070312 ], [ -95.634407043457031, 77.236991882324219 ], [ -95.43804931640625, 77.244430541992188 ], [ -95.372222900390625, 77.238037109375 ] ] ], [ [ [ -104.071403503417969, 77.161376953125 ], [ -103.998893737792969, 77.123870849609375 ], [ -104.431671142578125, 77.098876953125 ], [ -104.300827026367188, 77.155258178710938 ], [ -104.071403503417969, 77.161376953125 ] ] ], [ [ [ -113.778610229492188, 77.104156494140625 ], [ -113.908889770507812, 77.113037109375 ], [ -113.929298400878906, 77.132484436035156 ], [ -113.662635803222656, 77.127479553222656 ], [ -113.778610229492188, 77.104156494140625 ] ] ], [ [ [ -81.810821533203125, 74.456939697265625 ], [ -82.914169311523438, 74.549148559570312 ], [ -83.125968933105469, 74.688453674316406 ], [ -83.088760375976562, 74.820968627929688 ], [ -83.511398315429688, 74.901657104492188 ], [ -83.323196411132812, 74.777076721191406 ], [ -83.479301452636719, 74.577354431152344 ], [ -84.285552978515625, 74.50360107421875 ], [ -84.894447326660156, 74.502769470214844 ], [ -84.9969482421875, 74.69775390625 ], [ -85.214447021484375, 74.491928100585938 ], [ -85.523887634277344, 74.688453674316406 ], [ -85.604171752929688, 74.495819091796875 ], [ -86.121871948242188, 74.484428405761719 ], [ -86.187637329101562, 74.615264892578125 ], [ -86.423324584960938, 74.478866577148438 ], [ -86.776115417480469, 74.616508483886719 ], [ -86.693603515625, 74.468048095703125 ], [ -88.4969482421875, 74.497756958007812 ], [ -88.560821533203125, 74.593048095703125 ], [ -88.347503662109375, 74.784713745117188 ], [ -88.5352783203125, 74.904640197753906 ], [ -88.841949462890625, 74.660263061523438 ], [ -89.089447021484375, 74.835823059082031 ], [ -89.046524047851562, 74.725540161132812 ], [ -89.26806640625, 74.755546569824219 ], [ -89.128471374511719, 74.614151000976562 ], [ -89.489715576171875, 74.5455322265625 ], [ -91.018547058105469, 74.706443786621094 ], [ -90.765007019042969, 74.882904052734375 ], [ -91.224441528320312, 74.730682373046875 ], [ -91.133056640625, 74.624420166015625 ], [ -91.546661376953125, 74.647354125976562 ], [ -92.051521301269531, 74.793174743652344 ], [ -92.224784851074219, 75.0731201171875 ], [ -92.053474426269531, 75.148605346679688 ], [ -92.490829467773438, 75.213607788085938 ], [ -92.388336181640625, 75.441925048828125 ], [ -92.009452819824219, 75.592071533203125 ], [ -92.174995422363281, 75.747489929199219 ], [ -92.107772827148438, 75.852828979492188 ], [ -93.077781677246094, 76.355674743652344 ], [ -95.381523132324219, 76.235115051269531 ], [ -94.8065185546875, 76.319427490234375 ], [ -96.100212097167969, 76.5025634765625 ], [ -95.778610229492188, 76.518875122070312 ], [ -95.591316223144531, 76.600051879882812 ], [ -96.954231262207031, 76.7274169921875 ], [ -96.308746337890625, 76.752632141113281 ], [ -96.815170288085938, 76.969322204589844 ], [ -95.743614196777344, 77.068603515625 ], [ -93.747085571289062, 76.921653747558594 ], [ -93.199302673339844, 76.746124267578125 ], [ -93.303466796875, 76.549423217773438 ], [ -93.649101257324219, 76.440536499023438 ], [ -93.54833984375, 76.3861083984375 ], [ -93.04638671875, 76.6160888671875 ], [ -90.986114501953125, 76.649154663085938 ], [ -90.472152709960938, 76.474845886230469 ], [ -91.565414428710938, 76.499847412109375 ], [ -89.1981201171875, 76.231163024902344 ], [ -90.444747924804688, 76.170951843261719 ], [ -90.110824584960938, 76.1241455078125 ], [ -91.601951599121094, 76.262077331542969 ], [ -90.195343017578125, 76.057342529296875 ], [ -91.151390075683594, 76.018600463867188 ], [ -90.946563720703125, 75.955154418945312 ], [ -91.13311767578125, 75.844917297363281 ], [ -90.785690307617188, 75.995399475097656 ], [ -90.500839233398438, 75.896514892578125 ], [ -89.927078247070312, 76.003463745117188 ], [ -89.691802978515625, 75.893669128417969 ], [ -89.773200988769531, 75.789703369140625 ], [ -89.167495727539062, 75.775962829589844 ], [ -89.261390686035156, 75.629425048828125 ], [ -89.764175415039062, 75.576515197753906 ], [ -89.226524353027344, 75.585823059082031 ], [ -88.92138671875, 75.427200317382812 ], [ -88.774307250976562, 75.43359375 ], [ -88.865829467773438, 75.586105346679688 ], [ -88.7308349609375, 75.679290771484375 ], [ -88.2288818359375, 75.471099853515625 ], [ -87.75140380859375, 75.57666015625 ], [ -87.541114807128906, 75.445259094238281 ], [ -87.263336181640625, 75.62109375 ], [ -86.371383666992188, 75.424140930175781 ], [ -86.544723510742188, 75.359146118164062 ], [ -83.878150939941406, 75.818962097167969 ], [ -81.4505615234375, 75.800811767578125 ], [ -81.212509155273438, 75.771377563476562 ], [ -81.2640380859375, 75.650550842285156 ], [ -79.952987670898438, 75.536376953125 ], [ -80.356170654296875, 75.463699340820312 ], [ -79.582366943359375, 75.451446533203125 ], [ -79.5069580078125, 75.22998046875 ], [ -80.43402099609375, 75.034011840820312 ], [ -79.341178894042969, 74.900192260742188 ], [ -79.930557250976562, 74.813308715820312 ], [ -80.328475952148438, 74.935401916503906 ], [ -80.103195190429688, 74.822349548339844 ], [ -80.239860534667969, 74.577072143554688 ], [ -81.810821533203125, 74.456939697265625 ] ] ], [ [ [ -97.243057250976562, 77.037490844726562 ], [ -97.092643737792969, 77.007904052734375 ], [ -97.473052978515625, 76.980545043945312 ], [ -97.374710083007812, 77.022491455078125 ], [ -97.243057250976562, 77.037490844726562 ] ] ], [ [ [ -114.054718017578125, 76.703598022460938 ], [ -114.786941528320312, 76.750274658203125 ], [ -114.874984741210938, 76.767005920410156 ], [ -113.88555908203125, 76.89166259765625 ], [ -113.451522827148438, 76.774986267089844 ], [ -114.054718017578125, 76.703598022460938 ] ] ], [ [ [ -110.0, 76.466217041015625 ], [ -109.302780151367188, 76.79693603515625 ], [ -108.748046875, 76.855819702148438 ], [ -108.442138671875, 76.711441040039062 ], [ -108.71978759765625, 76.640266418457031 ], [ -108.558036804199219, 76.408599853515625 ], [ -108.077499389648438, 76.280548095703125 ], [ -108.3961181640625, 76.046096801757812 ], [ -107.638687133789062, 75.988029479980469 ], [ -108.022224426269531, 75.7823486328125 ], [ -107.186660766601562, 75.90386962890625 ], [ -106.89666748046875, 75.720260620117188 ], [ -106.622772216796875, 75.801162719726562 ], [ -106.892372131347656, 75.839576721191406 ], [ -106.869720458984375, 75.964157104492188 ], [ -106.336669921875, 76.054702758789062 ], [ -105.610137939453125, 75.935813903808594 ], [ -105.390144348144531, 75.647628784179688 ], [ -105.744300842285156, 75.488311767578125 ], [ -105.602287292480469, 75.4683837890625 ], [ -105.651107788085938, 75.359916687011719 ], [ -106.000770568847656, 75.059219360351562 ], [ -107.206527709960938, 74.911369323730469 ], [ -107.7781982421875, 75.0948486328125 ], [ -107.9486083984375, 74.929702758789062 ], [ -108.382362365722656, 74.910957336425781 ], [ -108.832496643066406, 75.069992065429688 ], [ -112.753067016601562, 74.401382446289062 ], [ -113.696380615234375, 74.446090698242188 ], [ -114.441864013671875, 74.664421081542969 ], [ -112.911117553710938, 74.9708251953125 ], [ -111.5433349609375, 75.013191223144531 ], [ -110.916107177734375, 75.231437683105469 ], [ -112.390556335449219, 75.123031616210938 ], [ -112.295280456542969, 75.200401306152344 ], [ -112.672500610351562, 75.278182983398438 ], [ -112.806953430175781, 75.115814208984375 ], [ -113.917503356933594, 75.0535888671875 ], [ -113.813194274902344, 75.320541381835938 ], [ -113.340560913085938, 75.413314819335938 ], [ -114.081245422363281, 75.462974548339844 ], [ -114.178749084472656, 75.225120544433594 ], [ -114.506393432617188, 75.313446044921875 ], [ -114.608680725097656, 75.270477294921875 ], [ -114.298118591308594, 75.175468444824219 ], [ -114.394996643066406, 75.090545654296875 ], [ -115.058464050292969, 74.961380004882812 ], [ -115.226249694824219, 75.171089172363281 ], [ -115.623893737792969, 75.121368408203125 ], [ -115.548469543457031, 75.012489318847656 ], [ -115.681243896484375, 74.964431762695312 ], [ -116.163063049316406, 75.040267944335938 ], [ -116.277778625488281, 75.205825805664062 ], [ -116.717216491699219, 75.116653442382812 ], [ -117.677223205566406, 75.246307373046875 ], [ -117.240547180175781, 75.473602294921875 ], [ -116.021942138671875, 75.4849853515625 ], [ -115.000770568847656, 75.694076538085938 ], [ -117.248046875, 75.591796875 ], [ -116.859718322753906, 75.791793823242188 ], [ -114.838607788085938, 75.874420166015625 ], [ -116.73388671875, 75.925537109375 ], [ -116.471519470214844, 75.974151611328125 ], [ -116.641387939453125, 76.113311767578125 ], [ -116.296112060546875, 76.188583374023438 ], [ -114.676979064941406, 76.158737182617188 ], [ -115.919021606445312, 76.279571533203125 ], [ -114.909584045410156, 76.51568603515625 ], [ -114.141807556152344, 76.448875427246094 ], [ -113.989990234375, 76.191505432128906 ], [ -112.458335876464844, 76.177345275878906 ], [ -112.418052673339844, 76.044845581054688 ], [ -111.729995727539062, 75.913383483886719 ], [ -112.219520568847656, 75.809211730957031 ], [ -111.448471069335938, 75.834434509277344 ], [ -111.247222900390625, 75.518051147460938 ], [ -108.89666748046875, 75.477554321289062 ], [ -108.834861755371094, 75.689002990722656 ], [ -110.051872253417969, 75.893531799316406 ], [ -109.308250427246094, 76.104080200195312 ], [ -110.378196716308594, 76.296096801757812 ], [ -110.384590148925781, 76.425254821777344 ], [ -110.0, 76.466217041015625 ] ] ], [ [ [ -19.673332214355469, 76.847213745117188 ], [ -19.590000152587891, 76.8116455078125 ], [ -19.807777404785156, 76.791511535644531 ], [ -19.741943359375, 76.848037719726562 ], [ -19.673332214355469, 76.847213745117188 ] ] ], [ [ [ -89.9788818359375, 76.469711303710938 ], [ -90.214447021484375, 76.528594970703125 ], [ -90.599090576171875, 76.746932983398438 ], [ -89.67388916015625, 76.734428405761719 ], [ -89.862640380859375, 76.600677490234375 ], [ -89.672637939453125, 76.503189086914062 ], [ -89.9788818359375, 76.469711303710938 ] ] ], [ [ [ -18.648609161376953, 76.163604736328125 ], [ -18.54888916015625, 76.023605346679688 ], [ -18.635276794433594, 75.889984130859375 ], [ -19.141944885253906, 76.529434204101562 ], [ -18.763057708740234, 76.5877685546875 ], [ -19.069446563720703, 76.741363525390625 ], [ -18.659442901611328, 76.630813598632812 ], [ -18.648609161376953, 76.163604736328125 ] ] ], [ [ [ -19.700275421142578, 76.752487182617188 ], [ -19.606388092041016, 76.718803405761719 ], [ -19.855972290039062, 76.734848022460938 ], [ -19.826389312744141, 76.755828857421875 ], [ -19.700275421142578, 76.752487182617188 ] ] ], [ [ [ -100.297233581542969, 76.721923828125 ], [ -101.273902893066406, 76.560806274414062 ], [ -101.688316345214844, 76.586380004882812 ], [ -100.743881225585938, 76.753326416015625 ], [ -100.297233581542969, 76.721923828125 ] ] ], [ [ [ -99.528884887695312, 76.725540161132812 ], [ -99.432220458984375, 76.697059631347656 ], [ -100.126518249511719, 76.721923828125 ], [ -100.03778076171875, 76.751388549804688 ], [ -99.528884887695312, 76.725540161132812 ] ] ], [ [ [ -99.680831909179688, 76.11859130859375 ], [ -99.423812866210938, 76.156578063964844 ], [ -100.438888549804688, 76.212493896484375 ], [ -99.846672058105469, 76.282073974609375 ], [ -100.981040954589844, 76.495956420898438 ], [ -99.684432983398438, 76.633331298828125 ], [ -99.099990844726562, 76.398040771484375 ], [ -98.851943969726562, 76.433731079101562 ], [ -99.0272216796875, 76.601089477539062 ], [ -98.489028930664062, 76.647758483886719 ], [ -98.854301452636719, 76.666854858398438 ], [ -98.712509155273438, 76.68304443359375 ], [ -98.439987182617188, 76.67303466796875 ], [ -98.185134887695312, 76.583602905273438 ], [ -98.357772827148438, 76.565536499023438 ], [ -97.757369995117188, 76.508743286132812 ], [ -97.727493286132812, 76.280540466308594 ], [ -97.494720458984375, 76.143882751464844 ], [ -97.5977783203125, 75.846939086914062 ], [ -97.934577941894531, 75.744148254394531 ], [ -97.395561218261719, 75.685394287109375 ], [ -97.288261413574219, 75.398880004882812 ], [ -97.720413208007812, 75.568466186523438 ], [ -98.042503356933594, 75.482345581054688 ], [ -97.77874755859375, 75.425674438476562 ], [ -98.124855041503906, 75.299842834472656 ], [ -97.5740966796875, 75.149085998535156 ], [ -98.091949462890625, 75.222763061523438 ], [ -97.982498168945312, 75.015274047851562 ], [ -99.400138854980469, 74.990676879882812 ], [ -99.30804443359375, 75.122482299804688 ], [ -99.538604736328125, 74.974151611328125 ], [ -100.057220458984375, 74.986923217773438 ], [ -100.539581298828125, 75.19622802734375 ], [ -100.00177001953125, 75.23272705078125 ], [ -100.76971435546875, 75.349632263183594 ], [ -99.674781799316406, 75.609291076660156 ], [ -99.820564270019531, 75.653457641601562 ], [ -98.898124694824219, 75.693580627441406 ], [ -99.740829467773438, 75.690811157226562 ], [ -102.534156799316406, 75.511383056640625 ], [ -102.874267578125, 75.612892150878906 ], [ -102.008613586425781, 75.704017639160156 ], [ -102.367835998535156, 75.797859191894531 ], [ -102.163063049316406, 75.878860473632812 ], [ -101.86444091796875, 75.902206420898438 ], [ -101.4385986328125, 75.75555419921875 ], [ -101.182220458984375, 75.779708862304688 ], [ -101.579177856445312, 75.908599853515625 ], [ -101.325691223144531, 76.019989013671875 ], [ -101.905975341796875, 76.081443786621094 ], [ -101.391258239746094, 76.246856689453125 ], [ -102.16278076171875, 76.240676879882812 ], [ -101.862213134765625, 76.450271606445312 ], [ -101.315826416015625, 76.4144287109375 ], [ -99.982498168945312, 75.890548706054688 ], [ -99.448509216308594, 75.968132019042969 ], [ -99.861381530761719, 75.935394287109375 ], [ -100.152786254882812, 76.132476806640625 ], [ -99.680831909179688, 76.11859130859375 ] ] ], [ [ [ -104.134170532226562, 76.66943359375 ], [ -103.924720764160156, 76.635826110839844 ], [ -104.033889770507812, 76.559707641601562 ], [ -103.004463195800781, 76.4326171875 ], [ -104.335006713867188, 76.318603515625 ], [ -104.662361145019531, 76.548736572265625 ], [ -104.134170532226562, 76.66943359375 ] ] ], [ [ [ -21.174167633056641, 76.5555419921875 ], [ -21.430278778076172, 76.5716552734375 ], [ -21.547361373901367, 76.612068176269531 ], [ -20.964719772338867, 76.626228332519531 ], [ -21.174167633056641, 76.5555419921875 ] ] ], [ [ [ -69.62249755859375, 76.606643676757812 ], [ -69.465690612792969, 76.575965881347656 ], [ -70.035835266113281, 76.567481994628906 ], [ -69.947219848632812, 76.589706420898438 ], [ -69.62249755859375, 76.606643676757812 ] ] ], [ [ [ -20.722774505615234, 76.51416015625 ], [ -20.745277404785156, 76.394989013671875 ], [ -21.137777328491211, 76.444564819335938 ], [ -20.835556030273438, 76.524703979492188 ], [ -20.722774505615234, 76.51416015625 ] ] ], [ [ [ -84.097503662109375, 76.50665283203125 ], [ -83.99249267578125, 76.494979858398438 ], [ -83.908050537109375, 76.464996337890625 ], [ -84.10943603515625, 76.444427490234375 ], [ -84.097503662109375, 76.50665283203125 ] ] ], [ [ [ -69.984161376953125, 76.459152221679688 ], [ -69.895286560058594, 76.435813903808594 ], [ -70.18707275390625, 76.437202453613281 ], [ -70.164169311523438, 76.448318481445312 ], [ -69.984161376953125, 76.459152221679688 ] ] ], [ [ [ -20.177223205566406, 76.416656494140625 ], [ -20.103195190429688, 76.395271301269531 ], [ -20.586387634277344, 76.378585815429688 ], [ -20.202499389648438, 76.44970703125 ], [ -20.177223205566406, 76.416656494140625 ] ] ], [ [ [ -20.959720611572266, 76.37109375 ], [ -20.509166717529297, 76.288589477539062 ], [ -20.430416107177734, 76.250396728515625 ], [ -21.054166793823242, 76.363868713378906 ], [ -20.959720611572266, 76.37109375 ] ] ], [ [ [ -20.182498931884766, 76.33831787109375 ], [ -20.376110076904297, 76.2591552734375 ], [ -20.660831451416016, 76.338882446289062 ], [ -20.456386566162109, 76.367202758789062 ], [ -20.182498931884766, 76.33831787109375 ] ] ], [ [ [ -102.6522216796875, 76.287765502929688 ], [ -102.530204772949219, 76.215888977050781 ], [ -102.650558471679688, 76.119979858398438 ], [ -103.342216491699219, 76.036651611328125 ], [ -104.480552673339844, 76.139015197753906 ], [ -102.6522216796875, 76.287765502929688 ] ] ], [ [ [ -94.854446411132812, 76.13665771484375 ], [ -94.928604125976562, 76.05108642578125 ], [ -95.1441650390625, 76.113937377929688 ], [ -95.0130615234375, 76.105819702148438 ], [ -94.854446411132812, 76.13665771484375 ] ] ], [ [ [ -78.89306640625, 76.11553955078125 ], [ -79.176666259765625, 75.949569702148438 ], [ -78.897781372070312, 75.839706420898438 ], [ -79.752227783203125, 75.878585815429688 ], [ -78.89306640625, 76.11553955078125 ] ] ], [ [ [ -117.623046875, 76.114425659179688 ], [ -117.467643737792969, 76.085968017578125 ], [ -118.354721069335938, 75.558868408203125 ], [ -119.406944274902344, 75.603179931640625 ], [ -117.623046875, 76.114425659179688 ] ] ], [ [ [ -102.35333251953125, 76.073883056640625 ], [ -103.339447021484375, 75.908035278320312 ], [ -103.968185424804688, 75.936363220214844 ], [ -102.860061645507812, 76.067283630371094 ], [ -102.35333251953125, 76.073883056640625 ] ] ], [ [ [ -65.03167724609375, 76.078048706054688 ], [ -64.956260681152344, 76.051925659179688 ], [ -65.221115112304688, 76.0455322265625 ], [ -65.0755615234375, 76.083877563476562 ], [ -65.03167724609375, 76.078048706054688 ] ] ], [ [ [ -19.968608856201172, 75.974700927734375 ], [ -20.356109619140625, 75.938873291015625 ], [ -20.369304656982422, 75.946578979492188 ], [ -20.1058349609375, 75.99609375 ], [ -19.968608856201172, 75.974700927734375 ] ] ], [ [ [ -101.988601684570312, 75.934417724609375 ], [ -102.611656188964844, 75.7672119140625 ], [ -103.381797790527344, 75.762489318847656 ], [ -102.696113586425781, 75.946640014648438 ], [ -101.988601684570312, 75.934417724609375 ] ] ], [ [ [ -94.481948852539062, 75.97442626953125 ], [ -94.294166564941406, 75.769302368164062 ], [ -94.73944091796875, 75.757492065429688 ], [ -94.905281066894531, 75.933868408203125 ], [ -94.481948852539062, 75.97442626953125 ] ] ], [ [ [ -120.867767333984375, 75.913314819335938 ], [ -121.032783508300781, 75.737762451171875 ], [ -121.287078857421875, 75.755828857421875 ], [ -120.997772216796875, 75.926376342773438 ], [ -120.867767333984375, 75.913314819335938 ] ] ], [ [ [ -122.633331298828125, 75.919708251953125 ], [ -122.353057861328125, 75.9144287109375 ], [ -122.326255798339844, 75.90277099609375 ], [ -122.694084167480469, 75.904632568359375 ], [ -122.633331298828125, 75.919708251953125 ] ] ], [ [ [ -103.331947326660156, 75.871917724609375 ], [ -103.616653442382812, 75.831100463867188 ], [ -103.862632751464844, 75.873931884765625 ], [ -103.42694091796875, 75.885543823242188 ], [ -103.331947326660156, 75.871917724609375 ] ] ], [ [ [ -96.455841064453125, 75.817764282226562 ], [ -96.553604125976562, 75.73858642578125 ], [ -96.713890075683594, 75.736648559570312 ], [ -96.663887023925781, 75.788040161132812 ], [ -96.455841064453125, 75.817764282226562 ] ] ], [ [ [ -96.025436401367188, 75.60284423828125 ], [ -95.910560607910156, 75.557205200195312 ], [ -96.22027587890625, 75.455551147460938 ], [ -96.4464111328125, 75.554405212402344 ], [ -96.851104736328125, 75.350265502929688 ], [ -97.053054809570312, 75.494705200195312 ], [ -96.025436401367188, 75.60284423828125 ] ] ], [ [ [ -93.406387329101562, 74.88360595703125 ], [ -93.563323974609375, 74.659423828125 ], [ -94.643341064453125, 74.62359619140625 ], [ -95.864166259765625, 74.826095581054688 ], [ -96.078620910644531, 75.024017333984375 ], [ -96.268341064453125, 74.90386962890625 ], [ -96.615554809570312, 74.988037109375 ], [ -96.459724426269531, 75.195121765136719 ], [ -95.834564208984375, 75.373001098632812 ], [ -96.142372131347656, 75.403594970703125 ], [ -94.909721374511719, 75.637351989746094 ], [ -93.494789123535156, 75.258316040039062 ], [ -93.406387329101562, 74.88360595703125 ] ] ], [ [ [ -100.479721069335938, 75.545822143554688 ], [ -100.293609619140625, 75.584426879882812 ], [ -101.036384582519531, 75.56512451171875 ], [ -100.394447326660156, 75.623031616210938 ], [ -100.157501220703125, 75.587211608886719 ], [ -100.479721069335938, 75.545822143554688 ] ] ], [ [ [ -104.151779174804688, 75.434555053710938 ], [ -103.586944580078125, 75.166023254394531 ], [ -104.229171752929688, 75.018051147460938 ], [ -104.84722900390625, 75.109146118164062 ], [ -104.677909851074219, 75.339714050292969 ], [ -104.151779174804688, 75.434555053710938 ] ] ], [ [ [ -17.97027587890625, 75.4002685546875 ], [ -17.80583381652832, 75.308311462402344 ], [ -18.214719772338867, 75.227203369140625 ], [ -17.320138931274414, 75.134010314941406 ], [ -17.620834350585938, 74.93109130859375 ], [ -18.92388916015625, 75.04193115234375 ], [ -18.839168548583984, 75.328323364257812 ], [ -17.97027587890625, 75.4002685546875 ] ] ], [ [ [ -20.230831146240234, 75.041656494140625 ], [ -19.962221145629883, 74.9951171875 ], [ -20.183609008789062, 74.903045654296875 ], [ -19.731246948242188, 74.85595703125 ], [ -20.084445953369141, 74.702774047851562 ], [ -20.685207366943359, 74.810325622558594 ], [ -20.57611083984375, 75.002487182617188 ], [ -20.230831146240234, 75.041656494140625 ] ] ], [ [ [ -18.3397216796875, 74.698867797851562 ], [ -18.473052978515625, 74.62359619140625 ], [ -18.59111213684082, 74.7188720703125 ], [ -18.304445266723633, 74.706443786621094 ], [ -18.3397216796875, 74.698867797851562 ] ] ], [ [ [ -18.73944091796875, 74.608871459960938 ], [ -18.860000610351562, 74.537200927734375 ], [ -19.218887329101562, 74.584152221679688 ], [ -18.866664886474609, 74.67498779296875 ], [ -18.73944091796875, 74.608871459960938 ] ] ], [ [ [ -95.62860107421875, 74.640823364257812 ], [ -95.403610229492188, 74.603317260742188 ], [ -95.248748779296875, 74.518875122070312 ], [ -95.861663818359375, 74.575965881347656 ], [ -95.62860107421875, 74.640823364257812 ] ] ], [ [ [ -97.368057250976562, 74.622756958007812 ], [ -97.259452819824219, 74.587211608886719 ], [ -97.790969848632812, 74.482894897460938 ], [ -97.5322265625, 74.606369018554688 ], [ -97.368057250976562, 74.622756958007812 ] ] ], [ [ [ -56.960556030273438, 74.60748291015625 ], [ -56.841522216796875, 74.588462829589844 ], [ -57.095134735107422, 74.55859375 ], [ -57.070556640625, 74.57916259765625 ], [ -56.960556030273438, 74.60748291015625 ] ] ], [ [ [ -57.346389770507812, 74.512771606445312 ], [ -56.730278015136719, 74.559417724609375 ], [ -56.464584350585938, 74.502494812011719 ], [ -57.554859161376953, 74.490676879882812 ], [ -57.346389770507812, 74.512771606445312 ] ] ], [ [ [ -123.833892822265625, 73.700271606445312 ], [ -124.777847290039062, 74.331375122070312 ], [ -121.518623352050781, 74.548873901367188 ], [ -119.609161376953125, 74.233322143554688 ], [ -119.773612976074219, 74.032073974609375 ], [ -119.497291564941406, 74.214500427246094 ], [ -119.143203735351562, 74.210403442382812 ], [ -119.167503356933594, 73.987197875976562 ], [ -118.67388916015625, 74.219985961914062 ], [ -117.51251220703125, 74.23858642578125 ], [ -115.31903076171875, 73.477066040039062 ], [ -119.13751220703125, 72.632476806640625 ], [ -119.404449462890625, 72.325546264648438 ], [ -120.246101379394531, 72.260551452636719 ], [ -120.145133972167969, 72.146797180175781 ], [ -120.44659423828125, 71.948249816894531 ], [ -120.378807067871094, 71.690948486328125 ], [ -120.543327331542969, 71.51666259765625 ], [ -121.70361328125, 71.4608154296875 ], [ -122.796112060546875, 71.084152221679688 ], [ -123.293060302734375, 71.146102905273438 ], [ -124.018623352050781, 71.687477111816406 ], [ -125.2454833984375, 71.948020935058594 ], [ -124.987777709960938, 71.969711303710938 ], [ -125.761398315429688, 71.950820922851562 ], [ -125.935821533203125, 71.958602905273438 ], [ -125.981765747070312, 71.97216796875 ], [ -125.028060913085938, 72.566070556640625 ], [ -125.026107788085938, 72.821090698242188 ], [ -124.48291015625, 72.925811767578125 ], [ -124.862876892089844, 73.078460693359375 ], [ -123.833892822265625, 73.700271606445312 ] ] ], [ [ [ -20.958286285400391, 74.442840576171875 ], [ -20.125068664550781, 74.201995849609375 ], [ -21.209999084472656, 74.086105346679688 ], [ -21.989721298217773, 74.22442626953125 ], [ -20.958286285400391, 74.442840576171875 ] ] ], [ [ [ -98.573623657226562, 74.334991455078125 ], [ -98.513343811035156, 74.316238403320312 ], [ -98.859786987304688, 74.307685852050781 ], [ -98.75250244140625, 74.334152221679688 ], [ -98.573623657226562, 74.334991455078125 ] ] ], [ [ [ -95.613616943359375, 73.342758178710938 ], [ -95.652366638183594, 73.7340087890625 ], [ -94.618606567382812, 73.652908325195312 ], [ -95.328758239746094, 73.914566040039062 ], [ -94.747154235839844, 74.090469360351562 ], [ -93.327499389648438, 74.16998291015625 ], [ -92.316970825195312, 73.945465087890625 ], [ -90.19757080078125, 73.897972106933594 ], [ -92.095840454101562, 72.7430419921875 ], [ -94.306800842285156, 72.766654968261719 ], [ -93.79833984375, 72.70220947265625 ], [ -93.465553283691406, 72.453872680664062 ], [ -94.192131042480469, 72.038566589355469 ], [ -94.072639465332031, 71.977203369140625 ], [ -94.449722290039062, 72.0233154296875 ], [ -95.210556030273438, 71.991653442382812 ], [ -95.203605651855469, 72.101097106933594 ], [ -94.75653076171875, 72.154151916503906 ], [ -95.165000915527344, 72.137489318847656 ], [ -95.133331298828125, 72.46026611328125 ], [ -95.596389770507812, 72.698867797851562 ], [ -95.613616943359375, 73.342758178710938 ] ] ], [ [ [ -97.653610229492188, 74.099990844726562 ], [ -98.392776489257812, 73.845260620117188 ], [ -99.436943054199219, 73.899574279785156 ], [ -98.17083740234375, 74.092483520507812 ], [ -97.653610229492188, 74.099990844726562 ] ] ], [ [ [ -90.007781982421875, 73.9849853515625 ], [ -90.2177734375, 74.004440307617188 ], [ -90.283958435058594, 74.026512145996094 ], [ -89.902915954589844, 74.034568786621094 ], [ -90.007781982421875, 73.9849853515625 ] ] ], [ [ [ -100.444442749023438, 73.4063720703125 ], [ -100.550827026367188, 73.596794128417969 ], [ -101.119163513183594, 73.725257873535156 ], [ -100.554168701171875, 73.854705810546875 ], [ -100.06304931640625, 73.764999389648438 ], [ -99.875564575195312, 73.871284484863281 ], [ -100.297157287597656, 73.864631652832031 ], [ -99.981109619140625, 73.945816040039062 ], [ -99.235000610351562, 73.737762451171875 ], [ -97.223617553710938, 73.856369018554688 ], [ -96.966255187988281, 73.63665771484375 ], [ -97.666801452636719, 73.479705810546875 ], [ -97.190139770507812, 73.467353820800781 ], [ -97.173675537109375, 73.354148864746094 ], [ -97.842918395996094, 73.270820617675781 ], [ -98.450286865234375, 73.020263671875 ], [ -98.448196411132812, 72.870399475097656 ], [ -97.987777709960938, 73.038597106933594 ], [ -97.442489624023438, 72.9991455078125 ], [ -97.026527404785156, 72.729354858398438 ], [ -97.197494506835938, 72.607208251953125 ], [ -96.6119384765625, 72.746932983398438 ], [ -96.300064086914062, 72.426300048828125 ], [ -96.868255615234375, 72.3206787109375 ], [ -96.557640075683594, 72.26971435546875 ], [ -96.503341674804688, 72.087631225585938 ], [ -96.86041259765625, 72.038734436035156 ], [ -96.489295959472656, 72.026657104492188 ], [ -96.759376525878906, 71.911582946777344 ], [ -96.494926452636719, 71.922828674316406 ], [ -96.585838317871094, 71.812896728515625 ], [ -98.121940612792969, 71.637489318847656 ], [ -98.356040954589844, 71.725814819335938 ], [ -98.287078857421875, 71.896934509277344 ], [ -98.495689392089844, 71.717765808105469 ], [ -98.039443969726562, 71.528739929199219 ], [ -98.72528076171875, 71.270263671875 ], [ -99.229446411132812, 71.343597412109375 ], [ -99.6754150390625, 71.755538940429688 ], [ -100.639312744140625, 72.186920166015625 ], [ -101.776947021484375, 72.299713134765625 ], [ -102.763885498046875, 72.78790283203125 ], [ -102.507080078125, 73.0283203125 ], [ -102.137222290039062, 73.086929321289062 ], [ -101.297500610351562, 72.709991455078125 ], [ -100.434432983398438, 72.736923217773438 ], [ -100.314994812011719, 72.798873901367188 ], [ -100.457504272460938, 73.017623901367188 ], [ -100.314582824707031, 73.029708862304688 ], [ -100.2852783203125, 72.87359619140625 ], [ -100.031387329101562, 72.934982299804688 ], [ -100.240837097167969, 73.135749816894531 ], [ -100.583061218261719, 73.170257568359375 ], [ -100.369712829589844, 73.290122985839844 ], [ -100.045417785644531, 73.18511962890625 ], [ -99.775001525878906, 73.206375122070312 ], [ -100.386116027832031, 73.395957946777344 ], [ -100.889450073242188, 73.264434814453125 ], [ -101.6190185546875, 73.487762451171875 ], [ -100.917915344238281, 73.599990844726562 ], [ -100.444442749023438, 73.4063720703125 ] ] ], [ [ [ -56.323333740234375, 73.7833251953125 ], [ -56.328056335449219, 73.833877563476562 ], [ -56.775554656982422, 73.872894287109375 ], [ -55.955554962158203, 73.831245422363281 ], [ -56.323333740234375, 73.7833251953125 ] ] ], [ [ [ -65.32806396484375, 62.666099548339844 ], [ -65.3397216796875, 62.837493896484375 ], [ -65.909439086914062, 62.925827026367188 ], [ -65.836524963378906, 63.027980804443359 ], [ -66.273056030273438, 63.132213592529297 ], [ -66.106178283691406, 62.945892333984375 ], [ -66.444442749023438, 63.020545959472656 ], [ -66.653816223144531, 63.373394012451172 ], [ -66.738815307617188, 63.291313171386719 ], [ -66.545486450195312, 62.993877410888672 ], [ -66.677635192871094, 63.024715423583984 ], [ -66.811904907226562, 63.272838592529297 ], [ -66.844161987304688, 63.147216796875 ], [ -67.020416259765625, 63.246971130371094 ], [ -66.977638244628906, 63.396728515625 ], [ -67.203887939453125, 63.285270690917969 ], [ -67.897506713867188, 63.7530517578125 ], [ -67.689857482910156, 63.367633819580078 ], [ -68.962509155273438, 63.759162902832031 ], [ -68.149375915527344, 63.153881072998047 ], [ -67.639442443847656, 63.099575042724609 ], [ -67.763473510742188, 62.957283020019531 ], [ -67.559165954589844, 63.049022674560547 ], [ -67.669509887695312, 62.933517456054688 ], [ -67.398056030273438, 62.967208862304688 ], [ -66.354927062988281, 62.445335388183594 ], [ -66.470863342285156, 62.344261169433594 ], [ -66.374710083007812, 62.286109924316406 ], [ -65.996528625488281, 62.245964050292969 ], [ -66.132492065429688, 62.089431762695312 ], [ -65.948043823242188, 61.907768249511719 ], [ -68.615829467773438, 62.263885498046875 ], [ -69.436737060546875, 62.550338745117188 ], [ -69.590629577636719, 62.657905578613281 ], [ -69.482498168945312, 62.76361083984375 ], [ -70.234725952148438, 62.750133514404297 ], [ -71.150344848632812, 62.988670349121094 ], [ -70.8638916015625, 63.112213134765625 ], [ -70.914718627929688, 63.169857025146484 ], [ -71.238327026367188, 63.001522064208984 ], [ -71.710281372070312, 63.177078247070312 ], [ -71.800689697265625, 63.383743286132812 ], [ -72.139999389648438, 63.443115234375 ], [ -71.607223510742188, 63.424160003662109 ], [ -71.2298583984375, 63.602626800537109 ], [ -71.575141906738281, 63.584716796875 ], [ -71.583061218261719, 63.715827941894531 ], [ -71.900558471679688, 63.809226989746094 ], [ -71.927078247070312, 63.652492523193359 ], [ -72.321670532226562, 63.676174163818359 ], [ -72.242149353027344, 63.949714660644531 ], [ -72.367355346679688, 63.788116455078125 ], [ -72.524894714355469, 63.792526245117188 ], [ -72.661529541015625, 64.078605651855469 ], [ -72.720001220703125, 63.961105346679688 ], [ -72.902847290039062, 64.161933898925781 ], [ -73.379371643066406, 64.270126342773438 ], [ -73.415557861328125, 64.445816040039062 ], [ -73.166244506835938, 64.57818603515625 ], [ -73.301528930664062, 64.6578369140625 ], [ -73.424163818359375, 64.509994506835938 ], [ -73.46722412109375, 64.612762451171875 ], [ -73.9102783203125, 64.605819702148438 ], [ -73.8447265625, 64.501937866210938 ], [ -74.062774658203125, 64.334426879882812 ], [ -74.053878784179688, 64.727973937988281 ], [ -74.387916564941406, 64.570480346679688 ], [ -74.70208740234375, 64.735191345214844 ], [ -74.479995727539062, 64.837623596191406 ], [ -74.630966186523438, 64.903732299804688 ], [ -74.978988647460938, 64.790611267089844 ], [ -74.472846984863281, 64.558937072753906 ], [ -74.685821533203125, 64.37109375 ], [ -75.796951293945312, 64.612197875976562 ], [ -75.638511657714844, 64.45953369140625 ], [ -75.915412902832031, 64.482757568359375 ], [ -75.721214294433594, 64.378044128417969 ], [ -76.705841064453125, 64.300811767578125 ], [ -76.670547485351562, 64.18414306640625 ], [ -77.747222900390625, 64.3377685546875 ], [ -78.180686950683594, 64.569992065429688 ], [ -78.147293090820312, 64.947967529296875 ], [ -77.336669921875, 65.17608642578125 ], [ -77.50958251953125, 65.320472717285156 ], [ -77.2918701171875, 65.369598388671875 ], [ -77.38555908203125, 65.468048095703125 ], [ -75.769935607910156, 65.217689514160156 ], [ -75.426246643066406, 65.046096801757812 ], [ -75.665275573730469, 64.943031311035156 ], [ -75.373046875, 64.714996337890625 ], [ -75.357223510742188, 64.89776611328125 ], [ -75.561454772949219, 64.877967834472656 ], [ -75.264175415039062, 64.966094970703125 ], [ -75.190406799316406, 65.1014404296875 ], [ -75.356178283691406, 65.004501342773438 ], [ -75.516403198242188, 65.138595581054688 ], [ -75.943328857421875, 65.319572448730469 ], [ -75.186660766601562, 65.251937866210938 ], [ -75.10491943359375, 65.388458251953125 ], [ -74.524444580078125, 65.333328247070312 ], [ -74.182769775390625, 65.5252685546875 ], [ -73.500564575195312, 65.47442626953125 ], [ -73.709930419921875, 65.762001037597656 ], [ -74.470863342285156, 66.134841918945312 ], [ -72.258346557617188, 67.248031616210938 ], [ -72.666397094726562, 67.68414306640625 ], [ -72.612434387207031, 67.789146423339844 ], [ -72.943077087402344, 67.929840087890625 ], [ -72.993324279785156, 68.205398559570312 ], [ -73.496109008789062, 68.275543212890625 ], [ -73.211669921875, 68.376922607421875 ], [ -73.628402709960938, 68.24713134765625 ], [ -73.8961181640625, 68.3922119140625 ], [ -73.760971069335938, 68.685813903808594 ], [ -74.094161987304688, 68.719985961914062 ], [ -73.884864807128906, 68.557411193847656 ], [ -73.990280151367188, 68.492752075195312 ], [ -74.358749389648438, 68.538040161132812 ], [ -74.727218627929688, 68.733734130859375 ], [ -74.548049926757812, 68.826034545898438 ], [ -74.91583251953125, 68.809295654296875 ], [ -74.72222900390625, 68.93414306640625 ], [ -75.037986755371094, 68.927688598632812 ], [ -74.652496337890625, 69.040267944335938 ], [ -74.9486083984375, 69.048873901367188 ], [ -75.131942749023438, 68.886383056640625 ], [ -75.486518859863281, 69.018051147460938 ], [ -75.6038818359375, 68.87969970703125 ], [ -76.667495727539062, 68.704841613769531 ], [ -76.525344848632812, 68.872756958007812 ], [ -76.603607177734375, 69.02581787109375 ], [ -75.996932983398438, 69.003036499023438 ], [ -75.604438781738281, 69.088943481445312 ], [ -75.5916748046875, 69.221649169921875 ], [ -76.63958740234375, 69.551231384277344 ], [ -76.185623168945312, 69.662071228027344 ], [ -77.191314697265625, 69.642730712890625 ], [ -76.792915344238281, 69.720123291015625 ], [ -77.305061340332031, 69.833946228027344 ], [ -76.990104675292969, 69.936851501464844 ], [ -77.632087707519531, 69.749427795410156 ], [ -77.677009582519531, 70.184211730957031 ], [ -78.403472900390625, 70.213325500488281 ], [ -78.431243896484375, 70.34942626953125 ], [ -79.070556640625, 70.469711303710938 ], [ -78.726104736328125, 70.5474853515625 ], [ -79.017364501953125, 70.679985046386719 ], [ -79.179443359375, 70.425819396972656 ], [ -79.5892333984375, 70.410888671875 ], [ -78.921661376953125, 70.300811767578125 ], [ -78.664169311523438, 70.004165649414062 ], [ -78.791946411132812, 69.891098022460938 ], [ -79.691802978515625, 69.851097106933594 ], [ -81.756805419921875, 70.124908447265625 ], [ -80.767814636230469, 69.770370483398438 ], [ -80.952499389648438, 69.713882446289062 ], [ -82.101104736328125, 70.1080322265625 ], [ -82.999862670898438, 70.304145812988281 ], [ -81.739852905273438, 69.874420166015625 ], [ -82.131309509277344, 69.783454895019531 ], [ -83.050834655761719, 70.004158020019531 ], [ -85.361518859863281, 70.10345458984375 ], [ -85.874649047851562, 70.079429626464844 ], [ -85.245903015136719, 69.9913330078125 ], [ -85.815834045410156, 69.999435424804688 ], [ -86.554023742675781, 70.239845275878906 ], [ -86.579170227050781, 70.361236572265625 ], [ -86.291252136230469, 70.478591918945312 ], [ -86.35791015625, 70.521102905273438 ], [ -86.644866943359375, 70.321792602539062 ], [ -86.960556030273438, 70.467628479003906 ], [ -87.183609008789062, 70.394012451171875 ], [ -86.981109619140625, 70.283187866210938 ], [ -87.86639404296875, 70.238876342773438 ], [ -88.258827209472656, 70.327140808105469 ], [ -87.885269165039062, 70.314422607421875 ], [ -88.897506713867188, 70.532760620117188 ], [ -89.446868896484375, 70.905464172363281 ], [ -89.194503784179688, 70.965888977050781 ], [ -89.549728393554688, 71.088592529296875 ], [ -88.0, 70.929153442382812 ], [ -87.005218505859375, 70.992691040039062 ], [ -87.828056335449219, 71.259780883789062 ], [ -89.903480529785156, 71.353042602539062 ], [ -90.0130615234375, 71.600265502929688 ], [ -89.808334350585938, 71.747756958007812 ], [ -90.048614501953125, 71.953872680664062 ], [ -89.578964233398438, 72.166854858398438 ], [ -89.895767211914062, 72.189140319824219 ], [ -89.910415649414062, 72.427207946777344 ], [ -89.472084045410156, 72.669288635253906 ], [ -89.572090148925781, 72.786094665527344 ], [ -89.33056640625, 72.755828857421875 ], [ -89.36138916015625, 72.991653442382812 ], [ -89.039581298828125, 73.254989624023438 ], [ -88.074722290039062, 73.627761840820312 ], [ -86.716659545898438, 73.8408203125 ], [ -84.970001220703125, 73.77777099609375 ], [ -84.840278625488281, 73.738731384277344 ], [ -85.930282592773438, 73.355255126953125 ], [ -86.732772827148438, 72.716094970703125 ], [ -86.261390686035156, 72.449981689453125 ], [ -86.433464050292969, 72.046653747558594 ], [ -86.132766723632812, 71.795822143554688 ], [ -84.836875915527344, 71.281059265136719 ], [ -86.816246032714844, 70.987823486328125 ], [ -84.952911376953125, 71.187889099121094 ], [ -84.874435424804688, 71.071662902832031 ], [ -84.973472595214844, 71.100677490234375 ], [ -85.14459228515625, 71.084571838378906 ], [ -84.805206298828125, 70.921791076660156 ], [ -84.755973815917969, 71.411651611328125 ], [ -84.526252746582031, 71.473594665527344 ], [ -84.63458251953125, 71.669151306152344 ], [ -85.285552978515625, 71.670402526855469 ], [ -86.049163818359375, 72.012496948242188 ], [ -85.538330078125, 72.05914306640625 ], [ -85.497428894042969, 72.254714965820312 ], [ -85.291946411132812, 72.259994506835938 ], [ -84.167915344238281, 72.022628784179688 ], [ -84.934295654296875, 72.28692626953125 ], [ -84.436874389648438, 72.377830505371094 ], [ -85.5352783203125, 72.469711303710938 ], [ -85.482254028320312, 72.571449279785156 ], [ -85.704795837402344, 72.638114929199219 ], [ -85.685066223144531, 72.89727783203125 ], [ -85.283065795898438, 72.964431762695312 ], [ -83.955696105957031, 72.7506103515625 ], [ -85.536247253417969, 73.025123596191406 ], [ -85.444023132324219, 73.122894287109375 ], [ -83.637916564941406, 72.985671997070312 ], [ -85.177627563476562, 73.216056823730469 ], [ -84.80804443359375, 73.388320922851562 ], [ -84.349441528320312, 73.226158142089844 ], [ -84.653884887695312, 73.389572143554688 ], [ -84.194442749023438, 73.474700927734375 ], [ -83.607223510742188, 73.296791076660156 ], [ -83.658195495605469, 73.447479248046875 ], [ -83.991455078125, 73.504951477050781 ], [ -82.846809387207031, 73.731513977050781 ], [ -81.572509765625, 73.719711303710938 ], [ -81.224166870117188, 73.528457641601562 ], [ -81.207084655761719, 73.26971435546875 ], [ -80.596389770507812, 73.148040771484375 ], [ -80.641525268554688, 72.930671691894531 ], [ -80.252777099609375, 72.727485656738281 ], [ -81.372360229492188, 72.241653442382812 ], [ -80.520980834960938, 72.505958557128906 ], [ -80.514175415039062, 72.37969970703125 ], [ -80.901260375976562, 72.187484741210938 ], [ -80.574241638183594, 72.070610046386719 ], [ -81.0826416015625, 72.048866271972656 ], [ -80.793464660644531, 72.025131225585938 ], [ -80.950286865234375, 71.881088256835938 ], [ -80.385009765625, 72.048324584960938 ], [ -80.479927062988281, 72.176750183105469 ], [ -80.266532897949219, 72.292625427246094 ], [ -79.991668701171875, 72.176651000976562 ], [ -79.685585021972656, 72.134468078613281 ], [ -80.159584045410156, 72.324287414550781 ], [ -79.799163818359375, 72.501388549804688 ], [ -79.595550537109375, 72.334716796875 ], [ -79.741386413574219, 72.213874816894531 ], [ -79.345832824707031, 72.398948669433594 ], [ -79.012786865234375, 72.273880004882812 ], [ -79.196670532226562, 71.960128784179688 ], [ -78.5130615234375, 71.867897033691406 ], [ -78.919235229492188, 72.012763977050781 ], [ -78.8583984375, 72.170326232910156 ], [ -78.481941223144531, 72.08984375 ], [ -78.21875, 71.829437255859375 ], [ -77.908332824707031, 71.769645690917969 ], [ -78.311729431152344, 71.930015563964844 ], [ -78.149314880371094, 71.966239929199219 ], [ -77.785552978515625, 71.787490844726562 ], [ -78.430686950683594, 72.11553955078125 ], [ -78.8699951171875, 72.228179931640625 ], [ -78.610000610351562, 72.359283447265625 ], [ -78.415138244628906, 72.168601989746094 ], [ -78.445274353027344, 72.325408935546875 ], [ -77.54083251953125, 72.176925659179688 ], [ -77.006629943847656, 72.12921142578125 ], [ -78.556655883789062, 72.504440307617188 ], [ -77.620689392089844, 72.750129699707031 ], [ -76.947219848632812, 72.743865966796875 ], [ -76.114715576171875, 72.475677490234375 ], [ -75.93194580078125, 72.583602905273438 ], [ -75.223480224609375, 72.499015808105469 ], [ -74.94610595703125, 72.259712219238281 ], [ -76.024169921875, 72.083877563476562 ], [ -76.348052978515625, 71.89166259765625 ], [ -75.796661376953125, 72.103591918945312 ], [ -75.225898742675781, 72.074668884277344 ], [ -75.580421447753906, 72.001373291015625 ], [ -75.802490234375, 71.75054931640625 ], [ -76.092018127441406, 71.696365356445312 ], [ -75.791107177734375, 71.728179931640625 ], [ -75.538604736328125, 71.986373901367188 ], [ -75.043609619140625, 72.123863220214844 ], [ -74.122222900390625, 71.983596801757812 ], [ -74.236526489257812, 71.820686340332031 ], [ -75.390213012695312, 71.676918029785156 ], [ -74.940269470214844, 71.664215087890625 ], [ -75.402503967285156, 71.52001953125 ], [ -74.631385803222656, 71.656028747558594 ], [ -75.116241455078125, 71.497764587402344 ], [ -74.705207824707031, 71.383522033691406 ], [ -75.081390380859375, 71.179428100585938 ], [ -74.645980834960938, 71.375396728515625 ], [ -74.739585876464844, 71.521240234375 ], [ -74.54388427734375, 71.631362915039062 ], [ -74.108673095703125, 71.734214782714844 ], [ -74.253616333007812, 71.603034973144531 ], [ -74.162605285644531, 71.539146423339844 ], [ -73.9969482421875, 71.751388549804688 ], [ -73.718887329101562, 71.776931762695312 ], [ -73.592430114746094, 71.75262451171875 ], [ -74.307487487792969, 71.414115905761719 ], [ -74.037223815917969, 71.439285278320312 ], [ -74.231559753417969, 71.204109191894531 ], [ -73.630828857421875, 71.584854125976562 ], [ -73.628753662109375, 71.3580322265625 ], [ -73.383544921875, 71.387763977050781 ], [ -73.885971069335938, 71.059494018554688 ], [ -73.434860229492188, 71.337699890136719 ], [ -73.057357788085938, 71.266448974609375 ], [ -73.269027709960938, 71.222763061523438 ], [ -73.373741149902344, 70.983177185058594 ], [ -72.530838012695312, 71.659843444824219 ], [ -71.554168701171875, 71.503875732421875 ], [ -71.123603820800781, 71.261100769042969 ], [ -71.458335876464844, 71.065269470214844 ], [ -71.91082763671875, 71.107757568359375 ], [ -72.653892517089844, 70.824302673339844 ], [ -72.170692443847656, 70.837905883789062 ], [ -72.5694580078125, 70.6099853515625 ], [ -71.354446411132812, 70.88275146484375 ], [ -70.83612060546875, 71.114425659179688 ], [ -70.603057861328125, 71.053726196289062 ], [ -70.515350341796875, 70.925399780273438 ], [ -70.773330688476562, 70.734420776367188 ], [ -71.558609008789062, 70.609420776367188 ], [ -71.803054809570312, 70.428314208984375 ], [ -71.84375, 70.29351806640625 ], [ -71.505416870117188, 70.574432373046875 ], [ -71.173049926757812, 70.532341003417969 ], [ -71.533363342285156, 70.027137756347656 ], [ -71.001533508300781, 70.621368408203125 ], [ -69.90728759765625, 70.879905700683594 ], [ -69.774650573730469, 70.857200622558594 ], [ -70.454727172851562, 70.627761840820312 ], [ -70.4879150390625, 70.483901977539062 ], [ -69.460563659667969, 70.791236877441406 ], [ -68.319725036621094, 70.564849853515625 ], [ -68.452011108398438, 70.375328063964844 ], [ -68.5736083984375, 70.465408325195312 ], [ -68.735549926757812, 70.317764282226562 ], [ -69.668060302734375, 70.198593139648438 ], [ -70.181381225585938, 70.028877258300781 ], [ -69.815826416015625, 69.989013671875 ], [ -70.164443969726562, 69.961654663085938 ], [ -70.465835571289062, 69.843460083007812 ], [ -69.7772216796875, 69.963607788085938 ], [ -69.653335571289062, 70.144989013671875 ], [ -68.6456298828125, 70.15283203125 ], [ -69.433326721191406, 69.818046569824219 ], [ -69.805831909179688, 69.819992065429688 ], [ -69.990554809570312, 69.614990234375 ], [ -69.756462097167969, 69.798591613769531 ], [ -69.402503967285156, 69.777076721191406 ], [ -68.221389770507812, 70.102767944335938 ], [ -68.348052978515625, 70.174217224121094 ], [ -68.160003662109375, 70.282760620117188 ], [ -67.801383972167969, 70.260688781738281 ], [ -67.219863891601562, 69.940811157226562 ], [ -67.127777099609375, 69.7269287109375 ], [ -68.004585266113281, 69.773178100585938 ], [ -68.318962097167969, 69.630821228027344 ], [ -70.028892517089844, 69.532623291015625 ], [ -68.6119384765625, 69.587493896484375 ], [ -66.790412902832031, 69.339149475097656 ], [ -66.648063659667969, 69.230682373046875 ], [ -66.760215759277344, 69.128936767578125 ], [ -67.6763916015625, 69.16943359375 ], [ -68.184478759765625, 69.308013916015625 ], [ -69.0150146484375, 69.35498046875 ], [ -69.24774169921875, 69.271690368652344 ], [ -68.082847595214844, 69.220954895019531 ], [ -68.9677734375, 69.221099853515625 ], [ -68.509170532226562, 69.19720458984375 ], [ -68.998046875, 69.103591918945312 ], [ -69.022773742675781, 68.970542907714844 ], [ -68.178329467773438, 69.146652221679688 ], [ -67.718887329101562, 69.026100158691406 ], [ -68.547149658203125, 68.975608825683594 ], [ -67.774093627929688, 68.7823486328125 ], [ -69.39013671875, 68.864700317382812 ], [ -68.047492980957031, 68.679496765136719 ], [ -68.090980529785156, 68.628593444824219 ], [ -68.65777587890625, 68.6563720703125 ], [ -68.897773742675781, 68.605262756347656 ], [ -68.835830688476562, 68.589157104492188 ], [ -67.496528625488281, 68.532760620117188 ], [ -67.60333251953125, 68.378860473632812 ], [ -67.426101684570312, 68.494430541992188 ], [ -66.702362060546875, 68.436370849609375 ], [ -67.743881225585938, 68.34332275390625 ], [ -67.871589660644531, 68.262214660644531 ], [ -67.238189697265625, 68.357902526855469 ], [ -67.0196533203125, 68.313865661621094 ], [ -67.598617553710938, 68.16387939453125 ], [ -67.003059387207031, 68.292831420898438 ], [ -66.77618408203125, 68.241920471191406 ], [ -66.952919006347656, 68.071998596191406 ], [ -66.9466552734375, 68.01361083984375 ], [ -66.513626098632812, 68.148330688476562 ], [ -66.18804931640625, 68.013946533203125 ], [ -66.694999694824219, 67.863182067871094 ], [ -66.356658935546875, 67.821380615234375 ], [ -65.925689697265625, 68.160049438476562 ], [ -66.00201416015625, 67.628799438476562 ], [ -65.817222595214844, 67.964363098144531 ], [ -65.444160461425781, 67.989006042480469 ], [ -65.608222961425781, 67.790473937988281 ], [ -65.346389770507812, 67.59332275390625 ], [ -65.550971984863281, 67.780891418457031 ], [ -65.423614501953125, 67.898040771484375 ], [ -65.001113891601562, 68.0555419921875 ], [ -64.726181030273438, 67.98883056640625 ], [ -65.015289306640625, 67.86248779296875 ], [ -65.203758239746094, 67.651237487792969 ], [ -64.5069580078125, 67.807205200195312 ], [ -64.366241455078125, 67.760543823242188 ], [ -64.630279541015625, 67.662139892578125 ], [ -64.3004150390625, 67.73193359375 ], [ -64.041801452636719, 67.528388977050781 ], [ -64.432838439941406, 67.475677490234375 ], [ -64.003860473632812, 67.455970764160156 ], [ -63.907913208007812, 67.301681518554688 ], [ -64.792388916015625, 67.355400085449219 ], [ -64.2452392578125, 67.294219970703125 ], [ -64.802734375, 67.204048156738281 ], [ -64.765838623046875, 67.190254211425781 ], [ -63.971141815185547, 67.275856018066406 ], [ -64.6119384765625, 67.132476806640625 ], [ -64.696975708007812, 67.009086608886719 ], [ -63.460624694824219, 67.224533081054688 ], [ -63.533889770507812, 67.102485656738281 ], [ -63.7379150390625, 67.044563293457031 ], [ -63.802707672119141, 66.9925537109375 ], [ -63.773853302001953, 66.974044799804688 ], [ -63.399200439453125, 67.15179443359375 ], [ -63.344097137451172, 67.273674011230469 ], [ -63.110282897949219, 67.329986572265625 ], [ -62.972358703613281, 67.229560852050781 ], [ -63.274513244628906, 67.113380432128906 ], [ -63.228469848632812, 66.974708557128906 ], [ -63.520431518554688, 66.910881042480469 ], [ -63.593330383300781, 66.8316650390625 ], [ -63.773609161376953, 66.818458557128906 ], [ -63.543125152587891, 66.813865661621094 ], [ -63.434444427490234, 66.904853820800781 ], [ -63.411666870117188, 66.703178405761719 ], [ -63.224716186523438, 66.899429321289062 ], [ -62.842361450195312, 66.959846496582031 ], [ -62.909130096435547, 66.646514892578125 ], [ -62.600002288818359, 66.951515197753906 ], [ -62.314723968505859, 66.729156494140625 ], [ -62.423057556152344, 66.923873901367188 ], [ -62.101394653320312, 67.054702758789062 ], [ -62.104167938232422, 66.915122985839844 ], [ -61.749725341796875, 66.948028564453125 ], [ -61.264583587646484, 66.626091003417969 ], [ -61.447776794433594, 66.538314819335938 ], [ -61.950553894042969, 66.676925659179688 ], [ -62.123886108398438, 66.626373291015625 ], [ -61.579200744628906, 66.48101806640625 ], [ -61.97784423828125, 66.412376403808594 ], [ -61.465000152587891, 66.369697570800781 ], [ -61.877494812011719, 66.2833251953125 ], [ -62.456108093261719, 66.423873901367188 ], [ -62.708747863769531, 66.408523559570312 ], [ -62.320140838623047, 66.302757263183594 ], [ -62.67388916015625, 66.215682983398438 ], [ -62.883541107177734, 66.333740234375 ], [ -62.710556030273438, 66.20068359375 ], [ -61.959793090820312, 66.021583557128906 ], [ -62.964996337890625, 66.148460388183594 ], [ -63.061111450195312, 66.118598937988281 ], [ -62.411945343017578, 65.966789245605469 ], [ -62.317222595214844, 65.808029174804688 ], [ -62.860836029052734, 65.911102294921875 ], [ -62.570697784423828, 65.754501342773438 ], [ -62.829971313476562, 65.752212524414062 ], [ -62.649166107177734, 65.586654663085938 ], [ -62.929306030273438, 65.75360107421875 ], [ -62.957500457763672, 65.584991455078125 ], [ -63.206111907958984, 65.636940002441406 ], [ -63.439720153808594, 65.849983215332031 ], [ -63.368331909179688, 65.66943359375 ], [ -63.718570709228516, 65.678207397460938 ], [ -63.323333740234375, 65.597068786621094 ], [ -63.612289428710938, 65.535751342773438 ], [ -63.302150726318359, 65.440078735351562 ], [ -63.651943206787109, 65.470405578613281 ], [ -63.335693359375, 65.29803466796875 ], [ -63.546951293945312, 64.88720703125 ], [ -63.824172973632812, 64.984710693359375 ], [ -63.691665649414062, 65.048591613769531 ], [ -64.3770751953125, 65.179145812988281 ], [ -64.239158630371094, 65.427406311035156 ], [ -64.550621032714844, 65.094291687011719 ], [ -64.910690307617188, 65.301506042480469 ], [ -64.690055847167969, 65.334815979003906 ], [ -64.903472900390625, 65.336616516113281 ], [ -64.418746948242188, 65.479843139648438 ], [ -65.1416015625, 65.426719665527344 ], [ -64.711456298828125, 65.65081787109375 ], [ -65.335968017578125, 65.569572448730469 ], [ -64.801727294921875, 65.721931457519531 ], [ -65.501808166503906, 65.748878479003906 ], [ -65.357223510742188, 65.902481079101562 ], [ -64.737701416015625, 65.972831726074219 ], [ -64.716941833496094, 66.220542907714844 ], [ -64.362319946289062, 66.343215942382812 ], [ -64.716667175292969, 66.274154663085938 ], [ -64.941246032714844, 66.078605651855469 ], [ -65.876388549804688, 65.948028564453125 ], [ -65.963478088378906, 66.039146423339844 ], [ -65.644027709960938, 66.167411804199219 ], [ -65.480758666992188, 66.384849548339844 ], [ -66.073623657226562, 66.120529174804688 ], [ -66.492500305175781, 66.204574584960938 ], [ -66.571945190429688, 66.362060546875 ], [ -66.443984985351562, 66.404739379882812 ], [ -66.767776489257812, 66.380538940429688 ], [ -66.851943969726562, 66.583328247070312 ], [ -67.03277587890625, 66.644020080566406 ], [ -66.887161254882812, 66.566513061523438 ], [ -67.734298706054688, 66.568801879882812 ], [ -67.146186828613281, 66.440254211425781 ], [ -67.404167175292969, 66.426651000976562 ], [ -67.131423950195312, 66.309288024902344 ], [ -67.2822265625, 66.2752685546875 ], [ -67.989295959472656, 66.507560729980469 ], [ -67.16375732421875, 66.036094665527344 ], [ -67.188743591308594, 65.91241455078125 ], [ -67.824172973632812, 65.880813598632812 ], [ -67.9385986328125, 65.908035278320312 ], [ -68.026527404785156, 66.063308715820312 ], [ -68.244720458984375, 66.182754516601562 ], [ -68.843887329101562, 66.188728332519531 ], [ -68.047225952148438, 66.064987182617188 ], [ -68.328338623046875, 65.922271728515625 ], [ -67.821121215820312, 65.768051147460938 ], [ -68.023300170898438, 65.488380432128906 ], [ -67.277923583984375, 65.640129089355469 ], [ -67.455902099609375, 65.498870849609375 ], [ -67.060554504394531, 65.422065734863281 ], [ -67.407218933105469, 65.339500427246094 ], [ -66.932846069335938, 65.232757568359375 ], [ -67.104652404785156, 65.059837341308594 ], [ -66.73236083984375, 65.1800537109375 ], [ -66.69464111328125, 64.761863708496094 ], [ -66.618057250976562, 65.0302734375 ], [ -66.148345947265625, 64.868865966796875 ], [ -66.215553283691406, 64.68817138671875 ], [ -66.020210266113281, 64.84783935546875 ], [ -65.851730346679688, 64.680397033691406 ], [ -65.937843322753906, 64.890403747558594 ], [ -65.668609619140625, 64.810127258300781 ], [ -65.739372253417969, 64.744224548339844 ], [ -65.707359313964844, 64.691436767578125 ], [ -65.562042236328125, 64.731544494628906 ], [ -65.71417236328125, 64.570541381835938 ], [ -65.701942443847656, 64.486228942871094 ], [ -65.078201293945312, 64.472206115722656 ], [ -65.200828552246094, 64.307685852050781 ], [ -65.657569885253906, 64.304977416992188 ], [ -65.053321838378906, 64.069297790527344 ], [ -65.189987182617188, 64.020263671875 ], [ -64.673126220703125, 64.03436279296875 ], [ -64.98541259765625, 63.823814392089844 ], [ -64.951530456542969, 63.775409698486328 ], [ -64.532638549804688, 63.679641723632812 ], [ -64.49554443359375, 63.327774047851562 ], [ -64.617286682128906, 63.319713592529297 ], [ -64.488609313964844, 63.286590576171875 ], [ -64.658340454101562, 63.249160766601562 ], [ -64.942489624023438, 63.632209777832031 ], [ -65.297325134277344, 63.810161590576172 ], [ -64.909164428710938, 63.280548095703125 ], [ -65.143409729003906, 63.286937713623047 ], [ -65.083328247070312, 63.203880310058594 ], [ -64.630615234375, 62.899021148681641 ], [ -65.252365112304688, 62.975337982177734 ], [ -64.948883056640625, 62.648605346679688 ], [ -65.32806396484375, 62.666099548339844 ] ] ], [ [ [ -77.084754943847656, 72.839683532714844 ], [ -79.623886108398438, 72.763320922851562 ], [ -80.003890991210938, 72.867897033691406 ], [ -80.140975952148438, 73.214431762695312 ], [ -80.8760986328125, 73.333183288574219 ], [ -80.857772827148438, 73.741928100585938 ], [ -77.4244384765625, 73.554702758789062 ], [ -76.060821533203125, 72.903877258300781 ], [ -77.084754943847656, 72.839683532714844 ] ] ], [ [ [ -105.225830078125, 72.93304443359375 ], [ -105.383056640625, 72.866653442382812 ], [ -106.454299926757812, 73.396240234375 ], [ -107.030754089355469, 73.485542297363281 ], [ -106.618331909179688, 73.70526123046875 ], [ -105.525970458984375, 73.763046264648438 ], [ -104.488265991210938, 73.548309326171875 ], [ -104.572357177734375, 73.325897216796875 ], [ -105.225830078125, 72.93304443359375 ] ] ], [ [ [ -56.489997863769531, 73.683319091796875 ], [ -56.342082977294922, 73.682342529296875 ], [ -56.833328247070312, 73.611373901367188 ], [ -56.963886260986328, 73.659706115722656 ], [ -56.489997863769531, 73.683319091796875 ] ] ], [ [ [ -56.4102783203125, 73.54193115234375 ], [ -56.556941986083984, 73.554283142089844 ], [ -56.190414428710938, 73.625808715820312 ], [ -56.327499389648438, 73.556365966796875 ], [ -56.4102783203125, 73.54193115234375 ] ] ], [ [ [ -124.307502746582031, 73.6322021484375 ], [ -124.167770385742188, 73.603042602539062 ], [ -124.114715576171875, 73.567344665527344 ], [ -124.343612670898438, 73.559982299804688 ], [ -124.307502746582031, 73.6322021484375 ] ] ], [ [ [ -107.645278930664062, 73.570266723632812 ], [ -107.930557250976562, 73.5394287109375 ], [ -108.081878662109375, 73.582206726074219 ], [ -107.584793090820312, 73.601577758789062 ], [ -107.645278930664062, 73.570266723632812 ] ] ], [ [ [ -55.94305419921875, 73.570266723632812 ], [ -55.875831604003906, 73.5283203125 ], [ -55.47332763671875, 73.428871154785156 ], [ -56.115837097167969, 73.556640625 ], [ -55.94305419921875, 73.570266723632812 ] ] ], [ [ [ -55.963890075683594, 73.479156494140625 ], [ -55.811527252197266, 73.47137451171875 ], [ -55.784168243408203, 73.434707641601562 ], [ -56.054027557373047, 73.450958251953125 ], [ -55.963890075683594, 73.479156494140625 ] ] ], [ [ [ -24.397499084472656, 73.414703369140625 ], [ -23.212497711181641, 73.229843139648438 ], [ -23.65777587890625, 73.220260620117188 ], [ -24.247219085693359, 73.293045043945312 ], [ -24.907501220703125, 73.324432373046875 ], [ -25.006668090820312, 73.312057495117188 ], [ -22.938610076904297, 73.134719848632812 ], [ -24.403888702392578, 73.023880004882812 ], [ -25.710138320922852, 73.183319091796875 ], [ -25.243053436279297, 73.40582275390625 ], [ -24.397499084472656, 73.414703369140625 ] ] ], [ [ [ -55.549728393554688, 73.314987182617188 ], [ -55.591526031494141, 73.347480773925781 ], [ -55.329448699951172, 73.3922119140625 ], [ -55.392227172851562, 73.361648559570312 ], [ -55.549728393554688, 73.314987182617188 ] ] ], [ [ [ -55.9647216796875, 73.403594970703125 ], [ -55.834026336669922, 73.371292114257812 ], [ -56.146804809570312, 73.295822143554688 ], [ -56.0927734375, 73.37469482421875 ], [ -55.9647216796875, 73.403594970703125 ] ] ], [ [ [ -105.024436950683594, 72.219985961914062 ], [ -104.820564270019531, 71.87164306640625 ], [ -104.360824584960938, 71.581657409667969 ], [ -104.578056335449219, 71.062492370605469 ], [ -103.556381225585938, 70.600814819335938 ], [ -102.923187255859375, 70.503074645996094 ], [ -103.1260986328125, 70.573883056640625 ], [ -103.025009155273438, 70.660263061523438 ], [ -101.591560363769531, 70.270294189453125 ], [ -101.55596923828125, 70.11151123046875 ], [ -100.999732971191406, 70.172760009765625 ], [ -100.924301147460938, 69.692619323730469 ], [ -101.326393127441406, 69.670951843261719 ], [ -101.450828552246094, 69.9073486328125 ], [ -101.694580078125, 69.682487487792969 ], [ -102.235557556152344, 69.915260314941406 ], [ -102.672004699707031, 69.760482788085938 ], [ -102.4808349609375, 69.687339782714844 ], [ -102.603057861328125, 69.538314819335938 ], [ -103.481796264648438, 69.68914794921875 ], [ -103.013900756835938, 69.474151611328125 ], [ -103.182220458984375, 69.111099243164062 ], [ -102.8321533203125, 69.384162902832031 ], [ -102.305549621582031, 69.498458862304688 ], [ -101.933883666992188, 69.411094665527344 ], [ -102.217216491699219, 69.225265502929688 ], [ -101.753059387207031, 69.16290283203125 ], [ -101.851387023925781, 68.984420776367188 ], [ -102.894729614257812, 68.79998779296875 ], [ -105.136947631835938, 68.89776611328125 ], [ -105.248893737792969, 68.945526123046875 ], [ -104.9208984375, 69.072341918945312 ], [ -106.407913208007812, 69.184562683105469 ], [ -106.316390991210938, 69.38665771484375 ], [ -106.611106872558594, 69.496994018554688 ], [ -107.342216491699219, 69.018875122070312 ], [ -108.530693054199219, 68.944976806640625 ], [ -109.104721069335938, 68.710540771484375 ], [ -113.260421752929688, 68.453041076660156 ], [ -113.041732788085938, 68.493736267089844 ], [ -113.671798706054688, 68.806648254394531 ], [ -113.547843933105469, 69.046371459960938 ], [ -113.686515808105469, 69.190673828125 ], [ -113.553596496582031, 69.18719482421875 ], [ -116.532211303710938, 69.40887451171875 ], [ -116.578475952148438, 69.558174133300781 ], [ -117.243194580078125, 69.754997253417969 ], [ -117.432563781738281, 69.983451843261719 ], [ -115.167503356933594, 70.27777099609375 ], [ -112.556381225585938, 70.198455810546875 ], [ -111.452629089355469, 70.283180236816406 ], [ -111.494094848632812, 70.339775085449219 ], [ -113.938316345214844, 70.71527099609375 ], [ -117.551521301269531, 70.596237182617188 ], [ -118.410903930664062, 71.000259399414062 ], [ -115.066947937011719, 71.523872375488281 ], [ -118.112213134765625, 71.37359619140625 ], [ -118.31207275390625, 71.459014892578125 ], [ -117.681106567382812, 71.551376342773438 ], [ -117.908889770507812, 71.614990234375 ], [ -117.711837768554688, 71.664085388183594 ], [ -118.903755187988281, 71.579437255859375 ], [ -119.134452819824219, 71.774574279785156 ], [ -118.691940307617188, 72.130538940429688 ], [ -118.123886108398438, 72.224433898925781 ], [ -118.588607788085938, 72.416656494140625 ], [ -118.207229614257812, 72.61859130859375 ], [ -117.353607177734375, 72.9163818359375 ], [ -114.666664123535156, 73.372474670410156 ], [ -113.959304809570312, 73.14776611328125 ], [ -113.974990844726562, 72.820121765136719 ], [ -114.558326721191406, 72.560806274414062 ], [ -113.466400146484375, 72.665267944335938 ], [ -113.590690612792969, 72.78790283203125 ], [ -113.028060913085938, 73.009429931640625 ], [ -111.229927062988281, 72.723457336425781 ], [ -111.269866943359375, 72.573326110839844 ], [ -111.899101257324219, 72.352973937988281 ], [ -111.663887023925781, 72.276382446289062 ], [ -111.301651000976562, 72.4617919921875 ], [ -111.112777709960938, 72.33526611328125 ], [ -110.708343505859375, 72.574295043945312 ], [ -109.78582763671875, 72.432479858398438 ], [ -110.28228759765625, 72.66290283203125 ], [ -109.773338317871094, 72.720199584960938 ], [ -110.743606567382812, 72.986785888671875 ], [ -109.659439086914062, 72.92498779296875 ], [ -109.040756225585938, 72.569503784179688 ], [ -108.618881225585938, 72.547622680664062 ], [ -108.660560607910156, 72.341239929199219 ], [ -108.191246032714844, 71.956443786621094 ], [ -108.238601684570312, 71.715126037597656 ], [ -107.837081909179688, 71.604148864746094 ], [ -107.261428833007812, 71.889633178710938 ], [ -107.779861450195312, 72.139297485351562 ], [ -107.879852294921875, 72.574638366699219 ], [ -108.293609619140625, 73.120254516601562 ], [ -107.876106262207031, 73.18719482421875 ], [ -108.084442138671875, 73.349990844726562 ], [ -107.069732666015625, 73.173873901367188 ], [ -106.86138916015625, 73.310806274414062 ], [ -105.855560302734375, 73.056930541992188 ], [ -105.323471069335938, 72.738800048828125 ], [ -105.504173278808594, 72.778877258300781 ], [ -105.024436950683594, 72.219985961914062 ] ] ], [ [ [ -55.7177734375, 73.360260009765625 ], [ -55.6280517578125, 73.298873901367188 ], [ -55.869583129882812, 73.330131530761719 ], [ -55.7852783203125, 73.360260009765625 ], [ -55.7177734375, 73.360260009765625 ] ] ], [ [ [ -55.844444274902344, 73.250274658203125 ], [ -55.820003509521484, 73.213188171386719 ], [ -56.132217407226562, 73.081939697265625 ], [ -56.017219543457031, 73.228591918945312 ], [ -55.844444274902344, 73.250274658203125 ] ] ], [ [ [ -96.771942138671875, 73.181655883789062 ], [ -96.577926635742188, 73.078048706054688 ], [ -96.640007019042969, 72.963600158691406 ], [ -97.138336181640625, 73.048873901367188 ], [ -96.771942138671875, 73.181655883789062 ] ] ], [ [ [ -21.91583251953125, 72.675811767578125 ], [ -23.132221221923828, 72.870529174804688 ], [ -24.588056564331055, 72.954292297363281 ], [ -22.468330383300781, 73.001663208007812 ], [ -21.904165267944336, 72.917900085449219 ], [ -22.189722061157227, 72.808868408203125 ], [ -21.91583251953125, 72.675811767578125 ] ] ], [ [ [ -55.305831909179688, 72.918319702148438 ], [ -55.387779235839844, 72.962493896484375 ], [ -55.684513092041016, 72.991783142089844 ], [ -55.0755615234375, 72.965545654296875 ], [ -55.305831909179688, 72.918319702148438 ] ] ], [ [ [ -24.778335571289062, 72.895263671875 ], [ -24.89666748046875, 72.77777099609375 ], [ -25.2147216796875, 72.822769165039062 ], [ -25.145832061767578, 72.88165283203125 ], [ -24.778335571289062, 72.895263671875 ] ] ], [ [ [ -96.688323974609375, 72.883331298828125 ], [ -96.741378784179688, 72.725540161132812 ], [ -97.010284423828125, 72.776657104492188 ], [ -96.798614501953125, 72.881362915039062 ], [ -96.688323974609375, 72.883331298828125 ] ] ], [ [ [ -55.559165954589844, 72.888046264648438 ], [ -55.514450073242188, 72.888595581054688 ], [ -55.357013702392578, 72.84991455078125 ], [ -55.536666870117188, 72.822494506835938 ], [ -55.559165954589844, 72.888046264648438 ] ] ], [ [ [ -22.311389923095703, 72.112762451171875 ], [ -24.347499847412109, 72.583602905273438 ], [ -24.476526260375977, 72.833595275878906 ], [ -23.149168014526367, 72.836799621582031 ], [ -21.928194046020508, 72.464706420898438 ], [ -22.760974884033203, 72.437614440917969 ], [ -22.134166717529297, 72.271652221679688 ], [ -22.311389923095703, 72.112762451171875 ] ] ], [ [ [ -55.197471618652344, 72.845321655273438 ], [ -54.964790344238281, 72.80810546875 ], [ -55.53277587890625, 72.551651000976562 ], [ -55.848468780517578, 72.614151000976562 ], [ -55.197471618652344, 72.845321655273438 ] ] ], [ [ [ -55.656661987304688, 72.768600463867188 ], [ -56.036666870117188, 72.6502685546875 ], [ -56.225410461425781, 72.704292297363281 ], [ -55.893333435058594, 72.76361083984375 ], [ -55.656661987304688, 72.768600463867188 ] ] ], [ [ [ -54.946662902832031, 72.763046264648438 ], [ -54.846664428710938, 72.751937866210938 ], [ -54.801113128662109, 72.718177795410156 ], [ -55.060001373291016, 72.721656799316406 ], [ -54.946662902832031, 72.763046264648438 ] ] ], [ [ [ -55.001113891601562, 72.685806274414062 ], [ -54.952499389648438, 72.657211303710938 ], [ -55.258056640625, 72.596511840820312 ], [ -55.196662902832031, 72.677474975585938 ], [ -55.001113891601562, 72.685806274414062 ] ] ], [ [ [ -55.032501220703125, 72.578048706054688 ], [ -55.079727172851562, 72.523040771484375 ], [ -55.38055419921875, 72.54345703125 ], [ -55.184722900390625, 72.583328247070312 ], [ -55.032501220703125, 72.578048706054688 ] ] ], [ [ [ -80.036941528320312, 72.516387939453125 ], [ -79.919166564941406, 72.460678100585938 ], [ -80.131660461425781, 72.521240234375 ], [ -80.036941528320312, 72.516387939453125 ] ] ], [ [ [ -79.552490234375, 72.451095581054688 ], [ -79.433052062988281, 72.414985656738281 ], [ -79.443603515625, 72.367759704589844 ], [ -79.683319091796875, 72.4305419921875 ], [ -79.552490234375, 72.451095581054688 ] ] ], [ [ [ -78.939987182617188, 72.435806274414062 ], [ -78.833892822265625, 72.41192626953125 ], [ -78.73333740234375, 72.367485046386719 ], [ -79.075286865234375, 72.406379699707031 ], [ -78.939987182617188, 72.435806274414062 ] ] ], [ [ [ -55.015281677246094, 72.377197265625 ], [ -55.344718933105469, 72.16693115234375 ], [ -55.688747406005859, 72.195816040039062 ], [ -55.523330688476562, 72.270263671875 ], [ -55.015281677246094, 72.377197265625 ] ] ], [ [ [ -86.067230224609375, 72.293869018554688 ], [ -85.8638916015625, 72.297210693359375 ], [ -85.83721923828125, 72.262771606445312 ], [ -85.908340454101562, 72.217758178710938 ], [ -86.067230224609375, 72.293869018554688 ] ] ], [ [ [ -74.707778930664062, 72.20721435546875 ], [ -74.796661376953125, 72.168045043945312 ], [ -74.94708251953125, 72.175117492675781 ], [ -74.674301147460938, 72.224639892578125 ], [ -74.707778930664062, 72.20721435546875 ] ] ], [ [ [ -61.690834045410156, 56.548049926757812 ], [ -62.136806488037109, 56.450824737548828 ], [ -61.676429748535156, 56.268604278564453 ], [ -62.077846527099609, 56.2918701171875 ], [ -61.348194122314453, 56.220268249511719 ], [ -61.450485229492188, 56.056312561035156 ], [ -61.240348815917969, 56.043952941894531 ], [ -61.499725341796875, 56.013050079345703 ], [ -61.117641448974609, 55.964920043945312 ], [ -61.090553283691406, 55.844154357910156 ], [ -60.735694885253906, 55.83624267578125 ], [ -60.879997253417969, 55.740962982177734 ], [ -60.619583129882812, 55.823467254638672 ], [ -60.661808013916016, 55.586933135986328 ], [ -60.508754730224609, 55.798328399658203 ], [ -60.332775115966797, 55.78131103515625 ], [ -60.530048370361328, 55.596904754638672 ], [ -60.317985534667969, 55.573188781738281 ], [ -60.47833251953125, 55.347488403320312 ], [ -60.3255615234375, 55.489017486572266 ], [ -60.195549011230469, 55.431381225585938 ], [ -60.683326721191406, 54.9949951171875 ], [ -60.074775695800781, 55.246936798095703 ], [ -60.289897918701172, 55.027248382568359 ], [ -59.777637481689453, 55.329441070556641 ], [ -59.735134124755859, 55.197002410888672 ], [ -59.965835571289062, 55.114715576171875 ], [ -59.431873321533203, 55.135440826416016 ], [ -59.802165985107422, 54.88726806640625 ], [ -59.914302825927734, 54.741104125976562 ], [ -59.156383514404297, 55.233879089355469 ], [ -59.383609771728516, 54.981201171875 ], [ -59.033542633056641, 55.155891418457031 ], [ -58.904167175292969, 54.844711303710938 ], [ -57.349685668945312, 54.574958801269531 ], [ -57.697708129882812, 54.465267181396484 ], [ -57.422431945800781, 54.455547332763672 ], [ -57.625553131103516, 54.382633209228516 ], [ -59.581596374511719, 54.042980194091797 ], [ -58.375064849853516, 54.226722717285156 ], [ -58.632499694824219, 54.035270690917969 ], [ -60.082778930664062, 53.762496948242188 ], [ -60.136112213134766, 53.528465270996094 ], [ -60.382915496826172, 53.661586761474609 ], [ -60.856948852539062, 53.792770385742188 ], [ -60.103614807128906, 53.50054931640625 ], [ -60.40777587890625, 53.267215728759766 ], [ -59.076950073242188, 53.681800842285156 ], [ -58.550277709960938, 54.009162902832031 ], [ -57.796943664550781, 54.075092315673828 ], [ -58.355560302734375, 54.206382751464844 ], [ -57.468330383300781, 54.193878173828125 ], [ -57.080310821533203, 53.823467254638672 ], [ -57.535503387451172, 53.598514556884766 ], [ -57.315139770507812, 53.576663970947266 ], [ -57.338054656982422, 53.447353363037109 ], [ -57.014724731445312, 53.711380004882812 ], [ -56.474151611328125, 53.782382965087891 ], [ -56.671249389648438, 53.676380157470703 ], [ -56.029304504394531, 53.575828552246094 ], [ -56.259586334228516, 53.547595977783203 ], [ -55.808052062988281, 53.340545654296875 ], [ -55.751319885253906, 53.138328552246094 ], [ -56.164581298828125, 53.030200958251953 ], [ -55.83416748046875, 52.92193603515625 ], [ -56.060829162597656, 52.766105651855469 ], [ -55.763477325439453, 52.611244201660156 ], [ -56.487739562988281, 52.594291687011719 ], [ -55.645587921142578, 52.432872772216797 ], [ -56.189857482910156, 52.436969757080078 ], [ -55.707221984863281, 52.248329162597656 ], [ -55.699306488037109, 52.085269927978516 ], [ -56.951595306396484, 51.424575805664062 ], [ -57.73944091796875, 51.471656799316406 ], [ -58.624301910400391, 51.276382446289062 ], [ -58.623260498046875, 51.150547027587891 ], [ -58.99371337890625, 51.006103515625 ], [ -59.012920379638672, 50.751384735107422 ], [ -60.0050048828125, 50.248878479003906 ], [ -61.720832824707031, 50.091934204101562 ], [ -61.583473205566406, 50.185546875 ], [ -62.400833129882812, 50.293331146240234 ], [ -66.449028015136719, 50.267772674560547 ], [ -67.141944885253906, 49.816936492919922 ], [ -67.372077941894531, 49.329994201660156 ], [ -68.590560913085938, 49.054161071777344 ], [ -69.678329467773438, 48.140827178955078 ], [ -69.968330383300781, 48.271938323974609 ], [ -70.779998779296875, 48.435546875 ], [ -71.039581298828125, 48.443878173828125 ], [ -69.732498168945312, 48.107563018798828 ], [ -70.226112365722656, 47.497425079345703 ], [ -71.299163818359375, 46.742218017578125 ], [ -70.5069580078125, 47.020271301269531 ], [ -69.4505615234375, 47.979156494140625 ], [ -68.202224731445312, 48.639854431152344 ], [ -66.225006103515625, 49.200828552246094 ], [ -64.8255615234375, 49.187767028808594 ], [ -64.211669921875, 48.884990692138672 ], [ -64.157630920410156, 48.759857177734375 ], [ -64.530418395996094, 48.873703002929688 ], [ -64.165481567382812, 48.627765655517578 ], [ -64.246383666992188, 48.488044738769531 ], [ -65.305831909179688, 48.00555419921875 ], [ -65.896537780761719, 48.202491760253906 ], [ -66.843704223632812, 47.996650695800781 ], [ -66.35540771484375, 48.070270538330078 ], [ -65.793609619140625, 47.890830993652344 ], [ -65.63153076171875, 47.621936798095703 ], [ -64.803886413574219, 47.808185577392578 ], [ -64.6749267578125, 47.724853515625 ], [ -64.910003662109375, 47.353050231933594 ], [ -65.366180419921875, 47.085479736328125 ], [ -64.802085876464844, 47.081523895263672 ], [ -64.904304504394531, 46.845966339111328 ], [ -64.504180908203125, 46.240272521972656 ], [ -63.826255798339844, 46.145133972167969 ], [ -64.093887329101562, 46.021659851074219 ], [ -63.667079925537109, 45.816661834716797 ], [ -62.677780151367188, 45.76416015625 ], [ -62.461944580078125, 45.612495422363281 ], [ -61.919376373291016, 45.883953094482422 ], [ -61.88458251953125, 45.691307067871094 ], [ -61.468746185302734, 45.680686950683594 ], [ -61.260002136230469, 45.510276794433594 ], [ -61.460556030273438, 45.345272064208984 ], [ -60.97027587890625, 45.26971435546875 ], [ -63.444438934326172, 44.591938018798828 ], [ -63.653678894042969, 44.711174011230469 ], [ -63.520557403564453, 44.510272979736328 ], [ -63.634860992431641, 44.436378479003906 ], [ -63.93194580078125, 44.513603210449219 ], [ -63.908607482910156, 44.678047180175781 ], [ -64.087509155273438, 44.467769622802734 ], [ -64.200836181640625, 44.576385498046875 ], [ -64.337509155273438, 44.411933898925781 ], [ -64.255699157714844, 44.272628784179688 ], [ -65.48138427734375, 43.464439392089844 ], [ -66.167503356933594, 43.860828399658203 ], [ -66.118606567382812, 44.338043212890625 ], [ -65.8515625, 44.581104278564453 ], [ -66.194854736328125, 44.418045043945312 ], [ -64.39361572265625, 45.289787292480469 ], [ -64.485694885253906, 45.330268859863281 ], [ -64.320976257324219, 45.2908935546875 ], [ -64.383056640625, 45.138324737548828 ], [ -64.156387329101562, 44.978324890136719 ], [ -64.158203125, 45.189014434814453 ], [ -63.369613647460938, 45.359855651855469 ], [ -64.935340881347656, 45.331729888916016 ], [ -64.274307250976562, 45.805828094482422 ], [ -64.47833251953125, 45.75054931640625 ], [ -64.750831604003906, 46.086658477783203 ], [ -64.58306884765625, 45.826942443847656 ], [ -64.782012939453125, 45.610271453857422 ], [ -65.886810302734375, 45.208328247070312 ], [ -66.092437744140625, 45.299530029296875 ], [ -65.999931335449219, 45.459228515625 ], [ -66.191871643066406, 45.331310272216797 ], [ -66.058387756347656, 45.257553100585938 ], [ -66.427780151367188, 45.084991455078125 ], [ -67.20654296875, 45.183036804199219 ], [ -67.034439086914062, 44.984992980957031 ], [ -67.178611755371094, 44.899158477783203 ], [ -66.970832824707031, 44.827911376953125 ], [ -67.189994812011719, 44.660266876220703 ], [ -67.546035766601562, 44.666866302490234 ], [ -68.059471130371094, 44.351799011230469 ], [ -68.107917785644531, 44.454994201660156 ], [ -68.559158325195312, 44.41888427734375 ], [ -68.615829467773438, 44.306381225585938 ], [ -68.813194274902344, 44.330272674560547 ], [ -68.796867370605469, 44.574611663818359 ], [ -69.248336791992188, 43.938041687011719 ], [ -69.3699951171875, 44.046943664550781 ], [ -69.500419616699219, 43.850406646728516 ], [ -69.528610229492188, 44.024261474609375 ], [ -69.651199340820312, 43.900833129882812 ], [ -69.617324829101562, 44.038848876953125 ], [ -69.71929931640625, 43.792079925537109 ], [ -69.771598815917969, 44.074298858642578 ], [ -69.831390380859375, 43.716171264648438 ], [ -69.922225952148438, 43.864715576171875 ], [ -70.172500610351562, 43.780548095703125 ], [ -70.191871643066406, 43.575546264648438 ], [ -70.810821533203125, 42.893608093261719 ], [ -70.80596923828125, 42.715896606445312 ], [ -70.581809997558594, 42.652835845947266 ], [ -71.04486083984375, 42.367214202880859 ], [ -70.717643737792969, 42.213878631591797 ], [ -70.682220458984375, 41.997215270996094 ], [ -70.332916259765625, 41.713882446289062 ], [ -70.019309997558594, 41.792564392089844 ], [ -70.2440185546875, 42.073947906494141 ], [ -70.074172973632812, 42.058879852294922 ], [ -69.935409545898438, 41.672496795654297 ], [ -70.648612976074219, 41.539440155029297 ], [ -70.726104736328125, 41.727767944335938 ], [ -71.188323974609375, 41.46832275390625 ], [ -71.114852905273438, 41.789508819580078 ], [ -71.271392822265625, 41.653045654296875 ], [ -71.389442443847656, 41.806694030761719 ], [ -71.511672973632812, 41.369991302490234 ], [ -72.906387329101562, 41.286109924316406 ], [ -73.934158325195312, 40.798049926757812 ], [ -73.866104125976562, 41.089157104492188 ], [ -73.951278686523438, 41.304435729980469 ], [ -73.9041748046875, 40.959434509277344 ], [ -74.020980834960938, 40.717350006103516 ], [ -74.133895874023438, 40.700824737548828 ], [ -74.259170532226562, 40.522216796875 ], [ -73.956390380859375, 40.398185729980469 ], [ -74.088264465332031, 39.774852752685547 ], [ -74.045547485351562, 40.052978515625 ], [ -74.151321411132812, 39.703742980957031 ], [ -74.908340454101562, 38.927356719970703 ], [ -74.894935607910156, 39.169021606445312 ], [ -75.415695190429688, 39.378044128417969 ], [ -75.557220458984375, 39.620407104492188 ], [ -75.424308776855469, 39.782772064208984 ], [ -75.137565612792969, 39.873947143554688 ], [ -75.028518676757812, 40.012306213378906 ], [ -75.459442138671875, 39.788330078125 ], [ -75.604438781738281, 39.614021301269531 ], [ -75.572158813476562, 39.452907562255859 ], [ -75.044578552246094, 38.417213439941406 ], [ -75.960830688476562, 37.152214050292969 ], [ -75.930557250976562, 37.576103210449219 ], [ -75.64404296875, 37.961174011230469 ], [ -75.878532409667969, 37.947559356689453 ], [ -75.846351623535156, 38.398777008056641 ], [ -76.037506103515625, 38.226654052734375 ], [ -76.24249267578125, 38.366935729980469 ], [ -76.265289306640625, 38.619712829589844 ], [ -76.028472900390625, 38.573745727539062 ], [ -75.960975646972656, 38.651588439941406 ], [ -76.342155456542969, 38.688255310058594 ], [ -76.255172729492188, 38.841033935546875 ], [ -76.104438781738281, 38.799091339111328 ], [ -76.224655151367188, 38.964088439941406 ], [ -76.35986328125, 38.855411529541016 ], [ -76.072463989257812, 39.141658782958984 ], [ -76.220840454101562, 39.060821533203125 ], [ -76.1683349609375, 39.316520690917969 ], [ -75.835350036621094, 39.571937561035156 ], [ -76.359725952148438, 39.399993896484375 ], [ -76.416397094726562, 39.209716796875 ], [ -76.610519409179688, 39.250373840332031 ], [ -76.393890380859375, 39.011035919189453 ], [ -76.537506103515625, 38.731658935546875 ], [ -76.378570556640625, 38.365203857421875 ], [ -76.679161071777344, 38.662525177001953 ], [ -76.663467407226562, 38.474712371826172 ], [ -76.371109008789062, 38.288330078125 ], [ -76.312347412109375, 38.04730224609375 ], [ -77.044448852539062, 38.438320159912109 ], [ -77.243743896484375, 38.398258209228516 ], [ -77.006118774414062, 38.754997253417969 ], [ -77.016807556152344, 38.864299774169922 ], [ -77.061691284179688, 38.904571533203125 ], [ -77.32000732421875, 38.345268249511719 ], [ -77.068748474121094, 38.379016876220703 ], [ -76.243614196777344, 37.906101226806641 ], [ -76.353607177734375, 37.618598937988281 ], [ -76.93194580078125, 38.089714050292969 ], [ -77.129890441894531, 38.169120788574219 ], [ -76.290695190429688, 37.568607330322266 ], [ -76.23944091796875, 37.373462677001953 ], [ -76.376487731933594, 37.280513763427734 ], [ -76.682769775390625, 37.429718017578125 ], [ -76.267715454101562, 37.086311340332031 ], [ -76.389724731445312, 36.973320007324219 ], [ -76.653884887695312, 37.226936340332031 ], [ -76.990272521972656, 37.312908172607422 ], [ -77.232223510742188, 37.29638671875 ], [ -76.293609619140625, 36.84332275390625 ], [ -76.255142211914062, 36.957912445068359 ], [ -75.987289428710938, 36.909229278564453 ], [ -75.532646179199219, 35.801521301269531 ], [ -75.945304870605469, 36.712421417236328 ], [ -75.899581909179688, 36.492771148681641 ], [ -76.03472900390625, 36.496658325195312 ], [ -75.79315185546875, 36.073848724365234 ], [ -75.976036071777344, 36.311378479003906 ], [ -75.926536560058594, 36.170890808105469 ], [ -76.199653625488281, 36.317390441894531 ], [ -76.070968627929688, 36.149295806884766 ], [ -76.51861572265625, 36.006938934326172 ], [ -76.746101379394531, 36.228183746337891 ], [ -76.729515075683594, 35.939849853515625 ], [ -76.026527404785156, 35.962215423583984 ], [ -76.103195190429688, 35.660408020019531 ], [ -75.850830078125, 35.975269317626953 ], [ -75.720832824707031, 35.814506530761719 ], [ -75.740760803222656, 35.618465423583984 ], [ -76.149169921875, 35.336936950683594 ], [ -76.496109008789062, 35.384719848632812 ], [ -76.58819580078125, 35.551033020019531 ], [ -76.652496337890625, 35.414993286132812 ], [ -77.049583435058594, 35.526939392089844 ], [ -76.468887329101562, 35.271659851074219 ], [ -76.761398315429688, 34.987770080566406 ], [ -77.068161010742188, 35.1497802734375 ], [ -76.965011596679688, 34.997772216796875 ], [ -76.753067016601562, 34.905265808105469 ], [ -76.453567504882812, 35.066761016845703 ], [ -76.453193664550781, 34.935234069824219 ], [ -76.271812438964844, 34.962631225585938 ], [ -76.34326171875, 34.881938934326172 ], [ -77.309577941894531, 34.559715270996094 ], [ -77.428878784179688, 34.741935729980469 ], [ -77.381729125976562, 34.516452789306641 ], [ -77.705276489257812, 34.341934204101562 ], [ -77.934432983398438, 33.92694091796875 ], [ -77.927284240722656, 34.117561340332031 ], [ -77.95562744140625, 34.149017333984375 ], [ -78.025970458984375, 33.889366149902344 ], [ -78.827499389648438, 33.730270385742188 ], [ -79.196441650390625, 33.278938293457031 ], [ -79.271392822265625, 33.373321533203125 ], [ -79.205841064453125, 33.165542602539062 ], [ -79.388336181640625, 33.008190155029297 ], [ -79.815826416015625, 32.7672119140625 ], [ -79.942634582519531, 32.853466033935547 ], [ -79.877983093261719, 32.694850921630859 ], [ -80.327720642089844, 32.48040771484375 ], [ -80.669303894042969, 32.522911071777344 ], [ -80.465003967285156, 32.317493438720703 ], [ -80.631378173828125, 32.256385803222656 ], [ -80.832366943359375, 32.519992828369141 ], [ -80.672286987304688, 32.217075347900391 ], [ -81.165901184082031, 31.564857482910156 ], [ -81.329025268554688, 31.554788589477539 ], [ -81.204727172851562, 31.474716186523438 ], [ -81.284233093261719, 31.221244812011719 ], [ -81.488433837890625, 31.113468170166016 ], [ -81.255279541015625, 29.796665191650391 ], [ -80.552490234375, 28.524997711181641 ], [ -80.4466552734375, 27.86444091796875 ], [ -80.603195190429688, 28.608608245849609 ], [ -80.843612670898438, 28.780969619750977 ], [ -80.757232666015625, 28.420690536499023 ], [ -80.03533935546875, 26.795690536499023 ], [ -80.397506713867188, 25.186655044555664 ], [ -81.146675109863281, 25.160411834716797 ], [ -81.135612487792969, 25.320537567138672 ], [ -80.9178466796875, 25.246871948242188 ], [ -81.340904235839844, 25.809719085693359 ], [ -81.736587524414062, 25.959442138671875 ], [ -81.969306945800781, 26.481828689575195 ], [ -81.785934448242188, 26.706903457641602 ], [ -82.02337646484375, 26.529218673706055 ], [ -82.017227172851562, 26.964717864990234 ], [ -82.191940307617188, 26.93804931640625 ], [ -82.158889770507812, 26.782878875732422 ], [ -82.396392822265625, 26.962356567382812 ], [ -82.6552734375, 27.461662292480469 ], [ -82.424163818359375, 27.919439315795898 ], [ -82.691246032714844, 28.029857635498047 ], [ -82.595069885253906, 27.821872711181641 ], [ -82.724723815917969, 27.658050537109375 ], [ -82.854164123535156, 27.858608245849609 ], [ -82.62860107421875, 28.696384429931641 ], [ -82.802780151367188, 29.154994964599609 ], [ -83.071670532226562, 29.224437713623047 ], [ -84.010978698730469, 30.097637176513672 ], [ -85.357086181640625, 29.677772521972656 ], [ -85.412223815917969, 29.793746948242188 ], [ -85.399200439453125, 29.864681243896484 ], [ -85.347114562988281, 29.686973571777344 ], [ -85.307212829589844, 29.815969467163086 ], [ -85.62939453125, 30.10462760925293 ], [ -85.476951599121094, 30.025829315185547 ], [ -85.393890380859375, 30.041524887084961 ], [ -85.7469482421875, 30.297218322753906 ], [ -85.845550537109375, 30.247079849243164 ], [ -85.725555419921875, 30.125827789306641 ], [ -86.337364196777344, 30.384439468383789 ], [ -86.104232788085938, 30.379093170166016 ], [ -86.260002136230469, 30.495828628540039 ], [ -87.1260986328125, 30.363883972167969 ], [ -86.936386108398438, 30.449996948242188 ], [ -87.160835266113281, 30.51777458190918 ], [ -87.306655883789062, 30.321384429931641 ], [ -87.522560119628906, 30.279293060302734 ], [ -87.340835571289062, 30.434577941894531 ], [ -87.420394897460938, 30.480945587158203 ], [ -87.568618774414062, 30.279441833496094 ], [ -87.733612060546875, 30.234992980957031 ], [ -88.021354675292969, 30.225479125976562 ], [ -87.757713317871094, 30.282428741455078 ], [ -88.020278930664062, 30.701107025146484 ], [ -88.131454467773438, 30.318954467773438 ], [ -88.9808349609375, 30.418327331542969 ], [ -89.593124389648438, 30.15325927734375 ], [ -90.236251831054688, 30.376523971557617 ], [ -90.427909851074219, 30.178606033325195 ], [ -90.3497314453125, 30.061664581298828 ], [ -89.673538208007812, 30.167148590087891 ], [ -89.84375, 30.007081985473633 ], [ -89.625694274902344, 29.873397827148438 ], [ -89.399444580078125, 30.050830841064453 ], [ -89.4041748046875, 29.762496948242188 ], [ -89.752716064453125, 29.632980346679688 ], [ -89.008758544921875, 29.174161911010742 ], [ -89.404998779296875, 28.926662445068359 ], [ -89.272018432617188, 29.149648666381836 ], [ -89.389579772949219, 29.092081069946289 ], [ -90.1824951171875, 29.569858551025391 ], [ -90.026527404785156, 29.425134658813477 ], [ -90.209442138671875, 29.091108322143555 ], [ -90.444442749023438, 29.326107025146484 ], [ -90.7650146484375, 29.109439849853516 ], [ -91.254867553710938, 29.244300842285156 ], [ -91.339309692382812, 29.324718475341797 ], [ -91.12652587890625, 29.347358703613281 ], [ -91.838821411132812, 29.82826042175293 ], [ -92.14862060546875, 29.768886566162109 ], [ -92.0997314453125, 29.615550994873047 ], [ -92.308334350585938, 29.539718627929688 ], [ -93.240829467773438, 29.784996032714844 ], [ -93.850486755371094, 29.70881462097168 ], [ -93.796661376953125, 29.994159698486328 ], [ -93.958473205566406, 29.816661834716797 ], [ -93.858436584472656, 29.681625366210938 ], [ -94.754173278808594, 29.367912292480469 ], [ -94.476593017578125, 29.55888557434082 ], [ -94.765838623046875, 29.56805419921875 ], [ -94.75701904296875, 29.784997940063477 ], [ -95.060066223144531, 29.715063095092773 ], [ -94.887504577636719, 29.385274887084961 ], [ -95.086944580078125, 29.181940078735352 ], [ -95.148612976074219, 29.051248550415039 ], [ -96.212013244628906, 28.488119125366211 ], [ -95.990684509277344, 28.651037216186523 ], [ -96.644729614257812, 28.711938858032227 ], [ -96.399971008300781, 28.441730499267578 ], [ -96.659309387207031, 28.315206527709961 ], [ -96.800338745117188, 28.471521377563477 ], [ -96.882766723632812, 28.140274047851562 ], [ -97.16937255859375, 28.161800384521484 ], [ -97.022499084472656, 28.031665802001953 ], [ -97.194511413574219, 27.821802139282227 ], [ -97.51708984375, 27.863815307617188 ], [ -97.27972412109375, 27.656105041503906 ], [ -97.412986755371094, 27.327287673950195 ], [ -97.769340515136719, 27.449716567993164 ], [ -97.633888244628906, 27.252496719360352 ], [ -97.429367065429688, 27.262289047241211 ], [ -97.560409545898438, 26.842081069946289 ], [ -97.137504577636719, 25.933193206787109 ], [ -97.65167236328125, 24.520275115966797 ], [ -97.74139404296875, 22.905830383300781 ], [ -97.888267517089844, 22.598817825317383 ], [ -97.697921752929688, 21.974721908569336 ], [ -97.315010070800781, 21.556524276733398 ], [ -97.413475036621094, 21.271734237670898 ], [ -97.372917175292969, 21.543539047241211 ], [ -97.742233276367188, 22.012496948242188 ], [ -97.17535400390625, 20.683956146240234 ], [ -96.460006713867188, 19.877498626708984 ], [ -96.2952880859375, 19.341108322143555 ], [ -95.801116943359375, 18.744998931884766 ], [ -95.182228088378906, 18.701803207397461 ], [ -94.46917724609375, 18.146247863769531 ], [ -93.587089538574219, 18.42138671875 ], [ -93.129867553710938, 18.339580535888672 ], [ -92.004173278808594, 18.726247787475586 ], [ -91.858619689941406, 18.615694046020508 ], [ -92.035842895507812, 18.592636108398438 ], [ -92.041954040527344, 18.55999755859375 ], [ -91.813125610351562, 18.382637023925781 ], [ -91.495704650878906, 18.435554504394531 ], [ -91.186187744140625, 18.650068283081055 ], [ -91.38507080078125, 18.907358169555664 ], [ -90.731674194335938, 19.361526489257812 ], [ -90.676673889160156, 19.768329620361328 ], [ -90.455276489257812, 19.975971221923828 ], [ -90.455909729003906, 20.732290267944336 ], [ -90.27972412109375, 21.063053131103516 ], [ -88.147789001464844, 21.608055114746094 ], [ -87.249176025390625, 21.441387176513672 ], [ -87.133827209472656, 21.557220458984375 ], [ -87.410774230957031, 21.528610229492188 ], [ -87.07861328125, 21.606109619140625 ], [ -86.829727172851562, 21.429233551025391 ], [ -86.913070678710938, 20.80194091796875 ], [ -87.425559997558594, 20.222776412963867 ], [ -87.47222900390625, 20.085971832275391 ], [ -87.444808959960938, 19.900192260742188 ], [ -87.46905517578125, 19.849023818969727 ], [ -87.449478149414062, 19.926441192626953 ], [ -87.4818115234375, 19.950727462768555 ], [ -87.736602783203125, 19.677568435668945 ], [ -87.65771484375, 19.505552291870117 ], [ -87.412223815917969, 19.5816650390625 ], [ -87.676948547363281, 19.314998626708984 ], [ -87.488616943359375, 19.291385650634766 ], [ -87.847503662109375, 18.190830230712891 ], [ -88.073333740234375, 18.493610382080078 ], [ -88.039726257324219, 18.868192672729492 ], [ -88.29949951171875, 18.482929229736328 ], [ -88.077789306640625, 18.215553283691406 ], [ -88.282501220703125, 17.623886108398438 ], [ -88.168785095214844, 17.499107360839844 ], [ -88.298614501953125, 17.238330841064453 ], [ -88.213340759277344, 16.962081909179688 ], [ -88.361289978027344, 16.501768112182617 ], [ -88.34722900390625, 16.602775573730469 ], [ -88.910568237304688, 15.893610000610352 ], [ -88.618064880371094, 15.698539733886719 ], [ -88.5513916015625, 15.940832138061523 ], [ -88.136955261230469, 15.682846069335938 ], [ -87.707778930664062, 15.921282768249512 ], [ -87.474449157714844, 15.784442901611328 ], [ -86.3577880859375, 15.769444465637207 ], [ -85.910148620605469, 15.955832481384277 ], [ -86.011604309082031, 16.021629333496094 ], [ -84.260147094726562, 15.825970649719238 ], [ -83.855560302734375, 15.459999084472656 ], [ -84.209518432617188, 15.545658111572266 ], [ -84.074455261230469, 15.349164962768555 ], [ -83.830070495605469, 15.270971298217773 ], [ -83.963897705078125, 15.407638549804688 ], [ -83.7711181640625, 15.280207633972168 ], [ -83.758346557617188, 15.196664810180664 ], [ -83.531402587890625, 15.268888473510742 ], [ -83.570419311523438, 15.158123970031738 ], [ -83.507225036621094, 15.28055477142334 ], [ -83.616683959960938, 15.347245216369629 ], [ -83.393478393554688, 15.256387710571289 ], [ -83.131851196289062, 14.992979049682617 ], [ -83.419105529785156, 14.809443473815918 ], [ -83.18695068359375, 14.323888778686523 ], [ -83.513336181640625, 13.635555267333984 ], [ -83.478485107421875, 12.423888206481934 ], [ -83.632713317871094, 12.479581832885742 ], [ -83.537094116210938, 12.770693778991699 ], [ -83.602920532226562, 12.818192481994629 ], [ -83.676956176757812, 12.050554275512695 ], [ -83.828094482421875, 11.875831604003906 ], [ -83.6534423828125, 11.602810859680176 ], [ -83.847511291503906, 11.174582481384277 ], [ -83.104866027832031, 10.009720802307129 ], [ -82.363616943359375, 9.407220840454102 ], [ -82.242782592773438, 9.002359390258789 ], [ -81.816390991210938, 8.945276260375977 ], [ -81.886329650878906, 9.173609733581543 ], [ -81.507293701171875, 8.793123245239258 ], [ -81.153060913085938, 8.787498474121094 ], [ -80.117507934570312, 9.206943511962891 ], [ -79.534454345703125, 9.620138168334961 ], [ -78.034385681152344, 9.228817939758301 ], [ -77.366668701171875, 8.674999237060547 ], [ -77.468582153320312, 8.471699714660645 ], [ -77.215560913085938, 7.937221527099609 ], [ -77.577438354492188, 7.526180267333984 ], [ -77.744033813476562, 7.719999313354492 ], [ -77.889724731445312, 7.228888511657715 ], [ -78.432785034179688, 8.048887252807617 ], [ -78.257232666015625, 8.101943969726562 ], [ -78.143638610839844, 8.401669502258301 ], [ -77.995193481445312, 8.23245906829834 ], [ -77.7791748046875, 8.154998779296875 ], [ -78.107513427734375, 8.455831527709961 ], [ -78.413063049316406, 8.343609809875488 ], [ -78.507232666015625, 8.616943359375 ], [ -79.053070068359375, 8.966665267944336 ], [ -78.979103088378906, 9.138540267944336 ], [ -79.697784423828125, 8.866664886474609 ], [ -79.952789306640625, 8.450832366943359 ], [ -80.471260070800781, 8.215554237365723 ], [ -80.002296447753906, 7.46840238571167 ], [ -80.851119995117188, 7.210277557373047 ], [ -81.058059692382812, 7.873332977294922 ], [ -81.217926025390625, 7.608263492584229 ], [ -81.4969482421875, 7.698610305786133 ], [ -81.738616943359375, 8.162498474121094 ], [ -82.2872314453125, 8.313331604003906 ], [ -82.807510375976562, 8.293054580688477 ], [ -82.898849487304688, 8.025669097900391 ], [ -83.344032287597656, 8.728055000305176 ], [ -83.480422973632812, 8.704546928405762 ], [ -83.279457092285156, 8.37763786315918 ], [ -83.595565795898438, 8.468332290649414 ], [ -83.73583984375, 8.612499237060547 ], [ -83.62646484375, 9.036457061767578 ], [ -84.618614196777344, 9.57944393157959 ], [ -84.707504272460938, 9.918333053588867 ], [ -85.070022583007812, 10.155340194702148 ], [ -85.238548278808594, 10.107290267944336 ], [ -84.897232055664062, 9.807498931884766 ], [ -85.142227172851562, 9.589443206787109 ], [ -85.345001220703125, 9.83277702331543 ], [ -85.65667724609375, 9.904998779296875 ], [ -85.857513427734375, 10.369442939758301 ], [ -85.63250732421875, 10.621665954589844 ], [ -85.911392211914062, 10.891109466552734 ], [ -85.669586181640625, 11.054998397827148 ], [ -87.689826965332031, 12.917707443237305 ], [ -87.557502746582031, 13.051248550415039 ], [ -87.418060302734375, 12.915833473205566 ], [ -87.297782897949219, 12.922117233276367 ], [ -87.511810302734375, 13.277290344238281 ], [ -87.398338317871094, 13.412359237670898 ], [ -87.836952209472656, 13.436318397521973 ], [ -87.937789916992188, 13.156387329101562 ], [ -88.220001220703125, 13.158054351806641 ], [ -88.550430297851562, 13.273957252502441 ], [ -88.708168029785156, 13.26093578338623 ], [ -88.535064697265625, 13.19911003112793 ], [ -89.81854248046875, 13.535797119140625 ], [ -90.492233276367188, 13.900276184082031 ], [ -91.384735107421875, 13.978887557983398 ], [ -92.218902587890625, 14.521665573120117 ], [ -92.770492553710938, 15.171596527099609 ], [ -93.938613891601562, 16.093887329101562 ], [ -94.400291442871094, 16.295553207397461 ], [ -94.052642822265625, 16.047637939453125 ], [ -94.691253662109375, 16.190690994262695 ], [ -94.578826904296875, 16.315206527709961 ], [ -94.791534423828125, 16.260066986083984 ], [ -94.859176635742188, 16.427082061767578 ], [ -95.062675476074219, 16.272115707397461 ], [ -94.8577880859375, 16.215831756591797 ], [ -96.476119995117188, 15.643610000610352 ], [ -97.79278564453125, 15.97208309173584 ], [ -98.7822265625, 16.553054809570312 ], [ -99.685981750488281, 16.706943511962891 ], [ -101.011123657226562, 17.265274047851562 ], [ -101.952789306640625, 17.978469848632812 ], [ -102.1702880859375, 17.918331146240234 ], [ -103.45001220703125, 18.313610076904297 ], [ -103.971946716308594, 18.877220153808594 ], [ -104.951683044433594, 19.315277099609375 ], [ -105.678337097167969, 20.383054733276367 ], [ -105.244728088378906, 20.574649810791016 ], [ -105.321807861328125, 20.765483856201172 ], [ -105.536186218261719, 20.792568206787109 ], [ -105.241386413574219, 21.064720153808594 ], [ -105.189453125, 21.437496185302734 ], [ -105.650276184082031, 21.98124885559082 ], [ -105.820426940917969, 22.664024353027344 ], [ -106.915695190429688, 23.865137100219727 ], [ -107.727729797363281, 24.471126556396484 ], [ -107.596405029296875, 24.428247451782227 ], [ -107.618034362792969, 24.517204284667969 ], [ -107.995491027832031, 24.64909553527832 ], [ -107.990005493164062, 24.959510803222656 ], [ -108.104171752929688, 24.821941375732422 ], [ -108.221260070800781, 25.029441833496094 ], [ -108.042510986328125, 25.0736083984375 ], [ -108.394180297851562, 25.141109466552734 ], [ -108.765289306640625, 25.539302825927734 ], [ -109.108901977539062, 25.526107788085938 ], [ -108.970291137695312, 25.564441680908203 ], [ -108.834930419921875, 25.793607711791992 ], [ -109.141044616699219, 25.583053588867188 ], [ -109.4375, 25.820274353027344 ], [ -109.231666564941406, 26.319442749023438 ], [ -109.103897094726562, 26.283607482910156 ], [ -109.444313049316406, 26.715553283691406 ], [ -109.753890991210938, 26.696109771728516 ], [ -109.949043273925781, 27.093469619750977 ], [ -110.529716491699219, 27.371109008789062 ], [ -110.634590148925781, 27.662359237670898 ], [ -110.511360168457031, 27.854997634887695 ], [ -111.103340148925781, 27.936943054199219 ], [ -112.161949157714844, 28.97138786315918 ], [ -112.213478088378906, 29.306108474731445 ], [ -113.081390380859375, 30.698886871337891 ], [ -113.0916748046875, 31.229719161987305 ], [ -113.589736938476562, 31.3316650390625 ], [ -113.974693298339844, 31.655693054199219 ], [ -114.020843505859375, 31.497636795043945 ], [ -114.217506408691406, 31.522220611572266 ], [ -115.031143188476562, 31.959997177124023 ], [ -114.786666870117188, 31.664165496826172 ], [ -114.880699157714844, 31.151664733886719 ], [ -114.706390380859375, 30.927497863769531 ], [ -114.5452880859375, 30.001110076904297 ], [ -113.667922973632812, 29.284164428710938 ], [ -113.508750915527344, 28.896247863769531 ], [ -113.194931030273438, 28.813816070556641 ], [ -113.11590576171875, 28.486455917358398 ], [ -112.863197326660156, 28.41850471496582 ], [ -112.753059387207031, 27.837497711181641 ], [ -112.346672058105469, 27.541385650634766 ], [ -111.858612060546875, 26.661941528320312 ], [ -111.687507629394531, 26.600587844848633 ], [ -111.844993591308594, 26.902080535888672 ], [ -111.561882019042969, 26.719650268554688 ], [ -111.299728393554688, 25.780277252197266 ], [ -110.686256408691406, 24.896387100219727 ], [ -110.691184997558594, 24.386873245239258 ], [ -110.354171752929688, 24.115833282470703 ], [ -110.210006713867188, 24.348194122314453 ], [ -109.799728393554688, 24.012218475341797 ], [ -109.682510375976562, 23.656665802001953 ], [ -109.407501220703125, 23.461248397827148 ], [ -109.438896179199219, 23.225831985473633 ], [ -109.998191833496094, 22.881942749023438 ], [ -110.311187744140625, 23.560691833496094 ], [ -112.087509155273438, 24.756107330322266 ], [ -112.100143432617188, 25.728054046630859 ], [ -112.378341674804688, 26.254997253417969 ], [ -113.215011596679688, 26.703332901000977 ], [ -113.1309814453125, 26.959997177124023 ], [ -113.275253295898438, 26.78135871887207 ], [ -113.598823547363281, 26.739582061767578 ], [ -114.475494384765625, 27.238054275512695 ], [ -115.023063659667969, 27.768608093261719 ], [ -113.985008239746094, 27.700832366943359 ], [ -114.307640075683594, 27.865924835205078 ], [ -114.128555297851562, 28.023658752441406 ], [ -114.061317443847656, 28.517568588256836 ], [ -114.94598388671875, 29.37388801574707 ], [ -115.696670532226562, 29.774232864379883 ], [ -116.055488586425781, 30.796524047851562 ], [ -116.675628662109375, 31.560760498046875 ], [ -116.608131408691406, 31.844511032104492 ], [ -116.864173889160156, 32.021385192871094 ], [ -117.141387939453125, 32.680614471435547 ], [ -117.254989624023438, 32.657138824462891 ], [ -117.409439086914062, 33.244155883789062 ], [ -118.108184814453125, 33.756938934326172 ], [ -118.400016784667969, 33.749855041503906 ], [ -118.530006408691406, 34.04791259765625 ], [ -119.129173278808594, 34.113883972167969 ], [ -119.541671752929688, 34.414154052734375 ], [ -120.605827331542969, 34.558601379394531 ], [ -120.618194580078125, 35.139438629150391 ], [ -121.867630004882812, 36.315338134765625 ], [ -121.943252563476562, 36.594573974609375 ], [ -121.799163818359375, 36.884017944335938 ], [ -122.379020690917969, 37.199989318847656 ], [ -122.490280151367188, 37.529991149902344 ], [ -122.379638671875, 37.813812255859375 ], [ -122.357772827148438, 37.615825653076172 ], [ -122.064300537109375, 37.459297180175781 ], [ -122.005836486816406, 37.47137451171875 ], [ -122.393409729003906, 37.959159851074219 ], [ -122.225273132324219, 38.064159393310547 ], [ -121.427215576171875, 38.012908935546875 ], [ -122.365280151367188, 38.155548095703125 ], [ -122.505485534667969, 37.831039428710938 ], [ -122.956390380859375, 38.05804443359375 ], [ -122.803047180175781, 38.081939697265625 ], [ -123.701522827148438, 38.930412292480469 ], [ -123.86749267578125, 39.869155883789062 ], [ -124.331184387207031, 40.272457122802734 ], [ -124.039993286132812, 41.427772521972656 ], [ -124.524436950683594, 42.866104125976562 ], [ -124.378532409667969, 43.319019317626953 ], [ -124.142784118652344, 43.371692657470703 ], [ -124.302490234375, 43.400543212890625 ], [ -124.115829467773438, 43.725265502929688 ], [ -123.871612548828125, 45.528980255126953 ], [ -123.951950073242188, 46.181106567382812 ], [ -123.506256103515625, 46.250133514404297 ], [ -123.263473510742188, 46.144855499267578 ], [ -123.16357421875, 46.1951904296875 ], [ -123.430412292480469, 46.286937713623047 ], [ -124.0, 46.3236083984375 ], [ -124.038749694824219, 46.656654357910156 ], [ -123.941246032714844, 46.392978668212891 ], [ -123.940826416015625, 46.63665771484375 ], [ -123.75946044921875, 46.685623168945312 ], [ -124.097503662109375, 46.861381530761719 ], [ -123.801246643066406, 46.976791381835938 ], [ -124.074996948242188, 47.066246032714844 ], [ -124.164169311523438, 46.946380615234375 ], [ -124.714309692382812, 48.397075653076172 ], [ -123.934722900390625, 48.175827026367188 ], [ -122.749435424804688, 48.153949737548828 ], [ -122.630279541015625, 47.915824890136719 ], [ -122.747772216796875, 47.763053894042969 ], [ -122.849296569824219, 47.831378936767578 ], [ -123.147926330566406, 47.371654510498047 ], [ -123.006668090820312, 47.368465423583984 ], [ -122.876106262207031, 47.414993286132812 ], [ -123.097496032714844, 47.400825500488281 ], [ -122.51409912109375, 47.922073364257812 ], [ -122.460037231445312, 47.763740539550781 ], [ -122.680831909179688, 47.639228820800781 ], [ -122.536521911621094, 47.593181610107422 ], [ -122.547767639160156, 47.288047790527344 ], [ -122.619163513183594, 47.420547485351562 ], [ -122.74896240234375, 47.189296722412109 ], [ -122.797500610351562, 47.395271301269531 ], [ -123.064857482910156, 47.113883972167969 ], [ -122.639717102050781, 47.151931762695312 ], [ -122.31353759765625, 47.371795654296875 ], [ -122.418327331542969, 47.672218322753906 ], [ -122.291099548339844, 47.958187103271484 ], [ -122.374404907226562, 48.213428497314453 ], [ -122.528465270996094, 48.182907104492188 ], [ -122.392845153808594, 48.309436798095703 ], [ -122.590950012207031, 48.425792694091797 ], [ -122.679580688476562, 48.418323516845703 ], [ -122.486244201660156, 48.452701568603516 ], [ -122.5, 48.744853973388672 ], [ -122.867561340332031, 49.079124450683594 ], [ -123.086532592773438, 48.972072601318359 ], [ -123.207366943359375, 49.125408172607422 ], [ -123.247909545898438, 49.272495269775391 ], [ -122.918060302734375, 49.290828704833984 ], [ -122.855133056640625, 49.438114166259766 ], [ -123.23638916015625, 49.338882446289062 ], [ -123.165618896484375, 49.701171875 ], [ -123.491661071777344, 49.508399963378906 ], [ -123.516532897949219, 49.385475158691406 ], [ -123.961677551269531, 49.511940002441406 ], [ -123.992774963378906, 49.740966796875 ], [ -123.791595458984375, 49.510135650634766 ], [ -123.5357666015625, 49.697105407714844 ], [ -123.806381225585938, 49.643535614013672 ], [ -123.934715270996094, 49.776100158691406 ], [ -123.872840881347656, 49.872421264648438 ], [ -123.956809997558594, 49.957630157470703 ], [ -123.74896240234375, 50.085063934326172 ], [ -123.987213134765625, 50.210929870605469 ], [ -123.813606262207031, 50.090686798095703 ], [ -123.998397827148438, 50.002220153808594 ], [ -123.982215881347656, 49.803741455078125 ], [ -124.035102844238281, 49.918010711669922 ], [ -124.432777404785156, 49.767635345458984 ], [ -124.741943359375, 49.958328247070312 ], [ -124.818092346191406, 50.063919067382812 ], [ -124.703338623046875, 49.99554443359375 ], [ -124.602912902832031, 50.240409851074219 ], [ -124.713066101074219, 50.323810577392578 ], [ -124.356521606445312, 50.495929718017578 ], [ -125.075286865234375, 50.320968627929688 ], [ -124.85888671875, 50.588184356689453 ], [ -124.806938171386719, 50.919578552246094 ], [ -125.117462158203125, 50.438045501708984 ], [ -125.548484802246094, 50.497585296630859 ], [ -125.467987060546875, 50.71124267578125 ], [ -125.703681945800781, 50.42950439453125 ], [ -126.276947021484375, 50.516311645507812 ], [ -126.186126708984375, 50.557361602783203 ], [ -126.270210266113281, 50.627353668212891 ], [ -125.738327026367188, 50.682212829589844 ], [ -125.620132446289062, 50.752082824707031 ], [ -125.507858276367188, 50.941482543945312 ], [ -125.610816955566406, 51.0877685546875 ], [ -125.731109619140625, 50.735549926757812 ], [ -126.135566711425781, 50.681533813476562 ], [ -126.198883056640625, 50.855827331542969 ], [ -126.557289123535156, 50.840339660644531 ], [ -126.488395690917969, 50.917701721191406 ], [ -126.246383666992188, 50.898605346679688 ], [ -126.179298400878906, 50.948043823242188 ], [ -127.173149108886719, 50.922214508056641 ], [ -127.018608093261719, 50.818470001220703 ], [ -127.537429809570312, 51.005691528320312 ], [ -126.821731567382812, 51.065883636474609 ], [ -126.689308166503906, 51.112632751464844 ], [ -126.657638549804688, 51.190334320068359 ], [ -127.199577331542969, 51.056797027587891 ], [ -127.789993286132812, 51.165542602539062 ], [ -127.132568359375, 51.328464508056641 ], [ -127.767562866210938, 51.321174621582031 ], [ -127.551666259765625, 51.46832275390625 ], [ -127.496391296386719, 51.614299774169922 ], [ -126.708053588867188, 51.641937255859375 ], [ -126.620002746582031, 51.67999267578125 ], [ -126.6602783203125, 51.792221069335938 ], [ -126.698051452636719, 51.664573669433594 ], [ -127.4375, 51.675235748291016 ], [ -127.347251892089844, 51.857944488525391 ], [ -127.659156799316406, 51.457496643066406 ], [ -127.876106262207031, 51.668601989746094 ], [ -127.864776611328125, 51.900894165039062 ], [ -127.174644470214844, 52.309158325195312 ], [ -126.675407409667969, 51.990894317626953 ], [ -126.940826416015625, 52.303878784179688 ], [ -126.734298706054688, 52.371517181396484 ], [ -127.228057861328125, 52.453048706054688 ], [ -126.922775268554688, 52.722629547119141 ], [ -126.974166870117188, 52.833671569824219 ], [ -127.614990234375, 52.293327331542969 ], [ -127.873046875, 52.223320007324219 ], [ -127.893394470214844, 52.511451721191406 ], [ -128.00701904296875, 52.337421417236328 ], [ -128.067642211914062, 52.450824737548828 ], [ -127.883674621582031, 52.577358245849609 ], [ -128.393890380859375, 52.2913818359375 ], [ -128.222000122070312, 52.470199584960938 ], [ -128.13165283203125, 52.876380920410156 ], [ -128.438613891601562, 52.820827484130859 ], [ -128.53973388671875, 53.131935119628906 ], [ -128.8538818359375, 53.279716491699219 ], [ -128.969573974609375, 53.553184509277344 ], [ -128.52362060546875, 53.396659851074219 ], [ -128.131927490234375, 53.448875427246094 ], [ -127.9486083984375, 53.254302978515625 ], [ -127.870925903320312, 53.237174987792969 ], [ -128.126922607421875, 53.481101989746094 ], [ -128.814849853515625, 53.621238708496094 ], [ -128.77056884765625, 53.795829772949219 ], [ -128.476715087890625, 53.838535308837891 ], [ -128.678863525390625, 53.909191131591797 ], [ -128.606170654296875, 54.02978515625 ], [ -129.217498779296875, 53.640274047851562 ], [ -129.272796630859375, 53.379158020019531 ], [ -130.100265502929688, 53.944293975830078 ], [ -130.049163818359375, 54.150962829589844 ], [ -129.614166259765625, 54.178916931152344 ], [ -129.474288940429688, 54.239364624023438 ], [ -130.117904663085938, 54.154987335205078 ], [ -130.481109619140625, 54.364715576171875 ], [ -130.411880493164062, 54.628742218017578 ], [ -130.060409545898438, 54.338047027587891 ], [ -129.960128784179688, 54.319644927978516 ], [ -130.371368408203125, 54.661380767822266 ], [ -129.9102783203125, 54.605552673339844 ], [ -130.19964599609375, 54.728809356689453 ], [ -130.16790771484375, 54.854087829589844 ], [ -129.623748779296875, 55.000133514404297 ], [ -129.975555419921875, 55.066940307617188 ], [ -129.478179931640625, 55.470752716064453 ], [ -129.786956787109375, 55.566665649414062 ], [ -129.815704345703125, 55.286525726318359 ], [ -130.109024047851562, 54.993949890136719 ], [ -129.946380615234375, 55.285408020019531 ], [ -130.128311157226562, 55.7359619140625 ], [ -129.995407104492188, 55.926589965820312 ], [ -130.1744384765625, 55.757217407226562 ], [ -129.99365234375, 55.281036376953125 ], [ -130.365966796875, 54.904434204101562 ], [ -130.709259033203125, 54.767875671386719 ], [ -130.742660522460938, 54.955093383789062 ], [ -130.8377685546875, 54.767284393310547 ], [ -130.982208251953125, 55.051101684570312 ], [ -130.702789306640625, 55.116935729980469 ], [ -130.474151611328125, 55.325931549072266 ], [ -130.727783203125, 55.126380920410156 ], [ -131.058761596679688, 55.127487182617188 ], [ -130.931533813476562, 55.284645080566406 ], [ -130.616104125976562, 55.294300079345703 ], [ -130.86126708984375, 55.310062408447266 ], [ -130.886398315429688, 55.707908630371094 ], [ -131.169464111328125, 55.941658020019531 ], [ -131.012786865234375, 56.106521606445312 ], [ -131.90057373046875, 55.855270385742188 ], [ -131.759109497070312, 55.814090728759766 ], [ -131.954986572265625, 55.501106262207031 ], [ -132.168060302734375, 55.584438323974609 ], [ -132.245269775390625, 55.723876953125 ], [ -131.947494506835938, 55.964504241943359 ], [ -131.956787109375, 56.164920806884766 ], [ -131.769744873046875, 56.196937561035156 ], [ -131.900848388671875, 56.226932525634766 ], [ -131.9930419921875, 56.357772827148438 ], [ -132.341659545898438, 56.523323059082031 ], [ -132.31573486328125, 56.633373260498047 ], [ -132.551116943359375, 56.637702941894531 ], [ -132.364974975585938, 56.817146301269531 ], [ -132.768890380859375, 56.843879699707031 ], [ -132.80413818359375, 57.083812713623047 ], [ -133.48858642578125, 57.166099548339844 ], [ -133.065963745117188, 57.346794128417969 ], [ -133.441314697265625, 57.355411529541016 ], [ -133.506820678710938, 57.484294891357422 ], [ -133.317855834960938, 57.590057373046875 ], [ -133.599365234375, 57.574508666992188 ], [ -133.64056396484375, 57.696380615234375 ], [ -133.006423950195312, 57.513950347900391 ], [ -133.544525146484375, 57.768882751464844 ], [ -133.544342041015625, 57.908149719238281 ], [ -133.183334350585938, 57.891380310058594 ], [ -133.557647705078125, 57.923603057861328 ], [ -133.700607299804688, 57.791522979736328 ], [ -133.813018798828125, 57.972934722900391 ], [ -133.680206298828125, 58.145961761474609 ], [ -133.913345336914062, 57.980129241943359 ], [ -134.059722900390625, 58.078880310058594 ], [ -134.008956909179688, 58.389934539794922 ], [ -133.774032592773438, 58.514995574951172 ], [ -133.972702026367188, 58.497837066650391 ], [ -134.149246215820312, 58.200477600097656 ], [ -134.518478393554688, 58.355690002441406 ], [ -134.757644653320312, 58.381969451904297 ], [ -134.95111083984375, 58.815128326416016 ], [ -135.145431518554688, 58.843116760253906 ], [ -135.34783935546875, 59.464157104492188 ], [ -135.459716796875, 59.290824890136719 ], [ -135.303390502929688, 59.092838287353516 ], [ -135.546676635742188, 59.225334167480469 ], [ -135.085540771484375, 58.233047485351562 ], [ -135.321243286132812, 58.249717712402344 ], [ -135.470901489257812, 58.471446990966797 ], [ -135.910354614257812, 58.381103515625 ], [ -135.836532592773438, 58.538188934326172 ], [ -136.065689086914062, 58.818325042724609 ], [ -135.765945434570312, 58.895961761474609 ], [ -136.164108276367188, 59.027423858642578 ], [ -136.094436645507812, 58.862491607666016 ], [ -136.23651123046875, 58.751728057861328 ], [ -137.064300537109375, 59.061866760253906 ], [ -136.97747802734375, 58.988883972167969 ], [ -137.11859130859375, 58.822704315185547 ], [ -136.558624267578125, 58.83221435546875 ], [ -136.342910766601562, 58.680335998535156 ], [ -136.519241333007812, 58.610271453857422 ], [ -136.255569458007812, 58.649993896484375 ], [ -136.028335571289062, 58.385272979736328 ], [ -136.47943115234375, 58.415824890136719 ], [ -136.367355346679688, 58.298534393310547 ], [ -136.647781372070312, 58.334503173828125 ], [ -136.658905029296875, 58.216518402099609 ], [ -138.599533081054688, 59.123218536376953 ], [ -138.439224243164062, 59.184642791748047 ], [ -139.710540771484375, 59.495826721191406 ], [ -139.481246948242188, 59.985057830810547 ], [ -139.31695556640625, 59.869987487792969 ], [ -139.290008544921875, 59.572772979736328 ], [ -139.270797729492188, 59.800823211669922 ], [ -138.899734497070312, 59.805335998535156 ], [ -139.5, 60.033050537109375 ], [ -140.403350830078125, 59.698043823242188 ], [ -141.37664794921875, 59.866386413574219 ], [ -141.2569580078125, 59.995967864990234 ], [ -141.384857177734375, 60.137908935546875 ], [ -141.73095703125, 59.953327178955078 ], [ -142.71722412109375, 60.109992980957031 ], [ -143.90057373046875, 59.991104125976562 ], [ -144.931533813476562, 60.297355651855469 ], [ -144.61138916015625, 60.715545654296875 ], [ -145.288467407226562, 60.350688934326172 ], [ -145.85943603515625, 60.491661071777344 ], [ -145.6253662109375, 60.667003631591797 ], [ -146.261611938476562, 60.654434204101562 ], [ -146.038055419921875, 60.795688629150391 ], [ -146.644027709960938, 60.694084167480469 ], [ -146.125259399414062, 60.845405578613281 ], [ -146.75543212890625, 60.952491760253906 ], [ -146.29681396484375, 61.129295349121094 ], [ -147.366943359375, 60.887771606445312 ], [ -147.537002563476562, 60.917373657226562 ], [ -147.55096435546875, 61.153182983398438 ], [ -147.668060302734375, 60.853050231933594 ], [ -148.050277709960938, 60.947353363037109 ], [ -147.715682983398438, 61.275405883789062 ], [ -148.071517944335938, 61.017772674560547 ], [ -148.18804931640625, 61.094711303710938 ], [ -148.4041748046875, 61.054435729980469 ], [ -148.163955688476562, 61.057018280029297 ], [ -148.344573974609375, 60.812492370605469 ], [ -148.46832275390625, 60.839714050292969 ], [ -148.692367553710938, 60.788120269775391 ], [ -148.45928955078125, 60.797489166259766 ], [ -148.631103515625, 60.750274658203125 ], [ -148.6602783203125, 60.671245574951172 ], [ -148.229721069335938, 60.765827178955078 ], [ -148.25164794921875, 60.702827453613281 ], [ -148.204574584960938, 60.617488861083984 ], [ -148.481094360351562, 60.578117370605469 ], [ -148.687149047851562, 60.451587677001953 ], [ -148.085479736328125, 60.600131988525391 ], [ -147.937850952148438, 60.451377868652344 ], [ -148.3660888671875, 60.247215270996094 ], [ -148.098876953125, 60.205966949462891 ], [ -148.324310302734375, 60.163188934326172 ], [ -148.438522338867188, 59.948459625244141 ], [ -149.077484130859375, 60.056381225585938 ], [ -149.275299072265625, 59.86749267578125 ], [ -149.41973876953125, 60.116241455078125 ], [ -149.6280517578125, 59.821937561035156 ], [ -149.523681640625, 59.726795196533203 ], [ -149.666885375976562, 59.812492370605469 ], [ -149.734283447265625, 59.954677581787109 ], [ -149.750823974609375, 59.659152984619141 ], [ -150.027786254882812, 59.796314239501953 ], [ -149.918258666992188, 59.713115692138672 ], [ -150.013641357421875, 59.627487182617188 ], [ -150.344711303710938, 59.466518402099609 ], [ -150.22467041015625, 59.715476989746094 ], [ -150.486724853515625, 59.463882446289062 ], [ -150.54168701171875, 59.591659545898438 ], [ -150.907501220703125, 59.243324279785156 ], [ -151.72332763671875, 59.160820007324219 ], [ -151.976242065429688, 59.275825500488281 ], [ -150.997894287109375, 59.780826568603516 ], [ -151.469223022460938, 59.636730194091797 ], [ -151.878311157226562, 59.759994506835938 ], [ -151.302642822265625, 60.388328552246094 ], [ -151.40673828125, 60.728111267089844 ], [ -150.4041748046875, 61.036800384521484 ], [ -149.029739379882812, 60.851657867431641 ], [ -150.06201171875, 61.157768249511719 ], [ -149.252044677734375, 61.49249267578125 ], [ -149.634857177734375, 61.487354278564453 ], [ -149.994583129882812, 61.258922576904297 ], [ -150.626373291015625, 61.286384582519531 ], [ -151.5836181640625, 60.976936340332031 ], [ -151.800140380859375, 60.854991912841797 ], [ -151.709716796875, 60.731864929199219 ], [ -152.225051879882812, 60.557353973388672 ], [ -152.421783447265625, 60.293258666992188 ], [ -153.078887939453125, 60.298187255859375 ], [ -152.587493896484375, 60.046382904052734 ], [ -153.277572631835938, 59.818950653076172 ], [ -153.001953125, 59.819297790527344 ], [ -153.042648315429688, 59.709438323974609 ], [ -153.34832763671875, 59.62860107421875 ], [ -153.420562744140625, 59.766105651855469 ], [ -153.743331909179688, 59.437210083007812 ], [ -154.143630981445312, 59.3760986328125 ], [ -153.996795654296875, 59.3538818359375 ], [ -154.2569580078125, 59.132766723632812 ], [ -153.261184692382812, 58.859573364257812 ], [ -154.102691650390625, 58.480060577392578 ], [ -154.005096435546875, 58.382003784179688 ], [ -154.354232788085938, 58.278327941894531 ], [ -154.114639282226562, 58.280406951904297 ], [ -154.235671997070312, 58.130687713623047 ], [ -155.033401489257812, 58.014610290527344 ], [ -155.311126708984375, 57.73443603515625 ], [ -155.60693359375, 57.789302825927734 ], [ -155.73443603515625, 57.551383972167969 ], [ -156.489990234375, 57.331108093261719 ], [ -156.341659545898438, 57.170829772949219 ], [ -156.552291870117188, 56.978878021240234 ], [ -156.940826416015625, 56.962493896484375 ], [ -157.2066650390625, 56.770545959472656 ], [ -157.427932739257812, 56.857494354248047 ], [ -157.583328247070312, 56.707351684570312 ], [ -157.470123291015625, 56.620269775390625 ], [ -157.7872314453125, 56.678329467773438 ], [ -158.115676879882812, 56.560581207275391 ], [ -157.88262939453125, 56.467491149902344 ], [ -158.428482055664062, 56.440128326416016 ], [ -158.637420654296875, 56.258743286132812 ], [ -158.126449584960938, 56.235198974609375 ], [ -158.505279541015625, 55.988883972167969 ], [ -158.60040283203125, 56.100963592529297 ], [ -158.484222412109375, 56.179779052734375 ], [ -158.601104736328125, 56.188041687011719 ], [ -158.67535400390625, 55.954231262207031 ], [ -159.3614501953125, 55.874362945556641 ], [ -159.667236328125, 55.577217102050781 ], [ -159.6240234375, 55.81207275390625 ], [ -159.842636108398438, 55.850269317626953 ], [ -160.507781982421875, 55.478042602539062 ], [ -160.633056640625, 55.566665649414062 ], [ -161.248886108398438, 55.347908020019531 ], [ -161.509902954101562, 55.368392944335938 ], [ -161.483734130859375, 55.483463287353516 ], [ -161.145278930664062, 55.530269622802734 ], [ -161.5625, 55.622764587402344 ], [ -162.043197631835938, 55.230125427246094 ], [ -161.97528076171875, 55.099159240722656 ], [ -162.445037841796875, 55.036426544189453 ], [ -162.636383056640625, 55.297355651855469 ], [ -162.566940307617188, 54.957977294921875 ], [ -162.873886108398438, 54.930965423583984 ], [ -163.179443359375, 55.139575958251953 ], [ -163.053085327148438, 54.932662963867188 ], [ -163.3529052734375, 54.809715270996094 ], [ -163.326248168945312, 55.117076873779297 ], [ -162.548904418945312, 55.342491149902344 ], [ -161.807632446289062, 55.883739471435547 ], [ -161.068328857421875, 55.934989929199219 ], [ -160.679580688476562, 55.695823669433594 ], [ -160.790145874023438, 55.877559661865234 ], [ -160.250076293945312, 55.771518707275391 ], [ -160.574020385742188, 55.993740081787109 ], [ -160.346954345703125, 56.285552978515625 ], [ -159.035003662109375, 56.80499267578125 ], [ -158.6390380859375, 56.762912750244141 ], [ -158.682785034179688, 57.012630462646484 ], [ -158.2852783203125, 57.324165344238281 ], [ -157.741668701171875, 57.562210083007812 ], [ -157.641387939453125, 57.483879089355469 ], [ -157.397918701171875, 57.492771148681641 ], [ -157.70416259765625, 57.637351989746094 ], [ -157.611373901367188, 58.084022521972656 ], [ -157.1390380859375, 58.164436340332031 ], [ -157.543197631835938, 58.266242980957031 ], [ -157.5513916015625, 58.387771606445312 ], [ -157.072494506835938, 58.739437103271484 ], [ -156.781814575195312, 59.151241302490234 ], [ -157.1119384765625, 58.874435424804688 ], [ -158.190963745117188, 58.606800079345703 ], [ -158.559234619140625, 58.808185577392578 ], [ -158.488113403320312, 59.000755310058594 ], [ -157.992767333984375, 58.904991149902344 ], [ -158.538619995117188, 59.173744201660156 ], [ -158.6160888671875, 58.921104431152344 ], [ -158.821243286132812, 58.968463897705078 ], [ -158.778900146484375, 58.773880004882812 ], [ -158.9072265625, 58.724433898925781 ], [ -158.710891723632812, 58.492771148681641 ], [ -158.89752197265625, 58.395545959472656 ], [ -159.620895385742188, 58.944087982177734 ], [ -159.914306640625, 58.770408630371094 ], [ -160.322769165039062, 59.058326721191406 ], [ -161.6322021484375, 58.599159240722656 ], [ -162.165969848632812, 58.655128479003906 ], [ -161.69915771484375, 58.763324737548828 ], [ -161.79278564453125, 59.0172119140625 ], [ -161.568405151367188, 59.106658935546875 ], [ -161.9940185546875, 59.147075653076172 ], [ -161.955825805664062, 59.380687713623047 ], [ -161.709640502929688, 59.496936798095703 ], [ -162.236526489257812, 60.063606262207031 ], [ -162.156051635742188, 60.244922637939453 ], [ -162.369583129882812, 60.16943359375 ], [ -162.221923828125, 60.5816650390625 ], [ -161.879425048828125, 60.702217102050781 ], [ -162.261672973632812, 60.616378784179688 ], [ -162.5694580078125, 60.316383361816406 ], [ -162.448333740234375, 60.169715881347656 ], [ -162.542236328125, 59.988044738769531 ], [ -164.065277099609375, 59.824165344238281 ], [ -164.214218139648438, 59.950057983398438 ], [ -164.094223022460938, 59.977767944335938 ], [ -165.138397216796875, 60.440959930419922 ], [ -164.979644775390625, 60.540409088134766 ], [ -165.422439575195312, 60.552146911621094 ], [ -164.659317016601562, 60.911659240722656 ], [ -164.655853271484375, 60.819992065429688 ], [ -164.270919799804688, 60.782905578613281 ], [ -164.437423706054688, 60.559154510498047 ], [ -163.951385498046875, 60.780548095703125 ], [ -163.675430297851562, 60.586238861083984 ], [ -163.412506103515625, 60.757213592529297 ], [ -163.888839721679688, 60.854316711425781 ], [ -163.555130004882812, 60.897106170654297 ], [ -165.150299072265625, 60.928047180175781 ], [ -164.82208251953125, 61.103050231933594 ], [ -165.366867065429688, 61.201797485351562 ], [ -164.7193603515625, 61.625335693359375 ], [ -165.197647094726562, 61.406517028808594 ], [ -165.403579711914062, 61.20245361328125 ], [ -165.386688232421875, 61.068603515625 ], [ -165.87359619140625, 61.332630157470703 ], [ -165.793060302734375, 61.51971435546875 ], [ -166.197357177734375, 61.590267181396484 ], [ -166.147705078125, 61.713775634765625 ], [ -165.826950073242188, 61.681240081787109 ], [ -166.092697143554688, 61.815963745117188 ], [ -165.633331298828125, 61.846939086914062 ], [ -165.7015380859375, 62.115966796875 ], [ -165.247222900390625, 62.446098327636719 ], [ -165.001129150390625, 62.537498474121094 ], [ -164.63641357421875, 62.417495727539062 ], [ -164.847763061523438, 62.569332122802734 ], [ -164.493362426757812, 62.746730804443359 ], [ -164.786041259765625, 62.652347564697266 ], [ -164.876800537109375, 62.838047027587891 ], [ -164.698272705078125, 63.019229888916016 ], [ -164.31805419921875, 63.009647369384766 ], [ -164.584518432617188, 63.134090423583984 ], [ -164.401123046875, 63.214992523193359 ], [ -163.111663818359375, 63.051933288574219 ], [ -162.305984497070312, 63.540622711181641 ], [ -162.0341796875, 63.482490539550781 ], [ -162.142242431640625, 63.425270080566406 ], [ -161.15167236328125, 63.512496948242188 ], [ -160.78125, 63.87457275390625 ], [ -161.18902587890625, 64.414154052734375 ], [ -161.5291748046875, 64.418869018554688 ], [ -161.017166137695312, 64.510475158691406 ], [ -160.782791137695312, 64.719154357910156 ], [ -161.174575805664062, 64.938034057617188 ], [ -161.425704956054688, 64.770828247070312 ], [ -162.107772827148438, 64.716239929199219 ], [ -162.790283203125, 64.336105346679688 ], [ -163.170013427734375, 64.655258178710938 ], [ -163.352630615234375, 64.590682983398438 ], [ -163.040557861328125, 64.518318176269531 ], [ -163.138748168945312, 64.412689208984375 ], [ -163.821929931640625, 64.589157104492188 ], [ -165.02862548828125, 64.443862915039062 ], [ -166.121368408203125, 64.57470703125 ], [ -166.489639282226562, 64.736579895019531 ], [ -166.4222412109375, 64.919143676757812 ], [ -166.696670532226562, 64.995887756347656 ], [ -166.722488403320312, 65.055397033691406 ], [ -166.846939086914062, 65.088043212890625 ], [ -166.91973876953125, 65.131362915039062 ], [ -166.959793090820312, 65.179908752441406 ], [ -166.054168701171875, 65.250022888183594 ], [ -167.462356567382812, 65.420120239257812 ], [ -168.1319580078125, 65.662956237792969 ], [ -166.2598876953125, 66.180122375488281 ], [ -165.51129150390625, 66.157135009765625 ], [ -165.887374877929688, 66.23651123046875 ], [ -164.3619384765625, 66.593879699707031 ], [ -163.933624267578125, 66.608596801757812 ], [ -163.642364501953125, 66.566719055175781 ], [ -163.931793212890625, 66.578048706054688 ], [ -163.75640869140625, 66.515541076660156 ], [ -163.85748291015625, 66.276237487792969 ], [ -164.173995971679688, 66.190673828125 ], [ -163.656402587890625, 66.070541381835938 ], [ -161.81640625, 65.974990844726562 ], [ -161.523345947265625, 66.268600463867188 ], [ -161.01556396484375, 66.183868408203125 ], [ -161.52001953125, 66.402206420898438 ], [ -161.913482666015625, 66.276649475097656 ], [ -161.900436401367188, 66.530128479003906 ], [ -162.633758544921875, 66.865814208984375 ], [ -162.329574584960938, 66.95574951171875 ], [ -161.630279541015625, 66.456100463867188 ], [ -161.186126708984375, 66.538589477539062 ], [ -160.783340454101562, 66.37109375 ], [ -160.235000610351562, 66.398048400878906 ], [ -160.240264892578125, 66.644149780273438 ], [ -161.716644287109375, 66.628311157226562 ], [ -161.897796630859375, 66.728317260742188 ], [ -161.721099853515625, 66.950675964355469 ], [ -161.49853515625, 66.960464477539062 ], [ -161.66778564453125, 67.020538330078125 ], [ -162.460800170898438, 66.998146057128906 ], [ -162.35247802734375, 67.120819091796875 ], [ -162.38360595703125, 67.163742065429688 ], [ -162.55950927734375, 67.010406494140625 ], [ -163.727203369140625, 67.112205505371094 ], [ -164.1241455078125, 67.6099853515625 ], [ -166.823623657226562, 68.348731994628906 ], [ -166.372604370117188, 68.416763305664062 ], [ -166.207489013671875, 68.883460998535156 ], [ -164.32470703125, 68.9305419921875 ], [ -163.645294189453125, 69.10693359375 ], [ -163.120269775390625, 69.384719848632812 ], [ -163.00390625, 69.752777099609375 ], [ -161.942230224609375, 70.307205200195312 ], [ -161.7669677734375, 70.257225036621094 ], [ -162.114212036132812, 70.154296875 ], [ -159.929092407226562, 70.586929321289062 ], [ -160.193893432617188, 70.470123291015625 ], [ -159.83612060546875, 70.268325805664062 ], [ -159.8194580078125, 70.484420776367188 ], [ -159.305648803710938, 70.530677795410156 ], [ -160.110122680664062, 70.631370544433594 ], [ -159.67236328125, 70.796089172363281 ], [ -159.3033447265625, 70.864151000976562 ], [ -159.146896362304688, 70.822906494140625 ], [ -159.445419311523438, 70.778182983398438 ], [ -157.880462646484375, 70.856353759765625 ], [ -156.596725463867188, 71.3514404296875 ], [ -155.592498779296875, 71.168319702148438 ], [ -156.177291870117188, 70.917762756347656 ], [ -155.987350463867188, 70.900543212890625 ], [ -155.973602294921875, 70.755828857421875 ], [ -155.186676025390625, 70.994148254394531 ], [ -155.27410888671875, 71.086433410644531 ], [ -155.094436645507812, 71.150131225585938 ], [ -155.062088012695312, 71.010269165039062 ], [ -154.82110595703125, 71.094985961914062 ], [ -154.595748901367188, 71.001930236816406 ], [ -154.612625122070312, 70.827621459960938 ], [ -154.20361328125, 70.776519775390625 ], [ -153.222503662109375, 70.9285888671875 ], [ -152.379150390625, 70.861648559570312 ], [ -152.21722412109375, 70.813041687011719 ], [ -152.492691040039062, 70.646095275878906 ], [ -152.077362060546875, 70.578392028808594 ], [ -152.619461059570312, 70.558387756347656 ], [ -151.736648559570312, 70.55859375 ], [ -151.970260620117188, 70.445671081542969 ], [ -151.2298583984375, 70.372962951660156 ], [ -150.779998779296875, 70.502212524414062 ], [ -149.174713134765625, 70.490814208984375 ], [ -144.95220947265625, 69.96832275390625 ], [ -143.215545654296875, 70.110260009765625 ], [ -141.382080078125, 69.63970947265625 ], [ -139.14306640625, 69.510818481445312 ], [ -137.2550048828125, 68.948318481445312 ], [ -135.160003662109375, 68.657211303710938 ], [ -135.6175537109375, 68.886581420898438 ], [ -134.97747802734375, 68.878311157226562 ], [ -134.810287475585938, 68.924423217773438 ], [ -134.46929931640625, 68.709434509277344 ], [ -134.28277587890625, 68.681365966796875 ], [ -134.225128173828125, 68.697525024414062 ], [ -134.26251220703125, 68.736373901367188 ], [ -134.287506103515625, 68.75360107421875 ], [ -134.423065185546875, 68.8316650390625 ], [ -134.619155883789062, 68.988037109375 ], [ -134.558609008789062, 69.08526611328125 ], [ -134.347427368164062, 69.1044921875 ], [ -133.664459228515625, 69.387908935546875 ], [ -133.07305908203125, 69.434982299804688 ], [ -132.893890380859375, 69.65386962890625 ], [ -132.14697265625, 69.685256958007812 ], [ -131.417007446289062, 69.954017639160156 ], [ -131.190689086914062, 69.824851989746094 ], [ -130.9302978515625, 70.083053588867188 ], [ -130.548614501953125, 70.166793823242188 ], [ -129.96929931640625, 70.070549011230469 ], [ -129.682647705078125, 70.265480041503906 ], [ -129.407470703125, 70.103179931640625 ], [ -130.92388916015625, 69.565261840820312 ], [ -131.053070068359375, 69.63720703125 ], [ -132.001815795898438, 69.529289245605469 ], [ -132.11663818359375, 69.357208251953125 ], [ -132.7640380859375, 69.251655578613281 ], [ -132.9052734375, 69.042755126953125 ], [ -133.491928100585938, 68.82415771484375 ], [ -133.321380615234375, 68.746368408203125 ], [ -133.04583740234375, 68.690948486328125 ], [ -132.9183349609375, 68.690261840820312 ], [ -133.354156494140625, 68.83221435546875 ], [ -132.478256225585938, 68.804634094238281 ], [ -132.772811889648438, 68.859687805175781 ], [ -132.86810302734375, 69.064010620117188 ], [ -132.313339233398438, 69.234291076660156 ], [ -132.222503662109375, 69.14166259765625 ], [ -131.645706176757812, 69.472763061523438 ], [ -131.432693481445312, 69.433067321777344 ], [ -131.499420166015625, 69.332489013671875 ], [ -131.23956298828125, 69.491233825683594 ], [ -131.329986572265625, 69.318328857421875 ], [ -131.16650390625, 69.404930114746094 ], [ -131.2254638671875, 69.580718994140625 ], [ -131.13458251953125, 69.364631652832031 ], [ -131.130966186523438, 69.614425659179688 ], [ -131.105682373046875, 69.326408386230469 ], [ -130.946548461914062, 69.534881591796875 ], [ -131.030197143554688, 69.342453002929688 ], [ -130.902694702148438, 69.381256103515625 ], [ -131.02471923828125, 69.209716796875 ], [ -130.937225341796875, 69.134429931640625 ], [ -130.94354248046875, 69.2672119140625 ], [ -130.364288330078125, 69.680122375488281 ], [ -128.89404296875, 69.97039794921875 ], [ -129.1646728515625, 69.829429626464844 ], [ -129.151382446289062, 69.700813293457031 ], [ -128.925018310546875, 69.680816650390625 ], [ -128.317352294921875, 69.953323364257812 ], [ -128.343048095703125, 70.116928100585938 ], [ -127.516250610351562, 70.223594665527344 ], [ -128.197769165039062, 70.397209167480469 ], [ -128.001800537109375, 70.589569091796875 ], [ -127.180961608886719, 70.276382446289062 ], [ -126.261665344238281, 69.532417297363281 ], [ -125.42083740234375, 69.312599182128906 ], [ -125.089447021484375, 69.44970703125 ], [ -125.617012023925781, 69.420669555664062 ], [ -125.132423400878906, 69.488227844238281 ], [ -125.363533020019531, 69.689277648925781 ], [ -124.825836181640625, 69.717071533203125 ], [ -125.276397705078125, 69.808242797851562 ], [ -124.795272827148438, 70.008880615234375 ], [ -125.197555541992188, 70.002670288085938 ], [ -124.994857788085938, 70.079292297363281 ], [ -124.562225341796875, 70.012077331542969 ], [ -124.423606872558594, 70.056365966796875 ], [ -124.745689392089844, 70.124282836914062 ], [ -124.436111450195312, 70.151092529296875 ], [ -124.358612060546875, 70.068603515625 ], [ -124.496734619140625, 69.723800659179688 ], [ -124.04083251953125, 69.701385498046875 ], [ -124.446662902832031, 69.367202758789062 ], [ -123.471946716308594, 69.382484436035156 ], [ -123.165969848632812, 69.498321533203125 ], [ -122.961044311523438, 69.832000732421875 ], [ -121.683883666992188, 69.793594360351562 ], [ -120.231666564941406, 69.39166259765625 ], [ -117.145271301269531, 68.885543823242188 ], [ -115.960006713867188, 68.804702758789062 ], [ -116.319717407226562, 68.956306457519531 ], [ -115.593063354492188, 68.971649169921875 ], [ -114.066520690917969, 68.469703674316406 ], [ -114.021041870117188, 68.244010925292969 ], [ -115.232292175292969, 68.181716918945312 ], [ -115.120994567871094, 68.015190124511719 ], [ -115.53582763671875, 67.920951843261719 ], [ -115.108612060546875, 67.797622680664062 ], [ -112.395843505859375, 67.679153442382812 ], [ -111.0120849609375, 67.76416015625 ], [ -110.077369689941406, 68.00555419921875 ], [ -109.731513977050781, 67.718597412109375 ], [ -109.062774658203125, 67.712074279785156 ], [ -108.82806396484375, 67.351509094238281 ], [ -108.662773132324219, 67.628448486328125 ], [ -108.492630004882812, 67.357269287109375 ], [ -108.38409423828125, 67.444351196289062 ], [ -108.020561218261719, 67.294708251953125 ], [ -107.877906799316406, 67.050544738769531 ], [ -108.621246337890625, 67.151931762695312 ], [ -107.228614807128906, 66.348876953125 ], [ -107.746658325195312, 66.922760009765625 ], [ -107.643478393554688, 67.074989318847656 ], [ -107.487358093261719, 66.9210205078125 ], [ -107.667922973632812, 66.93853759765625 ], [ -107.567359924316406, 66.835685729980469 ], [ -107.42041015625, 66.806648254394531 ], [ -107.414024353027344, 66.972068786621094 ], [ -107.08917236328125, 66.819435119628906 ], [ -107.64862060546875, 67.3599853515625 ], [ -107.578407287597656, 67.48626708984375 ], [ -107.9964599609375, 67.695816040039062 ], [ -107.658332824707031, 67.940460205078125 ], [ -107.914237976074219, 67.991989135742188 ], [ -107.887916564941406, 68.084991455078125 ], [ -107.355827331542969, 68.047767639160156 ], [ -106.620964050292969, 68.247337341308594 ], [ -106.426666259765625, 68.154571533203125 ], [ -106.459373474121094, 68.337760925292969 ], [ -105.745697021484375, 68.414154052734375 ], [ -105.651802062988281, 68.636100769042969 ], [ -106.543876647949219, 68.511932373046875 ], [ -106.564437866210938, 68.290534973144531 ], [ -106.787559509277344, 68.410537719726562 ], [ -107.883468627929688, 68.265060424804688 ], [ -107.6240234375, 68.164436340332031 ], [ -108.394309997558594, 68.114013671875 ], [ -108.399032592773438, 68.292060852050781 ], [ -108.815971374511719, 68.266098022460938 ], [ -108.345283508300781, 68.6019287109375 ], [ -106.208061218261719, 68.940948486328125 ], [ -105.480201721191406, 68.723800659179688 ], [ -105.380828857421875, 68.486648559570312 ], [ -105.525421142578125, 68.4073486328125 ], [ -104.884742736816406, 68.339706420898438 ], [ -104.932632446289062, 68.234565734863281 ], [ -104.603897094726562, 68.234352111816406 ], [ -104.50048828125, 68.03338623046875 ], [ -103.421661376953125, 68.166656494140625 ], [ -103.367630004882812, 68.008323669433594 ], [ -102.800277709960938, 67.820831298828125 ], [ -101.542503356933594, 67.679428100585938 ], [ -100.395553588867188, 67.847488403320312 ], [ -99.210556030273438, 67.706939697265625 ], [ -98.359786987304688, 67.795883178710938 ], [ -98.721946716308594, 67.95123291015625 ], [ -98.615554809570312, 68.07470703125 ], [ -98.094451904296875, 67.766098022460938 ], [ -97.59832763671875, 67.60345458984375 ], [ -97.138900756835938, 67.674148559570312 ], [ -97.247230529785156, 67.927757263183594 ], [ -97.683059692382812, 68.018600463867188 ], [ -98.111244201660156, 67.838874816894531 ], [ -98.583541870117188, 68.146095275878906 ], [ -98.329727172851562, 68.172134399414062 ], [ -98.710212707519531, 68.36199951171875 ], [ -97.7459716796875, 68.36761474609375 ], [ -98.010421752929688, 68.501785278320312 ], [ -97.844444274902344, 68.541374206542969 ], [ -97.259170532226562, 68.466659545898438 ], [ -96.939163208007812, 68.239700317382812 ], [ -96.407363891601562, 68.313453674316406 ], [ -96.781112670898438, 68.015548706054688 ], [ -95.98028564453125, 68.254714965820312 ], [ -96.174713134765625, 67.643051147460938 ], [ -96.454864501953125, 67.474563598632812 ], [ -96.110618591308594, 67.466789245605469 ], [ -96.24951171875, 67.24908447265625 ], [ -96.122215270996094, 67.214988708496094 ], [ -95.571388244628906, 67.378456115722656 ], [ -95.827156066894531, 67.166580200195312 ], [ -95.435546875, 67.193862915039062 ], [ -95.340278625488281, 66.982620239257812 ], [ -96.455551147460938, 67.06414794921875 ], [ -95.741378784179688, 66.638046264648438 ], [ -95.659027099609375, 66.729911804199219 ], [ -96.089096069335938, 66.913490295410156 ], [ -95.224723815917969, 66.97796630859375 ], [ -95.34930419921875, 67.151100158691406 ], [ -95.168045043945312, 67.282966613769531 ], [ -95.334587097167969, 67.346099853515625 ], [ -95.324722290039062, 67.529289245605469 ], [ -95.706390380859375, 67.7294921875 ], [ -95.470344543457031, 68.059425354003906 ], [ -94.716529846191406, 68.058792114257812 ], [ -93.619155883789062, 68.544143676757812 ], [ -93.638336181640625, 68.961517333984375 ], [ -94.490829467773438, 68.728866577148438 ], [ -94.625, 68.761383056640625 ], [ -94.599098205566406, 68.961860656738281 ], [ -94.072647094726562, 69.135818481445312 ], [ -94.322982788085938, 69.152900695800781 ], [ -94.259170532226562, 69.32666015625 ], [ -93.53326416015625, 69.431777954101562 ], [ -93.848747253417969, 69.169639587402344 ], [ -93.367568969726562, 69.373931884765625 ], [ -93.562774658203125, 69.375816345214844 ], [ -93.440406799316406, 69.4779052734375 ], [ -93.536666870117188, 69.522209167480469 ], [ -94.2791748046875, 69.440261840820312 ], [ -94.629440307617188, 69.68304443359375 ], [ -94.854721069335938, 69.566238403320312 ], [ -96.028053283691406, 69.809150695800781 ], [ -96.569450378417969, 70.259849548339844 ], [ -96.232772827148438, 70.56219482421875 ], [ -95.800201416015625, 70.5341796875 ], [ -96.054924011230469, 70.605888366699219 ], [ -95.816665649414062, 70.709709167480469 ], [ -96.202789306640625, 70.62164306640625 ], [ -96.60791015625, 70.791236877441406 ], [ -96.371726989746094, 71.092758178710938 ], [ -96.555618286132812, 71.1336669921875 ], [ -96.134170532226562, 71.409713745117188 ], [ -95.543190002441406, 71.290397644042969 ], [ -95.547775268554688, 71.487762451171875 ], [ -95.900421142578125, 71.606231689453125 ], [ -94.613677978515625, 71.863037109375 ], [ -95.216110229492188, 71.944145202636719 ], [ -94.530288696289062, 71.994430541992188 ], [ -94.390762329101562, 71.93365478515625 ], [ -94.6441650390625, 71.818328857421875 ], [ -94.360893249511719, 71.798446655273438 ], [ -94.417152404785156, 71.662345886230469 ], [ -93.734306335449219, 71.767768859863281 ], [ -93.809585571289062, 71.648597717285156 ], [ -92.983535766601562, 71.346855163574219 ], [ -92.854446411132812, 71.151382446289062 ], [ -92.982498168945312, 70.825546264648438 ], [ -92.203605651855469, 70.608451843261719 ], [ -91.950279235839844, 70.258880615234375 ], [ -91.733467102050781, 70.357765197753906 ], [ -91.513481140136719, 70.156303405761719 ], [ -92.268341064453125, 70.208877563476562 ], [ -92.441253662109375, 70.073326110839844 ], [ -91.943183898925781, 70.018043518066406 ], [ -92.91888427734375, 69.676994323730469 ], [ -92.340835571289062, 69.694137573242188 ], [ -91.802291870117188, 69.504150390625 ], [ -91.195411682128906, 69.654563903808594 ], [ -91.097358703613281, 69.630889892578125 ], [ -91.562423706054688, 69.517311096191406 ], [ -90.313400268554688, 69.448112487792969 ], [ -90.702568054199219, 69.451164245605469 ], [ -90.588401794433594, 69.414703369140625 ], [ -90.790283203125, 69.362762451171875 ], [ -90.903884887695312, 69.246368408203125 ], [ -91.433746337890625, 69.349494934082031 ], [ -90.436386108398438, 68.874420166015625 ], [ -90.604400634765625, 68.449569702148438 ], [ -90.263198852539062, 68.235816955566406 ], [ -89.729171752929688, 68.699142456054688 ], [ -89.711944580078125, 69.010406494140625 ], [ -89.314445495605469, 69.249298095703125 ], [ -88.968887329101562, 69.241363525390625 ], [ -88.045272827148438, 68.818595886230469 ], [ -87.800552368164062, 68.311920166015625 ], [ -87.935272216796875, 68.19720458984375 ], [ -88.221939086914062, 68.36553955078125 ], [ -88.389167785644531, 68.288734436035156 ], [ -88.371246337890625, 67.96282958984375 ], [ -88.132225036621094, 67.659988403320312 ], [ -87.359161376953125, 67.253524780273438 ], [ -87.510421752929688, 67.114631652832031 ], [ -86.966941833496094, 67.249076843261719 ], [ -87.087150573730469, 67.34686279296875 ], [ -86.874435424804688, 67.404983520507812 ], [ -86.529380798339844, 67.350257873535156 ], [ -86.523338317871094, 67.676643371582031 ], [ -85.895004272460938, 68.051231384277344 ], [ -85.669448852539062, 68.719017028808594 ], [ -84.794158935546875, 68.733871459960938 ], [ -85.184814453125, 68.8597412109375 ], [ -84.5343017578125, 69.014854431152344 ], [ -85.475555419921875, 69.274154663085938 ], [ -85.343887329101562, 69.442337036132812 ], [ -85.540695190429688, 69.471656799316406 ], [ -85.514724731445312, 69.768051147460938 ], [ -85.337501525878906, 69.77276611328125 ], [ -85.55499267578125, 69.859703063964844 ], [ -84.375823974609375, 69.85748291015625 ], [ -83.705001831054688, 69.703598022460938 ], [ -82.259033203125, 69.637214660644531 ], [ -82.653884887695312, 69.623031616210938 ], [ -82.488540649414062, 69.497688293457031 ], [ -83.228057861328125, 69.538589477539062 ], [ -82.228889465332031, 69.394088745117188 ], [ -82.273056030273438, 69.23748779296875 ], [ -81.335700988769531, 69.184982299804688 ], [ -82.049789428710938, 68.87713623046875 ], [ -81.382766723632812, 68.866653442382812 ], [ -81.259033203125, 68.641792297363281 ], [ -81.964447021484375, 68.422203063964844 ], [ -82.63250732421875, 68.500953674316406 ], [ -82.264305114746094, 68.279571533203125 ], [ -82.314437866210938, 68.146652221679688 ], [ -81.989234924316406, 68.204086303710938 ], [ -82.174720764160156, 67.999984741210938 ], [ -82.099723815917969, 67.90484619140625 ], [ -81.242218017578125, 67.470123291015625 ], [ -81.502220153808594, 67.000961303710938 ], [ -81.929718017578125, 66.978591918945312 ], [ -82.581077575683594, 66.57647705078125 ], [ -83.4022216796875, 66.347488403320312 ], [ -83.975067138671875, 66.582206726074219 ], [ -83.912086486816406, 66.878868103027344 ], [ -84.266670227050781, 66.717491149902344 ], [ -84.436386108398438, 66.818328857421875 ], [ -84.376800537109375, 66.966514587402344 ], [ -84.908203125, 67.059280395507812 ], [ -84.645698547363281, 66.979225158691406 ], [ -85.227081298828125, 66.87469482421875 ], [ -84.602218627929688, 66.935806274414062 ], [ -84.746383666992188, 66.897491455078125 ], [ -84.4041748046875, 66.705551147460938 ], [ -84.148757934570312, 66.683586120605469 ], [ -83.767898559570312, 66.16864013671875 ], [ -84.514656066894531, 66.4033203125 ], [ -84.630905151367188, 66.331649780273438 ], [ -84.373603820800781, 66.163459777832031 ], [ -85.22125244140625, 66.263320922851562 ], [ -85.485832214355469, 66.581657409667969 ], [ -86.757926940917969, 66.528457641601562 ], [ -86.645004272460938, 66.319709777832031 ], [ -85.897262573242188, 66.168022155761719 ], [ -86.530288696289062, 65.695526123046875 ], [ -87.395843505859375, 65.321380615234375 ], [ -88.070281982421875, 65.356094360351562 ], [ -88.829307556152344, 65.64276123046875 ], [ -88.513336181640625, 65.644439697265625 ], [ -89.668190002441406, 65.937202453613281 ], [ -89.995552062988281, 65.945915222167969 ], [ -89.7933349609375, 65.822494506835938 ], [ -90.42596435546875, 65.880813598632812 ], [ -90.258895874023438, 65.9224853515625 ], [ -91.429168701171875, 65.951095581054688 ], [ -89.960006713867188, 65.78887939453125 ], [ -89.0574951171875, 65.3306884765625 ], [ -86.935127258300781, 65.142906188964844 ], [ -87.794303894042969, 64.518112182617188 ], [ -87.987358093261719, 64.188446044921875 ], [ -88.736663818359375, 63.96832275390625 ], [ -89.250343322753906, 64.157478332519531 ], [ -89.035552978515625, 63.946586608886719 ], [ -89.555404663085938, 64.074432373046875 ], [ -89.485549926757812, 63.942214965820312 ], [ -89.820976257324219, 64.105812072753906 ], [ -89.789161682128906, 64.243316650390625 ], [ -90.117843627929688, 64.125946044921875 ], [ -89.826042175292969, 63.924160003662109 ], [ -89.945144653320312, 63.911102294921875 ], [ -89.954925537109375, 63.97186279296875 ], [ -90.272087097167969, 64.0015869140625 ], [ -89.967437744140625, 63.814228057861328 ], [ -90.23638916015625, 63.607215881347656 ], [ -92.142372131347656, 63.746795654296875 ], [ -93.772712707519531, 64.190254211425781 ], [ -93.604171752929688, 64.04443359375 ], [ -93.770553588867188, 63.957771301269531 ], [ -93.526527404785156, 63.841098785400391 ], [ -93.334861755371094, 63.80902099609375 ], [ -93.223747253417969, 63.844364166259766 ], [ -93.389999389648438, 63.971656799316406 ], [ -92.103744506835938, 63.697978973388672 ], [ -92.4808349609375, 63.527214050292969 ], [ -91.769721984863281, 63.714576721191406 ], [ -90.854721069335938, 63.408599853515625 ], [ -90.968269348144531, 63.420131683349609 ], [ -90.741943359375, 63.360824584960938 ], [ -90.627487182617188, 63.059432983398438 ], [ -91.361518859863281, 62.788051605224609 ], [ -92.411529541015625, 62.834438323974609 ], [ -91.884796142578125, 62.602909088134766 ], [ -92.710006713867188, 62.465827941894531 ], [ -92.482322692871094, 62.154705047607422 ], [ -92.744300842285156, 62.288467407226562 ], [ -93.122222900390625, 62.334991455078125 ], [ -92.765007019042969, 62.221935272216797 ], [ -93.412223815917969, 62.028465270996094 ], [ -93.281951904296875, 61.891380310058594 ], [ -93.616104125976562, 61.939987182617188 ], [ -93.255569458007812, 61.74249267578125 ], [ -93.985000610351562, 61.455131530761719 ], [ -93.819305419921875, 61.352561950683594 ], [ -94.673324584960938, 60.522491455078125 ], [ -94.819168090820312, 59.636383056640625 ], [ -94.680557250976562, 59.357215881347656 ], [ -94.789718627929688, 59.092216491699219 ], [ -94.416107177734375, 58.71527099609375 ], [ -94.2288818359375, 58.784996032714844 ], [ -94.363327026367188, 58.218879699707031 ], [ -94.143890380859375, 58.76361083984375 ], [ -93.153892517089844, 58.739021301269531 ], [ -92.418746948242188, 57.33270263671875 ], [ -92.868331909179688, 56.906654357910156 ], [ -90.824722290039062, 57.256523132324219 ], [ -88.81500244140625, 56.824440002441406 ], [ -87.979164123535156, 56.4395751953125 ], [ -87.548614501953125, 56.049995422363281 ], [ -85.731941223144531, 55.636173248291016 ], [ -85.130203247070312, 55.345268249511719 ], [ -85.398399353027344, 55.097007751464844 ], [ -85.419967651367188, 54.999088287353516 ], [ -85.001953125, 55.296661376953125 ], [ -82.307769775390625, 55.148880004882812 ], [ -82.221115112304688, 54.787498474121094 ], [ -82.441665649414062, 54.330825805664062 ], [ -82.131942749023438, 53.817771911621094 ], [ -82.114860534667969, 53.292495727539062 ], [ -82.273895263671875, 52.956382751464844 ], [ -81.553398132324219, 52.448879241943359 ], [ -81.878890991210938, 52.187908172607422 ], [ -81.51153564453125, 52.234577178955078 ], [ -80.991386413574219, 52.009716033935547 ], [ -80.438186645507812, 51.466377258300781 ], [ -81.009170532226562, 51.033466339111328 ], [ -80.405349731445312, 51.335201263427734 ], [ -80.125129699707031, 51.297080993652344 ], [ -79.345939636230469, 50.734954833984375 ], [ -79.751182556152344, 51.182281494140625 ], [ -79.326957702636719, 51.662349700927734 ], [ -79.022499084472656, 51.474849700927734 ], [ -78.954872131347656, 51.223045349121094 ], [ -78.8447265625, 51.163604736328125 ], [ -78.794029235839844, 51.606243133544922 ], [ -79.033195495605469, 51.773185729980469 ], [ -78.579452514648438, 52.111381530761719 ], [ -78.507095336914062, 52.457492828369141 ], [ -78.760841369628906, 52.568397521972656 ], [ -78.738327026367188, 52.872215270996094 ], [ -78.881385803222656, 52.899856567382812 ], [ -78.895149230957031, 53.262496948242188 ], [ -79.107353210449219, 53.502494812011719 ], [ -78.918815612792969, 53.562835693359375 ], [ -79.148406982421875, 53.704715728759766 ], [ -78.909370422363281, 53.821727752685547 ], [ -79.103607177734375, 53.903602600097656 ], [ -78.967926025390625, 54.006435394287109 ], [ -79.11944580078125, 54.078605651855469 ], [ -79.050552368164062, 54.181034088134766 ], [ -79.34527587890625, 54.199432373046875 ], [ -79.524932861328125, 54.590126037597656 ], [ -79.761810302734375, 54.651657104492188 ], [ -77.748611450195312, 55.300827026367188 ], [ -76.679786682128906, 56.036449432373047 ], [ -76.531669616699219, 56.318744659423828 ], [ -76.531387329101562, 57.091865539550781 ], [ -76.8619384765625, 57.719154357910156 ], [ -77.460838317871094, 58.199851989746094 ], [ -78.572990417480469, 58.628879547119141 ], [ -78.468475341796875, 58.698600769042969 ], [ -78.56402587890625, 58.963115692138672 ], [ -78.338333129882812, 58.912765502929688 ], [ -77.679718017578125, 59.399295806884766 ], [ -77.9097900390625, 59.411865234375 ], [ -77.721389770507812, 59.539718627929688 ], [ -77.767784118652344, 59.709854125976562 ], [ -77.316322326660156, 59.566173553466797 ], [ -77.537643432617188, 59.751796722412109 ], [ -77.300483703613281, 59.797771453857422 ], [ -77.427490234375, 59.914710998535156 ], [ -77.206954956054688, 60.042770385742188 ], [ -76.848052978515625, 60.099159240722656 ], [ -76.758895874023438, 60.159156799316406 ], [ -77.59222412109375, 60.064155578613281 ], [ -77.471946716308594, 60.215129852294922 ], [ -77.738883972167969, 60.426242828369141 ], [ -77.430030822753906, 60.547943115234375 ], [ -77.829170227050781, 60.642421722412109 ], [ -77.518928527832031, 60.832839965820312 ], [ -78.179924011230469, 60.787944793701172 ], [ -77.701675415039062, 61.217491149902344 ], [ -77.761123657226562, 61.410270690917969 ], [ -77.477149963378906, 61.541522979736328 ], [ -77.997779846191406, 61.721519470214844 ], [ -78.153266906738281, 62.280063629150391 ], [ -77.508346557617188, 62.561660766601562 ], [ -75.709732055664062, 62.29638671875 ], [ -75.888954162597656, 62.161518096923828 ], [ -75.314720153808594, 62.310688018798828 ], [ -74.571670532226562, 62.103050231933594 ], [ -74.756881713867188, 62.205856323242188 ], [ -73.683464050292969, 62.479988098144531 ], [ -72.621940612792969, 62.112075805664062 ], [ -72.748611450195312, 61.85638427734375 ], [ -72.235000610351562, 61.872215270996094 ], [ -72.010055541992188, 61.675270080566406 ], [ -72.303466796875, 61.568534851074219 ], [ -71.973541259765625, 61.605064392089844 ], [ -71.928878784179688, 61.705825805664062 ], [ -71.573341369628906, 61.607078552246094 ], [ -71.880172729492188, 61.426517486572266 ], [ -71.389999389648438, 61.137771606445312 ], [ -70.148475646972656, 61.084575653076172 ], [ -69.927490234375, 60.807769775390625 ], [ -69.513442993164062, 61.066066741943359 ], [ -69.370269775390625, 60.807769775390625 ], [ -69.819725036621094, 60.526031494140625 ], [ -69.630828857421875, 60.066383361816406 ], [ -70.945831298828125, 60.06304931640625 ], [ -69.722915649414062, 59.961662292480469 ], [ -69.600555419921875, 59.833053588867188 ], [ -69.54083251953125, 59.671104431152344 ], [ -69.753890991210938, 59.501937866210938 ], [ -69.631523132324219, 59.376380920410156 ], [ -69.746070861816406, 59.311378479003906 ], [ -69.238052368164062, 59.231792449951172 ], [ -69.537361145019531, 59.170684814453125 ], [ -69.349578857421875, 59.101100921630859 ], [ -69.552497863769531, 58.805824279785156 ], [ -69.863883972167969, 59.05096435546875 ], [ -69.815826416015625, 58.823883056640625 ], [ -70.15625, 58.769298553466797 ], [ -69.815971374511719, 58.588878631591797 ], [ -69.2791748046875, 58.888046264648438 ], [ -68.358604431152344, 58.770130157470703 ], [ -68.204032897949219, 58.442211151123047 ], [ -68.346664428710938, 58.126171112060547 ], [ -69.131111145019531, 57.898189544677734 ], [ -69.3636474609375, 57.767768859863281 ], [ -68.410560607910156, 58.037078857421875 ], [ -68.008201599121094, 58.574996948242188 ], [ -67.861801147460938, 58.325408935546875 ], [ -68.118148803710938, 58.075965881347656 ], [ -67.723892211914062, 58.458885192871094 ], [ -67.713897705078125, 57.923049926757812 ], [ -67.56610107421875, 58.223602294921875 ], [ -66.629714965820312, 58.503608703613281 ], [ -66.38861083984375, 58.850547790527344 ], [ -65.939018249511719, 58.611312866210938 ], [ -66.090896606445312, 58.358119964599609 ], [ -66.058883666992188, 58.320274353027344 ], [ -65.879989624023438, 58.627212524414062 ], [ -66.102638244628906, 58.772354125976562 ], [ -65.796066284179688, 58.860824584960938 ], [ -65.988601684570312, 58.903602600097656 ], [ -65.327468872070312, 59.046382904052734 ], [ -65.716537475585938, 59.150688171386719 ], [ -65.56903076171875, 59.376724243164062 ], [ -65.364021301269531, 59.278495788574219 ], [ -65.549575805664062, 59.488113403320312 ], [ -64.989433288574219, 59.374435424804688 ], [ -65.41583251953125, 59.513187408447266 ], [ -65.527786254882812, 59.716934204101562 ], [ -65.328758239746094, 59.846378326416016 ], [ -65.15570068359375, 59.781101226806641 ], [ -64.989753723144531, 59.764232635498047 ], [ -65.22381591796875, 59.885894775390625 ], [ -64.84478759765625, 60.361137390136719 ], [ -64.610275268554688, 60.336380004882812 ], [ -64.436088562011719, 60.255897521972656 ], [ -64.64306640625, 60.287498474121094 ], [ -64.745376586914062, 60.230751037597656 ], [ -64.376937866210938, 60.160545349121094 ], [ -64.81402587890625, 59.981101989746094 ], [ -64.39617919921875, 60.120616912841797 ], [ -64.504898071289062, 59.89825439453125 ], [ -64.165550231933594, 60.021522521972656 ], [ -64.258064270019531, 59.760688781738281 ], [ -64.057769775390625, 59.625267028808594 ], [ -64.116943359375, 59.517494201660156 ], [ -64.006111145019531, 59.623321533203125 ], [ -63.725551605224609, 59.516101837158203 ], [ -64.060478210449219, 59.385963439941406 ], [ -63.359653472900391, 59.199363708496094 ], [ -64.044021606445312, 59.0181884765625 ], [ -63.1280517578125, 59.046173095703125 ], [ -63.332637786865234, 59.024158477783203 ], [ -63.16180419921875, 58.923328399658203 ], [ -63.315971374511719, 58.855758666992188 ], [ -63.033332824707031, 58.873878479003906 ], [ -62.846385955810547, 58.687767028808594 ], [ -63.581008911132812, 58.301727294921875 ], [ -63.241668701171875, 58.466384887695312 ], [ -62.55694580078125, 58.480266571044922 ], [ -62.828056335449219, 58.252220153808594 ], [ -62.634998321533203, 58.183601379394531 ], [ -62.965003967285156, 58.153877258300781 ], [ -63.335281372070312, 57.980129241943359 ], [ -62.45062255859375, 58.168495178222656 ], [ -62.530277252197266, 58.099021911621094 ], [ -62.502571105957031, 58.057838439941406 ], [ -62.31048583984375, 58.037837982177734 ], [ -62.536808013916016, 58.0030517578125 ], [ -62.668609619140625, 57.929298400878906 ], [ -62.121803283691406, 57.96527099609375 ], [ -62.11846923828125, 57.799369812011719 ], [ -61.884860992431641, 57.63311767578125 ], [ -62.526943206787109, 57.488605499267578 ], [ -61.891387939453125, 57.411933898925781 ], [ -61.802639007568359, 57.362495422363281 ], [ -62.013336181640625, 57.247528076171875 ], [ -61.361114501953125, 57.092353820800781 ], [ -61.668888092041016, 56.806102752685547 ], [ -61.903957366943359, 56.793048858642578 ], [ -61.685276031494141, 56.618251800537109 ], [ -62.495555877685547, 56.787769317626953 ], [ -62.058940887451172, 56.830234527587891 ], [ -62.572086334228516, 56.795688629150391 ], [ -61.690834045410156, 56.548049926757812 ] ] ], [ [ [ -55.520835876464844, 71.92803955078125 ], [ -55.413330078125, 71.886940002441406 ], [ -55.801109313964844, 71.886024475097656 ], [ -55.687774658203125, 71.913040161132812 ], [ -55.520835876464844, 71.92803955078125 ] ] ], [ [ [ -95.32861328125, 71.842208862304688 ], [ -95.310546875, 71.737197875976562 ], [ -95.486869812011719, 71.742195129394531 ], [ -95.450286865234375, 71.818878173828125 ], [ -95.32861328125, 71.842208862304688 ] ] ], [ [ [ -73.213333129882812, 71.698593139648438 ], [ -73.352493286132812, 71.557479858398438 ], [ -73.450141906738281, 71.587066650390625 ], [ -73.348342895507812, 71.6583251953125 ], [ -73.213333129882812, 71.698593139648438 ] ] ], [ [ [ -53.218055725097656, 71.526382446289062 ], [ -53.471733093261719, 71.657066345214844 ], [ -52.757503509521484, 71.657623291015625 ], [ -53.1138916015625, 71.538589477539062 ], [ -53.218055725097656, 71.526382446289062 ] ] ], [ [ [ -72.924713134765625, 71.649429321289062 ], [ -72.70916748046875, 71.655258178710938 ], [ -72.661384582519531, 71.601234436035156 ], [ -73.032920837402344, 71.573600769042969 ], [ -72.924713134765625, 71.649429321289062 ] ] ], [ [ [ -73.060546875, 71.294708251953125 ], [ -73.271949768066406, 71.362754821777344 ], [ -73.37860107421875, 71.521240234375 ], [ -72.823890686035156, 71.452346801757812 ], [ -73.060546875, 71.294708251953125 ] ] ], [ [ [ -53.154716491699219, 71.342758178710938 ], [ -52.4183349609375, 71.352767944335938 ], [ -52.328338623046875, 71.289848327636719 ], [ -52.935829162597656, 71.147216796875 ], [ -53.154716491699219, 71.342758178710938 ] ] ], [ [ [ -53.58416748046875, 71.300811767578125 ], [ -53.381942749023438, 71.135269165039062 ], [ -53.452781677246094, 71.049423217773438 ], [ -53.990695953369141, 71.127891540527344 ], [ -53.58416748046875, 71.300811767578125 ] ] ], [ [ [ -96.610549926757812, 71.290542602539062 ], [ -96.546951293945312, 71.289154052734375 ], [ -96.471389770507812, 71.229148864746094 ], [ -96.62860107421875, 71.220260620117188 ], [ -96.610549926757812, 71.290542602539062 ] ] ], [ [ [ -71.044158935546875, 71.14276123046875 ], [ -71.112503051757812, 71.089431762695312 ], [ -71.252922058105469, 71.070274353027344 ], [ -71.2005615234375, 71.125808715820312 ], [ -71.044158935546875, 71.14276123046875 ] ] ], [ [ [ -25.460556030273438, 71.104156494140625 ], [ -25.42138671875, 71.074996948242188 ], [ -25.307710647583008, 71.019638061523438 ], [ -25.579166412353516, 71.102203369140625 ], [ -25.460556030273438, 71.104156494140625 ] ] ], [ [ [ -25.684444427490234, 71.063308715820312 ], [ -25.285835266113281, 70.665817260742188 ], [ -28.131874084472656, 70.44976806640625 ], [ -27.149589538574219, 70.8743896484375 ], [ -25.684444427490234, 71.063308715820312 ] ] ], [ [ [ -71.794723510742188, 71.05303955078125 ], [ -71.371109008789062, 71.011932373046875 ], [ -71.341392517089844, 70.988174438476562 ], [ -71.991668701171875, 70.814697265625 ], [ -72.22430419921875, 70.920677185058594 ], [ -71.794723510742188, 71.05303955078125 ] ] ], [ [ [ -51.974998474121094, 70.973876953125 ], [ -51.586387634277344, 70.8841552734375 ], [ -51.5584716796875, 70.873306274414062 ], [ -52.162216186523438, 70.88665771484375 ], [ -51.974998474121094, 70.973876953125 ] ] ], [ [ [ -27.274444580078125, 70.87469482421875 ], [ -27.575279235839844, 70.754165649414062 ], [ -27.751110076904297, 70.749290466308594 ], [ -27.736942291259766, 70.8822021484375 ], [ -27.274444580078125, 70.87469482421875 ] ] ], [ [ [ -51.523887634277344, 70.647216796875 ], [ -51.694442749023438, 70.677764892578125 ], [ -51.861671447753906, 70.722213745117188 ], [ -51.692497253417969, 70.727767944335938 ], [ -51.523887634277344, 70.647216796875 ] ] ], [ [ [ -100.46112060546875, 70.659988403320312 ], [ -100.218338012695312, 70.564422607421875 ], [ -100.227630615234375, 70.454154968261719 ], [ -100.681381225585938, 70.573043823242188 ], [ -100.46112060546875, 70.659988403320312 ] ] ], [ [ [ -128.12017822265625, 70.597213745117188 ], [ -128.13275146484375, 70.56915283203125 ], [ -128.341110229492188, 70.540679931640625 ], [ -128.234161376953125, 70.656097412109375 ], [ -128.12017822265625, 70.597213745117188 ] ] ], [ [ [ -117.183319091796875, 70.537490844726562 ], [ -117.301666259765625, 70.561920166015625 ], [ -116.88153076171875, 70.550125122070312 ], [ -116.889450073242188, 70.543869018554688 ], [ -117.183319091796875, 70.537490844726562 ] ] ], [ [ [ -51.246391296386719, 70.495819091796875 ], [ -51.380828857421875, 70.504714965820312 ], [ -51.662567138671875, 70.560745239257812 ], [ -51.53277587890625, 70.574432373046875 ], [ -51.246391296386719, 70.495819091796875 ] ] ], [ [ [ -26.146387100219727, 70.528366088867188 ], [ -26.195831298828125, 70.449996948242188 ], [ -26.384723663330078, 70.486923217773438 ], [ -26.244998931884766, 70.556930541992188 ], [ -26.146387100219727, 70.528366088867188 ] ] ], [ [ [ -116.260276794433594, 70.54998779296875 ], [ -116.129295349121094, 70.534149169921875 ], [ -116.495414733886719, 70.521377563476562 ], [ -116.470001220703125, 70.538040161132812 ], [ -116.260276794433594, 70.54998779296875 ] ] ], [ [ [ -54.970832824707031, 70.480819702148438 ], [ -54.737220764160156, 70.43359375 ], [ -54.648471832275391, 70.376502990722656 ], [ -54.934722900390625, 70.375534057617188 ], [ -54.970832824707031, 70.480819702148438 ] ] ], [ [ [ -112.237213134765625, 70.36248779296875 ], [ -111.796661376953125, 70.310256958007812 ], [ -111.6754150390625, 70.308723449707031 ], [ -112.053047180175781, 70.292205810546875 ], [ -112.320205688476562, 70.352691650390625 ], [ -112.237213134765625, 70.36248779296875 ] ] ], [ [ [ -52.552780151367188, 69.40277099609375 ], [ -53.578472137451172, 69.229705810546875 ], [ -54.269447326660156, 69.396102905273438 ], [ -53.399169921875, 69.437484741210938 ], [ -53.565277099609375, 69.496932983398438 ], [ -53.358158111572266, 69.576240539550781 ], [ -53.784027099609375, 69.451377868652344 ], [ -53.993057250976562, 69.501373291015625 ], [ -53.945972442626953, 69.603874206542969 ], [ -54.9879150390625, 69.690254211425781 ], [ -54.402706146240234, 69.680564880371094 ], [ -54.933181762695312, 69.844154357910156 ], [ -54.761249542236328, 69.963600158691406 ], [ -54.240833282470703, 69.914253234863281 ], [ -54.833614349365234, 70.092765808105469 ], [ -54.756114959716797, 70.243034362792969 ], [ -54.30194091796875, 70.316375732421875 ], [ -53.266395568847656, 70.194976806640625 ], [ -51.836524963378906, 69.634422302246094 ], [ -52.552780151367188, 69.40277099609375 ] ] ], [ [ [ -87.265609741210938, 70.113555908203125 ], [ -86.639724731445312, 70.116653442382812 ], [ -86.459442138671875, 70.0091552734375 ], [ -87.375686645507812, 70.098175048828125 ], [ -87.265609741210938, 70.113555908203125 ] ] ], [ [ [ -97.327499389648438, 69.931655883789062 ], [ -97.228752136230469, 69.870819091796875 ], [ -97.492767333984375, 69.917755126953125 ], [ -97.45361328125, 69.963043212890625 ], [ -97.327499389648438, 69.931655883789062 ] ] ], [ [ [ -51.001945495605469, 69.918594360351562 ], [ -50.657634735107422, 69.833465576171875 ], [ -50.965278625488281, 69.72442626953125 ], [ -50.958335876464844, 69.550537109375 ], [ -51.245277404785156, 69.531379699707031 ], [ -51.386665344238281, 69.702064514160156 ], [ -51.011600494384766, 69.878105163574219 ], [ -51.362777709960938, 69.8519287109375 ], [ -51.001945495605469, 69.918594360351562 ] ] ], [ [ [ -99.236663818359375, 68.848876953125 ], [ -99.591682434082031, 69.021934509277344 ], [ -98.406944274902344, 69.303443908691406 ], [ -98.61041259765625, 69.446922302246094 ], [ -98.422149658203125, 69.469703674316406 ], [ -98.531387329101562, 69.584991455078125 ], [ -98.001457214355469, 69.443801879882812 ], [ -98.364158630371094, 69.598869323730469 ], [ -97.945541381835938, 69.893600463867188 ], [ -97.44915771484375, 69.760269165039062 ], [ -97.385345458984375, 69.595405578613281 ], [ -97.281532287597656, 69.696365356445312 ], [ -96.202499389648438, 69.301376342773438 ], [ -96.195266723632812, 69.038314819335938 ], [ -96.044441223144531, 69.226097106933594 ], [ -95.820281982421875, 68.870254516601562 ], [ -95.209724426269531, 68.851097106933594 ], [ -96.530563354492188, 68.444976806640625 ], [ -98.124855041503906, 68.672760009765625 ], [ -98.37652587890625, 68.858734130859375 ], [ -98.519454956054688, 68.747482299804688 ], [ -98.849441528320312, 68.93359375 ], [ -99.236663818359375, 68.848876953125 ] ] ], [ [ [ -91.5352783203125, 69.7269287109375 ], [ -91.560272216796875, 69.728317260742188 ], [ -91.73443603515625, 69.790542602539062 ], [ -91.409164428710938, 69.874984741210938 ], [ -91.5352783203125, 69.7269287109375 ] ] ], [ [ [ -82.636398315429688, 69.87109375 ], [ -82.517227172851562, 69.854156494140625 ], [ -82.427772521972656, 69.784568786621094 ], [ -82.6885986328125, 69.850814819335938 ], [ -82.636398315429688, 69.87109375 ] ] ], [ [ [ -83.576675415039062, 69.78082275390625 ], [ -83.6885986328125, 69.719436645507812 ], [ -83.917221069335938, 69.778594970703125 ], [ -83.53125, 69.789009094238281 ], [ -83.576675415039062, 69.78082275390625 ] ] ], [ [ [ -79.76806640625, 69.752777099609375 ], [ -79.330009460449219, 69.71026611328125 ], [ -80.062492370605469, 69.642768859863281 ], [ -80.016532897949219, 69.492202758789062 ], [ -80.809432983398438, 69.686233520507812 ], [ -79.76806640625, 69.752777099609375 ] ] ], [ [ [ -82.796112060546875, 69.805252075195312 ], [ -82.460281372070312, 69.76165771484375 ], [ -82.454032897949219, 69.717483520507812 ], [ -82.878608703613281, 69.77679443359375 ], [ -82.796112060546875, 69.805252075195312 ] ] ], [ [ [ -78.141952514648438, 69.742477416992188 ], [ -77.945549011230469, 69.636520385742188 ], [ -78.878326416015625, 69.480186462402344 ], [ -78.575836181640625, 69.636383056640625 ], [ -78.141952514648438, 69.742477416992188 ] ] ], [ [ [ -23.256946563720703, 69.726089477539062 ], [ -23.302780151367188, 69.639434814453125 ], [ -23.593473434448242, 69.710685729980469 ], [ -23.444721221923828, 69.736648559570312 ], [ -23.256946563720703, 69.726089477539062 ] ] ], [ [ [ -135.648895263671875, 68.991928100585938 ], [ -135.52459716796875, 69.02325439453125 ], [ -135.9234619140625, 69.09088134765625 ], [ -135.953201293945312, 69.233871459960938 ], [ -135.895004272460938, 69.253471374511719 ], [ -135.661392211914062, 69.145271301269531 ], [ -135.491378784179688, 69.118728637695312 ], [ -135.844436645507812, 69.29901123046875 ], [ -135.17596435546875, 69.259361267089844 ], [ -135.283340454101562, 69.42047119140625 ], [ -135.152572631835938, 69.475677490234375 ], [ -134.438323974609375, 69.4547119140625 ], [ -134.486785888671875, 69.7120361328125 ], [ -133.74945068359375, 69.544845581054688 ], [ -134.390716552734375, 69.117897033691406 ], [ -134.57666015625, 69.102340698242188 ], [ -134.674652099609375, 69.01318359375 ], [ -134.665695190429688, 68.959152221679688 ], [ -134.2308349609375, 68.699722290039062 ], [ -134.825836181640625, 68.978866577148438 ], [ -135.99957275390625, 68.945877075195312 ], [ -135.648895263671875, 68.991928100585938 ] ] ], [ [ [ -67.869720458984375, 69.700820922851562 ], [ -67.920272827148438, 69.521926879882812 ], [ -68.248886108398438, 69.596649169921875 ], [ -67.970840454101562, 69.701934814453125 ], [ -67.869720458984375, 69.700820922851562 ] ] ], [ [ [ -139.12109375, 69.529159545898438 ], [ -139.33123779296875, 69.568870544433594 ], [ -139.120269775390625, 69.649993896484375 ], [ -138.870269775390625, 69.585685729980469 ], [ -139.12109375, 69.529159545898438 ] ] ], [ [ [ -95.4888916015625, 69.565536499023438 ], [ -95.362213134765625, 69.498870849609375 ], [ -95.515838623046875, 69.330825805664062 ], [ -95.740341186523438, 69.330757141113281 ], [ -95.669158935546875, 69.507492065429688 ], [ -95.815826416015625, 69.562759399414062 ], [ -95.862213134765625, 69.348037719726562 ], [ -95.990829467773438, 69.353317260742188 ], [ -95.919998168945312, 69.595260620117188 ], [ -95.4888916015625, 69.565536499023438 ] ] ], [ [ [ -67.507781982421875, 69.494979858398438 ], [ -67.642227172851562, 69.500274658203125 ], [ -67.747085571289062, 69.518463134765625 ], [ -67.309989929199219, 69.550956726074219 ], [ -67.507781982421875, 69.494979858398438 ] ] ], [ [ [ -96.136398315429688, 69.546096801757812 ], [ -96.163330078125, 69.348037719726562 ], [ -96.736106872558594, 69.579299926757812 ], [ -96.316390991210938, 69.526382446289062 ], [ -96.136398315429688, 69.546096801757812 ] ] ], [ [ [ -101.053047180175781, 69.504440307617188 ], [ -101.230293273925781, 69.36859130859375 ], [ -101.187637329101562, 69.472488403320312 ], [ -101.385833740234375, 69.535263061523438 ], [ -101.053047180175781, 69.504440307617188 ] ] ], [ [ [ -77.113616943359375, 69.441650390625 ], [ -76.716400146484375, 69.422210693359375 ], [ -76.647781372070312, 69.334434509277344 ], [ -77.28582763671875, 69.153594970703125 ], [ -77.358055114746094, 69.394706726074219 ], [ -77.113616943359375, 69.441650390625 ] ] ], [ [ [ -90.195266723632812, 69.41693115234375 ], [ -90.329452514648438, 69.235809326171875 ], [ -90.508201599121094, 69.331939697265625 ], [ -90.30194091796875, 69.434417724609375 ], [ -90.195266723632812, 69.41693115234375 ] ] ], [ [ [ -135.297515869140625, 69.304977416992188 ], [ -135.526947021484375, 69.370529174804688 ], [ -135.562774658203125, 69.393600463867188 ], [ -135.3377685546875, 69.388595581054688 ], [ -135.297515869140625, 69.304977416992188 ] ] ], [ [ [ -78.4586181640625, 69.389984130859375 ], [ -78.212013244628906, 69.295677185058594 ], [ -78.840286254882812, 68.908599853515625 ], [ -79.398338317871094, 68.868453979492188 ], [ -78.4586181640625, 69.389984130859375 ] ] ], [ [ [ -90.5755615234375, 69.198593139648438 ], [ -90.7772216796875, 69.272491455078125 ], [ -90.775833129882812, 69.329986572265625 ], [ -90.460830688476562, 69.267486572265625 ], [ -90.5755615234375, 69.198593139648438 ] ] ], [ [ [ -101.520278930664062, 69.197479248046875 ], [ -101.559577941894531, 69.102622985839844 ], [ -101.69561767578125, 69.091789245605469 ], [ -101.699440002441406, 69.204299926757812 ], [ -101.520278930664062, 69.197479248046875 ] ] ], [ [ [ -100.095550537109375, 69.117477416992188 ], [ -99.9788818359375, 69.013885498046875 ], [ -100.003196716308594, 68.941505432128906 ], [ -100.257781982421875, 69.029159545898438 ], [ -100.095550537109375, 69.117477416992188 ] ] ], [ [ [ -100.323623657226562, 68.99609375 ], [ -100.128746032714844, 68.907768249511719 ], [ -100.173744201660156, 68.797065734863281 ], [ -100.62554931640625, 68.76416015625 ], [ -100.599990844726562, 69.00054931640625 ], [ -100.323623657226562, 68.99609375 ] ] ], [ [ [ -89.915008544921875, 68.913314819335938 ], [ -90.0755615234375, 68.948028564453125 ], [ -90.070556640625, 68.98193359375 ], [ -89.913887023925781, 69.005828857421875 ], [ -89.915008544921875, 68.913314819335938 ] ] ], [ [ [ -89.956390380859375, 68.661651611328125 ], [ -89.944442749023438, 68.847488403320312 ], [ -89.782920837402344, 68.763740539550781 ], [ -89.857498168945312, 68.700546264648438 ], [ -89.956390380859375, 68.661651611328125 ] ] ], [ [ [ -101.693878173828125, 68.768051147460938 ], [ -101.831123352050781, 68.566940307617188 ], [ -102.316390991210938, 68.672210693359375 ], [ -102.023063659667969, 68.819442749023438 ], [ -101.693878173828125, 68.768051147460938 ] ] ], [ [ [ -68.418899536132812, 68.810256958007812 ], [ -68.110275268554688, 68.782760620117188 ], [ -67.663536071777344, 68.701446533203125 ], [ -68.457015991210938, 68.7879638671875 ], [ -68.418899536132812, 68.810256958007812 ] ] ], [ [ [ -75.0, 68.6722412109375 ], [ -74.770286560058594, 68.476646423339844 ], [ -74.814445495605469, 68.319572448730469 ], [ -75.416397094726562, 68.521240234375 ], [ -75.280563354492188, 68.709716796875 ], [ -75.0, 68.6722412109375 ] ] ], [ [ [ -52.171943664550781, 68.694976806640625 ], [ -52.327499389648438, 68.63275146484375 ], [ -53.116943359375, 68.564010620117188 ], [ -52.634170532226562, 68.71026611328125 ], [ -52.171943664550781, 68.694976806640625 ] ] ], [ [ [ -74.771942138671875, 68.67303466796875 ], [ -74.652091979980469, 68.653594970703125 ], [ -74.520286560058594, 68.561927795410156 ], [ -74.890289306640625, 68.624984741210938 ], [ -74.771942138671875, 68.67303466796875 ] ] ], [ [ [ -78.795272827148438, 68.438583374023438 ], [ -78.959732055664062, 68.474700927734375 ], [ -78.669723510742188, 68.581100463867188 ], [ -78.892990112304688, 68.650199890136719 ], [ -78.465003967285156, 68.619148254394531 ], [ -78.795272827148438, 68.438583374023438 ] ] ], [ [ [ -51.837501525878906, 68.634994506835938 ], [ -52.049446105957031, 68.574996948242188 ], [ -52.420555114746094, 68.569297790527344 ], [ -52.217216491699219, 68.641937255859375 ], [ -51.837501525878906, 68.634994506835938 ] ] ], [ [ [ -104.682502746582031, 68.573883056640625 ], [ -104.426109313964844, 68.438583374023438 ], [ -105.081680297851562, 68.546371459960938 ], [ -104.9385986328125, 68.583328247070312 ], [ -104.682502746582031, 68.573883056640625 ] ] ], [ [ [ -110.72833251953125, 68.484420776367188 ], [ -110.926101684570312, 68.4658203125 ], [ -111.093955993652344, 68.480117797851562 ], [ -110.821670532226562, 68.54803466796875 ], [ -110.72833251953125, 68.484420776367188 ] ] ], [ [ [ -52.987419128417969, 68.491424560546875 ], [ -52.856391906738281, 68.414993286132812 ], [ -53.210556030273438, 68.404708862304688 ], [ -53.04833984375, 68.489151000976562 ], [ -52.987419128417969, 68.491424560546875 ] ] ], [ [ [ -74.340835571289062, 68.462493896484375 ], [ -74.269729614257812, 68.4547119140625 ], [ -74.077293395996094, 68.330123901367188 ], [ -74.224998474121094, 68.249015808105469 ], [ -74.340835571289062, 68.462493896484375 ] ] ], [ [ [ -82.010009765625, 68.332763671875 ], [ -82.072509765625, 68.30303955078125 ], [ -82.343399047851562, 68.364143371582031 ], [ -82.230560302734375, 68.385543823242188 ], [ -82.010009765625, 68.332763671875 ] ] ], [ [ [ -79.099441528320312, 68.348602294921875 ], [ -78.92999267578125, 68.338882446289062 ], [ -78.803604125976562, 68.271240234375 ], [ -79.0897216796875, 68.170257568359375 ], [ -79.099441528320312, 68.348602294921875 ] ] ], [ [ [ -76.663619995117188, 67.219985961914062 ], [ -77.074447631835938, 67.28082275390625 ], [ -77.320838928222656, 67.704704284667969 ], [ -76.726104736328125, 68.238876342773438 ], [ -75.818069458007812, 68.336654663085938 ], [ -75.00750732421875, 68.139984130859375 ], [ -75.16131591796875, 67.954216003417969 ], [ -75.025146484375, 67.622482299804688 ], [ -75.161117553710938, 67.463882446289062 ], [ -76.663619995117188, 67.219985961914062 ] ] ], [ [ [ -111.528610229492188, 68.290542602539062 ], [ -111.671661376953125, 68.224700927734375 ], [ -111.779022216796875, 68.244010925292969 ], [ -111.703887939453125, 68.299423217773438 ], [ -111.528610229492188, 68.290542602539062 ] ] ], [ [ [ -86.43499755859375, 68.162490844726562 ], [ -86.3961181640625, 67.859710693359375 ], [ -86.571945190429688, 67.728866577148438 ], [ -86.945831298828125, 67.909423828125 ], [ -86.836944580078125, 68.0010986328125 ], [ -86.988327026367188, 68.0816650390625 ], [ -86.711944580078125, 68.299148559570312 ], [ -86.43499755859375, 68.162490844726562 ] ] ], [ [ [ -52.289443969726562, 68.177474975585938 ], [ -51.581672668457031, 68.256942749023438 ], [ -51.45361328125, 68.253044128417969 ], [ -52.007781982421875, 68.120529174804688 ], [ -52.289443969726562, 68.177474975585938 ] ] ], [ [ [ -66.326950073242188, 68.147491455078125 ], [ -66.601943969726562, 68.182479858398438 ], [ -66.607223510742188, 68.217208862304688 ], [ -66.221939086914062, 68.2410888671875 ], [ -66.326950073242188, 68.147491455078125 ] ] ], [ [ [ -109.576950073242188, 68.23248291015625 ], [ -109.772506713867188, 68.139984130859375 ], [ -109.855415344238281, 68.15081787109375 ], [ -109.67694091796875, 68.224151611328125 ], [ -109.576950073242188, 68.23248291015625 ] ] ], [ [ [ -29.725276947021484, 68.222763061523438 ], [ -29.838054656982422, 68.140823364257812 ], [ -30.015419006347656, 68.185401916503906 ], [ -29.930553436279297, 68.236373901367188 ], [ -29.725276947021484, 68.222763061523438 ] ] ], [ [ [ -31.748607635498047, 68.216094970703125 ], [ -31.765890121459961, 68.191902160644531 ], [ -31.692775726318359, 68.172271728515625 ], [ -31.95777702331543, 68.197624206542969 ], [ -31.748607635498047, 68.216094970703125 ] ] ], [ [ [ -104.377212524414062, 68.19970703125 ], [ -104.482772827148438, 68.0797119140625 ], [ -104.555763244628906, 68.146514892578125 ], [ -104.550270080566406, 68.163322448730469 ], [ -104.377212524414062, 68.19970703125 ] ] ], [ [ [ -65.648345947265625, 68.168594360351562 ], [ -65.512786865234375, 68.15277099609375 ], [ -65.498191833496094, 68.125114440917969 ], [ -65.711814880371094, 68.109428405761719 ], [ -65.648345947265625, 68.168594360351562 ] ] ], [ [ [ -73.655471801757812, 68.007705688476562 ], [ -73.348617553710938, 67.828048706054688 ], [ -74.400833129882812, 67.776657104492188 ], [ -74.778060913085938, 68.006103515625 ], [ -74.34320068359375, 68.176788330078125 ], [ -73.655471801757812, 68.007705688476562 ] ] ], [ [ [ -51.950553894042969, 68.0938720703125 ], [ -51.432777404785156, 68.150543212890625 ], [ -51.208332061767578, 68.118865966796875 ], [ -52.005767822265625, 68.077972412109375 ], [ -51.950553894042969, 68.0938720703125 ] ] ], [ [ [ -109.882766723632812, 68.114151000976562 ], [ -109.932220458984375, 68.07916259765625 ], [ -110.25750732421875, 68.039291381835938 ], [ -109.921661376953125, 68.1341552734375 ], [ -109.882766723632812, 68.114151000976562 ] ] ], [ [ [ -53.473052978515625, 68.06915283203125 ], [ -53.349723815917969, 68.111648559570312 ], [ -53.226524353027344, 68.056228637695312 ], [ -53.356948852539062, 68.007492065429688 ], [ -53.473052978515625, 68.06915283203125 ] ] ], [ [ [ -109.447219848632812, 68.092208862304688 ], [ -109.318473815917969, 68.037895202636719 ], [ -109.317916870117188, 67.983451843261719 ], [ -109.540969848632812, 68.049842834472656 ], [ -109.447219848632812, 68.092208862304688 ] ] ], [ [ [ -108.95111083984375, 67.973312377929688 ], [ -108.883750915527344, 67.873176574707031 ], [ -109.198883056640625, 67.972488403320312 ], [ -109.04998779296875, 67.958328247070312 ], [ -108.95111083984375, 67.973312377929688 ] ] ], [ [ [ -108.048606872558594, 67.949142456054688 ], [ -108.091377258300781, 67.880813598632812 ], [ -108.252708435058594, 67.883590698242188 ], [ -108.198036193847656, 67.950820922851562 ], [ -108.048606872558594, 67.949142456054688 ] ] ], [ [ [ -110.816963195800781, 67.940261840820312 ], [ -110.880279541015625, 67.887496948242188 ], [ -111.087913513183594, 67.854354858398438 ], [ -110.83917236328125, 67.958038330078125 ], [ -110.816963195800781, 67.940261840820312 ] ] ], [ [ [ -108.359443664550781, 67.899993896484375 ], [ -108.412216186523438, 67.885818481445312 ], [ -108.664993286132812, 67.870674133300781 ], [ -108.544723510742188, 67.928314208984375 ], [ -108.359443664550781, 67.899993896484375 ] ] ], [ [ [ -53.67083740234375, 67.674148559570312 ], [ -53.753616333007812, 67.736648559570312 ], [ -53.76458740234375, 67.7742919921875 ], [ -53.586803436279297, 67.731231689453125 ], [ -53.67083740234375, 67.674148559570312 ] ] ], [ [ [ -97.337783813476562, 67.721099853515625 ], [ -97.37054443359375, 67.657760620117188 ], [ -97.551734924316406, 67.644081115722656 ], [ -97.560546875, 67.6927490234375 ], [ -97.337783813476562, 67.721099853515625 ] ] ], [ [ [ -108.0897216796875, 67.465545654296875 ], [ -108.132217407226562, 67.639434814453125 ], [ -107.99957275390625, 67.657203674316406 ], [ -107.924858093261719, 67.537620544433594 ], [ -108.0897216796875, 67.465545654296875 ] ] ], [ [ [ -63.9263916015625, 67.633331298828125 ], [ -63.787223815917969, 67.550537109375 ], [ -63.759445190429688, 67.517906188964844 ], [ -64.029586791992188, 67.515403747558594 ], [ -63.9263916015625, 67.633331298828125 ] ] ], [ [ [ -108.169448852539062, 67.44970703125 ], [ -108.275283813476562, 67.481658935546875 ], [ -108.222358703613281, 67.568321228027344 ], [ -108.130538940429688, 67.479293823242188 ], [ -108.169448852539062, 67.44970703125 ] ] ], [ [ [ -108.381942749023438, 67.466659545898438 ], [ -108.458892822265625, 67.488037109375 ], [ -108.491378784179688, 67.563034057617188 ], [ -108.297500610351562, 67.557205200195312 ], [ -108.381942749023438, 67.466659545898438 ] ] ], [ [ [ -107.882766723632812, 67.462493896484375 ], [ -107.91082763671875, 67.310531616210938 ], [ -108.084442138671875, 67.381362915039062 ], [ -108.064865112304688, 67.439842224121094 ], [ -107.882766723632812, 67.462493896484375 ] ] ], [ [ [ -63.456108093261719, 67.264434814453125 ], [ -63.763618469238281, 67.272491455078125 ], [ -63.829727172851562, 67.284149169921875 ], [ -63.357780456542969, 67.293869018554688 ], [ -63.456108093261719, 67.264434814453125 ] ] ], [ [ [ -95.314712524414062, 67.23858642578125 ], [ -95.373611450195312, 67.196365356445312 ], [ -95.550071716308594, 67.231788635253906 ], [ -95.39111328125, 67.263046264648438 ], [ -95.314712524414062, 67.23858642578125 ] ] ], [ [ [ -107.581680297851562, 67.196365356445312 ], [ -107.400558471679688, 67.113037109375 ], [ -107.407783508300781, 67.083053588867188 ], [ -107.549728393554688, 67.089981079101562 ], [ -107.581680297851562, 67.196365356445312 ] ] ], [ [ [ -62.894599914550781, 67.059112548828125 ], [ -62.631942749023438, 67.176925659179688 ], [ -62.376590728759766, 67.166091918945312 ], [ -62.75250244140625, 67.010543823242188 ], [ -62.894599914550781, 67.059112548828125 ] ] ], [ [ [ -62.961112976074219, 67.054702758789062 ], [ -62.915275573730469, 67.012214660644531 ], [ -63.137016296386719, 67.058517456054688 ], [ -63.100082397460938, 67.0797119140625 ], [ -62.961112976074219, 67.054702758789062 ] ] ], [ [ [ -107.791107177734375, 66.988311767578125 ], [ -107.826950073242188, 66.8983154296875 ], [ -107.945823669433594, 66.854011535644531 ], [ -107.834037780761719, 67.006240844726562 ], [ -107.791107177734375, 66.988311767578125 ] ] ], [ [ [ -52.868232727050781, 66.897216796875 ], [ -53.205833435058594, 66.822769165039062 ], [ -53.464164733886719, 66.798873901367188 ], [ -53.345832824707031, 66.873870849609375 ], [ -52.868232727050781, 66.897216796875 ] ] ], [ [ [ -164.77001953125, 66.53082275390625 ], [ -164.876922607421875, 66.502777099609375 ], [ -165.468460083007812, 66.41290283203125 ], [ -165.11749267578125, 66.486099243164062 ], [ -164.77001953125, 66.53082275390625 ] ] ], [ [ [ -66.820846557617188, 66.388046264648438 ], [ -66.639724731445312, 66.340545654296875 ], [ -66.574317932128906, 66.312339782714844 ], [ -66.957084655761719, 66.408454895019531 ], [ -66.820846557617188, 66.388046264648438 ] ] ], [ [ [ -82.935546875, 66.251388549804688 ], [ -83.080291748046875, 66.196640014648438 ], [ -83.29833984375, 66.313873291015625 ], [ -83.252227783203125, 66.344985961914062 ], [ -82.935546875, 66.251388549804688 ] ] ], [ [ [ -62.23138427734375, 66.269439697265625 ], [ -62.199165344238281, 66.216934204101562 ], [ -62.428333282470703, 66.231101989746094 ], [ -62.282779693603516, 66.278877258300781 ], [ -62.23138427734375, 66.269439697265625 ] ] ], [ [ [ -166.210540771484375, 66.208877563476562 ], [ -166.5877685546875, 66.116378784179688 ], [ -166.663223266601562, 66.105293273925781 ], [ -166.171539306640625, 66.219017028808594 ], [ -166.210540771484375, 66.208877563476562 ] ] ], [ [ [ -83.92138671875, 66.009719848632812 ], [ -83.69415283203125, 65.924697875976562 ], [ -83.727493286132812, 65.799713134765625 ], [ -83.212638854980469, 65.708183288574219 ], [ -83.829727172851562, 65.644989013671875 ], [ -83.686172485351562, 65.750541687011719 ], [ -84.133331298828125, 65.760818481445312 ], [ -84.123611450195312, 65.9002685546875 ], [ -84.470695495605469, 66.130821228027344 ], [ -83.92138671875, 66.009719848632812 ] ] ], [ [ [ -53.633331298828125, 66.045822143554688 ], [ -53.672500610351562, 66.08984375 ], [ -53.427223205566406, 66.082550048828125 ], [ -53.525276184082031, 66.04248046875 ], [ -53.633331298828125, 66.045822143554688 ] ] ], [ [ [ -84.9102783203125, 66.0 ], [ -84.586669921875, 65.69219970703125 ], [ -84.667770385742188, 65.560531616210938 ], [ -85.118057250976562, 65.76470947265625 ], [ -85.173049926757812, 65.994705200195312 ], [ -84.9102783203125, 66.0 ] ] ], [ [ [ -36.700553894042969, 65.790542602539062 ], [ -36.749031066894531, 65.907211303710938 ], [ -36.502780914306641, 65.951026916503906 ], [ -36.590415954589844, 65.812759399414062 ], [ -36.700553894042969, 65.790542602539062 ] ] ], [ [ [ -82.217498779296875, 64.698593139648438 ], [ -81.7630615234375, 64.5010986328125 ], [ -81.776870727539062, 64.316368103027344 ], [ -81.593887329101562, 64.18963623046875 ], [ -81.989372253417969, 63.996654510498047 ], [ -80.942489624023438, 63.990547180175781 ], [ -80.890838623046875, 64.11553955078125 ], [ -80.174369812011719, 63.771171569824219 ], [ -81.076400756835938, 63.451385498046875 ], [ -82.4798583984375, 63.683605194091797 ], [ -82.366729736328125, 63.907558441162109 ], [ -83.092918395996094, 63.957077026367188 ], [ -82.96221923828125, 64.143043518066406 ], [ -83.072784423828125, 64.1866455078125 ], [ -83.54833984375, 64.10247802734375 ], [ -83.678047180175781, 64.010963439941406 ], [ -83.634925842285156, 63.77069091796875 ], [ -85.266403198242188, 63.11749267578125 ], [ -85.584312438964844, 63.171306610107422 ], [ -85.717498779296875, 63.716102600097656 ], [ -86.922225952148438, 63.552772521972656 ], [ -87.225837707519531, 63.646102905273438 ], [ -86.915283203125, 63.914436340332031 ], [ -86.196662902832031, 64.09637451171875 ], [ -86.401390075683594, 64.43914794921875 ], [ -86.15374755859375, 64.925331115722656 ], [ -86.151535034179688, 65.389717102050781 ], [ -85.9864501953125, 65.73699951171875 ], [ -85.565277099609375, 65.930267333984375 ], [ -85.501945495605469, 65.799705505371094 ], [ -85.159446716308594, 65.779014587402344 ], [ -85.051521301269531, 65.614837646484375 ], [ -85.305931091308594, 65.542274475097656 ], [ -84.927635192871094, 65.211936950683594 ], [ -84.555686950683594, 65.47998046875 ], [ -84.141387939453125, 65.219985961914062 ], [ -83.408615112304688, 65.135543823242188 ], [ -83.201171875, 64.942886352539062 ], [ -82.217498779296875, 64.698593139648438 ] ] ], [ [ [ -36.356109619140625, 65.820541381835938 ], [ -36.273056030273438, 65.915817260742188 ], [ -36.187564849853516, 65.87713623046875 ], [ -36.319725036621094, 65.821929931640625 ], [ -36.356109619140625, 65.820541381835938 ] ] ], [ [ [ -37.743057250976562, 65.568603515625 ], [ -37.93499755859375, 65.594985961914062 ], [ -37.954166412353516, 65.796928405761719 ], [ -37.675277709960938, 65.904708862304688 ], [ -37.270000457763672, 65.758186340332031 ], [ -37.498126983642578, 65.802070617675781 ], [ -37.314445495605469, 65.671371459960938 ], [ -37.743057250976562, 65.568603515625 ] ] ], [ [ [ -83.3477783203125, 65.832489013671875 ], [ -83.485275268554688, 65.800811767578125 ], [ -83.585563659667969, 65.851791381835938 ], [ -83.288124084472656, 65.836372375488281 ], [ -83.3477783203125, 65.832489013671875 ] ] ], [ [ [ -36.842498779296875, 65.733596801757812 ], [ -36.942771911621094, 65.819717407226562 ], [ -36.776947021484375, 65.863876342773438 ], [ -36.787506103515625, 65.75555419921875 ], [ -36.842498779296875, 65.733596801757812 ] ] ], [ [ [ -62.258613586425781, 65.728591918945312 ], [ -62.133609771728516, 65.654296875 ], [ -62.484165191650391, 65.724014282226562 ], [ -62.466457366943359, 65.744140625 ], [ -62.258613586425781, 65.728591918945312 ] ] ], [ [ [ -37.023887634277344, 65.585540771484375 ], [ -37.105278015136719, 65.60693359375 ], [ -37.21319580078125, 65.681922912597656 ], [ -36.910133361816406, 65.644020080566406 ], [ -37.023887634277344, 65.585540771484375 ] ] ], [ [ [ -53.188331604003906, 65.573883056640625 ], [ -53.16583251953125, 65.63165283203125 ], [ -52.848331451416016, 65.642974853515625 ], [ -52.995002746582031, 65.548873901367188 ], [ -53.188331604003906, 65.573883056640625 ] ] ], [ [ [ -52.928337097167969, 65.425262451171875 ], [ -53.0130615234375, 65.449417114257812 ], [ -53.086666107177734, 65.494979858398438 ], [ -52.872356414794922, 65.5111083984375 ], [ -52.928337097167969, 65.425262451171875 ] ] ], [ [ [ -39.601943969726562, 65.274703979492188 ], [ -39.785835266113281, 65.317214965820312 ], [ -39.803607940673828, 65.335197448730469 ], [ -39.496250152587891, 65.323463439941406 ], [ -39.601943969726562, 65.274703979492188 ] ] ], [ [ [ -40.191108703613281, 64.4305419921875 ], [ -40.486804962158203, 64.488868713378906 ], [ -40.571945190429688, 64.682479858398438 ], [ -40.86138916015625, 64.910957336425781 ], [ -40.542778015136719, 64.844146728515625 ], [ -40.191108703613281, 64.4305419921875 ] ] ], [ [ [ -65.266403198242188, 64.693313598632812 ], [ -65.468887329101562, 64.519149780273438 ], [ -65.689994812011719, 64.522071838378906 ], [ -65.435821533203125, 64.696365356445312 ], [ -65.266403198242188, 64.693313598632812 ] ] ], [ [ [ -73.509170532226562, 64.552474975585938 ], [ -73.556381225585938, 64.313728332519531 ], [ -73.652923583984375, 64.318740844726562 ], [ -73.678886413574219, 64.529151916503906 ], [ -73.509170532226562, 64.552474975585938 ] ] ], [ [ [ -51.109725952148438, 64.549713134765625 ], [ -51.278331756591797, 64.384017944335938 ], [ -51.416946411132812, 64.393600463867188 ], [ -51.255279541015625, 64.541656494140625 ], [ -51.109725952148438, 64.549713134765625 ] ] ], [ [ [ -50.807502746582031, 64.522491455078125 ], [ -51.151107788085938, 64.2530517578125 ], [ -51.339164733886719, 64.241096496582031 ], [ -51.025001525878906, 64.549423217773438 ], [ -50.807502746582031, 64.522491455078125 ] ] ], [ [ [ -74.310409545898438, 64.49884033203125 ], [ -74.228607177734375, 64.451095581054688 ], [ -74.174919128417969, 64.436782836914062 ], [ -74.438323974609375, 64.451797485351562 ], [ -74.310409545898438, 64.49884033203125 ] ] ], [ [ [ -64.897506713867188, 64.408599853515625 ], [ -64.82000732421875, 64.379425048828125 ], [ -64.772148132324219, 64.344917297363281 ], [ -64.877212524414062, 64.313308715820312 ], [ -64.897506713867188, 64.408599853515625 ] ] ], [ [ [ -73.7308349609375, 64.386383056640625 ], [ -73.700828552246094, 64.318458557128906 ], [ -73.704727172851562, 64.268875122070312 ], [ -73.8336181640625, 64.3316650390625 ], [ -73.7308349609375, 64.386383056640625 ] ] ], [ [ [ -51.328338623046875, 64.314697265625 ], [ -51.567222595214844, 64.256103515625 ], [ -51.601390838623047, 64.279983520507812 ], [ -51.428886413574219, 64.363876342773438 ], [ -51.328338623046875, 64.314697265625 ] ] ], [ [ [ -64.998886108398438, 64.35443115234375 ], [ -64.886604309082031, 64.283737182617188 ], [ -64.989166259765625, 64.209152221679688 ], [ -65.114303588867188, 64.326522827148438 ], [ -64.998886108398438, 64.35443115234375 ] ] ], [ [ [ -41.185272216796875, 64.257492065429688 ], [ -41.355003356933594, 64.26416015625 ], [ -41.373889923095703, 64.2823486328125 ], [ -41.125556945800781, 64.288314819335938 ], [ -41.185272216796875, 64.257492065429688 ] ] ], [ [ [ -41.019721984863281, 64.1927490234375 ], [ -40.970832824707031, 64.286376953125 ], [ -40.674171447753906, 64.291366577148438 ], [ -40.679443359375, 64.208602905273438 ], [ -41.019721984863281, 64.1927490234375 ] ] ], [ [ [ -77.625, 63.997772216796875 ], [ -77.748611450195312, 63.926105499267578 ], [ -77.980690002441406, 63.97235107421875 ], [ -77.54486083984375, 64.020263671875 ], [ -77.625, 63.997772216796875 ] ] ], [ [ [ -64.5494384765625, 63.895271301269531 ], [ -64.3880615234375, 63.699020385742188 ], [ -64.916397094726562, 63.806381225585938 ], [ -64.710556030273438, 63.908882141113281 ], [ -64.5494384765625, 63.895271301269531 ] ] ], [ [ [ -64.334091186523438, 63.852081298828125 ], [ -64.183326721191406, 63.866378784179688 ], [ -64.180831909179688, 63.785270690917969 ], [ -64.398269653320312, 63.849437713623047 ], [ -64.334091186523438, 63.852081298828125 ] ] ], [ [ [ -168.873321533203125, 63.15277099609375 ], [ -169.321151733398438, 63.184574127197266 ], [ -169.670425415039062, 62.944149017333984 ], [ -169.8052978515625, 63.125259399414062 ], [ -170.568603515625, 63.390830993652344 ], [ -171.006103515625, 63.435817718505859 ], [ -170.82806396484375, 63.414985656738281 ], [ -170.595001220703125, 63.371932983398438 ], [ -170.54364013671875, 63.359710693359375 ], [ -170.466766357421875, 63.334182739257812 ], [ -170.401123046875, 63.303878784179688 ], [ -170.363800048828125, 63.28411865234375 ], [ -170.341888427734375, 63.271125793457031 ], [ -170.31585693359375, 63.253875732421875 ], [ -170.296112060546875, 63.238044738769531 ], [ -170.960845947265625, 63.427772521972656 ], [ -171.549163818359375, 63.327766418457031 ], [ -171.850830078125, 63.50860595703125 ], [ -171.729171752929688, 63.789371490478516 ], [ -171.540008544921875, 63.613880157470703 ], [ -170.974456787109375, 63.573318481445312 ], [ -170.300018310546875, 63.69415283203125 ], [ -169.524444580078125, 63.354156494140625 ], [ -168.70086669921875, 63.290542602539062 ], [ -168.873321533203125, 63.15277099609375 ] ] ], [ [ [ -64.054840087890625, 63.736595153808594 ], [ -64.027366638183594, 63.695892333984375 ], [ -64.212089538574219, 63.709297180175781 ], [ -64.170684814453125, 63.74652099609375 ], [ -64.054840087890625, 63.736595153808594 ] ] ], [ [ [ -72.471389770507812, 63.700828552246094 ], [ -72.599586486816406, 63.642078399658203 ], [ -72.781944274902344, 63.662212371826172 ], [ -72.506668090820312, 63.70721435546875 ], [ -72.471389770507812, 63.700828552246094 ] ] ], [ [ [ -76.681610107421875, 63.481353759765625 ], [ -76.544509887695312, 63.4632568359375 ], [ -76.984161376953125, 63.406379699707031 ], [ -77.455558776855469, 63.647769927978516 ], [ -77.061386108398438, 63.672767639160156 ], [ -76.681610107421875, 63.481353759765625 ] ] ], [ [ [ -64.3255615234375, 63.637496948242188 ], [ -64.26251220703125, 63.421104431152344 ], [ -64.065834045410156, 63.269435882568359 ], [ -64.42193603515625, 63.471656799316406 ], [ -64.490554809570312, 63.62054443359375 ], [ -64.3255615234375, 63.637496948242188 ] ] ], [ [ [ -64.17193603515625, 63.63360595703125 ], [ -64.077781677246094, 63.543811798095703 ], [ -64.097221374511719, 63.480545043945312 ], [ -64.20916748046875, 63.574996948242188 ], [ -64.17193603515625, 63.63360595703125 ] ] ], [ [ [ -162.34942626953125, 63.588600158691406 ], [ -162.377471923828125, 63.544441223144531 ], [ -162.70361328125, 63.571662902832031 ], [ -162.56195068359375, 63.635269165039062 ], [ -162.34942626953125, 63.588600158691406 ] ] ], [ [ [ -64.954727172851562, 63.553878784179688 ], [ -64.86749267578125, 63.461662292480469 ], [ -64.854446411132812, 63.385826110839844 ], [ -65.052497863769531, 63.550273895263672 ], [ -64.954727172851562, 63.553878784179688 ] ] ], [ [ [ -90.720001220703125, 63.543052673339844 ], [ -90.676658630371094, 63.5111083984375 ], [ -90.967086791992188, 63.548049926757812 ], [ -90.7711181640625, 63.551933288574219 ], [ -90.720001220703125, 63.543052673339844 ] ] ], [ [ [ -41.115005493164062, 63.209716796875 ], [ -41.430831909179688, 63.231376647949219 ], [ -41.872219085693359, 63.464298248291016 ], [ -41.673614501953125, 63.489715576171875 ], [ -41.115005493164062, 63.209716796875 ] ] ], [ [ [ -78.212821960449219, 63.496089935302734 ], [ -77.680557250976562, 63.434432983398438 ], [ -77.495132446289062, 63.271450042724609 ], [ -77.9466552734375, 63.091102600097656 ], [ -78.572509765625, 63.437492370605469 ], [ -78.212821960449219, 63.496089935302734 ] ] ], [ [ [ -41.216659545898438, 63.118324279785156 ], [ -41.401939392089844, 63.132492065429688 ], [ -41.464447021484375, 63.186103820800781 ], [ -41.278884887695312, 63.192764282226562 ], [ -41.216659545898438, 63.118324279785156 ] ] ], [ [ [ -50.540000915527344, 63.195266723632812 ], [ -50.470966339111328, 63.151657104492188 ], [ -50.677780151367188, 63.133045196533203 ], [ -50.612220764160156, 63.20166015625 ], [ -50.540000915527344, 63.195266723632812 ] ] ], [ [ [ -50.753890991210938, 63.182212829589844 ], [ -50.6834716796875, 63.114162445068359 ], [ -50.886390686035156, 63.119991302490234 ], [ -50.792362213134766, 63.184574127197266 ], [ -50.753890991210938, 63.182212829589844 ] ] ], [ [ [ -41.482215881347656, 63.054435729980469 ], [ -41.426948547363281, 63.10943603515625 ], [ -41.305137634277344, 63.071662902832031 ], [ -41.353889465332031, 63.044998168945312 ], [ -41.482215881347656, 63.054435729980469 ] ] ], [ [ [ -41.569999694824219, 62.869438171386719 ], [ -41.586666107177734, 63.004718780517578 ], [ -41.455417633056641, 63.014026641845703 ], [ -41.494163513183594, 62.941932678222656 ], [ -41.569999694824219, 62.869438171386719 ] ] ], [ [ [ -82.185821533203125, 62.979988098144531 ], [ -81.86798095703125, 62.924991607666016 ], [ -81.92950439453125, 62.7203369140625 ], [ -82.993751525878906, 62.207077026367188 ], [ -83.707778930664062, 62.143745422363281 ], [ -83.943878173828125, 62.4244384765625 ], [ -83.374160766601562, 62.906936645507812 ], [ -82.185821533203125, 62.979988098144531 ] ] ], [ [ [ -70.587783813476562, 62.774162292480469 ], [ -70.211807250976562, 62.579715728759766 ], [ -70.746383666992188, 62.554710388183594 ], [ -70.846664428710938, 62.766105651855469 ], [ -71.240966796875, 62.878879547119141 ], [ -70.587783813476562, 62.774162292480469 ] ] ], [ [ [ -42.404441833496094, 62.694709777832031 ], [ -42.32611083984375, 62.799720764160156 ], [ -41.862781524658203, 62.737075805664062 ], [ -42.203334808349609, 62.729156494140625 ], [ -42.066108703613281, 62.682769775390625 ], [ -42.404441833496094, 62.694709777832031 ] ] ], [ [ [ -74.4808349609375, 62.740272521972656 ], [ -74.012504577636719, 62.663742065429688 ], [ -73.959587097167969, 62.614437103271484 ], [ -74.649520874023438, 62.717071533203125 ], [ -74.4808349609375, 62.740272521972656 ] ] ], [ [ [ -64.884735107421875, 62.594154357910156 ], [ -64.969032287597656, 62.530548095703125 ], [ -65.137367248535156, 62.544994354248047 ], [ -65.003067016601562, 62.598876953125 ], [ -64.884735107421875, 62.594154357910156 ] ] ], [ [ [ -78.0191650390625, 62.591934204101562 ], [ -77.867218017578125, 62.589157104492188 ], [ -77.839309692382812, 62.553466796875 ], [ -78.113746643066406, 62.566379547119141 ], [ -78.0191650390625, 62.591934204101562 ] ] ], [ [ [ -42.184440612792969, 62.482490539550781 ], [ -42.279029846191406, 62.521938323974609 ], [ -42.29534912109375, 62.573535919189453 ], [ -42.125556945800781, 62.559989929199219 ], [ -42.184440612792969, 62.482490539550781 ] ] ], [ [ [ -64.382766723632812, 62.525825500488281 ], [ -64.5947265625, 62.366798400878906 ], [ -64.965835571289062, 62.465827941894531 ], [ -64.8155517578125, 62.559715270996094 ], [ -64.382766723632812, 62.525825500488281 ] ] ], [ [ [ -79.54132080078125, 61.799789428710938 ], [ -79.836952209472656, 61.568328857421875 ], [ -80.277778625488281, 61.812423706054688 ], [ -80.26763916015625, 62.109298706054688 ], [ -79.942634582519531, 62.387355804443359 ], [ -79.446380615234375, 62.381378173828125 ], [ -79.261810302734375, 62.161243438720703 ], [ -79.54132080078125, 61.799789428710938 ] ] ], [ [ [ -92.158340454101562, 62.390548706054688 ], [ -92.306106567382812, 62.351661682128906 ], [ -92.372215270996094, 62.389438629150391 ], [ -92.3194580078125, 62.415267944335938 ], [ -92.158340454101562, 62.390548706054688 ] ] ], [ [ [ -65.068069458007812, 61.923881530761719 ], [ -64.890144348144531, 61.827774047851562 ], [ -64.827224731445312, 61.759788513183594 ], [ -65.251953125, 61.869712829589844 ], [ -65.068069458007812, 61.923881530761719 ] ] ], [ [ [ -49.412216186523438, 61.915824890136719 ], [ -49.523056030273438, 61.877212524414062 ], [ -49.634723663330078, 61.928188323974609 ], [ -49.419448852539062, 61.930549621582031 ], [ -49.412216186523438, 61.915824890136719 ] ] ], [ [ [ -93.086669921875, 61.829437255859375 ], [ -93.215003967285156, 61.877349853515625 ], [ -93.224861145019531, 61.910686492919922 ], [ -92.965003967285156, 61.882701873779297 ], [ -93.086669921875, 61.829437255859375 ] ] ], [ [ [ -42.248336791992188, 61.768600463867188 ], [ -42.165138244628906, 61.854022979736328 ], [ -42.084442138671875, 61.874992370605469 ], [ -42.118751525878906, 61.775405883789062 ], [ -42.248336791992188, 61.768600463867188 ] ] ], [ [ [ -65.713623046875, 61.824165344238281 ], [ -65.719451904296875, 61.754165649414062 ], [ -65.945960998535156, 61.792980194091797 ], [ -65.789993286132812, 61.865547180175781 ], [ -65.713623046875, 61.824165344238281 ] ] ], [ [ [ -64.65972900390625, 61.588043212890625 ], [ -64.8699951171875, 61.323329925537109 ], [ -65.487777709960938, 61.599433898925781 ], [ -65.036392211914062, 61.693603515625 ], [ -64.65972900390625, 61.588043212890625 ] ] ], [ [ [ -48.520835876464844, 61.35638427734375 ], [ -48.583328247070312, 61.312767028808594 ], [ -48.828754425048828, 61.332839965820312 ], [ -48.713615417480469, 61.36749267578125 ], [ -48.520835876464844, 61.35638427734375 ] ] ], [ [ [ -48.200553894042969, 61.091659545898438 ], [ -48.051181793212891, 61.062839508056641 ], [ -48.369441986083984, 61.081520080566406 ], [ -48.265007019042969, 61.098602294921875 ], [ -48.200553894042969, 61.091659545898438 ] ] ], [ [ [ -46.2066650390625, 60.885269165039062 ], [ -46.758476257324219, 60.749717712402344 ], [ -46.844165802001953, 60.763050079345703 ], [ -46.206947326660156, 60.949714660644531 ], [ -46.2066650390625, 60.885269165039062 ] ] ], [ [ [ -148.02972412109375, 60.927772521972656 ], [ -147.912368774414062, 60.817283630371094 ], [ -148.133621215820312, 60.802772521972656 ], [ -148.10443115234375, 60.914714813232422 ], [ -148.02972412109375, 60.927772521972656 ] ] ], [ [ [ -42.9263916015625, 60.883049011230469 ], [ -42.751113891601562, 60.903045654296875 ], [ -42.626106262207031, 60.885269165039062 ], [ -42.750282287597656, 60.854438781738281 ], [ -42.9263916015625, 60.883049011230469 ] ] ], [ [ [ -47.758338928222656, 60.800270080566406 ], [ -47.657772064208984, 60.755271911621094 ], [ -47.898471832275391, 60.677078247070312 ], [ -48.2388916015625, 60.795547485351562 ], [ -47.758338928222656, 60.800270080566406 ] ] ], [ [ [ -78.226669311523438, 60.808883666992188 ], [ -78.397232055664062, 60.743881225585938 ], [ -78.698051452636719, 60.722908020019531 ], [ -78.573623657226562, 60.784164428710938 ], [ -78.226669311523438, 60.808883666992188 ] ] ], [ [ [ -46.2772216796875, 60.772216796875 ], [ -46.350414276123047, 60.667495727539062 ], [ -46.499443054199219, 60.69915771484375 ], [ -46.423332214355469, 60.748603820800781 ], [ -46.2772216796875, 60.772216796875 ] ] ], [ [ [ -148.138336181640625, 60.756103515625 ], [ -148.094573974609375, 60.677494049072266 ], [ -148.145004272460938, 60.640968322753906 ], [ -148.232086181640625, 60.723598480224609 ], [ -148.138336181640625, 60.756103515625 ] ] ], [ [ [ -45.929168701171875, 60.703048706054688 ], [ -46.096527099609375, 60.635272979736328 ], [ -46.200691223144531, 60.675128936767578 ], [ -46.006950378417969, 60.706382751464844 ], [ -45.929168701171875, 60.703048706054688 ] ] ], [ [ [ -45.783332824707031, 60.660820007324219 ], [ -45.954719543457031, 60.615547180175781 ], [ -45.997085571289062, 60.629016876220703 ], [ -45.966110229492188, 60.682907104492188 ], [ -45.783332824707031, 60.660820007324219 ] ] ], [ [ [ -145.78057861328125, 60.573883056640625 ], [ -146.129425048828125, 60.470268249511719 ], [ -146.32806396484375, 60.463607788085938 ], [ -145.94195556640625, 60.588882446289062 ], [ -145.78057861328125, 60.573883056640625 ] ] ], [ [ [ -172.280029296875, 60.302772521972656 ], [ -172.599151611328125, 60.324996948242188 ], [ -173.051010131835938, 60.495819091796875 ], [ -172.914886474609375, 60.601516723632812 ], [ -172.280029296875, 60.302772521972656 ] ] ], [ [ [ -67.948478698730469, 60.561367034912109 ], [ -67.85333251953125, 60.375267028808594 ], [ -68.387222290039062, 60.240829467773438 ], [ -68.129440307617188, 60.570549011230469 ], [ -67.948478698730469, 60.561367034912109 ] ] ], [ [ [ -147.633636474609375, 60.422492980957031 ], [ -147.75750732421875, 60.16790771484375 ], [ -147.90972900390625, 60.234718322753906 ], [ -147.779861450195312, 60.478736877441406 ], [ -147.633636474609375, 60.422492980957031 ] ] ], [ [ [ -64.521713256835938, 60.31072998046875 ], [ -64.605972290039062, 60.351940155029297 ], [ -64.7288818359375, 60.363327026367188 ], [ -64.867912292480469, 60.45318603515625 ], [ -64.4254150390625, 60.399299621582031 ], [ -64.521713256835938, 60.31072998046875 ] ] ], [ [ [ -146.096954345703125, 60.392768859863281 ], [ -146.59735107421875, 60.238880157470703 ], [ -146.485549926757812, 60.365688323974609 ], [ -146.722824096679688, 60.376235961914062 ], [ -146.580841064453125, 60.482490539550781 ], [ -146.096954345703125, 60.392768859863281 ] ] ], [ [ [ -166.109161376953125, 60.410270690917969 ], [ -165.684341430664062, 60.296520233154297 ], [ -165.555435180664062, 59.928737640380859 ], [ -166.209197998046875, 59.857490539550781 ], [ -166.167266845703125, 59.753318786621094 ], [ -167.418060302734375, 60.189422607421875 ], [ -166.109161376953125, 60.410270690917969 ] ] ], [ [ [ -145.088043212890625, 60.399436950683594 ], [ -145.12652587890625, 60.305686950683594 ], [ -145.280838012695312, 60.332355499267578 ], [ -145.09832763671875, 60.415542602539062 ], [ -145.088043212890625, 60.399436950683594 ] ] ], [ [ [ -45.1522216796875, 60.376380920410156 ], [ -45.187358856201172, 60.263053894042969 ], [ -45.409027099609375, 60.183254241943359 ], [ -45.349861145019531, 60.384853363037109 ], [ -45.1522216796875, 60.376380920410156 ] ] ], [ [ [ -147.978607177734375, 60.371932983398438 ], [ -148.020431518554688, 60.289165496826172 ], [ -148.14044189453125, 60.30499267578125 ], [ -148.0716552734375, 60.368049621582031 ], [ -147.978607177734375, 60.371932983398438 ] ] ], [ [ [ -146.937774658203125, 60.286384582519531 ], [ -147.5311279296875, 59.851936340332031 ], [ -147.9102783203125, 59.792564392089844 ], [ -147.193603515625, 60.353324890136719 ], [ -146.937774658203125, 60.286384582519531 ] ] ], [ [ [ -148.036956787109375, 60.184158325195312 ], [ -148.154876708984375, 60.040271759033203 ], [ -148.307083129882812, 60.027633666992188 ], [ -148.22442626953125, 60.108329772949219 ], [ -148.036956787109375, 60.184158325195312 ] ] ], [ [ [ -43.572776794433594, 59.914710998535156 ], [ -43.914302825927734, 59.996379852294922 ], [ -44.131801605224609, 60.143466949462891 ], [ -43.133747100830078, 60.058738708496094 ], [ -43.574310302734375, 60.075687408447266 ], [ -43.572776794433594, 59.914710998535156 ] ] ], [ [ [ -44.193328857421875, 60.162490844726562 ], [ -44.147502899169922, 60.089714050292969 ], [ -44.014583587646484, 60.043186187744141 ], [ -44.156108856201172, 60.038192749023438 ], [ -44.193328857421875, 60.162490844726562 ] ] ], [ [ [ -147.87664794921875, 60.1038818359375 ], [ -148.120269775390625, 59.995410919189453 ], [ -148.138763427734375, 59.998188018798828 ], [ -147.9637451171875, 60.153324127197266 ], [ -147.87664794921875, 60.1038818359375 ] ] ], [ [ [ -44.264724731445312, 60.11444091796875 ], [ -44.307502746582031, 59.977767944335938 ], [ -44.49749755859375, 60.0111083984375 ], [ -44.430000305175781, 60.142768859863281 ], [ -44.264724731445312, 60.11444091796875 ] ] ], [ [ [ -147.823883056640625, 60.049163818359375 ], [ -147.893890380859375, 59.988327026367188 ], [ -148.042236328125, 59.947349548339844 ], [ -147.883331298828125, 60.067214965820312 ], [ -147.823883056640625, 60.049163818359375 ] ] ], [ [ [ -43.501945495605469, 59.9033203125 ], [ -43.457500457763672, 60.035690307617188 ], [ -43.341873168945312, 60.008815765380859 ], [ -43.395832061767578, 59.928325653076172 ], [ -43.501945495605469, 59.9033203125 ] ] ], [ [ [ -44.145545959472656, 59.899513244628906 ], [ -44.318752288818359, 59.871517181396484 ], [ -44.380279541015625, 59.909431457519531 ], [ -43.994651794433594, 60.005619049072266 ], [ -44.145545959472656, 59.899513244628906 ] ] ], [ [ [ -144.238037109375, 59.987770080566406 ], [ -144.4111328125, 59.9163818359375 ], [ -144.60137939453125, 59.810821533203125 ], [ -144.4425048828125, 59.925270080566406 ], [ -144.238037109375, 59.987770080566406 ] ] ], [ [ [ -43.9022216796875, 59.790275573730469 ], [ -44.10986328125, 59.867351531982422 ], [ -43.962776184082031, 59.979293823242188 ], [ -43.6370849609375, 59.865688323974609 ], [ -43.9022216796875, 59.790275573730469 ] ] ], [ [ [ -79.92999267578125, 59.873603820800781 ], [ -79.925140380859375, 59.813602447509766 ], [ -80.182846069335938, 59.749370574951172 ], [ -80.103057861328125, 59.844993591308594 ], [ -79.92999267578125, 59.873603820800781 ] ] ], [ [ [ -64.047775268554688, 59.849433898925781 ], [ -63.997222900390625, 59.723602294921875 ], [ -64.204452514648438, 59.73443603515625 ], [ -64.118881225585938, 59.851104736328125 ], [ -64.047775268554688, 59.849433898925781 ] ] ], [ [ [ -80.170547485351562, 59.673881530761719 ], [ -80.260833740234375, 59.623603820800781 ], [ -80.341461181640625, 59.618183135986328 ], [ -80.232772827148438, 59.725265502929688 ], [ -80.170547485351562, 59.673881530761719 ] ] ], [ [ [ -153.39306640625, 59.402488708496094 ], [ -153.345840454101562, 59.3619384765625 ], [ -153.552078247070312, 59.338047027587891 ], [ -153.518753051757812, 59.385135650634766 ], [ -153.39306640625, 59.402488708496094 ] ] ], [ [ [ -150.609710693359375, 59.380821228027344 ], [ -150.688339233398438, 59.308464050292969 ], [ -150.775985717773438, 59.325824737548828 ], [ -150.69097900390625, 59.404159545898438 ], [ -150.609710693359375, 59.380821228027344 ] ] ], [ [ [ -69.1824951171875, 59.12860107421875 ], [ -69.227218627929688, 58.971931457519531 ], [ -69.352920532226562, 58.948047637939453 ], [ -69.3194580078125, 59.098045349121094 ], [ -69.356315612792969, 59.135410308837891 ], [ -69.1824951171875, 59.12860107421875 ] ] ], [ [ [ -161.11309814453125, 58.6552734375 ], [ -161.042236328125, 58.709991455078125 ], [ -160.689788818359375, 58.814716339111328 ], [ -160.925567626953125, 58.56304931640625 ], [ -161.11309814453125, 58.6552734375 ] ] ], [ [ [ -152.34222412109375, 58.59332275390625 ], [ -152.493865966796875, 58.472213745117188 ], [ -152.658065795898438, 58.54541015625 ], [ -152.381927490234375, 58.635551452636719 ], [ -152.34222412109375, 58.59332275390625 ] ] ], [ [ [ -153.038055419921875, 58.053604125976562 ], [ -153.22125244140625, 58.193599700927734 ], [ -152.902236938476562, 58.167491912841797 ], [ -153.10430908203125, 58.261665344238281 ], [ -152.797775268554688, 58.282772064208984 ], [ -152.6541748046875, 58.478042602539062 ], [ -151.965682983398438, 58.323326110839844 ], [ -152.099990844726562, 58.149574279785156 ], [ -152.274185180664062, 58.262218475341797 ], [ -152.2772216796875, 58.129436492919922 ], [ -153.038055419921875, 58.053604125976562 ] ] ], [ [ [ -134.573333740234375, 57.505828857421875 ], [ -134.953048706054688, 58.299297332763672 ], [ -134.95013427734375, 58.405475616455078 ], [ -134.6683349609375, 58.15985107421875 ], [ -134.173126220703125, 58.159778594970703 ], [ -133.913909912109375, 57.812767028808594 ], [ -133.893341064453125, 57.655265808105469 ], [ -134.288604736328125, 58.077217102050781 ], [ -134.2711181640625, 57.873603820800781 ], [ -133.864715576171875, 57.458328247070312 ], [ -134.056259155273438, 57.465545654296875 ], [ -133.862625122070312, 57.365547180175781 ], [ -134.171249389648438, 57.380893707275391 ], [ -134.076690673828125, 57.269020080566406 ], [ -134.477706909179688, 57.029087066650391 ], [ -134.613311767578125, 57.224990844726562 ], [ -134.316452026367188, 57.331523895263672 ], [ -134.570831298828125, 57.487354278564453 ], [ -134.352981567382812, 57.541313171386719 ], [ -134.573333740234375, 57.505828857421875 ] ] ], [ [ [ -134.515838623046875, 58.338043212890625 ], [ -134.454437255859375, 58.313323974609375 ], [ -134.261398315429688, 58.198673248291016 ], [ -134.682647705078125, 58.299575805664062 ], [ -134.515838623046875, 58.338043212890625 ] ] ], [ [ [ -136.201934814453125, 57.747215270996094 ], [ -136.40374755859375, 57.822734832763672 ], [ -136.33734130859375, 57.988880157470703 ], [ -136.033554077148438, 57.846935272216797 ], [ -136.4183349609375, 58.089714050292969 ], [ -136.347900390625, 58.220405578613281 ], [ -136.167236328125, 58.098045349121094 ], [ -135.779312133789062, 58.275131225585938 ], [ -135.48345947265625, 58.158046722412109 ], [ -135.707763671875, 57.978324890136719 ], [ -135.406539916992188, 58.137493133544922 ], [ -134.935836791992188, 58.031936645507812 ], [ -134.970001220703125, 57.885269165039062 ], [ -135.198745727539062, 57.936866760253906 ], [ -134.9647216796875, 57.809577941894531 ], [ -135.12359619140625, 57.774436950683594 ], [ -135.880340576171875, 57.992488861083984 ], [ -135.296966552734375, 57.731658935546875 ], [ -134.931121826171875, 57.759437561035156 ], [ -134.8544921875, 57.458740234375 ], [ -135.800872802734375, 57.759891510009766 ], [ -135.545913696289062, 57.465755462646484 ], [ -135.835418701171875, 57.387077331542969 ], [ -136.201934814453125, 57.747215270996094 ] ] ], [ [ [ -153.258056640625, 58.136383056640625 ], [ -153.05584716796875, 58.035552978515625 ], [ -152.891525268554688, 57.990619659423828 ], [ -153.415695190429688, 58.060688018798828 ], [ -153.258056640625, 58.136383056640625 ] ] ], [ [ [ -136.454437255859375, 58.088600158691406 ], [ -136.330429077148438, 58.007495880126953 ], [ -136.441940307617188, 57.8458251953125 ], [ -136.555557250976562, 58.017078399658203 ], [ -136.454437255859375, 58.088600158691406 ] ] ], [ [ [ -153.373870849609375, 57.169990539550781 ], [ -154.138885498046875, 56.741657257080078 ], [ -153.738739013671875, 57.128738403320312 ], [ -154.099716186523438, 56.964855194091797 ], [ -154.020553588867188, 57.107666015625 ], [ -154.14501953125, 57.144996643066406 ], [ -154.473190307617188, 57.122108459472656 ], [ -154.106094360351562, 57.115478515625 ], [ -154.29779052734375, 56.848876953125 ], [ -154.609573364257812, 57.260967254638672 ], [ -154.799453735351562, 57.283329010009766 ], [ -154.20721435546875, 57.666664123535156 ], [ -154.002029418945312, 57.640754699707031 ], [ -153.89044189453125, 57.409713745117188 ], [ -153.760299682617188, 57.309852600097656 ], [ -153.635009765625, 57.275966644287109 ], [ -153.869522094726562, 57.643325805664062 ], [ -153.585586547851562, 57.605442047119141 ], [ -153.9293212890625, 57.808326721191406 ], [ -153.64306640625, 57.866104125976562 ], [ -153.506195068359375, 57.628463745117188 ], [ -153.320510864257812, 57.727249145507812 ], [ -153.470672607421875, 57.840892791748047 ], [ -153.213043212890625, 57.788330078125 ], [ -153.051177978515625, 57.830268859863281 ], [ -153.258621215820312, 58.002357482910156 ], [ -152.8134765625, 57.909572601318359 ], [ -152.909591674804688, 57.834854125976562 ], [ -152.877487182617188, 57.728874206542969 ], [ -152.477218627929688, 57.903182983398438 ], [ -152.329925537109375, 57.818916320800781 ], [ -152.551605224609375, 57.704227447509766 ], [ -152.152297973632812, 57.608188629150391 ], [ -152.361801147460938, 57.423049926757812 ], [ -152.92694091796875, 57.516937255859375 ], [ -153.0369873046875, 57.43328857421875 ], [ -152.600784301757812, 57.373634338378906 ], [ -153.166885375976562, 57.346031188964844 ], [ -152.956527709960938, 57.255756378173828 ], [ -153.2559814453125, 57.228878021240234 ], [ -153.373870849609375, 57.169990539550781 ] ] ], [ [ [ -153.45721435546875, 57.969154357910156 ], [ -153.27252197265625, 57.901103973388672 ], [ -153.210556030273438, 57.809993743896484 ], [ -153.535079956054688, 57.930892944335938 ], [ -153.45721435546875, 57.969154357910156 ] ] ], [ [ [ -61.884445190429688, 57.866935729980469 ], [ -61.944164276123047, 57.788051605224609 ], [ -62.108890533447266, 57.827075958251953 ], [ -61.990558624267578, 57.909713745117188 ], [ -61.884445190429688, 57.866935729980469 ] ] ], [ [ [ -61.654167175292969, 57.771102905273438 ], [ -61.691314697265625, 57.713115692138672 ], [ -61.896110534667969, 57.76971435546875 ], [ -61.775970458984375, 57.845405578613281 ], [ -61.654167175292969, 57.771102905273438 ] ] ], [ [ [ -79.7066650390625, 57.580825805664062 ], [ -79.705001831054688, 57.50860595703125 ], [ -79.802566528320312, 57.417701721191406 ], [ -79.826950073242188, 57.538047790527344 ], [ -79.7066650390625, 57.580825805664062 ] ] ], [ [ [ -61.926948547363281, 57.452491760253906 ], [ -61.971942901611328, 57.582908630371094 ], [ -61.780693054199219, 57.546588897705078 ], [ -61.78125, 57.510971069335938 ], [ -61.926948547363281, 57.452491760253906 ] ] ], [ [ [ -134.6099853515625, 56.575553894042969 ], [ -134.654586791992188, 56.166103363037109 ], [ -135.047500610351562, 56.530967712402344 ], [ -134.8468017578125, 56.683605194091797 ], [ -135.105819702148438, 56.5953369140625 ], [ -135.124298095703125, 56.827770233154297 ], [ -135.367355346679688, 56.83221435546875 ], [ -135.3382568359375, 57.245201110839844 ], [ -135.667526245117188, 57.345787048339844 ], [ -135.392105102539062, 57.553882598876953 ], [ -134.945419311523438, 57.364856719970703 ], [ -134.6099853515625, 56.575553894042969 ] ] ], [ [ [ -61.643890380859375, 57.52276611328125 ], [ -61.651805877685547, 57.392494201660156 ], [ -61.898262023925781, 57.439781188964844 ], [ -61.739997863769531, 57.535968780517578 ], [ -61.643890380859375, 57.52276611328125 ] ] ], [ [ [ -134.818878173828125, 57.401657104492188 ], [ -134.8094482421875, 57.296661376953125 ], [ -134.973114013671875, 57.409015655517578 ], [ -134.8880615234375, 57.428329467773438 ], [ -134.818878173828125, 57.401657104492188 ] ] ], [ [ [ -61.693328857421875, 57.368049621582031 ], [ -61.632217407226562, 57.3377685546875 ], [ -61.591453552246094, 57.327770233154297 ], [ -61.753334045410156, 57.302490234375 ], [ -61.693328857421875, 57.368049621582031 ] ] ], [ [ [ -135.700286865234375, 57.316940307617188 ], [ -135.546249389648438, 57.132213592529297 ], [ -135.826934814453125, 56.985824584960938 ], [ -135.7127685546875, 57.162906646728516 ], [ -135.845840454101562, 57.319301605224609 ], [ -135.700286865234375, 57.316940307617188 ] ] ], [ [ [ -170.280609130859375, 57.104995727539062 ], [ -170.411422729492188, 57.183738708496094 ], [ -170.1397705078125, 57.216926574707031 ], [ -170.162933349609375, 57.166927337646484 ], [ -170.280609130859375, 57.104995727539062 ] ] ], [ [ [ -152.894744873046875, 57.135826110839844 ], [ -153.311111450195312, 56.988880157470703 ], [ -153.40667724609375, 57.069717407226562 ], [ -153.234161376953125, 57.205825805664062 ], [ -152.894744873046875, 57.135826110839844 ] ] ], [ [ [ -133.051666259765625, 56.977485656738281 ], [ -132.933761596679688, 56.629783630371094 ], [ -133.347213745117188, 56.837627410888672 ], [ -133.08270263671875, 56.532630920410156 ], [ -133.5755615234375, 56.433601379394531 ], [ -133.699310302734375, 56.829578399658203 ], [ -133.881759643554688, 56.898067474365234 ], [ -133.741317749023438, 56.894992828369141 ], [ -134.01806640625, 57.014717102050781 ], [ -133.051666259765625, 56.977485656738281 ] ] ], [ [ [ -61.355278015136719, 56.910820007324219 ], [ -61.585277557373047, 56.763885498046875 ], [ -61.386035919189453, 56.774421691894531 ], [ -61.393589019775391, 56.617778778076172 ], [ -61.641952514648438, 56.735588073730469 ], [ -61.499370574951172, 56.952850341796875 ], [ -61.355278015136719, 56.910820007324219 ] ] ], [ [ [ -79.784164428710938, 56.940826416015625 ], [ -79.717918395996094, 56.810409545898438 ], [ -79.753616333007812, 56.782772064208984 ], [ -79.823768615722656, 56.895004272460938 ], [ -79.895835876464844, 56.883464813232422 ], [ -79.784164428710938, 56.940826416015625 ] ] ], [ [ [ -134.22027587890625, 56.276939392089844 ], [ -134.231658935546875, 56.419158935546875 ], [ -134.034591674804688, 56.377353668212891 ], [ -134.064590454101562, 56.548046112060547 ], [ -134.304031372070312, 56.558185577392578 ], [ -134.40472412109375, 56.847770690917969 ], [ -133.99053955078125, 56.872631072998047 ], [ -133.975006103515625, 56.635551452636719 ], [ -133.71929931640625, 56.769020080566406 ], [ -133.73858642578125, 56.560546875 ], [ -133.921249389648438, 56.611103057861328 ], [ -133.94610595703125, 56.089157104492188 ], [ -134.056655883789062, 56.311656951904297 ], [ -134.1260986328125, 55.997631072998047 ], [ -134.22027587890625, 56.276939392089844 ] ] ], [ [ [ -79.843887329101562, 56.858329772949219 ], [ -79.874443054199219, 56.749996185302734 ], [ -79.94512939453125, 56.769504547119141 ], [ -79.917083740234375, 56.859855651855469 ], [ -79.843887329101562, 56.858329772949219 ] ] ], [ [ [ -79.496383666992188, 56.766937255859375 ], [ -79.487503051757812, 56.656795501708984 ], [ -79.565620422363281, 56.617420196533203 ], [ -79.580009460449219, 56.809852600097656 ], [ -79.496383666992188, 56.766937255859375 ] ] ], [ [ [ -132.80194091796875, 56.786384582519531 ], [ -132.5362548828125, 56.601242065429688 ], [ -132.529327392578125, 56.581104278564453 ], [ -132.930419921875, 56.504440307617188 ], [ -132.80194091796875, 56.786384582519531 ] ] ], [ [ [ -61.211669921875, 56.5816650390625 ], [ -61.162498474121094, 56.686378479003906 ], [ -61.079864501953125, 56.676937103271484 ], [ -61.061111450195312, 56.625892639160156 ], [ -61.211669921875, 56.5816650390625 ] ] ], [ [ [ -169.58001708984375, 56.53582763671875 ], [ -169.644744873046875, 56.547077178955078 ], [ -169.782867431640625, 56.614295959472656 ], [ -169.472763061523438, 56.594711303710938 ], [ -169.58001708984375, 56.53582763671875 ] ] ], [ [ [ -154.08331298828125, 56.6038818359375 ], [ -154.207077026367188, 56.499713897705078 ], [ -154.35247802734375, 56.541664123535156 ], [ -154.272247314453125, 56.599433898925781 ], [ -154.08331298828125, 56.6038818359375 ] ] ], [ [ [ -154.42138671875, 56.5877685546875 ], [ -154.416534423828125, 56.537357330322266 ], [ -154.7874755859375, 56.414966583251953 ], [ -154.714996337890625, 56.517787933349609 ], [ -154.42138671875, 56.5877685546875 ] ] ], [ [ [ -157.240264892578125, 56.5816650390625 ], [ -157.072784423828125, 56.580825805664062 ], [ -156.975677490234375, 56.537216186523438 ], [ -157.32720947265625, 56.522216796875 ], [ -157.240264892578125, 56.5816650390625 ] ] ], [ [ [ -79.175277709960938, 55.923324584960938 ], [ -78.980270385742188, 56.38916015625 ], [ -79.055267333984375, 56.344436645507812 ], [ -79.083328247070312, 56.174163818359375 ], [ -79.282844543457031, 55.867839813232422 ], [ -79.150558471679688, 56.233047485351562 ], [ -79.479995727539062, 55.863883972167969 ], [ -79.781951904296875, 55.788047790527344 ], [ -79.5130615234375, 56.134994506835938 ], [ -79.985824584960938, 55.898048400878906 ], [ -79.526840209960938, 56.304214477539062 ], [ -79.4566650390625, 56.553321838378906 ], [ -79.531387329101562, 56.206939697265625 ], [ -79.414726257324219, 56.214435577392578 ], [ -79.286392211914062, 56.570274353027344 ], [ -78.920829772949219, 56.406517028808594 ], [ -79.175277709960938, 55.923324584960938 ] ] ], [ [ [ -153.8760986328125, 56.551101684570312 ], [ -153.958892822265625, 56.502777099609375 ], [ -154.129776000976562, 56.508468627929688 ], [ -154.039169311523438, 56.547496795654297 ], [ -153.8760986328125, 56.551101684570312 ] ] ], [ [ [ -61.558052062988281, 56.551933288574219 ], [ -61.168060302734375, 56.474708557128906 ], [ -61.149440765380859, 56.443321228027344 ], [ -61.63055419921875, 56.46527099609375 ], [ -61.420417785644531, 56.485340118408203 ], [ -61.558052062988281, 56.551933288574219 ] ] ], [ [ [ -80.060546875, 56.184432983398438 ], [ -80.055267333984375, 56.303604125976562 ], [ -79.54638671875, 56.525131225585938 ], [ -79.6824951171875, 56.317497253417969 ], [ -80.060546875, 56.184432983398438 ] ] ], [ [ [ -132.056121826171875, 56.111381530761719 ], [ -132.346237182617188, 56.270965576171875 ], [ -132.371795654296875, 56.487213134765625 ], [ -131.9949951171875, 56.328330993652344 ], [ -132.056121826171875, 56.111381530761719 ] ] ], [ [ [ -132.83416748046875, 56.230819702148438 ], [ -133.05548095703125, 56.349086761474609 ], [ -132.638473510742188, 56.435962677001953 ], [ -132.640289306640625, 56.283191680908203 ], [ -132.83416748046875, 56.230819702148438 ] ] ], [ [ [ -78.927490234375, 56.113883972167969 ], [ -78.8336181640625, 56.348186492919922 ], [ -78.662223815917969, 56.434226989746094 ], [ -78.6763916015625, 56.181106567382812 ], [ -78.927490234375, 56.113883972167969 ] ] ], [ [ [ -61.546669006347656, 56.390830993652344 ], [ -61.414161682128906, 56.324440002441406 ], [ -61.788055419921875, 56.413356781005859 ], [ -61.677780151367188, 56.405548095703125 ], [ -61.546669006347656, 56.390830993652344 ] ] ], [ [ [ -132.318878173828125, 55.912208557128906 ], [ -132.635009765625, 56.049163818359375 ], [ -132.696395874023438, 56.21929931640625 ], [ -132.41778564453125, 56.350830078125 ], [ -132.39501953125, 56.221931457519531 ], [ -132.09375, 56.101032257080078 ], [ -132.119842529296875, 55.935127258300781 ], [ -132.318878173828125, 55.912208557128906 ] ] ], [ [ [ -132.986663818359375, 55.373046875 ], [ -133.126983642578125, 55.491031646728516 ], [ -132.921142578125, 55.624641418457031 ], [ -133.365966796875, 55.615615844726562 ], [ -133.14385986328125, 55.879783630371094 ], [ -133.26507568359375, 56.154850006103516 ], [ -133.611648559570312, 56.2052001953125 ], [ -133.61053466796875, 56.34832763671875 ], [ -133.180206298828125, 56.327285766601562 ], [ -133.072906494140625, 56.051311492919922 ], [ -132.621795654296875, 55.919574737548828 ], [ -132.165283203125, 55.501388549804688 ], [ -132.5625, 55.567771911621094 ], [ -132.088287353515625, 55.267597198486328 ], [ -132.235336303710938, 55.193115234375 ], [ -131.985824584960938, 55.259578704833984 ], [ -132.213531494140625, 54.993743896484375 ], [ -131.972564697265625, 55.029712677001953 ], [ -132.007232666015625, 54.689987182617188 ], [ -132.573333740234375, 54.948600769042969 ], [ -132.511962890625, 55.10638427734375 ], [ -132.650726318359375, 55.243812561035156 ], [ -132.69403076171875, 55.142910003662109 ], [ -132.8074951171875, 55.248046875 ], [ -133.261398315429688, 55.335689544677734 ], [ -132.86749267578125, 55.3538818359375 ], [ -132.986663818359375, 55.373046875 ] ] ], [ [ [ -61.089164733886719, 56.169990539550781 ], [ -60.944026947021484, 56.092632293701172 ], [ -60.936733245849609, 56.012424468994141 ], [ -61.218334197998047, 56.048606872558594 ], [ -61.089164733886719, 56.169990539550781 ] ] ], [ [ [ -133.285552978515625, 56.128875732421875 ], [ -133.363037109375, 56.010276794433594 ], [ -133.793060302734375, 55.931381225585938 ], [ -133.571380615234375, 56.127212524414062 ], [ -133.285552978515625, 56.128875732421875 ] ] ], [ [ [ -79.009353637695312, 56.063613891601562 ], [ -78.939712524414062, 56.0252685546875 ], [ -79.135002136230469, 55.790687561035156 ], [ -79.029029846191406, 55.972766876220703 ], [ -79.009353637695312, 56.063613891601562 ] ] ], [ [ [ -131.135009765625, 55.229156494140625 ], [ -131.2811279296875, 55.22637939453125 ], [ -131.218048095703125, 55.403045654296875 ], [ -131.454925537109375, 55.278602600097656 ], [ -131.273544311523438, 55.433116912841797 ], [ -131.347702026367188, 55.643119812011719 ], [ -131.328598022460938, 55.425827026367188 ], [ -131.458755493164062, 55.326801300048828 ], [ -131.429229736328125, 55.520442962646484 ], [ -131.493881225585938, 55.505550384521484 ], [ -131.51861572265625, 55.294578552246094 ], [ -131.819168090820312, 55.453632354736328 ], [ -131.684860229492188, 55.830272674560547 ], [ -131.259597778320312, 55.960269927978516 ], [ -131.0694580078125, 55.821380615234375 ], [ -130.93804931640625, 55.562210083007812 ], [ -131.135009765625, 55.229156494140625 ] ] ], [ [ [ -60.74749755859375, 55.931663513183594 ], [ -60.689785003662109, 55.919017791748047 ], [ -60.898471832275391, 55.869850158691406 ], [ -60.868404388427734, 55.94964599609375 ], [ -60.74749755859375, 55.931663513183594 ] ] ], [ [ [ -134.114715576171875, 55.89971923828125 ], [ -134.25250244140625, 55.817356109619141 ], [ -134.340835571289062, 55.913742065429688 ], [ -134.11639404296875, 55.921661376953125 ], [ -134.114715576171875, 55.89971923828125 ] ] ], [ [ [ -155.556671142578125, 55.911376953125 ], [ -155.576812744140625, 55.775962829589844 ], [ -155.715972900390625, 55.784439086914062 ], [ -155.739990234375, 55.828605651855469 ], [ -155.556671142578125, 55.911376953125 ] ] ], [ [ [ -133.215545654296875, 55.8619384765625 ], [ -133.245407104492188, 55.775131225585938 ], [ -133.331527709960938, 55.873600006103516 ], [ -133.268203735351562, 55.899436950683594 ], [ -133.215545654296875, 55.8619384765625 ] ] ], [ [ [ -158.80889892578125, 55.892219543457031 ], [ -158.710556030273438, 55.834712982177734 ], [ -158.906051635742188, 55.814853668212891 ], [ -158.894729614257812, 55.869991302490234 ], [ -158.80889892578125, 55.892219543457031 ] ] ], [ [ [ -133.3033447265625, 55.796943664550781 ], [ -133.5230712890625, 55.690826416015625 ], [ -133.677780151367188, 55.775684356689453 ], [ -133.616928100585938, 55.82763671875 ], [ -133.3033447265625, 55.796943664550781 ] ] ], [ [ [ -133.269744873046875, 55.527214050292969 ], [ -133.348876953125, 55.447349548339844 ], [ -133.434097290039062, 55.524085998535156 ], [ -133.377471923828125, 55.556381225585938 ], [ -133.269744873046875, 55.527214050292969 ] ] ], [ [ [ -133.64556884765625, 55.44110107421875 ], [ -133.74664306640625, 55.46527099609375 ], [ -133.7188720703125, 55.548049926757812 ], [ -133.583602905273438, 55.537078857421875 ], [ -133.64556884765625, 55.44110107421875 ] ] ], [ [ [ -133.47833251953125, 55.514999389648438 ], [ -133.42889404296875, 55.439430236816406 ], [ -133.599014282226562, 55.44866943359375 ], [ -133.51251220703125, 55.519435882568359 ], [ -133.47833251953125, 55.514999389648438 ] ] ], [ [ [ -160.154998779296875, 55.437492370605469 ], [ -160.17889404296875, 55.396102905273438 ], [ -160.340896606445312, 55.412349700927734 ], [ -160.264450073242188, 55.463188171386719 ], [ -160.154998779296875, 55.437492370605469 ] ] ], [ [ [ -133.447784423828125, 55.399993896484375 ], [ -133.595138549804688, 55.235546112060547 ], [ -133.684310913085938, 55.308326721191406 ], [ -133.586669921875, 55.417213439941406 ], [ -133.447784423828125, 55.399993896484375 ] ] ], [ [ [ -131.8194580078125, 55.412765502929688 ], [ -131.621917724609375, 55.292770385742188 ], [ -131.72222900390625, 55.136661529541016 ], [ -131.822784423828125, 55.211662292480469 ], [ -131.8194580078125, 55.412765502929688 ] ] ], [ [ [ -160.695556640625, 55.399993896484375 ], [ -160.54388427734375, 55.385551452636719 ], [ -160.573760986328125, 55.230686187744141 ], [ -160.46429443359375, 55.186794281005859 ], [ -160.81390380859375, 55.117908477783203 ], [ -160.846527099609375, 55.332496643066406 ], [ -160.695556640625, 55.399993896484375 ] ] ], [ [ [ -160.328338623046875, 55.350273132324219 ], [ -160.335556030273438, 55.246101379394531 ], [ -160.525360107421875, 55.316379547119141 ], [ -160.49847412109375, 55.349437713623047 ], [ -160.328338623046875, 55.350273132324219 ] ] ], [ [ [ -133.296661376953125, 55.330551147460938 ], [ -133.241378784179688, 55.215408325195312 ], [ -133.4364013671875, 55.211936950683594 ], [ -133.4375, 55.304851531982422 ], [ -133.296661376953125, 55.330551147460938 ] ] ], [ [ [ -159.87164306640625, 55.278045654296875 ], [ -159.8408203125, 55.135963439941406 ], [ -160.225555419921875, 54.875267028808594 ], [ -160.193405151367188, 55.113254547119141 ], [ -159.87164306640625, 55.278045654296875 ] ] ], [ [ [ -131.46722412109375, 55.235824584960938 ], [ -131.35498046875, 55.035552978515625 ], [ -131.593887329101562, 54.993881225585938 ], [ -131.5816650390625, 55.254718780517578 ], [ -131.46722412109375, 55.235824584960938 ] ] ], [ [ [ -133.102203369140625, 55.24554443359375 ], [ -132.723052978515625, 54.784721374511719 ], [ -132.67999267578125, 54.666099548339844 ], [ -133.12249755859375, 54.939430236816406 ], [ -133.213623046875, 55.092212677001953 ], [ -133.102203369140625, 55.24554443359375 ] ] ], [ [ [ -159.51611328125, 55.238044738769531 ], [ -159.51947021484375, 55.064155578613281 ], [ -159.648757934570312, 55.039997100830078 ], [ -159.653060913085938, 55.125545501708984 ], [ -159.51611328125, 55.238044738769531 ] ] ], [ [ [ -132.81390380859375, 55.185821533203125 ], [ -132.732208251953125, 55.140274047851562 ], [ -132.67193603515625, 55.037075042724609 ], [ -132.866790771484375, 55.032077789306641 ], [ -132.81390380859375, 55.185821533203125 ] ] ], [ [ [ -161.732208251953125, 55.148605346679688 ], [ -161.642929077148438, 55.105270385742188 ], [ -161.903350830078125, 55.132492065429688 ], [ -161.827789306640625, 55.170829772949219 ], [ -161.732208251953125, 55.148605346679688 ] ] ], [ [ [ -159.3822021484375, 55.056098937988281 ], [ -159.338592529296875, 54.971931457519531 ], [ -159.458343505859375, 54.946098327636719 ], [ -159.479156494140625, 55.01416015625 ], [ -159.3822021484375, 55.056098937988281 ] ] ], [ [ [ -164.176116943359375, 54.604164123535156 ], [ -164.663909912109375, 54.391937255859375 ], [ -164.952346801757812, 54.5802001953125 ], [ -164.4910888671875, 54.914573669433594 ], [ -163.777511596679688, 55.055404663085938 ], [ -163.536392211914062, 55.047286987304688 ], [ -163.374984741210938, 54.791797637939453 ], [ -163.054885864257812, 54.668117523193359 ], [ -164.176116943359375, 54.604164123535156 ] ] ], [ [ [ -130.165008544921875, 55.01416015625 ], [ -130.270294189453125, 54.830825805664062 ], [ -130.457504272460938, 54.815410614013672 ], [ -130.21331787109375, 55.012496948242188 ], [ -130.165008544921875, 55.01416015625 ] ] ], [ [ [ -131.238311767578125, 54.986381530761719 ], [ -131.23388671875, 54.877212524414062 ], [ -131.48345947265625, 54.922351837158203 ], [ -131.451385498046875, 54.953048706054688 ], [ -131.238311767578125, 54.986381530761719 ] ] ], [ [ [ -162.232757568359375, 54.96527099609375 ], [ -162.293060302734375, 54.834159851074219 ], [ -162.41986083984375, 54.885967254638672 ], [ -162.319992065429688, 54.98040771484375 ], [ -162.232757568359375, 54.96527099609375 ] ] ], [ [ [ -79.0574951171875, 54.917770385742188 ], [ -79.235000610351562, 54.896659851074219 ], [ -79.775558471679688, 54.775547027587891 ], [ -79.462921142578125, 54.88916015625 ], [ -79.0574951171875, 54.917770385742188 ] ] ], [ [ [ -132.61639404296875, 54.890830993652344 ], [ -132.633056640625, 54.748878479003906 ], [ -132.789871215820312, 54.904987335205078 ], [ -132.708892822265625, 54.940544128417969 ], [ -132.61639404296875, 54.890830993652344 ] ] ], [ [ [ -57.940834045410156, 54.911933898925781 ], [ -57.982082366943359, 54.800411224365234 ], [ -57.843681335449219, 54.814228057861328 ], [ -58.1199951171875, 54.75555419921875 ], [ -58.222980499267578, 54.831657409667969 ], [ -57.940834045410156, 54.911933898925781 ] ] ], [ [ [ -130.4586181640625, 54.800270080566406 ], [ -130.46331787109375, 54.708602905273438 ], [ -130.609222412109375, 54.755619049072266 ], [ -130.4840087890625, 54.808189392089844 ], [ -130.4586181640625, 54.800270080566406 ] ] ], [ [ [ -130.7469482421875, 54.615272521972656 ], [ -130.76666259765625, 54.550544738769531 ], [ -130.96624755859375, 54.459300994873047 ], [ -130.928070068359375, 54.617076873779297 ], [ -130.7469482421875, 54.615272521972656 ] ] ], [ [ [ -162.753631591796875, 54.484718322753906 ], [ -162.595550537109375, 54.453464508056641 ], [ -162.542922973632812, 54.384017944335938 ], [ -162.836105346679688, 54.454158782958984 ], [ -162.753631591796875, 54.484718322753906 ] ] ], [ [ [ -165.56915283203125, 54.10888671875 ], [ -165.680862426757812, 54.235542297363281 ], [ -165.486602783203125, 54.286518096923828 ], [ -165.48583984375, 54.173324584960938 ], [ -165.56915283203125, 54.10888671875 ] ] ], [ [ [ -165.89752197265625, 54.02886962890625 ], [ -166.121688842773438, 54.114433288574219 ], [ -165.94305419921875, 54.220264434814453 ], [ -165.658981323242188, 54.122344970703125 ], [ -165.89752197265625, 54.02886962890625 ] ] ], [ [ [ -131.90863037109375, 53.357498168945312 ], [ -132.190841674804688, 53.159713745117188 ], [ -132.674179077148438, 53.256523132324219 ], [ -132.546142578125, 53.312942504882812 ], [ -132.705474853515625, 53.372978210449219 ], [ -132.405502319335938, 53.337421417236328 ], [ -132.972503662109375, 53.555824279785156 ], [ -132.882354736328125, 53.602561950683594 ], [ -133.138214111328125, 53.877632141113281 ], [ -133.069442749023438, 54.171382904052734 ], [ -132.572509765625, 54.113742828369141 ], [ -132.658905029296875, 53.939430236816406 ], [ -132.22833251953125, 54.065826416015625 ], [ -132.129730224609375, 53.848464965820312 ], [ -132.658615112304688, 53.682281494140625 ], [ -132.418060302734375, 53.606101989746094 ], [ -132.156402587890625, 53.716384887695312 ], [ -132.072509765625, 54.02276611328125 ], [ -131.663742065429688, 54.140270233154297 ], [ -131.934158325195312, 53.612216949462891 ], [ -131.90863037109375, 53.357498168945312 ] ] ], [ [ [ -164.976409912109375, 54.126441955566406 ], [ -164.961822509765625, 54.076381683349609 ], [ -165.221649169921875, 54.093044281005859 ], [ -165.133209228515625, 54.127487182617188 ], [ -164.976409912109375, 54.126441955566406 ] ] ], [ [ [ -130.33612060546875, 54.067497253417969 ], [ -130.2288818359375, 53.964714050292969 ], [ -130.341522216796875, 53.837211608886719 ], [ -130.45849609375, 53.882160186767578 ], [ -130.35498046875, 53.993324279785156 ], [ -130.710540771484375, 53.857631683349609 ], [ -130.33612060546875, 54.067497253417969 ] ] ], [ [ [ -166.284759521484375, 53.676383972167969 ], [ -166.756561279296875, 53.445266723632812 ], [ -167.842559814453125, 53.306373596191406 ], [ -167.1640625, 53.464576721191406 ], [ -167.025726318359375, 53.702625274658203 ], [ -166.80389404296875, 53.648872375488281 ], [ -167.152374267578125, 53.823879241943359 ], [ -167.020431518554688, 53.956653594970703 ], [ -166.631546020507812, 53.999710083007812 ], [ -166.603607177734375, 53.829025268554688 ], [ -166.261428833007812, 53.972484588623047 ], [ -166.570831298828125, 53.710273742675781 ], [ -166.284759521484375, 53.676383972167969 ] ] ], [ [ [ -129.56390380859375, 53.207496643066406 ], [ -130.040283203125, 53.581382751464844 ], [ -129.932388305664062, 53.637561798095703 ], [ -130.268356323242188, 53.878463745117188 ], [ -129.424713134765625, 53.411376953125 ], [ -129.56390380859375, 53.207496643066406 ] ] ], [ [ [ -166.219451904296875, 53.7047119140625 ], [ -166.29180908203125, 53.794296264648438 ], [ -166.09002685546875, 53.839431762695312 ], [ -166.11749267578125, 53.774982452392578 ], [ -166.219451904296875, 53.7047119140625 ] ] ], [ [ [ -130.271942138671875, 53.797775268554688 ], [ -130.118331909179688, 53.684295654296875 ], [ -130.094711303710938, 53.568191528320312 ], [ -130.403350830078125, 53.6824951171875 ], [ -130.271942138671875, 53.797775268554688 ] ] ], [ [ [ -128.8236083984375, 53.700546264648438 ], [ -129.0755615234375, 53.514717102050781 ], [ -129.157501220703125, 53.392768859863281 ], [ -129.150161743164062, 53.640548706054688 ], [ -128.8236083984375, 53.700546264648438 ] ] ], [ [ [ -130.39111328125, 53.616935729980469 ], [ -129.920562744140625, 53.424163818359375 ], [ -129.74249267578125, 53.178329467773438 ], [ -130.5272216796875, 53.552215576171875 ], [ -130.39111328125, 53.616935729980469 ] ] ], [ [ [ -167.795318603515625, 53.495536804199219 ], [ -168.467514038085938, 53.048881530761719 ], [ -169.086700439453125, 52.828048706054688 ], [ -168.62139892578125, 53.272216796875 ], [ -168.35723876953125, 53.262355804443359 ], [ -168.354049682617188, 53.473323822021484 ], [ -167.795318603515625, 53.495536804199219 ] ] ], [ [ [ -128.98553466796875, 53.523048400878906 ], [ -128.9202880859375, 53.328605651855469 ], [ -129.1240234375, 53.320274353027344 ], [ -129.04986572265625, 53.507774353027344 ], [ -128.98553466796875, 53.523048400878906 ] ] ], [ [ [ -55.883056640625, 53.486381530761719 ], [ -55.811943054199219, 53.483879089355469 ], [ -55.729301452636719, 53.452770233154297 ], [ -55.977703094482422, 53.459991455078125 ], [ -55.883056640625, 53.486381530761719 ] ] ], [ [ [ -79.951950073242188, 53.34832763671875 ], [ -79.942764282226562, 53.266937255859375 ], [ -80.084030151367188, 53.322772979736328 ], [ -80.061386108398438, 53.355552673339844 ], [ -79.951950073242188, 53.34832763671875 ] ] ], [ [ [ -129.2269287109375, 53.326103210449219 ], [ -129.168609619140625, 53.296104431152344 ], [ -129.13641357421875, 53.104995727539062 ], [ -129.333602905273438, 53.139995574951172 ], [ -129.2269287109375, 53.326103210449219 ] ] ], [ [ [ -129.110809326171875, 52.817497253417969 ], [ -128.838607788085938, 53.032634735107422 ], [ -129.0069580078125, 53.138328552246094 ], [ -128.863327026367188, 53.036525726318359 ], [ -129.163543701171875, 52.922492980957031 ], [ -129.082916259765625, 53.295135498046875 ], [ -128.53167724609375, 53.021102905273438 ], [ -128.601104736328125, 52.608467102050781 ], [ -128.750274658203125, 52.599021911621094 ], [ -128.646743774414062, 52.961936950683594 ], [ -128.778900146484375, 52.664154052734375 ], [ -129.110809326171875, 52.817497253417969 ] ] ], [ [ [ -131.61553955078125, 52.920272827148438 ], [ -131.980545043945312, 52.877632141113281 ], [ -131.395614624023438, 52.376449584960938 ], [ -131.23443603515625, 52.436935424804688 ], [ -131.329437255859375, 52.288257598876953 ], [ -131.033615112304688, 52.172771453857422 ], [ -131.264739990234375, 52.119712829589844 ], [ -132.083328247070312, 52.729846954345703 ], [ -131.965545654296875, 52.790271759033203 ], [ -132.344573974609375, 52.935478210449219 ], [ -132.113739013671875, 52.994922637939453 ], [ -132.55792236328125, 53.146240234375 ], [ -132.065826416015625, 53.155960083007812 ], [ -131.799514770507812, 53.251384735107422 ], [ -131.597732543945312, 53.040790557861328 ], [ -131.9647216796875, 53.04638671875 ], [ -131.61553955078125, 52.920272827148438 ] ] ], [ [ [ -81.087783813476562, 53.179435729980469 ], [ -80.769172668457031, 52.937908172607422 ], [ -80.709442138671875, 52.691448211669922 ], [ -82.057907104492188, 53.019924163818359 ], [ -81.856246948242188, 53.180133819580078 ], [ -81.087783813476562, 53.179435729980469 ] ] ], [ [ [ -129.4627685546875, 53.17999267578125 ], [ -129.352783203125, 53.072219848632812 ], [ -129.292160034179688, 52.971931457519531 ], [ -129.544174194335938, 53.130687713623047 ], [ -129.4627685546875, 53.17999267578125 ] ] ], [ [ [ -79.86639404296875, 53.169441223144531 ], [ -79.79583740234375, 53.116386413574219 ], [ -79.793197631835938, 53.094715118408203 ], [ -79.92291259765625, 53.083465576171875 ], [ -79.86639404296875, 53.169441223144531 ] ] ], [ [ [ 172.9285888671875, 52.743881225585938 ], [ 172.478713989257812, 52.922214508056641 ], [ 173.123565673828125, 52.992767333984375 ], [ 173.436920166015625, 52.851936340332031 ], [ 172.9285888671875, 52.743881225585938 ] ] ], [ [ [ -170.0, 52.838672637939453 ], [ -169.760833740234375, 52.884162902832031 ], [ -169.675048828125, 52.817771911621094 ], [ -169.960433959960938, 52.785690307617188 ], [ -170.0, 52.838672637939453 ] ] ], [ [ [ -128.498870849609375, 52.870826721191406 ], [ -128.450836181640625, 52.805267333984375 ], [ -128.514312744140625, 52.6431884765625 ], [ -128.540008544921875, 52.703323364257812 ], [ -128.498870849609375, 52.870826721191406 ] ] ], [ [ [ -129.231109619140625, 52.81610107421875 ], [ -128.922439575195312, 52.605480194091797 ], [ -128.946380615234375, 52.467628479003906 ], [ -129.27056884765625, 52.719154357910156 ], [ -129.231109619140625, 52.81610107421875 ] ] ], [ [ [ -128.1702880859375, 52.817771911621094 ], [ -128.24847412109375, 52.618602752685547 ], [ -128.276809692382812, 52.596725463867188 ], [ -128.325698852539062, 52.773738861083984 ], [ -128.1702880859375, 52.817771911621094 ] ] ], [ [ [ -128.373321533203125, 52.791107177734375 ], [ -128.275436401367188, 52.493045806884766 ], [ -128.441680908203125, 52.368049621582031 ], [ -128.438125610351562, 52.753261566162109 ], [ -128.373321533203125, 52.791107177734375 ] ] ], [ [ [ -131.4688720703125, 52.730545043945312 ], [ -131.589569091796875, 52.585544586181641 ], [ -131.709716796875, 52.705268859863281 ], [ -131.659454345703125, 52.730270385742188 ], [ -131.4688720703125, 52.730545043945312 ] ] ], [ [ [ -170.795013427734375, 52.532493591308594 ], [ -170.745407104492188, 52.674156188964844 ], [ -170.564590454101562, 52.669776916503906 ], [ -170.603485107421875, 52.593044281005859 ], [ -170.795013427734375, 52.532493591308594 ] ] ], [ [ [ -128.5352783203125, 52.647216796875 ], [ -128.483749389648438, 52.438739776611328 ], [ -128.812576293945312, 52.521381378173828 ], [ -128.57818603515625, 52.593643188476562 ], [ -128.5352783203125, 52.647216796875 ] ] ], [ [ [ 173.660247802734375, 52.348876953125 ], [ 173.62884521484375, 52.39166259765625 ], [ 173.375106811523438, 52.401935577392578 ], [ 173.785400390625, 52.503330230712891 ], [ 173.660247802734375, 52.348876953125 ] ] ], [ [ [ -128.6160888671875, 52.448600769042969 ], [ -128.618881225585938, 52.326938629150391 ], [ -128.672088623046875, 52.266387939453125 ], [ -128.759185791015625, 52.449432373046875 ], [ -128.6160888671875, 52.448600769042969 ] ] ], [ [ [ -127.5963134765625, 52.15179443359375 ], [ -127.893203735351562, 51.953742980957031 ], [ -127.789169311523438, 52.221931457519531 ], [ -127.234733581542969, 52.416938781738281 ], [ -127.5963134765625, 52.15179443359375 ] ] ], [ [ [ -128.092498779296875, 52.4083251953125 ], [ -128.058685302734375, 52.328323364257812 ], [ -128.210281372070312, 52.278812408447266 ], [ -128.1129150390625, 52.419994354248047 ], [ -128.092498779296875, 52.4083251953125 ] ] ], [ [ [ -174.39727783203125, 52.05499267578125 ], [ -174.719757080078125, 52.002212524414062 ], [ -175.334030151367188, 52.016517639160156 ], [ -174.2791748046875, 52.209983825683594 ], [ -174.446212768554688, 52.306728363037109 ], [ -174.180038452148438, 52.417629241943359 ], [ -173.990753173828125, 52.322139739990234 ], [ -174.39727783203125, 52.05499267578125 ] ] ], [ [ [ -172.521392822265625, 52.243049621582031 ], [ -172.6280517578125, 52.258323669433594 ], [ -172.303787231445312, 52.345680236816406 ], [ -172.31390380859375, 52.311927795410156 ], [ -172.521392822265625, 52.243049621582031 ] ] ], [ [ [ -127.961936950683594, 52.289436340332031 ], [ -127.921241760253906, 52.175552368164062 ], [ -128.168487548828125, 52.247215270996094 ], [ -128.043899536132812, 52.301101684570312 ], [ -127.961936950683594, 52.289436340332031 ] ] ], [ [ [ -128.30804443359375, 52.128875732421875 ], [ -128.364990234375, 52.162490844726562 ], [ -128.356658935546875, 52.235824584960938 ], [ -128.229354858398438, 52.215370178222656 ], [ -128.30804443359375, 52.128875732421875 ] ] ], [ [ [ -128.1480712890625, 52.183326721191406 ], [ -128.151123046875, 52.081108093261719 ], [ -128.253082275390625, 52.01971435546875 ], [ -128.292922973632812, 52.116245269775391 ], [ -128.1480712890625, 52.183326721191406 ] ] ], [ [ [ -128.03167724609375, 52.163291931152344 ], [ -127.89111328125, 52.171661376953125 ], [ -127.880134582519531, 52.169441223144531 ], [ -128.10736083984375, 52.102771759033203 ], [ -128.03167724609375, 52.163291931152344 ] ] ], [ [ [ -131.07720947265625, 52.1502685546875 ], [ -130.99249267578125, 52.060821533203125 ], [ -131.020278930664062, 51.943462371826172 ], [ -131.12054443359375, 52.055549621582031 ], [ -131.07720947265625, 52.1502685546875 ] ] ], [ [ [ -173.495025634765625, 52.014991760253906 ], [ -173.923095703125, 52.051658630371094 ], [ -174.05682373046875, 52.123046875 ], [ -172.95904541015625, 52.083877563476562 ], [ -173.495025634765625, 52.014991760253906 ] ] ], [ [ [ 177.318572998046875, 51.82110595703125 ], [ 177.248016357421875, 51.902214050292969 ], [ 177.677474975585938, 52.105827331542969 ], [ 177.608078002929688, 51.923465728759766 ], [ 177.318572998046875, 51.82110595703125 ] ] ], [ [ [ -79.297225952148438, 52.091934204101562 ], [ -79.381248474121094, 51.935825347900391 ], [ -79.652153015136719, 51.987907409667969 ], [ -79.341941833496094, 52.109439849853516 ], [ -79.297225952148438, 52.091934204101562 ] ] ], [ [ [ -176.05474853515625, 51.961654663085938 ], [ -176.167526245117188, 51.994571685791016 ], [ -176.1522216796875, 52.103324890136719 ], [ -176.041717529296875, 52.098037719726562 ], [ -176.05474853515625, 51.961654663085938 ] ] ], [ [ [ -127.951217651367188, 52.046913146972656 ], [ -128.008346557617188, 51.780410766601562 ], [ -128.134033203125, 51.745269775390625 ], [ -128.217498779296875, 51.9627685546875 ], [ -127.951217651367188, 52.046913146972656 ] ] ], [ [ [ 179.64971923828125, 51.867210388183594 ], [ 179.531097412109375, 51.891937255859375 ], [ 179.486907958984375, 51.974296569824219 ], [ 179.768997192382812, 51.966102600097656 ], [ 179.64971923828125, 51.867210388183594 ] ] ], [ [ [ 178.528045654296875, 51.893325805664062 ], [ 178.453170776367188, 51.941795349121094 ], [ 178.476409912109375, 51.986244201660156 ], [ 178.60662841796875, 51.946102142333984 ], [ 178.528045654296875, 51.893325805664062 ] ] ], [ [ [ -176.938629150390625, 51.584434509277344 ], [ -176.75836181640625, 51.950828552246094 ], [ -176.559768676757812, 51.984710693359375 ], [ -176.642242431640625, 51.857215881347656 ], [ -176.423629760742188, 51.827770233154297 ], [ -176.938629150390625, 51.584434509277344 ] ] ], [ [ [ -177.642242431640625, 51.649436950683594 ], [ -177.702789306640625, 51.698459625244141 ], [ -177.213043212890625, 51.808883666992188 ], [ -177.178237915039062, 51.933876037597656 ], [ -177.04779052734375, 51.903182983398438 ], [ -177.153900146484375, 51.699424743652344 ], [ -177.642242431640625, 51.649436950683594 ] ] ], [ [ [ -177.907806396484375, 51.591926574707031 ], [ -178.100830078125, 51.664710998535156 ], [ -177.962783813476562, 51.770549774169922 ], [ -178.216552734375, 51.874294281005859 ], [ -177.8253173828125, 51.831100463867188 ], [ -177.907806396484375, 51.591926574707031 ] ] ], [ [ [ -176.139190673828125, 51.774436950683594 ], [ -176.21612548828125, 51.817768096923828 ], [ -176.207672119140625, 51.876789093017578 ], [ -176.013916015625, 51.833042144775391 ], [ -176.139190673828125, 51.774436950683594 ] ] ], [ [ [ -176.33642578125, 51.721656799316406 ], [ -176.392547607421875, 51.738601684570312 ], [ -176.416152954101562, 51.852493286132812 ], [ -176.278091430664062, 51.859157562255859 ], [ -176.33642578125, 51.721656799316406 ] ] ], [ [ [ -127.998046875, 51.711662292480469 ], [ -127.873611450195312, 51.464439392089844 ], [ -127.914436340332031, 51.410820007324219 ], [ -128.15362548828125, 51.603744506835938 ], [ -127.998046875, 51.711662292480469 ] ] ], [ [ [ 179.252197265625, 51.347488403320312 ], [ 178.9599609375, 51.539718627929688 ], [ 178.638320922851562, 51.635410308837891 ], [ 178.900543212890625, 51.613609313964844 ], [ 179.468017578125, 51.367633819580078 ], [ 179.252197265625, 51.347488403320312 ] ] ], [ [ [ -55.193328857421875, 46.984992980957031 ], [ -55.392082214355469, 46.865829467773438 ], [ -55.98162841796875, 46.949260711669922 ], [ -54.84375, 47.560131072998047 ], [ -55.032150268554688, 47.627079010009766 ], [ -54.941455841064453, 47.777629852294922 ], [ -55.130214691162109, 47.613788604736328 ], [ -55.430000305175781, 47.709022521972656 ], [ -55.411174774169922, 47.485614776611328 ], [ -55.587776184082031, 47.398605346679688 ], [ -55.920383453369141, 47.445026397705078 ], [ -55.745834350585938, 47.58526611328125 ], [ -56.166770935058594, 47.501659393310547 ], [ -55.634166717529297, 47.673049926757812 ], [ -55.913471221923828, 47.655754089355469 ], [ -55.768959045410156, 47.951656341552734 ], [ -56.162498474121094, 47.636104583740234 ], [ -56.840835571289062, 47.521377563476562 ], [ -58.031944274902344, 47.695125579833984 ], [ -59.127223968505859, 47.555545806884766 ], [ -59.303470611572266, 47.611660003662109 ], [ -59.403606414794922, 47.89422607421875 ], [ -58.4183349609375, 48.486656188964844 ], [ -59.212501525878906, 48.547771453857422 ], [ -58.771873474121094, 48.773601531982422 ], [ -58.957221984863281, 48.619438171386719 ], [ -58.701244354248047, 48.579994201660156 ], [ -58.350414276123047, 49.148048400878906 ], [ -58.360263824462891, 49.063663482666016 ], [ -57.996109008789062, 48.961380004882812 ], [ -57.895725250244141, 48.977283477783203 ], [ -58.144447326660156, 49.121932983398438 ], [ -57.917705535888672, 49.126518249511719 ], [ -58.089847564697266, 49.161247253417969 ], [ -57.933261871337891, 49.23846435546875 ], [ -58.204166412353516, 49.242630004882812 ], [ -58.219860076904297, 49.396381378173828 ], [ -57.998336791992188, 49.559158325195312 ], [ -57.703678131103516, 49.464019775390625 ], [ -57.949722290039062, 49.664714813232422 ], [ -57.367984771728516, 50.593116760253906 ], [ -57.151386260986328, 50.623741149902344 ], [ -57.378608703613281, 50.687767028808594 ], [ -56.927497863769531, 50.915824890136719 ], [ -56.682502746582031, 51.339431762695312 ], [ -55.903125762939453, 51.626518249511719 ], [ -55.882221221923828, 51.4949951171875 ], [ -55.406768798828125, 51.564468383789062 ], [ -55.613750457763672, 51.302837371826172 ], [ -56.081947326660156, 51.3690185546875 ], [ -55.734027862548828, 51.077079772949219 ], [ -56.068893432617188, 50.724433898925781 ], [ -56.149166107177734, 50.889022827148438 ], [ -56.163330078125, 50.617767333984375 ], [ -56.905330657958984, 49.747520446777344 ], [ -56.784008026123047, 49.731243133544922 ], [ -56.848884582519531, 49.544441223144531 ], [ -56.122634887695312, 50.154502868652344 ], [ -55.750556945800781, 49.923606872558594 ], [ -55.461040496826172, 49.959712982177734 ], [ -55.986114501953125, 49.746940612792969 ], [ -56.124168395996094, 49.613327026367188 ], [ -55.833328247070312, 49.686653137207031 ], [ -56.12554931640625, 49.424854278564453 ], [ -55.827781677246094, 49.524162292480469 ], [ -55.668056488037109, 49.383533477783203 ], [ -55.522640228271484, 49.484294891357422 ], [ -55.561141967773438, 49.368183135986328 ], [ -55.373470306396484, 49.503467559814453 ], [ -55.315277099609375, 49.314437866210938 ], [ -55.305557250976562, 49.534439086914062 ], [ -55.141319274902344, 49.543331146240234 ], [ -55.383331298828125, 49.04083251953125 ], [ -55.077640533447266, 49.35235595703125 ], [ -54.821113586425781, 49.270408630371094 ], [ -54.528053283691406, 49.531936645507812 ], [ -54.481559753417969, 49.265029907226562 ], [ -54.045280456542969, 49.480125427246094 ], [ -53.511116027832031, 49.277214050292969 ], [ -53.591110229492188, 49.038192749023438 ], [ -54.096107482910156, 48.812210083007812 ], [ -53.801528930664062, 48.810268402099609 ], [ -53.932220458984375, 48.713935852050781 ], [ -53.922847747802734, 48.624782562255859 ], [ -53.607185363769531, 48.680961608886719 ], [ -53.951038360595703, 48.543258666992188 ], [ -53.588050842285156, 48.428047180175781 ], [ -53.072013854980469, 48.697975158691406 ], [ -52.987220764160156, 48.548049926757812 ], [ -53.626251220703125, 48.173183441162109 ], [ -53.937358856201172, 48.232074737548828 ], [ -53.944717407226562, 48.171379089355469 ], [ -53.909652709960938, 48.084018707275391 ], [ -53.691768646240234, 48.058567047119141 ], [ -53.909736633300781, 48.022823333740234 ], [ -53.606807708740234, 48.048744201660156 ], [ -53.837501525878906, 47.699432373046875 ], [ -53.545207977294922, 47.541034698486328 ], [ -53.306106567382812, 47.984161376953125 ], [ -52.923473358154297, 48.170684814453125 ], [ -52.834651947021484, 48.099647521972656 ], [ -53.261672973632812, 47.54638671875 ], [ -53.118541717529297, 47.41790771484375 ], [ -52.779685974121094, 47.797672271728516 ], [ -52.617362976074219, 47.508468627929688 ], [ -52.936664581298828, 46.797077178955078 ], [ -53.165138244628906, 46.619850158691406 ], [ -53.358058929443359, 46.737216949462891 ], [ -53.614303588867188, 46.64117431640625 ], [ -53.591384887695312, 47.156097412109375 ], [ -54.186870574951172, 46.821868896484375 ], [ -53.867500305175781, 47.40277099609375 ], [ -53.98388671875, 47.757774353027344 ], [ -54.196178436279297, 47.841243743896484 ], [ -54.477561950683594, 47.398395538330078 ], [ -54.609794616699219, 47.354854583740234 ], [ -54.414928436279297, 47.595478057861328 ], [ -54.856391906738281, 47.390548706054688 ], [ -55.193328857421875, 46.984992980957031 ] ] ], [ [ [ -125.427223205566406, 50.287498474121094 ], [ -125.168609619140625, 49.912765502929688 ], [ -124.898063659667969, 49.731658935546875 ], [ -124.789436340332031, 49.464157104492188 ], [ -123.943046569824219, 49.211105346679688 ], [ -123.292984008789062, 48.412071228027344 ], [ -123.583328247070312, 48.301101684570312 ], [ -125.101524353027344, 48.724849700927734 ], [ -125.184715270996094, 48.798465728759766 ], [ -124.843330383300781, 49.015758514404297 ], [ -124.780487060546875, 49.139434814453125 ], [ -124.8070068359375, 49.235614776611328 ], [ -124.936943054199219, 48.988044738769531 ], [ -125.504730224609375, 48.919021606445312 ], [ -125.76806640625, 49.098602294921875 ], [ -125.609542846679688, 49.207279205322266 ], [ -126.021942138671875, 49.265552520751953 ], [ -125.899650573730469, 49.422836303710938 ], [ -126.535697937011719, 49.37408447265625 ], [ -126.567916870117188, 49.580410003662109 ], [ -126.089790344238281, 49.660335540771484 ], [ -126.587646484375, 49.702770233154297 ], [ -126.679718017578125, 49.878875732421875 ], [ -126.804443359375, 49.909156799316406 ], [ -127.126800537109375, 49.8546142578125 ], [ -127.158340454101562, 50.096382141113281 ], [ -127.894447326660156, 50.108814239501953 ], [ -127.788887023925781, 50.222213745117188 ], [ -127.979026794433594, 50.344852447509766 ], [ -127.923324584960938, 50.461727142333984 ], [ -127.446952819824219, 50.372764587402344 ], [ -127.566314697265625, 50.508190155029297 ], [ -127.416946411132812, 50.579608917236328 ], [ -127.874229431152344, 50.621585845947266 ], [ -127.596206665039062, 50.545303344726562 ], [ -128.051422119140625, 50.446693420410156 ], [ -128.41326904296875, 50.770893096923828 ], [ -127.914024353027344, 50.871795654296875 ], [ -126.97528076171875, 50.576942443847656 ], [ -125.427223205566406, 50.287498474121094 ] ] ], [ [ [ -126.797782897949219, 50.768882751464844 ], [ -126.903617858886719, 50.824020385742188 ], [ -126.567085266113281, 50.800685882568359 ], [ -126.731376647949219, 50.771934509277344 ], [ -126.797782897949219, 50.768882751464844 ] ] ], [ [ [ -126.251716613769531, 50.818931579589844 ], [ -126.269729614257812, 50.653739929199219 ], [ -126.616241455078125, 50.665130615234375 ], [ -126.385963439941406, 50.807212829589844 ], [ -126.251716613769531, 50.818931579589844 ] ] ], [ [ [ -55.466941833496094, 50.784164428710938 ], [ -55.554447174072266, 50.702354431152344 ], [ -55.650760650634766, 50.724086761474609 ], [ -55.619163513183594, 50.7913818359375 ], [ -55.466941833496094, 50.784164428710938 ] ] ], [ [ [ -126.912513732910156, 50.613609313964844 ], [ -127.020973205566406, 50.63916015625 ], [ -127.142990112304688, 50.635341644287109 ], [ -126.890289306640625, 50.667213439941406 ], [ -126.834236145019531, 50.628463745117188 ], [ -126.912513732910156, 50.613609313964844 ] ] ], [ [ [ -126.286117553710938, 50.59832763671875 ], [ -126.225196838378906, 50.558807373046875 ], [ -126.623893737792969, 50.533882141113281 ], [ -126.488601684570312, 50.553321838378906 ], [ -126.286117553710938, 50.59832763671875 ] ] ], [ [ [ -125.370826721191406, 50.455825805664062 ], [ -125.385833740234375, 50.369712829589844 ], [ -125.527084350585938, 50.380268096923828 ], [ -125.468330383300781, 50.428741455078125 ], [ -125.370826721191406, 50.455825805664062 ] ] ], [ [ [ -125.273063659667969, 50.431106567382812 ], [ -125.051109313964844, 50.224155426025391 ], [ -125.131538391113281, 50.124431610107422 ], [ -125.156112670898438, 50.239158630371094 ], [ -125.213821411132812, 50.315273284912109 ], [ -125.399726867675781, 50.315967559814453 ], [ -125.273063659667969, 50.431106567382812 ] ] ], [ [ [ -124.726936340332031, 50.299163818359375 ], [ -124.657501220703125, 50.247772216796875 ], [ -124.703468322753906, 50.159709930419922 ], [ -124.793609619140625, 50.227069854736328 ], [ -124.726936340332031, 50.299163818359375 ] ] ], [ [ [ -124.89862060546875, 50.29388427734375 ], [ -124.756668090820312, 50.178329467773438 ], [ -124.809722900390625, 50.112632751464844 ], [ -124.963058471679688, 50.236381530761719 ], [ -124.89862060546875, 50.29388427734375 ] ] ], [ [ [ -125.345542907714844, 50.263900756835938 ], [ -125.167221069335938, 50.213607788085938 ], [ -125.168540954589844, 49.982349395751953 ], [ -125.320701599121094, 50.139717102050781 ], [ -125.345542907714844, 50.263900756835938 ] ] ], [ [ [ -124.983322143554688, 50.225547790527344 ], [ -124.897781372070312, 50.077491760253906 ], [ -124.968612670898438, 50.03582763671875 ], [ -125.06500244140625, 50.105411529541016 ], [ -124.983322143554688, 50.225547790527344 ] ] ], [ [ [ -63.492225646972656, 49.840827941894531 ], [ -61.883892059326172, 49.348190307617188 ], [ -61.664791107177734, 49.144229888916016 ], [ -62.195549011230469, 49.074996948242188 ], [ -63.093887329101562, 49.229293823242188 ], [ -64.51251220703125, 49.861106872558594 ], [ -63.492225646972656, 49.840827941894531 ] ] ], [ [ [ -126.768722534179688, 49.878616333007812 ], [ -126.635284423828125, 49.756660461425781 ], [ -126.633056640625, 49.596099853515625 ], [ -126.967369079589844, 49.729019165039062 ], [ -126.768722534179688, 49.878616333007812 ] ] ], [ [ [ -124.122772216796875, 49.493606567382812 ], [ -124.627212524414062, 49.719154357910156 ], [ -124.653884887695312, 49.798469543457031 ], [ -124.351387023925781, 49.698043823242188 ], [ -124.122772216796875, 49.493606567382812 ] ] ], [ [ [ -124.025558471679688, 49.767768859863281 ], [ -124.126373291015625, 49.651378631591797 ], [ -124.196662902832031, 49.67694091796875 ], [ -124.141181945800781, 49.750274658203125 ], [ -124.025558471679688, 49.767768859863281 ] ] ], [ [ [ -54.08111572265625, 49.736381530761719 ], [ -54.004447937011719, 49.647491455078125 ], [ -54.291389465332031, 49.578327178955078 ], [ -54.285415649414062, 49.714019775390625 ], [ -54.08111572265625, 49.736381530761719 ] ] ], [ [ [ -54.52972412109375, 49.633880615234375 ], [ -54.573612213134766, 49.560405731201172 ], [ -54.87249755859375, 49.489856719970703 ], [ -54.88861083984375, 49.591796875 ], [ -54.52972412109375, 49.633880615234375 ] ] ], [ [ [ -123.338333129882812, 49.506103515625 ], [ -123.360282897949219, 49.433052062988281 ], [ -123.459587097167969, 49.468875885009766 ], [ -123.436660766601562, 49.522216796875 ], [ -123.338333129882812, 49.506103515625 ] ] ], [ [ [ -126.126937866210938, 49.390274047851562 ], [ -126.072776794433594, 49.343048095703125 ], [ -126.067916870117188, 49.249580383300781 ], [ -126.239166259765625, 49.289718627929688 ], [ -126.126937866210938, 49.390274047851562 ] ] ], [ [ [ -125.86749267578125, 49.233329772949219 ], [ -125.799156188964844, 49.208328247070312 ], [ -125.817291259765625, 49.1260986328125 ], [ -125.925827026367188, 49.190826416015625 ], [ -125.86749267578125, 49.233329772949219 ] ] ], [ [ [ -123.674713134765625, 49.093048095703125 ], [ -123.52166748046875, 48.960273742675781 ], [ -123.312629699707031, 48.870407104492188 ], [ -123.540557861328125, 48.944992065429688 ], [ -123.674713134765625, 49.093048095703125 ] ] ], [ [ [ -123.577217102050781, 48.929161071777344 ], [ -123.433883666992188, 48.844436645507812 ], [ -123.3740234375, 48.75555419921875 ], [ -123.52471923828125, 48.722488403320312 ], [ -123.577217102050781, 48.929161071777344 ] ] ], [ [ [ -122.895553588867188, 48.711105346679688 ], [ -122.751113891601562, 48.649021148681641 ], [ -123.012496948242188, 48.605827331542969 ], [ -123.020278930664062, 48.635551452636719 ], [ -122.895553588867188, 48.711105346679688 ] ] ], [ [ [ -123.0997314453125, 48.6038818359375 ], [ -122.995002746582031, 48.529716491699219 ], [ -122.962638854980469, 48.452632904052734 ], [ -123.14862060546875, 48.501663208007812 ], [ -123.0997314453125, 48.6038818359375 ] ] ], [ [ [ -122.868057250976562, 48.552490234375 ], [ -122.808883666992188, 48.454437255859375 ], [ -122.814437866210938, 48.417911529541016 ], [ -122.934860229492188, 48.455272674560547 ], [ -122.868057250976562, 48.552490234375 ] ] ], [ [ [ -122.588333129882812, 48.392219543457031 ], [ -122.505836486816406, 48.307491302490234 ], [ -122.663887023925781, 48.244712829589844 ], [ -122.3699951171875, 47.921382904052734 ], [ -122.756805419921875, 48.231101989746094 ], [ -122.588333129882812, 48.392219543457031 ] ] ], [ [ [ -53.564163208007812, 48.190544128417969 ], [ -53.634170532226562, 48.075271606445312 ], [ -53.935829162597656, 48.1824951171875 ], [ -53.686111450195312, 48.147495269775391 ], [ -53.564163208007812, 48.190544128417969 ] ] ], [ [ [ -64.482772827148438, 47.917770385742188 ], [ -64.607772827148438, 47.746799468994141 ], [ -64.691940307617188, 47.755550384521484 ], [ -64.66485595703125, 47.868881225585938 ], [ -64.482772827148438, 47.917770385742188 ] ] ], [ [ [ -55.927497863769531, 47.676658630371094 ], [ -55.928821563720703, 47.638462066650391 ], [ -55.879444122314453, 47.609718322753906 ], [ -56.112918853759766, 47.647216796875 ], [ -55.927497863769531, 47.676658630371094 ] ] ], [ [ [ -54.125, 47.640830993652344 ], [ -54.241111755371094, 47.401657104492188 ], [ -54.361946105957031, 47.409503936767578 ], [ -54.132080078125, 47.669300079345703 ], [ -54.125, 47.640830993652344 ] ] ], [ [ [ -61.40777587890625, 47.641105651855469 ], [ -61.963890075683594, 47.278606414794922 ], [ -61.799446105957031, 47.232765197753906 ], [ -62.011531829833984, 47.223598480224609 ], [ -61.925140380859375, 47.408599853515625 ], [ -61.40777587890625, 47.641105651855469 ] ] ], [ [ [ -122.381103515625, 47.39471435546875 ], [ -122.518547058105469, 47.371517181396484 ], [ -122.449440002441406, 47.516315460205078 ], [ -122.421943664550781, 47.432212829589844 ], [ -122.381103515625, 47.39471435546875 ] ] ], [ [ [ -56.289443969726562, 47.070831298828125 ], [ -56.232635498046875, 46.853050231933594 ], [ -56.371387481689453, 46.78680419921875 ], [ -56.397781372070312, 47.106658935546875 ], [ -56.289443969726562, 47.070831298828125 ] ] ], [ [ [ -62.27972412109375, 46.338043212890625 ], [ -62.603889465332031, 46.179855346679688 ], [ -62.466388702392578, 46.00054931640625 ], [ -62.761116027832031, 45.95416259765625 ], [ -63.113819122314453, 46.208915710449219 ], [ -62.966526031494141, 46.315616607666016 ], [ -63.231525421142578, 46.138881683349609 ], [ -63.591941833496094, 46.211936950683594 ], [ -64.415687561035156, 46.689437866210938 ], [ -64.020843505859375, 47.038604736328125 ], [ -64.0916748046875, 46.778602600097656 ], [ -63.834587097167969, 46.46124267578125 ], [ -63.654720306396484, 46.566799163818359 ], [ -63.216392517089844, 46.412208557128906 ], [ -61.974617004394531, 46.4547119140625 ], [ -62.27972412109375, 46.338043212890625 ] ] ], [ [ [ -61.478050231933594, 45.803878784179688 ], [ -61.455558776855469, 46.137496948242188 ], [ -60.595554351806641, 47.030132293701172 ], [ -60.305831909179688, 46.84429931640625 ], [ -60.609169006347656, 46.201934814453125 ], [ -60.425136566162109, 46.277976989746094 ], [ -61.107917785644531, 45.953254699707031 ], [ -60.736736297607422, 46.055130004882812 ], [ -61.146530151367188, 45.701522827148438 ], [ -60.466941833496094, 45.938041687011719 ], [ -60.787223815917969, 45.936168670654297 ], [ -60.307498931884766, 46.208744049072266 ], [ -60.644924163818359, 46.071346282958984 ], [ -60.353752136230469, 46.307769775390625 ], [ -59.809165954589844, 46.109161376953125 ], [ -59.840553283691406, 45.938323974609375 ], [ -60.498886108398438, 45.620269775390625 ], [ -61.336944580078125, 45.573326110839844 ], [ -61.478050231933594, 45.803878784179688 ] ] ], [ [ [ -70.814437866210938, 46.998329162597656 ], [ -70.9041748046875, 46.913604736328125 ], [ -71.12860107421875, 46.858047485351562 ], [ -70.89666748046875, 47.013328552246094 ], [ -70.814437866210938, 46.998329162597656 ] ] ], [ [ [ -56.187469482421875, 46.808612823486328 ], [ -56.146518707275391, 46.760498046875 ], [ -56.224327087402344, 46.747188568115234 ], [ -56.235588073730469, 46.768688201904297 ], [ -56.187469482421875, 46.808612823486328 ] ] ], [ [ [ -60.9102783203125, 45.546104431152344 ], [ -60.997085571289062, 45.456798553466797 ], [ -61.103889465332031, 45.524993896484375 ], [ -61.020416259765625, 45.57513427734375 ], [ -60.9102783203125, 45.546104431152344 ] ] ], [ [ [ -66.764724731445312, 44.801101684570312 ], [ -66.763069152832031, 44.673740386962891 ], [ -66.903335571289062, 44.619087219238281 ], [ -66.858612060546875, 44.743049621582031 ], [ -66.764724731445312, 44.801101684570312 ] ] ], [ [ [ -68.241378784179688, 44.438880920410156 ], [ -68.1824951171875, 44.332771301269531 ], [ -68.406257629394531, 44.271381378173828 ], [ -68.365272521972656, 44.428604125976562 ], [ -68.241378784179688, 44.438880920410156 ] ] ], [ [ [ -68.632766723632812, 44.276657104492188 ], [ -68.615135192871094, 44.188186645507812 ], [ -68.710563659667969, 44.177768707275391 ], [ -68.720970153808594, 44.231655120849609 ], [ -68.632766723632812, 44.276657104492188 ] ] ], [ [ [ -71.220550537109375, 41.633331298828125 ], [ -71.232772827148438, 41.494712829589844 ], [ -71.355621337890625, 41.457630157470703 ], [ -71.263191223144531, 41.630481719970703 ], [ -71.220550537109375, 41.633331298828125 ] ] ], [ [ [ -70.55694580078125, 41.46527099609375 ], [ -70.509170532226562, 41.355411529541016 ], [ -70.834999084472656, 41.361175537109375 ], [ -70.617218017578125, 41.473876953125 ], [ -70.55694580078125, 41.46527099609375 ] ] ], [ [ [ -70.019454956054688, 41.383880615234375 ], [ -69.979446411132812, 41.255271911621094 ], [ -70.232223510742188, 41.281661987304688 ], [ -70.109588623046875, 41.296245574951172 ], [ -70.019454956054688, 41.383880615234375 ] ] ], [ [ [ -74.0050048828125, 40.67999267578125 ], [ -73.589447021484375, 40.920547485351562 ], [ -72.637641906738281, 40.981658935546875 ], [ -72.2852783203125, 41.161933898925781 ], [ -72.617111206054688, 40.917594909667969 ], [ -71.866798400878906, 41.074783325195312 ], [ -73.618057250976562, 40.594436645507812 ], [ -74.0050048828125, 40.67999267578125 ] ] ], [ [ [ -74.062774658203125, 40.639434814453125 ], [ -74.108612060546875, 40.559715270996094 ], [ -74.235206604003906, 40.514717102050781 ], [ -74.17388916015625, 40.642353057861328 ], [ -74.062774658203125, 40.639434814453125 ] ] ], [ [ [ -75.5272216796875, 35.235549926757812 ], [ -75.653610229492188, 35.225547790527344 ], [ -75.51251220703125, 35.307769775390625 ], [ -75.514801025390625, 35.775962829589844 ], [ -75.447494506835938, 35.582496643066406 ], [ -75.5272216796875, 35.235549926757812 ] ] ], [ [ [ -119.868057250976562, 34.084159851074219 ], [ -119.698333740234375, 34.045272827148438 ], [ -119.51556396484375, 34.044578552246094 ], [ -119.788330078125, 33.967208862304688 ], [ -119.868057250976562, 34.084159851074219 ] ] ], [ [ [ -120.0, 33.989631652832031 ], [ -120.107498168945312, 33.905548095703125 ], [ -120.226097106933594, 34.006103515625 ], [ -120.05194091796875, 34.036109924316406 ], [ -120.0, 33.989631652832031 ] ] ], [ [ [ -118.51666259765625, 33.477767944335938 ], [ -118.3497314453125, 33.398330688476562 ], [ -118.303741455078125, 33.309852600097656 ], [ -118.44964599609375, 33.328605651855469 ], [ -118.51666259765625, 33.477767944335938 ] ] ], [ [ [ -118.530288696289062, 32.993324279785156 ], [ -118.369163513183594, 32.854713439941406 ], [ -118.369453430175781, 32.832771301269531 ], [ -118.593894958496094, 33.044582366943359 ], [ -118.530288696289062, 32.993324279785156 ] ] ], [ [ [ -64.82305908203125, 32.260551452636719 ], [ -64.782371520996094, 32.280136108398438 ], [ -64.676811218261719, 32.379508972167969 ], [ -64.761123657226562, 32.284996032714844 ], [ -64.82305908203125, 32.260551452636719 ] ] ], [ [ [ -86.558883666992188, 30.396663665771484 ], [ -87.251113891601562, 30.317426681518555 ], [ -87.29034423828125, 30.334579467773438 ], [ -86.7630615234375, 30.404994964599609 ], [ -86.527641296386719, 30.397045135498047 ], [ -86.558883666992188, 30.396663665771484 ] ] ], [ [ [ -91.724166870117188, 29.558609008789062 ], [ -91.842086791992188, 29.482494354248047 ], [ -92.03680419921875, 29.581386566162109 ], [ -91.910552978515625, 29.645275115966797 ], [ -91.724166870117188, 29.558609008789062 ] ] ], [ [ [ -113.139717102050781, 29.017776489257812 ], [ -113.592216491699219, 29.425830841064453 ], [ -113.582435607910156, 29.585969924926758 ], [ -113.195846557617188, 29.22833251953125 ], [ -113.139717102050781, 29.017776489257812 ] ] ], [ [ [ -94.841949462890625, 29.269443511962891 ], [ -94.879165649414062, 29.240272521972656 ], [ -95.112319946289062, 29.101560592651367 ], [ -94.781509399414062, 29.318365097045898 ], [ -94.841949462890625, 29.269443511962891 ] ] ], [ [ [ -112.296401977539062, 28.756385803222656 ], [ -112.563621520996094, 28.881109237670898 ], [ -112.456947326660156, 29.186107635498047 ], [ -112.290008544921875, 29.237499237060547 ], [ -112.296401977539062, 28.756385803222656 ] ] ], [ [ [ -118.304458618164062, 28.917221069335938 ], [ -118.404167175292969, 29.150554656982422 ], [ -118.306114196777344, 29.193885803222656 ], [ -118.237648010253906, 28.950136184692383 ], [ -118.304458618164062, 28.917221069335938 ] ] ], [ [ [ -80.660552978515625, 28.318885803222656 ], [ -80.740280151367188, 28.478328704833984 ], [ -80.643058776855469, 28.597635269165039 ], [ -80.610549926757812, 28.548332214355469 ], [ -80.660552978515625, 28.318885803222656 ] ] ], [ [ [ -96.776641845703125, 28.192054748535156 ], [ -96.710975646972656, 28.204439163208008 ], [ -96.409927368164062, 28.395204544067383 ], [ -96.813613891601562, 28.092494964599609 ], [ -96.776641845703125, 28.192054748535156 ] ] ], [ [ [ -115.179458618164062, 28.02471923828125 ], [ -115.324317932128906, 28.139720916748047 ], [ -115.240837097167969, 28.370552062988281 ], [ -115.1461181640625, 28.178886413574219 ], [ -115.179458618164062, 28.02471923828125 ] ] ], [ [ [ -96.83917236328125, 28.10638427734375 ], [ -96.887786865234375, 28.030551910400391 ], [ -97.03582763671875, 27.875274658203125 ], [ -96.92193603515625, 28.089717864990234 ], [ -96.83917236328125, 28.10638427734375 ] ] ], [ [ [ -80.432220458984375, 27.843330383300781 ], [ -80.292495727539062, 27.468883514404297 ], [ -80.165145874023438, 27.186246871948242 ], [ -80.288894653320312, 27.413330078125 ], [ -80.432220458984375, 27.843330383300781 ] ] ], [ [ [ -97.246383666992188, 27.544441223144531 ], [ -97.387985229492188, 27.22242546081543 ], [ -97.317230224609375, 27.495826721191406 ], [ -97.043190002441406, 27.83985710144043 ], [ -97.246383666992188, 27.544441223144531 ] ] ], [ [ [ -97.358245849609375, 26.706962585449219 ], [ -97.400558471679688, 27.020832061767578 ], [ -97.383193969726562, 27.202529907226562 ], [ -97.176597595214844, 26.087776184082031 ], [ -97.358245849609375, 26.706962585449219 ] ] ], [ [ [ -77.950286865234375, 26.897777557373047 ], [ -77.826950073242188, 26.929164886474609 ], [ -77.546676635742188, 26.896663665771484 ], [ -77.049591064453125, 26.519025802612305 ], [ -77.202644348144531, 25.882497787475586 ], [ -77.398056030273438, 26.026386260986328 ], [ -77.220840454101562, 26.145275115966797 ], [ -77.1541748046875, 26.554582595825195 ], [ -77.54278564453125, 26.86555290222168 ], [ -77.950286865234375, 26.897777557373047 ] ] ], [ [ [ -78.7086181640625, 26.489719390869141 ], [ -78.978897094726562, 26.695274353027344 ], [ -78.701118469238281, 26.584442138671875 ], [ -78.518890380859375, 26.734165191650391 ], [ -77.917236328125, 26.745277404785156 ], [ -78.7086181640625, 26.489719390869141 ] ] ], [ [ [ -111.206123352050781, 25.802776336669922 ], [ -111.192359924316406, 26.036247253417969 ], [ -111.085906982421875, 26.071455001831055 ], [ -111.099456787109375, 26.004444122314453 ], [ -111.206123352050781, 25.802776336669922 ] ] ], [ [ [ -76.73529052734375, 25.559165954589844 ], [ -76.349700927734375, 25.343280792236328 ], [ -76.120285034179688, 25.13319206237793 ], [ -76.1683349609375, 24.689998626708984 ], [ -76.336883544921875, 24.817705154418945 ], [ -76.163345336914062, 25.127777099609375 ], [ -76.73529052734375, 25.559165954589844 ] ] ], [ [ [ -80.600860595703125, 24.950809478759766 ], [ -80.45556640625, 25.091384887695312 ], [ -80.260978698730469, 25.348052978515625 ], [ -80.370269775390625, 25.146108627319336 ], [ -80.600860595703125, 24.950809478759766 ] ] ], [ [ [ -112.133621215820312, 25.281108856201172 ], [ -112.126663208007812, 25.233055114746094 ], [ -112.202507019042969, 24.844997406005859 ], [ -112.049171447753906, 24.518610000610352 ], [ -112.2489013671875, 24.809720993041992 ], [ -112.133621215820312, 25.281108856201172 ] ] ], [ [ [ -78.205001831054688, 25.201942443847656 ], [ -77.987716674804688, 25.150205612182617 ], [ -77.7216796875, 24.528888702392578 ], [ -78.019660949707031, 24.274650573730469 ], [ -78.440147399902344, 24.616664886474609 ], [ -78.193267822265625, 24.605415344238281 ], [ -78.30584716796875, 24.721107482910156 ], [ -78.205001831054688, 25.201942443847656 ] ] ], [ [ [ -110.696090698242188, 25.088840484619141 ], [ -110.578903198242188, 25.033885955810547 ], [ -110.53924560546875, 24.882705688476562 ], [ -110.641670227050781, 24.929721832275391 ], [ -110.696090698242188, 25.088840484619141 ] ] ], [ [ [ -77.465835571289062, 24.986663818359375 ], [ -77.5614013671875, 25.027496337890625 ], [ -77.259590148925781, 25.051942825317383 ], [ -77.433761596679688, 25.009025573730469 ], [ -77.465835571289062, 24.986663818359375 ] ] ], [ [ [ -75.462509155273438, 24.12249755859375 ], [ -75.466117858886719, 24.290346145629883 ], [ -75.735565185546875, 24.696525573730469 ], [ -75.314727783203125, 24.213886260986328 ], [ -75.462509155273438, 24.12249755859375 ] ] ], [ [ [ -110.335006713867188, 24.400554656982422 ], [ -110.403900146484375, 24.563053131103516 ], [ -110.379379272460938, 24.586662292480469 ], [ -110.300003051757812, 24.484443664550781 ], [ -110.335006713867188, 24.400554656982422 ] ] ], [ [ [ -111.70806884765625, 24.328330993652344 ], [ -111.835006713867188, 24.427497863769531 ], [ -112.015907287597656, 24.528190612792969 ], [ -111.839164733886719, 24.542499542236328 ], [ -111.70806884765625, 24.328330993652344 ] ] ], [ [ [ -109.788352966308594, 24.131942749023438 ], [ -109.87139892578125, 24.187496185302734 ], [ -109.917228698730469, 24.366664886474609 ], [ -109.798606872558594, 24.191108703613281 ], [ -109.788352966308594, 24.131942749023438 ] ] ], [ [ [ -77.701126098632812, 24.284721374511719 ], [ -77.741668701171875, 24.030277252197266 ], [ -77.632087707519531, 24.211109161376953 ], [ -77.546806335449219, 24.116664886474609 ], [ -77.519729614257812, 23.861110687255859 ], [ -77.609039306640625, 23.727357864379883 ], [ -77.773750305175781, 23.74485969543457 ], [ -77.669647216796875, 23.766368865966797 ], [ -77.575912475585938, 23.843887329101562 ], [ -77.73028564453125, 23.786941528320312 ], [ -77.876678466796875, 24.073055267333984 ], [ -77.701126098632812, 24.284721374511719 ] ] ], [ [ [ -74.530288696289062, 24.07611083984375 ], [ -74.424591064453125, 24.078054428100586 ], [ -74.492782592773438, 23.955276489257812 ], [ -74.541397094726562, 23.969165802001953 ], [ -74.530288696289062, 24.07611083984375 ] ] ], [ [ [ -76.020278930664062, 23.675277709960938 ], [ -75.918624877929688, 23.626388549804688 ], [ -75.771957397460938, 23.499721527099609 ], [ -75.991119384765625, 23.599441528320312 ], [ -76.020278930664062, 23.675277709960938 ] ] ], [ [ [ -75.307510375976562, 23.667774200439453 ], [ -75.099037170410156, 23.327497482299805 ], [ -75.0675048828125, 23.14305305480957 ], [ -74.848892211914062, 23.002082824707031 ], [ -74.837921142578125, 22.857498168945312 ], [ -75.168617248535156, 23.142831802368164 ], [ -75.070701599121094, 23.110692977905273 ], [ -75.307510375976562, 23.667774200439453 ] ] ], [ [ [ -80.59112548828125, 22.050552368164062 ], [ -81.82305908203125, 22.183609008789062 ], [ -82.150283813476562, 22.376110076904297 ], [ -81.648895263671875, 22.491386413574219 ], [ -81.812789916992188, 22.663608551025391 ], [ -82.760566711425781, 22.700832366943359 ], [ -83.368064880371094, 22.201663970947266 ], [ -83.929039001464844, 22.162498474121094 ], [ -84.028762817382812, 21.914026260375977 ], [ -84.501113891601562, 21.765552520751953 ], [ -84.498481750488281, 21.934720993041992 ], [ -84.952926635742188, 21.863191604614258 ], [ -84.338058471679688, 22.012218475341797 ], [ -84.44000244140625, 22.203609466552734 ], [ -84.2005615234375, 22.553054809570312 ], [ -83.229171752929688, 22.998886108398438 ], [ -82.220565795898438, 23.187496185302734 ], [ -81.500839233398438, 23.055553436279297 ], [ -81.226959228515625, 23.161663055419922 ], [ -81.131401062011719, 23.023330688476562 ], [ -80.633056640625, 23.098331451416016 ], [ -80.27862548828125, 22.905277252197266 ], [ -80.037643432617188, 22.951248168945312 ], [ -79.259033203125, 22.372638702392578 ], [ -78.573333740234375, 22.321941375732422 ], [ -77.340492248535156, 21.637289047241211 ], [ -77.610694885253906, 21.885831832885742 ], [ -77.543060302734375, 21.918609619140625 ], [ -77.1400146484375, 21.652774810791016 ], [ -77.364311218261719, 21.614095687866211 ], [ -77.265838623046875, 21.480831146240234 ], [ -77.06195068359375, 21.584999084472656 ], [ -76.898612976074219, 21.309305191040039 ], [ -75.707229614257812, 21.121944427490234 ], [ -75.579727172851562, 21.006942749023438 ], [ -75.736679077148438, 20.696941375732422 ], [ -74.95556640625, 20.685276031494141 ], [ -74.13250732421875, 20.193607330322266 ], [ -75.12139892578125, 19.887496948242188 ], [ -75.092788696289062, 20.056388854980469 ], [ -75.355560302734375, 19.875553131103516 ], [ -76.2489013671875, 19.990833282470703 ], [ -77.681121826171875, 19.821941375732422 ], [ -77.596672058105469, 20.046665191650391 ], [ -77.114593505859375, 20.367359161376953 ], [ -77.196952819824219, 20.634025573730469 ], [ -78.072235107421875, 20.713886260986328 ], [ -78.495147705078125, 21.031803131103516 ], [ -78.740280151367188, 21.634719848632812 ], [ -79.2650146484375, 21.545829772949219 ], [ -79.98779296875, 21.723609924316406 ], [ -80.453201293945312, 22.163608551025391 ], [ -80.59112548828125, 22.050552368164062 ] ] ], [ [ [ -74.088897705078125, 22.657497406005859 ], [ -74.272506713867188, 22.714443206787109 ], [ -74.343902587890625, 22.834999084472656 ], [ -74.022361755371094, 22.713123321533203 ], [ -74.088897705078125, 22.657497406005859 ] ] ], [ [ [ -79.329727172851562, 22.614166259765625 ], [ -79.630767822265625, 22.782707214355469 ], [ -79.63250732421875, 22.799999237060547 ], [ -79.580352783203125, 22.811317443847656 ], [ -79.329727172851562, 22.614166259765625 ] ] ], [ [ [ -74.276397705078125, 22.170555114746094 ], [ -73.867782592773438, 22.512218475341797 ], [ -74.036529541015625, 22.620275497436523 ], [ -73.851531982421875, 22.72833251953125 ], [ -73.867507934570312, 22.469444274902344 ], [ -74.276397705078125, 22.170555114746094 ] ] ], [ [ [ -78.42529296875, 22.412498474121094 ], [ -78.397438049316406, 22.457635879516602 ], [ -78.6934814453125, 22.533191680908203 ], [ -78.277717590332031, 22.442775726318359 ], [ -78.42529296875, 22.412498474121094 ] ] ], [ [ [ -72.787506103515625, 22.283054351806641 ], [ -72.88555908203125, 22.360275268554688 ], [ -73.163619995117188, 22.376941680908203 ], [ -73.023056030273438, 22.432498931884766 ], [ -72.762222290039062, 22.351665496826172 ], [ -72.787506103515625, 22.283054351806641 ] ] ], [ [ [ -78.019454956054688, 22.261943817138672 ], [ -78.159591674804688, 22.302776336669922 ], [ -78.308822631835938, 22.410137176513672 ], [ -78.118621826171875, 22.413887023925781 ], [ -78.019454956054688, 22.261943817138672 ] ] ], [ [ [ -77.864730834960938, 22.095554351806641 ], [ -78.044029235839844, 22.188329696655273 ], [ -77.997512817382812, 22.285274505615234 ], [ -77.861259460449219, 22.21916389465332 ], [ -77.864730834960938, 22.095554351806641 ] ] ], [ [ [ -77.70556640625, 21.908607482910156 ], [ -77.885833740234375, 22.003330230712891 ], [ -77.947235107421875, 22.098331451416016 ], [ -77.652572631835938, 22.068609237670898 ], [ -77.70556640625, 21.908607482910156 ] ] ], [ [ [ -71.8819580078125, 21.8236083984375 ], [ -72.0291748046875, 21.904998779296875 ], [ -72.031463623046875, 21.944164276123047 ], [ -71.914871215820312, 21.944581985473633 ], [ -71.8819580078125, 21.8236083984375 ] ] ], [ [ [ -82.897232055664062, 21.432777404785156 ], [ -83.072990417480469, 21.46270751953125 ], [ -83.191398620605469, 21.62339973449707 ], [ -82.935073852539062, 21.58659553527832 ], [ -83.089447021484375, 21.785552978515625 ], [ -82.974456787109375, 21.942775726318359 ], [ -82.715835571289062, 21.890274047851562 ], [ -82.543060302734375, 21.5897216796875 ], [ -82.897232055664062, 21.432777404785156 ] ] ], [ [ [ -71.658889770507812, 21.739719390869141 ], [ -71.825286865234375, 21.775413513183594 ], [ -71.8477783203125, 21.854721069335938 ], [ -71.66778564453125, 21.831525802612305 ], [ -71.658889770507812, 21.739719390869141 ] ] ], [ [ [ -106.621078491210938, 21.565311431884766 ], [ -106.645843505859375, 21.688331604003906 ], [ -106.585563659667969, 21.715831756591797 ], [ -106.515007019042969, 21.513053894042969 ], [ -106.621078491210938, 21.565311431884766 ] ] ], [ [ [ -106.399169921875, 21.419719696044922 ], [ -106.507225036621094, 21.437427520751953 ], [ -106.4716796875, 21.510555267333984 ], [ -106.339515686035156, 21.500553131103516 ], [ -106.399169921875, 21.419719696044922 ] ] ], [ [ [ -71.146049499511719, 21.429922103881836 ], [ -71.150665283203125, 21.470724105834961 ], [ -71.132194519042969, 21.50921630859375 ], [ -71.127571105957031, 21.442625045776367 ], [ -71.146049499511719, 21.429922103881836 ] ] ], [ [ [ -73.66278076171875, 20.915275573730469 ], [ -73.530632019042969, 21.185762405395508 ], [ -73.25848388671875, 21.13499641418457 ], [ -73.00750732421875, 21.323747634887695 ], [ -73.149726867675781, 20.973888397216797 ], [ -73.66278076171875, 20.915275573730469 ] ] ], [ [ [ -86.99334716796875, 20.25555419921875 ], [ -86.935569763183594, 20.543054580688477 ], [ -86.738616943359375, 20.588954925537109 ], [ -86.88555908203125, 20.353885650634766 ], [ -86.99334716796875, 20.25555419921875 ] ] ], [ [ [ -72.640289306640625, 19.985275268554688 ], [ -72.876113891601562, 20.024997711181641 ], [ -72.95458984375, 20.058609008789062 ], [ -72.810417175292969, 20.091455459594727 ], [ -72.640289306640625, 19.985275268554688 ] ] ], [ [ [ -73.03643798828125, 18.456216812133789 ], [ -72.368759155273438, 18.525693893432617 ], [ -72.321258544921875, 18.666385650634766 ], [ -72.80029296875, 19.033054351806641 ], [ -72.723342895507812, 19.454998016357422 ], [ -73.465286254882812, 19.687774658203125 ], [ -73.405143737792969, 19.831804275512695 ], [ -72.79833984375, 19.942775726318359 ], [ -71.719657897949219, 19.701316833496094 ], [ -71.665840148925781, 19.893747329711914 ], [ -70.994453430175781, 19.930692672729492 ], [ -70.290847778320312, 19.649164199829102 ], [ -69.949317932128906, 19.676803588867188 ], [ -69.7559814453125, 19.29083251953125 ], [ -69.157928466796875, 19.294998168945312 ], [ -69.230010986328125, 19.180274963378906 ], [ -69.615768432617188, 19.224372863769531 ], [ -69.620147705078125, 19.088470458984375 ], [ -68.923896789550781, 19.02985954284668 ], [ -68.322929382324219, 18.599027633666992 ], [ -68.646049499511719, 18.205623626708984 ], [ -68.895278930664062, 18.396385192871094 ], [ -69.884727478027344, 18.469026565551758 ], [ -70.1541748046875, 18.233055114746094 ], [ -70.50750732421875, 18.194721221923828 ], [ -70.691947937011719, 18.43235969543457 ], [ -71.081253051757812, 18.299165725708008 ], [ -71.42388916015625, 17.604166030883789 ], [ -72.072364807128906, 18.239997863769531 ], [ -72.815834045410156, 18.138471603393555 ], [ -73.451400756835938, 18.256942749023438 ], [ -73.881668090820312, 18.022777557373047 ], [ -74.467788696289062, 18.450832366943359 ], [ -74.236679077148438, 18.667221069335938 ], [ -73.03643798828125, 18.456216812133789 ] ] ], [ [ [ -81.395004272460938, 19.32611083984375 ], [ -81.25445556640625, 19.353885650634766 ], [ -81.093063354492188, 19.332775115966797 ], [ -81.263618469238281, 19.264997482299805 ], [ -81.395004272460938, 19.32611083984375 ] ] ], [ [ [ -72.825836181640625, 18.695552825927734 ], [ -73.218063354492188, 18.834163665771484 ], [ -73.300003051757812, 18.927219390869141 ], [ -72.857223510742188, 18.834999084472656 ], [ -72.825836181640625, 18.695552825927734 ] ] ], [ [ [ -110.975013732910156, 18.716110229492188 ], [ -111.072921752929688, 18.775135040283203 ], [ -111.000701904296875, 18.866247177124023 ], [ -110.910285949707031, 18.737777709960938 ], [ -110.975013732910156, 18.716110229492188 ] ] ], [ [ [ -91.834457397460938, 18.638053894042969 ], [ -91.6461181640625, 18.753608703613281 ], [ -91.525009155273438, 18.772914886474609 ], [ -91.522918701171875, 18.750692367553711 ], [ -91.834457397460938, 18.638053894042969 ] ] ], [ [ [ -77.566390991210938, 17.859474182128906 ], [ -78.338897705078125, 18.219026565551758 ], [ -78.339797973632812, 18.360692977905273 ], [ -77.864456176757812, 18.522499084472656 ], [ -76.911216735839844, 18.400838851928711 ], [ -76.3416748046875, 18.14971923828125 ], [ -76.221115112304688, 17.904163360595703 ], [ -76.832923889160156, 17.987081527709961 ], [ -76.951530456542969, 17.829303741455078 ], [ -77.1319580078125, 17.878887176513672 ], [ -77.165702819824219, 17.697219848632812 ], [ -77.566390991210938, 17.859474182128906 ] ] ], [ [ [ -65.632217407226562, 18.265430450439453 ], [ -65.937225341796875, 17.966663360595703 ], [ -67.184730529785156, 17.932498931884766 ], [ -67.266395568847656, 18.365415573120117 ], [ -67.101669311523438, 18.518054962158203 ], [ -66.115493774414062, 18.472011566162109 ], [ -65.632217407226562, 18.265430450439453 ] ] ], [ [ [ -64.4364013671875, 18.431388854980469 ], [ -64.413894653320312, 18.504858016967773 ], [ -64.32452392578125, 18.503677368164062 ], [ -64.33056640625, 18.494163513183594 ], [ -64.4364013671875, 18.431388854980469 ] ] ], [ [ [ -64.660842895507812, 18.383888244628906 ], [ -64.652511596679688, 18.441108703613281 ], [ -64.560279846191406, 18.453609466552734 ], [ -64.565139770507812, 18.420969009399414 ], [ -64.660842895507812, 18.383888244628906 ] ] ], [ [ [ -65.023513793945312, 18.366374969482422 ], [ -64.938323974609375, 18.387672424316406 ], [ -64.834877014160156, 18.313133239746094 ], [ -64.956573486328125, 18.332908630371094 ], [ -65.023513793945312, 18.366374969482422 ] ] ], [ [ [ -63.167778015136719, 18.164443969726562 ], [ -63.052017211914062, 18.259580612182617 ], [ -62.972709655761719, 18.272983551025391 ], [ -62.993057250976562, 18.227218627929688 ], [ -63.167778015136719, 18.164443969726562 ] ] ], [ [ [ -68.573333740234375, 18.101665496826172 ], [ -68.755561828613281, 18.129858016967773 ], [ -68.779998779296875, 18.19770622253418 ], [ -68.5977783203125, 18.161388397216797 ], [ -68.573333740234375, 18.101665496826172 ] ] ], [ [ [ -87.925056457519531, 17.999322891235352 ], [ -88.006118774414062, 17.901943206787109 ], [ -87.856391906738281, 18.164581298828125 ], [ -87.846672058105469, 18.140970230102539 ], [ -87.925056457519531, 17.999322891235352 ] ] ], [ [ [ -65.525009155273438, 18.083053588867188 ], [ -65.578964233398438, 18.115415573120117 ], [ -65.301116943359375, 18.147777557373047 ], [ -65.337783813476562, 18.116943359375 ], [ -65.525009155273438, 18.083053588867188 ] ] ], [ [ [ -64.8961181640625, 17.676666259765625 ], [ -64.786956787109375, 17.792499542236328 ], [ -64.562576293945312, 17.751178741455078 ], [ -64.6683349609375, 17.710830688476562 ], [ -64.8961181640625, 17.676666259765625 ] ] ], [ [ [ -61.7388916015625, 17.540554046630859 ], [ -61.853057861328125, 17.583053588867188 ], [ -61.843544006347656, 17.724302291870117 ], [ -61.739933013916016, 17.647914886474609 ], [ -61.7388916015625, 17.540554046630859 ] ] ], [ [ [ -87.924179077148438, 17.274997711181641 ], [ -87.93597412109375, 17.292915344238281 ], [ -87.917854309082031, 17.418262481689453 ], [ -87.810005187988281, 17.546941757202148 ], [ -87.924179077148438, 17.274997711181641 ] ] ], [ [ [ -62.653892517089844, 17.208885192871094 ], [ -62.837226867675781, 17.326108932495117 ], [ -62.856391906738281, 17.385829925537109 ], [ -62.732364654541016, 17.366664886474609 ], [ -62.653892517089844, 17.208885192871094 ] ] ], [ [ [ -61.738059997558594, 16.989719390869141 ], [ -61.88153076171875, 17.02208137512207 ], [ -61.829586029052734, 17.165554046630859 ], [ -61.670558929443359, 17.088470458984375 ], [ -61.738059997558594, 16.989719390869141 ] ] ], [ [ [ -62.171394348144531, 16.67138671875 ], [ -62.236949920654297, 16.714719772338867 ], [ -62.20458984375, 16.812358856201172 ], [ -62.147224426269531, 16.749164581298828 ], [ -62.171394348144531, 16.67138671875 ] ] ], [ [ [ -61.5418701171875, 16.290248870849609 ], [ -61.463336944580078, 16.512914657592773 ], [ -61.205558776855469, 16.267219543457031 ], [ -61.565933227539062, 16.226860046386719 ], [ -61.688892364501953, 15.947776794433594 ], [ -61.783615112304688, 16.333053588867188 ], [ -61.5418701171875, 16.290248870849609 ] ] ], [ [ [ -86.626678466796875, 16.270275115966797 ], [ -86.596389770507812, 16.337776184082031 ], [ -86.44598388671875, 16.406108856201172 ], [ -86.263336181640625, 16.423332214355469 ], [ -86.626678466796875, 16.270275115966797 ] ] ], [ [ [ -61.256668090820312, 15.869998931884766 ], [ -61.329586029052734, 15.931527137756348 ], [ -61.264167785644531, 16.013887405395508 ], [ -61.187084197998047, 15.914165496826172 ], [ -61.256668090820312, 15.869998931884766 ] ] ], [ [ [ -61.363616943359375, 15.198055267333984 ], [ -61.49139404296875, 15.540554046630859 ], [ -61.452224731445312, 15.631942749023438 ], [ -61.253334045410156, 15.461387634277344 ], [ -61.363616943359375, 15.198055267333984 ] ] ], [ [ [ -60.86083984375, 14.402776718139648 ], [ -61.033889770507812, 14.465831756591797 ], [ -61.174728393554688, 14.876943588256836 ], [ -60.940834045410156, 14.740833282470703 ], [ -60.86083984375, 14.402776718139648 ] ] ], [ [ [ -60.954727172851562, 13.709444046020508 ], [ -61.079586029052734, 13.876666069030762 ], [ -60.933338165283203, 14.109304428100586 ], [ -60.878059387207031, 13.9566650390625 ], [ -60.954727172851562, 13.709444046020508 ] ] ], [ [ [ -61.1844482421875, 13.130277633666992 ], [ -61.280143737792969, 13.205693244934082 ], [ -61.179862976074219, 13.383193016052246 ], [ -61.120285034179688, 13.307498931884766 ], [ -61.1844482421875, 13.130277633666992 ] ] ], [ [ [ -59.533058166503906, 13.050554275512695 ], [ -59.642780303955078, 13.146388053894043 ], [ -59.631111145019531, 13.334999084472656 ], [ -59.429168701171875, 13.164999008178711 ], [ -59.533058166503906, 13.050554275512695 ] ] ], [ [ [ -69.882232666015625, 12.411109924316406 ], [ -70.059036254882812, 12.540207862854004 ], [ -70.059661865234375, 12.627776145935059 ], [ -69.932235717773438, 12.528055191040039 ], [ -69.882232666015625, 12.411109924316406 ] ] ], [ [ [ -68.7469482421875, 12.040276527404785 ], [ -69.0625, 12.188331604003906 ], [ -69.163619995117188, 12.366388320922852 ], [ -68.824172973632812, 12.160276412963867 ], [ -68.7469482421875, 12.040276527404785 ] ] ], [ [ [ -68.251113891601562, 12.020554542541504 ], [ -68.400566101074219, 12.222498893737793 ], [ -68.397224426269531, 12.302915573120117 ], [ -68.197364807128906, 12.222637176513672 ], [ -68.251113891601562, 12.020554542541504 ] ] ], [ [ [ -61.610000610351562, 12.227776527404785 ], [ -61.630142211914062, 12.046110153198242 ], [ -61.785179138183594, 12.003818511962891 ], [ -61.707504272460938, 12.196943283081055 ], [ -61.610000610351562, 12.227776527404785 ] ] ], [ [ [ -60.797500610351562, 11.141666412353516 ], [ -60.84722900390625, 11.176942825317383 ], [ -60.529586791992188, 11.345554351806641 ], [ -60.531806945800781, 11.259026527404785 ], [ -60.797500610351562, 11.141666412353516 ] ] ], [ [ [ -61.079444885253906, 10.824165344238281 ], [ -60.909236907958984, 10.82701301574707 ], [ -61.034168243408203, 10.678194046020508 ], [ -61.004447937011719, 10.149581909179688 ], [ -61.909515380859375, 10.040346145629883 ], [ -61.453754425048828, 10.294164657592773 ], [ -61.473617553710938, 10.597776412963867 ], [ -61.662017822265625, 10.708401679992676 ], [ -61.079444885253906, 10.824165344238281 ] ] ], [ [ [ -82.325119018554688, 9.407863616943359 ], [ -82.256744384765625, 9.427803993225098 ], [ -82.235252380371094, 9.332502365112305 ], [ -82.249755859375, 9.330689430236816 ], [ -82.325119018554688, 9.407863616943359 ] ] ], [ [ [ -78.871673583984375, 8.456943511962891 ], [ -78.834732055664062, 8.319721221923828 ], [ -78.922225952148438, 8.27055549621582 ], [ -78.962791442871094, 8.437637329101562 ], [ -78.871673583984375, 8.456943511962891 ] ] ], [ [ [ -81.738906860351562, 7.639163017272949 ], [ -81.713623046875, 7.436666488647461 ], [ -81.590141296386719, 7.329860210418701 ], [ -81.853347778320312, 7.44666576385498 ], [ -81.738906860351562, 7.639163017272949 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "Europe" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ 58.061378479003906, 81.687759399414062 ], [ 57.889858245849609, 81.709854125976562 ], [ 59.435546875, 81.819297790527344 ], [ 59.159713745117188, 81.728866577148438 ], [ 58.061378479003906, 81.687759399414062 ] ] ], [ [ [ 62.16192626953125, 81.68719482421875 ], [ 63.296104431152344, 81.719985961914062 ], [ 63.802772521972656, 81.6533203125 ], [ 63.4708251953125, 81.582489013671875 ], [ 62.16192626953125, 81.68719482421875 ] ] ], [ [ [ 58.299690246582031, 81.590927124023438 ], [ 58.377212524414062, 81.611923217773438 ], [ 58.717281341552734, 81.598175048828125 ], [ 58.229156494140625, 81.5787353515625 ], [ 58.299690246582031, 81.590927124023438 ] ] ], [ [ [ 61.776679992675781, 81.608322143554688 ], [ 62.12054443359375, 81.584426879882812 ], [ 62.201381683349609, 81.562065124511719 ], [ 61.654434204101562, 81.603042602539062 ], [ 61.776679992675781, 81.608322143554688 ] ] ], [ [ [ 58.080551147460938, 81.366378784179688 ], [ 57.441375732421875, 81.431655883789062 ], [ 56.741378784179688, 81.448593139648438 ], [ 57.754440307617188, 81.561370849609375 ], [ 58.571384429931641, 81.409011840820312 ], [ 58.080551147460938, 81.366378784179688 ] ] ], [ [ [ 58.461936950683594, 81.338592529296875 ], [ 58.954994201660156, 81.404708862304688 ], [ 59.380268096923828, 81.321243286132812 ], [ 58.977767944335938, 81.284713745117188 ], [ 58.461936950683594, 81.338592529296875 ] ] ], [ [ [ 55.55633544921875, 81.219161987304688 ], [ 55.431938171386719, 81.274711608886719 ], [ 56.602630615234375, 81.260269165039062 ], [ 56.365829467773438, 81.384994506835938 ], [ 57.90277099609375, 81.290267944335938 ], [ 55.55633544921875, 81.219161987304688 ] ] ], [ [ [ 54.259765625, 81.291702270507812 ], [ 54.115962982177734, 81.349708557128906 ], [ 54.42193603515625, 81.273178100585938 ], [ 54.317214965820312, 81.268600463867188 ], [ 54.259765625, 81.291702270507812 ] ] ], [ [ [ 59.861724853515625, 81.300262451171875 ], [ 60.426101684570312, 81.299148559570312 ], [ 60.636173248291016, 81.27069091796875 ], [ 59.722213745117188, 81.2833251953125 ], [ 59.861724853515625, 81.300262451171875 ] ] ], [ [ [ 57.083290100097656, 81.181396484375 ], [ 57.874160766601562, 81.237197875976562 ], [ 58.080551147460938, 81.209716796875 ], [ 56.994712829589844, 81.165542602539062 ], [ 57.083290100097656, 81.181396484375 ] ] ], [ [ [ 59.015510559082031, 81.21209716796875 ], [ 59.684432983398438, 81.21026611328125 ], [ 59.842769622802734, 81.182754516601562 ], [ 59.496940612792969, 81.173309326171875 ], [ 59.015510559082031, 81.21209716796875 ] ] ], [ [ [ 62.557464599609375, 80.8441162109375 ], [ 64.094711303710938, 80.989700317382812 ], [ 64.550262451171875, 81.195816040039062 ], [ 65.23858642578125, 81.133041381835938 ], [ 65.46734619140625, 80.925125122070312 ], [ 63.212493896484375, 80.681655883789062 ], [ 62.557464599609375, 80.8441162109375 ] ] ], [ [ [ 50.415245056152344, 81.039459228515625 ], [ 50.516387939453125, 81.16192626953125 ], [ 50.982353210449219, 81.10345458984375 ], [ 50.375961303710938, 81.022071838378906 ], [ 50.415245056152344, 81.039459228515625 ] ] ], [ [ [ 58.21588134765625, 81.1363525390625 ], [ 58.406654357910156, 81.15277099609375 ], [ 58.648605346679688, 81.134994506835938 ], [ 58.149436950683594, 81.128860473632812 ], [ 58.21588134765625, 81.1363525390625 ] ] ], [ [ [ 60.101089477539062, 81.007476806640625 ], [ 60.756385803222656, 81.100814819335938 ], [ 61.656097412109375, 81.0938720703125 ], [ 61.052490234375, 80.91943359375 ], [ 60.101089477539062, 81.007476806640625 ] ] ], [ [ [ 54.429458618164062, 81.024154663085938 ], [ 56.089714050292969, 81.038314819335938 ], [ 57.718807220458984, 80.790817260742188 ], [ 57.017768859863281, 80.694427490234375 ], [ 56.631660461425781, 80.807479858398438 ], [ 54.429458618164062, 81.024154663085938 ] ] ], [ [ [ 56.104507446289062, 81.103073120117188 ], [ 57.486656188964844, 81.046371459960938 ], [ 58.278602600097656, 80.919708251953125 ], [ 57.610275268554688, 80.856643676757812 ], [ 56.104507446289062, 81.103073120117188 ] ] ], [ [ [ 57.847969055175781, 81.039199829101562 ], [ 58.051101684570312, 81.10693359375 ], [ 58.696517944335938, 81.024085998535156 ], [ 58.399993896484375, 80.946090698242188 ], [ 57.847969055175781, 81.039199829101562 ] ] ], [ [ [ 48.714439392089844, 80.276657104492188 ], [ 49.107284545898438, 80.185462951660156 ], [ 47.654159545898438, 80.067489624023438 ], [ 48.082496643066406, 80.19720458984375 ], [ 46.626102447509766, 80.29498291015625 ], [ 48.185405731201172, 80.333320617675781 ], [ 47.623462677001953, 80.3988037109375 ], [ 48.2288818359375, 80.420257568359375 ], [ 48.129856109619141, 80.464988708496094 ], [ 47.391590118408203, 80.450050354003906 ], [ 49.192214965820312, 80.521377563476562 ], [ 49.681381225585938, 80.717483520507812 ], [ 48.96173095703125, 80.730255126953125 ], [ 50.184432983398438, 80.9224853515625 ], [ 50.440265655517578, 80.906791687011719 ], [ 50.011798858642578, 80.860740661621094 ], [ 51.038467407226562, 80.847274780273438 ], [ 50.248325347900391, 80.743728637695312 ], [ 50.34332275390625, 80.711105346679688 ], [ 51.746242523193359, 80.715126037597656 ], [ 48.714439392089844, 80.276657104492188 ] ] ], [ [ [ 57.944381713867188, 80.829986572265625 ], [ 58.719154357910156, 80.896377563476562 ], [ 59.0252685546875, 80.822494506835938 ], [ 57.818744659423828, 80.80303955078125 ], [ 57.944381713867188, 80.829986572265625 ] ] ], [ [ [ 54.00469970703125, 80.826644897460938 ], [ 55.130821228027344, 80.893600463867188 ], [ 55.979988098144531, 80.798599243164062 ], [ 54.841102600097656, 80.719711303710938 ], [ 54.00469970703125, 80.826644897460938 ] ] ], [ [ [ 59.313346862792969, 80.541427612304688 ], [ 59.2802734375, 80.696090698242188 ], [ 59.724708557128906, 80.833877563476562 ], [ 61.851936340332031, 80.8861083984375 ], [ 62.284019470214844, 80.770828247070312 ], [ 61.06610107421875, 80.403594970703125 ], [ 59.313346862792969, 80.541427612304688 ] ] ], [ [ [ 46.084159851074219, 80.436920166015625 ], [ 46.036384582519531, 80.572219848632812 ], [ 44.859996795654297, 80.613456726074219 ], [ 47.501937866210938, 80.855545043945312 ], [ 48.5302734375, 80.78997802734375 ], [ 48.653877258300781, 80.750274658203125 ], [ 48.453605651855469, 80.720535278320312 ], [ 48.764858245849609, 80.649429321289062 ], [ 47.751663208007812, 80.766387939453125 ], [ 47.302211761474609, 80.654289245605469 ], [ 47.423606872558594, 80.588882446289062 ], [ 46.084159851074219, 80.436920166015625 ] ] ], [ [ [ 55.500282287597656, 80.723312377929688 ], [ 56.51416015625, 80.7783203125 ], [ 56.948600769042969, 80.6927490234375 ], [ 55.904991149902344, 80.63165283203125 ], [ 55.500282287597656, 80.723312377929688 ] ] ], [ [ [ 20.833606719970703, 80.674148559570312 ], [ 20.806385040283203, 80.70166015625 ], [ 20.519163131713867, 80.761245727539062 ], [ 21.00444221496582, 80.70416259765625 ], [ 20.833606719970703, 80.674148559570312 ] ] ], [ [ [ 21.113052368164062, 80.649429321289062 ], [ 21.027566909790039, 80.683242797851562 ], [ 21.362913131713867, 80.681785583496094 ], [ 21.353328704833984, 80.67498779296875 ], [ 21.113052368164062, 80.649429321289062 ] ] ], [ [ [ 53.214447021484375, 80.5157470703125 ], [ 53.301380157470703, 80.595405578613281 ], [ 53.141380310058594, 80.648880004882812 ], [ 53.543952941894531, 80.526657104492188 ], [ 53.214447021484375, 80.5157470703125 ] ] ], [ [ [ 58.548606872558594, 80.6180419921875 ], [ 58.805824279785156, 80.646942138671875 ], [ 58.855270385742188, 80.640274047851562 ], [ 58.806381225585938, 80.582763671875 ], [ 58.548606872558594, 80.6180419921875 ] ] ], [ [ [ 57.282707214355469, 80.614730834960938 ], [ 57.416099548339844, 80.641937255859375 ], [ 58.034996032714844, 80.619140625 ], [ 57.528045654296875, 80.5474853515625 ], [ 57.282707214355469, 80.614730834960938 ] ] ], [ [ [ 53.831413269042969, 80.499969482421875 ], [ 54.007499694824219, 80.60748291015625 ], [ 54.461940765380859, 80.471237182617188 ], [ 54.22943115234375, 80.419143676757812 ], [ 53.831413269042969, 80.499969482421875 ] ] ], [ [ [ 54.66558837890625, 80.519393920898438 ], [ 54.997215270996094, 80.561920166015625 ], [ 55.163185119628906, 80.497764587402344 ], [ 54.947486877441406, 80.466659545898438 ], [ 54.66558837890625, 80.519393920898438 ] ] ], [ [ [ 19.966384887695312, 80.4769287109375 ], [ 19.848051071166992, 80.504989624023438 ], [ 20.128190994262695, 80.509300231933594 ], [ 20.000553131103516, 80.485260009765625 ], [ 19.966384887695312, 80.4769287109375 ] ] ], [ [ [ 18.805831909179688, 79.969985961914062 ], [ 17.790830612182617, 80.127067565917969 ], [ 19.340553283691406, 80.086380004882812 ], [ 19.579858779907227, 80.1492919921875 ], [ 18.979995727539062, 80.336654663085938 ], [ 19.840829849243164, 80.220962524414062 ], [ 19.913745880126953, 80.37664794921875 ], [ 19.458744049072266, 80.420677185058594 ], [ 19.66888427734375, 80.501663208007812 ], [ 20.853328704833984, 80.211105346679688 ], [ 21.838329315185547, 80.271102905273438 ], [ 21.607982635498047, 80.121299743652344 ], [ 22.257499694824219, 79.978317260742188 ], [ 22.568538665771484, 80.296371459960938 ], [ 22.361106872558594, 80.410263061523438 ], [ 22.749160766601562, 80.32415771484375 ], [ 22.886940002441406, 80.490264892578125 ], [ 23.355829238891602, 80.426513671875 ], [ 23.127079010009766, 80.382766723632812 ], [ 23.339717864990234, 80.342422485351562 ], [ 23.047496795654297, 80.244979858398438 ], [ 23.101387023925781, 80.120819091796875 ], [ 24.836383819580078, 80.350814819335938 ], [ 24.779720306396484, 80.24664306640625 ], [ 27.182216644287109, 80.10693359375 ], [ 27.101108551025391, 79.967483520507812 ], [ 27.23554801940918, 79.913902282714844 ], [ 25.811107635498047, 79.613868713378906 ], [ 25.975273132324219, 79.507766723632812 ], [ 25.722772598266602, 79.407905578613281 ], [ 23.759162902832031, 79.174148559570312 ], [ 22.654163360595703, 79.296928405761719 ], [ 22.837497711181641, 79.407485961914062 ], [ 20.936107635498047, 79.3660888671875 ], [ 19.63763427734375, 79.602340698242188 ], [ 21.123050689697266, 79.559417724609375 ], [ 20.480619430541992, 79.678726196289062 ], [ 21.839164733886719, 79.702774047851562 ], [ 22.320690155029297, 79.794990539550781 ], [ 18.771385192871094, 79.717483520507812 ], [ 18.154163360595703, 79.909988403320312 ], [ 18.805831909179688, 79.969985961914062 ] ] ], [ [ [ 57.635009765625, 80.110519409179688 ], [ 57.271934509277344, 80.166091918945312 ], [ 57.270961761474609, 80.389572143554688 ], [ 56.946380615234375, 80.47442626953125 ], [ 59.275131225585938, 80.33123779296875 ], [ 58.371658325195312, 80.313873291015625 ], [ 58.076801300048828, 80.251380920410156 ], [ 58.435821533203125, 80.168594360351562 ], [ 57.635009765625, 80.110519409179688 ] ] ], [ [ [ 54.45166015625, 80.415435791015625 ], [ 54.673049926757812, 80.49053955078125 ], [ 54.863052368164062, 80.450271606445312 ], [ 54.373325347900391, 80.403045654296875 ], [ 54.45166015625, 80.415435791015625 ] ] ], [ [ [ 24.308887481689453, 80.3822021484375 ], [ 24.161941528320312, 80.384994506835938 ], [ 24.131523132324219, 80.394783020019531 ], [ 24.382219314575195, 80.392486572265625 ], [ 24.308887481689453, 80.3822021484375 ] ] ], [ [ [ 55.103073120117188, 80.423309326171875 ], [ 55.286384582519531, 80.451385498046875 ], [ 55.364021301269531, 80.431640625 ], [ 54.980545043945312, 80.414154052734375 ], [ 55.103073120117188, 80.423309326171875 ] ] ], [ [ [ 55.802749633789062, 80.417144775390625 ], [ 55.873046875, 80.435256958007812 ], [ 56.32513427734375, 80.391372680664062 ], [ 56.223320007324219, 80.371368408203125 ], [ 55.802749633789062, 80.417144775390625 ] ] ], [ [ [ 52.318916320800781, 80.218505859375 ], [ 52.181381225585938, 80.271926879882812 ], [ 52.931663513183594, 80.40887451171875 ], [ 53.869922637939453, 80.261100769042969 ], [ 52.318916320800781, 80.218505859375 ] ] ], [ [ [ 55.802848815917969, 80.12713623046875 ], [ 56.044300079345703, 80.194145202636719 ], [ 56.007217407226562, 80.3358154296875 ], [ 57.130130767822266, 80.312484741210938 ], [ 57.024436950683594, 80.07110595703125 ], [ 55.802848815917969, 80.12713623046875 ] ] ], [ [ [ 18.456661224365234, 80.238037109375 ], [ 18.370830535888672, 80.263885498046875 ], [ 18.119441986083984, 80.284713745117188 ], [ 18.758609771728516, 80.301925659179688 ], [ 18.456661224365234, 80.238037109375 ] ] ], [ [ [ 54.89410400390625, 80.26275634765625 ], [ 55.328605651855469, 80.344436645507812 ], [ 55.54388427734375, 80.293869018554688 ], [ 55.12054443359375, 80.21832275390625 ], [ 54.89410400390625, 80.26275634765625 ] ] ], [ [ [ 54.177017211914062, 80.21856689453125 ], [ 54.221099853515625, 80.32720947265625 ], [ 54.445823669433594, 80.28082275390625 ], [ 54.421104431152344, 80.224990844726562 ], [ 54.177017211914062, 80.21856689453125 ] ] ], [ [ [ 31.582496643066406, 80.069442749023438 ], [ 31.449440002441406, 80.0858154296875 ], [ 33.637496948242188, 80.21331787109375 ], [ 32.315269470214844, 80.089431762695312 ], [ 31.582496643066406, 80.069442749023438 ] ] ], [ [ [ 49.874359130859375, 80.06365966796875 ], [ 49.532211303710938, 80.152206420898438 ], [ 50.331661224365234, 80.174430847167969 ], [ 50.06610107421875, 80.05914306640625 ], [ 49.874359130859375, 80.06365966796875 ] ] ], [ [ [ 59.909141540527344, 80.181625366210938 ], [ 60.098876953125, 80.203872680664062 ], [ 60.287631988525391, 80.169845581054688 ], [ 60.230270385742188, 80.161651611328125 ], [ 59.909141540527344, 80.181625366210938 ] ] ], [ [ [ 27.878177642822266, 80.166061401367188 ], [ 28.070690155029297, 80.141517639160156 ], [ 27.676801681518555, 80.1201171875 ], [ 27.719161987304688, 80.158035278320312 ], [ 27.878177642822266, 80.166061401367188 ] ] ], [ [ [ 58.7996826171875, 80.006698608398438 ], [ 59.450828552246094, 80.114990234375 ], [ 59.860549926757812, 79.987762451171875 ], [ 59.364715576171875, 79.9144287109375 ], [ 58.7996826171875, 80.006698608398438 ] ] ], [ [ [ 50.066368103027344, 79.979202270507812 ], [ 51.008049011230469, 80.098876953125 ], [ 51.501937866210938, 79.931655883789062 ], [ 50.509719848632812, 79.940261840820312 ], [ 50.066368103027344, 79.979202270507812 ] ] ], [ [ [ 49.355560302734375, 80.047836303710938 ], [ 49.460548400878906, 80.092758178710938 ], [ 49.681243896484375, 80.033180236816406 ], [ 49.431663513183594, 80.015274047851562 ], [ 49.355560302734375, 80.047836303710938 ] ] ], [ [ [ 16.421382904052734, 78.90277099609375 ], [ 15.646943092346191, 79.83978271484375 ], [ 16.110828399658203, 79.860260009765625 ], [ 15.951387405395508, 79.934425354003906 ], [ 16.307773590087891, 80.062759399414062 ], [ 16.819164276123047, 79.872207641601562 ], [ 17.557773590087891, 79.891792297363281 ], [ 18.087011337280273, 79.728172302246094 ], [ 17.637702941894531, 79.376091003417969 ], [ 18.356941223144531, 79.628311157226562 ], [ 18.859718322753906, 79.450546264648438 ], [ 18.937217712402344, 79.160263061523438 ], [ 19.723606109619141, 79.151092529296875 ], [ 19.906661987304688, 79.013885498046875 ], [ 21.540552139282227, 78.759918212890625 ], [ 18.969924926757812, 78.451995849609375 ], [ 19.085344314575195, 78.093452453613281 ], [ 18.41082763671875, 78.021652221679688 ], [ 18.296524047851562, 77.512908935546875 ], [ 17.738327026367188, 77.471099853515625 ], [ 17.343399047851562, 77.055465698242188 ], [ 17.101177215576172, 77.047340393066406 ], [ 17.293331146240234, 76.949996948242188 ], [ 16.9208984375, 76.790191650390625 ], [ 17.200967788696289, 76.699424743652344 ], [ 16.612773895263672, 76.570541381835938 ], [ 15.502151489257812, 76.881370544433594 ], [ 16.498603820800781, 77.000823974609375 ], [ 14.467220306396484, 77.171646118164062 ], [ 13.914164543151855, 77.524993896484375 ], [ 16.223049163818359, 77.434982299804688 ], [ 14.745623588562012, 77.659294128417969 ], [ 16.800552368164062, 77.806930541992188 ], [ 17.006107330322266, 77.931365966796875 ], [ 13.951664924621582, 77.718048095703125 ], [ 13.75624942779541, 77.729843139648438 ], [ 13.592219352722168, 78.052200317382812 ], [ 14.355831146240234, 77.9627685546875 ], [ 14.221941947937012, 78.078941345214844 ], [ 17.295204162597656, 78.421791076660156 ], [ 16.33027458190918, 78.450958251953125 ], [ 16.810829162597656, 78.67498779296875 ], [ 15.472775459289551, 78.451240539550781 ], [ 15.198886871337891, 78.590545654296875 ], [ 15.448886871337891, 78.633041381835938 ], [ 15.370830535888672, 78.843040466308594 ], [ 15.027915000915527, 78.599014282226562 ], [ 14.531665802001953, 78.682754516601562 ], [ 14.388888359069824, 78.491508483886719 ], [ 14.728192329406738, 78.386238098144531 ], [ 13.00666618347168, 78.197479248046875 ], [ 12.371594429016113, 78.480888366699219 ], [ 13.187359809875488, 78.541572570800781 ], [ 11.918192863464355, 78.629280090332031 ], [ 11.644790649414062, 78.735954284667969 ], [ 11.924304008483887, 78.825920104980469 ], [ 11.33701229095459, 78.960540771484375 ], [ 12.500692367553711, 78.911994934082031 ], [ 11.755277633666992, 79.075820922851562 ], [ 12.115273475646973, 79.293319702148438 ], [ 11.63861083984375, 79.319442749023438 ], [ 11.70999813079834, 79.163734436035156 ], [ 11.236385345458984, 79.093048095703125 ], [ 10.682358741760254, 79.546089172363281 ], [ 11.180276870727539, 79.559417724609375 ], [ 10.859372138977051, 79.597419738769531 ], [ 11.366107940673828, 79.634994506835938 ], [ 11.19569206237793, 79.774993896484375 ], [ 11.696386337280273, 79.834991455078125 ], [ 12.31138801574707, 79.66192626953125 ], [ 12.16222095489502, 79.80609130859375 ], [ 13.82472038269043, 79.875259399414062 ], [ 13.967358589172363, 79.769989013671875 ], [ 12.44930362701416, 79.568878173828125 ], [ 13.474858283996582, 79.582489013671875 ], [ 13.264720916748047, 79.470954895019531 ], [ 14.058886528015137, 79.260269165039062 ], [ 14.153887748718262, 79.33526611328125 ], [ 13.884998321533203, 79.538314819335938 ], [ 14.584997177124023, 79.804153442382812 ], [ 15.262638092041016, 79.612342834472656 ], [ 15.772637367248535, 79.237762451171875 ], [ 15.714443206787109, 79.110809326171875 ], [ 16.421382904052734, 78.90277099609375 ] ] ], [ [ [ 58.362464904785156, 79.938079833984375 ], [ 58.664295196533203, 79.975814819335938 ], [ 58.986103057861328, 79.898460388183594 ], [ 58.280132293701172, 79.929702758789062 ], [ 58.362464904785156, 79.938079833984375 ] ] ], [ [ [ 10.973052978515625, 79.729156494140625 ], [ 10.755277633666992, 79.736648559570312 ], [ 10.642082214355469, 79.746932983398438 ], [ 10.756109237670898, 79.7833251953125 ], [ 10.973052978515625, 79.729156494140625 ] ] ], [ [ [ 10.781665802001953, 79.6502685546875 ], [ 10.71221923828125, 79.713607788085938 ], [ 11.076108932495117, 79.662765502929688 ], [ 10.922775268554688, 79.651092529296875 ], [ 10.781665802001953, 79.6502685546875 ] ] ], [ [ [ 20.142772674560547, 79.331939697265625 ], [ 19.676662445068359, 79.338043212890625 ], [ 19.628330230712891, 79.388320922851562 ], [ 20.178050994873047, 79.343254089355469 ], [ 20.142772674560547, 79.331939697265625 ] ] ], [ [ [ 20.342494964599609, 78.990814208984375 ], [ 20.047636032104492, 79.040122985839844 ], [ 20.831108093261719, 79.056930541992188 ], [ 20.707218170166016, 79.01416015625 ], [ 20.342494964599609, 78.990814208984375 ] ] ], [ [ [ 28.095550537109375, 78.8116455078125 ], [ 28.019718170166016, 78.867477416992188 ], [ 28.428882598876953, 78.951934814453125 ], [ 29.708049774169922, 78.896377563476562 ], [ 28.095550537109375, 78.8116455078125 ] ] ], [ [ [ 12.120552062988281, 78.195816040039062 ], [ 11.073331832885742, 78.455825805664062 ], [ 10.487914085388184, 78.893325805664062 ], [ 11.006109237670898, 78.82916259765625 ], [ 11.267221450805664, 78.538040161132812 ], [ 11.821109771728516, 78.441085815429688 ], [ 12.120552062988281, 78.195816040039062 ] ] ], [ [ [ 26.735828399658203, 78.623870849609375 ], [ 26.466245651245117, 78.701652526855469 ], [ 26.398052215576172, 78.774017333984375 ], [ 27.01513671875, 78.6956787109375 ], [ 26.735828399658203, 78.623870849609375 ] ] ], [ [ [ 20.142665863037109, 78.4696044921875 ], [ 22.028884887695312, 78.580825805664062 ], [ 22.241382598876953, 78.480545043945312 ], [ 22.26805305480957, 78.265411376953125 ], [ 20.671108245849609, 78.187484741210938 ], [ 20.779998779296875, 78.284423828125 ], [ 20.470550537109375, 78.316375732421875 ], [ 20.663883209228516, 78.38720703125 ], [ 20.142665863037109, 78.4696044921875 ] ] ], [ [ [ 22.641105651855469, 77.2530517578125 ], [ 22.423606872558594, 77.257217407226562 ], [ 22.415620803833008, 77.411651611328125 ], [ 22.773191452026367, 77.546157836914062 ], [ 20.867218017578125, 77.454574584960938 ], [ 21.644996643066406, 77.912490844726562 ], [ 20.868745803833008, 78.090126037597656 ], [ 22.982772827148438, 78.246932983398438 ], [ 23.459716796875, 78.15582275390625 ], [ 23.112773895263672, 77.98858642578125 ], [ 24.902217864990234, 77.747062683105469 ], [ 22.641105651855469, 77.2530517578125 ] ] ], [ [ [ 59.147216796875, 74.438583374023438 ], [ 58.191947937011719, 74.575233459472656 ], [ 58.613883972167969, 74.427764892578125 ], [ 58.724159240722656, 74.235809326171875 ], [ 58.279853820800781, 74.217903137207031 ], [ 58.384719848632812, 74.131088256835938 ], [ 58.136798858642578, 74.137077331542969 ], [ 58.135826110839844, 73.985260009765625 ], [ 57.533882141113281, 74.181930541992188 ], [ 57.257499694824219, 74.076095581054688 ], [ 57.911659240722656, 73.915542602539062 ], [ 57.724159240722656, 73.715263366699219 ], [ 57.40277099609375, 73.83831787109375 ], [ 56.567840576171875, 73.880119323730469 ], [ 57.330551147460938, 73.82415771484375 ], [ 57.613609313964844, 73.662200927734375 ], [ 57.351104736328125, 73.549713134765625 ], [ 56.727005004882812, 73.6715087890625 ], [ 57.252494812011719, 73.491233825683594 ], [ 56.749580383300781, 73.245262145996094 ], [ 55.907768249511719, 73.440261840820312 ], [ 55.926658630371094, 73.304153442382812 ], [ 54.971656799316406, 73.44219970703125 ], [ 54.21429443359375, 73.32415771484375 ], [ 54.036941528320312, 73.3831787109375 ], [ 55.173881530761719, 73.711097717285156 ], [ 54.060821533203125, 73.605819702148438 ], [ 53.632698059082031, 73.758941650390625 ], [ 54.800270080566406, 73.977272033691406 ], [ 54.590614318847656, 74.008041381835938 ], [ 55.021244049072266, 74.1724853515625 ], [ 55.862003326416016, 74.108177185058594 ], [ 55.075271606445312, 74.261383056640625 ], [ 55.741867065429688, 74.292823791503906 ], [ 55.234298706054688, 74.3660888671875 ], [ 55.364437103271484, 74.434700012207031 ], [ 56.281383514404297, 74.487548828125 ], [ 55.497909545898438, 74.569015502929688 ], [ 55.571662902832031, 74.659713745117188 ], [ 56.984580993652344, 74.687149047851562 ], [ 55.817699432373047, 74.804496765136719 ], [ 56.67596435546875, 74.948806762695312 ], [ 55.88916015625, 74.98858642578125 ], [ 55.728878021240234, 75.076240539550781 ], [ 55.803329467773438, 75.149429321289062 ], [ 56.354713439941406, 75.18914794921875 ], [ 56.480545043945312, 75.061370849609375 ], [ 56.908252716064453, 75.236862182617188 ], [ 56.732349395751953, 75.298248291015625 ], [ 56.869438171386719, 75.359710693359375 ], [ 57.737213134765625, 75.323043823242188 ], [ 57.512214660644531, 75.494148254394531 ], [ 58.789436340332031, 75.838882446289062 ], [ 60.835128784179688, 76.113876342773438 ], [ 60.468463897705078, 76.013877868652344 ], [ 60.729156494140625, 76.002212524414062 ], [ 61.156101226806641, 76.131584167480469 ], [ 60.904922485351562, 76.148109436035156 ], [ 61.066383361816406, 76.273880004882812 ], [ 62.502494812011719, 76.176651000976562 ], [ 65.97442626953125, 76.528045654296875 ], [ 65.757621765136719, 76.681854248046875 ], [ 67.545822143554688, 77.010818481445312 ], [ 68.931365966796875, 76.782760620117188 ], [ 68.861099243164062, 76.54193115234375 ], [ 68.290817260742188, 76.279983520507812 ], [ 63.581939697265625, 75.7108154296875 ], [ 61.514301300048828, 75.223876953125 ], [ 61.283256530761719, 75.318313598632812 ], [ 60.736656188964844, 75.024993896484375 ], [ 59.930198669433594, 74.997268676757812 ], [ 60.6824951171875, 74.927207946777344 ], [ 60.203739166259766, 74.846443176269531 ], [ 60.36749267578125, 74.786376953125 ], [ 60.243049621582031, 74.7430419921875 ], [ 59.509994506835938, 74.79498291015625 ], [ 59.869571685791016, 74.680816650390625 ], [ 59.763744354248047, 74.589012145996094 ], [ 59.169441223144531, 74.719711303710938 ], [ 59.287635803222656, 74.641380310058594 ], [ 59.147216796875, 74.438583374023438 ] ] ], [ [ [ 24.991104125976562, 76.435256958007812 ], [ 25.065273284912109, 76.530548095703125 ], [ 25.582218170166016, 76.706649780273438 ], [ 25.033330917358398, 76.481925964355469 ], [ 24.991104125976562, 76.435256958007812 ] ] ], [ [ [ 59.932731628417969, 76.134719848632812 ], [ 60.041107177734375, 76.156936645507812 ], [ 60.494716644287109, 76.183319091796875 ], [ 59.867214202880859, 76.107345581054688 ], [ 59.932731628417969, 76.134719848632812 ] ] ], [ [ [ 58.793548583984375, 75.921401977539062 ], [ 59.197769165039062, 75.98248291015625 ], [ 59.263607025146484, 75.965965270996094 ], [ 58.694709777832031, 75.899429321289062 ], [ 58.793548583984375, 75.921401977539062 ] ] ], [ [ [ 19.069164276123047, 74.343048095703125 ], [ 18.854164123535156, 74.433319091796875 ], [ 18.791109085083008, 74.478874206542969 ], [ 19.299860000610352, 74.471794128417969 ], [ 19.069164276123047, 74.343048095703125 ] ] ], [ [ [ 57.314155578613281, 70.560531616210938 ], [ 56.642494201660156, 70.629974365234375 ], [ 56.514717102050781, 70.749710083007812 ], [ 56.219573974609375, 70.660125732421875 ], [ 56.652629852294922, 70.578948974609375 ], [ 55.875129699707031, 70.580268859863281 ], [ 55.407028198242188, 70.748100280761719 ], [ 55.164924621582031, 70.553176879882812 ], [ 54.573440551757812, 70.781478881835938 ], [ 54.479156494140625, 70.733871459960938 ], [ 54.756244659423828, 70.652275085449219 ], [ 53.463607788085938, 70.813873291015625 ], [ 53.739574432373047, 70.949295043945312 ], [ 53.508331298828125, 71.086105346679688 ], [ 54.236030578613281, 71.124778747558594 ], [ 53.504997253417969, 71.221099853515625 ], [ 53.941238403320312, 71.458526611328125 ], [ 53.446380615234375, 71.297065734863281 ], [ 53.255828857421875, 71.446090698242188 ], [ 53.364994049072266, 71.56512451171875 ], [ 52.919441223144531, 71.405548095703125 ], [ 52.552490234375, 71.594436645507812 ], [ 51.797218322753906, 71.474990844726562 ], [ 51.394996643066406, 71.848602294921875 ], [ 51.841934204101562, 72.158599853515625 ], [ 52.403324127197266, 72.079574584960938 ], [ 52.409576416015625, 72.225128173828125 ], [ 52.746101379394531, 72.336929321289062 ], [ 52.665126800537109, 72.432273864746094 ], [ 53.084156036376953, 72.593940734863281 ], [ 52.755130767822266, 72.636512756347656 ], [ 53.214435577392578, 72.649299621582031 ], [ 52.380550384521484, 72.721786499023438 ], [ 52.976795196533203, 72.919845581054688 ], [ 53.374019622802734, 72.878730773925781 ], [ 53.140895843505859, 73.003936767578125 ], [ 53.381660461425781, 73.008331298828125 ], [ 53.125686645507812, 73.091514587402344 ], [ 53.328929901123047, 73.217041015625 ], [ 54.226936340332031, 73.274429321289062 ], [ 54.914436340332031, 73.422210693359375 ], [ 55.321937561035156, 73.332206726074219 ], [ 56.437210083007812, 73.225540161132812 ], [ 56.586032867431641, 73.132347106933594 ], [ 55.812213897705078, 73.057754516601562 ], [ 56.460132598876953, 73.046928405761719 ], [ 56.340408325195312, 72.993865966796875 ], [ 55.62152099609375, 72.963462829589844 ], [ 56.256107330322266, 72.968315124511719 ], [ 56.164154052734375, 72.792205810546875 ], [ 55.436935424804688, 72.781654357910156 ], [ 55.943737030029297, 72.664573669433594 ], [ 55.132976531982422, 72.450675964355469 ], [ 55.463603973388672, 72.428314208984375 ], [ 55.575550079345703, 72.189285278320312 ], [ 55.221015930175781, 71.925613403320312 ], [ 55.505390167236328, 71.891799926757812 ], [ 56.228042602539062, 71.194137573242188 ], [ 57.63311767578125, 70.728111267089844 ], [ 57.386520385742188, 70.602622985839844 ], [ 56.744365692138672, 70.699501037597656 ], [ 57.314155578613281, 70.560531616210938 ] ] ], [ [ [ 53.001029968261719, 70.9771728515625 ], [ 52.644996643066406, 71.219146728515625 ], [ 52.211105346679688, 71.319442749023438 ], [ 52.710273742675781, 71.401092529296875 ], [ 53.203746795654297, 71.253875732421875 ], [ 53.048332214355469, 71.066665649414062 ], [ 53.141937255859375, 70.978317260742188 ], [ 53.001029968261719, 70.9771728515625 ] ] ], [ [ [ -9.0430908203125, 70.803863525390625 ], [ -8.344482421875, 71.13665771484375 ], [ -7.928513050079346, 71.149696350097656 ], [ -8.00836181640625, 71.030258178710938 ], [ -9.0430908203125, 70.803863525390625 ] ] ], [ [ [ 25.585277557373047, 70.922210693359375 ], [ 25.294441223144531, 71.042221069335938 ], [ 25.784721374511719, 71.154708862304688 ], [ 26.038055419921875, 71.105270385742188 ], [ 25.939720153808594, 71.000823974609375 ], [ 26.217081069946289, 71.037139892578125 ], [ 25.585277557373047, 70.922210693359375 ] ] ], [ [ [ 16.863796234130859, 40.390350341796875 ], [ 16.490554809570312, 39.749160766601562 ], [ 17.145553588867188, 39.396385192871094 ], [ 17.169166564941406, 38.963333129882812 ], [ 16.614997863769531, 38.817634582519531 ], [ 16.56916618347168, 38.428333282470703 ], [ 16.087776184082031, 37.94610595703125 ], [ 15.72027587890625, 37.931106567382812 ], [ 15.629581451416016, 38.229297637939453 ], [ 15.906110763549805, 38.472770690917969 ], [ 15.829026222229004, 38.627979278564453 ], [ 16.178192138671875, 38.745204925537109 ], [ 16.219789505004883, 38.921382904052734 ], [ 15.663748741149902, 40.033050537109375 ], [ 15.354860305786133, 40.000896453857422 ], [ 14.941944122314453, 40.234161376953125 ], [ 14.83076286315918, 40.631519317626953 ], [ 14.401943206787109, 40.599998474121094 ], [ 14.452775955200195, 40.747913360595703 ], [ 14.073888778686523, 40.821937561035156 ], [ 13.712221145629883, 41.251110076904297 ], [ 13.029582977294922, 41.260135650634766 ], [ 11.627707481384277, 42.298259735107422 ], [ 11.097429275512695, 42.396522521972656 ], [ 11.158054351806641, 42.55499267578125 ], [ 10.588888168334961, 42.957496643066406 ], [ 10.111804008483887, 44.003749847412109 ], [ 8.747220993041992, 44.428050994873047 ], [ 8.067777633666992, 43.893051147460938 ], [ 7.246805191040039, 43.70166015625 ], [ 6.641666412353516, 43.18499755859375 ], [ 6.165277481079102, 43.050552368164062 ], [ 5.0395827293396, 43.347911834716797 ], [ 5.231527328491211, 43.465831756591797 ], [ 5.024166107177734, 43.552635192871094 ], [ 4.815055370330811, 43.399215698242188 ], [ 4.707499504089355, 43.572078704833984 ], [ 4.758961200714111, 43.374149322509766 ], [ 4.056249618530273, 43.562774658203125 ], [ 3.258055210113525, 43.227493286132812 ], [ 2.961318969726562, 42.842216491699219 ], [ 3.168472051620483, 42.359718322753906 ], [ 3.317986011505127, 42.320480346679688 ], [ 3.11805534362793, 42.225131988525391 ], [ 3.201666355133057, 41.892776489257812 ], [ 2.117360830307007, 41.289299011230469 ], [ 0.993055462837219, 41.048049926757812 ], [ 0.703611016273499, 40.796871185302734 ], [ 0.896597146987915, 40.725761413574219 ], [ 0.54194438457489, 40.569160461425781 ], [ -0.326111137866974, 39.494720458984375 ], [ -0.182500004768372, 39.029159545898438 ], [ 0.207222193479538, 38.732208251953125 ], [ -0.511666774749756, 38.324996948242188 ], [ -0.858333349227905, 37.715549468994141 ], [ -0.72347229719162, 37.602218627929688 ], [ -1.327500104904175, 37.558052062988281 ], [ -1.643611192703247, 37.372772216796875 ], [ -2.12291693687439, 36.733467102050781 ], [ -2.347083568572998, 36.840549468994141 ], [ -2.7688889503479, 36.678329467773438 ], [ -4.399861812591553, 36.721454620361328 ], [ -4.639722347259521, 36.508327484130859 ], [ -5.1726393699646, 36.411872863769531 ], [ -5.338308811187744, 36.112071990966797 ], [ -5.613611221313477, 36.006103515625 ], [ -6.044167041778564, 36.186107635498047 ], [ -6.43250036239624, 36.692356109619141 ], [ -6.355556488037109, 36.860832214355469 ], [ -6.959923267364502, 37.221836090087891 ], [ -7.431854248046875, 37.253189086914062 ], [ -7.897778511047363, 37.008888244628906 ], [ -8.989236831665039, 37.026313781738281 ], [ -8.795862197875977, 37.442512512207031 ], [ -8.802501678466797, 38.374443054199219 ], [ -8.673334121704102, 38.413887023925781 ], [ -8.768890380859375, 38.517219543457031 ], [ -9.183889389038086, 38.419715881347656 ], [ -9.274236679077148, 38.668743133544922 ], [ -8.919746398925781, 38.765892028808594 ], [ -8.994306564331055, 38.940620422363281 ], [ -9.118473052978516, 38.717220306396484 ], [ -9.49083423614502, 38.79388427734375 ], [ -9.359583854675293, 39.356662750244141 ], [ -9.085556030273438, 39.614997863769531 ], [ -8.660139083862305, 40.691108703613281 ], [ -8.880834579467773, 41.751663208007812 ], [ -8.74500846862793, 41.952499389648438 ], [ -8.875140190124512, 41.879508972167969 ], [ -8.897500991821289, 42.110553741455078 ], [ -8.579862594604492, 42.349021911621094 ], [ -8.864861488342285, 42.249649047851562 ], [ -8.656112670898438, 42.427772521972656 ], [ -8.84083366394043, 42.391387939453125 ], [ -8.906112670898438, 42.475135803222656 ], [ -8.720497131347656, 42.698490142822266 ], [ -9.029375076293945, 42.524162292480469 ], [ -8.915833473205566, 42.789024353027344 ], [ -9.086668014526367, 42.740272521972656 ], [ -9.2933349609375, 42.922492980957031 ], [ -9.169723510742188, 43.185829162597656 ], [ -8.329723358154297, 43.403884887695312 ], [ -7.898056030273438, 43.76416015625 ], [ -7.044818878173828, 43.490402221679688 ], [ -5.854166984558105, 43.648048400878906 ], [ -4.514552116394043, 43.396347045898438 ], [ -3.585556030273438, 43.510276794433594 ], [ -3.150592803955078, 43.353561401367188 ], [ -1.780876636505127, 43.35992431640625 ], [ -1.443888902664185, 43.640548706054688 ], [ -1.208611249923706, 44.625831604003906 ], [ -1.040625095367432, 44.6749267578125 ], [ -1.245833396911621, 44.675342559814453 ], [ -1.089444518089294, 45.558605194091797 ], [ -0.539930582046509, 44.895622253417969 ], [ -0.781527876853943, 45.466522216796875 ], [ -1.238858222961426, 45.706214904785156 ], [ -1.070972323417664, 45.903949737548828 ], [ -1.11463451385498, 46.316581726074219 ], [ -1.786389112472534, 46.488327026367188 ], [ -2.125416994094849, 46.830970764160156 ], [ -1.9858717918396, 47.036930084228516 ], [ -2.170833587646484, 47.126663208007812 ], [ -2.134166717529297, 47.278053283691406 ], [ -1.735000014305115, 47.208675384521484 ], [ -2.012778043746948, 47.319854736328125 ], [ -2.539652824401855, 47.298053741455078 ], [ -2.367083549499512, 47.50152587890625 ], [ -2.831875324249268, 47.497283935546875 ], [ -2.700278043746948, 47.637077331542969 ], [ -3.125069618225098, 47.595409393310547 ], [ -3.132639169692993, 47.476661682128906 ], [ -3.216944694519043, 47.650550842285156 ], [ -3.982222557067871, 47.889717102050781 ], [ -4.367361545562744, 47.808742523193359 ], [ -4.722238063812256, 48.039176940917969 ], [ -4.282917022705078, 48.116523742675781 ], [ -4.546597480773926, 48.1744384765625 ], [ -4.5665283203125, 48.332077026367188 ], [ -4.192153453826904, 48.299369812011719 ], [ -4.440463066101074, 48.346199035644531 ], [ -4.76062536239624, 48.334995269775391 ], [ -4.750972747802734, 48.539440155029297 ], [ -3.582430601119995, 48.677772521972656 ], [ -3.536666870117188, 48.825828552246094 ], [ -3.22611141204834, 48.869579315185547 ], [ -2.685277938842773, 48.501663208007812 ], [ -2.307222366333008, 48.676109313964844 ], [ -1.976111173629761, 48.513050079345703 ], [ -1.98805570602417, 48.686943054199219 ], [ -1.368889093399048, 48.643608093261719 ], [ -1.562569499015808, 48.748954772949219 ], [ -1.609722375869751, 49.214996337890625 ], [ -1.922013878822327, 49.726455688476562 ], [ -1.264166831970215, 49.684165954589844 ], [ -1.109583497047424, 49.369438171386719 ], [ -0.228333353996277, 49.283607482910156 ], [ 0.465763837099075, 49.468814849853516 ], [ 0.075833320617676, 49.522567749023438 ], [ 0.211111098527908, 49.718883514404297 ], [ 1.43874990940094, 50.100830078125 ], [ 1.739583134651184, 50.945274353027344 ], [ 3.528888463973999, 51.411663055419922 ], [ 4.309677124023438, 51.262031555175781 ], [ 4.202499389648438, 51.404998779296875 ], [ 3.444235801696777, 51.529369354248047 ], [ 3.834999799728394, 51.606666564941406 ], [ 4.283610820770264, 51.448051452636719 ], [ 3.997846603393555, 51.590133666992188 ], [ 4.209434986114502, 51.674091339111328 ], [ 3.867985725402832, 51.812149047851562 ], [ 4.574371337890625, 52.454471588134766 ], [ 5.422499656677246, 52.249019622802734 ], [ 5.813735485076904, 52.428462982177734 ], [ 5.878054618835449, 52.509437561035156 ], [ 5.854999542236328, 52.606910705566406 ], [ 5.600554943084717, 52.658191680908203 ], [ 5.718352317810059, 52.838020324707031 ], [ 5.370798110961914, 52.880199432373047 ], [ 5.369860649108887, 53.070411682128906 ], [ 5.100276947021484, 52.948051452636719 ], [ 5.30319356918335, 52.704856872558594 ], [ 5.167777061462402, 52.628883361816406 ], [ 5.050624370574951, 52.641525268554688 ], [ 5.029721736907959, 52.624092102050781 ], [ 5.078055381774902, 52.416107177734375 ], [ 4.582013607025146, 52.477081298828125 ], [ 4.738818645477295, 52.956661224365234 ], [ 5.094443798065186, 52.959163665771484 ], [ 5.599165916442871, 53.300277709960938 ], [ 6.741944313049316, 53.465827941894531 ], [ 7.200485706329346, 53.240409851074219 ], [ 7.350902080535889, 53.3072509765625 ], [ 7.049930095672607, 53.341106414794922 ], [ 7.093540668487549, 53.588188171386719 ], [ 7.907499313354492, 53.719444274902344 ], [ 8.21027660369873, 53.403049468994141 ], [ 8.269582748413086, 53.607494354248047 ], [ 8.494443893432617, 53.55499267578125 ], [ 8.484721183776855, 53.412216186523438 ], [ 8.503887176513672, 53.362358093261719 ], [ 8.565519332885742, 53.529056549072266 ], [ 8.484096527099609, 53.686317443847656 ], [ 8.659026145935059, 53.892635345458984 ], [ 9.283401489257812, 53.855548858642578 ], [ 9.577916145324707, 53.588607788085938 ], [ 9.829060554504395, 53.541698455810547 ], [ 9.332776069641113, 53.854995727539062 ], [ 8.906804084777832, 53.934715270996094 ], [ 8.844269752502441, 54.034751892089844 ], [ 9.017221450805664, 54.084999084472656 ], [ 8.827360153198242, 54.151660919189453 ], [ 8.883609771728516, 54.294166564941406 ], [ 8.600484848022461, 54.326381683349609 ], [ 9.011248588562012, 54.503467559814453 ], [ 8.641387939453125, 54.832218170166016 ], [ 8.300901412963867, 54.856452941894531 ], [ 8.29083251953125, 54.742805480957031 ], [ 8.293333053588867, 54.900554656982422 ], [ 8.388193130493164, 55.049163818359375 ], [ 8.420421600341797, 54.919643402099609 ], [ 8.664545059204102, 54.913093566894531 ], [ 8.676109313964844, 55.114166259765625 ], [ 8.492082595825195, 55.062702178955078 ], [ 8.475137710571289, 55.179580688476562 ], [ 8.689443588256836, 55.160270690917969 ], [ 8.618193626403809, 55.431106567382812 ], [ 8.092915534973145, 55.556205749511719 ], [ 8.127707481384277, 55.983814239501953 ], [ 8.191387176513672, 55.810691833496094 ], [ 8.395692825317383, 55.894718170166016 ], [ 8.26291561126709, 56.078884124755859 ], [ 8.108331680297852, 56.017776489257812 ], [ 8.12117862701416, 56.548259735107422 ], [ 8.220727920532227, 56.707424163818359 ], [ 8.643540382385254, 56.474296569824219 ], [ 9.072783470153809, 56.807613372802734 ], [ 9.062915802001953, 56.565757751464844 ], [ 9.318262100219727, 56.525409698486328 ], [ 9.178199768066406, 56.916030883789062 ], [ 9.974273681640625, 57.071731567382812 ], [ 10.311890602111816, 56.981304168701172 ], [ 10.305276870727539, 56.748054504394531 ], [ 9.866388320922852, 56.650276184082031 ], [ 10.34305477142334, 56.692634582519531 ], [ 10.361943244934082, 56.644996643066406 ], [ 10.214720726013184, 56.544303894042969 ], [ 10.187776565551758, 56.468605041503906 ], [ 10.308666229248047, 56.578159332275391 ], [ 10.961943626403809, 56.442218780517578 ], [ 10.744998931884766, 56.163887023925781 ], [ 10.519721031188965, 56.099720001220703 ], [ 10.355692863464355, 56.197494506835938 ], [ 10.448610305786133, 56.291938781738281 ], [ 10.23936653137207, 56.172607421875 ], [ 10.184581756591797, 55.828189849853516 ], [ 9.869582176208496, 55.843746185302734 ], [ 10.044443130493164, 55.815689086914062 ], [ 9.992776870727539, 55.704994201660156 ], [ 9.554581642150879, 55.702980041503906 ], [ 9.81916618347168, 55.604721069335938 ], [ 9.704166412353516, 55.531105041503906 ], [ 9.5897216796875, 55.418190002441406 ], [ 9.677151679992676, 55.191173553466797 ], [ 9.461525917053223, 55.122146606445312 ], [ 9.766110420227051, 54.896385192871094 ], [ 9.43944263458252, 54.807979583740234 ], [ 9.972012519836426, 54.760757446289062 ], [ 10.032499313354492, 54.555274963378906 ], [ 9.866040229797363, 54.457286834716797 ], [ 10.690553665161133, 54.309299468994141 ], [ 11.073888778686523, 54.376388549804688 ], [ 11.09395694732666, 54.205482482910156 ], [ 10.762221336364746, 54.056522369384766 ], [ 10.818534851074219, 53.890052795410156 ], [ 11.094720840454102, 54.01361083984375 ], [ 11.412776947021484, 53.919715881347656 ], [ 12.526943206787109, 54.474159240722656 ], [ 12.921526908874512, 54.427459716796875 ], [ 12.463888168334961, 54.395133972167969 ], [ 12.374373435974121, 54.262428283691406 ], [ 13.023887634277344, 54.39971923828125 ], [ 13.454582214355469, 54.097080230712891 ], [ 13.710831642150879, 54.170825958251953 ], [ 13.808540344238281, 53.854785919189453 ], [ 13.959165573120117, 53.774993896484375 ], [ 14.524999618530273, 53.660552978515625 ], [ 14.553471565246582, 53.857772827148438 ], [ 13.829189300537109, 53.859504699707031 ], [ 14.056002616882324, 53.98486328125 ], [ 13.768470764160156, 54.165828704833984 ], [ 14.376387596130371, 53.912220001220703 ], [ 16.174720764160156, 54.259162902832031 ], [ 16.543609619140625, 54.544715881347656 ], [ 18.043331146240234, 54.834026336669922 ], [ 18.336109161376953, 54.836036682128906 ], [ 18.703887939453125, 54.700271606445312 ], [ 18.77471923828125, 54.6663818359375 ], [ 18.406108856201172, 54.738189697265625 ], [ 18.595205307006836, 54.427772521972656 ], [ 18.843748092651367, 54.351802825927734 ], [ 19.439720153808594, 54.385826110839844 ], [ 19.836383819580078, 54.599998474121094 ], [ 19.630344390869141, 54.443069458007812 ], [ 19.408050537109375, 54.35888671875 ], [ 19.23076057434082, 54.333671569824219 ], [ 19.371109008789062, 54.268600463867188 ], [ 20.397289276123047, 54.675064086914062 ], [ 19.872711181640625, 54.640548706054688 ], [ 19.990409851074219, 54.95721435546875 ], [ 20.422634124755859, 54.947628021240234 ], [ 20.894439697265625, 55.243049621582031 ], [ 21.092008590698242, 55.714015960693359 ], [ 21.046663284301758, 55.329719543457031 ], [ 20.531698226928711, 54.964363098144531 ], [ 21.245063781738281, 54.955059051513672 ], [ 21.289024353027344, 55.286457061767578 ], [ 20.973606109619141, 56.237907409667969 ], [ 21.052227020263672, 56.817489624023438 ], [ 21.39569091796875, 57.026657104492188 ], [ 21.417285919189453, 57.281932830810547 ], [ 21.729022979736328, 57.574718475341797 ], [ 22.606904983520508, 57.749057769775391 ], [ 22.643329620361328, 57.585273742675781 ], [ 23.135690689086914, 57.36444091796875 ], [ 23.256107330322266, 57.100963592529297 ], [ 23.6552734375, 56.965892791748047 ], [ 24.404163360595703, 57.251243591308594 ], [ 24.28895378112793, 57.833465576171875 ], [ 24.554510116577148, 58.324714660644531 ], [ 24.330829620361328, 58.386661529541016 ], [ 24.103607177734375, 58.235542297363281 ], [ 23.728607177734375, 58.370826721191406 ], [ 23.495548248291016, 58.69415283203125 ], [ 23.864233016967773, 58.773048400878906 ], [ 23.483051300048828, 58.809989929199219 ], [ 23.438327789306641, 58.939987182617188 ], [ 23.636663436889648, 58.974292755126953 ], [ 23.41041374206543, 59.01568603515625 ], [ 23.505273818969727, 59.226795196533203 ], [ 24.795969009399414, 59.564994812011719 ], [ 25.399209976196289, 59.488231658935547 ], [ 25.477424621582031, 59.658046722412109 ], [ 27.887912750244141, 59.408599853515625 ], [ 28.066247940063477, 59.544437408447266 ], [ 28.074581146240234, 59.794578552246094 ], [ 28.366802215576172, 59.661239624023438 ], [ 28.495828628540039, 59.855274200439453 ], [ 28.832218170166016, 59.783466339111328 ], [ 29.194578170776367, 60.006801605224609 ], [ 30.218051910400391, 59.896938323974609 ], [ 29.824165344238281, 60.168327331542969 ], [ 29.04638671875, 60.181663513183594 ], [ 28.598329544067383, 60.387214660644531 ], [ 28.446735382080078, 60.548954010009766 ], [ 28.70573616027832, 60.460872650146484 ], [ 28.554302215576172, 60.608467102050781 ], [ 28.676731109619141, 60.735824584960938 ], [ 28.146663665771484, 60.529434204101562 ], [ 27.21916389465332, 60.583744049072266 ], [ 26.50013542175293, 60.444995880126953 ], [ 26.749719619750977, 60.575340270996094 ], [ 26.652359008789062, 60.646385192871094 ], [ 26.416526794433594, 60.39166259765625 ], [ 26.05506706237793, 60.422771453857422 ], [ 26.07874870300293, 60.294025421142578 ], [ 25.838193893432617, 60.398468017578125 ], [ 25.921663284301758, 60.243743896484375 ], [ 25.657497406005859, 60.361248016357422 ], [ 24.472497940063477, 59.990413665771484 ], [ 24.333053588867188, 60.071937561035156 ], [ 23.431594848632812, 59.953815460205078 ], [ 23.537496566772461, 60.067562103271484 ], [ 23.249303817749023, 59.837913513183594 ], [ 22.900276184082031, 59.806800842285156 ], [ 23.257217407226562, 59.919441223144531 ], [ 23.335693359375, 60.023952484130859 ], [ 23.109231948852539, 59.925651550292969 ], [ 23.254859924316406, 60.037078857421875 ], [ 22.874443054199219, 60.145553588867188 ], [ 23.084650039672852, 60.345203399658203 ], [ 22.565473556518555, 60.211936950683594 ], [ 22.449302673339844, 60.242355346679688 ], [ 22.626594543457031, 60.380443572998047 ], [ 21.803054809570312, 60.482498168945312 ], [ 21.824443817138672, 60.619163513183594 ], [ 21.424163818359375, 60.579299926757812 ], [ 21.328330993652344, 60.865272521972656 ], [ 21.554443359375, 61.309440612792969 ], [ 21.468887329101562, 61.556522369384766 ], [ 21.663887023925781, 61.540275573730469 ], [ 21.284582138061523, 61.946384429931641 ], [ 21.371665954589844, 62.259994506835938 ], [ 21.065969467163086, 62.597980499267578 ], [ 21.435552597045898, 63.034717559814453 ], [ 21.676595687866211, 63.020133972167969 ], [ 21.496871948242188, 63.203536987304688 ], [ 22.339998245239258, 63.276523590087891 ], [ 22.187845230102539, 63.445133209228516 ], [ 22.288192749023438, 63.525691986083984 ], [ 23.318885803222656, 63.896659851074219 ], [ 24.339303970336914, 64.521659851074219 ], [ 24.539581298828125, 64.799156188964844 ], [ 25.319442749023438, 64.817764282226562 ], [ 25.189304351806641, 64.964019775390625 ], [ 25.444232940673828, 64.953392028808594 ], [ 25.267498016357422, 65.169998168945312 ], [ 25.351247787475586, 65.478744506835938 ], [ 24.669166564941406, 65.654708862304688 ], [ 24.553539276123047, 65.762001037597656 ], [ 24.689163208007812, 65.896102905273438 ], [ 23.077358245849609, 65.700828552246094 ], [ 22.675830841064453, 65.9022216796875 ], [ 22.679302215576172, 65.760475158691406 ], [ 22.329166412353516, 65.8297119140625 ], [ 22.249053955078125, 65.632492065429688 ], [ 22.399997711181641, 65.536796569824219 ], [ 21.765829086303711, 65.712142944335938 ], [ 22.194372177124023, 65.542282104492188 ], [ 21.471246719360352, 65.383743286132812 ], [ 21.659303665161133, 65.245826721191406 ], [ 21.328678131103516, 65.370269775390625 ], [ 21.264860153198242, 65.3382568359375 ], [ 21.619373321533203, 65.151374816894531 ], [ 21.039373397827148, 64.823814392089844 ], [ 21.303400039672852, 64.76165771484375 ], [ 21.104721069335938, 64.7198486328125 ], [ 21.584999084472656, 64.439712524414062 ], [ 20.963747024536133, 64.1427001953125 ], [ 20.774024963378906, 63.867080688476562 ], [ 19.704998016357422, 63.431938171386719 ], [ 19.425830841064453, 63.546314239501953 ], [ 19.062498092651367, 63.17694091796875 ], [ 18.896665573120117, 63.273189544677734 ], [ 18.289165496826172, 62.997215270996094 ], [ 18.575204849243164, 62.961799621582031 ], [ 18.20402717590332, 62.777359008789062 ], [ 17.700551986694336, 62.992706298828125 ], [ 18.04638671875, 62.59527587890625 ], [ 17.330831527709961, 62.487773895263672 ], [ 17.37388801574707, 62.326801300048828 ], [ 17.648885726928711, 62.231731414794922 ], [ 17.350830078125, 61.943470001220703 ], [ 17.495170593261719, 61.634578704833984 ], [ 17.333192825317383, 61.713466644287109 ], [ 17.148780822753906, 61.71728515625 ], [ 17.264545440673828, 61.685375213623047 ], [ 17.098609924316406, 61.602775573730469 ], [ 17.219650268554688, 61.434650421142578 ], [ 17.105276107788086, 61.399925231933594 ], [ 17.152498245239258, 60.942775726318359 ], [ 17.377098083496094, 60.618988037109375 ], [ 17.687915802001953, 60.497356414794922 ], [ 17.960969924926758, 60.592079162597656 ], [ 18.239582061767578, 60.329021453857422 ], [ 18.437845230102539, 60.339996337890625 ], [ 18.599615097045898, 60.235618591308594 ], [ 18.317081451416016, 60.308189392089844 ], [ 18.816387176513672, 60.096382141113281 ], [ 19.070552825927734, 59.889717102050781 ], [ 18.864719390869141, 59.798049926757812 ], [ 19.072637557983398, 59.738193511962891 ], [ 18.091388702392578, 59.334442138671875 ], [ 17.78277587890625, 59.38916015625 ], [ 17.817707061767578, 59.586452484130859 ], [ 17.603961944580078, 59.650627136230469 ], [ 17.654163360595703, 59.718048095703125 ], [ 17.591039657592773, 59.803050994873047 ], [ 17.444721221923828, 59.676109313964844 ], [ 17.54315185546875, 59.573005676269531 ], [ 17.510137557983398, 59.696731567382812 ], [ 17.612567901611328, 59.732425689697266 ], [ 17.56117057800293, 59.668449401855469 ], [ 17.785831451416016, 59.532634735107422 ], [ 17.731386184692383, 59.444854736328125 ], [ 17.382844924926758, 59.652359008789062 ], [ 17.404443740844727, 59.469161987304688 ], [ 16.558609008789062, 59.609855651855469 ], [ 16.032463073730469, 59.490165710449219 ], [ 16.877775192260742, 59.381938934326172 ], [ 16.695415496826172, 59.470478057861328 ], [ 16.836734771728516, 59.489646911621094 ], [ 17.370553970336914, 59.248050689697266 ], [ 17.352912902832031, 59.321453094482422 ], [ 17.847221374511719, 59.264442443847656 ], [ 18.278539657592773, 59.366107940673828 ], [ 18.454719543457031, 59.331108093261719 ], [ 18.477218627929688, 59.435272216796875 ], [ 18.643156051635742, 59.321868896484375 ], [ 18.2772216796875, 59.310829162597656 ], [ 18.311386108398438, 59.132499694824219 ], [ 17.894721984863281, 58.85888671875 ], [ 17.666248321533203, 59.167354583740234 ], [ 17.629095077514648, 58.910202026367188 ], [ 17.349998474121094, 58.752220153808594 ], [ 16.193607330322266, 58.627494812011719 ], [ 16.933609008789062, 58.488327026367188 ], [ 16.422843933105469, 58.477771759033203 ], [ 16.769996643066406, 58.367218017578125 ], [ 16.825832366943359, 58.176666259765625 ], [ 16.620206832885742, 57.987010955810547 ], [ 16.763608932495117, 57.881240844726562 ], [ 16.50621223449707, 57.991973876953125 ], [ 16.695175170898438, 57.74169921875 ], [ 16.419233322143555, 57.889091491699219 ], [ 16.711387634277344, 57.70263671875 ], [ 16.665830612182617, 57.408535003662109 ], [ 16.472221374511719, 57.290275573730469 ], [ 16.584442138671875, 57.046661376953125 ], [ 16.379823684692383, 56.663326263427734 ], [ 15.865554809570312, 56.092216491699219 ], [ 14.692636489868164, 56.158191680908203 ], [ 14.738332748413086, 56.010826110839844 ], [ 14.555136680603027, 56.056247711181641 ], [ 14.217222213745117, 55.830276489257812 ], [ 14.365936279296875, 55.542842864990234 ], [ 14.193546295166016, 55.386146545410156 ], [ 12.982221603393555, 55.400550842285156 ], [ 12.921178817749023, 55.572425842285156 ], [ 13.061108589172363, 55.680759429931641 ], [ 12.460068702697754, 56.296661376953125 ], [ 12.799234390258789, 56.225898742675781 ], [ 12.62430477142334, 56.418331146240234 ], [ 12.917221069335938, 56.578605651855469 ], [ 12.348888397216797, 56.916805267333984 ], [ 12.094999313354492, 57.42694091796875 ], [ 11.902776718139648, 57.424304962158203 ], [ 11.887777328491211, 57.693885803222656 ], [ 11.701873779296875, 57.699924468994141 ], [ 11.880485534667969, 58.202079772949219 ], [ 11.798053741455078, 58.318328857421875 ], [ 11.729165077209473, 58.328609466552734 ], [ 11.528610229492188, 58.230758666992188 ], [ 11.201387405395508, 58.399436950683594 ], [ 11.113332748413086, 59.003608703613281 ], [ 11.319998741149902, 59.100273132324219 ], [ 11.43277645111084, 58.995136260986328 ], [ 11.354928970336914, 59.106727600097656 ], [ 10.764720916748047, 59.22027587890625 ], [ 10.65916633605957, 59.363883972167969 ], [ 10.691463470458984, 59.479263305664062 ], [ 10.559582710266113, 59.724788665771484 ], [ 10.741179466247559, 59.890342712402344 ], [ 10.473262786865234, 59.844089508056641 ], [ 10.609859466552734, 59.591873168945312 ], [ 10.513053894042969, 59.524993896484375 ], [ 10.37763786315918, 59.700828552246094 ], [ 10.230901718139648, 59.729091644287109 ], [ 10.515693664550781, 59.306243896484375 ], [ 10.231109619140625, 59.038604736328125 ], [ 9.877498626708984, 58.954994201660156 ], [ 9.551595687866211, 59.114021301269531 ], [ 9.69305419921875, 58.983055114746094 ], [ 8.127498626708984, 58.098884582519531 ], [ 6.602916240692139, 58.069438934326172 ], [ 6.75999927520752, 58.244022369384766 ], [ 6.011943817138672, 58.379714965820312 ], [ 5.508471965789795, 58.667636871337891 ], [ 5.558610439300537, 59.0302734375 ], [ 6.168610572814941, 58.832221984863281 ], [ 6.119165897369385, 58.957008361816406 ], [ 6.617082595825195, 59.053466796875 ], [ 6.163610935211182, 58.995830535888672 ], [ 6.036388397216797, 58.904506683349609 ], [ 5.869860649108887, 59.0655517578125 ], [ 6.45979118347168, 59.320480346679688 ], [ 5.996527194976807, 59.332912445068359 ], [ 6.468888282775879, 59.555274963378906 ], [ 5.940173149108887, 59.353225708007812 ], [ 5.883471488952637, 59.436386108398438 ], [ 6.145555019378662, 59.479301452636719 ], [ 5.807777404785156, 59.469161987304688 ], [ 5.667658805847168, 59.409065246582031 ], [ 5.852499485015869, 59.344161987304688 ], [ 5.51652717590332, 59.275550842285156 ], [ 5.178888320922852, 59.506801605224609 ], [ 5.481179714202881, 59.727912902832031 ], [ 5.459734916687012, 59.519218444824219 ], [ 5.568471431732178, 59.675621032714844 ], [ 6.061805248260498, 59.742916107177734 ], [ 6.303645133972168, 59.844474792480469 ], [ 5.698332786560059, 59.832771301269531 ], [ 6.204721450805664, 60.295555114746094 ], [ 6.63493013381958, 60.406105041503906 ], [ 6.531665802001953, 60.258888244628906 ], [ 6.505971908569336, 60.107635498046875 ], [ 6.52194356918335, 60.083465576171875 ], [ 6.741665840148926, 60.436943054199219 ], [ 7.102013111114502, 60.496105194091797 ], [ 6.22131872177124, 60.407356262207031 ], [ 5.747221946716309, 59.986663818359375 ], [ 5.641805171966553, 60.145828247070312 ], [ 5.548749446868896, 60.149089813232422 ], [ 5.728089332580566, 60.383743286132812 ], [ 5.411110877990723, 60.129714965820312 ], [ 5.144929885864258, 60.361038208007812 ], [ 5.285554885864258, 60.521659851074219 ], [ 5.487082958221436, 60.422634124755859 ], [ 5.637221813201904, 60.416942596435547 ], [ 5.706457614898682, 60.459506988525391 ], [ 5.719999313354492, 60.6744384765625 ], [ 5.627777099609375, 60.713050842285156 ], [ 5.36027717590332, 60.564994812011719 ], [ 5.198610305786133, 60.577499389648438 ], [ 4.931110382080078, 60.800548553466797 ], [ 5.428055286407471, 60.627220153808594 ], [ 5.237499237060547, 60.770622253417969 ], [ 5.532082557678223, 60.871109008789062 ], [ 5.070138454437256, 60.829719543457031 ], [ 5.012290954589844, 61.040271759033203 ], [ 6.372221946716309, 61.061943054199219 ], [ 6.818193912506104, 61.14166259765625 ], [ 7.113888740539551, 60.860275268554688 ], [ 6.998054981231689, 61.087841033935547 ], [ 7.428610801696777, 61.181388854980469 ], [ 7.304166316986084, 61.291248321533203 ], [ 7.562464714050293, 61.470340728759766 ], [ 7.279443740844727, 61.325553894042969 ], [ 7.353888511657715, 61.189994812011719 ], [ 6.961249351501465, 61.109855651855469 ], [ 6.579027652740479, 61.211666107177734 ], [ 6.712637901306152, 61.394786834716797 ], [ 6.42847204208374, 61.113193511962891 ], [ 5.115833282470703, 61.14166259765625 ], [ 5.243054866790771, 61.182357788085938 ], [ 4.952499389648438, 61.256107330322266 ], [ 5.627082824707031, 61.361312866210938 ], [ 4.94944429397583, 61.410411834716797 ], [ 5.796249389648438, 61.447982788085938 ], [ 5.188332557678223, 61.498886108398438 ], [ 5.338674545288086, 61.592479705810547 ], [ 4.971944332122803, 61.632148742675781 ], [ 4.982915878295898, 61.739994049072266 ], [ 5.417222023010254, 61.911247253417969 ], [ 5.744721412658691, 61.842216491699219 ], [ 6.469165802001953, 61.800827026367188 ], [ 6.76361083984375, 61.868049621582031 ], [ 5.433610916137695, 61.93499755859375 ], [ 5.154582977294922, 61.892498016357422 ], [ 5.399096488952637, 62.018814086914062 ], [ 5.080138206481934, 62.176662445068359 ], [ 5.468888282775879, 62.006801605224609 ], [ 5.421041488647461, 62.178119659423828 ], [ 6.360416412353516, 62.060897827148438 ], [ 5.920138359069824, 62.206729888916016 ], [ 6.320416450500488, 62.367633819580078 ], [ 6.533263206481934, 62.11041259765625 ], [ 6.395138263702393, 62.377220153808594 ], [ 6.703332424163818, 62.444858551025391 ], [ 6.87798547744751, 62.412563323974609 ], [ 6.944652080535889, 62.108955383300781 ], [ 7.003054618835449, 62.085548400878906 ], [ 7.06874942779541, 62.09124755859375 ], [ 7.027777194976807, 62.266525268554688 ], [ 7.415138244628906, 62.229721069335938 ], [ 6.786527156829834, 62.477218627929688 ], [ 6.255694389343262, 62.456108093261719 ], [ 6.646832466125488, 62.495758056640625 ], [ 6.25298547744751, 62.577770233154297 ], [ 7.089999198913574, 62.647773742675781 ], [ 7.539166450500488, 62.499160766601562 ], [ 7.77263879776001, 62.574855804443359 ], [ 7.411943912506104, 62.617008209228516 ], [ 8.137984275817871, 62.693641662597656 ], [ 6.954582691192627, 62.724025726318359 ], [ 6.949443817138672, 62.931388854980469 ], [ 7.265138626098633, 63.011383056640625 ], [ 7.467360496520996, 62.911247253417969 ], [ 8.010971069335938, 62.966941833496094 ], [ 8.17986011505127, 62.800689697265625 ], [ 8.548332214355469, 62.653884887695312 ], [ 8.153610229492188, 62.944091796875 ], [ 7.880902290344238, 63.0025634765625 ], [ 8.098054885864258, 63.103748321533203 ], [ 8.357776641845703, 62.88055419921875 ], [ 8.531769752502441, 62.847217559814453 ], [ 8.417568206787109, 62.951313018798828 ], [ 8.656839370727539, 62.971694946289062 ], [ 8.160970687866211, 63.118049621582031 ], [ 8.94013786315918, 63.207912445068359 ], [ 8.479722023010254, 63.291801452636719 ], [ 8.758540153503418, 63.342914581298828 ], [ 8.672222137451172, 63.413887023925781 ], [ 9.000970840454102, 63.464649200439453 ], [ 9.231388092041016, 63.3538818359375 ], [ 9.418054580688477, 63.374717712402344 ], [ 9.152811050415039, 63.485759735107422 ], [ 9.534582138061523, 63.604579925537109 ], [ 9.717498779296875, 63.630271911621094 ], [ 9.976110458374023, 63.356109619140625 ], [ 10.263193130493164, 63.264820098876953 ], [ 10.064443588256836, 63.419715881347656 ], [ 10.91180419921875, 63.458049774169922 ], [ 10.761665344238281, 63.505760192871094 ], [ 10.913124084472656, 63.599925994873047 ], [ 10.666248321533203, 63.54541015625 ], [ 11.459929466247559, 63.798259735107422 ], [ 11.095484733581543, 63.886245727539062 ], [ 11.487915992736816, 64.005546569824219 ], [ 11.313054084777832, 64.116241455078125 ], [ 10.579929351806641, 63.804786682128906 ], [ 11.074721336364746, 63.839717864990234 ], [ 10.941944122314453, 63.738052368164062 ], [ 10.04777717590332, 63.496109008789062 ], [ 9.789165496826172, 63.662498474121094 ], [ 10.094581604003906, 63.759647369384766 ], [ 9.570276260375977, 63.661384582519531 ], [ 9.545276641845703, 63.766109466552734 ], [ 10.192777633666992, 63.932910919189453 ], [ 9.982221603393555, 63.990554809570312 ], [ 10.652082443237305, 64.355545043945312 ], [ 10.495290756225586, 64.423812866210938 ], [ 10.849443435668945, 64.370552062988281 ], [ 10.662637710571289, 64.443115234375 ], [ 10.965693473815918, 64.600967407226562 ], [ 11.273332595825195, 64.45166015625 ], [ 11.22166633605957, 64.31610107421875 ], [ 11.728054046630859, 64.5797119140625 ], [ 11.438331604003906, 64.711105346679688 ], [ 12.217082023620605, 64.940681457519531 ], [ 11.24152660369873, 64.733596801757812 ], [ 11.69597053527832, 64.898880004882812 ], [ 11.30180549621582, 64.8851318359375 ], [ 12.624721527099609, 65.13360595703125 ], [ 12.939234733581543, 65.320884704589844 ], [ 12.479789733886719, 65.134300231933594 ], [ 12.368331909179688, 65.157768249511719 ], [ 12.675387382507324, 65.251716613769531 ], [ 12.249026298522949, 65.231796264648438 ], [ 12.634511947631836, 65.416030883789062 ], [ 12.354928970336914, 65.640754699707031 ], [ 12.783818244934082, 65.634712219238281 ], [ 12.553400993347168, 65.747909545898438 ], [ 12.670832633972168, 65.919158935546875 ], [ 13.169443130493164, 65.849845886230469 ], [ 12.957359313964844, 66.039161682128906 ], [ 12.673748970031738, 66.064437866210938 ], [ 13.559652328491211, 66.234016418457031 ], [ 13.549720764160156, 66.100555419921875 ], [ 14.138262748718262, 66.320236206054688 ], [ 13.028401374816895, 66.188949584960938 ], [ 13.527429580688477, 66.305130004882812 ], [ 13.020832061767578, 66.324440002441406 ], [ 13.15513801574707, 66.433326721191406 ], [ 12.975692749023438, 66.517280578613281 ], [ 13.210970878601074, 66.509437561035156 ], [ 13.713610649108887, 66.601524353027344 ], [ 13.234165191650391, 66.545547485351562 ], [ 13.191527366638184, 66.661109924316406 ], [ 13.535831451416016, 66.634719848632812 ], [ 13.229026794433594, 66.710273742675781 ], [ 13.990833282470703, 66.785270690917969 ], [ 13.551387786865234, 66.928466796875 ], [ 14.594443321228027, 67.032905578613281 ], [ 14.268887519836426, 67.076652526855469 ], [ 14.350555419921875, 67.151107788085938 ], [ 14.742637634277344, 67.117835998535156 ], [ 14.580832481384277, 67.195274353027344 ], [ 15.495553970336914, 67.065277099609375 ], [ 15.384929656982422, 67.194091796875 ], [ 15.735554695129395, 67.175750732421875 ], [ 15.153887748718262, 67.305549621582031 ], [ 14.328896522521973, 67.239204406738281 ], [ 15.035831451416016, 67.570541381835938 ], [ 15.14659595489502, 67.541099548339844 ], [ 14.934277534484863, 67.473106384277344 ], [ 15.435276985168457, 67.473739624023438 ], [ 15.644443511962891, 67.268051147460938 ], [ 15.531387329101562, 67.464996337890625 ], [ 15.887463569641113, 67.556449890136719 ], [ 15.278888702392578, 67.518325805664062 ], [ 15.182429313659668, 67.619575500488281 ], [ 15.30687427520752, 67.716728210449219 ], [ 15.826873779296875, 67.676589965820312 ], [ 15.372081756591797, 67.79241943359375 ], [ 14.761665344238281, 67.643051147460938 ], [ 15.036109924316406, 67.740264892578125 ], [ 14.756804466247559, 67.802627563476562 ], [ 15.871110916137695, 67.923324584960938 ], [ 15.961111068725586, 68.013046264648438 ], [ 15.288331985473633, 68.030548095703125 ], [ 16.013748168945312, 68.243461608886719 ], [ 16.212011337280273, 67.900688171386719 ], [ 16.495830535888672, 67.794158935546875 ], [ 16.207496643066406, 67.999992370605469 ], [ 16.715274810791016, 68.066665649414062 ], [ 16.342498779296875, 68.0716552734375 ], [ 16.458053588867188, 68.208602905273438 ], [ 16.105762481689453, 68.271102905273438 ], [ 16.516803741455078, 68.253463745117188 ], [ 16.632774353027344, 68.174163818359375 ], [ 16.800065994262695, 68.130332946777344 ], [ 16.317218780517578, 68.366943359375 ], [ 17.132637023925781, 68.36749267578125 ], [ 17.358053207397461, 68.176376342773438 ], [ 17.202499389648438, 68.369575500488281 ], [ 17.571523666381836, 68.359916687011719 ], [ 17.373746871948242, 68.409011840820312 ], [ 17.548192977905273, 68.525688171386719 ], [ 16.467010498046875, 68.511726379394531 ], [ 16.97291374206543, 68.701522827148438 ], [ 17.669059753417969, 68.657562255859375 ], [ 17.239095687866211, 68.753463745117188 ], [ 17.792499542236328, 68.756942749023438 ], [ 17.471385955810547, 68.827774047851562 ], [ 17.84437370300293, 68.87249755859375 ], [ 17.718608856201172, 68.928604125976562 ], [ 17.431873321533203, 68.898391723632812 ], [ 17.636455535888672, 69.103675842285156 ], [ 18.147914886474609, 69.150131225585938 ], [ 17.996387481689453, 69.2802734375 ], [ 18.256942749023438, 69.486373901367188 ], [ 18.539443969726562, 69.299163818359375 ], [ 19.006942749023438, 69.287078857421875 ], [ 18.45728874206543, 69.449569702148438 ], [ 18.85020637512207, 69.550338745117188 ], [ 19.010622024536133, 69.396171569824219 ], [ 19.376108169555664, 69.317977905273438 ], [ 19.173746109008789, 69.259117126464844 ], [ 19.4405517578125, 69.225830078125 ], [ 19.417499542236328, 69.348876953125 ], [ 18.998052597045898, 69.459152221679688 ], [ 19.226665496826172, 69.564437866210938 ], [ 18.944927215576172, 69.612564086914062 ], [ 19.772706985473633, 69.804847717285156 ], [ 19.533538818359375, 69.396652221679688 ], [ 19.683053970336914, 69.431938171386719 ], [ 19.828052520751953, 69.714431762695312 ], [ 20.311248779296875, 69.964019775390625 ], [ 20.420623779296875, 69.875541687011719 ], [ 20.281942367553711, 69.4788818359375 ], [ 19.946941375732422, 69.256103515625 ], [ 20.466386795043945, 69.573188781738281 ], [ 20.849025726318359, 69.492286682128906 ], [ 20.484928131103516, 69.631309509277344 ], [ 20.565830230712891, 69.761383056640625 ], [ 20.804996490478516, 69.805404663085938 ], [ 21.059444427490234, 69.94610595703125 ], [ 20.894580841064453, 69.851799011230469 ], [ 21.048332214355469, 69.789016723632812 ], [ 21.313331604003906, 70.020965576171875 ], [ 22.099580764770508, 69.743743896484375 ], [ 21.808401107788086, 70.040267944335938 ], [ 22.093330383300781, 70.108253479003906 ], [ 21.725414276123047, 70.0565185546875 ], [ 21.299999237060547, 70.246932983398438 ], [ 22.957498550415039, 70.20416259765625 ], [ 22.296665191650391, 70.041236877441406 ], [ 22.873054504394531, 70.102493286132812 ], [ 23.317636489868164, 69.942352294921875 ], [ 23.534719467163086, 70.019294738769531 ], [ 23.178747177124023, 70.091102600097656 ], [ 23.585552215576172, 70.38360595703125 ], [ 24.353399276733398, 70.457839965820312 ], [ 24.155277252197266, 70.56805419921875 ], [ 24.363052368164062, 70.6885986328125 ], [ 24.735067367553711, 70.63214111328125 ], [ 24.256385803222656, 70.770896911621094 ], [ 24.626247406005859, 70.776107788085938 ], [ 24.588470458984375, 70.960960388183594 ], [ 25.265274047851562, 70.812629699707031 ], [ 25.366109848022461, 70.969573974609375 ], [ 25.637775421142578, 70.891937255859375 ], [ 25.903331756591797, 70.888740539550781 ], [ 25.089859008789062, 70.506553649902344 ], [ 25.267635345458984, 70.395957946777344 ], [ 24.943052291870117, 70.091796875 ], [ 25.234722137451172, 70.0897216796875 ], [ 26.523330688476562, 70.925827026367188 ], [ 26.734443664550781, 70.896102905273438 ], [ 26.668052673339844, 70.718887329101562 ], [ 26.353193283081055, 70.639640808105469 ], [ 26.650623321533203, 70.636581420898438 ], [ 26.537220001220703, 70.34930419921875 ], [ 27.26603889465332, 70.581794738769531 ], [ 27.090692520141602, 70.705818176269531 ], [ 27.309164047241211, 70.818046569824219 ], [ 27.5655517578125, 70.804718017578125 ], [ 27.128747940063477, 70.916587829589844 ], [ 27.228330612182617, 71.021240234375 ], [ 28.207775115966797, 71.079986572265625 ], [ 28.533885955810547, 70.94110107421875 ], [ 27.771316528320312, 70.785896301269531 ], [ 28.119407653808594, 70.732803344726562 ], [ 27.657150268554688, 70.60638427734375 ], [ 28.287914276123047, 70.713462829589844 ], [ 27.854303359985352, 70.48193359375 ], [ 28.33027458190918, 70.502143859863281 ], [ 28.169166564941406, 70.38720703125 ], [ 28.038887023925781, 70.061935424804688 ], [ 28.543609619140625, 70.739166259765625 ], [ 28.853885650634766, 70.88055419921875 ], [ 29.250553131103516, 70.84283447265625 ], [ 29.346942901611328, 70.664154052734375 ], [ 30.108610153198242, 70.707351684570312 ], [ 30.341733932495117, 70.599708557128906 ], [ 30.008052825927734, 70.536445617675781 ], [ 30.597776412963867, 70.535194396972656 ], [ 31.073537826538086, 70.285545349121094 ], [ 30.094444274902344, 70.068603515625 ], [ 28.740137100219727, 70.177078247070312 ], [ 28.599094390869141, 70.160751342773438 ], [ 29.666248321533203, 69.964164733886719 ], [ 29.37159538269043, 69.857147216796875 ], [ 29.734859466552734, 69.907493591308594 ], [ 29.491941452026367, 69.660202026367188 ], [ 30.184026718139648, 69.690750122070312 ], [ 30.17249870300293, 69.875404357910156 ], [ 30.301387786865234, 69.879714965820312 ], [ 30.350690841674805, 69.667488098144531 ], [ 30.556941986083984, 69.8155517578125 ], [ 31.773887634277344, 69.68109130859375 ], [ 31.756942749023438, 69.846649169921875 ], [ 32.096786499023438, 69.792854309082031 ], [ 31.91523551940918, 69.923080444335938 ], [ 32.055824279785156, 69.959426879882812 ], [ 33.13043212890625, 69.72607421875 ], [ 32.894996643066406, 69.582763671875 ], [ 32.026393890380859, 69.63653564453125 ], [ 32.494556427001953, 69.505409240722656 ], [ 32.201766967773438, 69.428512573242188 ], [ 33.029415130615234, 69.47186279296875 ], [ 32.806049346923828, 69.302772521972656 ], [ 33.51617431640625, 69.422477722167969 ], [ 33.241519927978516, 69.269088745117188 ], [ 33.516658782958984, 69.181365966796875 ], [ 33.043327331542969, 69.070411682128906 ], [ 33.010597229003906, 68.9671630859375 ], [ 33.440547943115234, 69.103042602539062 ], [ 33.567771911621094, 69.183853149414062 ], [ 33.641380310058594, 69.325546264648438 ], [ 35.836654663085938, 69.198867797851562 ], [ 37.773323059082031, 68.67608642578125 ], [ 38.432769775390625, 68.339157104492188 ], [ 39.852630615234375, 68.044075012207031 ], [ 39.778049468994141, 68.163597106933594 ], [ 40.484298706054688, 67.748878479003906 ], [ 40.992218017578125, 67.716094970703125 ], [ 41.110687255859375, 67.250953674316406 ], [ 41.390827178955078, 67.119148254394531 ], [ 41.219711303710938, 66.8377685546875 ], [ 40.066658020019531, 66.276100158691406 ], [ 38.607772827148438, 66.052200317382812 ], [ 35.509132385253906, 66.387741088867188 ], [ 34.8458251953125, 66.60498046875 ], [ 34.479019165039062, 66.5323486328125 ], [ 33.598876953125, 66.823043823242188 ], [ 33.251388549804688, 66.79443359375 ], [ 32.667770385742188, 67.119430541992188 ], [ 31.858806610107422, 67.15283203125 ], [ 32.259441375732422, 67.122756958007812 ], [ 32.930824279785156, 66.736236572265625 ], [ 32.800895690917969, 66.726577758789062 ], [ 33.321872711181641, 66.640884399414062 ], [ 32.87103271484375, 66.580680847167969 ], [ 33.240131378173828, 66.616233825683594 ], [ 33.524921417236328, 66.527481079101562 ], [ 33.199199676513672, 66.564002990722656 ], [ 32.958427429199219, 66.530364990234375 ], [ 33.72186279296875, 66.4224853515625 ], [ 33.321517944335938, 66.3197021484375 ], [ 34.109718322753906, 66.249015808105469 ], [ 34.850131988525391, 65.898735046386719 ], [ 34.964717864990234, 65.721229553222656 ], [ 34.689159393310547, 65.801643371582031 ], [ 34.673049926757812, 65.447898864746094 ], [ 34.381244659423828, 65.382621765136719 ], [ 34.936103820800781, 64.83831787109375 ], [ 34.95721435546875, 64.65277099609375 ], [ 34.787773132324219, 64.547760009765625 ], [ 35.3248291015625, 64.326522827148438 ], [ 35.804161071777344, 64.342903137207031 ], [ 36.277908325195312, 64.143745422363281 ], [ 36.282493591308594, 64.009712219238281 ], [ 37.388740539550781, 63.803325653076172 ], [ 38.061935424804688, 64.004440307617188 ], [ 37.978874206542969, 64.316665649414062 ], [ 37.14471435546875, 64.40887451171875 ], [ 36.4395751953125, 64.937896728515625 ], [ 36.833049774169922, 64.991928100585938 ], [ 36.834159851074219, 65.157203674316406 ], [ 37.041656494140625, 65.20721435546875 ], [ 38.404365539550781, 64.854080200195312 ], [ 38.039230346679688, 64.759918212890625 ], [ 38.041385650634766, 64.643318176269531 ], [ 38.536659240722656, 64.798324584960938 ], [ 40.497215270996094, 64.535125732421875 ], [ 40.375961303710938, 64.923454284667969 ], [ 39.753883361816406, 65.342208862304688 ], [ 39.751388549804688, 65.550811767578125 ], [ 40.703323364257812, 65.968048095703125 ], [ 41.424995422363281, 66.089706420898438 ], [ 42.175132751464844, 66.524429321289062 ], [ 43.292915344238281, 66.424293518066406 ], [ 43.693878173828125, 66.231925964355469 ], [ 43.294368743896484, 66.090675354003906 ], [ 43.354713439941406, 66.038589477539062 ], [ 43.516246795654297, 65.975677490234375 ], [ 43.3851318359375, 66.072700500488281 ], [ 43.858047485351562, 66.176925659179688 ], [ 44.1744384765625, 65.87469482421875 ], [ 44.076385498046875, 66.200546264648438 ], [ 44.483047485351562, 66.674148559570312 ], [ 44.3614501953125, 66.783660888671875 ], [ 44.496383666992188, 66.907485961914062 ], [ 43.751800537109375, 67.311515808105469 ], [ 44.113883972167969, 67.706649780273438 ], [ 44.086517333984375, 67.876991271972656 ], [ 44.258190155029297, 67.9281005859375 ], [ 44.131587982177734, 67.928245544433594 ], [ 44.244922637939453, 68.264572143554688 ], [ 43.311660766601562, 68.684982299804688 ], [ 45.9033203125, 68.482208251953125 ], [ 46.527355194091797, 68.138175964355469 ], [ 46.711105346679688, 67.816787719726562 ], [ 45.382492065429688, 67.73553466796875 ], [ 44.912906646728516, 67.365676879882812 ], [ 45.578605651855469, 67.182205200195312 ], [ 46.03363037109375, 66.824897766113281 ], [ 46.587909698486328, 66.861373901367188 ], [ 46.381938934326172, 66.7410888671875 ], [ 47.699714660644531, 66.986373901367188 ], [ 47.682212829589844, 67.186370849609375 ], [ 47.951103210449219, 67.451927185058594 ], [ 47.814365386962891, 67.574295043945312 ], [ 48.001522064208984, 67.652351379394531 ], [ 49.097213745117188, 67.632621765136719 ], [ 48.595268249511719, 67.930465698242188 ], [ 49.226097106933594, 67.873870849609375 ], [ 50.768745422363281, 68.370536804199219 ], [ 52.074714660644531, 68.54443359375 ], [ 52.355552673339844, 68.477348327636719 ], [ 52.141242980957031, 68.382064819335938 ], [ 52.258739471435547, 68.306373596191406 ], [ 52.73040771484375, 68.459022521972656 ], [ 52.488044738769531, 68.585540771484375 ], [ 52.637977600097656, 68.642097473144531 ], [ 52.294857025146484, 68.616645812988281 ], [ 53.775550842285156, 68.966934204101562 ], [ 54.559158325195312, 68.995674133300781 ], [ 53.604366302490234, 68.908180236816406 ], [ 54.012630462646484, 68.857757568359375 ], [ 53.723461151123047, 68.632064819335938 ], [ 53.944293975830078, 68.401374816894531 ], [ 53.209156036376953, 68.26470947265625 ], [ 54.506523132324219, 68.305122375488281 ], [ 54.823326110839844, 68.167755126953125 ], [ 54.939712524414062, 68.399993896484375 ], [ 55.3326416015625, 68.551116943359375 ], [ 55.976799011230469, 68.659423828125 ], [ 57.276100158691406, 68.555816650390625 ], [ 58.184295654296875, 68.884994506835938 ], [ 58.345409393310547, 68.730125427246094 ], [ 58.421661376953125, 68.736648559570312 ], [ 58.276313781738281, 68.891860961914062 ], [ 58.898330688476562, 68.999710083007812 ], [ 59.221694946289062, 68.990638732910156 ], [ 58.901515960693359, 68.933525085449219 ], [ 59.427215576171875, 68.745254516601562 ], [ 59.061798095703125, 68.619842529296875 ], [ 59.072353363037109, 68.424568176269531 ], [ 59.842632293701172, 68.369430541992188 ], [ 59.968460083007812, 68.464286804199219 ], [ 59.811660766601562, 68.681930541992188 ], [ 60.914436340332031, 68.904708862304688 ], [ 60.89471435546875, 69.123313903808594 ], [ 60.602218627929688, 69.125808715820312 ], [ 60.145271301269531, 69.573112487792969 ], [ 60.931663513183594, 69.863037109375 ], [ 63.268882751464844, 69.68359375 ], [ 64.959152221679688, 69.319992065429688 ], [ 64.522216796875, 68.903045654296875 ], [ 65.348602294921875, 68.79193115234375 ], [ 65.65228271484375, 68.557273864746094 ], [ 65.27581787109375, 68.23553466796875 ], [ 65.284988403320312, 68.011932373046875 ], [ 66.07415771484375, 67.937484741210938 ], [ 66.021377563476562, 67.804359436035156 ], [ 66.198799133300781, 67.738456726074219 ], [ 65.828742980957031, 67.644157409667969 ], [ 66.108871459960938, 67.481231689453125 ], [ 65.223602294921875, 67.146102905273438 ], [ 65.11151123046875, 66.898391723632812 ], [ 63.408599853515625, 66.452774047851562 ], [ 63.226238250732422, 66.32916259765625 ], [ 63.301727294921875, 66.245468139648438 ], [ 62.853607177734375, 66.07110595703125 ], [ 62.849575042724609, 65.871017456054688 ], [ 61.840827941894531, 65.669288635253906 ], [ 60.627628326416016, 64.885406494140625 ], [ 60.152351379394531, 65.066238403320312 ], [ 59.650688171386719, 64.778045654296875 ], [ 59.483116149902344, 64.48797607421875 ], [ 59.843879699707031, 64.083053588867188 ], [ 59.577560424804688, 63.932868957519531 ], [ 59.225959777832031, 63.035549163818359 ], [ 59.484573364257812, 62.891033172607422 ], [ 59.397315979003906, 62.739158630371094 ], [ 59.642910003662109, 62.518390655517578 ], [ 59.405963897705078, 62.144996643066406 ], [ 59.421104431152344, 61.426521301269531 ], [ 59.256385803222656, 61.260826110839844 ], [ 59.473598480224609, 60.809574127197266 ], [ 58.982490539550781, 59.949996948242188 ], [ 58.447349548339844, 59.692493438720703 ], [ 58.310966491699219, 59.460407257080078 ], [ 59.182281494140625, 59.163673400878906 ], [ 59.083465576171875, 58.760276794433594 ], [ 59.385829925537109, 58.7056884765625 ], [ 59.449123382568359, 58.488044738769531 ], [ 58.677352905273438, 58.106002807617188 ], [ 58.600967407226562, 58.005687713623047 ], [ 58.856941223144531, 57.729988098144531 ], [ 58.532493591308594, 57.566940307617188 ], [ 58.198875427246094, 57.689155578613281 ], [ 57.971931457519531, 57.532215118408203 ], [ 58.070968627929688, 57.047496795654297 ], [ 57.221691131591797, 56.850963592529297 ], [ 57.416938781738281, 56.642494201660156 ], [ 57.321662902832031, 56.482765197753906 ], [ 57.466381072998047, 56.121932983398438 ], [ 59.292354583740234, 56.134090423583984 ], [ 59.174297332763672, 55.997768402099609 ], [ 59.159191131591797, 55.792911529541016 ], [ 59.31353759765625, 55.776451110839844 ], [ 59.237628936767578, 55.596656799316406 ], [ 59.641658782958984, 55.558670043945312 ], [ 58.579574584960938, 55.164020538330078 ], [ 58.810272216796875, 55.019718170166016 ], [ 58.529716491699219, 54.956100463867188 ], [ 58.30499267578125, 55.175407409667969 ], [ 57.998603820800781, 54.917770385742188 ], [ 58.139438629150391, 55.221240997314453 ], [ 57.433742523193359, 55.327217102050781 ], [ 57.209438323974609, 55.225543975830078 ], [ 57.160129547119141, 54.824440002441406 ], [ 57.970268249511719, 54.388187408447266 ], [ 59.247909545898438, 54.613254547119141 ], [ 59.638328552246094, 54.911727905273438 ], [ 59.936309814453125, 54.861591339111328 ], [ 59.676105499267578, 54.487075805664062 ], [ 59.736656188964844, 54.138046264648438 ], [ 59.334712982177734, 54.184852600097656 ], [ 58.921524047851562, 53.932907104492188 ], [ 58.824504852294922, 53.203945159912109 ], [ 59.027355194091797, 53.018051147460938 ], [ 58.748950958251953, 52.856246948242188 ], [ 58.789302825927734, 52.45068359375 ], [ 59.179851531982422, 52.277908325195312 ], [ 59.250274658203125, 52.498878479003906 ], [ 60.144157409667969, 52.423740386962891 ], [ 59.913806915283203, 52.100273132324219 ], [ 60.052009582519531, 51.883186340332031 ], [ 61.685821533203125, 51.265830993652344 ], [ 61.422351837158203, 50.800617218017578 ], [ 60.698043823242188, 50.661659240722656 ], [ 60.052909851074219, 50.864162445068359 ], [ 59.814403533935547, 50.546276092529297 ], [ 59.542495727539062, 50.478324890136719 ], [ 59.488742828369141, 50.630405426025391 ], [ 58.665542602539062, 50.80499267578125 ], [ 58.601387023925781, 51.046661376953125 ], [ 58.3377685546875, 51.156097412109375 ], [ 57.792682647705078, 51.116317749023438 ], [ 57.736103057861328, 50.910408020019531 ], [ 57.463535308837891, 50.865272521972656 ], [ 57.127353668212891, 51.084712982177734 ], [ 56.501865386962891, 51.080829620361328 ], [ 55.692489624023438, 50.532493591308594 ], [ 54.647216796875, 51.036941528320312 ], [ 54.548606872558594, 50.922218322753906 ], [ 54.701797485351562, 50.609645843505859 ], [ 54.523933410644531, 50.528839111328125 ], [ 54.398395538330078, 50.625892639160156 ], [ 54.501659393310547, 50.859230041503906 ], [ 53.423744201660156, 51.492633819580078 ], [ 52.607631683349609, 51.456382751464844 ], [ 52.341800689697266, 51.780754089355469 ], [ 51.871379852294922, 51.671798706054688 ], [ 51.711936950683594, 51.461936950683594 ], [ 51.2994384765625, 51.481239318847656 ], [ 51.384712219238281, 51.640548706054688 ], [ 50.773300170898438, 51.769180297851562 ], [ 50.812351226806641, 51.59429931640625 ], [ 50.600410461425781, 51.637771606445312 ], [ 50.368598937988281, 51.327423095703125 ], [ 49.474712371826172, 51.124019622802734 ], [ 49.425827026367188, 50.851387023925781 ], [ 48.697486877441406, 50.591934204101562 ], [ 48.833881378173828, 49.959159851074219 ], [ 48.248744964599609, 49.871379852294922 ], [ 47.599716186523438, 50.460823059082031 ], [ 47.319648742675781, 50.296104431152344 ], [ 47.302490234375, 50.031936645507812 ], [ 46.931381225585938, 49.865829467773438 ], [ 46.804019927978516, 49.338462829589844 ], [ 47.059574127197266, 49.133602142333984 ], [ 46.499160766601562, 48.417495727539062 ], [ 47.121238708496094, 48.272075653076172 ], [ 47.255828857421875, 47.750831604003906 ], [ 48.143039703369141, 47.749713897705078 ], [ 49.027206420898438, 46.776092529296875 ], [ 48.544574737548828, 46.754154205322266 ], [ 48.576171875, 46.561031341552734 ], [ 49.222526550292969, 46.346305847167969 ], [ 49.325145721435547, 46.086944580078125 ], [ 50.038501739501953, 45.858478546142578 ], [ 49.448314666748047, 45.530384063720703 ], [ 48.6861572265625, 44.754344940185547 ], [ 49.2109375, 43.471668243408203 ], [ 49.760623931884766, 42.710758209228516 ], [ 48.770950317382812, 42.04534912109375 ], [ 47.915470123291016, 41.224987030029297 ], [ 47.274646759033203, 41.321098327636719 ], [ 46.761726379394531, 41.8604736328125 ], [ 45.655124664306641, 42.199989318847656 ], [ 45.750827789306641, 42.487758636474609 ], [ 45.165122985839844, 42.703327178955078 ], [ 44.558048248291016, 42.759716033935547 ], [ 43.911933898925781, 42.583320617675781 ], [ 43.739662170410156, 42.649570465087891 ], [ 43.829154968261719, 42.749366760253906 ], [ 42.855197906494141, 43.177761077880859 ], [ 41.597484588623047, 43.221508026123047 ], [ 40.253387451171875, 43.58251953125 ], [ 39.945533752441406, 43.396934509277344 ], [ 38.753742218017578, 44.273319244384766 ], [ 38.197486877441406, 44.389434814453125 ], [ 37.7830810546875, 44.723354339599609 ], [ 37.484081268310547, 44.671443939208984 ], [ 37.202911376953125, 44.979778289794922 ], [ 36.625541687011719, 45.127346038818359 ], [ 36.962345123291016, 45.279022216796875 ], [ 36.669811248779297, 45.332557678222656 ], [ 36.827701568603516, 45.435680389404297 ], [ 37.110408782958984, 45.234428405761719 ], [ 37.734634399414062, 45.298812866210938 ], [ 37.59136962890625, 45.627479553222656 ], [ 37.927490234375, 46.01165771484375 ], [ 38.570854187011719, 46.091129302978516 ], [ 37.89776611328125, 46.407207489013672 ], [ 37.737483978271484, 46.667106628417969 ], [ 38.584949493408203, 46.657211303710938 ], [ 38.3839111328125, 46.711200714111328 ], [ 38.410331726074219, 46.826934814453125 ], [ 39.279571533203125, 47.0172119140625 ], [ 39.251518249511719, 47.26318359375 ], [ 37.5595703125, 47.086444854736328 ], [ 36.763877868652344, 46.7510986328125 ], [ 35.907203674316406, 46.651092529296875 ], [ 35.160610198974609, 46.128532409667969 ], [ 34.980121612548828, 46.086029052734375 ], [ 35.334297180175781, 46.321659088134766 ], [ 35.198043823242188, 46.443313598632812 ], [ 34.702491760253906, 46.175819396972656 ], [ 34.566383361816406, 45.9859619140625 ], [ 34.405193328857422, 46.012733459472656 ], [ 34.536895751953125, 46.184463500976562 ], [ 33.681640625, 46.221656799316406 ], [ 34.139434814453125, 45.94012451171875 ], [ 34.636516571044922, 45.937416076660156 ], [ 34.463394165039062, 45.769294738769531 ], [ 34.986648559570312, 45.631927490234375 ], [ 35.133041381835938, 45.324996948242188 ], [ 35.343040466308594, 45.332496643066406 ], [ 35.054294586181641, 45.609992980957031 ], [ 34.666206359863281, 46.086376190185547 ], [ 34.823646545410156, 46.072616577148438 ], [ 35.457904815673828, 45.298465728759766 ], [ 36.136238098144531, 45.458320617675781 ], [ 36.636795043945312, 45.377906799316406 ], [ 36.431102752685547, 45.271099090576172 ], [ 36.453460693359375, 45.077278137207031 ], [ 35.85693359375, 44.986381530761719 ], [ 35.526584625244141, 45.118457794189453 ], [ 35.082977294921875, 44.791240692138672 ], [ 34.518592834472656, 44.744430541992188 ], [ 33.930274963378906, 44.379150390625 ], [ 33.369052886962891, 44.584362030029297 ], [ 33.554435729980469, 44.623603820800781 ], [ 33.546241760253906, 45.108463287353516 ], [ 32.481098175048828, 45.394020080566406 ], [ 33.769397735595703, 45.925300598144531 ], [ 33.614017486572266, 46.142627716064453 ], [ 32.500408172607422, 46.076244354248047 ], [ 31.790134429931641, 46.284160614013672 ], [ 32.056720733642578, 46.391685485839844 ], [ 31.6583251953125, 46.47137451171875 ], [ 31.514509201049805, 46.579093933105469 ], [ 32.348045349121094, 46.459156036376953 ], [ 32.641620635986328, 46.642280578613281 ], [ 32.013603210449219, 46.634292602539062 ], [ 31.980823516845703, 47.007499694824219 ], [ 31.751522064208984, 47.252353668212891 ], [ 31.96502685546875, 46.925373077392578 ], [ 31.908187866210938, 46.653591156005859 ], [ 31.47773551940918, 46.631965637207031 ], [ 31.59568977355957, 46.797077178955078 ], [ 31.419717788696289, 46.625408172607422 ], [ 30.832771301269531, 46.548324584960938 ], [ 30.246242523193359, 45.87359619140625 ], [ 29.742631912231445, 45.624011993408203 ], [ 29.636104583740234, 45.820682525634766 ], [ 29.593048095703125, 45.557071685791016 ], [ 29.760412216186523, 45.322208404541016 ], [ 29.608325958251953, 44.845409393310547 ], [ 29.214160919189453, 44.793052673339844 ], [ 29.044437408447266, 45.003189086914062 ], [ 28.869194030761719, 44.940509796142578 ], [ 28.947355270385742, 44.826656341552734 ], [ 28.780828475952148, 44.660961151123047 ], [ 28.90186882019043, 44.706512451171875 ], [ 28.990861892700195, 44.685646057128906 ], [ 28.763050079345703, 44.625583648681641 ], [ 28.757499694824219, 44.519721984863281 ], [ 28.927772521972656, 44.61749267578125 ], [ 28.629579544067383, 44.296520233154297 ], [ 28.592494964599609, 43.503322601318359 ], [ 28.084854125976562, 43.357070922851562 ], [ 27.894094467163086, 42.703052520751953 ], [ 27.449579238891602, 42.472980499267578 ], [ 27.679164886474609, 42.418319702148438 ], [ 28.013053894042969, 41.982215881347656 ], [ 27.569580078125, 41.909263610839844 ], [ 27.233051300048828, 42.109992980957031 ], [ 26.381317138671875, 41.822002410888672 ], [ 26.635759353637695, 41.364715576171875 ], [ 26.324996948242188, 41.234710693359375 ], [ 26.36041259765625, 40.953880310058594 ], [ 26.090549468994141, 40.736106872558594 ], [ 25.141803741455078, 41.010337829589844 ], [ 23.722011566162109, 40.744647979736328 ], [ 23.88298225402832, 40.400272369384766 ], [ 24.175554275512695, 40.349857330322266 ], [ 24.394094467163086, 40.148017883300781 ], [ 23.729721069335938, 40.351249694824219 ], [ 23.98853874206543, 39.952632904052734 ], [ 23.401039123535156, 40.279857635498047 ], [ 23.368053436279297, 40.143882751464844 ], [ 23.746664047241211, 39.925273895263672 ], [ 23.379444122314453, 39.992774963378906 ], [ 23.294582366943359, 40.235832214355469 ], [ 22.899440765380859, 40.396659851074219 ], [ 22.901454925537109, 40.644439697265625 ], [ 22.585206985473633, 40.464996337890625 ], [ 22.594997406005859, 40.012214660644531 ], [ 23.343677520751953, 39.181800842285156 ], [ 23.206108093261719, 39.105270385742188 ], [ 23.054859161376953, 39.097911834716797 ], [ 23.221525192260742, 39.182289123535156 ], [ 22.940830230712891, 39.359367370605469 ], [ 22.8236083984375, 39.21221923828125 ], [ 23.072776794433594, 39.036941528320312 ], [ 22.52385139465332, 38.866069793701172 ], [ 23.960552215576172, 38.281661987304688 ], [ 24.089998245239258, 37.776664733886719 ], [ 23.947637557983398, 37.671939849853516 ], [ 23.575136184692383, 38.042911529541016 ], [ 23.018886566162109, 37.919715881347656 ], [ 23.165901184082031, 37.614994049072266 ], [ 23.521387100219727, 37.459995269775391 ], [ 23.179719924926758, 37.290412902832031 ], [ 23.128887176513672, 37.448051452636719 ], [ 22.725551605224609, 37.563400268554688 ], [ 23.201454162597656, 36.440200805664062 ], [ 22.632497787475586, 36.803607940673828 ], [ 22.488887786865234, 36.3861083984375 ], [ 22.152463912963867, 37.018535614013672 ], [ 21.945552825927734, 36.992637634277344 ], [ 21.87513542175293, 36.723537445068359 ], [ 21.703607559204102, 36.816665649414062 ], [ 21.565343856811523, 37.155063629150391 ], [ 21.659721374511719, 37.423881530761719 ], [ 21.131038665771484, 37.937080383300781 ], [ 21.384441375732422, 38.211387634277344 ], [ 21.641666412353516, 38.158882141113281 ], [ 21.853609085083008, 38.339580535888672 ], [ 22.862775802612305, 37.939579010009766 ], [ 23.224649429321289, 38.153396606445312 ], [ 22.408609390258789, 38.446037292480469 ], [ 22.374303817749023, 38.334575653076172 ], [ 21.108747482299805, 38.355552673339844 ], [ 20.987913131713867, 38.671108245849609 ], [ 20.73277473449707, 38.804439544677734 ], [ 20.781108856201172, 38.931663513183594 ], [ 21.085136413574219, 38.864025115966797 ], [ 21.144304275512695, 39.008743286132812 ], [ 20.820831298828125, 39.113605499267578 ], [ 20.733331680297852, 38.953395843505859 ], [ 19.985414505004883, 39.694751739501953 ], [ 19.857290267944336, 40.043468475341797 ], [ 19.289789199829102, 40.421451568603516 ], [ 19.479442596435547, 40.3548583984375 ], [ 19.307209014892578, 40.645309448242188 ], [ 19.521663665771484, 40.909854888916016 ], [ 19.442497253417969, 41.406944274902344 ], [ 19.597705841064453, 41.806106567382812 ], [ 19.176109313964844, 41.931522369384766 ], [ 18.553539276123047, 42.427219390869141 ], [ 18.678609848022461, 42.460552215576172 ], [ 18.508052825927734, 42.453884124755859 ], [ 18.516942977905273, 42.399993896484375 ], [ 17.877220153808594, 42.767776489257812 ], [ 17.012359619140625, 43.006244659423828 ], [ 17.657358169555664, 42.880828857421875 ], [ 16.881664276123047, 43.403606414794922 ], [ 15.988332748413086, 43.504440307617188 ], [ 15.940832138061523, 43.683609008789062 ], [ 15.151666641235352, 44.196388244628906 ], [ 15.522290229797363, 44.263256072998047 ], [ 14.990554809570312, 44.579437255859375 ], [ 14.831526756286621, 45.115413665771484 ], [ 14.482776641845703, 45.311103820800781 ], [ 14.323054313659668, 45.350967407226562 ], [ 13.904443740844727, 44.772563934326172 ], [ 13.504790306091309, 45.502010345458984 ], [ 13.798054695129395, 45.607494354248047 ], [ 13.629999160766602, 45.769996643066406 ], [ 13.120901107788086, 45.767841339111328 ], [ 13.087777137756348, 45.636524200439453 ], [ 12.287081718444824, 45.47332763671875 ], [ 12.161109924316406, 45.263885498046875 ], [ 12.538053512573242, 44.960617065429688 ], [ 12.247637748718262, 44.723884582519531 ], [ 12.368331909179688, 44.246665954589844 ], [ 13.599443435668945, 43.569999694824219 ], [ 14.13055419921875, 42.541107177734375 ], [ 15.099164962768555, 41.937217712402344 ], [ 16.145553588867188, 41.911174774169922 ], [ 16.192775726318359, 41.789993286132812 ], [ 15.897638320922852, 41.613330841064453 ], [ 15.984999656677246, 41.439716339111328 ], [ 18.012638092041016, 40.643051147460938 ], [ 18.514442443847656, 40.102912902832031 ], [ 18.349441528320312, 39.791938781738281 ], [ 18.040761947631836, 39.937705993652344 ], [ 17.857219696044922, 40.284439086914062 ], [ 17.076595306396484, 40.520481109619141 ], [ 16.863796234130859, 40.390350341796875 ] ] ], [ [ [ 24.768886566162109, 71.022216796875 ], [ 24.667774200439453, 71.04388427734375 ], [ 24.639997482299805, 71.058326721191406 ], [ 24.851110458374023, 71.091644287109375 ], [ 24.768886566162109, 71.022216796875 ] ] ], [ [ [ 24.046108245849609, 70.9083251953125 ], [ 23.880138397216797, 70.990829467773438 ], [ 24.243888854980469, 70.951934814453125 ], [ 24.167774200439453, 70.925827026367188 ], [ 24.046108245849609, 70.9083251953125 ] ] ], [ [ [ 22.163887023925781, 70.463607788085938 ], [ 22.263401031494141, 70.593170166015625 ], [ 21.956802368164062, 70.654998779296875 ], [ 23.451663970947266, 70.783599853515625 ], [ 23.088886260986328, 70.581100463867188 ], [ 22.163887023925781, 70.463607788085938 ] ] ], [ [ [ 23.839996337890625, 70.511383056640625 ], [ 23.633468627929688, 70.693466186523438 ], [ 24.12388801574707, 70.617630004882812 ], [ 23.952774047851562, 70.522491455078125 ], [ 23.839996337890625, 70.511383056640625 ] ] ], [ [ [ 23.156387329101562, 70.274429321289062 ], [ 22.851108551025391, 70.40582275390625 ], [ 23.403331756591797, 70.621658325195312 ], [ 23.653053283691406, 70.501388549804688 ], [ 23.156387329101562, 70.274429321289062 ] ] ], [ [ [ 57.056938171386719, 70.500457763671875 ], [ 56.915824890136719, 70.537765502929688 ], [ 56.843185424804688, 70.595954895019531 ], [ 57.224575042724609, 70.523597717285156 ], [ 57.056938171386719, 70.500457763671875 ] ] ], [ [ [ 59.911933898925781, 69.6663818359375 ], [ 59.431102752685547, 69.883453369140625 ], [ 58.950199127197266, 69.937339782714844 ], [ 59.118392944335938, 69.870437622070312 ], [ 59.017768859863281, 69.853866577148438 ], [ 58.409156799316406, 70.253608703613281 ], [ 58.823047637939453, 70.215827941894531 ], [ 58.631660461425781, 70.325820922851562 ], [ 59.034786224365234, 70.474212646484375 ], [ 60.546939849853516, 69.802482604980469 ], [ 59.911933898925781, 69.6663818359375 ] ] ], [ [ [ 22.976108551025391, 70.245819091796875 ], [ 22.573329925537109, 70.2691650390625 ], [ 22.370553970336914, 70.332077026367188 ], [ 22.684442520141602, 70.388740539550781 ], [ 22.976108551025391, 70.245819091796875 ] ] ], [ [ [ 21.750274658203125, 70.260269165039062 ], [ 21.691108703613281, 70.298324584960938 ], [ 21.702081680297852, 70.384300231933594 ], [ 21.841388702392578, 70.350265502929688 ], [ 21.750274658203125, 70.260269165039062 ] ] ], [ [ [ 19.932220458984375, 70.052490234375 ], [ 19.769996643066406, 70.065277099609375 ], [ 19.535970687866211, 70.24554443359375 ], [ 20.119720458984375, 70.1180419921875 ], [ 19.932220458984375, 70.052490234375 ] ] ], [ [ [ 19.141387939453125, 70.119430541992188 ], [ 19.038608551025391, 70.162971496582031 ], [ 19.248054504394531, 70.246109008789062 ], [ 19.23527717590332, 70.136520385742188 ], [ 19.141387939453125, 70.119430541992188 ] ] ], [ [ [ 20.609443664550781, 70.042221069335938 ], [ 20.406944274902344, 70.158599853515625 ], [ 20.832220077514648, 70.1966552734375 ], [ 20.794719696044922, 70.059707641601562 ], [ 20.609443664550781, 70.042221069335938 ] ] ], [ [ [ 19.5816650390625, 70.098052978515625 ], [ 19.501941680908203, 70.102218627929688 ], [ 19.352081298828125, 70.129020690917969 ], [ 19.431388854980469, 70.177764892578125 ], [ 19.5816650390625, 70.098052978515625 ] ] ], [ [ [ 18.708610534667969, 69.990264892578125 ], [ 18.712360382080078, 70.128189086914062 ], [ 19.000415802001953, 70.086517333984375 ], [ 18.970554351806641, 70.057220458984375 ], [ 18.708610534667969, 69.990264892578125 ] ] ], [ [ [ 19.134998321533203, 69.789443969726562 ], [ 18.723052978515625, 69.941169738769531 ], [ 19.219165802001953, 70.09637451171875 ], [ 19.690832138061523, 69.997215270996094 ], [ 19.134998321533203, 69.789443969726562 ] ] ], [ [ [ 20.872219085693359, 69.935546875 ], [ 20.759580612182617, 69.998878479003906 ], [ 21.100275039672852, 70.007072448730469 ], [ 20.952774047851562, 69.945541381835938 ], [ 20.872219085693359, 69.935546875 ] ] ], [ [ [ 19.473888397216797, 69.8397216796875 ], [ 19.798053741455078, 70.00054931640625 ], [ 19.895483016967773, 69.965408325195312 ], [ 19.772499084472656, 69.864715576171875 ], [ 19.473888397216797, 69.8397216796875 ] ] ], [ [ [ 29.793331146240234, 69.754440307617188 ], [ 29.841941833496094, 69.910263061523438 ], [ 30.048053741455078, 69.827499389648438 ], [ 30.042499542236328, 69.808319091796875 ], [ 29.793331146240234, 69.754440307617188 ] ] ], [ [ [ 20.604442596435547, 69.796096801757812 ], [ 20.589998245239258, 69.890823364257812 ], [ 20.737844467163086, 69.903533935546875 ], [ 20.732219696044922, 69.820274353027344 ], [ 20.604442596435547, 69.796096801757812 ] ] ], [ [ [ 18.314495086669922, 69.703384399414062 ], [ 18.755832672119141, 69.684852600097656 ], [ 18.69305419921875, 69.884429931640625 ], [ 19.064720153808594, 69.768875122070312 ], [ 18.794166564941406, 69.67193603515625 ], [ 18.738330841064453, 69.557769775390625 ], [ 17.999790191650391, 69.590408325195312 ], [ 18.314495086669922, 69.703384399414062 ] ] ], [ [ [ 18.920808792114258, 69.623870849609375 ], [ 18.933750152587891, 69.685981750488281 ], [ 19.025882720947266, 69.707206726074219 ], [ 18.95600700378418, 69.639915466308594 ], [ 18.920808792114258, 69.623870849609375 ] ] ], [ [ [ 17.045555114746094, 69.003326416015625 ], [ 17.135831832885742, 69.072494506835938 ], [ 16.774026870727539, 69.06707763671875 ], [ 17.169441223144531, 69.196525573730469 ], [ 16.875831604003906, 69.22137451171875 ], [ 17.142776489257812, 69.249435424804688 ], [ 16.875415802001953, 69.358192443847656 ], [ 17.49083137512207, 69.424301147460938 ], [ 17.2611083984375, 69.444442749023438 ], [ 17.196662902832031, 69.5 ], [ 17.844165802001953, 69.589157104492188 ], [ 18.085136413574219, 69.41888427734375 ], [ 17.875831604003906, 69.239715576171875 ], [ 17.999164581298828, 69.188186645507812 ], [ 17.045555114746094, 69.003326416015625 ] ] ], [ [ [ 48.232101440429688, 69.084091186523438 ], [ 48.41387939453125, 69.347763061523438 ], [ 49.009017944335938, 69.509712219238281 ], [ 50.329437255859375, 69.124488830566406 ], [ 48.785408020019531, 68.723037719726562 ], [ 48.218879699707031, 68.8902587890625 ], [ 48.232101440429688, 69.084091186523438 ] ] ], [ [ [ 34.213371276855469, 69.402725219726562 ], [ 34.404918670654297, 69.343803405761719 ], [ 33.975822448730469, 69.362899780273438 ], [ 34.043327331542969, 69.395263671875 ], [ 34.213371276855469, 69.402725219726562 ] ] ], [ [ [ 59.248954772949219, 69.137298583984375 ], [ 59.045272827148438, 69.247756958007812 ], [ 58.763328552246094, 69.336654663085938 ], [ 59.1966552734375, 69.23095703125 ], [ 59.248954772949219, 69.137298583984375 ] ] ], [ [ [ 15.468053817749023, 68.874160766601562 ], [ 15.56444263458252, 69.096794128417969 ], [ 16.148052215576172, 69.286376953125 ], [ 16.085136413574219, 69.1552734375 ], [ 15.468053817749023, 68.874160766601562 ] ] ], [ [ [ 17.372776031494141, 68.984710693359375 ], [ 17.414581298828125, 69.073600769042969 ], [ 17.562637329101562, 69.092353820800781 ], [ 17.526388168334961, 69.04998779296875 ], [ 17.372776031494141, 68.984710693359375 ] ] ], [ [ [ 14.501110076904297, 68.601943969726562 ], [ 14.373610496520996, 68.686660766601562 ], [ 14.529443740844727, 68.80499267578125 ], [ 15.15180492401123, 68.814712524414062 ], [ 15.044721603393555, 68.996383666992188 ], [ 15.379026412963867, 68.847358703613281 ], [ 15.397637367248535, 68.680137634277344 ], [ 15.070276260375977, 68.575271606445312 ], [ 14.80402660369873, 68.615264892578125 ], [ 15.149999618530273, 68.749160766601562 ], [ 14.501110076904297, 68.601943969726562 ] ] ], [ [ [ 16.521385192871094, 68.879440307617188 ], [ 16.376110076904297, 68.906661987304688 ], [ 16.263053894042969, 68.969993591308594 ], [ 16.598054885864258, 68.947624206542969 ], [ 16.521385192871094, 68.879440307617188 ] ] ], [ [ [ 16.501144409179688, 68.552459716796875 ], [ 16.221942901611328, 68.547210693359375 ], [ 15.911109924316406, 68.364166259765625 ], [ 15.331387519836426, 68.328193664550781 ], [ 15.589166641235352, 68.47833251953125 ], [ 15.54145622253418, 68.50360107421875 ], [ 14.986665725708008, 68.24749755859375 ], [ 15.449027061462402, 68.727073669433594 ], [ 15.71360969543457, 68.6986083984375 ], [ 15.453193664550781, 68.759574890136719 ], [ 15.658609390258789, 68.95220947265625 ], [ 15.908756256103516, 68.956695556640625 ], [ 15.987776756286621, 68.754714965820312 ], [ 15.764304161071777, 68.618186950683594 ], [ 15.742499351501465, 68.529159545898438 ], [ 16.204166412353516, 68.855270385742188 ], [ 16.544441223144531, 68.76416015625 ], [ 16.501144409179688, 68.552459716796875 ] ] ], [ [ [ 17.241664886474609, 68.788604736328125 ], [ 17.087221145629883, 68.912765502929688 ], [ 17.43610954284668, 68.862625122070312 ], [ 17.308330535888672, 68.80499267578125 ], [ 17.241664886474609, 68.788604736328125 ] ] ], [ [ [ 16.825275421142578, 68.719711303710938 ], [ 16.987777709960938, 68.852767944335938 ], [ 17.144651412963867, 68.768463134765625 ], [ 17.09527587890625, 68.746383666992188 ], [ 16.825275421142578, 68.719711303710938 ] ] ], [ [ [ 57.287200927734375, 68.754806518554688 ], [ 57.890830993652344, 68.8116455078125 ], [ 57.920829772949219, 68.803314208984375 ], [ 57.199996948242188, 68.720954895019531 ], [ 57.287200927734375, 68.754806518554688 ] ] ], [ [ [ 16.121109008789062, 68.376388549804688 ], [ 16.234996795654297, 68.523040771484375 ], [ 16.464580535888672, 68.465408325195312 ], [ 16.405551910400391, 68.411102294921875 ], [ 16.121109008789062, 68.376388549804688 ] ] ], [ [ [ 50.83673095703125, 68.409011840820312 ], [ 51.16387939453125, 68.495254516601562 ], [ 51.456657409667969, 68.4769287109375 ], [ 50.796798706054688, 68.375396728515625 ], [ 50.83673095703125, 68.409011840820312 ] ] ], [ [ [ 14.205831527709961, 68.149154663085938 ], [ 14.542221069335938, 68.400833129882812 ], [ 15.168888092041016, 68.450546264648438 ], [ 14.813055038452148, 68.2691650390625 ], [ 14.205831527709961, 68.149154663085938 ] ] ], [ [ [ 14.188331604003906, 68.238601684570312 ], [ 14.052359580993652, 68.289299011230469 ], [ 14.049027442932129, 68.300270080566406 ], [ 14.229166030883789, 68.293045043945312 ], [ 14.188331604003906, 68.238601684570312 ] ] ], [ [ [ 13.521110534667969, 68.039443969726562 ], [ 13.568193435668945, 68.262626647949219 ], [ 14.135415077209473, 68.236244201660156 ], [ 13.835554122924805, 68.104721069335938 ], [ 13.521110534667969, 68.039443969726562 ] ] ], [ [ [ 13.239166259765625, 67.985275268554688 ], [ 13.295415878295898, 68.147491455078125 ], [ 13.437359809875488, 68.115692138671875 ], [ 13.382499694824219, 68.028610229492188 ], [ 13.239166259765625, 67.985275268554688 ] ] ], [ [ [ 12.797222137451172, 67.806930541992188 ], [ 13.054721832275391, 68.101943969726562 ], [ 13.151665687561035, 68.082489013671875 ], [ 13.135831832885742, 67.955825805664062 ], [ 12.797222137451172, 67.806930541992188 ] ] ], [ [ [ 15.613887786865234, 67.975555419921875 ], [ 15.502636909484863, 67.989509582519531 ], [ 15.921804428100586, 67.989013671875 ], [ 15.862220764160156, 67.975830078125 ], [ 15.613887786865234, 67.975555419921875 ] ] ], [ [ [ 15.143610000610352, 67.898330688476562 ], [ 14.960832595825195, 67.90777587890625 ], [ 14.934860229492188, 67.925468444824219 ], [ 15.30111026763916, 67.919021606445312 ], [ 15.143610000610352, 67.898330688476562 ] ] ], [ [ [ 14.164443969726562, 66.997772216796875 ], [ 14.125971794128418, 67.049430847167969 ], [ 13.994165420532227, 67.081100463867188 ], [ 14.257776260375977, 67.133041381835938 ], [ 14.164443969726562, 66.997772216796875 ] ] ], [ [ [ 42.5406494140625, 66.790390014648438 ], [ 42.661659240722656, 66.769149780273438 ], [ 42.715545654296875, 66.6927490234375 ], [ 42.433742523193359, 66.76263427734375 ], [ 42.5406494140625, 66.790390014648438 ] ] ], [ [ [ -13.499444961547852, 65.06915283203125 ], [ -13.988056182861328, 65.063888549804688 ], [ -13.700417518615723, 64.920402526855469 ], [ -14.051251411437988, 64.932212829589844 ], [ -13.769722938537598, 64.866302490234375 ], [ -14.018056869506836, 64.723602294921875 ], [ -14.512223243713379, 64.796516418457031 ], [ -14.365944862365723, 64.674102783203125 ], [ -14.584722518920898, 64.584991455078125 ], [ -14.462486267089844, 64.5423583984375 ], [ -14.541251182556152, 64.404708862304688 ], [ -14.92500114440918, 64.26416015625 ], [ -15.386806488037109, 64.370132446289062 ], [ -16.488613128662109, 63.895828247070312 ], [ -17.872085571289062, 63.730690002441406 ], [ -17.930835723876953, 63.529579162597656 ], [ -18.775001525878906, 63.391387939453125 ], [ -20.196945190429688, 63.542495727539062 ], [ -20.541168212890625, 63.707107543945312 ], [ -20.361946105957031, 63.761665344238281 ], [ -21.169723510742188, 63.95416259765625 ], [ -22.686250686645508, 63.804576873779297 ], [ -22.700418472290039, 64.081939697265625 ], [ -22.045558929443359, 64.046661376953125 ], [ -21.702085494995117, 64.182769775390625 ], [ -21.875974655151367, 64.232902526855469 ], [ -21.759166717529297, 64.34027099609375 ], [ -21.36277961730957, 64.384986877441406 ], [ -22.099237442016602, 64.312347412109375 ], [ -21.978889465332031, 64.500823974609375 ], [ -21.513057708740234, 64.644088745117188 ], [ -22.177780151367188, 64.455551147460938 ], [ -22.407222747802734, 64.812484741210938 ], [ -23.835973739624023, 64.725967407226562 ], [ -24.059532165527344, 64.890884399414062 ], [ -21.835834503173828, 65.0302734375 ], [ -21.736459732055664, 65.197212219238281 ], [ -22.560140609741211, 65.168388366699219 ], [ -21.698612213134766, 65.44915771484375 ], [ -22.334806442260742, 65.483169555664062 ], [ -22.159168243408203, 65.541656494140625 ], [ -22.122364044189453, 65.593879699707031 ], [ -23.879447937011719, 65.402496337890625 ], [ -24.53840446472168, 65.500274658203125 ], [ -24.32194709777832, 65.636802673339844 ], [ -23.807432174682617, 65.530960083007812 ], [ -24.069585800170898, 65.630683898925781 ], [ -23.805904388427734, 65.609024047851562 ], [ -24.10521125793457, 65.805686950683594 ], [ -23.527225494384766, 65.627777099609375 ], [ -23.229446411132812, 65.740547180175781 ], [ -23.873334884643555, 65.868736267089844 ], [ -23.216182708740234, 65.840133666992188 ], [ -23.818334579467773, 66.014427185058594 ], [ -23.374446868896484, 65.986518859863281 ], [ -23.666112899780273, 66.112907409667969 ], [ -23.468751907348633, 66.199714660644531 ], [ -22.677780151367188, 66.044998168945312 ], [ -22.64958381652832, 65.826522827148438 ], [ -22.499725341796875, 65.966110229492188 ], [ -22.424724578857422, 65.847488403320312 ], [ -22.5, 66.07696533203125 ], [ -22.972225189208984, 66.22137451171875 ], [ -22.434169769287109, 66.267776489257812 ], [ -23.189308166503906, 66.351524353027344 ], [ -22.941806793212891, 66.465690612792969 ], [ -22.421669006347656, 66.433319091796875 ], [ -21.651390075683594, 66.018875122070312 ], [ -21.399444580078125, 66.0272216796875 ], [ -21.599237442016602, 65.953117370605469 ], [ -21.285140991210938, 65.920616149902344 ], [ -21.339723587036133, 65.732902526855469 ], [ -21.775001525878906, 65.76470947265625 ], [ -21.308891296386719, 65.596939086914062 ], [ -21.084445953369141, 65.159164428710938 ], [ -21.09222412109375, 65.453742980957031 ], [ -20.927223205566406, 65.588882446289062 ], [ -20.664169311523438, 65.690826416015625 ], [ -20.474445343017578, 65.487777709960938 ], [ -20.325557708740234, 65.62860107421875 ], [ -20.422639846801758, 66.084442138671875 ], [ -20.092639923095703, 66.123184204101562 ], [ -19.456111907958984, 65.725692749023438 ], [ -19.454444885253906, 66.054718017578125 ], [ -18.787778854370117, 66.191932678222656 ], [ -18.069446563720703, 65.643325805664062 ], [ -18.295141220092773, 66.175270080566406 ], [ -17.609169006347656, 65.98748779296875 ], [ -17.131111145019531, 66.210540771484375 ], [ -16.594722747802734, 66.091110229492188 ], [ -16.68708610534668, 66.160964965820312 ], [ -16.417362213134766, 66.276031494140625 ], [ -16.565280914306641, 66.493606567382812 ], [ -16.025419235229492, 66.536102294921875 ], [ -15.374305725097656, 66.145271301269531 ], [ -14.943611145019531, 66.378875732421875 ], [ -14.710835456848145, 66.367218017578125 ], [ -15.176250457763672, 66.113670349121094 ], [ -14.618890762329102, 65.994430541992188 ], [ -14.848333358764648, 65.73138427734375 ], [ -14.338473320007324, 65.784576416015625 ], [ -14.558334350585938, 65.499229431152344 ], [ -14.288056373596191, 65.656242370605469 ], [ -13.680557250976562, 65.548049926757812 ], [ -13.735694885253906, 65.317352294921875 ], [ -13.570138931274414, 65.261306762695312 ], [ -14.030279159545898, 65.193466186523438 ], [ -13.499444961547852, 65.06915283203125 ] ] ], [ [ [ 12.300277709960938, 66.010269165039062 ], [ 12.563331604003906, 66.2177734375 ], [ 12.655832290649414, 66.101387023925781 ], [ 12.531944274902344, 66.054718017578125 ], [ 12.300277709960938, 66.010269165039062 ] ] ], [ [ [ 12.438610076904297, 65.864166259765625 ], [ 12.53416633605957, 65.999710083007812 ], [ 12.898679733276367, 66.0111083984375 ], [ 12.674720764160156, 65.9547119140625 ], [ 12.438610076904297, 65.864166259765625 ] ] ], [ [ [ 11.900554656982422, 65.583053588867188 ], [ 11.761178970336914, 65.613189697265625 ], [ 11.997220993041992, 65.696662902832031 ], [ 11.974164962768555, 65.626937866210938 ], [ 11.900554656982422, 65.583053588867188 ] ] ], [ [ [ 12.063055038452148, 65.209991455078125 ], [ 12.258054733276367, 65.57611083984375 ], [ 12.502777099609375, 65.391937255859375 ], [ 12.188055038452148, 65.24554443359375 ], [ 12.063055038452148, 65.209991455078125 ] ] ], [ [ [ 12.129720687866211, 65.050277709960938 ], [ 11.984443664550781, 65.074851989746094 ], [ 12.183610916137695, 65.208328247070312 ], [ 12.313679695129395, 65.102973937988281 ], [ 12.129720687866211, 65.050277709960938 ] ] ], [ [ [ 35.812187194824219, 65.180557250976562 ], [ 35.749160766601562, 64.964996337890625 ], [ 35.521369934082031, 65.145828247070312 ], [ 35.565818786621094, 65.1785888671875 ], [ 35.812187194824219, 65.180557250976562 ] ] ], [ [ [ 25.0, 65.025848388671875 ], [ 24.722774505615234, 64.94415283203125 ], [ 24.551666259765625, 65.024993896484375 ], [ 24.833610534667969, 65.078598022460938 ], [ 25.0, 65.025848388671875 ] ] ], [ [ [ 10.739721298217773, 64.849441528320312 ], [ 10.777776718139648, 64.91888427734375 ], [ 11.113332748413086, 64.968460083007812 ], [ 10.815553665161133, 64.863601684570312 ], [ 10.739721298217773, 64.849441528320312 ] ] ], [ [ [ 11.128887176513672, 64.829437255859375 ], [ 10.951387405395508, 64.869720458984375 ], [ 10.824859619140625, 64.847488403320312 ], [ 11.110971450805664, 64.949989318847656 ], [ 11.263401985168457, 64.887771606445312 ], [ 11.128887176513672, 64.829437255859375 ] ] ], [ [ [ 40.348548889160156, 64.758316040039062 ], [ 40.47137451171875, 64.566085815429688 ], [ 39.976238250732422, 64.679420471191406 ], [ 40.274993896484375, 64.641937255859375 ], [ 40.148117065429688, 64.74859619140625 ], [ 40.348548889160156, 64.758316040039062 ] ] ], [ [ [ 11.418054580688477, 64.471939086914062 ], [ 11.175554275512695, 64.506942749023438 ], [ 11.040971755981445, 64.631515502929688 ], [ 11.452498435974121, 64.518463134765625 ], [ 11.418054580688477, 64.471939086914062 ] ] ], [ [ [ 22.868331909179688, 63.770553588867188 ], [ 22.7066650390625, 63.775276184082031 ], [ 22.673887252807617, 63.791728973388672 ], [ 22.88055419921875, 63.872772216796875 ], [ 22.868331909179688, 63.770553588867188 ] ] ], [ [ [ 8.319442749023438, 63.660270690917969 ], [ 8.79777717590332, 63.812774658203125 ], [ 8.827637672424316, 63.725551605224609 ], [ 8.752222061157227, 63.689437866210938 ], [ 8.319442749023438, 63.660270690917969 ] ] ], [ [ [ 8.455276489257812, 63.426383972167969 ], [ 8.279998779296875, 63.4647216796875 ], [ 8.944721221923828, 63.653884887695312 ], [ 9.174860000610352, 63.561664581298828 ], [ 8.455276489257812, 63.426383972167969 ] ] ], [ [ [ 7.98527717590332, 63.308883666992188 ], [ 7.98277759552002, 63.347496032714844 ], [ 7.779443740844727, 63.408191680908203 ], [ 8.183610916137695, 63.3861083984375 ], [ 7.98527717590332, 63.308883666992188 ] ] ], [ [ [ 8.562776565551758, 63.319160461425781 ], [ 8.470832824707031, 63.321388244628906 ], [ 8.435345649719238, 63.333816528320312 ], [ 8.672707557678223, 63.350273132324219 ], [ 8.562776565551758, 63.319160461425781 ] ] ], [ [ [ 8.391109466552734, 63.159164428710938 ], [ 8.269165992736816, 63.263328552246094 ], [ 8.57541561126709, 63.185966491699219 ], [ 8.523611068725586, 63.163887023925781 ], [ 8.391109466552734, 63.159164428710938 ] ] ], [ [ [ 21.246944427490234, 63.144721984863281 ], [ 21.148193359375, 63.176383972167969 ], [ 21.080484390258789, 63.277290344238281 ], [ 21.415969848632812, 63.249164581298828 ], [ 21.246944427490234, 63.144721984863281 ] ] ], [ [ [ 8.005277633666992, 63.140830993652344 ], [ 8.073610305786133, 63.235275268554688 ], [ 8.185971260070801, 63.155414581298828 ], [ 8.136110305786133, 63.146659851074219 ], [ 8.005277633666992, 63.140830993652344 ] ] ], [ [ [ 7.778332710266113, 63.017494201660156 ], [ 7.679444313049316, 63.056106567382812 ], [ 7.914721965789795, 63.076385498046875 ], [ 7.88861083984375, 63.048881530761719 ], [ 7.778332710266113, 63.017494201660156 ] ] ], [ [ [ 7.51027774810791, 62.938606262207031 ], [ 7.399166107177734, 63.0574951171875 ], [ 7.710138320922852, 63.000411987304688 ], [ 7.548333168029785, 62.948326110839844 ], [ 7.51027774810791, 62.938606262207031 ] ] ], [ [ [ 6.677777290344238, 62.653610229492188 ], [ 6.689582824707031, 62.730274200439453 ], [ 6.91986083984375, 62.705966949462891 ], [ 6.892777442932129, 62.689163208007812 ], [ 6.677777290344238, 62.653610229492188 ] ] ], [ [ [ 17.484722137451172, 62.363052368164062 ], [ 17.416109085083008, 62.377983093261719 ], [ 17.370761871337891, 62.4718017578125 ], [ 17.46763801574707, 62.459995269775391 ], [ 17.484722137451172, 62.363052368164062 ] ] ], [ [ [ 6.22833251953125, 62.390274047851562 ], [ 6.096388816833496, 62.393882751464844 ], [ 6.025138378143311, 62.433052062988281 ], [ 6.330346584320068, 62.410552978515625 ], [ 6.22833251953125, 62.390274047851562 ] ] ], [ [ [ 5.827221870422363, 62.239715576171875 ], [ 5.845971584320068, 62.407493591308594 ], [ 6.026666641235352, 62.352775573730469 ], [ 6.02388858795166, 62.327217102050781 ], [ 5.827221870422363, 62.239715576171875 ] ] ], [ [ [ -6.51805591583252, 62.16888427734375 ], [ -6.588055610656738, 62.239715576171875 ], [ -6.541666984558105, 62.357498168945312 ], [ -6.38972282409668, 62.246109008789062 ], [ -6.51805591583252, 62.16888427734375 ] ] ], [ [ [ -6.657500267028809, 62.055831909179688 ], [ -6.948056221008301, 62.1824951171875 ], [ -7.060277938842773, 62.313606262207031 ], [ -6.59944486618042, 62.195549011230469 ], [ -6.657500267028809, 62.055831909179688 ] ] ], [ [ [ -6.717778205871582, 61.933326721191406 ], [ -7.034581661224365, 62.112110137939453 ], [ -7.234236717224121, 62.177074432373047 ], [ -7.210833549499512, 62.284721374511719 ], [ -6.717778205871582, 61.933326721191406 ] ] ], [ [ [ 5.609166145324707, 62.185272216796875 ], [ 5.545693874359131, 62.279994964599609 ], [ 5.808610439300537, 62.270687103271484 ], [ 5.773332595825195, 62.202774047851562 ], [ 5.609166145324707, 62.185272216796875 ] ] ], [ [ [ -7.201666831970215, 62.018608093261719 ], [ -7.379861354827881, 62.066524505615234 ], [ -7.430347919464111, 62.143329620361328 ], [ -7.041944980621338, 62.089164733886719 ], [ -7.201666831970215, 62.018608093261719 ] ] ], [ [ [ -6.652222633361816, 61.742774963378906 ], [ -6.838611602783203, 61.817634582519531 ], [ -6.906667232513428, 61.905342102050781 ], [ -6.604166984558105, 61.823886871337891 ], [ -6.652222633361816, 61.742774963378906 ] ] ], [ [ [ 4.922499656677246, 61.773048400878906 ], [ 4.807499408721924, 61.841869354248047 ], [ 5.221110343933105, 61.839160919189453 ], [ 5.174999237060547, 61.822219848632812 ], [ 4.922499656677246, 61.773048400878906 ] ] ], [ [ [ -6.6602783203125, 61.388328552246094 ], [ -6.845833778381348, 61.468048095703125 ], [ -6.961389064788818, 61.620967864990234 ], [ -6.726667404174805, 61.574577331542969 ], [ -6.6602783203125, 61.388328552246094 ] ] ], [ [ [ 4.804721832275391, 61.044441223144531 ], [ 4.789583206176758, 61.149162292480469 ], [ 4.960971832275391, 61.173606872558594 ], [ 4.979999542236328, 61.093605041503906 ], [ 4.804721832275391, 61.044441223144531 ] ] ], [ [ [ -0.835000038146973, 60.673332214355469 ], [ -0.962083399295807, 60.685272216796875 ], [ -0.880694508552551, 60.843330383300781 ], [ -0.757638931274414, 60.815830230712891 ], [ -0.835000038146973, 60.673332214355469 ] ] ], [ [ [ 5.15916633605957, 60.576942443847656 ], [ 4.994166374206543, 60.626937866210938 ], [ 4.857360363006592, 60.734439849853516 ], [ 4.983471870422363, 60.712913513183594 ], [ 5.15916633605957, 60.576942443847656 ] ] ], [ [ [ -1.104722261428833, 60.485549926757812 ], [ -1.178333401679993, 60.63458251953125 ], [ -0.993888914585114, 60.722354888916016 ], [ -1.025416731834412, 60.500202178955078 ], [ -1.104722261428833, 60.485549926757812 ] ] ], [ [ [ 5.527499198913574, 60.429161071777344 ], [ 5.359999656677246, 60.523887634277344 ], [ 5.679166316986084, 60.681247711181641 ], [ 5.679443836212158, 60.470409393310547 ], [ 5.527499198913574, 60.429161071777344 ] ] ], [ [ [ -1.647777795791626, 60.224716186523438 ], [ -1.32027792930603, 60.35638427734375 ], [ -1.610347270965576, 60.478397369384766 ], [ -1.413333415985107, 60.605968475341797 ], [ -1.038541793823242, 60.442771911621094 ], [ -1.268611192703247, 59.851104736328125 ], [ -1.377916693687439, 59.904304504394531 ], [ -1.291388988494873, 60.241386413574219 ], [ -1.647777795791626, 60.224716186523438 ] ] ], [ [ [ 5.172499656677246, 60.505828857421875 ], [ 4.987221717834473, 60.561103820800781 ], [ 4.927499294281006, 60.602912902832031 ], [ 5.121665954589844, 60.578048706054688 ], [ 5.172499656677246, 60.505828857421875 ] ] ], [ [ [ 5.13861083984375, 60.396110534667969 ], [ 5.020833015441895, 60.492218017578125 ], [ 5.000832557678223, 60.531105041503906 ], [ 5.189999580383301, 60.474441528320312 ], [ 5.13861083984375, 60.396110534667969 ] ] ], [ [ [ 18.561664581298828, 60.305274963378906 ], [ 18.401107788085938, 60.365272521972656 ], [ 18.372915267944336, 60.496940612792969 ], [ 18.422496795654297, 60.486663818359375 ], [ 18.561664581298828, 60.305274963378906 ] ] ], [ [ [ 21.972221374511719, 60.3236083984375 ], [ 21.785274505615234, 60.376937866210938 ], [ 21.806247711181641, 60.462497711181641 ], [ 21.933330535888672, 60.416664123535156 ], [ 21.972221374511719, 60.3236083984375 ] ] ], [ [ [ 5.103610992431641, 60.183326721191406 ], [ 4.948888778686523, 60.246662139892578 ], [ 4.942499160766602, 60.427497863769531 ], [ 5.087499618530273, 60.328468322753906 ], [ 5.103610992431641, 60.183326721191406 ] ] ], [ [ [ 19.943885803222656, 60.042770385742188 ], [ 19.648469924926758, 60.259578704833984 ], [ 19.812915802001953, 60.186664581298828 ], [ 19.937358856201172, 60.291801452636719 ], [ 19.857219696044922, 60.403610229492188 ], [ 20.277496337890625, 60.274162292480469 ], [ 20.166942596435547, 60.163051605224609 ], [ 20.025276184082031, 60.310554504394531 ], [ 19.943885803222656, 60.042770385742188 ] ] ], [ [ [ 22.213333129882812, 60.241661071777344 ], [ 22.218887329101562, 60.269721984863281 ], [ 22.072498321533203, 60.292007446289062 ], [ 22.341665267944336, 60.285690307617188 ], [ 22.213333129882812, 60.241661071777344 ] ] ], [ [ [ 19.575275421142578, 60.121940612792969 ], [ 19.511386871337891, 60.178333282470703 ], [ 19.601943969726562, 60.255828857421875 ], [ 19.674860000610352, 60.153610229492188 ], [ 19.575275421142578, 60.121940612792969 ] ] ], [ [ [ 22.601108551025391, 59.983329772949219 ], [ 22.446662902832031, 60.215831756591797 ], [ 22.587776184082031, 60.202499389648438 ], [ 22.824443817138672, 60.227218627929688 ], [ 22.601108551025391, 59.983329772949219 ] ] ], [ [ [ 21.739166259765625, 60.109992980957031 ], [ 21.723331451416016, 60.186386108398438 ], [ 21.884998321533203, 60.174301147460938 ], [ 21.784999847412109, 60.118888854980469 ], [ 21.739166259765625, 60.109992980957031 ] ] ], [ [ [ 20.109996795654297, 60.088050842285156 ], [ 20.208608627319336, 60.061801910400391 ], [ 20.20707893371582, 59.978469848632812 ], [ 20.001665115356445, 60.053192138671875 ], [ 20.109996795654297, 60.088050842285156 ] ] ], [ [ [ 5.512777328491211, 59.893051147460938 ], [ 5.360208034515381, 59.988327026367188 ], [ 5.658055305480957, 60.075271606445312 ], [ 5.661249160766602, 59.996665954589844 ], [ 5.512777328491211, 59.893051147460938 ] ] ], [ [ [ 23.040554046630859, 59.897216796875 ], [ 22.881248474121094, 59.903606414794922 ], [ 22.803886413574219, 59.951244354248047 ], [ 23.054161071777344, 59.958610534667969 ], [ 23.040554046630859, 59.897216796875 ] ] ], [ [ [ 5.400554656982422, 59.751388549804688 ], [ 5.308402061462402, 59.789508819580078 ], [ 5.287776947021484, 59.971523284912109 ], [ 5.484166145324707, 59.860549926757812 ], [ 5.400554656982422, 59.751388549804688 ] ] ], [ [ [ 23.4022216796875, 59.900833129882812 ], [ 23.523052215576172, 59.959163665771484 ], [ 23.726383209228516, 59.931312561035156 ], [ 23.507221221923828, 59.915550231933594 ], [ 23.4022216796875, 59.900833129882812 ] ] ], [ [ [ 5.14888858795166, 59.581108093261719 ], [ 5.070208072662354, 59.781455993652344 ], [ 5.118888854980469, 59.87249755859375 ], [ 5.260694026947021, 59.800689697265625 ], [ 5.34305477142334, 59.701801300048828 ], [ 5.187082767486572, 59.735206604003906 ], [ 5.14888858795166, 59.581108093261719 ] ] ], [ [ [ 17.256385803222656, 59.373329162597656 ], [ 17.151386260986328, 59.385135650634766 ], [ 17.070137023925781, 59.4566650390625 ], [ 17.266941070556641, 59.444160461425781 ], [ 17.256385803222656, 59.373329162597656 ] ] ], [ [ [ 17.777774810791016, 59.308609008789062 ], [ 17.671943664550781, 59.334716796875 ], [ 17.608053207397461, 59.419162750244141 ], [ 17.775554656982422, 59.370410919189453 ], [ 17.777774810791016, 59.308609008789062 ] ] ], [ [ [ 5.160554885864258, 59.142776489257812 ], [ 5.131943702697754, 59.220832824707031 ], [ 5.194443702697754, 59.413055419921875 ], [ 5.293333053588867, 59.240692138671875 ], [ 5.160554885864258, 59.142776489257812 ] ] ], [ [ [ -2.68583345413208, 59.184165954589844 ], [ -2.684444904327393, 59.220832824707031 ], [ -2.592778205871582, 59.290550231933594 ], [ -2.397222518920898, 59.303329467773438 ], [ -2.68583345413208, 59.184165954589844 ] ] ], [ [ [ -2.824444770812988, 58.878883361816406 ], [ -3.313333511352539, 58.949996948242188 ], [ -3.350833415985107, 59.108188629150391 ], [ -3.075000286102295, 59.120414733886719 ], [ -2.824444770812988, 58.878883361816406 ] ] ], [ [ [ 22.565273284912109, 58.686653137207031 ], [ 22.386106491088867, 58.884574890136719 ], [ 22.044303894042969, 58.942626953125 ], [ 22.575828552246094, 59.068603515625 ], [ 23.045831680297852, 58.847770690917969 ], [ 22.565273284912109, 58.686653137207031 ] ] ], [ [ [ 23.192165374755859, 59.041984558105469 ], [ 23.351940155029297, 59.031936645507812 ], [ 23.389858245849609, 58.986240386962891 ], [ 23.148468017578125, 58.968326568603516 ], [ 23.192165374755859, 59.041984558105469 ] ] ], [ [ [ -3.231389045715332, 58.775550842285156 ], [ -3.296597480773926, 58.776939392089844 ], [ -3.415139198303223, 58.907356262207031 ], [ -3.135555744171143, 58.802494049072266 ], [ -3.231389045715332, 58.775550842285156 ] ] ], [ [ [ -2.939444541931152, 58.729995727539062 ], [ -2.980000019073486, 58.750274658203125 ], [ -3.032083511352539, 58.821247100830078 ], [ -2.886389255523682, 58.831939697265625 ], [ -2.939444541931152, 58.729995727539062 ] ] ], [ [ [ 23.247459411621094, 58.671051025390625 ], [ 23.396385192871094, 58.550827026367188 ], [ 23.059024810791016, 58.604579925537109 ], [ 23.14971923828125, 58.670272827148438 ], [ 23.247459411621094, 58.671051025390625 ] ] ], [ [ [ -4.196666717529297, 57.485832214355469 ], [ -3.339722633361816, 57.72332763671875 ], [ -1.82194447517395, 57.578605651855469 ], [ -1.773333549499512, 57.458053588867188 ], [ -2.531250238418579, 56.576107025146484 ], [ -3.278055667877197, 56.357498168945312 ], [ -2.884444713592529, 56.451385498046875 ], [ -2.583472490310669, 56.268535614013672 ], [ -3.723750114440918, 56.027355194091797 ], [ -3.053055763244629, 55.943603515625 ], [ -2.631111145019531, 56.054718017578125 ], [ -1.635972261428833, 55.581939697265625 ], [ -1.297500133514404, 54.76361083984375 ], [ -0.079305559396744, 54.113399505615234 ], [ -0.212222248315811, 54.008331298828125 ], [ 0.126388877630234, 53.645271301269531 ], [ 0.142083317041397, 53.580551147460938 ], [ -0.272500038146973, 53.735549926757812 ], [ -0.716527879238129, 53.696384429931641 ], [ -0.301666706800461, 53.713191986083984 ], [ 0.235555529594421, 53.399436950683594 ], [ 0.339166641235352, 53.092357635498047 ], [ 0.002109796507284, 52.879856109619141 ], [ 0.378888845443726, 52.781387329101562 ], [ 0.547777652740479, 52.966178894042969 ], [ 0.884722113609314, 52.966381072998047 ], [ 1.675277709960938, 52.748054504394531 ], [ 1.749444246292114, 52.455825805664062 ], [ 1.587360978126526, 52.083885192871094 ], [ 1.331249833106995, 51.928745269775391 ], [ 1.163472056388855, 52.023609161376953 ], [ 1.266110897064209, 51.839164733886719 ], [ 0.701111018657684, 51.718471527099609 ], [ 0.935694396495819, 51.736526489257812 ], [ 0.952499866485596, 51.609230041503906 ], [ 0.789444327354431, 51.524162292480469 ], [ 0.464999973773956, 51.5030517578125 ], [ 0.388935327529907, 51.448219299316406 ], [ 0.908055484294891, 51.340690612792969 ], [ 1.385555505752563, 51.387771606445312 ], [ 1.390277624130249, 51.154159545898438 ], [ 0.253888845443726, 50.738609313964844 ], [ -1.094444513320923, 50.845832824707031 ], [ -2.43445086479187, 50.541790008544922 ], [ -2.927500247955322, 50.731246948242188 ], [ -3.437222480773926, 50.604995727539062 ], [ -3.716666698455811, 50.2066650390625 ], [ -4.380000114440918, 50.363883972167969 ], [ -5.048055648803711, 50.171104431152344 ], [ -5.193056106567383, 49.955276489257812 ], [ -5.470556259155273, 50.124992370605469 ], [ -5.716805934906006, 50.060825347900391 ], [ -4.77166748046875, 50.601943969726562 ], [ -4.228055953979492, 51.187774658203125 ], [ -3.02833366394043, 51.206108093261719 ], [ -2.380000114440918, 51.761734008789062 ], [ -3.346111297607422, 51.378608703613281 ], [ -3.83791708946228, 51.6199951171875 ], [ -4.277778625488281, 51.556663513183594 ], [ -4.074722290039062, 51.677215576171875 ], [ -4.574444770812988, 51.734161376953125 ], [ -4.941389083862305, 51.594161987304688 ], [ -5.051389694213867, 51.620277404785156 ], [ -4.861111640930176, 51.713333129882812 ], [ -4.884445190429688, 51.746665954589844 ], [ -5.246945381164551, 51.730270385742188 ], [ -5.102569580078125, 51.778953552246094 ], [ -5.239167213439941, 51.9163818359375 ], [ -4.130833625793457, 52.334716796875 ], [ -4.133611679077148, 52.914443969726562 ], [ -4.758487224578857, 52.787261962890625 ], [ -4.196389198303223, 53.206108093261719 ], [ -3.336389064788818, 53.347221374511719 ], [ -3.102222442626953, 53.247772216796875 ], [ -3.170833587646484, 53.400276184082031 ], [ -2.862222671508789, 53.28277587890625 ], [ -2.704930782318115, 53.350620269775391 ], [ -2.953888893127441, 53.360275268554688 ], [ -3.105625152587891, 53.559928894042969 ], [ -2.899791717529297, 53.724994659423828 ], [ -3.052639007568359, 53.907634735107422 ], [ -2.813611507415771, 54.222770690917969 ], [ -3.214722633361816, 54.095550537109375 ], [ -3.632639169692993, 54.512214660644531 ], [ -3.381111145019531, 54.884437561035156 ], [ -3.0270836353302, 54.972911834716797 ], [ -3.57111120223999, 54.990829467773438 ], [ -3.965000152587891, 54.765274047851562 ], [ -4.398056030273438, 54.906387329101562 ], [ -4.387222290039062, 54.675552368164062 ], [ -4.852222442626953, 54.868606567382812 ], [ -4.960764408111572, 54.796871185302734 ], [ -4.864167213439941, 54.627220153808594 ], [ -5.170000076293945, 54.891105651855469 ], [ -4.613611698150635, 55.490688323974609 ], [ -4.916388988494873, 55.700828552246094 ], [ -4.878264427185059, 55.9365234375 ], [ -4.485417366027832, 55.923606872558594 ], [ -4.854612350463867, 55.986484527587891 ], [ -4.828605651855469, 56.113162994384766 ], [ -4.986667156219482, 55.864925384521484 ], [ -5.173334121704102, 55.929161071777344 ], [ -5.305278301239014, 55.852218627929688 ], [ -5.309055805206299, 56.005702972412109 ], [ -4.922292232513428, 56.271106719970703 ], [ -5.4291672706604, 56.006938934326172 ], [ -5.515278339385986, 55.363468170166016 ], [ -5.788889408111572, 55.308742523193359 ], [ -5.571389198303223, 56.328327178955078 ], [ -5.206111431121826, 56.440971374511719 ], [ -5.120555877685547, 56.495552062988281 ], [ -5.070138931274414, 56.560691833496094 ], [ -5.398667335510254, 56.478664398193359 ], [ -5.120833873748779, 56.814720153808594 ], [ -5.676944732666016, 56.493888854980469 ], [ -6.009722709655762, 56.633468627929688 ], [ -5.552395820617676, 56.688850402832031 ], [ -6.227778434753418, 56.697219848632812 ], [ -5.662917137145996, 56.869232177734375 ], [ -5.919583797454834, 56.887081146240234 ], [ -5.825833797454834, 57.003467559814453 ], [ -5.646111488342285, 56.972217559814453 ], [ -5.524028301239014, 56.997356414794922 ], [ -5.724722862243652, 57.113052368164062 ], [ -5.403056144714355, 57.110618591308594 ], [ -5.647507190704346, 57.161605834960938 ], [ -5.405139446258545, 57.230968475341797 ], [ -5.598844528198242, 57.330486297607422 ], [ -5.451250076293945, 57.418048858642578 ], [ -5.818056106567383, 57.362495422363281 ], [ -5.839722633361816, 57.572776794433594 ], [ -5.653055667877197, 57.508743286132812 ], [ -5.510139465332031, 57.533191680908203 ], [ -5.81083345413208, 57.639579772949219 ], [ -5.801389217376709, 57.853885650634766 ], [ -5.102778434753418, 57.850830078125 ], [ -5.452847480773926, 58.074161529541016 ], [ -5.281458854675293, 58.077217102050781 ], [ -5.389444828033447, 58.260272979736328 ], [ -5.071666717529297, 58.264717102050781 ], [ -5.174722671508789, 58.349998474121094 ], [ -5.001528263092041, 58.624160766601562 ], [ -4.701666831970215, 58.558609008789062 ], [ -4.761458873748779, 58.446037292480469 ], [ -4.578333854675293, 58.574440002441406 ], [ -3.022639036178589, 58.646526336669922 ], [ -3.20555591583252, 58.306247711181641 ], [ -4.015000343322754, 57.867774963378906 ], [ -4.391666889190674, 57.901386260986328 ], [ -4.043222904205322, 57.814384460449219 ], [ -3.774028062820435, 57.854854583740234 ], [ -3.97777795791626, 57.698326110839844 ], [ -4.296667098999023, 57.6744384765625 ], [ -4.431528091430664, 57.572772979736328 ], [ -4.046667098999023, 57.642776489257812 ], [ -4.196666717529297, 57.485832214355469 ] ] ], [ [ [ 22.037776947021484, 57.9083251953125 ], [ 22.194091796875, 58.145236968994141 ], [ 21.844509124755859, 58.289161682128906 ], [ 22.006942749023438, 58.356658935546875 ], [ 21.837356567382812, 58.506664276123047 ], [ 22.911245346069336, 58.616798400878906 ], [ 23.328189849853516, 58.446937561035156 ], [ 22.372913360595703, 58.221378326416016 ], [ 22.037776947021484, 57.9083251953125 ] ] ], [ [ [ -7.021944999694824, 57.951942443847656 ], [ -7.036250591278076, 58.235691070556641 ], [ -6.860972881317139, 58.105968475341797 ], [ -6.797778129577637, 58.302215576171875 ], [ -6.263333797454834, 58.51263427734375 ], [ -6.165972709655762, 58.422916412353516 ], [ -6.327027797698975, 58.235397338867188 ], [ -6.168334007263184, 58.209579467773438 ], [ -6.619722843170166, 58.080135345458984 ], [ -6.393333911895752, 58.101665496826172 ], [ -6.473333835601807, 57.942218780517578 ], [ -6.664306163787842, 57.925552368164062 ], [ -6.686806201934814, 58.056243896484375 ], [ -6.661389350891113, 57.882637023925781 ], [ -6.964931011199951, 57.726314544677734 ], [ -7.124236583709717, 57.835620880126953 ], [ -6.832222938537598, 57.9022216796875 ], [ -7.021944999694824, 57.951942443847656 ] ] ], [ [ [ 11.464998245239258, 58.066108703613281 ], [ 11.410554885864258, 58.147499084472656 ], [ 11.67319393157959, 58.285549163818359 ], [ 11.812429428100586, 58.217704772949219 ], [ 11.464998245239258, 58.066108703613281 ] ] ], [ [ [ 11.518124580383301, 57.980690002441406 ], [ 11.525276184082031, 58.048469543457031 ], [ 11.741665840148926, 58.02777099609375 ], [ 11.594444274902344, 57.9324951171875 ], [ 11.518124580383301, 57.980690002441406 ] ] ], [ [ [ 19.126110076904297, 57.8397216796875 ], [ 19.09235954284668, 57.971942901611328 ], [ 19.334232330322266, 57.959365844726562 ], [ 19.166666030883789, 57.928192138671875 ], [ 19.126110076904297, 57.8397216796875 ] ] ], [ [ [ 19.003887176513672, 57.898887634277344 ], [ 18.713191986083984, 57.244300842285156 ], [ 18.144580841064453, 56.914787292480469 ], [ 18.254444122314453, 57.07916259765625 ], [ 18.115274429321289, 57.525272369384766 ], [ 18.685970306396484, 57.91485595703125 ], [ 19.003887176513672, 57.898887634277344 ] ] ], [ [ [ 10.645953178405762, 57.73626708984375 ], [ 10.431804656982422, 57.585689544677734 ], [ 10.530276298522949, 57.222564697265625 ], [ 10.336615562438965, 56.991664886474609 ], [ 10.004720687866211, 57.089618682861328 ], [ 9.115549087524414, 57.052772521972656 ], [ 8.676595687866211, 56.9481201171875 ], [ 8.415797233581543, 56.678127288818359 ], [ 8.579061508178711, 56.687671661376953 ], [ 8.545901298522949, 56.585170745849609 ], [ 8.244165420532227, 56.704303741455078 ], [ 8.618471145629883, 57.121524810791016 ], [ 9.391318321228027, 57.152149200439453 ], [ 9.957706451416016, 57.586246490478516 ], [ 10.645953178405762, 57.73626708984375 ] ] ], [ [ [ -7.233612060546875, 57.503608703613281 ], [ -7.322083950042725, 57.506244659423828 ], [ -7.540833950042725, 57.590133666992188 ], [ -7.068611621856689, 57.636592864990234 ], [ -7.233612060546875, 57.503608703613281 ] ] ], [ [ [ -6.724445343017578, 57.403610229492188 ], [ -6.637500762939453, 57.605552673339844 ], [ -6.430000305175781, 57.504997253417969 ], [ -6.304166793823242, 57.686103820800781 ], [ -6.127223014831543, 57.306106567382812 ], [ -5.647639274597168, 57.258327484130859 ], [ -6.01430606842041, 57.023468017578125 ], [ -6.030555725097656, 57.177497863769531 ], [ -6.316389083862305, 57.158466339111328 ], [ -6.480139255523682, 57.302497863769531 ], [ -6.312083721160889, 57.299785614013672 ], [ -6.724445343017578, 57.403610229492188 ] ] ], [ [ [ -6.051111221313477, 57.324440002441406 ], [ -6.073056221008301, 57.430549621582031 ], [ -6.003055572509766, 57.50860595703125 ], [ -5.994722843170166, 57.343051910400391 ], [ -6.051111221313477, 57.324440002441406 ] ] ], [ [ [ -7.283333778381348, 57.397499084472656 ], [ -7.388055801391602, 57.423881530761719 ], [ -7.402778148651123, 57.468120574951172 ], [ -7.203611373901367, 57.459163665771484 ], [ -7.283333778381348, 57.397499084472656 ] ] ], [ [ [ -7.230278015136719, 57.094718933105469 ], [ -7.384028434753418, 57.111660003662109 ], [ -7.423611640930176, 57.383747100830078 ], [ -7.223750591278076, 57.339576721191406 ], [ -7.230278015136719, 57.094718933105469 ] ] ], [ [ [ 16.429721832275391, 56.208885192871094 ], [ 16.420276641845703, 56.586387634277344 ], [ 17.102081298828125, 57.349441528320312 ], [ 16.571662902832031, 56.354995727539062 ], [ 16.429721832275391, 56.208885192871094 ] ] ], [ [ [ 10.982221603393555, 57.221664428710938 ], [ 10.857637405395508, 57.264579772949219 ], [ 11.196388244628906, 57.312496185302734 ], [ 11.058332443237305, 57.240829467773438 ], [ 10.982221603393555, 57.221664428710938 ] ] ], [ [ [ -7.466944694519043, 56.940826416015625 ], [ -7.560278415679932, 56.957912445068359 ], [ -7.442639350891113, 57.054996490478516 ], [ -7.377083778381348, 56.980411529541016 ], [ -7.466944694519043, 56.940826416015625 ] ] ], [ [ [ -6.317500114440918, 56.934165954589844 ], [ -6.361945152282715, 56.946388244628906 ], [ -6.450972557067871, 57.003326416015625 ], [ -6.257917404174805, 57.034858703613281 ], [ -6.317500114440918, 56.934165954589844 ] ] ], [ [ [ 8.655277252197266, 56.674163818359375 ], [ 8.546110153198242, 56.793327331542969 ], [ 8.910831451416016, 56.948326110839844 ], [ 8.831388473510742, 56.743331909179688 ], [ 8.655277252197266, 56.674163818359375 ] ] ], [ [ [ -6.67833423614502, 56.555549621582031 ], [ -6.613889694213867, 56.634437561035156 ], [ -6.456007480621338, 56.682773590087891 ], [ -6.497361660003662, 56.627494812011719 ], [ -6.67833423614502, 56.555549621582031 ] ] ], [ [ [ -6.116666793823242, 56.650276184082031 ], [ -5.651111602783203, 56.45111083984375 ], [ -5.660833835601807, 56.399303436279297 ], [ -6.323056221008301, 56.265411376953125 ], [ -6.019375324249268, 56.375965118408203 ], [ -6.201667308807373, 56.382358551025391 ], [ -6.003403186798096, 56.492565155029297 ], [ -6.337778091430664, 56.546661376953125 ], [ -6.116666793823242, 56.650276184082031 ] ] ], [ [ [ -6.892778396606445, 56.438606262207031 ], [ -6.989722728729248, 56.496246337890625 ], [ -6.730069637298584, 56.523952484130859 ], [ -6.803889274597168, 56.512218475341797 ], [ -6.892778396606445, 56.438606262207031 ] ] ], [ [ [ -5.971944808959961, 55.788330078125 ], [ -6.078888893127441, 55.905548095703125 ], [ -5.69444465637207, 56.147216796875 ], [ -5.690834045410156, 56.106666564941406 ], [ -5.971944808959961, 55.788330078125 ] ] ], [ [ [ 12.55887508392334, 55.867237091064453 ], [ 12.597984313964844, 55.702564239501953 ], [ 12.192359924316406, 55.482425689697266 ], [ 12.462221145629883, 55.289577484130859 ], [ 12.025554656982422, 55.169441223144531 ], [ 12.178749084472656, 55.11846923828125 ], [ 12.071943283081055, 54.968605041503906 ], [ 11.730554580688477, 55.060554504394531 ], [ 11.730833053588867, 55.203605651855469 ], [ 11.245415687561035, 55.202075958251953 ], [ 11.08638858795166, 55.666385650634766 ], [ 10.879720687866211, 55.734298706054688 ], [ 11.211111068725586, 55.698883056640625 ], [ 11.506387710571289, 55.867218017578125 ], [ 11.273332595825195, 55.991661071777344 ], [ 11.768332481384277, 55.963470458984375 ], [ 11.670555114746094, 55.814163208007812 ], [ 11.794440269470215, 55.661659240722656 ], [ 11.914164543151855, 55.929718017578125 ], [ 12.056249618530273, 55.746803283691406 ], [ 11.935832977294922, 55.653327941894531 ], [ 12.059581756591797, 55.655689239501953 ], [ 12.093887329101562, 55.711105346679688 ], [ 12.040970802307129, 55.921665191650391 ], [ 11.847082138061523, 55.955554962158203 ], [ 12.290554046630859, 56.128883361816406 ], [ 12.617290496826172, 56.040134429931641 ], [ 12.55887508392334, 55.867237091064453 ] ] ], [ [ [ 10.666893005371094, 55.892585754394531 ], [ 10.666248321533203, 55.872077941894531 ], [ 10.610971450805664, 55.761524200439453 ], [ 10.527776718139648, 55.767494201660156 ], [ 10.523611068725586, 55.98138427734375 ], [ 10.666893005371094, 55.892585754394531 ] ] ], [ [ [ -6.274444580078125, 55.572776794433594 ], [ -6.262222290039062, 55.777217864990234 ], [ -6.495278358459473, 55.733604431152344 ], [ -6.12569522857666, 55.931247711181641 ], [ -6.026111602783203, 55.679302215576172 ], [ -6.274444580078125, 55.572776794433594 ] ] ], [ [ [ -5.023056030273438, 55.721382141113281 ], [ -5.120417594909668, 55.77874755859375 ], [ -5.206319808959961, 55.896659851074219 ], [ -5.036389350891113, 55.837776184082031 ], [ -5.023056030273438, 55.721382141113281 ] ] ], [ [ [ -5.171944618225098, 55.429443359375 ], [ -5.341250896453857, 55.476108551025391 ], [ -5.379583358764648, 55.670135498046875 ], [ -5.154723167419434, 55.673332214355469 ], [ -5.171944618225098, 55.429443359375 ] ] ], [ [ [ 10.000304222106934, 55.541263580322266 ], [ 10.31847095489502, 55.61444091796875 ], [ 10.473749160766602, 55.437633514404297 ], [ 10.660276412963867, 55.587635040283203 ], [ 10.783331871032715, 55.124092102050781 ], [ 10.152776718139648, 55.084442138671875 ], [ 9.679720878601074, 55.497077941894531 ], [ 10.000304222106934, 55.541263580322266 ] ] ], [ [ [ -9.001476287841797, 53.145591735839844 ], [ -8.941112518310547, 53.26416015625 ], [ -9.608057022094727, 53.232215881347656 ], [ -9.55916690826416, 53.381248474121094 ], [ -10.176528930664062, 53.409717559814453 ], [ -10.186111450195312, 53.550277709960938 ], [ -9.698958396911621, 53.597911834716797 ], [ -9.906389236450195, 53.75860595703125 ], [ -9.561389923095703, 53.859718322753906 ], [ -9.940695762634277, 53.867912292480469 ], [ -9.789584159851074, 53.945411682128906 ], [ -10.013402938842773, 54.218189239501953 ], [ -10.124028205871582, 54.096588134765625 ], [ -10.112222671508789, 54.229995727539062 ], [ -8.474862098693848, 54.273468017578125 ], [ -8.668126106262207, 54.343536376953125 ], [ -8.188333511352539, 54.63360595703125 ], [ -8.798334121704102, 54.695758819580078 ], [ -8.353889465332031, 54.839439392089844 ], [ -8.457222938537598, 54.996799468994141 ], [ -8.317501068115234, 55.10888671875 ], [ -7.793506622314453, 55.243118286132812 ], [ -7.810835361480713, 55.176471710205078 ], [ -7.699722290039062, 55.095134735107422 ], [ -7.79172945022583, 55.212017059326172 ], [ -7.657500267028809, 55.274436950683594 ], [ -7.526111602783203, 55.1119384765625 ], [ -7.663333892822266, 54.953887939453125 ], [ -7.446528434753418, 55.055690765380859 ], [ -7.547500610351562, 55.216941833496094 ], [ -7.376667022705078, 55.379993438720703 ], [ -6.935139656066895, 55.238468170166016 ], [ -7.253056049346924, 55.046798706054688 ], [ -6.145833492279053, 55.220691680908203 ], [ -5.690417289733887, 54.809162139892578 ], [ -5.902431011199951, 54.602287292480469 ], [ -5.574306011199951, 54.677219390869141 ], [ -5.431319713592529, 54.485965728759766 ], [ -5.506722450256348, 54.36444091796875 ], [ -5.69812536239624, 54.5726318359375 ], [ -5.562222480773926, 54.283050537109375 ], [ -6.381389141082764, 53.951522827148438 ], [ -6.081111907958984, 53.563606262207031 ], [ -6.224584102630615, 53.352771759033203 ], [ -6.013055801391602, 52.944999694824219 ], [ -6.203333854675293, 52.547775268554688 ], [ -6.498194694519043, 52.354026794433594 ], [ -6.359445095062256, 52.179023742675781 ], [ -6.997295379638672, 52.278270721435547 ], [ -7.001806259155273, 52.138469696044922 ], [ -7.578888893127441, 52.100273132324219 ], [ -8.169306755065918, 51.791942596435547 ], [ -8.210556030273438, 51.884437561035156 ], [ -8.421938896179199, 51.881546020507812 ], [ -8.310695648193359, 51.741802215576172 ], [ -9.23013973236084, 51.482357025146484 ], [ -9.817501068115234, 51.445549011230469 ], [ -9.450834274291992, 51.689437866210938 ], [ -9.535556793212891, 51.75 ], [ -10.132501602172852, 51.593330383300781 ], [ -9.580973625183105, 51.872352600097656 ], [ -10.338592529296875, 51.782920837402344 ], [ -10.263612747192383, 51.988052368164062 ], [ -9.760416984558105, 52.149578094482422 ], [ -10.463335037231445, 52.180206298828125 ], [ -9.74486255645752, 52.247219085693359 ], [ -9.839723587036133, 52.379714965820312 ], [ -9.65361213684082, 52.560829162597656 ], [ -9.331666946411133, 52.57110595703125 ], [ -8.818334579467773, 52.665550231933594 ], [ -9.932361602783203, 52.555202484130859 ], [ -9.485834121704102, 52.800552368164062 ], [ -9.280834197998047, 53.139717102050781 ], [ -9.001476287841797, 53.145591735839844 ] ] ], [ [ [ 15.042499542236328, 54.994720458984375 ], [ 14.678749084472656, 55.100830078125 ], [ 14.745275497436523, 55.294025421142578 ], [ 15.137637138366699, 55.141387939453125 ], [ 15.042499542236328, 54.994720458984375 ] ] ], [ [ [ 10.7147216796875, 54.724998474121094 ], [ 10.681943893432617, 54.908607482910156 ], [ 10.952082633972168, 55.1593017578125 ], [ 10.896804809570312, 54.999439239501953 ], [ 10.7147216796875, 54.724998474121094 ] ] ], [ [ [ 10.0, 54.983718872070312 ], [ 10.069304466247559, 54.873878479003906 ], [ 9.931665420532227, 54.861385345458984 ], [ 9.631457328796387, 55.049022674560547 ], [ 10.0, 54.983718872070312 ] ] ], [ [ [ 10.565277099609375, 54.94610595703125 ], [ 10.501804351806641, 55.006729125976562 ], [ 10.675832748413086, 54.991939544677734 ], [ 10.614999771118164, 54.950271606445312 ], [ 10.565277099609375, 54.94610595703125 ] ] ], [ [ [ 12.183610916137695, 54.880271911621094 ], [ 12.311943054199219, 55.035270690917969 ], [ 12.55645751953125, 54.9637451171875 ], [ 12.338054656982422, 54.958885192871094 ], [ 12.183610916137695, 54.880271911621094 ] ] ], [ [ [ 10.407220840454102, 54.821388244628906 ], [ 10.245694160461426, 54.905967712402344 ], [ 10.186735153198242, 54.974437713623047 ], [ 10.440832138061523, 54.863883972167969 ], [ 10.407220840454102, 54.821388244628906 ] ] ], [ [ [ 11.850586891174316, 54.954784393310547 ], [ 12.168192863464355, 54.837703704833984 ], [ 11.966804504394531, 54.561939239501953 ], [ 11.899166107177734, 54.718605041503906 ], [ 11.710971832275391, 54.939163208007812 ], [ 11.850586891174316, 54.954784393310547 ] ] ], [ [ [ 10.989891052246094, 54.790847778320312 ], [ 11.239721298217773, 54.957221984863281 ], [ 11.656944274902344, 54.903884887695312 ], [ 11.857220649719238, 54.686382293701172 ], [ 11.454929351806641, 54.619857788085938 ], [ 10.989891052246094, 54.790847778320312 ] ] ], [ [ [ 8.563610076904297, 54.684165954589844 ], [ 8.47833251953125, 54.686943054199219 ], [ 8.398332595825195, 54.710201263427734 ], [ 8.551109313964844, 54.753883361816406 ], [ 8.563610076904297, 54.684165954589844 ] ] ], [ [ [ 13.357498168945312, 54.259719848632812 ], [ 13.118818283081055, 54.33673095703125 ], [ 13.263888359069824, 54.379997253417969 ], [ 13.14696216583252, 54.545604705810547 ], [ 13.516607284545898, 54.513370513916016 ], [ 13.226527214050293, 54.641178131103516 ], [ 13.67451286315918, 54.566593170166016 ], [ 13.57728385925293, 54.456935882568359 ], [ 13.710693359375, 54.380970001220703 ], [ 13.729166030883789, 54.275135040283203 ], [ 13.357498168945312, 54.259719848632812 ] ] ], [ [ [ 11.273926734924316, 54.458736419677734 ], [ 11.312499046325684, 54.408332824707031 ], [ 11.006110191345215, 54.457633972167969 ], [ 11.066804885864258, 54.534580230712891 ], [ 11.273926734924316, 54.458736419677734 ] ] ], [ [ [ -4.777778625488281, 54.055549621582031 ], [ -4.71208381652832, 54.215827941894531 ], [ -4.353472709655762, 54.409996032714844 ], [ -4.394444465637207, 54.186386108398438 ], [ -4.777778625488281, 54.055549621582031 ] ] ], [ [ [ 10.979442596435547, 54.38055419921875 ], [ 10.994998931884766, 54.381942749023438 ], [ 11.016456604003906, 54.379161834716797 ], [ 10.994582176208496, 54.377494812011719 ], [ 10.979442596435547, 54.38055419921875 ] ] ], [ [ [ -10.119522094726562, 54.0 ], [ -9.970139503479004, 54.020828247070312 ], [ -9.943889617919922, 53.883747100830078 ], [ -10.265625953674316, 53.972496032714844 ], [ -10.119522094726562, 54.0 ] ] ], [ [ [ 5.200554847717285, 53.349441528320312 ], [ 5.169999599456787, 53.375690460205078 ], [ 5.579026699066162, 53.448467254638672 ], [ 5.561110496520996, 53.430274963378906 ], [ 5.200554847717285, 53.349441528320312 ] ] ], [ [ [ -4.351388931274414, 53.124443054199219 ], [ -4.560000419616699, 53.396659851074219 ], [ -4.046528339385986, 53.301525115966797 ], [ -4.101388931274414, 53.247772216796875 ], [ -4.218055725097656, 53.200271606445312 ], [ -4.351388931274414, 53.124443054199219 ] ] ], [ [ [ 4.753610610961914, 52.988609313964844 ], [ 4.713888168334961, 53.056106567382812 ], [ 4.883541107177734, 53.183467864990234 ], [ 4.910555362701416, 53.094581604003906 ], [ 4.753610610961914, 52.988609313964844 ] ] ], [ [ [ 5.107433319091797, 52.488533020019531 ], [ 5.049039363861084, 52.636795043945312 ], [ 5.483541011810303, 52.572772979736328 ], [ 5.134019374847412, 52.383136749267578 ], [ 5.107433319091797, 52.488533020019531 ] ] ], [ [ [ 5.611944198608398, 52.369720458984375 ], [ 5.422221660614014, 52.26416015625 ], [ 5.136666297912598, 52.381523132324219 ], [ 5.573332786560059, 52.588333129882812 ], [ 5.860700130462646, 52.530906677246094 ], [ 5.611944198608398, 52.369720458984375 ] ] ], [ [ [ 3.712656259536743, 51.674674987792969 ], [ 3.881944417953491, 51.743888854980469 ], [ 4.106143951416016, 51.650978088378906 ], [ 3.97374963760376, 51.614578247070312 ], [ 3.712656259536743, 51.674674987792969 ] ] ], [ [ [ 0.899166584014893, 51.357215881347656 ], [ 0.76277768611908, 51.378330230712891 ], [ 0.74055552482605, 51.429718017578125 ], [ 0.906527698040009, 51.417911529541016 ], [ 0.899166584014893, 51.357215881347656 ] ] ], [ [ [ -1.282500028610229, 50.578887939453125 ], [ -1.496389031410217, 50.667915344238281 ], [ -1.569583535194397, 50.659023284912109 ], [ -1.308888912200928, 50.771110534667969 ], [ -1.059722423553467, 50.687492370605469 ], [ -1.282500028610229, 50.578887939453125 ] ] ], [ [ [ -2.59083366394043, 49.422492980957031 ], [ -2.668611288070679, 49.432773590087891 ], [ -2.500972509384155, 49.503887176513672 ], [ -2.528472661972046, 49.426387786865234 ], [ -2.59083366394043, 49.422492980957031 ] ] ], [ [ [ -2.066944599151611, 49.167770385742188 ], [ -2.226388931274414, 49.189720153808594 ], [ -2.247361421585083, 49.251247406005859 ], [ -2.016805648803711, 49.231037139892578 ], [ -2.066944599151611, 49.167770385742188 ] ] ], [ [ [ -3.576666831970215, 48.803886413574219 ], [ -3.575555801391602, 48.812492370605469 ], [ -3.563333511352539, 48.808609008789062 ], [ -3.56611156463623, 48.805831909179688 ], [ -3.576666831970215, 48.803886413574219 ] ] ], [ [ [ -3.085833549499512, 47.287773132324219 ], [ -3.219444751739502, 47.304580688476562 ], [ -3.259583473205566, 47.371730804443359 ], [ -3.063611268997192, 47.314437866210938 ], [ -3.085833549499512, 47.287773132324219 ] ] ], [ [ [ -1.284166812896729, 46.155548095703125 ], [ -1.50694465637207, 46.20416259765625 ], [ -1.55138897895813, 46.246036529541016 ], [ -1.291666746139526, 46.198051452636719 ], [ -1.284166812896729, 46.155548095703125 ] ] ], [ [ [ -1.211944580078125, 45.806938171386719 ], [ -1.374861240386963, 45.961662292480469 ], [ -1.39923620223999, 46.049858093261719 ], [ -1.171249985694885, 45.891315460205078 ], [ -1.211944580078125, 45.806938171386719 ] ] ], [ [ [ 12.314332008361816, 45.341327667236328 ], [ 12.369160652160645, 45.425819396972656 ], [ 12.426901817321777, 45.414958953857422 ], [ 12.379225730895996, 45.419994354248047 ], [ 12.314332008361816, 45.341327667236328 ] ] ], [ [ [ 14.733610153198242, 44.939994812011719 ], [ 14.43638801574707, 45.069995880126953 ], [ 14.539164543151855, 45.23944091796875 ], [ 14.806665420532227, 44.996383666992188 ], [ 14.733610153198242, 44.939994812011719 ] ] ], [ [ [ 14.488054275512695, 44.605827331542969 ], [ 14.331388473510742, 44.849716186523438 ], [ 14.317638397216797, 45.175411224365234 ], [ 14.426387786865234, 44.984718322753906 ], [ 14.488054275512695, 44.605827331542969 ] ] ], [ [ [ 14.516666412353516, 44.47332763671875 ], [ 14.367498397827148, 44.59027099609375 ], [ 14.338054656982422, 44.706733703613281 ], [ 14.39194393157959, 44.689857482910156 ], [ 14.516666412353516, 44.47332763671875 ] ] ], [ [ [ 14.745277404785156, 44.694442749023438 ], [ 15.042637825012207, 44.522842407226562 ], [ 15.250068664550781, 44.335483551025391 ], [ 15.128888130187988, 44.309860229492188 ], [ 14.745277404785156, 44.694442749023438 ] ] ], [ [ [ 15.19416618347168, 43.871109008789062 ], [ 15.108055114746094, 43.919998168945312 ], [ 14.85423469543457, 44.172565460205078 ], [ 15.219582557678223, 43.909717559814453 ], [ 15.19416618347168, 43.871109008789062 ] ] ], [ [ [ 16.687221527099609, 43.261665344238281 ], [ 16.519721984863281, 43.276382446289062 ], [ 16.405553817749023, 43.326038360595703 ], [ 16.884719848632812, 43.317214965820312 ], [ 16.687221527099609, 43.261665344238281 ] ] ], [ [ [ 17.057777404785156, 43.112495422363281 ], [ 16.654163360595703, 43.119720458984375 ], [ 16.377775192260742, 43.195343017578125 ], [ 17.116386413574219, 43.1361083984375 ], [ 17.057777404785156, 43.112495422363281 ] ] ], [ [ [ 16.093330383300781, 43.009994506835938 ], [ 16.050552368164062, 43.06304931640625 ], [ 16.252115249633789, 43.064609527587891 ], [ 16.209859848022461, 43.023468017578125 ], [ 16.093330383300781, 43.009994506835938 ] ] ], [ [ [ 8.659442901611328, 42.008331298828125 ], [ 8.665277481079102, 42.5111083984375 ], [ 9.288887977600098, 42.674995422363281 ], [ 9.346803665161133, 43.000411987304688 ], [ 9.459582328796387, 42.988048553466797 ], [ 9.552568435668945, 42.118331909179688 ], [ 9.21965217590332, 41.367286682128906 ], [ 8.790414810180664, 41.557842254638672 ], [ 8.917117118835449, 41.685688018798828 ], [ 8.725831985473633, 41.729438781738281 ], [ 8.802360534667969, 41.900413513183594 ], [ 8.627222061157227, 41.906661987304688 ], [ 8.659442901611328, 42.008331298828125 ] ] ], [ [ [ 16.866107940673828, 42.897773742675781 ], [ 16.633886337280273, 42.982357025146484 ], [ 17.183609008789062, 42.918609619140625 ], [ 16.941108703613281, 42.911384582519531 ], [ 16.866107940673828, 42.897773742675781 ] ] ], [ [ [ 10.418609619140625, 42.708610534667969 ], [ 10.139165878295898, 42.731666564941406 ], [ 10.100971221923828, 42.784854888916016 ], [ 10.413054466247559, 42.870067596435547 ], [ 10.418609619140625, 42.708610534667969 ] ] ], [ [ [ 17.739997863769531, 42.691665649414062 ], [ 17.37249755859375, 42.757217407226562 ], [ 17.323469161987305, 42.789024353027344 ], [ 17.664859771728516, 42.735969543457031 ], [ 17.739997863769531, 42.691665649414062 ] ] ], [ [ [ 8.178333282470703, 40.636383056640625 ], [ 8.228054046630859, 40.938396453857422 ], [ 8.579721450805664, 40.839996337890625 ], [ 9.233055114746094, 41.254714965820312 ], [ 9.562498092651367, 41.117774963378906 ], [ 9.633888244628906, 40.989166259765625 ], [ 9.51045036315918, 40.920375823974609 ], [ 9.824165344238281, 40.527217864990234 ], [ 9.623332023620605, 40.251873016357422 ], [ 9.71360969543457, 40.040550231933594 ], [ 9.565068244934082, 39.145618438720703 ], [ 9.013540267944336, 39.263191223144531 ], [ 8.902082443237305, 38.902633666992188 ], [ 8.646387100219727, 38.890274047851562 ], [ 8.505380630493164, 39.061027526855469 ], [ 8.408331871032715, 38.958538055419922 ], [ 8.371527671813965, 39.372913360595703 ], [ 8.557220458984375, 39.844993591308594 ], [ 8.395971298217773, 39.901313781738281 ], [ 8.457221984863281, 40.321388244628906 ], [ 8.178333282470703, 40.636383056640625 ] ] ], [ [ [ 24.643608093261719, 40.570831298828125 ], [ 24.509441375732422, 40.658050537109375 ], [ 24.643192291259766, 40.797218322753906 ], [ 24.773330688476562, 40.631660461425781 ], [ 24.643608093261719, 40.570831298828125 ] ] ], [ [ [ 25.657218933105469, 40.493049621582031 ], [ 25.603885650634766, 40.398319244384766 ], [ 25.443885803222656, 40.475822448730469 ], [ 25.555831909179688, 40.51165771484375 ], [ 25.657218933105469, 40.493049621582031 ] ] ], [ [ [ 4.276388168334961, 39.806388854980469 ], [ 3.826666355133057, 39.922492980957031 ], [ 3.796944141387939, 40.017219543457031 ], [ 4.174444198608398, 40.050277709960938 ], [ 4.276388168334961, 39.806388854980469 ] ] ], [ [ [ 25.441665649414062, 40.004714965820312 ], [ 25.355827331542969, 39.786384582519531 ], [ 25.263051986694336, 39.912349700927734 ], [ 25.054439544677734, 39.860549926757812 ], [ 25.047636032104492, 39.986656188964844 ], [ 25.441665649414062, 40.004714965820312 ] ] ], [ [ [ 2.389166355133057, 39.524993896484375 ], [ 2.987777709960938, 39.911109924316406 ], [ 3.479999780654907, 39.716384887695312 ], [ 3.060277700424194, 39.263332366943359 ], [ 2.694444179534912, 39.55194091796875 ], [ 2.389166355133057, 39.524993896484375 ] ] ], [ [ [ 19.854999542236328, 39.818328857421875 ], [ 19.929859161376953, 39.474441528320312 ], [ 20.111663818359375, 39.363052368164062 ], [ 19.878746032714844, 39.448535919189453 ], [ 19.674581527709961, 39.675968170166016 ], [ 19.854999542236328, 39.818328857421875 ] ] ], [ [ [ -31.215557098388672, 39.35333251953125 ], [ -31.289030075073242, 39.410968780517578 ], [ -31.213890075683594, 39.521942138671875 ], [ -31.126041412353516, 39.455204010009766 ], [ -31.215557098388672, 39.35333251953125 ] ] ], [ [ [ 26.419994354248047, 39.325828552246094 ], [ 26.615690231323242, 39.013881683349609 ], [ 26.088468551635742, 39.074371337890625 ], [ 26.257080078125, 39.203460693359375 ], [ 26.065412521362305, 39.084575653076172 ], [ 25.834856033325195, 39.180065155029297 ], [ 26.178329467773438, 39.374984741210938 ], [ 26.419994354248047, 39.325828552246094 ] ] ], [ [ [ 23.724441528320312, 39.071388244628906 ], [ 23.660276412963867, 39.089439392089844 ], [ 23.594858169555664, 39.204925537109375 ], [ 23.787359237670898, 39.118259429931641 ], [ 23.724441528320312, 39.071388244628906 ] ] ], [ [ [ 1.371944427490234, 38.830825805664062 ], [ 1.211944341659546, 38.898330688476562 ], [ 1.294166564941406, 39.031387329101562 ], [ 1.602916598320007, 39.093883514404297 ], [ 1.371944427490234, 38.830825805664062 ] ] ], [ [ [ 24.049999237060547, 38.365829467773438 ], [ 23.642219543457031, 38.41888427734375 ], [ 23.198053359985352, 38.831798553466797 ], [ 22.832843780517578, 38.829124450683594 ], [ 23.304443359375, 39.037284851074219 ], [ 23.591941833496094, 38.764717102050781 ], [ 24.153888702392578, 38.646659851074219 ], [ 24.258260726928711, 38.21728515625 ], [ 24.561246871948242, 38.144302368164062 ], [ 24.564163208007812, 37.987220764160156 ], [ 24.049999237060547, 38.365829467773438 ] ] ], [ [ [ 24.568885803222656, 38.760826110839844 ], [ 24.450275421142578, 38.896942138671875 ], [ 24.483192443847656, 38.97735595703125 ], [ 24.681663513183594, 38.802078247070312 ], [ 24.568885803222656, 38.760826110839844 ] ] ], [ [ [ 20.701385498046875, 38.834716796875 ], [ 20.722080230712891, 38.627147674560547 ], [ 20.543191909790039, 38.566104888916016 ], [ 20.601665496826172, 38.778884887695312 ], [ 20.701385498046875, 38.834716796875 ] ] ], [ [ [ -27.138614654541016, 38.629440307617188 ], [ -27.351390838623047, 38.681663513183594 ], [ -27.385002136230469, 38.763328552246094 ], [ -27.065834045410156, 38.76416015625 ], [ -27.138614654541016, 38.629440307617188 ] ] ], [ [ [ -27.810836791992188, 38.539993286132812 ], [ -28.194168090820312, 38.650276184082031 ], [ -28.315555572509766, 38.748603820800781 ], [ -27.761459350585938, 38.547981262207031 ], [ -27.810836791992188, 38.539993286132812 ] ] ], [ [ [ 1.390277624130249, 38.643325805664062 ], [ 1.399166584014893, 38.737777709960938 ], [ 1.587360978126526, 38.669857025146484 ], [ 1.459860920906067, 38.686248779296875 ], [ 1.390277624130249, 38.643325805664062 ] ] ], [ [ [ -28.636112213134766, 38.510276794433594 ], [ -28.758892059326172, 38.517776489257812 ], [ -28.845836639404297, 38.595134735107422 ], [ -28.631528854370117, 38.608329772949219 ], [ -28.636112213134766, 38.510276794433594 ] ] ], [ [ [ 26.014720916748047, 38.149436950683594 ], [ 25.86332893371582, 38.239849090576172 ], [ 25.991664886474609, 38.343879699707031 ], [ 25.86583137512207, 38.584999084472656 ], [ 26.159580230712891, 38.542072296142578 ], [ 26.014720916748047, 38.149436950683594 ] ] ], [ [ [ -28.246669769287109, 38.371940612792969 ], [ -28.459722518920898, 38.4052734375 ], [ -28.549446105957031, 38.5272216796875 ], [ -28.036876678466797, 38.414165496826172 ], [ -28.246669769287109, 38.371940612792969 ] ] ], [ [ [ 20.719718933105469, 38.305274963378906 ], [ 20.614303588867188, 38.469718933105469 ], [ 20.652776718139648, 38.500690460205078 ], [ 20.760692596435547, 38.323467254638672 ], [ 20.719718933105469, 38.305274963378906 ] ] ], [ [ [ 20.571109771728516, 38.468048095703125 ], [ 20.812637329101562, 38.114925384521484 ], [ 20.79347038269043, 38.063259124755859 ], [ 20.342567443847656, 38.177909851074219 ], [ 20.571109771728516, 38.468048095703125 ] ] ], [ [ [ 12.441665649414062, 37.806106567382812 ], [ 12.733610153198242, 38.139717102050781 ], [ 12.923610687255859, 38.024860382080078 ], [ 13.318610191345215, 38.217494964599609 ], [ 13.791110992431641, 37.972221374511719 ], [ 15.647936820983887, 38.264575958251953 ], [ 15.092498779296875, 37.490272521972656 ], [ 15.316665649414062, 37.008888244628906 ], [ 15.081388473510742, 36.649162292480469 ], [ 13.155971527099609, 37.491245269775391 ], [ 12.656109809875488, 37.559783935546875 ], [ 12.441665649414062, 37.806106567382812 ] ] ], [ [ [ 23.501110076904297, 37.999160766601562 ], [ 23.538747787475586, 37.919303894042969 ], [ 23.407358169555664, 37.894298553466797 ], [ 23.437496185302734, 37.985832214355469 ], [ 23.501110076904297, 37.999160766601562 ] ] ], [ [ [ 24.960277557373047, 37.685554504394531 ], [ 24.715137481689453, 37.873050689697266 ], [ 24.694580078125, 37.962635040283203 ], [ 24.962776184082031, 37.87249755859375 ], [ 24.960277557373047, 37.685554504394531 ] ] ], [ [ [ 20.836109161376953, 37.646385192871094 ], [ 20.628608703613281, 37.813190460205078 ], [ 20.643329620361328, 37.898330688476562 ], [ 20.998607635498047, 37.713882446289062 ], [ 20.836109161376953, 37.646385192871094 ] ] ], [ [ [ -25.456111907958984, 37.705551147460938 ], [ -25.711391448974609, 37.744720458984375 ], [ -25.854167938232422, 37.883888244628906 ], [ -25.140556335449219, 37.840690612792969 ], [ -25.456111907958984, 37.705551147460938 ] ] ], [ [ [ 26.818050384521484, 37.63665771484375 ], [ 26.572219848632812, 37.732353210449219 ], [ 27.066940307617188, 37.727218627929688 ], [ 27.063676834106445, 37.707351684570312 ], [ 26.818050384521484, 37.63665771484375 ] ] ], [ [ [ 25.984161376953125, 37.506942749023438 ], [ 26.066246032714844, 37.630966186523438 ], [ 26.358676910400391, 37.683948516845703 ], [ 26.214992523193359, 37.558883666992188 ], [ 25.984161376953125, 37.506942749023438 ] ] ], [ [ [ 24.285274505615234, 37.52471923828125 ], [ 24.299581527709961, 37.656387329101562 ], [ 24.3941650390625, 37.673332214355469 ], [ 24.381385803222656, 37.596939086914062 ], [ 24.285274505615234, 37.52471923828125 ] ] ], [ [ [ 25.053882598876953, 37.675819396972656 ], [ 25.238887786865234, 37.621940612792969 ], [ 25.229999542236328, 37.535408020019531 ], [ 24.976387023925781, 37.674026489257812 ], [ 25.053882598876953, 37.675819396972656 ] ] ], [ [ [ 24.440830230712891, 37.470832824707031 ], [ 24.482498168945312, 37.395965576171875 ], [ 24.377012252807617, 37.306385040283203 ], [ 24.369998931884766, 37.429508209228516 ], [ 24.440830230712891, 37.470832824707031 ] ] ], [ [ [ 25.452770233154297, 36.918319702148438 ], [ 25.341939926147461, 37.073467254638672 ], [ 25.541872024536133, 37.1976318359375 ], [ 25.580272674560547, 37.015548706054688 ], [ 25.452770233154297, 36.918319702148438 ] ] ], [ [ [ 25.191383361816406, 36.973884582519531 ], [ 25.109996795654297, 37.057212829589844 ], [ 25.268604278564453, 37.13861083984375 ], [ 25.250274658203125, 37.008323669433594 ], [ 25.191383361816406, 36.973884582519531 ] ] ], [ [ [ 26.975551605224609, 36.924430847167969 ], [ 26.919166564941406, 36.946662902832031 ], [ 26.887565612792969, 37.073738098144531 ], [ 27.049161911010742, 36.992080688476562 ], [ 26.975551605224609, 36.924430847167969 ] ] ], [ [ [ -25.018890380859375, 36.929161071777344 ], [ -25.167779922485352, 36.943191528320312 ], [ -25.198057174682617, 36.994304656982422 ], [ -25.054792404174805, 37.015758514404297 ], [ -25.018890380859375, 36.929161071777344 ] ] ], [ [ [ 26.971385955810547, 36.672210693359375 ], [ 26.919857025146484, 36.758186340332031 ], [ 27.062496185302734, 36.838043212890625 ], [ 27.354717254638672, 36.863811492919922 ], [ 26.971385955810547, 36.672210693359375 ] ] ], [ [ [ 25.357776641845703, 36.644996643066406 ], [ 25.258609771728516, 36.7288818359375 ], [ 25.277494430541992, 36.782356262207031 ], [ 25.40777587890625, 36.716518402099609 ], [ 25.357776641845703, 36.644996643066406 ] ] ], [ [ [ 24.330829620361328, 36.649993896484375 ], [ 24.350969314575195, 36.746940612792969 ], [ 24.548748016357422, 36.757911682128906 ], [ 24.53944206237793, 36.677562713623047 ], [ 24.330829620361328, 36.649993896484375 ] ] ], [ [ [ 26.466659545898438, 36.576377868652344 ], [ 26.315271377563477, 36.504852294921875 ], [ 26.263326644897461, 36.589572906494141 ], [ 26.382913589477539, 36.640407562255859 ], [ 26.466659545898438, 36.576377868652344 ] ] ], [ [ [ 28.207221984863281, 36.442489624023438 ], [ 28.063606262207031, 36.111930847167969 ], [ 27.73124885559082, 35.913051605224609 ], [ 27.804443359375, 36.269439697265625 ], [ 28.207221984863281, 36.442489624023438 ] ] ], [ [ [ 22.956943511962891, 36.377494812011719 ], [ 23.108329772949219, 36.2369384765625 ], [ 23.044094085693359, 36.136245727539062 ], [ 22.911664962768555, 36.201107025146484 ], [ 22.956943511962891, 36.377494812011719 ] ] ], [ [ [ 14.519721984863281, 35.799995422363281 ], [ 14.347221374511719, 35.87249755859375 ], [ 14.329095840454102, 35.978466033935547 ], [ 14.563888549804688, 35.877777099609375 ], [ 14.519721984863281, 35.799995422363281 ] ] ], [ [ [ 27.142219543457031, 35.39971923828125 ], [ 27.06694221496582, 35.606662750244141 ], [ 27.229721069335938, 35.825412750244141 ], [ 27.202220916748047, 35.478050231933594 ], [ 27.142219543457031, 35.39971923828125 ] ] ], [ [ [ 23.681941986083984, 35.224441528320312 ], [ 23.520553588867188, 35.294998168945312 ], [ 23.741872787475586, 35.686317443847656 ], [ 23.848539352416992, 35.522983551025391 ], [ 24.176387786865234, 35.588886260986328 ], [ 24.107065200805664, 35.492214202880859 ], [ 24.327081680297852, 35.351383209228516 ], [ 25.765726089477539, 35.329959869384766 ], [ 25.784027099609375, 35.113887786865234 ], [ 26.301109313964844, 35.283050537109375 ], [ 26.135831832885742, 34.997287750244141 ], [ 25.016941070556641, 34.930831909179688 ], [ 24.392498016357422, 35.188884735107422 ], [ 23.681941986083984, 35.224441528320312 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "Africa" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ 0.694651007652283, 5.773365020751953 ], [ 0.635833263397217, 5.944513320922852 ], [ 0.506461620330811, 6.058594703674316 ], [ 0.405138850212097, 6.08104133605957 ], [ 0.311319380998611, 6.058575630187988 ], [ 0.217222213745117, 6.098194122314453 ], [ 0.353749960660934, 6.023333072662354 ], [ 0.430416643619537, 6.069791316986084 ], [ 0.574999928474426, 5.991944313049316 ], [ 0.663749933242798, 5.75993013381958 ], [ 0.255833327770233, 5.757777214050293 ], [ -2.058888912200928, 4.730833053588867 ], [ -3.148611545562744, 5.095832824707031 ], [ -2.847951412200928, 5.146839618682861 ], [ -3.136111259460449, 5.142221450805664 ], [ -3.14020848274231, 5.364305019378662 ], [ -3.297986268997192, 5.119166374206543 ], [ -4.003541946411133, 5.25666618347168 ], [ -3.734722375869751, 5.25916576385498 ], [ -3.754444599151611, 5.35333251953125 ], [ -3.811736106872559, 5.37263822555542 ], [ -3.738750219345093, 5.276041030883789 ], [ -4.468056201934814, 5.295555114746094 ], [ -4.80750036239624, 5.17652702331543 ], [ -4.00569486618042, 5.230971813201904 ], [ -4.893889427185059, 5.128610610961914 ], [ -5.026667594909668, 5.2147216796875 ], [ -5.322916984558105, 5.228957653045654 ], [ -5.360486507415771, 5.118471622467041 ], [ -5.014204978942871, 5.12522554397583 ], [ -5.897500514984131, 5.020138740539551 ], [ -7.436389446258545, 4.349166393280029 ], [ -8.242154121398926, 4.5708327293396 ], [ -9.238889694213867, 5.122776985168457 ], [ -10.371945381164551, 6.162221908569336 ], [ -10.764167785644531, 6.271110534667969 ], [ -11.463335037231445, 6.908055305480957 ], [ -12.504167556762695, 7.388610363006592 ], [ -12.184306144714355, 7.591041088104248 ], [ -12.460556983947754, 7.555416107177734 ], [ -12.958959579467773, 7.903263568878174 ], [ -12.974334716796875, 8.247768402099609 ], [ -13.132778167724609, 8.194999694824219 ], [ -13.285000801086426, 8.49756908416748 ], [ -13.055903434753418, 8.369582176208496 ], [ -13.095556259155273, 8.48527717590332 ], [ -12.897500991821289, 8.567777633666992 ], [ -13.189444541931152, 8.556943893432617 ], [ -13.132223129272461, 8.861944198608398 ], [ -13.493133544921875, 9.560075759887695 ], [ -13.679512023925781, 9.541465759277344 ], [ -13.688638687133789, 9.952190399169922 ], [ -13.822361946105957, 9.849443435668945 ], [ -14.457500457763672, 10.293609619140625 ], [ -14.53582763671875, 10.506673812866211 ], [ -14.660696029663086, 10.473331451416016 ], [ -14.516528129577637, 10.842777252197266 ], [ -14.698611259460449, 10.640483856201172 ], [ -14.818889617919922, 10.917499542236328 ], [ -14.690417289733887, 11.028887748718262 ], [ -15.005416870117188, 10.771943092346191 ], [ -15.115695953369141, 10.977638244628906 ], [ -15.02277946472168, 11.195276260375977 ], [ -15.232917785644531, 10.995901107788086 ], [ -15.208820343017578, 11.229755401611328 ], [ -15.353472709655762, 11.141804695129395 ], [ -15.426667213439941, 11.287428855895996 ], [ -15.265279769897461, 11.425912857055664 ], [ -15.50114631652832, 11.33281135559082 ], [ -15.282084465026855, 11.619304656982422 ], [ -15.027223587036133, 11.594165802001953 ], [ -15.339035034179688, 11.681463241577148 ], [ -15.444340705871582, 11.55312442779541 ], [ -15.423528671264648, 11.683666229248047 ], [ -15.556112289428711, 11.725415229797363 ], [ -15.458612442016602, 11.865276336669922 ], [ -15.130834579467773, 11.893331527709961 ], [ -15.0665283203125, 11.802637100219727 ], [ -14.955972671508789, 11.746944427490234 ], [ -14.991111755371094, 11.958053588867188 ], [ -15.43083381652832, 11.958887100219727 ], [ -15.959444999694824, 11.735276222229004 ], [ -15.705810546875, 12.009904861450195 ], [ -16.202777862548828, 11.905553817749023 ], [ -16.349723815917969, 12.105833053588867 ], [ -16.115280151367188, 12.333332061767578 ], [ -16.455280303955078, 12.171804428100586 ], [ -16.793195724487305, 12.422915458679199 ], [ -16.583751678466797, 12.632637977600098 ], [ -16.37437629699707, 12.545414924621582 ], [ -15.634444236755371, 12.531040191650391 ], [ -15.509305953979492, 12.637082099914551 ], [ -15.529862403869629, 12.782081604003906 ], [ -15.391806602478027, 12.832915306091309 ], [ -15.526876449584961, 12.805763244628906 ], [ -15.645625114440918, 12.557082176208496 ], [ -16.021377563476562, 12.724939346313477 ], [ -16.421667098999023, 12.576804161071777 ], [ -16.593959808349609, 12.783332824707031 ], [ -16.752918243408203, 12.56472110748291 ], [ -16.821666717529297, 13.323331832885742 ], [ -16.709932327270508, 13.471735000610352 ], [ -16.554723739624023, 13.295068740844727 ], [ -16.194725036621094, 13.25263786315918 ], [ -16.155904769897461, 13.424860000610352 ], [ -15.328334808349609, 13.438610076904297 ], [ -15.305764198303223, 13.451526641845703 ], [ -15.297176361083984, 13.491054534912109 ], [ -15.547223091125488, 13.528679847717285 ], [ -16.513336181640625, 13.368610382080078 ], [ -16.642152786254883, 13.696873664855957 ], [ -16.490837097167969, 13.958054542541504 ], [ -16.69843864440918, 13.770449638366699 ], [ -16.74534797668457, 13.953471183776855 ], [ -16.638889312744141, 13.961666107177734 ], [ -16.367431640625, 14.166388511657715 ], [ -16.775836944580078, 14.01249885559082 ], [ -17.175556182861328, 14.654443740844727 ], [ -17.532779693603516, 14.750137329101562 ], [ -17.129169464111328, 14.931110382080078 ], [ -16.546390533447266, 15.75666618347168 ], [ -16.467641830444336, 16.611387252807617 ], [ -16.039447784423828, 17.734580993652344 ], [ -16.179168701171875, 18.913055419921875 ], [ -16.511669158935547, 19.352218627929688 ], [ -16.3094482421875, 19.467498779296875 ], [ -16.461736679077148, 19.410066604614258 ], [ -16.196807861328125, 20.226108551025391 ], [ -16.923681259155273, 21.158470153808594 ], [ -17.101528167724609, 20.837429046630859 ], [ -16.916252136230469, 21.945415496826172 ], [ -16.362709045410156, 22.564582824707031 ], [ -15.779446601867676, 23.909439086914062 ], [ -15.993976593017578, 23.648504257202148 ], [ -15.933055877685547, 23.788055419921875 ], [ -14.90090274810791, 24.68964958190918 ], [ -14.483333587646484, 26.163330078125 ], [ -13.574167251586914, 26.731666564941406 ], [ -12.962709426879883, 27.92048454284668 ], [ -11.511945724487305, 28.303747177124023 ], [ -10.228196144104004, 29.317914962768555 ], [ -9.640973091125488, 30.164997100830078 ], [ -9.608403205871582, 30.402498245239258 ], [ -9.853889465332031, 30.726943969726562 ], [ -9.809167861938477, 31.446662902832031 ], [ -9.277778625488281, 32.183609008789062 ], [ -9.279340744018555, 32.543952941894531 ], [ -8.538333892822266, 33.25054931640625 ], [ -6.843055725097656, 34.018608093261719 ], [ -5.918744087219238, 35.7906494140625 ], [ -5.45555591583252, 35.914440155029297 ], [ -5.307649612426758, 35.885791778564453 ], [ -5.248958587646484, 35.574371337890625 ], [ -4.695834159851074, 35.208885192871094 ], [ -3.336250305175781, 35.191383361816406 ], [ -2.986111164093018, 35.418052673339844 ], [ -2.834861278533936, 35.125133514404297 ], [ -2.883680820465088, 35.234577178955078 ], [ -1.979722261428833, 35.073326110839844 ], [ -1.352222442626953, 35.322494506835938 ], [ -1.03583025932312, 35.67694091796875 ], [ -0.373125046491623, 35.902774810791016 ], [ -0.106666676700115, 35.784023284912109 ], [ 0.204166650772095, 36.10333251953125 ], [ 1.182499885559082, 36.512214660644531 ], [ 2.572499752044678, 36.589160919189453 ], [ 2.900207996368408, 36.794784545898438 ], [ 3.901666402816772, 36.914718627929688 ], [ 4.788749217987061, 36.893886566162109 ], [ 5.328055381774902, 36.640274047851562 ], [ 6.398332595825195, 37.086387634277344 ], [ 6.920415878295898, 36.884300231933594 ], [ 7.292499542236328, 37.077220916748047 ], [ 7.932221412658691, 36.844444274902344 ], [ 9.858680725097656, 37.328334808349609 ], [ 9.808313369750977, 37.150772094726562 ], [ 10.254859924316406, 37.179580688476562 ], [ 10.132012367248535, 37.145515441894531 ], [ 10.344235420227051, 36.877147674560547 ], [ 10.192776679992676, 36.810829162597656 ], [ 10.336943626403809, 36.735137939453125 ], [ 11.039373397827148, 37.085968017578125 ], [ 11.10222053527832, 36.904441833496094 ], [ 10.796387672424316, 36.465343475341797 ], [ 10.512777328491211, 36.351104736328125 ], [ 10.456178665161133, 36.117355346679688 ], [ 10.685832977294922, 35.788604736328125 ], [ 11.027082443237305, 35.637355804443359 ], [ 11.126665115356445, 35.241943359375 ], [ 10.731388092041016, 34.670276641845703 ], [ 10.007082939147949, 34.168605804443359 ], [ 10.266387939453125, 33.748603820800781 ], [ 10.715970993041992, 33.70416259765625 ], [ 10.751666069030762, 33.473743438720703 ], [ 11.055832862854004, 33.612636566162109 ], [ 11.174304008483887, 33.210063934326172 ], [ 12.301248550415039, 32.837776184082031 ], [ 13.251110076904297, 32.918888092041016 ], [ 15.165833473205566, 32.398605346679688 ], [ 15.754304885864258, 31.389720916748047 ], [ 17.367219924926758, 31.082220077514648 ], [ 18.957498550415039, 30.276386260986328 ], [ 19.617774963378906, 30.417221069335938 ], [ 20.057638168334961, 30.850830078125 ], [ 20.155551910400391, 31.149997711181641 ], [ 19.919580459594727, 31.748189926147461 ], [ 20.084442138671875, 32.184715270996094 ], [ 20.567626953125, 32.5609130859375 ], [ 21.713886260986328, 32.944442749023438 ], [ 23.119163513183594, 32.6197509765625 ], [ 23.085100173950195, 32.332111358642578 ], [ 23.247196197509766, 32.216224670410156 ], [ 24.982637405395508, 31.966526031494141 ], [ 25.173887252807617, 31.540760040283203 ], [ 25.947219848632812, 31.617774963378906 ], [ 27.323192596435547, 31.376108169555664 ], [ 27.438888549804688, 31.222774505615234 ], [ 27.84416389465332, 31.243749618530273 ], [ 27.92138671875, 31.098052978515625 ], [ 28.429721832275391, 31.078887939453125 ], [ 29.034999847412109, 30.824165344238281 ], [ 30.064441680908203, 31.320274353027344 ], [ 30.289718627929688, 31.237358093261719 ], [ 30.355449676513672, 31.502843856811523 ], [ 30.956110000610352, 31.575693130493164 ], [ 30.59388542175293, 31.380275726318359 ], [ 31.126455307006836, 31.496664047241211 ], [ 31.01222038269043, 31.597011566162109 ], [ 31.556941986083984, 31.442218780517578 ], [ 31.8717041015625, 31.534917831420898 ], [ 31.921480178833008, 31.529884338378906 ], [ 32.202491760253906, 31.290933609008789 ], [ 31.909650802612305, 31.527566909790039 ], [ 31.777462005615234, 31.277393341064453 ], [ 32.14306640625, 31.074165344238281 ], [ 32.279788970947266, 31.124303817749023 ], [ 32.214752197265625, 31.282426834106445 ], [ 32.711799621582031, 31.033538818359375 ], [ 34.216659545898438, 31.323329925537109 ], [ 34.903800964355469, 29.486705780029297 ], [ 34.254440307617188, 27.728610992431641 ], [ 33.242774963378906, 28.554443359375 ], [ 33.172561645507812, 28.995067596435547 ], [ 32.741386413574219, 29.454719543457031 ], [ 32.575618743896484, 30.002706527709961 ], [ 32.340827941894531, 29.594860076904297 ], [ 32.596382141113281, 29.340553283691406 ], [ 32.688606262207031, 28.867774963378906 ], [ 33.558883666992188, 27.883052825927734 ], [ 33.494720458984375, 27.643886566162109 ], [ 33.837356567382812, 27.236663818359375 ], [ 33.938327789306641, 26.655275344848633 ], [ 35.13861083984375, 24.517498016357422 ], [ 35.811176300048828, 23.907011032104492 ], [ 35.485832214355469, 23.942914962768555 ], [ 35.668888092041016, 22.970693588256836 ], [ 36.886245727539062, 22.053194046020508 ], [ 36.911384582519531, 21.608608245849609 ], [ 37.306591033935547, 21.063261032104492 ], [ 37.103187561035156, 21.207914352416992 ], [ 37.435688018798828, 18.853887557983398 ], [ 38.589023590087891, 18.066802978515625 ], [ 39.001937866210938, 17.188610076904297 ], [ 39.270137786865234, 15.986248970031738 ], [ 39.718051910400391, 15.088054656982422 ], [ 39.881385803222656, 15.489442825317383 ], [ 40.175411224365234, 14.971110343933105 ], [ 40.454856872558594, 15.007776260375977 ], [ 40.807220458984375, 14.705554962158203 ], [ 41.172218322753906, 14.630693435668945 ], [ 41.677219390869141, 13.93638801574707 ], [ 42.284580230712891, 13.573471069335938 ], [ 42.373813629150391, 13.217915534973145 ], [ 42.804718017578125, 12.844999313354492 ], [ 43.077980041503906, 12.828956604003906 ], [ 43.327495574951172, 12.476728439331055 ], [ 43.370903015136719, 11.993263244628906 ], [ 42.531524658203125, 11.511942863464355 ], [ 43.157218933105469, 11.570833206176758 ], [ 44.278327941894531, 10.447776794433594 ], [ 44.892078399658203, 10.421526908874512 ], [ 45.758884429931641, 10.872984886169434 ], [ 46.453330993652344, 10.689999580383301 ], [ 47.396663665771484, 11.178956985473633 ], [ 48.125690460205078, 11.135137557983398 ], [ 48.521385192871094, 11.315553665161133 ], [ 48.987220764160156, 11.245832443237305 ], [ 50.093189239501953, 11.514582633972168 ], [ 50.769439697265625, 11.979166030883789 ], [ 51.278327941894531, 11.816665649414062 ], [ 51.076385498046875, 11.328054428100586 ], [ 51.145553588867188, 10.633609771728516 ], [ 51.017215728759766, 10.44666576385498 ], [ 51.189437866210938, 10.538055419921875 ], [ 51.391246795654297, 10.397359848022461 ], [ 50.895828247070312, 10.312221527099609 ], [ 50.838539123535156, 9.437870979309082 ], [ 49.829299926757812, 7.946110725402832 ], [ 49.04083251953125, 6.149722099304199 ], [ 48.000553131103516, 4.523055076599121 ], [ 46.025550842285156, 2.437222003936768 ], [ 44.544994354248047, 1.551944255828857 ], [ 43.488609313964844, 0.649998784065247 ], [ 42.066665649414062, -0.896111130714417 ], [ 41.315277099609375, -1.958055734634399 ], [ 40.89166259765625, -2.019166946411133 ], [ 40.958469390869141, -2.304375171661377 ], [ 40.854995727539062, -2.236111164093018 ], [ 40.630481719970703, -2.552847385406494 ], [ 40.231109619140625, -2.671111345291138 ], [ 40.125480651855469, -3.265694618225098 ], [ 39.402496337890625, -4.633889198303223 ], [ 39.203025817871094, -4.669617652893066 ], [ 38.776107788085938, -6.039722919464111 ], [ 38.870830535888672, -6.385278224945068 ], [ 39.547882080078125, -6.99431324005127 ], [ 39.288330078125, -7.498888969421387 ], [ 39.299720764160156, -7.757778167724609 ], [ 39.446662902832031, -7.814167022705078 ], [ 39.2952880859375, -8.267862319946289 ], [ 39.791107177734375, -9.92388916015625 ], [ 40.584442138671875, -10.654167175292969 ], [ 40.387771606445312, -11.317779541015625 ], [ 40.474159240722656, -12.504931449890137 ], [ 40.645969390869141, -12.755416870117188 ], [ 40.412773132324219, -12.969236373901367 ], [ 40.592910766601562, -12.970694541931152 ], [ 40.649715423583984, -14.02166748046875 ], [ 40.532772064208984, -14.167500495910645 ], [ 40.722774505615234, -14.202084541320801 ], [ 40.6361083984375, -14.484724044799805 ], [ 40.821109771728516, -14.423473358154297 ], [ 40.84527587890625, -14.734167098999023 ], [ 40.514442443847656, -15.183890342712402 ], [ 40.684299468994141, -15.254861831665039 ], [ 40.578330993652344, -15.498889923095703 ], [ 39.782634735107422, -16.305557250976562 ], [ 39.6986083984375, -16.536945343017578 ], [ 39.096179962158203, -16.984376907348633 ], [ 37.853050231933594, -17.385833740234375 ], [ 36.98388671875, -18.001392364501953 ], [ 36.846385955810547, -17.875556945800781 ], [ 36.943885803222656, -18.108612060546875 ], [ 36.252777099609375, -18.891391754150391 ], [ 36.100135803222656, -18.813056945800781 ], [ 34.890689849853516, -19.860418319702148 ], [ 34.626800537109375, -19.618612289428711 ], [ 34.776103973388672, -19.825904846191406 ], [ 34.666938781738281, -20.391181945800781 ], [ 35.111801147460938, -20.933300018310547 ], [ 35.306732177734375, -22.407501220703125 ], [ 35.397216796875, -22.460002899169922 ], [ 35.480552673339844, -22.095800399780273 ], [ 35.545272827148438, -22.232501983642578 ], [ 35.597267150878906, -22.919672012329102 ], [ 35.347770690917969, -23.695278167724609 ], [ 35.3397216796875, -23.969448089599609 ], [ 35.522911071777344, -23.795488357543945 ], [ 35.456108093261719, -24.169445037841797 ], [ 35.012214660644531, -24.654167175292969 ], [ 32.811107635498047, -25.612085342407227 ], [ 32.587150573730469, -25.972433090209961 ], [ 32.843189239501953, -26.291112899780273 ], [ 32.945621490478516, -26.087709426879883 ], [ 32.868331909179688, -27.007503509521484 ], [ 32.394439697265625, -28.531391143798828 ], [ 31.325832366943359, -29.390834808349609 ], [ 30.023887634277344, -31.281112670898438 ], [ 27.899997711181641, -33.040557861328125 ], [ 26.530551910400391, -33.753334045410156 ], [ 25.724998474121094, -33.767227172851562 ], [ 25.701942443847656, -34.031951904296875 ], [ 25.022636413574219, -33.968055725097656 ], [ 24.824718475341797, -34.201667785644531 ], [ 23.649303436279297, -33.983894348144531 ], [ 23.366178512573242, -34.090904235839844 ], [ 22.539163589477539, -34.011184692382812 ], [ 21.802497863769531, -34.383056640625 ], [ 20.504444122314453, -34.464729309082031 ], [ 20.0, -34.822002410888672 ], [ 19.320413589477539, -34.595283508300781 ], [ 19.278192520141602, -34.409172058105469 ], [ 18.819719314575195, -34.378894805908203 ], [ 18.799026489257812, -34.088893890380859 ], [ 18.485969543457031, -34.099445343017578 ], [ 18.485027313232422, -34.348308563232422 ], [ 18.380275726318359, -34.255836486816406 ], [ 18.43902587890625, -33.701950073242188 ], [ 17.847499847412109, -32.830833435058594 ], [ 18.308609008789062, -32.585697174072266 ], [ 18.217914581298828, -31.734584808349609 ], [ 17.277914047241211, -30.342292785644531 ], [ 16.818330764770508, -29.094375610351562 ], [ 16.489589691162109, -28.578178405761719 ], [ 15.689722061157227, -27.956111907958984 ], [ 15.094999313354492, -26.735279083251953 ], [ 15.171804428100586, -26.601667404174805 ], [ 14.834304809570312, -25.741947174072266 ], [ 14.85666561126709, -25.058889389038086 ], [ 14.462637901306152, -24.103336334228516 ], [ 14.511388778686523, -22.552780151367188 ], [ 13.403887748718262, -20.862363815307617 ], [ 12.460832595825195, -18.928058624267578 ], [ 11.767638206481934, -17.988195419311523 ], [ 11.73124885559082, -15.850695610046387 ], [ 12.014999389648438, -15.56944465637207 ], [ 12.512706756591797, -13.424375534057617 ], [ 12.969999313354492, -12.784444808959961 ], [ 13.459158897399902, -12.508607864379883 ], [ 13.764165878295898, -11.936112403869629 ], [ 13.849443435668945, -10.956111907958984 ], [ 12.984582901000977, -9.08125114440918 ], [ 13.38749885559082, -8.740278244018555 ], [ 13.391804695129395, -8.393750190734863 ], [ 12.817777633666992, -6.950278282165527 ], [ 12.246249198913574, -6.103611469268799 ], [ 13.17888069152832, -5.856329917907715 ], [ 12.897915840148926, -5.811944961547852 ], [ 12.435832977294922, -6.016667366027832 ], [ 12.264999389648438, -5.86472225189209 ], [ 12.176109313964844, -5.323333740234375 ], [ 11.774166107177734, -4.54263973236084 ], [ 9.702498435974121, -2.447916746139526 ], [ 10.016109466552734, -2.639722347259521 ], [ 10.133471488952637, -2.523889303207397 ], [ 9.610971450805664, -2.370694637298584 ], [ 9.322498321533203, -1.907500028610229 ], [ 9.536873817443848, -2.068403005599976 ], [ 9.518054962158203, -1.926944494247437 ], [ 9.262776374816895, -1.849444508552551 ], [ 8.985485076904297, -1.243055701255798 ], [ 9.016393661499023, -1.306905508041382 ], [ 9.233331680297852, -1.530277967453003 ], [ 9.291110992431641, -1.638889074325562 ], [ 9.513887405395508, -1.596666812896729 ], [ 9.288331985473633, -1.570416808128357 ], [ 9.251388549804688, -1.498611211776733 ], [ 9.336943626403809, -1.399722337722778 ], [ 9.352777481079102, -1.341944456100464 ], [ 9.333436012268066, -1.285590291023254 ], [ 9.22472095489502, -1.411250114440918 ], [ 9.026665687561035, -1.297639012336731 ], [ 8.709999084472656, -0.641111135482788 ], [ 9.007776260375977, -0.813888967037201 ], [ 9.298332214355469, -0.371666669845581 ], [ 9.350832939147949, 0.362013846635818 ], [ 9.466943740844727, 0.167222201824188 ], [ 9.746526718139648, 0.116249993443489 ], [ 9.921110153198242, 0.185277760028839 ], [ 9.497707366943359, 0.293680518865585 ], [ 9.305137634277344, 0.580972194671631 ], [ 9.542221069335938, 0.67249995470047 ], [ 9.599998474121094, 0.481111109256744 ], [ 9.572012901306152, 0.996597111225128 ], [ 9.845901489257812, 1.074722170829773 ], [ 9.360276222229004, 1.174722075462341 ], [ 9.813401222229004, 1.929791569709778 ], [ 9.965137481689453, 3.085208177566528 ], [ 9.543054580688477, 3.811527490615845 ], [ 9.722499847412109, 3.865277767181396 ], [ 9.48836612701416, 4.112915992736816 ], [ 9.434999465942383, 3.899444341659546 ], [ 8.974096298217773, 4.099791049957275 ], [ 8.898611068725586, 4.588333129882812 ], [ 8.666387557983398, 4.681388854980469 ], [ 8.714165687561035, 4.502638339996338 ], [ 8.508401870727539, 4.52354097366333 ], [ 8.585213661193848, 4.820409297943115 ], [ 8.506942749023438, 4.699860572814941 ], [ 8.274721145629883, 4.856666564941406 ], [ 8.293679237365723, 4.547499656677246 ], [ 7.695277214050293, 4.497499465942383 ], [ 7.537221431732178, 4.539999485015869 ], [ 7.55040454864502, 4.706555366516113 ], [ 7.272499084472656, 4.557777404785156 ], [ 7.074305057525635, 4.753055095672607 ], [ 7.179443836212158, 4.506943702697754 ], [ 7.073055267333984, 4.434721946716309 ], [ 6.963888645172119, 4.724860668182373 ], [ 7.008679866790771, 4.371318817138672 ], [ 6.871665954589844, 4.392638683319092 ], [ 6.76284646987915, 4.763472080230713 ], [ 6.848610877990723, 4.348332405090332 ], [ 6.720485210418701, 4.348194122314453 ], [ 6.732429981231689, 4.603540897369385 ], [ 6.692360401153564, 4.331805229187012 ], [ 6.251179695129395, 4.301561832427979 ], [ 6.252777576446533, 4.449999332427979 ], [ 6.172222137451172, 4.282776832580566 ], [ 5.935832500457764, 4.338333129882812 ], [ 5.582360744476318, 4.655832767486572 ], [ 5.384235382080078, 5.116527080535889 ], [ 5.493402004241943, 5.1449294090271 ], [ 5.368332862854004, 5.160554885864258 ], [ 5.345276832580566, 5.329999923706055 ], [ 5.539721488952637, 5.414721488952637 ], [ 5.636041164398193, 5.536735534667969 ], [ 5.26194429397583, 5.433194160461426 ], [ 5.214791297912598, 5.577638149261475 ], [ 5.502499580383301, 5.616943836212158 ], [ 5.182082653045654, 5.574860572814941 ], [ 4.410207748413086, 6.359930038452148 ], [ 3.391319036483765, 6.445138454437256 ], [ 3.80722188949585, 6.612777709960938 ], [ 3.443055152893066, 6.578332901000977 ], [ 3.319166660308838, 6.385555267333984 ], [ 1.468888759613037, 6.186388492584229 ], [ 1.098888874053955, 6.040277481079102 ], [ 0.944999933242798, 5.78083324432373 ], [ 0.694651007652283, 5.773365020751953 ] ] ], [ [ [ 11.128887176513672, 34.668609619140625 ], [ 11.237984657287598, 34.822841644287109 ], [ 11.302221298217773, 34.803329467773438 ], [ 11.282360076904297, 34.742774963378906 ], [ 11.128887176513672, 34.668609619140625 ] ] ], [ [ [ 10.864999771118164, 33.63861083984375 ], [ 10.719165802001953, 33.730827331542969 ], [ 10.735137939453125, 33.890415191650391 ], [ 11.052637100219727, 33.807632446289062 ], [ 10.864999771118164, 33.63861083984375 ] ] ], [ [ [ -16.943611145019531, 32.637496948242188 ], [ -17.195972442626953, 32.7288818359375 ], [ -17.2545166015625, 32.812843322753906 ], [ -16.715557098388672, 32.758888244628906 ], [ -16.943611145019531, 32.637496948242188 ] ] ], [ [ [ -13.773056030273438, 28.837776184082031 ], [ -13.791666984558105, 29.052497863769531 ], [ -13.442501068115234, 29.231666564941406 ], [ -13.48347282409668, 28.995277404785156 ], [ -13.773056030273438, 28.837776184082031 ] ] ], [ [ [ -17.783336639404297, 28.529163360595703 ], [ -18.002918243408203, 28.749721527099609 ], [ -17.906806945800781, 28.84819221496582 ], [ -17.716529846191406, 28.743331909179688 ], [ -17.783336639404297, 28.529163360595703 ] ] ], [ [ [ -14.332778930664062, 28.044441223144531 ], [ -14.444168090820312, 28.069164276123047 ], [ -13.867778778076172, 28.749582290649414 ], [ -13.923055648803711, 28.249164581298828 ], [ -14.332778930664062, 28.044441223144531 ] ] ], [ [ [ -16.671390533447266, 27.984165191650391 ], [ -16.90937614440918, 28.346038818359375 ], [ -16.156948089599609, 28.572219848632812 ], [ -16.418056488037109, 28.145275115966797 ], [ -16.671390533447266, 27.984165191650391 ] ] ], [ [ [ -17.2308349609375, 28.009998321533203 ], [ -17.330558776855469, 28.091110229492188 ], [ -17.255002975463867, 28.206108093261719 ], [ -17.089168548583984, 28.111942291259766 ], [ -17.2308349609375, 28.009998321533203 ] ] ], [ [ [ -15.579168319702148, 27.731109619140625 ], [ -15.815834045410156, 28.001941680908203 ], [ -15.70250129699707, 28.156108856201172 ], [ -15.409407615661621, 28.155902862548828 ], [ -15.394166946411133, 27.844997406005859 ], [ -15.579168319702148, 27.731109619140625 ] ] ], [ [ [ -17.982780456542969, 27.637496948242188 ], [ -18.167503356933594, 27.753608703613281 ], [ -17.907501220703125, 27.848609924316406 ], [ -17.883474349975586, 27.797220230102539 ], [ -17.982780456542969, 27.637496948242188 ] ] ], [ [ [ -16.432502746582031, 19.601387023925781 ], [ -16.46055793762207, 19.696941375732422 ], [ -16.342086791992188, 19.865137100219727 ], [ -16.361251831054688, 19.733331680297852 ], [ -16.432502746582031, 19.601387023925781 ] ] ], [ [ [ -25.281391143798828, 16.913330078125 ], [ -25.332363128662109, 17.094997406005859 ], [ -24.973474502563477, 17.108678817749023 ], [ -25.171392440795898, 16.928333282470703 ], [ -25.281391143798828, 16.913330078125 ] ] ], [ [ [ -24.993335723876953, 16.779720306396484 ], [ -25.082500457763672, 16.858331680297852 ], [ -24.930278778076172, 16.920692443847656 ], [ -24.876253128051758, 16.828470230102539 ], [ -24.993335723876953, 16.779720306396484 ] ] ], [ [ [ -22.923057556152344, 16.590274810791016 ], [ -22.994306564331055, 16.803192138671875 ], [ -22.921529769897461, 16.853191375732422 ], [ -22.87750244140625, 16.671943664550781 ], [ -22.923057556152344, 16.590274810791016 ] ] ], [ [ [ -24.321392059326172, 16.482776641845703 ], [ -24.420001983642578, 16.661941528320312 ], [ -24.024168014526367, 16.572290420532227 ], [ -24.270975112915039, 16.586664199829102 ], [ -24.321392059326172, 16.482776641845703 ] ] ], [ [ [ -22.800556182861328, 15.978054046630859 ], [ -22.962223052978516, 16.044998168945312 ], [ -22.798614501953125, 16.235275268554688 ], [ -22.666112899780273, 16.094997406005859 ], [ -22.800556182861328, 15.978054046630859 ] ] ], [ [ [ 40.0, 15.885777473449707 ], [ 40.141036987304688, 15.801595687866211 ], [ 40.167842864990234, 15.639650344848633 ], [ 40.417076110839844, 15.574860572814941 ], [ 39.980831146240234, 15.60291576385498 ], [ 40.0, 15.885777473449707 ] ] ], [ [ [ -23.167224884033203, 15.115833282470703 ], [ -23.253890991210938, 15.164165496826172 ], [ -23.199445724487305, 15.326525688171387 ], [ -23.113056182861328, 15.234443664550781 ], [ -23.167224884033203, 15.115833282470703 ] ] ], [ [ [ -23.525836944580078, 14.896110534667969 ], [ -23.789516448974609, 15.065415382385254 ], [ -23.695003509521484, 15.294998168945312 ], [ -23.444725036621094, 15.006109237670898 ], [ -23.525836944580078, 14.896110534667969 ] ] ], [ [ [ -24.390003204345703, 14.81110954284668 ], [ -24.524446487426758, 14.918332099914551 ], [ -24.382570266723633, 15.04617977142334 ], [ -24.295558929443359, 14.870553970336914 ], [ -24.390003204345703, 14.81110954284668 ] ] ], [ [ [ -16.085281372070312, 11.753610610961914 ], [ -16.157154083251953, 11.871109962463379 ], [ -15.981112480163574, 11.905693054199219 ], [ -16.029376983642578, 11.758541107177734 ], [ -16.085281372070312, 11.753610610961914 ] ] ], [ [ [ -15.466817855834961, 11.5653076171875 ], [ -15.574032783508301, 11.506784439086914 ], [ -15.63396167755127, 11.535811424255371 ], [ -15.487886428833008, 11.624299049377441 ], [ -15.466817855834961, 11.5653076171875 ] ] ], [ [ [ -16.034725189208984, 11.417221069335938 ], [ -16.014724731445312, 11.546943664550781 ], [ -15.905555725097656, 11.577499389648438 ], [ -15.915000915527344, 11.448610305786133 ], [ -16.034725189208984, 11.417221069335938 ] ] ], [ [ [ -16.312225341796875, 11.47722053527832 ], [ -16.414932250976562, 11.482290267944336 ], [ -16.420139312744141, 11.533123016357422 ], [ -16.243196487426758, 11.575554847717285 ], [ -16.312225341796875, 11.47722053527832 ] ] ], [ [ [ -15.763055801391602, 11.163887023925781 ], [ -15.753055572509766, 11.269721984863281 ], [ -15.662431716918945, 11.301457405090332 ], [ -15.661111831665039, 11.225069046020508 ], [ -15.763055801391602, 11.163887023925781 ] ] ], [ [ [ -16.15472412109375, 11.024721145629883 ], [ -16.243196487426758, 11.103055000305176 ], [ -16.080278396606445, 11.205693244934082 ], [ -16.060001373291016, 11.03972053527832 ], [ -16.15472412109375, 11.024721145629883 ] ] ], [ [ [ -12.885000228881836, 7.614166259765625 ], [ -12.59111213684082, 7.634444236755371 ], [ -12.496251106262207, 7.500833034515381 ], [ -12.559446334838867, 7.420832633972168 ], [ -12.885000228881836, 7.614166259765625 ] ] ], [ [ [ 7.180276870727539, 4.377777099609375 ], [ 7.226110458374023, 4.519999504089355 ], [ 7.316666603088379, 4.472499847412109 ], [ 7.309860706329346, 4.410555362701416 ], [ 7.180276870727539, 4.377777099609375 ] ] ], [ [ [ 8.625042915344238, 3.650001049041748 ], [ 8.960137367248535, 3.701805114746094 ], [ 8.681942939758301, 3.197083234786987 ], [ 8.424582481384277, 3.336944103240967 ], [ 8.625042915344238, 3.650001049041748 ] ] ], [ [ [ 7.399166107177734, 1.530555486679077 ], [ 7.327916145324707, 1.609999895095825 ], [ 7.404582500457764, 1.701249837875366 ], [ 7.462777137756348, 1.634721994400024 ], [ 7.399166107177734, 1.530555486679077 ] ] ], [ [ [ 6.52388858795166, 0.018333330750465 ], [ 6.467222213745117, 0.259722173213959 ], [ 6.687777519226074, 0.402222216129303 ], [ 6.751527309417725, 0.226805537939072 ], [ 6.52388858795166, 0.018333330750465 ] ] ], [ [ [ 9.002222061157227, -0.7688889503479 ], [ 8.946664810180664, -0.658333420753479 ], [ 9.003888130187988, -0.599583387374878 ], [ 9.046526908874512, -0.669305622577667 ], [ 9.002222061157227, -0.7688889503479 ] ] ], [ [ [ 40.99749755859375, -2.203055858612061 ], [ 40.990692138671875, -2.089444637298584 ], [ 41.162425994873047, -2.081111431121826 ], [ 41.016105651855469, -2.148889064788818 ], [ 40.99749755859375, -2.203055858612061 ] ] ], [ [ [ 55.532493591308594, -4.789167404174805 ], [ 55.375411987304688, -4.625139713287354 ], [ 55.463882446289062, -4.551667213439941 ], [ 55.538188934326172, -4.663750648498535 ], [ 55.532493591308594, -4.789167404174805 ] ] ], [ [ [ 39.855632781982422, -5.159406185150146 ], [ 39.794998168945312, -5.407500267028809 ], [ 39.648746490478516, -5.433680534362793 ], [ 39.689437866210938, -4.901111602783203 ], [ 39.870277404785156, -4.914722442626953 ], [ 39.855632781982422, -5.159406185150146 ] ] ], [ [ [ 39.284553527832031, -6.264074325561523 ], [ 39.186386108398438, -5.959722518920898 ], [ 39.311107635498047, -5.724166870117188 ], [ 39.559165954589844, -6.444167137145996 ], [ 39.284553527832031, -6.264074325561523 ] ] ], [ [ [ 39.653053283691406, -7.996945381164551 ], [ 39.592910766601562, -7.949445247650146 ], [ 39.9012451171875, -7.642570018768311 ], [ 39.824996948242188, -7.909167289733887 ], [ 39.653053283691406, -7.996945381164551 ] ] ], [ [ [ 46.2691650390625, -9.463056564331055 ], [ 46.2056884765625, -9.396806716918945 ], [ 46.521312713623047, -9.37743091583252 ], [ 46.476104736328125, -9.422500610351562 ], [ 46.2691650390625, -9.463056564331055 ] ] ], [ [ [ 43.453605651855469, -11.936111450195312 ], [ 43.220134735107422, -11.763473510742188 ], [ 43.286941528320312, -11.378334045410156 ], [ 43.395271301269531, -11.406112670898438 ], [ 43.453605651855469, -11.936111450195312 ] ] ], [ [ [ 47.295829772949219, -11.577777862548828 ], [ 47.282081604003906, -11.574584007263184 ], [ 47.279094696044922, -11.557570457458496 ], [ 47.297149658203125, -11.554098129272461 ], [ 47.295829772949219, -11.577777862548828 ] ] ], [ [ [ 48.031402587890625, -14.063411712646484 ], [ 47.9052734375, -13.596389770507812 ], [ 48.063331604003906, -13.518056869506836 ], [ 48.287216186523438, -13.808055877685547 ], [ 48.337635040283203, -13.550833702087402 ], [ 48.792770385742188, -13.367778778076172 ], [ 48.959442138671875, -12.822223663330078 ], [ 48.733604431152344, -12.437640190124512 ], [ 48.944164276123047, -12.485834121704102 ], [ 49.272216796875, -11.947084426879883 ], [ 49.367359161376953, -12.20583438873291 ], [ 49.232498168945312, -12.225000381469727 ], [ 49.518325805664062, -12.345834732055664 ], [ 49.570621490478516, -12.648771286010742 ], [ 49.943328857421875, -13.039445877075195 ], [ 50.482772827148438, -15.405834197998047 ], [ 50.232215881347656, -15.974445343017578 ], [ 50.033882141113281, -15.866945266723633 ], [ 49.866104125976562, -15.432500839233398 ], [ 49.63360595703125, -15.557500839233398 ], [ 49.681385040283203, -16.055002212524414 ], [ 49.854022979736328, -16.231391906738281 ], [ 49.788604736328125, -16.830280303955078 ], [ 49.596939086914062, -16.908611297607422 ], [ 49.422775268554688, -17.315834045410156 ], [ 49.510276794433594, -17.711391448974609 ], [ 49.368331909179688, -18.351390838623047 ], [ 47.133049011230469, -24.928058624267578 ], [ 45.2147216796875, -25.588336944580078 ], [ 44.017078399658203, -24.9808349609375 ], [ 43.664161682128906, -24.311389923095703 ], [ 43.636383056640625, -23.657779693603516 ], [ 43.759994506835938, -23.468057632446289 ], [ 43.3619384765625, -22.852779388427734 ], [ 43.238883972167969, -22.282501220703125 ], [ 43.50054931640625, -21.333889007568359 ], [ 43.808609008789062, -21.22528076171875 ], [ 44.482772827148438, -19.965835571289062 ], [ 44.370830535888672, -19.77708625793457 ], [ 44.469161987304688, -19.438335418701172 ], [ 44.035690307617188, -18.408058166503906 ], [ 43.931388854980469, -17.500556945800781 ], [ 44.437774658203125, -16.692222595214844 ], [ 44.460273742675781, -16.183891296386719 ], [ 44.873603820800781, -16.210281372070312 ], [ 45.264999389648438, -15.927501678466797 ], [ 45.302635192871094, -16.117778778076172 ], [ 45.390548706054688, -15.973333358764648 ], [ 45.617774963378906, -16.057502746582031 ], [ 45.716659545898438, -15.791667938232422 ], [ 46.063606262207031, -15.871946334838867 ], [ 46.151382446289062, -15.703611373901367 ], [ 46.302215576171875, -15.961112976074219 ], [ 46.477775573730469, -15.961389541625977 ], [ 46.338333129882812, -15.624723434448242 ], [ 46.947219848632812, -15.198890686035156 ], [ 47.076385498046875, -15.334445953369141 ], [ 46.959442138671875, -15.558055877685547 ], [ 47.223617553710938, -15.448465347290039 ], [ 47.058326721191406, -15.185001373291016 ], [ 47.454994201660156, -14.665279388427734 ], [ 47.427215576171875, -15.110555648803711 ], [ 47.811275482177734, -14.603890419006348 ], [ 48.013328552246094, -14.749444961547852 ], [ 47.699714660644531, -14.408334732055664 ], [ 47.927772521972656, -14.253889083862305 ], [ 47.914161682128906, -14.088890075683594 ], [ 48.0030517578125, -14.322778701782227 ], [ 48.031402587890625, -14.063411712646484 ] ] ], [ [ [ 44.51361083984375, -12.380279541015625 ], [ 44.390968322753906, -12.269862174987793 ], [ 44.21221923828125, -12.163542747497559 ], [ 44.467357635498047, -12.07013988494873 ], [ 44.51361083984375, -12.380279541015625 ] ] ], [ [ [ 43.854438781738281, -12.383056640625 ], [ 43.668609619140625, -12.357500076293945 ], [ 43.62554931640625, -12.254446029663086 ], [ 43.737220764160156, -12.274444580078125 ], [ 43.854438781738281, -12.383056640625 ] ] ], [ [ [ 45.136383056640625, -12.992500305175781 ], [ 45.069999694824219, -12.957223892211914 ], [ 45.078887939453125, -12.662500381469727 ], [ 45.229717254638672, -12.754862785339355 ], [ 45.136383056640625, -12.992500305175781 ] ] ], [ [ [ 45.280078887939453, -12.805130958557129 ], [ 45.263126373291016, -12.768277168273926 ], [ 45.283763885498047, -12.746901512145996 ], [ 45.293346405029297, -12.785229682922363 ], [ 45.280078887939453, -12.805130958557129 ] ] ], [ [ [ 48.331939697265625, -13.420000076293945 ], [ 48.192214965820312, -13.338056564331055 ], [ 48.284164428710938, -13.195972442626953 ], [ 48.324996948242188, -13.211112976074219 ], [ 48.331939697265625, -13.420000076293945 ] ] ], [ [ [ -5.71297550201416, -15.992862701416016 ], [ -5.792778491973877, -15.991111755371094 ], [ -5.671389579772949, -15.909444808959961 ], [ -5.646389484405518, -15.958334922790527 ], [ -5.71297550201416, -15.992862701416016 ] ] ], [ [ [ 39.8861083984375, -16.417778015136719 ], [ 39.812774658203125, -16.324861526489258 ], [ 39.898052215576172, -16.272918701171875 ], [ 39.91485595703125, -16.282918930053711 ], [ 39.8861083984375, -16.417778015136719 ] ] ], [ [ [ 49.827217102050781, -17.095279693603516 ], [ 49.860549926757812, -16.913890838623047 ], [ 50.010551452636719, -16.725559234619141 ], [ 49.939720153808594, -16.907501220703125 ], [ 49.827217102050781, -17.095279693603516 ] ] ], [ [ [ 42.751937866210938, -17.076114654541016 ], [ 42.741523742675781, -17.074029922485352 ], [ 42.72381591796875, -17.057987213134766 ], [ 42.760898590087891, -17.065279006958008 ], [ 42.751937866210938, -17.076114654541016 ] ] ], [ [ [ 63.478050231933594, -19.677501678466797 ], [ 63.468883514404297, -19.734724044799805 ], [ 63.332008361816406, -19.742986679077148 ], [ 63.34832763671875, -19.707500457763672 ], [ 63.478050231933594, -19.677501678466797 ] ] ], [ [ [ 57.529441833496094, -20.520557403564453 ], [ 57.307083129882812, -20.434030532836914 ], [ 57.624443054199219, -19.98638916015625 ], [ 57.789581298828125, -20.285974502563477 ], [ 57.529441833496094, -20.520557403564453 ] ] ], [ [ [ 55.709999084472656, -20.998058319091797 ], [ 55.853050231933594, -21.168613433837891 ], [ 55.674163818359375, -21.373889923095703 ], [ 55.343330383300781, -21.268611907958984 ], [ 55.220550537109375, -21.025001525878906 ], [ 55.452495574951172, -20.856531143188477 ], [ 55.709999084472656, -20.998058319091797 ] ] ], [ [ [ 35.452217102050781, -21.787502288818359 ], [ 35.4244384765625, -21.727500915527344 ], [ 35.483325958251953, -21.525279998779297 ], [ 35.494720458984375, -21.658336639404297 ], [ 35.452217102050781, -21.787502288818359 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "South America" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -81.713058471679688, 12.490276336669922 ], [ -81.720146179199219, 12.545276641845703 ], [ -81.692367553710938, 12.590276718139648 ], [ -81.69097900390625, 12.532220840454102 ], [ -81.713058471679688, 12.490276336669922 ] ] ], [ [ [ -39.668930053710938, -18.325603485107422 ], [ -39.704032897949219, -19.423612594604492 ], [ -40.240558624267578, -20.283819198608398 ], [ -40.349723815917969, -20.234725952148438 ], [ -40.417503356933594, -20.616668701171875 ], [ -40.813125610351562, -20.928195953369141 ], [ -41.029167175292969, -21.448890686035156 ], [ -40.970142364501953, -21.982501983642578 ], [ -41.7630615234375, -22.346111297607422 ], [ -41.987434387207031, -22.565696716308594 ], [ -42.034446716308594, -22.919170379638672 ], [ -43.094169616699219, -22.953334808349609 ], [ -43.075836181640625, -22.6683349609375 ], [ -43.254310607910156, -22.736598968505859 ], [ -43.147434234619141, -22.951807022094727 ], [ -43.289451599121094, -23.013057708740234 ], [ -43.9969482421875, -23.103057861328125 ], [ -43.606807708740234, -23.018888473510742 ], [ -43.858753204345703, -22.896806716918945 ], [ -44.236705780029297, -23.048299789428711 ], [ -44.353752136230469, -22.920417785644531 ], [ -44.675212860107422, -23.055696487426758 ], [ -44.574306488037109, -23.353683471679688 ], [ -44.943893432617188, -23.362224578857422 ], [ -45.410835266113281, -23.628890991210938 ], [ -45.415485382080078, -23.828056335449219 ], [ -45.890007019042969, -23.767780303955078 ], [ -46.27972412109375, -24.025835037231445 ], [ -46.311668395996094, -24.018890380859375 ], [ -46.274795532226562, -23.991043090820312 ], [ -46.305488586425781, -23.919099807739258 ], [ -46.380420684814453, -23.868751525878906 ], [ -48.026115417480469, -25.015003204345703 ], [ -47.914306640625, -25.152362823486328 ], [ -48.208198547363281, -25.460140228271484 ], [ -48.134056091308594, -25.284730911254883 ], [ -48.395004272460938, -25.296112060546875 ], [ -48.480697631835938, -25.480140686035156 ], [ -48.718612670898438, -25.424724578857422 ], [ -48.361808776855469, -25.579444885253906 ], [ -48.7701416015625, -25.884098052978516 ], [ -48.58111572265625, -25.872222900390625 ], [ -48.581043243408203, -26.175695419311523 ], [ -48.7933349609375, -26.132225036621094 ], [ -48.486949920654297, -27.213474273681641 ], [ -48.620559692382812, -27.237085342407227 ], [ -48.563896179199219, -27.864444732666016 ], [ -48.761806488037109, -28.490695953369141 ], [ -48.852779388427734, -28.320278167724609 ], [ -48.842506408691406, -28.617778778076172 ], [ -49.75250244140625, -29.369724273681641 ], [ -50.74945068359375, -31.081111907958984 ], [ -52.069656372070312, -32.171947479248047 ], [ -52.086742401123047, -31.826805114746094 ], [ -51.861255645751953, -31.872917175292969 ], [ -51.251396179199219, -31.471668243408203 ], [ -51.158962249755859, -31.077848434448242 ], [ -50.970840454101562, -31.122222900390625 ], [ -50.568099975585938, -30.457550048828125 ], [ -50.605003356933594, -30.194028854370117 ], [ -50.966392517089844, -30.408889770507812 ], [ -51.275039672851562, -30.010557174682617 ], [ -51.267784118652344, -30.780834197998047 ], [ -51.376949310302734, -30.651111602783203 ], [ -51.467781066894531, -31.06097412109375 ], [ -51.963752746582031, -31.337364196777344 ], [ -52.217639923095703, -31.745002746582031 ], [ -52.254722595214844, -32.055282592773438 ], [ -52.090766906738281, -32.164379119873047 ], [ -52.639865875244141, -33.133754730224609 ], [ -53.439727783203125, -33.792228698730469 ], [ -54.140766143798828, -34.664657592773438 ], [ -54.312919616699219, -34.562850952148438 ], [ -54.278892517089844, -34.690700531005859 ], [ -54.8961181640625, -34.943611145019531 ], [ -55.692783355712891, -34.775070190429688 ], [ -56.158340454101562, -34.927223205566406 ], [ -57.111255645751953, -34.46417236328125 ], [ -57.836875915527344, -34.492782592773438 ], [ -58.429866790771484, -33.835002899169922 ], [ -58.360557556152344, -33.130977630615234 ], [ -58.141948699951172, -33.098896026611328 ], [ -58.045562744140625, -32.934722900390625 ], [ -58.200004577636719, -32.448333740234375 ], [ -58.146530151367188, -33.045421600341797 ], [ -58.425697326660156, -33.097434997558594 ], [ -58.531951904296875, -33.516944885253906 ], [ -58.385284423828125, -34.050422668457031 ], [ -58.4697265625, -34.539726257324219 ], [ -57.188339233398438, -35.320556640625 ], [ -57.376670837402344, -35.962783813476562 ], [ -57.053337097167969, -36.314170837402344 ], [ -56.745349884033203, -36.315975189208984 ], [ -56.678337097167969, -36.923614501953125 ], [ -57.484031677246094, -37.830421447753906 ], [ -57.551948547363281, -38.113616943359375 ], [ -58.301116943359375, -38.485000610351562 ], [ -61.094451904296875, -38.995834350585938 ], [ -62.385143280029297, -38.802642822265625 ], [ -62.327503204345703, -39.260005950927734 ], [ -62.165977478027344, -39.286392211914062 ], [ -62.024375915527344, -39.387504577636719 ], [ -62.274864196777344, -39.338474273681641 ], [ -62.068752288818359, -39.508476257324219 ], [ -62.117088317871094, -39.836875915527344 ], [ -62.309173583984375, -39.892227172851562 ], [ -62.488750457763672, -40.302570343017578 ], [ -62.247501373291016, -40.601184844970703 ], [ -62.338336944580078, -40.671321868896484 ], [ -62.195316314697266, -40.628406524658203 ], [ -62.390007019042969, -40.901947021484375 ], [ -63.036396026611328, -41.149311065673828 ], [ -63.774726867675781, -41.164867401123047 ], [ -64.804450988769531, -40.721946716308594 ], [ -65.130142211914062, -40.844169616699219 ], [ -65.013626098632812, -42.09222412109375 ], [ -64.464454650878906, -42.265628814697266 ], [ -64.600875854492188, -42.407260894775391 ], [ -64.451950073242188, -42.445838928222656 ], [ -64.113479614257812, -42.431529998779297 ], [ -64.063064575195312, -42.278617858886719 ], [ -64.328239440917969, -42.246181488037109 ], [ -63.750835418701172, -42.090003967285156 ], [ -63.579307556152344, -42.615005493164062 ], [ -63.684516906738281, -42.815765380859375 ], [ -64.098411560058594, -42.888545989990234 ], [ -64.398056030273438, -42.515838623046875 ], [ -64.953750610351562, -42.661113739013672 ], [ -64.989448547363281, -42.794589996337891 ], [ -64.296531677246094, -42.991184234619141 ], [ -64.929862976074219, -43.235836029052734 ], [ -65.326812744140625, -43.661808013916016 ], [ -65.24945068359375, -44.313056945800781 ], [ -65.689041137695312, -44.712089538574219 ], [ -65.537300109863281, -44.892292022705078 ], [ -65.611122131347656, -45.020561218261719 ], [ -66.182785034179688, -44.964447021484375 ], [ -66.946533203125, -45.254173278808594 ], [ -67.5843505859375, -46.000297546386719 ], [ -67.533615112304688, -46.42236328125 ], [ -66.818550109863281, -46.989170074462891 ], [ -65.775283813476562, -47.195209503173828 ], [ -65.87042236328125, -47.755558013916016 ], [ -66.029586791992188, -47.762920379638672 ], [ -66.1138916015625, -47.8175048828125 ], [ -66.229118347167969, -47.840377807617188 ], [ -66.243621826171875, -47.860282897949219 ], [ -65.956809997558594, -47.786392211914062 ], [ -65.789794921875, -47.965835571289062 ], [ -67.585700988769531, -49.040420532226562 ], [ -67.827781677246094, -49.386390686035156 ], [ -67.60577392578125, -49.26409912109375 ], [ -67.897232055664062, -49.98583984375 ], [ -68.273345947265625, -50.123336791992188 ], [ -68.592514038085938, -49.928611755371094 ], [ -69.002853393554688, -50.009654998779297 ], [ -68.584938049316406, -49.980419158935547 ], [ -68.373199462890625, -50.15521240234375 ], [ -68.941116333007812, -50.3880615234375 ], [ -69.14361572265625, -50.881671905517578 ], [ -69.405975341796875, -51.079654693603516 ], [ -69.1925048828125, -50.966808319091797 ], [ -68.970069885253906, -51.572780609130859 ], [ -69.37445068359375, -51.556396484375 ], [ -69.609519958496094, -51.624172210693359 ], [ -68.990142822265625, -51.624446868896484 ], [ -68.382789611816406, -52.327362060546875 ], [ -69.268486022949219, -52.208057403564453 ], [ -69.675697326660156, -52.528266906738281 ], [ -70.811676025390625, -52.732505798339844 ], [ -70.976600646972656, -53.760906219482422 ], [ -71.28472900390625, -53.886390686035156 ], [ -72.115013122558594, -53.687641143798828 ], [ -72.452507019042969, -53.404308319091797 ], [ -72.283409118652344, -53.245006561279297 ], [ -72.112091064453125, -53.257640838623047 ], [ -72.227363586425781, -53.435523986816406 ], [ -72.10528564453125, -53.429725646972656 ], [ -71.866600036621094, -53.222850799560547 ], [ -71.786048889160156, -53.429515838623047 ], [ -72.005844116210938, -53.565418243408203 ], [ -71.797370910644531, -53.512783050537109 ], [ -71.739028930664062, -53.2152099609375 ], [ -71.328620910644531, -53.100006103515625 ], [ -71.166534423828125, -52.810695648193359 ], [ -72.01959228515625, -53.124309539794922 ], [ -72.303482055664062, -53.029449462890625 ], [ -72.51708984375, -53.062366485595703 ], [ -72.189521789550781, -53.182712554931641 ], [ -72.647781372070312, -53.325973510742188 ], [ -72.400283813476562, -53.540283203125 ], [ -73.29888916015625, -53.1607666015625 ], [ -72.710281372070312, -53.294033050537109 ], [ -72.792221069335938, -53.184097290039062 ], [ -72.655838012695312, -53.149101257324219 ], [ -72.9375, -53.102989196777344 ], [ -72.915847778320312, -52.824722290039062 ], [ -71.47528076171875, -52.633338928222656 ], [ -72.789794921875, -52.542850494384766 ], [ -72.898895263671875, -52.625556945800781 ], [ -72.6783447265625, -52.662155151367188 ], [ -73.005844116210938, -52.854171752929688 ], [ -72.980422973632812, -53.064723968505859 ], [ -73.203483581542969, -53.106250762939453 ], [ -73.449348449707031, -53.002048492431641 ], [ -73.235000610351562, -52.889724731445312 ], [ -73.55645751953125, -52.802326202392578 ], [ -73.231880187988281, -52.787643432617188 ], [ -73.101112365722656, -52.507503509521484 ], [ -72.918060302734375, -52.49444580078125 ], [ -73.149734497070312, -52.489723205566406 ], [ -73.265975952148438, -52.669795989990234 ], [ -73.693611145019531, -52.722087860107422 ], [ -73.549934387207031, -52.542572021484375 ], [ -73.731674194335938, -52.037506103515625 ], [ -73.321815490722656, -52.2237548828125 ], [ -72.986251831054688, -52.070625305175781 ], [ -72.986679077148438, -52.1875 ], [ -72.86639404296875, -52.263893127441406 ], [ -72.78472900390625, -52.062225341796875 ], [ -72.875495910644531, -52.203056335449219 ], [ -72.943344116210938, -52.087783813476562 ], [ -72.694236755371094, -51.989101409912109 ], [ -72.575630187988281, -52.321529388427734 ], [ -72.899444580078125, -52.4586181640625 ], [ -72.491050720214844, -52.316741943359375 ], [ -72.66656494140625, -51.965244293212891 ], [ -72.470703125, -51.93597412109375 ], [ -72.468902587890625, -51.789169311523438 ], [ -72.712646484375, -51.583889007568359 ], [ -73.242507934570312, -51.462985992431641 ], [ -72.550209045410156, -51.7393798828125 ], [ -72.719734191894531, -51.837226867675781 ], [ -73.283897399902344, -51.613544464111328 ], [ -72.997360229492188, -51.783332824707031 ], [ -73.190704345703125, -51.876495361328125 ], [ -72.926956176757812, -51.861114501953125 ], [ -73.140068054199219, -51.940486907958984 ], [ -73.240768432617188, -52.087223052978516 ], [ -73.32000732421875, -51.726112365722656 ], [ -73.380668640136719, -51.669895172119141 ], [ -73.316810607910156, -52.170421600341797 ], [ -73.649139404296875, -51.834514617919922 ], [ -73.399452209472656, -52.017223358154297 ], [ -73.586708068847656, -51.756355285644531 ], [ -73.471321105957031, -51.694133758544922 ], [ -73.700355529785156, -51.789169311523438 ], [ -73.905838012695312, -51.622505187988281 ], [ -73.904800415039062, -51.377292633056641 ], [ -73.604942321777344, -51.628406524658203 ], [ -73.711669921875, -51.15972900390625 ], [ -74.083755493164062, -51.209030151367188 ], [ -74.247367858886719, -50.927707672119141 ], [ -73.851394653320312, -50.916671752929688 ], [ -73.751670837402344, -50.661739349365234 ], [ -73.533134460449219, -50.714237213134766 ], [ -73.722579956054688, -50.545700073242188 ], [ -73.571739196777344, -50.404342651367188 ], [ -74.043479919433594, -50.828060150146484 ], [ -74.289237976074219, -50.480487823486328 ], [ -73.890907287597656, -50.546840667724609 ], [ -74.693336486816406, -50.177433013916016 ], [ -74.3487548828125, -50.088615417480469 ], [ -74.20361328125, -50.217781066894531 ], [ -73.867332458496094, -50.288890838623047 ], [ -74.370841979980469, -49.992084503173828 ], [ -73.890144348144531, -50.074863433837891 ], [ -74.324874877929688, -49.867782592773438 ], [ -74.063339233398438, -49.715557098388672 ], [ -74.299102783203125, -49.739101409912109 ], [ -74.243270874023438, -49.571182250976562 ], [ -73.947715759277344, -49.559238433837891 ], [ -73.881256103515625, -49.667644500732422 ], [ -73.723617553710938, -49.789169311523438 ], [ -73.874031066894531, -49.531875610351562 ], [ -74.121810913085938, -49.413753509521484 ], [ -74.068336486816406, -49.262783050537109 ], [ -73.917503356933594, -49.347225189208984 ], [ -73.847854614257812, -49.346599578857422 ], [ -74.028900146484375, -49.093055725097656 ], [ -73.831184387207031, -49.0322265625 ], [ -74.0433349609375, -49.021949768066406 ], [ -74.215980529785156, -49.532222747802734 ], [ -74.3739013671875, -49.427505493164062 ], [ -74.450141906738281, -48.815696716308594 ], [ -74.064651489257812, -48.743682861328125 ], [ -74.397575378417969, -48.611946105957031 ], [ -74.046676635742188, -48.547782897949219 ], [ -74.0211181640625, -48.413612365722656 ], [ -74.656883239746094, -48.029727935791016 ], [ -74.414939880371094, -47.987709045410156 ], [ -74.2152099609375, -48.231807708740234 ], [ -74.327781677246094, -48.005001068115234 ], [ -73.771812438964844, -48.02972412109375 ], [ -73.5533447265625, -48.245834350585938 ], [ -73.349166870117188, -48.197502136230469 ], [ -73.284866333007812, -48.154033660888672 ], [ -73.273757934570312, -48.093338012695312 ], [ -73.486534118652344, -48.122920989990234 ], [ -73.654205322265625, -47.909099578857422 ], [ -73.487785339355469, -47.985004425048828 ], [ -73.226600646972656, -48.003025054931641 ], [ -73.713615417480469, -47.780143737792969 ], [ -73.726287841796875, -47.531391143798828 ], [ -73.771255493164062, -47.786533355712891 ], [ -73.9344482421875, -47.846946716308594 ], [ -74.74139404296875, -47.711460113525391 ], [ -74.560562133789062, -47.550975799560547 ], [ -74.237510681152344, -47.752086639404297 ], [ -74.257156372070312, -47.632919311523438 ], [ -74.046676635742188, -47.620208740234375 ], [ -74.528129577636719, -47.434310913085938 ], [ -74.319595336914062, -47.219863891601562 ], [ -74.10528564453125, -47.347503662109375 ], [ -73.938270568847656, -47.034446716308594 ], [ -74.265769958496094, -46.787570953369141 ], [ -74.618621826171875, -46.785560607910156 ], [ -74.504035949707031, -46.903057098388672 ], [ -75.008621215820312, -46.751945495605469 ], [ -74.945289611816406, -46.442710876464844 ], [ -75.598068237304688, -46.703056335449219 ], [ -75.419731140136719, -46.7152099609375 ], [ -75.413070678710938, -46.933891296386719 ], [ -75.717514038085938, -46.72528076171875 ], [ -74.821670532226562, -46.112785339355469 ], [ -74.67486572265625, -45.826805114746094 ], [ -74.368614196777344, -45.792366027832031 ], [ -74.110702514648438, -45.835834503173828 ], [ -74.161537170410156, -46.137504577636719 ], [ -74.055007934570312, -45.984794616699219 ], [ -73.972648620605469, -46.088615417480469 ], [ -74.311676025390625, -46.249168395996094 ], [ -74.484504699707031, -46.184013366699219 ], [ -74.3326416015625, -46.265422821044922 ], [ -74.046463012695312, -46.197849273681641 ], [ -73.863067626953125, -46.347503662109375 ], [ -74.017364501953125, -46.213508605957031 ], [ -73.892295837402344, -46.138751983642578 ], [ -73.766815185546875, -46.296253204345703 ], [ -73.993827819824219, -46.559310913085938 ], [ -73.846542358398438, -46.592086791992188 ], [ -73.425567626953125, -46.074447631835938 ], [ -73.687850952148438, -46.31500244140625 ], [ -73.665145874023438, -45.980487823486328 ], [ -73.184242248535156, -45.668338775634766 ], [ -73.579872131347656, -45.778266906738281 ], [ -73.514663696289062, -45.455696105957031 ], [ -73.214935302734375, -45.301460266113281 ], [ -73.014732360839844, -45.448753356933594 ], [ -72.827224731445312, -45.422500610351562 ], [ -73.259864807128906, -45.245006561279297 ], [ -73.457366943359375, -45.275558471679688 ], [ -73.305488586425781, -45.147747039794922 ], [ -73.39678955078125, -44.994514465332031 ], [ -73.142501831054688, -44.944450378417969 ], [ -72.76611328125, -44.753334045410156 ], [ -72.6138916015625, -44.4727783203125 ], [ -73.289382934570312, -44.146877288818359 ], [ -72.845840454101562, -43.77667236328125 ], [ -73.042098999023438, -43.733837127685547 ], [ -73.116119384765625, -43.442920684814453 ], [ -72.885009765625, -43.042503356933594 ], [ -72.745285034179688, -43.04833984375 ], [ -72.856948852539062, -42.566810607910156 ], [ -72.539794921875, -42.554168701171875 ], [ -72.849029541015625, -42.288822174072266 ], [ -72.604385375976562, -42.184375762939453 ], [ -72.421463012695312, -42.445972442626953 ], [ -72.461669921875, -41.973476409912109 ], [ -72.859451293945312, -41.906951904296875 ], [ -72.350570678710938, -41.652503967285156 ], [ -72.310012817382812, -41.435836791992188 ], [ -72.578475952148438, -41.708892822265625 ], [ -72.935836791992188, -41.483268737792969 ], [ -73.195419311523438, -41.788196563720703 ], [ -73.745559692382812, -41.754375457763672 ], [ -73.684730529785156, -41.626670837402344 ], [ -73.562850952148438, -41.611183166503906 ], [ -73.497718811035156, -41.519931793212891 ], [ -73.871116638183594, -41.479171752929688 ], [ -73.994316101074219, -40.966945648193359 ], [ -73.74542236328125, -40.509654998779297 ], [ -73.714866638183594, -39.981670379638672 ], [ -73.4041748046875, -39.885002136230469 ], [ -73.224037170410156, -39.416877746582031 ], [ -73.677093505859375, -37.347293853759766 ], [ -73.586875915527344, -37.152568817138672 ], [ -73.203758239746094, -37.161808013916016 ], [ -73.12945556640625, -36.682502746582031 ], [ -72.981536865234375, -36.699031829833984 ], [ -72.796051025390625, -35.975070953369141 ], [ -72.591400146484375, -35.802501678466797 ], [ -72.647781372070312, -35.574031829833984 ], [ -72.210838317871094, -35.085281372070312 ], [ -72.016807556152344, -34.144378662109375 ], [ -71.655014038085938, -33.662506103515625 ], [ -71.756256103515625, -33.105419158935547 ], [ -71.446670532226562, -32.665000915527344 ], [ -71.695846557617188, -30.506668090820312 ], [ -71.289649963378906, -29.90965461730957 ], [ -71.510284423828125, -28.895000457763672 ], [ -70.913894653320312, -27.624446868896484 ], [ -70.9666748046875, -27.179168701171875 ], [ -70.785354614257812, -26.988821029663086 ], [ -70.6380615234375, -26.3013916015625 ], [ -70.731254577636719, -25.81590461730957 ], [ -70.433624267578125, -25.260280609130859 ], [ -70.583343505859375, -24.71611213684082 ], [ -70.39111328125, -23.561946868896484 ], [ -70.622093200683594, -23.499652862548828 ], [ -70.574722290039062, -23.066947937011719 ], [ -70.286117553710938, -22.886877059936523 ], [ -70.0533447265625, -21.425651550292969 ], [ -70.210426330566406, -20.801668167114258 ], [ -70.124732971191406, -19.974445343017578 ], [ -70.312019348144531, -18.437501907348633 ], [ -71.301681518554688, -17.711669921875 ], [ -71.494239807128906, -17.302225112915039 ], [ -75.0513916015625, -15.465972900390625 ], [ -75.933891296386719, -14.651875495910645 ], [ -76.394798278808594, -13.884167671203613 ], [ -76.196945190429688, -13.4183349609375 ], [ -76.799728393554688, -12.390278816223145 ], [ -77.175697326660156, -12.070900917053223 ], [ -77.304733276367188, -11.51097297668457 ], [ -77.647712707519531, -11.297847747802734 ], [ -77.679458618164062, -10.934167861938477 ], [ -78.994590759277344, -8.219654083251953 ], [ -79.372512817382812, -7.852778434753418 ], [ -79.980010986328125, -6.768611907958984 ], [ -81.174728393554688, -6.086667060852051 ], [ -81.151535034179688, -5.855694770812988 ], [ -80.939033508300781, -5.8601393699646 ], [ -80.872856140136719, -5.644583702087402 ], [ -81.203826904296875, -5.204444885253906 ], [ -81.085006713867188, -5.017778396606445 ], [ -81.355148315429688, -4.687500476837158 ], [ -81.276397705078125, -4.280834197998047 ], [ -80.532295227050781, -3.510208368301392 ], [ -79.956321716308594, -3.207777976989746 ], [ -79.726814270019531, -2.596944570541382 ], [ -79.844100952148438, -2.378194570541382 ], [ -79.762924194335938, -2.014027833938599 ], [ -79.905838012695312, -2.559305667877197 ], [ -80.064727783203125, -2.573333501815796 ], [ -79.955841064453125, -2.316111326217651 ], [ -80.252227783203125, -2.733194589614868 ], [ -80.975006103515625, -2.216944694519043 ], [ -80.730979919433594, -1.93791675567627 ], [ -80.912788391113281, -1.036527872085571 ], [ -80.5760498046875, -0.897708415985107 ], [ -80.433265686035156, -0.569513976573944 ], [ -80.376533508300781, -0.634583413600922 ], [ -80.269721984863281, -0.625381946563721 ], [ -80.501182556152344, -0.372569471597672 ], [ -80.069450378417969, 0.060416661202908 ], [ -80.100837707519531, 0.770277738571167 ], [ -78.889289855957031, 1.238367080688477 ], [ -78.809722900390625, 1.437777757644653 ], [ -79.050285339355469, 1.631805419921875 ], [ -78.844940185546875, 1.836527705192566 ], [ -78.587501525878906, 1.767152547836304 ], [ -78.686874389648438, 2.193471908569336 ], [ -78.565292358398438, 2.429166316986084 ], [ -78.45556640625, 2.5041663646698 ], [ -78.346458435058594, 2.437846899032593 ], [ -77.986953735351562, 2.522499561309814 ], [ -77.937469482421875, 2.650902509689331 ], [ -77.74542236328125, 2.610416412353516 ], [ -77.781112670898438, 2.756388664245605 ], [ -77.03271484375, 3.918402433395386 ], [ -77.265419006347656, 3.840138673782349 ], [ -77.187225341796875, 4.060276985168457 ], [ -77.366256713867188, 3.925971984863281 ], [ -77.4344482421875, 4.031388282775879 ], [ -77.242301940917969, 4.260902404785156 ], [ -77.382438659667969, 4.342152118682861 ], [ -77.3477783203125, 5.240554809570312 ], [ -77.5322265625, 5.518888473510742 ], [ -77.2408447265625, 5.758193969726562 ], [ -77.4888916015625, 6.185346603393555 ], [ -77.340423583984375, 6.567360877990723 ], [ -77.889724731445312, 7.228888511657715 ], [ -77.744033813476562, 7.719999313354492 ], [ -77.577438354492188, 7.526180267333984 ], [ -77.215560913085938, 7.937221527099609 ], [ -77.468582153320312, 8.471699714660645 ], [ -77.366668701171875, 8.674999237060547 ], [ -76.8341064453125, 8.129096031188965 ], [ -76.92388916015625, 7.936040878295898 ], [ -76.757919311523438, 7.919166088104248 ], [ -76.773826599121094, 8.411249160766602 ], [ -76.9283447265625, 8.568332672119141 ], [ -76.317512512207031, 8.938610076904297 ], [ -76.089736938476562, 9.335832595825195 ], [ -75.634315490722656, 9.448193550109863 ], [ -75.547073364257812, 10.41789436340332 ], [ -75.264137268066406, 10.798992156982422 ], [ -74.860809326171875, 11.125486373901367 ], [ -74.292228698730469, 10.999026298522949 ], [ -74.591743469238281, 10.87763786315918 ], [ -74.395004272460938, 10.742152214050293 ], [ -74.155014038085938, 11.331388473510742 ], [ -73.284454345703125, 11.295555114746094 ], [ -72.258621215820312, 11.889165878295898 ], [ -72.157920837402344, 12.241108894348145 ], [ -71.937789916992188, 12.162776947021484 ], [ -71.661537170410156, 12.463888168334961 ], [ -71.275703430175781, 12.346110343933105 ], [ -71.11083984375, 12.075554847717285 ], [ -71.378616333007812, 11.753332138061523 ], [ -71.969169616699219, 11.546248435974121 ], [ -71.577926635742188, 10.716110229492188 ], [ -72.125350952148438, 9.818193435668945 ], [ -71.623893737792969, 9.043054580688477 ], [ -71.055976867675781, 9.338749885559082 ], [ -71.073402404785156, 9.851110458374023 ], [ -71.545707702636719, 10.568331718444824 ], [ -71.49285888671875, 10.961040496826172 ], [ -70.04779052734375, 11.517776489257812 ], [ -69.8013916015625, 11.427221298217773 ], [ -69.816535949707031, 11.690971374511719 ], [ -70.235977172851562, 11.628888130187988 ], [ -70.286666870117188, 11.920276641845703 ], [ -70.014312744140625, 12.197498321533203 ], [ -69.631813049316406, 11.46763801574707 ], [ -68.843681335449219, 11.44708251953125 ], [ -68.4183349609375, 11.179998397827148 ], [ -68.114242553710938, 10.484929084777832 ], [ -66.229873657226562, 10.640554428100586 ], [ -65.814453125, 10.22833251953125 ], [ -65.081390380859375, 10.060555458068848 ], [ -64.182052612304688, 10.456549644470215 ], [ -63.697502136230469, 10.485553741455078 ], [ -64.235694885253906, 10.514373779296875 ], [ -64.26458740234375, 10.657776832580566 ], [ -61.879589080810547, 10.728331565856934 ], [ -62.331111907958984, 10.531664848327637 ], [ -62.912296295166016, 10.528749465942383 ], [ -63.004238128662109, 10.452984809875488 ], [ -62.872505187988281, 10.524443626403809 ], [ -62.837711334228516, 10.39729118347168 ], [ -62.934307098388672, 10.418471336364746 ], [ -63.003684997558594, 10.3941650390625 ], [ -62.998409271240234, 10.271596908569336 ], [ -62.790088653564453, 10.401333808898926 ], [ -62.630630493164062, 10.107151031494141 ], [ -63.015975952148438, 10.095693588256836 ], [ -62.805282592773438, 10.008609771728516 ], [ -62.615764617919922, 10.093193054199219 ], [ -62.577503204345703, 10.225138664245605 ], [ -62.322643280029297, 9.712082862854004 ], [ -62.205699920654297, 9.914026260375977 ], [ -62.196113586425781, 9.641665458679199 ], [ -62.027435302734375, 9.866422653198242 ], [ -62.17889404296875, 10.014721870422363 ], [ -61.735836029052734, 9.600936889648438 ], [ -61.800918579101562, 9.812275886535645 ], [ -61.597709655761719, 9.782776832580566 ], [ -61.619865417480469, 9.905277252197266 ], [ -60.959724426269531, 9.532499313354492 ], [ -60.783615112304688, 9.304998397827148 ], [ -60.987785339355469, 9.188610076904297 ], [ -61.084587097167969, 9.097498893737793 ], [ -60.950489044189453, 9.175137519836426 ], [ -61.0977783203125, 8.963333129882812 ], [ -61.210208892822266, 8.595137596130371 ], [ -61.595420837402344, 8.616943359375 ], [ -61.598892211914062, 8.554998397827148 ], [ -61.329170227050781, 8.430831909179688 ], [ -61.077507019042969, 8.49305534362793 ], [ -61.073543548583984, 8.402915954589844 ], [ -60.981254577636719, 8.564443588256836 ], [ -60.205833435058594, 8.621944427490234 ], [ -59.129306793212891, 8.039999008178711 ], [ -58.468544006347656, 7.337568759918213 ], [ -58.637088775634766, 6.421943664550781 ], [ -58.419723510742188, 6.870277404785156 ], [ -57.98638916015625, 6.790555000305176 ], [ -57.519187927246094, 6.270767211914062 ], [ -57.194309234619141, 6.139304637908936 ], [ -57.248504638671875, 5.486110687255859 ], [ -56.964447021484375, 5.997083187103271 ], [ -56.017784118652344, 5.818332672119141 ], [ -55.899559020996094, 5.671908378601074 ], [ -55.922714233398438, 5.876075744628906 ], [ -55.768062591552734, 5.967221736907959 ], [ -55.127967834472656, 5.822173118591309 ], [ -54.864448547363281, 5.855138301849365 ], [ -55.144725799560547, 5.934165954589844 ], [ -55.047367095947266, 6.001804828643799 ], [ -54.204727172851562, 5.879721641540527 ], [ -53.990211486816406, 5.746943950653076 ], [ -54.166679382324219, 5.347402572631836 ], [ -53.911392211914062, 5.750277519226074 ], [ -52.973197937011719, 5.473054885864258 ], [ -52.023475646972656, 4.685693740844727 ], [ -52.040695190429688, 4.334582805633545 ], [ -51.915557861328125, 4.646527290344238 ], [ -51.794448852539062, 4.605555534362793 ], [ -51.684066772460938, 4.034163475036621 ], [ -51.540283203125, 4.153610229492188 ], [ -51.447784423828125, 3.972499847412109 ], [ -51.548130035400391, 4.385693550109863 ], [ -51.259307861328125, 4.152499675750732 ], [ -50.679725646972656, 2.164721965789795 ], [ -50.445281982421875, 1.825833320617676 ], [ -49.932083129882812, 1.709930419921875 ], [ -49.892990112304688, 1.324235916137695 ], [ -50.110557556152344, 1.213402628898621 ], [ -49.9031982421875, 1.174444317817688 ], [ -50.450004577636719, 0.661805510520935 ], [ -50.760421752929688, 0.195972219109535 ], [ -51.297500610351562, -0.19138890504837 ], [ -51.700004577636719, -0.752500057220459 ], [ -51.712295532226562, -1.02381956577301 ], [ -51.919658660888672, -1.166736245155334 ], [ -51.927505493164062, -1.334861159324646 ], [ -52.227642059326172, -1.344930648803711 ], [ -52.706951141357422, -1.603055715560913 ], [ -52.2933349609375, -1.535000085830688 ], [ -52.208469390869141, -1.692078709602356 ], [ -51.449451446533203, -1.327083468437195 ], [ -50.852920532226562, -0.915000081062317 ], [ -50.814586639404297, -1.444583415985107 ], [ -50.667228698730469, -1.771666765213013 ], [ -50.814727783203125, -1.898333549499512 ], [ -51.336597442626953, -1.647430539131165 ], [ -51.521949768066406, -2.046389102935791 ], [ -51.447227478027344, -2.27916693687439 ], [ -51.308231353759766, -1.766909718513489 ], [ -50.991115570068359, -2.02958345413208 ], [ -51.029167175292969, -2.345000267028809 ], [ -50.996112823486328, -2.417778015136719 ], [ -50.843822479248047, -2.507500171661377 ], [ -51.006252288818359, -2.339861392974854 ], [ -50.984310150146484, -2.069166898727417 ], [ -50.716457366943359, -2.223264217376709 ], [ -50.822921752929688, -1.960000038146973 ], [ -50.677955627441406, -1.810443639755249 ], [ -50.416389465332031, -1.952222347259521 ], [ -49.280906677246094, -1.717708468437195 ], [ -49.490005493164062, -2.565000057220459 ], [ -49.190559387207031, -1.898055791854858 ], [ -48.970489501953125, -1.840555667877197 ], [ -48.697227478027344, -1.46916675567627 ], [ -48.427223205566406, -1.660277962684631 ], [ -48.413612365722656, -1.499444484710693 ], [ -48.188961029052734, -1.466250061988831 ], [ -48.499725341796875, -1.461458444595337 ], [ -48.481182098388672, -1.304861187934875 ], [ -48.339797973632812, -1.317499995231628 ], [ -48.238059997558594, -0.867777824401855 ], [ -47.744586944580078, -0.637361168861389 ], [ -47.398059844970703, -0.812777876853943 ], [ -47.459587097167969, -0.595000088214874 ], [ -47.285560607910156, -0.599166750907898 ], [ -46.959728240966797, -0.702777862548828 ], [ -46.960002899169922, -0.898472309112549 ], [ -46.826671600341797, -0.713194489479065 ], [ -46.630138397216797, -0.825625061988831 ], [ -46.610000610351562, -1.037500143051147 ], [ -46.418060302734375, -1.037500143051147 ], [ -46.191947937011719, -0.957500100135803 ], [ -46.259449005126953, -1.177777886390686 ], [ -46.046669006347656, -1.210277795791626 ], [ -45.975696563720703, -1.077500104904175 ], [ -45.861530303955078, -1.259513974189758 ], [ -45.735557556152344, -1.180000066757202 ], [ -45.696182250976562, -1.368680596351624 ], [ -45.446945190429688, -1.31083345413208 ], [ -45.462226867675781, -1.545555591583252 ], [ -45.324726104736328, -1.314722418785095 ], [ -45.350696563720703, -1.73680567741394 ], [ -45.158756256103516, -1.480416774749756 ], [ -44.858894348144531, -1.430625081062317 ], [ -44.951393127441406, -1.601666688919067 ], [ -44.489727020263672, -1.986666798591614 ], [ -44.654933929443359, -2.323680877685547 ], [ -44.450836181640625, -2.146389007568359 ], [ -44.360557556152344, -2.341944694519043 ], [ -44.582088470458984, -2.566805839538574 ], [ -44.786392211914062, -3.297500133514404 ], [ -44.423061370849609, -2.934444665908813 ], [ -44.356948852539062, -2.52666711807251 ], [ -44.063339233398438, -2.405833721160889 ], [ -44.340351104736328, -2.827361345291138 ], [ -44.190631866455078, -2.763402938842773 ], [ -44.198333740234375, -2.868889331817627 ], [ -43.928337097167969, -2.54847240447998 ], [ -43.448333740234375, -2.537777900695801 ], [ -43.477710723876953, -2.382778167724609 ], [ -43.347503662109375, -2.365833759307861 ], [ -42.23583984375, -2.837778091430664 ], [ -41.870834350585938, -2.732222557067871 ], [ -41.248069763183594, -3.02355432510376 ], [ -41.2227783203125, -2.88027811050415 ], [ -39.998752593994141, -2.846528053283691 ], [ -38.496532440185547, -3.72486138343811 ], [ -37.174446105957031, -4.918611526489258 ], [ -36.684585571289062, -5.098472595214844 ], [ -35.479728698730469, -5.166111946105957 ], [ -34.980278015136719, -6.406389236450195 ], [ -34.901290893554688, -7.125252246856689 ], [ -34.831291198730469, -6.981796741485596 ], [ -34.846393585205078, -8.062917709350586 ], [ -35.327507019042969, -9.228889465332031 ], [ -36.389862060546875, -10.489167213439941 ], [ -37.011947631835938, -10.929723739624023 ], [ -37.032295227050781, -10.928750991821289 ], [ -37.025283813476562, -10.858890533447266 ], [ -37.09222412109375, -10.743890762329102 ], [ -37.155696868896484, -10.7540283203125 ], [ -37.07305908203125, -10.96722412109375 ], [ -37.154514312744141, -11.099791526794434 ], [ -37.275627136230469, -11.025208473205566 ], [ -37.207229614257812, -11.219446182250977 ], [ -37.371879577636719, -11.429862022399902 ], [ -37.290142059326172, -11.211251258850098 ], [ -37.342361450195312, -11.187500953674316 ], [ -38.041389465332031, -12.633056640625 ], [ -38.474655151367188, -13.016597747802734 ], [ -38.507366180419922, -12.726458549499512 ], [ -38.697990417480469, -12.581111907958984 ], [ -38.818267822265625, -12.843542098999023 ], [ -38.901115417480469, -12.705556869506836 ], [ -38.857643127441406, -12.849862098693848 ], [ -38.730140686035156, -12.871251106262207 ], [ -39.057090759277344, -13.380278587341309 ], [ -39.080284118652344, -13.538333892822266 ], [ -38.963474273681641, -13.686112403869629 ], [ -39.036529541015625, -14.17500114440918 ], [ -38.920700073242188, -13.925139427185059 ], [ -39.066669464111328, -14.650418281555176 ], [ -38.8719482421875, -15.874168395996094 ], [ -39.209030151367188, -17.166114807128906 ], [ -39.132225036621094, -17.686321258544922 ], [ -39.668930053710938, -18.325603485107422 ] ] ], [ [ [ -64.055557250976562, 10.857221603393555 ], [ -64.40570068359375, 10.970137596130371 ], [ -64.378341674804688, 11.056942939758301 ], [ -64.04278564453125, 10.987637519836426 ], [ -63.884933471679688, 11.175622940063477 ], [ -63.81500244140625, 10.978054046630859 ], [ -64.055557250976562, 10.857221603393555 ] ] ], [ [ [ -65.281112670898438, 10.880277633666992 ], [ -65.393341064453125, 10.906944274902344 ], [ -65.416122436523438, 10.927221298217773 ], [ -65.212158203125, 10.954165458679199 ], [ -65.281112670898438, 10.880277633666992 ] ] ], [ [ [ -60.858322143554688, 9.064958572387695 ], [ -60.943336486816406, 9.022220611572266 ], [ -61.061393737792969, 8.896944046020508 ], [ -61.096668243408203, 8.890900611877441 ], [ -61.070625305175781, 8.971318244934082 ], [ -60.858322143554688, 9.064958572387695 ] ] ], [ [ [ -60.9102783203125, 8.8941650390625 ], [ -61.019729614257812, 8.846942901611328 ], [ -61.046394348144531, 8.843887329101562 ], [ -60.880348205566406, 9.02652645111084 ], [ -60.9102783203125, 8.8941650390625 ] ] ], [ [ [ -61.163612365722656, 8.688331604003906 ], [ -61.042503356933594, 8.821109771728516 ], [ -60.860557556152344, 8.85333251953125 ], [ -60.976112365722656, 8.725831985473633 ], [ -61.163612365722656, 8.688331604003906 ] ] ], [ [ [ -60.92333984375, 8.618331909179688 ], [ -60.988616943359375, 8.635555267333984 ], [ -60.8094482421875, 8.716943740844727 ], [ -60.823337554931641, 8.652359962463379 ], [ -60.92333984375, 8.618331909179688 ] ] ], [ [ [ -61.048057556152344, 8.639720916748047 ], [ -61.177227020263672, 8.676665306091309 ], [ -60.937782287597656, 8.721248626708984 ], [ -60.996810913085938, 8.65263843536377 ], [ -61.048057556152344, 8.639720916748047 ] ] ], [ [ [ -61.129173278808594, 8.501665115356445 ], [ -61.263683319091797, 8.51020622253418 ], [ -60.998062133789062, 8.596942901611328 ], [ -61.040557861328125, 8.514164924621582 ], [ -61.129173278808594, 8.501665115356445 ] ] ], [ [ [ -61.2469482421875, 8.474721908569336 ], [ -61.405281066894531, 8.485832214355469 ], [ -61.543544769287109, 8.548679351806641 ], [ -61.279449462890625, 8.569721221923828 ], [ -61.263599395751953, 8.499930381774902 ], [ -61.185070037841797, 8.496735572814941 ], [ -61.2469482421875, 8.474721908569336 ] ] ], [ [ [ -77.399444580078125, 4.322222709655762 ], [ -77.319732666015625, 4.251666069030762 ], [ -77.548545837402344, 4.196179866790771 ], [ -77.433204650878906, 4.331666469573975 ], [ -77.399444580078125, 4.322222709655762 ] ] ], [ [ [ -78.125564575195312, 2.499444007873535 ], [ -78.214866638183594, 2.576388597488403 ], [ -78.191261291503906, 2.639166355133057 ], [ -78.105560302734375, 2.595971822738647 ], [ -78.125564575195312, 2.499444007873535 ] ] ], [ [ [ -50.485000610351562, 2.117499828338623 ], [ -50.517227172851562, 2.203055381774902 ], [ -50.405555725097656, 2.193610668182373 ], [ -50.40472412109375, 2.146388530731201 ], [ -50.485000610351562, 2.117499828338623 ] ] ], [ [ [ -50.40472412109375, 1.879999876022339 ], [ -50.49945068359375, 2.07777738571167 ], [ -50.378890991210938, 2.133333206176758 ], [ -50.298336029052734, 1.961805462837219 ], [ -50.40472412109375, 1.879999876022339 ] ] ], [ [ [ -50.024444580078125, 0.929722189903259 ], [ -50.074447631835938, 0.9811110496521 ], [ -49.947784423828125, 1.054444313049316 ], [ -49.942367553710938, 0.998888731002808 ], [ -50.024444580078125, 0.929722189903259 ] ] ], [ [ [ -50.245002746582031, 0.744166612625122 ], [ -50.204448699951172, 0.877083241939545 ], [ -50.01055908203125, 0.919583261013031 ], [ -50.069168090820312, 0.788611054420471 ], [ -50.245002746582031, 0.744166612625122 ] ] ], [ [ [ -50.254173278808594, 0.341944396495819 ], [ -50.308059692382812, 0.506388783454895 ], [ -50.059864044189453, 0.643055498600006 ], [ -50.023056030273438, 0.54194438457489 ], [ -50.254173278808594, 0.341944396495819 ] ] ], [ [ [ -50.441116333007812, 0.171111106872559 ], [ -50.536392211914062, 0.222361087799072 ], [ -50.377780914306641, 0.618333280086517 ], [ -50.317779541015625, 0.308888852596283 ], [ -50.441116333007812, 0.171111106872559 ] ] ], [ [ [ -49.895015716552734, 0.0 ], [ -50.349864959716797, 0.021805552765727 ], [ -50.391944885253906, 0.189722210168839 ], [ -49.675834655761719, 0.319999992847443 ], [ -49.895015716552734, 0.0 ] ] ], [ [ [ -50.437141418457031, -0.0 ], [ -50.539726257324219, -0.023472225293517 ], [ -50.657783508300781, 0.15236109495163 ], [ -50.4727783203125, 0.154166638851166 ], [ -50.437141418457031, -0.0 ] ] ], [ [ [ -91.603622436523438, 0.0 ], [ -91.391815185546875, 0.124722205102444 ], [ -91.202926635742188, -0.032638888806105 ], [ -90.810836791992188, -0.732500076293945 ], [ -90.926597595214844, -0.967500030994415 ], [ -91.440567016601562, -0.996388912200928 ], [ -91.454727172851562, -0.79972231388092 ], [ -91.08367919921875, -0.589757025241852 ], [ -91.436042785644531, -0.017916670069098 ], [ -91.603622436523438, 0.0 ] ] ], [ [ [ -49.769828796386719, 0.0 ], [ -49.524169921875, 0.075277775526047 ], [ -49.381111145019531, -0.068611115217209 ], [ -49.694725036621094, -0.156388908624649 ], [ -49.839729309082031, -0.098888888955116 ], [ -49.769828796386719, 0.0 ] ] ], [ [ [ -50.90167236328125, -0.047500006854534 ], [ -50.834171295166016, 0.059166662395 ], [ -50.697917938232422, 0.019722221419215 ], [ -50.707363128662109, 0.006388888228685 ], [ -50.90167236328125, -0.047500006854534 ] ] ], [ [ [ -50.857780456542969, -0.283055603504181 ], [ -51.027229309082031, -0.224166691303253 ], [ -50.9727783203125, -0.090000003576279 ], [ -50.5625, -0.054166667163372 ], [ -50.857780456542969, -0.283055603504181 ] ] ], [ [ [ -48.876670837402344, -1.487777948379517 ], [ -49.672500610351562, -1.776666879653931 ], [ -49.757572174072266, -1.638750076293945 ], [ -49.81298828125, -1.814444541931152 ], [ -50.054309844970703, -1.70847225189209 ], [ -50.579517364501953, -1.798680663108826 ], [ -50.814311981201172, -1.329513907432556 ], [ -50.781112670898438, -1.151944637298584 ], [ -50.569450378417969, -1.101944446563721 ], [ -50.796951293945312, -0.971944451332092 ], [ -50.775001525878906, -0.644166707992554 ], [ -50.557430267333984, -0.678611159324646 ], [ -50.726394653320312, -0.497777819633484 ], [ -50.64666748046875, -0.262500047683716 ], [ -50.328895568847656, -0.100277781486511 ], [ -49.645561218261719, -0.248333334922791 ], [ -49.19000244140625, -0.135833352804184 ], [ -48.4102783203125, -0.26212739944458 ], [ -48.539169311523438, -0.900277853012085 ], [ -48.876670837402344, -1.487777948379517 ] ] ], [ [ [ -51.390007019042969, -0.486111164093018 ], [ -51.2388916015625, -0.201666682958603 ], [ -51.099308013916016, -0.124444462358952 ], [ -51.137504577636719, -0.285277783870697 ], [ -51.390007019042969, -0.486111164093018 ] ] ], [ [ [ -90.6058349609375, -0.375555574893951 ], [ -90.826530456542969, -0.337916702032089 ], [ -90.834732055664062, -0.176944464445114 ], [ -90.598892211914062, -0.231666684150696 ], [ -90.6058349609375, -0.375555574893951 ] ] ], [ [ [ -50.846946716308594, -0.36305558681488 ], [ -50.902782440185547, -0.346388936042786 ], [ -50.751461029052734, -0.227916672825813 ], [ -50.763336181640625, -0.330277800559998 ], [ -50.846946716308594, -0.36305558681488 ] ] ], [ [ [ -91.4989013671875, -0.496111154556274 ], [ -91.663894653320312, -0.316111147403717 ], [ -91.469032287597656, -0.249444484710693 ], [ -91.396675109863281, -0.440000027418137 ], [ -91.4989013671875, -0.496111154556274 ] ] ], [ [ [ -51.115562438964844, -0.544166684150696 ], [ -51.130142211914062, -0.399305582046509 ], [ -51.030559539794922, -0.285555601119995 ], [ -50.948474884033203, -0.357916712760925 ], [ -51.047500610351562, -0.398888945579529 ], [ -51.115562438964844, -0.544166684150696 ] ] ], [ [ [ -50.983894348144531, -0.576388955116272 ], [ -50.878334045410156, -0.385277807712555 ], [ -50.776947021484375, -0.383888900279999 ], [ -50.796951293945312, -0.485277831554413 ], [ -50.983894348144531, -0.576388955116272 ] ] ], [ [ [ -51.072227478027344, -0.554166674613953 ], [ -51.061393737792969, -0.472777783870697 ], [ -50.902225494384766, -0.37868058681488 ], [ -50.959728240966797, -0.507361173629761 ], [ -51.072227478027344, -0.554166674613953 ] ] ], [ [ [ -90.338623046875, -0.781388998031616 ], [ -90.539588928222656, -0.691944479942322 ], [ -90.488067626953125, -0.528333425521851 ], [ -90.187095642089844, -0.546250104904175 ], [ -90.338623046875, -0.781388998031616 ] ] ], [ [ [ -51.901390075683594, -1.476666688919067 ], [ -51.884860992431641, -1.183402895927429 ], [ -51.662223815917969, -1.083333492279053 ], [ -51.609725952148438, -0.733888983726501 ], [ -51.198333740234375, -0.530277848243713 ], [ -51.276809692382812, -1.020000100135803 ], [ -51.901390075683594, -1.476666688919067 ] ] ], [ [ [ -51.140007019042969, -0.962222337722778 ], [ -51.070281982421875, -0.694444537162781 ], [ -50.813613891601562, -0.576111137866974 ], [ -50.823757171630859, -0.691527843475342 ], [ -50.923614501953125, -0.719722270965576 ], [ -51.140007019042969, -0.962222337722778 ] ] ], [ [ [ -89.533340454101562, -0.958611130714417 ], [ -89.617507934570312, -0.897916674613953 ], [ -89.257232666015625, -0.689444482326508 ], [ -89.415840148925781, -0.920000076293945 ], [ -89.533340454101562, -0.958611130714417 ] ] ], [ [ [ -50.935279846191406, -0.846388936042786 ], [ -50.918754577636719, -0.726527869701385 ], [ -50.842781066894531, -0.72777783870697 ], [ -50.850559234619141, -0.814583420753479 ], [ -50.935279846191406, -0.846388936042786 ] ] ], [ [ [ -51.387504577636719, -1.215000152587891 ], [ -51.248893737792969, -1.024722337722778 ], [ -51.203056335449219, -0.841666698455811 ], [ -51.239448547363281, -1.1438889503479 ], [ -51.387504577636719, -1.215000152587891 ] ] ], [ [ [ -50.973045349121094, -0.868979692459106 ], [ -51.019447326660156, -0.991666674613953 ], [ -51.178058624267578, -1.09208345413208 ], [ -51.140838623046875, -0.986111164093018 ], [ -50.973045349121094, -0.868979692459106 ] ] ], [ [ [ -46.524169921875, -1.022222280502319 ], [ -46.536670684814453, -0.939305603504181 ], [ -46.47125244140625, -0.880833387374878 ], [ -46.440280914306641, -1.003333449363708 ], [ -46.524169921875, -1.022222280502319 ] ] ], [ [ [ -48.3477783203125, -1.218888998031616 ], [ -48.466323852539062, -1.155555605888367 ], [ -48.4107666015625, -1.074930667877197 ], [ -48.324932098388672, -1.074305653572083 ], [ -48.3477783203125, -1.218888998031616 ] ] ], [ [ [ -45.6763916015625, -1.361944675445557 ], [ -45.689723968505859, -1.358472347259521 ], [ -45.628753662109375, -1.127916693687439 ], [ -45.634170532226562, -1.346389055252075 ], [ -45.6763916015625, -1.361944675445557 ] ] ], [ [ [ -90.440567016601562, -1.356111288070679 ], [ -90.523056030273438, -1.306666851043701 ], [ -90.479034423828125, -1.218472361564636 ], [ -90.369171142578125, -1.263819575309753 ], [ -90.440567016601562, -1.356111288070679 ] ] ], [ [ [ -44.993614196777344, -1.402500152587891 ], [ -44.975563049316406, -1.261666774749756 ], [ -44.878128051757812, -1.286944627761841 ], [ -44.884170532226562, -1.33222222328186 ], [ -44.993614196777344, -1.402500152587891 ] ] ], [ [ [ -52.4183349609375, -1.527500152587891 ], [ -52.431114196777344, -1.466388940811157 ], [ -52.168617248535156, -1.408333539962769 ], [ -52.259170532226562, -1.468611240386963 ], [ -52.4183349609375, -1.527500152587891 ] ] ], [ [ [ -52.200836181640625, -1.646666765213013 ], [ -52.172225952148438, -1.497222423553467 ], [ -51.915145874023438, -1.520277857780457 ], [ -52.162506103515625, -1.599583387374878 ], [ -52.200836181640625, -1.646666765213013 ] ] ], [ [ [ -44.769172668457031, -1.672222375869751 ], [ -44.783340454101562, -1.619166851043701 ], [ -44.6844482421875, -1.566250085830688 ], [ -44.661666870117188, -1.660486221313477 ], [ -44.769172668457031, -1.672222375869751 ] ] ], [ [ [ -48.970840454101562, -1.79972243309021 ], [ -49.046531677246094, -1.708333492279053 ], [ -48.911811828613281, -1.575833559036255 ], [ -48.900840759277344, -1.630000114440918 ], [ -48.970840454101562, -1.79972243309021 ] ] ], [ [ [ -49.138618469238281, -1.866944551467896 ], [ -49.0987548828125, -1.748472332954407 ], [ -49.054862976074219, -1.72284734249115 ], [ -49.024169921875, -1.829166889190674 ], [ -49.138618469238281, -1.866944551467896 ] ] ], [ [ [ -50.846115112304688, -2.003889083862305 ], [ -51.036117553710938, -1.975833415985107 ], [ -51.143962860107422, -1.824514031410217 ], [ -50.865695953369141, -1.909027814865112 ], [ -50.846115112304688, -2.003889083862305 ] ] ], [ [ [ -80.211395263671875, -3.036666870117188 ], [ -80.20806884765625, -2.72611141204834 ], [ -79.902786254882812, -2.722083568572998 ], [ -80.123336791992188, -3.014861345291138 ], [ -80.211395263671875, -3.036666870117188 ] ] ], [ [ [ -44.590003967285156, -3.062777996063232 ], [ -44.577507019042969, -2.801944732666016 ], [ -44.483894348144531, -2.710000038146973 ], [ -44.494724273681641, -2.948125123977661 ], [ -44.590003967285156, -3.062777996063232 ] ] ], [ [ [ -38.77972412109375, -13.135278701782227 ], [ -38.794307708740234, -13.060139656066895 ], [ -38.6446533203125, -12.891806602478027 ], [ -38.595142364501953, -12.99083423614502 ], [ -38.77972412109375, -13.135278701782227 ] ] ], [ [ [ -38.941390991210938, -13.565279006958008 ], [ -39.042087554931641, -13.459723472595215 ], [ -39.033542633056641, -13.392431259155273 ], [ -38.903892517089844, -13.395278930664062 ], [ -38.941390991210938, -13.565279006958008 ] ] ], [ [ [ -44.323890686035156, -23.221111297607422 ], [ -44.366809844970703, -23.163612365722656 ], [ -44.231670379638672, -23.07166862487793 ], [ -44.084587097167969, -23.168821334838867 ], [ -44.323890686035156, -23.221111297607422 ] ] ], [ [ [ -45.243339538574219, -23.96722412109375 ], [ -45.447917938232422, -23.917501449584961 ], [ -45.321949005126953, -23.726947784423828 ], [ -45.222366333007812, -23.777362823486328 ], [ -45.243339538574219, -23.96722412109375 ] ] ], [ [ [ -46.317848205566406, -23.931365966796875 ], [ -46.284225463867188, -23.987703323364258 ], [ -46.410530090332031, -23.956808090209961 ], [ -46.386905670166016, -23.924097061157227 ], [ -46.317848205566406, -23.931365966796875 ] ] ], [ [ [ -48.585838317871094, -26.425556182861328 ], [ -48.705696105957031, -26.308820724487305 ], [ -48.526390075683594, -26.170558929443359 ], [ -48.485000610351562, -26.231529235839844 ], [ -48.585838317871094, -26.425556182861328 ] ] ], [ [ [ -48.556671142578125, -27.822780609130859 ], [ -48.517780303955078, -27.433197021484375 ], [ -48.413543701171875, -27.392917633056641 ], [ -48.406394958496094, -27.592781066894531 ], [ -48.556671142578125, -27.822780609130859 ] ] ], [ [ [ -61.893333435058594, -39.243614196777344 ], [ -62.061115264892578, -39.166671752929688 ], [ -62.092365264892578, -39.087642669677734 ], [ -61.890003204345703, -39.140487670898438 ], [ -61.893333435058594, -39.243614196777344 ] ] ], [ [ [ -74.25250244140625, -42.991668701171875 ], [ -74.061813354492188, -41.8134765625 ], [ -73.503341674804688, -41.841533660888672 ], [ -73.380279541015625, -42.285003662109375 ], [ -73.667228698730469, -42.358753204345703 ], [ -73.616744995117188, -42.510700225830078 ], [ -73.820976257324219, -42.514312744140625 ], [ -73.500633239746094, -42.800350189208984 ], [ -73.652091979980469, -42.935417175292969 ], [ -73.491607666015625, -43.115833282470703 ], [ -73.78021240234375, -43.127429962158203 ], [ -73.714736938476562, -43.370285034179688 ], [ -73.866462707519531, -43.398197174072266 ], [ -74.389175415039062, -43.267227172851562 ], [ -74.25250244140625, -42.991668701171875 ] ] ], [ [ [ -73.436508178710938, -42.554939270019531 ], [ -73.625701904296875, -42.447917938232422 ], [ -73.650421142578125, -42.379863739013672 ], [ -73.533760070800781, -42.386947631835938 ], [ -73.436508178710938, -42.554939270019531 ] ] ], [ [ [ -74.785568237304688, -43.648895263671875 ], [ -74.857368469238281, -43.557640075683594 ], [ -74.634521484375, -43.601810455322266 ], [ -74.737503051757812, -43.622505187988281 ], [ -74.785568237304688, -43.648895263671875 ] ] ], [ [ [ -73.992782592773438, -43.94000244140625 ], [ -74.152992248535156, -43.820350646972656 ], [ -73.78973388671875, -43.821670532226562 ], [ -73.7640380859375, -43.889308929443359 ], [ -73.992782592773438, -43.94000244140625 ] ] ], [ [ [ -73.165283203125, -44.029167175292969 ], [ -73.283897399902344, -43.983058929443359 ], [ -73.2569580078125, -43.908889770507812 ], [ -73.1400146484375, -43.8961181640625 ], [ -73.165283203125, -44.029167175292969 ] ] ], [ [ [ -73.656402587890625, -44.137504577636719 ], [ -73.755424499511719, -43.9969482421875 ], [ -73.728622436523438, -43.938896179199219 ], [ -73.634445190429688, -44.010002136230469 ], [ -73.656402587890625, -44.137504577636719 ] ] ], [ [ [ -73.866668701171875, -44.199172973632812 ], [ -73.977645874023438, -44.180976867675781 ], [ -74.01153564453125, -44.144725799560547 ], [ -73.915557861328125, -44.101394653320312 ], [ -73.866668701171875, -44.199172973632812 ] ] ], [ [ [ -74.007232666015625, -44.332504272460938 ], [ -74.12445068359375, -44.199932098388672 ], [ -74.063339233398438, -44.151531219482422 ], [ -73.950836181640625, -44.240562438964844 ], [ -74.007232666015625, -44.332504272460938 ] ] ], [ [ [ -73.8558349609375, -44.338340759277344 ], [ -73.955009460449219, -44.324867248535156 ], [ -73.972366333007812, -44.280422210693359 ], [ -73.800979614257812, -44.273338317871094 ], [ -73.8558349609375, -44.338340759277344 ] ] ], [ [ [ -73.96728515625, -44.434829711914062 ], [ -74.071395874023438, -44.395004272460938 ], [ -74.106529235839844, -44.326808929443359 ], [ -73.931190490722656, -44.357295989990234 ], [ -73.96728515625, -44.434829711914062 ] ] ], [ [ [ -72.870407104492188, -44.738052368164062 ], [ -73.276954650878906, -44.941112518310547 ], [ -73.408065795898438, -44.823890686035156 ], [ -73.206954956054688, -44.800418853759766 ], [ -73.462989807128906, -44.646114349365234 ], [ -72.998062133789062, -44.367225646972656 ], [ -72.718338012695312, -44.535282135009766 ], [ -72.978683471679688, -44.608058929443359 ], [ -72.870407104492188, -44.738052368164062 ] ] ], [ [ [ -74.40167236328125, -44.550834655761719 ], [ -74.542579650878906, -44.462574005126953 ], [ -74.218894958496094, -44.465557098388672 ], [ -74.412506103515625, -44.512779235839844 ], [ -74.40167236328125, -44.550834655761719 ] ] ], [ [ [ -74.0452880859375, -44.558059692382812 ], [ -74.12945556640625, -44.532501220703125 ], [ -74.12945556640625, -44.448333740234375 ], [ -73.957786560058594, -44.485004425048828 ], [ -74.0452880859375, -44.558059692382812 ] ] ], [ [ [ -74.3255615234375, -44.581672668457031 ], [ -74.292373657226562, -44.502918243408203 ], [ -74.139175415039062, -44.550559997558594 ], [ -74.189727783203125, -44.560562133789062 ], [ -74.3255615234375, -44.581672668457031 ] ] ], [ [ [ -73.745559692382812, -44.743614196777344 ], [ -73.8255615234375, -44.584724426269531 ], [ -73.692367553710938, -44.543613433837891 ], [ -73.591400146484375, -44.712085723876953 ], [ -73.745559692382812, -44.743614196777344 ] ] ], [ [ [ -74.785842895507812, -44.687782287597656 ], [ -74.82501220703125, -44.628616333007812 ], [ -74.807228088378906, -44.550422668457031 ], [ -74.726119995117188, -44.5977783203125 ], [ -74.785842895507812, -44.687782287597656 ] ] ], [ [ [ -74.2630615234375, -44.807502746582031 ], [ -74.410980224609375, -44.6370849609375 ], [ -73.874099731445312, -44.693477630615234 ], [ -74.015838623046875, -44.721115112304688 ], [ -74.2630615234375, -44.807502746582031 ] ] ], [ [ [ -74.4666748046875, -44.699447631835938 ], [ -74.628890991210938, -44.698333740234375 ], [ -74.673614501953125, -44.668617248535156 ], [ -74.552780151367188, -44.623611450195312 ], [ -74.4666748046875, -44.699447631835938 ] ] ], [ [ [ -74.385009765625, -44.860282897949219 ], [ -74.465003967285156, -44.830211639404297 ], [ -74.528129577636719, -44.746112823486328 ], [ -74.427230834960938, -44.721393585205078 ], [ -74.385009765625, -44.860282897949219 ] ] ], [ [ [ -73.692184448242188, -44.837081909179688 ], [ -73.746673583984375, -44.756320953369141 ], [ -73.606674194335938, -44.743335723876953 ], [ -73.618751525878906, -44.828338623046875 ], [ -73.692184448242188, -44.837081909179688 ] ] ], [ [ [ -73.844436645507812, -44.957435607910156 ], [ -73.930007934570312, -44.883056640625 ], [ -73.900283813476562, -44.773612976074219 ], [ -73.770278930664062, -44.902229309082031 ], [ -73.844436645507812, -44.957435607910156 ] ] ], [ [ [ -74.041946411132812, -44.858894348144531 ], [ -74.17083740234375, -44.827224731445312 ], [ -74.184585571289062, -44.815834045410156 ], [ -73.965568542480469, -44.778614044189453 ], [ -74.041946411132812, -44.858894348144531 ] ] ], [ [ [ -75.085556030273438, -44.927223205566406 ], [ -75.150283813476562, -44.828895568847656 ], [ -75.092369079589844, -44.776535034179688 ], [ -75.023063659667969, -44.847919464111328 ], [ -75.085556030273438, -44.927223205566406 ] ] ], [ [ [ -74.277236938476562, -45.030838012695312 ], [ -74.1683349609375, -44.866668701171875 ], [ -73.912094116210938, -44.955421447753906 ], [ -74.190284729003906, -44.994586944580078 ], [ -74.277236938476562, -45.030838012695312 ] ] ], [ [ [ -73.731399536132812, -45.284446716308594 ], [ -74.224723815917969, -45.169586181640625 ], [ -74.239036560058594, -45.075557708740234 ], [ -73.8466796875, -45.002784729003906 ], [ -73.731399536132812, -45.284446716308594 ] ] ], [ [ [ -74.336410522460938, -45.298271179199219 ], [ -74.420150756835938, -45.240283966064453 ], [ -74.392364501953125, -45.154586791992188 ], [ -74.272232055664062, -45.212089538574219 ], [ -74.336410522460938, -45.298271179199219 ] ] ], [ [ [ -74.000564575195312, -45.357223510742188 ], [ -74.166122436523438, -45.250556945800781 ], [ -73.784454345703125, -45.31195068359375 ], [ -73.802230834960938, -45.349449157714844 ], [ -74.000564575195312, -45.357223510742188 ] ] ], [ [ [ -74.387786865234375, -45.397781372070312 ], [ -74.493057250976562, -45.352226257324219 ], [ -74.522850036621094, -45.299793243408203 ], [ -74.377227783203125, -45.295005798339844 ], [ -74.387786865234375, -45.397781372070312 ] ] ], [ [ [ -73.920562744140625, -45.434173583984375 ], [ -74.023895263671875, -45.403339385986328 ], [ -73.824310302734375, -45.375560760498047 ], [ -73.823341369628906, -45.408336639404297 ], [ -73.920562744140625, -45.434173583984375 ] ] ], [ [ [ -74.139175415039062, -45.579444885253906 ], [ -74.060142517089844, -45.422920227050781 ], [ -73.819931030273438, -45.460487365722656 ], [ -73.864593505859375, -45.567085266113281 ], [ -74.045700073242188, -45.517364501953125 ], [ -74.139175415039062, -45.579444885253906 ] ] ], [ [ [ -73.652511596679688, -45.761116027832031 ], [ -73.781951904296875, -45.670280456542969 ], [ -73.704032897949219, -45.444725036621094 ], [ -73.582023620605469, -45.470977783203125 ], [ -73.652511596679688, -45.761116027832031 ] ] ], [ [ [ -74.4586181640625, -45.779167175292969 ], [ -74.446670532226562, -45.487503051757812 ], [ -74.302505493164062, -45.47528076171875 ], [ -74.228897094726562, -45.673057556152344 ], [ -74.4586181640625, -45.779167175292969 ] ] ], [ [ [ -73.986953735351562, -45.724723815917969 ], [ -74.111396789550781, -45.617225646972656 ], [ -74.028900146484375, -45.538612365722656 ], [ -73.896812438964844, -45.617782592773438 ], [ -73.986953735351562, -45.724723815917969 ] ] ], [ [ [ -74.70135498046875, -45.732124328613281 ], [ -74.669174194335938, -45.617782592773438 ], [ -74.541259765625, -45.582782745361328 ], [ -74.580558776855469, -45.740558624267578 ], [ -74.70135498046875, -45.732124328613281 ] ] ], [ [ [ -74.023056030273438, -45.918891906738281 ], [ -74.105140686035156, -45.786945343017578 ], [ -74.034172058105469, -45.736946105957031 ], [ -73.962509155273438, -45.788063049316406 ], [ -74.023056030273438, -45.918891906738281 ] ] ], [ [ [ -73.908615112304688, -45.989173889160156 ], [ -73.902511596679688, -45.873611450195312 ], [ -73.726676940917969, -45.801254272460938 ], [ -73.700004577636719, -45.893753051757812 ], [ -73.803199768066406, -45.885417938232422 ], [ -73.908615112304688, -45.989173889160156 ] ] ], [ [ [ -75.071395874023438, -46.097457885742188 ], [ -74.951950073242188, -46.009864807128906 ], [ -75.104179382324219, -45.876113891601562 ], [ -74.722305297851562, -45.80340576171875 ], [ -74.8033447265625, -46.032501220703125 ], [ -75.071395874023438, -46.097457885742188 ] ] ], [ [ [ -73.688613891601562, -46.030006408691406 ], [ -73.819938659667969, -45.997570037841797 ], [ -73.778060913085938, -45.905006408691406 ], [ -73.7086181640625, -45.925285339355469 ], [ -73.688613891601562, -46.030006408691406 ] ] ], [ [ [ -73.773056030273438, -46.211944580078125 ], [ -73.934867858886719, -46.071666717529297 ], [ -73.909454345703125, -46.018611907958984 ], [ -73.683334350585938, -46.076667785644531 ], [ -73.773056030273438, -46.211944580078125 ] ] ], [ [ [ -74.171112060546875, -47.174446105957031 ], [ -74.185981750488281, -47.027225494384766 ], [ -73.976676940917969, -47.053615570068359 ], [ -74.08056640625, -47.149169921875 ], [ -74.171112060546875, -47.174446105957031 ] ] ], [ [ [ -74.465286254882812, -47.160560607910156 ], [ -74.481536865234375, -47.081809997558594 ], [ -74.312370300292969, -47.065559387207031 ], [ -74.332778930664062, -47.108612060546875 ], [ -74.465286254882812, -47.160560607910156 ] ] ], [ [ [ -74.997222900390625, -47.786666870117188 ], [ -75.053070068359375, -47.755561828613281 ], [ -75.076675415039062, -47.697227478027344 ], [ -74.904594421386719, -47.758892059326172 ], [ -74.997222900390625, -47.786666870117188 ] ] ], [ [ [ -75.183013916015625, -47.837844848632812 ], [ -75.300979614257812, -47.772087097167969 ], [ -75.1219482421875, -47.703895568847656 ], [ -75.065841674804688, -47.804794311523438 ], [ -75.183013916015625, -47.837844848632812 ] ] ], [ [ [ -74.3175048828125, -47.983894348144531 ], [ -74.497512817382812, -47.914169311523438 ], [ -74.273475646972656, -47.801254272460938 ], [ -73.800285339355469, -47.891254425048828 ], [ -74.3175048828125, -47.983894348144531 ] ] ], [ [ [ -74.88751220703125, -48.070281982421875 ], [ -75.070121765136719, -47.987808227539062 ], [ -75.264938354492188, -48.030139923095703 ], [ -74.830291748046875, -47.80792236328125 ], [ -74.88751220703125, -48.070281982421875 ] ] ], [ [ [ -75.201004028320312, -48.699790954589844 ], [ -75.295013427734375, -48.436668395996094 ], [ -75.557090759277344, -48.406116485595703 ], [ -75.34722900390625, -48.297988891601562 ], [ -75.550567626953125, -48.313060760498047 ], [ -75.510292053222656, -48.034030914306641 ], [ -75.335845947265625, -48.01861572265625 ], [ -75.0836181640625, -48.508338928222656 ], [ -75.201004028320312, -48.699790954589844 ] ] ], [ [ [ -75.025558471679688, -48.444725036621094 ], [ -75.19500732421875, -48.229171752929688 ], [ -75.253761291503906, -48.072223663330078 ], [ -74.803962707519531, -48.182781219482422 ], [ -75.025558471679688, -48.444725036621094 ] ] ], [ [ [ -74.525558471679688, -48.340278625488281 ], [ -74.599456787109375, -48.235557556152344 ], [ -74.566390991210938, -48.120975494384766 ], [ -74.366676330566406, -48.258472442626953 ], [ -74.525558471679688, -48.340278625488281 ] ] ], [ [ [ -74.623016357421875, -48.692184448242188 ], [ -75.031402587890625, -48.511112213134766 ], [ -74.710426330566406, -48.456394195556641 ], [ -74.738754272460938, -48.123893737792969 ], [ -74.484725952148438, -48.595840454101562 ], [ -74.623016357421875, -48.692184448242188 ] ] ], [ [ [ -74.273056030273438, -48.467781066894531 ], [ -74.458198547363281, -48.386531829833984 ], [ -74.491531372070312, -48.354167938232422 ], [ -74.310005187988281, -48.285556793212891 ], [ -74.273056030273438, -48.467781066894531 ] ] ], [ [ [ -74.065841674804688, -48.49139404296875 ], [ -74.180145263671875, -48.443199157714844 ], [ -74.242782592773438, -48.3719482421875 ], [ -74.062789916992188, -48.421669006347656 ], [ -74.065841674804688, -48.49139404296875 ] ] ], [ [ [ -74.434616088867188, -48.525566101074219 ], [ -74.494033813476562, -48.398338317871094 ], [ -74.301399230957031, -48.478614807128906 ], [ -74.33612060546875, -48.505279541015625 ], [ -74.434616088867188, -48.525566101074219 ] ] ], [ [ [ -75.604721069335938, -48.688880920410156 ], [ -75.441253662109375, -48.616809844970703 ], [ -75.649734497070312, -48.618614196777344 ], [ -75.62139892578125, -48.446529388427734 ], [ -75.3402099609375, -48.435909271240234 ], [ -75.32000732421875, -48.602226257324219 ], [ -75.604721069335938, -48.688880920410156 ] ] ], [ [ [ -75.61279296875, -48.796951293945312 ], [ -75.647636413574219, -48.705486297607422 ], [ -75.283340454101562, -48.695281982421875 ], [ -75.318069458007812, -48.738616943359375 ], [ -75.61279296875, -48.796951293945312 ] ] ], [ [ [ -75.129180908203125, -48.834449768066406 ], [ -75.247573852539062, -48.770072937011719 ], [ -75.068344116210938, -48.635974884033203 ], [ -75.056671142578125, -48.702507019042969 ], [ -75.129180908203125, -48.834449768066406 ] ] ], [ [ [ -75.005844116210938, -48.74444580078125 ], [ -74.99139404296875, -48.648895263671875 ], [ -74.8270263671875, -48.663543701171875 ], [ -74.935836791992188, -48.731391906738281 ], [ -75.005844116210938, -48.74444580078125 ] ] ], [ [ [ -74.762786865234375, -50.055557250976562 ], [ -74.870071411132812, -50.010211944580078 ], [ -74.666603088378906, -49.946949005126953 ], [ -74.88604736328125, -49.957920074462891 ], [ -74.919868469238281, -49.686115264892578 ], [ -74.655632019042969, -49.360767364501953 ], [ -75.0059814453125, -49.511112213134766 ], [ -75.017227172851562, -49.899444580078125 ], [ -75.465843200683594, -49.316181182861328 ], [ -75.167510986328125, -49.50250244140625 ], [ -75.317466735839844, -49.266319274902344 ], [ -74.918060302734375, -49.336112976074219 ], [ -74.827224731445312, -49.095840454101562 ], [ -75.060981750488281, -48.840419769287109 ], [ -74.741539001464844, -48.680278778076172 ], [ -74.523475646972656, -48.753059387207031 ], [ -74.443344116210938, -49.306671142578125 ], [ -74.595039367675781, -49.718334197998047 ], [ -74.467643737792969, -49.625419616699219 ], [ -74.414169311523438, -49.739032745361328 ], [ -74.478889465332031, -49.948337554931641 ], [ -74.762786865234375, -50.055557250976562 ] ] ], [ [ [ -75.206527709960938, -48.994659423828125 ], [ -75.226394653320312, -48.966949462890625 ], [ -75.309516906738281, -48.800075531005859 ], [ -75.082229614257812, -48.889167785644531 ], [ -75.206527709960938, -48.994659423828125 ] ] ], [ [ [ -75.257781982421875, -49.081947326660156 ], [ -75.322509765625, -48.954444885253906 ], [ -75.5, -49.046394348144531 ], [ -75.650848388671875, -48.900558471679688 ], [ -75.314453125, -48.863616943359375 ], [ -75.257781982421875, -49.081947326660156 ] ] ], [ [ [ -75.514175415039062, -49.271949768066406 ], [ -75.656402587890625, -49.213893890380859 ], [ -75.34222412109375, -48.988059997558594 ], [ -75.285423278808594, -49.096809387207031 ], [ -75.514175415039062, -49.271949768066406 ] ] ], [ [ [ -74.952239990234375, -49.278022766113281 ], [ -75.04583740234375, -49.205284118652344 ], [ -75.236328125, -49.136112213134766 ], [ -74.975975036621094, -49.029865264892578 ], [ -74.952239990234375, -49.278022766113281 ] ] ], [ [ [ -74.428741455078125, -49.614517211914062 ], [ -74.449722290039062, -49.485000610351562 ], [ -74.426116943359375, -49.426811218261719 ], [ -74.287094116210938, -49.549587249755859 ], [ -74.428741455078125, -49.614517211914062 ] ] ], [ [ [ -75.179458618164062, -49.90472412109375 ], [ -75.559593200683594, -49.834445953369141 ], [ -75.603477478027344, -49.661533355712891 ], [ -75.359725952148438, -49.624168395996094 ], [ -75.179458618164062, -49.90472412109375 ] ] ], [ [ [ -75.055084228515625, -50.299453735351562 ], [ -75.233894348144531, -50.440559387207031 ], [ -75.217033386230469, -50.307197570800781 ], [ -75.459732055664062, -50.361534118652344 ], [ -75.37445068359375, -50.148338317871094 ], [ -75.145004272460938, -50.249031066894531 ], [ -75.400489807128906, -50.044029235839844 ], [ -74.800697326660156, -50.126670837402344 ], [ -75.055084228515625, -50.299453735351562 ] ] ], [ [ [ -74.757781982421875, -50.500282287597656 ], [ -74.755912780761719, -50.391807556152344 ], [ -74.546539306640625, -50.379447937011719 ], [ -74.557510375976562, -50.405555725097656 ], [ -74.757781982421875, -50.500282287597656 ] ] ], [ [ [ -74.20916748046875, -50.851669311523438 ], [ -74.562789916992188, -50.665283203125 ], [ -74.425559997558594, -50.526252746582031 ], [ -74.667579650878906, -50.478477478027344 ], [ -74.3638916015625, -50.49139404296875 ], [ -74.20916748046875, -50.851669311523438 ] ] ], [ [ [ -75.328125, -50.792671203613281 ], [ -75.514457702636719, -50.65972900390625 ], [ -75.374458312988281, -50.615837097167969 ], [ -75.460769653320312, -50.494098663330078 ], [ -75.09014892578125, -50.503059387207031 ], [ -75.328125, -50.792671203613281 ] ] ], [ [ [ -75.065010070800781, -50.798755645751953 ], [ -75.111885070800781, -50.717918395996094 ], [ -74.989730834960938, -50.654029846191406 ], [ -74.986122131347656, -50.808475494384766 ], [ -75.065010070800781, -50.798755645751953 ] ] ], [ [ [ -74.698898315429688, -50.89111328125 ], [ -74.924873352050781, -50.855697631835938 ], [ -74.952644348144531, -50.728755950927734 ], [ -74.747093200683594, -50.704170227050781 ], [ -74.698898315429688, -50.89111328125 ] ] ], [ [ [ -74.720565795898438, -51.111946105957031 ], [ -74.933067321777344, -50.889865875244141 ], [ -74.616119384765625, -50.895004272460938 ], [ -74.657501220703125, -50.726669311523438 ], [ -74.409454345703125, -50.830558776855469 ], [ -74.39111328125, -51.081531524658203 ], [ -74.477783203125, -50.997920989990234 ], [ -74.720565795898438, -51.111946105957031 ] ] ], [ [ [ -74.281906127929688, -51.218215942382812 ], [ -74.337783813476562, -51.028892517089844 ], [ -74.340980529785156, -50.924587249755859 ], [ -74.192367553710938, -51.198612213134766 ], [ -74.281906127929688, -51.218215942382812 ] ] ], [ [ [ -74.428070068359375, -51.206672668457031 ], [ -74.575706481933594, -51.157920837402344 ], [ -74.601112365722656, -51.075283050537109 ], [ -74.4666748046875, -51.028335571289062 ], [ -74.428070068359375, -51.206672668457031 ] ] ], [ [ [ -74.9888916015625, -51.476394653320312 ], [ -74.793899536132812, -51.209449768066406 ], [ -74.536117553710938, -51.279167175292969 ], [ -74.597511291503906, -51.405422210693359 ], [ -74.9888916015625, -51.476394653320312 ] ] ], [ [ [ -74.078079223632812, -51.377639770507812 ], [ -74.107925415039062, -51.236949920654297 ], [ -73.971260070800781, -51.241043090820312 ], [ -73.955009460449219, -51.329448699951172 ], [ -74.078079223632812, -51.377639770507812 ] ] ], [ [ [ -73.78717041015625, -51.372352600097656 ], [ -73.86944580078125, -51.358062744140625 ], [ -73.915290832519531, -51.303058624267578 ], [ -73.794448852539062, -51.259586334228516 ], [ -73.78717041015625, -51.372352600097656 ] ] ], [ [ [ -59.791389465332031, -51.24945068359375 ], [ -59.483200073242188, -51.263893127441406 ], [ -59.445556640625, -51.320278167724609 ], [ -59.573616027832031, -51.3336181640625 ], [ -59.791389465332031, -51.24945068359375 ] ] ], [ [ [ -60.285263061523438, -51.375648498535156 ], [ -60.290973663330078, -51.266529083251953 ], [ -60.048336029052734, -51.333335876464844 ], [ -60.113613128662109, -51.406810760498047 ], [ -60.285263061523438, -51.375648498535156 ] ] ], [ [ [ -75.310287475585938, -51.634170532226562 ], [ -75.205291748046875, -51.299171447753906 ], [ -75.004730224609375, -51.335838317871094 ], [ -75.153892517089844, -51.577365875244141 ], [ -75.310287475585938, -51.634170532226562 ] ] ], [ [ [ -74.134963989257812, -51.451377868652344 ], [ -74.247230529785156, -51.402225494384766 ], [ -74.259796142578125, -51.299934387207031 ], [ -74.169174194335938, -51.288059234619141 ], [ -74.134963989257812, -51.451377868652344 ] ] ], [ [ [ -58.994728088378906, -51.806671142578125 ], [ -59.023895263671875, -51.676948547363281 ], [ -59.168266296386719, -51.585281372070312 ], [ -58.848617553710938, -51.291389465332031 ], [ -58.412506103515625, -51.323406219482422 ], [ -58.324588775634766, -51.416080474853516 ], [ -58.550285339355469, -51.433616638183594 ], [ -58.24139404296875, -51.650142669677734 ], [ -58.274795532226562, -51.413753509521484 ], [ -57.915420532226562, -51.375282287597656 ], [ -57.772922515869141, -51.543754577636719 ], [ -58.138961791992188, -51.549861907958984 ], [ -57.733196258544922, -51.694446563720703 ], [ -58.420001983642578, -51.900699615478516 ], [ -58.935558319091797, -51.801254272460938 ], [ -58.646949768066406, -52.067222595214844 ], [ -59.251670837402344, -51.991111755371094 ], [ -59.050697326660156, -52.217502593994141 ], [ -59.449794769287109, -52.146739959716797 ], [ -59.348060607910156, -52.343055725097656 ], [ -59.716121673583984, -52.117374420166016 ], [ -59.22125244140625, -51.717086791992188 ], [ -58.994728088378906, -51.806671142578125 ] ] ], [ [ [ -59.953056335449219, -51.983062744140625 ], [ -60.598617553710938, -52.242225646972656 ], [ -60.9808349609375, -52.06195068359375 ], [ -60.459724426269531, -51.970840454101562 ], [ -60.440349578857422, -51.782848358154297 ], [ -60.182849884033203, -51.757850646972656 ], [ -60.634376525878906, -51.725002288818359 ], [ -60.163612365722656, -51.671115875244141 ], [ -60.64361572265625, -51.358058929443359 ], [ -60.127223968505859, -51.494728088378906 ], [ -60.023197174072266, -51.381256103515625 ], [ -59.211669921875, -51.408199310302734 ], [ -59.953056335449219, -51.983062744140625 ] ] ], [ [ [ -74.0224609375, -51.802024841308594 ], [ -74.236679077148438, -51.703891754150391 ], [ -74.088897705078125, -51.539451599121094 ], [ -73.925285339355469, -51.759727478027344 ], [ -74.0224609375, -51.802024841308594 ] ] ], [ [ [ -74.9697265625, -52.118057250976562 ], [ -75.059722900390625, -51.970558166503906 ], [ -74.830703735351562, -51.844722747802734 ], [ -74.933479309082031, -51.646671295166016 ], [ -74.805839538574219, -51.634586334228516 ], [ -74.765426635742188, -51.780002593994141 ], [ -74.9697265625, -52.118057250976562 ] ] ], [ [ [ -73.796676635742188, -51.819168090820312 ], [ -73.856948852539062, -51.801116943359375 ], [ -73.93597412109375, -51.662090301513672 ], [ -73.795280456542969, -51.726531982421875 ], [ -73.796676635742188, -51.819168090820312 ] ] ], [ [ [ -74.163070678710938, -51.953056335449219 ], [ -74.374313354492188, -51.891254425048828 ], [ -74.503341674804688, -51.712642669677734 ], [ -74.090286254882812, -51.877223968505859 ], [ -74.163070678710938, -51.953056335449219 ] ] ], [ [ [ -75.108551025390625, -51.899810791015625 ], [ -75.070846557617188, -51.740280151367188 ], [ -74.968193054199219, -51.729450225830078 ], [ -75.015838623046875, -51.865005493164062 ], [ -75.108551025390625, -51.899810791015625 ] ] ], [ [ [ -60.993057250976562, -51.965835571289062 ], [ -61.112155914306641, -51.895420074462891 ], [ -61.139167785644531, -51.835281372070312 ], [ -60.890838623046875, -51.825836181640625 ], [ -60.993057250976562, -51.965835571289062 ] ] ], [ [ [ -73.859725952148438, -51.902503967285156 ], [ -73.9515380859375, -51.886116027832031 ], [ -73.929595947265625, -51.801670074462891 ], [ -73.819725036621094, -51.870559692382812 ], [ -73.859725952148438, -51.902503967285156 ] ] ], [ [ [ -74.870559692382812, -52.141670227050781 ], [ -74.7550048828125, -51.843055725097656 ], [ -74.600837707519531, -51.843475341796875 ], [ -74.769729614257812, -52.0836181640625 ], [ -74.870559692382812, -52.141670227050781 ] ] ], [ [ [ -73.11358642578125, -52.051658630371094 ], [ -73.056953430175781, -51.933338165283203 ], [ -72.888336181640625, -51.88555908203125 ], [ -72.9898681640625, -52.043338775634766 ], [ -73.11358642578125, -52.051658630371094 ] ] ], [ [ [ -73.72442626953125, -52.224411010742188 ], [ -74.11279296875, -51.998611450195312 ], [ -74.095291137695312, -51.922782897949219 ], [ -73.770561218261719, -52.066532135009766 ], [ -73.72442626953125, -52.224411010742188 ] ] ], [ [ [ -74.724456787109375, -52.065284729003906 ], [ -74.544174194335938, -51.926044464111328 ], [ -74.489593505859375, -51.955005645751953 ], [ -74.501808166503906, -52.0045166015625 ], [ -74.724456787109375, -52.065284729003906 ] ] ], [ [ [ -74.772781372070312, -52.188613891601562 ], [ -74.788887023925781, -52.124515533447266 ], [ -74.612228393554688, -52.060420989990234 ], [ -74.683059692382812, -52.169174194335938 ], [ -74.772781372070312, -52.188613891601562 ] ] ], [ [ [ -74.144668579101562, -52.392837524414062 ], [ -74.145843505859375, -52.197227478027344 ], [ -74.415557861328125, -52.133613586425781 ], [ -74.285568237304688, -52.088615417480469 ], [ -73.934310913085938, -52.323265075683594 ], [ -74.144668579101562, -52.392837524414062 ] ] ], [ [ [ -73.840286254882812, -52.39361572265625 ], [ -73.91473388671875, -52.303062438964844 ], [ -74.094245910644531, -52.166114807128906 ], [ -73.789169311523438, -52.264167785644531 ], [ -73.840286254882812, -52.39361572265625 ] ] ], [ [ [ -74.748611450195312, -52.317779541015625 ], [ -74.820556640625, -52.229446411132812 ], [ -74.622505187988281, -52.205974578857422 ], [ -74.689033508300781, -52.29986572265625 ], [ -74.748611450195312, -52.317779541015625 ] ] ], [ [ [ -73.916946411132812, -52.726951599121094 ], [ -74.05584716796875, -52.569725036621094 ], [ -73.725418090820312, -52.411117553710938 ], [ -73.729446411132812, -52.602500915527344 ], [ -73.916946411132812, -52.726951599121094 ] ] ], [ [ [ -69.177505493164062, -54.580833435058594 ], [ -68.993202209472656, -54.431041717529297 ], [ -70.045982360839844, -54.099308013916016 ], [ -70.1844482421875, -53.813613891601562 ], [ -69.353897094726562, -53.506111145019531 ], [ -69.351951599121094, -53.358894348144531 ], [ -70.217514038085938, -53.473335266113281 ], [ -70.446670532226562, -53.368057250976562 ], [ -70.4444580078125, -53.012779235839844 ], [ -70.099868774414062, -52.907642364501953 ], [ -70.400421142578125, -52.749729156494141 ], [ -69.917236328125, -52.825836181640625 ], [ -69.417228698730469, -52.459449768066406 ], [ -69.15167236328125, -52.6844482421875 ], [ -68.69500732421875, -52.605278015136719 ], [ -68.302780151367188, -52.92333984375 ], [ -68.224174499511719, -53.106254577636719 ], [ -68.36834716796875, -53.003890991210938 ], [ -68.543624877929688, -53.229446411132812 ], [ -68.163200378417969, -53.293754577636719 ], [ -67.563613891601562, -53.918617248535156 ], [ -66.241668701171875, -54.53778076171875 ], [ -65.14007568359375, -54.653266906738281 ], [ -65.350563049316406, -54.927780151367188 ], [ -66.45806884765625, -55.051673889160156 ], [ -67.011337280273438, -54.908615112304688 ], [ -68.635833740234375, -54.788337707519531 ], [ -68.559616088867188, -54.881011962890625 ], [ -68.890007019042969, -54.802921295166016 ], [ -68.748672485351562, -54.900737762451172 ], [ -69.111114501953125, -54.948333740234375 ], [ -69.653480529785156, -54.821395874023438 ], [ -69.627784729003906, -54.695697784423828 ], [ -70.762786865234375, -54.841117858886719 ], [ -70.455703735351562, -54.630695343017578 ], [ -71.036674499511719, -54.777782440185547 ], [ -70.970565795898438, -54.620285034179688 ], [ -71.272781372070312, -54.679725646972656 ], [ -71.335700988769531, -54.522918701171875 ], [ -71.48529052734375, -54.691390991210938 ], [ -71.928070068359375, -54.656951904296875 ], [ -72.009307861328125, -54.507362365722656 ], [ -71.67529296875, -54.576950073242188 ], [ -71.8477783203125, -54.418060302734375 ], [ -71.564727783203125, -54.512779235839844 ], [ -71.602645874023438, -54.406948089599609 ], [ -71.368057250976562, -54.37445068359375 ], [ -70.967788696289062, -54.472640991210938 ], [ -70.8114013671875, -54.320838928222656 ], [ -70.6138916015625, -54.346946716308594 ], [ -70.754180908203125, -54.5947265625 ], [ -70.590003967285156, -54.392505645751953 ], [ -70.134452819824219, -54.543472290039062 ], [ -70.880279541015625, -54.133895874023438 ], [ -70.139175415039062, -54.427780151367188 ], [ -70.198890686035156, -54.313755035400391 ], [ -70.055282592773438, -54.249168395996094 ], [ -69.77362060546875, -54.556114196777344 ], [ -69.859176635742188, -54.283058166503906 ], [ -69.241119384765625, -54.446395874023438 ], [ -69.4183349609375, -54.626392364501953 ], [ -69.37640380859375, -54.686668395996094 ], [ -69.177505493164062, -54.580833435058594 ] ] ], [ [ [ -73.574172973632812, -53.2711181640625 ], [ -73.893341064453125, -53.064727783203125 ], [ -74.326118469238281, -53.093891143798828 ], [ -74.744110107421875, -52.758544921875 ], [ -73.091255187988281, -53.353195190429688 ], [ -73.574172973632812, -53.2711181640625 ] ] ], [ [ [ -73.411666870117188, -52.953895568847656 ], [ -73.532791137695312, -52.884445190429688 ], [ -73.752227783203125, -52.893333435058594 ], [ -73.428619384765625, -52.870838165283203 ], [ -73.411666870117188, -52.953895568847656 ] ] ], [ [ [ -74.056121826171875, -53.252227783203125 ], [ -74.133476257324219, -53.320281982421875 ], [ -74.242225646972656, -53.313613891601562 ], [ -74.105560302734375, -53.228199005126953 ], [ -74.056121826171875, -53.252227783203125 ] ] ], [ [ [ -73.4298095703125, -53.397056579589844 ], [ -73.4898681640625, -53.573890686035156 ], [ -73.800704956054688, -53.431529998779297 ], [ -73.622512817382812, -53.475837707519531 ], [ -73.4298095703125, -53.397056579589844 ] ] ], [ [ [ -73.308624267578125, -53.828895568847656 ], [ -73.249862670898438, -53.712257385253906 ], [ -73.576950073242188, -53.75274658203125 ], [ -73.492500305175781, -53.66680908203125 ], [ -73.613197326660156, -53.612503051757812 ], [ -73.417228698730469, -53.564308166503906 ], [ -73.253890991210938, -53.6602783203125 ], [ -72.954444885253906, -53.667293548583984 ], [ -73.421669006347656, -53.468059539794922 ], [ -73.103195190429688, -53.510696411132812 ], [ -73.075119018554688, -53.402694702148438 ], [ -72.911117553710938, -53.429450988769531 ], [ -72.876258850097656, -53.678684234619141 ], [ -72.859901428222656, -53.466567993164062 ], [ -72.142295837402344, -53.804519653320312 ], [ -72.416954040527344, -53.897087097167969 ], [ -72.327919006347656, -54.041667938232422 ], [ -72.823890686035156, -54.136390686035156 ], [ -73.026329040527344, -54.080348968505859 ], [ -72.776947021484375, -54.017227172851562 ], [ -72.727989196777344, -53.845626831054688 ], [ -73.059036254882812, -53.813823699951172 ], [ -73.13250732421875, -54.011672973632812 ], [ -73.308624267578125, -53.828895568847656 ] ] ], [ [ [ -73.8416748046875, -53.591392517089844 ], [ -73.853057861328125, -53.452503204345703 ], [ -73.689033508300781, -53.519168853759766 ], [ -73.699310302734375, -53.541114807128906 ], [ -73.8416748046875, -53.591392517089844 ] ] ], [ [ [ -70.524444580078125, -54.228614807128906 ], [ -70.819450378417969, -54.1138916015625 ], [ -70.898056030273438, -53.879722595214844 ], [ -70.621116638183594, -53.864170074462891 ], [ -70.70556640625, -53.690837860107422 ], [ -70.491539001464844, -53.557502746582031 ], [ -70.347648620605469, -54.007503509521484 ], [ -70.667930603027344, -53.915699005126953 ], [ -70.524444580078125, -54.228614807128906 ] ] ], [ [ [ -71.671112060546875, -53.943893432617188 ], [ -71.733062744140625, -54.161945343017578 ], [ -71.954452514648438, -54.022502899169922 ], [ -71.743690490722656, -54.231391906738281 ], [ -71.842369079589844, -54.338893890380859 ], [ -72.257095336914062, -53.942436218261719 ], [ -71.671112060546875, -53.943893432617188 ] ] ], [ [ [ -71.281402587890625, -54.013618469238281 ], [ -71.009735107421875, -54.102783203125 ], [ -71.120002746582031, -54.385974884033203 ], [ -71.4112548828125, -54.116531372070312 ], [ -71.540283203125, -54.255699157714844 ], [ -71.698616027832031, -54.163894653320312 ], [ -71.611534118652344, -53.947086334228516 ], [ -71.281402587890625, -54.013618469238281 ] ] ], [ [ [ -73.272506713867188, -54.13555908203125 ], [ -73.457511901855469, -54.082225799560547 ], [ -73.46820068359375, -54.071811676025391 ], [ -73.183334350585938, -54.056396484375 ], [ -73.272506713867188, -54.13555908203125 ] ] ], [ [ [ -70.353897094726562, -54.156112670898438 ], [ -70.4525146484375, -54.117225646972656 ], [ -70.499176025390625, -54.07305908203125 ], [ -70.313064575195312, -54.039726257324219 ], [ -70.353897094726562, -54.156112670898438 ] ] ], [ [ [ -72.294189453125, -54.078903198242188 ], [ -72.301811218261719, -54.253337860107422 ], [ -72.501113891601562, -54.243057250976562 ], [ -72.386947631835938, -54.091392517089844 ], [ -72.294189453125, -54.078903198242188 ] ] ], [ [ [ -70.281402587890625, -54.275558471679688 ], [ -70.467926025390625, -54.234867095947266 ], [ -70.511123657226562, -54.160835266113281 ], [ -70.217231750488281, -54.229030609130859 ], [ -70.281402587890625, -54.275558471679688 ] ] ], [ [ [ -72.463348388671875, -54.430000305175781 ], [ -72.540420532226562, -54.345558166503906 ], [ -72.299034118652344, -54.33514404296875 ], [ -72.304237365722656, -54.366458892822266 ], [ -72.463348388671875, -54.430000305175781 ] ] ], [ [ [ -64.6783447265625, -54.9072265625 ], [ -64.692779541015625, -54.776947021484375 ], [ -63.813755035400391, -54.728614807128906 ], [ -63.954727172851562, -54.81195068359375 ], [ -64.6783447265625, -54.9072265625 ] ] ], [ [ [ -71.060287475585938, -54.955284118652344 ], [ -71.406951904296875, -54.943752288818359 ], [ -71.454307556152344, -54.883613586425781 ], [ -70.915428161621094, -54.926113128662109 ], [ -71.060287475585938, -54.955284118652344 ] ] ], [ [ [ -70.4656982421875, -54.8399658203125 ], [ -70.397018432617188, -54.868892669677734 ], [ -70.744865417480469, -54.872089385986328 ], [ -70.589447021484375, -54.834449768066406 ], [ -70.4656982421875, -54.8399658203125 ] ] ], [ [ [ -69.906112670898438, -55.043060302734375 ], [ -69.8497314453125, -54.878334045410156 ], [ -69.168754577636719, -54.959934234619141 ], [ -69.503890991210938, -55.012504577636719 ], [ -69.906112670898438, -55.043060302734375 ] ] ], [ [ [ -70.350845336914062, -54.898612976074219 ], [ -70.514175415039062, -54.996391296386719 ], [ -70.732505798339844, -55.012847900390625 ], [ -70.28570556640625, -55.033058166503906 ], [ -70.530838012695312, -55.211112976074219 ], [ -71.008064270019531, -55.045005798339844 ], [ -70.350845336914062, -54.898612976074219 ] ] ], [ [ [ -68.066596984863281, -55.237796783447266 ], [ -68.361114501953125, -54.937713623046875 ], [ -67.386672973632812, -54.92083740234375 ], [ -67.055702209472656, -55.072086334228516 ], [ -67.243896484375, -55.308891296386719 ], [ -67.526123046875, -55.17083740234375 ], [ -68.066596984863281, -55.237796783447266 ] ] ], [ [ [ -70.163070678710938, -55.009445190429688 ], [ -70.203620910644531, -54.984031677246094 ], [ -69.979454040527344, -54.935142517089844 ], [ -70.013336181640625, -54.980281829833984 ], [ -70.163070678710938, -55.009445190429688 ] ] ], [ [ [ -68.111953735351562, -55.701393127441406 ], [ -68.360565185546875, -55.481674194335938 ], [ -68.939178466796875, -55.459724426269531 ], [ -68.783340454101562, -55.386116027832031 ], [ -68.912506103515625, -55.34222412109375 ], [ -68.812370300292969, -55.190071105957031 ], [ -69.032791137695312, -55.269172668457031 ], [ -69.249038696289062, -55.137226104736328 ], [ -69.427154541015625, -55.165386199951172 ], [ -69.295013427734375, -55.166530609130859 ], [ -69.388336181640625, -55.290557861328125 ], [ -69.168624877929688, -55.511806488037109 ], [ -69.702232360839844, -55.311115264892578 ], [ -69.505142211914062, -55.178821563720703 ], [ -70.031257629394531, -55.158683776855469 ], [ -69.79278564453125, -55.054725646972656 ], [ -68.404861450195312, -54.955348968505859 ], [ -68.338066101074219, -55.070003509521484 ], [ -68.644729614257812, -55.155281066894531 ], [ -69.059791564941406, -55.050422668457031 ], [ -68.208610534667969, -55.268894195556641 ], [ -68.740142822265625, -55.268825531005859 ], [ -68.163063049316406, -55.397224426269531 ], [ -67.967506408691406, -55.591949462890625 ], [ -68.111953735351562, -55.701393127441406 ] ] ], [ [ [ -67.016326904296875, -54.997123718261719 ], [ -66.859176635742188, -55.028057098388672 ], [ -66.806671142578125, -55.114032745361328 ], [ -67.075004577636719, -55.011112213134766 ], [ -67.016326904296875, -54.997123718261719 ] ] ], [ [ [ -66.581954956054688, -55.285560607910156 ], [ -66.627784729003906, -55.202083587646484 ], [ -66.420631408691406, -55.202083587646484 ], [ -66.511672973632812, -55.268337249755859 ], [ -66.581954956054688, -55.285560607910156 ] ] ], [ [ [ -66.869659423828125, -55.232345581054688 ], [ -66.842849731445312, -55.317779541015625 ], [ -67.061676025390625, -55.324722290039062 ], [ -67.043479919433594, -55.248889923095703 ], [ -66.869659423828125, -55.232345581054688 ] ] ], [ [ [ -67.728622436523438, -55.62445068359375 ], [ -67.688064575195312, -55.501670837402344 ], [ -67.587928771972656, -55.548057556152344 ], [ -67.590560913085938, -55.582229614257812 ], [ -67.728622436523438, -55.62445068359375 ] ] ], [ [ [ -67.338897705078125, -55.790840148925781 ], [ -67.552505493164062, -55.737785339355469 ], [ -67.543060302734375, -55.663753509521484 ], [ -67.353065490722656, -55.575279235839844 ], [ -67.338897705078125, -55.790840148925781 ] ] ], [ [ [ -67.611953735351562, -55.902229309082031 ], [ -67.655014038085938, -55.849449157714844 ], [ -67.855422973632812, -55.841804504394531 ], [ -67.494239807128906, -55.830348968505859 ], [ -67.611953735351562, -55.902229309082031 ] ] ], [ [ [ -67.2469482421875, -55.895004272460938 ], [ -67.3497314453125, -55.863616943359375 ], [ -67.411392211914062, -55.834312438964844 ], [ -67.2469482421875, -55.828056335449219 ], [ -67.2469482421875, -55.895004272460938 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "Oceania" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -177.393341064453125, 28.184158325195312 ], [ -177.387969970703125, 28.214576721191406 ], [ -177.360549926757812, 28.22041130065918 ], [ -177.364578247070312, 28.204021453857422 ], [ -177.393341064453125, 28.184158325195312 ] ] ], [ [ [ -159.451416015625, 21.869991302490234 ], [ -159.754196166992188, 21.979160308837891 ], [ -159.714614868164062, 22.154163360595703 ], [ -159.327484130859375, 22.201656341552734 ], [ -159.451416015625, 21.869991302490234 ] ] ], [ [ [ -160.19976806640625, 21.783603668212891 ], [ -160.227203369140625, 21.891380310058594 ], [ -160.0614013671875, 22.013881683349609 ], [ -160.071136474609375, 21.909160614013672 ], [ -160.19976806640625, 21.783603668212891 ] ] ], [ [ [ -157.813079833984375, 21.258884429931641 ], [ -158.100570678710938, 21.294443130493164 ], [ -158.27349853515625, 21.57777214050293 ], [ -157.94390869140625, 21.684440612792969 ], [ -157.66558837890625, 21.324161529541016 ], [ -157.813079833984375, 21.258884429931641 ] ] ], [ [ [ -156.86749267578125, 21.045829772949219 ], [ -157.06781005859375, 21.10888671875 ], [ -157.304046630859375, 21.097772598266602 ], [ -157.188629150390625, 21.209716796875 ], [ -156.705154418945312, 21.155548095703125 ], [ -156.86749267578125, 21.045829772949219 ] ] ], [ [ [ -156.374176025390625, 20.580829620361328 ], [ -156.688629150390625, 20.886104583740234 ], [ -156.597091674804688, 21.051382064819336 ], [ -155.99334716796875, 20.782493591308594 ], [ -156.374176025390625, 20.580829620361328 ] ] ], [ [ [ -156.907257080078125, 20.737773895263672 ], [ -156.96612548828125, 20.743465423583984 ], [ -157.046417236328125, 20.919021606445312 ], [ -156.812255859375, 20.843608856201172 ], [ -156.907257080078125, 20.737773895263672 ] ] ], [ [ [ -155.823333740234375, 20.272495269775391 ], [ -155.183349609375, 19.985132217407227 ], [ -154.797821044921875, 19.5380859375 ], [ -155.66314697265625, 18.925477981567383 ], [ -155.900299072265625, 19.090339660644531 ], [ -156.048980712890625, 19.73505973815918 ], [ -155.813262939453125, 20.004024505615234 ], [ -155.823333740234375, 20.272495269775391 ] ] ], [ [ [ 166.627593994140625, 19.324577331542969 ], [ 166.658859252929688, 19.311525344848633 ], [ 166.658782958984375, 19.282844543457031 ], [ 166.613861083984375, 19.297218322753906 ], [ 166.627593994140625, 19.324577331542969 ] ] ], [ [ [ -169.5389404296875, 16.724159240722656 ], [ -169.538909912109375, 16.729713439941406 ], [ -169.52392578125, 16.73027229309082 ], [ -169.5389404296875, 16.724159240722656 ] ] ], [ [ [ 145.73468017578125, 15.08721923828125 ], [ 145.695526123046875, 15.178054809570312 ], [ 145.818084716796875, 15.263193130493164 ], [ 145.736831665039062, 15.137706756591797 ], [ 145.73468017578125, 15.08721923828125 ] ] ], [ [ [ 145.624114990234375, 14.908054351806641 ], [ 145.572677612304688, 15.005483627319336 ], [ 145.629959106445312, 15.083609580993652 ], [ 145.662750244140625, 14.976663589477539 ], [ 145.624114990234375, 14.908054351806641 ] ] ], [ [ [ 168.9810791015625, 14.580275535583496 ], [ 168.9852294921875, 14.590553283691406 ], [ 169.001983642578125, 14.594025611877441 ], [ 168.98773193359375, 14.580831527709961 ], [ 168.9810791015625, 14.580275535583496 ] ] ], [ [ [ 144.70941162109375, 13.234996795654297 ], [ 144.655242919921875, 13.427776336669922 ], [ 144.876052856445312, 13.652290344238281 ], [ 144.95330810546875, 13.587497711181641 ], [ 144.70941162109375, 13.234996795654297 ] ] ], [ [ [ 162.332733154296875, 11.350830078125 ], [ 162.324966430664062, 11.352775573730469 ], [ 162.339447021484375, 11.357114791870117 ], [ 162.332733154296875, 11.350830078125 ] ] ], [ [ [ 169.969970703125, 10.432220458984375 ], [ 169.961776733398438, 10.434720993041992 ], [ 169.948776245117188, 10.449719429016113 ], [ 169.962875366210938, 10.444997787475586 ], [ 169.969970703125, 10.432220458984375 ] ] ], [ [ [ 165.5313720703125, 9.196109771728516 ], [ 165.527191162109375, 9.198886871337891 ], [ 165.52581787109375, 9.2142333984375 ], [ 165.537124633789062, 9.201178550720215 ], [ 165.5313720703125, 9.196109771728516 ] ] ], [ [ [ 167.731903076171875, 8.724720001220703 ], [ 167.725372314453125, 8.728053092956543 ], [ 167.739532470703125, 8.745691299438477 ], [ 167.744964599609375, 8.736386299133301 ], [ 167.731903076171875, 8.724720001220703 ] ] ], [ [ [ 134.5313720703125, 7.354443550109863 ], [ 134.4852294921875, 7.438054084777832 ], [ 134.630661010742188, 7.729443550109863 ], [ 134.628570556640625, 7.490276336669922 ], [ 134.5313720703125, 7.354443550109863 ] ] ], [ [ [ 134.513290405273438, 7.305258750915527 ], [ 134.452484130859375, 7.327107906341553 ], [ 134.4600830078125, 7.363206386566162 ], [ 134.516143798828125, 7.343257427215576 ], [ 134.513290405273438, 7.305258750915527 ] ] ], [ [ [ 168.786376953125, 7.288887977600098 ], [ 168.6907958984375, 7.308332443237305 ], [ 168.672332763671875, 7.330138206481934 ], [ 168.768035888671875, 7.298332214355469 ], [ 168.786376953125, 7.288887977600098 ] ] ], [ [ [ 171.361618041992188, 7.136246681213379 ], [ 171.3748779296875, 7.128020286560059 ], [ 171.375625610351562, 7.114462852478027 ], [ 171.361770629882812, 7.120099067687988 ], [ 171.361618041992188, 7.136246681213379 ] ] ], [ [ [ 158.227752685546875, 6.78055477142334 ], [ 158.120162963867188, 6.906110286712646 ], [ 158.182327270507812, 6.977637767791748 ], [ 158.335098266601562, 6.874720573425293 ], [ 158.227752685546875, 6.78055477142334 ] ] ], [ [ [ 168.11358642578125, 5.600276947021484 ], [ 168.094970703125, 5.610693454742432 ], [ 168.126480102539062, 5.638471603393555 ], [ 168.1309814453125, 5.622359752655029 ], [ 168.11358642578125, 5.600276947021484 ] ] ], [ [ [ 163.001922607421875, 5.261666297912598 ], [ 162.905670166015625, 5.307776927947998 ], [ 163.021636962890625, 5.374929428100586 ], [ 163.042892456054688, 5.319999694824219 ], [ 163.001922607421875, 5.261666297912598 ] ] ], [ [ [ -157.235015869140625, 1.704999685287476 ], [ -157.567642211914062, 1.855832934379578 ], [ -157.350006103515625, 1.935693979263306 ], [ -157.505584716796875, 2.028749465942383 ], [ -157.350830078125, 1.971944093704224 ], [ -157.235015869140625, 1.704999685287476 ] ] ], [ [ [ 172.914276123046875, 1.346583127975464 ], [ 172.922988891601562, 1.351775646209717 ], [ 172.947509765625, 1.342429041862488 ], [ 172.9398193359375, 1.335990309715271 ], [ 172.914276123046875, 1.346583127975464 ] ] ], [ [ [ -176.63616943359375, 0.790277719497681 ], [ -176.643081665039062, 0.793610990047455 ], [ -176.642868041992188, 0.808333158493042 ], [ -176.63275146484375, 0.808611035346985 ], [ -176.63616943359375, 0.790277719497681 ] ] ], [ [ [ -176.46142578125, 0.21527773141861 ], [ -176.4676513671875, 0.219444409012794 ], [ -176.455856323242188, 0.22256937623024 ], [ -176.46142578125, 0.21527773141861 ] ] ], [ [ [ -160.021148681640625, -0.398055553436279 ], [ -160.043487548828125, -0.392222285270691 ], [ -160.045166015625, -0.3801389336586 ], [ -160.017791748046875, -0.374722182750702 ], [ -160.021148681640625, -0.398055553436279 ] ] ], [ [ [ 166.92913818359375, -0.55222225189209 ], [ 166.9044189453125, -0.532361149787903 ], [ 166.9305419921875, -0.493333339691162 ], [ 166.957046508789062, -0.514236152172089 ], [ 166.92913818359375, -0.55222225189209 ] ] ], [ [ [ 149.731903076171875, -1.603333473205566 ], [ 149.531936645507812, -1.467638731002808 ], [ 149.5799560546875, -1.35527777671814 ], [ 149.716766357421875, -1.429374814033508 ], [ 149.731903076171875, -1.603333473205566 ] ] ], [ [ [ 147.391937255859375, -1.960833311080933 ], [ 147.446701049804688, -2.012986183166504 ], [ 147.438720703125, -2.063194513320923 ], [ 147.20843505859375, -2.189513683319092 ], [ 146.524993896484375, -2.19083309173584 ], [ 146.638580322265625, -1.978610992431641 ], [ 147.391937255859375, -1.960833311080933 ] ] ], [ [ [ 150.36773681640625, -2.686666488647461 ], [ 150.187332153320312, -2.685555219650269 ], [ 149.950103759765625, -2.470763444900513 ], [ 150.417205810546875, -2.460555553436279 ], [ 150.36773681640625, -2.686666488647461 ] ] ], [ [ [ 152.659423828125, -3.842777729034424 ], [ 153.133026123046875, -4.265833854675293 ], [ 152.900955200195312, -4.822916984558105 ], [ 152.28594970703125, -3.576111078262329 ], [ 150.752349853515625, -2.769444465637207 ], [ 150.8837890625, -2.709340333938599 ], [ 150.805740356445312, -2.566592216491699 ], [ 152.05511474609375, -3.253889083862305 ], [ 152.659423828125, -3.842777729034424 ] ] ], [ [ [ 150.773590087890625, -2.985555648803711 ], [ 150.874954223632812, -2.910694360733032 ], [ 151.021987915039062, -2.968541622161865 ], [ 150.8349609375, -2.960000038146973 ], [ 150.773590087890625, -2.985555648803711 ] ] ], [ [ [ 152.64080810546875, -3.230000019073486 ], [ 152.538177490234375, -3.103333473205566 ], [ 152.602890014648438, -3.047639131546021 ], [ 152.667755126953125, -3.129444122314453 ], [ 152.64080810546875, -3.230000019073486 ] ] ], [ [ [ 151.38470458984375, -5.80720043182373 ], [ 150.46856689453125, -6.276111602783203 ], [ 149.63470458984375, -6.30805492401123 ], [ 149.33856201171875, -6.060138702392578 ], [ 149.0516357421875, -6.159305095672607 ], [ 148.31646728515625, -5.628026008605957 ], [ 148.4285888671875, -5.451111793518066 ], [ 149.22076416015625, -5.606111526489258 ], [ 149.878021240234375, -5.535694122314453 ], [ 150.092330932617188, -5.007778167724609 ], [ 150.20391845703125, -5.071805477142334 ], [ 150.04248046875, -5.308610916137695 ], [ 150.1644287109375, -5.551388740539551 ], [ 150.924407958984375, -5.487221717834473 ], [ 151.264297485351562, -4.985138416290283 ], [ 151.67608642578125, -4.908055305480957 ], [ 151.509994506835938, -4.206111431121826 ], [ 151.970809936523438, -4.336597442626953 ], [ 152.181503295898438, -4.146944999694824 ], [ 152.40582275390625, -4.688888549804688 ], [ 152.237319946289062, -4.987222194671631 ], [ 151.970794677734375, -4.993332862854004 ], [ 152.131072998046875, -5.402222633361816 ], [ 151.822052001953125, -5.60111141204834 ], [ 151.47052001953125, -5.530972480773926 ], [ 151.38470458984375, -5.80720043182373 ] ] ], [ [ [ 154.63720703125, -5.458611488342285 ], [ 154.5302734375, -5.133889198303223 ], [ 154.642623901367188, -5.016388893127441 ], [ 154.728302001953125, -5.216388702392578 ], [ 154.63720703125, -5.458611488342285 ] ] ], [ [ [ 155.404083251953125, -6.0 ], [ 155.914764404296875, -6.520763874053955 ], [ 155.91253662109375, -6.805485725402832 ], [ 155.339889526367188, -6.741458415985107 ], [ 155.21649169921875, -6.324722766876221 ], [ 154.750579833984375, -5.94915771484375 ], [ 154.75360107421875, -5.51805591583252 ], [ 155.073577880859375, -5.561666488647461 ], [ 155.404083251953125, -6.0 ] ] ], [ [ [ 177.290252685546875, -6.114444732666016 ], [ 177.2813720703125, -6.109861373901367 ], [ 177.2813720703125, -6.089444160461426 ], [ 177.305526733398438, -6.105972290039062 ], [ 177.290252685546875, -6.114444732666016 ] ] ], [ [ [ 176.306365966796875, -6.288332939147949 ], [ 176.295257568359375, -6.27458381652832 ], [ 176.306015014648438, -6.260139465332031 ], [ 176.311981201171875, -6.282153129577637 ], [ 176.306365966796875, -6.288332939147949 ] ] ], [ [ [ 157.44384765625, -7.43388843536377 ], [ 156.93206787109375, -7.216389179229736 ], [ 156.441635131835938, -6.639861583709717 ], [ 157.04248046875, -6.901666641235352 ], [ 157.18829345703125, -7.178333282470703 ], [ 157.532272338867188, -7.316666603088379 ], [ 157.44384765625, -7.43388843536377 ] ] ], [ [ [ 155.769134521484375, -7.129444122314453 ], [ 155.671295166015625, -7.091527938842773 ], [ 155.729949951171875, -6.967499732971191 ], [ 155.868972778320312, -7.062708377838135 ], [ 155.769134521484375, -7.129444122314453 ] ] ], [ [ [ 178.69580078125, -7.484166145324707 ], [ 178.688858032226562, -7.480833053588867 ], [ 178.68878173828125, -7.467569828033447 ], [ 178.7017822265625, -7.475208282470703 ], [ 178.69580078125, -7.484166145324707 ] ] ], [ [ [ 159.8641357421875, -8.519721984863281 ], [ 159.8900146484375, -8.55756950378418 ], [ 159.622467041015625, -8.360555648803711 ], [ 158.842178344726562, -7.971458435058594 ], [ 158.487457275390625, -7.554166793823242 ], [ 159.388031005859375, -7.994166374206543 ], [ 159.851211547851562, -8.331944465637207 ], [ 159.8641357421875, -8.519721984863281 ] ] ], [ [ [ 158.5244140625, -7.658888816833496 ], [ 158.359405517578125, -7.640556335449219 ], [ 158.314132690429688, -7.579444885253906 ], [ 158.377456665039062, -7.567222595214844 ], [ 158.5244140625, -7.658888816833496 ] ] ], [ [ [ 156.703033447265625, -7.950833320617676 ], [ 156.500274658203125, -7.698332786560059 ], [ 156.554412841796875, -7.578611373901367 ], [ 156.808303833007812, -7.728749752044678 ], [ 156.703033447265625, -7.950833320617676 ] ] ], [ [ [ 157.150543212890625, -8.151666641235352 ], [ 156.967742919921875, -8.046388626098633 ], [ 157.027679443359375, -7.865346908569336 ], [ 157.18359375, -7.931666374206543 ], [ 157.150543212890625, -8.151666641235352 ] ] ], [ [ [ 156.5941162109375, -8.205278396606445 ], [ 156.53289794921875, -8.094305038452148 ], [ 156.5455322265625, -7.944305419921875 ], [ 156.60858154296875, -8.070833206176758 ], [ 156.5941162109375, -8.205278396606445 ] ] ], [ [ [ 157.811920166015625, -8.620832443237305 ], [ 157.532333374023438, -8.255279541015625 ], [ 157.236358642578125, -8.312221527099609 ], [ 157.424835205078125, -7.992083072662354 ], [ 157.777694702148438, -8.248263359069824 ], [ 157.906158447265625, -8.483123779296875 ], [ 157.811920166015625, -8.620832443237305 ] ] ], [ [ [ 161.22662353515625, -9.117776870727539 ], [ 161.378997802734375, -9.631874084472656 ], [ 160.80816650390625, -9.062639236450195 ], [ 160.580245971679688, -8.334999084472656 ], [ 160.812896728515625, -8.370138168334961 ], [ 161.009979248046875, -8.635557174682617 ], [ 160.944290161132812, -8.816527366638184 ], [ 161.22662353515625, -9.117776870727539 ] ] ], [ [ [ 159.677764892578125, -8.548334121704102 ], [ 159.5374755859375, -8.468332290649414 ], [ 159.56884765625, -8.378887176513672 ], [ 159.644287109375, -8.396389961242676 ], [ 159.677764892578125, -8.548334121704102 ] ] ], [ [ [ 157.384429931640625, -8.734443664550781 ], [ 157.1988525390625, -8.568889617919922 ], [ 157.359893798828125, -8.410834312438965 ], [ 157.327041625976562, -8.644166946411133 ], [ 157.384429931640625, -8.734443664550781 ] ] ], [ [ [ 151.144439697265625, -8.830554962158203 ], [ 151.094970703125, -8.771112442016602 ], [ 151.10107421875, -8.638889312744141 ], [ 150.997528076171875, -8.527084350585938 ], [ 151.07635498046875, -8.426111221313477 ], [ 151.144439697265625, -8.830554962158203 ] ] ], [ [ [ 179.213226318359375, -8.561291694641113 ], [ 179.202407836914062, -8.465419769287109 ], [ 179.231094360351562, -8.50492000579834 ], [ 179.213226318359375, -8.561291694641113 ] ] ], [ [ [ 157.9913330078125, -8.773056030273438 ], [ 157.875518798828125, -8.60999870300293 ], [ 158.094970703125, -8.52458381652832 ], [ 158.10467529296875, -8.698541641235352 ], [ 157.9913330078125, -8.773056030273438 ] ] ], [ [ [ 157.619964599609375, -8.800832748413086 ], [ 157.4932861328125, -8.758335113525391 ], [ 157.447479248046875, -8.711389541625977 ], [ 157.559005737304688, -8.693194389343262 ], [ 157.619964599609375, -8.800832748413086 ] ] ], [ [ [ -140.177825927734375, -8.956390380859375 ], [ -140.236663818359375, -8.783891677856445 ], [ -140.0159912109375, -8.852846145629883 ], [ -140.022659301757812, -8.898056983947754 ], [ -140.177825927734375, -8.956390380859375 ] ] ], [ [ [ 152.83551025390625, -9.235555648803711 ], [ 152.651229858398438, -9.068332672119141 ], [ 152.49871826171875, -9.023334503173828 ], [ 152.81121826171875, -8.971457481384277 ], [ 153.019561767578125, -9.123054504394531 ], [ 152.83551025390625, -9.235555648803711 ] ] ], [ [ [ 159.099395751953125, -9.119720458984375 ], [ 159.031784057617188, -9.06291675567627 ], [ 159.135116577148438, -8.993749618530273 ], [ 159.189956665039062, -9.028680801391602 ], [ 159.099395751953125, -9.119720458984375 ] ] ], [ [ [ 160.264434814453125, -9.131942749023438 ], [ 160.120513916015625, -9.096111297607422 ], [ 160.077056884765625, -9.044305801391602 ], [ 160.243148803710938, -9.004584312438965 ], [ 160.264434814453125, -9.131942749023438 ] ] ], [ [ [ 160.24383544921875, -9.196111679077148 ], [ 160.322052001953125, -9.060277938842773 ], [ 160.408035278320312, -9.132916450500488 ], [ 160.35113525390625, -9.190138816833496 ], [ 160.24383544921875, -9.196111679077148 ] ] ], [ [ [ -171.848052978515625, -9.218889236450195 ], [ -171.862716674804688, -9.180904388427734 ], [ -171.852432250976562, -9.170625686645508 ], [ -171.844192504882812, -9.191112518310547 ], [ -171.848052978515625, -9.218889236450195 ] ] ], [ [ [ 160.82025146484375, -9.829444885253906 ], [ 160.6502685546875, -9.930000305175781 ], [ 159.834335327148438, -9.799166679382324 ], [ 159.601837158203125, -9.320555686950684 ], [ 160.386383056640625, -9.426666259765625 ], [ 160.82025146484375, -9.829444885253906 ] ] ], [ [ [ 161.55609130859375, -9.799167633056641 ], [ 161.397216796875, -9.669445037841797 ], [ 161.351898193359375, -9.341596603393555 ], [ 161.55413818359375, -9.632221221923828 ], [ 161.55609130859375, -9.799167633056641 ] ] ], [ [ [ -139.05474853515625, -9.85999870300293 ], [ -139.167266845703125, -9.760000228881836 ], [ -138.812515258789062, -9.737917900085449 ], [ -139.048629760742188, -9.808196067810059 ], [ -139.05474853515625, -9.85999870300293 ] ] ], [ [ [ 162.292755126953125, -10.729445457458496 ], [ 162.3829345703125, -10.829461097717285 ], [ 161.7783203125, -10.720832824707031 ], [ 161.296981811523438, -10.211874008178711 ], [ 162.106491088867188, -10.449304580688477 ], [ 162.292755126953125, -10.729445457458496 ] ] ], [ [ [ 152.744415283203125, -10.716665267944336 ], [ 152.5738525390625, -10.656944274902344 ], [ 152.542404174804688, -10.632569313049316 ], [ 152.871902465820312, -10.660139083862305 ], [ 152.744415283203125, -10.716665267944336 ] ] ], [ [ [ 165.883026123046875, -10.87360954284668 ], [ 165.808868408203125, -10.73499870300293 ], [ 166.1573486328125, -10.678056716918945 ], [ 166.141860961914062, -10.757987022399902 ], [ 165.883026123046875, -10.87360954284668 ] ] ], [ [ [ -165.8416748046875, -10.890836715698242 ], [ -165.848342895507812, -10.884236335754395 ], [ -165.827651977539062, -10.881319046020508 ], [ -165.8416748046875, -10.890836715698242 ] ] ], [ [ [ 154.1121826171875, -11.439722061157227 ], [ 154.021087646484375, -11.348888397216797 ], [ 154.297760009765625, -11.391944885253906 ], [ 154.136093139648438, -11.400694847106934 ], [ 154.1121826171875, -11.439722061157227 ] ] ], [ [ [ 153.566070556640625, -11.642499923706055 ], [ 153.376068115234375, -11.567222595214844 ], [ 153.199417114257812, -11.322083473205566 ], [ 153.777069091796875, -11.600137710571289 ], [ 153.566070556640625, -11.642499923706055 ] ] ], [ [ [ 160.497467041015625, -11.845832824707031 ], [ 160.01971435546875, -11.602222442626953 ], [ 159.967330932617188, -11.50444507598877 ], [ 160.437057495117188, -11.680000305175781 ], [ 160.497467041015625, -11.845832824707031 ] ] ], [ [ [ 166.84442138671875, -11.697500228881836 ], [ 166.7894287109375, -11.67388916015625 ], [ 166.75970458984375, -11.581110954284668 ], [ 166.92108154296875, -11.64777946472168 ], [ 166.84442138671875, -11.697500228881836 ] ] ], [ [ [ 96.85247802734375, -12.199443817138672 ], [ 96.819442749023438, -12.178056716918945 ], [ 96.8236083984375, -12.130415916442871 ], [ 96.864845275878906, -12.192083358764648 ], [ 96.85247802734375, -12.199443817138672 ] ] ], [ [ [ -176.1650390625, -13.353054046630859 ], [ -176.19110107421875, -13.286945343017578 ], [ -176.158355712890625, -13.214861869812012 ], [ -176.121932983398438, -13.258612632751465 ], [ -176.1650390625, -13.353054046630859 ] ] ], [ [ [ -172.59649658203125, -13.509113311767578 ], [ -172.287796020507812, -13.484165191650391 ], [ -172.212356567382812, -13.80652904510498 ], [ -172.527923583984375, -13.802709579467773 ], [ -172.780029296875, -13.532570838928223 ], [ -172.59649658203125, -13.509113311767578 ] ] ], [ [ [ 167.468292236328125, -13.95111083984375 ], [ 167.38671875, -13.831179618835449 ], [ 167.4720458984375, -13.707221984863281 ], [ 167.5777587890625, -13.847221374511719 ], [ 167.468292236328125, -13.95111083984375 ] ] ], [ [ [ -171.441986083984375, -14.057502746582031 ], [ -171.9111328125, -14.012502670288086 ], [ -172.06475830078125, -13.878193855285645 ], [ -171.822265625, -13.807502746582031 ], [ -171.441986083984375, -14.057502746582031 ] ] ], [ [ [ 167.521087646484375, -14.326944351196289 ], [ 167.394424438476562, -14.300415992736816 ], [ 167.44635009765625, -14.159306526184082 ], [ 167.59857177734375, -14.19416618347168 ], [ 167.521087646484375, -14.326944351196289 ] ] ], [ [ [ -178.060821533203125, -14.323890686035156 ], [ -178.153900146484375, -14.30805778503418 ], [ -178.190277099609375, -14.239723205566406 ], [ -178.127334594726562, -14.248611450195312 ], [ -178.060821533203125, -14.323890686035156 ] ] ], [ [ [ -170.743896484375, -14.375555038452148 ], [ -170.823226928710938, -14.323751449584961 ], [ -170.567916870117188, -14.254306793212891 ], [ -170.561874389648438, -14.270002365112305 ], [ -170.743896484375, -14.375555038452148 ] ] ], [ [ [ 167.107818603515625, -15.123703002929688 ], [ 167.233367919921875, -15.525344848632812 ], [ 166.763595581054688, -15.644583702087402 ], [ 166.552749633789062, -14.656805038452148 ], [ 166.802764892578125, -15.157501220703125 ], [ 167.005325317382812, -14.925764083862305 ], [ 167.107818603515625, -15.123703002929688 ] ] ], [ [ [ 168.13580322265625, -15.396666526794434 ], [ 168.0888671875, -14.951944351196289 ], [ 168.102890014648438, -14.92055606842041 ], [ 168.19329833984375, -15.238611221313477 ], [ 168.13580322265625, -15.396666526794434 ] ] ], [ [ [ 167.846923828125, -15.490833282470703 ], [ 167.669281005859375, -15.444306373596191 ], [ 168.003448486328125, -15.29222297668457 ], [ 167.9305419921875, -15.418889999389648 ], [ 167.846923828125, -15.490833282470703 ] ] ], [ [ [ 168.20440673828125, -15.998332977294922 ], [ 168.112045288085938, -15.678750038146973 ], [ 168.1533203125, -15.492221832275391 ], [ 168.26666259765625, -15.870832443237305 ], [ 168.20440673828125, -15.998332977294922 ] ] ], [ [ [ 167.195526123046875, -15.756111145019531 ], [ 167.091644287109375, -15.707221984863281 ], [ 167.07745361328125, -15.640277862548828 ], [ 167.22509765625, -15.636251449584961 ], [ 167.195526123046875, -15.756111145019531 ] ] ], [ [ [ 167.494964599609375, -16.593334197998047 ], [ 167.376068115234375, -16.190555572509766 ], [ 167.146636962890625, -16.085834503173828 ], [ 167.211090087890625, -15.876110076904297 ], [ 167.824005126953125, -16.426111221313477 ], [ 167.494964599609375, -16.593334197998047 ] ] ], [ [ [ 168.144134521484375, -16.362220764160156 ], [ 167.912887573242188, -16.233470916748047 ], [ 168.16748046875, -16.086112976074219 ], [ 168.3248291015625, -16.30694580078125 ], [ 168.144134521484375, -16.362220764160156 ] ] ], [ [ [ 180.0, -16.172740936279297 ], [ 179.481491088867188, -16.696943283081055 ], [ 179.938644409179688, -16.467948913574219 ], [ 179.900115966796875, -16.7701416015625 ], [ 179.3319091796875, -16.802223205566406 ], [ 179.270462036132812, -16.691318511962891 ], [ 178.7471923828125, -17.011947631835938 ], [ 178.492172241210938, -16.804445266723633 ], [ 178.981903076171875, -16.469718933105469 ], [ 180.0, -16.172740936279297 ] ] ], [ [ [ 168.471343994140625, -16.848888397216797 ], [ 168.170669555664062, -16.806806564331055 ], [ 168.1483154296875, -16.580554962158203 ], [ 168.455108642578125, -16.773473739624023 ], [ 168.471343994140625, -16.848888397216797 ] ] ], [ [ [ -180.0, -16.965728759765625 ], [ -180.0, -16.787363052368164 ], [ -179.8648681640625, -16.679891586303711 ], [ -179.82110595703125, -16.781093597412109 ], [ -180.0, -16.965728759765625 ] ] ], [ [ [ -151.444488525390625, -16.904449462890625 ], [ -151.49169921875, -16.849170684814453 ], [ -151.472518920898438, -16.739721298217773 ], [ -151.351119995117188, -16.84583854675293 ], [ -151.444488525390625, -16.904449462890625 ] ] ], [ [ [ 180.0, -16.787395477294922 ], [ 180.0, -16.965724945068359 ], [ 179.92913818359375, -17.006111145019531 ], [ 179.883575439453125, -16.961664199829102 ], [ 180.0, -16.787395477294922 ] ] ], [ [ [ 177.4730224609375, -18.162776947021484 ], [ 177.258041381835938, -17.87208366394043 ], [ 177.624664306640625, -17.444721221923828 ], [ 178.1907958984375, -17.302501678466797 ], [ 178.594680786132812, -17.639444351196289 ], [ 178.694839477539062, -18.052083969116211 ], [ 178.588287353515625, -18.135276794433594 ], [ 178.019134521484375, -18.267780303955078 ], [ 177.4730224609375, -18.162776947021484 ] ] ], [ [ [ -149.85443115234375, -17.574447631835938 ], [ -149.937255859375, -17.484165191650391 ], [ -149.785293579101562, -17.471250534057617 ], [ -149.798492431640625, -17.527782440185547 ], [ -149.85443115234375, -17.574447631835938 ] ] ], [ [ [ -149.17919921875, -17.870834350585938 ], [ -149.590576171875, -17.711391448974609 ], [ -149.63250732421875, -17.549999237060547 ], [ -149.359161376953125, -17.534450531005859 ], [ -149.17919921875, -17.870834350585938 ] ] ], [ [ [ 168.3841552734375, -17.830001831054688 ], [ 168.148452758789062, -17.716665267944336 ], [ 168.31109619140625, -17.531391143798828 ], [ 168.574676513671875, -17.692775726318359 ], [ 168.3841552734375, -17.830001831054688 ] ] ], [ [ [ 178.77191162109375, -17.754447937011719 ], [ 178.74969482421875, -17.653472900390625 ], [ 178.83135986328125, -17.626665115356445 ], [ 178.849700927734375, -17.715274810791016 ], [ 178.77191162109375, -17.754447937011719 ] ] ], [ [ [ 179.341644287109375, -18.122501373291016 ], [ 179.24578857421875, -18.036388397216797 ], [ 179.269989013671875, -17.935832977294922 ], [ 179.354263305664062, -18.011528015136719 ], [ 179.341644287109375, -18.122501373291016 ] ] ], [ [ [ -163.169464111328125, -18.091949462890625 ], [ -163.171279907226562, -18.084169387817383 ], [ -163.15472412109375, -18.061458587646484 ], [ -163.157257080078125, -18.080558776855469 ], [ -163.169464111328125, -18.091949462890625 ] ] ], [ [ [ -173.939208984375, -18.568893432617188 ], [ -173.908905029296875, -18.63555908203125 ], [ -174.063079833984375, -18.659303665161133 ], [ -174.003219604492188, -18.578197479248047 ], [ -173.939208984375, -18.568893432617188 ] ] ], [ [ [ 169.271087646484375, -19.0 ], [ 168.986495971679688, -18.876667022705078 ], [ 169.03997802734375, -18.625831604003906 ], [ 169.32330322265625, -18.889720916748047 ], [ 169.271087646484375, -19.0 ] ] ], [ [ [ 178.0941162109375, -19.162776947021484 ], [ 177.952178955078125, -19.129583358764648 ], [ 178.306915283203125, -18.935554504394531 ], [ 178.49432373046875, -18.974788665771484 ], [ 178.0941162109375, -19.162776947021484 ] ] ], [ [ [ -169.893890380859375, -19.145557403564453 ], [ -169.930282592773438, -19.013612747192383 ], [ -169.815139770507812, -18.97027587890625 ], [ -169.78155517578125, -19.065280914306641 ], [ -169.893890380859375, -19.145557403564453 ] ] ], [ [ [ 169.431365966796875, -19.658054351806641 ], [ 169.233856201171875, -19.527500152587891 ], [ 169.248291015625, -19.338054656982422 ], [ 169.49774169921875, -19.531112670898438 ], [ 169.431365966796875, -19.658054351806641 ] ] ], [ [ [ -157.713043212890625, -19.857227325439453 ], [ -157.740814208984375, -19.817642211914062 ], [ -157.712295532226562, -19.773128509521484 ], [ -157.703765869140625, -19.836807250976562 ], [ -157.713043212890625, -19.857227325439453 ] ] ], [ [ [ -158.116668701171875, -20.019172668457031 ], [ -158.125396728515625, -19.978471755981445 ], [ -158.094757080078125, -19.974170684814453 ], [ -158.081390380859375, -19.996387481689453 ], [ -158.116668701171875, -20.019172668457031 ] ] ], [ [ [ 166.451904296875, -22.316665649414062 ], [ 166.116363525390625, -21.946388244628906 ], [ 164.904144287109375, -21.268611907958984 ], [ 164.172607421875, -20.503475189208984 ], [ 163.995513916015625, -20.087917327880859 ], [ 165.223297119140625, -20.765277862548828 ], [ 165.63079833984375, -21.27972412109375 ], [ 167.028045654296875, -22.232776641845703 ], [ 166.929412841796875, -22.397499084472656 ], [ 166.451904296875, -22.316665649414062 ] ] ], [ [ [ 169.826904296875, -20.254169464111328 ], [ 169.737045288085938, -20.206110000610352 ], [ 169.744949340820312, -20.150762557983398 ], [ 169.888809204101562, -20.173610687255859 ], [ 169.826904296875, -20.254169464111328 ] ] ], [ [ [ 166.499114990234375, -20.717777252197266 ], [ 166.56317138671875, -20.399513244628906 ], [ 166.609130859375, -20.389583587646484 ], [ 166.624404907226562, -20.602777481079102 ], [ 166.499114990234375, -20.717777252197266 ] ] ], [ [ [ 167.36273193359375, -21.183330535888672 ], [ 167.064971923828125, -20.997219085693359 ], [ 167.189971923828125, -20.810417175292969 ], [ 167.051361083984375, -20.720136642456055 ], [ 167.30621337890625, -20.722221374511719 ], [ 167.277542114257812, -20.89958381652832 ], [ 167.463577270507812, -21.057361602783203 ], [ 167.36273193359375, -21.183330535888672 ] ] ], [ [ [ -175.145294189453125, -21.268062591552734 ], [ -175.323638916015625, -21.174442291259766 ], [ -175.34112548828125, -21.074863433837891 ], [ -175.04876708984375, -21.136943817138672 ], [ -175.145294189453125, -21.268062591552734 ] ] ], [ [ [ -159.746978759765625, -21.256668090820312 ], [ -159.83251953125, -21.248472213745117 ], [ -159.834716796875, -21.199306488037109 ], [ -159.756134033203125, -21.192361831665039 ], [ -159.746978759765625, -21.256668090820312 ] ] ], [ [ [ 167.99468994140625, -21.660831451416016 ], [ 167.883331298828125, -21.568889617919922 ], [ 167.8096923828125, -21.383888244628906 ], [ 168.095245361328125, -21.455554962158203 ], [ 168.130508422851562, -21.616111755371094 ], [ 167.99468994140625, -21.660831451416016 ] ] ], [ [ [ -157.92889404296875, -21.940834045410156 ], [ -157.963638305664062, -21.908193588256836 ], [ -157.921737670898438, -21.881462097167969 ], [ -157.88385009765625, -21.925209045410156 ], [ -157.92889404296875, -21.940834045410156 ] ] ], [ [ [ 167.496337890625, -22.67388916015625 ], [ 167.41912841796875, -22.646389007568359 ], [ 167.437332153320312, -22.542083740234375 ], [ 167.554702758789062, -22.614999771118164 ], [ 167.496337890625, -22.67388916015625 ] ] ], [ [ [ -128.33221435546875, -24.327266693115234 ], [ -128.301681518554688, -24.334447860717773 ], [ -128.291122436523438, -24.411388397216797 ], [ -128.34307861328125, -24.367221832275391 ], [ -128.33221435546875, -24.327266693115234 ] ] ], [ [ [ -130.081390380859375, -25.082225799560547 ], [ -130.102630615234375, -25.074447631835938 ], [ -130.105056762695312, -25.06146240234375 ], [ -130.0638427734375, -25.068264007568359 ], [ -130.081390380859375, -25.082225799560547 ] ] ], [ [ [ -109.427780151367188, -27.201946258544922 ], [ -109.393478393554688, -27.067502975463867 ], [ -109.219589233398438, -27.097640991210938 ], [ -109.238609313964844, -27.132083892822266 ], [ -109.427780151367188, -27.201946258544922 ] ] ], [ [ [ 167.9649658203125, -29.081111907958984 ], [ 167.923583984375, -29.056667327880859 ], [ 167.91094970703125, -29.007362365722656 ], [ 167.998870849609375, -29.027502059936523 ], [ 167.9649658203125, -29.081111907958984 ] ] ], [ [ [ 177.91778564453125, -38.942802429199219 ], [ 177.998001098632812, -39.123886108398438 ], [ 177.874969482421875, -39.286117553710938 ], [ 177.680267333984375, -39.075279235839844 ], [ 177.054962158203125, -39.204444885253906 ], [ 176.898590087890625, -39.442218780517578 ], [ 176.946624755859375, -39.664443969726562 ], [ 177.117446899414062, -39.679306030273438 ], [ 175.955230712890625, -41.255279541015625 ], [ 175.230804443359375, -41.620834350585938 ], [ 175.188583374023438, -41.427780151367188 ], [ 174.863571166992188, -41.42236328125 ], [ 174.8912353515625, -41.226245880126953 ], [ 174.629669189453125, -41.31500244140625 ], [ 175.12774658203125, -40.713615417480469 ], [ 175.19635009765625, -40.166946411132812 ], [ 174.960784912109375, -39.912773132324219 ], [ 173.966629028320312, -39.543476104736328 ], [ 173.75164794921875, -39.269996643066406 ], [ 174.587738037109375, -38.828887939453125 ], [ 174.724395751953125, -38.185829162597656 ], [ 174.94024658203125, -38.101112365722656 ], [ 174.793304443359375, -37.849864959716797 ], [ 174.9749755859375, -37.75 ], [ 174.848297119140625, -37.769721984863281 ], [ 174.71746826171875, -37.425003051757812 ], [ 174.840652465820312, -37.294170379638672 ], [ 174.714279174804688, -37.362918853759766 ], [ 174.550811767578125, -37.077224731445312 ], [ 174.703857421875, -37.197776794433594 ], [ 174.887481689453125, -37.059165954589844 ], [ 174.770263671875, -36.936660766601562 ], [ 174.500244140625, -37.034725189208984 ], [ 174.177902221679688, -36.462917327880859 ], [ 174.454696655273438, -36.647914886474609 ], [ 174.4205322265625, -36.368473052978516 ], [ 174.268585205078125, -36.345832824707031 ], [ 174.5052490234375, -36.23138427734375 ], [ 174.0657958984375, -36.1683349609375 ], [ 173.911102294921875, -35.872081756591797 ], [ 173.990097045898438, -36.136947631835938 ], [ 174.199417114257812, -36.348056793212891 ], [ 174.067611694335938, -36.397083282470703 ], [ 173.397201538085938, -35.570697784423828 ], [ 173.655548095703125, -35.317916870117188 ], [ 173.38177490234375, -35.52471923828125 ], [ 172.7391357421875, -34.435554504394531 ], [ 173.03887939453125, -34.436943054199219 ], [ 172.910537719726562, -34.546947479248047 ], [ 173.266921997070312, -35.017086029052734 ], [ 173.4508056640625, -34.807777404785156 ], [ 173.47149658203125, -34.990280151367188 ], [ 174.10107421875, -35.121109008789062 ], [ 174.00970458984375, -35.218193054199219 ], [ 174.143585205078125, -35.32861328125 ], [ 174.319976806640625, -35.232772827148438 ], [ 174.602447509765625, -35.844444274902344 ], [ 174.35968017578125, -35.723468780517578 ], [ 174.348724365234375, -35.836250305175781 ], [ 174.522628784179688, -35.846942901611328 ], [ 174.781097412109375, -36.266944885253906 ], [ 174.808319091796875, -36.805274963378906 ], [ 175.579132080078125, -37.24444580078125 ], [ 175.352447509765625, -36.489997863769531 ], [ 175.540390014648438, -36.517360687255859 ], [ 175.840789794921875, -36.754173278808594 ], [ 175.708709716796875, -36.872634887695312 ], [ 175.847320556640625, -36.842914581298828 ], [ 175.88970947265625, -37.246944427490234 ], [ 176.165603637695312, -37.621040344238281 ], [ 175.943572998046875, -37.525417327880859 ], [ 175.994415283203125, -37.638893127441406 ], [ 177.159423828125, -38.013336181640625 ], [ 177.47357177734375, -37.962501525878906 ], [ 178.01800537109375, -37.550830841064453 ], [ 178.550537109375, -37.6875 ], [ 178.347335815429688, -38.015419006347656 ], [ 178.298446655273438, -38.539169311523438 ], [ 177.928863525390625, -38.722221374511719 ], [ 177.91778564453125, -38.942802429199219 ] ] ], [ [ [ 175.523040771484375, -36.348312377929688 ], [ 175.358856201171875, -36.229438781738281 ], [ 175.375778198242188, -36.069168090820312 ], [ 175.5294189453125, -36.178611755371094 ], [ 175.523040771484375, -36.348312377929688 ] ] ], [ [ [ 175.16943359375, -36.829177856445312 ], [ 175.0888671875, -36.833610534667969 ], [ 175.002471923828125, -36.792778015136719 ], [ 175.18927001953125, -36.728466033935547 ], [ 175.16943359375, -36.829177856445312 ] ] ], [ [ [ 171.18524169921875, -44.938331604003906 ], [ 170.5555419921875, -45.896110534667969 ], [ 170.779708862304688, -45.88055419921875 ], [ 170.34246826171875, -45.973609924316406 ], [ 169.845245361328125, -46.469993591308594 ], [ 169.4580078125, -46.623329162597656 ], [ 168.351409912109375, -46.603164672851562 ], [ 168.371337890625, -46.419025421142578 ], [ 168.190109252929688, -46.344024658203125 ], [ 167.828292846679688, -46.396530151367188 ], [ 167.534423828125, -46.152778625488281 ], [ 166.768035888671875, -46.223609924316406 ], [ 166.6705322265625, -46.157638549804688 ], [ 166.944625854492188, -45.949234008789062 ], [ 166.6705322265625, -46.08721923828125 ], [ 166.466217041015625, -45.986804962158203 ], [ 166.476898193359375, -45.809722900390625 ], [ 166.97412109375, -45.735000610351562 ], [ 166.77581787109375, -45.662773132324219 ], [ 167.041351318359375, -45.501396179199219 ], [ 166.70745849609375, -45.576946258544922 ], [ 166.821624755859375, -45.320556640625 ], [ 167.205230712890625, -45.477775573730469 ], [ 167.05108642578125, -45.333328247070312 ], [ 167.304000854492188, -45.3165283203125 ], [ 166.996917724609375, -45.145835876464844 ], [ 167.3167724609375, -44.873191833496094 ], [ 167.506195068359375, -45.000141143798828 ], [ 167.4508056640625, -44.792087554931641 ], [ 168.372329711914062, -44.040557861328125 ], [ 169.6605224609375, -43.601943969726562 ], [ 170.79412841796875, -42.901390075683594 ], [ 171.151657104492188, -42.560417175292969 ], [ 171.51080322265625, -41.764450073242188 ], [ 172.064971923828125, -41.403610229492188 ], [ 172.113861083984375, -40.879997253417969 ], [ 172.6302490234375, -40.51055908203125 ], [ 172.712188720703125, -40.495552062988281 ], [ 172.98822021484375, -40.531040191650391 ], [ 172.65692138671875, -40.653327941894531 ], [ 172.86065673828125, -40.853057861328125 ], [ 173.0133056640625, -40.796669006347656 ], [ 173.10552978515625, -41.313331604003906 ], [ 173.989547729492188, -40.896808624267578 ], [ 173.7803955078125, -41.012363433837891 ], [ 173.9498291015625, -41.058193206787109 ], [ 173.77581787109375, -41.289726257324219 ], [ 174.130523681640625, -41.179790496826172 ], [ 173.893585205078125, -41.192771911621094 ], [ 174.032745361328125, -40.999725341796875 ], [ 174.319549560546875, -41.001945495605469 ], [ 174.2099609375, -41.197494506835938 ], [ 174.026641845703125, -41.236114501953125 ], [ 174.3238525390625, -41.221523284912109 ], [ 174.045120239257812, -41.446666717529297 ], [ 174.236358642578125, -41.83721923828125 ], [ 173.2855224609375, -42.958053588867188 ], [ 172.759414672851562, -43.242916107177734 ], [ 172.77581787109375, -43.612220764160156 ], [ 173.0596923828125, -43.653053283691406 ], [ 173.091644287109375, -43.856391906738281 ], [ 172.472198486328125, -43.723609924316406 ], [ 171.538482666015625, -44.178775787353516 ], [ 171.278594970703125, -44.3699951171875 ], [ 171.18524169921875, -44.938331604003906 ] ] ], [ [ [ 173.784698486328125, -40.911384582519531 ], [ 173.829132080078125, -40.757781982421875 ], [ 173.960113525390625, -40.709724426269531 ], [ 173.923446655273438, -40.865974426269531 ], [ 173.784698486328125, -40.911384582519531 ] ] ], [ [ [ -176.655059814453125, -44.011978149414062 ], [ -176.55364990234375, -43.845840454101562 ], [ -176.842514038085938, -43.803054809570312 ], [ -176.55780029296875, -43.717506408691406 ], [ -176.269195556640625, -43.763893127441406 ], [ -176.535552978515625, -43.771671295166016 ], [ -176.377227783203125, -44.056114196777344 ], [ -176.655059814453125, -44.011978149414062 ] ] ], [ [ [ 166.971343994140625, -45.166664123535156 ], [ 167.029983520507812, -45.300556182861328 ], [ 167.005264282226562, -45.311389923095703 ], [ 166.891082763671875, -45.246112823486328 ], [ 166.971343994140625, -45.166664123535156 ] ] ], [ [ [ 166.736053466796875, -45.637802124023438 ], [ 166.71636962890625, -45.741668701171875 ], [ 166.50469970703125, -45.722774505615234 ], [ 166.576629638671875, -45.638053894042969 ], [ 166.736053466796875, -45.637802124023438 ] ] ], [ [ [ 168.01165771484375, -46.730606079101562 ], [ 168.217742919921875, -47.072502136230469 ], [ 167.5223388671875, -47.276527404785156 ], [ 167.809127807617188, -46.920001983642578 ], [ 167.772903442382812, -46.702919006347656 ], [ 168.01165771484375, -46.730606079101562 ] ] ], [ [ [ 178.833282470703125, -49.669456481933594 ], [ 178.816375732421875, -49.723884582519531 ], [ 178.717193603515625, -49.70361328125 ], [ 178.802459716796875, -49.615005493164062 ], [ 178.833282470703125, -49.669456481933594 ] ] ], [ [ [ 166.29193115234375, -50.568336486816406 ], [ 166.141357421875, -50.698051452636719 ], [ 166.237869262695312, -50.851806640625 ], [ 165.893035888671875, -50.847637176513672 ], [ 166.108306884765625, -50.536666870117188 ], [ 166.29193115234375, -50.568336486816406 ] ] ], [ [ [ 166.166900634765625, -50.903106689453125 ], [ 165.97357177734375, -50.9052734375 ], [ 165.927474975585938, -50.85430908203125 ], [ 166.215377807617188, -50.888126373291016 ], [ 166.166900634765625, -50.903106689453125 ] ] ], [ [ [ 169.209381103515625, -52.465789794921875 ], [ 169.185516357421875, -52.576950073242188 ], [ 169.000106811523438, -52.518890380859375 ], [ 169.163604736328125, -52.445831298828125 ], [ 169.209381103515625, -52.465789794921875 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "Australia" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ 142.27996826171875, -10.265556335449219 ], [ 142.189422607421875, -10.204166412353516 ], [ 142.22857666015625, -10.145556449890137 ], [ 142.3399658203125, -10.191389083862305 ], [ 142.27996826171875, -10.265556335449219 ] ] ], [ [ [ 142.183319091796875, -10.770278930664062 ], [ 142.115798950195312, -10.657501220703125 ], [ 142.2169189453125, -10.61027717590332 ], [ 142.259017944335938, -10.72097110748291 ], [ 142.183319091796875, -10.770278930664062 ] ] ], [ [ [ 151.540252685546875, -24.045833587646484 ], [ 151.683868408203125, -23.988887786865234 ], [ 152.13177490234375, -24.608194351196289 ], [ 152.468017578125, -24.812221527099609 ], [ 152.671493530273438, -25.245136260986328 ], [ 152.907821655273438, -25.288888931274414 ], [ 152.9205322265625, -25.735416412353516 ], [ 153.181915283203125, -25.949443817138672 ], [ 153.072052001953125, -26.308473587036133 ], [ 153.157196044921875, -27.082778930664062 ], [ 153.034561157226562, -27.176666259765625 ], [ 153.577606201171875, -28.207916259765625 ], [ 153.624191284179688, -28.661039352416992 ], [ 153.018585205078125, -30.568611145019531 ], [ 152.954132080078125, -31.359443664550781 ], [ 152.511856079101562, -32.13104248046875 ], [ 152.529693603515625, -32.403610229492188 ], [ 151.454559326171875, -33.316806793212891 ], [ 151.27276611328125, -33.969444274902344 ], [ 150.93414306640625, -34.331672668457031 ], [ 150.746902465820312, -34.877498626708984 ], [ 150.836761474609375, -35.088401794433594 ], [ 150.6851806640625, -35.042186737060547 ], [ 150.1624755859375, -35.9405517578125 ], [ 149.9024658203125, -36.923332214355469 ], [ 149.971633911132812, -37.522220611572266 ], [ 149.457183837890625, -37.783332824707031 ], [ 147.7591552734375, -37.982498168945312 ], [ 146.873565673828125, -38.651664733886719 ], [ 146.219268798828125, -38.715972900390625 ], [ 146.296493530273438, -38.916561126708984 ], [ 146.469268798828125, -38.805625915527344 ], [ 146.394134521484375, -39.147224426269531 ], [ 146.142349243164062, -38.845970153808594 ], [ 145.9044189453125, -38.856948852539062 ], [ 145.816146850585938, -38.652286529541016 ], [ 145.41607666015625, -38.54583740234375 ], [ 145.555252075195312, -38.374305725097656 ], [ 145.44427490234375, -38.226940155029297 ], [ 145.255462646484375, -38.237640380859375 ], [ 144.9013671875, -38.505836486816406 ], [ 144.7611083984375, -38.377777099609375 ], [ 145.131271362304688, -38.137012481689453 ], [ 144.917678833007812, -37.868541717529297 ], [ 144.368560791015625, -38.12652587890625 ], [ 144.706344604492188, -38.149166107177734 ], [ 144.65887451171875, -38.285003662109375 ], [ 144.36328125, -38.324447631835938 ], [ 143.542953491210938, -38.859233856201172 ], [ 142.37933349609375, -38.3638916015625 ], [ 141.750946044921875, -38.267082214355469 ], [ 141.57135009765625, -38.417221069335938 ], [ 141.10357666015625, -38.1138916015625 ], [ 140.52996826171875, -38.000282287597656 ], [ 139.751373291015625, -37.199722290039062 ], [ 139.823501586914062, -36.554584503173828 ], [ 139.082595825195312, -35.679759979248047 ], [ 139.660400390625, -36.21624755859375 ], [ 139.099563598632812, -35.612510681152344 ], [ 139.159698486328125, -35.503894805908203 ], [ 139.335830688476562, -35.691387176513672 ], [ 139.356613159179688, -35.374443054199219 ], [ 139.21246337890625, -35.316665649414062 ], [ 138.969955444335938, -35.408470153808594 ], [ 138.991134643554688, -35.557430267333984 ], [ 138.536285400390625, -35.653469085693359 ], [ 138.093154907226562, -35.619167327880859 ], [ 138.43878173828125, -35.343818664550781 ], [ 138.51416015625, -35.024997711181641 ], [ 138.496063232421875, -34.7288818359375 ], [ 138.092254638671875, -34.134929656982422 ], [ 137.7481689453125, -35.132778167724609 ], [ 136.85968017578125, -35.291114807128906 ], [ 137.024078369140625, -34.902011871337891 ], [ 137.43414306640625, -34.938888549804688 ], [ 137.451705932617188, -34.160415649414062 ], [ 137.948577880859375, -33.559303283691406 ], [ 137.814346313476562, -33.278053283691406 ], [ 138.0394287109375, -33.078056335449219 ], [ 137.762969970703125, -32.532501220703125 ], [ 137.77484130859375, -32.992774963378906 ], [ 137.48828125, -33.127777099609375 ], [ 137.2099609375, -33.666107177734375 ], [ 136.4134521484375, -34.040977478027344 ], [ 135.936904907226562, -34.536876678466797 ], [ 135.803787231445312, -34.815212249755859 ], [ 136.006668090820312, -34.742603302001953 ], [ 135.956405639648438, -35.008235931396484 ], [ 135.112319946289062, -34.594757080078125 ], [ 135.208511352539062, -34.435829162597656 ], [ 135.34442138671875, -34.614166259765625 ], [ 135.495864868164062, -34.617084503173828 ], [ 135.261077880859375, -34.006526947021484 ], [ 134.840667724609375, -33.637779235839844 ], [ 134.707473754882812, -33.177223205566406 ], [ 134.268722534179688, -33.145557403564453 ], [ 134.074508666992188, -32.720863342285156 ], [ 134.276519775390625, -32.728748321533203 ], [ 134.18414306640625, -32.486663818359375 ], [ 133.852874755859375, -32.54180908203125 ], [ 133.950790405273438, -32.398262023925781 ], [ 133.605865478515625, -32.098052978515625 ], [ 133.417205810546875, -32.213333129882812 ], [ 132.764434814453125, -31.950832366943359 ], [ 132.195938110351562, -32.026947021484375 ], [ 131.148590087890625, -31.474027633666992 ], [ 128.978713989257812, -31.696109771728516 ], [ 127.26776123046875, -32.278335571289062 ], [ 125.972274780273438, -32.266738891601562 ], [ 124.74664306640625, -32.897781372070312 ], [ 124.281936645507812, -32.985557556152344 ], [ 123.734992980957031, -33.77972412109375 ], [ 123.168052673339844, -34.018608093261719 ], [ 123.017829895019531, -33.857570648193359 ], [ 122.118316650390625, -34.028610229492188 ], [ 121.993865966796875, -33.824726104736328 ], [ 120.004989624023438, -33.928886413574219 ], [ 119.325546264648438, -34.446945190429688 ], [ 118.911651611328125, -34.453056335449219 ], [ 118.281661987304688, -34.905555725097656 ], [ 117.837974548339844, -35.030139923095703 ], [ 117.93414306640625, -35.125343322753906 ], [ 116.6019287109375, -35.033058166503906 ], [ 115.973602294921875, -34.819450378417969 ], [ 115.648040771484375, -34.4677734375 ], [ 115.008949279785156, -34.262432098388672 ], [ 114.997100830078125, -33.524105072021484 ], [ 115.396942138671875, -33.621383666992188 ], [ 115.712631225585938, -33.264026641845703 ], [ 115.5943603515625, -32.670692443847656 ], [ 115.617622375488281, -32.602848052978516 ], [ 115.694496154785156, -32.522220611572266 ], [ 115.718246459960938, -32.770347595214844 ], [ 115.739982604980469, -31.86805534362793 ], [ 115.047271728515625, -30.504722595214844 ], [ 114.887344360351562, -29.205833435058594 ], [ 114.154289245605469, -28.090972900390625 ], [ 113.936920166015625, -27.198886871337891 ], [ 113.22442626953125, -26.239166259765625 ], [ 113.28765869140625, -26.027776718139648 ], [ 113.643455505371094, -26.654306411743164 ], [ 113.855819702148438, -26.507503509521484 ], [ 113.391105651855469, -25.710416793823242 ], [ 113.469436645507812, -25.540836334228516 ], [ 113.734085083007812, -25.889026641845703 ], [ 113.714004516601562, -26.196943283081055 ], [ 113.878860473632812, -26.028888702392578 ], [ 114.069290161132812, -26.461666107177734 ], [ 114.221443176269531, -26.292499542236328 ], [ 114.258110046386719, -25.847846984863281 ], [ 113.38970947265625, -24.429443359375 ], [ 113.532211303710938, -23.757225036621094 ], [ 113.768333435058594, -23.441665649414062 ], [ 113.807479858398438, -22.933330535888672 ], [ 113.6563720703125, -22.604721069335938 ], [ 114.0302734375, -21.841667175292969 ], [ 114.175956726074219, -21.822778701782227 ], [ 114.15386962890625, -22.527778625488281 ], [ 114.372482299804688, -22.442497253417969 ], [ 114.651092529296875, -21.840000152587891 ], [ 115.451927185058594, -21.517780303955078 ], [ 116.707489013671875, -20.649166107177734 ], [ 117.685386657714844, -20.676387786865234 ], [ 118.178520202636719, -20.34868049621582 ], [ 118.80108642578125, -20.285835266113281 ], [ 119.080268859863281, -19.968748092651367 ], [ 119.581794738769531, -20.070835113525391 ], [ 121.027481079101562, -19.59222412109375 ], [ 121.48858642578125, -19.123054504394531 ], [ 121.800537109375, -18.480278015136719 ], [ 122.337486267089844, -18.131389617919922 ], [ 122.17498779296875, -17.243331909179688 ], [ 122.752212524414062, -16.762222290039062 ], [ 122.920257568359375, -16.414583206176758 ], [ 123.060249328613281, -16.45555305480957 ], [ 122.956230163574219, -16.586807250976562 ], [ 123.575271606445312, -17.597499847412109 ], [ 123.592620849609375, -16.996665954589844 ], [ 123.655754089355469, -16.994791030883789 ], [ 123.855819702148438, -17.206386566162109 ], [ 123.916023254394531, -17.208263397216797 ], [ 123.796371459960938, -16.997983932495117 ], [ 123.89166259765625, -16.893333435058594 ], [ 123.425178527832031, -16.499513626098633 ], [ 123.708877563476562, -16.430278778076172 ], [ 123.570899963378906, -16.171665191650391 ], [ 123.726234436035156, -16.13861083984375 ], [ 123.891372680664062, -16.378887176513672 ], [ 123.964431762695312, -16.245552062988281 ], [ 124.229843139648438, -16.404233932495117 ], [ 124.893043518066406, -16.406700134277344 ], [ 124.400543212890625, -16.329444885253906 ], [ 124.726715087890625, -15.808958053588867 ], [ 124.400199890136719, -15.864304542541504 ], [ 124.457267761230469, -15.478262901306152 ], [ 124.6563720703125, -15.479721069335938 ], [ 124.705268859863281, -15.253334045410156 ], [ 125.181808471679688, -15.520685195922852 ], [ 125.097343444824219, -15.30180549621582 ], [ 124.912101745605469, -15.336006164550781 ], [ 125.044258117675781, -15.161562919616699 ], [ 124.824851989746094, -15.1602783203125 ], [ 125.078323364257812, -14.999721527099609 ], [ 125.164710998535156, -15.162362098693848 ], [ 125.161651611328125, -15.033889770507812 ], [ 125.3216552734375, -15.156042098999023 ], [ 125.434768676757812, -15.133124351501465 ], [ 125.136024475097656, -14.747430801391602 ], [ 125.336112976074219, -14.523056030273438 ], [ 125.588882446289062, -14.549444198608398 ], [ 125.618316650390625, -14.222429275512695 ], [ 125.728668212890625, -14.273194313049316 ], [ 125.642242431640625, -14.630104064941406 ], [ 125.722793579101562, -14.404305458068848 ], [ 125.90277099609375, -14.643611907958984 ], [ 126.037620544433594, -14.51520824432373 ], [ 126.146652221679688, -14.129999160766602 ], [ 126.017593383789062, -13.92652702331543 ], [ 126.217483520507812, -13.961944580078125 ], [ 126.287773132324219, -14.233055114746094 ], [ 126.502487182617188, -13.9647216796875 ], [ 126.600540161132812, -14.229721069335938 ], [ 126.857902526855469, -13.750971794128418 ], [ 127.12841796875, -13.971491813659668 ], [ 127.425254821777344, -13.95402717590332 ], [ 128.16943359375, -14.702777862548828 ], [ 128.020843505859375, -15.498229026794434 ], [ 128.13214111328125, -15.214055061340332 ], [ 128.287185668945312, -15.400694847106934 ], [ 128.192108154296875, -15.065208435058594 ], [ 128.306289672851562, -14.912776947021484 ], [ 128.448287963867188, -15.047082901000977 ], [ 128.387680053710938, -14.799999237060547 ], [ 128.535964965820312, -14.758472442626953 ], [ 129.08941650390625, -14.899444580078125 ], [ 129.191070556640625, -15.182500839233398 ], [ 129.2296142578125, -14.839235305786133 ], [ 129.731964111328125, -15.182188034057617 ], [ 129.6473388671875, -14.837776184082031 ], [ 129.80157470703125, -14.863957405090332 ], [ 129.944427490234375, -14.767778396606445 ], [ 129.675384521484375, -14.766042709350586 ], [ 129.586563110351562, -14.628055572509766 ], [ 129.772750854492188, -14.535590171813965 ], [ 129.540115356445312, -14.550278663635254 ], [ 129.3702392578125, -14.333332061767578 ], [ 129.73272705078125, -13.994722366333008 ], [ 129.828857421875, -13.516945838928223 ], [ 130.264434814453125, -13.325277328491211 ], [ 130.140701293945312, -12.925924301147461 ], [ 130.509002685546875, -12.604443550109863 ], [ 130.600799560546875, -12.70736026763916 ], [ 130.688827514648438, -12.701075553894043 ], [ 130.579269409179688, -12.404653549194336 ], [ 130.8963623046875, -12.640277862548828 ], [ 130.8157958984375, -12.444723129272461 ], [ 131.02691650390625, -12.358333587646484 ], [ 131.024322509765625, -12.149582862854004 ], [ 131.492599487304688, -12.297222137451172 ], [ 132.360931396484375, -12.202361106872559 ], [ 132.38360595703125, -12.379999160766602 ], [ 132.444351196289062, -12.150277137756348 ], [ 132.748992919921875, -12.135416030883789 ], [ 132.627593994140625, -12.032777786254883 ], [ 132.691497802734375, -11.658195495605469 ], [ 132.489959716796875, -11.476943969726562 ], [ 132.086776733398438, -11.524723052978516 ], [ 131.770950317382812, -11.317638397216797 ], [ 131.984329223632812, -11.127429962158203 ], [ 132.165939331054688, -11.406458854675293 ], [ 132.146682739257812, -11.140000343322754 ], [ 132.34051513671875, -11.130138397216797 ], [ 132.671981811523438, -11.508126258850098 ], [ 132.91802978515625, -11.336944580078125 ], [ 133.18304443359375, -11.716665267944336 ], [ 133.548858642578125, -11.83277702331543 ], [ 133.9083251953125, -11.736110687255859 ], [ 133.839401245117188, -11.854166030883789 ], [ 134.050399780273438, -11.844443321228027 ], [ 134.206634521484375, -12.061665534973145 ], [ 134.771377563476562, -11.995832443237305 ], [ 135.231353759765625, -12.294445037841797 ], [ 135.912750244140625, -11.765556335449219 ], [ 135.669143676757812, -12.19083309173584 ], [ 135.735504150390625, -12.280834197998047 ], [ 136.023040771484375, -12.111944198608398 ], [ 136.039703369140625, -12.47166633605957 ], [ 136.293731689453125, -12.414305686950684 ], [ 136.363922119140625, -12.239721298217773 ], [ 136.177749633789062, -12.166945457458496 ], [ 136.56219482421875, -11.934444427490234 ], [ 136.673233032226562, -12.284514427185059 ], [ 136.775405883789062, -12.171736717224121 ], [ 136.978363037109375, -12.358159065246582 ], [ 136.62078857421875, -12.825277328491211 ], [ 136.494415283203125, -12.779167175292969 ], [ 136.4580078125, -13.252500534057617 ], [ 136.35662841796875, -13.053750038146973 ], [ 135.927261352539062, -13.277847290039062 ], [ 135.845794677734375, -13.603887557983398 ], [ 136.020263671875, -13.762500762939453 ], [ 135.869125366210938, -14.194583892822266 ], [ 135.37274169921875, -14.728887557983398 ], [ 135.45135498046875, -14.932777404785156 ], [ 136.76580810546875, -15.904445648193359 ], [ 137.7376708984375, -16.251735687255859 ], [ 138.19482421875, -16.707359313964844 ], [ 139.010543823242188, -16.899166107177734 ], [ 139.260528564453125, -17.342498779296875 ], [ 140.132171630859375, -17.719165802001953 ], [ 140.833297729492188, -17.451942443847656 ], [ 141.286102294921875, -16.503334045410156 ], [ 141.66552734375, -15.026528358459473 ], [ 141.465789794921875, -13.89708423614502 ], [ 141.688720703125, -13.254027366638184 ], [ 141.585662841796875, -12.986388206481934 ], [ 141.796920776367188, -12.691249847412109 ], [ 141.9403076171875, -12.864998817443848 ], [ 141.747604370117188, -12.469721794128418 ], [ 141.5941162109375, -12.531667709350586 ], [ 141.84912109375, -11.988471031188965 ], [ 142.023666381835938, -12.067777633666992 ], [ 142.147689819335938, -10.949166297912598 ], [ 142.444427490234375, -10.709722518920898 ], [ 142.613143920898438, -10.750763893127441 ], [ 142.509292602539062, -10.950277328491211 ], [ 142.608978271484375, -10.872498512268066 ], [ 142.788299560546875, -11.08055591583252 ], [ 142.859817504882812, -11.833193778991699 ], [ 143.199127197265625, -11.987499237060547 ], [ 143.077468872070312, -12.334304809570312 ], [ 143.27581787109375, -12.413056373596191 ], [ 143.429977416992188, -12.616805076599121 ], [ 143.362319946289062, -12.848888397216797 ], [ 143.51416015625, -12.879165649414062 ], [ 143.530807495117188, -13.756389617919922 ], [ 143.782196044921875, -14.413333892822266 ], [ 144.011856079101562, -14.487707138061523 ], [ 144.515945434570312, -14.171666145324707 ], [ 144.676773071289062, -14.557361602783203 ], [ 145.3157958984375, -14.945554733276367 ], [ 145.402053833007812, -16.440971374511719 ], [ 145.80609130859375, -16.913055419921875 ], [ 145.9554443359375, -16.89909553527832 ], [ 145.8828125, -17.071735382080078 ], [ 146.104263305664062, -17.691665649414062 ], [ 146.009429931640625, -18.238052368164062 ], [ 146.2119140625, -18.491664886474609 ], [ 146.333572387695312, -18.535625457763672 ], [ 146.277618408203125, -18.887014389038086 ], [ 147.139434814453125, -19.402778625488281 ], [ 147.431915283203125, -19.412361145019531 ], [ 147.4014892578125, -19.307950973510742 ], [ 147.6695556640625, -19.824722290039062 ], [ 147.82183837890625, -19.710691452026367 ], [ 148.4134521484375, -20.206388473510742 ], [ 148.452987670898438, -20.06361198425293 ], [ 148.768890380859375, -20.232461929321289 ], [ 148.934417724609375, -20.534723281860352 ], [ 148.790252685546875, -20.456943511962891 ], [ 148.691650390625, -20.624443054199219 ], [ 149.214691162109375, -21.080001831054688 ], [ 149.669479370117188, -22.495170593261719 ], [ 149.814651489257812, -22.383922576904297 ], [ 150.038299560546875, -22.641006469726562 ], [ 149.920806884765625, -22.350555419921875 ], [ 150.043731689453125, -22.149028778076172 ], [ 150.593017578125, -22.586112976074219 ], [ 150.634552001953125, -22.343055725097656 ], [ 150.819122314453125, -22.731941223144531 ], [ 150.800399780273438, -23.380693435668945 ], [ 151.168045043945312, -23.792499542236328 ], [ 151.540252685546875, -24.045833587646484 ] ] ], [ [ [ 136.503326416015625, -11.456388473510742 ], [ 136.72869873046875, -11.045139312744141 ], [ 136.77386474609375, -11.021249771118164 ], [ 136.7249755859375, -11.206944465637207 ], [ 136.503326416015625, -11.456388473510742 ] ] ], [ [ [ 132.5960693359375, -11.344722747802734 ], [ 132.502197265625, -11.051389694213867 ], [ 132.578857421875, -11.022500991821289 ], [ 132.6263427734375, -11.177778244018555 ], [ 132.5960693359375, -11.344722747802734 ] ] ], [ [ [ 130.9588623046875, -11.938888549804688 ], [ 130.493438720703125, -11.642013549804688 ], [ 130.392684936523438, -11.163402557373047 ], [ 130.7049560546875, -11.390277862548828 ], [ 131.151718139648438, -11.260765075683594 ], [ 131.2235107421875, -11.402013778686523 ], [ 131.271514892578125, -11.190278053283691 ], [ 131.528594970703125, -11.391944885253906 ], [ 130.9588623046875, -11.938888549804688 ] ] ], [ [ [ 130.493560791015625, -11.838611602783203 ], [ 130.024703979492188, -11.79847240447998 ], [ 130.25567626953125, -11.34416675567627 ], [ 130.343994140625, -11.325554847717285 ], [ 130.491058349609375, -11.68861198425293 ], [ 130.636581420898438, -11.772916793823242 ], [ 130.493560791015625, -11.838611602783203 ] ] ], [ [ [ 136.1827392578125, -11.690834045410156 ], [ 136.27374267578125, -11.572221755981445 ], [ 136.481216430664062, -11.467221260070801 ], [ 136.373291015625, -11.592498779296875 ], [ 136.1827392578125, -11.690834045410156 ] ] ], [ [ [ 136.908782958984375, -14.179265975952148 ], [ 136.88916015625, -14.297779083251953 ], [ 136.378021240234375, -14.216388702392578 ], [ 136.428314208984375, -13.886945724487305 ], [ 136.678863525390625, -13.658056259155273 ], [ 136.712890625, -13.837916374206543 ], [ 136.91845703125, -13.80958366394043 ], [ 136.708023071289062, -14.167777061462402 ], [ 136.908782958984375, -14.179265975952148 ] ] ], [ [ [ 136.20135498046875, -13.85999870300293 ], [ 136.1051025390625, -13.815278053283691 ], [ 136.201766967773438, -13.664584159851074 ], [ 136.288864135742188, -13.730277061462402 ], [ 136.20135498046875, -13.85999870300293 ] ] ], [ [ [ 125.138320922851562, -14.648611068725586 ], [ 125.092483520507812, -14.544445037841797 ], [ 125.162200927734375, -14.439027786254883 ], [ 125.208038330078125, -14.489166259765625 ], [ 125.138320922851562, -14.648611068725586 ] ] ], [ [ [ 124.522491455078125, -15.445278167724609 ], [ 124.469154357910156, -15.324722290039062 ], [ 124.559707641601562, -15.260000228881836 ], [ 124.646514892578125, -15.400694847106934 ], [ 124.522491455078125, -15.445278167724609 ] ] ], [ [ [ 136.524688720703125, -15.646112442016602 ], [ 136.519439697265625, -15.549722671508789 ], [ 136.605514526367188, -15.524862289428711 ], [ 136.587738037109375, -15.634723663330078 ], [ 136.524688720703125, -15.646112442016602 ] ] ], [ [ [ 137.054412841796875, -15.829999923706055 ], [ 136.934417724609375, -15.698888778686523 ], [ 137.01019287109375, -15.59305477142334 ], [ 137.093017578125, -15.766389846801758 ], [ 137.054412841796875, -15.829999923706055 ] ] ], [ [ [ 139.1483154296875, -16.760833740234375 ], [ 139.306640625, -16.462497711181641 ], [ 139.73358154296875, -16.455833435058594 ], [ 139.441925048828125, -16.667778015136719 ], [ 139.1483154296875, -16.760833740234375 ] ] ], [ [ [ 139.428314208984375, -17.146110534667969 ], [ 139.400115966796875, -17.088750839233398 ], [ 139.55413818359375, -17.031875610351562 ], [ 139.57025146484375, -17.104999542236328 ], [ 139.428314208984375, -17.146110534667969 ] ] ], [ [ [ 146.28997802734375, -18.493888854980469 ], [ 146.22052001953125, -18.468330383300781 ], [ 146.08599853515625, -18.254375457763672 ], [ 146.26971435546875, -18.308334350585938 ], [ 146.28997802734375, -18.493888854980469 ] ] ], [ [ [ 115.368873596191406, -20.880832672119141 ], [ 115.302764892578125, -20.815973281860352 ], [ 115.43817138671875, -20.667221069335938 ], [ 115.459716796875, -20.772777557373047 ], [ 115.368873596191406, -20.880832672119141 ] ] ], [ [ [ 151.2271728515625, -23.786666870117188 ], [ 151.066070556640625, -23.605278015136719 ], [ 151.018463134765625, -23.456388473510742 ], [ 151.22247314453125, -23.558612823486328 ], [ 151.2271728515625, -23.786666870117188 ] ] ], [ [ [ 153.081634521484375, -25.795833587646484 ], [ 152.943023681640625, -25.558334350585938 ], [ 153.281646728515625, -24.699165344238281 ], [ 153.371063232421875, -25.014167785644531 ], [ 153.081634521484375, -25.795833587646484 ] ] ], [ [ [ 113.205551147460938, -26.144721984863281 ], [ 112.952491760253906, -25.784444808959961 ], [ 112.953872680664062, -25.487775802612305 ], [ 113.003250122070312, -25.499027252197266 ], [ 113.205551147460938, -26.144721984863281 ] ] ], [ [ [ 153.425262451171875, -27.362777709960938 ], [ 153.358352661132812, -27.061527252197266 ], [ 153.444427490234375, -27.019306182861328 ], [ 153.46636962890625, -27.034168243408203 ], [ 153.425262451171875, -27.362777709960938 ] ] ], [ [ [ 153.40692138671875, -27.731109619140625 ], [ 153.43359375, -27.416110992431641 ], [ 153.540939331054688, -27.418054580688477 ], [ 153.453994750976562, -27.726387023925781 ], [ 153.40692138671875, -27.731109619140625 ] ] ], [ [ [ 137.91094970703125, -35.729377746582031 ], [ 138.11273193359375, -35.869720458984375 ], [ 137.760955810546875, -35.866043090820312 ], [ 137.4554443359375, -36.085342407226562 ], [ 136.712188720703125, -36.056663513183594 ], [ 136.53387451171875, -35.882221221923828 ], [ 137.31719970703125, -35.590690612792969 ], [ 137.91094970703125, -35.729377746582031 ] ] ], [ [ [ 145.355804443359375, -38.431114196777344 ], [ 145.295669555664062, -38.298751831054688 ], [ 145.496490478515625, -38.36236572265625 ], [ 145.421356201171875, -38.377498626708984 ], [ 145.355804443359375, -38.431114196777344 ] ] ], [ [ [ 145.3541259765625, -38.569999694824219 ], [ 145.2713623046875, -38.520835876464844 ], [ 145.117050170898438, -38.531108856201172 ], [ 145.28289794921875, -38.452503204345703 ], [ 145.3541259765625, -38.569999694824219 ] ] ], [ [ [ 143.921630859375, -40.136390686035156 ], [ 143.837738037109375, -39.873054504394531 ], [ 143.977462768554688, -39.573890686035156 ], [ 144.146453857421875, -39.929439544677734 ], [ 143.921630859375, -40.136390686035156 ] ] ], [ [ [ 148.12884521484375, -40.274444580078125 ], [ 147.7607421875, -39.877983093261719 ], [ 147.88189697265625, -39.754173278808594 ], [ 148.2794189453125, -39.965835571289062 ], [ 148.33135986328125, -40.219165802001953 ], [ 148.12884521484375, -40.274444580078125 ] ] ], [ [ [ 148.339141845703125, -40.503334045410156 ], [ 148.31829833984375, -40.435272216796875 ], [ 147.998565673828125, -40.389724731445312 ], [ 148.343017578125, -40.306663513183594 ], [ 148.479141235351562, -40.430694580078125 ], [ 148.339141845703125, -40.503334045410156 ] ] ], [ [ [ 144.888885498046875, -40.729438781738281 ], [ 144.926223754882812, -40.617221832275391 ], [ 145.016082763671875, -40.695549011230469 ], [ 144.926361083984375, -40.722496032714844 ], [ 144.888885498046875, -40.729438781738281 ] ] ], [ [ [ 146.916702270507812, -43.617843627929688 ], [ 146.038299560546875, -43.498054504394531 ], [ 145.93267822265625, -43.376316070556641 ], [ 146.234542846679688, -43.325141906738281 ], [ 145.8369140625, -43.297225952148438 ], [ 145.459686279296875, -42.904441833496094 ], [ 145.205230712890625, -42.256950378417969 ], [ 145.46942138671875, -42.523056030273438 ], [ 145.552047729492188, -42.351108551025391 ], [ 144.85858154296875, -41.544448852539062 ], [ 144.63720703125, -41.031944274902344 ], [ 144.70135498046875, -40.759170532226562 ], [ 146.586090087890625, -41.186660766601562 ], [ 147.971832275390625, -40.744789123535156 ], [ 148.2733154296875, -40.901107788085938 ], [ 148.363845825195312, -42.222427368164062 ], [ 148.195266723632812, -41.945449829101562 ], [ 147.842880249023438, -42.872917175292969 ], [ 147.99969482421875, -42.907077789306641 ], [ 147.995529174804688, -43.227588653564453 ], [ 147.789703369140625, -43.2469482421875 ], [ 147.631622314453125, -43.0655517578125 ], [ 147.706497192382812, -42.938327789306641 ], [ 147.8994140625, -43.026874542236328 ], [ 147.8258056640625, -42.93194580078125 ], [ 147.557464599609375, -42.830558776855469 ], [ 147.4271240234375, -43.041740417480469 ], [ 147.317474365234375, -42.846664428710938 ], [ 147.247451782226562, -43.269168853759766 ], [ 146.9700927734375, -43.1370849609375 ], [ 147.0953369140625, -43.288715362548828 ], [ 146.916702270507812, -43.617843627929688 ] ] ], [ [ [ 148.01416015625, -42.753059387207031 ], [ 148.01873779296875, -42.619720458984375 ], [ 148.128005981445312, -42.590274810791016 ], [ 148.168167114257812, -42.665554046630859 ], [ 148.01416015625, -42.753059387207031 ] ] ], [ [ [ 147.36163330078125, -43.2630615234375 ], [ 147.29302978515625, -43.157081604003906 ], [ 147.357177734375, -43.075004577636719 ], [ 147.4327392578125, -43.241943359375 ], [ 147.36163330078125, -43.2630615234375 ] ] ], [ [ [ 147.302764892578125, -43.513336181640625 ], [ 147.123016357421875, -43.421943664550781 ], [ 147.300262451171875, -43.262779235839844 ], [ 147.364959716796875, -43.385833740234375 ], [ 147.302764892578125, -43.513336181640625 ] ] ], [ [ [ 158.879669189453125, -54.753890991210938 ], [ 158.8338623046875, -54.668891906738281 ], [ 158.960372924804688, -54.476383209228516 ], [ 158.945526123046875, -54.576393127441406 ], [ 158.879669189453125, -54.753890991210938 ] ] ] ] } },
  { "type": "Feature", "properties": { "CONTINENT": "Antarctica" }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ 51.803054809570312, -46.456672668457031 ], [ 51.710552215576172, -46.446670532226562 ], [ 51.653743743896484, -46.3719482421875 ], [ 51.782218933105469, -46.342365264892578 ], [ 51.803054809570312, -46.456672668457031 ] ] ], [ [ [ 52.191383361816406, -46.463615417480469 ], [ 52.089855194091797, -46.412921905517578 ], [ 52.308746337890625, -46.407779693603516 ], [ 52.288604736328125, -46.451667785644531 ], [ 52.191383361816406, -46.463615417480469 ] ] ], [ [ [ 37.819999694824219, -46.9697265625 ], [ 37.609161376953125, -46.953895568847656 ], [ 37.575969696044922, -46.912918090820312 ], [ 37.777496337890625, -46.831531524658203 ], [ 37.819999694824219, -46.9697265625 ] ] ], [ [ [ 69.217208862304688, -49.125556945800781 ], [ 69.582351684570312, -48.950420379638672 ], [ 69.641029357910156, -49.122570037841797 ], [ 69.36187744140625, -49.132518768310547 ], [ 69.286407470703125, -49.192153930664062 ], [ 69.703109741210938, -49.310626983642578 ], [ 70.32916259765625, -49.050834655761719 ], [ 70.567489624023438, -49.221187591552734 ], [ 70.30902099609375, -49.381252288818359 ], [ 70.459152221679688, -49.444168090820312 ], [ 69.77471923828125, -49.394172668457031 ], [ 69.8408203125, -49.551948547363281 ], [ 70.3226318359375, -49.541393280029297 ], [ 70.256240844726562, -49.689308166503906 ], [ 69.254714965820312, -49.512779235839844 ], [ 68.792076110839844, -49.718753814697266 ], [ 68.880828857421875, -49.403617858886719 ], [ 68.740272521972656, -49.068893432617188 ], [ 68.956657409667969, -48.666671752929688 ], [ 69.078887939453125, -48.69500732421875 ], [ 68.95111083984375, -48.84722900390625 ], [ 69.186935424804688, -48.772781372070312 ], [ 69.001304626464844, -49.088546752929688 ], [ 69.117630004882812, -48.994728088378906 ], [ 69.217208862304688, -49.125556945800781 ] ] ], [ [ [ 69.215545654296875, -49.099449157714844 ], [ 69.216384887695312, -48.96722412109375 ], [ 69.368881225585938, -48.886390686035156 ], [ 69.4052734375, -48.944583892822266 ], [ 69.215545654296875, -49.099449157714844 ] ] ], [ [ [ 73.773880004882812, -53.125030517578125 ], [ 73.474441528320312, -53.194168090820312 ], [ 73.234710693359375, -52.992504119873047 ], [ 73.578887939453125, -53.024444580078125 ], [ 73.773880004882812, -53.125030517578125 ] ] ], [ [ [ -36.99139404296875, -54.350563049316406 ], [ -37.408332824707031, -54.264934539794922 ], [ -37.252082824707031, -54.152294158935547 ], [ -37.685279846191406, -54.175281524658203 ], [ -37.619792938232422, -54.046115875244141 ], [ -38.023754119873047, -54.007434844970703 ], [ -36.656394958496094, -54.107780456542969 ], [ -36.662643432617188, -54.275142669677734 ], [ -36.290210723876953, -54.265838623046875 ], [ -35.793960571289062, -54.760211944580078 ], [ -36.095314025878906, -54.769935607910156 ], [ -35.923614501953125, -54.850421905517578 ], [ -36.104724884033203, -54.889236450195312 ], [ -36.468612670898438, -54.528892517089844 ], [ -36.99139404296875, -54.350563049316406 ] ] ], [ [ [ 3.361388683319092, -54.462783813476562 ], [ 3.366944313049316, -54.399726867675781 ], [ 3.481249809265137, -54.400142669677734 ], [ 3.462499618530273, -54.447223663330078 ], [ 3.361388683319092, -54.462783813476562 ] ] ], [ [ [ -26.248889923095703, -58.498611450195312 ], [ -26.420001983642578, -58.456672668457031 ], [ -26.458196640014648, -58.430698394775391 ], [ -26.265697479248047, -58.394172668457031 ], [ -26.248889923095703, -58.498611450195312 ] ] ], [ [ [ -45.145278930664062, -60.76611328125 ], [ -45.378334045410156, -60.671394348144531 ], [ -46.017227172851562, -60.586395263671875 ], [ -45.428199768066406, -60.549034118652344 ], [ -45.145278930664062, -60.76611328125 ] ] ], [ [ [ -44.72528076171875, -60.776390075683594 ], [ -44.78472900390625, -60.734451293945312 ], [ -44.425144195556641, -60.721530914306641 ], [ -44.655555725097656, -60.743896484375 ], [ -44.72528076171875, -60.776390075683594 ] ] ], [ [ [ -55.240837097167969, -61.27972412109375 ], [ -55.49444580078125, -61.126670837402344 ], [ -54.646392822265625, -61.092781066894531 ], [ -55.028892517089844, -61.161666870117188 ], [ -55.240837097167969, -61.27972412109375 ] ] ], [ [ [ -54.0594482421875, -61.2711181640625 ], [ -54.198616027832031, -61.232501983642578 ], [ -54.016395568847656, -61.091117858886719 ], [ -54.006393432617188, -61.19000244140625 ], [ -54.0594482421875, -61.2711181640625 ] ] ], [ [ [ -58.5836181640625, -62.250282287597656 ], [ -58.98638916015625, -62.211112976074219 ], [ -58.387504577636719, -61.935836791992188 ], [ -57.658340454101562, -61.880561828613281 ], [ -57.589168548583984, -62.008335113525391 ], [ -58.228889465332031, -62.175003051757812 ], [ -58.399726867675781, -62.055557250976562 ], [ -58.5836181640625, -62.250282287597656 ] ] ], [ [ [ -58.992500305175781, -62.3477783203125 ], [ -59.079727172851562, -62.341667175292969 ], [ -59.208892822265625, -62.288753509521484 ], [ -58.8170166015625, -62.299655914306641 ], [ -58.992500305175781, -62.3477783203125 ] ] ], [ [ [ -59.476669311523438, -62.459724426269531 ], [ -59.56195068359375, -62.432228088378906 ], [ -59.678337097167969, -62.3638916015625 ], [ -59.324722290039062, -62.37750244140625 ], [ -59.476669311523438, -62.459724426269531 ] ] ], [ [ [ -59.679450988769531, -62.558059692382812 ], [ -59.886390686035156, -62.525283813476562 ], [ -59.97930908203125, -62.454170227050781 ], [ -59.542366027832031, -62.501945495605469 ], [ -59.679450988769531, -62.558059692382812 ] ] ], [ [ [ -60.267784118652344, -62.761672973632812 ], [ -60.343894958496094, -62.613616943359375 ], [ -61.106391906738281, -62.65472412109375 ], [ -61.169445037841797, -62.571533203125 ], [ -60.132225036621094, -62.460838317871094 ], [ -59.818199157714844, -62.610977172851562 ], [ -60.267784118652344, -62.761672973632812 ] ] ], [ [ [ -61.387222290039062, -62.815559387207031 ], [ -61.476947784423828, -62.751113891601562 ], [ -61.150558471679688, -62.7086181640625 ], [ -61.206672668457031, -62.761116027832031 ], [ -61.387222290039062, -62.815559387207031 ] ] ], [ [ [ -62.704727172851562, -63.09722900390625 ], [ -62.489448547363281, -62.921112060546875 ], [ -62.260837554931641, -62.885002136230469 ], [ -62.364723205566406, -62.993057250976562 ], [ -62.704727172851562, -63.09722900390625 ] ] ], [ [ [ -60.580001831054688, -63.008056640625 ], [ -60.731616973876953, -62.981895446777344 ], [ -60.746433258056641, -62.928554534912109 ], [ -60.617366790771484, -62.879169464111328 ], [ -60.471839904785156, -62.900897979736328 ], [ -60.642917633056641, -62.920558929443359 ], [ -60.580001831054688, -63.008056640625 ] ] ], [ [ [ -56.279449462890625, -63.169723510742188 ], [ -56.473892211914062, -63.108894348144531 ], [ -56.584304809570312, -63.039863586425781 ], [ -55.981674194335938, -63.035560607910156 ], [ -56.279449462890625, -63.169723510742188 ] ] ], [ [ [ -56.349723815917969, -63.437782287597656 ], [ -56.543891906738281, -63.347923278808594 ], [ -56.010284423828125, -63.132781982421875 ], [ -55.001045227050781, -63.258686065673828 ], [ -55.148056030273438, -63.360000610351562 ], [ -55.868896484375, -63.3013916015625 ], [ -56.349723815917969, -63.437782287597656 ] ] ], [ [ [ 163.76611328125, -82.081680297851562 ], [ 163.858078002929688, -82.178482055664062 ], [ 163.439743041992188, -82.2598876953125 ], [ 165.3194580078125, -82.421951293945312 ], [ 165.458053588867188, -82.494865417480469 ], [ 165.240142822265625, -82.55389404296875 ], [ 167.366668701171875, -82.802780151367188 ], [ 166.813079833984375, -82.822784423828125 ], [ 167.159866333007812, -82.911811828613281 ], [ 166.7528076171875, -82.977523803710938 ], [ 168.360260009765625, -82.994171142578125 ], [ 168.688262939453125, -83.150566101074219 ], [ 167.505279541015625, -83.444168090820312 ], [ 169.250823974609375, -83.33001708984375 ], [ 172.317276000976562, -83.600776672363281 ], [ 171.905029296875, -83.80169677734375 ], [ 174.741668701171875, -83.828353881835938 ], [ 178.189422607421875, -84.184188842773438 ], [ 179.511688232421875, -84.155014038085938 ], [ 179.615127563476562, -84.17474365234375 ], [ 179.323196411132812, -84.242233276367188 ], [ 180.0, -84.30224609375 ], [ 180.0, -90.0 ], [ -180.0, -90.0 ], [ -180.0, -84.305343627929688 ], [ -177.721954345703125, -84.498336791992188 ], [ -174.517242431640625, -84.443069458007812 ], [ -169.223358154296875, -84.663894653320312 ], [ -168.445281982421875, -84.84222412109375 ], [ -167.211944580078125, -84.788894653320312 ], [ -162.52667236328125, -85.250564575195312 ], [ -157.48333740234375, -85.448623657226562 ], [ -152.810577392578125, -85.32806396484375 ], [ -150.239471435546875, -85.463623046875 ], [ -148.138336181640625, -85.090835571289062 ], [ -139.661407470703125, -85.245010375976562 ], [ -138.589447021484375, -84.984725952148438 ], [ -149.29473876953125, -84.56195068359375 ], [ -151.691131591796875, -84.324172973632812 ], [ -153.053070068359375, -84.012786865234375 ], [ -153.2327880859375, -83.818618774414062 ], [ -152.943634033203125, -83.648345947265625 ], [ -153.00750732421875, -83.087509155273438 ], [ -151.794189453125, -82.577789306640625 ], [ -154.887863159179688, -81.893203735351562 ], [ -154.0, -81.648345947265625 ], [ -154.20501708984375, -81.552230834960938 ], [ -156.9560546875, -81.252296447753906 ], [ -156.546417236328125, -81.096954345703125 ], [ -154.92169189453125, -81.001953125 ], [ -148.413360595703125, -81.357513427734375 ], [ -148.060028076171875, -81.101394653320312 ], [ -145.524169921875, -80.460556030273438 ], [ -146.81195068359375, -79.88751220703125 ], [ -154.298065185546875, -79.057235717773438 ], [ -155.906402587890625, -78.7197265625 ], [ -156.01397705078125, -78.66375732421875 ], [ -154.0836181640625, -78.481399536132812 ], [ -153.750442504882812, -78.311668395996094 ], [ -154.43280029296875, -78.098617553710938 ], [ -156.81195068359375, -78.270278930664062 ], [ -157.9102783203125, -78.001953125 ], [ -158.167648315429688, -77.846946716308594 ], [ -158.009597778320312, -77.781814575195312 ], [ -158.063079833984375, -77.657791137695312 ], [ -157.700714111328125, -77.577507019042969 ], [ -157.84417724609375, -77.363899230957031 ], [ -157.753082275390625, -77.108062744140625 ], [ -156.48333740234375, -77.358612060546875 ], [ -155.86138916015625, -77.084457397460938 ], [ -153.790283203125, -77.174728393554688 ], [ -153.0836181640625, -77.286666870117188 ], [ -152.972381591796875, -77.371604919433594 ], [ -153.2388916015625, -77.432991027832031 ], [ -153.106414794921875, -77.497222900390625 ], [ -152.061126708984375, -77.325286865234375 ], [ -149.6622314453125, -77.761123657226562 ], [ -149.09765625, -77.694381713867188 ], [ -149.4141845703125, -77.570846557617188 ], [ -148.67388916015625, -77.61944580078125 ], [ -147.591400146484375, -77.422225952148438 ], [ -147.46722412109375, -77.294448852539062 ], [ -147.099456787109375, -77.377227783203125 ], [ -147.0322265625, -77.220840454101562 ], [ -146.26861572265625, -77.466400146484375 ], [ -145.88446044921875, -77.309661865234375 ], [ -146.221817016601562, -77.161811828613281 ], [ -145.845291137695312, -77.105422973632812 ], [ -146.301254272460938, -77.002090454101562 ], [ -145.29888916015625, -77.0291748046875 ], [ -146.10223388671875, -76.840011596679688 ], [ -145.461334228515625, -76.759033203125 ], [ -146.9322509765625, -76.451950073242188 ], [ -149.503341674804688, -76.382156372070312 ], [ -148.101287841796875, -76.095657348632812 ], [ -146.491668701171875, -76.367507934570312 ], [ -145.479461669921875, -76.443344116210938 ], [ -145.420440673828125, -76.327232360839844 ], [ -146.2952880859375, -76.03973388671875 ], [ -145.9766845703125, -75.898895263671875 ], [ -144.206390380859375, -75.837783813476562 ], [ -144.170562744140625, -75.664459228515625 ], [ -142.745574951171875, -75.636123657226562 ], [ -142.56640625, -75.480560302734375 ], [ -140.243621826171875, -75.466949462890625 ], [ -139.327789306640625, -75.106674194335938 ], [ -137.020843505859375, -75.011672973632812 ], [ -136.737518310546875, -74.751678466796875 ], [ -134.30389404296875, -74.532791137695312 ], [ -134.129730224609375, -74.731124877929688 ], [ -133.26251220703125, -74.84722900390625 ], [ -131.84222412109375, -74.723892211914062 ], [ -129.650299072265625, -74.86138916015625 ], [ -126.8114013671875, -74.634735107421875 ], [ -121.478347778320312, -74.742507934570312 ], [ -118.53167724609375, -74.613616943359375 ], [ -118.345909118652344, -74.535568237304688 ], [ -118.525146484375, -74.433891296386719 ], [ -117.743057250976562, -74.308624267578125 ], [ -117.396957397460938, -74.530838012695312 ], [ -114.697776794433594, -74.46917724609375 ], [ -114.806732177734375, -74.103141784667969 ], [ -114.003616333007812, -73.889175415039062 ], [ -113.184860229492188, -74.185005187988281 ], [ -113.510002136230469, -74.301956176757812 ], [ -113.448341369628906, -74.462791442871094 ], [ -112.933616638183594, -74.446952819824219 ], [ -113.548896789550781, -74.631393432617188 ], [ -113.445419311523438, -74.706398010253906 ], [ -112.637222290039062, -74.684722900390625 ], [ -112.654167175292969, -74.858612060546875 ], [ -111.343063354492188, -74.759445190429688 ], [ -111.721328735351562, -74.590980529785156 ], [ -111.389030456542969, -74.466812133789062 ], [ -111.647369384765625, -74.291816711425781 ], [ -111.503890991210938, -74.191680908203125 ], [ -110.154716491699219, -74.2841796875 ], [ -109.962928771972656, -74.546951293945312 ], [ -110.140762329101562, -74.660697937011719 ], [ -109.943756103515625, -74.771392822265625 ], [ -110.774436950683594, -74.962783813476562 ], [ -110.588058471679688, -75.019180297851562 ], [ -110.956390380859375, -75.152992248535156 ], [ -110.383056640625, -75.306121826171875 ], [ -109.068618774414062, -75.128890991210938 ], [ -106.979446411132812, -75.3477783203125 ], [ -105.834457397460938, -75.127227783203125 ], [ -103.338058471679688, -75.028335571289062 ], [ -100.831390380859375, -75.307785034179688 ], [ -99.513893127441406, -75.096260070800781 ], [ -99.743484497070312, -74.917228698730469 ], [ -100.845840454101562, -74.81854248046875 ], [ -100.151741027832031, -74.757156372070312 ], [ -100.505973815917969, -74.668548583984375 ], [ -100.143753051757812, -74.612991333007812 ], [ -100.248062133789062, -74.4908447265625 ], [ -101.324455261230469, -74.482643127441406 ], [ -101.67333984375, -73.993896484375 ], [ -102.901397705078125, -73.875839233398438 ], [ -102.814445495605469, -73.731956481933594 ], [ -103.013343811035156, -73.637924194335938 ], [ -100.310562133789062, -73.75 ], [ -99.195556640625, -73.610565185546875 ], [ -100.460853576660156, -73.36639404296875 ], [ -103.036117553710938, -73.326400756835938 ], [ -103.601119995117188, -72.8961181640625 ], [ -103.176116943359375, -72.73333740234375 ], [ -102.318748474121094, -72.806114196777344 ], [ -102.663192749023438, -73.002578735351562 ], [ -102.099166870117188, -73.084732055664062 ], [ -98.835556030273438, -72.973342895507812 ], [ -96.518890380859375, -73.306121826171875 ], [ -92.451950073242188, -73.15362548828125 ], [ -90.8611145