---
slug: meet-buildbuddy
title: Meet BuildBuddy
author: Siggi Simonarson
author_title: Co-founder @ BuildBuddy
date: 2020-03-04:12:00:00
author_url: https://www.linkedin.com/in/siggisim/
author_image_url: https://avatars.githubusercontent.com/u/1704556?v=4
tags: [company, product]
---

BuildBuddy is a managed [Bazel](https://bazel.build/) build system --- it brings a Google-style development environment to any company in minutes.

The first product we've built is an [open-core](https://en.wikipedia.org/wiki/Open-core_model) Bazel build log viewer. It consumes the Bazel [build event protocol](https://docs.bazel.build/versions/master/build-event-protocol.html) and makes logs accessible through a user-friendly web UI. If you're familiar with [Google's Sponge tool](https://mike-bland.com/2012/10/01/tools.html#tap-and-sponge) - it's basically an open source version of that. It's available in 3 forms:

- **Open source** - You can find the core product open source and free to use with an MIT license on [GitHub](https://github.com/buildbuddy-io/buildbuddy).
- **Cloud hosted** - We also offer a cloud hosted version of the product at [buildbuddy.io](https://buildbuddy.io/). Plans range from a free version for personal use to an enterprise version suited for companies with complex needs.
- **On-prem** - We offer an enterprise version of the product that you can run on-premises or in your own cloud. This version comes with all the bells and whistles - like dashboards, user accounts, and dedicated support.

The Bazel build log viewer is just the start. We're working on a [shared build cache](https://docs.bazel.build/versions/master/remote-caching.html), [remote build execution](https://docs.bazel.build/versions/master/remote-execution.html), and more.

Our end goal is to take the pain out of managing Bazel, so you can focus on building your product.

Reach out to us at <hello@buildbuddy.io> if you're interested, we'd love to chat!
