---
title: Solutions Engineer
---

import Apply from '../../components/apply/apply.tsx'

# Solutions Engineer

<div className="pill"> Full-Time, San Francisco Bay Area & Remote</div>

BuildBuddy was founded to make developers more productive. Today we're solving a small piece of this problem with an open-core remote build execution platform for Bazel - but our ambitions are much larger. Our mission is to take the world class engineering tools that are only available to employees of large companies and make them available to everyone.

This is a unique opportunity to shape the future of how engineers build and test software. You’ll be working directly with engineering organizations developing the most cutting-edge tech.

## You will

- Build a great customer experience for our users (other engineers!)
- Define and prioritize product features, goals, roadmap, and strategy based on your frontline knowledge of customer needs
- Design, build, test, deploy, and maintain reliable software
- Debug complex production issues across the stack
- Resolve customer issues via email, Slack, and video conferencing
- Become a trusted technical advisor to our customers
- Create or update documentation based on customer interactions
- Continually research and learn the current and future best practices of using Bazel

## We're looking for someone who

- Cares deeply about creating the best possible experience for our customers
- Can lead technical discussions and help drive technical decisions
- Is comfortable with ambiguity and working outside of their comfort zone
- Can manage priorities well when there's a lot to be done
- Holds yourself and others to a high bar when working with production
- Is able to write high quality code in a programming language (e.g. Golang, Typescript)
- Has knowledge of DevOps methodologies and appreciates the value technologies like Serverless and Kubernetes bring to the software deployment and development process
- Is experienced with build tools and CI/CD.

## Who you'll work with

- Tyler Williams - GitHub: @tylerwilliams, Twitter: @tylerbw
- Siggi Simonarson - GitHub: @siggisim, Twitter: @siggi
- Brandon Duffany - GitHub: @bduffany, Twitter: @brandon_duffany
- Vadim Berezniker - GitHub: @vadimberezniker

## What's it like to work at BuildBuddy?

- We're a small team of builders that value getting things done over busywork
- We value curiosity and encourage employees to contribute to open source projects
- We aim to create a warm & welcoming work environment
- We treat our coworkers well, and offer platinum health benefits at no cost to employees
- We offer generous equity & comp packages, and reward those that help the company grow
- We work remotely, but are loosely based out of the San Francisco Bay Area

## Apply now

<Apply />
