#! /bin/bash -ex

export BUILD_DIR=${BUILD_DIR:-builds/socorro}

# package up the tarball in $BUILD_DIR
# create base directories
mkdir -p $BUILD_DIR/application

# copy to install directory
rsync -a config $BUILD_DIR/application
rsync -a ${VIRTUAL_ENV} $BUILD_DIR
rsync -a socorro $BUILD_DIR/application
rsync -a scripts $BUILD_DIR/application
rsync -a tools $BUILD_DIR/application
rsync -a sql $BUILD_DIR/application
rsync -a wsgi $BUILD_DIR/application
rsync -a stackwalk $BUILD_DIR/
rsync -a scripts/stackwalk.sh $BUILD_DIR/stackwalk/bin/
rsync -a analysis $BUILD_DIR/
rsync -a alembic $BUILD_DIR/application
rsync -a webapp-django $BUILD_DIR/

# copy default config files
pushd $BUILD_DIR/application/scripts/config
for file in *.py.dist; do cp $file `basename $file .dist`; done
popd

# record current git revision in install dir
git rev-parse HEAD > $BUILD_DIR/application/socorro/external/postgresql/socorro_revision.txt
cp $BUILD_DIR/stackwalk/revision.txt $BUILD_DIR/application/socorro/external/postgresql/breakpad_revision.txt
