CREATE OR REPLACE FUNCTION same_time_fuzzy(date1 timestamp with time zone, date2 timestamp with time zone, interval_secs1 integer, interval_secs2 integer) RETURNS boolean
    LANGUAGE sql
    AS $_$
SELECT
-- return true if either interval is null
-- so we don't exclude crashes missing data
CASE WHEN $3 IS NULL THEN
    TRUE
WHEN $4 IS NULL THEN
    TRUE
WHEN $3 < 0 or $4 < 0 THEN
    FALSE
-- otherwise check that the two timestamp deltas
-- and the two interval deltas are within 60 sec
-- of each other
ELSE
    ( extract ('epoch' from ( $2 - $1 ) ) -
        ( $4 - $3 )
    ) BETWEEN -60 AND 60
END;
$_$;


