"""bug 867387 Bixie draft schema

Revision ID: 22e4e60e03f
Revises: 37004fc6e41e
Create Date: 2013-05-10 13:20:35.750954

"""

# revision identifiers, used by Alembic.
revision = '22e4e60e03f'
down_revision = '37004fc6e41e'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy.dialects import postgresql
import sqlalchemy.types as types
from sqlalchemy.sql import table, column

class CITEXT(types.UserDefinedType):
    name = 'citext'

    def get_col_spec(self):
        return 'CITEXT'

    def bind_processor(self, dialect):
        def process(value):
            return value
        return process

    def result_processor(self, dialect, coltype):
        def process(value):
            return value
        return process

    def __repr__(self):
        return "citext"

class JSON(types.UserDefinedType):
    name = 'json'

    def get_col_spec(self):
        return 'JSON'

    def bind_processor(self, dialect):
        def process(value):
            return value
        return process

    def result_processor(self, dialect, coltype):
        def process(value):
            return value
        return process

    def __repr__(self):
        return "json"

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.execute(u'CREATE SCHEMA bixie')
    op.create_table(u'product_versions',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', CITEXT(), nullable=True),
    sa.Column(u'release_version', sa.TEXT(), nullable=True),
    sa.Column(u'major_version', sa.TEXT(), nullable=True),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'full_urls',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'url', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'raw_product_releases',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'version', sa.TEXT(), nullable=False),
    sa.Column(u'build', sa.TEXT(), nullable=False),
    sa.Column(u'build_type', CITEXT(), nullable=False),
    sa.Column(u'platform', sa.TEXT(), nullable=False),
    sa.Column(u'product_name', CITEXT(), nullable=False),
    sa.Column(u'repository', sa.TEXT(), nullable=False),
    sa.Column(u'stability', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'products',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'crashes_normalized',
    sa.Column(u'crash_id', postgresql.UUID(), autoincrement=False,
        nullable=False),
    sa.Column(u'signature_id', sa.TEXT(), nullable=False),
    sa.Column(u'error_message_id', JSON(), nullable=False),
    sa.Column(u'product_id', sa.TEXT(), nullable=True),
    sa.Column(u'user_agent_id', sa.TEXT(), nullable=True),
    sa.PrimaryKeyConstraint(u'crash_id'),
    schema=u'bixie'
    )
    op.create_table(u'hosts',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'signatures',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'signature', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'crashes',
    sa.Column(u'crash_id', postgresql.UUID(), autoincrement=False,
        nullable=False),
    sa.Column(u'signature', sa.TEXT(), nullable=False),
    sa.Column(u'error', JSON(), nullable=False),
    sa.Column(u'product', sa.TEXT(), nullable=True),
    sa.Column(u'protocol', sa.TEXT(), nullable=True),
    sa.Column(u'hostname', sa.TEXT(), nullable=True),
    sa.Column(u'username', sa.TEXT(), nullable=True),
    sa.Column(u'port', sa.TEXT(), nullable=True),
    sa.Column(u'path', sa.TEXT(), nullable=True),
    sa.Column(u'query', sa.TEXT(), nullable=True),
    sa.Column(u'full_url', sa.TEXT(), nullable=True),
    sa.Column(u'user_agent', sa.TEXT(), nullable=True),
    sa.Column(u'success', sa.BOOLEAN(), nullable=True),
    sa.Column(u'client_crash_datetime',
        postgresql.TIMESTAMP(timezone=True), nullable=True),
    sa.Column(u'client_submitted_datetime',
        postgresql.TIMESTAMP(timezone=True), nullable=True),
    sa.Column(u'processor_started_datetime',
        postgresql.TIMESTAMP(timezone=True), nullable=True),
    sa.Column(u'processor_completed_datetime',
        postgresql.TIMESTAMP(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint(u'crash_id'),
    schema=u'bixie'
    )
    op.create_table(u'release_channels',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', CITEXT(), nullable=False),
    sa.Column(u'sort', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'os_names',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'error_messages',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'error_message', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'product_version_adi',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'product_version_id', sa.INTEGER(), nullable=False),
    sa.Column(u'adi_count', sa.BIGINT(), nullable=False),
    sa.Column(u'adi_date', sa.INTEGER(), nullable=False),
    sa.Column(u'os_name', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'raw_adi',
    sa.Column(u'adi_count', sa.BIGINT(), nullable=True),
    sa.Column(u'date', sa.DATE(), nullable=True),
    sa.Column(u'product_name', sa.TEXT(), nullable=True),
    sa.Column(u'product_os_platform', sa.TEXT(), nullable=True),
    sa.Column(u'product_os_version', sa.TEXT(), nullable=True),
    sa.Column(u'product_version', sa.TEXT(), nullable=True),
    sa.Column(u'build', sa.TEXT(), nullable=True),
    sa.Column(u'build_channel', sa.TEXT(), nullable=True),
    sa.Column(u'product_guid', sa.TEXT(), nullable=True),
    sa.Column(u'received_at', postgresql.TIMESTAMP(timezone=True),
        nullable=True),
    sa.PrimaryKeyConstraint(),
    schema=u'bixie'
    )
    op.create_table(u'users',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'name', sa.TEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'product_adi',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'product_id', sa.INTEGER(), nullable=False),
    sa.Column(u'adi_count', sa.BIGINT(), nullable=False),
    sa.Column(u'adi_date', sa.INTEGER(), nullable=False),
    sa.Column(u'os_name', CITEXT(), nullable=False),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'user_agents',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'error_message_id', sa.INTEGER(), nullable=True),
    sa.ForeignKeyConstraint(['error_message_id'],
        [u'bixie.error_messages.id'], ),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'product_users',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'product_id', sa.INTEGER(), nullable=True),
    sa.Column(u'user_id', sa.INTEGER(), nullable=True),
    sa.ForeignKeyConstraint(['product_id'], [u'bixie.products.id'], ),
    sa.ForeignKeyConstraint(['user_id'], [u'bixie.users.id'], ),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'product_release_channels',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'release_channel_id', sa.INTEGER(), nullable=True),
    sa.Column(u'product_id', sa.INTEGER(), nullable=True),
    sa.ForeignKeyConstraint(['product_id'], [u'bixie.products.id'], ),
    sa.ForeignKeyConstraint(['release_channel_id'],
        [u'bixie.release_channels.id'], ),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    op.create_table(u'error_message_products',
    sa.Column(u'id', sa.INTEGER(), nullable=False),
    sa.Column(u'error_message_id', sa.INTEGER(), nullable=True),
    sa.Column(u'product_id', sa.INTEGER(), nullable=True),
    sa.ForeignKeyConstraint(['error_message_id'],
        [u'bixie.error_messages.id'], ),
    sa.ForeignKeyConstraint(['product_id'], [u'bixie.products.id'], ),
    sa.PrimaryKeyConstraint(u'id'),
    schema=u'bixie'
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table(u'error_message_products', schema=u'bixie')
    op.drop_table(u'product_release_channels', schema=u'bixie')
    op.drop_table(u'product_users', schema=u'bixie')
    op.drop_table(u'user_agents', schema=u'bixie')
    op.drop_table(u'product_adi', schema=u'bixie')
    op.drop_table(u'users', schema=u'bixie')
    op.drop_table(u'raw_adi', schema=u'bixie')
    op.drop_table(u'product_version_adi', schema=u'bixie')
    op.drop_table(u'error_messages', schema=u'bixie')
    op.drop_table(u'os_names', schema=u'bixie')
    op.drop_table(u'release_channels', schema=u'bixie')
    op.drop_table(u'crashes', schema=u'bixie')
    op.drop_table(u'signatures', schema=u'bixie')
    op.drop_table(u'hosts', schema=u'bixie')
    op.drop_table(u'crashes_normalized', schema=u'bixie')
    op.drop_table(u'products', schema=u'bixie')
    op.drop_table(u'raw_product_releases', schema=u'bixie')
    op.drop_table(u'full_urls', schema=u'bixie')
    op.drop_table(u'product_versions', schema=u'bixie')
    op.execute(u'DROP SCHEMA bixie')
    ### end Alembic commands ###
