"""bug 951825 update exploitability

Revision ID: 4a6b5fec10e9
Revises: 1ade2c09799b
Create Date: 2014-01-07 07:24:54.423164

"""
import datetime

# revision identifiers, used by Alembic.
revision = '4a6b5fec10e9'
down_revision = '58d0dc2f6aa4'

from alembic import op
from socorro.lib import citexttype, jsontype
from socorro.lib.migrations import fix_permissions, load_stored_proc

import sqlalchemy as sa
from sqlalchemy import types
from sqlalchemy.dialects import postgresql
from sqlalchemy.sql import table, column


def upgrade():
    load_stored_proc(op, ['update_exploitability.sql'])

    # Rid ourselves of incorrect data
    op.execute(""" TRUNCATE exploitability_reports """)
    op.execute(""" COMMIT """)

    today = datetime.datetime.utcnow().strftime('%Y-%m-%d')
    # Backfill!
    for i in range(0, 7):
        op.execute(""" select backfill_exploitability(('%s'::date - '%s days'::interval)::date) """ % (today, i))
        op.execute(""" COMMIT """)


def downgrade():
    load_stored_proc(op, ['update_exploitability.sql'])
