"""bug 853452 android devices

Revision ID: 49bf379b5a8
Revises: 35604f61bc24
Create Date: 2013-08-26 13:51:45.423498

"""

# revision identifiers, used by Alembic.
revision = '49bf379b5a8'
down_revision = '35604f61bc24'

import os
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql
from sqlalchemy import types
from sqlalchemy.sql import table, column


class CITEXT(types.UserDefinedType):
    name = 'citext'

    def get_col_spec(self):
        return 'CITEXT'

    def bind_processor(self, dialect):
        return lambda value: value

    def result_processor(self, dialect, coltype):
        return lambda value: value

    def __repr__(self):
        return "citext"

class JSON(types.UserDefinedType):
    name = 'json'

    def get_col_spec(self):
        return 'JSON'

    def bind_processor(self, dialect):
        return lambda value: value

    def result_processor(self, dialect, coltype):
        return lambda value: value

    def __repr__(self):
        return "json"

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(u'signature_summary_device',
    sa.Column(u'report_date', sa.DATE(), nullable=False),
    sa.Column(u'signature_id', sa.INTEGER(), nullable=False),
    sa.Column(u'android_device_id', sa.INTEGER(), nullable=False),
    sa.Column(u'report_count', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint(u'report_date', u'signature_id', u'android_device_id')
    )
    op.create_table(u'android_devices',
    sa.Column(u'android_device_id', sa.INTEGER(), nullable=False),
    sa.Column(u'android_cpu_abi', sa.TEXT(), nullable=True),
    sa.Column(u'android_manufacturer', sa.TEXT(), nullable=True),
    sa.Column(u'android_model', sa.TEXT(), nullable=True),
    sa.Column(u'android_version', sa.TEXT(), nullable=True),
    sa.PrimaryKeyConstraint(u'android_device_id')
    )
    app_path=os.getcwd()
    procs = [
        'update_signature_summary.sql'
        , 'backfill_android_devices.sql'
        , 'update_android_devices.sql'
    ]
    for myfile in [app_path + '/socorro/external/postgresql/raw_sql/procs/' + line for line in procs]:
        with open(myfile, 'r') as file:
            op.execute(file.read())


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table(u'android_devices')
    op.drop_table(u'signature_summary_device')
    ### end Alembic commands ###
