"""bug 867606 add data dictionary

Revision ID: 37004fc6e41e
Revises: 5e14d46c725
Create Date: 2013-05-01 09:33:37.597915

"""

# revision identifiers, used by Alembic.
revision = '37004fc6e41e'
down_revision = '5e14d46c725'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
import sqlalchemy.types as types
from sqlalchemy.sql import table, column

class JSON(types.UserDefinedType):
    name = 'json'

    def get_col_spec(self):
        return 'JSON'

    def bind_processor(self, dialect):
        def process(value):
            return value
        return process

    def result_processor(self, dialect, coltype):
        def process(value):
            return value
        return process

    def __repr__(self):
        return "json"


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(u'data_dictionary',
    sa.Column(u'raw_field', sa.TEXT(), nullable=False),
    sa.Column(u'transforms', JSON(), nullable=True),
    sa.Column(u'product', sa.TEXT(), nullable=True),
    sa.PrimaryKeyConstraint(u'raw_field')
    )

    data_dictionary_table = table(u'data_dictionary',
        column(u'raw_field', sa.TEXT()),
        column(u'transforms', JSON()),
        column(u'product', sa.TEXT())
    )
    op.bulk_insert(data_dictionary_table,
        [
            {"product": None, "transforms": "{}", "raw_field": "test"}
            , {"product": None, "transforms": "{\"data name\": \"AdapterDeviceID\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "AdapterDeviceID"}
            , {"product": None, "transforms": "{\"data name\": \"AdapterVendorID\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "AdapterVendorID"}
            , {"product": None, "transforms": "{\"data name\": \"Add-ons\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"addons\", \"ted's mdsw json\": \"extensions.extension_key, extensions.extension_id, extensions.extension_version \", \"1.X processed json\": \"\", \"processor transform\": \"addons\", \"collector:raw json\": \"\", \"processed json 2012\": \"list of lists \"}", "raw_field": "Add-ons"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Board\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Board"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Brand\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Brand"}
            , {"product": None, "transforms": "{\"data name\": \"Android_CPU_ABI2\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_CPU_ABI2"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Device\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Device"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Display\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Display"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Fingerprint\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Fingerprint"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Manufacturer\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Manufacturer"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Model\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Model"}
            , {"product": None, "transforms": "{\"data name\": \"Android_Version\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Android_Version"}
            , {"product": None, "transforms": "{\"data name\": \"AvailablePhysicalMemory\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "AvailablePhysicalMemory"}
            , {"product": None, "transforms": "{\"data name\": \"AvailableVirtualMemory\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "AvailableVirtualMemory"}
            , {"product": None, "transforms": "{\"data name\": \"AvalablePageFile\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "AvalablePageFile"}
            , {"product": None, "transforms": "{\"data name\": \"BuildID\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"build\", \"ted's mdsw json\": \"reports.build (16)\", \"1.X processed json\": \"\", \"processor transform\": \"build\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "BuildID"}
            , {"product": None, "transforms": "{\"data name\": \"buildid\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"inadvertent extra value from breakpad, not used\"}", "raw_field": "buildid"}
            , {"product": None, "transforms": "{\"data name\": \"Comments\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 500 characters; None if missing\", \"pj transform\": \"user_comments\", \"ted's mdsw json\": \"reports.user_comments (500)\", \"1.X processed json\": \"truncated to 500 characters; None if missing\", \"processor transform\": \"user_comments\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Comments"}
            , {"product": None, "transforms": "{\"data name\": \"CrashTime\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 10 characters, converted to integer; if missing, reverts to the value of 'timestamp'.  Converted to timestamp with time zone in the database\\n\", \"pj transform\": \"client_crash_date\", \"ted's mdsw json\": \"reports.client_crash_date\", \"1.X processed json\": \"truncated to 10 characters, converted to integer; if missing, reverts to the value of 'timestamp'.  Converted back to string in almost ISO 8601 for json.\\n\", \"processor transform\": \"client_crash_date\", \"collector:raw json\": \"\", \"processed json 2012\": \"UTZ applied by processor\"}", "raw_field": "CrashTime"}
            , {"product": None, "transforms": "{\"data name\": \"submitted_timestamp\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"reports.date_processed\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "submitted_timestamp"}
            , {"product": None, "transforms": "{\"data name\": \"Distributor\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 20 characters; None if missing\", \"pj transform\": \"distributor\", \"ted's mdsw json\": \"reports.distributor (20)\", \"1.X processed json\": \"truncated to 20 characters; None if missing\", \"processor transform\": \"distributor\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Distributor"}
            , {"product": None, "transforms": "{\"data name\": \"Distributor_version\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 20 characters; None if missing\", \"pj transform\": \"distributor_version\", \"ted's mdsw json\": \"reports.distributor_version (20)\", \"1.X processed json\": \"truncated to 20 characters; None if missing\", \"processor transform\": \"distributor_version\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Distributor_version"}
            , {"product": None, "transforms": "{\"data name\": \"Email\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 100 characters; None if missing\", \"pj transform\": \"\", \"ted's mdsw json\": \"reports.email (100)\", \"1.X processed json\": \"truncated to 100 characters; None if missing\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Email"}
            , {"product": None, "transforms": "{\"data name\": \"EMCheckCompatibility\", \"mdsw pipe dump\": \"\", \"database\": \"converted to lower case, then to boolean True if 'true' and False for any other value\", \"pj transform\": \"addons_checked\", \"ted's mdsw json\": \"reports.addons_checked\", \"1.X processed json\": \"converted to lower case, then to boolean True if 'true' and False for any other value\", \"processor transform\": \"addons_checked\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "EMCheckCompatibility"}
            , {"product": None, "transforms": "{\"data name\": \"FramePoisonBase\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "FramePoisonBase"}
            , {"product": None, "transforms": "{\"data name\": \"FramePoisonSize\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "FramePoisonSize"}
            , {"product": None, "transforms": "{\"data name\": \"Hang\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"not currently enabled in breakpad\"}", "raw_field": "Hang"}
            , {"product": None, "transforms": "{\"data name\": \"HangID\", \"mdsw pipe dump\": \"\", \"database\": \"no conversion; None if missng\", \"pj transform\": \"hangid\", \"ted's mdsw json\": \"reports.hangid\", \"1.X processed json\": \"no conversion; None if missng\", \"processor transform\": \"hangid\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "HangID"}
            , {"product": None, "transforms": "{\"data name\": \"id\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"name collision: the raw json 'id'\"}", "raw_field": "id"}
            , {"product": None, "transforms": "{\"data name\": \"InstallTime\", \"mdsw pipe dump\": \"\", \"database\": \"converted to int; reverts to 'startuptime' if missing\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"converted to int; reverts to 'startuptime' if missing\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "InstallTime"}
            , {"product": None, "transforms": "{\"data name\": \"JavaStackTrace\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"java_stack_trace\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "JavaStackTrace"}
            , {"product": None, "transforms": "{\"data name\": \"legacy_processing\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"added by collector\"}", "raw_field": "legacy_processing"}
            , {"product": None, "transforms": "{\"data name\": \"Min_ARM_Version\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Min_ARM_Version"}
            , {"product": None, "transforms": "{\"data name\": \"Notes\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 1000; None if missing\", \"pj transform\": \"app_notes\", \"ted's mdsw json\": \"reports.app_notes (1000)\", \"1.X processed json\": \"truncated to 1000; None if missing\", \"processor transform\": \"app_notes\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Notes"}
            , {"product": None, "transforms": "{\"data name\": \"PluginFilename\", \"mdsw pipe dump\": \"\", \"database\": \"no conversion; empty string if missing\", \"pj transform\": \"pluginFilename\", \"ted's mdsw json\": \"plugins.filename\", \"1.X processed json\": \"only present if 'plugin' crash type\", \"processor transform\": \"pluginFilename\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "PluginFilename"}
            , {"product": None, "transforms": "{\"data name\": \"PluginName\", \"mdsw pipe dump\": \"\", \"database\": \"no conversion; empty string if missing\", \"pj transform\": \"pluginName\", \"ted's mdsw json\": \"plugins.name\", \"1.X processed json\": \"only present if 'plugin' crash type\", \"processor transform\": \"pluginName\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "PluginName"}
            , {"product": None, "transforms": "{\"data name\": \"PluginVersion\", \"mdsw pipe dump\": \"\", \"database\": \"no conversion; empty string if missing\", \"pj transform\": \"pluginVersion\", \"ted's mdsw json\": \"plugins_reports.pluginVersion\", \"1.X processed json\": \"only present if 'plugin' crash type\", \"processor transform\": \"pluginVersion\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "PluginVersion"}
            , {"product": None, "transforms": "{\"data name\": \"ProcessType\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 10; None if missing\", \"pj transform\": \"process_type\", \"ted's mdsw json\": \"reports.process_type\", \"1.X processed json\": \"truncated to 10; None if missing\", \"processor transform\": \"process_type\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "ProcessType"}
            , {"product": None, "transforms": "{\"data name\": \"ProductName\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"product\", \"ted's mdsw json\": \"reports.product (30)\", \"1.X processed json\": \"\", \"processor transform\": \"product\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "ProductName"}
            , {"product": None, "transforms": "{\"data name\": \"ReleaseChannel\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"release_channel\", \"ted's mdsw json\": \"reports.release_channel\", \"1.X processed json\": \"\", \"processor transform\": \"release_channel\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "ReleaseChannel"}
            , {"product": None, "transforms": "{\"data name\": \"SecondsSinceLastCrash\", \"mdsw pipe dump\": \"\", \"database\": \"converted to int\", \"pj transform\": \"last_crash\", \"ted's mdsw json\": \"reports.last_crash\", \"1.X processed json\": \"converted to int\", \"processor transform\": \"last_crash\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "SecondsSinceLastCrash"}
            , {"product": None, "transforms": "{\"data name\": \"StartupTime\", \"mdsw pipe dump\": \"\", \"database\": \"converted to int; reverts to 'CrashTime' if missing\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"converted to int; reverts to 'CrashTime' if missing\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"decimal unix timestamp of 10 or fewer digits\"}", "raw_field": "StartupTime"}
            , {"product": None, "transforms": "{\"data name\": \"SystemMemoryUsePercentage\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "SystemMemoryUsePercentage"}
            , {"product": None, "transforms": "{\"data name\": \"Theme\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Theme"}
            , {"product": None, "transforms": "{\"data name\": \"Throttleable\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Throttleable"}
            , {"product": None, "transforms": "{\"data name\": \"timestamp\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "timestamp"}
            , {"product": None, "transforms": "{\"data name\": \"TotalVirtualMemory\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "TotalVirtualMemory"}
            , {"product": None, "transforms": "{\"data name\": \"URL\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 255; None if missing\", \"pj transform\": \"\", \"ted's mdsw json\": \"reports.url (255)\", \"1.X processed json\": \"truncated to 255; None if missing\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "URL"}
            , {"product": None, "transforms": "{\"data name\": \"UserID\", \"mdsw pipe dump\": \"\", \"database\": \"forced to empty string\", \"pj transform\": \"\", \"ted's mdsw json\": \"reports.user_id\", \"1.X processed json\": \"forced to empty string\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"processor always leaves this blank\"}", "raw_field": "UserID"}
            , {"product": None, "transforms": "{\"data name\": \"Vendor\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Vendor"}
            , {"product": None, "transforms": "{\"data name\": \"Version\", \"mdsw pipe dump\": \"\", \"database\": \"truncated to 16; 'esr' appended if ReleaseChannel is 'ESR'; None if missing\", \"pj transform\": \"version\", \"ted's mdsw json\": \"reports.version (16)\", \"1.X processed json\": \"truncated to 16; 'esr' appended if ReleaseChannel is 'ESR'; None if missing\", \"processor transform\": \"version\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Version"}
            , {"product": None, "transforms": "{\"data name\": \"version\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"\", \"collector:raw json\": \"\", \"processed json 2012\": \"inadvertent extra value from breakpad, not used\"}", "raw_field": "version"}
            , {"product": None, "transforms": "{\"data name\": \"Winsock_LSP\", \"mdsw pipe dump\": \"\", \"database\": \"\", \"pj transform\": \"Winsock_LSP\", \"ted's mdsw json\": \"\", \"1.X processed json\": \"\", \"processor transform\": \"Winsock_LSP\", \"collector:raw json\": \"\", \"processed json 2012\": \"\"}", "raw_field": "Winsock_LSP"}
    ])
                ### end Alembic commands ###

def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table(u'data_dictionary')
    ### end Alembic commands ###
