"""Migration for creation of devices matview.

Revision ID: 523b9e57eba2
Revises: 608afb3824d
Create Date: 2013-09-12 09:31:48.245856

"""

# revision identifiers, used by Alembic.
revision = '523b9e57eba2'
down_revision = '608afb3824d'

import os
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql
from sqlalchemy import types
from sqlalchemy.sql import table, column

from socorro.lib.migrations import fix_permissions


class CITEXT(types.UserDefinedType):
    name = 'citext'

    def get_col_spec(self):
        return 'CITEXT'

    def bind_processor(self, dialect):
        return lambda value: value

    def result_processor(self, dialect, coltype):
        return lambda value: value

    def __repr__(self):
        return "citext"

class JSON(types.UserDefinedType):
    name = 'json'

    def get_col_spec(self):
        return 'JSON'

    def bind_processor(self, dialect):
        return lambda value: value

    def result_processor(self, dialect, coltype):
        return lambda value: value

    def __repr__(self):
        return "json"

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(u'signature_summary_graphics',
    sa.Column(u'report_date', sa.DATE(), nullable=False),
    sa.Column(u'signature_id', sa.INTEGER(), nullable=False),
    sa.Column(u'graphics_device_id', sa.INTEGER(), nullable=False),
    sa.Column(u'report_count', sa.INTEGER(), nullable=False),
    sa.PrimaryKeyConstraint(u'report_date', u'signature_id', u'graphics_device_id')
    )
    op.create_table(u'graphics_device',
    sa.Column(u'graphics_device_id', sa.INTEGER(), nullable=False),
    sa.Column(u'vendor_hex', sa.TEXT(), nullable=True),
    sa.Column(u'adapter_hex', sa.TEXT(), nullable=True),
    sa.Column(u'vendor_name', sa.TEXT(), nullable=True),
    sa.Column(u'adapter_name', sa.TEXT(), nullable=True),
    sa.PrimaryKeyConstraint(u'graphics_device_id')
    )
    ### end Alembic commands ###
    app_path=os.getcwd()
    procs = [
        'update_signature_summary.sql'
        , 'backfill_graphics_devices.sql'
        , 'update_graphics_devices.sql'
    ]
    for myfile in [app_path + '/socorro/external/postgresql/raw_sql/procs/' + line for line in procs]:
        with open(myfile, 'r') as file:
            op.execute(file.read())
    fix_permissions(op, 'graphics_device')
    fix_permissions(op, 'signature_summary_graphics')


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table(u'graphics_device')
    op.drop_table(u'signature_summary_graphics')
    ### end Alembic commands ###
