/*
 * LensKit, an open source recommender systems toolkit.
 * Copyright 2010-2013 Regents of the University of Minnesota and contributors
 * Work on LensKit has been funded by the National Science Foundation under
 * grants IIS 05-34939, 08-08692, 08-12148, and 10-17697.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.grouplens.lenskit.eval.metrics.topn;

import it.unimi.dsi.fastutil.longs.LongSet;
import org.grouplens.lenskit.data.event.Event;
import org.grouplens.lenskit.data.history.UserHistory;

/**
 * Interface for selecting items for various phases of Top-N evaluation.  These are used to
 * select candidate items, good items, bad items, etc.
 *
 * @author <a href="http://www.grouplens.org">GroupLens Research</a>
 */
public interface ItemSelector {
    /**
     * Select a set of items.
     * @param trainingData The user's training data.
     * @param testData The user's test data.
     * @param universe The set of all items.
     * @return The set of items selected.
     */
    LongSet select(UserHistory<Event> trainingData, UserHistory<Event> testData, LongSet universe);
}
