// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/cloudwatch/config/config.proto

// The CloudWatch adapter enables Istio to deliver metrics to
// [Amazon CloudWatch](https://aws.amazon.com/cloudwatch/).
// [Amazon CloudWatch](https://aws.amazon.com/cloudwatch/) and logs to
// [Amazon CloudWatchLogs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html).
//
// To push metrics and logs to CloudWatch using this adapter you must provide AWS credentials to the AWS SDK.
// (see [AWS docs](https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/setup-credentials.html)).
//
// The handler configuration must contain the same metrics as the instance configuration.
// The metrics specified in both instance and handler configurations will be sent to CloudWatch.
//
// This adapter supports the [metric template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/metric/).

package config

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Params_MetricDatum_Unit int32

const (
	None             Params_MetricDatum_Unit = 0
	Seconds          Params_MetricDatum_Unit = 1
	Microseconds     Params_MetricDatum_Unit = 2
	Milliseconds     Params_MetricDatum_Unit = 3
	Count            Params_MetricDatum_Unit = 4
	Bytes            Params_MetricDatum_Unit = 5
	Kilobytes        Params_MetricDatum_Unit = 6
	Megabytes        Params_MetricDatum_Unit = 7
	Gigabytes        Params_MetricDatum_Unit = 8
	Terabytes        Params_MetricDatum_Unit = 9
	Bits             Params_MetricDatum_Unit = 10
	Kilobits         Params_MetricDatum_Unit = 11
	Megabits         Params_MetricDatum_Unit = 12
	Gigabits         Params_MetricDatum_Unit = 13
	Terabits         Params_MetricDatum_Unit = 14
	Percent          Params_MetricDatum_Unit = 15
	Bytes_Second     Params_MetricDatum_Unit = 16
	Kilobytes_Second Params_MetricDatum_Unit = 17
	Megabytes_Second Params_MetricDatum_Unit = 18
	Gigabytes_Second Params_MetricDatum_Unit = 19
	Terabytes_Second Params_MetricDatum_Unit = 20
	Bits_Second      Params_MetricDatum_Unit = 21
	Kilobits_Second  Params_MetricDatum_Unit = 22
	Megabits_Second  Params_MetricDatum_Unit = 23
	Gigabits_Second  Params_MetricDatum_Unit = 24
	Terabits_Second  Params_MetricDatum_Unit = 25
	Count_Second     Params_MetricDatum_Unit = 26
)

var Params_MetricDatum_Unit_name = map[int32]string{
	0:  "None",
	1:  "Seconds",
	2:  "Microseconds",
	3:  "Milliseconds",
	4:  "Count",
	5:  "Bytes",
	6:  "Kilobytes",
	7:  "Megabytes",
	8:  "Gigabytes",
	9:  "Terabytes",
	10: "Bits",
	11: "Kilobits",
	12: "Megabits",
	13: "Gigabits",
	14: "Terabits",
	15: "Percent",
	16: "Bytes_Second",
	17: "Kilobytes_Second",
	18: "Megabytes_Second",
	19: "Gigabytes_Second",
	20: "Terabytes_Second",
	21: "Bits_Second",
	22: "Kilobits_Second",
	23: "Megabits_Second",
	24: "Gigabits_Second",
	25: "Terabits_Second",
	26: "Count_Second",
}

var Params_MetricDatum_Unit_value = map[string]int32{
	"None":             0,
	"Seconds":          1,
	"Microseconds":     2,
	"Milliseconds":     3,
	"Count":            4,
	"Bytes":            5,
	"Kilobytes":        6,
	"Megabytes":        7,
	"Gigabytes":        8,
	"Terabytes":        9,
	"Bits":             10,
	"Kilobits":         11,
	"Megabits":         12,
	"Gigabits":         13,
	"Terabits":         14,
	"Percent":          15,
	"Bytes_Second":     16,
	"Kilobytes_Second": 17,
	"Megabytes_Second": 18,
	"Gigabytes_Second": 19,
	"Terabytes_Second": 20,
	"Bits_Second":      21,
	"Kilobits_Second":  22,
	"Megabits_Second":  23,
	"Gigabits_Second":  24,
	"Terabits_Second":  25,
	"Count_Second":     26,
}

func (Params_MetricDatum_Unit) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d3d61a6c81fc6e3f, []int{0, 1, 0}
}

// Configuration for the `cloudwatch` adapter.
type Params struct {
	// CloudWatch metric namespace.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// A map of Istio metric name to CloudWatch metric info.
	MetricInfo map[string]*Params_MetricDatum `protobuf:"bytes,2,rep,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the log group in cloudwatchlogs.
	LogGroupName string `protobuf:"bytes,4,opt,name=log_group_name,json=logGroupName,proto3" json:"log_group_name,omitempty"`
	// The name of the log stream in cloudwatchlogs.
	LogStreamName string `protobuf:"bytes,5,opt,name=log_stream_name,json=logStreamName,proto3" json:"log_stream_name,omitempty"`
	// A map of Istio logentry name to CloudWatch logentry info.
	Logs map[string]*Params_LogInfo `protobuf:"bytes,6,rep,name=logs,proto3" json:"logs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3d61a6c81fc6e3f, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

func (m *Params) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Params) GetMetricInfo() map[string]*Params_MetricDatum {
	if m != nil {
		return m.MetricInfo
	}
	return nil
}

func (m *Params) GetLogGroupName() string {
	if m != nil {
		return m.LogGroupName
	}
	return ""
}

func (m *Params) GetLogStreamName() string {
	if m != nil {
		return m.LogStreamName
	}
	return ""
}

func (m *Params) GetLogs() map[string]*Params_LogInfo {
	if m != nil {
		return m.Logs
	}
	return nil
}

// CloudWatch metric format.
type Params_MetricDatum struct {
	// The unit of the metric. Must be valid cloudwatch unit value.
	// [CloudWatch docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	Unit Params_MetricDatum_Unit `protobuf:"varint,3,opt,name=unit,proto3,enum=adapter.cloudwatch.config.Params_MetricDatum_Unit" json:"unit,omitempty"`
}

func (m *Params_MetricDatum) Reset()      { *m = Params_MetricDatum{} }
func (*Params_MetricDatum) ProtoMessage() {}
func (*Params_MetricDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3d61a6c81fc6e3f, []int{0, 1}
}
func (m *Params_MetricDatum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricDatum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricDatum.Merge(m, src)
}
func (m *Params_MetricDatum) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricDatum.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricDatum proto.InternalMessageInfo

func (m *Params_MetricDatum) GetUnit() Params_MetricDatum_Unit {
	if m != nil {
		return m.Unit
	}
	return None
}

type Params_LogInfo struct {
	// A golang text/template template that will be executed to construct the payload for this log entry.
	// It will be given the full set of variables for the log to use to construct its result.
	PayloadTemplate string `protobuf:"bytes,1,opt,name=payload_template,json=payloadTemplate,proto3" json:"payload_template,omitempty"`
}

func (m *Params_LogInfo) Reset()      { *m = Params_LogInfo{} }
func (*Params_LogInfo) ProtoMessage() {}
func (*Params_LogInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3d61a6c81fc6e3f, []int{0, 3}
}
func (m *Params_LogInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_LogInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_LogInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_LogInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_LogInfo.Merge(m, src)
}
func (m *Params_LogInfo) XXX_Size() int {
	return m.Size()
}
func (m *Params_LogInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_LogInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Params_LogInfo proto.InternalMessageInfo

func (m *Params_LogInfo) GetPayloadTemplate() string {
	if m != nil {
		return m.PayloadTemplate
	}
	return ""
}

func init() {
	proto.RegisterEnum("adapter.cloudwatch.config.Params_MetricDatum_Unit", Params_MetricDatum_Unit_name, Params_MetricDatum_Unit_value)
	proto.RegisterType((*Params)(nil), "adapter.cloudwatch.config.Params")
	proto.RegisterMapType((map[string]*Params_LogInfo)(nil), "adapter.cloudwatch.config.Params.LogsEntry")
	proto.RegisterMapType((map[string]*Params_MetricDatum)(nil), "adapter.cloudwatch.config.Params.MetricInfoEntry")
	proto.RegisterType((*Params_MetricDatum)(nil), "adapter.cloudwatch.config.Params.MetricDatum")
	proto.RegisterType((*Params_LogInfo)(nil), "adapter.cloudwatch.config.Params.LogInfo")
}

func init() {
	proto.RegisterFile("mixer/adapter/cloudwatch/config/config.proto", fileDescriptor_d3d61a6c81fc6e3f)
}

var fileDescriptor_d3d61a6c81fc6e3f = []byte{
	// 628 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xc1, 0x6e, 0xd3, 0x4c,
	0x10, 0xc7, 0xed, 0xc4, 0x49, 0x93, 0x71, 0xda, 0xf8, 0xdb, 0xf6, 0x03, 0x37, 0x42, 0xab, 0xa8,
	0x42, 0x28, 0x15, 0xe0, 0x8a, 0xc0, 0x01, 0x21, 0xa4, 0x4a, 0x2d, 0x50, 0x21, 0x68, 0x55, 0xa5,
	0xe5, 0xc2, 0x25, 0xda, 0x3a, 0x5b, 0x63, 0x61, 0x7b, 0x23, 0x7b, 0x03, 0xe4, 0xc6, 0x23, 0x70,
	0xe7, 0x05, 0xb8, 0xf1, 0x10, 0x5c, 0x38, 0xf6, 0xd8, 0x23, 0x75, 0x2f, 0x1c, 0xfb, 0x08, 0x68,
	0xd6, 0xde, 0xb4, 0x20, 0x10, 0xe5, 0x14, 0xff, 0x7e, 0x99, 0x1d, 0xff, 0x67, 0x35, 0x32, 0xdc,
	0x8a, 0xc3, 0x77, 0x3c, 0x5d, 0x63, 0x23, 0x36, 0x96, 0x3c, 0x5d, 0xf3, 0x23, 0x31, 0x19, 0xbd,
	0x65, 0xd2, 0x7f, 0xb5, 0xe6, 0x8b, 0xe4, 0x30, 0x0c, 0xca, 0x1f, 0x6f, 0x9c, 0x0a, 0x29, 0xc8,
	0x72, 0x59, 0xe7, 0x9d, 0xd7, 0x79, 0x45, 0xc1, 0xca, 0xe7, 0x06, 0xd4, 0x77, 0x59, 0xca, 0xe2,
	0x8c, 0x5c, 0x83, 0x66, 0xc2, 0x62, 0x9e, 0x8d, 0x99, 0xcf, 0x5d, 0xb3, 0x6b, 0xf6, 0x9a, 0x83,
	0x73, 0x41, 0x06, 0x60, 0xc7, 0x5c, 0xa6, 0xa1, 0x3f, 0x0c, 0x93, 0x43, 0xe1, 0x56, 0xba, 0xd5,
	0x9e, 0xdd, 0xbf, 0xe3, 0xfd, 0xb1, 0xb3, 0x57, 0x74, 0xf5, 0xb6, 0xd5, 0xa1, 0xa7, 0xc9, 0xa1,
	0x78, 0x9c, 0xc8, 0x74, 0x3a, 0x80, 0x78, 0x26, 0xc8, 0x75, 0x58, 0x88, 0x44, 0x30, 0x0c, 0x52,
	0x31, 0x19, 0x0f, 0xf1, 0x55, 0xae, 0xa5, 0x5e, 0xdb, 0x8a, 0x44, 0xb0, 0x85, 0x72, 0x87, 0xc5,
	0x9c, 0xdc, 0x80, 0x36, 0x56, 0x65, 0x32, 0xe5, 0x2c, 0x2e, 0xca, 0x6a, 0xaa, 0x6c, 0x3e, 0x12,
	0xc1, 0x9e, 0xb2, 0xaa, 0x6e, 0x1d, 0xac, 0x48, 0x04, 0x99, 0x5b, 0x57, 0xd1, 0x6e, 0xfe, 0x3d,
	0xda, 0x73, 0x11, 0x64, 0x45, 0x28, 0x75, 0xb0, 0x13, 0x41, 0xfb, 0x97, 0xb4, 0xc4, 0x81, 0xea,
	0x6b, 0x3e, 0x2d, 0x6f, 0x03, 0x1f, 0xc9, 0x26, 0xd4, 0xde, 0xb0, 0x68, 0xc2, 0xdd, 0x4a, 0xd7,
	0xec, 0xd9, 0xfd, 0xdb, 0x97, 0xbd, 0x81, 0x47, 0x4c, 0x4e, 0xe2, 0x41, 0x71, 0xf6, 0x41, 0xe5,
	0xbe, 0xd9, 0xf9, 0x68, 0x81, 0x7d, 0xe1, 0x2f, 0xf2, 0x04, 0xac, 0x49, 0x12, 0x4a, 0xb7, 0xda,
	0x35, 0x7b, 0x0b, 0xfd, 0xfe, 0x3f, 0xf5, 0xf5, 0x5e, 0x24, 0xa1, 0x1c, 0xa8, 0xf3, 0x2b, 0x5f,
	0xaa, 0x60, 0x21, 0x92, 0x06, 0x58, 0x3b, 0x22, 0xe1, 0x8e, 0x41, 0x6c, 0x98, 0xdb, 0xe3, 0xbe,
	0x48, 0x46, 0x99, 0x63, 0x12, 0x07, 0x5a, 0xdb, 0xa1, 0x9f, 0x8a, 0xac, 0x34, 0x95, 0xc2, 0x44,
	0x51, 0xa8, 0x4d, 0x95, 0x34, 0xa1, 0xb6, 0x29, 0x26, 0x89, 0x74, 0x2c, 0x7c, 0xdc, 0x98, 0x4a,
	0x9e, 0x39, 0x35, 0x32, 0x0f, 0xcd, 0x67, 0x61, 0x24, 0x0e, 0x14, 0xd6, 0x11, 0xb7, 0x79, 0xc0,
	0x0a, 0x9c, 0x43, 0xdc, 0x0a, 0x35, 0x36, 0x10, 0xf7, 0x79, 0x5a, 0x62, 0x13, 0xc3, 0x6c, 0x84,
	0x32, 0x73, 0x80, 0xb4, 0xa0, 0xa1, 0xba, 0x20, 0xd9, 0x48, 0xaa, 0x09, 0x52, 0x0b, 0x49, 0xf5,
	0x40, 0x9a, 0x47, 0x52, 0x2d, 0x90, 0x16, 0x70, 0x88, 0x5d, 0x9e, 0xfa, 0x3c, 0x91, 0x4e, 0x1b,
	0x23, 0xab, 0x54, 0xc3, 0x62, 0x2e, 0xc7, 0x21, 0x4b, 0xe0, 0xcc, 0xc2, 0x69, 0xfb, 0x1f, 0xda,
	0x59, 0x46, 0x6d, 0x09, 0xda, 0x59, 0x54, 0x6d, 0x17, 0xd1, 0xce, 0x12, 0x6b, 0xbb, 0x44, 0xda,
	0x60, 0x63, 0x70, 0x2d, 0xfe, 0x27, 0x8b, 0xd0, 0xd6, 0xf9, 0xb5, 0xbc, 0x82, 0x52, 0x8f, 0xa1,
	0xe5, 0x55, 0x94, 0x7a, 0x1a, 0x2d, 0x5d, 0x94, 0x7a, 0x28, 0x2d, 0x97, 0x71, 0x1c, 0x75, 0xdf,
	0xda, 0x74, 0x3a, 0x07, 0xd0, 0x9c, 0xad, 0xe7, 0x6f, 0xb6, 0x70, 0xfd, 0xe7, 0x2d, 0x5c, 0xbd,
	0xd4, 0xb2, 0xe3, 0x5a, 0x5f, 0xdc, 0xc0, 0x7b, 0x30, 0x57, 0x5a, 0xb2, 0x0a, 0xce, 0x98, 0x4d,
	0x23, 0xc1, 0x46, 0x43, 0xc9, 0xe3, 0x71, 0xc4, 0xa4, 0xfe, 0x04, 0xb4, 0x4b, 0xbf, 0x5f, 0xea,
	0x8d, 0x87, 0x47, 0x27, 0xd4, 0x38, 0x3e, 0xa1, 0xc6, 0xd9, 0x09, 0x35, 0xdf, 0xe7, 0xd4, 0xfc,
	0x94, 0x53, 0xf3, 0x6b, 0x4e, 0xcd, 0xa3, 0x9c, 0x9a, 0xdf, 0x72, 0x6a, 0x7e, 0xcf, 0xa9, 0x71,
	0x96, 0x53, 0xf3, 0xc3, 0x29, 0x35, 0x8e, 0x4e, 0xa9, 0x71, 0x7c, 0x4a, 0x8d, 0x97, 0xf5, 0x22,
	0xcd, 0x41, 0x5d, 0x7d, 0x91, 0xee, 0xfe, 0x08, 0x00, 0x00, 0xff, 0xff, 0x31, 0xe8, 0x5b, 0x2d,
	0xc1, 0x04, 0x00, 0x00,
}

func (x Params_MetricDatum_Unit) String() string {
	s, ok := Params_MetricDatum_Unit_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *Params) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Params)
	if !ok {
		that2, ok := that.(Params)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if len(this.MetricInfo) != len(that1.MetricInfo) {
		return false
	}
	for i := range this.MetricInfo {
		if !this.MetricInfo[i].Equal(that1.MetricInfo[i]) {
			return false
		}
	}
	if this.LogGroupName != that1.LogGroupName {
		return false
	}
	if this.LogStreamName != that1.LogStreamName {
		return false
	}
	if len(this.Logs) != len(that1.Logs) {
		return false
	}
	for i := range this.Logs {
		if !this.Logs[i].Equal(that1.Logs[i]) {
			return false
		}
	}
	return true
}
func (this *Params_MetricDatum) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Params_MetricDatum)
	if !ok {
		that2, ok := that.(Params_MetricDatum)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Unit != that1.Unit {
		return false
	}
	return true
}
func (this *Params_LogInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Params_LogInfo)
	if !ok {
		that2, ok := that.(Params_LogInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PayloadTemplate != that1.PayloadTemplate {
		return false
	}
	return true
}
func (this *Params) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&config.Params{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	keysForMetricInfo := make([]string, 0, len(this.MetricInfo))
	for k, _ := range this.MetricInfo {
		keysForMetricInfo = append(keysForMetricInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMetricInfo)
	mapStringForMetricInfo := "map[string]*Params_MetricDatum{"
	for _, k := range keysForMetricInfo {
		mapStringForMetricInfo += fmt.Sprintf("%#v: %#v,", k, this.MetricInfo[k])
	}
	mapStringForMetricInfo += "}"
	if this.MetricInfo != nil {
		s = append(s, "MetricInfo: "+mapStringForMetricInfo+",\n")
	}
	s = append(s, "LogGroupName: "+fmt.Sprintf("%#v", this.LogGroupName)+",\n")
	s = append(s, "LogStreamName: "+fmt.Sprintf("%#v", this.LogStreamName)+",\n")
	keysForLogs := make([]string, 0, len(this.Logs))
	for k, _ := range this.Logs {
		keysForLogs = append(keysForLogs, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLogs)
	mapStringForLogs := "map[string]*Params_LogInfo{"
	for _, k := range keysForLogs {
		mapStringForLogs += fmt.Sprintf("%#v: %#v,", k, this.Logs[k])
	}
	mapStringForLogs += "}"
	if this.Logs != nil {
		s = append(s, "Logs: "+mapStringForLogs+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Params_MetricDatum) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&config.Params_MetricDatum{")
	s = append(s, "Unit: "+fmt.Sprintf("%#v", this.Unit)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Params_LogInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&config.Params_LogInfo{")
	s = append(s, "PayloadTemplate: "+fmt.Sprintf("%#v", this.PayloadTemplate)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringConfig(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Logs) > 0 {
		for k := range m.Logs {
			v := m.Logs[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConfig(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.LogStreamName) > 0 {
		i -= len(m.LogStreamName)
		copy(dAtA[i:], m.LogStreamName)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.LogStreamName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.LogGroupName) > 0 {
		i -= len(m.LogGroupName)
		copy(dAtA[i:], m.LogGroupName)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.LogGroupName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.MetricInfo) > 0 {
		for k := range m.MetricInfo {
			v := m.MetricInfo[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConfig(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Params_MetricDatum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricDatum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricDatum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Unit != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Unit))
		i--
		dAtA[i] = 0x18
	}
	return len(dAtA) - i, nil
}

func (m *Params_LogInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_LogInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PayloadTemplate) > 0 {
		i -= len(m.PayloadTemplate)
		copy(dAtA[i:], m.PayloadTemplate)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PayloadTemplate)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	offset -= sovConfig(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.MetricInfo) > 0 {
		for k, v := range m.MetricInfo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	l = len(m.LogGroupName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.LogStreamName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.Logs) > 0 {
		for k, v := range m.Logs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Params_MetricDatum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Unit != 0 {
		n += 1 + sovConfig(uint64(m.Unit))
	}
	return n
}

func (m *Params_LogInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PayloadTemplate)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func sovConfig(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	keysForMetricInfo := make([]string, 0, len(this.MetricInfo))
	for k, _ := range this.MetricInfo {
		keysForMetricInfo = append(keysForMetricInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMetricInfo)
	mapStringForMetricInfo := "map[string]*Params_MetricDatum{"
	for _, k := range keysForMetricInfo {
		mapStringForMetricInfo += fmt.Sprintf("%v: %v,", k, this.MetricInfo[k])
	}
	mapStringForMetricInfo += "}"
	keysForLogs := make([]string, 0, len(this.Logs))
	for k, _ := range this.Logs {
		keysForLogs = append(keysForLogs, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLogs)
	mapStringForLogs := "map[string]*Params_LogInfo{"
	for _, k := range keysForLogs {
		mapStringForLogs += fmt.Sprintf("%v: %v,", k, this.Logs[k])
	}
	mapStringForLogs += "}"
	s := strings.Join([]string{`&Params{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`MetricInfo:` + mapStringForMetricInfo + `,`,
		`LogGroupName:` + fmt.Sprintf("%v", this.LogGroupName) + `,`,
		`LogStreamName:` + fmt.Sprintf("%v", this.LogStreamName) + `,`,
		`Logs:` + mapStringForLogs + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricDatum) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricDatum{`,
		`Unit:` + fmt.Sprintf("%v", this.Unit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo{`,
		`PayloadTemplate:` + fmt.Sprintf("%v", this.PayloadTemplate) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricInfo == nil {
				m.MetricInfo = make(map[string]*Params_MetricDatum)
			}
			var mapkey string
			var mapvalue *Params_MetricDatum
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_MetricDatum{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MetricInfo[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogGroupName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogGroupName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogStreamName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogStreamName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Logs == nil {
				m.Logs = make(map[string]*Params_LogInfo)
			}
			var mapkey string
			var mapvalue *Params_LogInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_LogInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Logs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricDatum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricDatum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricDatum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			m.Unit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unit |= Params_MetricDatum_Unit(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PayloadTemplate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PayloadTemplate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)
