// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/kubernetesenv/template/template_handler_service.proto

// The `kubernetes` template holds data that controls the production of Kubernetes-specific
// attributes.
//
// Example config:
//
// ```yaml
// apiVersion: "config.istio.io/v1alpha2"
// kind: kubernetes
// metadata:
//   name: attributes
//   namespace: istio-system
// spec:
//   # Pass the required attribute data to the adapter
//   source_uid: source.uid | ""
//   source_ip: source.ip | ip("0.0.0.0") # default to unspecified ip addr
//   destination_uid: destination.uid | ""
//   destination_ip: destination.ip | ip("0.0.0.0") # default to unspecified ip addr
//   attribute_bindings:
//     # Fill the new attributes from the adapter produced output.
//     # $out refers to an instance of OutputTemplate message
//     source.ip: $out.source_pod_ip
//     source.labels: $out.source_labels
//     source.namespace: $out.source_namespace
//     source.service: $out.source_service
//     source.serviceAccount: $out.source_service_account_name
//     destination.ip: $out.destination_pod_ip
//     destination.labels: $out.destination_labels
//     destination.namespace: $out.destination_mamespace
//     destination.service: $out.destination_service
//     destination.serviceAccount: $out.destination_service_account_name
// ```
//
// The `kubernetes` template represents data used to generate kubernetes-derived attributes.
//
// The values provided controls the manner in which the kubernetesenv adapter discovers and
// generates values related to pod information.
// Next ID: 8

package adapter_template_kubernetes

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	_ "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Request message for HandleKubernetes method.
type HandleKubernetesRequest struct {
	// 'kubernetes' instance.
	Instance *InstanceMsg `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleKubernetesRequest) Reset()      { *m = HandleKubernetesRequest{} }
func (*HandleKubernetesRequest) ProtoMessage() {}
func (*HandleKubernetesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0b899e296d745a6, []int{0}
}
func (m *HandleKubernetesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleKubernetesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HandleKubernetesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HandleKubernetesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleKubernetesRequest.Merge(m, src)
}
func (m *HandleKubernetesRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleKubernetesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleKubernetesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleKubernetesRequest proto.InternalMessageInfo

// Contains output payload for 'kubernetes' template.
type OutputMsg struct {
	// Refers to the source.uid for a pod. This is for TCP use cases where the attribute is not present.
	// attribute_bindings can refer to this field using $out.source_pod_uid
	SourcePodUid string `protobuf:"bytes,31,opt,name=source_pod_uid,json=sourcePodUid,proto3" json:"source_pod_uid,omitempty"`
	// Refers to source pod ip address. attribute_bindings can refer to this field using $out.source_pod_ip
	SourcePodIp *v1beta1.IPAddress `protobuf:"bytes,1,opt,name=source_pod_ip,json=sourcePodIp,proto3" json:"source_pod_ip,omitempty"`
	// Refers to source pod name. attribute_bindings can refer to this field using $out.source_pod_name
	SourcePodName string `protobuf:"bytes,2,opt,name=source_pod_name,json=sourcePodName,proto3" json:"source_pod_name,omitempty"`
	// Refers to source pod labels. attribute_bindings can refer to this field using $out.source_labels
	SourceLabels map[string]string `protobuf:"bytes,3,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Refers to source pod namespace. attribute_bindings can refer to this field using $out.source_namespace
	SourceNamespace string `protobuf:"bytes,4,opt,name=source_namespace,json=sourceNamespace,proto3" json:"source_namespace,omitempty"`
	// Refers to source pod service account name. attribute_bindings can refer to this field using $out.source_service_account_name
	SourceServiceAccountName string `protobuf:"bytes,6,opt,name=source_service_account_name,json=sourceServiceAccountName,proto3" json:"source_service_account_name,omitempty"`
	// Refers to source pod host ip address. attribute_bindings can refer to this field using $out.source_host_ip
	SourceHostIp *v1beta1.IPAddress `protobuf:"bytes,7,opt,name=source_host_ip,json=sourceHostIp,proto3" json:"source_host_ip,omitempty"`
	// Refers to the Istio workload identifier for the source pod. Attribute_bindings can refer to this field using $out.source_workload_uid
	SourceWorkloadUid string `protobuf:"bytes,22,opt,name=source_workload_uid,json=sourceWorkloadUid,proto3" json:"source_workload_uid,omitempty"`
	// Refers to the Istio workload name for the source pod. Attribute_bindings can refer to this field using $out.source_workload_name
	SourceWorkloadName string `protobuf:"bytes,23,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	// Refers to the Istio workload namespace for the source pod. Attribute_bindings can refer to this field using $out.source_workload_namespace
	SourceWorkloadNamespace string `protobuf:"bytes,24,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	// Refers to the (controlling) owner of the source pod. Attribute_bindings can refer to this field using $out.source_owner
	SourceOwner string `protobuf:"bytes,25,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	// Refers to the destination.uid for a pod. This is for TCP use cases where the attribute is not present.
	// attribute_bindings can refer to this field using $out.destination_pod_uid
	DestinationPodUid string `protobuf:"bytes,32,opt,name=destination_pod_uid,json=destinationPodUid,proto3" json:"destination_pod_uid,omitempty"`
	// Refers to destination pod ip address. attribute_bindings can refer to this field using $out.destination_pod_ip
	DestinationPodIp *v1beta1.IPAddress `protobuf:"bytes,8,opt,name=destination_pod_ip,json=destinationPodIp,proto3" json:"destination_pod_ip,omitempty"`
	// Refers to destination pod name. attribute_bindings can refer to this field using $out.destination_pod_name
	DestinationPodName string `protobuf:"bytes,9,opt,name=destination_pod_name,json=destinationPodName,proto3" json:"destination_pod_name,omitempty"`
	// Refers to destination container name. attribute_bindings can refer to this field using $out.destination_container_name
	DestinationContainerName string `protobuf:"bytes,30,opt,name=destination_container_name,json=destinationContainerName,proto3" json:"destination_container_name,omitempty"`
	// Refers to destination pod labels. attribute_bindings can refer to this field using $out.destination_labels
	DestinationLabels map[string]string `protobuf:"bytes,10,rep,name=destination_labels,json=destinationLabels,proto3" json:"destination_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Refers to destination pod namespace. attribute_bindings can refer to this field using $out.destination_namespace
	DestinationNamespace string `protobuf:"bytes,11,opt,name=destination_namespace,json=destinationNamespace,proto3" json:"destination_namespace,omitempty"`
	// Refers to destination pod service account name. attribute_bindings can refer to this field using $out.destination_service_account_name
	DestinationServiceAccountName string `protobuf:"bytes,13,opt,name=destination_service_account_name,json=destinationServiceAccountName,proto3" json:"destination_service_account_name,omitempty"`
	// Refers to destination pod host ip address. attribute_bindings can refer to this field using $out.destination_host_ip
	DestinationHostIp *v1beta1.IPAddress `protobuf:"bytes,14,opt,name=destination_host_ip,json=destinationHostIp,proto3" json:"destination_host_ip,omitempty"`
	// Refers to the (controlling) owner of the destination pod. Attribute_bindings can refer to this field using $out.destination_owner
	DestinationOwner string `protobuf:"bytes,26,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	// Refers to the Istio workload identifier for the destination pod. Attribute_bindings can refer to this field using $out.destination_workload_uid
	DestinationWorkloadUid string `protobuf:"bytes,27,opt,name=destination_workload_uid,json=destinationWorkloadUid,proto3" json:"destination_workload_uid,omitempty"`
	// Refers to the Istio workload name for the destination pod. Attribute_bindings can refer to this field using $out.destination_workload_name
	DestinationWorkloadName string `protobuf:"bytes,28,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	// Refers to the Istio workload name for the destination pod. Attribute_bindings can refer to this field using $out.destination_workload_namespace
	DestinationWorkloadNamespace string `protobuf:"bytes,29,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
}

func (m *OutputMsg) Reset()      { *m = OutputMsg{} }
func (*OutputMsg) ProtoMessage() {}
func (*OutputMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0b899e296d745a6, []int{1}
}
func (m *OutputMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutputMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutputMsg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutputMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputMsg.Merge(m, src)
}
func (m *OutputMsg) XXX_Size() int {
	return m.Size()
}
func (m *OutputMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputMsg.DiscardUnknown(m)
}

var xxx_messageInfo_OutputMsg proto.InternalMessageInfo

// Contains instance payload for 'kubernetes' template. This is passed to infrastructure backends during request-time
// through HandleKubernetesService.HandleKubernetes.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Source pod's uid. Must be of the form: "kubernetes://pod.namespace"
	SourceUid string `protobuf:"bytes,1,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Source pod's ip.
	SourceIp *v1beta1.IPAddress `protobuf:"bytes,2,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Destination pod's uid. Must be of the form: "kubernetes://pod.namespace"
	DestinationUid string `protobuf:"bytes,3,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Destination pod's ip.
	DestinationIp *v1beta1.IPAddress `protobuf:"bytes,4,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Destination container's port number.
	DestinationPort int64 `protobuf:"varint,7,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0b899e296d745a6, []int{2}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceMsg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'kubernetes' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0b899e296d745a6, []int{3}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

// Represents instance configuration schema for 'kubernetes' template.
type InstanceParam struct {
	// Source pod's uid. Must be of the form: "kubernetes://pod.namespace"
	SourceUid string `protobuf:"bytes,1,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Source pod's ip.
	SourceIp string `protobuf:"bytes,2,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Destination pod's uid. Must be of the form: "kubernetes://pod.namespace"
	DestinationUid string `protobuf:"bytes,3,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Destination pod's ip.
	DestinationIp string `protobuf:"bytes,4,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Destination container's port number.
	DestinationPort string `protobuf:"bytes,7,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// Attribute names to expression mapping. These expressions can use the fields from the output object
	// returned by the attribute producing adapters using $out.<fieldName> notation. For example:
	// source.ip : $out.source_pod_ip
	// In the above example, source.ip attribute will be added to the existing attribute list and its value will be set to
	// the value of source_pod_ip field of the output returned by the adapter.
	AttributeBindings map[string]string `protobuf:"bytes,72295728,rep,name=attribute_bindings,json=attributeBindings,proto3" json:"attribute_bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_a0b899e296d745a6, []int{4}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceParam.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleKubernetesRequest)(nil), "adapter.template.kubernetes.HandleKubernetesRequest")
	proto.RegisterType((*OutputMsg)(nil), "adapter.template.kubernetes.OutputMsg")
	proto.RegisterMapType((map[string]string)(nil), "adapter.template.kubernetes.OutputMsg.DestinationLabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "adapter.template.kubernetes.OutputMsg.SourceLabelsEntry")
	proto.RegisterType((*InstanceMsg)(nil), "adapter.template.kubernetes.InstanceMsg")
	proto.RegisterType((*Type)(nil), "adapter.template.kubernetes.Type")
	proto.RegisterType((*InstanceParam)(nil), "adapter.template.kubernetes.InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "adapter.template.kubernetes.InstanceParam.AttributeBindingsEntry")
}

func init() {
	proto.RegisterFile("mixer/adapter/kubernetesenv/template/template_handler_service.proto", fileDescriptor_a0b899e296d745a6)
}

var fileDescriptor_a0b899e296d745a6 = []byte{
	// 1068 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xf7, 0xda, 0xf9, 0xa6, 0xf1, 0x73, 0x9d, 0xa4, 0xf3, 0x4d, 0x93, 0xb5, 0xd3, 0x6c, 0x8d,
	0x05, 0x25, 0x08, 0xb4, 0xa6, 0x29, 0x87, 0x28, 0xb4, 0x42, 0x6e, 0x52, 0xa8, 0x05, 0xf9, 0x21,
	0x17, 0xc4, 0x09, 0x59, 0x63, 0xef, 0xd4, 0x5d, 0x65, 0x3d, 0xb3, 0xec, 0xce, 0xa6, 0xf5, 0x0d,
	0xb8, 0xf6, 0x82, 0xd4, 0x33, 0x77, 0x6e, 0x70, 0xe3, 0xc2, 0x1f, 0x50, 0x71, 0x8a, 0x38, 0xf5,
	0x82, 0x44, 0x9c, 0x1e, 0x38, 0xf6, 0xc8, 0x11, 0xed, 0xcc, 0xec, 0x7a, 0xec, 0x38, 0xc1, 0xe5,
	0xb6, 0x33, 0xf3, 0xf9, 0xbc, 0x79, 0xef, 0xf3, 0x3e, 0xfb, 0x76, 0x61, 0xbb, 0xe7, 0x3e, 0x21,
	0x41, 0x0d, 0x3b, 0xd8, 0xe7, 0x24, 0xa8, 0x1d, 0x46, 0x6d, 0x12, 0x50, 0xc2, 0x49, 0x48, 0xe8,
	0x51, 0x8d, 0x93, 0x9e, 0xef, 0x61, 0x4e, 0xd2, 0x87, 0xd6, 0x23, 0x4c, 0x1d, 0x8f, 0x04, 0xad,
	0x90, 0x04, 0x47, 0x6e, 0x87, 0xd8, 0x7e, 0xc0, 0x38, 0x43, 0xab, 0x8a, 0x6e, 0x27, 0x38, 0x7b,
	0x18, 0xa7, 0xbc, 0xd4, 0x65, 0x5d, 0x26, 0x70, 0xb5, 0xf8, 0x49, 0x52, 0xca, 0xef, 0x8d, 0xde,
	0xdb, 0x63, 0x0e, 0xf1, 0x6a, 0x47, 0x37, 0xdb, 0x84, 0xe3, 0x9b, 0x35, 0xf2, 0x84, 0x13, 0x1a,
	0xba, 0x8c, 0x86, 0x0a, 0x5d, 0xea, 0x32, 0xd6, 0xf5, 0x48, 0x4d, 0xac, 0xda, 0xd1, 0xc3, 0x1a,
	0xa6, 0xfd, 0xe4, 0xc8, 0x67, 0x9e, 0xdb, 0xe9, 0xa7, 0x5c, 0xde, 0xf7, 0x55, 0x5a, 0xd5, 0x5f,
	0x0c, 0x58, 0xb9, 0x2f, 0x12, 0xfe, 0x34, 0x4d, 0xa7, 0x49, 0xbe, 0x8e, 0x48, 0xc8, 0xd1, 0x0e,
	0xcc, 0xb9, 0x34, 0xe4, 0x98, 0x76, 0x88, 0x69, 0x54, 0x8c, 0xf5, 0xc2, 0xc6, 0xba, 0x7d, 0x41,
	0x15, 0x76, 0x43, 0x81, 0x77, 0xc3, 0x6e, 0x33, 0x65, 0xa2, 0x0f, 0x61, 0x5e, 0x91, 0x5a, 0x1d,
	0x46, 0x1f, 0xba, 0x5d, 0x33, 0x2b, 0x62, 0x2d, 0xd9, 0x32, 0x61, 0x3b, 0x49, 0xd8, 0xae, 0xd3,
	0x7e, 0xb3, 0xa8, 0xb0, 0xdb, 0x02, 0x8a, 0x4a, 0x30, 0xe7, 0x10, 0x27, 0xf2, 0x5b, 0xae, 0x63,
	0xe6, 0x2a, 0xc6, 0x7a, 0xbe, 0x79, 0x49, 0xac, 0x1b, 0x4e, 0xf5, 0xe9, 0x65, 0xc8, 0xef, 0x47,
	0xdc, 0x8f, 0xf8, 0x6e, 0xd8, 0x45, 0x6f, 0xc2, 0x7c, 0xc8, 0xa2, 0xa0, 0x43, 0x5a, 0x3e, 0x73,
	0x5a, 0x91, 0xeb, 0x98, 0xd7, 0x05, 0xfc, 0xb2, 0xdc, 0x3d, 0x60, 0xce, 0x17, 0xae, 0x83, 0xb6,
	0xa1, 0xa8, 0xa1, 0x5c, 0x5f, 0x95, 0x75, 0xdd, 0x76, 0x43, 0xee, 0x32, 0x5b, 0xca, 0x64, 0x2b,
	0x99, 0xec, 0xc6, 0x41, 0xdd, 0x71, 0x02, 0x12, 0x86, 0xcd, 0x42, 0x1a, 0xa5, 0xe1, 0xa3, 0x1b,
	0xb0, 0xa0, 0x05, 0xa1, 0xb8, 0x47, 0x44, 0x45, 0xf9, 0x66, 0x31, 0x45, 0xed, 0xe1, 0x1e, 0x41,
	0x5f, 0xa5, 0x97, 0x79, 0xb8, 0x4d, 0xbc, 0xd0, 0xcc, 0x55, 0x72, 0xeb, 0x85, 0x8d, 0xcd, 0x0b,
	0x35, 0x4c, 0x2b, 0xb2, 0x1f, 0x08, 0xee, 0x67, 0x82, 0x7a, 0x8f, 0xf2, 0xa0, 0x9f, 0xd4, 0x22,
	0xb7, 0xd0, 0x3b, 0xb0, 0xa8, 0xc2, 0xc7, 0x29, 0x84, 0x3e, 0xee, 0x10, 0x73, 0x46, 0xe4, 0xa1,
	0xd2, 0xdb, 0x4b, 0xb6, 0xd1, 0x1d, 0x58, 0x55, 0x50, 0xe5, 0xc9, 0x16, 0xee, 0x74, 0x58, 0x44,
	0xb9, 0xcc, 0x7e, 0x56, 0xb0, 0x4c, 0x09, 0x79, 0x20, 0x11, 0x75, 0x09, 0x10, 0x85, 0xdc, 0x4b,
	0xb5, 0x7d, 0xc4, 0x42, 0x1e, 0xcb, 0x76, 0x69, 0x3a, 0xd9, 0x54, 0xc2, 0xf7, 0x59, 0xc8, 0x1b,
	0x3e, 0xb2, 0xe1, 0xff, 0x2a, 0xcc, 0x63, 0x16, 0x1c, 0x7a, 0x0c, 0xcb, 0x3e, 0x2d, 0x8b, 0xdb,
	0xaf, 0xc8, 0xa3, 0x2f, 0xd5, 0x49, 0xdc, 0xac, 0xf7, 0x61, 0x69, 0x1c, 0x2f, 0xd2, 0x5d, 0x11,
	0x04, 0x34, 0x4a, 0x10, 0x89, 0x6e, 0x41, 0x69, 0x12, 0x43, 0x6a, 0x63, 0x0a, 0xda, 0xca, 0x59,
	0x9a, 0xd4, 0xe8, 0x0d, 0x50, 0xd9, 0xb6, 0xd8, 0x63, 0x4a, 0x02, 0xb3, 0x24, 0xe0, 0xaa, 0xf1,
	0xfb, 0xf1, 0x56, 0x5c, 0x80, 0x43, 0x42, 0xee, 0x52, 0xcc, 0x5d, 0x46, 0x53, 0xa3, 0x55, 0x64,
	0x01, 0xda, 0x91, 0x72, 0xdb, 0x2e, 0xa0, 0x71, 0xbc, 0xeb, 0x9b, 0x73, 0xd3, 0x69, 0xb7, 0x38,
	0x1a, 0xaf, 0xe1, 0xc7, 0x7a, 0x8c, 0x87, 0x13, 0x7a, 0xe4, 0xa5, 0x1e, 0xa3, 0x78, 0xa1, 0xc7,
	0x6d, 0x28, 0xeb, 0x8c, 0x0e, 0xa3, 0x1c, 0xbb, 0x94, 0x04, 0x92, 0x67, 0xc9, 0xb6, 0x6b, 0x88,
	0xed, 0x04, 0x20, 0xd8, 0xde, 0x68, 0xfa, 0xca, 0xc4, 0x20, 0x4c, 0x7c, 0x67, 0x4a, 0x13, 0xef,
	0x0c, 0x03, 0xe8, 0x4e, 0xd6, 0xc5, 0x52, 0x76, 0xbe, 0x05, 0x57, 0xf5, 0xdb, 0x86, 0x7d, 0x2b,
	0x88, 0x34, 0xf5, 0xd2, 0x87, 0x4d, 0xfb, 0x04, 0x2a, 0x3a, 0x69, 0xa2, 0xbb, 0x8b, 0x82, 0xbf,
	0xa6, 0xe1, 0x26, 0x58, 0x7c, 0x7f, 0xb4, 0xb5, 0x89, 0xcf, 0xe7, 0xa7, 0xeb, 0x95, 0x5e, 0x8e,
	0x32, 0xfb, 0xbb, 0xa0, 0x6f, 0x2a, 0x4f, 0x95, 0x45, 0x2a, 0x7a, 0x67, 0xa5, 0xb1, 0x36, 0x41,
	0xef, 0xc2, 0xe8, 0xeb, 0xb1, 0x2a, 0x38, 0xcb, 0xda, 0xb9, 0xfe, 0x8e, 0x6c, 0x41, 0x69, 0x22,
	0x53, 0x54, 0x7e, 0x4d, 0x3a, 0x7e, 0x02, 0x55, 0xd4, 0xbc, 0x03, 0xd6, 0xb9, 0x5c, 0x29, 0xfd,
	0x9a, 0x08, 0x70, 0xed, 0x9c, 0x00, 0x02, 0x53, 0xfe, 0x08, 0xae, 0x9c, 0x99, 0x54, 0x68, 0x11,
	0x72, 0x87, 0xa4, 0x2f, 0xa6, 0x6b, 0xbe, 0x19, 0x3f, 0xa2, 0x25, 0xf8, 0xdf, 0x11, 0xf6, 0xa2,
	0x64, 0x54, 0xca, 0xc5, 0x56, 0x76, 0xd3, 0x28, 0xef, 0xc0, 0xf2, 0x64, 0x97, 0xbc, 0x4e, 0x94,
	0xea, 0x0f, 0x59, 0x28, 0x68, 0xdf, 0x1f, 0x74, 0x15, 0x66, 0x84, 0x06, 0x3f, 0xfd, 0xf6, 0x6b,
	0x55, 0x60, 0xc5, 0x12, 0xad, 0x01, 0xa8, 0xb7, 0x3c, 0xd6, 0x56, 0x46, 0xce, 0xcb, 0x9d, 0x58,
	0xce, 0xdb, 0xa0, 0x16, 0x71, 0xf3, 0xb3, 0xd3, 0x35, 0x7f, 0x4e, 0x32, 0x1a, 0x3e, 0x7a, 0x1b,
	0x16, 0x74, 0x41, 0xa3, 0xf4, 0x9b, 0x35, 0xaf, 0x6d, 0xc7, 0xd7, 0x7c, 0x0c, 0xfa, 0x4e, 0x7c,
	0xd7, 0xcc, 0x74, 0x77, 0x15, 0x35, 0x5a, 0xc3, 0x8f, 0x3f, 0x01, 0xa3, 0x13, 0x21, 0xe0, 0x62,
	0x34, 0xe7, 0x9a, 0x0b, 0x23, 0xd3, 0x20, 0xe0, 0xd5, 0x59, 0x98, 0xf9, 0xbc, 0xef, 0x93, 0xea,
	0xb7, 0x39, 0x28, 0x26, 0x3a, 0x1d, 0xe0, 0x00, 0xf7, 0xfe, 0x4d, 0x92, 0xd5, 0x71, 0x49, 0xf2,
	0xff, 0xa5, 0xe2, 0xb7, 0x26, 0x56, 0x9c, 0x9f, 0xb6, 0xa0, 0xfc, 0x99, 0x82, 0x50, 0x08, 0x08,
	0x73, 0x1e, 0xb8, 0xed, 0x88, 0x93, 0x56, 0xdb, 0xa5, 0x8e, 0x4b, 0xbb, 0xa1, 0xf9, 0x73, 0xdc,
	0xee, 0x78, 0x40, 0xd5, 0xa7, 0xfa, 0x53, 0x11, 0x0a, 0xd8, 0xf5, 0x24, 0xce, 0x5d, 0x15, 0x46,
	0x0d, 0x29, 0x3c, 0xbe, 0x1f, 0x7b, 0x75, 0x32, 0xf8, 0x75, 0xbc, 0xba, 0xf1, 0x74, 0xc2, 0x3f,
	0x97, 0x9a, 0x49, 0xc8, 0x87, 0xc5, 0xf1, 0x23, 0xf4, 0xc1, 0x85, 0xb5, 0x9c, 0xf3, 0xf7, 0x56,
	0xbe, 0x31, 0xdd, 0x88, 0xbe, 0xbb, 0xf7, 0xfc, 0xc4, 0xca, 0x1c, 0x9f, 0x58, 0x99, 0x17, 0x27,
	0x56, 0xe6, 0xd5, 0x89, 0x95, 0xf9, 0x66, 0x60, 0x19, 0x3f, 0x0e, 0xac, 0xcc, 0xf3, 0x81, 0x65,
	0x1c, 0x0f, 0x2c, 0xe3, 0xcf, 0x81, 0x65, 0xfc, 0x35, 0xb0, 0x32, 0xaf, 0x06, 0x96, 0xf1, 0xfd,
	0xa9, 0x95, 0x39, 0x3e, 0xb5, 0x32, 0x2f, 0x4e, 0xad, 0xcc, 0xdf, 0xbf, 0xbf, 0x7c, 0x96, 0xcd,
	0x7d, 0xf7, 0xc7, 0xcb, 0x67, 0x59, 0x18, 0x46, 0x6e, 0xcf, 0x8a, 0xff, 0xb9, 0x5b, 0xff, 0x04,
	0x00, 0x00, 0xff, 0xff, 0xa8, 0x45, 0x63, 0x94, 0x36, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleKubernetesServiceClient is the client API for HandleKubernetesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleKubernetesServiceClient interface {
	// HandleKubernetes is called by Mixer at request-time to deliver 'kubernetes' instances to the backend.
	HandleKubernetes(ctx context.Context, in *HandleKubernetesRequest, opts ...grpc.CallOption) (*OutputMsg, error)
}

type handleKubernetesServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleKubernetesServiceClient(cc *grpc.ClientConn) HandleKubernetesServiceClient {
	return &handleKubernetesServiceClient{cc}
}

func (c *handleKubernetesServiceClient) HandleKubernetes(ctx context.Context, in *HandleKubernetesRequest, opts ...grpc.CallOption) (*OutputMsg, error) {
	out := new(OutputMsg)
	err := c.cc.Invoke(ctx, "/adapter.template.kubernetes.HandleKubernetesService/HandleKubernetes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleKubernetesServiceServer is the server API for HandleKubernetesService service.
type HandleKubernetesServiceServer interface {
	// HandleKubernetes is called by Mixer at request-time to deliver 'kubernetes' instances to the backend.
	HandleKubernetes(context.Context, *HandleKubernetesRequest) (*OutputMsg, error)
}

// UnimplementedHandleKubernetesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHandleKubernetesServiceServer struct {
}

func (*UnimplementedHandleKubernetesServiceServer) HandleKubernetes(ctx context.Context, req *HandleKubernetesRequest) (*OutputMsg, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleKubernetes not implemented")
}

func RegisterHandleKubernetesServiceServer(s *grpc.Server, srv HandleKubernetesServiceServer) {
	s.RegisterService(&_HandleKubernetesService_serviceDesc, srv)
}

func _HandleKubernetesService_HandleKubernetes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleKubernetesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleKubernetesServiceServer).HandleKubernetes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/adapter.template.kubernetes.HandleKubernetesService/HandleKubernetes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleKubernetesServiceServer).HandleKubernetes(ctx, req.(*HandleKubernetesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleKubernetesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "adapter.template.kubernetes.HandleKubernetesService",
	HandlerType: (*HandleKubernetesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleKubernetes",
			Handler:    _HandleKubernetesService_HandleKubernetes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/adapter/kubernetesenv/template/template_handler_service.proto",
}

func (m *HandleKubernetesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleKubernetesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleKubernetesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DedupId) > 0 {
		i -= len(m.DedupId)
		copy(dAtA[i:], m.DedupId)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AdapterConfig != nil {
		{
			size, err := m.AdapterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Instance != nil {
		{
			size, err := m.Instance.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OutputMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutputMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OutputMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DestinationPodUid) > 0 {
		i -= len(m.DestinationPodUid)
		copy(dAtA[i:], m.DestinationPodUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationPodUid)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if len(m.SourcePodUid) > 0 {
		i -= len(m.SourcePodUid)
		copy(dAtA[i:], m.SourcePodUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourcePodUid)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.DestinationContainerName) > 0 {
		i -= len(m.DestinationContainerName)
		copy(dAtA[i:], m.DestinationContainerName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationContainerName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		i -= len(m.DestinationWorkloadNamespace)
		copy(dAtA[i:], m.DestinationWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if len(m.DestinationWorkloadName) > 0 {
		i -= len(m.DestinationWorkloadName)
		copy(dAtA[i:], m.DestinationWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if len(m.DestinationWorkloadUid) > 0 {
		i -= len(m.DestinationWorkloadUid)
		copy(dAtA[i:], m.DestinationWorkloadUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadUid)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.DestinationOwner) > 0 {
		i -= len(m.DestinationOwner)
		copy(dAtA[i:], m.DestinationOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if len(m.SourceOwner) > 0 {
		i -= len(m.SourceOwner)
		copy(dAtA[i:], m.SourceOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		i -= len(m.SourceWorkloadNamespace)
		copy(dAtA[i:], m.SourceWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if len(m.SourceWorkloadName) > 0 {
		i -= len(m.SourceWorkloadName)
		copy(dAtA[i:], m.SourceWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if len(m.SourceWorkloadUid) > 0 {
		i -= len(m.SourceWorkloadUid)
		copy(dAtA[i:], m.SourceWorkloadUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadUid)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.DestinationHostIp != nil {
		{
			size, err := m.DestinationHostIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if len(m.DestinationServiceAccountName) > 0 {
		i -= len(m.DestinationServiceAccountName)
		copy(dAtA[i:], m.DestinationServiceAccountName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceAccountName)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.DestinationNamespace) > 0 {
		i -= len(m.DestinationNamespace)
		copy(dAtA[i:], m.DestinationNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationNamespace)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.DestinationLabels) > 0 {
		for k := range m.DestinationLabels {
			v := m.DestinationLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.DestinationPodName) > 0 {
		i -= len(m.DestinationPodName)
		copy(dAtA[i:], m.DestinationPodName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationPodName)))
		i--
		dAtA[i] = 0x4a
	}
	if m.DestinationPodIp != nil {
		{
			size, err := m.DestinationPodIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.SourceHostIp != nil {
		{
			size, err := m.SourceHostIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.SourceServiceAccountName) > 0 {
		i -= len(m.SourceServiceAccountName)
		copy(dAtA[i:], m.SourceServiceAccountName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceServiceAccountName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.SourceNamespace) > 0 {
		i -= len(m.SourceNamespace)
		copy(dAtA[i:], m.SourceNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceNamespace)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SourceLabels) > 0 {
		for k := range m.SourceLabels {
			v := m.SourceLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SourcePodName) > 0 {
		i -= len(m.SourcePodName)
		copy(dAtA[i:], m.SourcePodName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourcePodName)))
		i--
		dAtA[i] = 0x12
	}
	if m.SourcePodIp != nil {
		{
			size, err := m.SourcePodIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x93
		i--
		dAtA[i] = 0xe4
		i--
		dAtA[i] = 0xd2
		i--
		dAtA[i] = 0xfa
	}
	if m.DestinationPort != 0 {
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.DestinationPort))
		i--
		dAtA[i] = 0x38
	}
	if m.DestinationIp != nil {
		{
			size, err := m.DestinationIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.DestinationUid) > 0 {
		i -= len(m.DestinationUid)
		copy(dAtA[i:], m.DestinationUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i--
		dAtA[i] = 0x1a
	}
	if m.SourceIp != nil {
		{
			size, err := m.SourceIp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.SourceUid) > 0 {
		i -= len(m.SourceUid)
		copy(dAtA[i:], m.SourceUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AttributeBindings) > 0 {
		for k := range m.AttributeBindings {
			v := m.AttributeBindings[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x93
			i--
			dAtA[i] = 0xe4
			i--
			dAtA[i] = 0xd3
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.DestinationPort) > 0 {
		i -= len(m.DestinationPort)
		copy(dAtA[i:], m.DestinationPort)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationPort)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.DestinationIp) > 0 {
		i -= len(m.DestinationIp)
		copy(dAtA[i:], m.DestinationIp)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationIp)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DestinationUid) > 0 {
		i -= len(m.DestinationUid)
		copy(dAtA[i:], m.DestinationUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SourceIp) > 0 {
		i -= len(m.SourceIp)
		copy(dAtA[i:], m.SourceIp)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceIp)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SourceUid) > 0 {
		i -= len(m.SourceUid)
		copy(dAtA[i:], m.SourceUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	offset -= sovTemplateHandlerService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HandleKubernetesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Instance != nil {
		l = m.Instance.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *OutputMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SourcePodIp != nil {
		l = m.SourcePodIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourcePodName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.SourceLabels) > 0 {
		for k, v := range m.SourceLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.SourceNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceServiceAccountName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.SourceHostIp != nil {
		l = m.SourceHostIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.DestinationPodIp != nil {
		l = m.DestinationPodIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationPodName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.DestinationLabels) > 0 {
		for k, v := range m.DestinationLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.DestinationNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceAccountName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.DestinationHostIp != nil {
		l = m.DestinationHostIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationContainerName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourcePodUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationPodUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.SourceIp != nil {
		l = m.SourceIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.DestinationIp != nil {
		l = m.DestinationIp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.DestinationPort != 0 {
		n += 1 + sovTemplateHandlerService(uint64(m.DestinationPort))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceIp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationIp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationPort)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.AttributeBindings) > 0 {
		for k, v := range m.AttributeBindings {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 5 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleKubernetesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleKubernetesRequest{`,
		`Instance:` + strings.Replace(this.Instance.String(), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OutputMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForSourceLabels := make([]string, 0, len(this.SourceLabels))
	for k, _ := range this.SourceLabels {
		keysForSourceLabels = append(keysForSourceLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSourceLabels)
	mapStringForSourceLabels := "map[string]string{"
	for _, k := range keysForSourceLabels {
		mapStringForSourceLabels += fmt.Sprintf("%v: %v,", k, this.SourceLabels[k])
	}
	mapStringForSourceLabels += "}"
	keysForDestinationLabels := make([]string, 0, len(this.DestinationLabels))
	for k, _ := range this.DestinationLabels {
		keysForDestinationLabels = append(keysForDestinationLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDestinationLabels)
	mapStringForDestinationLabels := "map[string]string{"
	for _, k := range keysForDestinationLabels {
		mapStringForDestinationLabels += fmt.Sprintf("%v: %v,", k, this.DestinationLabels[k])
	}
	mapStringForDestinationLabels += "}"
	s := strings.Join([]string{`&OutputMsg{`,
		`SourcePodIp:` + strings.Replace(fmt.Sprintf("%v", this.SourcePodIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`SourcePodName:` + fmt.Sprintf("%v", this.SourcePodName) + `,`,
		`SourceLabels:` + mapStringForSourceLabels + `,`,
		`SourceNamespace:` + fmt.Sprintf("%v", this.SourceNamespace) + `,`,
		`SourceServiceAccountName:` + fmt.Sprintf("%v", this.SourceServiceAccountName) + `,`,
		`SourceHostIp:` + strings.Replace(fmt.Sprintf("%v", this.SourceHostIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DestinationPodIp:` + strings.Replace(fmt.Sprintf("%v", this.DestinationPodIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DestinationPodName:` + fmt.Sprintf("%v", this.DestinationPodName) + `,`,
		`DestinationLabels:` + mapStringForDestinationLabels + `,`,
		`DestinationNamespace:` + fmt.Sprintf("%v", this.DestinationNamespace) + `,`,
		`DestinationServiceAccountName:` + fmt.Sprintf("%v", this.DestinationServiceAccountName) + `,`,
		`DestinationHostIp:` + strings.Replace(fmt.Sprintf("%v", this.DestinationHostIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`SourceWorkloadUid:` + fmt.Sprintf("%v", this.SourceWorkloadUid) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationWorkloadUid:` + fmt.Sprintf("%v", this.DestinationWorkloadUid) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationContainerName:` + fmt.Sprintf("%v", this.DestinationContainerName) + `,`,
		`SourcePodUid:` + fmt.Sprintf("%v", this.SourcePodUid) + `,`,
		`DestinationPodUid:` + fmt.Sprintf("%v", this.DestinationPodUid) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceMsg{`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`SourceIp:` + strings.Replace(fmt.Sprintf("%v", this.SourceIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationIp:` + strings.Replace(fmt.Sprintf("%v", this.DestinationIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DestinationPort:` + fmt.Sprintf("%v", this.DestinationPort) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForAttributeBindings := make([]string, 0, len(this.AttributeBindings))
	for k, _ := range this.AttributeBindings {
		keysForAttributeBindings = append(keysForAttributeBindings, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributeBindings)
	mapStringForAttributeBindings := "map[string]string{"
	for _, k := range keysForAttributeBindings {
		mapStringForAttributeBindings += fmt.Sprintf("%v: %v,", k, this.AttributeBindings[k])
	}
	mapStringForAttributeBindings += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`SourceIp:` + fmt.Sprintf("%v", this.SourceIp) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationIp:` + fmt.Sprintf("%v", this.DestinationIp) + `,`,
		`DestinationPort:` + fmt.Sprintf("%v", this.DestinationPort) + `,`,
		`AttributeBindings:` + mapStringForAttributeBindings + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleKubernetesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleKubernetesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleKubernetesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instance", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Instance == nil {
				m.Instance = &InstanceMsg{}
			}
			if err := m.Instance.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutputMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutputMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutputMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePodIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourcePodIp == nil {
				m.SourcePodIp = &v1beta1.IPAddress{}
			}
			if err := m.SourcePodIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePodName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceLabels == nil {
				m.SourceLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SourceLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceServiceAccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceServiceAccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceHostIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceHostIp == nil {
				m.SourceHostIp = &v1beta1.IPAddress{}
			}
			if err := m.SourceHostIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPodIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationPodIp == nil {
				m.DestinationPodIp = &v1beta1.IPAddress{}
			}
			if err := m.DestinationPodIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationPodName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationLabels == nil {
				m.DestinationLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DestinationLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceAccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceAccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationHostIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationHostIp == nil {
				m.DestinationHostIp = &v1beta1.IPAddress{}
			}
			if err := m.DestinationHostIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationContainerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationContainerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePodUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePodUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPodUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationPodUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceIp == nil {
				m.SourceIp = &v1beta1.IPAddress{}
			}
			if err := m.SourceIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationIp == nil {
				m.DestinationIp = &v1beta1.IPAddress{}
			}
			if err := m.DestinationIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPort", wireType)
			}
			m.DestinationPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DestinationPort |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationPort = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295728:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeBindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttributeBindings == nil {
				m.AttributeBindings = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AttributeBindings[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthTemplateHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)
