// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/config/client/client_config.proto

// Describes the configuration state for the Mixer client library that's built into Envoy.

package client

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1 "istio.io/api/mixer/v1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Describes the policy.
type NetworkFailPolicy_FailPolicy int32

const (
	// If network connection fails, request is allowed and delivered to the
	// service.
	FAIL_OPEN NetworkFailPolicy_FailPolicy = 0
	// If network connection fails, request is rejected.
	FAIL_CLOSE NetworkFailPolicy_FailPolicy = 1
)

var NetworkFailPolicy_FailPolicy_name = map[int32]string{
	0: "FAIL_OPEN",
	1: "FAIL_CLOSE",
}

var NetworkFailPolicy_FailPolicy_value = map[string]int32{
	"FAIL_OPEN":  0,
	"FAIL_CLOSE": 1,
}

func (NetworkFailPolicy_FailPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{0, 0}
}

// Specifies the behavior when the client is unable to connect to Mixer.
type NetworkFailPolicy struct {
	// Specifies the behavior when the client is unable to connect to Mixer.
	Policy NetworkFailPolicy_FailPolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=istio.mixer.v1.config.client.NetworkFailPolicy_FailPolicy" json:"policy,omitempty"`
	// Max retries on transport error.
	MaxRetry uint32 `protobuf:"varint,2,opt,name=max_retry,json=maxRetry,proto3" json:"max_retry,omitempty"`
	// Base time to wait between retries.  Will be adjusted by exponential
	// backoff and jitter.
	BaseRetryWait *types.Duration `protobuf:"bytes,3,opt,name=base_retry_wait,json=baseRetryWait,proto3" json:"base_retry_wait,omitempty"`
	// Max time to wait between retries.
	MaxRetryWait *types.Duration `protobuf:"bytes,4,opt,name=max_retry_wait,json=maxRetryWait,proto3" json:"max_retry_wait,omitempty"`
}

func (m *NetworkFailPolicy) Reset()      { *m = NetworkFailPolicy{} }
func (*NetworkFailPolicy) ProtoMessage() {}
func (*NetworkFailPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{0}
}
func (m *NetworkFailPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkFailPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *NetworkFailPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkFailPolicy.Merge(m, src)
}
func (m *NetworkFailPolicy) XXX_Size() int {
	return m.Size()
}
func (m *NetworkFailPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkFailPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkFailPolicy proto.InternalMessageInfo

// Defines the per-service client configuration.
type ServiceConfig struct {
	// If true, do not call Mixer Check.
	DisableCheckCalls bool `protobuf:"varint,1,opt,name=disable_check_calls,json=disableCheckCalls,proto3" json:"disable_check_calls,omitempty"`
	// If true, do not call Mixer Report.
	DisableReportCalls bool `protobuf:"varint,2,opt,name=disable_report_calls,json=disableReportCalls,proto3" json:"disable_report_calls,omitempty"`
	// Send these attributes to Mixer in both Check and Report. This
	// typically includes the "destination.service" attribute.
	// In case of a per-route override, per-route attributes take precedence
	// over the attributes supplied in the client configuration.
	MixerAttributes *v1.Attributes `protobuf:"bytes,3,opt,name=mixer_attributes,json=mixerAttributes,proto3" json:"mixer_attributes,omitempty"`
	// HTTP API specifications to generate API attributes.
	HttpApiSpec []*HTTPAPISpec `protobuf:"bytes,4,rep,name=http_api_spec,json=httpApiSpec,proto3" json:"http_api_spec,omitempty"`
	// Quota specifications to generate quota requirements.
	QuotaSpec []*QuotaSpec `protobuf:"bytes,5,rep,name=quota_spec,json=quotaSpec,proto3" json:"quota_spec,omitempty"`
	// Specifies the behavior when the client is unable to connect to Mixer.
	// This is the service-level policy. It overrides
	// [mesh-level
	// policy][istio.mixer.v1.config.client.TransportConfig.network_fail_policy].
	NetworkFailPolicy *NetworkFailPolicy `protobuf:"bytes,7,opt,name=network_fail_policy,json=networkFailPolicy,proto3" json:"network_fail_policy,omitempty"`
	// Default attributes to forward to upstream. This typically
	// includes the "source.ip" and "source.uid" attributes.
	// In case of a per-route override, per-route attributes take precedence
	// over the attributes supplied in the client configuration.
	//
	// Forwarded attributes take precedence over the static Mixer attributes.
	// The full order of application is as follows:
	// 1. static Mixer attributes from the filter config;
	// 2. static Mixer attributes from the route config;
	// 3. forwarded attributes from the source filter config (if any);
	// 4. forwarded attributes from the source route config (if any);
	// 5. derived attributes from the request metadata.
	ForwardAttributes *v1.Attributes `protobuf:"bytes,8,opt,name=forward_attributes,json=forwardAttributes,proto3" json:"forward_attributes,omitempty"`
}

func (m *ServiceConfig) Reset()      { *m = ServiceConfig{} }
func (*ServiceConfig) ProtoMessage() {}
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{1}
}
func (m *ServiceConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ServiceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConfig.Merge(m, src)
}
func (m *ServiceConfig) XXX_Size() int {
	return m.Size()
}
func (m *ServiceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConfig proto.InternalMessageInfo

// Defines the transport config on how to call Mixer.
type TransportConfig struct {
	// The flag to disable check cache.
	DisableCheckCache bool `protobuf:"varint,1,opt,name=disable_check_cache,json=disableCheckCache,proto3" json:"disable_check_cache,omitempty"`
	// The flag to disable quota cache.
	DisableQuotaCache bool `protobuf:"varint,2,opt,name=disable_quota_cache,json=disableQuotaCache,proto3" json:"disable_quota_cache,omitempty"`
	// The flag to disable report batch.
	DisableReportBatch bool `protobuf:"varint,3,opt,name=disable_report_batch,json=disableReportBatch,proto3" json:"disable_report_batch,omitempty"`
	// Specifies the behavior when the client is unable to connect to Mixer.
	// This is the mesh level policy. The default value for policy is FAIL_OPEN.
	NetworkFailPolicy *NetworkFailPolicy `protobuf:"bytes,4,opt,name=network_fail_policy,json=networkFailPolicy,proto3" json:"network_fail_policy,omitempty"`
	// Specify refresh interval to write Mixer client statistics to Envoy share
	// memory. If not specified, the interval is 10 seconds.
	StatsUpdateInterval *types.Duration `protobuf:"bytes,5,opt,name=stats_update_interval,json=statsUpdateInterval,proto3" json:"stats_update_interval,omitempty"`
	// Name of the cluster that will forward check calls to a pool of mixer
	// servers. Defaults to "mixer_server". By using different names for
	// checkCluster and reportCluster, it is possible to have one set of
	// Mixer servers handle check calls, while another set of Mixer servers
	// handle report calls.
	//
	// NOTE: Any value other than the default "mixer_server" will require the
	// Istio Grafana dashboards to be reconfigured to use the new name.
	CheckCluster string `protobuf:"bytes,6,opt,name=check_cluster,json=checkCluster,proto3" json:"check_cluster,omitempty"`
	// Name of the cluster that will forward report calls to a pool of mixer
	// servers. Defaults to "mixer_server". By using different names for
	// checkCluster and reportCluster, it is possible to have one set of
	// Mixer servers handle check calls, while another set of Mixer servers
	// handle report calls.
	//
	// NOTE: Any value other than the default "mixer_server" will require the
	// Istio Grafana dashboards to be reconfigured to use the new name.
	ReportCluster string `protobuf:"bytes,7,opt,name=report_cluster,json=reportCluster,proto3" json:"report_cluster,omitempty"`
	// Default attributes to forward to Mixer upstream. This typically
	// includes the "source.ip" and "source.uid" attributes. These
	// attributes are consumed by the proxy in front of mixer.
	AttributesForMixerProxy *v1.Attributes `protobuf:"bytes,8,opt,name=attributes_for_mixer_proxy,json=attributesForMixerProxy,proto3" json:"attributes_for_mixer_proxy,omitempty"`
	// When disable_report_batch is false, this value specifies the maximum number
	// of requests that are batched in report. If left unspecified, the default value
	// of report_batch_max_entries == 0 will use the hardcoded defaults of
	// istio::mixerclient::ReportOptions.
	ReportBatchMaxEntries uint32 `protobuf:"varint,9,opt,name=report_batch_max_entries,json=reportBatchMaxEntries,proto3" json:"report_batch_max_entries,omitempty"`
	// When disable_report_batch is false, this value specifies the maximum elapsed
	// time a batched report will be sent after a user request is processed. If left
	// unspecified, the default report_batch_max_time == 0 will use the hardcoded
	// defaults of istio::mixerclient::ReportOptions.
	ReportBatchMaxTime *types.Duration `protobuf:"bytes,10,opt,name=report_batch_max_time,json=reportBatchMaxTime,proto3" json:"report_batch_max_time,omitempty"`
}

func (m *TransportConfig) Reset()      { *m = TransportConfig{} }
func (*TransportConfig) ProtoMessage() {}
func (*TransportConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{2}
}
func (m *TransportConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransportConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *TransportConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransportConfig.Merge(m, src)
}
func (m *TransportConfig) XXX_Size() int {
	return m.Size()
}
func (m *TransportConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TransportConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TransportConfig proto.InternalMessageInfo

// Defines the client config for HTTP.
type HttpClientConfig struct {
	// The transport config.
	Transport *TransportConfig `protobuf:"bytes,1,opt,name=transport,proto3" json:"transport,omitempty"`
	// Map of control configuration indexed by destination.service. This
	// is used to support per-service configuration for cases where a
	// mixerclient serves multiple services.
	ServiceConfigs map[string]*ServiceConfig `protobuf:"bytes,2,rep,name=service_configs,json=serviceConfigs,proto3" json:"service_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Default destination service name if none was specified in the
	// client request.
	DefaultDestinationService string `protobuf:"bytes,3,opt,name=default_destination_service,json=defaultDestinationService,proto3" json:"default_destination_service,omitempty"`
	// Default attributes to send to Mixer in both Check and
	// Report. This typically includes "destination.ip" and
	// "destination.uid" attributes.
	MixerAttributes *v1.Attributes `protobuf:"bytes,4,opt,name=mixer_attributes,json=mixerAttributes,proto3" json:"mixer_attributes,omitempty"`
	// Default attributes to forward to upstream. This typically
	// includes the "source.ip" and "source.uid" attributes.
	ForwardAttributes *v1.Attributes `protobuf:"bytes,5,opt,name=forward_attributes,json=forwardAttributes,proto3" json:"forward_attributes,omitempty"`
}

func (m *HttpClientConfig) Reset()      { *m = HttpClientConfig{} }
func (*HttpClientConfig) ProtoMessage() {}
func (*HttpClientConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{3}
}
func (m *HttpClientConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpClientConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HttpClientConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpClientConfig.Merge(m, src)
}
func (m *HttpClientConfig) XXX_Size() int {
	return m.Size()
}
func (m *HttpClientConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpClientConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HttpClientConfig proto.InternalMessageInfo

// Defines the client config for TCP.
type TcpClientConfig struct {
	// The transport config.
	Transport *TransportConfig `protobuf:"bytes,1,opt,name=transport,proto3" json:"transport,omitempty"`
	// Default attributes to send to Mixer in both Check and
	// Report. This typically includes "destination.ip" and
	// "destination.uid" attributes.
	MixerAttributes *v1.Attributes `protobuf:"bytes,2,opt,name=mixer_attributes,json=mixerAttributes,proto3" json:"mixer_attributes,omitempty"`
	// If set to true, disables Mixer check calls.
	DisableCheckCalls bool `protobuf:"varint,3,opt,name=disable_check_calls,json=disableCheckCalls,proto3" json:"disable_check_calls,omitempty"`
	// If set to true, disables Mixer check calls.
	DisableReportCalls bool `protobuf:"varint,4,opt,name=disable_report_calls,json=disableReportCalls,proto3" json:"disable_report_calls,omitempty"`
	// Quota specifications to generate quota requirements.
	// It applies on the new TCP connections.
	ConnectionQuotaSpec *QuotaSpec `protobuf:"bytes,5,opt,name=connection_quota_spec,json=connectionQuotaSpec,proto3" json:"connection_quota_spec,omitempty"`
	// Specify report interval to send periodical reports for long TCP
	// connections. If not specified, the interval is 10 seconds. This interval
	// should not be less than 1 second, otherwise it will be reset to 1 second.
	ReportInterval *types.Duration `protobuf:"bytes,6,opt,name=report_interval,json=reportInterval,proto3" json:"report_interval,omitempty"`
}

func (m *TcpClientConfig) Reset()      { *m = TcpClientConfig{} }
func (*TcpClientConfig) ProtoMessage() {}
func (*TcpClientConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_27bf0dec365e2f6f, []int{4}
}
func (m *TcpClientConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpClientConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *TcpClientConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpClientConfig.Merge(m, src)
}
func (m *TcpClientConfig) XXX_Size() int {
	return m.Size()
}
func (m *TcpClientConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpClientConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TcpClientConfig proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("istio.mixer.v1.config.client.NetworkFailPolicy_FailPolicy", NetworkFailPolicy_FailPolicy_name, NetworkFailPolicy_FailPolicy_value)
	proto.RegisterType((*NetworkFailPolicy)(nil), "istio.mixer.v1.config.client.NetworkFailPolicy")
	proto.RegisterType((*ServiceConfig)(nil), "istio.mixer.v1.config.client.ServiceConfig")
	proto.RegisterType((*TransportConfig)(nil), "istio.mixer.v1.config.client.TransportConfig")
	proto.RegisterType((*HttpClientConfig)(nil), "istio.mixer.v1.config.client.HttpClientConfig")
	proto.RegisterMapType((map[string]*ServiceConfig)(nil), "istio.mixer.v1.config.client.HttpClientConfig.ServiceConfigsEntry")
	proto.RegisterType((*TcpClientConfig)(nil), "istio.mixer.v1.config.client.TcpClientConfig")
}

func init() {
	proto.RegisterFile("mixer/v1/config/client/client_config.proto", fileDescriptor_27bf0dec365e2f6f)
}

var fileDescriptor_27bf0dec365e2f6f = []byte{
	// 1000 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4d, 0x6f, 0x1a, 0x47,
	0x18, 0xde, 0x05, 0xec, 0x84, 0x71, 0xf8, 0xf0, 0x10, 0xab, 0x98, 0x54, 0x2b, 0x44, 0x14, 0x95,
	0x36, 0xea, 0xd2, 0xd0, 0x43, 0xab, 0x1c, 0x5a, 0x61, 0x62, 0x2b, 0x56, 0xed, 0x84, 0xae, 0xa9,
	0x22, 0xb5, 0x87, 0xd5, 0xb0, 0x0c, 0x30, 0xf2, 0xb2, 0xb3, 0x99, 0x1d, 0x30, 0xbe, 0xf5, 0x17,
	0x54, 0xfd, 0x19, 0xf9, 0x03, 0xfd, 0x0f, 0x39, 0xfa, 0xe8, 0x63, 0x8d, 0x2f, 0x3d, 0xe6, 0xde,
	0x43, 0xab, 0x9d, 0x19, 0x58, 0x63, 0xf3, 0x51, 0xaa, 0xf6, 0xc4, 0xec, 0xfb, 0x3e, 0xcf, 0xcb,
	0xec, 0xf3, 0x3e, 0xf3, 0xce, 0x82, 0xcf, 0xfa, 0x64, 0x84, 0x59, 0x65, 0xf8, 0xac, 0xe2, 0x50,
	0xaf, 0x43, 0xba, 0x15, 0xc7, 0x25, 0xd8, 0xe3, 0xea, 0xc7, 0x96, 0x41, 0xd3, 0x67, 0x94, 0x53,
	0xf8, 0x31, 0x09, 0x38, 0xa1, 0xa6, 0x60, 0x98, 0xc3, 0x67, 0xa6, 0x4a, 0x4a, 0x68, 0xe1, 0x61,
	0x97, 0x76, 0xa9, 0x00, 0x56, 0xc2, 0x95, 0xe4, 0x14, 0x8c, 0x2e, 0xa5, 0x5d, 0x17, 0x57, 0xc4,
	0x53, 0x6b, 0xd0, 0xa9, 0xb4, 0x07, 0x0c, 0x71, 0x42, 0x3d, 0x95, 0xdf, 0x9d, 0xfe, 0x3f, 0xe2,
	0x9c, 0x91, 0xd6, 0x80, 0xe3, 0x40, 0xa5, 0x9e, 0x2c, 0xd8, 0x1a, 0xf2, 0x89, 0x1d, 0xf8, 0xd8,
	0x51, 0xb0, 0xd2, 0x02, 0xd8, 0xdb, 0x01, 0xe5, 0x48, 0x62, 0x4a, 0xbf, 0xc5, 0xc0, 0xf6, 0x2b,
	0xcc, 0xcf, 0x28, 0x3b, 0x3d, 0x40, 0xc4, 0x6d, 0x50, 0x97, 0x38, 0xe7, 0xd0, 0x02, 0x9b, 0xbe,
	0x58, 0xe5, 0xf5, 0xa2, 0x5e, 0x4e, 0x57, 0x9f, 0x9b, 0xcb, 0x5e, 0xd0, 0xbc, 0x53, 0xc0, 0x8c,
	0x96, 0x96, 0xaa, 0x04, 0x1f, 0x81, 0x64, 0x1f, 0x8d, 0x6c, 0x86, 0x39, 0x3b, 0xcf, 0xc7, 0x8a,
	0x7a, 0x39, 0x65, 0xdd, 0xef, 0xa3, 0x91, 0x15, 0x3e, 0xc3, 0x1a, 0xc8, 0xb4, 0x50, 0x80, 0x65,
	0xd6, 0x3e, 0x43, 0x84, 0xe7, 0xe3, 0x45, 0xbd, 0xbc, 0x55, 0xdd, 0x35, 0xa5, 0x4c, 0xe6, 0x44,
	0x26, 0xf3, 0x85, 0x92, 0xc9, 0x4a, 0x85, 0x0c, 0x41, 0x7f, 0x83, 0x08, 0x87, 0xdf, 0x82, 0xf4,
	0xb4, 0xbe, 0xac, 0x90, 0x58, 0x55, 0xe1, 0xc1, 0xe4, 0xff, 0xc3, 0x02, 0xa5, 0xa7, 0x00, 0xdc,
	0x90, 0x20, 0x05, 0x92, 0x07, 0xb5, 0xc3, 0x23, 0xfb, 0x75, 0x63, 0xff, 0x55, 0x56, 0x83, 0x69,
	0x00, 0xc4, 0x63, 0xfd, 0xe8, 0xf5, 0xc9, 0x7e, 0x56, 0x2f, 0xfd, 0x19, 0x07, 0xa9, 0x13, 0xcc,
	0x86, 0xc4, 0xc1, 0x75, 0xa1, 0x05, 0x34, 0x41, 0xae, 0x4d, 0x02, 0xd4, 0x72, 0xb1, 0xed, 0xf4,
	0xb0, 0x73, 0x6a, 0x3b, 0xc8, 0x75, 0x03, 0x21, 0xe0, 0x7d, 0x6b, 0x5b, 0xa5, 0xea, 0x61, 0xa6,
	0x1e, 0x26, 0xe0, 0x17, 0xe0, 0xe1, 0x04, 0xcf, 0xb0, 0x4f, 0x19, 0x57, 0x84, 0x98, 0x20, 0x40,
	0x95, 0xb3, 0x44, 0x4a, 0x32, 0xf6, 0x41, 0x56, 0x34, 0xc0, 0x8e, 0x0c, 0xa1, 0x54, 0x2a, 0xdc,
	0xee, 0x4f, 0x6d, 0x8a, 0xb0, 0x32, 0x22, 0x18, 0x05, 0xe0, 0x31, 0x48, 0xf5, 0x38, 0xf7, 0xed,
	0x89, 0x5b, 0xf2, 0x89, 0x62, 0xbc, 0xbc, 0x55, 0xfd, 0x74, 0x79, 0x8f, 0x5f, 0x36, 0x9b, 0x8d,
	0x5a, 0xe3, 0xf0, 0xc4, 0xc7, 0x8e, 0xb5, 0x15, 0xf2, 0x6b, 0x3e, 0x09, 0x1f, 0xe0, 0x01, 0x00,
	0xc2, 0x50, 0xb2, 0xd6, 0x86, 0xa8, 0xf5, 0xc9, 0xf2, 0x5a, 0xdf, 0x87, 0x78, 0x51, 0x29, 0xf9,
	0x76, 0xb2, 0x84, 0x36, 0xc8, 0x79, 0xd2, 0x47, 0x76, 0x07, 0x11, 0xd7, 0x56, 0x06, 0xbc, 0x27,
	0x5e, 0xb0, 0xb2, 0xa6, 0x01, 0xad, 0x6d, 0xef, 0x8e, 0xa9, 0x0f, 0x01, 0xec, 0x50, 0x76, 0x86,
	0x58, 0xfb, 0xa6, 0x80, 0xf7, 0x57, 0x0a, 0xb8, 0xad, 0x58, 0x51, 0xa8, 0xf4, 0x57, 0x02, 0x64,
	0x9a, 0x0c, 0x79, 0x81, 0x68, 0xce, 0xc2, 0xfe, 0x3b, 0x3d, 0x3c, 0xbf, 0xff, 0x4e, 0x0f, 0xdf,
	0xc4, 0x4b, 0xfd, 0x24, 0x3e, 0x36, 0x83, 0x17, 0x4a, 0x49, 0xfc, 0x5d, 0xbf, 0xb4, 0x10, 0x77,
	0x7a, 0xc2, 0x01, 0xb7, 0xfd, 0xb2, 0x17, 0x66, 0x16, 0x29, 0x9a, 0xf8, 0xcf, 0x14, 0x3d, 0x06,
	0x3b, 0x01, 0x47, 0x3c, 0xb0, 0x07, 0x7e, 0x1b, 0x71, 0x6c, 0x13, 0x8f, 0x63, 0x36, 0x44, 0x6e,
	0x7e, 0x63, 0xd5, 0xc9, 0xcb, 0x09, 0xde, 0x0f, 0x82, 0x76, 0xa8, 0x58, 0xf0, 0x31, 0x48, 0x29,
	0xe5, 0xdc, 0x41, 0xc0, 0x31, 0xcb, 0x6f, 0x16, 0xf5, 0x72, 0xd2, 0x7a, 0x20, 0x82, 0x75, 0x19,
	0x83, 0x4f, 0x40, 0x7a, 0x72, 0x5c, 0x14, 0xea, 0x9e, 0x40, 0xa5, 0x64, 0x74, 0x02, 0x7b, 0x03,
	0x0a, 0x51, 0x93, 0xed, 0x0e, 0x65, 0xb6, 0x3c, 0x3a, 0x3e, 0xa3, 0xa3, 0xf3, 0x7f, 0xd0, 0xf4,
	0x8f, 0x22, 0xf6, 0x01, 0x65, 0xc7, 0x21, 0xa2, 0x11, 0x52, 0xe1, 0x57, 0x20, 0x7f, 0x53, 0x7e,
	0x3b, 0x9c, 0x39, 0xd8, 0xe3, 0x8c, 0xe0, 0x20, 0x9f, 0x14, 0x53, 0x6d, 0x87, 0x45, 0x3d, 0x38,
	0x46, 0xa3, 0x7d, 0x99, 0x84, 0x47, 0x60, 0xe7, 0x0e, 0x91, 0x93, 0x3e, 0xce, 0x83, 0x55, 0x62,
	0xc1, 0xd9, 0x82, 0x4d, 0xd2, 0xc7, 0xa5, 0x5f, 0x12, 0x20, 0xfb, 0x92, 0x73, 0xbf, 0x2e, 0xda,
	0xa5, 0x2c, 0xf8, 0x1d, 0x48, 0xf2, 0x89, 0x2b, 0x85, 0xf1, 0xb6, 0xaa, 0x9f, 0x2f, 0x6f, 0xf3,
	0x2d, 0x13, 0x5b, 0x11, 0x1f, 0x9e, 0x82, 0x4c, 0x20, 0x07, 0x9c, 0xba, 0xeb, 0xc2, 0xd1, 0x14,
	0x1e, 0xee, 0xbd, 0x15, 0x83, 0xe2, 0xd6, 0xae, 0xcc, 0x99, 0x31, 0x19, 0x84, 0x72, 0x9c, 0x5b,
	0xe9, 0x60, 0x26, 0x08, 0xbf, 0x01, 0x8f, 0xda, 0xb8, 0x83, 0x06, 0x2e, 0xb7, 0xdb, 0x38, 0xe0,
	0xc4, 0x13, 0x6f, 0x6e, 0x2b, 0x94, 0xf0, 0x78, 0xd2, 0xda, 0x55, 0x90, 0x17, 0x11, 0x42, 0xd5,
	0x9e, 0x3b, 0x1a, 0x13, 0xeb, 0x8f, 0xc6, 0xf9, 0x23, 0x62, 0xe3, 0x5f, 0x8c, 0x88, 0x82, 0x07,
	0x72, 0x73, 0x5e, 0x1c, 0x66, 0x41, 0xfc, 0x14, 0xcb, 0x6b, 0x35, 0x69, 0x85, 0x4b, 0x58, 0x03,
	0x1b, 0x43, 0xe4, 0x0e, 0xe4, 0xc9, 0xdf, 0xaa, 0x3e, 0x5d, 0xae, 0xee, 0x4c, 0x4d, 0x4b, 0x32,
	0x9f, 0xc7, 0xbe, 0xd6, 0x4b, 0xef, 0xe2, 0x20, 0xd3, 0x74, 0xfe, 0x47, 0x3f, 0xcc, 0x93, 0x38,
	0xb6, 0xbe, 0xc4, 0x0b, 0xae, 0xc9, 0xf8, 0xba, 0xd7, 0x64, 0x62, 0xe1, 0x35, 0xf9, 0x13, 0xd8,
	0x71, 0xa8, 0xe7, 0x61, 0x47, 0x58, 0x68, 0xe6, 0x6e, 0xd2, 0xd7, 0xb9, 0x9b, 0x72, 0x51, 0x95,
	0x69, 0x10, 0xee, 0x81, 0x8c, 0xda, 0xc6, 0x74, 0xd8, 0x6d, 0xae, 0x3a, 0xbf, 0x6a, 0x60, 0x4d,
	0xe6, 0xdc, 0x1e, 0x7a, 0x7f, 0x65, 0x68, 0x17, 0x57, 0x86, 0x76, 0x79, 0x65, 0x68, 0x1f, 0xae,
	0x0c, 0xed, 0xe7, 0xb1, 0xa1, 0xbf, 0x1b, 0x1b, 0xda, 0xfb, 0xb1, 0xa1, 0x5f, 0x8c, 0x0d, 0xfd,
	0x72, 0x6c, 0xe8, 0xbf, 0x8f, 0x0d, 0xfd, 0x8f, 0xb1, 0xa1, 0x7d, 0x18, 0x1b, 0xfa, 0xaf, 0xd7,
	0x86, 0x76, 0x71, 0x6d, 0x68, 0x97, 0xd7, 0x86, 0xf6, 0xe3, 0x63, 0xb9, 0x7d, 0x42, 0xc3, 0xcf,
	0xbd, 0xca, 0xfc, 0x4f, 0xbc, 0xd6, 0xa6, 0xd8, 0xc5, 0x97, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff,
	0x1b, 0xa2, 0x66, 0x11, 0xc5, 0x0a, 0x00, 0x00,
}

func (x NetworkFailPolicy_FailPolicy) String() string {
	s, ok := NetworkFailPolicy_FailPolicy_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (m *NetworkFailPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkFailPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkFailPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxRetryWait != nil {
		{
			size, err := m.MaxRetryWait.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.BaseRetryWait != nil {
		{
			size, err := m.BaseRetryWait.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxRetry != 0 {
		i = encodeVarintClientConfig(dAtA, i, uint64(m.MaxRetry))
		i--
		dAtA[i] = 0x10
	}
	if m.Policy != 0 {
		i = encodeVarintClientConfig(dAtA, i, uint64(m.Policy))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ServiceConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ForwardAttributes != nil {
		{
			size, err := m.ForwardAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.NetworkFailPolicy != nil {
		{
			size, err := m.NetworkFailPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.QuotaSpec) > 0 {
		for iNdEx := len(m.QuotaSpec) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QuotaSpec[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintClientConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.HttpApiSpec) > 0 {
		for iNdEx := len(m.HttpApiSpec) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HttpApiSpec[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintClientConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.MixerAttributes != nil {
		{
			size, err := m.MixerAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.DisableReportCalls {
		i--
		if m.DisableReportCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.DisableCheckCalls {
		i--
		if m.DisableCheckCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TransportConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransportConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TransportConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReportBatchMaxTime != nil {
		{
			size, err := m.ReportBatchMaxTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ReportBatchMaxEntries != 0 {
		i = encodeVarintClientConfig(dAtA, i, uint64(m.ReportBatchMaxEntries))
		i--
		dAtA[i] = 0x48
	}
	if m.AttributesForMixerProxy != nil {
		{
			size, err := m.AttributesForMixerProxy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.ReportCluster) > 0 {
		i -= len(m.ReportCluster)
		copy(dAtA[i:], m.ReportCluster)
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.ReportCluster)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CheckCluster) > 0 {
		i -= len(m.CheckCluster)
		copy(dAtA[i:], m.CheckCluster)
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.CheckCluster)))
		i--
		dAtA[i] = 0x32
	}
	if m.StatsUpdateInterval != nil {
		{
			size, err := m.StatsUpdateInterval.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.NetworkFailPolicy != nil {
		{
			size, err := m.NetworkFailPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.DisableReportBatch {
		i--
		if m.DisableReportBatch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.DisableQuotaCache {
		i--
		if m.DisableQuotaCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.DisableCheckCache {
		i--
		if m.DisableCheckCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HttpClientConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpClientConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpClientConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ForwardAttributes != nil {
		{
			size, err := m.ForwardAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.MixerAttributes != nil {
		{
			size, err := m.MixerAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.DefaultDestinationService) > 0 {
		i -= len(m.DefaultDestinationService)
		copy(dAtA[i:], m.DefaultDestinationService)
		i = encodeVarintClientConfig(dAtA, i, uint64(len(m.DefaultDestinationService)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServiceConfigs) > 0 {
		keysForServiceConfigs := make([]string, 0, len(m.ServiceConfigs))
		for k := range m.ServiceConfigs {
			keysForServiceConfigs = append(keysForServiceConfigs, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForServiceConfigs)
		for iNdEx := len(keysForServiceConfigs) - 1; iNdEx >= 0; iNdEx-- {
			v := m.ServiceConfigs[string(keysForServiceConfigs[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintClientConfig(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForServiceConfigs[iNdEx])
			copy(dAtA[i:], keysForServiceConfigs[iNdEx])
			i = encodeVarintClientConfig(dAtA, i, uint64(len(keysForServiceConfigs[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintClientConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Transport != nil {
		{
			size, err := m.Transport.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TcpClientConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpClientConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TcpClientConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReportInterval != nil {
		{
			size, err := m.ReportInterval.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.ConnectionQuotaSpec != nil {
		{
			size, err := m.ConnectionQuotaSpec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.DisableReportCalls {
		i--
		if m.DisableReportCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.DisableCheckCalls {
		i--
		if m.DisableCheckCalls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.MixerAttributes != nil {
		{
			size, err := m.MixerAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Transport != nil {
		{
			size, err := m.Transport.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClientConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintClientConfig(dAtA []byte, offset int, v uint64) int {
	offset -= sovClientConfig(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkFailPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Policy != 0 {
		n += 1 + sovClientConfig(uint64(m.Policy))
	}
	if m.MaxRetry != 0 {
		n += 1 + sovClientConfig(uint64(m.MaxRetry))
	}
	if m.BaseRetryWait != nil {
		l = m.BaseRetryWait.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.MaxRetryWait != nil {
		l = m.MaxRetryWait.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *ServiceConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DisableCheckCalls {
		n += 2
	}
	if m.DisableReportCalls {
		n += 2
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if len(m.HttpApiSpec) > 0 {
		for _, e := range m.HttpApiSpec {
			l = e.Size()
			n += 1 + l + sovClientConfig(uint64(l))
		}
	}
	if len(m.QuotaSpec) > 0 {
		for _, e := range m.QuotaSpec {
			l = e.Size()
			n += 1 + l + sovClientConfig(uint64(l))
		}
	}
	if m.NetworkFailPolicy != nil {
		l = m.NetworkFailPolicy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ForwardAttributes != nil {
		l = m.ForwardAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *TransportConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DisableCheckCache {
		n += 2
	}
	if m.DisableQuotaCache {
		n += 2
	}
	if m.DisableReportBatch {
		n += 2
	}
	if m.NetworkFailPolicy != nil {
		l = m.NetworkFailPolicy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.StatsUpdateInterval != nil {
		l = m.StatsUpdateInterval.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	l = len(m.CheckCluster)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	l = len(m.ReportCluster)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.AttributesForMixerProxy != nil {
		l = m.AttributesForMixerProxy.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ReportBatchMaxEntries != 0 {
		n += 1 + sovClientConfig(uint64(m.ReportBatchMaxEntries))
	}
	if m.ReportBatchMaxTime != nil {
		l = m.ReportBatchMaxTime.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *HttpClientConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Transport != nil {
		l = m.Transport.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if len(m.ServiceConfigs) > 0 {
		for k, v := range m.ServiceConfigs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClientConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClientConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClientConfig(uint64(mapEntrySize))
		}
	}
	l = len(m.DefaultDestinationService)
	if l > 0 {
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ForwardAttributes != nil {
		l = m.ForwardAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func (m *TcpClientConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Transport != nil {
		l = m.Transport.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.MixerAttributes != nil {
		l = m.MixerAttributes.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.DisableCheckCalls {
		n += 2
	}
	if m.DisableReportCalls {
		n += 2
	}
	if m.ConnectionQuotaSpec != nil {
		l = m.ConnectionQuotaSpec.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	if m.ReportInterval != nil {
		l = m.ReportInterval.Size()
		n += 1 + l + sovClientConfig(uint64(l))
	}
	return n
}

func sovClientConfig(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozClientConfig(x uint64) (n int) {
	return sovClientConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NetworkFailPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkFailPolicy{`,
		`Policy:` + fmt.Sprintf("%v", this.Policy) + `,`,
		`MaxRetry:` + fmt.Sprintf("%v", this.MaxRetry) + `,`,
		`BaseRetryWait:` + strings.Replace(fmt.Sprintf("%v", this.BaseRetryWait), "Duration", "types.Duration", 1) + `,`,
		`MaxRetryWait:` + strings.Replace(fmt.Sprintf("%v", this.MaxRetryWait), "Duration", "types.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceConfig) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHttpApiSpec := "[]*HTTPAPISpec{"
	for _, f := range this.HttpApiSpec {
		repeatedStringForHttpApiSpec += strings.Replace(fmt.Sprintf("%v", f), "HTTPAPISpec", "HTTPAPISpec", 1) + ","
	}
	repeatedStringForHttpApiSpec += "}"
	repeatedStringForQuotaSpec := "[]*QuotaSpec{"
	for _, f := range this.QuotaSpec {
		repeatedStringForQuotaSpec += strings.Replace(fmt.Sprintf("%v", f), "QuotaSpec", "QuotaSpec", 1) + ","
	}
	repeatedStringForQuotaSpec += "}"
	s := strings.Join([]string{`&ServiceConfig{`,
		`DisableCheckCalls:` + fmt.Sprintf("%v", this.DisableCheckCalls) + `,`,
		`DisableReportCalls:` + fmt.Sprintf("%v", this.DisableReportCalls) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "v1.Attributes", 1) + `,`,
		`HttpApiSpec:` + repeatedStringForHttpApiSpec + `,`,
		`QuotaSpec:` + repeatedStringForQuotaSpec + `,`,
		`NetworkFailPolicy:` + strings.Replace(this.NetworkFailPolicy.String(), "NetworkFailPolicy", "NetworkFailPolicy", 1) + `,`,
		`ForwardAttributes:` + strings.Replace(fmt.Sprintf("%v", this.ForwardAttributes), "Attributes", "v1.Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TransportConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TransportConfig{`,
		`DisableCheckCache:` + fmt.Sprintf("%v", this.DisableCheckCache) + `,`,
		`DisableQuotaCache:` + fmt.Sprintf("%v", this.DisableQuotaCache) + `,`,
		`DisableReportBatch:` + fmt.Sprintf("%v", this.DisableReportBatch) + `,`,
		`NetworkFailPolicy:` + strings.Replace(this.NetworkFailPolicy.String(), "NetworkFailPolicy", "NetworkFailPolicy", 1) + `,`,
		`StatsUpdateInterval:` + strings.Replace(fmt.Sprintf("%v", this.StatsUpdateInterval), "Duration", "types.Duration", 1) + `,`,
		`CheckCluster:` + fmt.Sprintf("%v", this.CheckCluster) + `,`,
		`ReportCluster:` + fmt.Sprintf("%v", this.ReportCluster) + `,`,
		`AttributesForMixerProxy:` + strings.Replace(fmt.Sprintf("%v", this.AttributesForMixerProxy), "Attributes", "v1.Attributes", 1) + `,`,
		`ReportBatchMaxEntries:` + fmt.Sprintf("%v", this.ReportBatchMaxEntries) + `,`,
		`ReportBatchMaxTime:` + strings.Replace(fmt.Sprintf("%v", this.ReportBatchMaxTime), "Duration", "types.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HttpClientConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForServiceConfigs := make([]string, 0, len(this.ServiceConfigs))
	for k, _ := range this.ServiceConfigs {
		keysForServiceConfigs = append(keysForServiceConfigs, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForServiceConfigs)
	mapStringForServiceConfigs := "map[string]*ServiceConfig{"
	for _, k := range keysForServiceConfigs {
		mapStringForServiceConfigs += fmt.Sprintf("%v: %v,", k, this.ServiceConfigs[k])
	}
	mapStringForServiceConfigs += "}"
	s := strings.Join([]string{`&HttpClientConfig{`,
		`Transport:` + strings.Replace(this.Transport.String(), "TransportConfig", "TransportConfig", 1) + `,`,
		`ServiceConfigs:` + mapStringForServiceConfigs + `,`,
		`DefaultDestinationService:` + fmt.Sprintf("%v", this.DefaultDestinationService) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "v1.Attributes", 1) + `,`,
		`ForwardAttributes:` + strings.Replace(fmt.Sprintf("%v", this.ForwardAttributes), "Attributes", "v1.Attributes", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TcpClientConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TcpClientConfig{`,
		`Transport:` + strings.Replace(this.Transport.String(), "TransportConfig", "TransportConfig", 1) + `,`,
		`MixerAttributes:` + strings.Replace(fmt.Sprintf("%v", this.MixerAttributes), "Attributes", "v1.Attributes", 1) + `,`,
		`DisableCheckCalls:` + fmt.Sprintf("%v", this.DisableCheckCalls) + `,`,
		`DisableReportCalls:` + fmt.Sprintf("%v", this.DisableReportCalls) + `,`,
		`ConnectionQuotaSpec:` + strings.Replace(fmt.Sprintf("%v", this.ConnectionQuotaSpec), "QuotaSpec", "QuotaSpec", 1) + `,`,
		`ReportInterval:` + strings.Replace(fmt.Sprintf("%v", this.ReportInterval), "Duration", "types.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringClientConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NetworkFailPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFailPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFailPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			m.Policy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Policy |= NetworkFailPolicy_FailPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetry", wireType)
			}
			m.MaxRetry = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetry |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseRetryWait", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseRetryWait == nil {
				m.BaseRetryWait = &types.Duration{}
			}
			if err := m.BaseRetryWait.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetryWait", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxRetryWait == nil {
				m.MaxRetryWait = &types.Duration{}
			}
			if err := m.MaxRetryWait.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCalls = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportCalls = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpApiSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpApiSpec = append(m.HttpApiSpec, &HTTPAPISpec{})
			if err := m.HttpApiSpec[len(m.HttpApiSpec)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuotaSpec = append(m.QuotaSpec, &QuotaSpec{})
			if err := m.QuotaSpec[len(m.QuotaSpec)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFailPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkFailPolicy == nil {
				m.NetworkFailPolicy = &NetworkFailPolicy{}
			}
			if err := m.NetworkFailPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForwardAttributes == nil {
				m.ForwardAttributes = &v1.Attributes{}
			}
			if err := m.ForwardAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransportConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransportConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransportConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCache = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableQuotaCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableQuotaCache = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportBatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportBatch = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFailPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkFailPolicy == nil {
				m.NetworkFailPolicy = &NetworkFailPolicy{}
			}
			if err := m.NetworkFailPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsUpdateInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsUpdateInterval == nil {
				m.StatsUpdateInterval = &types.Duration{}
			}
			if err := m.StatsUpdateInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReportCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributesForMixerProxy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttributesForMixerProxy == nil {
				m.AttributesForMixerProxy = &v1.Attributes{}
			}
			if err := m.AttributesForMixerProxy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportBatchMaxEntries", wireType)
			}
			m.ReportBatchMaxEntries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReportBatchMaxEntries |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportBatchMaxTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportBatchMaxTime == nil {
				m.ReportBatchMaxTime = &types.Duration{}
			}
			if err := m.ReportBatchMaxTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpClientConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpClientConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpClientConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transport", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transport == nil {
				m.Transport = &TransportConfig{}
			}
			if err := m.Transport.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServiceConfigs == nil {
				m.ServiceConfigs = make(map[string]*ServiceConfig)
			}
			var mapkey string
			var mapvalue *ServiceConfig
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClientConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClientConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClientConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthClientConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClientConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClientConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthClientConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ServiceConfig{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClientConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClientConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ServiceConfigs[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultDestinationService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultDestinationService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForwardAttributes == nil {
				m.ForwardAttributes = &v1.Attributes{}
			}
			if err := m.ForwardAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpClientConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpClientConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpClientConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transport", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transport == nil {
				m.Transport = &TransportConfig{}
			}
			if err := m.Transport.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MixerAttributes == nil {
				m.MixerAttributes = &v1.Attributes{}
			}
			if err := m.MixerAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableCheckCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableCheckCalls = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableReportCalls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableReportCalls = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionQuotaSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionQuotaSpec == nil {
				m.ConnectionQuotaSpec = &QuotaSpec{}
			}
			if err := m.ConnectionQuotaSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClientConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClientConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportInterval == nil {
				m.ReportInterval = &types.Duration{}
			}
			if err := m.ReportInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClientConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClientConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClientConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClientConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClientConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthClientConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthClientConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowClientConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipClientConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthClientConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthClientConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClientConfig   = fmt.Errorf("proto: integer overflow")
)
