// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/bootstrap/v2/bootstrap.proto

package v2

import (
	fmt "fmt"
	v22 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
	auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	v2 "github.com/envoyproxy/go-control-plane/envoy/config/metrics/v2"
	v2alpha "github.com/envoyproxy/go-control-plane/envoy/config/overload/v2alpha"
	v21 "github.com/envoyproxy/go-control-plane/envoy/config/trace/v2"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Bootstrap :ref:`configuration overview <config_overview_v2_bootstrap>`.
type Bootstrap struct {
	// Node identity to present to the management server and for instance
	// identification purposes (e.g. in generated headers).
	Node *core.Node `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// Statically specified resources.
	StaticResources *Bootstrap_StaticResources `protobuf:"bytes,2,opt,name=static_resources,json=staticResources,proto3" json:"static_resources,omitempty"`
	// xDS configuration sources.
	DynamicResources *Bootstrap_DynamicResources `protobuf:"bytes,3,opt,name=dynamic_resources,json=dynamicResources,proto3" json:"dynamic_resources,omitempty"`
	// Configuration for the cluster manager which owns all upstream clusters
	// within the server.
	ClusterManager *ClusterManager `protobuf:"bytes,4,opt,name=cluster_manager,json=clusterManager,proto3" json:"cluster_manager,omitempty"`
	// Health discovery service config option.
	// (:ref:`core.ApiConfigSource <envoy_api_msg_core.ApiConfigSource>`)
	HdsConfig *core.ApiConfigSource `protobuf:"bytes,14,opt,name=hds_config,json=hdsConfig,proto3" json:"hds_config,omitempty"`
	// Optional file system path to search for startup flag files.
	FlagsPath string `protobuf:"bytes,5,opt,name=flags_path,json=flagsPath,proto3" json:"flags_path,omitempty"`
	// Optional set of stats sinks.
	StatsSinks []*v2.StatsSink `protobuf:"bytes,6,rep,name=stats_sinks,json=statsSinks,proto3" json:"stats_sinks,omitempty"`
	// Configuration for internal processing of stats.
	StatsConfig *v2.StatsConfig `protobuf:"bytes,13,opt,name=stats_config,json=statsConfig,proto3" json:"stats_config,omitempty"`
	// Optional duration between flushes to configured stats sinks. For
	// performance reasons Envoy latches counters and only flushes counters and
	// gauges at a periodic interval. If not specified the default is 5000ms (5
	// seconds).
	StatsFlushInterval *time.Duration `protobuf:"bytes,7,opt,name=stats_flush_interval,json=statsFlushInterval,proto3,stdduration" json:"stats_flush_interval,omitempty"`
	// Optional watchdog configuration.
	Watchdog *Watchdog `protobuf:"bytes,8,opt,name=watchdog,proto3" json:"watchdog,omitempty"`
	// Configuration for an external tracing provider. If not specified, no
	// tracing will be performed.
	Tracing *v21.Tracing `protobuf:"bytes,9,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// Configuration for the runtime configuration provider (deprecated). If not
	// specified, a “null” provider will be used which will result in all defaults
	// being used.
	Runtime *Runtime `protobuf:"bytes,11,opt,name=runtime,proto3" json:"runtime,omitempty"` // Deprecated: Do not use.
	// Configuration for the runtime configuration provider. If not
	// specified, a “null” provider will be used which will result in all defaults
	// being used.
	LayeredRuntime *LayeredRuntime `protobuf:"bytes,17,opt,name=layered_runtime,json=layeredRuntime,proto3" json:"layered_runtime,omitempty"`
	// Configuration for the local administration HTTP server.
	Admin *Admin `protobuf:"bytes,12,opt,name=admin,proto3" json:"admin,omitempty"`
	// Optional overload manager configuration.
	OverloadManager *v2alpha.OverloadManager `protobuf:"bytes,15,opt,name=overload_manager,json=overloadManager,proto3" json:"overload_manager,omitempty"`
	// Enable :ref:`stats for event dispatcher <operations_performance>`, defaults to false.
	// Note that this records a value for each iteration of the event loop on every thread. This
	// should normally be minimal overhead, but when using
	// :ref:`statsd <envoy_api_msg_config.metrics.v2.StatsdSink>`, it will send each observed value
	// over the wire individually because the statsd protocol doesn't have any way to represent a
	// histogram summary. Be aware that this can be a very large volume of data.
	EnableDispatcherStats bool `protobuf:"varint,16,opt,name=enable_dispatcher_stats,json=enableDispatcherStats,proto3" json:"enable_dispatcher_stats,omitempty"`
	// Optional string which will be used in lieu of x-envoy in prefixing headers.
	//
	// For example, if this string is present and set to X-Foo, then x-envoy-retry-on will be
	// transformed into x-foo-retry-on etc.
	//
	// Note this applies to the headers Envoy will generate, the headers Envoy will sanitize, and the
	// headers Envoy will trust for core code and core extensions only. Be VERY careful making
	// changes to this string, especially in multi-layer Envoy deployments or deployments using
	// extensions which are not upstream.
	HeaderPrefix         string   `protobuf:"bytes,18,opt,name=header_prefix,json=headerPrefix,proto3" json:"header_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bootstrap) Reset()         { *m = Bootstrap{} }
func (m *Bootstrap) String() string { return proto.CompactTextString(m) }
func (*Bootstrap) ProtoMessage()    {}
func (*Bootstrap) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{0}
}
func (m *Bootstrap) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Bootstrap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap.Merge(m, src)
}
func (m *Bootstrap) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap proto.InternalMessageInfo

func (m *Bootstrap) GetNode() *core.Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *Bootstrap) GetStaticResources() *Bootstrap_StaticResources {
	if m != nil {
		return m.StaticResources
	}
	return nil
}

func (m *Bootstrap) GetDynamicResources() *Bootstrap_DynamicResources {
	if m != nil {
		return m.DynamicResources
	}
	return nil
}

func (m *Bootstrap) GetClusterManager() *ClusterManager {
	if m != nil {
		return m.ClusterManager
	}
	return nil
}

func (m *Bootstrap) GetHdsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.HdsConfig
	}
	return nil
}

func (m *Bootstrap) GetFlagsPath() string {
	if m != nil {
		return m.FlagsPath
	}
	return ""
}

func (m *Bootstrap) GetStatsSinks() []*v2.StatsSink {
	if m != nil {
		return m.StatsSinks
	}
	return nil
}

func (m *Bootstrap) GetStatsConfig() *v2.StatsConfig {
	if m != nil {
		return m.StatsConfig
	}
	return nil
}

func (m *Bootstrap) GetStatsFlushInterval() *time.Duration {
	if m != nil {
		return m.StatsFlushInterval
	}
	return nil
}

func (m *Bootstrap) GetWatchdog() *Watchdog {
	if m != nil {
		return m.Watchdog
	}
	return nil
}

func (m *Bootstrap) GetTracing() *v21.Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

// Deprecated: Do not use.
func (m *Bootstrap) GetRuntime() *Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *Bootstrap) GetLayeredRuntime() *LayeredRuntime {
	if m != nil {
		return m.LayeredRuntime
	}
	return nil
}

func (m *Bootstrap) GetAdmin() *Admin {
	if m != nil {
		return m.Admin
	}
	return nil
}

func (m *Bootstrap) GetOverloadManager() *v2alpha.OverloadManager {
	if m != nil {
		return m.OverloadManager
	}
	return nil
}

func (m *Bootstrap) GetEnableDispatcherStats() bool {
	if m != nil {
		return m.EnableDispatcherStats
	}
	return false
}

func (m *Bootstrap) GetHeaderPrefix() string {
	if m != nil {
		return m.HeaderPrefix
	}
	return ""
}

type Bootstrap_StaticResources struct {
	// Static :ref:`Listeners <envoy_api_msg_Listener>`. These listeners are
	// available regardless of LDS configuration.
	Listeners []*v22.Listener `protobuf:"bytes,1,rep,name=listeners,proto3" json:"listeners,omitempty"`
	// If a network based configuration source is specified for :ref:`cds_config
	// <envoy_api_field_config.bootstrap.v2.Bootstrap.DynamicResources.cds_config>`, it's necessary
	// to have some initial cluster definitions available to allow Envoy to know
	// how to speak to the management server. These cluster definitions may not
	// use :ref:`EDS <arch_overview_dynamic_config_eds>` (i.e. they should be static
	// IP or DNS-based).
	Clusters []*v22.Cluster `protobuf:"bytes,2,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// These static secrets can be used by :ref:`SdsSecretConfig
	// <envoy_api_msg_auth.SdsSecretConfig>`
	Secrets              []*auth.Secret `protobuf:"bytes,3,rep,name=secrets,proto3" json:"secrets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Bootstrap_StaticResources) Reset()         { *m = Bootstrap_StaticResources{} }
func (m *Bootstrap_StaticResources) String() string { return proto.CompactTextString(m) }
func (*Bootstrap_StaticResources) ProtoMessage()    {}
func (*Bootstrap_StaticResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{0, 0}
}
func (m *Bootstrap_StaticResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap_StaticResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap_StaticResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Bootstrap_StaticResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap_StaticResources.Merge(m, src)
}
func (m *Bootstrap_StaticResources) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap_StaticResources) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap_StaticResources.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap_StaticResources proto.InternalMessageInfo

func (m *Bootstrap_StaticResources) GetListeners() []*v22.Listener {
	if m != nil {
		return m.Listeners
	}
	return nil
}

func (m *Bootstrap_StaticResources) GetClusters() []*v22.Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *Bootstrap_StaticResources) GetSecrets() []*auth.Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type Bootstrap_DynamicResources struct {
	// All :ref:`Listeners <envoy_api_msg_Listener>` are provided by a single
	// :ref:`LDS <arch_overview_dynamic_config_lds>` configuration source.
	LdsConfig *core.ConfigSource `protobuf:"bytes,1,opt,name=lds_config,json=ldsConfig,proto3" json:"lds_config,omitempty"`
	// All post-bootstrap :ref:`Cluster <envoy_api_msg_Cluster>` definitions are
	// provided by a single :ref:`CDS <arch_overview_dynamic_config_cds>`
	// configuration source.
	CdsConfig *core.ConfigSource `protobuf:"bytes,2,opt,name=cds_config,json=cdsConfig,proto3" json:"cds_config,omitempty"`
	// A single :ref:`ADS <config_overview_v2_ads>` source may be optionally
	// specified. This must have :ref:`api_type
	// <envoy_api_field_core.ApiConfigSource.api_type>` :ref:`GRPC
	// <envoy_api_enum_value_core.ApiConfigSource.ApiType.GRPC>`. Only
	// :ref:`ConfigSources <envoy_api_msg_core.ConfigSource>` that have
	// the :ref:`ads <envoy_api_field_core.ConfigSource.ads>` field set will be
	// streamed on the ADS channel.
	AdsConfig            *core.ApiConfigSource `protobuf:"bytes,3,opt,name=ads_config,json=adsConfig,proto3" json:"ads_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Bootstrap_DynamicResources) Reset()         { *m = Bootstrap_DynamicResources{} }
func (m *Bootstrap_DynamicResources) String() string { return proto.CompactTextString(m) }
func (*Bootstrap_DynamicResources) ProtoMessage()    {}
func (*Bootstrap_DynamicResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{0, 1}
}
func (m *Bootstrap_DynamicResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap_DynamicResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap_DynamicResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Bootstrap_DynamicResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap_DynamicResources.Merge(m, src)
}
func (m *Bootstrap_DynamicResources) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap_DynamicResources) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap_DynamicResources.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap_DynamicResources proto.InternalMessageInfo

func (m *Bootstrap_DynamicResources) GetLdsConfig() *core.ConfigSource {
	if m != nil {
		return m.LdsConfig
	}
	return nil
}

func (m *Bootstrap_DynamicResources) GetCdsConfig() *core.ConfigSource {
	if m != nil {
		return m.CdsConfig
	}
	return nil
}

func (m *Bootstrap_DynamicResources) GetAdsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.AdsConfig
	}
	return nil
}

// Administration interface :ref:`operations documentation
// <operations_admin_interface>`.
type Admin struct {
	// The path to write the access log for the administration server. If no
	// access log is desired specify ‘/dev/null’. This is only required if
	// :ref:`address <envoy_api_field_config.bootstrap.v2.Admin.address>` is set.
	AccessLogPath string `protobuf:"bytes,1,opt,name=access_log_path,json=accessLogPath,proto3" json:"access_log_path,omitempty"`
	// The cpu profiler output path for the administration server. If no profile
	// path is specified, the default is ‘/var/log/envoy/envoy.prof’.
	ProfilePath string `protobuf:"bytes,2,opt,name=profile_path,json=profilePath,proto3" json:"profile_path,omitempty"`
	// The TCP address that the administration server will listen on.
	// If not specified, Envoy will not start an administration server.
	Address *core.Address `protobuf:"bytes,3,opt,name=address,proto3" json:"address,omitempty"`
	// Additional socket options that may not be present in Envoy source code or
	// precompiled binaries.
	SocketOptions        []*core.SocketOption `protobuf:"bytes,4,rep,name=socket_options,json=socketOptions,proto3" json:"socket_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Admin) Reset()         { *m = Admin{} }
func (m *Admin) String() string { return proto.CompactTextString(m) }
func (*Admin) ProtoMessage()    {}
func (*Admin) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{1}
}
func (m *Admin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Admin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Admin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Admin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Admin.Merge(m, src)
}
func (m *Admin) XXX_Size() int {
	return m.Size()
}
func (m *Admin) XXX_DiscardUnknown() {
	xxx_messageInfo_Admin.DiscardUnknown(m)
}

var xxx_messageInfo_Admin proto.InternalMessageInfo

func (m *Admin) GetAccessLogPath() string {
	if m != nil {
		return m.AccessLogPath
	}
	return ""
}

func (m *Admin) GetProfilePath() string {
	if m != nil {
		return m.ProfilePath
	}
	return ""
}

func (m *Admin) GetAddress() *core.Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Admin) GetSocketOptions() []*core.SocketOption {
	if m != nil {
		return m.SocketOptions
	}
	return nil
}

// Cluster manager :ref:`architecture overview <arch_overview_cluster_manager>`.
type ClusterManager struct {
	// Name of the local cluster (i.e., the cluster that owns the Envoy running
	// this configuration). In order to enable :ref:`zone aware routing
	// <arch_overview_load_balancing_zone_aware_routing>` this option must be set.
	// If *local_cluster_name* is defined then :ref:`clusters
	// <envoy_api_msg_Cluster>` must be defined in the :ref:`Bootstrap
	// static cluster resources
	// <envoy_api_field_config.bootstrap.v2.Bootstrap.StaticResources.clusters>`. This is unrelated to
	// the :option:`--service-cluster` option which does not `affect zone aware
	// routing <https://github.com/envoyproxy/envoy/issues/774>`_.
	LocalClusterName string `protobuf:"bytes,1,opt,name=local_cluster_name,json=localClusterName,proto3" json:"local_cluster_name,omitempty"`
	// Optional global configuration for outlier detection.
	OutlierDetection *ClusterManager_OutlierDetection `protobuf:"bytes,2,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// Optional configuration used to bind newly established upstream connections.
	// This may be overridden on a per-cluster basis by upstream_bind_config in the cds_config.
	UpstreamBindConfig *core.BindConfig `protobuf:"bytes,3,opt,name=upstream_bind_config,json=upstreamBindConfig,proto3" json:"upstream_bind_config,omitempty"`
	// A management server endpoint to stream load stats to via
	// *StreamLoadStats*. This must have :ref:`api_type
	// <envoy_api_field_core.ApiConfigSource.api_type>` :ref:`GRPC
	// <envoy_api_enum_value_core.ApiConfigSource.ApiType.GRPC>`.
	LoadStatsConfig      *core.ApiConfigSource `protobuf:"bytes,4,opt,name=load_stats_config,json=loadStatsConfig,proto3" json:"load_stats_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ClusterManager) Reset()         { *m = ClusterManager{} }
func (m *ClusterManager) String() string { return proto.CompactTextString(m) }
func (*ClusterManager) ProtoMessage()    {}
func (*ClusterManager) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{2}
}
func (m *ClusterManager) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterManager) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterManager.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterManager) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterManager.Merge(m, src)
}
func (m *ClusterManager) XXX_Size() int {
	return m.Size()
}
func (m *ClusterManager) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterManager.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterManager proto.InternalMessageInfo

func (m *ClusterManager) GetLocalClusterName() string {
	if m != nil {
		return m.LocalClusterName
	}
	return ""
}

func (m *ClusterManager) GetOutlierDetection() *ClusterManager_OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *ClusterManager) GetUpstreamBindConfig() *core.BindConfig {
	if m != nil {
		return m.UpstreamBindConfig
	}
	return nil
}

func (m *ClusterManager) GetLoadStatsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.LoadStatsConfig
	}
	return nil
}

type ClusterManager_OutlierDetection struct {
	// Specifies the path to the outlier event log.
	EventLogPath         string   `protobuf:"bytes,1,opt,name=event_log_path,json=eventLogPath,proto3" json:"event_log_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterManager_OutlierDetection) Reset()         { *m = ClusterManager_OutlierDetection{} }
func (m *ClusterManager_OutlierDetection) String() string { return proto.CompactTextString(m) }
func (*ClusterManager_OutlierDetection) ProtoMessage()    {}
func (*ClusterManager_OutlierDetection) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{2, 0}
}
func (m *ClusterManager_OutlierDetection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterManager_OutlierDetection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterManager_OutlierDetection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterManager_OutlierDetection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterManager_OutlierDetection.Merge(m, src)
}
func (m *ClusterManager_OutlierDetection) XXX_Size() int {
	return m.Size()
}
func (m *ClusterManager_OutlierDetection) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterManager_OutlierDetection.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterManager_OutlierDetection proto.InternalMessageInfo

func (m *ClusterManager_OutlierDetection) GetEventLogPath() string {
	if m != nil {
		return m.EventLogPath
	}
	return ""
}

// Envoy process watchdog configuration. When configured, this monitors for
// nonresponsive threads and kills the process after the configured thresholds.
type Watchdog struct {
	// The duration after which Envoy counts a nonresponsive thread in the
	// *server.watchdog_miss* statistic. If not specified the default is 200ms.
	MissTimeout *types.Duration `protobuf:"bytes,1,opt,name=miss_timeout,json=missTimeout,proto3" json:"miss_timeout,omitempty"`
	// The duration after which Envoy counts a nonresponsive thread in the
	// *server.watchdog_mega_miss* statistic. If not specified the default is
	// 1000ms.
	MegamissTimeout *types.Duration `protobuf:"bytes,2,opt,name=megamiss_timeout,json=megamissTimeout,proto3" json:"megamiss_timeout,omitempty"`
	// If a watched thread has been nonresponsive for this duration, assume a
	// programming error and kill the entire Envoy process. Set to 0 to disable
	// kill behavior. If not specified the default is 0 (disabled).
	KillTimeout *types.Duration `protobuf:"bytes,3,opt,name=kill_timeout,json=killTimeout,proto3" json:"kill_timeout,omitempty"`
	// If at least two watched threads have been nonresponsive for at least this
	// duration assume a true deadlock and kill the entire Envoy process. Set to 0
	// to disable this behavior. If not specified the default is 0 (disabled).
	MultikillTimeout     *types.Duration `protobuf:"bytes,4,opt,name=multikill_timeout,json=multikillTimeout,proto3" json:"multikill_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Watchdog) Reset()         { *m = Watchdog{} }
func (m *Watchdog) String() string { return proto.CompactTextString(m) }
func (*Watchdog) ProtoMessage()    {}
func (*Watchdog) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{3}
}
func (m *Watchdog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Watchdog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Watchdog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Watchdog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Watchdog.Merge(m, src)
}
func (m *Watchdog) XXX_Size() int {
	return m.Size()
}
func (m *Watchdog) XXX_DiscardUnknown() {
	xxx_messageInfo_Watchdog.DiscardUnknown(m)
}

var xxx_messageInfo_Watchdog proto.InternalMessageInfo

func (m *Watchdog) GetMissTimeout() *types.Duration {
	if m != nil {
		return m.MissTimeout
	}
	return nil
}

func (m *Watchdog) GetMegamissTimeout() *types.Duration {
	if m != nil {
		return m.MegamissTimeout
	}
	return nil
}

func (m *Watchdog) GetKillTimeout() *types.Duration {
	if m != nil {
		return m.KillTimeout
	}
	return nil
}

func (m *Watchdog) GetMultikillTimeout() *types.Duration {
	if m != nil {
		return m.MultikillTimeout
	}
	return nil
}

// Runtime :ref:`configuration overview <config_runtime>` (deprecated).
type Runtime struct {
	// The implementation assumes that the file system tree is accessed via a
	// symbolic link. An atomic link swap is used when a new tree should be
	// switched to. This parameter specifies the path to the symbolic link. Envoy
	// will watch the location for changes and reload the file system tree when
	// they happen. If this parameter is not set, there will be no disk based
	// runtime.
	SymlinkRoot string `protobuf:"bytes,1,opt,name=symlink_root,json=symlinkRoot,proto3" json:"symlink_root,omitempty"`
	// Specifies the subdirectory to load within the root directory. This is
	// useful if multiple systems share the same delivery mechanism. Envoy
	// configuration elements can be contained in a dedicated subdirectory.
	Subdirectory string `protobuf:"bytes,2,opt,name=subdirectory,proto3" json:"subdirectory,omitempty"`
	// Specifies an optional subdirectory to load within the root directory. If
	// specified and the directory exists, configuration values within this
	// directory will override those found in the primary subdirectory. This is
	// useful when Envoy is deployed across many different types of servers.
	// Sometimes it is useful to have a per service cluster directory for runtime
	// configuration. See below for exactly how the override directory is used.
	OverrideSubdirectory string `protobuf:"bytes,3,opt,name=override_subdirectory,json=overrideSubdirectory,proto3" json:"override_subdirectory,omitempty"`
	// Static base runtime. This will be :ref:`overridden
	// <config_runtime_layering>` by other runtime layers, e.g.
	// disk or admin. This follows the :ref:`runtime protobuf JSON representation
	// encoding <config_runtime_proto_json>`.
	Base                 *types.Struct `protobuf:"bytes,4,opt,name=base,proto3" json:"base,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Runtime) Reset()         { *m = Runtime{} }
func (m *Runtime) String() string { return proto.CompactTextString(m) }
func (*Runtime) ProtoMessage()    {}
func (*Runtime) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{4}
}
func (m *Runtime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Runtime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Runtime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Runtime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Runtime.Merge(m, src)
}
func (m *Runtime) XXX_Size() int {
	return m.Size()
}
func (m *Runtime) XXX_DiscardUnknown() {
	xxx_messageInfo_Runtime.DiscardUnknown(m)
}

var xxx_messageInfo_Runtime proto.InternalMessageInfo

func (m *Runtime) GetSymlinkRoot() string {
	if m != nil {
		return m.SymlinkRoot
	}
	return ""
}

func (m *Runtime) GetSubdirectory() string {
	if m != nil {
		return m.Subdirectory
	}
	return ""
}

func (m *Runtime) GetOverrideSubdirectory() string {
	if m != nil {
		return m.OverrideSubdirectory
	}
	return ""
}

func (m *Runtime) GetBase() *types.Struct {
	if m != nil {
		return m.Base
	}
	return nil
}

type RuntimeLayer struct {
	// Descriptive name for the runtime layer. This is only used for the runtime
	// :http:get:`/runtime` output.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to LayerSpecifier:
	//	*RuntimeLayer_StaticLayer
	//	*RuntimeLayer_DiskLayer_
	//	*RuntimeLayer_AdminLayer_
	//	*RuntimeLayer_RtdsLayer_
	LayerSpecifier       isRuntimeLayer_LayerSpecifier `protobuf_oneof:"layer_specifier"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *RuntimeLayer) Reset()         { *m = RuntimeLayer{} }
func (m *RuntimeLayer) String() string { return proto.CompactTextString(m) }
func (*RuntimeLayer) ProtoMessage()    {}
func (*RuntimeLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{5}
}
func (m *RuntimeLayer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeLayer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeLayer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeLayer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeLayer.Merge(m, src)
}
func (m *RuntimeLayer) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeLayer) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeLayer.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeLayer proto.InternalMessageInfo

type isRuntimeLayer_LayerSpecifier interface {
	isRuntimeLayer_LayerSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type RuntimeLayer_StaticLayer struct {
	StaticLayer *types.Struct `protobuf:"bytes,2,opt,name=static_layer,json=staticLayer,proto3,oneof"`
}
type RuntimeLayer_DiskLayer_ struct {
	DiskLayer *RuntimeLayer_DiskLayer `protobuf:"bytes,3,opt,name=disk_layer,json=diskLayer,proto3,oneof"`
}
type RuntimeLayer_AdminLayer_ struct {
	AdminLayer *RuntimeLayer_AdminLayer `protobuf:"bytes,4,opt,name=admin_layer,json=adminLayer,proto3,oneof"`
}
type RuntimeLayer_RtdsLayer_ struct {
	RtdsLayer *RuntimeLayer_RtdsLayer `protobuf:"bytes,5,opt,name=rtds_layer,json=rtdsLayer,proto3,oneof"`
}

func (*RuntimeLayer_StaticLayer) isRuntimeLayer_LayerSpecifier() {}
func (*RuntimeLayer_DiskLayer_) isRuntimeLayer_LayerSpecifier()  {}
func (*RuntimeLayer_AdminLayer_) isRuntimeLayer_LayerSpecifier() {}
func (*RuntimeLayer_RtdsLayer_) isRuntimeLayer_LayerSpecifier()  {}

func (m *RuntimeLayer) GetLayerSpecifier() isRuntimeLayer_LayerSpecifier {
	if m != nil {
		return m.LayerSpecifier
	}
	return nil
}

func (m *RuntimeLayer) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RuntimeLayer) GetStaticLayer() *types.Struct {
	if x, ok := m.GetLayerSpecifier().(*RuntimeLayer_StaticLayer); ok {
		return x.StaticLayer
	}
	return nil
}

func (m *RuntimeLayer) GetDiskLayer() *RuntimeLayer_DiskLayer {
	if x, ok := m.GetLayerSpecifier().(*RuntimeLayer_DiskLayer_); ok {
		return x.DiskLayer
	}
	return nil
}

func (m *RuntimeLayer) GetAdminLayer() *RuntimeLayer_AdminLayer {
	if x, ok := m.GetLayerSpecifier().(*RuntimeLayer_AdminLayer_); ok {
		return x.AdminLayer
	}
	return nil
}

func (m *RuntimeLayer) GetRtdsLayer() *RuntimeLayer_RtdsLayer {
	if x, ok := m.GetLayerSpecifier().(*RuntimeLayer_RtdsLayer_); ok {
		return x.RtdsLayer
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RuntimeLayer) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RuntimeLayer_OneofMarshaler, _RuntimeLayer_OneofUnmarshaler, _RuntimeLayer_OneofSizer, []interface{}{
		(*RuntimeLayer_StaticLayer)(nil),
		(*RuntimeLayer_DiskLayer_)(nil),
		(*RuntimeLayer_AdminLayer_)(nil),
		(*RuntimeLayer_RtdsLayer_)(nil),
	}
}

func _RuntimeLayer_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RuntimeLayer)
	// layer_specifier
	switch x := m.LayerSpecifier.(type) {
	case *RuntimeLayer_StaticLayer:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StaticLayer); err != nil {
			return err
		}
	case *RuntimeLayer_DiskLayer_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DiskLayer); err != nil {
			return err
		}
	case *RuntimeLayer_AdminLayer_:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminLayer); err != nil {
			return err
		}
	case *RuntimeLayer_RtdsLayer_:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RtdsLayer); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RuntimeLayer.LayerSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RuntimeLayer_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RuntimeLayer)
	switch tag {
	case 2: // layer_specifier.static_layer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.LayerSpecifier = &RuntimeLayer_StaticLayer{msg}
		return true, err
	case 3: // layer_specifier.disk_layer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RuntimeLayer_DiskLayer)
		err := b.DecodeMessage(msg)
		m.LayerSpecifier = &RuntimeLayer_DiskLayer_{msg}
		return true, err
	case 4: // layer_specifier.admin_layer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RuntimeLayer_AdminLayer)
		err := b.DecodeMessage(msg)
		m.LayerSpecifier = &RuntimeLayer_AdminLayer_{msg}
		return true, err
	case 5: // layer_specifier.rtds_layer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RuntimeLayer_RtdsLayer)
		err := b.DecodeMessage(msg)
		m.LayerSpecifier = &RuntimeLayer_RtdsLayer_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RuntimeLayer_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RuntimeLayer)
	// layer_specifier
	switch x := m.LayerSpecifier.(type) {
	case *RuntimeLayer_StaticLayer:
		s := proto.Size(x.StaticLayer)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RuntimeLayer_DiskLayer_:
		s := proto.Size(x.DiskLayer)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RuntimeLayer_AdminLayer_:
		s := proto.Size(x.AdminLayer)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RuntimeLayer_RtdsLayer_:
		s := proto.Size(x.RtdsLayer)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// :ref:`Disk runtime <config_runtime_local_disk>` layer.
type RuntimeLayer_DiskLayer struct {
	// The implementation assumes that the file system tree is accessed via a
	// symbolic link. An atomic link swap is used when a new tree should be
	// switched to. This parameter specifies the path to the symbolic link.
	// Envoy will watch the location for changes and reload the file system tree
	// when they happen. See documentation on runtime :ref:`atomicity
	// <config_runtime_atomicity>` for further details on how reloads are
	// treated.
	SymlinkRoot string `protobuf:"bytes,1,opt,name=symlink_root,json=symlinkRoot,proto3" json:"symlink_root,omitempty"`
	// Specifies the subdirectory to load within the root directory. This is
	// useful if multiple systems share the same delivery mechanism. Envoy
	// configuration elements can be contained in a dedicated subdirectory.
	Subdirectory string `protobuf:"bytes,3,opt,name=subdirectory,proto3" json:"subdirectory,omitempty"`
	// :ref:`Append <config_runtime_local_disk_service_cluster_subdirs>` the
	// service cluster to the path under symlink root.
	AppendServiceCluster bool     `protobuf:"varint,2,opt,name=append_service_cluster,json=appendServiceCluster,proto3" json:"append_service_cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeLayer_DiskLayer) Reset()         { *m = RuntimeLayer_DiskLayer{} }
func (m *RuntimeLayer_DiskLayer) String() string { return proto.CompactTextString(m) }
func (*RuntimeLayer_DiskLayer) ProtoMessage()    {}
func (*RuntimeLayer_DiskLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{5, 0}
}
func (m *RuntimeLayer_DiskLayer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeLayer_DiskLayer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeLayer_DiskLayer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeLayer_DiskLayer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeLayer_DiskLayer.Merge(m, src)
}
func (m *RuntimeLayer_DiskLayer) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeLayer_DiskLayer) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeLayer_DiskLayer.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeLayer_DiskLayer proto.InternalMessageInfo

func (m *RuntimeLayer_DiskLayer) GetSymlinkRoot() string {
	if m != nil {
		return m.SymlinkRoot
	}
	return ""
}

func (m *RuntimeLayer_DiskLayer) GetSubdirectory() string {
	if m != nil {
		return m.Subdirectory
	}
	return ""
}

func (m *RuntimeLayer_DiskLayer) GetAppendServiceCluster() bool {
	if m != nil {
		return m.AppendServiceCluster
	}
	return false
}

// :ref:`Admin console runtime <config_runtime_admin>` layer.
type RuntimeLayer_AdminLayer struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeLayer_AdminLayer) Reset()         { *m = RuntimeLayer_AdminLayer{} }
func (m *RuntimeLayer_AdminLayer) String() string { return proto.CompactTextString(m) }
func (*RuntimeLayer_AdminLayer) ProtoMessage()    {}
func (*RuntimeLayer_AdminLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{5, 1}
}
func (m *RuntimeLayer_AdminLayer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeLayer_AdminLayer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeLayer_AdminLayer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeLayer_AdminLayer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeLayer_AdminLayer.Merge(m, src)
}
func (m *RuntimeLayer_AdminLayer) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeLayer_AdminLayer) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeLayer_AdminLayer.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeLayer_AdminLayer proto.InternalMessageInfo

// :ref:`Runtime Discovery Service (RTDS) <config_runtime_rtds>` layer.
type RuntimeLayer_RtdsLayer struct {
	// Resource to subscribe to at *rtds_config* for the RTDS layer.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// RTDS configuration source.
	RtdsConfig           *core.ConfigSource `protobuf:"bytes,2,opt,name=rtds_config,json=rtdsConfig,proto3" json:"rtds_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *RuntimeLayer_RtdsLayer) Reset()         { *m = RuntimeLayer_RtdsLayer{} }
func (m *RuntimeLayer_RtdsLayer) String() string { return proto.CompactTextString(m) }
func (*RuntimeLayer_RtdsLayer) ProtoMessage()    {}
func (*RuntimeLayer_RtdsLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{5, 2}
}
func (m *RuntimeLayer_RtdsLayer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeLayer_RtdsLayer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeLayer_RtdsLayer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeLayer_RtdsLayer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeLayer_RtdsLayer.Merge(m, src)
}
func (m *RuntimeLayer_RtdsLayer) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeLayer_RtdsLayer) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeLayer_RtdsLayer.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeLayer_RtdsLayer proto.InternalMessageInfo

func (m *RuntimeLayer_RtdsLayer) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RuntimeLayer_RtdsLayer) GetRtdsConfig() *core.ConfigSource {
	if m != nil {
		return m.RtdsConfig
	}
	return nil
}

// Runtime :ref:`configuration overview <config_runtime>`.
type LayeredRuntime struct {
	// The :ref:`layers <config_runtime_layering>` of the runtime. This is ordered
	// such that later layers in the list overlay earlier entries.
	Layers               []*RuntimeLayer `protobuf:"bytes,1,rep,name=layers,proto3" json:"layers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *LayeredRuntime) Reset()         { *m = LayeredRuntime{} }
func (m *LayeredRuntime) String() string { return proto.CompactTextString(m) }
func (*LayeredRuntime) ProtoMessage()    {}
func (*LayeredRuntime) Descriptor() ([]byte, []int) {
	return fileDescriptor_f1197defdf9c5e6a, []int{6}
}
func (m *LayeredRuntime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LayeredRuntime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LayeredRuntime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LayeredRuntime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LayeredRuntime.Merge(m, src)
}
func (m *LayeredRuntime) XXX_Size() int {
	return m.Size()
}
func (m *LayeredRuntime) XXX_DiscardUnknown() {
	xxx_messageInfo_LayeredRuntime.DiscardUnknown(m)
}

var xxx_messageInfo_LayeredRuntime proto.InternalMessageInfo

func (m *LayeredRuntime) GetLayers() []*RuntimeLayer {
	if m != nil {
		return m.Layers
	}
	return nil
}

func init() {
	proto.RegisterType((*Bootstrap)(nil), "envoy.config.bootstrap.v2.Bootstrap")
	proto.RegisterType((*Bootstrap_StaticResources)(nil), "envoy.config.bootstrap.v2.Bootstrap.StaticResources")
	proto.RegisterType((*Bootstrap_DynamicResources)(nil), "envoy.config.bootstrap.v2.Bootstrap.DynamicResources")
	proto.RegisterType((*Admin)(nil), "envoy.config.bootstrap.v2.Admin")
	proto.RegisterType((*ClusterManager)(nil), "envoy.config.bootstrap.v2.ClusterManager")
	proto.RegisterType((*ClusterManager_OutlierDetection)(nil), "envoy.config.bootstrap.v2.ClusterManager.OutlierDetection")
	proto.RegisterType((*Watchdog)(nil), "envoy.config.bootstrap.v2.Watchdog")
	proto.RegisterType((*Runtime)(nil), "envoy.config.bootstrap.v2.Runtime")
	proto.RegisterType((*RuntimeLayer)(nil), "envoy.config.bootstrap.v2.RuntimeLayer")
	proto.RegisterType((*RuntimeLayer_DiskLayer)(nil), "envoy.config.bootstrap.v2.RuntimeLayer.DiskLayer")
	proto.RegisterType((*RuntimeLayer_AdminLayer)(nil), "envoy.config.bootstrap.v2.RuntimeLayer.AdminLayer")
	proto.RegisterType((*RuntimeLayer_RtdsLayer)(nil), "envoy.config.bootstrap.v2.RuntimeLayer.RtdsLayer")
	proto.RegisterType((*LayeredRuntime)(nil), "envoy.config.bootstrap.v2.LayeredRuntime")
}

func init() {
	proto.RegisterFile("envoy/config/bootstrap/v2/bootstrap.proto", fileDescriptor_f1197defdf9c5e6a)
}

var fileDescriptor_f1197defdf9c5e6a = []byte{
	// 1490 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x4d, 0x6f, 0x1b, 0xbd,
	0x11, 0x7e, 0x57, 0x92, 0x63, 0x69, 0x24, 0x4b, 0x32, 0xe1, 0xc4, 0xfb, 0x0a, 0x8d, 0xe3, 0x28,
	0x6f, 0x9b, 0x04, 0x09, 0x56, 0x88, 0xe2, 0x06, 0x41, 0x11, 0x24, 0xb1, 0x62, 0xa4, 0x69, 0x9a,
	0xc6, 0x0e, 0x95, 0xa2, 0x68, 0x2f, 0x0b, 0x6a, 0x97, 0x96, 0x08, 0xaf, 0x96, 0x0b, 0x92, 0x52,
	0xe3, 0x5b, 0xd1, 0x53, 0x7f, 0x40, 0x0f, 0xfd, 0x0f, 0x3d, 0x14, 0xe8, 0xa9, 0xe8, 0x29, 0xc7,
	0x1e, 0x73, 0xef, 0xa1, 0x45, 0x6e, 0xf9, 0x17, 0xc5, 0x92, 0xdc, 0x95, 0xd7, 0x91, 0x3f, 0xd2,
	0xdb, 0x72, 0xf8, 0x3c, 0x0f, 0x87, 0x33, 0xc3, 0x21, 0x17, 0xee, 0xd2, 0x78, 0xce, 0x8f, 0x7b,
	0x01, 0x8f, 0x0f, 0xd9, 0xb8, 0x37, 0xe2, 0x5c, 0x49, 0x25, 0x48, 0xd2, 0x9b, 0xf7, 0x17, 0x03,
	0x2f, 0x11, 0x5c, 0x71, 0xf4, 0xbd, 0x86, 0x7a, 0x06, 0xea, 0x2d, 0x66, 0xe7, 0xfd, 0xce, 0x0d,
	0xa3, 0x42, 0x12, 0x96, 0x12, 0x03, 0x2e, 0x68, 0x8f, 0x84, 0xa1, 0xa0, 0x52, 0x1a, 0x6e, 0xe7,
	0x47, 0x5f, 0x03, 0x46, 0x44, 0xd2, 0xa5, 0xb3, 0x64, 0xa6, 0x26, 0xbd, 0x80, 0x0a, 0x65, 0x67,
	0x7f, 0xfc, 0x35, 0xd7, 0xf8, 0xe0, 0x4b, 0x3e, 0x13, 0x41, 0x26, 0x72, 0xad, 0x08, 0x0b, 0xe5,
	0x52, 0x7b, 0x94, 0xdb, 0x6f, 0x16, 0x76, 0xae, 0x04, 0x09, 0x68, 0x0a, 0xd0, 0x1f, 0x16, 0x72,
	0xab, 0x00, 0x99, 0x52, 0x25, 0x58, 0x20, 0x53, 0x90, 0x54, 0x44, 0x65, 0x3a, 0xf7, 0x0b, 0x20,
	0x3e, 0xa7, 0x22, 0xe2, 0x24, 0xec, 0xcd, 0xfb, 0x24, 0x4a, 0x26, 0x24, 0x37, 0x58, 0xf4, 0xd6,
	0x98, 0xf3, 0x71, 0x44, 0x7b, 0x7a, 0x34, 0x9a, 0x1d, 0xf6, 0xc2, 0x99, 0x20, 0x8a, 0xf1, 0x38,
	0x0b, 0xc5, 0xe9, 0x79, 0xa9, 0xc4, 0x2c, 0xc8, 0x42, 0xb1, 0x39, 0x27, 0x11, 0x0b, 0x89, 0xa2,
	0xbd, 0xec, 0xc3, 0x4e, 0x6c, 0x8c, 0xf9, 0x98, 0xeb, 0xcf, 0x5e, 0xfa, 0x65, 0xac, 0xdd, 0xbf,
	0x36, 0xa0, 0x36, 0xc8, 0xf2, 0x84, 0xee, 0x41, 0x25, 0xe6, 0x21, 0x75, 0x9d, 0x6d, 0xe7, 0x4e,
	0xbd, 0xbf, 0xe9, 0x99, 0x74, 0x92, 0x84, 0x79, 0xf3, 0xbe, 0x97, 0x86, 0xd5, 0x7b, 0xcb, 0x43,
	0x8a, 0x35, 0x08, 0xf9, 0xd0, 0x4e, 0x37, 0xc9, 0x02, 0x5f, 0x50, 0x13, 0x66, 0xe9, 0x96, 0x34,
	0x71, 0xc7, 0x3b, 0xb3, 0x0e, 0xbc, 0x7c, 0x31, 0x6f, 0xa8, 0xc9, 0x38, 0xe3, 0xe2, 0x96, 0x2c,
	0x1a, 0xd0, 0x08, 0xd6, 0xc3, 0xe3, 0x98, 0x4c, 0x0b, 0x2b, 0x94, 0xf5, 0x0a, 0x3f, 0xbd, 0xd4,
	0x0a, 0x7b, 0x86, 0xbd, 0x58, 0xa2, 0x1d, 0x9e, 0xb2, 0x20, 0x0c, 0xad, 0x20, 0x9a, 0x49, 0x45,
	0x85, 0x3f, 0x25, 0x31, 0x19, 0x53, 0xe1, 0x56, 0xf4, 0x0a, 0x77, 0xcf, 0x59, 0xe1, 0x85, 0x61,
	0xfc, 0xca, 0x10, 0x70, 0x33, 0x28, 0x8c, 0xd1, 0x2e, 0xc0, 0x24, 0x94, 0xbe, 0x61, 0xba, 0x4d,
	0x2d, 0xd7, 0x5d, 0x12, 0xcb, 0xdd, 0x84, 0xbd, 0xd0, 0x98, 0xa1, 0x76, 0x06, 0xd7, 0x26, 0xa1,
	0x34, 0x06, 0x74, 0x1d, 0xe0, 0x30, 0x22, 0x63, 0xe9, 0x27, 0x44, 0x4d, 0xdc, 0x95, 0x6d, 0xe7,
	0x4e, 0x0d, 0xd7, 0xb4, 0xe5, 0x80, 0xa8, 0x09, 0x7a, 0x01, 0x75, 0x5d, 0x5f, 0xbe, 0x64, 0xf1,
	0x91, 0x74, 0xaf, 0x6c, 0x97, 0x4f, 0x2c, 0x61, 0x3d, 0xb6, 0xb5, 0x98, 0xae, 0x96, 0x46, 0x5a,
	0x0e, 0x59, 0x7c, 0x84, 0x41, 0x66, 0x9f, 0x12, 0xfd, 0x1c, 0x1a, 0x46, 0xc4, 0x3a, 0xba, 0xa6,
	0x1d, 0xfd, 0xe1, 0x7c, 0x15, 0xe3, 0x1f, 0x36, 0xcb, 0x5b, 0x67, 0xdf, 0xc1, 0x86, 0x11, 0x3a,
	0x8c, 0x66, 0x72, 0xe2, 0xb3, 0x58, 0x51, 0x31, 0x27, 0x91, 0xbb, 0xaa, 0x05, 0xbf, 0xf7, 0x4c,
	0xbd, 0x7a, 0x59, 0xbd, 0x7a, 0x7b, 0xb6, 0x9e, 0x07, 0x95, 0xbf, 0xfc, 0xe7, 0x86, 0x83, 0x91,
	0x26, 0xbf, 0x4c, 0xb9, 0xbf, 0xb0, 0x54, 0xf4, 0x0c, 0xaa, 0xbf, 0x27, 0x2a, 0x98, 0x84, 0x7c,
	0xec, 0x56, 0xb5, 0xcc, 0xad, 0x73, 0xf2, 0xf1, 0x1b, 0x0b, 0xc5, 0x39, 0x09, 0x3d, 0x86, 0xd5,
	0xf4, 0x98, 0xb2, 0x78, 0xec, 0xd6, 0x34, 0x7f, 0xab, 0xc8, 0x37, 0x67, 0x78, 0xde, 0xf7, 0xde,
	0x1b, 0x14, 0xce, 0xe0, 0xe8, 0x39, 0xac, 0x8a, 0x59, 0xac, 0xd8, 0x94, 0xba, 0xf5, 0x42, 0xea,
	0x96, 0xad, 0x8c, 0x0d, 0x72, 0x50, 0x72, 0x1d, 0x9c, 0xd1, 0xd2, 0x9a, 0x8a, 0xc8, 0x31, 0x15,
	0x34, 0xf4, 0x33, 0xa5, 0xf5, 0x0b, 0x6b, 0xea, 0x8d, 0x61, 0x58, 0x41, 0xdc, 0x8c, 0x0a, 0x63,
	0xf4, 0x08, 0x56, 0x48, 0x38, 0x65, 0xb1, 0xdb, 0xd0, 0x4a, 0xdb, 0xe7, 0x28, 0xed, 0xa6, 0x38,
	0x6c, 0xe0, 0xe8, 0xb7, 0xd0, 0xce, 0xda, 0x4b, 0x5e, 0xe0, 0x2d, 0x2d, 0xe1, 0x15, 0x25, 0xf2,
	0x26, 0x64, 0xbb, 0x92, 0xb7, 0x6f, 0x0d, 0x59, 0x95, 0xb7, 0x78, 0xd1, 0x80, 0x1e, 0xc1, 0x26,
	0x8d, 0xc9, 0x28, 0xa2, 0x7e, 0xc8, 0x64, 0x92, 0x06, 0x9e, 0x0a, 0x5f, 0xe7, 0xd2, 0x6d, 0x6f,
	0x3b, 0x77, 0xaa, 0xf8, 0xaa, 0x99, 0xde, 0xcb, 0x67, 0x75, 0x05, 0xa1, 0x5b, 0xb0, 0x36, 0xa1,
	0x24, 0xa4, 0xc2, 0x4f, 0x04, 0x3d, 0x64, 0x1f, 0x5c, 0xa4, 0xcb, 0xbb, 0x61, 0x8c, 0x07, 0xda,
	0xd6, 0xf9, 0x9b, 0x03, 0xad, 0x53, 0x0d, 0x02, 0xed, 0x40, 0x2d, 0x62, 0x52, 0xd1, 0x98, 0x0a,
	0xe9, 0x3a, 0xba, 0xe6, 0xaf, 0x15, 0x8f, 0xd5, 0x1b, 0x3b, 0x8d, 0x17, 0x40, 0xf4, 0x00, 0xaa,
	0xf6, 0x7c, 0xa6, 0xed, 0x29, 0x25, 0x5d, 0x2d, 0x92, 0xec, 0x69, 0xc6, 0x39, 0x0c, 0x3d, 0x84,
	0x55, 0x49, 0x03, 0x41, 0x55, 0xda, 0x6e, 0xca, 0xba, 0x86, 0x0b, 0x8c, 0xf4, 0xfa, 0xf1, 0x86,
	0x1a, 0x81, 0x33, 0x64, 0xe7, 0xdf, 0x0e, 0xb4, 0x4f, 0x37, 0x1c, 0xf4, 0x14, 0x20, 0x5a, 0xb4,
	0x02, 0xd3, 0x56, 0x6f, 0x2c, 0x69, 0x05, 0xc5, 0x3e, 0x10, 0xe5, 0x7d, 0xe0, 0x29, 0x40, 0xb0,
	0xe0, 0x97, 0x2e, 0xc9, 0x0f, 0x72, 0xfe, 0x2e, 0x00, 0x59, 0xf0, 0xcb, 0x97, 0x6f, 0x45, 0x24,
	0x93, 0x78, 0x5d, 0xa9, 0x56, 0xda, 0x2b, 0xaf, 0x2b, 0x55, 0x68, 0xd7, 0xbb, 0x9f, 0x1c, 0x58,
	0xd1, 0xe5, 0x85, 0x7e, 0x02, 0x2d, 0x12, 0x04, 0x54, 0x4a, 0x3f, 0xe2, 0x63, 0xd3, 0xa5, 0x1c,
	0x9d, 0xc6, 0x35, 0x63, 0x7e, 0xc3, 0xc7, 0xba, 0x53, 0xdd, 0x84, 0x46, 0x22, 0xf8, 0x21, 0x8b,
	0xa8, 0x01, 0x95, 0x34, 0xa8, 0x6e, 0x6d, 0x1a, 0xb2, 0x03, 0xab, 0xf6, 0x25, 0x60, 0x1d, 0xec,
	0x2c, 0x73, 0xd0, 0x20, 0x70, 0x06, 0x45, 0x2f, 0xa1, 0x29, 0x79, 0x70, 0x44, 0x95, 0xcf, 0x93,
	0xb4, 0x99, 0x48, 0xb7, 0xa2, 0x53, 0xb5, 0x2c, 0x3a, 0x43, 0x0d, 0xdc, 0xd7, 0x38, 0xbc, 0x26,
	0x4f, 0x8c, 0x64, 0xf7, 0x8f, 0x65, 0x68, 0x16, 0xfb, 0x39, 0xba, 0x0f, 0x28, 0xe2, 0x01, 0x89,
	0xfc, 0xec, 0x66, 0x88, 0xc9, 0x94, 0xda, 0xed, 0xb5, 0xf5, 0x8c, 0x25, 0xbc, 0x25, 0x53, 0x8a,
	0xc6, 0xb0, 0xce, 0x67, 0x2a, 0x62, 0x54, 0xf8, 0x21, 0x55, 0x34, 0x48, 0x65, 0x6d, 0xa6, 0x7e,
	0x76, 0xe9, 0x3b, 0xc4, 0xdb, 0x37, 0x12, 0x7b, 0x99, 0x02, 0x6e, 0xf3, 0x53, 0x16, 0xb4, 0x0f,
	0x1b, 0xb3, 0x44, 0x2a, 0x41, 0xc9, 0xd4, 0x1f, 0xb1, 0x38, 0x2c, 0x66, 0xf5, 0xfa, 0x92, 0x7d,
	0x0f, 0x58, 0x1c, 0xda, 0x86, 0x8d, 0x32, 0xea, 0xc2, 0x86, 0xde, 0xc2, 0xba, 0xee, 0x0b, 0x85,
	0x5b, 0xa0, 0x72, 0xe9, 0x1a, 0x69, 0xa5, 0xe4, 0x13, 0x97, 0x42, 0xe7, 0x31, 0xb4, 0x4f, 0x6f,
	0x03, 0xfd, 0x00, 0x4d, 0x3a, 0xa7, 0xb1, 0x3a, 0x5d, 0x26, 0x0d, 0x6d, 0xb5, 0x55, 0xd2, 0xfd,
	0x73, 0x09, 0xaa, 0x59, 0x13, 0x47, 0x4f, 0xa0, 0x31, 0x65, 0x52, 0xfa, 0x69, 0xdf, 0xe3, 0x33,
	0x65, 0x4f, 0xcd, 0xd9, 0xd7, 0x08, 0xae, 0xa7, 0xf0, 0xf7, 0x06, 0x8d, 0xf6, 0xa0, 0x3d, 0xa5,
	0x63, 0x52, 0x50, 0x28, 0x5d, 0xa4, 0xd0, 0xca, 0x28, 0x99, 0xca, 0x13, 0x68, 0x1c, 0xb1, 0x28,
	0xca, 0x15, 0xca, 0x17, 0xfa, 0x90, 0xc2, 0x33, 0xf6, 0x4b, 0x58, 0x9f, 0xce, 0x22, 0xc5, 0x0a,
	0x12, 0x95, 0x8b, 0x24, 0xda, 0x39, 0xc7, 0xea, 0x74, 0xff, 0xee, 0xc0, 0x6a, 0x76, 0x01, 0xdc,
	0x84, 0x86, 0x3c, 0x9e, 0x46, 0x2c, 0x3e, 0xf2, 0x05, 0xe7, 0xca, 0x86, 0xb1, 0x6e, 0x6d, 0x98,
	0x73, 0x85, 0xba, 0xd0, 0x90, 0xb3, 0x51, 0xc8, 0x04, 0x0d, 0x14, 0x17, 0xc7, 0xf6, 0xac, 0x15,
	0x6c, 0xe8, 0x21, 0x5c, 0x4d, 0xfb, 0xb8, 0x60, 0x21, 0xf5, 0x0b, 0xe0, 0xb2, 0x06, 0x6f, 0x64,
	0x93, 0xc3, 0x93, 0xa4, 0x7b, 0x50, 0x49, 0x9f, 0xe2, 0x76, 0x0b, 0x9b, 0x5f, 0x6d, 0x61, 0xa8,
	0x1f, 0xa0, 0x58, 0x83, 0xba, 0x7f, 0x58, 0x81, 0x86, 0x75, 0x5a, 0xdf, 0x69, 0xe8, 0x3a, 0x54,
	0x16, 0x07, 0x68, 0x50, 0xfb, 0xe7, 0x97, 0x8f, 0xe5, 0x8a, 0x28, 0x6d, 0x3b, 0x58, 0x9b, 0xd3,
	0x50, 0xdb, 0x67, 0xa4, 0xbe, 0xf2, 0x6c, 0xb2, 0xce, 0x5a, 0xe4, 0xd5, 0x77, 0xe6, 0xed, 0xc1,
	0x02, 0x23, 0x8e, 0x01, 0x42, 0x26, 0x8f, 0x2c, 0xd7, 0xa4, 0xe9, 0xc1, 0xc5, 0x17, 0xb6, 0x26,
	0x7b, 0x7b, 0x4c, 0x1e, 0xe9, 0xaf, 0x57, 0xdf, 0xe1, 0x5a, 0x98, 0x0d, 0xd0, 0xaf, 0xa1, 0xae,
	0x2f, 0x4f, 0x2b, 0x6a, 0x76, 0xdd, 0xbf, 0xac, 0xa8, 0xee, 0x8f, 0x99, 0x2a, 0x90, 0x7c, 0x94,
	0xba, 0x2a, 0x54, 0x28, 0xad, 0xea, 0xca, 0xb7, 0xb9, 0x8a, 0x55, 0x28, 0x73, 0x57, 0x45, 0x36,
	0xe8, 0xfc, 0xc9, 0x81, 0x5a, 0xbe, 0x8b, 0xff, 0xa7, 0x46, 0xca, 0x4b, 0x6a, 0x64, 0x07, 0xae,
	0x91, 0x24, 0xa1, 0x71, 0xe8, 0x4b, 0x2a, 0xe6, 0x2c, 0xa0, 0x59, 0x23, 0xd4, 0xb9, 0xa9, 0xe2,
	0x0d, 0x33, 0x3b, 0x34, 0x93, 0xb6, 0x91, 0x75, 0x1a, 0x00, 0x8b, 0xad, 0x77, 0x08, 0xd4, 0x72,
	0x97, 0x11, 0x3a, 0x59, 0x01, 0x36, 0xed, 0xcf, 0xa1, 0xae, 0xa3, 0xf1, 0x6d, 0x57, 0x9b, 0x8e,
	0xa0, 0xb1, 0x0c, 0x5c, 0xfb, 0xcc, 0xf2, 0x65, 0x42, 0x03, 0x76, 0xc8, 0xa8, 0x40, 0x2b, 0xff,
	0xf8, 0xf2, 0xb1, 0xec, 0x74, 0xdf, 0x41, 0xb3, 0xf8, 0x9c, 0x42, 0xcf, 0xe0, 0x8a, 0xc6, 0x66,
	0xef, 0x86, 0xdb, 0x97, 0x8c, 0x3b, 0xb6, 0xb4, 0xc1, 0x2f, 0xff, 0xf5, 0x79, 0xcb, 0xf9, 0xf4,
	0x79, 0xcb, 0xf9, 0xef, 0xe7, 0x2d, 0x07, 0x6e, 0x33, 0x6e, 0x04, 0x12, 0xc1, 0x3f, 0x1c, 0x9f,
	0xad, 0x35, 0x68, 0xe6, 0x3f, 0x23, 0x07, 0x69, 0x1d, 0x1f, 0x38, 0xbf, 0x2b, 0xcd, 0xfb, 0xa3,
	0x2b, 0xba, 0xa8, 0x1f, 0xfe, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x8a, 0xa4, 0x0d, 0xd2, 0x5a, 0x0f,
	0x00, 0x00,
}

func (m *Bootstrap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Node.Size()))
		n1, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.StaticResources != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.StaticResources.Size()))
		n2, err := m.StaticResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DynamicResources != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.DynamicResources.Size()))
		n3, err := m.DynamicResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ClusterManager != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.ClusterManager.Size()))
		n4, err := m.ClusterManager.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.FlagsPath) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.FlagsPath)))
		i += copy(dAtA[i:], m.FlagsPath)
	}
	if len(m.StatsSinks) > 0 {
		for _, msg := range m.StatsSinks {
			dAtA[i] = 0x32
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StatsFlushInterval != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StatsFlushInterval)))
		n5, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StatsFlushInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Watchdog != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Watchdog.Size()))
		n6, err := m.Watchdog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Tracing != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Tracing.Size()))
		n7, err := m.Tracing.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Runtime != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Runtime.Size()))
		n8, err := m.Runtime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Admin != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Admin.Size()))
		n9, err := m.Admin.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.StatsConfig != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.StatsConfig.Size()))
		n10, err := m.StatsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.HdsConfig != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.HdsConfig.Size()))
		n11, err := m.HdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.OverloadManager != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.OverloadManager.Size()))
		n12, err := m.OverloadManager.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.EnableDispatcherStats {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		if m.EnableDispatcherStats {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LayeredRuntime != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.LayeredRuntime.Size()))
		n13, err := m.LayeredRuntime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if len(m.HeaderPrefix) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.HeaderPrefix)))
		i += copy(dAtA[i:], m.HeaderPrefix)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bootstrap_StaticResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap_StaticResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Listeners) > 0 {
		for _, msg := range m.Listeners {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Clusters) > 0 {
		for _, msg := range m.Clusters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Secrets) > 0 {
		for _, msg := range m.Secrets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bootstrap_DynamicResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap_DynamicResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.LdsConfig.Size()))
		n14, err := m.LdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.CdsConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.CdsConfig.Size()))
		n15, err := m.CdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.AdsConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.AdsConfig.Size()))
		n16, err := m.AdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Admin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Admin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AccessLogPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.AccessLogPath)))
		i += copy(dAtA[i:], m.AccessLogPath)
	}
	if len(m.ProfilePath) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.ProfilePath)))
		i += copy(dAtA[i:], m.ProfilePath)
	}
	if m.Address != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Address.Size()))
		n17, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.SocketOptions) > 0 {
		for _, msg := range m.SocketOptions {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterManager) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterManager) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LocalClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.LocalClusterName)))
		i += copy(dAtA[i:], m.LocalClusterName)
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.OutlierDetection.Size()))
		n18, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.UpstreamBindConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.UpstreamBindConfig.Size()))
		n19, err := m.UpstreamBindConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.LoadStatsConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.LoadStatsConfig.Size()))
		n20, err := m.LoadStatsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterManager_OutlierDetection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterManager_OutlierDetection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.EventLogPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.EventLogPath)))
		i += copy(dAtA[i:], m.EventLogPath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Watchdog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Watchdog) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MissTimeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MissTimeout.Size()))
		n21, err := m.MissTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.MegamissTimeout != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MegamissTimeout.Size()))
		n22, err := m.MegamissTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.KillTimeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.KillTimeout.Size()))
		n23, err := m.KillTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.MultikillTimeout != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MultikillTimeout.Size()))
		n24, err := m.MultikillTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Runtime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Runtime) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SymlinkRoot) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.SymlinkRoot)))
		i += copy(dAtA[i:], m.SymlinkRoot)
	}
	if len(m.Subdirectory) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.Subdirectory)))
		i += copy(dAtA[i:], m.Subdirectory)
	}
	if len(m.OverrideSubdirectory) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.OverrideSubdirectory)))
		i += copy(dAtA[i:], m.OverrideSubdirectory)
	}
	if m.Base != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Base.Size()))
		n25, err := m.Base.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeLayer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeLayer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.LayerSpecifier != nil {
		nn26, err := m.LayerSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn26
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeLayer_StaticLayer) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StaticLayer != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.StaticLayer.Size()))
		n27, err := m.StaticLayer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *RuntimeLayer_DiskLayer_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DiskLayer != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.DiskLayer.Size()))
		n28, err := m.DiskLayer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func (m *RuntimeLayer_AdminLayer_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminLayer != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.AdminLayer.Size()))
		n29, err := m.AdminLayer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}
func (m *RuntimeLayer_RtdsLayer_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RtdsLayer != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.RtdsLayer.Size()))
		n30, err := m.RtdsLayer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	return i, nil
}
func (m *RuntimeLayer_DiskLayer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeLayer_DiskLayer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SymlinkRoot) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.SymlinkRoot)))
		i += copy(dAtA[i:], m.SymlinkRoot)
	}
	if m.AppendServiceCluster {
		dAtA[i] = 0x10
		i++
		if m.AppendServiceCluster {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Subdirectory) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.Subdirectory)))
		i += copy(dAtA[i:], m.Subdirectory)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeLayer_AdminLayer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeLayer_AdminLayer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeLayer_RtdsLayer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeLayer_RtdsLayer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.RtdsConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.RtdsConfig.Size()))
		n31, err := m.RtdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LayeredRuntime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LayeredRuntime) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Layers) > 0 {
		for _, msg := range m.Layers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintBootstrap(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Bootstrap) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.StaticResources != nil {
		l = m.StaticResources.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.DynamicResources != nil {
		l = m.DynamicResources.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.ClusterManager != nil {
		l = m.ClusterManager.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.FlagsPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if len(m.StatsSinks) > 0 {
		for _, e := range m.StatsSinks {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.StatsFlushInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StatsFlushInterval)
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Watchdog != nil {
		l = m.Watchdog.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Tracing != nil {
		l = m.Tracing.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Runtime != nil {
		l = m.Runtime.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Admin != nil {
		l = m.Admin.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.StatsConfig != nil {
		l = m.StatsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.HdsConfig != nil {
		l = m.HdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.OverloadManager != nil {
		l = m.OverloadManager.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.EnableDispatcherStats {
		n += 3
	}
	if m.LayeredRuntime != nil {
		l = m.LayeredRuntime.Size()
		n += 2 + l + sovBootstrap(uint64(l))
	}
	l = len(m.HeaderPrefix)
	if l > 0 {
		n += 2 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bootstrap_StaticResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Listeners) > 0 {
		for _, e := range m.Listeners {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bootstrap_DynamicResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LdsConfig != nil {
		l = m.LdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.CdsConfig != nil {
		l = m.CdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.AdsConfig != nil {
		l = m.AdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Admin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AccessLogPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.ProfilePath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if len(m.SocketOptions) > 0 {
		for _, e := range m.SocketOptions {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterManager) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LocalClusterName)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.UpstreamBindConfig != nil {
		l = m.UpstreamBindConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.LoadStatsConfig != nil {
		l = m.LoadStatsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterManager_OutlierDetection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EventLogPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Watchdog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MissTimeout != nil {
		l = m.MissTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.MegamissTimeout != nil {
		l = m.MegamissTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.KillTimeout != nil {
		l = m.KillTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.MultikillTimeout != nil {
		l = m.MultikillTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Runtime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SymlinkRoot)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.Subdirectory)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.OverrideSubdirectory)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Base != nil {
		l = m.Base.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.LayerSpecifier != nil {
		n += m.LayerSpecifier.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeLayer_StaticLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StaticLayer != nil {
		l = m.StaticLayer.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	return n
}
func (m *RuntimeLayer_DiskLayer_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DiskLayer != nil {
		l = m.DiskLayer.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	return n
}
func (m *RuntimeLayer_AdminLayer_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminLayer != nil {
		l = m.AdminLayer.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	return n
}
func (m *RuntimeLayer_RtdsLayer_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RtdsLayer != nil {
		l = m.RtdsLayer.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	return n
}
func (m *RuntimeLayer_DiskLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SymlinkRoot)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.AppendServiceCluster {
		n += 2
	}
	l = len(m.Subdirectory)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeLayer_AdminLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeLayer_RtdsLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.RtdsConfig != nil {
		l = m.RtdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LayeredRuntime) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Layers) > 0 {
		for _, e := range m.Layers {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBootstrap(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBootstrap(x uint64) (n int) {
	return sovBootstrap(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Bootstrap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bootstrap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bootstrap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &core.Node{}
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StaticResources == nil {
				m.StaticResources = &Bootstrap_StaticResources{}
			}
			if err := m.StaticResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DynamicResources == nil {
				m.DynamicResources = &Bootstrap_DynamicResources{}
			}
			if err := m.DynamicResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterManager", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterManager == nil {
				m.ClusterManager = &ClusterManager{}
			}
			if err := m.ClusterManager.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlagsPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FlagsPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsSinks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsSinks = append(m.StatsSinks, &v2.StatsSink{})
			if err := m.StatsSinks[len(m.StatsSinks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsFlushInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsFlushInterval == nil {
				m.StatsFlushInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StatsFlushInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Watchdog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Watchdog == nil {
				m.Watchdog = &Watchdog{}
			}
			if err := m.Watchdog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracing == nil {
				m.Tracing = &v21.Tracing{}
			}
			if err := m.Tracing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runtime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Runtime == nil {
				m.Runtime = &Runtime{}
			}
			if err := m.Runtime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Admin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Admin == nil {
				m.Admin = &Admin{}
			}
			if err := m.Admin.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsConfig == nil {
				m.StatsConfig = &v2.StatsConfig{}
			}
			if err := m.StatsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HdsConfig == nil {
				m.HdsConfig = &core.ApiConfigSource{}
			}
			if err := m.HdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverloadManager", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OverloadManager == nil {
				m.OverloadManager = &v2alpha.OverloadManager{}
			}
			if err := m.OverloadManager.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableDispatcherStats", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableDispatcherStats = bool(v != 0)
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LayeredRuntime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LayeredRuntime == nil {
				m.LayeredRuntime = &LayeredRuntime{}
			}
			if err := m.LayeredRuntime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bootstrap_StaticResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Listeners = append(m.Listeners, &v22.Listener{})
			if err := m.Listeners[len(m.Listeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &v22.Cluster{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &auth.Secret{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bootstrap_DynamicResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DynamicResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DynamicResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LdsConfig == nil {
				m.LdsConfig = &core.ConfigSource{}
			}
			if err := m.LdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CdsConfig == nil {
				m.CdsConfig = &core.ConfigSource{}
			}
			if err := m.CdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdsConfig == nil {
				m.AdsConfig = &core.ApiConfigSource{}
			}
			if err := m.AdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Admin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Admin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Admin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProfilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &core.Address{}
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SocketOptions = append(m.SocketOptions, &core.SocketOption{})
			if err := m.SocketOptions[len(m.SocketOptions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterManager) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterManager: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterManager: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &ClusterManager_OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamBindConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamBindConfig == nil {
				m.UpstreamBindConfig = &core.BindConfig{}
			}
			if err := m.UpstreamBindConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadStatsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadStatsConfig == nil {
				m.LoadStatsConfig = &core.ApiConfigSource{}
			}
			if err := m.LoadStatsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterManager_OutlierDetection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventLogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventLogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Watchdog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Watchdog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Watchdog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MissTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MissTimeout == nil {
				m.MissTimeout = &types.Duration{}
			}
			if err := m.MissTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MegamissTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MegamissTimeout == nil {
				m.MegamissTimeout = &types.Duration{}
			}
			if err := m.MegamissTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KillTimeout == nil {
				m.KillTimeout = &types.Duration{}
			}
			if err := m.KillTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MultikillTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MultikillTimeout == nil {
				m.MultikillTimeout = &types.Duration{}
			}
			if err := m.MultikillTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Runtime) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Runtime: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Runtime: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SymlinkRoot", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SymlinkRoot = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subdirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subdirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverrideSubdirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OverrideSubdirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Base", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Base == nil {
				m.Base = &types.Struct{}
			}
			if err := m.Base.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeLayer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeLayer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeLayer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticLayer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LayerSpecifier = &RuntimeLayer_StaticLayer{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskLayer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuntimeLayer_DiskLayer{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LayerSpecifier = &RuntimeLayer_DiskLayer_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminLayer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuntimeLayer_AdminLayer{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LayerSpecifier = &RuntimeLayer_AdminLayer_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RtdsLayer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuntimeLayer_RtdsLayer{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LayerSpecifier = &RuntimeLayer_RtdsLayer_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeLayer_DiskLayer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiskLayer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiskLayer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SymlinkRoot", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SymlinkRoot = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendServiceCluster", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AppendServiceCluster = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subdirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subdirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeLayer_AdminLayer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminLayer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminLayer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeLayer_RtdsLayer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RtdsLayer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RtdsLayer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RtdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RtdsConfig == nil {
				m.RtdsConfig = &core.ConfigSource{}
			}
			if err := m.RtdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LayeredRuntime) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LayeredRuntime: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LayeredRuntime: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Layers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBootstrap
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Layers = append(m.Layers, &RuntimeLayer{})
			if err := m.Layers[len(m.Layers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBootstrap(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBootstrap
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthBootstrap
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBootstrap
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBootstrap(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthBootstrap
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBootstrap = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBootstrap   = fmt.Errorf("proto: integer overflow")
)
