// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/test/spyAdapter/template/report/reporttmpl_handler_service.proto

package samplereport

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleSampleReport method.
type HandleSampleReportRequest struct {
	// 'samplereport' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleSampleReportRequest) Reset()      { *m = HandleSampleReportRequest{} }
func (*HandleSampleReportRequest) ProtoMessage() {}
func (*HandleSampleReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b05e7600bf31d60, []int{0}
}
func (m *HandleSampleReportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleSampleReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HandleSampleReportRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HandleSampleReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleSampleReportRequest.Merge(m, src)
}
func (m *HandleSampleReportRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleSampleReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleSampleReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleSampleReportRequest proto.InternalMessageInfo

// Contains instance payload for 'samplereport' template. This is passed to infrastructure backends during request-time
// through HandleSampleReportService.HandleSampleReport.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name       string                    `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	Value      *v1beta1.Value            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions map[string]*v1beta1.Value `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b05e7600bf31d60, []int{1}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceMsg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'samplereport' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	Value      v1beta1.ValueType            `protobuf:"varint,1,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType" json:"value,omitempty"`
	Dimensions map[string]v1beta1.ValueType `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b05e7600bf31d60, []int{2}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

// Represents instance configuration schema for 'samplereport' template.
type InstanceParam struct {
	Value      string            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions map[string]string `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_4b05e7600bf31d60, []int{3}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceParam.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleSampleReportRequest)(nil), "samplereport.HandleSampleReportRequest")
	proto.RegisterType((*InstanceMsg)(nil), "samplereport.InstanceMsg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "samplereport.InstanceMsg.DimensionsEntry")
	proto.RegisterType((*Type)(nil), "samplereport.Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "samplereport.Type.DimensionsEntry")
	proto.RegisterType((*InstanceParam)(nil), "samplereport.InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "samplereport.InstanceParam.DimensionsEntry")
}

func init() {
	proto.RegisterFile("mixer/test/spyAdapter/template/report/reporttmpl_handler_service.proto", fileDescriptor_4b05e7600bf31d60)
}

var fileDescriptor_4b05e7600bf31d60 = []byte{
	// 616 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x94, 0x4f, 0x6b, 0xd4, 0x4e,
	0x18, 0xc7, 0x33, 0x69, 0x7f, 0x3f, 0xdd, 0xa9, 0xad, 0x32, 0xac, 0x90, 0x5d, 0x61, 0x5a, 0xf6,
	0xe2, 0x8a, 0x32, 0xa1, 0x2b, 0x45, 0x51, 0x3c, 0xb4, 0xfe, 0xc1, 0x22, 0x42, 0x49, 0xc5, 0x83,
	0x07, 0x97, 0xe9, 0x66, 0x1a, 0x83, 0x49, 0x26, 0x66, 0x66, 0x4b, 0x73, 0x13, 0xaf, 0x5e, 0x84,
	0xbe, 0x09, 0x0f, 0x82, 0x78, 0xf7, 0x05, 0x14, 0x4f, 0xc5, 0x53, 0x2f, 0x82, 0x9b, 0xf6, 0xe0,
	0xb1, 0x47, 0x4f, 0x22, 0x3b, 0x99, 0xec, 0x66, 0xeb, 0x76, 0xd9, 0x53, 0xf2, 0xf0, 0x7c, 0x67,
	0x9e, 0xef, 0xe7, 0x19, 0x9e, 0x07, 0x3e, 0x0a, 0xfd, 0x5d, 0x96, 0xd8, 0x92, 0x09, 0x69, 0x8b,
	0x38, 0x5d, 0x75, 0x69, 0x2c, 0x55, 0x1c, 0xc6, 0x01, 0x95, 0xcc, 0x4e, 0x58, 0xcc, 0x13, 0xa9,
	0x3f, 0x32, 0x8c, 0x83, 0xf6, 0x2b, 0x1a, 0xb9, 0x01, 0x4b, 0xda, 0x82, 0x25, 0x3b, 0x7e, 0x87,
	0x91, 0x38, 0xe1, 0x92, 0xa3, 0x0b, 0x82, 0x86, 0x71, 0xc0, 0x72, 0x5d, 0xbd, 0xea, 0x71, 0x8f,
	0xab, 0x84, 0xdd, 0xff, 0xcb, 0x35, 0xf5, 0x1b, 0x79, 0x2d, 0xaa, 0x6b, 0x84, 0xdc, 0x65, 0x81,
	0xbd, 0xb3, 0xbc, 0xc5, 0x24, 0x5d, 0xb6, 0xd9, 0xae, 0x64, 0x91, 0xf0, 0x79, 0x24, 0xb4, 0xba,
	0xe6, 0x71, 0xee, 0x05, 0xcc, 0x56, 0xd1, 0x56, 0x77, 0xdb, 0xa6, 0x51, 0xaa, 0x53, 0xcd, 0x49,
	0x17, 0xe5, 0x16, 0xb4, 0x72, 0x31, 0xe6, 0x81, 0xdf, 0x49, 0x07, 0xc9, 0x1d, 0x1a, 0x74, 0x59,
	0x5b, 0xa6, 0x31, 0x2b, 0xaa, 0x9c, 0x12, 0x0c, 0x53, 0x8d, 0x4f, 0x00, 0xd6, 0x1e, 0x2b, 0xd8,
	0x4d, 0xc5, 0xe6, 0xa8, 0x8b, 0x1d, 0xf6, 0xa6, 0xcb, 0x84, 0x44, 0xb7, 0x60, 0xc5, 0x8f, 0x84,
	0xa4, 0x51, 0x87, 0x09, 0x0b, 0x2c, 0xcd, 0x34, 0xe7, 0x5a, 0x35, 0x52, 0x6e, 0x02, 0x59, 0xd7,
	0xe9, 0xa7, 0xc2, 0x73, 0x86, 0x5a, 0x74, 0x17, 0x2e, 0x68, 0xe3, 0xed, 0x0e, 0x8f, 0xb6, 0x7d,
	0xcf, 0x32, 0x97, 0x40, 0x73, 0xae, 0x55, 0x25, 0x39, 0x30, 0x29, 0x80, 0xc9, 0x6a, 0x94, 0x3a,
	0xf3, 0x5a, 0x7b, 0x5f, 0x49, 0x51, 0x0d, 0x9e, 0x77, 0x99, 0xdb, 0x8d, 0xdb, 0xbe, 0x6b, 0xcd,
	0x2c, 0x81, 0x66, 0xc5, 0x39, 0xa7, 0xe2, 0x75, 0xb7, 0xf1, 0x07, 0xc0, 0xb9, 0x52, 0x49, 0x74,
	0x19, 0xce, 0x46, 0x34, 0x64, 0xd6, 0xe7, 0x6f, 0x5f, 0x1b, 0x4a, 0xa9, 0x42, 0xb4, 0x0c, 0xff,
	0x53, 0x4d, 0xb0, 0x80, 0xaa, 0x7a, 0x85, 0xf8, 0x42, 0xfa, 0x9c, 0xe4, 0x6d, 0x20, 0xba, 0x0d,
	0xe4, 0x79, 0x5f, 0xe2, 0xe4, 0x4a, 0xb4, 0x0e, 0xa1, 0xeb, 0x87, 0xfa, 0x75, 0x2c, 0x53, 0xb1,
	0x5e, 0x3b, 0x93, 0x95, 0x3c, 0x18, 0x68, 0x1f, 0x46, 0x32, 0x49, 0x9d, 0xd2, 0xe1, 0xfa, 0x0b,
	0x78, 0xf1, 0x54, 0x1a, 0x5d, 0x82, 0x33, 0xaf, 0x59, 0xaa, 0xec, 0x54, 0x9c, 0xfe, 0xef, 0xd0,
	0xa2, 0x39, 0xad, 0xc5, 0x3b, 0xe6, 0x6d, 0xd0, 0xe8, 0x01, 0x38, 0xfb, 0x2c, 0x8d, 0x19, 0x5a,
	0x29, 0x23, 0x2e, 0xb4, 0x16, 0x27, 0x9c, 0xef, 0xeb, 0x0b, 0xcc, 0xb5, 0x31, 0x98, 0x8d, 0x51,
	0xcc, 0xbe, 0x7c, 0x22, 0xdf, 0xcb, 0x69, 0xf8, 0x56, 0xca, 0x7c, 0x53, 0xfb, 0x53, 0x8c, 0x5f,
	0x00, 0x9c, 0x2f, 0x7a, 0xbd, 0x41, 0x13, 0x1a, 0xa2, 0x6a, 0x19, 0xb6, 0x52, 0xb0, 0x3c, 0x19,
	0xc3, 0x72, 0x7d, 0xfc, 0x93, 0xa9, 0x6b, 0x26, 0x42, 0xdd, 0x9b, 0x06, 0xaa, 0x5a, 0x86, 0xaa,
	0x94, 0x3c, 0xb7, 0xde, 0x8f, 0x9d, 0xa3, 0xcd, 0x7c, 0x7d, 0xa0, 0x08, 0xa2, 0x7f, 0x93, 0xe8,
	0xea, 0xa8, 0xd7, 0x33, 0xc7, 0xb0, 0x6e, 0xeb, 0xe6, 0xa9, 0x8d, 0x40, 0xf4, 0xb0, 0x10, 0xb5,
	0x11, 0x06, 0x9d, 0x2c, 0x4e, 0x88, 0x6e, 0x20, 0xd7, 0x36, 0xf6, 0x7b, 0xd8, 0x38, 0xe8, 0x61,
	0xe3, 0xb0, 0x87, 0x8d, 0x93, 0x1e, 0x36, 0xde, 0x66, 0x18, 0x7c, 0xcc, 0xb0, 0xb1, 0x9f, 0x61,
	0x70, 0x90, 0x61, 0xf0, 0x33, 0xc3, 0xe0, 0x57, 0x86, 0x8d, 0x93, 0x0c, 0x83, 0x0f, 0x47, 0xd8,
	0x38, 0x38, 0xc2, 0xc6, 0xe1, 0x11, 0x36, 0x7e, 0x7f, 0x3f, 0xde, 0x33, 0xc1, 0xbb, 0x1f, 0xc7,
	0x7b, 0xe6, 0xc8, 0xb2, 0xdb, 0xfa, 0x5f, 0x0d, 0xec, 0xcd, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff,
	0x88, 0xd0, 0x44, 0xe8, 0x4b, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleSampleReportServiceClient is the client API for HandleSampleReportService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleSampleReportServiceClient interface {
	// HandleSampleReport is called by Mixer at request-time to deliver 'samplereport' instances to the backend.
	HandleSampleReport(ctx context.Context, in *HandleSampleReportRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error)
}

type handleSampleReportServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleSampleReportServiceClient(cc *grpc.ClientConn) HandleSampleReportServiceClient {
	return &handleSampleReportServiceClient{cc}
}

func (c *handleSampleReportServiceClient) HandleSampleReport(ctx context.Context, in *HandleSampleReportRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error) {
	out := new(v1beta11.ReportResult)
	err := c.cc.Invoke(ctx, "/samplereport.HandleSampleReportService/HandleSampleReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleSampleReportServiceServer is the server API for HandleSampleReportService service.
type HandleSampleReportServiceServer interface {
	// HandleSampleReport is called by Mixer at request-time to deliver 'samplereport' instances to the backend.
	HandleSampleReport(context.Context, *HandleSampleReportRequest) (*v1beta11.ReportResult, error)
}

// UnimplementedHandleSampleReportServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHandleSampleReportServiceServer struct {
}

func (*UnimplementedHandleSampleReportServiceServer) HandleSampleReport(ctx context.Context, req *HandleSampleReportRequest) (*v1beta11.ReportResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleSampleReport not implemented")
}

func RegisterHandleSampleReportServiceServer(s *grpc.Server, srv HandleSampleReportServiceServer) {
	s.RegisterService(&_HandleSampleReportService_serviceDesc, srv)
}

func _HandleSampleReportService_HandleSampleReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleSampleReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleSampleReportServiceServer).HandleSampleReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/samplereport.HandleSampleReportService/HandleSampleReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleSampleReportServiceServer).HandleSampleReport(ctx, req.(*HandleSampleReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleSampleReportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "samplereport.HandleSampleReportService",
	HandlerType: (*HandleSampleReportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleSampleReport",
			Handler:    _HandleSampleReportService_HandleSampleReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/test/spyAdapter/template/report/reporttmpl_handler_service.proto",
}

func (m *HandleSampleReportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleSampleReportRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleSampleReportRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DedupId) > 0 {
		i -= len(m.DedupId)
		copy(dAtA[i:], m.DedupId)
		i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AdapterConfig != nil {
		{
			size, err := m.AdapterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Instances) > 0 {
		for iNdEx := len(m.Instances) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Instances[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x93
		i--
		dAtA[i] = 0xe4
		i--
		dAtA[i] = 0xd2
		i--
		dAtA[i] = 0xfa
	}
	if len(m.Dimensions) > 0 {
		for k := range m.Dimensions {
			v := m.Dimensions[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Dimensions) > 0 {
		for k := range m.Dimensions {
			v := m.Dimensions[k]
			baseI := i
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != 0 {
		i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Dimensions) > 0 {
		for k := range m.Dimensions {
			v := m.Dimensions[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintReporttmplHandlerService(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintReporttmplHandlerService(dAtA []byte, offset int, v uint64) int {
	offset -= sovReporttmplHandlerService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HandleSampleReportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovReporttmplHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovReporttmplHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovReporttmplHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovReporttmplHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReporttmplHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReporttmplHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReporttmplHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovReporttmplHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovReporttmplHandlerService(uint64(m.Value))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReporttmplHandlerService(uint64(len(k))) + 1 + sovReporttmplHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReporttmplHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovReporttmplHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReporttmplHandlerService(uint64(len(k))) + 1 + len(v) + sovReporttmplHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReporttmplHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func sovReporttmplHandlerService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozReporttmplHandlerService(x uint64) (n int) {
	return sovReporttmplHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleSampleReportRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInstances := "[]*InstanceMsg{"
	for _, f := range this.Instances {
		repeatedStringForInstances += strings.Replace(f.String(), "InstanceMsg", "InstanceMsg", 1) + ","
	}
	repeatedStringForInstances += "}"
	s := strings.Join([]string{`&HandleSampleReportRequest{`,
		`Instances:` + repeatedStringForInstances + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]*v1beta1.Value{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`Value:` + strings.Replace(fmt.Sprintf("%v", this.Value), "Value", "v1beta1.Value", 1) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]v1beta1.ValueType{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&Type{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]string{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringReporttmplHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleSampleReportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReporttmplHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleSampleReportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleSampleReportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReporttmplHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &v1beta1.Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReporttmplHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReporttmplHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= v1beta1.ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReporttmplHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReporttmplHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReporttmplHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReporttmplHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReporttmplHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReporttmplHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReporttmplHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipReporttmplHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowReporttmplHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReporttmplHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthReporttmplHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthReporttmplHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowReporttmplHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipReporttmplHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthReporttmplHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthReporttmplHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowReporttmplHandlerService   = fmt.Errorf("proto: integer overflow")
)
