// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/stackdriver/config/config.proto

// The `stackdriver` adapter enables Istio to deliver log, metric and traces to the
// [Stackdriver](https://cloud.google.com/stackdriver/) backend.
//
// This adapter supports the [metric template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/metric/),
// the [logentry template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/logentry/),
// and the [tracespan template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/tracespan/).

package config

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	metric "google.golang.org/genproto/googleapis/api/metric"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration format for the `stackdriver` adapter.
type Params struct {
	// Endpoint URL to send stackdriver data - leave empty to use the
	// StackDriver SDK's default value (monitoring.googleapis.com).
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// GCP Project to attach metrics to.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// This adapter batches the data it sends to Stackdriver; we will push to stackdriver every push_interval.
	// If no value is provided we default to once per minute.
	PushInterval time.Duration `protobuf:"bytes,3,opt,name=push_interval,json=pushInterval,proto3,stdduration" json:"push_interval"`
	// Credentials must be attached to every call made to StackDriver. This
	// can be an API key, a service account secret key, or Oauth2 tokens.
	//
	// TODO: do we want to support oauth?
	//
	// Types that are valid to be assigned to Creds:
	//	*Params_AppCredentials
	//	*Params_ApiKey
	//	*Params_ServiceAccountPath
	Creds isParams_Creds `protobuf_oneof:"creds"`
	// A map of Istio metric name to Stackdriver metric info.
	MetricInfo map[string]*Params_MetricInfo `protobuf:"bytes,8,rep,name=metric_info,json=metricInfo,proto3" json:"metric_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A map of Istio LogEntry name to Stackdriver log info.
	LogInfo map[string]*Params_LogInfo `protobuf:"bytes,9,rep,name=log_info,json=logInfo,proto3" json:"log_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Stackdriver Trace configuration.
	Trace *Params_Trace `protobuf:"bytes,10,opt,name=trace,proto3" json:"trace,omitempty"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

type isParams_Creds interface {
	isParams_Creds()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Params_AppCredentials struct {
	AppCredentials bool `protobuf:"varint,4,opt,name=app_credentials,json=appCredentials,proto3,oneof"`
}
type Params_ApiKey struct {
	ApiKey string `protobuf:"bytes,5,opt,name=api_key,json=apiKey,proto3,oneof"`
}
type Params_ServiceAccountPath struct {
	ServiceAccountPath string `protobuf:"bytes,6,opt,name=service_account_path,json=serviceAccountPath,proto3,oneof"`
}

func (*Params_AppCredentials) isParams_Creds()     {}
func (*Params_ApiKey) isParams_Creds()             {}
func (*Params_ServiceAccountPath) isParams_Creds() {}

func (m *Params) GetCreds() isParams_Creds {
	if m != nil {
		return m.Creds
	}
	return nil
}

func (m *Params) GetAppCredentials() bool {
	if x, ok := m.GetCreds().(*Params_AppCredentials); ok {
		return x.AppCredentials
	}
	return false
}

func (m *Params) GetApiKey() string {
	if x, ok := m.GetCreds().(*Params_ApiKey); ok {
		return x.ApiKey
	}
	return ""
}

func (m *Params) GetServiceAccountPath() string {
	if x, ok := m.GetCreds().(*Params_ServiceAccountPath); ok {
		return x.ServiceAccountPath
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Params) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Params_OneofMarshaler, _Params_OneofUnmarshaler, _Params_OneofSizer, []interface{}{
		(*Params_AppCredentials)(nil),
		(*Params_ApiKey)(nil),
		(*Params_ServiceAccountPath)(nil),
	}
}

func _Params_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Params)
	// creds
	switch x := m.Creds.(type) {
	case *Params_AppCredentials:
		t := uint64(0)
		if x.AppCredentials {
			t = 1
		}
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Params_ApiKey:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ApiKey)
	case *Params_ServiceAccountPath:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ServiceAccountPath)
	case nil:
	default:
		return fmt.Errorf("Params.Creds has unexpected type %T", x)
	}
	return nil
}

func _Params_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Params)
	switch tag {
	case 4: // creds.app_credentials
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Creds = &Params_AppCredentials{x != 0}
		return true, err
	case 5: // creds.api_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Creds = &Params_ApiKey{x}
		return true, err
	case 6: // creds.service_account_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Creds = &Params_ServiceAccountPath{x}
		return true, err
	default:
		return false, nil
	}
}

func _Params_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Params)
	// creds
	switch x := m.Creds.(type) {
	case *Params_AppCredentials:
		n += 1 // tag and wire
		n += 1
	case *Params_ApiKey:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ApiKey)))
		n += len(x.ApiKey)
	case *Params_ServiceAccountPath:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ServiceAccountPath)))
		n += len(x.ServiceAccountPath)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes how to represent an Istio metric in Stackdriver.
// See https://github.com/googleapis/googleapis/blob/master/google/api/metric.proto
type Params_MetricInfo struct {
	// The kind of measurement for a metric, which describes how the data is reported. Ex: Gauge.
	Kind metric.MetricDescriptor_MetricKind `protobuf:"varint,1,opt,name=kind,proto3,enum=google.api.MetricDescriptor_MetricKind" json:"kind,omitempty"`
	// The type of the metric's value. Ex: Distribution.
	Value metric.MetricDescriptor_ValueType `protobuf:"varint,2,opt,name=value,proto3,enum=google.api.MetricDescriptor_ValueType" json:"value,omitempty"`
	// For metrics with a metric value of DISTRIBUTION, this provides a mechanism
	// for configuring the buckets that will be used to store the aggregated values.
	// This field must be provided for metrics declared to be of type DISTRIBUTION.
	// This field will be ignored for non-distribution metric kinds.
	Buckets *Params_MetricInfo_BucketsDefinition `protobuf:"bytes,3,opt,name=buckets,proto3" json:"buckets,omitempty"`
	// Stackdriver metric type name, e.g.
	// istio.io/service/server/request_count. If this is not provided, a
	// concantenation of custom metric prefix (custom.googleapis.com/) and
	// Istio metric name will be used.
	MetricType string `protobuf:"bytes,4,opt,name=metric_type,json=metricType,proto3" json:"metric_type,omitempty"`
}

func (m *Params_MetricInfo) Reset()      { *m = Params_MetricInfo{} }
func (*Params_MetricInfo) ProtoMessage() {}
func (*Params_MetricInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 0}
}
func (m *Params_MetricInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricInfo.Merge(m, src)
}
func (m *Params_MetricInfo) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricInfo proto.InternalMessageInfo

// Describes buckets for DISTRIBUTION valued metrics.
// TODO: look into using google.api.distribution.proto instead - we would pull it in but it has a ton of
// dependencies it doesn't actually use.
type Params_MetricInfo_BucketsDefinition struct {
	// Exactly one of these three fields must be set.
	//
	// Types that are valid to be assigned to Definition:
	//	*Params_MetricInfo_BucketsDefinition_LinearBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExponentialBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExplicitBuckets
	Definition isParams_MetricInfo_BucketsDefinition_Definition `protobuf_oneof:"definition"`
}

func (m *Params_MetricInfo_BucketsDefinition) Reset()      { *m = Params_MetricInfo_BucketsDefinition{} }
func (*Params_MetricInfo_BucketsDefinition) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 0, 0}
}
func (m *Params_MetricInfo_BucketsDefinition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricInfo_BucketsDefinition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricInfo_BucketsDefinition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricInfo_BucketsDefinition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition.Merge(m, src)
}
func (m *Params_MetricInfo_BucketsDefinition) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricInfo_BucketsDefinition) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricInfo_BucketsDefinition proto.InternalMessageInfo

type isParams_MetricInfo_BucketsDefinition_Definition interface {
	isParams_MetricInfo_BucketsDefinition_Definition()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Params_MetricInfo_BucketsDefinition_LinearBuckets struct {
	LinearBuckets *Params_MetricInfo_BucketsDefinition_Linear `protobuf:"bytes,1,opt,name=linear_buckets,json=linearBuckets,proto3,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExponentialBuckets struct {
	ExponentialBuckets *Params_MetricInfo_BucketsDefinition_Exponential `protobuf:"bytes,2,opt,name=exponential_buckets,json=exponentialBuckets,proto3,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExplicitBuckets struct {
	ExplicitBuckets *Params_MetricInfo_BucketsDefinition_Explicit `protobuf:"bytes,3,opt,name=explicit_buckets,json=explicitBuckets,proto3,oneof"`
}

func (*Params_MetricInfo_BucketsDefinition_LinearBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExponentialBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExplicitBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}

func (m *Params_MetricInfo_BucketsDefinition) GetDefinition() isParams_MetricInfo_BucketsDefinition_Definition {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetLinearBuckets() *Params_MetricInfo_BucketsDefinition_Linear {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_LinearBuckets); ok {
		return x.LinearBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExponentialBuckets() *Params_MetricInfo_BucketsDefinition_Exponential {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets); ok {
		return x.ExponentialBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExplicitBuckets() *Params_MetricInfo_BucketsDefinition_Explicit {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets); ok {
		return x.ExplicitBuckets
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Params_MetricInfo_BucketsDefinition) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Params_MetricInfo_BucketsDefinition_OneofMarshaler, _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler, _Params_MetricInfo_BucketsDefinition_OneofSizer, []interface{}{
		(*Params_MetricInfo_BucketsDefinition_LinearBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets)(nil),
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LinearBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExponentialBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExplicitBuckets); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Params_MetricInfo_BucketsDefinition.Definition has unexpected type %T", x)
	}
	return nil
}

func _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	switch tag {
	case 1: // definition.linear_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Linear)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{msg}
		return true, err
	case 2: // definition.exponential_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Exponential)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{msg}
		return true, err
	case 3: // definition.explicit_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Explicit)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		s := proto.Size(x.LinearBuckets)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		s := proto.Size(x.ExponentialBuckets)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		s := proto.Size(x.ExplicitBuckets)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a linear sequence of buckets that all have the same width
// (except overflow and underflow). Each bucket represents a constant
// absolute uncertainty on the specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (`0 <= i < N-1`): `offset + (width * i)`
// * Lower bound (`1 <= i < N`): `offset + (width * (i - 1))`
type Params_MetricInfo_BucketsDefinition_Linear struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 0.
	Width float64 `protobuf:"fixed64,2,opt,name=width,proto3" json:"width,omitempty"`
	// Lower bound of the first bucket.
	Offset float64 `protobuf:"fixed64,3,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Linear{}
}
func (*Params_MetricInfo_BucketsDefinition_Linear) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Linear) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 0, 0, 0}
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Linear.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Linear.Merge(m, src)
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Linear.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Linear proto.InternalMessageInfo

// Specifies an exponential sequence of buckets that have a width that is
// proportional to the value of the lower bound. Each bucket represents a
// constant relative uncertainty on a specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (0 <= i < N-1): `scale * (growth_factor ^ i)`
// * Lower bound (1 <= i < N): `scale * (growth_factor ^ (i - 1))`
type Params_MetricInfo_BucketsDefinition_Exponential struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 1.
	GrowthFactor float64 `protobuf:"fixed64,2,opt,name=growth_factor,json=growthFactor,proto3" json:"growth_factor,omitempty"`
	// Must be greater than 0.
	Scale float64 `protobuf:"fixed64,3,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Exponential{}
}
func (*Params_MetricInfo_BucketsDefinition_Exponential) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Exponential) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 0, 0, 1}
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Exponential.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Exponential.Merge(m, src)
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Exponential.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Exponential proto.InternalMessageInfo

// Specifies a set of buckets with arbitrary widths.
//
// There are `size(bounds) + 1` (= `N`) buckets. Bucket `i` has the following
// boundaries:
//
// * Upper bound (`0 <= i < N-1`): `bounds[i]`
// * Lower bound (`1 <= i < N`): `bounds[i - 1]`
//
// The `bounds` field must contain at least one element. If `bounds` has
// only one element, then there are no finite buckets, and that single
// element is the common boundary of the overflow and underflow buckets.
type Params_MetricInfo_BucketsDefinition_Explicit struct {
	// The values must be monotonically increasing.
	Bounds []float64 `protobuf:"fixed64,1,rep,packed,name=bounds,proto3" json:"bounds,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Explicit{}
}
func (*Params_MetricInfo_BucketsDefinition_Explicit) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Explicit) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 0, 0, 2}
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Explicit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Explicit.Merge(m, src)
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) XXX_Size() int {
	return m.Size()
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Explicit.DiscardUnknown(m)
}

var xxx_messageInfo_Params_MetricInfo_BucketsDefinition_Explicit proto.InternalMessageInfo

// Describes how to represent an Istio Log in Stackdriver.
type Params_LogInfo struct {
	// The logging template provides a set of variables; these list the subset of variables that should be used to
	// form Stackdriver labels for the log entry.
	LabelNames []string `protobuf:"bytes,1,rep,name=label_names,json=labelNames,proto3" json:"label_names,omitempty"`
	// A golang text/template template that will be executed to construct the payload for this log entry.
	// It will be given the full set of variables for the log to use to construct its result.
	PayloadTemplate string `protobuf:"bytes,2,opt,name=payload_template,json=payloadTemplate,proto3" json:"payload_template,omitempty"`
	// If an HttpRequestMapping is provided, a HttpRequest object will be filled out for this log entry using the
	// variables named in the mapping to populate the fields of the request struct from the instance's variables.
	HttpMapping *Params_LogInfo_HttpRequestMapping `protobuf:"bytes,3,opt,name=http_mapping,json=httpMapping,proto3" json:"http_mapping,omitempty"`
	// If SinkInfo is provided, Stackriver logs would be exported to that sink.
	SinkInfo *Params_LogInfo_SinkInfo `protobuf:"bytes,4,opt,name=sink_info,json=sinkInfo,proto3" json:"sink_info,omitempty"`
}

func (m *Params_LogInfo) Reset()      { *m = Params_LogInfo{} }
func (*Params_LogInfo) ProtoMessage() {}
func (*Params_LogInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 2}
}
func (m *Params_LogInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_LogInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_LogInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_LogInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_LogInfo.Merge(m, src)
}
func (m *Params_LogInfo) XXX_Size() int {
	return m.Size()
}
func (m *Params_LogInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_LogInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Params_LogInfo proto.InternalMessageInfo

// Maps from template variable names to the various fields of Stackdriver's HTTP request struct.
// See https://godoc.org/cloud.google.com/go/logging#HTTPRequest
type Params_LogInfo_HttpRequestMapping struct {
	// template variable name to map into HTTPRequest.Status
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// template variable name to map into HTTPRequest.RequestSize
	RequestSize string `protobuf:"bytes,2,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// template variable name to map into HTTPRequest.ResponseSize
	ResponseSize string `protobuf:"bytes,3,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// template variable name to map into HTTPRequest.Latency
	Latency string `protobuf:"bytes,4,opt,name=latency,proto3" json:"latency,omitempty"`
	// template variable name to map into HTTPRequest.LocalIP
	LocalIp string `protobuf:"bytes,5,opt,name=local_ip,json=localIp,proto3" json:"local_ip,omitempty"`
	// template variable name to map into HTTPRequest.RemoteIP
	RemoteIp string `protobuf:"bytes,6,opt,name=remote_ip,json=remoteIp,proto3" json:"remote_ip,omitempty"`
	// template variable name to map into HTTPRequest.Request.Url
	Url string `protobuf:"bytes,7,opt,name=url,proto3" json:"url,omitempty"`
	// template variable name to map into HTTPRequest.RequestMethod
	Method string `protobuf:"bytes,8,opt,name=method,proto3" json:"method,omitempty"`
	// template variable name to map into HTTPRequest.UserAgent
	UserAgent string `protobuf:"bytes,9,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// template variable name to map into HTTPRequest.Referer
	Referer string `protobuf:"bytes,10,opt,name=referer,proto3" json:"referer,omitempty"`
}

func (m *Params_LogInfo_HttpRequestMapping) Reset()      { *m = Params_LogInfo_HttpRequestMapping{} }
func (*Params_LogInfo_HttpRequestMapping) ProtoMessage() {}
func (*Params_LogInfo_HttpRequestMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 2, 0}
}
func (m *Params_LogInfo_HttpRequestMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_LogInfo_HttpRequestMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_LogInfo_HttpRequestMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_LogInfo_HttpRequestMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_LogInfo_HttpRequestMapping.Merge(m, src)
}
func (m *Params_LogInfo_HttpRequestMapping) XXX_Size() int {
	return m.Size()
}
func (m *Params_LogInfo_HttpRequestMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_LogInfo_HttpRequestMapping.DiscardUnknown(m)
}

var xxx_messageInfo_Params_LogInfo_HttpRequestMapping proto.InternalMessageInfo

// Contains information about sink to export Stackdriver logs to.
// See https://godoc.org/cloud.google.com/go/logging/logadmin#Sink.
// Ex: If you want to export it to a GCS bucket, id would be a unique idetifier you want for the sink,
// destination would be the storage be name of GCS Storage bucket and filter would be user defined condition for
// filtering logs. See below for a sample config:
//      id: 'info-errors-to-gcs'
//      destination: 'storage.googleapis.com/<bucket_name>'
//      filter: 'severity >= Default'
type Params_LogInfo_SinkInfo struct {
	// Client assigned sink identifier.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Export Destination.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Filter that specifies any filtering to be done on logs.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Determines the kind of IAM identity returned as WriterIdentity in the new
	// sink. If this value is omitted or set to false, and if the sink's parent is a
	// project, then the value returned as WriterIdentity is the same group or
	// service account used by Stackdriver Logging before the addition of writer
	// identities to the API. The sink's destination must be in the same project as
	// the sink itself.
	//
	// If this field is set to true, or if the sink is owned by a non-project
	// resource such as an organization, then the value of WriterIdentity will
	// be a unique service account used only for exports from the new sink.
	UniqueWriterIdentity bool `protobuf:"varint,4,opt,name=UniqueWriterIdentity,proto3" json:"UniqueWriterIdentity,omitempty"`
	// These fields apply only to UpdateSinkOpt calls. The corresponding sink field
	// is updated if and only if the Update field is true.
	// Upate sink destination.
	UpdateDestination bool `protobuf:"varint,5,opt,name=UpdateDestination,proto3" json:"UpdateDestination,omitempty"`
	// Update sink filter.
	UpdateFilter bool `protobuf:"varint,6,opt,name=UpdateFilter,proto3" json:"UpdateFilter,omitempty"`
	// Update includes children.
	UpdateIncludeChildren bool `protobuf:"varint,7,opt,name=UpdateIncludeChildren,proto3" json:"UpdateIncludeChildren,omitempty"`
}

func (m *Params_LogInfo_SinkInfo) Reset()      { *m = Params_LogInfo_SinkInfo{} }
func (*Params_LogInfo_SinkInfo) ProtoMessage() {}
func (*Params_LogInfo_SinkInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 2, 1}
}
func (m *Params_LogInfo_SinkInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_LogInfo_SinkInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_LogInfo_SinkInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_LogInfo_SinkInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_LogInfo_SinkInfo.Merge(m, src)
}
func (m *Params_LogInfo_SinkInfo) XXX_Size() int {
	return m.Size()
}
func (m *Params_LogInfo_SinkInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_LogInfo_SinkInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Params_LogInfo_SinkInfo proto.InternalMessageInfo

// Details of Stackdriver Trace configuration for tracespan template.
type Params_Trace struct {
	// Proability that a particular trace ID will be sampled.
	SampleProbability float64 `protobuf:"fixed64,1,opt,name=sample_probability,json=sampleProbability,proto3" json:"sample_probability,omitempty"`
}

func (m *Params_Trace) Reset()      { *m = Params_Trace{} }
func (*Params_Trace) ProtoMessage() {}
func (*Params_Trace) Descriptor() ([]byte, []int) {
	return fileDescriptor_94f37849817efbb2, []int{0, 4}
}
func (m *Params_Trace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params_Trace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params_Trace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params_Trace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params_Trace.Merge(m, src)
}
func (m *Params_Trace) XXX_Size() int {
	return m.Size()
}
func (m *Params_Trace) XXX_DiscardUnknown() {
	xxx_messageInfo_Params_Trace.DiscardUnknown(m)
}

var xxx_messageInfo_Params_Trace proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Params)(nil), "adapter.stackdriver.config.Params")
	proto.RegisterMapType((map[string]*Params_LogInfo)(nil), "adapter.stackdriver.config.Params.LogInfoEntry")
	proto.RegisterMapType((map[string]*Params_MetricInfo)(nil), "adapter.stackdriver.config.Params.MetricInfoEntry")
	proto.RegisterType((*Params_MetricInfo)(nil), "adapter.stackdriver.config.Params.MetricInfo")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Linear)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Linear")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Exponential)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Exponential")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Explicit)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Explicit")
	proto.RegisterType((*Params_LogInfo)(nil), "adapter.stackdriver.config.Params.LogInfo")
	proto.RegisterType((*Params_LogInfo_HttpRequestMapping)(nil), "adapter.stackdriver.config.Params.LogInfo.HttpRequestMapping")
	proto.RegisterType((*Params_LogInfo_SinkInfo)(nil), "adapter.stackdriver.config.Params.LogInfo.SinkInfo")
	proto.RegisterType((*Params_Trace)(nil), "adapter.stackdriver.config.Params.Trace")
}

func init() {
	proto.RegisterFile("mixer/adapter/stackdriver/config/config.proto", fileDescriptor_94f37849817efbb2)
}

var fileDescriptor_94f37849817efbb2 = []byte{
	// 1223 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcd, 0x73, 0x14, 0x45,
	0x14, 0x9f, 0x49, 0xd8, 0xaf, 0xb7, 0x4b, 0x12, 0x1a, 0xd4, 0x65, 0x2c, 0x87, 0x88, 0x55, 0x1a,
	0x2c, 0xd8, 0xad, 0x0a, 0x96, 0x65, 0xf9, 0x09, 0x21, 0xa4, 0xb2, 0x02, 0x56, 0x6a, 0x00, 0x2d,
	0xbd, 0x8c, 0xbd, 0x33, 0xbd, 0xbb, 0x6d, 0x66, 0xbb, 0x9b, 0x9e, 0x9e, 0xc0, 0x72, 0xb0, 0xbc,
	0x7b, 0xc1, 0x9b, 0x7f, 0x82, 0xfe, 0x27, 0x39, 0x72, 0xe4, 0x84, 0x66, 0xb9, 0x78, 0xe4, 0x4f,
	0xb0, 0xfa, 0x63, 0x92, 0x8d, 0xa0, 0x95, 0x14, 0x9e, 0x76, 0xde, 0xef, 0x7d, 0xf6, 0xaf, 0x5f,
	0xbf, 0xb7, 0x70, 0x69, 0x4c, 0x1f, 0x10, 0xd9, 0xc5, 0x29, 0x16, 0x8a, 0xc8, 0x6e, 0xae, 0x70,
	0xb2, 0x9d, 0x4a, 0xba, 0x43, 0x64, 0x37, 0xe1, 0x6c, 0x40, 0x87, 0xee, 0xa7, 0x23, 0x24, 0x57,
	0x1c, 0x05, 0xce, 0xb0, 0x33, 0x63, 0xd8, 0xb1, 0x16, 0xc1, 0x99, 0x21, 0x1f, 0x72, 0x63, 0xd6,
	0xd5, 0x5f, 0xd6, 0x23, 0x78, 0x63, 0xc8, 0xf9, 0x30, 0x23, 0x5d, 0x2c, 0x68, 0x77, 0x4c, 0x94,
	0xa4, 0x89, 0x53, 0x84, 0x4e, 0x61, 0xa4, 0x7e, 0x31, 0xe8, 0xa6, 0x85, 0xc4, 0x8a, 0x72, 0x66,
	0xf5, 0xe7, 0x9f, 0x9e, 0x86, 0xea, 0x16, 0x96, 0x78, 0x9c, 0xa3, 0x00, 0xea, 0x84, 0xa5, 0x82,
	0x53, 0xa6, 0xda, 0xfe, 0xb2, 0xbf, 0xd2, 0x88, 0xf6, 0x65, 0xf4, 0x16, 0x80, 0x90, 0xfc, 0x07,
	0x92, 0xa8, 0x98, 0xa6, 0xed, 0x39, 0xa3, 0x6d, 0x38, 0xa4, 0x97, 0xa2, 0x4d, 0x38, 0x29, 0x8a,
	0x7c, 0x14, 0x53, 0xa6, 0x88, 0xdc, 0xc1, 0x59, 0x7b, 0x7e, 0xd9, 0x5f, 0x69, 0xae, 0x9e, 0xed,
	0xd8, 0xec, 0x9d, 0x32, 0x7b, 0x67, 0xdd, 0x65, 0x5f, 0xab, 0xef, 0x3e, 0x3d, 0xe7, 0xfd, 0xfa,
	0xc7, 0x39, 0x3f, 0x6a, 0x69, 0xcf, 0x9e, 0x73, 0x44, 0x17, 0x60, 0x11, 0x0b, 0x11, 0x27, 0x92,
	0xa4, 0x84, 0x29, 0x8a, 0xb3, 0xbc, 0x7d, 0x62, 0xd9, 0x5f, 0xa9, 0x6f, 0x7a, 0xd1, 0x02, 0x16,
	0xe2, 0xda, 0x01, 0x8e, 0xce, 0x42, 0x0d, 0x0b, 0x1a, 0x6f, 0x93, 0x49, 0xbb, 0xa2, 0x0b, 0xda,
	0xf4, 0xa2, 0x2a, 0x16, 0xf4, 0x06, 0x99, 0xa0, 0x55, 0x38, 0x93, 0x13, 0xb9, 0x43, 0x13, 0x12,
	0xe3, 0x24, 0xe1, 0x05, 0x53, 0xb1, 0xc0, 0x6a, 0xd4, 0xae, 0x3a, 0x3b, 0xe4, 0xb4, 0x57, 0xad,
	0x72, 0x0b, 0xab, 0x11, 0xba, 0x0d, 0x4d, 0xcb, 0x5c, 0x4c, 0xd9, 0x80, 0xb7, 0xeb, 0xcb, 0xf3,
	0x2b, 0xcd, 0xd5, 0xd5, 0xce, 0xbf, 0x5f, 0x45, 0xc7, 0xf2, 0xd6, 0xb9, 0x65, 0xbc, 0x7a, 0x6c,
	0xc0, 0xaf, 0x33, 0x25, 0x27, 0x11, 0x8c, 0xf7, 0x01, 0xf4, 0x25, 0xd4, 0x33, 0x3e, 0xb4, 0x11,
	0x1b, 0x26, 0x62, 0xf7, 0x08, 0x11, 0x6f, 0xf2, 0xe1, 0x41, 0xb8, 0x5a, 0x66, 0x25, 0xf4, 0x39,
	0x54, 0x94, 0xc4, 0x09, 0x69, 0x83, 0x21, 0x77, 0xe5, 0x08, 0x81, 0xee, 0x68, 0xfb, 0xc8, 0xba,
	0x05, 0xbf, 0xd4, 0x00, 0x0e, 0x6a, 0x45, 0x9f, 0xc0, 0x89, 0x6d, 0xca, 0x52, 0x73, 0xd5, 0x0b,
	0xab, 0xef, 0x95, 0x57, 0x85, 0x05, 0x75, 0x27, 0x5a, 0x27, 0x79, 0x22, 0xa9, 0x50, 0x5c, 0x3a,
	0xe0, 0x06, 0x65, 0x69, 0x64, 0x9c, 0xd0, 0xa7, 0x50, 0xd9, 0xc1, 0x59, 0x41, 0x4c, 0x2b, 0x2c,
	0xac, 0xbe, 0xfb, 0x9f, 0xde, 0x5f, 0x6b, 0xcb, 0x3b, 0x13, 0x41, 0x22, 0xeb, 0x84, 0xbe, 0x85,
	0x5a, 0xbf, 0x48, 0xb6, 0x89, 0xca, 0x5d, 0xa3, 0x7c, 0x71, 0x2c, 0x9a, 0x3b, 0x6b, 0xd6, 0x79,
	0x9d, 0x0c, 0x28, 0xa3, 0xba, 0x9d, 0xa2, 0x32, 0x1e, 0x3a, 0xb7, 0x7f, 0x8b, 0x6a, 0x22, 0x88,
	0xe9, 0x9d, 0x46, 0x79, 0x23, 0xba, 0x84, 0xe0, 0xe7, 0x0a, 0x9c, 0x7a, 0xc1, 0x1f, 0x71, 0x58,
	0xc8, 0x28, 0x23, 0x58, 0xc6, 0x65, 0x61, 0xbe, 0x29, 0x6c, 0xe3, 0x15, 0x0b, 0xeb, 0xdc, 0x34,
	0x51, 0x37, 0xbd, 0xe8, 0xa4, 0x8d, 0xef, 0x2c, 0xd0, 0x8f, 0x70, 0x9a, 0x3c, 0x10, 0x9c, 0xd9,
	0x66, 0xde, 0xcf, 0x3a, 0x67, 0xb2, 0xde, 0x78, 0xd5, 0xac, 0xd7, 0x0f, 0x42, 0xeb, 0x6e, 0x9f,
	0xc9, 0x54, 0xe6, 0x2f, 0x60, 0x89, 0x3c, 0x10, 0x19, 0x4d, 0xa8, 0x8a, 0x0f, 0xdf, 0xc5, 0xe6,
	0xff, 0x90, 0xdc, 0xc4, 0xdd, 0xf4, 0xa2, 0xc5, 0x32, 0x87, 0xb3, 0x0a, 0x52, 0xa8, 0x5a, 0x46,
	0xd0, 0x45, 0x40, 0xac, 0x18, 0xc7, 0xc6, 0x8b, 0x1c, 0x62, 0xbd, 0x12, 0x2d, 0xb1, 0x62, 0xbc,
	0x61, 0x14, 0x65, 0xb9, 0x67, 0xa0, 0x72, 0x9f, 0xa6, 0x6a, 0x64, 0x08, 0xf2, 0x23, 0x2b, 0xa0,
	0xd7, 0xa1, 0xca, 0x07, 0x83, 0x9c, 0x28, 0x53, 0xba, 0x1f, 0x39, 0x29, 0xd8, 0x81, 0xe6, 0x0c,
	0x03, 0xc7, 0x4c, 0xf5, 0x0e, 0x9c, 0x1c, 0x4a, 0x7e, 0x5f, 0x8d, 0xe2, 0x01, 0x4e, 0x14, 0x97,
	0x2e, 0x65, 0xcb, 0x82, 0x1b, 0x06, 0xd3, 0xf5, 0xe4, 0x09, 0xce, 0x88, 0x4b, 0x6c, 0x85, 0xe0,
	0x3c, 0xd4, 0xcb, 0xc3, 0xeb, 0xda, 0xfa, 0xbc, 0x60, 0xa9, 0x4e, 0x34, 0xaf, 0x6b, 0xb3, 0xd2,
	0x5a, 0x0b, 0x20, 0xdd, 0xe7, 0x2a, 0xc8, 0x60, 0xf1, 0x1f, 0xe3, 0x03, 0x2d, 0xc1, 0xbc, 0x1e,
	0x69, 0x76, 0x02, 0xeb, 0x4f, 0x74, 0x6d, 0xf6, 0xb1, 0x35, 0x57, 0x2f, 0x1d, 0xeb, 0x82, 0xdc,
	0x9b, 0xfb, 0x78, 0xee, 0x23, 0x3f, 0xd8, 0xad, 0x42, 0xcd, 0xcd, 0x16, 0xfd, 0x50, 0x32, 0xdc,
	0x27, 0x59, 0xcc, 0xf0, 0x98, 0xd8, 0x22, 0x1b, 0x11, 0x18, 0xe8, 0x2b, 0x8d, 0xa0, 0x0b, 0xb0,
	0x24, 0xf0, 0x24, 0xe3, 0x38, 0x8d, 0x15, 0x19, 0x8b, 0x0c, 0x2b, 0xe2, 0x06, 0xff, 0xa2, 0xc3,
	0xef, 0x38, 0x18, 0x7d, 0x0f, 0xad, 0x91, 0x52, 0x22, 0x1e, 0x63, 0x21, 0x28, 0x1b, 0xba, 0x46,
	0xfa, 0xec, 0xe8, 0x93, 0xae, 0xb3, 0xa9, 0x94, 0x88, 0xc8, 0xbd, 0x82, 0xe4, 0xea, 0x96, 0x0d,
	0x12, 0x35, 0x75, 0x48, 0x27, 0xa0, 0x2d, 0x68, 0xe4, 0x94, 0x6d, 0xdb, 0x41, 0x7a, 0xc2, 0x84,
	0xbf, 0x7c, 0x8c, 0xf0, 0xb7, 0x29, 0xdb, 0x36, 0x64, 0xd4, 0x73, 0xf7, 0x15, 0xfc, 0x3e, 0x07,
	0xe8, 0xc5, 0xac, 0xfa, 0xda, 0x72, 0x85, 0x55, 0x91, 0xbb, 0x0b, 0x70, 0x12, 0x7a, 0x1b, 0x5a,
	0xd2, 0x5a, 0xc6, 0x39, 0x7d, 0x58, 0x32, 0xd1, 0x74, 0xd8, 0x6d, 0xfa, 0x90, 0xe8, 0xc6, 0x91,
	0x24, 0x17, 0x9c, 0xe5, 0xc4, 0xda, 0xcc, 0x1b, 0x9b, 0x56, 0x09, 0x1a, 0xa3, 0x36, 0xd4, 0x34,
	0x65, 0x2c, 0x99, 0xb8, 0xd9, 0x54, 0x8a, 0xe8, 0xac, 0x5e, 0x15, 0x09, 0xce, 0x62, 0x2a, 0xec,
	0x3e, 0xd3, 0x93, 0x3f, 0xc1, 0x59, 0x4f, 0xa0, 0x37, 0xa1, 0x21, 0xc9, 0x98, 0x2b, 0xa2, 0x75,
	0x55, 0xbb, 0x9a, 0x2d, 0xd0, 0x13, 0xba, 0x5f, 0x0a, 0x99, 0xb5, 0x6b, 0xb6, 0x5f, 0x0a, 0x99,
	0xe9, 0x33, 0x8c, 0x89, 0x1a, 0xf1, 0xb4, 0x5d, 0xb7, 0x67, 0xb0, 0x92, 0x5e, 0xe2, 0x45, 0x4e,
	0x64, 0x8c, 0x87, 0x84, 0xa9, 0x76, 0xc3, 0x2e, 0x71, 0x8d, 0x5c, 0xd5, 0x80, 0x2e, 0x4d, 0x92,
	0x01, 0x91, 0x44, 0x9a, 0x0d, 0xd3, 0x88, 0x4a, 0x31, 0x78, 0x34, 0x07, 0xf5, 0x92, 0x42, 0xb4,
	0x00, 0x73, 0x34, 0x75, 0xec, 0xcc, 0xd1, 0x14, 0x2d, 0x43, 0x33, 0x25, 0xb9, 0xa2, 0xcc, 0x2c,
	0xf6, 0x92, 0x98, 0x19, 0x48, 0xd7, 0x33, 0xa0, 0x99, 0x22, 0xd2, 0x31, 0xe2, 0x24, 0xbd, 0xa5,
	0xef, 0x32, 0x7a, 0xaf, 0x20, 0xdf, 0x48, 0xaa, 0x88, 0xec, 0x99, 0xcd, 0xae, 0x2c, 0x31, 0xf5,
	0xe8, 0xa5, 0x3a, 0x74, 0x11, 0x4e, 0xdd, 0x15, 0x29, 0x56, 0x64, 0x7d, 0x26, 0x67, 0xc5, 0x38,
	0xbc, 0xa8, 0x40, 0xe7, 0xa1, 0x65, 0xc1, 0x0d, 0x9b, 0xbf, 0x6a, 0x0c, 0x0f, 0x61, 0xe8, 0x03,
	0x78, 0xcd, 0xca, 0x3d, 0x96, 0x64, 0x45, 0x4a, 0xae, 0x8d, 0x68, 0x96, 0x4a, 0xc2, 0x0c, 0xa3,
	0xf5, 0xe8, 0xe5, 0xca, 0x60, 0x00, 0xad, 0xd9, 0x2d, 0xfd, 0x92, 0x57, 0x7b, 0xe5, 0xf0, 0xab,
	0x7d, 0xff, 0xe8, 0xed, 0x3a, 0xfb, 0x64, 0x3f, 0x84, 0x8a, 0x59, 0xe2, 0xe8, 0x12, 0xa0, 0x1c,
	0x8f, 0x45, 0x46, 0x62, 0x21, 0x79, 0x1f, 0xf7, 0x69, 0xa6, 0xa9, 0xf2, 0xcd, 0xf8, 0x39, 0x65,
	0x35, 0x5b, 0x07, 0x8a, 0xb5, 0x1a, 0x54, 0xf4, 0x7f, 0xa8, 0x7c, 0xed, 0xca, 0xee, 0x5e, 0xe8,
	0x3d, 0xde, 0x0b, 0xbd, 0x27, 0x7b, 0xa1, 0xf7, 0x7c, 0x2f, 0xf4, 0x7e, 0x9a, 0x86, 0xfe, 0x6f,
	0xd3, 0xd0, 0xdb, 0x9d, 0x86, 0xfe, 0xe3, 0x69, 0xe8, 0xff, 0x39, 0x0d, 0xfd, 0xbf, 0xa6, 0xa1,
	0xf7, 0x7c, 0x1a, 0xfa, 0x8f, 0x9e, 0x85, 0xde, 0xe3, 0x67, 0xa1, 0xf7, 0xe4, 0x59, 0xe8, 0x7d,
	0x57, 0xb5, 0xc5, 0xf5, 0xab, 0xe6, 0xdf, 0xdb, 0xe5, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x99,
	0x69, 0xc0, 0xfb, 0xc5, 0x0a, 0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Trace != nil {
		{
			size, err := m.Trace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.LogInfo) > 0 {
		for k := range m.LogInfo {
			v := m.LogInfo[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConfig(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.MetricInfo) > 0 {
		for k := range m.MetricInfo {
			v := m.MetricInfo[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConfig(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.Creds != nil {
		{
			size := m.Creds.Size()
			i -= size
			if _, err := m.Creds.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	n4, err4 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.PushInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushInterval):])
	if err4 != nil {
		return 0, err4
	}
	i -= n4
	i = encodeVarintConfig(dAtA, i, uint64(n4))
	i--
	dAtA[i] = 0x1a
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Params_AppCredentials) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_AppCredentials) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.AppCredentials {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *Params_ApiKey) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_ApiKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.ApiKey)
	copy(dAtA[i:], m.ApiKey)
	i = encodeVarintConfig(dAtA, i, uint64(len(m.ApiKey)))
	i--
	dAtA[i] = 0x2a
	return len(dAtA) - i, nil
}
func (m *Params_ServiceAccountPath) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_ServiceAccountPath) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.ServiceAccountPath)
	copy(dAtA[i:], m.ServiceAccountPath)
	i = encodeVarintConfig(dAtA, i, uint64(len(m.ServiceAccountPath)))
	i--
	dAtA[i] = 0x32
	return len(dAtA) - i, nil
}
func (m *Params_MetricInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MetricType) > 0 {
		i -= len(m.MetricType)
		copy(dAtA[i:], m.MetricType)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MetricType)))
		i--
		dAtA[i] = 0x22
	}
	if m.Buckets != nil {
		{
			size, err := m.Buckets.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Value != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if m.Kind != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Kind))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Params_MetricInfo_BucketsDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricInfo_BucketsDefinition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Definition != nil {
		{
			size := m.Definition.Size()
			i -= size
			if _, err := m.Definition.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LinearBuckets != nil {
		{
			size, err := m.LinearBuckets.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExponentialBuckets != nil {
		{
			size, err := m.ExponentialBuckets.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExplicitBuckets != nil {
		{
			size, err := m.ExplicitBuckets.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Offset != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Offset))))
		i--
		dAtA[i] = 0x19
	}
	if m.Width != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Width))))
		i--
		dAtA[i] = 0x11
	}
	if m.NumFiniteBuckets != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Scale != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Scale))))
		i--
		dAtA[i] = 0x19
	}
	if m.GrowthFactor != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.GrowthFactor))))
		i--
		dAtA[i] = 0x11
	}
	if m.NumFiniteBuckets != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		for iNdEx := len(m.Bounds) - 1; iNdEx >= 0; iNdEx-- {
			f9 := math.Float64bits(float64(m.Bounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f9))
		}
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Bounds)*8))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Params_LogInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_LogInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SinkInfo != nil {
		{
			size, err := m.SinkInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.HttpMapping != nil {
		{
			size, err := m.HttpMapping.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PayloadTemplate) > 0 {
		i -= len(m.PayloadTemplate)
		copy(dAtA[i:], m.PayloadTemplate)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PayloadTemplate)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.LabelNames) > 0 {
		for iNdEx := len(m.LabelNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LabelNames[iNdEx])
			copy(dAtA[i:], m.LabelNames[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.LabelNames[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Params_LogInfo_HttpRequestMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo_HttpRequestMapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_LogInfo_HttpRequestMapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Referer) > 0 {
		i -= len(m.Referer)
		copy(dAtA[i:], m.Referer)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Referer)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.UserAgent) > 0 {
		i -= len(m.UserAgent)
		copy(dAtA[i:], m.UserAgent)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.UserAgent)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Method) > 0 {
		i -= len(m.Method)
		copy(dAtA[i:], m.Method)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Method)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.RemoteIp) > 0 {
		i -= len(m.RemoteIp)
		copy(dAtA[i:], m.RemoteIp)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RemoteIp)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.LocalIp) > 0 {
		i -= len(m.LocalIp)
		copy(dAtA[i:], m.LocalIp)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.LocalIp)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Latency) > 0 {
		i -= len(m.Latency)
		copy(dAtA[i:], m.Latency)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Latency)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ResponseSize) > 0 {
		i -= len(m.ResponseSize)
		copy(dAtA[i:], m.ResponseSize)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ResponseSize)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RequestSize) > 0 {
		i -= len(m.RequestSize)
		copy(dAtA[i:], m.RequestSize)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RequestSize)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Params_LogInfo_SinkInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo_SinkInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_LogInfo_SinkInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UpdateIncludeChildren {
		i--
		if m.UpdateIncludeChildren {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.UpdateFilter {
		i--
		if m.UpdateFilter {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.UpdateDestination {
		i--
		if m.UpdateDestination {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.UniqueWriterIdentity {
		i--
		if m.UniqueWriterIdentity {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Filter) > 0 {
		i -= len(m.Filter)
		copy(dAtA[i:], m.Filter)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Filter)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Destination) > 0 {
		i -= len(m.Destination)
		copy(dAtA[i:], m.Destination)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Destination)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Params_Trace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_Trace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params_Trace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SampleProbability != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.SampleProbability))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	offset -= sovConfig(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushInterval)
	n += 1 + l + sovConfig(uint64(l))
	if m.Creds != nil {
		n += m.Creds.Size()
	}
	if len(m.MetricInfo) > 0 {
		for k, v := range m.MetricInfo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	if len(m.LogInfo) > 0 {
		for k, v := range m.LogInfo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	if m.Trace != nil {
		l = m.Trace.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_AppCredentials) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Params_ApiKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ApiKey)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *Params_ServiceAccountPath) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceAccountPath)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *Params_MetricInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kind != 0 {
		n += 1 + sovConfig(uint64(m.Kind))
	}
	if m.Value != 0 {
		n += 1 + sovConfig(uint64(m.Value))
	}
	if m.Buckets != nil {
		l = m.Buckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.MetricType)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Definition != nil {
		n += m.Definition.Size()
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LinearBuckets != nil {
		l = m.LinearBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExponentialBuckets != nil {
		l = m.ExponentialBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExplicitBuckets != nil {
		l = m.ExplicitBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.Width != 0 {
		n += 9
	}
	if m.Offset != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.GrowthFactor != 0 {
		n += 9
	}
	if m.Scale != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		n += 1 + sovConfig(uint64(len(m.Bounds)*8)) + len(m.Bounds)*8
	}
	return n
}

func (m *Params_LogInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.LabelNames) > 0 {
		for _, s := range m.LabelNames {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.PayloadTemplate)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.HttpMapping != nil {
		l = m.HttpMapping.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.SinkInfo != nil {
		l = m.SinkInfo.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_LogInfo_HttpRequestMapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.RequestSize)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ResponseSize)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Latency)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.LocalIp)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.RemoteIp)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.UserAgent)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Referer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_LogInfo_SinkInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Destination)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Filter)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.UniqueWriterIdentity {
		n += 2
	}
	if m.UpdateDestination {
		n += 2
	}
	if m.UpdateFilter {
		n += 2
	}
	if m.UpdateIncludeChildren {
		n += 2
	}
	return n
}

func (m *Params_Trace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SampleProbability != 0 {
		n += 9
	}
	return n
}

func sovConfig(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	keysForMetricInfo := make([]string, 0, len(this.MetricInfo))
	for k, _ := range this.MetricInfo {
		keysForMetricInfo = append(keysForMetricInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMetricInfo)
	mapStringForMetricInfo := "map[string]*Params_MetricInfo{"
	for _, k := range keysForMetricInfo {
		mapStringForMetricInfo += fmt.Sprintf("%v: %v,", k, this.MetricInfo[k])
	}
	mapStringForMetricInfo += "}"
	keysForLogInfo := make([]string, 0, len(this.LogInfo))
	for k, _ := range this.LogInfo {
		keysForLogInfo = append(keysForLogInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLogInfo)
	mapStringForLogInfo := "map[string]*Params_LogInfo{"
	for _, k := range keysForLogInfo {
		mapStringForLogInfo += fmt.Sprintf("%v: %v,", k, this.LogInfo[k])
	}
	mapStringForLogInfo += "}"
	s := strings.Join([]string{`&Params{`,
		`Endpoint:` + fmt.Sprintf("%v", this.Endpoint) + `,`,
		`ProjectId:` + fmt.Sprintf("%v", this.ProjectId) + `,`,
		`PushInterval:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.PushInterval), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`Creds:` + fmt.Sprintf("%v", this.Creds) + `,`,
		`MetricInfo:` + mapStringForMetricInfo + `,`,
		`LogInfo:` + mapStringForLogInfo + `,`,
		`Trace:` + strings.Replace(fmt.Sprintf("%v", this.Trace), "Params_Trace", "Params_Trace", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_AppCredentials) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_AppCredentials{`,
		`AppCredentials:` + fmt.Sprintf("%v", this.AppCredentials) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_ApiKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_ApiKey{`,
		`ApiKey:` + fmt.Sprintf("%v", this.ApiKey) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_ServiceAccountPath) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_ServiceAccountPath{`,
		`ServiceAccountPath:` + fmt.Sprintf("%v", this.ServiceAccountPath) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Buckets:` + strings.Replace(fmt.Sprintf("%v", this.Buckets), "Params_MetricInfo_BucketsDefinition", "Params_MetricInfo_BucketsDefinition", 1) + `,`,
		`MetricType:` + fmt.Sprintf("%v", this.MetricType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition{`,
		`Definition:` + fmt.Sprintf("%v", this.Definition) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_LinearBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_LinearBuckets{`,
		`LinearBuckets:` + strings.Replace(fmt.Sprintf("%v", this.LinearBuckets), "Params_MetricInfo_BucketsDefinition_Linear", "Params_MetricInfo_BucketsDefinition_Linear", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExponentialBuckets{`,
		`ExponentialBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExponentialBuckets), "Params_MetricInfo_BucketsDefinition_Exponential", "Params_MetricInfo_BucketsDefinition_Exponential", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExplicitBuckets{`,
		`ExplicitBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExplicitBuckets), "Params_MetricInfo_BucketsDefinition_Explicit", "Params_MetricInfo_BucketsDefinition_Explicit", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Linear) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Linear{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`Width:` + fmt.Sprintf("%v", this.Width) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Exponential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Exponential{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`GrowthFactor:` + fmt.Sprintf("%v", this.GrowthFactor) + `,`,
		`Scale:` + fmt.Sprintf("%v", this.Scale) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Explicit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Explicit{`,
		`Bounds:` + fmt.Sprintf("%v", this.Bounds) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo{`,
		`LabelNames:` + fmt.Sprintf("%v", this.LabelNames) + `,`,
		`PayloadTemplate:` + fmt.Sprintf("%v", this.PayloadTemplate) + `,`,
		`HttpMapping:` + strings.Replace(fmt.Sprintf("%v", this.HttpMapping), "Params_LogInfo_HttpRequestMapping", "Params_LogInfo_HttpRequestMapping", 1) + `,`,
		`SinkInfo:` + strings.Replace(fmt.Sprintf("%v", this.SinkInfo), "Params_LogInfo_SinkInfo", "Params_LogInfo_SinkInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo_HttpRequestMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo_HttpRequestMapping{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`Latency:` + fmt.Sprintf("%v", this.Latency) + `,`,
		`LocalIp:` + fmt.Sprintf("%v", this.LocalIp) + `,`,
		`RemoteIp:` + fmt.Sprintf("%v", this.RemoteIp) + `,`,
		`Url:` + fmt.Sprintf("%v", this.Url) + `,`,
		`Method:` + fmt.Sprintf("%v", this.Method) + `,`,
		`UserAgent:` + fmt.Sprintf("%v", this.UserAgent) + `,`,
		`Referer:` + fmt.Sprintf("%v", this.Referer) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo_SinkInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo_SinkInfo{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Destination:` + fmt.Sprintf("%v", this.Destination) + `,`,
		`Filter:` + fmt.Sprintf("%v", this.Filter) + `,`,
		`UniqueWriterIdentity:` + fmt.Sprintf("%v", this.UniqueWriterIdentity) + `,`,
		`UpdateDestination:` + fmt.Sprintf("%v", this.UpdateDestination) + `,`,
		`UpdateFilter:` + fmt.Sprintf("%v", this.UpdateFilter) + `,`,
		`UpdateIncludeChildren:` + fmt.Sprintf("%v", this.UpdateIncludeChildren) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_Trace) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_Trace{`,
		`SampleProbability:` + fmt.Sprintf("%v", this.SampleProbability) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.PushInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppCredentials", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Creds = &Params_AppCredentials{b}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Creds = &Params_ApiKey{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccountPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Creds = &Params_ServiceAccountPath{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricInfo == nil {
				m.MetricInfo = make(map[string]*Params_MetricInfo)
			}
			var mapkey string
			var mapvalue *Params_MetricInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_MetricInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MetricInfo[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogInfo == nil {
				m.LogInfo = make(map[string]*Params_LogInfo)
			}
			var mapkey string
			var mapvalue *Params_LogInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_LogInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LogInfo[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Trace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Trace == nil {
				m.Trace = &Params_Trace{}
			}
			if err := m.Trace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= metric.MetricDescriptor_MetricKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= metric.MetricDescriptor_ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Buckets == nil {
				m.Buckets = &Params_MetricInfo_BucketsDefinition{}
			}
			if err := m.Buckets.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetricType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketsDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketsDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinearBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Linear{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Exponential{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Explicit{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Linear: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Linear: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Width = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Offset = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exponential: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exponential: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrowthFactor", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.GrowthFactor = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Scale = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Explicit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Explicit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.Bounds = append(m.Bounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConfig
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConfig
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.Bounds) == 0 {
					m.Bounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.Bounds = append(m.Bounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelNames = append(m.LabelNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PayloadTemplate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PayloadTemplate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpMapping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpMapping == nil {
				m.HttpMapping = &Params_LogInfo_HttpRequestMapping{}
			}
			if err := m.HttpMapping.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SinkInfo == nil {
				m.SinkInfo = &Params_LogInfo_SinkInfo{}
			}
			if err := m.SinkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo_HttpRequestMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRequestMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRequestMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latency", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Latency = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserAgent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserAgent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Referer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Referer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo_SinkInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SinkInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SinkInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destination = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UniqueWriterIdentity", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UniqueWriterIdentity = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateDestination", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdateDestination = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateFilter", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdateFilter = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateIncludeChildren", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdateIncludeChildren = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_Trace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Trace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Trace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleProbability", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.SampleProbability = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)
