// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opencensus/proto/trace/v1/trace.proto

/*
	Package opencensus_proto_trace_v1 is a generated protocol buffer package.

	It is generated from these files:
		opencensus/proto/trace/v1/trace.proto
		opencensus/proto/trace/v1/trace_config.proto

	It has these top-level messages:
		Span
		Status
		AttributeValue
		StackTrace
		Module
		TruncatableString
		TraceConfig
		ProbabilitySampler
		ConstantSampler
		RateLimitingSampler
*/
package opencensus_proto_trace_v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"
import google_protobuf1 "github.com/gogo/protobuf/types"

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SERVER Span_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	Span_CLIENT Span_SpanKind = 2
)

var Span_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "SERVER",
	2: "CLIENT",
}
var Span_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"SERVER":                1,
	"CLIENT":                2,
}

func (x Span_SpanKind) String() string {
	return proto.EnumName(Span_SpanKind_name, int32(x))
}
func (Span_SpanKind) EnumDescriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 0} }

// Indicates whether the message was sent or received.
type Span_TimeEvent_MessageEvent_Type int32

const (
	// Unknown event type.
	Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED Span_TimeEvent_MessageEvent_Type = 0
	// Indicates a sent message.
	Span_TimeEvent_MessageEvent_SENT Span_TimeEvent_MessageEvent_Type = 1
	// Indicates a received message.
	Span_TimeEvent_MessageEvent_RECEIVED Span_TimeEvent_MessageEvent_Type = 2
)

var Span_TimeEvent_MessageEvent_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "SENT",
	2: "RECEIVED",
}
var Span_TimeEvent_MessageEvent_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"SENT":             1,
	"RECEIVED":         2,
}

func (x Span_TimeEvent_MessageEvent_Type) String() string {
	return proto.EnumName(Span_TimeEvent_MessageEvent_Type_name, int32(x))
}
func (Span_TimeEvent_MessageEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTrace, []int{0, 2, 1, 0}
}

// The relationship of the current span relative to the linked span: child,
// parent, or unspecified.
type Span_Link_Type int32

const (
	// The relationship of the two spans is unknown, or known but other
	// than parent-child.
	Span_Link_TYPE_UNSPECIFIED Span_Link_Type = 0
	// The linked span is a child of the current span.
	Span_Link_CHILD_LINKED_SPAN Span_Link_Type = 1
	// The linked span is a parent of the current span.
	Span_Link_PARENT_LINKED_SPAN Span_Link_Type = 2
)

var Span_Link_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CHILD_LINKED_SPAN",
	2: "PARENT_LINKED_SPAN",
}
var Span_Link_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":   0,
	"CHILD_LINKED_SPAN":  1,
	"PARENT_LINKED_SPAN": 2,
}

func (x Span_Link_Type) String() string {
	return proto.EnumName(Span_Link_Type_name, int32(x))
}
func (Span_Link_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 4, 0} }

// A span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Often, a trace contains a root span
// that describes the end-to-end latency, and one or more subspans for
// its sub-operations. A trace can also contain multiple root spans,
// or none at all. Spans do not need to be contiguous - there may be
// gaps or overlaps between spans in a trace.
//
// The next id is 16.
// TODO(bdrutu): Add an example.
type Span struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array.
	//
	// This field is required.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array.
	//
	// This field is required.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The Tracestate on the span.
	Tracestate *Span_Tracestate `protobuf:"bytes,15,opt,name=tracestate" json:"tracestate,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId []byte `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is required.
	Name *TruncatableString `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT`
	// and `SERVER` to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,14,opt,name=kind,proto3,enum=opencensus.proto.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// The start time of the span. On the client side, this is the time kept by
	// the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	StartTime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The end time of the span. On the client side, this is the time kept by
	// the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	EndTime *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// A set of attributes on the span.
	Attributes *Span_Attributes `protobuf:"bytes,7,opt,name=attributes" json:"attributes,omitempty"`
	// A stack trace captured at the start of the span.
	StackTrace *StackTrace `protobuf:"bytes,8,opt,name=stack_trace,json=stackTrace" json:"stack_trace,omitempty"`
	// The included time events.
	TimeEvents *Span_TimeEvents `protobuf:"bytes,9,opt,name=time_events,json=timeEvents" json:"time_events,omitempty"`
	// The included links.
	Links *Span_Links `protobuf:"bytes,10,opt,name=links" json:"links,omitempty"`
	// An optional final status for this span.
	Status *Status `protobuf:"bytes,11,opt,name=status" json:"status,omitempty"`
	// A highly recommended but not required flag that identifies when a trace
	// crosses a process boundary. True when the parent_span belongs to the
	// same process as the current span.
	SameProcessAsParentSpan *google_protobuf1.BoolValue `protobuf:"bytes,12,opt,name=same_process_as_parent_span,json=sameProcessAsParentSpan" json:"same_process_as_parent_span,omitempty"`
	// An optional number of child spans that were generated while this span
	// was active. If set, allows an implementation to detect missing child spans.
	ChildSpanCount *google_protobuf1.UInt32Value `protobuf:"bytes,13,opt,name=child_span_count,json=childSpanCount" json:"child_span_count,omitempty"`
}

func (m *Span) Reset()                    { *m = Span{} }
func (m *Span) String() string            { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()               {}
func (*Span) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0} }

func (m *Span) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span) GetTracestate() *Span_Tracestate {
	if m != nil {
		return m.Tracestate
	}
	return nil
}

func (m *Span) GetParentSpanId() []byte {
	if m != nil {
		return m.ParentSpanId
	}
	return nil
}

func (m *Span) GetName() *TruncatableString {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Span) GetKind() Span_SpanKind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetStartTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Span) GetEndTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Span) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetStackTrace() *StackTrace {
	if m != nil {
		return m.StackTrace
	}
	return nil
}

func (m *Span) GetTimeEvents() *Span_TimeEvents {
	if m != nil {
		return m.TimeEvents
	}
	return nil
}

func (m *Span) GetLinks() *Span_Links {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetStatus() *Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Span) GetSameProcessAsParentSpan() *google_protobuf1.BoolValue {
	if m != nil {
		return m.SameProcessAsParentSpan
	}
	return nil
}

func (m *Span) GetChildSpanCount() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.ChildSpanCount
	}
	return nil
}

// This field conveys information about request position in multiple distributed tracing graphs.
// It is a list of Tracestate.Entry with a maximum of 32 members in the list.
//
// See the https://github.com/w3c/distributed-tracing for more details about this field.
type Span_Tracestate struct {
	// A list of entries that represent the Tracestate.
	Entries []*Span_Tracestate_Entry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *Span_Tracestate) Reset()                    { *m = Span_Tracestate{} }
func (m *Span_Tracestate) String() string            { return proto.CompactTextString(m) }
func (*Span_Tracestate) ProtoMessage()               {}
func (*Span_Tracestate) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 0} }

func (m *Span_Tracestate) GetEntries() []*Span_Tracestate_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type Span_Tracestate_Entry struct {
	// The key must begin with a lowercase letter, and can only contain
	// lowercase letters 'a'-'z', digits '0'-'9', underscores '_', dashes
	// '-', asterisks '*', and forward slashes '/'.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value is opaque string up to 256 characters printable ASCII
	// RFC0020 characters (i.e., the range 0x20 to 0x7E) except ',' and '='.
	// Note that this also excludes tabs, newlines, carriage returns, etc.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Span_Tracestate_Entry) Reset()                    { *m = Span_Tracestate_Entry{} }
func (m *Span_Tracestate_Entry) String() string            { return proto.CompactTextString(m) }
func (*Span_Tracestate_Entry) ProtoMessage()               {}
func (*Span_Tracestate_Entry) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 0, 0} }

func (m *Span_Tracestate_Entry) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Span_Tracestate_Entry) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A set of attributes, each with a key and a value.
type Span_Attributes struct {
	// The set of attributes. The value can be a string, an integer, or the
	// Boolean values `true` and `false`. For example:
	//
	//     "/instance_id": "my-instance"
	//     "/http/user_agent": ""
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	AttributeMap map[string]*AttributeValue `protobuf:"bytes,1,rep,name=attribute_map,json=attributeMap" json:"attribute_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// The number of attributes that were discarded. Attributes can be discarded
	// because their keys are too long or because there are too many attributes.
	// If this value is 0, then no attributes were dropped.
	DroppedAttributesCount int32 `protobuf:"varint,2,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Attributes) Reset()                    { *m = Span_Attributes{} }
func (m *Span_Attributes) String() string            { return proto.CompactTextString(m) }
func (*Span_Attributes) ProtoMessage()               {}
func (*Span_Attributes) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 1} }

func (m *Span_Attributes) GetAttributeMap() map[string]*AttributeValue {
	if m != nil {
		return m.AttributeMap
	}
	return nil
}

func (m *Span_Attributes) GetDroppedAttributesCount() int32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A time-stamped annotation or message event in the Span.
type Span_TimeEvent struct {
	// The time the event occurred.
	Time *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=time" json:"time,omitempty"`
	// A `TimeEvent` can contain either an `Annotation` object or a
	// `MessageEvent` object, but not both.
	//
	// Types that are valid to be assigned to Value:
	//	*Span_TimeEvent_Annotation_
	//	*Span_TimeEvent_MessageEvent_
	Value isSpan_TimeEvent_Value `protobuf_oneof:"value"`
}

func (m *Span_TimeEvent) Reset()                    { *m = Span_TimeEvent{} }
func (m *Span_TimeEvent) String() string            { return proto.CompactTextString(m) }
func (*Span_TimeEvent) ProtoMessage()               {}
func (*Span_TimeEvent) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 2} }

type isSpan_TimeEvent_Value interface {
	isSpan_TimeEvent_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Span_TimeEvent_Annotation_ struct {
	Annotation *Span_TimeEvent_Annotation `protobuf:"bytes,2,opt,name=annotation,oneof"`
}
type Span_TimeEvent_MessageEvent_ struct {
	MessageEvent *Span_TimeEvent_MessageEvent `protobuf:"bytes,3,opt,name=message_event,json=messageEvent,oneof"`
}

func (*Span_TimeEvent_Annotation_) isSpan_TimeEvent_Value()   {}
func (*Span_TimeEvent_MessageEvent_) isSpan_TimeEvent_Value() {}

func (m *Span_TimeEvent) GetValue() isSpan_TimeEvent_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Span_TimeEvent) GetTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *Span_TimeEvent) GetAnnotation() *Span_TimeEvent_Annotation {
	if x, ok := m.GetValue().(*Span_TimeEvent_Annotation_); ok {
		return x.Annotation
	}
	return nil
}

func (m *Span_TimeEvent) GetMessageEvent() *Span_TimeEvent_MessageEvent {
	if x, ok := m.GetValue().(*Span_TimeEvent_MessageEvent_); ok {
		return x.MessageEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Span_TimeEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Span_TimeEvent_OneofMarshaler, _Span_TimeEvent_OneofUnmarshaler, _Span_TimeEvent_OneofSizer, []interface{}{
		(*Span_TimeEvent_Annotation_)(nil),
		(*Span_TimeEvent_MessageEvent_)(nil),
	}
}

func _Span_TimeEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Annotation); err != nil {
			return err
		}
	case *Span_TimeEvent_MessageEvent_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MessageEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Span_TimeEvent.Value has unexpected type %T", x)
	}
	return nil
}

func _Span_TimeEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Span_TimeEvent)
	switch tag {
	case 2: // value.annotation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_Annotation)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_Annotation_{msg}
		return true, err
	case 3: // value.message_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Span_TimeEvent_MessageEvent)
		err := b.DecodeMessage(msg)
		m.Value = &Span_TimeEvent_MessageEvent_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Span_TimeEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Span_TimeEvent)
	// value
	switch x := m.Value.(type) {
	case *Span_TimeEvent_Annotation_:
		s := proto.Size(x.Annotation)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Span_TimeEvent_MessageEvent_:
		s := proto.Size(x.MessageEvent)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A text annotation with a set of attributes.
type Span_TimeEvent_Annotation struct {
	// A user-supplied message describing the event.
	Description *TruncatableString `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// A set of attributes on the annotation.
	Attributes *Span_Attributes `protobuf:"bytes,2,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Span_TimeEvent_Annotation) Reset()         { *m = Span_TimeEvent_Annotation{} }
func (m *Span_TimeEvent_Annotation) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent_Annotation) ProtoMessage()    {}
func (*Span_TimeEvent_Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptorTrace, []int{0, 2, 0}
}

func (m *Span_TimeEvent_Annotation) GetDescription() *TruncatableString {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *Span_TimeEvent_Annotation) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// An event describing a message sent/received between Spans.
type Span_TimeEvent_MessageEvent struct {
	// The type of MessageEvent. Indicates whether the message was sent or
	// received.
	Type Span_TimeEvent_MessageEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_TimeEvent_MessageEvent_Type" json:"type,omitempty"`
	// An identifier for the MessageEvent's message that can be used to match
	// SENT and RECEIVED MessageEvents. For example, this field could
	// represent a sequence ID for a streaming RPC. It is recommended to be
	// unique within a Span.
	Id uint64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// The number of uncompressed bytes sent or received.
	UncompressedSize uint64 `protobuf:"varint,3,opt,name=uncompressed_size,json=uncompressedSize,proto3" json:"uncompressed_size,omitempty"`
	// The number of compressed bytes sent or received. If zero, assumed to
	// be the same size as uncompressed.
	CompressedSize uint64 `protobuf:"varint,4,opt,name=compressed_size,json=compressedSize,proto3" json:"compressed_size,omitempty"`
}

func (m *Span_TimeEvent_MessageEvent) Reset()         { *m = Span_TimeEvent_MessageEvent{} }
func (m *Span_TimeEvent_MessageEvent) String() string { return proto.CompactTextString(m) }
func (*Span_TimeEvent_MessageEvent) ProtoMessage()    {}
func (*Span_TimeEvent_MessageEvent) Descriptor() ([]byte, []int) {
	return fileDescriptorTrace, []int{0, 2, 1}
}

func (m *Span_TimeEvent_MessageEvent) GetType() Span_TimeEvent_MessageEvent_Type {
	if m != nil {
		return m.Type
	}
	return Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED
}

func (m *Span_TimeEvent_MessageEvent) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetUncompressedSize() uint64 {
	if m != nil {
		return m.UncompressedSize
	}
	return 0
}

func (m *Span_TimeEvent_MessageEvent) GetCompressedSize() uint64 {
	if m != nil {
		return m.CompressedSize
	}
	return 0
}

// A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation
// on the span, consisting of either user-supplied key-value pairs, or
// details of a message sent/received between Spans.
type Span_TimeEvents struct {
	// A collection of `TimeEvent`s.
	TimeEvent []*Span_TimeEvent `protobuf:"bytes,1,rep,name=time_event,json=timeEvent" json:"time_event,omitempty"`
	// The number of dropped annotations in all the included time events.
	// If the value is 0, then no annotations were dropped.
	DroppedAnnotationsCount int32 `protobuf:"varint,2,opt,name=dropped_annotations_count,json=droppedAnnotationsCount,proto3" json:"dropped_annotations_count,omitempty"`
	// The number of dropped message events in all the included time events.
	// If the value is 0, then no message events were dropped.
	DroppedMessageEventsCount int32 `protobuf:"varint,3,opt,name=dropped_message_events_count,json=droppedMessageEventsCount,proto3" json:"dropped_message_events_count,omitempty"`
}

func (m *Span_TimeEvents) Reset()                    { *m = Span_TimeEvents{} }
func (m *Span_TimeEvents) String() string            { return proto.CompactTextString(m) }
func (*Span_TimeEvents) ProtoMessage()               {}
func (*Span_TimeEvents) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 3} }

func (m *Span_TimeEvents) GetTimeEvent() []*Span_TimeEvent {
	if m != nil {
		return m.TimeEvent
	}
	return nil
}

func (m *Span_TimeEvents) GetDroppedAnnotationsCount() int32 {
	if m != nil {
		return m.DroppedAnnotationsCount
	}
	return 0
}

func (m *Span_TimeEvents) GetDroppedMessageEventsCount() int32 {
	if m != nil {
		return m.DroppedMessageEventsCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The relationship of the current span relative to the linked span.
	Type Span_Link_Type `protobuf:"varint,3,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_Link_Type" json:"type,omitempty"`
	// A set of attributes on the link.
	Attributes *Span_Attributes `protobuf:"bytes,4,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *Span_Link) Reset()                    { *m = Span_Link{} }
func (m *Span_Link) String() string            { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()               {}
func (*Span_Link) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 4} }

func (m *Span_Link) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span_Link) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span_Link) GetType() Span_Link_Type {
	if m != nil {
		return m.Type
	}
	return Span_Link_TYPE_UNSPECIFIED
}

func (m *Span_Link) GetAttributes() *Span_Attributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A collection of links, which are references from this span to a span
// in the same or different trace.
type Span_Links struct {
	// A collection of links.
	Link []*Span_Link `protobuf:"bytes,1,rep,name=link" json:"link,omitempty"`
	// The number of dropped links after the maximum size was enforced. If
	// this value is 0, then no links were dropped.
	DroppedLinksCount int32 `protobuf:"varint,2,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
}

func (m *Span_Links) Reset()                    { *m = Span_Links{} }
func (m *Span_Links) String() string            { return proto.CompactTextString(m) }
func (*Span_Links) ProtoMessage()               {}
func (*Span_Links) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0, 5} }

func (m *Span_Links) GetLink() []*Span_Link {
	if m != nil {
		return m.Link
	}
	return nil
}

func (m *Span_Links) GetDroppedLinksCount() int32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

// The `Status` type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs. This proto's fields
// are a subset of those of
// [google.rpc.Status](https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto),
// which is used by [gRPC](https://github.com/grpc).
type Status struct {
	// The status code.
	Code int32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// A developer-facing error message, which should be in English.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Status) Reset()                    { *m = Status{} }
func (m *Status) String() string            { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()               {}
func (*Status) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{1} }

func (m *Status) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// The value of an Attribute.
type AttributeValue struct {
	// The type of the value.
	//
	// Types that are valid to be assigned to Value:
	//	*AttributeValue_StringValue
	//	*AttributeValue_IntValue
	//	*AttributeValue_BoolValue
	//	*AttributeValue_DoubleValue
	Value isAttributeValue_Value `protobuf_oneof:"value"`
}

func (m *AttributeValue) Reset()                    { *m = AttributeValue{} }
func (m *AttributeValue) String() string            { return proto.CompactTextString(m) }
func (*AttributeValue) ProtoMessage()               {}
func (*AttributeValue) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{2} }

type isAttributeValue_Value interface {
	isAttributeValue_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type AttributeValue_StringValue struct {
	StringValue *TruncatableString `protobuf:"bytes,1,opt,name=string_value,json=stringValue,oneof"`
}
type AttributeValue_IntValue struct {
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}
type AttributeValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}
type AttributeValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*AttributeValue_StringValue) isAttributeValue_Value() {}
func (*AttributeValue_IntValue) isAttributeValue_Value()    {}
func (*AttributeValue_BoolValue) isAttributeValue_Value()   {}
func (*AttributeValue_DoubleValue) isAttributeValue_Value() {}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *AttributeValue) GetStringValue() *TruncatableString {
	if x, ok := m.GetValue().(*AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return nil
}

func (m *AttributeValue) GetIntValue() int64 {
	if x, ok := m.GetValue().(*AttributeValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *AttributeValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *AttributeValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*AttributeValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttributeValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttributeValue_OneofMarshaler, _AttributeValue_OneofUnmarshaler, _AttributeValue_OneofSizer, []interface{}{
		(*AttributeValue_StringValue)(nil),
		(*AttributeValue_IntValue)(nil),
		(*AttributeValue_BoolValue)(nil),
		(*AttributeValue_DoubleValue)(nil),
	}
}

func _AttributeValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringValue); err != nil {
			return err
		}
	case *AttributeValue_IntValue:
		_ = b.EncodeVarint(2<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *AttributeValue_DoubleValue:
		_ = b.EncodeVarint(4<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case nil:
	default:
		return fmt.Errorf("AttributeValue.Value has unexpected type %T", x)
	}
	return nil
}

func _AttributeValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttributeValue)
	switch tag {
	case 1: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncatableString)
		err := b.DecodeMessage(msg)
		m.Value = &AttributeValue_StringValue{msg}
		return true, err
	case 2: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_IntValue{int64(x)}
		return true, err
	case 3: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &AttributeValue_BoolValue{x != 0}
		return true, err
	case 4: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &AttributeValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	default:
		return false, nil
	}
}

func _AttributeValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *AttributeValue_StringValue:
		s := proto.Size(x.StringValue)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AttributeValue_IntValue:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntValue))
	case *AttributeValue_BoolValue:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case *AttributeValue_DoubleValue:
		n += proto.SizeVarint(4<<3 | proto.WireFixed64)
		n += 8
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The call stack which originated this span.
type StackTrace struct {
	// Stack frames in this stack trace.
	StackFrames *StackTrace_StackFrames `protobuf:"bytes,1,opt,name=stack_frames,json=stackFrames" json:"stack_frames,omitempty"`
	// The hash ID is used to conserve network bandwidth for duplicate
	// stack traces within a single trace.
	//
	// Often multiple spans will have identical stack traces.
	// The first occurrence of a stack trace should contain both
	// `stack_frames` and a value in `stack_trace_hash_id`.
	//
	// Subsequent spans within the same request can refer
	// to that stack trace by setting only `stack_trace_hash_id`.
	//
	// TODO: describe how to deal with the case where stack_trace_hash_id is
	// zero because it was not set.
	StackTraceHashId uint64 `protobuf:"varint,2,opt,name=stack_trace_hash_id,json=stackTraceHashId,proto3" json:"stack_trace_hash_id,omitempty"`
}

func (m *StackTrace) Reset()                    { *m = StackTrace{} }
func (m *StackTrace) String() string            { return proto.CompactTextString(m) }
func (*StackTrace) ProtoMessage()               {}
func (*StackTrace) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{3} }

func (m *StackTrace) GetStackFrames() *StackTrace_StackFrames {
	if m != nil {
		return m.StackFrames
	}
	return nil
}

func (m *StackTrace) GetStackTraceHashId() uint64 {
	if m != nil {
		return m.StackTraceHashId
	}
	return 0
}

// A single stack frame in a stack trace.
type StackTrace_StackFrame struct {
	// The fully-qualified name that uniquely identifies the function or
	// method that is active in this frame.
	FunctionName *TruncatableString `protobuf:"bytes,1,opt,name=function_name,json=functionName" json:"function_name,omitempty"`
	// An un-mangled function name, if `function_name` is
	// [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can
	// be fully qualified.
	OriginalFunctionName *TruncatableString `protobuf:"bytes,2,opt,name=original_function_name,json=originalFunctionName" json:"original_function_name,omitempty"`
	// The name of the source file where the function call appears.
	FileName *TruncatableString `protobuf:"bytes,3,opt,name=file_name,json=fileName" json:"file_name,omitempty"`
	// The line number in `file_name` where the function call appears.
	LineNumber int64 `protobuf:"varint,4,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// The column number where the function call appears, if available.
	// This is important in JavaScript because of its anonymous functions.
	ColumnNumber int64 `protobuf:"varint,5,opt,name=column_number,json=columnNumber,proto3" json:"column_number,omitempty"`
	// The binary module from where the code was loaded.
	LoadModule *Module `protobuf:"bytes,6,opt,name=load_module,json=loadModule" json:"load_module,omitempty"`
	// The version of the deployed source code.
	SourceVersion *TruncatableString `protobuf:"bytes,7,opt,name=source_version,json=sourceVersion" json:"source_version,omitempty"`
}

func (m *StackTrace_StackFrame) Reset()                    { *m = StackTrace_StackFrame{} }
func (m *StackTrace_StackFrame) String() string            { return proto.CompactTextString(m) }
func (*StackTrace_StackFrame) ProtoMessage()               {}
func (*StackTrace_StackFrame) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{3, 0} }

func (m *StackTrace_StackFrame) GetFunctionName() *TruncatableString {
	if m != nil {
		return m.FunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetOriginalFunctionName() *TruncatableString {
	if m != nil {
		return m.OriginalFunctionName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetFileName() *TruncatableString {
	if m != nil {
		return m.FileName
	}
	return nil
}

func (m *StackTrace_StackFrame) GetLineNumber() int64 {
	if m != nil {
		return m.LineNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetColumnNumber() int64 {
	if m != nil {
		return m.ColumnNumber
	}
	return 0
}

func (m *StackTrace_StackFrame) GetLoadModule() *Module {
	if m != nil {
		return m.LoadModule
	}
	return nil
}

func (m *StackTrace_StackFrame) GetSourceVersion() *TruncatableString {
	if m != nil {
		return m.SourceVersion
	}
	return nil
}

// A collection of stack frames, which can be truncated.
type StackTrace_StackFrames struct {
	// Stack frames in this call stack.
	Frame []*StackTrace_StackFrame `protobuf:"bytes,1,rep,name=frame" json:"frame,omitempty"`
	// The number of stack frames that were dropped because there
	// were too many stack frames.
	// If this value is 0, then no stack frames were dropped.
	DroppedFramesCount int32 `protobuf:"varint,2,opt,name=dropped_frames_count,json=droppedFramesCount,proto3" json:"dropped_frames_count,omitempty"`
}

func (m *StackTrace_StackFrames) Reset()                    { *m = StackTrace_StackFrames{} }
func (m *StackTrace_StackFrames) String() string            { return proto.CompactTextString(m) }
func (*StackTrace_StackFrames) ProtoMessage()               {}
func (*StackTrace_StackFrames) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{3, 1} }

func (m *StackTrace_StackFrames) GetFrame() []*StackTrace_StackFrame {
	if m != nil {
		return m.Frame
	}
	return nil
}

func (m *StackTrace_StackFrames) GetDroppedFramesCount() int32 {
	if m != nil {
		return m.DroppedFramesCount
	}
	return 0
}

// A description of a binary module.
type Module struct {
	// TODO: document the meaning of this field.
	// For example: main binary, kernel modules, and dynamic libraries
	// such as libc.so, sharedlib.so.
	Module *TruncatableString `protobuf:"bytes,1,opt,name=module" json:"module,omitempty"`
	// A unique identifier for the module, usually a hash of its
	// contents.
	BuildId *TruncatableString `protobuf:"bytes,2,opt,name=build_id,json=buildId" json:"build_id,omitempty"`
}

func (m *Module) Reset()                    { *m = Module{} }
func (m *Module) String() string            { return proto.CompactTextString(m) }
func (*Module) ProtoMessage()               {}
func (*Module) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{4} }

func (m *Module) GetModule() *TruncatableString {
	if m != nil {
		return m.Module
	}
	return nil
}

func (m *Module) GetBuildId() *TruncatableString {
	if m != nil {
		return m.BuildId
	}
	return nil
}

// A string that might be shortened to a specified length.
type TruncatableString struct {
	// The shortened string. For example, if the original string was 500 bytes long and
	// the limit of the string was 128 bytes, then this value contains the first 128
	// bytes of the 500-byte string. Note that truncation always happens on a
	// character boundary, to ensure that a truncated string is still valid UTF-8.
	// Because it may contain multi-byte characters, the size of the truncated string
	// may be less than the truncation limit.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of bytes removed from the original string. If this
	// value is 0, then the string was not shortened.
	TruncatedByteCount int32 `protobuf:"varint,2,opt,name=truncated_byte_count,json=truncatedByteCount,proto3" json:"truncated_byte_count,omitempty"`
}

func (m *TruncatableString) Reset()                    { *m = TruncatableString{} }
func (m *TruncatableString) String() string            { return proto.CompactTextString(m) }
func (*TruncatableString) ProtoMessage()               {}
func (*TruncatableString) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{5} }

func (m *TruncatableString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *TruncatableString) GetTruncatedByteCount() int32 {
	if m != nil {
		return m.TruncatedByteCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Span)(nil), "opencensus.proto.trace.v1.Span")
	proto.RegisterType((*Span_Tracestate)(nil), "opencensus.proto.trace.v1.Span.Tracestate")
	proto.RegisterType((*Span_Tracestate_Entry)(nil), "opencensus.proto.trace.v1.Span.Tracestate.Entry")
	proto.RegisterType((*Span_Attributes)(nil), "opencensus.proto.trace.v1.Span.Attributes")
	proto.RegisterType((*Span_TimeEvent)(nil), "opencensus.proto.trace.v1.Span.TimeEvent")
	proto.RegisterType((*Span_TimeEvent_Annotation)(nil), "opencensus.proto.trace.v1.Span.TimeEvent.Annotation")
	proto.RegisterType((*Span_TimeEvent_MessageEvent)(nil), "opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent")
	proto.RegisterType((*Span_TimeEvents)(nil), "opencensus.proto.trace.v1.Span.TimeEvents")
	proto.RegisterType((*Span_Link)(nil), "opencensus.proto.trace.v1.Span.Link")
	proto.RegisterType((*Span_Links)(nil), "opencensus.proto.trace.v1.Span.Links")
	proto.RegisterType((*Status)(nil), "opencensus.proto.trace.v1.Status")
	proto.RegisterType((*AttributeValue)(nil), "opencensus.proto.trace.v1.AttributeValue")
	proto.RegisterType((*StackTrace)(nil), "opencensus.proto.trace.v1.StackTrace")
	proto.RegisterType((*StackTrace_StackFrame)(nil), "opencensus.proto.trace.v1.StackTrace.StackFrame")
	proto.RegisterType((*StackTrace_StackFrames)(nil), "opencensus.proto.trace.v1.StackTrace.StackFrames")
	proto.RegisterType((*Module)(nil), "opencensus.proto.trace.v1.Module")
	proto.RegisterType((*TruncatableString)(nil), "opencensus.proto.trace.v1.TruncatableString")
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_SpanKind", Span_SpanKind_name, Span_SpanKind_value)
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_TimeEvent_MessageEvent_Type", Span_TimeEvent_MessageEvent_Type_name, Span_TimeEvent_MessageEvent_Type_value)
	proto.RegisterEnum("opencensus.proto.trace.v1.Span_Link_Type", Span_Link_Type_name, Span_Link_Type_value)
}
func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if m.Name != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Name.Size()))
		n1, err := m.Name.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.StartTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.StartTime.Size()))
		n2, err := m.StartTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.EndTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.EndTime.Size()))
		n3, err := m.EndTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Attributes != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Attributes.Size()))
		n4, err := m.Attributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.StackTrace != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.StackTrace.Size()))
		n5, err := m.StackTrace.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TimeEvents != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.TimeEvents.Size()))
		n6, err := m.TimeEvents.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Links != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Links.Size()))
		n7, err := m.Links.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Status != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Status.Size()))
		n8, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.SameProcessAsParentSpan != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.SameProcessAsParentSpan.Size()))
		n9, err := m.SameProcessAsParentSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.ChildSpanCount != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.ChildSpanCount.Size()))
		n10, err := m.ChildSpanCount.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Kind != 0 {
		dAtA[i] = 0x70
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Kind))
	}
	if m.Tracestate != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Tracestate.Size()))
		n11, err := m.Tracestate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *Span_Tracestate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Tracestate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, msg := range m.Entries {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Span_Tracestate_Entry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Tracestate_Entry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *Span_Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Attributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AttributeMap) > 0 {
		for k, _ := range m.AttributeMap {
			dAtA[i] = 0xa
			i++
			v := m.AttributeMap[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTrace(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTrace(uint64(len(k))) + msgSize
			i = encodeVarintTrace(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTrace(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTrace(dAtA, i, uint64(v.Size()))
				n12, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n12
			}
		}
	}
	if m.DroppedAttributesCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
	}
	return i, nil
}

func (m *Span_TimeEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_TimeEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Time != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Time.Size()))
		n13, err := m.Time.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Value != nil {
		nn14, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn14
	}
	return i, nil
}

func (m *Span_TimeEvent_Annotation_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Annotation != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Annotation.Size()))
		n15, err := m.Annotation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *Span_TimeEvent_MessageEvent_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.MessageEvent != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.MessageEvent.Size()))
		n16, err := m.MessageEvent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *Span_TimeEvent_Annotation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_TimeEvent_Annotation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Description != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Description.Size()))
		n17, err := m.Description.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.Attributes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Attributes.Size()))
		n18, err := m.Attributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}

func (m *Span_TimeEvent_MessageEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_TimeEvent_MessageEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Type))
	}
	if m.Id != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Id))
	}
	if m.UncompressedSize != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.UncompressedSize))
	}
	if m.CompressedSize != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.CompressedSize))
	}
	return i, nil
}

func (m *Span_TimeEvents) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_TimeEvents) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TimeEvent) > 0 {
		for _, msg := range m.TimeEvent {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedAnnotationsCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAnnotationsCount))
	}
	if m.DroppedMessageEventsCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedMessageEventsCount))
	}
	return i, nil
}

func (m *Span_Link) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Link) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if m.Type != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Type))
	}
	if m.Attributes != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Attributes.Size()))
		n19, err := m.Attributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}

func (m *Span_Links) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Links) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Link) > 0 {
		for _, msg := range m.Link {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedLinksCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedLinksCount))
	}
	return i, nil
}

func (m *Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Status) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Code))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *AttributeValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn20, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn20
	}
	return i, nil
}

func (m *AttributeValue_StringValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StringValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.StringValue.Size()))
		n21, err := m.StringValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}
func (m *AttributeValue_IntValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x10
	i++
	i = encodeVarintTrace(dAtA, i, uint64(m.IntValue))
	return i, nil
}
func (m *AttributeValue_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *AttributeValue_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x21
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i += 8
	return i, nil
}
func (m *StackTrace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StackTrace) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StackFrames != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.StackFrames.Size()))
		n22, err := m.StackFrames.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.StackTraceHashId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.StackTraceHashId))
	}
	return i, nil
}

func (m *StackTrace_StackFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StackTrace_StackFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FunctionName != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.FunctionName.Size()))
		n23, err := m.FunctionName.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.OriginalFunctionName != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.OriginalFunctionName.Size()))
		n24, err := m.OriginalFunctionName.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.FileName != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.FileName.Size()))
		n25, err := m.FileName.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.LineNumber != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.LineNumber))
	}
	if m.ColumnNumber != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.ColumnNumber))
	}
	if m.LoadModule != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.LoadModule.Size()))
		n26, err := m.LoadModule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.SourceVersion != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.SourceVersion.Size()))
		n27, err := m.SourceVersion.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}

func (m *StackTrace_StackFrames) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StackTrace_StackFrames) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Frame) > 0 {
		for _, msg := range m.Frame {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedFramesCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedFramesCount))
	}
	return i, nil
}

func (m *Module) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Module) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Module != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Module.Size()))
		n28, err := m.Module.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.BuildId != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.BuildId.Size()))
		n29, err := m.BuildId.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}

func (m *TruncatableString) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncatableString) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.TruncatedByteCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.TruncatedByteCount))
	}
	return i, nil
}

func encodeVarintTrace(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Span) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Name != nil {
		l = m.Name.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.EndTime != nil {
		l = m.EndTime.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.StackTrace != nil {
		l = m.StackTrace.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.TimeEvents != nil {
		l = m.TimeEvents.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Links != nil {
		l = m.Links.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.SameProcessAsParentSpan != nil {
		l = m.SameProcessAsParentSpan.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.ChildSpanCount != nil {
		l = m.ChildSpanCount.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Kind != 0 {
		n += 1 + sovTrace(uint64(m.Kind))
	}
	if m.Tracestate != nil {
		l = m.Tracestate.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span_Tracestate) Size() (n int) {
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	return n
}

func (m *Span_Tracestate_Entry) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span_Attributes) Size() (n int) {
	var l int
	_ = l
	if len(m.AttributeMap) > 0 {
		for k, v := range m.AttributeMap {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTrace(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTrace(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTrace(uint64(mapEntrySize))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	return n
}

func (m *Span_TimeEvent) Size() (n int) {
	var l int
	_ = l
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Span_TimeEvent_Annotation_) Size() (n int) {
	var l int
	_ = l
	if m.Annotation != nil {
		l = m.Annotation.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}
func (m *Span_TimeEvent_MessageEvent_) Size() (n int) {
	var l int
	_ = l
	if m.MessageEvent != nil {
		l = m.MessageEvent.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}
func (m *Span_TimeEvent_Annotation) Size() (n int) {
	var l int
	_ = l
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span_TimeEvent_MessageEvent) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovTrace(uint64(m.Type))
	}
	if m.Id != 0 {
		n += 1 + sovTrace(uint64(m.Id))
	}
	if m.UncompressedSize != 0 {
		n += 1 + sovTrace(uint64(m.UncompressedSize))
	}
	if m.CompressedSize != 0 {
		n += 1 + sovTrace(uint64(m.CompressedSize))
	}
	return n
}

func (m *Span_TimeEvents) Size() (n int) {
	var l int
	_ = l
	if len(m.TimeEvent) > 0 {
		for _, e := range m.TimeEvent {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAnnotationsCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAnnotationsCount))
	}
	if m.DroppedMessageEventsCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedMessageEventsCount))
	}
	return n
}

func (m *Span_Link) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovTrace(uint64(m.Type))
	}
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span_Links) Size() (n int) {
	var l int
	_ = l
	if len(m.Link) > 0 {
		for _, e := range m.Link {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedLinksCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedLinksCount))
	}
	return n
}

func (m *Status) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovTrace(uint64(m.Code))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *AttributeValue) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *AttributeValue_StringValue) Size() (n int) {
	var l int
	_ = l
	if m.StringValue != nil {
		l = m.StringValue.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}
func (m *AttributeValue_IntValue) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovTrace(uint64(m.IntValue))
	return n
}
func (m *AttributeValue_BoolValue) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *AttributeValue_DoubleValue) Size() (n int) {
	var l int
	_ = l
	n += 9
	return n
}
func (m *StackTrace) Size() (n int) {
	var l int
	_ = l
	if m.StackFrames != nil {
		l = m.StackFrames.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.StackTraceHashId != 0 {
		n += 1 + sovTrace(uint64(m.StackTraceHashId))
	}
	return n
}

func (m *StackTrace_StackFrame) Size() (n int) {
	var l int
	_ = l
	if m.FunctionName != nil {
		l = m.FunctionName.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.OriginalFunctionName != nil {
		l = m.OriginalFunctionName.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.FileName != nil {
		l = m.FileName.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.LineNumber != 0 {
		n += 1 + sovTrace(uint64(m.LineNumber))
	}
	if m.ColumnNumber != 0 {
		n += 1 + sovTrace(uint64(m.ColumnNumber))
	}
	if m.LoadModule != nil {
		l = m.LoadModule.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.SourceVersion != nil {
		l = m.SourceVersion.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *StackTrace_StackFrames) Size() (n int) {
	var l int
	_ = l
	if len(m.Frame) > 0 {
		for _, e := range m.Frame {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedFramesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedFramesCount))
	}
	return n
}

func (m *Module) Size() (n int) {
	var l int
	_ = l
	if m.Module != nil {
		l = m.Module.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.BuildId != nil {
		l = m.BuildId.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *TruncatableString) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.TruncatedByteCount != 0 {
		n += 1 + sovTrace(uint64(m.TruncatedByteCount))
	}
	return n
}

func sovTrace(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTrace(x uint64) (n int) {
	return sovTrace(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = append(m.ParentSpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.ParentSpanId == nil {
				m.ParentSpanId = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Name == nil {
				m.Name = &TruncatableString{}
			}
			if err := m.Name.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &google_protobuf.Timestamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTime == nil {
				m.EndTime = &google_protobuf.Timestamp{}
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &Span_Attributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTrace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StackTrace == nil {
				m.StackTrace = &StackTrace{}
			}
			if err := m.StackTrace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeEvents == nil {
				m.TimeEvents = &Span_TimeEvents{}
			}
			if err := m.TimeEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Links", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Links == nil {
				m.Links = &Span_Links{}
			}
			if err := m.Links.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SameProcessAsParentSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SameProcessAsParentSpan == nil {
				m.SameProcessAsParentSpan = &google_protobuf1.BoolValue{}
			}
			if err := m.SameProcessAsParentSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChildSpanCount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChildSpanCount == nil {
				m.ChildSpanCount = &google_protobuf1.UInt32Value{}
			}
			if err := m.ChildSpanCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= (Span_SpanKind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracestate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracestate == nil {
				m.Tracestate = &Span_Tracestate{}
			}
			if err := m.Tracestate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Tracestate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tracestate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tracestate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &Span_Tracestate_Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Tracestate_Entry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttributeMap == nil {
				m.AttributeMap = make(map[string]*AttributeValue)
			}
			var mapkey string
			var mapvalue *AttributeValue
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTrace
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTrace
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTrace
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTrace
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTrace
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTrace
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &AttributeValue{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTrace(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTrace
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AttributeMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_TimeEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &google_protobuf.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Span_TimeEvent_Annotation{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Span_TimeEvent_Annotation_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Span_TimeEvent_MessageEvent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Span_TimeEvent_MessageEvent_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_TimeEvent_Annotation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Annotation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Annotation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &TruncatableString{}
			}
			if err := m.Description.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &Span_Attributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_TimeEvent_MessageEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MessageEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MessageEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Span_TimeEvent_MessageEvent_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UncompressedSize", wireType)
			}
			m.UncompressedSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UncompressedSize |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressedSize", wireType)
			}
			m.CompressedSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressedSize |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_TimeEvents) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeEvents: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeEvents: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeEvent = append(m.TimeEvent, &Span_TimeEvent{})
			if err := m.TimeEvent[len(m.TimeEvent)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAnnotationsCount", wireType)
			}
			m.DroppedAnnotationsCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAnnotationsCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedMessageEventsCount", wireType)
			}
			m.DroppedMessageEventsCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedMessageEventsCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Link) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Link: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Link: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Span_Link_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &Span_Attributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Links) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Links: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Links: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Link", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Link = append(m.Link, &Span_Link{})
			if err := m.Link[len(m.Link)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedLinksCount", wireType)
			}
			m.DroppedLinksCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedLinksCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TruncatableString{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &AttributeValue_StringValue{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &AttributeValue_IntValue{v}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &AttributeValue_BoolValue{b}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &AttributeValue_DoubleValue{float64(math.Float64frombits(v))}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StackTrace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StackTrace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StackTrace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackFrames", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StackFrames == nil {
				m.StackFrames = &StackTrace_StackFrames{}
			}
			if err := m.StackFrames.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTraceHashId", wireType)
			}
			m.StackTraceHashId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StackTraceHashId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StackTrace_StackFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StackFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StackFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FunctionName == nil {
				m.FunctionName = &TruncatableString{}
			}
			if err := m.FunctionName.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalFunctionName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OriginalFunctionName == nil {
				m.OriginalFunctionName = &TruncatableString{}
			}
			if err := m.OriginalFunctionName.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FileName == nil {
				m.FileName = &TruncatableString{}
			}
			if err := m.FileName.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LineNumber", wireType)
			}
			m.LineNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LineNumber |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNumber", wireType)
			}
			m.ColumnNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColumnNumber |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadModule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadModule == nil {
				m.LoadModule = &Module{}
			}
			if err := m.LoadModule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceVersion == nil {
				m.SourceVersion = &TruncatableString{}
			}
			if err := m.SourceVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StackTrace_StackFrames) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StackFrames: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StackFrames: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frame", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frame = append(m.Frame, &StackTrace_StackFrame{})
			if err := m.Frame[len(m.Frame)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedFramesCount", wireType)
			}
			m.DroppedFramesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedFramesCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Module) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Module: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Module: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Module", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Module == nil {
				m.Module = &TruncatableString{}
			}
			if err := m.Module.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BuildId == nil {
				m.BuildId = &TruncatableString{}
			}
			if err := m.BuildId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncatableString) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncatableString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncatableString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncatedByteCount", wireType)
			}
			m.TruncatedByteCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TruncatedByteCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTrace(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTrace
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTrace
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTrace(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTrace = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTrace   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("opencensus/proto/trace/v1/trace.proto", fileDescriptorTrace) }

var fileDescriptorTrace = []byte{
	// 1504 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x5b, 0x6f, 0x1b, 0xc5,
	0x17, 0xcf, 0xda, 0xeb, 0xdb, 0xb1, 0xe3, 0x3a, 0xd3, 0xb4, 0xdd, 0xf8, 0xdf, 0x7f, 0x1a, 0xdc,
	0x56, 0xa4, 0x5c, 0x9c, 0xd6, 0x2d, 0x55, 0xaf, 0x2a, 0xb9, 0x38, 0xd8, 0x4d, 0x6a, 0xdc, 0xb1,
	0x1b, 0x81, 0x10, 0x5a, 0xad, 0xbd, 0x93, 0x64, 0x89, 0xbd, 0xbb, 0xec, 0xcc, 0x06, 0xa5, 0x6f,
	0x3c, 0x21, 0xc4, 0x0b, 0x42, 0x42, 0x7c, 0x01, 0x1e, 0xf8, 0x28, 0x3c, 0x82, 0xf8, 0x02, 0xa8,
	0x3c, 0xf3, 0x09, 0x78, 0x41, 0x33, 0xb3, 0xbb, 0x5e, 0xa7, 0x6d, 0x62, 0xdc, 0x17, 0x6b, 0x66,
	0xce, 0xf9, 0xfd, 0x76, 0xce, 0x9c, 0xab, 0xe1, 0xaa, 0xe3, 0x12, 0xbb, 0x4f, 0x6c, 0xea, 0xd3,
	0x15, 0xd7, 0x73, 0x98, 0xb3, 0xc2, 0x3c, 0xa3, 0x4f, 0x56, 0x0e, 0x6f, 0xc8, 0x45, 0x55, 0x1c,
	0xa2, 0x85, 0x91, 0x9a, 0x3c, 0xa9, 0x4a, 0xe9, 0xe1, 0x8d, 0xf2, 0xa5, 0x3d, 0xc7, 0xd9, 0x1b,
	0x10, 0x89, 0xee, 0xf9, 0xbb, 0x2b, 0xcc, 0x1a, 0x12, 0xca, 0x8c, 0xa1, 0x2b, 0x35, 0xcb, 0x8b,
	0xc7, 0x15, 0xbe, 0xf2, 0x0c, 0xd7, 0x25, 0x5e, 0xc0, 0x54, 0xf9, 0xfa, 0x1c, 0xa8, 0x1d, 0xd7,
	0xb0, 0xd1, 0x02, 0x64, 0x05, 0xab, 0x6e, 0x99, 0x9a, 0xb2, 0xa4, 0x2c, 0x17, 0x70, 0x46, 0xec,
	0x9b, 0x26, 0xba, 0x00, 0x19, 0xea, 0x1a, 0x36, 0x97, 0x24, 0x84, 0x24, 0xcd, 0xb7, 0x4d, 0x13,
	0x5d, 0x81, 0xa2, 0x6b, 0x78, 0xc4, 0x66, 0x7a, 0x28, 0x4f, 0x0a, 0x79, 0x41, 0x9e, 0x76, 0xa4,
	0xd6, 0x87, 0xa0, 0xda, 0xc6, 0x90, 0x68, 0xea, 0x92, 0xb2, 0x9c, 0xaf, 0xbd, 0x57, 0x7d, 0xad,
	0x35, 0xd5, 0xae, 0xe7, 0xdb, 0x7d, 0x83, 0x19, 0xbd, 0x01, 0xe9, 0x30, 0xcf, 0xb2, 0xf7, 0xb0,
	0x40, 0xa2, 0xbb, 0x00, 0x94, 0x19, 0x1e, 0xd3, 0xb9, 0x75, 0x5a, 0x4a, 0xf0, 0x94, 0xab, 0xd2,
	0xb2, 0x6a, 0x68, 0x59, 0xb5, 0x1b, 0x9a, 0x8e, 0x73, 0x42, 0x9b, 0xef, 0xd1, 0x07, 0x90, 0x25,
	0xb6, 0x29, 0x81, 0xe9, 0x53, 0x81, 0x19, 0x62, 0x9b, 0x02, 0xf6, 0x18, 0xc0, 0x60, 0xcc, 0xb3,
	0x7a, 0x3e, 0x23, 0x54, 0xcb, 0x08, 0xe0, 0x3b, 0x27, 0xdc, 0x9c, 0x9b, 0x5a, 0x5d, 0x8d, 0x10,
	0x38, 0x86, 0x46, 0x9b, 0x90, 0xa7, 0xcc, 0xe8, 0x1f, 0xe8, 0x42, 0x5b, 0xcb, 0x0a, 0xb2, 0xab,
	0x27, 0x91, 0x71, 0xed, 0x2e, 0xdf, 0x61, 0xa0, 0xd1, 0x1a, 0x6d, 0x41, 0x9e, 0x9b, 0xa1, 0x93,
	0x43, 0x62, 0x33, 0xaa, 0xe5, 0x26, 0xbb, 0x14, 0x37, 0xa7, 0x2e, 0x10, 0x18, 0x58, 0xb4, 0x46,
	0xf7, 0x21, 0x35, 0xb0, 0xec, 0x03, 0xaa, 0xc1, 0xe9, 0xd7, 0xe1, 0x34, 0xdb, 0x5c, 0x19, 0x4b,
	0x0c, 0xba, 0x0b, 0x69, 0xca, 0x0c, 0xe6, 0x53, 0x2d, 0x2f, 0xd0, 0x6f, 0x9d, 0x6c, 0x0c, 0xf3,
	0x29, 0x0e, 0x00, 0xe8, 0x13, 0xf8, 0x1f, 0x35, 0x86, 0x44, 0x77, 0x3d, 0xa7, 0x4f, 0x28, 0xd5,
	0x0d, 0xaa, 0xc7, 0x42, 0x48, 0x2b, 0xbc, 0xc6, 0x45, 0x6b, 0x8e, 0x33, 0xd8, 0x31, 0x06, 0x3e,
	0xc1, 0x17, 0x38, 0xbc, 0x2d, 0xd1, 0xab, 0xb4, 0x1d, 0x05, 0x1a, 0xda, 0x84, 0x52, 0x7f, 0xdf,
	0x1a, 0x98, 0x32, 0x16, 0xfb, 0x8e, 0x6f, 0x33, 0x6d, 0x56, 0xd0, 0x5d, 0x7c, 0x89, 0xee, 0x59,
	0xd3, 0x66, 0x37, 0x6b, 0x92, 0xb0, 0x28, 0x50, 0x9c, 0x62, 0x9d, 0x63, 0xd0, 0x03, 0x50, 0x0f,
	0x2c, 0xdb, 0xd4, 0x8a, 0x4b, 0xca, 0x72, 0xb1, 0xb6, 0x7c, 0xda, 0xc3, 0xf0, 0x9f, 0x2d, 0xcb,
	0x36, 0xb1, 0x40, 0xf1, 0xc0, 0x11, 0x72, 0x6e, 0x2e, 0xd1, 0xce, 0x4c, 0xe8, 0xa3, 0x08, 0x81,
	0x63, 0xe8, 0xf2, 0xb7, 0x0a, 0xc0, 0x48, 0x84, 0x1e, 0x43, 0x86, 0xd8, 0xcc, 0xb3, 0x08, 0xd5,
	0x94, 0xa5, 0xe4, 0x72, 0xbe, 0x76, 0x7d, 0x72, 0xde, 0x6a, 0xdd, 0x66, 0xde, 0x11, 0x0e, 0x09,
	0xca, 0x2b, 0x90, 0x12, 0x27, 0xa8, 0x04, 0xc9, 0x03, 0x72, 0x24, 0x32, 0x3e, 0x87, 0xf9, 0x12,
	0xcd, 0x43, 0xea, 0x90, 0x3f, 0x8c, 0xc8, 0xf5, 0x1c, 0x96, 0x9b, 0xf2, 0x8f, 0x09, 0x80, 0x51,
	0x7c, 0x23, 0x03, 0x66, 0xa3, 0x08, 0xd7, 0x87, 0x86, 0x1b, 0xdc, 0xe8, 0xc1, 0xe4, 0x29, 0x32,
	0x5a, 0x3e, 0x31, 0x5c, 0x79, 0xbb, 0x82, 0x11, 0x3b, 0x42, 0x77, 0x40, 0x33, 0x3d, 0xc7, 0x75,
	0x89, 0xa9, 0x8f, 0x92, 0x29, 0xf0, 0x2b, 0xbf, 0x5a, 0x0a, 0x9f, 0x0f, 0xe4, 0x23, 0x52, 0xe1,
	0xc1, 0xf2, 0x17, 0x30, 0xf7, 0x12, 0xf9, 0x2b, 0x0c, 0x7d, 0x14, 0x37, 0x34, 0x5f, 0xbb, 0x76,
	0xc2, 0xdd, 0x23, 0x3a, 0x19, 0x32, 0x12, 0x77, 0x2f, 0x71, 0x47, 0x29, 0xff, 0x9c, 0x82, 0x5c,
	0x94, 0x62, 0xa8, 0x0a, 0xaa, 0xa8, 0x34, 0xca, 0xa9, 0x95, 0x46, 0xe8, 0xa1, 0x1d, 0x00, 0xc3,
	0xb6, 0x1d, 0x66, 0x30, 0xcb, 0xb1, 0x83, 0x7b, 0xdc, 0x9a, 0x38, 0xa3, 0xab, 0xab, 0x11, 0xb6,
	0x31, 0x83, 0x63, 0x4c, 0xe8, 0x73, 0x98, 0x1d, 0x12, 0x4a, 0x8d, 0xbd, 0xa0, 0x5a, 0x88, 0xba,
	0x9c, 0xaf, 0xdd, 0x9e, 0x9c, 0xfa, 0x89, 0x84, 0x8b, 0x4d, 0x63, 0x06, 0x17, 0x86, 0xb1, 0x7d,
	0xf9, 0x17, 0x05, 0x60, 0xf4, 0x6d, 0xd4, 0x82, 0xbc, 0x49, 0x68, 0xdf, 0xb3, 0x5c, 0x61, 0x86,
	0x32, 0x45, 0x9d, 0x8f, 0x13, 0x1c, 0x2b, 0xbe, 0x89, 0x37, 0x29, 0xbe, 0xe5, 0x7f, 0x14, 0x28,
	0xc4, 0x6d, 0x41, 0x1f, 0x83, 0xca, 0x8e, 0x5c, 0xe9, 0xa2, 0x62, 0xed, 0xfe, 0x74, 0x2f, 0x52,
	0xed, 0x1e, 0xb9, 0x04, 0x0b, 0x22, 0x54, 0x84, 0x44, 0xd0, 0x18, 0x55, 0x9c, 0xb0, 0x4c, 0xf4,
	0x2e, 0xcc, 0xf9, 0x76, 0xdf, 0x19, 0xba, 0x1e, 0xa1, 0x94, 0x98, 0x3a, 0xb5, 0x9e, 0x13, 0xf1,
	0xfe, 0x2a, 0x2e, 0xc5, 0x05, 0x1d, 0xeb, 0x39, 0x41, 0x6f, 0xc3, 0x99, 0xe3, 0xaa, 0xaa, 0x50,
	0x2d, 0x8e, 0x2b, 0x56, 0x6e, 0x81, 0xca, 0xbf, 0x89, 0xe6, 0xa1, 0xd4, 0xfd, 0xb4, 0x5d, 0xd7,
	0x9f, 0xb5, 0x3a, 0xed, 0xfa, 0x7a, 0x73, 0xb3, 0x59, 0xdf, 0x28, 0xcd, 0xa0, 0x2c, 0xa8, 0x9d,
	0x7a, 0xab, 0x5b, 0x52, 0x50, 0x01, 0xb2, 0xb8, 0xbe, 0x5e, 0x6f, 0xee, 0xd4, 0x37, 0x4a, 0x89,
	0xb5, 0x4c, 0x10, 0xe2, 0xe5, 0x3f, 0x78, 0x29, 0x19, 0x55, 0xff, 0x06, 0xc0, 0xa8, 0x95, 0x04,
	0xb9, 0x7b, 0x6d, 0xe2, 0xa7, 0xc0, 0xb9, 0xa8, 0x91, 0xa0, 0x7b, 0xb0, 0x10, 0x65, 0x69, 0x14,
	0x11, 0xe3, 0x69, 0x7a, 0x21, 0x4c, 0xd3, 0x91, 0x5c, 0x56, 0xda, 0x47, 0x70, 0x31, 0xc4, 0x8e,
	0x45, 0x6b, 0x08, 0x4f, 0x0a, 0x78, 0xc8, 0x1f, 0x7f, 0xff, 0x20, 0xd1, 0x7f, 0x48, 0x80, 0xca,
	0x1b, 0xd3, 0x54, 0xc3, 0xcb, 0xc3, 0x20, 0x10, 0x92, 0x22, 0x10, 0xae, 0x4d, 0xd2, 0x00, 0xe3,
	0x6e, 0x1f, 0x0f, 0x52, 0xf5, 0x4d, 0x82, 0xb4, 0xb2, 0x75, 0xa2, 0x73, 0xcf, 0xc1, 0xdc, 0x7a,
	0xa3, 0xb9, 0xbd, 0xa1, 0x6f, 0x37, 0x5b, 0x5b, 0xf5, 0x0d, 0xbd, 0xd3, 0x5e, 0x6d, 0x95, 0x14,
	0x74, 0x1e, 0x50, 0x7b, 0x15, 0xd7, 0x5b, 0xdd, 0xb1, 0xf3, 0x44, 0xf9, 0x4b, 0x48, 0x89, 0x66,
	0x8d, 0xee, 0x80, 0xca, 0xdb, 0x75, 0xe0, 0xde, 0x2b, 0x93, 0x18, 0x88, 0x05, 0x02, 0x55, 0xe1,
	0x6c, 0xe8, 0x18, 0xd1, 0xf0, 0xc7, 0xdc, 0x39, 0x17, 0x88, 0xc4, 0x47, 0x84, 0x1f, 0x2a, 0x0f,
	0x21, 0x1b, 0xb6, 0x41, 0xb4, 0x00, 0xe7, 0xf8, 0x45, 0xf4, 0xad, 0x66, 0x6b, 0xe3, 0x98, 0x21,
	0x00, 0xe9, 0x4e, 0x1d, 0xef, 0xd4, 0x71, 0x49, 0xe1, 0xeb, 0xf5, 0xed, 0x26, 0x8f, 0xd9, 0x44,
	0xe5, 0x36, 0xa4, 0xe5, 0x94, 0x80, 0x10, 0xa8, 0x7d, 0xc7, 0x94, 0xc9, 0x99, 0xc2, 0x62, 0x8d,
	0x34, 0xc8, 0x04, 0xd1, 0x11, 0x74, 0xa4, 0x70, 0x5b, 0xf9, 0x5d, 0x81, 0xe2, 0x78, 0x65, 0x46,
	0x4f, 0xa1, 0x40, 0x45, 0x45, 0xd1, 0x65, 0x69, 0x9f, 0xa2, 0x16, 0x35, 0x66, 0x70, 0x5e, 0x72,
	0x48, 0xca, 0xff, 0x43, 0xce, 0xb2, 0x99, 0x3e, 0x6a, 0x15, 0xc9, 0xc6, 0x0c, 0xce, 0x5a, 0x36,
	0x93, 0xe2, 0x4b, 0x00, 0x3d, 0xc7, 0x19, 0x04, 0x72, 0x1e, 0x4c, 0xd9, 0xc6, 0x0c, 0xce, 0xf5,
	0xc2, 0x81, 0x05, 0x5d, 0x86, 0x82, 0xe9, 0xf8, 0xbd, 0x01, 0x09, 0x54, 0x78, 0xa8, 0x28, 0xfc,
	0x23, 0xf2, 0x54, 0x28, 0x45, 0x89, 0x5a, 0xf9, 0x2e, 0x0d, 0x30, 0x9a, 0xff, 0x50, 0x97, 0xdb,
	0xc3, 0x67, 0xc7, 0x5d, 0xcf, 0x18, 0x8a, 0xc6, 0xcf, 0xed, 0xb9, 0x31, 0xd1, 0xf0, 0x28, 0x97,
	0x9b, 0x02, 0x88, 0xe5, 0x08, 0x2a, 0x37, 0xe8, 0x7d, 0x38, 0x1b, 0x9b, 0x48, 0xf5, 0x7d, 0x83,
	0xee, 0xeb, 0x51, 0x0d, 0x2b, 0x8d, 0x46, 0xce, 0x86, 0x41, 0xf7, 0x9b, 0x66, 0xf9, 0xef, 0x64,
	0x70, 0x27, 0x01, 0x47, 0x4f, 0x61, 0x76, 0xd7, 0xb7, 0xfb, 0x3c, 0x91, 0x75, 0x31, 0xd8, 0x4f,
	0x53, 0xf0, 0x0b, 0x21, 0x45, 0x8b, 0x53, 0xf6, 0xe0, 0xbc, 0xe3, 0x59, 0x7b, 0x96, 0x6d, 0x0c,
	0xf4, 0x71, 0xee, 0xc4, 0x14, 0xdc, 0xf3, 0x21, 0xd7, 0x66, 0xfc, 0x1b, 0x4d, 0xc8, 0xed, 0x5a,
	0x03, 0x22, 0x69, 0x93, 0x53, 0xd0, 0x66, 0x39, 0x5c, 0x50, 0x5d, 0x82, 0xfc, 0xc0, 0xb2, 0x89,
	0x6e, 0xfb, 0xc3, 0x1e, 0xf1, 0x84, 0x47, 0x93, 0x18, 0xf8, 0x51, 0x4b, 0x9c, 0xa0, 0xcb, 0x30,
	0xdb, 0x77, 0x06, 0xfe, 0xd0, 0x0e, 0x55, 0x52, 0x42, 0xa5, 0x20, 0x0f, 0x03, 0xa5, 0x35, 0xc8,
	0x0f, 0x1c, 0xc3, 0xd4, 0x87, 0x8e, 0xe9, 0x0f, 0xc2, 0x7f, 0x27, 0x27, 0x8d, 0xd2, 0x4f, 0x84,
	0x22, 0x06, 0x8e, 0x92, 0x6b, 0xd4, 0x81, 0x22, 0x75, 0x7c, 0xaf, 0x4f, 0xf4, 0x43, 0xe2, 0x51,
	0xde, 0x7d, 0x33, 0x53, 0x58, 0x36, 0x2b, 0x39, 0x76, 0x24, 0x45, 0xf9, 0x1b, 0x05, 0xf2, 0xb1,
	0xd8, 0x41, 0x9b, 0x90, 0x12, 0xe1, 0x37, 0xc9, 0xd8, 0xf9, 0xaa, 0xe8, 0xc3, 0x12, 0x8e, 0xae,
	0xc3, 0x7c, 0x58, 0x56, 0x64, 0x38, 0x8f, 0xd5, 0x15, 0x14, 0xc8, 0xe4, 0x47, 0x65, 0x61, 0xf9,
	0x49, 0x81, 0x74, 0x60, 0xe9, 0x06, 0xa4, 0x83, 0x87, 0x9a, 0x26, 0xdc, 0x02, 0x2c, 0xfa, 0x08,
	0xb2, 0x3d, 0x9f, 0xff, 0x49, 0x08, 0xc2, 0xfd, 0xbf, 0xf2, 0x64, 0x04, 0xba, 0x69, 0x56, 0x3e,
	0x83, 0xb9, 0x97, 0xa4, 0xa3, 0xd1, 0x59, 0x89, 0x8d, 0xce, 0xdc, 0x6c, 0x26, 0x55, 0x89, 0xa9,
	0xf7, 0x8e, 0x18, 0x19, 0x37, 0x3b, 0x92, 0xad, 0x1d, 0x31, 0x22, 0xcc, 0x5e, 0x7b, 0xf0, 0xeb,
	0x8b, 0x45, 0xe5, 0xb7, 0x17, 0x8b, 0xca, 0x9f, 0x2f, 0x16, 0x95, 0xef, 0xff, 0x5a, 0x9c, 0x81,
	0x8b, 0x96, 0xf3, 0xfa, 0x7b, 0xae, 0xc9, 0x7f, 0x09, 0x6d, 0x7e, 0xd8, 0x56, 0x7a, 0x69, 0x21,
	0xbd, 0xf9, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1a, 0x9c, 0xc4, 0xd9, 0x5e, 0x10, 0x00, 0x00,
}
