// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/config/client/quota.proto

package client

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Determines the quotas used for individual requests.
type QuotaSpec struct {
	// A list of Quota rules.
	Rules []*QuotaRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (m *QuotaSpec) Reset()      { *m = QuotaSpec{} }
func (*QuotaSpec) ProtoMessage() {}
func (*QuotaSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{0}
}
func (m *QuotaSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *QuotaSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaSpec.Merge(m, src)
}
func (m *QuotaSpec) XXX_Size() int {
	return m.Size()
}
func (m *QuotaSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaSpec.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaSpec proto.InternalMessageInfo

// Specifies a rule with list of matches and list of quotas.
// If any clause matched, the list of quotas will be used.
type QuotaRule struct {
	// If empty, match all request.
	// If any of match is true, it is matched.
	Match []*AttributeMatch `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// The list of quotas to charge.
	Quotas []*Quota `protobuf:"bytes,2,rep,name=quotas,proto3" json:"quotas,omitempty"`
}

func (m *QuotaRule) Reset()      { *m = QuotaRule{} }
func (*QuotaRule) ProtoMessage() {}
func (*QuotaRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{1}
}
func (m *QuotaRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *QuotaRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaRule.Merge(m, src)
}
func (m *QuotaRule) XXX_Size() int {
	return m.Size()
}
func (m *QuotaRule) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaRule.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaRule proto.InternalMessageInfo

// Describes how to match a given string in HTTP headers. Match is
// case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Regex
	MatchType isStringMatch_MatchType `protobuf_oneof:"match_type"`
}

func (m *StringMatch) Reset()      { *m = StringMatch{} }
func (*StringMatch) ProtoMessage() {}
func (*StringMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{2}
}
func (m *StringMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StringMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringMatch.Merge(m, src)
}
func (m *StringMatch) XXX_Size() int {
	return m.Size()
}
func (m *StringMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_StringMatch.DiscardUnknown(m)
}

var xxx_messageInfo_StringMatch proto.InternalMessageInfo

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StringMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StringMatch_OneofMarshaler, _StringMatch_OneofUnmarshaler, _StringMatch_OneofSizer, []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

func _StringMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Exact)
	case *StringMatch_Prefix:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Prefix)
	case *StringMatch_Regex:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("StringMatch.MatchType has unexpected type %T", x)
	}
	return nil
}

func _StringMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StringMatch)
	switch tag {
	case 1: // match_type.exact
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Exact{x}
		return true, err
	case 2: // match_type.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Prefix{x}
		return true, err
	case 3: // match_type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _StringMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Exact)))
		n += len(x.Exact)
	case *StringMatch_Prefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *StringMatch_Regex:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a match clause to match Istio attributes
type AttributeMatch struct {
	// Map of attribute names to StringMatch type.
	// Each map element specifies one condition to match.
	//
	// Example:
	//
	//   clause:
	//     source.uid:
	//       exact: SOURCE_UID
	//     request.http_method:
	//       exact: POST
	Clause map[string]*StringMatch `protobuf:"bytes,1,rep,name=clause,proto3" json:"clause,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *AttributeMatch) Reset()      { *m = AttributeMatch{} }
func (*AttributeMatch) ProtoMessage() {}
func (*AttributeMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{3}
}
func (m *AttributeMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AttributeMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeMatch.Merge(m, src)
}
func (m *AttributeMatch) XXX_Size() int {
	return m.Size()
}
func (m *AttributeMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeMatch.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeMatch proto.InternalMessageInfo

// Specifies a quota to use with quota name and amount.
type Quota struct {
	// The quota name to charge
	Quota string `protobuf:"bytes,1,opt,name=quota,proto3" json:"quota,omitempty"`
	// The quota amount to charge
	Charge int64 `protobuf:"varint,2,opt,name=charge,proto3" json:"charge,omitempty"`
}

func (m *Quota) Reset()      { *m = Quota{} }
func (*Quota) ProtoMessage() {}
func (*Quota) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{4}
}
func (m *Quota) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Quota) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Quota) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quota.Merge(m, src)
}
func (m *Quota) XXX_Size() int {
	return m.Size()
}
func (m *Quota) XXX_DiscardUnknown() {
	xxx_messageInfo_Quota.DiscardUnknown(m)
}

var xxx_messageInfo_Quota proto.InternalMessageInfo

// QuotaSpecBinding defines the binding between QuotaSpecs and one or more
// IstioService.
type QuotaSpecBinding struct {
	// REQUIRED. One or more services to map the listed QuotaSpec onto.
	Services []*IstioService `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// REQUIRED. One or more QuotaSpec references that should be mapped to
	// the specified service(s). The aggregate collection of match
	// conditions defined in the QuotaSpecs should not overlap.
	QuotaSpecs []*QuotaSpecBinding_QuotaSpecReference `protobuf:"bytes,2,rep,name=quota_specs,json=quotaSpecs,proto3" json:"quota_specs,omitempty"`
}

func (m *QuotaSpecBinding) Reset()      { *m = QuotaSpecBinding{} }
func (*QuotaSpecBinding) ProtoMessage() {}
func (*QuotaSpecBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{5}
}
func (m *QuotaSpecBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaSpecBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *QuotaSpecBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaSpecBinding.Merge(m, src)
}
func (m *QuotaSpecBinding) XXX_Size() int {
	return m.Size()
}
func (m *QuotaSpecBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaSpecBinding.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaSpecBinding proto.InternalMessageInfo

// QuotaSpecReference uniquely identifies the QuotaSpec used in the
// Binding.
type QuotaSpecBinding_QuotaSpecReference struct {
	// REQUIRED. The short name of the QuotaSpec. This is the resource
	// name defined by the metadata name field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional namespace of the QuotaSpec. Defaults to the value of the
	// metadata namespace field.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *QuotaSpecBinding_QuotaSpecReference) Reset()      { *m = QuotaSpecBinding_QuotaSpecReference{} }
func (*QuotaSpecBinding_QuotaSpecReference) ProtoMessage() {}
func (*QuotaSpecBinding_QuotaSpecReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_81777b5d047af315, []int{5, 0}
}
func (m *QuotaSpecBinding_QuotaSpecReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaSpecBinding_QuotaSpecReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *QuotaSpecBinding_QuotaSpecReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaSpecBinding_QuotaSpecReference.Merge(m, src)
}
func (m *QuotaSpecBinding_QuotaSpecReference) XXX_Size() int {
	return m.Size()
}
func (m *QuotaSpecBinding_QuotaSpecReference) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaSpecBinding_QuotaSpecReference.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaSpecBinding_QuotaSpecReference proto.InternalMessageInfo

func init() {
	proto.RegisterType((*QuotaSpec)(nil), "istio.mixer.v1.config.client.QuotaSpec")
	proto.RegisterType((*QuotaRule)(nil), "istio.mixer.v1.config.client.QuotaRule")
	proto.RegisterType((*StringMatch)(nil), "istio.mixer.v1.config.client.StringMatch")
	proto.RegisterType((*AttributeMatch)(nil), "istio.mixer.v1.config.client.AttributeMatch")
	proto.RegisterMapType((map[string]*StringMatch)(nil), "istio.mixer.v1.config.client.AttributeMatch.ClauseEntry")
	proto.RegisterType((*Quota)(nil), "istio.mixer.v1.config.client.Quota")
	proto.RegisterType((*QuotaSpecBinding)(nil), "istio.mixer.v1.config.client.QuotaSpecBinding")
	proto.RegisterType((*QuotaSpecBinding_QuotaSpecReference)(nil), "istio.mixer.v1.config.client.QuotaSpecBinding.QuotaSpecReference")
}

func init() { proto.RegisterFile("mixer/v1/config/client/quota.proto", fileDescriptor_81777b5d047af315) }

var fileDescriptor_81777b5d047af315 = []byte{
	// 540 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x93, 0xcf, 0x6b, 0x13, 0x41,
	0x14, 0xc7, 0x77, 0x12, 0x37, 0x98, 0x17, 0x91, 0x32, 0x94, 0xb2, 0x84, 0x32, 0x94, 0xad, 0x60,
	0x15, 0xd9, 0xa5, 0x15, 0xa1, 0x28, 0x22, 0x8d, 0x58, 0x54, 0x10, 0x74, 0x7a, 0xf3, 0x52, 0x36,
	0xdb, 0x97, 0xed, 0x60, 0xb2, 0xbb, 0xdd, 0x9d, 0x0d, 0xc9, 0xcd, 0x93, 0x27, 0x0f, 0xfe, 0x19,
	0xfe, 0x29, 0x39, 0xe6, 0x98, 0xa3, 0xd9, 0x5c, 0x3c, 0xf6, 0x4f, 0x90, 0x9d, 0x99, 0xb4, 0x11,
	0x35, 0xd4, 0xd3, 0xbe, 0xf7, 0xf6, 0x7d, 0xbe, 0xef, 0x07, 0x6f, 0xc0, 0x1d, 0x88, 0x11, 0x66,
	0xfe, 0x70, 0xdf, 0x0f, 0x93, 0xb8, 0x27, 0x22, 0x3f, 0xec, 0x0b, 0x8c, 0xa5, 0x7f, 0x51, 0x24,
	0x32, 0xf0, 0xd2, 0x2c, 0x91, 0x09, 0xdd, 0x16, 0xb9, 0x14, 0x89, 0xa7, 0x32, 0xbd, 0xe1, 0xbe,
	0xa7, 0x33, 0x3d, 0x9d, 0xd9, 0xde, 0x8c, 0x92, 0x28, 0x51, 0x89, 0x7e, 0x65, 0x69, 0xa6, 0x7d,
	0xef, 0x1f, 0xba, 0x39, 0x66, 0x43, 0x11, 0xa2, 0xce, 0x72, 0xdf, 0x42, 0xf3, 0x43, 0x55, 0xe8,
	0x24, 0xc5, 0x90, 0x3e, 0x07, 0x3b, 0x2b, 0xfa, 0x98, 0x3b, 0x64, 0xa7, 0xbe, 0xd7, 0x3a, 0xb8,
	0xef, 0xad, 0x2b, 0xeb, 0x29, 0x8e, 0x17, 0x7d, 0xe4, 0x9a, 0x72, 0xbf, 0x12, 0x23, 0x56, 0x05,
	0x69, 0x07, 0xec, 0x41, 0x20, 0xc3, 0x73, 0x23, 0xf6, 0x68, 0xbd, 0xd8, 0x91, 0x94, 0x99, 0xe8,
	0x16, 0x12, 0xdf, 0x55, 0x0c, 0xd7, 0x28, 0x7d, 0x06, 0x0d, 0xb5, 0x86, 0xdc, 0xa9, 0x29, 0x91,
	0xdd, 0x9b, 0x74, 0x64, 0x10, 0x17, 0xa1, 0x75, 0x22, 0x33, 0x11, 0x47, 0x4a, 0x92, 0x6e, 0x81,
	0x8d, 0xa3, 0x20, 0x94, 0x0e, 0xd9, 0x21, 0x7b, 0xcd, 0xd7, 0x16, 0xd7, 0x2e, 0x75, 0xa0, 0x91,
	0x66, 0xd8, 0x13, 0x23, 0xa7, 0x66, 0x7e, 0x18, 0xbf, 0x22, 0x32, 0x8c, 0x70, 0xe4, 0xd4, 0x97,
	0x84, 0x72, 0x3b, 0x77, 0x00, 0x54, 0x7b, 0xa7, 0x72, 0x9c, 0xa2, 0x3b, 0x21, 0x70, 0xf7, 0xf7,
	0xee, 0xe9, 0x7b, 0x68, 0x84, 0xfd, 0xa0, 0xc8, 0xd1, 0xcc, 0x7e, 0xf8, 0x3f, 0xb3, 0x7b, 0x2f,
	0x15, 0xfa, 0x2a, 0x96, 0xd9, 0x98, 0x1b, 0x9d, 0xf6, 0x19, 0xb4, 0x56, 0xc2, 0x74, 0x03, 0xea,
	0x9f, 0x70, 0xac, 0x27, 0xe1, 0x95, 0x49, 0x5f, 0x80, 0x3d, 0x0c, 0xfa, 0x05, 0xaa, 0x21, 0x5a,
	0x07, 0x0f, 0xd6, 0x57, 0x5c, 0xd9, 0x0b, 0xd7, 0xdc, 0xd3, 0xda, 0x21, 0x71, 0x9f, 0x80, 0xad,
	0x56, 0x48, 0x37, 0xc1, 0x56, 0x4b, 0x34, 0x15, 0xb4, 0x43, 0xb7, 0xa0, 0x11, 0x9e, 0x07, 0x59,
	0xa4, 0x8b, 0xd4, 0xb9, 0xf1, 0xdc, 0x2f, 0x35, 0xd8, 0xb8, 0x3a, 0xa2, 0x8e, 0x88, 0xcf, 0x44,
	0x1c, 0xd1, 0x63, 0xb8, 0x6d, 0x2e, 0x6d, 0x79, 0x4e, 0x0f, 0xd7, 0xf7, 0xf4, 0xa6, 0xfa, 0x79,
	0xa2, 0x11, 0x7e, 0xc5, 0xd2, 0x2e, 0xb4, 0x54, 0xf5, 0xd3, 0x3c, 0xc5, 0x70, 0x79, 0x07, 0x47,
	0x37, 0xb8, 0x83, 0x95, 0x66, 0xae, 0x03, 0x1c, 0x7b, 0x98, 0x61, 0x1c, 0x22, 0x87, 0x8b, 0x65,
	0x2c, 0x6f, 0x1f, 0x03, 0xfd, 0x33, 0x83, 0x52, 0xb8, 0x15, 0x07, 0x03, 0x34, 0x3b, 0x50, 0x36,
	0xdd, 0x86, 0x66, 0xf5, 0xcd, 0xd3, 0x20, 0xd4, 0x5b, 0x68, 0xf2, 0xeb, 0x40, 0x27, 0x98, 0xcc,
	0x99, 0x35, 0x9d, 0x33, 0x6b, 0x36, 0x67, 0xd6, 0xe5, 0x9c, 0x59, 0x9f, 0x4b, 0x46, 0xbe, 0x97,
	0xcc, 0x9a, 0x94, 0x8c, 0x4c, 0x4b, 0x46, 0x66, 0x25, 0x23, 0x3f, 0x4a, 0x46, 0x7e, 0x96, 0xcc,
	0xba, 0x2c, 0x19, 0xf9, 0xb6, 0x60, 0xd6, 0x74, 0xc1, 0xac, 0xd9, 0x82, 0x59, 0x1f, 0x77, 0xf5,
	0x4c, 0x22, 0xf1, 0x83, 0x54, 0xf8, 0x7f, 0x7f, 0xbd, 0xdd, 0x86, 0x7a, 0xb6, 0x8f, 0x7f, 0x05,
	0x00, 0x00, 0xff, 0xff, 0xb5, 0x3a, 0x59, 0xa6, 0x36, 0x04, 0x00, 0x00,
}

func (m *QuotaSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuota(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *QuotaRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Quotas) > 0 {
		for iNdEx := len(m.Quotas) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Quotas[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuota(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Match) > 0 {
		for iNdEx := len(m.Match) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Match[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuota(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *StringMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MatchType != nil {
		{
			size := m.MatchType.Size()
			i -= size
			if _, err := m.MatchType.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *StringMatch_Exact) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Exact) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Exact)
	copy(dAtA[i:], m.Exact)
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Exact)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *StringMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Prefix) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Prefix)
	copy(dAtA[i:], m.Prefix)
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Prefix)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *StringMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Regex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Regex)
	copy(dAtA[i:], m.Regex)
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Regex)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *AttributeMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttributeMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Clause) > 0 {
		keysForClause := make([]string, 0, len(m.Clause))
		for k := range m.Clause {
			keysForClause = append(keysForClause, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForClause)
		for iNdEx := len(keysForClause) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Clause[string(keysForClause[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintQuota(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForClause[iNdEx])
			copy(dAtA[i:], keysForClause[iNdEx])
			i = encodeVarintQuota(dAtA, i, uint64(len(keysForClause[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintQuota(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Quota) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Quota) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Quota) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Charge != 0 {
		i = encodeVarintQuota(dAtA, i, uint64(m.Charge))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Quota) > 0 {
		i -= len(m.Quota)
		copy(dAtA[i:], m.Quota)
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Quota)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuotaSpecBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpecBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaSpecBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.QuotaSpecs) > 0 {
		for iNdEx := len(m.QuotaSpecs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QuotaSpecs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuota(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Services) > 0 {
		for iNdEx := len(m.Services) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Services[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQuota(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *QuotaSpecBinding_QuotaSpecReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpecBinding_QuotaSpecReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaSpecBinding_QuotaSpecReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintQuota(dAtA []byte, offset int, v uint64) int {
	offset -= sovQuota(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QuotaSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, e := range m.Match {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	if len(m.Quotas) > 0 {
		for _, e := range m.Quotas {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *StringMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchType != nil {
		n += m.MatchType.Size()
	}
	return n
}

func (m *StringMatch_Exact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Exact)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *StringMatch_Prefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *StringMatch_Regex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *AttributeMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Clause) > 0 {
		for k, v := range m.Clause {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovQuota(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Quota) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Quota)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	if m.Charge != 0 {
		n += 1 + sovQuota(uint64(m.Charge))
	}
	return n
}

func (m *QuotaSpecBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, e := range m.Services {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	if len(m.QuotaSpecs) > 0 {
		for _, e := range m.QuotaSpecs {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaSpecBinding_QuotaSpecReference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	return n
}

func sovQuota(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQuota(x uint64) (n int) {
	return sovQuota(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QuotaSpec) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRules := "[]*QuotaRule{"
	for _, f := range this.Rules {
		repeatedStringForRules += strings.Replace(f.String(), "QuotaRule", "QuotaRule", 1) + ","
	}
	repeatedStringForRules += "}"
	s := strings.Join([]string{`&QuotaSpec{`,
		`Rules:` + repeatedStringForRules + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaRule) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMatch := "[]*AttributeMatch{"
	for _, f := range this.Match {
		repeatedStringForMatch += strings.Replace(f.String(), "AttributeMatch", "AttributeMatch", 1) + ","
	}
	repeatedStringForMatch += "}"
	repeatedStringForQuotas := "[]*Quota{"
	for _, f := range this.Quotas {
		repeatedStringForQuotas += strings.Replace(f.String(), "Quota", "Quota", 1) + ","
	}
	repeatedStringForQuotas += "}"
	s := strings.Join([]string{`&QuotaRule{`,
		`Match:` + repeatedStringForMatch + `,`,
		`Quotas:` + repeatedStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch{`,
		`MatchType:` + fmt.Sprintf("%v", this.MatchType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Exact) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Exact{`,
		`Exact:` + fmt.Sprintf("%v", this.Exact) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Prefix) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Prefix{`,
		`Prefix:` + fmt.Sprintf("%v", this.Prefix) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Regex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Regex{`,
		`Regex:` + fmt.Sprintf("%v", this.Regex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AttributeMatch) String() string {
	if this == nil {
		return "nil"
	}
	keysForClause := make([]string, 0, len(this.Clause))
	for k, _ := range this.Clause {
		keysForClause = append(keysForClause, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClause)
	mapStringForClause := "map[string]*StringMatch{"
	for _, k := range keysForClause {
		mapStringForClause += fmt.Sprintf("%v: %v,", k, this.Clause[k])
	}
	mapStringForClause += "}"
	s := strings.Join([]string{`&AttributeMatch{`,
		`Clause:` + mapStringForClause + `,`,
		`}`,
	}, "")
	return s
}
func (this *Quota) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Quota{`,
		`Quota:` + fmt.Sprintf("%v", this.Quota) + `,`,
		`Charge:` + fmt.Sprintf("%v", this.Charge) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaSpecBinding) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForServices := "[]*IstioService{"
	for _, f := range this.Services {
		repeatedStringForServices += strings.Replace(fmt.Sprintf("%v", f), "IstioService", "IstioService", 1) + ","
	}
	repeatedStringForServices += "}"
	repeatedStringForQuotaSpecs := "[]*QuotaSpecBinding_QuotaSpecReference{"
	for _, f := range this.QuotaSpecs {
		repeatedStringForQuotaSpecs += strings.Replace(fmt.Sprintf("%v", f), "QuotaSpecBinding_QuotaSpecReference", "QuotaSpecBinding_QuotaSpecReference", 1) + ","
	}
	repeatedStringForQuotaSpecs += "}"
	s := strings.Join([]string{`&QuotaSpecBinding{`,
		`Services:` + repeatedStringForServices + `,`,
		`QuotaSpecs:` + repeatedStringForQuotaSpecs + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaSpecBinding_QuotaSpecReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaSpecBinding_QuotaSpecReference{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQuota(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QuotaSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &QuotaRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = append(m.Match, &AttributeMatch{})
			if err := m.Match[len(m.Match)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Quotas = append(m.Quotas, &Quota{})
			if err := m.Quotas[len(m.Quotas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Exact{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clause", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Clause == nil {
				m.Clause = make(map[string]*StringMatch)
			}
			var mapkey string
			var mapvalue *StringMatch
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQuota
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthQuota
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthQuota
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMatch{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQuota(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthQuota
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Clause[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Quota) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quota", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Quota = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Charge", wireType)
			}
			m.Charge = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Charge |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaSpecBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpecBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpecBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &IstioService{})
			if err := m.Services[len(m.Services)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaSpecs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuotaSpecs = append(m.QuotaSpecs, &QuotaSpecBinding_QuotaSpecReference{})
			if err := m.QuotaSpecs[len(m.QuotaSpecs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaSpecBinding_QuotaSpecReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpecReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpecReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuota
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuota(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQuota
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthQuota
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuota(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthQuota
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuota = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuota   = fmt.Errorf("proto: integer overflow")
)
