// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/service/tap/v2alpha/common.proto

package envoy_service_tap_v2alpha

import (
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	route "github.com/envoyproxy/go-control-plane/envoy/api/v2/route"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Output format. All output is in the form of one or more :ref:`TraceWrapper
// <envoy_api_msg_data.tap.v2alpha.TraceWrapper>` messages. This enumeration indicates
// how those messages are written. Note that not all sinks support all output formats. See
// individual sink documentation for more information.
type OutputSink_Format int32

const (
	// Each message will be written as JSON. Any :ref:`body <envoy_api_msg_data.tap.v2alpha.Body>`
	// data will be present in the :ref:`as_bytes
	// <envoy_api_field_data.tap.v2alpha.Body.as_bytes>` field. This means that body data will be
	// base64 encoded as per the `proto3 JSON mappings
	// <https://developers.google.com/protocol-buffers/docs/proto3#json>`_.
	OutputSink_JSON_BODY_AS_BYTES OutputSink_Format = 0
	// Each message will be written as JSON. Any :ref:`body <envoy_api_msg_data.tap.v2alpha.Body>`
	// data will be present in the :ref:`as_string
	// <envoy_api_field_data.tap.v2alpha.Body.as_string>` field. This means that body data will be
	// string encoded as per the `proto3 JSON mappings
	// <https://developers.google.com/protocol-buffers/docs/proto3#json>`_. This format type is
	// useful when it is known that that body is human readable (e.g., JSON over HTTP) and the
	// user wishes to view it directly without being forced to base64 decode the body.
	OutputSink_JSON_BODY_AS_STRING OutputSink_Format = 1
	// Binary proto format. Note that binary proto is not self-delimiting. If a sink writes
	// multiple binary messages without any length information the data stream will not be
	// useful. However, for certain sinks that are self-delimiting (e.g., one message per file)
	// this output format makes consumption simpler.
	OutputSink_PROTO_BINARY OutputSink_Format = 2
	// Messages are written as a sequence tuples, where each tuple is the message length encoded
	// as a `protobuf 32-bit varint
	// <https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.io.coded_stream>`_
	// followed by the binary message. The messages can be read back using the language specific
	// protobuf coded stream implementation to obtain the message length and the message.
	OutputSink_PROTO_BINARY_LENGTH_DELIMITED OutputSink_Format = 3
	// Text proto format.
	OutputSink_PROTO_TEXT OutputSink_Format = 4
)

var OutputSink_Format_name = map[int32]string{
	0: "JSON_BODY_AS_BYTES",
	1: "JSON_BODY_AS_STRING",
	2: "PROTO_BINARY",
	3: "PROTO_BINARY_LENGTH_DELIMITED",
	4: "PROTO_TEXT",
}

var OutputSink_Format_value = map[string]int32{
	"JSON_BODY_AS_BYTES":            0,
	"JSON_BODY_AS_STRING":           1,
	"PROTO_BINARY":                  2,
	"PROTO_BINARY_LENGTH_DELIMITED": 3,
	"PROTO_TEXT":                    4,
}

func (x OutputSink_Format) String() string {
	return proto.EnumName(OutputSink_Format_name, int32(x))
}

func (OutputSink_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{4, 0}
}

// Tap configuration.
type TapConfig struct {
	// The match configuration. If the configuration matches the data source being tapped, a tap will
	// occur, with the result written to the configured output.
	MatchConfig *MatchPredicate `protobuf:"bytes,1,opt,name=match_config,json=matchConfig,proto3" json:"match_config,omitempty"`
	// The tap output configuration. If a match configuration matches a data source being tapped,
	// a tap will occur and the data will be written to the configured output.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// [#not-implemented-hide:] Specify if Tap matching is enabled. The % of requests\connections for
	// which the tap matching is enabled. When not enabled, the request\connection will not be
	// recorded.
	//
	// .. note::
	//
	//   This field defaults to 100/:ref:`HUNDRED
	//   <envoy_api_enum_type.FractionalPercent.DenominatorType>`.
	TapEnabled           *core.RuntimeFractionalPercent `protobuf:"bytes,3,opt,name=tap_enabled,json=tapEnabled,proto3" json:"tap_enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *TapConfig) Reset()         { *m = TapConfig{} }
func (m *TapConfig) String() string { return proto.CompactTextString(m) }
func (*TapConfig) ProtoMessage()    {}
func (*TapConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{0}
}
func (m *TapConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TapConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TapConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TapConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TapConfig.Merge(m, src)
}
func (m *TapConfig) XXX_Size() int {
	return m.Size()
}
func (m *TapConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TapConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TapConfig proto.InternalMessageInfo

func (m *TapConfig) GetMatchConfig() *MatchPredicate {
	if m != nil {
		return m.MatchConfig
	}
	return nil
}

func (m *TapConfig) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *TapConfig) GetTapEnabled() *core.RuntimeFractionalPercent {
	if m != nil {
		return m.TapEnabled
	}
	return nil
}

// Tap match configuration. This is a recursive structure which allows complex nested match
// configurations to be built using various logical operators.
type MatchPredicate struct {
	// Types that are valid to be assigned to Rule:
	//	*MatchPredicate_OrMatch
	//	*MatchPredicate_AndMatch
	//	*MatchPredicate_NotMatch
	//	*MatchPredicate_AnyMatch
	//	*MatchPredicate_HttpRequestHeadersMatch
	//	*MatchPredicate_HttpRequestTrailersMatch
	//	*MatchPredicate_HttpResponseHeadersMatch
	//	*MatchPredicate_HttpResponseTrailersMatch
	Rule                 isMatchPredicate_Rule `protobuf_oneof:"rule"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MatchPredicate) Reset()         { *m = MatchPredicate{} }
func (m *MatchPredicate) String() string { return proto.CompactTextString(m) }
func (*MatchPredicate) ProtoMessage()    {}
func (*MatchPredicate) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{1}
}
func (m *MatchPredicate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MatchPredicate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MatchPredicate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MatchPredicate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MatchPredicate.Merge(m, src)
}
func (m *MatchPredicate) XXX_Size() int {
	return m.Size()
}
func (m *MatchPredicate) XXX_DiscardUnknown() {
	xxx_messageInfo_MatchPredicate.DiscardUnknown(m)
}

var xxx_messageInfo_MatchPredicate proto.InternalMessageInfo

type isMatchPredicate_Rule interface {
	isMatchPredicate_Rule()
	MarshalTo([]byte) (int, error)
	Size() int
}

type MatchPredicate_OrMatch struct {
	OrMatch *MatchPredicate_MatchSet `protobuf:"bytes,1,opt,name=or_match,json=orMatch,proto3,oneof"`
}
type MatchPredicate_AndMatch struct {
	AndMatch *MatchPredicate_MatchSet `protobuf:"bytes,2,opt,name=and_match,json=andMatch,proto3,oneof"`
}
type MatchPredicate_NotMatch struct {
	NotMatch *MatchPredicate `protobuf:"bytes,3,opt,name=not_match,json=notMatch,proto3,oneof"`
}
type MatchPredicate_AnyMatch struct {
	AnyMatch bool `protobuf:"varint,4,opt,name=any_match,json=anyMatch,proto3,oneof"`
}
type MatchPredicate_HttpRequestHeadersMatch struct {
	HttpRequestHeadersMatch *HttpHeadersMatch `protobuf:"bytes,5,opt,name=http_request_headers_match,json=httpRequestHeadersMatch,proto3,oneof"`
}
type MatchPredicate_HttpRequestTrailersMatch struct {
	HttpRequestTrailersMatch *HttpHeadersMatch `protobuf:"bytes,6,opt,name=http_request_trailers_match,json=httpRequestTrailersMatch,proto3,oneof"`
}
type MatchPredicate_HttpResponseHeadersMatch struct {
	HttpResponseHeadersMatch *HttpHeadersMatch `protobuf:"bytes,7,opt,name=http_response_headers_match,json=httpResponseHeadersMatch,proto3,oneof"`
}
type MatchPredicate_HttpResponseTrailersMatch struct {
	HttpResponseTrailersMatch *HttpHeadersMatch `protobuf:"bytes,8,opt,name=http_response_trailers_match,json=httpResponseTrailersMatch,proto3,oneof"`
}

func (*MatchPredicate_OrMatch) isMatchPredicate_Rule()                   {}
func (*MatchPredicate_AndMatch) isMatchPredicate_Rule()                  {}
func (*MatchPredicate_NotMatch) isMatchPredicate_Rule()                  {}
func (*MatchPredicate_AnyMatch) isMatchPredicate_Rule()                  {}
func (*MatchPredicate_HttpRequestHeadersMatch) isMatchPredicate_Rule()   {}
func (*MatchPredicate_HttpRequestTrailersMatch) isMatchPredicate_Rule()  {}
func (*MatchPredicate_HttpResponseHeadersMatch) isMatchPredicate_Rule()  {}
func (*MatchPredicate_HttpResponseTrailersMatch) isMatchPredicate_Rule() {}

func (m *MatchPredicate) GetRule() isMatchPredicate_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *MatchPredicate) GetOrMatch() *MatchPredicate_MatchSet {
	if x, ok := m.GetRule().(*MatchPredicate_OrMatch); ok {
		return x.OrMatch
	}
	return nil
}

func (m *MatchPredicate) GetAndMatch() *MatchPredicate_MatchSet {
	if x, ok := m.GetRule().(*MatchPredicate_AndMatch); ok {
		return x.AndMatch
	}
	return nil
}

func (m *MatchPredicate) GetNotMatch() *MatchPredicate {
	if x, ok := m.GetRule().(*MatchPredicate_NotMatch); ok {
		return x.NotMatch
	}
	return nil
}

func (m *MatchPredicate) GetAnyMatch() bool {
	if x, ok := m.GetRule().(*MatchPredicate_AnyMatch); ok {
		return x.AnyMatch
	}
	return false
}

func (m *MatchPredicate) GetHttpRequestHeadersMatch() *HttpHeadersMatch {
	if x, ok := m.GetRule().(*MatchPredicate_HttpRequestHeadersMatch); ok {
		return x.HttpRequestHeadersMatch
	}
	return nil
}

func (m *MatchPredicate) GetHttpRequestTrailersMatch() *HttpHeadersMatch {
	if x, ok := m.GetRule().(*MatchPredicate_HttpRequestTrailersMatch); ok {
		return x.HttpRequestTrailersMatch
	}
	return nil
}

func (m *MatchPredicate) GetHttpResponseHeadersMatch() *HttpHeadersMatch {
	if x, ok := m.GetRule().(*MatchPredicate_HttpResponseHeadersMatch); ok {
		return x.HttpResponseHeadersMatch
	}
	return nil
}

func (m *MatchPredicate) GetHttpResponseTrailersMatch() *HttpHeadersMatch {
	if x, ok := m.GetRule().(*MatchPredicate_HttpResponseTrailersMatch); ok {
		return x.HttpResponseTrailersMatch
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MatchPredicate) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MatchPredicate_OneofMarshaler, _MatchPredicate_OneofUnmarshaler, _MatchPredicate_OneofSizer, []interface{}{
		(*MatchPredicate_OrMatch)(nil),
		(*MatchPredicate_AndMatch)(nil),
		(*MatchPredicate_NotMatch)(nil),
		(*MatchPredicate_AnyMatch)(nil),
		(*MatchPredicate_HttpRequestHeadersMatch)(nil),
		(*MatchPredicate_HttpRequestTrailersMatch)(nil),
		(*MatchPredicate_HttpResponseHeadersMatch)(nil),
		(*MatchPredicate_HttpResponseTrailersMatch)(nil),
	}
}

func _MatchPredicate_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MatchPredicate)
	// rule
	switch x := m.Rule.(type) {
	case *MatchPredicate_OrMatch:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrMatch); err != nil {
			return err
		}
	case *MatchPredicate_AndMatch:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AndMatch); err != nil {
			return err
		}
	case *MatchPredicate_NotMatch:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotMatch); err != nil {
			return err
		}
	case *MatchPredicate_AnyMatch:
		t := uint64(0)
		if x.AnyMatch {
			t = 1
		}
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *MatchPredicate_HttpRequestHeadersMatch:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpRequestHeadersMatch); err != nil {
			return err
		}
	case *MatchPredicate_HttpRequestTrailersMatch:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpRequestTrailersMatch); err != nil {
			return err
		}
	case *MatchPredicate_HttpResponseHeadersMatch:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpResponseHeadersMatch); err != nil {
			return err
		}
	case *MatchPredicate_HttpResponseTrailersMatch:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpResponseTrailersMatch); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MatchPredicate.Rule has unexpected type %T", x)
	}
	return nil
}

func _MatchPredicate_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MatchPredicate)
	switch tag {
	case 1: // rule.or_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MatchPredicate_MatchSet)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_OrMatch{msg}
		return true, err
	case 2: // rule.and_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MatchPredicate_MatchSet)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_AndMatch{msg}
		return true, err
	case 3: // rule.not_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MatchPredicate)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_NotMatch{msg}
		return true, err
	case 4: // rule.any_match
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &MatchPredicate_AnyMatch{x != 0}
		return true, err
	case 5: // rule.http_request_headers_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HttpHeadersMatch)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_HttpRequestHeadersMatch{msg}
		return true, err
	case 6: // rule.http_request_trailers_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HttpHeadersMatch)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_HttpRequestTrailersMatch{msg}
		return true, err
	case 7: // rule.http_response_headers_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HttpHeadersMatch)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_HttpResponseHeadersMatch{msg}
		return true, err
	case 8: // rule.http_response_trailers_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HttpHeadersMatch)
		err := b.DecodeMessage(msg)
		m.Rule = &MatchPredicate_HttpResponseTrailersMatch{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MatchPredicate_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MatchPredicate)
	// rule
	switch x := m.Rule.(type) {
	case *MatchPredicate_OrMatch:
		s := proto.Size(x.OrMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_AndMatch:
		s := proto.Size(x.AndMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_NotMatch:
		s := proto.Size(x.NotMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_AnyMatch:
		n += 1 // tag and wire
		n += 1
	case *MatchPredicate_HttpRequestHeadersMatch:
		s := proto.Size(x.HttpRequestHeadersMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_HttpRequestTrailersMatch:
		s := proto.Size(x.HttpRequestTrailersMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_HttpResponseHeadersMatch:
		s := proto.Size(x.HttpResponseHeadersMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MatchPredicate_HttpResponseTrailersMatch:
		s := proto.Size(x.HttpResponseTrailersMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A set of match configurations used for logical operations.
type MatchPredicate_MatchSet struct {
	// The list of rules that make up the set.
	Rules                []*MatchPredicate `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MatchPredicate_MatchSet) Reset()         { *m = MatchPredicate_MatchSet{} }
func (m *MatchPredicate_MatchSet) String() string { return proto.CompactTextString(m) }
func (*MatchPredicate_MatchSet) ProtoMessage()    {}
func (*MatchPredicate_MatchSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{1, 0}
}
func (m *MatchPredicate_MatchSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MatchPredicate_MatchSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MatchPredicate_MatchSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MatchPredicate_MatchSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MatchPredicate_MatchSet.Merge(m, src)
}
func (m *MatchPredicate_MatchSet) XXX_Size() int {
	return m.Size()
}
func (m *MatchPredicate_MatchSet) XXX_DiscardUnknown() {
	xxx_messageInfo_MatchPredicate_MatchSet.DiscardUnknown(m)
}

var xxx_messageInfo_MatchPredicate_MatchSet proto.InternalMessageInfo

func (m *MatchPredicate_MatchSet) GetRules() []*MatchPredicate {
	if m != nil {
		return m.Rules
	}
	return nil
}

// HTTP headers match configuration.
type HttpHeadersMatch struct {
	// HTTP headers to match.
	Headers              []*route.HeaderMatcher `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *HttpHeadersMatch) Reset()         { *m = HttpHeadersMatch{} }
func (m *HttpHeadersMatch) String() string { return proto.CompactTextString(m) }
func (*HttpHeadersMatch) ProtoMessage()    {}
func (*HttpHeadersMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{2}
}
func (m *HttpHeadersMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpHeadersMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpHeadersMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpHeadersMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpHeadersMatch.Merge(m, src)
}
func (m *HttpHeadersMatch) XXX_Size() int {
	return m.Size()
}
func (m *HttpHeadersMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpHeadersMatch.DiscardUnknown(m)
}

var xxx_messageInfo_HttpHeadersMatch proto.InternalMessageInfo

func (m *HttpHeadersMatch) GetHeaders() []*route.HeaderMatcher {
	if m != nil {
		return m.Headers
	}
	return nil
}

// Tap output configuration.
type OutputConfig struct {
	// Output sinks for tap data. Currently a single sink is allowed in the list. Once multiple
	// sink types are supported this constraint will be relaxed.
	Sinks []*OutputSink `protobuf:"bytes,1,rep,name=sinks,proto3" json:"sinks,omitempty"`
	// For buffered tapping, the maximum amount of received body that will be buffered prior to
	// truncation. If truncation occurs, the :ref:`truncated
	// <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If not specified, the
	// default is 1KiB.
	MaxBufferedRxBytes *types.UInt32Value `protobuf:"bytes,2,opt,name=max_buffered_rx_bytes,json=maxBufferedRxBytes,proto3" json:"max_buffered_rx_bytes,omitempty"`
	// For buffered tapping, the maximum amount of transmitted body that will be buffered prior to
	// truncation. If truncation occurs, the :ref:`truncated
	// <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If not specified, the
	// default is 1KiB.
	MaxBufferedTxBytes *types.UInt32Value `protobuf:"bytes,3,opt,name=max_buffered_tx_bytes,json=maxBufferedTxBytes,proto3" json:"max_buffered_tx_bytes,omitempty"`
	// Indicates whether taps produce a single buffered message per tap, or multiple streamed
	// messages per tap in the emitted :ref:`TraceWrapper
	// <envoy_api_msg_data.tap.v2alpha.TraceWrapper>` messages. Note that streamed tapping does not
	// mean that no buffering takes place. Buffering may be required if data is processed before a
	// match can be determined. See the HTTP tap filter :ref:`streaming
	// <config_http_filters_tap_streaming>` documentation for more information.
	Streaming            bool     `protobuf:"varint,4,opt,name=streaming,proto3" json:"streaming,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{3}
}
func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return m.Size()
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

func (m *OutputConfig) GetSinks() []*OutputSink {
	if m != nil {
		return m.Sinks
	}
	return nil
}

func (m *OutputConfig) GetMaxBufferedRxBytes() *types.UInt32Value {
	if m != nil {
		return m.MaxBufferedRxBytes
	}
	return nil
}

func (m *OutputConfig) GetMaxBufferedTxBytes() *types.UInt32Value {
	if m != nil {
		return m.MaxBufferedTxBytes
	}
	return nil
}

func (m *OutputConfig) GetStreaming() bool {
	if m != nil {
		return m.Streaming
	}
	return false
}

// Tap output sink configuration.
type OutputSink struct {
	// Sink output format.
	Format OutputSink_Format `protobuf:"varint,1,opt,name=format,proto3,enum=envoy.service.tap.v2alpha.OutputSink_Format" json:"format,omitempty"`
	// Types that are valid to be assigned to OutputSinkType:
	//	*OutputSink_StreamingAdmin
	//	*OutputSink_FilePerTap
	//	*OutputSink_StreamingGrpc
	OutputSinkType       isOutputSink_OutputSinkType `protobuf_oneof:"output_sink_type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *OutputSink) Reset()         { *m = OutputSink{} }
func (m *OutputSink) String() string { return proto.CompactTextString(m) }
func (*OutputSink) ProtoMessage()    {}
func (*OutputSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{4}
}
func (m *OutputSink) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutputSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutputSink.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutputSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputSink.Merge(m, src)
}
func (m *OutputSink) XXX_Size() int {
	return m.Size()
}
func (m *OutputSink) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputSink.DiscardUnknown(m)
}

var xxx_messageInfo_OutputSink proto.InternalMessageInfo

type isOutputSink_OutputSinkType interface {
	isOutputSink_OutputSinkType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type OutputSink_StreamingAdmin struct {
	StreamingAdmin *StreamingAdminSink `protobuf:"bytes,2,opt,name=streaming_admin,json=streamingAdmin,proto3,oneof"`
}
type OutputSink_FilePerTap struct {
	FilePerTap *FilePerTapSink `protobuf:"bytes,3,opt,name=file_per_tap,json=filePerTap,proto3,oneof"`
}
type OutputSink_StreamingGrpc struct {
	StreamingGrpc *StreamingGrpcSink `protobuf:"bytes,4,opt,name=streaming_grpc,json=streamingGrpc,proto3,oneof"`
}

func (*OutputSink_StreamingAdmin) isOutputSink_OutputSinkType() {}
func (*OutputSink_FilePerTap) isOutputSink_OutputSinkType()     {}
func (*OutputSink_StreamingGrpc) isOutputSink_OutputSinkType()  {}

func (m *OutputSink) GetOutputSinkType() isOutputSink_OutputSinkType {
	if m != nil {
		return m.OutputSinkType
	}
	return nil
}

func (m *OutputSink) GetFormat() OutputSink_Format {
	if m != nil {
		return m.Format
	}
	return OutputSink_JSON_BODY_AS_BYTES
}

func (m *OutputSink) GetStreamingAdmin() *StreamingAdminSink {
	if x, ok := m.GetOutputSinkType().(*OutputSink_StreamingAdmin); ok {
		return x.StreamingAdmin
	}
	return nil
}

func (m *OutputSink) GetFilePerTap() *FilePerTapSink {
	if x, ok := m.GetOutputSinkType().(*OutputSink_FilePerTap); ok {
		return x.FilePerTap
	}
	return nil
}

func (m *OutputSink) GetStreamingGrpc() *StreamingGrpcSink {
	if x, ok := m.GetOutputSinkType().(*OutputSink_StreamingGrpc); ok {
		return x.StreamingGrpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OutputSink) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OutputSink_OneofMarshaler, _OutputSink_OneofUnmarshaler, _OutputSink_OneofSizer, []interface{}{
		(*OutputSink_StreamingAdmin)(nil),
		(*OutputSink_FilePerTap)(nil),
		(*OutputSink_StreamingGrpc)(nil),
	}
}

func _OutputSink_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OutputSink)
	// output_sink_type
	switch x := m.OutputSinkType.(type) {
	case *OutputSink_StreamingAdmin:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StreamingAdmin); err != nil {
			return err
		}
	case *OutputSink_FilePerTap:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FilePerTap); err != nil {
			return err
		}
	case *OutputSink_StreamingGrpc:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StreamingGrpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OutputSink.OutputSinkType has unexpected type %T", x)
	}
	return nil
}

func _OutputSink_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OutputSink)
	switch tag {
	case 2: // output_sink_type.streaming_admin
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingAdminSink)
		err := b.DecodeMessage(msg)
		m.OutputSinkType = &OutputSink_StreamingAdmin{msg}
		return true, err
	case 3: // output_sink_type.file_per_tap
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FilePerTapSink)
		err := b.DecodeMessage(msg)
		m.OutputSinkType = &OutputSink_FilePerTap{msg}
		return true, err
	case 4: // output_sink_type.streaming_grpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingGrpcSink)
		err := b.DecodeMessage(msg)
		m.OutputSinkType = &OutputSink_StreamingGrpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OutputSink_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OutputSink)
	// output_sink_type
	switch x := m.OutputSinkType.(type) {
	case *OutputSink_StreamingAdmin:
		s := proto.Size(x.StreamingAdmin)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OutputSink_FilePerTap:
		s := proto.Size(x.FilePerTap)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OutputSink_StreamingGrpc:
		s := proto.Size(x.StreamingGrpc)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Streaming admin sink configuration.
type StreamingAdminSink struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAdminSink) Reset()         { *m = StreamingAdminSink{} }
func (m *StreamingAdminSink) String() string { return proto.CompactTextString(m) }
func (*StreamingAdminSink) ProtoMessage()    {}
func (*StreamingAdminSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{5}
}
func (m *StreamingAdminSink) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StreamingAdminSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StreamingAdminSink.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StreamingAdminSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAdminSink.Merge(m, src)
}
func (m *StreamingAdminSink) XXX_Size() int {
	return m.Size()
}
func (m *StreamingAdminSink) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAdminSink.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAdminSink proto.InternalMessageInfo

// The file per tap sink outputs a discrete file for every tapped stream.
type FilePerTapSink struct {
	// Path prefix. The output file will be of the form <path_prefix>_<id>.pb, where <id> is an
	// identifier distinguishing the recorded trace for stream instances (the Envoy
	// connection ID, HTTP stream ID, etc.).
	PathPrefix           string   `protobuf:"bytes,1,opt,name=path_prefix,json=pathPrefix,proto3" json:"path_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FilePerTapSink) Reset()         { *m = FilePerTapSink{} }
func (m *FilePerTapSink) String() string { return proto.CompactTextString(m) }
func (*FilePerTapSink) ProtoMessage()    {}
func (*FilePerTapSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{6}
}
func (m *FilePerTapSink) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilePerTapSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilePerTapSink.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilePerTapSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilePerTapSink.Merge(m, src)
}
func (m *FilePerTapSink) XXX_Size() int {
	return m.Size()
}
func (m *FilePerTapSink) XXX_DiscardUnknown() {
	xxx_messageInfo_FilePerTapSink.DiscardUnknown(m)
}

var xxx_messageInfo_FilePerTapSink proto.InternalMessageInfo

func (m *FilePerTapSink) GetPathPrefix() string {
	if m != nil {
		return m.PathPrefix
	}
	return ""
}

// [#not-implemented-hide:] Streaming gRPC sink configuration sends the taps to an external gRPC
// server.
type StreamingGrpcSink struct {
	// Opaque identifier, that will be sent back to the streaming grpc server.
	TapId string `protobuf:"bytes,1,opt,name=tap_id,json=tapId,proto3" json:"tap_id,omitempty"`
	// The gRPC server that hosts the Tap Sink Service.
	GrpcService          *core.GrpcService `protobuf:"bytes,2,opt,name=grpc_service,json=grpcService,proto3" json:"grpc_service,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StreamingGrpcSink) Reset()         { *m = StreamingGrpcSink{} }
func (m *StreamingGrpcSink) String() string { return proto.CompactTextString(m) }
func (*StreamingGrpcSink) ProtoMessage()    {}
func (*StreamingGrpcSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f6a60461d532a14, []int{7}
}
func (m *StreamingGrpcSink) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StreamingGrpcSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StreamingGrpcSink.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StreamingGrpcSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingGrpcSink.Merge(m, src)
}
func (m *StreamingGrpcSink) XXX_Size() int {
	return m.Size()
}
func (m *StreamingGrpcSink) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingGrpcSink.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingGrpcSink proto.InternalMessageInfo

func (m *StreamingGrpcSink) GetTapId() string {
	if m != nil {
		return m.TapId
	}
	return ""
}

func (m *StreamingGrpcSink) GetGrpcService() *core.GrpcService {
	if m != nil {
		return m.GrpcService
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.service.tap.v2alpha.OutputSink_Format", OutputSink_Format_name, OutputSink_Format_value)
	proto.RegisterType((*TapConfig)(nil), "envoy.service.tap.v2alpha.TapConfig")
	proto.RegisterType((*MatchPredicate)(nil), "envoy.service.tap.v2alpha.MatchPredicate")
	proto.RegisterType((*MatchPredicate_MatchSet)(nil), "envoy.service.tap.v2alpha.MatchPredicate.MatchSet")
	proto.RegisterType((*HttpHeadersMatch)(nil), "envoy.service.tap.v2alpha.HttpHeadersMatch")
	proto.RegisterType((*OutputConfig)(nil), "envoy.service.tap.v2alpha.OutputConfig")
	proto.RegisterType((*OutputSink)(nil), "envoy.service.tap.v2alpha.OutputSink")
	proto.RegisterType((*StreamingAdminSink)(nil), "envoy.service.tap.v2alpha.StreamingAdminSink")
	proto.RegisterType((*FilePerTapSink)(nil), "envoy.service.tap.v2alpha.FilePerTapSink")
	proto.RegisterType((*StreamingGrpcSink)(nil), "envoy.service.tap.v2alpha.StreamingGrpcSink")
}

func init() {
	proto.RegisterFile("envoy/service/tap/v2alpha/common.proto", fileDescriptor_4f6a60461d532a14)
}

var fileDescriptor_4f6a60461d532a14 = []byte{
	// 1016 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x96, 0xcf, 0x73, 0x1a, 0x37,
	0x14, 0xc7, 0xbd, 0x60, 0x30, 0x3c, 0xb0, 0x4b, 0xd5, 0xa6, 0xfe, 0x51, 0x97, 0x71, 0x98, 0xb6,
	0x71, 0x7f, 0x2d, 0x33, 0xe4, 0xd8, 0x5e, 0xbc, 0x31, 0x36, 0xb4, 0xb6, 0xa1, 0xcb, 0xa6, 0xb5,
	0x4f, 0x1a, 0x01, 0x02, 0x6f, 0xb2, 0xac, 0x54, 0xad, 0xa0, 0x70, 0xe9, 0xa1, 0xc7, 0xce, 0xf4,
	0x92, 0x5b, 0xff, 0x93, 0x4e, 0x4f, 0x39, 0xe6, 0xd8, 0x3f, 0xa1, 0xe3, 0x5b, 0xfe, 0x84, 0xde,
	0x3a, 0xbb, 0xd2, 0x62, 0xd6, 0x4e, 0x5c, 0xc7, 0xb9, 0x30, 0x48, 0xef, 0xbd, 0xcf, 0x57, 0xef,
	0x49, 0x7a, 0x5a, 0xf8, 0x94, 0xfa, 0x13, 0x36, 0xab, 0x06, 0x54, 0x4c, 0xdc, 0x1e, 0xad, 0x4a,
	0xc2, 0xab, 0x93, 0x1a, 0xf1, 0xf8, 0x39, 0xa9, 0xf6, 0xd8, 0x68, 0xc4, 0x7c, 0x93, 0x0b, 0x26,
	0x19, 0xda, 0x8c, 0xfc, 0x4c, 0xed, 0x67, 0x4a, 0xc2, 0x4d, 0xed, 0xb7, 0x55, 0x56, 0x08, 0xc2,
	0xdd, 0xea, 0xa4, 0x56, 0x15, 0x6c, 0x2c, 0xa9, 0xfa, 0x55, 0xa1, 0x5b, 0xdb, 0x09, 0x7b, 0x8f,
	0x09, 0x5a, 0xed, 0x92, 0x20, 0xb6, 0x7e, 0x7c, 0xdd, 0x3a, 0x14, 0xbc, 0x87, 0x63, 0x25, 0xe5,
	0x55, 0x1e, 0x32, 0x36, 0xf4, 0x68, 0x35, 0x1a, 0x75, 0xc7, 0x83, 0xea, 0xcf, 0x82, 0x70, 0x4e,
	0x45, 0xa0, 0xed, 0xeb, 0x13, 0xe2, 0xb9, 0x7d, 0x22, 0x69, 0x35, 0xfe, 0xa3, 0x0c, 0x95, 0xdf,
	0x53, 0x90, 0x77, 0x08, 0x7f, 0xc4, 0xfc, 0x81, 0x3b, 0x44, 0xa7, 0x50, 0x1c, 0x11, 0xd9, 0x3b,
	0xc7, 0xbd, 0x68, 0xbc, 0x61, 0xec, 0x18, 0xbb, 0x85, 0xda, 0x67, 0xe6, 0x6b, 0x93, 0x33, 0x8f,
	0x43, 0xf7, 0xb6, 0xa0, 0x7d, 0xb7, 0x47, 0x24, 0xb5, 0xe0, 0xaf, 0x97, 0xcf, 0xd3, 0x99, 0xdf,
	0x8c, 0x54, 0xc9, 0xb0, 0x0b, 0x11, 0x6a, 0x4e, 0x5e, 0x65, 0x63, 0xc9, 0xc7, 0x32, 0x46, 0xa7,
	0x22, 0xf4, 0x83, 0x1b, 0xd0, 0xad, 0xc8, 0x5f, 0xc5, 0x27, 0xc0, 0x45, 0xb6, 0x60, 0x41, 0x47,
	0x50, 0x90, 0x84, 0x63, 0xea, 0x93, 0xae, 0x47, 0xfb, 0x1b, 0xe9, 0x88, 0xfb, 0x85, 0xe6, 0x12,
	0xee, 0x9a, 0x93, 0x9a, 0x19, 0x96, 0xcd, 0xb4, 0xc7, 0xbe, 0x74, 0x47, 0xf4, 0x40, 0x90, 0x9e,
	0x74, 0x99, 0x4f, 0xbc, 0x36, 0x15, 0x3d, 0xea, 0x4b, 0x1b, 0x24, 0xe1, 0x75, 0x15, 0x5e, 0x79,
	0x91, 0x85, 0xb5, 0x64, 0x4e, 0xa8, 0x05, 0x39, 0x26, 0x70, 0x94, 0x8c, 0x2e, 0x48, 0xed, 0xd6,
	0x05, 0x51, 0xc3, 0x0e, 0x95, 0x8d, 0x25, 0x7b, 0x85, 0x89, 0x68, 0x84, 0xbe, 0x87, 0x3c, 0xf1,
	0xfb, 0x9a, 0x98, 0x7a, 0x0b, 0x62, 0x8e, 0xf8, 0x7d, 0x85, 0x6c, 0x40, 0xde, 0x67, 0x52, 0x23,
	0xd3, 0x6f, 0xb8, 0x6b, 0x21, 0xc9, 0x67, 0x52, 0x91, 0x76, 0xc3, 0xc5, 0xcd, 0x34, 0x69, 0x79,
	0xc7, 0xd8, 0xcd, 0x59, 0xf9, 0xb0, 0xf6, 0xcb, 0x4f, 0x52, 0x39, 0x43, 0x69, 0xce, 0x94, 0xe7,
	0x13, 0xd8, 0x3a, 0x97, 0x92, 0x63, 0x41, 0x7f, 0x1a, 0xd3, 0x40, 0xe2, 0x73, 0x4a, 0xfa, 0x54,
	0x04, 0x3a, 0x34, 0x93, 0xd8, 0x87, 0x57, 0x2d, 0xa2, 0x21, 0x25, 0x6f, 0xa8, 0x98, 0x08, 0xd8,
	0x58, 0xb2, 0xd7, 0x43, 0xa0, 0xad, 0x78, 0x8b, 0x26, 0xe4, 0xc1, 0x87, 0x09, 0x2d, 0x29, 0x88,
	0xeb, 0x5d, 0x8a, 0x65, 0xef, 0x22, 0xb6, 0xb1, 0x20, 0xe6, 0x68, 0xde, 0x55, 0xb5, 0x80, 0x33,
	0x3f, 0xa0, 0x57, 0x52, 0x5b, 0x79, 0x0b, 0x35, 0x05, 0x4c, 0xe4, 0xe6, 0xc3, 0x76, 0x52, 0xed,
	0x4a, 0x72, 0xb9, 0xbb, 0xc8, 0x6d, 0x2e, 0xca, 0x25, 0xb2, 0xdb, 0xfa, 0x11, 0x72, 0xf1, 0x19,
	0x42, 0xdf, 0x41, 0x46, 0x8c, 0x3d, 0x1a, 0x6c, 0x18, 0x3b, 0xe9, 0xbb, 0xdc, 0xf4, 0x67, 0x46,
	0x2a, 0x97, 0xb2, 0x15, 0xc3, 0x5a, 0x85, 0xe5, 0xf0, 0x0f, 0xca, 0xfc, 0xf9, 0xf2, 0x79, 0xda,
	0xa8, 0xb4, 0xa0, 0x74, 0x75, 0x61, 0xe8, 0x6b, 0x58, 0xd1, 0xb5, 0xd4, 0x8a, 0xf7, 0x93, 0x17,
	0x55, 0xf5, 0x45, 0x15, 0x12, 0x45, 0x50, 0x61, 0xc7, 0x11, 0x95, 0x3f, 0x52, 0x50, 0x5c, 0x6c,
	0x0a, 0xa8, 0x09, 0x99, 0xc0, 0xf5, 0x9f, 0xc6, 0xac, 0x4f, 0xfe, 0xb7, 0x99, 0x74, 0x5c, 0xff,
	0xa9, 0x55, 0x0c, 0x57, 0xbe, 0xf2, 0xcc, 0x58, 0xce, 0x19, 0x25, 0xc3, 0x56, 0x04, 0xd4, 0x82,
	0x7b, 0x23, 0x32, 0xc5, 0xdd, 0xf1, 0x60, 0x40, 0x05, 0xed, 0x63, 0x31, 0xc5, 0xdd, 0x99, 0xa4,
	0x81, 0xbe, 0x9f, 0xdb, 0xa6, 0x6a, 0xb0, 0x66, 0xdc, 0x60, 0xcd, 0xc7, 0x4d, 0x5f, 0x3e, 0xac,
	0xfd, 0x40, 0xbc, 0x31, 0xb5, 0xd1, 0x88, 0x4c, 0x2d, 0x1d, 0x69, 0x4f, 0xad, 0x30, 0xee, 0x1a,
	0x50, 0xc6, 0xc0, 0xf4, 0x1b, 0x02, 0x1d, 0x0d, 0xdc, 0x86, 0x7c, 0x20, 0x05, 0x25, 0x23, 0xd7,
	0x1f, 0xaa, 0x8b, 0x69, 0x5f, 0x4e, 0x54, 0xfe, 0x4d, 0x03, 0x5c, 0xe6, 0x88, 0xda, 0x90, 0x1d,
	0x30, 0x31, 0x22, 0x32, 0xea, 0x58, 0x6b, 0xb5, 0x2f, 0x6f, 0x55, 0x1a, 0xf3, 0x20, 0x8a, 0xd1,
	0x7b, 0xfb, 0x6b, 0xd4, 0x6c, 0x35, 0x07, 0x9d, 0xc2, 0x3b, 0x73, 0x35, 0x4c, 0xfa, 0x23, 0xd7,
	0xd7, 0xa5, 0xf9, 0xea, 0x06, 0x74, 0x27, 0x8e, 0xd8, 0x0b, 0x03, 0x42, 0x89, 0xc6, 0x92, 0xbd,
	0x16, 0x24, 0x66, 0xd1, 0x31, 0x14, 0x07, 0xae, 0x47, 0x31, 0xa7, 0x02, 0x4b, 0xc2, 0x6f, 0xd1,
	0xbe, 0x0e, 0x5c, 0x8f, 0xb6, 0xa9, 0x70, 0x08, 0xd7, 0x48, 0x18, 0xcc, 0x67, 0xd0, 0x63, 0xb8,
	0x14, 0xc0, 0xe1, 0x53, 0x19, 0x15, 0xab, 0x70, 0x63, 0x09, 0xe6, 0xeb, 0x3c, 0x14, 0xbc, 0xa7,
	0x99, 0xab, 0xc1, 0xe2, 0x64, 0xe5, 0x17, 0xc8, 0xaa, 0xea, 0xa0, 0x0f, 0x00, 0x7d, 0xdb, 0x69,
	0x9d, 0x60, 0xab, 0xb5, 0x7f, 0x86, 0xf7, 0x3a, 0xd8, 0x3a, 0x73, 0xea, 0x9d, 0xd2, 0x12, 0x5a,
	0x87, 0xf7, 0x12, 0xf3, 0x1d, 0xc7, 0x6e, 0x9e, 0x1c, 0x96, 0x0c, 0x54, 0x82, 0x62, 0xdb, 0x6e,
	0x39, 0x2d, 0x6c, 0x35, 0x4f, 0xf6, 0xec, 0xb3, 0x52, 0x0a, 0xdd, 0x87, 0x8f, 0x16, 0x67, 0xf0,
	0x51, 0xfd, 0xe4, 0xd0, 0x69, 0xe0, 0xfd, 0xfa, 0x51, 0xf3, 0xb8, 0xe9, 0xd4, 0xf7, 0x4b, 0x69,
	0xb4, 0x06, 0xa0, 0x5c, 0x9c, 0xfa, 0xa9, 0x53, 0x5a, 0xb6, 0x36, 0xa1, 0xa4, 0x1f, 0xd0, 0xf0,
	0xc0, 0x62, 0x39, 0xe3, 0xf3, 0x8b, 0xf6, 0x3e, 0xa0, 0xeb, 0x85, 0xae, 0x7c, 0x03, 0x6b, 0xc9,
	0x3a, 0xa1, 0xcf, 0xa1, 0xc0, 0x89, 0x3c, 0xc7, 0x5c, 0xd0, 0x81, 0x3b, 0x8d, 0x4e, 0x46, 0x5e,
	0x37, 0x77, 0x91, 0xda, 0x31, 0x6c, 0x08, 0xad, 0xed, 0xc8, 0x58, 0x99, 0xc1, 0xbb, 0xd7, 0x8a,
	0x82, 0xee, 0x41, 0x36, 0x7c, 0x6a, 0xdd, 0xbe, 0x8a, 0xb5, 0x33, 0x92, 0xf0, 0x66, 0x3f, 0xdc,
	0xc0, 0xc5, 0x4f, 0x12, 0x7d, 0x2e, 0xca, 0xaf, 0x78, 0x82, 0x23, 0x92, 0xf2, 0x4a, 0x7e, 0x2a,
	0x0c, 0x17, 0x0c, 0xfb, 0x2f, 0x2e, 0xca, 0xc6, 0xdf, 0x17, 0x65, 0xe3, 0x9f, 0x8b, 0xb2, 0x01,
	0x0f, 0x5c, 0xa6, 0x40, 0x5c, 0xb0, 0xe9, 0xec, 0xf5, 0x7b, 0x68, 0x15, 0x1e, 0x45, 0xdf, 0x63,
	0xed, 0xf0, 0x3e, 0xb5, 0x8d, 0x6e, 0x36, 0xba, 0x58, 0x0f, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff,
	0x2d, 0xac, 0xef, 0x68, 0xc1, 0x09, 0x00, 0x00,
}

func (m *TapConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TapConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MatchConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.MatchConfig.Size()))
		n1, err := m.MatchConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.OutputConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.OutputConfig.Size()))
		n2, err := m.OutputConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.TapEnabled != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.TapEnabled.Size()))
		n3, err := m.TapEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MatchPredicate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MatchPredicate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Rule != nil {
		nn4, err := m.Rule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MatchPredicate_OrMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OrMatch != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.OrMatch.Size()))
		n5, err := m.OrMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *MatchPredicate_AndMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AndMatch != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.AndMatch.Size()))
		n6, err := m.AndMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *MatchPredicate_NotMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NotMatch != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.NotMatch.Size()))
		n7, err := m.NotMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *MatchPredicate_AnyMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x20
	i++
	if m.AnyMatch {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *MatchPredicate_HttpRequestHeadersMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HttpRequestHeadersMatch != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.HttpRequestHeadersMatch.Size()))
		n8, err := m.HttpRequestHeadersMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *MatchPredicate_HttpRequestTrailersMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HttpRequestTrailersMatch != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.HttpRequestTrailersMatch.Size()))
		n9, err := m.HttpRequestTrailersMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *MatchPredicate_HttpResponseHeadersMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HttpResponseHeadersMatch != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.HttpResponseHeadersMatch.Size()))
		n10, err := m.HttpResponseHeadersMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *MatchPredicate_HttpResponseTrailersMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HttpResponseTrailersMatch != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.HttpResponseTrailersMatch.Size()))
		n11, err := m.HttpResponseTrailersMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *MatchPredicate_MatchSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MatchPredicate_MatchSet) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCommon(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpHeadersMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpHeadersMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Headers) > 0 {
		for _, msg := range m.Headers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCommon(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OutputConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutputConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sinks) > 0 {
		for _, msg := range m.Sinks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCommon(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxBufferedRxBytes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.MaxBufferedRxBytes.Size()))
		n12, err := m.MaxBufferedRxBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.MaxBufferedTxBytes != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.MaxBufferedTxBytes.Size()))
		n13, err := m.MaxBufferedTxBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Streaming {
		dAtA[i] = 0x20
		i++
		if m.Streaming {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OutputSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutputSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Format != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.Format))
	}
	if m.OutputSinkType != nil {
		nn14, err := m.OutputSinkType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn14
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OutputSink_StreamingAdmin) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StreamingAdmin != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.StreamingAdmin.Size()))
		n15, err := m.StreamingAdmin.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *OutputSink_FilePerTap) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.FilePerTap != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.FilePerTap.Size()))
		n16, err := m.FilePerTap.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *OutputSink_StreamingGrpc) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StreamingGrpc != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.StreamingGrpc.Size()))
		n17, err := m.StreamingGrpc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *StreamingAdminSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamingAdminSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FilePerTapSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilePerTapSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PathPrefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommon(dAtA, i, uint64(len(m.PathPrefix)))
		i += copy(dAtA[i:], m.PathPrefix)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StreamingGrpcSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamingGrpcSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TapId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommon(dAtA, i, uint64(len(m.TapId)))
		i += copy(dAtA[i:], m.TapId)
	}
	if m.GrpcService != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommon(dAtA, i, uint64(m.GrpcService.Size()))
		n18, err := m.GrpcService.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintCommon(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TapConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchConfig != nil {
		l = m.MatchConfig.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.OutputConfig != nil {
		l = m.OutputConfig.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.TapEnabled != nil {
		l = m.TapEnabled.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MatchPredicate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Rule != nil {
		n += m.Rule.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MatchPredicate_OrMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OrMatch != nil {
		l = m.OrMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_AndMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AndMatch != nil {
		l = m.AndMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_NotMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NotMatch != nil {
		l = m.NotMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_AnyMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *MatchPredicate_HttpRequestHeadersMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpRequestHeadersMatch != nil {
		l = m.HttpRequestHeadersMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_HttpRequestTrailersMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpRequestTrailersMatch != nil {
		l = m.HttpRequestTrailersMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_HttpResponseHeadersMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpResponseHeadersMatch != nil {
		l = m.HttpResponseHeadersMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_HttpResponseTrailersMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpResponseTrailersMatch != nil {
		l = m.HttpResponseTrailersMatch.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *MatchPredicate_MatchSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovCommon(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpHeadersMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovCommon(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutputConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Sinks) > 0 {
		for _, e := range m.Sinks {
			l = e.Size()
			n += 1 + l + sovCommon(uint64(l))
		}
	}
	if m.MaxBufferedRxBytes != nil {
		l = m.MaxBufferedRxBytes.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.MaxBufferedTxBytes != nil {
		l = m.MaxBufferedTxBytes.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.Streaming {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutputSink) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Format != 0 {
		n += 1 + sovCommon(uint64(m.Format))
	}
	if m.OutputSinkType != nil {
		n += m.OutputSinkType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutputSink_StreamingAdmin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StreamingAdmin != nil {
		l = m.StreamingAdmin.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *OutputSink_FilePerTap) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FilePerTap != nil {
		l = m.FilePerTap.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *OutputSink_StreamingGrpc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StreamingGrpc != nil {
		l = m.StreamingGrpc.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}
func (m *StreamingAdminSink) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FilePerTapSink) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PathPrefix)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StreamingGrpcSink) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TapId)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.GrpcService != nil {
		l = m.GrpcService.Size()
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCommon(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCommon(x uint64) (n int) {
	return sovCommon(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TapConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TapConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TapConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MatchConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MatchConfig == nil {
				m.MatchConfig = &MatchPredicate{}
			}
			if err := m.MatchConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutputConfig == nil {
				m.OutputConfig = &OutputConfig{}
			}
			if err := m.OutputConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TapEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TapEnabled == nil {
				m.TapEnabled = &core.RuntimeFractionalPercent{}
			}
			if err := m.TapEnabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MatchPredicate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MatchPredicate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MatchPredicate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchPredicate_MatchSet{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_OrMatch{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AndMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchPredicate_MatchSet{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_AndMatch{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchPredicate{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_NotMatch{v}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AnyMatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Rule = &MatchPredicate_AnyMatch{b}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpRequestHeadersMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HttpHeadersMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_HttpRequestHeadersMatch{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpRequestTrailersMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HttpHeadersMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_HttpRequestTrailersMatch{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpResponseHeadersMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HttpHeadersMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_HttpResponseHeadersMatch{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpResponseTrailersMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HttpHeadersMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &MatchPredicate_HttpResponseTrailersMatch{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MatchPredicate_MatchSet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MatchSet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MatchSet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &MatchPredicate{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpHeadersMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpHeadersMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpHeadersMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &route.HeaderMatcher{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutputConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutputConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutputConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sinks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sinks = append(m.Sinks, &OutputSink{})
			if err := m.Sinks[len(m.Sinks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBufferedRxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxBufferedRxBytes == nil {
				m.MaxBufferedRxBytes = &types.UInt32Value{}
			}
			if err := m.MaxBufferedRxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBufferedTxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxBufferedTxBytes == nil {
				m.MaxBufferedTxBytes = &types.UInt32Value{}
			}
			if err := m.MaxBufferedTxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streaming", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Streaming = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutputSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutputSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutputSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			m.Format = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Format |= OutputSink_Format(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingAdmin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StreamingAdminSink{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.OutputSinkType = &OutputSink_StreamingAdmin{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilePerTap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FilePerTapSink{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.OutputSinkType = &OutputSink_FilePerTap{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingGrpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StreamingGrpcSink{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.OutputSinkType = &OutputSink_StreamingGrpc{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamingAdminSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamingAdminSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamingAdminSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilePerTapSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilePerTapSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilePerTapSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PathPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamingGrpcSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamingGrpcSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamingGrpcSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TapId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TapId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GrpcService == nil {
				m.GrpcService = &core.GrpcService{}
			}
			if err := m.GrpcService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCommon(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCommon
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCommon
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCommon
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCommon(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCommon
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCommon = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCommon   = fmt.Errorf("proto: integer overflow")
)
