// Code generated by protoc-gen-go. DO NOT EDIT.
// source: pkg/apis/istio/v1alpha2/istiocontrolplane_types.proto

// IstioControlPlane is a schema for both defining and customizing Istio control plane installations.
// Running the operator with an empty user defined InstallSpec results in an control plane with default values, using the
// default charts.
//
// The simplest install specialization is to point the user InstallSpec profile to a different values file, for
// example an Istio minimal control plane, which will use the values associated with the minimal control plane profile for
// Istio.
//
// Deeper customization is possible at three levels:
//
// 1. New APIs defined in this file
//
//     Feature API: this API groups an Istio install by features and allows enabling/disabling the features, selecting base
//     control plane profiles, as well as some additional high level settings that are feature specific. Each feature contains
//     one or more components, which correspond to Istio components (Pods) in the cluster.
//
//     k8s API: this API is a pass through to k8s resource settings for Istio k8s resources. It allows customizing Istio k8s
//     resources like Affinity, Resource requests/limits, PodDisruptionBudgetSpec, Selectors etc. in a more consistent and
//     k8s specific way compared to values.yaml. See KubernetesResourcesSpec in this file for details.
//
// 1. values.yaml
//
//     The entirety of values.yaml settings is accessible through InstallSpec (see CommonComponentSpec/Values).
//     This API will gradually be deprecated and values there will be moved either into CRDs that are used to directly
//     configure components or, in the case of k8s settings, will be replaced by the new API above.
//
// 1. k8s resource overlays
//
//     Once a manifest is rendered from InstallSpec, a further customization can be applied by specifying k8s resource
//     overlays. The concept is similar to kustomize, where JSON patches are applied for object paths. This allows
//     customization at the lowest level and eliminates the need to create ad-hoc template parameters, or edit templates.
//
// Here are a few example uses:
//
// 1. Default Istio install
//
//     ```yaml
//     spec:
//     ```
//
// 1. Default minimal profile install
//
//     ```yaml
//     spec:
//       profile: minimal
//     ```
//
// 1. Default install with telemetry disabled
//
//     ```yaml
//     spec:
//       telemetry:
//         enabled: false
//     ```
//
// 1. Default install with each feature installed to different namespace and security components in separate namespaces
//
//     ```yaml
//     spec:
//       traffic_management:
//         components:
//           namespace: istio-traffic-management
//       policy:
//         components:
//           namespace: istio-policy
//       telemetry:
//         components:
//           namespace: istio-telemetry
//       config_management:
//         components:
//           namespace: istio-config-management
//       security:
//         components:
//           citadel:
//             namespace: istio-citadel
//           cert_manager:
//             namespace: istio-cert-manager
//           node_agent:
//             namespace: istio-node-agent
//     ```
//
// 1. Default install with specialized k8s settings for pilot
//
//     ```yaml
//     spec:
//       traffic_management:
//         components:
//           pilot:
//             k8s:
//               resources:
//                 limits:
//                   cpu: 444m
//                   memory: 333Mi
//                 requests:
//                   cpu: 222m
//                   memory: 111Mi
//               readinessProbe:
//                 failureThreshold: 44
//                 initialDelaySeconds: 11
//                 periodSeconds: 22
//                 successThreshold: 33
//     ```
//
// 1. Default install with values.yaml customizations for proxy
//
//     ```yaml
//     spec:
//       traffic_management:
//         components:
//           proxy:
//             values:
//             - global.proxy.enableCoreDump: true
//             - global.proxy.dnsRefreshRate: 10s
//     ```
//
// 1. Default install with modification to container flag in galley
//
//     ```yaml
//     spec:
//       configuration_management:
//         components:
//           galley:
//             k8s:
//               overlays:
//               - apiVersion: extensions/v1beta1
//                 kind: Deployment
//                 name: istio-galley
//                 patches:
//                 - path: spec.template.spec.containers.[name:galley].command.[--livenessProbeInterval]
//                   value: --livenessProbeInterval=123s
//     ```

package v1alpha2

import (
	fmt "fmt"
	protobuf "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "k8s.io/api/apps/v1"
	v2beta1 "k8s.io/api/autoscaling/v2beta1"
	v1 "k8s.io/api/core/v1"
	v11 "k8s.io/apimachinery/pkg/apis/meta/v1"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type InstallStatus_Status int32

const (
	InstallStatus_NONE     InstallStatus_Status = 0
	InstallStatus_UPDATING InstallStatus_Status = 1
	InstallStatus_HEALTHY  InstallStatus_Status = 2
	InstallStatus_ERROR    InstallStatus_Status = 3
)

var InstallStatus_Status_name = map[int32]string{
	0: "NONE",
	1: "UPDATING",
	2: "HEALTHY",
	3: "ERROR",
}

var InstallStatus_Status_value = map[string]int32{
	"NONE":     0,
	"UPDATING": 1,
	"HEALTHY":  2,
	"ERROR":    3,
}

func (x InstallStatus_Status) String() string {
	return proto.EnumName(InstallStatus_Status_name, int32(x))
}

func (InstallStatus_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{22, 0}
}

// IstioControlPlane is a CustomResourceDefinition (CRD) describing an Istio control plane.
type IstioControlPlane struct {
	// Spec defines the desired state of IstioControlPlane.
	Spec *IstioControlPlaneSpec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	// Status reports the status of the Istio control plane.
	Status               *InstallStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IstioControlPlane) Reset()         { *m = IstioControlPlane{} }
func (m *IstioControlPlane) String() string { return proto.CompactTextString(m) }
func (*IstioControlPlane) ProtoMessage()    {}
func (*IstioControlPlane) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{0}
}

func (m *IstioControlPlane) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioControlPlane.Unmarshal(m, b)
}
func (m *IstioControlPlane) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioControlPlane.Marshal(b, m, deterministic)
}
func (m *IstioControlPlane) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioControlPlane.Merge(m, src)
}
func (m *IstioControlPlane) XXX_Size() int {
	return xxx_messageInfo_IstioControlPlane.Size(m)
}
func (m *IstioControlPlane) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioControlPlane.DiscardUnknown(m)
}

var xxx_messageInfo_IstioControlPlane proto.InternalMessageInfo

func (m *IstioControlPlane) GetSpec() *IstioControlPlaneSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *IstioControlPlane) GetStatus() *InstallStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// IstioControlPlaneSpec defines the desired state of IstioControlPlane.
// The spec is a used to define a customization of the default profile values that are supplied with each Istio release.
// It is grouped at the top level by feature, where behavior of Istio functional areas is specified.
// Each feature contains components, where k8s resource level defaults can be overridden.
// Because the spec is a customization API, specifying an empty InstallSpec results in a default Istio control plane.
type IstioControlPlaneSpec struct {
	// Default namespace if feature or component namespaces are not set.
	DefaultNamespace string `protobuf:"bytes,5,opt,name=default_namespace,json=defaultNamespace,proto3" json:"default_namespace,omitempty"`
	// Selection and configuration of core Istio features.
	TrafficManagement *TrafficManagementFeatureSpec `protobuf:"bytes,25,opt,name=traffic_management,json=trafficManagement,proto3" json:"traffic_management,omitempty"`
	Policy            *PolicyFeatureSpec            `protobuf:"bytes,26,opt,name=policy,proto3" json:"policy,omitempty"`
	Telemetry         *TelemetryFeatureSpec         `protobuf:"bytes,27,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	Security          *SecurityFeatureSpec          `protobuf:"bytes,28,opt,name=security,proto3" json:"security,omitempty"`
	ConfigManagement  *ConfigManagementFeatureSpec  `protobuf:"bytes,29,opt,name=config_management,json=configManagement,proto3" json:"config_management,omitempty"`
	AutoInjection     *AutoInjectionFeatureSpec     `protobuf:"bytes,30,opt,name=auto_injection,json=autoInjection,proto3" json:"auto_injection,omitempty"`
	Gateways          *GatewayFeatureSpec           `protobuf:"bytes,31,opt,name=gateways,proto3" json:"gateways,omitempty"`
	// Overrides for default global values.yaml.
	Values map[string]interface{} `protobuf:"bytes,50,opt,name=values,proto3" json:"values,omitempty"`
	// Unvalidated overrides for default global values.yaml.
	UnvalidatedValues map[string]interface{} `protobuf:"bytes,51,opt,name=unvalidatedValues,proto3" json:"unvalidatedValues,omitempty"`
	// Path or name for the profile e.g.
	//     - minimal (looks in profiles dir for a file called minimal.yaml)
	//     - /tmp/istio/install/values/custom/custom-install.yaml (local file path)
	// default profile is used if this field is unset.
	Profile string `protobuf:"bytes,100,opt,name=profile,proto3" json:"profile,omitempty"`
	// Path for the install package. e.g.
	//     - /tmp/istio-installer/nightly (local file path)
	InstallPackagePath string `protobuf:"bytes,102,opt,name=install_package_path,json=installPackagePath,proto3" json:"install_package_path,omitempty"`
	// Root for docker image paths e.g. docker.io/istio-release.
	// Releases are published to docker hub under 'istio' project.
	// Daily builds from prow are on gcr.io, and nightly builds from circle on docker.io/istionightly
	Hub string `protobuf:"bytes,110,opt,name=hub,proto3" json:"hub,omitempty"`
	// Version tag for docker images e.g. 1.0.6
	Tag                  string   `protobuf:"bytes,111,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IstioControlPlaneSpec) Reset()         { *m = IstioControlPlaneSpec{} }
func (m *IstioControlPlaneSpec) String() string { return proto.CompactTextString(m) }
func (*IstioControlPlaneSpec) ProtoMessage()    {}
func (*IstioControlPlaneSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{1}
}

func (m *IstioControlPlaneSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioControlPlaneSpec.Unmarshal(m, b)
}
func (m *IstioControlPlaneSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioControlPlaneSpec.Marshal(b, m, deterministic)
}
func (m *IstioControlPlaneSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioControlPlaneSpec.Merge(m, src)
}
func (m *IstioControlPlaneSpec) XXX_Size() int {
	return xxx_messageInfo_IstioControlPlaneSpec.Size(m)
}
func (m *IstioControlPlaneSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioControlPlaneSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IstioControlPlaneSpec proto.InternalMessageInfo

func (m *IstioControlPlaneSpec) GetDefaultNamespace() string {
	if m != nil {
		return m.DefaultNamespace
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetTrafficManagement() *TrafficManagementFeatureSpec {
	if m != nil {
		return m.TrafficManagement
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetPolicy() *PolicyFeatureSpec {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetTelemetry() *TelemetryFeatureSpec {
	if m != nil {
		return m.Telemetry
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetSecurity() *SecurityFeatureSpec {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetConfigManagement() *ConfigManagementFeatureSpec {
	if m != nil {
		return m.ConfigManagement
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetAutoInjection() *AutoInjectionFeatureSpec {
	if m != nil {
		return m.AutoInjection
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetGateways() *GatewayFeatureSpec {
	if m != nil {
		return m.Gateways
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetValues() map[string]interface{} {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetUnvalidatedValues() map[string]interface{} {
	if m != nil {
		return m.UnvalidatedValues
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetProfile() string {
	if m != nil {
		return m.Profile
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetInstallPackagePath() string {
	if m != nil {
		return m.InstallPackagePath
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetHub() string {
	if m != nil {
		return m.Hub
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// Configuration options for traffic management.
type TrafficManagementFeatureSpec struct {
	// Selects whether traffic management is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *protobuf.BoolValue                      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *TrafficManagementFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *TrafficManagementFeatureSpec) Reset()         { *m = TrafficManagementFeatureSpec{} }
func (m *TrafficManagementFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*TrafficManagementFeatureSpec) ProtoMessage()    {}
func (*TrafficManagementFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{2}
}

func (m *TrafficManagementFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Unmarshal(m, b)
}
func (m *TrafficManagementFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Marshal(b, m, deterministic)
}
func (m *TrafficManagementFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficManagementFeatureSpec.Merge(m, src)
}
func (m *TrafficManagementFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Size(m)
}
func (m *TrafficManagementFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficManagementFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficManagementFeatureSpec proto.InternalMessageInfo

func (m *TrafficManagementFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TrafficManagementFeatureSpec) GetComponents() *TrafficManagementFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type TrafficManagementFeatureSpec_Components struct {
	// Namespace that all traffic management components are installed into.
	Namespace            string              `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Pilot                *PilotComponentSpec `protobuf:"bytes,20,opt,name=pilot,proto3" json:"pilot,omitempty"`
	Proxy                *ProxyComponentSpec `protobuf:"bytes,21,opt,name=proxy,proto3" json:"proxy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TrafficManagementFeatureSpec_Components) Reset() {
	*m = TrafficManagementFeatureSpec_Components{}
}
func (m *TrafficManagementFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*TrafficManagementFeatureSpec_Components) ProtoMessage()    {}
func (*TrafficManagementFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{2, 0}
}

func (m *TrafficManagementFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Unmarshal(m, b)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficManagementFeatureSpec_Components.Merge(m, src)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Size(m)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficManagementFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficManagementFeatureSpec_Components proto.InternalMessageInfo

func (m *TrafficManagementFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TrafficManagementFeatureSpec_Components) GetPilot() *PilotComponentSpec {
	if m != nil {
		return m.Pilot
	}
	return nil
}

func (m *TrafficManagementFeatureSpec_Components) GetProxy() *ProxyComponentSpec {
	if m != nil {
		return m.Proxy
	}
	return nil
}

// Configuration options for the policy feature.
type PolicyFeatureSpec struct {
	// Selects whether policy is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *protobuf.BoolValue           `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *PolicyFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PolicyFeatureSpec) Reset()         { *m = PolicyFeatureSpec{} }
func (m *PolicyFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*PolicyFeatureSpec) ProtoMessage()    {}
func (*PolicyFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{3}
}

func (m *PolicyFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyFeatureSpec.Unmarshal(m, b)
}
func (m *PolicyFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyFeatureSpec.Marshal(b, m, deterministic)
}
func (m *PolicyFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyFeatureSpec.Merge(m, src)
}
func (m *PolicyFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_PolicyFeatureSpec.Size(m)
}
func (m *PolicyFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyFeatureSpec proto.InternalMessageInfo

func (m *PolicyFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PolicyFeatureSpec) GetComponents() *PolicyFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type PolicyFeatureSpec_Components struct {
	// Namespace that all policy components are installed into.
	Namespace            string               `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Policy               *PolicyComponentSpec `protobuf:"bytes,20,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PolicyFeatureSpec_Components) Reset()         { *m = PolicyFeatureSpec_Components{} }
func (m *PolicyFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*PolicyFeatureSpec_Components) ProtoMessage()    {}
func (*PolicyFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{3, 0}
}

func (m *PolicyFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Unmarshal(m, b)
}
func (m *PolicyFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *PolicyFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyFeatureSpec_Components.Merge(m, src)
}
func (m *PolicyFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Size(m)
}
func (m *PolicyFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyFeatureSpec_Components proto.InternalMessageInfo

func (m *PolicyFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PolicyFeatureSpec_Components) GetPolicy() *PolicyComponentSpec {
	if m != nil {
		return m.Policy
	}
	return nil
}

// Configuration options for the telemetry feature.
type TelemetryFeatureSpec struct {
	// Selects whether telemetry is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *protobuf.BoolValue              `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *TelemetryFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *TelemetryFeatureSpec) Reset()         { *m = TelemetryFeatureSpec{} }
func (m *TelemetryFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*TelemetryFeatureSpec) ProtoMessage()    {}
func (*TelemetryFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{4}
}

func (m *TelemetryFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryFeatureSpec.Unmarshal(m, b)
}
func (m *TelemetryFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryFeatureSpec.Marshal(b, m, deterministic)
}
func (m *TelemetryFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryFeatureSpec.Merge(m, src)
}
func (m *TelemetryFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_TelemetryFeatureSpec.Size(m)
}
func (m *TelemetryFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryFeatureSpec proto.InternalMessageInfo

func (m *TelemetryFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TelemetryFeatureSpec) GetComponents() *TelemetryFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type TelemetryFeatureSpec_Components struct {
	// Namespace that all telemetry components are installed into.
	Namespace            string                  `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Telemetry            *TelemetryComponentSpec `protobuf:"bytes,20,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *TelemetryFeatureSpec_Components) Reset()         { *m = TelemetryFeatureSpec_Components{} }
func (m *TelemetryFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*TelemetryFeatureSpec_Components) ProtoMessage()    {}
func (*TelemetryFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{4, 0}
}

func (m *TelemetryFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Unmarshal(m, b)
}
func (m *TelemetryFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *TelemetryFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryFeatureSpec_Components.Merge(m, src)
}
func (m *TelemetryFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Size(m)
}
func (m *TelemetryFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryFeatureSpec_Components proto.InternalMessageInfo

func (m *TelemetryFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TelemetryFeatureSpec_Components) GetTelemetry() *TelemetryComponentSpec {
	if m != nil {
		return m.Telemetry
	}
	return nil
}

// Configuration options for security feature.
type SecurityFeatureSpec struct {
	// Selects whether security feature is installed. Must be set for any sub-component to be installed.
	Enabled              *protobuf.BoolValue             `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *SecurityFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SecurityFeatureSpec) Reset()         { *m = SecurityFeatureSpec{} }
func (m *SecurityFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*SecurityFeatureSpec) ProtoMessage()    {}
func (*SecurityFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{5}
}

func (m *SecurityFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityFeatureSpec.Unmarshal(m, b)
}
func (m *SecurityFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityFeatureSpec.Marshal(b, m, deterministic)
}
func (m *SecurityFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityFeatureSpec.Merge(m, src)
}
func (m *SecurityFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_SecurityFeatureSpec.Size(m)
}
func (m *SecurityFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityFeatureSpec proto.InternalMessageInfo

func (m *SecurityFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *SecurityFeatureSpec) GetComponents() *SecurityFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type SecurityFeatureSpec_Components struct {
	// Namespace that security components are installed into.
	Namespace            string                    `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Citadel              *CitadelComponentSpec     `protobuf:"bytes,20,opt,name=citadel,proto3" json:"citadel,omitempty"`
	CertManager          *CertManagerComponentSpec `protobuf:"bytes,21,opt,name=cert_manager,json=certManager,proto3" json:"cert_manager,omitempty"`
	NodeAgent            *NodeAgentComponentSpec   `protobuf:"bytes,22,opt,name=node_agent,json=nodeAgent,proto3" json:"node_agent,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SecurityFeatureSpec_Components) Reset()         { *m = SecurityFeatureSpec_Components{} }
func (m *SecurityFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*SecurityFeatureSpec_Components) ProtoMessage()    {}
func (*SecurityFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{5, 0}
}

func (m *SecurityFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Unmarshal(m, b)
}
func (m *SecurityFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *SecurityFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityFeatureSpec_Components.Merge(m, src)
}
func (m *SecurityFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Size(m)
}
func (m *SecurityFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityFeatureSpec_Components proto.InternalMessageInfo

func (m *SecurityFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SecurityFeatureSpec_Components) GetCitadel() *CitadelComponentSpec {
	if m != nil {
		return m.Citadel
	}
	return nil
}

func (m *SecurityFeatureSpec_Components) GetCertManager() *CertManagerComponentSpec {
	if m != nil {
		return m.CertManager
	}
	return nil
}

func (m *SecurityFeatureSpec_Components) GetNodeAgent() *NodeAgentComponentSpec {
	if m != nil {
		return m.NodeAgent
	}
	return nil
}

// Configuration options for configuration management feature.
type ConfigManagementFeatureSpec struct {
	// Selects whether config management feature is installed. Must be set for any sub-component to be installed.
	Enabled              *protobuf.BoolValue                     `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *ConfigManagementFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ConfigManagementFeatureSpec) Reset()         { *m = ConfigManagementFeatureSpec{} }
func (m *ConfigManagementFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigManagementFeatureSpec) ProtoMessage()    {}
func (*ConfigManagementFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{6}
}

func (m *ConfigManagementFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Unmarshal(m, b)
}
func (m *ConfigManagementFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Marshal(b, m, deterministic)
}
func (m *ConfigManagementFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigManagementFeatureSpec.Merge(m, src)
}
func (m *ConfigManagementFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Size(m)
}
func (m *ConfigManagementFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigManagementFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigManagementFeatureSpec proto.InternalMessageInfo

func (m *ConfigManagementFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *ConfigManagementFeatureSpec) GetComponents() *ConfigManagementFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type ConfigManagementFeatureSpec_Components struct {
	// Namespace that security components are installed into.
	Namespace            string               `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Galley               *GalleyComponentSpec `protobuf:"bytes,20,opt,name=galley,proto3" json:"galley,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ConfigManagementFeatureSpec_Components) Reset() {
	*m = ConfigManagementFeatureSpec_Components{}
}
func (m *ConfigManagementFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*ConfigManagementFeatureSpec_Components) ProtoMessage()    {}
func (*ConfigManagementFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{6, 0}
}

func (m *ConfigManagementFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Unmarshal(m, b)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigManagementFeatureSpec_Components.Merge(m, src)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Size(m)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigManagementFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigManagementFeatureSpec_Components proto.InternalMessageInfo

func (m *ConfigManagementFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ConfigManagementFeatureSpec_Components) GetGalley() *GalleyComponentSpec {
	if m != nil {
		return m.Galley
	}
	return nil
}

// Configuration options for auto injection feature.
type AutoInjectionFeatureSpec struct {
	// Selects whether auto injection feature is installed. Must be set for any sub-component to be installed.
	Enabled              *protobuf.BoolValue                  `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *AutoInjectionFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *AutoInjectionFeatureSpec) Reset()         { *m = AutoInjectionFeatureSpec{} }
func (m *AutoInjectionFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*AutoInjectionFeatureSpec) ProtoMessage()    {}
func (*AutoInjectionFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{7}
}

func (m *AutoInjectionFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Unmarshal(m, b)
}
func (m *AutoInjectionFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Marshal(b, m, deterministic)
}
func (m *AutoInjectionFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoInjectionFeatureSpec.Merge(m, src)
}
func (m *AutoInjectionFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Size(m)
}
func (m *AutoInjectionFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoInjectionFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AutoInjectionFeatureSpec proto.InternalMessageInfo

func (m *AutoInjectionFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *AutoInjectionFeatureSpec) GetComponents() *AutoInjectionFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type AutoInjectionFeatureSpec_Components struct {
	// Namespace that auto injections components are installed into.
	Namespace            string                        `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Injector             *SidecarInjectorComponentSpec `protobuf:"bytes,20,opt,name=injector,proto3" json:"injector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AutoInjectionFeatureSpec_Components) Reset()         { *m = AutoInjectionFeatureSpec_Components{} }
func (m *AutoInjectionFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*AutoInjectionFeatureSpec_Components) ProtoMessage()    {}
func (*AutoInjectionFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{7, 0}
}

func (m *AutoInjectionFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Unmarshal(m, b)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoInjectionFeatureSpec_Components.Merge(m, src)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Size(m)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoInjectionFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_AutoInjectionFeatureSpec_Components proto.InternalMessageInfo

func (m *AutoInjectionFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *AutoInjectionFeatureSpec_Components) GetInjector() *SidecarInjectorComponentSpec {
	if m != nil {
		return m.Injector
	}
	return nil
}

// Configuration options for gateway feature.
type GatewayFeatureSpec struct {
	// Selects whether gateway feature is installed. Must be set for any sub-component to be installed.
	Enabled              *protobuf.BoolValue            `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *GatewayFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GatewayFeatureSpec) Reset()         { *m = GatewayFeatureSpec{} }
func (m *GatewayFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*GatewayFeatureSpec) ProtoMessage()    {}
func (*GatewayFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{8}
}

func (m *GatewayFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayFeatureSpec.Unmarshal(m, b)
}
func (m *GatewayFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayFeatureSpec.Marshal(b, m, deterministic)
}
func (m *GatewayFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayFeatureSpec.Merge(m, src)
}
func (m *GatewayFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_GatewayFeatureSpec.Size(m)
}
func (m *GatewayFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayFeatureSpec proto.InternalMessageInfo

func (m *GatewayFeatureSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *GatewayFeatureSpec) GetComponents() *GatewayFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type GatewayFeatureSpec_Components struct {
	// Namespace that auto injections components are installed into.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Ingress/egress gateway configuration.
	IngressGateway       *IngressGatewayComponentSpec `protobuf:"bytes,31,opt,name=ingress_gateway,json=ingressGateway,proto3" json:"ingress_gateway,omitempty"`
	EgressGateway        *EgressGatewayComponentSpec  `protobuf:"bytes,32,opt,name=egress_gateway,json=egressGateway,proto3" json:"egress_gateway,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GatewayFeatureSpec_Components) Reset()         { *m = GatewayFeatureSpec_Components{} }
func (m *GatewayFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*GatewayFeatureSpec_Components) ProtoMessage()    {}
func (*GatewayFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{8, 0}
}

func (m *GatewayFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Unmarshal(m, b)
}
func (m *GatewayFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *GatewayFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayFeatureSpec_Components.Merge(m, src)
}
func (m *GatewayFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Size(m)
}
func (m *GatewayFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayFeatureSpec_Components proto.InternalMessageInfo

func (m *GatewayFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GatewayFeatureSpec_Components) GetIngressGateway() *IngressGatewayComponentSpec {
	if m != nil {
		return m.IngressGateway
	}
	return nil
}

func (m *GatewayFeatureSpec_Components) GetEgressGateway() *EgressGatewayComponentSpec {
	if m != nil {
		return m.EgressGateway
	}
	return nil
}

// Configuration options for the pilot component.
type PilotComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PilotComponentSpec) Reset()         { *m = PilotComponentSpec{} }
func (m *PilotComponentSpec) String() string { return proto.CompactTextString(m) }
func (*PilotComponentSpec) ProtoMessage()    {}
func (*PilotComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{9}
}

func (m *PilotComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PilotComponentSpec.Unmarshal(m, b)
}
func (m *PilotComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PilotComponentSpec.Marshal(b, m, deterministic)
}
func (m *PilotComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PilotComponentSpec.Merge(m, src)
}
func (m *PilotComponentSpec) XXX_Size() int {
	return xxx_messageInfo_PilotComponentSpec.Size(m)
}
func (m *PilotComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PilotComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PilotComponentSpec proto.InternalMessageInfo

func (m *PilotComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PilotComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PilotComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the proxy.
type ProxyComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ProxyComponentSpec) Reset()         { *m = ProxyComponentSpec{} }
func (m *ProxyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*ProxyComponentSpec) ProtoMessage()    {}
func (*ProxyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{10}
}

func (m *ProxyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProxyComponentSpec.Unmarshal(m, b)
}
func (m *ProxyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProxyComponentSpec.Marshal(b, m, deterministic)
}
func (m *ProxyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyComponentSpec.Merge(m, src)
}
func (m *ProxyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_ProxyComponentSpec.Size(m)
}
func (m *ProxyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyComponentSpec proto.InternalMessageInfo

func (m *ProxyComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *ProxyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ProxyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the sidecar injector component.
type SidecarInjectorComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SidecarInjectorComponentSpec) Reset()         { *m = SidecarInjectorComponentSpec{} }
func (m *SidecarInjectorComponentSpec) String() string { return proto.CompactTextString(m) }
func (*SidecarInjectorComponentSpec) ProtoMessage()    {}
func (*SidecarInjectorComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{11}
}

func (m *SidecarInjectorComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Unmarshal(m, b)
}
func (m *SidecarInjectorComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Marshal(b, m, deterministic)
}
func (m *SidecarInjectorComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SidecarInjectorComponentSpec.Merge(m, src)
}
func (m *SidecarInjectorComponentSpec) XXX_Size() int {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Size(m)
}
func (m *SidecarInjectorComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SidecarInjectorComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SidecarInjectorComponentSpec proto.InternalMessageInfo

func (m *SidecarInjectorComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *SidecarInjectorComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SidecarInjectorComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the policy enforcement component.
type PolicyComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PolicyComponentSpec) Reset()         { *m = PolicyComponentSpec{} }
func (m *PolicyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*PolicyComponentSpec) ProtoMessage()    {}
func (*PolicyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{12}
}

func (m *PolicyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyComponentSpec.Unmarshal(m, b)
}
func (m *PolicyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyComponentSpec.Marshal(b, m, deterministic)
}
func (m *PolicyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyComponentSpec.Merge(m, src)
}
func (m *PolicyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_PolicyComponentSpec.Size(m)
}
func (m *PolicyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyComponentSpec proto.InternalMessageInfo

func (m *PolicyComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PolicyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PolicyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the telemetry component.
type TelemetryComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *TelemetryComponentSpec) Reset()         { *m = TelemetryComponentSpec{} }
func (m *TelemetryComponentSpec) String() string { return proto.CompactTextString(m) }
func (*TelemetryComponentSpec) ProtoMessage()    {}
func (*TelemetryComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{13}
}

func (m *TelemetryComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryComponentSpec.Unmarshal(m, b)
}
func (m *TelemetryComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryComponentSpec.Marshal(b, m, deterministic)
}
func (m *TelemetryComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryComponentSpec.Merge(m, src)
}
func (m *TelemetryComponentSpec) XXX_Size() int {
	return xxx_messageInfo_TelemetryComponentSpec.Size(m)
}
func (m *TelemetryComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryComponentSpec proto.InternalMessageInfo

func (m *TelemetryComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TelemetryComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TelemetryComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for Citadel component.
type CitadelComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CitadelComponentSpec) Reset()         { *m = CitadelComponentSpec{} }
func (m *CitadelComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CitadelComponentSpec) ProtoMessage()    {}
func (*CitadelComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{14}
}

func (m *CitadelComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CitadelComponentSpec.Unmarshal(m, b)
}
func (m *CitadelComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CitadelComponentSpec.Marshal(b, m, deterministic)
}
func (m *CitadelComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CitadelComponentSpec.Merge(m, src)
}
func (m *CitadelComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CitadelComponentSpec.Size(m)
}
func (m *CitadelComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CitadelComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CitadelComponentSpec proto.InternalMessageInfo

func (m *CitadelComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CitadelComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CitadelComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for certificate manager component.
type CertManagerComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CertManagerComponentSpec) Reset()         { *m = CertManagerComponentSpec{} }
func (m *CertManagerComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CertManagerComponentSpec) ProtoMessage()    {}
func (*CertManagerComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{15}
}

func (m *CertManagerComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CertManagerComponentSpec.Unmarshal(m, b)
}
func (m *CertManagerComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CertManagerComponentSpec.Marshal(b, m, deterministic)
}
func (m *CertManagerComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertManagerComponentSpec.Merge(m, src)
}
func (m *CertManagerComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CertManagerComponentSpec.Size(m)
}
func (m *CertManagerComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CertManagerComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CertManagerComponentSpec proto.InternalMessageInfo

func (m *CertManagerComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CertManagerComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CertManagerComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for node agent component.
type NodeAgentComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NodeAgentComponentSpec) Reset()         { *m = NodeAgentComponentSpec{} }
func (m *NodeAgentComponentSpec) String() string { return proto.CompactTextString(m) }
func (*NodeAgentComponentSpec) ProtoMessage()    {}
func (*NodeAgentComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{16}
}

func (m *NodeAgentComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeAgentComponentSpec.Unmarshal(m, b)
}
func (m *NodeAgentComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeAgentComponentSpec.Marshal(b, m, deterministic)
}
func (m *NodeAgentComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAgentComponentSpec.Merge(m, src)
}
func (m *NodeAgentComponentSpec) XXX_Size() int {
	return xxx_messageInfo_NodeAgentComponentSpec.Size(m)
}
func (m *NodeAgentComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAgentComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAgentComponentSpec proto.InternalMessageInfo

func (m *NodeAgentComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *NodeAgentComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *NodeAgentComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for node agent component.
type GalleyComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GalleyComponentSpec) Reset()         { *m = GalleyComponentSpec{} }
func (m *GalleyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*GalleyComponentSpec) ProtoMessage()    {}
func (*GalleyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{17}
}

func (m *GalleyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GalleyComponentSpec.Unmarshal(m, b)
}
func (m *GalleyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GalleyComponentSpec.Marshal(b, m, deterministic)
}
func (m *GalleyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GalleyComponentSpec.Merge(m, src)
}
func (m *GalleyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_GalleyComponentSpec.Size(m)
}
func (m *GalleyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GalleyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_GalleyComponentSpec proto.InternalMessageInfo

func (m *GalleyComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *GalleyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GalleyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for ingress gateways.
type IngressGatewayComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *IngressGatewayComponentSpec) Reset()         { *m = IngressGatewayComponentSpec{} }
func (m *IngressGatewayComponentSpec) String() string { return proto.CompactTextString(m) }
func (*IngressGatewayComponentSpec) ProtoMessage()    {}
func (*IngressGatewayComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{18}
}

func (m *IngressGatewayComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IngressGatewayComponentSpec.Unmarshal(m, b)
}
func (m *IngressGatewayComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IngressGatewayComponentSpec.Marshal(b, m, deterministic)
}
func (m *IngressGatewayComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressGatewayComponentSpec.Merge(m, src)
}
func (m *IngressGatewayComponentSpec) XXX_Size() int {
	return xxx_messageInfo_IngressGatewayComponentSpec.Size(m)
}
func (m *IngressGatewayComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressGatewayComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IngressGatewayComponentSpec proto.InternalMessageInfo

func (m *IngressGatewayComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *IngressGatewayComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *IngressGatewayComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for egress gateways.
type EgressGatewayComponentSpec struct {
	Enabled              *protobuf.BoolValue      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *EgressGatewayComponentSpec) Reset()         { *m = EgressGatewayComponentSpec{} }
func (m *EgressGatewayComponentSpec) String() string { return proto.CompactTextString(m) }
func (*EgressGatewayComponentSpec) ProtoMessage()    {}
func (*EgressGatewayComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{19}
}

func (m *EgressGatewayComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EgressGatewayComponentSpec.Unmarshal(m, b)
}
func (m *EgressGatewayComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EgressGatewayComponentSpec.Marshal(b, m, deterministic)
}
func (m *EgressGatewayComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EgressGatewayComponentSpec.Merge(m, src)
}
func (m *EgressGatewayComponentSpec) XXX_Size() int {
	return xxx_messageInfo_EgressGatewayComponentSpec.Size(m)
}
func (m *EgressGatewayComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_EgressGatewayComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_EgressGatewayComponentSpec proto.InternalMessageInfo

func (m *EgressGatewayComponentSpec) GetEnabled() *protobuf.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *EgressGatewayComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *EgressGatewayComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// KubernetesResourcesConfig is a common set of k8s resource configs for components.
type KubernetesResourcesSpec struct {
	// k8s affinity.
	// https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity
	Affinity *v1.Affinity `protobuf:"bytes,1,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// Deployment environment variables.
	// https://kubernetes.io/docs/tasks/inject-data-application/define-environment-variable-container/
	Env []*v1.EnvVar `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// k8s HorizontalPodAutoscaler settings.
	// https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	HpaSpec *v2beta1.HorizontalPodAutoscalerSpec `protobuf:"bytes,3,opt,name=hpa_spec,json=hpaSpec,proto3" json:"hpa_spec,omitempty"`
	// k8s imagePullPolicy.
	// https://kubernetes.io/docs/concepts/containers/images/
	ImagePullPolicy string `protobuf:"bytes,4,opt,name=image_pull_policy,json=imagePullPolicy,proto3" json:"image_pull_policy,omitempty"`
	// k8s nodeSelector.
	// https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	NodeSelector map[string]string `protobuf:"bytes,5,rep,name=node_selector,json=nodeSelector,proto3" json:"node_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s PodDisruptionBudget settings.
	// https://kubernetes.io/docs/concepts/workloads/pods/disruptions/#how-disruption-budgets-work
	PodDisruptionBudget *PodDisruptionBudgetSpec `protobuf:"bytes,6,opt,name=pod_disruption_budget,json=podDisruptionBudget,proto3" json:"pod_disruption_budget,omitempty"`
	// k8s pod annotations.
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	PodAnnotations map[string]string `protobuf:"bytes,7,rep,name=pod_annotations,json=podAnnotations,proto3" json:"pod_annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s priority_class_name. Default for all resources unless overridden.
	// https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass
	PriorityClassName string `protobuf:"bytes,8,opt,name=priority_class_name,json=priorityClassName,proto3" json:"priority_class_name,omitempty"`
	// k8s readinessProbe settings.
	// https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-probes/
	// k8s.io.api.core.v1.Probe readiness_probe = 9;
	ReadinessProbe *ReadinessProbe `protobuf:"bytes,9,opt,name=readiness_probe,json=readinessProbe,proto3" json:"readiness_probe,omitempty"`
	// k8s Deployment replicas setting.
	// https://kubernetes.io/docs/concepts/workloads/controllers/deployment/
	ReplicaCount uint32 `protobuf:"varint,10,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// k8s resources settings.
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	Resources *Resources `protobuf:"bytes,11,opt,name=resources,proto3" json:"resources,omitempty"`
	// k8s Service settings.
	// https://kubernetes.io/docs/concepts/services-networking/service/
	Service *v1.ServiceSpec `protobuf:"bytes,12,opt,name=service,proto3" json:"service,omitempty"`
	// k8s deployment strategy.
	// https://kubernetes.io/docs/concepts/workloads/controllers/deployment/
	Strategy *DeploymentStrategy `protobuf:"bytes,13,opt,name=strategy,proto3" json:"strategy,omitempty"`
	// k8s toleration
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Tolerations []*v1.Toleration `protobuf:"bytes,14,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// Overlays for k8s resources in rendered manifests.
	Overlays             []*K8SObjectOverlay `protobuf:"bytes,100,rep,name=overlays,proto3" json:"overlays,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *KubernetesResourcesSpec) Reset()         { *m = KubernetesResourcesSpec{} }
func (m *KubernetesResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*KubernetesResourcesSpec) ProtoMessage()    {}
func (*KubernetesResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{20}
}

func (m *KubernetesResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KubernetesResourcesSpec.Unmarshal(m, b)
}
func (m *KubernetesResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KubernetesResourcesSpec.Marshal(b, m, deterministic)
}
func (m *KubernetesResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubernetesResourcesSpec.Merge(m, src)
}
func (m *KubernetesResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_KubernetesResourcesSpec.Size(m)
}
func (m *KubernetesResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_KubernetesResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_KubernetesResourcesSpec proto.InternalMessageInfo

func (m *KubernetesResourcesSpec) GetAffinity() *v1.Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetEnv() []*v1.EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetHpaSpec() *v2beta1.HorizontalPodAutoscalerSpec {
	if m != nil {
		return m.HpaSpec
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetImagePullPolicy() string {
	if m != nil {
		return m.ImagePullPolicy
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetNodeSelector() map[string]string {
	if m != nil {
		return m.NodeSelector
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodDisruptionBudget() *PodDisruptionBudgetSpec {
	if m != nil {
		return m.PodDisruptionBudget
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodAnnotations() map[string]string {
	if m != nil {
		return m.PodAnnotations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPriorityClassName() string {
	if m != nil {
		return m.PriorityClassName
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetReadinessProbe() *ReadinessProbe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetReplicaCount() uint32 {
	if m != nil {
		return m.ReplicaCount
	}
	return 0
}

func (m *KubernetesResourcesSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetService() *v1.ServiceSpec {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetStrategy() *DeploymentStrategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetTolerations() []*v1.Toleration {
	if m != nil {
		return m.Tolerations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetOverlays() []*K8SObjectOverlay {
	if m != nil {
		return m.Overlays
	}
	return nil
}

// Patch for an existing k8s resource.
type K8SObjectOverlay struct {
	// Resource API version.
	ApiVersion string `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Resource kind.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// Name of resource.
	// Namespace is always the component namespace.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// List of patches to apply to resource.
	Patches              []*K8SObjectOverlay_PathValue `protobuf:"bytes,4,rep,name=patches,proto3" json:"patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *K8SObjectOverlay) Reset()         { *m = K8SObjectOverlay{} }
func (m *K8SObjectOverlay) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay) ProtoMessage()    {}
func (*K8SObjectOverlay) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{21}
}

func (m *K8SObjectOverlay) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay.Unmarshal(m, b)
}
func (m *K8SObjectOverlay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay.Merge(m, src)
}
func (m *K8SObjectOverlay) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay.Size(m)
}
func (m *K8SObjectOverlay) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay proto.InternalMessageInfo

func (m *K8SObjectOverlay) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *K8SObjectOverlay) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *K8SObjectOverlay) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *K8SObjectOverlay) GetPatches() []*K8SObjectOverlay_PathValue {
	if m != nil {
		return m.Patches
	}
	return nil
}

type K8SObjectOverlay_PathValue struct {
	// Path of the form a.b:c.e.:f
	// Where b:c is a list element selector of the form key:value and :f is a list selector of the form :value.
	// All path intermediate nodes must exist.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Value to add, delete or replace.
	// For add, the path should be a new leaf.
	// For delete, value should be unset.
	// For replace, path should reference an existing node.
	// All values are strings but are converted into appropriate type based on schema.
	Value                interface{} `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *K8SObjectOverlay_PathValue) Reset()         { *m = K8SObjectOverlay_PathValue{} }
func (m *K8SObjectOverlay_PathValue) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay_PathValue) ProtoMessage()    {}
func (*K8SObjectOverlay_PathValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{21, 0}
}

func (m *K8SObjectOverlay_PathValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Unmarshal(m, b)
}
func (m *K8SObjectOverlay_PathValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay_PathValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay_PathValue.Merge(m, src)
}
func (m *K8SObjectOverlay_PathValue) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Size(m)
}
func (m *K8SObjectOverlay_PathValue) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay_PathValue.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay_PathValue proto.InternalMessageInfo

func (m *K8SObjectOverlay_PathValue) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *K8SObjectOverlay_PathValue) GetValue() interface{} {
	if m != nil {
		return m.Value
	}
	return nil
}

// Observed state of IstioControlPlane.
type InstallStatus struct {
	TrafficManagement    *InstallStatus_VersionStatus   `protobuf:"bytes,1,opt,name=traffic_management,json=trafficManagement,proto3" json:"traffic_management,omitempty"`
	PolicyTelemetry      *InstallStatus_VersionStatus   `protobuf:"bytes,2,opt,name=policy_telemetry,json=policyTelemetry,proto3" json:"policy_telemetry,omitempty"`
	Security             *InstallStatus_VersionStatus   `protobuf:"bytes,3,opt,name=security,proto3" json:"security,omitempty"`
	ConfigManagement     *InstallStatus_VersionStatus   `protobuf:"bytes,4,opt,name=config_management,json=configManagement,proto3" json:"config_management,omitempty"`
	IngressGateway       []*InstallStatus_VersionStatus `protobuf:"bytes,5,rep,name=ingress_gateway,json=ingressGateway,proto3" json:"ingress_gateway,omitempty"`
	EgressGateway        []*InstallStatus_VersionStatus `protobuf:"bytes,6,rep,name=egress_gateway,json=egressGateway,proto3" json:"egress_gateway,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstallStatus) Reset()         { *m = InstallStatus{} }
func (m *InstallStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus) ProtoMessage()    {}
func (*InstallStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{22}
}

func (m *InstallStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus.Unmarshal(m, b)
}
func (m *InstallStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus.Merge(m, src)
}
func (m *InstallStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus.Size(m)
}
func (m *InstallStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus proto.InternalMessageInfo

func (m *InstallStatus) GetTrafficManagement() *InstallStatus_VersionStatus {
	if m != nil {
		return m.TrafficManagement
	}
	return nil
}

func (m *InstallStatus) GetPolicyTelemetry() *InstallStatus_VersionStatus {
	if m != nil {
		return m.PolicyTelemetry
	}
	return nil
}

func (m *InstallStatus) GetSecurity() *InstallStatus_VersionStatus {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *InstallStatus) GetConfigManagement() *InstallStatus_VersionStatus {
	if m != nil {
		return m.ConfigManagement
	}
	return nil
}

func (m *InstallStatus) GetIngressGateway() []*InstallStatus_VersionStatus {
	if m != nil {
		return m.IngressGateway
	}
	return nil
}

func (m *InstallStatus) GetEgressGateway() []*InstallStatus_VersionStatus {
	if m != nil {
		return m.EgressGateway
	}
	return nil
}

type InstallStatus_VersionStatus struct {
	Version              string               `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Status               InstallStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=v1alpha2.InstallStatus_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InstallStatus_VersionStatus) Reset()         { *m = InstallStatus_VersionStatus{} }
func (m *InstallStatus_VersionStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus_VersionStatus) ProtoMessage()    {}
func (*InstallStatus_VersionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{22, 0}
}

func (m *InstallStatus_VersionStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus_VersionStatus.Unmarshal(m, b)
}
func (m *InstallStatus_VersionStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus_VersionStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus_VersionStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus_VersionStatus.Merge(m, src)
}
func (m *InstallStatus_VersionStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus_VersionStatus.Size(m)
}
func (m *InstallStatus_VersionStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus_VersionStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus_VersionStatus proto.InternalMessageInfo

func (m *InstallStatus_VersionStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *InstallStatus_VersionStatus) GetStatus() InstallStatus_Status {
	if m != nil {
		return m.Status
	}
	return InstallStatus_NONE
}

// Mirrors k8s.io.api.core.v1.ResourceRequirements for unmarshaling.
type Resources struct {
	Limits               map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Requests             map[string]string `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{23}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetLimits() map[string]string {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *Resources) GetRequests() map[string]string {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.Probe for unmarshaling
type ReadinessProbe struct {
	Exec                 *ExecAction      `protobuf:"bytes,1,opt,name=exec,proto3" json:"exec,omitempty"`
	HttpGet              *HTTPGetAction   `protobuf:"bytes,2,opt,name=httpGet,proto3" json:"httpGet,omitempty"`
	TcpSocket            *TCPSocketAction `protobuf:"bytes,3,opt,name=tcpSocket,proto3" json:"tcpSocket,omitempty"`
	InitialDelaySeconds  int32            `protobuf:"varint,4,opt,name=initialDelaySeconds,proto3" json:"initialDelaySeconds,omitempty"`
	TimeoutSeconds       int32            `protobuf:"varint,5,opt,name=timeoutSeconds,proto3" json:"timeoutSeconds,omitempty"`
	PeriodSeconds        int32            `protobuf:"varint,6,opt,name=periodSeconds,proto3" json:"periodSeconds,omitempty"`
	SuccessThreshold     int32            `protobuf:"varint,7,opt,name=successThreshold,proto3" json:"successThreshold,omitempty"`
	FailureThreshold     int32            `protobuf:"varint,8,opt,name=failureThreshold,proto3" json:"failureThreshold,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReadinessProbe) Reset()         { *m = ReadinessProbe{} }
func (m *ReadinessProbe) String() string { return proto.CompactTextString(m) }
func (*ReadinessProbe) ProtoMessage()    {}
func (*ReadinessProbe) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{24}
}

func (m *ReadinessProbe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadinessProbe.Unmarshal(m, b)
}
func (m *ReadinessProbe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadinessProbe.Marshal(b, m, deterministic)
}
func (m *ReadinessProbe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadinessProbe.Merge(m, src)
}
func (m *ReadinessProbe) XXX_Size() int {
	return xxx_messageInfo_ReadinessProbe.Size(m)
}
func (m *ReadinessProbe) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadinessProbe.DiscardUnknown(m)
}

var xxx_messageInfo_ReadinessProbe proto.InternalMessageInfo

func (m *ReadinessProbe) GetExec() *ExecAction {
	if m != nil {
		return m.Exec
	}
	return nil
}

func (m *ReadinessProbe) GetHttpGet() *HTTPGetAction {
	if m != nil {
		return m.HttpGet
	}
	return nil
}

func (m *ReadinessProbe) GetTcpSocket() *TCPSocketAction {
	if m != nil {
		return m.TcpSocket
	}
	return nil
}

func (m *ReadinessProbe) GetInitialDelaySeconds() int32 {
	if m != nil {
		return m.InitialDelaySeconds
	}
	return 0
}

func (m *ReadinessProbe) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetSuccessThreshold() int32 {
	if m != nil {
		return m.SuccessThreshold
	}
	return 0
}

func (m *ReadinessProbe) GetFailureThreshold() int32 {
	if m != nil {
		return m.FailureThreshold
	}
	return 0
}

// Mirrors k8s.io.api.core.v1.ExecAction for unmarshaling
type ExecAction struct {
	Command              []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecAction) Reset()         { *m = ExecAction{} }
func (m *ExecAction) String() string { return proto.CompactTextString(m) }
func (*ExecAction) ProtoMessage()    {}
func (*ExecAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{25}
}

func (m *ExecAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecAction.Unmarshal(m, b)
}
func (m *ExecAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecAction.Marshal(b, m, deterministic)
}
func (m *ExecAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecAction.Merge(m, src)
}
func (m *ExecAction) XXX_Size() int {
	return xxx_messageInfo_ExecAction.Size(m)
}
func (m *ExecAction) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecAction.DiscardUnknown(m)
}

var xxx_messageInfo_ExecAction proto.InternalMessageInfo

func (m *ExecAction) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.HTTPGetAction for unmarshaling
type HTTPGetAction struct {
	Path                 string                `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Port                 *IntOrStringForPB `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Scheme               string                `protobuf:"bytes,4,opt,name=scheme,proto3" json:"scheme,omitempty"`
	HttpHeaders          []*HTTPHeader         `protobuf:"bytes,5,rep,name=httpHeaders,proto3" json:"httpHeaders,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HTTPGetAction) Reset()         { *m = HTTPGetAction{} }
func (m *HTTPGetAction) String() string { return proto.CompactTextString(m) }
func (*HTTPGetAction) ProtoMessage()    {}
func (*HTTPGetAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{26}
}

func (m *HTTPGetAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPGetAction.Unmarshal(m, b)
}
func (m *HTTPGetAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPGetAction.Marshal(b, m, deterministic)
}
func (m *HTTPGetAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPGetAction.Merge(m, src)
}
func (m *HTTPGetAction) XXX_Size() int {
	return xxx_messageInfo_HTTPGetAction.Size(m)
}
func (m *HTTPGetAction) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPGetAction.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPGetAction proto.InternalMessageInfo

func (m *HTTPGetAction) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPGetAction) GetPort() *IntOrStringForPB {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *HTTPGetAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HTTPGetAction) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.HTTPHeader for unmarshaling
type HTTPHeader struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPHeader) Reset()         { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()    {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{27}
}

func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPHeader.Unmarshal(m, b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
}
func (m *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(m, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return xxx_messageInfo_HTTPHeader.Size(m)
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Mirrors k8s.io.api.core.v1.TCPSocketAction for unmarshaling
type TCPSocketAction struct {
	Port                 *IntOrStringForPB `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TCPSocketAction) Reset()         { *m = TCPSocketAction{} }
func (m *TCPSocketAction) String() string { return proto.CompactTextString(m) }
func (*TCPSocketAction) ProtoMessage()    {}
func (*TCPSocketAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{28}
}

func (m *TCPSocketAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TCPSocketAction.Unmarshal(m, b)
}
func (m *TCPSocketAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TCPSocketAction.Marshal(b, m, deterministic)
}
func (m *TCPSocketAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPSocketAction.Merge(m, src)
}
func (m *TCPSocketAction) XXX_Size() int {
	return xxx_messageInfo_TCPSocketAction.Size(m)
}
func (m *TCPSocketAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPSocketAction.DiscardUnknown(m)
}

var xxx_messageInfo_TCPSocketAction proto.InternalMessageInfo

func (m *TCPSocketAction) GetPort() *IntOrStringForPB {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TCPSocketAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// Mirrors k8s.io.api.policy.v1beta1.PodDisruptionBudget for unmarshaling.
type PodDisruptionBudgetSpec struct {
	MinAvailable         uint32             `protobuf:"varint,1,opt,name=minAvailable,proto3" json:"minAvailable,omitempty"`
	Selector             *v11.LabelSelector `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	MaxUnavailable       uint32             `protobuf:"varint,3,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PodDisruptionBudgetSpec) Reset()         { *m = PodDisruptionBudgetSpec{} }
func (m *PodDisruptionBudgetSpec) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudgetSpec) ProtoMessage()    {}
func (*PodDisruptionBudgetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{29}
}

func (m *PodDisruptionBudgetSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Unmarshal(m, b)
}
func (m *PodDisruptionBudgetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Marshal(b, m, deterministic)
}
func (m *PodDisruptionBudgetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudgetSpec.Merge(m, src)
}
func (m *PodDisruptionBudgetSpec) XXX_Size() int {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Size(m)
}
func (m *PodDisruptionBudgetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudgetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudgetSpec proto.InternalMessageInfo

func (m *PodDisruptionBudgetSpec) GetMinAvailable() uint32 {
	if m != nil {
		return m.MinAvailable
	}
	return 0
}

func (m *PodDisruptionBudgetSpec) GetSelector() *v11.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetMaxUnavailable() uint32 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

// Mirrors k8s.io.api.apps.v1.DeploymentStrategy for unmarshaling.
type DeploymentStrategy struct {
	Type                 string                   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	RollingUpdate        *RollingUpdateDeployment `protobuf:"bytes,2,opt,name=rollingUpdate,proto3" json:"rollingUpdate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *DeploymentStrategy) Reset()         { *m = DeploymentStrategy{} }
func (m *DeploymentStrategy) String() string { return proto.CompactTextString(m) }
func (*DeploymentStrategy) ProtoMessage()    {}
func (*DeploymentStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{30}
}

func (m *DeploymentStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeploymentStrategy.Unmarshal(m, b)
}
func (m *DeploymentStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeploymentStrategy.Marshal(b, m, deterministic)
}
func (m *DeploymentStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentStrategy.Merge(m, src)
}
func (m *DeploymentStrategy) XXX_Size() int {
	return xxx_messageInfo_DeploymentStrategy.Size(m)
}
func (m *DeploymentStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentStrategy proto.InternalMessageInfo

func (m *DeploymentStrategy) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeploymentStrategy) GetRollingUpdate() *RollingUpdateDeployment {
	if m != nil {
		return m.RollingUpdate
	}
	return nil
}

// Mirrors k8s.io.api.apps.v1.RollingUpdateDeployment for unmarshaling.
type RollingUpdateDeployment struct {
	MaxUnavailable       *IntOrStringForPB `protobuf:"bytes,1,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	MaxSurge             *IntOrStringForPB `protobuf:"bytes,2,opt,name=maxSurge,proto3" json:"maxSurge,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RollingUpdateDeployment) Reset()         { *m = RollingUpdateDeployment{} }
func (m *RollingUpdateDeployment) String() string { return proto.CompactTextString(m) }
func (*RollingUpdateDeployment) ProtoMessage()    {}
func (*RollingUpdateDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{31}
}

func (m *RollingUpdateDeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollingUpdateDeployment.Unmarshal(m, b)
}
func (m *RollingUpdateDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollingUpdateDeployment.Marshal(b, m, deterministic)
}
func (m *RollingUpdateDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollingUpdateDeployment.Merge(m, src)
}
func (m *RollingUpdateDeployment) XXX_Size() int {
	return xxx_messageInfo_RollingUpdateDeployment.Size(m)
}
func (m *RollingUpdateDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_RollingUpdateDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_RollingUpdateDeployment proto.InternalMessageInfo

func (m *RollingUpdateDeployment) GetMaxUnavailable() *IntOrStringForPB {
	if m != nil {
		return m.MaxUnavailable
	}
	return nil
}

func (m *RollingUpdateDeployment) GetMaxSurge() *IntOrStringForPB {
	if m != nil {
		return m.MaxSurge
	}
	return nil
}

type ObjectMeta struct {
	// From k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	Namespace            string   `protobuf:"bytes,6,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectMeta) Reset()         { *m = ObjectMeta{} }
func (m *ObjectMeta) String() string { return proto.CompactTextString(m) }
func (*ObjectMeta) ProtoMessage()    {}
func (*ObjectMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{32}
}

func (m *ObjectMeta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectMeta.Unmarshal(m, b)
}
func (m *ObjectMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectMeta.Marshal(b, m, deterministic)
}
func (m *ObjectMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMeta.Merge(m, src)
}
func (m *ObjectMeta) XXX_Size() int {
	return xxx_messageInfo_ObjectMeta.Size(m)
}
func (m *ObjectMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMeta.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMeta proto.InternalMessageInfo

func (m *ObjectMeta) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ObjectMeta) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}




func init() {
	proto.RegisterEnum("v1alpha2.InstallStatus_Status", InstallStatus_Status_name, InstallStatus_Status_value)
	proto.RegisterType((*IstioControlPlane)(nil), "v1alpha2.IstioControlPlane")
	proto.RegisterType((*IstioControlPlaneSpec)(nil), "v1alpha2.IstioControlPlaneSpec")
	proto.RegisterType((*TrafficManagementFeatureSpec)(nil), "v1alpha2.TrafficManagementFeatureSpec")
	proto.RegisterType((*TrafficManagementFeatureSpec_Components)(nil), "v1alpha2.TrafficManagementFeatureSpec.Components")
	proto.RegisterType((*PolicyFeatureSpec)(nil), "v1alpha2.PolicyFeatureSpec")
	proto.RegisterType((*PolicyFeatureSpec_Components)(nil), "v1alpha2.PolicyFeatureSpec.Components")
	proto.RegisterType((*TelemetryFeatureSpec)(nil), "v1alpha2.TelemetryFeatureSpec")
	proto.RegisterType((*TelemetryFeatureSpec_Components)(nil), "v1alpha2.TelemetryFeatureSpec.Components")
	proto.RegisterType((*SecurityFeatureSpec)(nil), "v1alpha2.SecurityFeatureSpec")
	proto.RegisterType((*SecurityFeatureSpec_Components)(nil), "v1alpha2.SecurityFeatureSpec.Components")
	proto.RegisterType((*ConfigManagementFeatureSpec)(nil), "v1alpha2.ConfigManagementFeatureSpec")
	proto.RegisterType((*ConfigManagementFeatureSpec_Components)(nil), "v1alpha2.ConfigManagementFeatureSpec.Components")
	proto.RegisterType((*AutoInjectionFeatureSpec)(nil), "v1alpha2.AutoInjectionFeatureSpec")
	proto.RegisterType((*AutoInjectionFeatureSpec_Components)(nil), "v1alpha2.AutoInjectionFeatureSpec.Components")
	proto.RegisterType((*GatewayFeatureSpec)(nil), "v1alpha2.GatewayFeatureSpec")
	proto.RegisterType((*GatewayFeatureSpec_Components)(nil), "v1alpha2.GatewayFeatureSpec.Components")
	proto.RegisterType((*PilotComponentSpec)(nil), "v1alpha2.PilotComponentSpec")
	proto.RegisterType((*ProxyComponentSpec)(nil), "v1alpha2.ProxyComponentSpec")
	proto.RegisterType((*SidecarInjectorComponentSpec)(nil), "v1alpha2.SidecarInjectorComponentSpec")
	proto.RegisterType((*PolicyComponentSpec)(nil), "v1alpha2.PolicyComponentSpec")
	proto.RegisterType((*TelemetryComponentSpec)(nil), "v1alpha2.TelemetryComponentSpec")
	proto.RegisterType((*CitadelComponentSpec)(nil), "v1alpha2.CitadelComponentSpec")
	proto.RegisterType((*CertManagerComponentSpec)(nil), "v1alpha2.CertManagerComponentSpec")
	proto.RegisterType((*NodeAgentComponentSpec)(nil), "v1alpha2.NodeAgentComponentSpec")
	proto.RegisterType((*GalleyComponentSpec)(nil), "v1alpha2.GalleyComponentSpec")
	proto.RegisterType((*IngressGatewayComponentSpec)(nil), "v1alpha2.IngressGatewayComponentSpec")
	proto.RegisterType((*EgressGatewayComponentSpec)(nil), "v1alpha2.EgressGatewayComponentSpec")
	proto.RegisterType((*KubernetesResourcesSpec)(nil), "v1alpha2.KubernetesResourcesSpec")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.KubernetesResourcesSpec.NodeSelectorEntry")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.KubernetesResourcesSpec.PodAnnotationsEntry")
	proto.RegisterType((*K8SObjectOverlay)(nil), "v1alpha2.k8sObjectOverlay")
	proto.RegisterType((*K8SObjectOverlay_PathValue)(nil), "v1alpha2.k8sObjectOverlay.PathValue")
	proto.RegisterType((*InstallStatus)(nil), "v1alpha2.InstallStatus")
	proto.RegisterType((*InstallStatus_VersionStatus)(nil), "v1alpha2.InstallStatus.VersionStatus")
	proto.RegisterType((*Resources)(nil), "v1alpha2.Resources")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.Resources.LimitsEntry")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.Resources.RequestsEntry")
	proto.RegisterType((*ReadinessProbe)(nil), "v1alpha2.ReadinessProbe")
	proto.RegisterType((*ExecAction)(nil), "v1alpha2.ExecAction")
	proto.RegisterType((*HTTPGetAction)(nil), "v1alpha2.HTTPGetAction")
	proto.RegisterType((*HTTPHeader)(nil), "v1alpha2.HTTPHeader")
	proto.RegisterType((*TCPSocketAction)(nil), "v1alpha2.TCPSocketAction")
	proto.RegisterType((*PodDisruptionBudgetSpec)(nil), "v1alpha2.PodDisruptionBudgetSpec")
	proto.RegisterType((*DeploymentStrategy)(nil), "v1alpha2.DeploymentStrategy")
	proto.RegisterType((*RollingUpdateDeployment)(nil), "v1alpha2.RollingUpdateDeployment")
	proto.RegisterType((*ObjectMeta)(nil), "v1alpha2.ObjectMeta")
}

func init() {
	proto.RegisterFile("pkg/apis/istio/v1alpha2/istiocontrolplane_types.proto", fileDescriptor_daac92937abd81a4)
}

var fileDescriptor_daac92937abd81a4 = []byte{
	// 2401 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x4f, 0x73, 0xdc, 0x48,
	0x15, 0x47, 0x63, 0x7b, 0x3c, 0x7e, 0xf6, 0xf8, 0x4f, 0xdb, 0x49, 0xb4, 0x8e, 0x37, 0xf1, 0x8a,
	0x6c, 0x08, 0x0b, 0x3b, 0x8e, 0xed, 0x4d, 0xd6, 0xd9, 0x85, 0xec, 0x3a, 0x8e, 0x63, 0xbb, 0x36,
	0xb1, 0x07, 0xd9, 0x49, 0xb1, 0x17, 0xa6, 0x7a, 0xa4, 0xf6, 0x8c, 0xd6, 0x1a, 0xb5, 0xb6, 0xd5,
	0x9a, 0xcd, 0x70, 0x85, 0x03, 0x9c, 0xa8, 0xe2, 0xcc, 0x42, 0x51, 0x14, 0xf0, 0x0d, 0xb8, 0xc0,
	0x9d, 0x2f, 0xc0, 0x95, 0x4f, 0x00, 0x47, 0x6e, 0x54, 0x51, 0x54, 0xb7, 0x5a, 0xff, 0x66, 0x34,
	0x8e, 0xc7, 0xc5, 0xc1, 0xdc, 0xa4, 0xf7, 0x7e, 0xef, 0xe9, 0xf5, 0xeb, 0x7e, 0x7f, 0xfa, 0x09,
	0x1e, 0xf8, 0x67, 0xad, 0x35, 0xec, 0x3b, 0xc1, 0x9a, 0x13, 0x70, 0x87, 0xae, 0x75, 0xd7, 0xb1,
	0xeb, 0xb7, 0xf1, 0x46, 0xf4, 0x6a, 0x51, 0x8f, 0x33, 0xea, 0xfa, 0x2e, 0xf6, 0x48, 0x83, 0xf7,
	0x7c, 0x12, 0xd4, 0x7c, 0x46, 0x39, 0x45, 0x95, 0x18, 0xb7, 0x6c, 0x9c, 0x6d, 0x05, 0x35, 0x87,
	0x0a, 0x1d, 0x6b, 0x16, 0x65, 0x64, 0xad, 0xbb, 0xbe, 0xd6, 0x22, 0x1e, 0x61, 0x98, 0x13, 0x3b,
	0x42, 0xe7, 0x30, 0xd8, 0xf7, 0x83, 0x22, 0x4c, 0x2d, 0x8b, 0x09, 0x39, 0x0d, 0x2c, 0xec, 0x3a,
	0x5e, 0x6b, 0xad, 0xbb, 0xd1, 0x24, 0x1c, 0x0f, 0xe2, 0x3f, 0x48, 0xf1, 0x1d, 0x6c, 0xb5, 0x1d,
	0x8f, 0xb0, 0xde, 0x5a, 0xb2, 0x98, 0x0e, 0xe1, 0xb8, 0xe8, 0x2b, 0x9f, 0xb6, 0x1c, 0xde, 0x0e,
	0x9b, 0x35, 0x8b, 0x76, 0xd6, 0x5a, 0xb4, 0x45, 0xd7, 0x24, 0xb9, 0x19, 0x9e, 0xa6, 0x0f, 0x2d,
	0x4a, 0x5b, 0x2e, 0x49, 0xdf, 0xbf, 0x62, 0xd8, 0xf7, 0x09, 0x53, 0x2b, 0x37, 0x7a, 0xb0, 0x70,
	0x20, 0x5c, 0xb3, 0x13, 0xb9, 0xa6, 0x2e, 0x5c, 0x83, 0x36, 0x61, 0x3c, 0xf0, 0x89, 0xa5, 0x8f,
	0xad, 0x6a, 0xf7, 0xa6, 0x37, 0x6e, 0xd7, 0x62, 0xef, 0xd4, 0x06, 0xa0, 0xc7, 0x3e, 0xb1, 0x4c,
	0x09, 0x46, 0x6b, 0x50, 0x0e, 0x38, 0xe6, 0x61, 0xa0, 0x8f, 0x4b, 0xb1, 0x1b, 0x19, 0x31, 0x2f,
	0xe0, 0xd8, 0x75, 0x8f, 0x25, 0xdb, 0x54, 0x30, 0xe3, 0x57, 0x65, 0xb8, 0x56, 0xa8, 0x10, 0x7d,
	0x07, 0x16, 0x6c, 0x72, 0x8a, 0x43, 0x97, 0x37, 0x3c, 0xdc, 0x21, 0x81, 0x8f, 0x2d, 0xa2, 0x4f,
	0xac, 0x6a, 0xf7, 0xa6, 0xcc, 0x79, 0xc5, 0x38, 0x8c, 0xe9, 0xe8, 0x25, 0x20, 0xce, 0xf0, 0xe9,
	0xa9, 0x63, 0x35, 0x3a, 0xd8, 0xc3, 0x2d, 0xd2, 0x21, 0x1e, 0xd7, 0xdf, 0x92, 0x36, 0xdc, 0x4d,
	0x6d, 0x38, 0x89, 0x30, 0x2f, 0x12, 0xc8, 0x33, 0x82, 0x79, 0xc8, 0xa2, 0x15, 0x2c, 0xf0, 0x7e,
	0x2e, 0xda, 0x84, 0xb2, 0x4f, 0x5d, 0xc7, 0xea, 0xe9, 0xcb, 0x52, 0xd5, 0xcd, 0x54, 0x55, 0x5d,
	0xd2, 0xb3, 0xf2, 0x0a, 0x8a, 0xbe, 0x07, 0x53, 0x9c, 0xb8, 0xa4, 0x43, 0x38, 0xeb, 0xe9, 0x37,
	0xa5, 0xdc, 0xad, 0x8c, 0x09, 0x31, 0x2b, 0x2b, 0x9a, 0x0a, 0xa0, 0x47, 0x50, 0x09, 0x88, 0x15,
	0x32, 0x87, 0xf7, 0xf4, 0x15, 0x29, 0xfc, 0x76, 0x2a, 0x7c, 0xac, 0x38, 0x59, 0xd9, 0x04, 0x8e,
	0x4c, 0x58, 0xb0, 0xa8, 0x77, 0xea, 0xb4, 0xb2, 0x3e, 0x78, 0x5b, 0xea, 0x78, 0x37, 0xd5, 0xb1,
	0x23, 0x21, 0xc5, 0x2e, 0x98, 0xb7, 0xfa, 0x98, 0xe8, 0x00, 0x66, 0xc5, 0xc9, 0x6d, 0x38, 0xde,
	0x17, 0xc4, 0xe2, 0x0e, 0xf5, 0xf4, 0x5b, 0x52, 0xa1, 0x91, 0x2a, 0xdc, 0x0e, 0x39, 0x3d, 0x88,
	0xd9, 0x59, 0x6d, 0x55, 0x9c, 0xe5, 0xa0, 0x2d, 0xa8, 0xb4, 0x30, 0x27, 0x5f, 0xe1, 0x5e, 0xa0,
	0xdf, 0x96, 0x4a, 0x56, 0x52, 0x25, 0x7b, 0x11, 0x27, 0xb7, 0xb0, 0x18, 0x8d, 0xb6, 0xa0, 0xdc,
	0xc5, 0x6e, 0x48, 0x02, 0x7d, 0x43, 0xca, 0xad, 0x66, 0xdc, 0xd9, 0xf3, 0xc9, 0x0b, 0xec, 0x1f,
	0x73, 0xe6, 0x78, 0xad, 0x03, 0x8f, 0x13, 0x76, 0x8a, 0x2d, 0x62, 0x2a, 0x3c, 0x3a, 0x84, 0x85,
	0xd0, 0xeb, 0x62, 0xd7, 0xb1, 0x45, 0xc0, 0xbc, 0x8a, 0x94, 0x6c, 0x5e, 0x50, 0xc9, 0xa0, 0x28,
	0xd2, 0x61, 0xd2, 0x67, 0xf4, 0xd4, 0x71, 0x89, 0x6e, 0xcb, 0xa3, 0x18, 0xbf, 0xa2, 0xfb, 0xb0,
	0xe4, 0x44, 0x27, 0xbc, 0xe1, 0x63, 0xeb, 0x0c, 0xb7, 0x48, 0xc3, 0xc7, 0xbc, 0xad, 0x9f, 0x4a,
	0x18, 0x52, 0xbc, 0x7a, 0xc4, 0xaa, 0x63, 0xde, 0x46, 0xf3, 0x30, 0xd6, 0x0e, 0x9b, 0xba, 0x27,
	0x01, 0xe2, 0x51, 0x50, 0x38, 0x6e, 0xe9, 0x34, 0xa2, 0x70, 0xdc, 0x32, 0xfe, 0x52, 0x82, 0x95,
	0xf3, 0x0e, 0x2d, 0xfa, 0x00, 0x26, 0x89, 0x87, 0x9b, 0x2e, 0xb1, 0x75, 0x4d, 0x2e, 0x6b, 0xb9,
	0x16, 0x05, 0x7b, 0x2d, 0x0e, 0xf6, 0xda, 0x13, 0x4a, 0x5d, 0x69, 0xbe, 0x19, 0x43, 0xd1, 0x0f,
	0x00, 0x2c, 0xda, 0xf1, 0xa9, 0x47, 0x3c, 0x1e, 0x3b, 0x75, 0xfd, 0x62, 0x61, 0x52, 0xdb, 0x49,
	0x04, 0xcd, 0x8c, 0x92, 0xe5, 0x5f, 0x6a, 0x00, 0x29, 0x0b, 0xad, 0xc0, 0x54, 0x1a, 0xb5, 0x9a,
	0x5c, 0x50, 0x4a, 0x40, 0x1b, 0x30, 0xe1, 0x3b, 0x2e, 0xe5, 0xfa, 0x52, 0xff, 0x39, 0xa8, 0x0b,
	0x72, 0xa2, 0x47, 0x9e, 0x83, 0x08, 0x2a, 0x65, 0x18, 0x7d, 0xdd, 0xd3, 0xaf, 0x0d, 0xc8, 0x08,
	0x72, 0xbf, 0x8c, 0xa0, 0x19, 0xff, 0xd2, 0x60, 0x61, 0x20, 0x50, 0x2f, 0xe9, 0xb3, 0x67, 0x05,
	0x3e, 0xbb, 0x7b, 0x4e, 0x3e, 0x18, 0xe6, 0x28, 0x3c, 0x82, 0x9f, 0x1e, 0x24, 0xf9, 0x67, 0xa9,
	0x3f, 0x15, 0x44, 0xdf, 0xcb, 0xaf, 0x5a, 0x81, 0x8d, 0x9f, 0x94, 0x60, 0xa9, 0x28, 0xcf, 0x5c,
	0x72, 0xe5, 0x07, 0x05, 0x2b, 0xff, 0xf6, 0xf9, 0x19, 0x6d, 0xd8, 0xe2, 0xbf, 0x18, 0x61, 0xf1,
	0x8f, 0xb3, 0x79, 0x74, 0x69, 0x20, 0x66, 0x63, 0x56, 0xde, 0x05, 0xa9, 0x88, 0xf1, 0xd3, 0x31,
	0x58, 0x2c, 0x48, 0x98, 0x97, 0x74, 0xc2, 0x7e, 0x81, 0x13, 0xee, 0x9d, 0x9b, 0x99, 0x87, 0xf9,
	0xe0, 0x9f, 0xa3, 0x44, 0xca, 0x16, 0x4c, 0x5a, 0x0e, 0xc7, 0x36, 0x71, 0x95, 0x0b, 0x32, 0xa5,
	0x64, 0x27, 0x62, 0xe4, 0x1d, 0x10, 0xc3, 0xd1, 0x2e, 0xcc, 0x58, 0x84, 0x71, 0x55, 0x0b, 0x98,
	0x0a, 0x9b, 0x4c, 0xde, 0xde, 0x21, 0x8c, 0x47, 0x21, 0xce, 0xf2, 0x2a, 0xa6, 0xad, 0x94, 0x83,
	0x3e, 0x01, 0xf0, 0xa8, 0x4d, 0x1a, 0xb8, 0x25, 0xaa, 0xc9, 0xf5, 0xfe, 0x6d, 0x38, 0xa4, 0x36,
	0xd9, 0x16, 0xac, 0xbe, 0x6d, 0xf0, 0x62, 0xba, 0xf1, 0xb3, 0x12, 0xdc, 0x3c, 0xa7, 0xe6, 0x5c,
	0x72, 0x3b, 0xea, 0x05, 0xdb, 0x71, 0xff, 0x42, 0x45, 0xee, 0x7f, 0x14, 0x97, 0x2d, 0xec, 0xba,
	0xa4, 0x20, 0x2e, 0xf7, 0x24, 0xbd, 0x2f, 0x2e, 0x23, 0xb0, 0xf1, 0x8b, 0x12, 0xe8, 0xc3, 0xaa,
	0xe5, 0x25, 0xfd, 0xf0, 0xa2, 0xc0, 0x0f, 0xef, 0xbf, 0xb9, 0x36, 0x0f, 0x73, 0x82, 0x37, 0x82,
	0x13, 0x9e, 0x40, 0x25, 0xea, 0x0a, 0x28, 0x53, 0x6e, 0xc8, 0xa4, 0xc3, 0x63, 0xc7, 0x26, 0x16,
	0x66, 0x07, 0x0a, 0x90, 0xf7, 0x47, 0x22, 0x67, 0xfc, 0xbd, 0x04, 0x68, 0xb0, 0xf4, 0x5f, 0xd2,
	0x17, 0x7b, 0x05, 0xbe, 0xf8, 0xd6, 0x79, 0x2d, 0xc6, 0x30, 0x2f, 0xfc, 0x75, 0x94, 0x08, 0x3d,
	0x84, 0x39, 0xc7, 0x6b, 0x31, 0x12, 0x04, 0x0d, 0xd5, 0xb0, 0xa8, 0xee, 0xe6, 0xdd, 0x6c, 0xef,
	0x2b, 0x01, 0xca, 0x82, 0xbc, 0x33, 0x66, 0x9d, 0x1c, 0x13, 0x7d, 0x06, 0xb3, 0x24, 0xaf, 0x6e,
	0x55, 0xaa, 0xbb, 0x93, 0xaa, 0xdb, 0x1d, 0xae, 0xad, 0x4a, 0xb2, 0x3c, 0xe3, 0x6b, 0x0d, 0xd0,
	0x60, 0x49, 0xbd, 0xa4, 0x7f, 0x73, 0x7e, 0x28, 0xf5, 0xfb, 0x61, 0x13, 0xc6, 0xce, 0xb6, 0x02,
	0xbd, 0x2e, 0xf5, 0xbd, 0x93, 0x1a, 0xfb, 0x59, 0xd8, 0x24, 0xcc, 0x23, 0x9c, 0x04, 0x26, 0x09,
	0x68, 0xc8, 0x2c, 0x12, 0x48, 0x4b, 0x05, 0x3a, 0xb2, 0x6f, 0xa0, 0x7c, 0x5f, 0x1d, 0xfb, 0xfe,
	0xa8, 0xc1, 0xca, 0x79, 0x47, 0xf9, 0xea, 0x58, 0xfa, 0x6b, 0x0d, 0x16, 0x0b, 0x7a, 0x82, 0xab,
	0x63, 0xe0, 0x6f, 0x35, 0xb8, 0x5e, 0x5c, 0xb4, 0xaf, 0x8e, 0x8d, 0xbf, 0xd1, 0x60, 0xa9, 0xa8,
	0xaa, 0x5e, 0x1d, 0x0b, 0x7f, 0xa7, 0x81, 0x3e, 0xac, 0x70, 0x5f, 0xad, 0xbd, 0x2e, 0xee, 0x0c,
	0xae, 0x56, 0xc0, 0x14, 0x14, 0xeb, 0xab, 0x63, 0xe0, 0x1f, 0x34, 0xb8, 0x79, 0x4e, 0xe1, 0xb8,
	0x3a, 0x86, 0xfe, 0x5e, 0x83, 0xe5, 0xdd, 0xff, 0x03, 0x3b, 0xff, 0x56, 0x81, 0x1b, 0x43, 0x00,
	0x68, 0x0b, 0x2a, 0xe2, 0xce, 0xeb, 0x39, 0xbc, 0xa7, 0xac, 0x5c, 0x51, 0xd3, 0xbb, 0x1a, 0xf6,
	0x9d, 0x9a, 0x45, 0x19, 0xa9, 0x75, 0xd7, 0x6b, 0xdb, 0x0a, 0x63, 0x26, 0x68, 0xf4, 0x5d, 0x18,
	0x23, 0x5e, 0x57, 0x2f, 0xad, 0x8e, 0xc9, 0xa5, 0x15, 0x08, 0xed, 0x7a, 0xdd, 0x57, 0x98, 0x99,
	0x02, 0x86, 0x5e, 0x41, 0xa5, 0xed, 0xe3, 0x46, 0x66, 0xb2, 0xf6, 0x71, 0x56, 0x24, 0x33, 0x25,
	0xac, 0xa9, 0x29, 0x61, 0x6d, 0x9f, 0x32, 0xe7, 0xc7, 0xd4, 0xe3, 0xd8, 0xad, 0x53, 0x7b, 0x5b,
	0x01, 0x08, 0x8b, 0xba, 0xfd, 0xb6, 0x8f, 0xa5, 0xfd, 0xef, 0xc1, 0x82, 0xd3, 0x91, 0x43, 0x87,
	0xd0, 0x75, 0x1b, 0xea, 0xd2, 0x38, 0x2e, 0xdd, 0x36, 0x27, 0x19, 0xf5, 0xd0, 0x75, 0xa3, 0xfa,
	0x80, 0x7e, 0x08, 0x55, 0xd9, 0xd2, 0x07, 0xc4, 0x8d, 0xba, 0xb7, 0x09, 0x69, 0xfb, 0xe6, 0x1b,
	0xdd, 0x28, 0xbb, 0xfd, 0x63, 0x25, 0xb5, 0xeb, 0x71, 0xd6, 0x33, 0x67, 0xbc, 0x0c, 0x09, 0xbd,
	0x84, 0x6b, 0x3e, 0xb5, 0x1b, 0xb6, 0x13, 0xb0, 0xd0, 0x17, 0x2d, 0x67, 0xa3, 0x19, 0xda, 0x2d,
	0xc2, 0xf5, 0x72, 0xff, 0x46, 0xd5, 0xa9, 0xfd, 0x34, 0x41, 0x3d, 0x91, 0x20, 0xb9, 0xa0, 0x45,
	0x7f, 0x90, 0x81, 0x7e, 0x04, 0x73, 0x42, 0x2d, 0xf6, 0x3c, 0xca, 0xb1, 0xa0, 0x07, 0xfa, 0xa4,
	0x34, 0xf9, 0xc1, 0x9b, 0x4d, 0x16, 0x3e, 0x4b, 0xe5, 0x22, 0xa3, 0x67, 0xfd, 0x1c, 0x11, 0xd5,
	0x60, 0xd1, 0x67, 0x0e, 0x15, 0xf7, 0xb7, 0x86, 0xe5, 0xe2, 0x20, 0x90, 0x13, 0x47, 0xbd, 0x22,
	0xdd, 0xb7, 0x10, 0xb3, 0x76, 0x04, 0xe7, 0x10, 0x77, 0x08, 0xda, 0x86, 0x39, 0x46, 0xb0, 0xed,
	0x78, 0xa2, 0x4b, 0xf3, 0x19, 0x6d, 0x12, 0x7d, 0x4a, 0x2e, 0x50, 0x4f, 0xed, 0x31, 0x63, 0x40,
	0x5d, 0xf0, 0xcd, 0x59, 0x96, 0x7b, 0x47, 0xdf, 0x84, 0x2a, 0x23, 0xbe, 0xeb, 0x58, 0xb8, 0x61,
	0xd1, 0xd0, 0xe3, 0x3a, 0xac, 0x6a, 0xf7, 0xaa, 0xe6, 0x8c, 0x22, 0xee, 0x08, 0x1a, 0x5a, 0x87,
	0x29, 0x16, 0x2f, 0x46, 0x9f, 0x96, 0x5f, 0x58, 0xcc, 0x7e, 0x41, 0xb1, 0xcc, 0x14, 0x85, 0x1e,
	0xc1, 0x64, 0x40, 0x58, 0xd7, 0xb1, 0x88, 0x3e, 0xa3, 0x06, 0xb7, 0x05, 0x27, 0xf2, 0x38, 0x82,
	0x44, 0x47, 0x48, 0xe1, 0x45, 0x08, 0x04, 0x9c, 0x61, 0x4e, 0x5a, 0x3d, 0xbd, 0xda, 0x3f, 0x63,
	0x79, 0x4a, 0x7c, 0x97, 0xf6, 0xc4, 0x55, 0xea, 0x58, 0x61, 0xcc, 0x04, 0x8d, 0x3e, 0x85, 0x69,
	0x4e, 0x5d, 0xc2, 0xd4, 0xde, 0xcc, 0xca, 0xbd, 0xb9, 0x55, 0xf4, 0xe1, 0x93, 0x04, 0x66, 0x66,
	0x45, 0xd0, 0x43, 0xa8, 0xd0, 0x2e, 0x61, 0x2e, 0xee, 0x05, 0xba, 0xad, 0x22, 0x29, 0xf9, 0xf6,
	0xd9, 0x56, 0x70, 0xd4, 0x14, 0xcd, 0xd7, 0x51, 0x04, 0x31, 0x13, 0xec, 0xf2, 0x27, 0xb0, 0x30,
	0x70, 0x26, 0xd1, 0x3c, 0x8c, 0x9d, 0x91, 0x9e, 0xea, 0xd4, 0xc5, 0x23, 0x5a, 0x82, 0x09, 0x39,
	0x10, 0x54, 0x89, 0x24, 0x7a, 0xf9, 0xa8, 0xb4, 0xa5, 0x2d, 0x6f, 0x8b, 0xae, 0x69, 0xe0, 0x84,
	0x8c, 0xa2, 0xc2, 0xf8, 0x87, 0x06, 0xf3, 0xfd, 0x26, 0xa2, 0xdb, 0x30, 0x8d, 0x7d, 0xa7, 0xd1,
	0x25, 0x2c, 0x70, 0xa8, 0xa7, 0x14, 0x01, 0xf6, 0x9d, 0x57, 0x11, 0x05, 0x21, 0x18, 0x3f, 0x73,
	0x3c, 0x5b, 0xa9, 0x93, 0xcf, 0x82, 0x26, 0x0f, 0xde, 0x58, 0x44, 0x13, 0xcf, 0xe8, 0x31, 0x4c,
	0xfa, 0x98, 0x5b, 0x6d, 0x12, 0xe8, 0xe3, 0xd2, 0x31, 0x77, 0x86, 0x3b, 0xa6, 0x56, 0xc7, 0xbc,
	0xad, 0xf2, 0xa8, 0x12, 0x5a, 0x3e, 0x84, 0xa9, 0x84, 0x2a, 0x3e, 0x20, 0x87, 0x92, 0x91, 0x39,
	0xf2, 0x19, 0xbd, 0x9f, 0x5d, 0x58, 0x6e, 0x62, 0x7f, 0xd2, 0xf3, 0x49, 0x3a, 0x0d, 0x8d, 0x50,
	0xc6, 0xcf, 0x27, 0xa0, 0x9a, 0x1b, 0xe5, 0xa3, 0x93, 0xc2, 0xd9, 0xbb, 0x36, 0x78, 0x07, 0xca,
	0x08, 0xd5, 0x94, 0x1b, 0xd4, 0xdf, 0x80, 0x82, 0xd1, 0x7b, 0x1d, 0xe6, 0xa3, 0x2c, 0xd6, 0x48,
	0x87, 0x40, 0xa5, 0x51, 0x74, 0xce, 0x45, 0xe2, 0x49, 0xcb, 0x89, 0xb6, 0x33, 0x93, 0xf5, 0xb1,
	0x51, 0x34, 0xbd, 0x61, 0xc2, 0x3e, 0x3e, 0x8a, 0xae, 0xc1, 0x09, 0x7b, 0xc1, 0xfd, 0x31, 0xca,
	0xc7, 0x17, 0xd4, 0xd8, 0x7f, 0x7f, 0x7c, 0x3e, 0x70, 0x7f, 0x2c, 0x8f, 0xa2, 0x2e, 0x7f, 0x81,
	0x5c, 0xc6, 0x50, 0xcd, 0xf1, 0x91, 0x0e, 0x93, 0xf9, 0x43, 0x1d, 0xbf, 0xa2, 0x87, 0xc9, 0xbf,
	0x1f, 0xb1, 0x4f, 0xb3, 0xd9, 0x49, 0x55, 0xfe, 0x83, 0x7d, 0xbf, 0x80, 0xb6, 0xa0, 0xac, 0x74,
	0x57, 0x60, 0xfc, 0xf0, 0xe8, 0x70, 0x77, 0xfe, 0x1b, 0x68, 0x06, 0x2a, 0x2f, 0xeb, 0x4f, 0xb7,
	0x4f, 0x0e, 0x0e, 0xf7, 0xe6, 0x35, 0x34, 0x0d, 0x93, 0xfb, 0xbb, 0xdb, 0xcf, 0x4f, 0xf6, 0x3f,
	0x9f, 0x2f, 0xa1, 0x29, 0x98, 0xd8, 0x35, 0xcd, 0x23, 0x73, 0x7e, 0xcc, 0xf8, 0xb7, 0x06, 0x53,
	0x49, 0x16, 0x44, 0x1f, 0x42, 0xd9, 0x75, 0x3a, 0x0e, 0x0f, 0x74, 0x4d, 0x2e, 0xf8, 0x76, 0x41,
	0xaa, 0xac, 0x3d, 0x97, 0x88, 0xa8, 0x0c, 0x28, 0x38, 0xfa, 0x3e, 0x54, 0x18, 0xf9, 0x32, 0x24,
	0x01, 0x0f, 0x54, 0x19, 0x7f, 0xa7, 0x48, 0xd4, 0x54, 0x98, 0x48, 0x38, 0x11, 0x59, 0x7e, 0x04,
	0xd3, 0x19, 0xad, 0x23, 0x65, 0x9f, 0x8f, 0xa1, 0x9a, 0xd3, 0x3a, 0x52, 0xde, 0xf9, 0x4f, 0x09,
	0x66, 0xf3, 0x55, 0x06, 0xdd, 0x83, 0x71, 0xf2, 0x9a, 0x58, 0x2a, 0xf8, 0x96, 0x32, 0x13, 0x83,
	0xd7, 0xc4, 0xda, 0x96, 0x43, 0x20, 0x53, 0x22, 0xd0, 0x3a, 0x4c, 0xb6, 0x39, 0xf7, 0xf7, 0x08,
	0x1f, 0x8c, 0xfb, 0xfd, 0x93, 0x93, 0xfa, 0x1e, 0xe1, 0x0a, 0x1f, 0xe3, 0xd0, 0x87, 0x30, 0xc5,
	0x2d, 0xff, 0x98, 0x5a, 0x67, 0x84, 0xab, 0x00, 0x7a, 0x2b, 0x93, 0x2c, 0x76, 0xea, 0x11, 0x4b,
	0x89, 0xa5, 0x58, 0x74, 0x1f, 0x16, 0x45, 0xab, 0xe4, 0x60, 0xf7, 0x29, 0x71, 0x71, 0xef, 0x98,
	0x58, 0xd4, 0xb3, 0xa3, 0x3f, 0x84, 0x13, 0x66, 0x11, 0x0b, 0xdd, 0x85, 0x59, 0xee, 0x74, 0x08,
	0x0d, 0x79, 0x0c, 0x9e, 0x90, 0xe0, 0x3e, 0x2a, 0xba, 0x03, 0x55, 0x9f, 0x30, 0x87, 0xda, 0x31,
	0xac, 0x2c, 0x61, 0x79, 0x22, 0x7a, 0x0f, 0xe6, 0x83, 0xd0, 0xb2, 0x48, 0x10, 0x9c, 0xb4, 0x19,
	0x09, 0xda, 0xd4, 0xb5, 0xf5, 0x49, 0x09, 0x1c, 0xa0, 0x0b, 0xec, 0x29, 0x76, 0xdc, 0x90, 0x91,
	0x14, 0x5b, 0x89, 0xb0, 0xfd, 0x74, 0xe3, 0x2e, 0x40, 0xea, 0x57, 0x11, 0x18, 0x16, 0xed, 0x74,
	0xb0, 0x67, 0xcb, 0xf3, 0x37, 0x65, 0xc6, 0xaf, 0xc6, 0x9f, 0x35, 0xa8, 0xe6, 0x7c, 0x5a, 0x98,
	0x87, 0x37, 0x60, 0xdc, 0xa7, 0x2c, 0xde, 0x8e, 0x5b, 0x03, 0x69, 0xf8, 0x88, 0x45, 0xff, 0xa7,
	0x9e, 0x51, 0x56, 0x7f, 0x62, 0x4a, 0xac, 0xd0, 0xd3, 0xa6, 0x01, 0x8f, 0x0b, 0x86, 0x78, 0x46,
	0xd7, 0xa1, 0x1c, 0x58, 0x6d, 0xd2, 0x21, 0xaa, 0xfd, 0x53, 0x6f, 0xe8, 0x21, 0x4c, 0x8b, 0x9d,
	0xdc, 0x27, 0xd8, 0x26, 0x2c, 0x50, 0x39, 0x66, 0x29, 0xbf, 0xeb, 0x11, 0xd3, 0xcc, 0x02, 0x8d,
	0x87, 0x00, 0x29, 0x2b, 0x29, 0x51, 0x5a, 0xa6, 0x44, 0x15, 0x1e, 0x51, 0xe3, 0x73, 0x98, 0xeb,
	0x3b, 0x13, 0xc9, 0x12, 0xb5, 0x4b, 0x2c, 0xb1, 0x94, 0x2e, 0xd1, 0xf8, 0x93, 0x06, 0x37, 0x86,
	0x34, 0x90, 0xc8, 0x80, 0x99, 0x8e, 0xe3, 0x6d, 0x77, 0xb1, 0xe3, 0x8a, 0x8b, 0x84, 0xfc, 0x56,
	0xd5, 0xcc, 0xd1, 0xd0, 0x91, 0xa8, 0x04, 0xaa, 0xf7, 0x8d, 0xdc, 0xbd, 0x99, 0x69, 0x56, 0x92,
	0x5f, 0xef, 0x35, 0xff, 0xac, 0x25, 0x08, 0x41, 0xad, 0x43, 0x38, 0x16, 0xed, 0xcb, 0x73, 0xdc,
	0x24, 0x6e, 0xdc, 0x6c, 0x98, 0x89, 0x12, 0x71, 0x5e, 0x3b, 0xf8, 0xf5, 0x4b, 0x0f, 0x27, 0x9f,
	0x1d, 0x93, 0x9f, 0xed, 0xa3, 0x1a, 0x5f, 0x02, 0x1a, 0x6c, 0xa4, 0xc4, 0x12, 0x79, 0xcf, 0x4f,
	0x7c, 0x2a, 0x9e, 0xd1, 0x1e, 0x54, 0x19, 0x75, 0xc5, 0x3d, 0xe0, 0xa5, 0x6f, 0x63, 0x1e, 0x57,
	0xe7, 0x6c, 0x62, 0xca, 0xb2, 0x53, 0xad, 0x66, 0x5e, 0xce, 0xf8, 0x5a, 0x83, 0x1b, 0x43, 0xa0,
	0xe8, 0xd9, 0x80, 0xd9, 0x17, 0xdb, 0x99, 0x3e, 0x29, 0xf4, 0x11, 0x54, 0x3a, 0xf8, 0xf5, 0x71,
	0xc8, 0x5a, 0xe4, 0x82, 0xc7, 0x37, 0xc1, 0x1b, 0x8f, 0x01, 0xa2, 0x1e, 0xe6, 0x05, 0xe1, 0x38,
	0x39, 0x5e, 0x13, 0x99, 0xe3, 0x95, 0xbb, 0x09, 0x96, 0xfb, 0x6e, 0x82, 0x86, 0x0e, 0xd7, 0x8b,
	0x7f, 0xdf, 0x1a, 0x73, 0x50, 0xcd, 0x75, 0x30, 0xc6, 0x75, 0x58, 0x2a, 0x32, 0xa6, 0x59, 0x96,
	0xf7, 0xd0, 0xcd, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x38, 0x8c, 0x09, 0xca, 0x38, 0x22, 0x00,
	0x00,
}