// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/gateway.proto

// `Gateway` describes a load balancer operating at the edge of the mesh
// receiving incoming or outgoing HTTP/TCP connections. The specification
// describes a set of ports that should be exposed, the type of protocol to
// use, SNI configuration for the load balancer, etc.
//
// For example, the following Gateway configuration sets up a proxy to act
// as a load balancer exposing port 80 and 9080 (http), 443 (https),
// 9443(https) and port 2379 (TCP) for ingress.  The gateway will be
// applied to the proxy running on a pod with labels `app:
// my-gateway-controller`. While Istio will configure the proxy to listen
// on these ports, it is the responsibility of the user to ensure that
// external traffic to these ports are allowed into the mesh.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       httpsRedirect: true # sends 301 redirect for http requests
//   - port:
//       number: 443
//       name: https-443
//       protocol: HTTPS
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       serverCertificate: /etc/certs/servercert.pem
//       privateKey: /etc/certs/privatekey.pem
//   - port:
//       number: 9443
//       name: https-9443
//       protocol: HTTPS
//     hosts:
//     - "bookinfo-namespace/*.bookinfo.com"
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       credentialName: bookinfo-secret # fetches certs from Kubernetes secret
//   - port:
//       number: 9080
//       name: http-wildcard
//       protocol: HTTP
//     hosts:
//     - "*"
//   - port:
//       number: 2379 # to expose internal service via external port 2379
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
//
// The Gateway specification above describes the L4-L6 properties of a load
// balancer. A `VirtualService` can then be bound to a gateway to control
// the forwarding of traffic arriving at a particular host or gateway port.
//
// For example, the following VirtualService splits traffic for
// `https://uk.bookinfo.com/reviews`, `https://eu.bookinfo.com/reviews`,
// `http://uk.bookinfo.com:9080/reviews`,
// `http://eu.bookinfo.com:9080/reviews` into two versions (prod and qa) of
// an internal reviews service on port 9080. In addition, requests
// containing the cookie "user: dev-123" will be sent to special port 7777
// in the qa version. The same rule is also applicable inside the mesh for
// requests to the "reviews.prod.svc.cluster.local" service. This rule is
// applicable across ports 443, 9080. Note that `http://uk.bookinfo.com`
// gets redirected to `https://uk.bookinfo.com` (i.e. 80 redirects to 443).
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-rule
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   - uk.bookinfo.com
//   - eu.bookinfo.com
//   gateways:
//   - some-config-namespace/my-gateway
//   - mesh # applies to all the sidecars in the mesh
//   http:
//   - match:
//     - headers:
//         cookie:
//           exact: "user=dev-123"
//     route:
//     - destination:
//         port:
//           number: 7777
//         host: reviews.qa.svc.cluster.local
//   - match:
//     - uri:
//         prefix: /reviews/
//     route:
//     - destination:
//         port:
//           number: 9080 # can be omitted if it's the only port for reviews
//         host: reviews.prod.svc.cluster.local
//       weight: 80
//     - destination:
//         host: reviews.qa.svc.cluster.local
//       weight: 20
// ```
//
// The following VirtualService forwards traffic arriving at (external)
// port 27017 to internal Mongo server on port 5555. This rule is not
// applicable internally in the mesh as the gateway list omits the
// reserved name `mesh`.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-Mongo
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - mongosvr.prod.svc.cluster.local # name of internal Mongo service
//   gateways:
//   - some-config-namespace/my-gateway # can omit the namespace if gateway is in same
//                                        namespace as virtual service.
//   tcp:
//   - match:
//     - port: 27017
//     route:
//     - destination:
//         host: mongo.prod.svc.cluster.local
//         port:
//           number: 5555
// ```
//
// It is possible to restrict the set of virtual services that can bind to
// a gateway server using the namespace/hostname syntax in the hosts field.
// For example, the following Gateway allows any virtual service in the ns1
// namespace to bind to it, while restricting only the virtual service with
// foo.bar.com host in the ns2 namespace to bind to it.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - "ns1/*"
//     - "ns2/foo.bar.com"
// ```
//

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TLS modes enforced by the proxy
type Server_TLSOptions_TLSmode int32

const (
	// The SNI string presented by the client will be used as the match
	// criterion in a VirtualService TLS route to determine the
	// destination service from the service registry.
	Server_TLSOptions_PASSTHROUGH Server_TLSOptions_TLSmode = 0
	// Secure connections with standard TLS semantics.
	Server_TLSOptions_SIMPLE Server_TLSOptions_TLSmode = 1
	// Secure connections to the downstream using mutual TLS by presenting
	// server certificates for authentication.
	Server_TLSOptions_MUTUAL Server_TLSOptions_TLSmode = 2
	// Similar to the passthrough mode, except servers with this TLS mode
	// do not require an associated VirtualService to map from the SNI
	// value to service in the registry. The destination details such as
	// the service/subset/port are encoded in the SNI value. The proxy
	// will forward to the upstream (Envoy) cluster (a group of
	// endpoints) specified by the SNI value. This server is typically
	// used to provide connectivity between services in disparate L3
	// networks that otherwise do not have direct connectivity between
	// their respective endpoints. Use of this mode assumes that both the
	// source and the destination are using Istio mTLS to secure traffic.
	Server_TLSOptions_AUTO_PASSTHROUGH Server_TLSOptions_TLSmode = 3
	// Secure connections from the downstream using mutual TLS by presenting
	// server certificates for authentication.
	// Compared to Mutual mode, this mode uses certificates, representing
	// gateway workload identity, generated automatically by Istio for
	// mTLS authentication. When this mode is used, all other fields in
	// `TLSOptions` should be empty.
	Server_TLSOptions_ISTIO_MUTUAL Server_TLSOptions_TLSmode = 4
)

var Server_TLSOptions_TLSmode_name = map[int32]string{
	0: "PASSTHROUGH",
	1: "SIMPLE",
	2: "MUTUAL",
	3: "AUTO_PASSTHROUGH",
	4: "ISTIO_MUTUAL",
}

var Server_TLSOptions_TLSmode_value = map[string]int32{
	"PASSTHROUGH":      0,
	"SIMPLE":           1,
	"MUTUAL":           2,
	"AUTO_PASSTHROUGH": 3,
	"ISTIO_MUTUAL":     4,
}

func (x Server_TLSOptions_TLSmode) String() string {
	return proto.EnumName(Server_TLSOptions_TLSmode_name, int32(x))
}

func (Server_TLSOptions_TLSmode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{1, 0, 0}
}

// TLS protocol versions.
type Server_TLSOptions_TLSProtocol int32

const (
	// Automatically choose the optimal TLS version.
	Server_TLSOptions_TLS_AUTO Server_TLSOptions_TLSProtocol = 0
	// TLS version 1.0
	Server_TLSOptions_TLSV1_0 Server_TLSOptions_TLSProtocol = 1
	// TLS version 1.1
	Server_TLSOptions_TLSV1_1 Server_TLSOptions_TLSProtocol = 2
	// TLS version 1.2
	Server_TLSOptions_TLSV1_2 Server_TLSOptions_TLSProtocol = 3
	// TLS version 1.3
	Server_TLSOptions_TLSV1_3 Server_TLSOptions_TLSProtocol = 4
)

var Server_TLSOptions_TLSProtocol_name = map[int32]string{
	0: "TLS_AUTO",
	1: "TLSV1_0",
	2: "TLSV1_1",
	3: "TLSV1_2",
	4: "TLSV1_3",
}

var Server_TLSOptions_TLSProtocol_value = map[string]int32{
	"TLS_AUTO": 0,
	"TLSV1_0":  1,
	"TLSV1_1":  2,
	"TLSV1_2":  3,
	"TLSV1_3":  4,
}

func (x Server_TLSOptions_TLSProtocol) String() string {
	return proto.EnumName(Server_TLSOptions_TLSProtocol_name, int32(x))
}

func (Server_TLSOptions_TLSProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{1, 0, 1}
}

type Gateway struct {
	// REQUIRED: A list of server specifications.
	Servers []*Server `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// REQUIRED: One or more labels that indicate a specific set of pods/VMs
	// on which this gateway configuration should be applied. The scope of
	// label search is restricted to the configuration namespace in which the
	// the resource is present. In other words, the Gateway resource must
	// reside in the same namespace as the gateway workload instance.
	Selector             map[string]string `protobuf:"bytes,2,rep,name=selector,proto3" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Gateway) Reset()         { *m = Gateway{} }
func (m *Gateway) String() string { return proto.CompactTextString(m) }
func (*Gateway) ProtoMessage()    {}
func (*Gateway) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{0}
}
func (m *Gateway) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Gateway) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Gateway.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Gateway) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gateway.Merge(m, src)
}
func (m *Gateway) XXX_Size() int {
	return m.Size()
}
func (m *Gateway) XXX_DiscardUnknown() {
	xxx_messageInfo_Gateway.DiscardUnknown(m)
}

var xxx_messageInfo_Gateway proto.InternalMessageInfo

func (m *Gateway) GetServers() []*Server {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Gateway) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

// `Server` describes the properties of the proxy on a given load balancer
// port. For example,
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-ingress
// spec:
//   selector:
//     app: my-ingress-gateway
//   servers:
//   - port:
//       number: 80
//       name: http2
//       protocol: HTTP2
//     hosts:
//     - "*"
// ```
//
// Another example
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-tcp-ingress
// spec:
//   selector:
//     app: my-tcp-ingress-gateway
//   servers:
//   - port:
//       number: 27018
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
//
// The following is an example of TLS configuration for port 443
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-tls-ingress
// spec:
//   selector:
//     app: my-tls-ingress-gateway
//   servers:
//   - port:
//       number: 443
//       name: https
//       protocol: HTTPS
//     hosts:
//     - "*"
//     tls:
//       mode: SIMPLE
//       serverCertificate: /etc/certs/server.pem
//       privateKey: /etc/certs/privatekey.pem
// ```
type Server struct {
	// REQUIRED: The Port on which the proxy should listen for incoming
	// connections.
	Port *Port `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// $hide_from_docs
	// The ip or the Unix domain socket to which the listener should be bound
	// to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://@foobar`
	// (Linux abstract namespace). When using Unix domain sockets, the port
	// number should be 0.
	Bind string `protobuf:"bytes,4,opt,name=bind,proto3" json:"bind,omitempty"`
	// REQUIRED. One or more hosts exposed by this gateway.
	// While typically applicable to
	// HTTP services, it can also be used for TCP services using TLS with SNI.
	// A host is specified as a `dnsName` with an optional `namespace/` prefix.
	// The `dnsName` should be specified using FQDN format, optionally including
	// a wildcard character in the left-most component (e.g., `prod/*.example.com`).
	// Set the `dnsName` to `*` to select all `VirtualService` hosts from the
	// specified namespace (e.g.,`prod/*`).
	//
	// The `namespace` can be set to `*` or `.`, representing any or the current
	// namespace, respectively. For example, `*/foo.example.com` selects the
	// service from any available namespace while `./foo.example.com` only selects
	// the service from the namespace of the sidecar. The default, if no `namespace/`
	// is specified, is `*/`, that is, select services from any namespace.
	// Any associated `DestinationRule` in the selected namespace will also be used.
	//
	// A `VirtualService` must be bound to the gateway and must have one or
	// more hosts that match the hosts specified in a server. The match
	// could be an exact match or a suffix match with the server's hosts. For
	// example, if the server's hosts specifies `*.example.com`, a
	// `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
	// match. However, a `VirtualService` with host `example.com` or
	// `newexample.com` will not match.
	//
	// NOTE: Only virtual services exported to the gateway's namespace
	// (e.g., `exportTo` value of `*`) can be referenced.
	// Private configurations (e.g., `exportTo` set to `.`) will not be
	// available. Refer to the `exportTo` setting in `VirtualService`,
	// `DestinationRule`, and `ServiceEntry` configurations for details.
	Hosts []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Set of TLS related options that govern the server's behavior. Use
	// these options to control if all http requests should be redirected to
	// https, and the TLS modes to use.
	Tls *Server_TLSOptions `protobuf:"bytes,3,opt,name=tls,proto3" json:"tls,omitempty"`
	// The loopback IP endpoint or Unix domain socket to which traffic should
	// be forwarded to by default. Format should be `127.0.0.1:PORT` or
	// `unix:///path/to/socket` or `unix://@foobar` (Linux abstract namespace).
	DefaultEndpoint      string   `protobuf:"bytes,5,opt,name=default_endpoint,json=defaultEndpoint,proto3" json:"default_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Server) Reset()         { *m = Server{} }
func (m *Server) String() string { return proto.CompactTextString(m) }
func (*Server) ProtoMessage()    {}
func (*Server) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{1}
}
func (m *Server) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Server) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Server.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Server) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Server.Merge(m, src)
}
func (m *Server) XXX_Size() int {
	return m.Size()
}
func (m *Server) XXX_DiscardUnknown() {
	xxx_messageInfo_Server.DiscardUnknown(m)
}

var xxx_messageInfo_Server proto.InternalMessageInfo

func (m *Server) GetPort() *Port {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *Server) GetBind() string {
	if m != nil {
		return m.Bind
	}
	return ""
}

func (m *Server) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Server) GetTls() *Server_TLSOptions {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *Server) GetDefaultEndpoint() string {
	if m != nil {
		return m.DefaultEndpoint
	}
	return ""
}

type Server_TLSOptions struct {
	// If set to true, the load balancer will send a 301 redirect for all
	// http connections, asking the clients to use HTTPS.
	HttpsRedirect bool `protobuf:"varint,1,opt,name=https_redirect,json=httpsRedirect,proto3" json:"https_redirect,omitempty"`
	// Optional: Indicates whether connections to this port should be
	// secured using TLS. The value of this field determines how TLS is
	// enforced.
	Mode Server_TLSOptions_TLSmode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.networking.v1alpha3.Server_TLSOptions_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server-side TLS certificate to use.
	ServerCertificate string `protobuf:"bytes,3,opt,name=server_certificate,json=serverCertificate,proto3" json:"server_certificate,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server's private key.
	PrivateKey string `protobuf:"bytes,4,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to a file containing
	// certificate authority certificates to use in verifying a presented
	// client side certificate.
	CaCertificates string `protobuf:"bytes,5,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// The credentialName stands for a unique identifier that can be used
	// to identify the serverCertificate and the privateKey. The
	// credentialName appended with suffix "-cacert" is used to identify
	// the CaCertificates associated with this server. Gateway workloads
	// capable of fetching credentials from a remote credential store such
	// as Kubernetes secrets, will be configured to retrieve the
	// serverCertificate and the privateKey using credentialName, instead
	// of using the file system paths specified above. If using mutual TLS,
	// gateway workload instances will retrieve the CaCertificates using
	// credentialName-cacert. The semantics of the name are platform
	// dependent.  In Kubernetes, the default Istio supplied credential
	// server expects the credentialName to match the name of the
	// Kubernetes secret that holds the server certificate, the private
	// key, and the CA certificate (if using mutual TLS). Set the
	// `ISTIO_META_USER_SDS` metadata variable in the gateway's proxy to
	// enable the dynamic credential fetching feature.
	CredentialName string `protobuf:"bytes,10,opt,name=credential_name,json=credentialName,proto3" json:"credential_name,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate presented by the client.
	SubjectAltNames []string `protobuf:"bytes,6,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// An optional list of base64-encoded SHA-256 hashes of the SKPIs of
	// authorized client certificates.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateSpki []string `protobuf:"bytes,11,rep,name=verify_certificate_spki,json=verifyCertificateSpki,proto3" json:"verify_certificate_spki,omitempty"`
	// An optional list of hex-encoded SHA-256 hashes of the
	// authorized client certificates. Both simple and colon separated
	// formats are acceptable.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateHash []string `protobuf:"bytes,12,rep,name=verify_certificate_hash,json=verifyCertificateHash,proto3" json:"verify_certificate_hash,omitempty"`
	// Optional: Minimum TLS protocol version.
	MinProtocolVersion Server_TLSOptions_TLSProtocol `protobuf:"varint,7,opt,name=min_protocol_version,json=minProtocolVersion,proto3,enum=istio.networking.v1alpha3.Server_TLSOptions_TLSProtocol" json:"min_protocol_version,omitempty"`
	// Optional: Maximum TLS protocol version.
	MaxProtocolVersion Server_TLSOptions_TLSProtocol `protobuf:"varint,8,opt,name=max_protocol_version,json=maxProtocolVersion,proto3,enum=istio.networking.v1alpha3.Server_TLSOptions_TLSProtocol" json:"max_protocol_version,omitempty"`
	// Optional: If specified, only support the specified cipher list.
	// Otherwise default to the default cipher list supported by Envoy.
	CipherSuites         []string `protobuf:"bytes,9,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Server_TLSOptions) Reset()         { *m = Server_TLSOptions{} }
func (m *Server_TLSOptions) String() string { return proto.CompactTextString(m) }
func (*Server_TLSOptions) ProtoMessage()    {}
func (*Server_TLSOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{1, 0}
}
func (m *Server_TLSOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Server_TLSOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Server_TLSOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Server_TLSOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Server_TLSOptions.Merge(m, src)
}
func (m *Server_TLSOptions) XXX_Size() int {
	return m.Size()
}
func (m *Server_TLSOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_Server_TLSOptions.DiscardUnknown(m)
}

var xxx_messageInfo_Server_TLSOptions proto.InternalMessageInfo

func (m *Server_TLSOptions) GetHttpsRedirect() bool {
	if m != nil {
		return m.HttpsRedirect
	}
	return false
}

func (m *Server_TLSOptions) GetMode() Server_TLSOptions_TLSmode {
	if m != nil {
		return m.Mode
	}
	return Server_TLSOptions_PASSTHROUGH
}

func (m *Server_TLSOptions) GetServerCertificate() string {
	if m != nil {
		return m.ServerCertificate
	}
	return ""
}

func (m *Server_TLSOptions) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

func (m *Server_TLSOptions) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *Server_TLSOptions) GetCredentialName() string {
	if m != nil {
		return m.CredentialName
	}
	return ""
}

func (m *Server_TLSOptions) GetSubjectAltNames() []string {
	if m != nil {
		return m.SubjectAltNames
	}
	return nil
}

func (m *Server_TLSOptions) GetVerifyCertificateSpki() []string {
	if m != nil {
		return m.VerifyCertificateSpki
	}
	return nil
}

func (m *Server_TLSOptions) GetVerifyCertificateHash() []string {
	if m != nil {
		return m.VerifyCertificateHash
	}
	return nil
}

func (m *Server_TLSOptions) GetMinProtocolVersion() Server_TLSOptions_TLSProtocol {
	if m != nil {
		return m.MinProtocolVersion
	}
	return Server_TLSOptions_TLS_AUTO
}

func (m *Server_TLSOptions) GetMaxProtocolVersion() Server_TLSOptions_TLSProtocol {
	if m != nil {
		return m.MaxProtocolVersion
	}
	return Server_TLSOptions_TLS_AUTO
}

func (m *Server_TLSOptions) GetCipherSuites() []string {
	if m != nil {
		return m.CipherSuites
	}
	return nil
}

// Port describes the properties of a specific port of a service.
type Port struct {
	// REQUIRED: A valid non-negative integer port number.
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// REQUIRED: The protocol exposed on the port.
	// MUST BE one of HTTP|HTTPS|GRPC|HTTP2|MONGO|TCP|TLS.
	// TLS implies the connection will be routed based on the SNI header to
	// the destination without terminating the TLS connection.
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Label assigned to the port.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{2}
}
func (m *Port) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Port.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return m.Size()
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetNumber() uint32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *Port) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *Port) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("istio.networking.v1alpha3.Server_TLSOptions_TLSmode", Server_TLSOptions_TLSmode_name, Server_TLSOptions_TLSmode_value)
	proto.RegisterEnum("istio.networking.v1alpha3.Server_TLSOptions_TLSProtocol", Server_TLSOptions_TLSProtocol_name, Server_TLSOptions_TLSProtocol_value)
	proto.RegisterType((*Gateway)(nil), "istio.networking.v1alpha3.Gateway")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.Gateway.SelectorEntry")
	proto.RegisterType((*Server)(nil), "istio.networking.v1alpha3.Server")
	proto.RegisterType((*Server_TLSOptions)(nil), "istio.networking.v1alpha3.Server.TLSOptions")
	proto.RegisterType((*Port)(nil), "istio.networking.v1alpha3.Port")
}

func init() { proto.RegisterFile("networking/v1alpha3/gateway.proto", fileDescriptor_067d98d02f84cc0b) }

var fileDescriptor_067d98d02f84cc0b = []byte{
	// 725 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0xdb, 0x6e, 0xda, 0x4a,
	0x14, 0x8d, 0x81, 0x70, 0xd9, 0x40, 0x70, 0x46, 0x39, 0xe7, 0xf8, 0xe4, 0x21, 0x17, 0x8e, 0x8e,
	0x9a, 0x56, 0xad, 0x49, 0xa0, 0xaa, 0xa2, 0x46, 0xaa, 0x44, 0xab, 0x28, 0x44, 0x25, 0x01, 0xd9,
	0x90, 0x87, 0xbc, 0x58, 0x83, 0x99, 0x84, 0x09, 0xc6, 0xb6, 0x66, 0x06, 0x12, 0x7e, 0xad, 0x5f,
	0xd0, 0xc7, 0xf6, 0x0f, 0xaa, 0x48, 0xfd, 0x8f, 0xca, 0xe3, 0x21, 0xd0, 0x4b, 0x52, 0x45, 0x7d,
	0xdb, 0x97, 0xb5, 0xd6, 0xde, 0xb3, 0xf7, 0xcc, 0xc0, 0xb6, 0x4f, 0xc4, 0x75, 0xc0, 0x86, 0xd4,
	0xbf, 0xac, 0x4c, 0xf6, 0xb0, 0x17, 0x0e, 0x70, 0xad, 0x72, 0x89, 0x05, 0xb9, 0xc6, 0x53, 0x33,
	0x64, 0x81, 0x08, 0xd0, 0xbf, 0x94, 0x0b, 0x1a, 0x98, 0x73, 0xa0, 0x39, 0x03, 0x96, 0x3f, 0x6b,
	0x90, 0x39, 0x8a, 0xc1, 0xe8, 0x00, 0x32, 0x9c, 0xb0, 0x09, 0x61, 0xdc, 0xd0, 0xb6, 0x92, 0x3b,
	0xf9, 0xea, 0xb6, 0x79, 0x2f, 0xd1, 0xb4, 0x25, 0xd2, 0x9a, 0x31, 0x50, 0x13, 0xb2, 0x9c, 0x78,
	0xc4, 0x15, 0x01, 0x33, 0x12, 0x92, 0xbd, 0xfb, 0x00, 0x5b, 0x95, 0x34, 0x6d, 0x45, 0x39, 0xf4,
	0x05, 0x9b, 0x5a, 0x77, 0x0a, 0xeb, 0x07, 0x50, 0xfc, 0x2e, 0x85, 0x74, 0x48, 0x0e, 0xc9, 0xd4,
	0xd0, 0xb6, 0xb4, 0x9d, 0x9c, 0x15, 0x99, 0x68, 0x0d, 0x96, 0x27, 0xd8, 0x1b, 0x13, 0x23, 0x21,
	0x63, 0xb1, 0xf3, 0x3a, 0xb1, 0xaf, 0x95, 0x3f, 0x64, 0x21, 0x1d, 0xb7, 0x87, 0x6a, 0x90, 0x0a,
	0x03, 0x26, 0x24, 0x2f, 0x5f, 0xdd, 0x7c, 0xa0, 0xa3, 0x76, 0xc0, 0x84, 0x25, 0xc1, 0x08, 0x41,
	0xaa, 0x47, 0xfd, 0xbe, 0x91, 0x92, 0xc2, 0xd2, 0x8e, 0xaa, 0x0d, 0x02, 0x2e, 0xb8, 0x3c, 0x5b,
	0xce, 0x8a, 0x1d, 0xf4, 0x06, 0x92, 0xc2, 0xe3, 0x46, 0x52, 0xaa, 0x3f, 0xff, 0xed, 0xb4, 0xcc,
	0x4e, 0xd3, 0x6e, 0x85, 0x82, 0x06, 0x3e, 0xb7, 0x22, 0x22, 0x7a, 0x0a, 0x7a, 0x9f, 0x5c, 0xe0,
	0xb1, 0x27, 0x1c, 0xe2, 0xf7, 0xc3, 0x80, 0xfa, 0xc2, 0x58, 0x96, 0x55, 0x4b, 0x2a, 0x7e, 0xa8,
	0xc2, 0xeb, 0x5f, 0xd3, 0x00, 0x73, 0x3a, 0xfa, 0x1f, 0x56, 0x06, 0x42, 0x84, 0xdc, 0x61, 0xa4,
	0x4f, 0x19, 0x71, 0xe3, 0x23, 0x66, 0xad, 0xa2, 0x8c, 0x5a, 0x2a, 0x88, 0x1a, 0x90, 0x1a, 0x05,
	0xfd, 0x78, 0x46, 0x2b, 0xd5, 0x97, 0x8f, 0xe9, 0x30, 0x32, 0x23, 0xae, 0x25, 0x15, 0xd0, 0x0b,
	0x40, 0xf1, 0xaa, 0x1d, 0x97, 0x30, 0x41, 0x2f, 0xa8, 0x8b, 0x05, 0x91, 0x27, 0xcf, 0x59, 0xab,
	0x71, 0xe6, 0xdd, 0x3c, 0x81, 0x36, 0x21, 0x1f, 0x32, 0x3a, 0xc1, 0x82, 0x38, 0xd1, 0xde, 0xe2,
	0x51, 0x82, 0x0a, 0xbd, 0x27, 0x53, 0xf4, 0x04, 0x4a, 0x2e, 0x5e, 0xd4, 0xe2, 0xea, 0xe4, 0x2b,
	0x2e, 0x5e, 0x10, 0xe2, 0x12, 0xc8, 0x48, 0x9f, 0xf8, 0x82, 0x62, 0xcf, 0xf1, 0xf1, 0x88, 0x18,
	0xa0, 0x80, 0x77, 0xe1, 0x53, 0x3c, 0x22, 0xe8, 0x19, 0xac, 0xf2, 0x71, 0xef, 0x8a, 0xb8, 0xc2,
	0xc1, 0x9e, 0x90, 0x48, 0x6e, 0xa4, 0xe5, 0xba, 0x4a, 0x2a, 0x51, 0xf7, 0x44, 0x04, 0xe5, 0xe8,
	0x15, 0xfc, 0x33, 0x21, 0x8c, 0x5e, 0x4c, 0x17, 0x3b, 0x70, 0x78, 0x38, 0xa4, 0x46, 0x5e, 0x32,
	0xfe, 0x8a, 0xd3, 0x0b, 0x9d, 0xd8, 0xe1, 0x90, 0xde, 0xc3, 0x1b, 0x60, 0x3e, 0x30, 0x0a, 0xf7,
	0xf0, 0x1a, 0x98, 0x0f, 0xd0, 0x15, 0xac, 0x8d, 0xa8, 0xef, 0xc8, 0xe7, 0xe8, 0x06, 0x9e, 0x13,
	0x3d, 0x19, 0x1a, 0xf8, 0x46, 0x46, 0xee, 0x65, 0xff, 0xb1, 0x7b, 0x69, 0x2b, 0x1d, 0x0b, 0x8d,
	0xa8, 0x3f, 0x73, 0xce, 0x62, 0x4d, 0x59, 0x0b, 0xdf, 0xfc, 0x5c, 0x2b, 0xfb, 0xc7, 0xb5, 0xf0,
	0xcd, 0x8f, 0xb5, 0xfe, 0x83, 0xa2, 0x4b, 0xc3, 0x01, 0x61, 0x0e, 0x1f, 0xd3, 0x68, 0x87, 0x39,
	0x39, 0x85, 0x42, 0x1c, 0xb4, 0x65, 0xac, 0x7c, 0x0e, 0x19, 0x75, 0x97, 0x50, 0x09, 0xf2, 0xed,
	0xba, 0x6d, 0x77, 0x1a, 0x56, 0xab, 0x7b, 0xd4, 0xd0, 0x97, 0x10, 0x40, 0xda, 0x3e, 0x3e, 0x69,
	0x37, 0x0f, 0x75, 0x2d, 0xb2, 0x4f, 0xba, 0x9d, 0x6e, 0xbd, 0xa9, 0x27, 0xd0, 0x1a, 0xe8, 0xf5,
	0x6e, 0xa7, 0xe5, 0x2c, 0xa2, 0x93, 0x48, 0x87, 0xc2, 0xb1, 0xdd, 0x39, 0x6e, 0x39, 0x0a, 0x97,
	0x2a, 0xb7, 0x20, 0xbf, 0xd0, 0x23, 0x2a, 0x40, 0xb6, 0xd3, 0xb4, 0x9d, 0x88, 0xaa, 0x2f, 0xa1,
	0xbc, 0x2c, 0x7c, 0xb6, 0xe7, 0xec, 0xea, 0xda, 0xdc, 0xd9, 0xd3, 0x13, 0x73, 0xa7, 0xaa, 0x27,
	0xe7, 0x4e, 0x4d, 0x4f, 0x95, 0x4f, 0x21, 0x15, 0x7d, 0x05, 0xe8, 0x6f, 0x48, 0xfb, 0xe3, 0x51,
	0x8f, 0x30, 0xf9, 0xb0, 0x8a, 0x96, 0xf2, 0xd0, 0x3a, 0x64, 0x67, 0x93, 0x55, 0x3f, 0xcf, 0x9d,
	0x1f, 0x7d, 0x1c, 0xf2, 0x7e, 0xc6, 0xaf, 0x42, 0xda, 0x6f, 0xcd, 0x8f, 0xb7, 0x1b, 0xda, 0xa7,
	0xdb, 0x0d, 0xed, 0xcb, 0xed, 0x86, 0x76, 0xbe, 0x15, 0x0f, 0x9f, 0x06, 0x15, 0x1c, 0xd2, 0xca,
	0x2f, 0x7e, 0xee, 0x5e, 0x5a, 0xaa, 0xd5, 0xbe, 0x05, 0x00, 0x00, 0xff, 0xff, 0xd4, 0x12, 0xef,
	0xc6, 0xd7, 0x05, 0x00, 0x00,
}

func (m *Gateway) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Gateway) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Gateway) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Selector) > 0 {
		for k := range m.Selector {
			v := m.Selector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGateway(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGateway(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGateway(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Servers) > 0 {
		for iNdEx := len(m.Servers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Servers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGateway(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Server) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Server) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Server) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DefaultEndpoint) > 0 {
		i -= len(m.DefaultEndpoint)
		copy(dAtA[i:], m.DefaultEndpoint)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.DefaultEndpoint)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Bind) > 0 {
		i -= len(m.Bind)
		copy(dAtA[i:], m.Bind)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Bind)))
		i--
		dAtA[i] = 0x22
	}
	if m.Tls != nil {
		{
			size, err := m.Tls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGateway(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Port != nil {
		{
			size, err := m.Port.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGateway(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Server_TLSOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Server_TLSOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Server_TLSOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.VerifyCertificateHash) > 0 {
		for iNdEx := len(m.VerifyCertificateHash) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.VerifyCertificateHash[iNdEx])
			copy(dAtA[i:], m.VerifyCertificateHash[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.VerifyCertificateHash[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for iNdEx := len(m.VerifyCertificateSpki) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.VerifyCertificateSpki[iNdEx])
			copy(dAtA[i:], m.VerifyCertificateSpki[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.VerifyCertificateSpki[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.CredentialName) > 0 {
		i -= len(m.CredentialName)
		copy(dAtA[i:], m.CredentialName)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.CredentialName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.CipherSuites) > 0 {
		for iNdEx := len(m.CipherSuites) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CipherSuites[iNdEx])
			copy(dAtA[i:], m.CipherSuites[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.CipherSuites[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.MaxProtocolVersion != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.MaxProtocolVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.MinProtocolVersion != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.MinProtocolVersion))
		i--
		dAtA[i] = 0x38
	}
	if len(m.SubjectAltNames) > 0 {
		for iNdEx := len(m.SubjectAltNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SubjectAltNames[iNdEx])
			copy(dAtA[i:], m.SubjectAltNames[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.SubjectAltNames[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.CaCertificates) > 0 {
		i -= len(m.CaCertificates)
		copy(dAtA[i:], m.CaCertificates)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.CaCertificates)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PrivateKey) > 0 {
		i -= len(m.PrivateKey)
		copy(dAtA[i:], m.PrivateKey)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.PrivateKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ServerCertificate) > 0 {
		i -= len(m.ServerCertificate)
		copy(dAtA[i:], m.ServerCertificate)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.ServerCertificate)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Mode != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x10
	}
	if m.HttpsRedirect {
		i--
		if m.HttpsRedirect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Port) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Port) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Port) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if m.Number != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.Number))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintGateway(dAtA []byte, offset int, v uint64) int {
	offset -= sovGateway(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Gateway) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Servers) > 0 {
		for _, e := range m.Servers {
			l = e.Size()
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if len(m.Selector) > 0 {
		for k, v := range m.Selector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGateway(uint64(len(k))) + 1 + len(v) + sovGateway(uint64(len(v)))
			n += mapEntrySize + 1 + sovGateway(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Server) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.Bind)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.DefaultEndpoint)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Server_TLSOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpsRedirect {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovGateway(uint64(m.Mode))
	}
	l = len(m.ServerCertificate)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.PrivateKey)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.SubjectAltNames) > 0 {
		for _, s := range m.SubjectAltNames {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.MinProtocolVersion != 0 {
		n += 1 + sovGateway(uint64(m.MinProtocolVersion))
	}
	if m.MaxProtocolVersion != 0 {
		n += 1 + sovGateway(uint64(m.MaxProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	l = len(m.CredentialName)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Port) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Number != 0 {
		n += 1 + sovGateway(uint64(m.Number))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGateway(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGateway(x uint64) (n int) {
	return sovGateway(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Gateway) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Gateway: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Gateway: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Servers = append(m.Servers, &Server{})
			if err := m.Servers[len(m.Servers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGateway
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGateway
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGateway
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGateway
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGateway
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGateway
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGateway
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGateway(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGateway
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Selector[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Server) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Server: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Server: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &Port{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &Server_TLSOptions{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Server_TLSOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsRedirect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HttpsRedirect = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= Server_TLSOptions_TLSmode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerCertificate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerCertificate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectAltNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectAltNames = append(m.SubjectAltNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinProtocolVersion", wireType)
			}
			m.MinProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinProtocolVersion |= Server_TLSOptions_TLSProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxProtocolVersion", wireType)
			}
			m.MaxProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxProtocolVersion |= Server_TLSOptions_TLSProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherSuites", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherSuites = append(m.CipherSuites, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateSpki", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateSpki = append(m.VerifyCertificateSpki, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateHash = append(m.VerifyCertificateHash, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Port) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Port: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Port: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			m.Number = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Number |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGateway(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGateway
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthGateway
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGateway
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGateway(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthGateway
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGateway = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGateway   = fmt.Errorf("proto: integer overflow")
)
