// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/envoy_filter.proto

// `EnvoyFilter` provides a mechanism to customize the Envoy
// configuration generated by Istio Pilot. Use EnvoyFilter to modify
// values for certain fields, add specific filters, or even add
// entirely new listeners, clusters, etc. This feature must be used
// with care, as incorrect configurations could potentially
// destabilize the entire mesh. Unlike other Istio networking objects,
// EnvoyFilters are additively applied. Any number of EnvoyFilters can
// exist for a given workload in a specific namespace. The order of
// application of these EnvoyFilters is as follows: all EnvoyFilters
// in the config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// followed by all matching EnvoyFilters in the workload's namespace.
//
// **NOTE 1**: Since this is break glass configuration, there will not
// be any backward compatibility across different Istio releases. In
// other words, this configuration is subject to change based on
// internal implementation of Istio networking subsystem.
//
// **NOTE 2**: The envoy configuration provided through this mechanism
// should be carefully monitored across Istio proxy version upgrades,
// to ensure that deprecated fields are removed and replaced
// appropriately.
//
// **NOTE 3**: When multiple EnvoyFilters are bound to the same
// workload in a given namespace, all patches will be processed
// sequentially in order of creation time.  The behavior is undefined
// if multiple EnvoyFilter configurations conflict with each other.
//
// **NOTE 4**: *_To apply an EnvoyFilter resource to all workloads
// (sidecars and gateways) in the system, define the resource in the
// config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// without a workloadSelector.
//
// The example below declares a global default EnvoyFilter resource in
// the root namespace called `istio-config`, that adds a custom
// protocol filter on all sidecars in the system, for outbound port
// 9307. The filter should be added before the terminating tcp_proxy
// filter to take effect. In addition, it sets a 30s idle timeout for
// all HTTP connections in both gateays and sidecars.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: custom-protocol
//   namespace: istio-config # as defined in meshConfig resource.
// spec:
//   configPatches:
//   - applyTo: NETWORK_FILTER
//     match:
//       context: SIDECAR_OUTBOUND # will match outbound listeners in all sidecars
//       listener:
//         portNumber: 9307
//         filterChain:
//           filter:
//             name: "envoy.tcp_proxy"
//     patch:
//       operation: INSERT_BEFORE
//       value:
//         name: "envoy.config.filter.network.custom_protocol"
//         config:
//          ...
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       # context omitted so that this applies to both sidecars and gateways
//       listener:
//         filterChain:
//           filter:
//             name: "envoy.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         idle_timeout: 30s
//```
//
// The following example enables Envoy's Lua filter for all inbound
// HTTP calls arriving at service port 8080 of the reviews service pod
// with labels "app: reviews", in the bookinfo namespace. The lua
// filter calls out to an external service internal.org.net:8888 that
// requires a special cluster definition in envoy. The cluster is also
// added to the sidecar as part of this configuration.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-lua
//   namespace: bookinfo
// spec:
//   workloadSelector:
//     labels:
//       app: reviews
//   configPatches:
//     # The first patch adds the lua filter to the listener/http connection manager
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//       listener:
//         portNumber: 8080
//         filterChain:
//           filter:
//             name: "envoy.http_connection_manager"
//             subFilter:
//               name: "envoy.router"
//     patch:
//       operation: INSERT_BEFORE
//       value: # lua filter specification
//        name: envoy.lua
//        config:
//          inlineCode: |
//            function envoy_on_request(request_handle)
//              -- Make an HTTP call to an upstream host with the following headers, body, and timeout.
//              local headers, body = request_handle:httpCall(
//               "lua_cluster",
//               {
//                [":method"] = "POST",
//                [":path"] = "/acl",
//                [":authority"] = "internal.org.net"
//               },
//              "authorize call",
//              5000)
//            end
//   # The second patch adds the cluster that is referenced by the lua code
//   # cds match is omitted as a new cluster is being added
//   - applyTo: CLUSTER
//     match:
//       context: SIDECAR_OUTBOUND
//     patch:
//       operation: ADD
//       value: # cluster specification
//         name: "lua_cluster"
//         type: STRICT_DNS
//         connect_timeout: 0.5s
//         lb_policy: ROUND_ROBIN
//         hosts:
//         - socket_address:
//             protocol: TCP
//             address: "internal.org.net"
//             port_value: 8888
//
// ```
//
// The following example overwrites certain fields (HTTP idle timeout
// and X-Forward-For trusted hops) in the HTTP connection manager in a
// listener on the ingress gateway in istio-system namespace for the
// SNI host app.example.com:
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: hcm-tweaks
//   namespace: istio-system
// spec:
//   workloadSelector:
//     labels:
//       istio: ingress-gateway
//   configPatches:
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       context: GATEWAY
//       listener:
//         filterChain:
//           sni: app.example.com
//           filter:
//             name: "envoy.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         idle_timeout: 30s
//         xff_num_trusted_hops: 5
//```
//

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ApplyTo specifies where in the Envoy configuration, the given patch should be applied.
type EnvoyFilter_ApplyTo int32

const (
	EnvoyFilter_INVALID EnvoyFilter_ApplyTo = 0
	// Applies the patch to the listener.
	EnvoyFilter_LISTENER EnvoyFilter_ApplyTo = 1
	// Applies the patch to the filter chain.
	EnvoyFilter_FILTER_CHAIN EnvoyFilter_ApplyTo = 2
	// Applies the patch to the network filter chain, to modify an
	// existing filter or add a new filter.
	EnvoyFilter_NETWORK_FILTER EnvoyFilter_ApplyTo = 3
	// Applies the patch to the HTTP filter chain in the http
	// connection manager, to modify an existing filter or add a new
	// filter.
	EnvoyFilter_HTTP_FILTER EnvoyFilter_ApplyTo = 4
	// Applies the patch to the Route configuration (rds output)
	// inside a HTTP connection manager. This does not apply to the
	// virtual host. Currently, only MERGE operation is allowed on the
	// route configuration objects.
	EnvoyFilter_ROUTE_CONFIGURATION EnvoyFilter_ApplyTo = 5
	// Applies the patch to a virtual host inside a route configuration.
	EnvoyFilter_VIRTUAL_HOST EnvoyFilter_ApplyTo = 6
	// Applies the patch to a route object inside the matched virtual
	// host in a route configuration. Currently, only MERGE operation
	// is allowed on the route objects.
	EnvoyFilter_HTTP_ROUTE EnvoyFilter_ApplyTo = 7
	// Applies the patch to a cluster in a CDS output. Also used to add new clusters.
	EnvoyFilter_CLUSTER EnvoyFilter_ApplyTo = 8
)

var EnvoyFilter_ApplyTo_name = map[int32]string{
	0: "INVALID",
	1: "LISTENER",
	2: "FILTER_CHAIN",
	3: "NETWORK_FILTER",
	4: "HTTP_FILTER",
	5: "ROUTE_CONFIGURATION",
	6: "VIRTUAL_HOST",
	7: "HTTP_ROUTE",
	8: "CLUSTER",
}

var EnvoyFilter_ApplyTo_value = map[string]int32{
	"INVALID":             0,
	"LISTENER":            1,
	"FILTER_CHAIN":        2,
	"NETWORK_FILTER":      3,
	"HTTP_FILTER":         4,
	"ROUTE_CONFIGURATION": 5,
	"VIRTUAL_HOST":        6,
	"HTTP_ROUTE":          7,
	"CLUSTER":             8,
}

func (x EnvoyFilter_ApplyTo) String() string {
	return proto.EnumName(EnvoyFilter_ApplyTo_name, int32(x))
}

func (EnvoyFilter_ApplyTo) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0}
}

// PatchContext selects a class of configurations based on the
// traffic flow direction and workload type.
type EnvoyFilter_PatchContext int32

const (
	// All listeners/routes/clusters in both sidecars and gateways.
	EnvoyFilter_ANY EnvoyFilter_PatchContext = 0
	// Inbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_INBOUND EnvoyFilter_PatchContext = 1
	// Outbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_OUTBOUND EnvoyFilter_PatchContext = 2
	// Gateway listener/route/cluster.
	EnvoyFilter_GATEWAY EnvoyFilter_PatchContext = 3
)

var EnvoyFilter_PatchContext_name = map[int32]string{
	0: "ANY",
	1: "SIDECAR_INBOUND",
	2: "SIDECAR_OUTBOUND",
	3: "GATEWAY",
}

var EnvoyFilter_PatchContext_value = map[string]int32{
	"ANY":              0,
	"SIDECAR_INBOUND":  1,
	"SIDECAR_OUTBOUND": 2,
	"GATEWAY":          3,
}

func (x EnvoyFilter_PatchContext) String() string {
	return proto.EnumName(EnvoyFilter_PatchContext_name, int32(x))
}

func (EnvoyFilter_PatchContext) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1}
}

type EnvoyFilter_DeprecatedListenerMatch_ListenerType int32

const (
	// All listeners
	EnvoyFilter_DeprecatedListenerMatch_ANY EnvoyFilter_DeprecatedListenerMatch_ListenerType = 0
	// Inbound listener in sidecar
	EnvoyFilter_DeprecatedListenerMatch_SIDECAR_INBOUND EnvoyFilter_DeprecatedListenerMatch_ListenerType = 1
	// Outbound listener in sidecar
	EnvoyFilter_DeprecatedListenerMatch_SIDECAR_OUTBOUND EnvoyFilter_DeprecatedListenerMatch_ListenerType = 2
	// Gateway listener
	EnvoyFilter_DeprecatedListenerMatch_GATEWAY EnvoyFilter_DeprecatedListenerMatch_ListenerType = 3
)

var EnvoyFilter_DeprecatedListenerMatch_ListenerType_name = map[int32]string{
	0: "ANY",
	1: "SIDECAR_INBOUND",
	2: "SIDECAR_OUTBOUND",
	3: "GATEWAY",
}

var EnvoyFilter_DeprecatedListenerMatch_ListenerType_value = map[string]int32{
	"ANY":              0,
	"SIDECAR_INBOUND":  1,
	"SIDECAR_OUTBOUND": 2,
	"GATEWAY":          3,
}

func (x EnvoyFilter_DeprecatedListenerMatch_ListenerType) String() string {
	return proto.EnumName(EnvoyFilter_DeprecatedListenerMatch_ListenerType_name, int32(x))
}

func (EnvoyFilter_DeprecatedListenerMatch_ListenerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0, 0}
}

type EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol int32

const (
	// All protocols
	EnvoyFilter_DeprecatedListenerMatch_ALL EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol = 0
	// HTTP or HTTPS (with termination) / HTTP2/gRPC
	EnvoyFilter_DeprecatedListenerMatch_HTTP EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol = 1
	// Any non-HTTP listener
	EnvoyFilter_DeprecatedListenerMatch_TCP EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol = 2
)

var EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol_name = map[int32]string{
	0: "ALL",
	1: "HTTP",
	2: "TCP",
}

var EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol_value = map[string]int32{
	"ALL":  0,
	"HTTP": 1,
	"TCP":  2,
}

func (x EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol) String() string {
	return proto.EnumName(EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol_name, int32(x))
}

func (EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0, 1}
}

// Index/position in the filter chain.
type EnvoyFilter_InsertPosition_Index int32

const (
	// Insert first
	EnvoyFilter_InsertPosition_FIRST EnvoyFilter_InsertPosition_Index = 0
	// Insert last
	EnvoyFilter_InsertPosition_LAST EnvoyFilter_InsertPosition_Index = 1
	// Insert before the named filter.
	EnvoyFilter_InsertPosition_BEFORE EnvoyFilter_InsertPosition_Index = 2
	// Insert after the named filter.
	EnvoyFilter_InsertPosition_AFTER EnvoyFilter_InsertPosition_Index = 3
)

var EnvoyFilter_InsertPosition_Index_name = map[int32]string{
	0: "FIRST",
	1: "LAST",
	2: "BEFORE",
	3: "AFTER",
}

var EnvoyFilter_InsertPosition_Index_value = map[string]int32{
	"FIRST":  0,
	"LAST":   1,
	"BEFORE": 2,
	"AFTER":  3,
}

func (x EnvoyFilter_InsertPosition_Index) String() string {
	return proto.EnumName(EnvoyFilter_InsertPosition_Index_name, int32(x))
}

func (EnvoyFilter_InsertPosition_Index) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1, 0}
}

type EnvoyFilter_Filter_FilterType int32

const (
	// placeholder
	EnvoyFilter_Filter_INVALID EnvoyFilter_Filter_FilterType = 0
	// Http filter
	EnvoyFilter_Filter_HTTP EnvoyFilter_Filter_FilterType = 1
	// Network filter
	EnvoyFilter_Filter_NETWORK EnvoyFilter_Filter_FilterType = 2
)

var EnvoyFilter_Filter_FilterType_name = map[int32]string{
	0: "INVALID",
	1: "HTTP",
	2: "NETWORK",
}

var EnvoyFilter_Filter_FilterType_value = map[string]int32{
	"INVALID": 0,
	"HTTP":    1,
	"NETWORK": 2,
}

func (x EnvoyFilter_Filter_FilterType) String() string {
	return proto.EnumName(EnvoyFilter_Filter_FilterType_name, int32(x))
}

func (EnvoyFilter_Filter_FilterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2, 0}
}

// Action refers to the route action taken by Envoy when a http route matches.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action int32

const (
	// All three route actions
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 0
	// Route traffic to a cluster / weighted clusters.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ROUTE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 1
	// Redirect request.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_REDIRECT EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 2
	// directly respond to a request with specific payload.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_DIRECT_RESPONSE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 3
)

var EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name = map[int32]string{
	0: "ANY",
	1: "ROUTE",
	2: "REDIRECT",
	3: "DIRECT_RESPONSE",
}

var EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_value = map[string]int32{
	"ANY":             0,
	"ROUTE":           1,
	"REDIRECT":        2,
	"DIRECT_RESPONSE": 3,
}

func (x EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) String() string {
	return proto.EnumName(EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name, int32(x))
}

func (EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 5, 0, 0}
}

// Operation denotes how the patch should be applied to the selected
// configuration.
type EnvoyFilter_Patch_Operation int32

const (
	EnvoyFilter_Patch_INVALID EnvoyFilter_Patch_Operation = 0
	// Merge the provided config with the generated config using
	// json merge semantics.
	EnvoyFilter_Patch_MERGE EnvoyFilter_Patch_Operation = 1
	// Add the provided config to an existing list (of listeners,
	// clusters, virtual hosts, network filters, or http
	// filters). This operation will be ignored when applyTo is set
	// to ROUTE_CONFIGURATION, or HTTP_ROUTE.
	EnvoyFilter_Patch_ADD EnvoyFilter_Patch_Operation = 2
	// Remove the selected object from the list (of listeners,
	// clusters, virtual hosts, network filters, or http
	// filters). Does not require a value to be specified. This
	// operation will be ignored when applyTo is set to
	// ROUTE_CONFIGURATION, or HTTP_ROUTE.
	EnvoyFilter_Patch_REMOVE EnvoyFilter_Patch_Operation = 3
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters, where the
	// order of filters matter. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// before the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the front
	// of the list.
	EnvoyFilter_Patch_INSERT_BEFORE EnvoyFilter_Patch_Operation = 4
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters, where the
	// order of filters matter. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// after the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the end
	// of the list.
	EnvoyFilter_Patch_INSERT_AFTER EnvoyFilter_Patch_Operation = 5
)

var EnvoyFilter_Patch_Operation_name = map[int32]string{
	0: "INVALID",
	1: "MERGE",
	2: "ADD",
	3: "REMOVE",
	4: "INSERT_BEFORE",
	5: "INSERT_AFTER",
}

var EnvoyFilter_Patch_Operation_value = map[string]int32{
	"INVALID":       0,
	"MERGE":         1,
	"ADD":           2,
	"REMOVE":        3,
	"INSERT_BEFORE": 4,
	"INSERT_AFTER":  5,
}

func (x EnvoyFilter_Patch_Operation) String() string {
	return proto.EnumName(EnvoyFilter_Patch_Operation_name, int32(x))
}

func (EnvoyFilter_Patch_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 7, 0}
}

type EnvoyFilter struct {
	// Deprecated. Use workload_selector instead.
	// $hide_from_docs
	WorkloadLabels map[string]string `protobuf:"bytes,1,rep,name=workload_labels,json=workloadLabels,proto3" json:"workload_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// $hide_from_docs
	Filters []*EnvoyFilter_Filter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"` // Deprecated: Do not use.
	// Criteria used to select the specific set of pods/VMs on which
	// this patch configuration should be applied. If omitted, the set
	// of patches in this configuration will be applied to all workload
	// instances in the same namespace.  If omitted, the EnvoyFilter
	// patches will be applied to all workloads in the same
	// namespace. If the EnvoyFilter is present in the config root
	// namespace, it will be applied to all applicable workloads in any
	// namespace.
	WorkloadSelector *WorkloadSelector `protobuf:"bytes,3,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	// REQUIRED. One or more patches with match conditions.
	ConfigPatches        []*EnvoyFilter_EnvoyConfigObjectPatch `protobuf:"bytes,4,rep,name=config_patches,json=configPatches,proto3" json:"config_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *EnvoyFilter) Reset()         { *m = EnvoyFilter{} }
func (m *EnvoyFilter) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter) ProtoMessage()    {}
func (*EnvoyFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0}
}
func (m *EnvoyFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter.Merge(m, src)
}
func (m *EnvoyFilter) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *EnvoyFilter) GetWorkloadLabels() map[string]string {
	if m != nil {
		return m.WorkloadLabels
	}
	return nil
}

// Deprecated: Do not use.
func (m *EnvoyFilter) GetFilters() []*EnvoyFilter_Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *EnvoyFilter) GetWorkloadSelector() *WorkloadSelector {
	if m != nil {
		return m.WorkloadSelector
	}
	return nil
}

func (m *EnvoyFilter) GetConfigPatches() []*EnvoyFilter_EnvoyConfigObjectPatch {
	if m != nil {
		return m.ConfigPatches
	}
	return nil
}

// Deprecated.
// Select a listener to add the filter to based on the match conditions.
// All conditions specified in the ListenerMatch must be met for the filter
// to be applied to a listener.
// $hide_from_docs
type EnvoyFilter_DeprecatedListenerMatch struct {
	// The service port/gateway port to which traffic is being
	// sent/received. If not specified, matches all listeners. Even though
	// inbound listeners are generated for the instance/pod ports, only
	// service ports should be used to match listeners.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Instead of using specific port numbers, a set of ports matching a
	// given port name prefix can be selected. E.g., "mongo" selects ports
	// named mongo-port, mongo, mongoDB, MONGO, etc. Matching is case
	// insensitive.
	PortNamePrefix string `protobuf:"bytes,2,opt,name=port_name_prefix,json=portNamePrefix,proto3" json:"port_name_prefix,omitempty"`
	// Inbound vs outbound sidecar listener or gateway listener. If not specified,
	// matches all listeners.
	ListenerType EnvoyFilter_DeprecatedListenerMatch_ListenerType `protobuf:"varint,3,opt,name=listener_type,json=listenerType,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_DeprecatedListenerMatch_ListenerType" json:"listener_type,omitempty"`
	// Selects a class of listeners for the same protocol. Use the protocol
	// selection to select all HTTP listeners (includes HTTP2/gRPC/HTTPS
	// where Envoy terminates TLS) or all TCP listeners (includes HTTPS
	// passthrough using SNI). When adding a HTTP filter, the listenerProtocol
	// should be set to HTTP.
	ListenerProtocol EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol `protobuf:"varint,4,opt,name=listener_protocol,json=listenerProtocol,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol" json:"listener_protocol,omitempty"`
	// One or more IP addresses to which the listener is bound. If
	// specified, should match at least one address in the list.
	Address              []string `protobuf:"bytes,5,rep,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_DeprecatedListenerMatch) Reset()         { *m = EnvoyFilter_DeprecatedListenerMatch{} }
func (m *EnvoyFilter_DeprecatedListenerMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_DeprecatedListenerMatch) ProtoMessage()    {}
func (*EnvoyFilter_DeprecatedListenerMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0}
}
func (m *EnvoyFilter_DeprecatedListenerMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_DeprecatedListenerMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_DeprecatedListenerMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_DeprecatedListenerMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_DeprecatedListenerMatch.Merge(m, src)
}
func (m *EnvoyFilter_DeprecatedListenerMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_DeprecatedListenerMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_DeprecatedListenerMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_DeprecatedListenerMatch proto.InternalMessageInfo

func (m *EnvoyFilter_DeprecatedListenerMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_DeprecatedListenerMatch) GetPortNamePrefix() string {
	if m != nil {
		return m.PortNamePrefix
	}
	return ""
}

func (m *EnvoyFilter_DeprecatedListenerMatch) GetListenerType() EnvoyFilter_DeprecatedListenerMatch_ListenerType {
	if m != nil {
		return m.ListenerType
	}
	return EnvoyFilter_DeprecatedListenerMatch_ANY
}

func (m *EnvoyFilter_DeprecatedListenerMatch) GetListenerProtocol() EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol {
	if m != nil {
		return m.ListenerProtocol
	}
	return EnvoyFilter_DeprecatedListenerMatch_ALL
}

func (m *EnvoyFilter_DeprecatedListenerMatch) GetAddress() []string {
	if m != nil {
		return m.Address
	}
	return nil
}

// Deprecated.
// Indicates the relative index in the filter chain where the filter should be inserted.
// $hide_from_docs
type EnvoyFilter_InsertPosition struct {
	// Position of this filter in the filter chain.
	Index EnvoyFilter_InsertPosition_Index `protobuf:"varint,1,opt,name=index,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_InsertPosition_Index" json:"index,omitempty"`
	// If BEFORE or AFTER position is specified, specify the name of the
	// filter relative to which this filter should be inserted.
	RelativeTo           string   `protobuf:"bytes,2,opt,name=relative_to,json=relativeTo,proto3" json:"relative_to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_InsertPosition) Reset()         { *m = EnvoyFilter_InsertPosition{} }
func (m *EnvoyFilter_InsertPosition) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_InsertPosition) ProtoMessage()    {}
func (*EnvoyFilter_InsertPosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1}
}
func (m *EnvoyFilter_InsertPosition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_InsertPosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_InsertPosition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_InsertPosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_InsertPosition.Merge(m, src)
}
func (m *EnvoyFilter_InsertPosition) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_InsertPosition) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_InsertPosition.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_InsertPosition proto.InternalMessageInfo

func (m *EnvoyFilter_InsertPosition) GetIndex() EnvoyFilter_InsertPosition_Index {
	if m != nil {
		return m.Index
	}
	return EnvoyFilter_InsertPosition_FIRST
}

func (m *EnvoyFilter_InsertPosition) GetRelativeTo() string {
	if m != nil {
		return m.RelativeTo
	}
	return ""
}

// Deprecated.
// Envoy filters to be added to a network or http filter chain.
// $hide_from_docs
type EnvoyFilter_Filter struct {
	// Filter will be added to the listener only if the match
	// conditions are true.  If not specified, the filters will be
	// applied to all listeners where possible, potentially resulting
	// in invalid configurations. It is recommended to specify the
	// listener match criteria for all filter insertions.
	ListenerMatch *EnvoyFilter_DeprecatedListenerMatch `protobuf:"bytes,1,opt,name=listener_match,json=listenerMatch,proto3" json:"listener_match,omitempty"`
	// Insert position in the filter chain. Defaults to FIRST
	InsertPosition *EnvoyFilter_InsertPosition `protobuf:"bytes,2,opt,name=insert_position,json=insertPosition,proto3" json:"insert_position,omitempty"`
	// REQUIRED: The type of filter to instantiate.
	FilterType EnvoyFilter_Filter_FilterType `protobuf:"varint,3,opt,name=filter_type,json=filterType,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Filter_FilterType" json:"filter_type,omitempty"`
	// REQUIRED: The name of the filter to instantiate. The name must match a supported
	// filter _compiled into_ Envoy.
	FilterName string `protobuf:"bytes,4,opt,name=filter_name,json=filterName,proto3" json:"filter_name,omitempty"`
	// REQUIRED: Filter specific configuration which depends on the filter being
	// instantiated.
	FilterConfig         *types.Struct `protobuf:"bytes,5,opt,name=filter_config,json=filterConfig,proto3" json:"filter_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EnvoyFilter_Filter) Reset()         { *m = EnvoyFilter_Filter{} }
func (m *EnvoyFilter_Filter) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_Filter) ProtoMessage()    {}
func (*EnvoyFilter_Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2}
}
func (m *EnvoyFilter_Filter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_Filter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_Filter.Merge(m, src)
}
func (m *EnvoyFilter_Filter) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_Filter proto.InternalMessageInfo

func (m *EnvoyFilter_Filter) GetListenerMatch() *EnvoyFilter_DeprecatedListenerMatch {
	if m != nil {
		return m.ListenerMatch
	}
	return nil
}

func (m *EnvoyFilter_Filter) GetInsertPosition() *EnvoyFilter_InsertPosition {
	if m != nil {
		return m.InsertPosition
	}
	return nil
}

func (m *EnvoyFilter_Filter) GetFilterType() EnvoyFilter_Filter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return EnvoyFilter_Filter_INVALID
}

func (m *EnvoyFilter_Filter) GetFilterName() string {
	if m != nil {
		return m.FilterName
	}
	return ""
}

func (m *EnvoyFilter_Filter) GetFilterConfig() *types.Struct {
	if m != nil {
		return m.FilterConfig
	}
	return nil
}

// One or more properties of the proxy to match on.
type EnvoyFilter_ProxyMatch struct {
	// A regular expression in golang regex format (RE2) that can be
	// used to select proxies using a specific version of istio
	// proxy. The Istio version for a given proxy is obtained from the
	// node metadata field ISTIO_VERSION supplied by the proxy when
	// connecting to Pilot. This value is embedded as an environment
	// variable (ISTIO_META_ISTIO_VERSION) in the Istio proxy docker
	// image. Custom proxy implementations should provide this metadata
	// variable to take advantage of the Istio version check option.
	ProxyVersion string `protobuf:"bytes,1,opt,name=proxy_version,json=proxyVersion,proto3" json:"proxy_version,omitempty"`
	// Match on the node metadata supplied by a proxy when connecting
	// to Istio Pilot. Note that while Envoy's node metadata is of
	// type Struct, only string key-value pairs are processed by
	// Pilot. All keys specified in the metadata must match with exact
	// values. The match will fail if any of the specified keys are
	// absent or the values fail to match.
	Metadata             map[string]string `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *EnvoyFilter_ProxyMatch) Reset()         { *m = EnvoyFilter_ProxyMatch{} }
func (m *EnvoyFilter_ProxyMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ProxyMatch) ProtoMessage()    {}
func (*EnvoyFilter_ProxyMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3}
}
func (m *EnvoyFilter_ProxyMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ProxyMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ProxyMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ProxyMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ProxyMatch.Merge(m, src)
}
func (m *EnvoyFilter_ProxyMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ProxyMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ProxyMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ProxyMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ProxyMatch) GetProxyVersion() string {
	if m != nil {
		return m.ProxyVersion
	}
	return ""
}

func (m *EnvoyFilter_ProxyMatch) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Conditions specified in ClusterMatch must be met for the patch
// to be applied to a cluster.
type EnvoyFilter_ClusterMatch struct {
	// The service port for which this cluster was generated.  If
	// omitted, applies to clusters for any port.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// The fully qualified service name for this cluster. If omitted,
	// applies to clusters for any service. For services defined
	// through service entries, the service name is same as the hosts
	// defined in the service entry.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// The subset associated with the service. If omitted, applies to
	// clusters for any subset of a service.
	Subset string `protobuf:"bytes,3,opt,name=subset,proto3" json:"subset,omitempty"`
	// The exact name of the cluster to match. To match a specific
	// cluster by name, such as the internally generated "Passthrough"
	// cluster, leave all fields in clusterMatch empty, except the
	// name.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ClusterMatch) Reset()         { *m = EnvoyFilter_ClusterMatch{} }
func (m *EnvoyFilter_ClusterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ClusterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ClusterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 4}
}
func (m *EnvoyFilter_ClusterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ClusterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ClusterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ClusterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ClusterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ClusterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ClusterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ClusterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ClusterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ClusterMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_ClusterMatch) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *EnvoyFilter_ClusterMatch) GetSubset() string {
	if m != nil {
		return m.Subset
	}
	return ""
}

func (m *EnvoyFilter_ClusterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Conditions specified in RouteConfigurationMatch must be met for
// the patch to be applied to a route configuration object or a
// specific virtual host within the route configuration.
type EnvoyFilter_RouteConfigurationMatch struct {
	// The service port number or gateway server port number for which
	// this route configuration was generated. If omitted, applies to
	// route configurations for all ports.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Applicable only for GATEWAY context. The gateway server port
	// name for which this route configuration was generated.
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// The Istio gateway config's namespace/name for which this route
	// configuration was generated. Applies only if the context is
	// GATEWAY. Should be in the namespace/name format. Use this field
	// in conjunction with the portNumber and portName to accurately
	// select the Envoy route configuration for a specific HTTPS
	// server within a gateway config object.
	Gateway string `protobuf:"bytes,3,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Match a specific virtual host in a route configuration and
	// apply the patch to the virtual host.
	Vhost *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch `protobuf:"bytes,4,opt,name=vhost,proto3" json:"vhost,omitempty"`
	// Route configuration name to match on. Can be used to match a
	// specific route configuration by name, such as the internally
	// generated "http_proxy" route configuration for all sidecars.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch) Reset()         { *m = EnvoyFilter_RouteConfigurationMatch{} }
func (m *EnvoyFilter_RouteConfigurationMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_RouteConfigurationMatch) ProtoMessage()    {}
func (*EnvoyFilter_RouteConfigurationMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 5}
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetGateway() string {
	if m != nil {
		return m.Gateway
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetVhost() *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch {
	if m != nil {
		return m.Vhost
	}
	return nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Match a specific route inside a virtual host in a route configuration.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch struct {
	// The Route objects generated by default are named as
	// "default".  Route objects generated using a virtual service
	// will carry the name used in the virtual service's HTTP
	// routes.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a route with specific action type.
	Action               EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action `protobuf:"varint,2,opt,name=action,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Reset() {
	*m = EnvoyFilter_RouteConfigurationMatch_RouteMatch{}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) ProtoMessage() {}
func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 5, 0}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetAction() EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action {
	if m != nil {
		return m.Action
	}
	return EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY
}

// Match a specific virtual host inside a route configuration.
type EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch struct {
	// The VirtualHosts objects generated by Istio are named as
	// host:port, where the host typically corresponds to the
	// VirtualService's host field or the hostname of a service in the
	// registry.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a specific route within the virtual host.
	Route                *EnvoyFilter_RouteConfigurationMatch_RouteMatch `protobuf:"bytes,2,opt,name=route,proto3" json:"route,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Reset() {
	*m = EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch{}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) ProtoMessage() {}
func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 5, 1}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetRoute() *EnvoyFilter_RouteConfigurationMatch_RouteMatch {
	if m != nil {
		return m.Route
	}
	return nil
}

// Conditions specified in a listener match must be met for the
// patch to be applied to a specific listener across all filter
// chains, or a specific filter chain inside the listener.
type EnvoyFilter_ListenerMatch struct {
	// The service port/gateway port to which traffic is being
	// sent/received. If not specified, matches all listeners. Even though
	// inbound listeners are generated for the instance/pod ports, only
	// service ports should be used to match listeners.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Instead of using specific port numbers, a set of ports matching
	// a given service's port name can be selected. Matching is case
	// insensitive.
	// Not implemented.
	// $hide_from_docs
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// Match a specific filter chain in a listener. If specified, the
	// patch will be applied to the filter chain (and a specific
	// filter if specified) and not to other filter chains in the
	// listener.
	FilterChain *EnvoyFilter_ListenerMatch_FilterChainMatch `protobuf:"bytes,3,opt,name=filter_chain,json=filterChain,proto3" json:"filter_chain,omitempty"`
	// Match a specific listener by its name. The listeners generated
	// by Pilot are typically named as IP:Port.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch) Reset()         { *m = EnvoyFilter_ListenerMatch{} }
func (m *EnvoyFilter_ListenerMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 6}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_ListenerMatch) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch) GetFilterChain() *EnvoyFilter_ListenerMatch_FilterChainMatch {
	if m != nil {
		return m.FilterChain
	}
	return nil
}

func (m *EnvoyFilter_ListenerMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// For listeners with multiple filter chains (e.g., inbound
// listeners on sidecars with permissive mTLS, gateway listeners
// with multiple SNI matches), the filter chain match can be used
// to select a specific filter chain to patch.
type EnvoyFilter_ListenerMatch_FilterChainMatch struct {
	// The name assigned to the filter chain.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The SNI value used by a filter chain's match condition.  This
	// condition will evaluate to false if the filter chain has no
	// sni match.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
	// Applies only to SIDECAR_INBOUND context. If non-empty, a
	// transport protocol to consider when determining a filter
	// chain match.  This value will be compared against the
	// transport protocol of a new connection, when it's detected by
	// the tls_inspector listener filter.
	//
	// Accepted values include:
	//
	// * `raw_buffer` - default, used when no transport protocol is detected.
	// * `tls` - set when TLS protocol is detected by the TLS inspector.
	TransportProtocol string `protobuf:"bytes,3,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// Applies only to sidecars. If non-empty, a comma separated set
	// of application protocols to consider when determining a
	// filter chain match.  This value will be compared against the
	// application protocols of a new connection, when it's detected
	// by one of the listener filters such as the http_inspector.
	//
	// Accepted values include: h2,http/1.1,http/1.0
	ApplicationProtocols string `protobuf:"bytes,4,opt,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// The name of a specific filter to apply the patch to. Set this
	// to envoy.http_connection_manager to add a filter or apply a
	// patch to the HTTP connection manager.
	Filter               *EnvoyFilter_ListenerMatch_FilterMatch `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Reset() {
	*m = EnvoyFilter_ListenerMatch_FilterChainMatch{}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_ListenerMatch_FilterChainMatch) ProtoMessage() {}
func (*EnvoyFilter_ListenerMatch_FilterChainMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 6, 0}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetTransportProtocol() string {
	if m != nil {
		return m.TransportProtocol
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetApplicationProtocols() string {
	if m != nil {
		return m.ApplicationProtocols
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetFilter() *EnvoyFilter_ListenerMatch_FilterMatch {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Conditions to match a specific filter within a filter chain.
type EnvoyFilter_ListenerMatch_FilterMatch struct {
	// The filter name to match on.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The next level filter within this filter to match
	// upon. Typically used for HTTP Connection Manager filters and
	// Thrift filters.
	SubFilter            *EnvoyFilter_ListenerMatch_SubFilterMatch `protobuf:"bytes,2,opt,name=sub_filter,json=subFilter,proto3" json:"sub_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Reset()         { *m = EnvoyFilter_ListenerMatch_FilterMatch{} }
func (m *EnvoyFilter_ListenerMatch_FilterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch_FilterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch_FilterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 6, 1}
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_FilterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) GetSubFilter() *EnvoyFilter_ListenerMatch_SubFilterMatch {
	if m != nil {
		return m.SubFilter
	}
	return nil
}

// Conditions to match a specific filter within another
// filter. This field is typically useful to match a HTTP filter
// inside the envoy.http_connection_manager network filter. This
// could also be applicable for thrift filters.
type EnvoyFilter_ListenerMatch_SubFilterMatch struct {
	// The filter name to match on.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Reset() {
	*m = EnvoyFilter_ListenerMatch_SubFilterMatch{}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch_SubFilterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch_SubFilterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 6, 2}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Patch specifies how the selected object should be modified.
type EnvoyFilter_Patch struct {
	// Determines how the patch should be applied.
	Operation EnvoyFilter_Patch_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Patch_Operation" json:"operation,omitempty"`
	// The JSON config of the object being patched. This will be merged using
	// json merge semantics with the existing proto in the path.
	Value                *types.Struct `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EnvoyFilter_Patch) Reset()         { *m = EnvoyFilter_Patch{} }
func (m *EnvoyFilter_Patch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_Patch) ProtoMessage()    {}
func (*EnvoyFilter_Patch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 7}
}
func (m *EnvoyFilter_Patch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_Patch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_Patch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_Patch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_Patch.Merge(m, src)
}
func (m *EnvoyFilter_Patch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_Patch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_Patch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_Patch proto.InternalMessageInfo

func (m *EnvoyFilter_Patch) GetOperation() EnvoyFilter_Patch_Operation {
	if m != nil {
		return m.Operation
	}
	return EnvoyFilter_Patch_INVALID
}

func (m *EnvoyFilter_Patch) GetValue() *types.Struct {
	if m != nil {
		return m.Value
	}
	return nil
}

// One or more match conditions to be met before a patch is applied
// to the generated configuration for a given proxy.
type EnvoyFilter_EnvoyConfigObjectMatch struct {
	// The specific config generation context to match on. Istio Pilot
	// generates envoy configuration in the context of a gateway,
	// inbound traffic to sidecar and outbound traffic from sidecar.
	Context EnvoyFilter_PatchContext `protobuf:"varint,1,opt,name=context,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_PatchContext" json:"context,omitempty"`
	// Match on properties associated with a proxy.
	Proxy *EnvoyFilter_ProxyMatch `protobuf:"bytes,2,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Types that are valid to be assigned to ObjectTypes:
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Listener
	//	*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Cluster
	ObjectTypes          isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes `protobuf_oneof:"object_types"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Reset()         { *m = EnvoyFilter_EnvoyConfigObjectMatch{} }
func (m *EnvoyFilter_EnvoyConfigObjectMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_EnvoyConfigObjectMatch) ProtoMessage()    {}
func (*EnvoyFilter_EnvoyConfigObjectMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 8}
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.Merge(m, src)
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch proto.InternalMessageInfo

type isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes interface {
	isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes()
	MarshalTo([]byte) (int, error)
	Size() int
}

type EnvoyFilter_EnvoyConfigObjectMatch_Listener struct {
	Listener *EnvoyFilter_ListenerMatch `protobuf:"bytes,3,opt,name=listener,proto3,oneof"`
}
type EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration struct {
	RouteConfiguration *EnvoyFilter_RouteConfigurationMatch `protobuf:"bytes,4,opt,name=route_configuration,json=routeConfiguration,proto3,oneof"`
}
type EnvoyFilter_EnvoyConfigObjectMatch_Cluster struct {
	Cluster *EnvoyFilter_ClusterMatch `protobuf:"bytes,5,opt,name=cluster,proto3,oneof"`
}

func (*EnvoyFilter_EnvoyConfigObjectMatch_Listener) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}
func (*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}
func (*EnvoyFilter_EnvoyConfigObjectMatch_Cluster) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetObjectTypes() isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes {
	if m != nil {
		return m.ObjectTypes
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetContext() EnvoyFilter_PatchContext {
	if m != nil {
		return m.Context
	}
	return EnvoyFilter_ANY
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetProxy() *EnvoyFilter_ProxyMatch {
	if m != nil {
		return m.Proxy
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetListener() *EnvoyFilter_ListenerMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_Listener); ok {
		return x.Listener
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetRouteConfiguration() *EnvoyFilter_RouteConfigurationMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration); ok {
		return x.RouteConfiguration
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetCluster() *EnvoyFilter_ClusterMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster); ok {
		return x.Cluster
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*EnvoyFilter_EnvoyConfigObjectMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _EnvoyFilter_EnvoyConfigObjectMatch_OneofMarshaler, _EnvoyFilter_EnvoyConfigObjectMatch_OneofUnmarshaler, _EnvoyFilter_EnvoyConfigObjectMatch_OneofSizer, []interface{}{
		(*EnvoyFilter_EnvoyConfigObjectMatch_Listener)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster)(nil),
	}
}

func _EnvoyFilter_EnvoyConfigObjectMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*EnvoyFilter_EnvoyConfigObjectMatch)
	// object_types
	switch x := m.ObjectTypes.(type) {
	case *EnvoyFilter_EnvoyConfigObjectMatch_Listener:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Listener); err != nil {
			return err
		}
	case *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RouteConfiguration); err != nil {
			return err
		}
	case *EnvoyFilter_EnvoyConfigObjectMatch_Cluster:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cluster); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("EnvoyFilter_EnvoyConfigObjectMatch.ObjectTypes has unexpected type %T", x)
	}
	return nil
}

func _EnvoyFilter_EnvoyConfigObjectMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*EnvoyFilter_EnvoyConfigObjectMatch)
	switch tag {
	case 3: // object_types.listener
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EnvoyFilter_ListenerMatch)
		err := b.DecodeMessage(msg)
		m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Listener{msg}
		return true, err
	case 4: // object_types.route_configuration
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EnvoyFilter_RouteConfigurationMatch)
		err := b.DecodeMessage(msg)
		m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration{msg}
		return true, err
	case 5: // object_types.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EnvoyFilter_ClusterMatch)
		err := b.DecodeMessage(msg)
		m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Cluster{msg}
		return true, err
	default:
		return false, nil
	}
}

func _EnvoyFilter_EnvoyConfigObjectMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*EnvoyFilter_EnvoyConfigObjectMatch)
	// object_types
	switch x := m.ObjectTypes.(type) {
	case *EnvoyFilter_EnvoyConfigObjectMatch_Listener:
		s := proto.Size(x.Listener)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration:
		s := proto.Size(x.RouteConfiguration)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *EnvoyFilter_EnvoyConfigObjectMatch_Cluster:
		s := proto.Size(x.Cluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Changes to be made to various envoy config objects.
type EnvoyFilter_EnvoyConfigObjectPatch struct {
	// Specifies where in the Envoy configuration, the patch should be
	// applied.  The match is expected to select the appropriate
	// object based on applyTo.  For example, an applyTo with
	// HTTP_FILTER is expected to have a match condition on the
	// listeners, with a network filter selection on
	// envoy.http_connection_manager and a sub filter selection on the
	// HTTP filter relative to which the insertion should be
	// performed. Similarly, an applyTo on CLUSTER should have a match
	// (if provided) on the cluster and not on a listener.
	ApplyTo EnvoyFilter_ApplyTo `protobuf:"varint,1,opt,name=apply_to,json=applyTo,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_ApplyTo" json:"apply_to,omitempty"`
	// Match on listener/route configuration/cluster.
	Match *EnvoyFilter_EnvoyConfigObjectMatch `protobuf:"bytes,2,opt,name=match,proto3" json:"match,omitempty"`
	// The patch to apply along with the operation.
	Patch                *EnvoyFilter_Patch `protobuf:"bytes,3,opt,name=patch,proto3" json:"patch,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) Reset()         { *m = EnvoyFilter_EnvoyConfigObjectPatch{} }
func (m *EnvoyFilter_EnvoyConfigObjectPatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_EnvoyConfigObjectPatch) ProtoMessage()    {}
func (*EnvoyFilter_EnvoyConfigObjectPatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 9}
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.Merge(m, src)
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch proto.InternalMessageInfo

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetApplyTo() EnvoyFilter_ApplyTo {
	if m != nil {
		return m.ApplyTo
	}
	return EnvoyFilter_INVALID
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetMatch() *EnvoyFilter_EnvoyConfigObjectMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetPatch() *EnvoyFilter_Patch {
	if m != nil {
		return m.Patch
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_ApplyTo", EnvoyFilter_ApplyTo_name, EnvoyFilter_ApplyTo_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_PatchContext", EnvoyFilter_PatchContext_name, EnvoyFilter_PatchContext_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_DeprecatedListenerMatch_ListenerType", EnvoyFilter_DeprecatedListenerMatch_ListenerType_name, EnvoyFilter_DeprecatedListenerMatch_ListenerType_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol", EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol_name, EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_InsertPosition_Index", EnvoyFilter_InsertPosition_Index_name, EnvoyFilter_InsertPosition_Index_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_Filter_FilterType", EnvoyFilter_Filter_FilterType_name, EnvoyFilter_Filter_FilterType_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action", EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name, EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_Patch_Operation", EnvoyFilter_Patch_Operation_name, EnvoyFilter_Patch_Operation_value)
	proto.RegisterType((*EnvoyFilter)(nil), "istio.networking.v1alpha3.EnvoyFilter")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.EnvoyFilter.WorkloadLabelsEntry")
	proto.RegisterType((*EnvoyFilter_DeprecatedListenerMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.DeprecatedListenerMatch")
	proto.RegisterType((*EnvoyFilter_InsertPosition)(nil), "istio.networking.v1alpha3.EnvoyFilter.InsertPosition")
	proto.RegisterType((*EnvoyFilter_Filter)(nil), "istio.networking.v1alpha3.EnvoyFilter.Filter")
	proto.RegisterType((*EnvoyFilter_ProxyMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ProxyMatch")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.MetadataEntry")
	proto.RegisterType((*EnvoyFilter_ClusterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ClusterMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch_RouteMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_FilterChainMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_FilterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_SubFilterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.SubFilterMatch")
	proto.RegisterType((*EnvoyFilter_Patch)(nil), "istio.networking.v1alpha3.EnvoyFilter.Patch")
	proto.RegisterType((*EnvoyFilter_EnvoyConfigObjectMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch")
	proto.RegisterType((*EnvoyFilter_EnvoyConfigObjectPatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch")
}

func init() {
	proto.RegisterFile("networking/v1alpha3/envoy_filter.proto", fileDescriptor_16d9b2922bd3e4a9)
}

var fileDescriptor_16d9b2922bd3e4a9 = []byte{
	// 1594 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcd, 0x6f, 0xdb, 0x46,
	0x16, 0x37, 0x25, 0x51, 0x1f, 0x4f, 0x1f, 0xa6, 0xc7, 0xd9, 0x58, 0xcb, 0x5d, 0x64, 0x1d, 0xed,
	0x62, 0x61, 0xa0, 0x0d, 0xdd, 0xd8, 0x6d, 0x11, 0x24, 0x6d, 0x52, 0x59, 0xa6, 0x6d, 0x22, 0xb2,
	0xa4, 0x8e, 0x68, 0xa7, 0x69, 0xd1, 0x12, 0x94, 0x34, 0xb6, 0xd9, 0xd0, 0xa2, 0x4a, 0x52, 0xb6,
	0x05, 0xf4, 0x5a, 0xf4, 0x0f, 0xe9, 0x5f, 0x51, 0xf4, 0xda, 0x43, 0x81, 0x5e, 0x7a, 0xec, 0xb1,
	0xc8, 0xb5, 0x87, 0x02, 0x39, 0xf4, 0xd4, 0x43, 0x31, 0x1f, 0xa4, 0x25, 0x47, 0x09, 0x64, 0x3b,
	0x27, 0xcd, 0xbc, 0x99, 0xf7, 0x9b, 0xdf, 0x9b, 0xf7, 0x31, 0x8f, 0x82, 0xff, 0xf7, 0x49, 0x78,
	0xea, 0xf9, 0xcf, 0x9c, 0xfe, 0xe1, 0xea, 0xc9, 0x5d, 0xdb, 0x1d, 0x1c, 0xd9, 0xeb, 0xab, 0xa4,
	0x7f, 0xe2, 0x8d, 0xac, 0x03, 0xc7, 0x0d, 0x89, 0xaf, 0x0d, 0x7c, 0x2f, 0xf4, 0xd0, 0x3f, 0x9d,
	0x20, 0x74, 0x3c, 0xed, 0x7c, 0xb7, 0x16, 0xed, 0x56, 0xff, 0x7d, 0xe8, 0x79, 0x87, 0x2e, 0x59,
	0x65, 0x1b, 0x3b, 0xc3, 0x83, 0xd5, 0x20, 0xf4, 0x87, 0xdd, 0x90, 0x2b, 0xaa, 0xb7, 0xa7, 0x1d,
	0x10, 0x38, 0x3d, 0xd2, 0xb5, 0x05, 0x76, 0xe5, 0xc5, 0x6d, 0xc8, 0xeb, 0xf4, 0xc8, 0x2d, 0x76,
	0x22, 0x3a, 0x84, 0x79, 0xaa, 0xe1, 0x7a, 0x76, 0xcf, 0x72, 0xed, 0x0e, 0x71, 0x83, 0xb2, 0xb4,
	0x9c, 0x5c, 0xc9, 0xaf, 0xdd, 0xd7, 0x5e, 0xc9, 0x42, 0x1b, 0x03, 0xd0, 0x9e, 0x08, 0xed, 0x3a,
	0x53, 0xd6, 0xfb, 0xa1, 0x3f, 0xda, 0x48, 0x94, 0x25, 0x5c, 0x3a, 0x9d, 0x58, 0x40, 0x8f, 0x21,
	0xc3, 0x8d, 0x0c, 0xca, 0x09, 0x76, 0xc0, 0x9d, 0x19, 0x0f, 0xe0, 0x3f, 0x0c, 0x33, 0x42, 0x40,
	0x9f, 0xc0, 0x42, 0xcc, 0x3a, 0x20, 0x2e, 0xe9, 0x86, 0x9e, 0x5f, 0x4e, 0x2e, 0x4b, 0x2b, 0xf9,
	0xb5, 0xb7, 0x5e, 0x03, 0x1b, 0x71, 0x6d, 0x0b, 0x15, 0xac, 0x9c, 0x5e, 0x90, 0xa0, 0x1e, 0x94,
	0xba, 0x5e, 0xff, 0xc0, 0x39, 0xb4, 0x06, 0x76, 0xd8, 0x3d, 0x22, 0x41, 0x39, 0xc5, 0xd8, 0x7e,
	0x38, 0x23, 0x5b, 0x36, 0xae, 0x31, 0x84, 0x66, 0xe7, 0x4b, 0xd2, 0x0d, 0x5b, 0x14, 0x06, 0x17,
	0x39, 0x68, 0x8b, 0x63, 0xaa, 0x7f, 0x24, 0x61, 0x69, 0x93, 0x0c, 0x7c, 0xd2, 0xb5, 0x43, 0xd2,
	0xab, 0x3b, 0x41, 0x48, 0xfa, 0xc4, 0xdf, 0xa5, 0xab, 0xe8, 0x3f, 0x90, 0x1f, 0x78, 0x7e, 0x68,
	0xf5, 0x87, 0xc7, 0x1d, 0xe2, 0x97, 0xa5, 0x65, 0x69, 0xa5, 0x88, 0x81, 0x8a, 0x1a, 0x4c, 0x82,
	0x56, 0x40, 0xe1, 0x1b, 0xec, 0x63, 0x62, 0x0d, 0x7c, 0x72, 0xe0, 0x9c, 0x95, 0x13, 0xcb, 0xd2,
	0x4a, 0x0e, 0x97, 0xd8, 0x2e, 0xfb, 0x98, 0xb4, 0x98, 0x14, 0x0d, 0xa0, 0xe8, 0x0a, 0x6c, 0x2b,
	0x1c, 0x0d, 0x08, 0xbb, 0xa2, 0xd2, 0xda, 0xe3, 0x19, 0x6d, 0x79, 0x05, 0x43, 0x2d, 0x9a, 0x99,
	0xa3, 0x01, 0xc1, 0x05, 0x77, 0x6c, 0x86, 0xbe, 0x86, 0x85, 0xf8, 0x44, 0x16, 0x70, 0x5d, 0xcf,
	0x2d, 0xa7, 0xd8, 0xa9, 0xcd, 0x37, 0x74, 0x6a, 0x4b, 0xc0, 0x62, 0xc5, 0xbd, 0x20, 0x41, 0x65,
	0xc8, 0xd8, 0xbd, 0x9e, 0x4f, 0x82, 0xa0, 0x2c, 0x2f, 0x27, 0x57, 0x72, 0x38, 0x9a, 0x56, 0x9a,
	0x50, 0x18, 0x67, 0x8d, 0x32, 0x90, 0xac, 0x36, 0x9e, 0x2a, 0x73, 0x68, 0x11, 0xe6, 0xdb, 0xc6,
	0xa6, 0x5e, 0xab, 0x62, 0xcb, 0x68, 0x6c, 0x34, 0xf7, 0x1a, 0x9b, 0x8a, 0x84, 0x6e, 0x80, 0x12,
	0x09, 0x9b, 0x7b, 0x26, 0x97, 0x26, 0x50, 0x1e, 0x32, 0xdb, 0x55, 0x53, 0x7f, 0x52, 0x7d, 0xaa,
	0x24, 0x2b, 0x1a, 0x28, 0x17, 0x09, 0x31, 0xd0, 0x7a, 0x5d, 0x99, 0x43, 0x59, 0x48, 0xed, 0x98,
	0x66, 0x4b, 0x91, 0xa8, 0xc8, 0xac, 0xb5, 0x94, 0x84, 0xfa, 0xbd, 0x04, 0x25, 0xa3, 0x1f, 0x10,
	0x3f, 0x6c, 0x79, 0x81, 0x13, 0x3a, 0x5e, 0x1f, 0x7d, 0x0c, 0xb2, 0xd3, 0xef, 0x91, 0x33, 0xe6,
	0xe2, 0xd2, 0xda, 0x83, 0x19, 0xef, 0x67, 0x12, 0x45, 0x33, 0x28, 0x04, 0xe6, 0x48, 0x34, 0x76,
	0x7c, 0xe2, 0xda, 0xa1, 0x73, 0x42, 0xac, 0xd0, 0x13, 0x51, 0x01, 0x91, 0xc8, 0xf4, 0x2a, 0xeb,
	0x20, 0x33, 0x05, 0x94, 0x03, 0x79, 0xcb, 0xc0, 0x6d, 0x93, 0xb3, 0xad, 0x57, 0xdb, 0xa6, 0x22,
	0x21, 0x80, 0xf4, 0x86, 0xbe, 0xd5, 0xc4, 0xba, 0x92, 0xa0, 0x1b, 0xaa, 0x5b, 0xa6, 0x8e, 0x95,
	0xa4, 0xfa, 0x43, 0x12, 0xd2, 0xa2, 0x5c, 0x10, 0x28, 0xc5, 0xfe, 0x3d, 0xa6, 0x6e, 0x61, 0xe4,
	0xf3, 0x6b, 0x0f, 0xaf, 0xe7, 0x5c, 0x1c, 0xc7, 0x29, 0xcf, 0x81, 0x2f, 0x60, 0xde, 0x61, 0x66,
	0x5a, 0x03, 0x61, 0x27, 0xb3, 0x25, 0xbf, 0xf6, 0xde, 0x95, 0x2e, 0x09, 0x97, 0x9c, 0xc9, 0xab,
	0x7f, 0x0a, 0x79, 0x5e, 0x4a, 0xc6, 0xd3, 0xe2, 0xde, 0xa5, 0x0a, 0x92, 0xf8, 0x61, 0x39, 0x00,
	0x07, 0xf1, 0x98, 0xba, 0x40, 0x40, 0xd3, 0xfc, 0x64, 0xb1, 0x9f, 0x8b, 0x36, 0xd0, 0xd4, 0x44,
	0x1f, 0x40, 0x51, 0x6c, 0xe0, 0x35, 0xa1, 0x2c, 0x33, 0xcb, 0x96, 0x34, 0x5e, 0xda, 0xb5, 0xa8,
	0xb4, 0x6b, 0x6d, 0x56, 0xda, 0x71, 0x81, 0xef, 0xe6, 0x35, 0xa5, 0xf2, 0x0e, 0xc0, 0xf9, 0xc1,
	0x34, 0x24, 0x8d, 0xc6, 0x7e, 0xb5, 0x6e, 0x6c, 0x4e, 0x44, 0x5d, 0x1e, 0x32, 0x0d, 0xdd, 0x7c,
	0xd2, 0xc4, 0x8f, 0x95, 0x84, 0xfa, 0xb3, 0x04, 0xd0, 0xf2, 0xbd, 0xb3, 0x11, 0xbf, 0xda, 0xff,
	0x42, 0x71, 0x40, 0x67, 0xd6, 0x09, 0xf1, 0x03, 0x7a, 0xb1, 0x12, 0x63, 0x58, 0x60, 0xc2, 0x7d,
	0x2e, 0x43, 0x9f, 0x41, 0xf6, 0x98, 0x84, 0x76, 0xcf, 0x0e, 0x6d, 0x51, 0xad, 0x1f, 0xcd, 0x78,
	0x39, 0xe7, 0x27, 0x69, 0xbb, 0x02, 0x81, 0xbd, 0x09, 0x38, 0x06, 0x54, 0x1f, 0x40, 0x71, 0x62,
	0x09, 0x29, 0x90, 0x7c, 0x46, 0x46, 0x82, 0x08, 0x1d, 0xa2, 0x1b, 0x20, 0x9f, 0xd8, 0xee, 0x90,
	0x88, 0x08, 0xe6, 0x93, 0xfb, 0x89, 0x7b, 0x92, 0x3a, 0x84, 0x42, 0xcd, 0x1d, 0x06, 0xe1, 0xcc,
	0xd5, 0xb2, 0x0c, 0x99, 0x80, 0xf8, 0x27, 0x4e, 0x37, 0x02, 0x8b, 0xa6, 0xe8, 0x26, 0xa4, 0x83,
	0x61, 0x27, 0x20, 0x21, 0xf3, 0x7f, 0x0e, 0x8b, 0x19, 0x42, 0x90, 0x1a, 0x73, 0x1d, 0x1b, 0xab,
	0x3f, 0xa6, 0x60, 0x09, 0x7b, 0xc3, 0x90, 0x70, 0x37, 0x0c, 0x7d, 0x9b, 0xc6, 0xd1, 0x8c, 0x14,
	0xfe, 0x05, 0xb9, 0xb8, 0x60, 0x0b, 0x12, 0xd9, 0xa8, 0x52, 0x53, 0x7e, 0x87, 0x76, 0x48, 0x4e,
	0xed, 0x91, 0xa0, 0x11, 0x4d, 0x11, 0x01, 0xf9, 0xe4, 0xc8, 0x0b, 0x42, 0x46, 0x24, 0x3f, 0x73,
	0xfd, 0x7c, 0x05, 0x4d, 0x6d, 0xdf, 0xf1, 0xc3, 0xa1, 0xed, 0xee, 0x78, 0x41, 0xc8, 0x73, 0x8e,
	0xa3, 0xc7, 0xe6, 0xca, 0x63, 0xe6, 0xd2, 0x98, 0x61, 0x38, 0xdc, 0xc2, 0x68, 0x8b, 0x74, 0xbe,
	0x05, 0x1d, 0x41, 0xda, 0xee, 0xc6, 0x99, 0x59, 0x5a, 0x6b, 0x5d, 0x93, 0xde, 0xf9, 0x71, 0x5a,
	0x95, 0xe1, 0x62, 0x81, 0x5f, 0x79, 0x04, 0x69, 0x2e, 0x39, 0xaf, 0xda, 0x39, 0x90, 0x71, 0x73,
	0xcf, 0xd4, 0x15, 0x09, 0x15, 0x20, 0x8b, 0xf5, 0x4d, 0x03, 0xeb, 0x35, 0x53, 0x49, 0xd0, 0x72,
	0xce, 0xc7, 0x16, 0xd6, 0xdb, 0xad, 0x66, 0xa3, 0xad, 0x2b, 0x49, 0xf5, 0x5b, 0x09, 0x94, 0x8b,
	0xd6, 0x4f, 0xb5, 0xc9, 0x02, 0xd9, 0xa7, 0x34, 0x44, 0xb1, 0x31, 0xde, 0x98, 0x49, 0x98, 0xe3,
	0xaa, 0x2f, 0x52, 0x50, 0xbc, 0xe4, 0x6b, 0xff, 0xda, 0xe0, 0x39, 0x82, 0x42, 0x54, 0x4b, 0x8e,
	0x6c, 0xa7, 0x2f, 0x5a, 0x20, 0x7d, 0x46, 0xde, 0x93, 0xef, 0x2b, 0x17, 0xd6, 0x28, 0x0e, 0xe7,
	0x2c, 0xea, 0x18, 0x93, 0x4c, 0x4d, 0x8a, 0x3f, 0x25, 0x50, 0x2e, 0x6a, 0x4d, 0xbd, 0x57, 0x05,
	0x92, 0x41, 0xdf, 0x11, 0xec, 0xe9, 0x10, 0xdd, 0x01, 0x14, 0xfa, 0x76, 0x3f, 0x60, 0xa6, 0xc5,
	0x8d, 0x02, 0x4f, 0x80, 0x85, 0x78, 0x25, 0x7e, 0x59, 0xd7, 0xe1, 0x1f, 0xf6, 0x60, 0xe0, 0x3a,
	0x5d, 0x76, 0xbb, 0xb1, 0x42, 0x20, 0xe8, 0xdc, 0x18, 0x5b, 0x8c, 0x74, 0x68, 0x93, 0x98, 0xe6,
	0x16, 0x88, 0x0a, 0xfb, 0xd1, 0x35, 0xae, 0x85, 0xdf, 0x88, 0xc0, 0x53, 0xbf, 0x91, 0x20, 0x3f,
	0x26, 0x9f, 0x6a, 0x73, 0x07, 0x20, 0x18, 0x76, 0x44, 0x63, 0x2f, 0x02, 0xaa, 0x76, 0x25, 0x06,
	0xed, 0x61, 0x67, 0x9c, 0x44, 0x2e, 0x88, 0xe6, 0xea, 0xff, 0xa0, 0x34, 0xb9, 0x38, 0x8d, 0x89,
	0xfa, 0xbb, 0x04, 0x32, 0x6b, 0x3c, 0x91, 0x09, 0x39, 0x6f, 0x40, 0x78, 0x88, 0x8a, 0xae, 0xe3,
	0xfd, 0x59, 0xeb, 0x3a, 0xa3, 0xd2, 0x8c, 0xb4, 0xf1, 0x39, 0x10, 0xba, 0x33, 0x5e, 0xac, 0x5f,
	0xf3, 0x90, 0xf1, 0x5d, 0x95, 0xcf, 0x21, 0x17, 0xc3, 0x4c, 0x3e, 0x60, 0x39, 0x90, 0x77, 0x75,
	0xbc, 0xad, 0xf3, 0xbe, 0xa9, 0xba, 0x49, 0x9b, 0x2e, 0x80, 0x34, 0xd6, 0x77, 0x9b, 0xfb, 0xba,
	0x92, 0x44, 0x0b, 0x50, 0x34, 0x1a, 0x6d, 0x1d, 0x9b, 0x96, 0xe8, 0x52, 0x52, 0x48, 0x81, 0x82,
	0x10, 0xf1, 0x66, 0x45, 0x56, 0x7f, 0x4d, 0xc2, 0xcd, 0x97, 0x9a, 0x70, 0x7e, 0x39, 0xbb, 0x90,
	0xe9, 0x7a, 0xfd, 0x90, 0x9c, 0x85, 0xc2, 0xf8, 0xf5, 0xcb, 0x18, 0x5f, 0xe3, 0xaa, 0x38, 0xc2,
	0x40, 0xdb, 0x20, 0xb3, 0x47, 0x53, 0xd8, 0x7d, 0xf7, 0xd2, 0x2f, 0x24, 0xe6, 0xfa, 0x08, 0x43,
	0x36, 0x6a, 0x7f, 0x44, 0x06, 0xbf, 0x7b, 0x95, 0x40, 0xd9, 0x99, 0xc3, 0x31, 0x0e, 0xfa, 0x0a,
	0x16, 0x59, 0xc9, 0x11, 0x4d, 0x86, 0xa8, 0x4b, 0xe2, 0x29, 0x79, 0x78, 0xbd, 0xc2, 0xb6, 0x33,
	0x87, 0x91, 0xff, 0xd2, 0x12, 0x6a, 0x42, 0xa6, 0xcb, 0x9f, 0x66, 0x91, 0x70, 0xb3, 0x5e, 0xef,
	0xf8, 0x83, 0xbe, 0x33, 0x87, 0x23, 0x94, 0x8d, 0x12, 0x14, 0x3c, 0xe6, 0x3e, 0xd6, 0xa5, 0x05,
	0xea, 0x5f, 0xd2, 0x14, 0xd7, 0xf2, 0xc8, 0x36, 0x20, 0x4b, 0x6b, 0xc0, 0x88, 0x76, 0xbd, 0xdc,
	0xb7, 0xda, 0x8c, 0x87, 0x57, 0xa9, 0x9a, 0xe9, 0xe1, 0x8c, 0xcd, 0x07, 0xa8, 0x0d, 0x32, 0xef,
	0x6c, 0xb9, 0x5b, 0xaf, 0xfc, 0xe1, 0x27, 0x5c, 0xcc, 0xb0, 0xd0, 0x06, 0xc8, 0xec, 0x7b, 0x52,
	0xf8, 0xf7, 0xed, 0xcb, 0x04, 0x1e, 0xe6, 0xaa, 0x6a, 0x15, 0x16, 0xa7, 0x7c, 0x6c, 0x5f, 0xa6,
	0x7b, 0xaa, 0x7c, 0x27, 0x41, 0x46, 0x18, 0x3c, 0x99, 0x7a, 0x05, 0xc8, 0xd6, 0x8d, 0xb6, 0xa9,
	0x37, 0x74, 0xac, 0x48, 0x34, 0xab, 0xb6, 0x8c, 0xba, 0xa9, 0x63, 0xab, 0xb6, 0x53, 0x35, 0x1a,
	0x4a, 0x02, 0x21, 0x28, 0x89, 0x8e, 0xd2, 0xe2, 0x2b, 0x4a, 0x12, 0xcd, 0x43, 0x9e, 0xf6, 0x9b,
	0x91, 0x20, 0x85, 0x96, 0x60, 0x91, 0xbd, 0xca, 0x56, 0xad, 0xd9, 0xd8, 0x32, 0xb6, 0xf7, 0x70,
	0xd5, 0x34, 0x9a, 0x0d, 0x45, 0xa6, 0x78, 0xfb, 0x06, 0x36, 0xf7, 0xaa, 0x75, 0x6b, 0xa7, 0xd9,
	0x36, 0x95, 0x34, 0x2a, 0x01, 0x30, 0x5d, 0xfe, 0x8a, 0x67, 0x28, 0x99, 0x5a, 0x7d, 0xaf, 0x4d,
	0x71, 0xb2, 0xf4, 0x63, 0x6d, 0x3c, 0xe3, 0xae, 0xfd, 0xb1, 0xb6, 0xa1, 0xfd, 0xf4, 0xfc, 0x96,
	0xf4, 0xcb, 0xf3, 0x5b, 0xd2, 0x6f, 0xcf, 0x6f, 0x49, 0x9f, 0x2e, 0xf3, 0xbb, 0x77, 0xbc, 0x55,
	0x7b, 0xe0, 0xac, 0x4e, 0xf9, 0xcb, 0xa4, 0x93, 0x66, 0xa5, 0x6b, 0xfd, 0xef, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x19, 0x44, 0x3b, 0xe4, 0xb1, 0x11, 0x00, 0x00,
}

func (m *EnvoyFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ConfigPatches) > 0 {
		for iNdEx := len(m.ConfigPatches) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ConfigPatches[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.WorkloadSelector != nil {
		{
			size, err := m.WorkloadSelector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Filters) > 0 {
		for iNdEx := len(m.Filters) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Filters[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.WorkloadLabels) > 0 {
		for k := range m.WorkloadLabels {
			v := m.WorkloadLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_DeprecatedListenerMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_DeprecatedListenerMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_DeprecatedListenerMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Address) > 0 {
		for iNdEx := len(m.Address) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Address[iNdEx])
			copy(dAtA[i:], m.Address[iNdEx])
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Address[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.ListenerProtocol != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ListenerProtocol))
		i--
		dAtA[i] = 0x20
	}
	if m.ListenerType != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ListenerType))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PortNamePrefix) > 0 {
		i -= len(m.PortNamePrefix)
		copy(dAtA[i:], m.PortNamePrefix)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortNamePrefix)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_InsertPosition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_InsertPosition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_InsertPosition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RelativeTo) > 0 {
		i -= len(m.RelativeTo)
		copy(dAtA[i:], m.RelativeTo)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.RelativeTo)))
		i--
		dAtA[i] = 0x12
	}
	if m.Index != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_Filter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_Filter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FilterConfig != nil {
		{
			size, err := m.FilterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.FilterName) > 0 {
		i -= len(m.FilterName)
		copy(dAtA[i:], m.FilterName)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.FilterName)))
		i--
		dAtA[i] = 0x22
	}
	if m.FilterType != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.FilterType))
		i--
		dAtA[i] = 0x18
	}
	if m.InsertPosition != nil {
		{
			size, err := m.InsertPosition.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ListenerMatch != nil {
		{
			size, err := m.ListenerMatch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ProxyMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ProxyMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ProxyMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metadata) > 0 {
		for k := range m.Metadata {
			v := m.Metadata[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ProxyVersion) > 0 {
		i -= len(m.ProxyVersion)
		copy(dAtA[i:], m.ProxyVersion)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.ProxyVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ClusterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ClusterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ClusterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Subset) > 0 {
		i -= len(m.Subset)
		copy(dAtA[i:], m.Subset)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Subset)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Vhost != nil {
		{
			size, err := m.Vhost.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Gateway) > 0 {
		i -= len(m.Gateway)
		copy(dAtA[i:], m.Gateway)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Gateway)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PortName) > 0 {
		i -= len(m.PortName)
		copy(dAtA[i:], m.PortName)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortName)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Action != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Route != nil {
		{
			size, err := m.Route.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if m.FilterChain != nil {
		{
			size, err := m.FilterChain.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PortName) > 0 {
		i -= len(m.PortName)
		copy(dAtA[i:], m.PortName)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortName)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ApplicationProtocols) > 0 {
		i -= len(m.ApplicationProtocols)
		copy(dAtA[i:], m.ApplicationProtocols)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.ApplicationProtocols)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.TransportProtocol) > 0 {
		i -= len(m.TransportProtocol)
		copy(dAtA[i:], m.TransportProtocol)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.TransportProtocol)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Sni) > 0 {
		i -= len(m.Sni)
		copy(dAtA[i:], m.Sni)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Sni)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SubFilter != nil {
		{
			size, err := m.SubFilter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_Patch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_Patch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_Patch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Operation != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Operation))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ObjectTypes != nil {
		{
			size := m.ObjectTypes.Size()
			i -= size
			if _, err := m.ObjectTypes.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Proxy != nil {
		{
			size, err := m.Proxy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Context != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Context))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Listener != nil {
		{
			size, err := m.Listener.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.RouteConfiguration != nil {
		{
			size, err := m.RouteConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Cluster != nil {
		{
			size, err := m.Cluster.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Patch != nil {
		{
			size, err := m.Patch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Match != nil {
		{
			size, err := m.Match.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ApplyTo != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ApplyTo))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintEnvoyFilter(dAtA []byte, offset int, v uint64) int {
	offset -= sovEnvoyFilter(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *EnvoyFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.WorkloadLabels) > 0 {
		for k, v := range m.WorkloadLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovEnvoyFilter(uint64(len(k))) + 1 + len(v) + sovEnvoyFilter(uint64(len(v)))
			n += mapEntrySize + 1 + sovEnvoyFilter(uint64(mapEntrySize))
		}
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.WorkloadSelector != nil {
		l = m.WorkloadSelector.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if len(m.ConfigPatches) > 0 {
		for _, e := range m.ConfigPatches {
			l = e.Size()
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_DeprecatedListenerMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortNamePrefix)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.ListenerType != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ListenerType))
	}
	if m.ListenerProtocol != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ListenerProtocol))
	}
	if len(m.Address) > 0 {
		for _, s := range m.Address {
			l = len(s)
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_InsertPosition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Index))
	}
	l = len(m.RelativeTo)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_Filter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListenerMatch != nil {
		l = m.ListenerMatch.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.InsertPosition != nil {
		l = m.InsertPosition.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterType != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.FilterType))
	}
	l = len(m.FilterName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterConfig != nil {
		l = m.FilterConfig.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ProxyMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProxyVersion)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovEnvoyFilter(uint64(len(k))) + 1 + len(v) + sovEnvoyFilter(uint64(len(v)))
			n += mapEntrySize + 1 + sovEnvoyFilter(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ClusterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Subset)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Vhost != nil {
		l = m.Vhost.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Action))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Route != nil {
		l = m.Route.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterChain != nil {
		l = m.FilterChain.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.TransportProtocol)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.ApplicationProtocols)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.SubFilter != nil {
		l = m.SubFilter.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_Patch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operation != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Operation))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Context))
	}
	if m.Proxy != nil {
		l = m.Proxy.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.ObjectTypes != nil {
		n += m.ObjectTypes.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Listener != nil {
		l = m.Listener.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RouteConfiguration != nil {
		l = m.RouteConfiguration.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ApplyTo != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ApplyTo))
	}
	if m.Match != nil {
		l = m.Match.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Patch != nil {
		l = m.Patch.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEnvoyFilter(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEnvoyFilter(x uint64) (n int) {
	return sovEnvoyFilter(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EnvoyFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkloadLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkloadLabels == nil {
				m.WorkloadLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.WorkloadLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &EnvoyFilter_Filter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkloadSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkloadSelector == nil {
				m.WorkloadSelector = &WorkloadSelector{}
			}
			if err := m.WorkloadSelector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigPatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigPatches = append(m.ConfigPatches, &EnvoyFilter_EnvoyConfigObjectPatch{})
			if err := m.ConfigPatches[len(m.ConfigPatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_DeprecatedListenerMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedListenerMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedListenerMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNamePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortNamePrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerType", wireType)
			}
			m.ListenerType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ListenerType |= EnvoyFilter_DeprecatedListenerMatch_ListenerType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerProtocol", wireType)
			}
			m.ListenerProtocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ListenerProtocol |= EnvoyFilter_DeprecatedListenerMatch_ListenerProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = append(m.Address, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_InsertPosition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InsertPosition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InsertPosition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= EnvoyFilter_InsertPosition_Index(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelativeTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RelativeTo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListenerMatch == nil {
				m.ListenerMatch = &EnvoyFilter_DeprecatedListenerMatch{}
			}
			if err := m.ListenerMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InsertPosition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InsertPosition == nil {
				m.InsertPosition = &EnvoyFilter_InsertPosition{}
			}
			if err := m.InsertPosition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterType", wireType)
			}
			m.FilterType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilterType |= EnvoyFilter_Filter_FilterType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterConfig == nil {
				m.FilterConfig = &types.Struct{}
			}
			if err := m.FilterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ProxyMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ClusterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subset", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subset = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteConfigurationMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteConfigurationMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vhost", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Vhost == nil {
				m.Vhost = &EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch{}
			}
			if err := m.Vhost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualHostMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualHostMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Route == nil {
				m.Route = &EnvoyFilter_RouteConfigurationMatch_RouteMatch{}
			}
			if err := m.Route.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenerMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenerMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterChain == nil {
				m.FilterChain = &EnvoyFilter_ListenerMatch_FilterChainMatch{}
			}
			if err := m.FilterChain.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChainMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChainMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TransportProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationProtocols = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = &EnvoyFilter_ListenerMatch_FilterMatch{}
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SubFilter == nil {
				m.SubFilter = &EnvoyFilter_ListenerMatch_SubFilterMatch{}
			}
			if err := m.SubFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubFilterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubFilterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_Patch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Patch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Patch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= EnvoyFilter_Patch_Operation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &types.Struct{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyConfigObjectMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyConfigObjectMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			m.Context = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Context |= EnvoyFilter_PatchContext(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proxy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Proxy == nil {
				m.Proxy = &EnvoyFilter_ProxyMatch{}
			}
			if err := m.Proxy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listener", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_ListenerMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Listener{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_RouteConfigurationMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_ClusterMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Cluster{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyConfigObjectPatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyConfigObjectPatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyTo", wireType)
			}
			m.ApplyTo = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyTo |= EnvoyFilter_ApplyTo(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Match == nil {
				m.Match = &EnvoyFilter_EnvoyConfigObjectMatch{}
			}
			if err := m.Match.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Patch == nil {
				m.Patch = &EnvoyFilter_Patch{}
			}
			if err := m.Patch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEnvoyFilter(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipEnvoyFilter(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthEnvoyFilter
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthEnvoyFilter = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEnvoyFilter   = fmt.Errorf("proto: integer overflow")
)
