// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesh/v1alpha1/proxy.proto

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// AuthenticationPolicy defines authentication policy. It can be set for
// different scopes (mesh, service …), and the most narrow scope with
// non-INHERIT value will be used.
// Mesh policy cannot be INHERIT.
type AuthenticationPolicy int32

const (
	// Do not encrypt Envoy to Envoy traffic.
	AuthenticationPolicy_NONE AuthenticationPolicy = 0
	// Envoy to Envoy traffic is wrapped into mutual TLS connections.
	AuthenticationPolicy_MUTUAL_TLS AuthenticationPolicy = 1
	// Use the policy defined by the parent scope. Should not be used for mesh
	// policy.
	AuthenticationPolicy_INHERIT AuthenticationPolicy = 1000
)

var AuthenticationPolicy_name = map[int32]string{
	0:    "NONE",
	1:    "MUTUAL_TLS",
	1000: "INHERIT",
}

var AuthenticationPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
	"INHERIT":    1000,
}

func (x AuthenticationPolicy) String() string {
	return proto.EnumName(AuthenticationPolicy_name, int32(x))
}

func (AuthenticationPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0}
}

// The mode used to redirect inbound traffic to Envoy.
// This setting has no effect on outbound traffic: iptables REDIRECT is always used for
// outbound connections.
type ProxyConfig_InboundInterceptionMode int32

const (
	// The REDIRECT mode uses iptables REDIRECT to NAT and redirect to Envoy. This mode loses
	// source IP addresses during redirection.
	ProxyConfig_REDIRECT ProxyConfig_InboundInterceptionMode = 0
	// The TPROXY mode uses iptables TPROXY to redirect to Envoy. This mode preserves both the
	// source and destination IP addresses and ports, so that they can be used for advanced
	// filtering and manipulation. This mode also configures the sidecar to run with the
	// CAP_NET_ADMIN capability, which is required to use TPROXY.
	ProxyConfig_TPROXY ProxyConfig_InboundInterceptionMode = 1
)

var ProxyConfig_InboundInterceptionMode_name = map[int32]string{
	0: "REDIRECT",
	1: "TPROXY",
}

var ProxyConfig_InboundInterceptionMode_value = map[string]int32{
	"REDIRECT": 0,
	"TPROXY":   1,
}

func (x ProxyConfig_InboundInterceptionMode) String() string {
	return proto.EnumName(ProxyConfig_InboundInterceptionMode_name, int32(x))
}

func (ProxyConfig_InboundInterceptionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{2, 0}
}

// Tracing defines configuration for the tracing performed by Envoy instances.
type Tracing struct {
	// The tracer implementation to be used by Envoy.
	//
	// Types that are valid to be assigned to Tracer:
	//	*Tracing_Zipkin_
	//	*Tracing_Lightstep_
	//	*Tracing_Datadog_
	//	*Tracing_Stackdriver_
	Tracer               isTracing_Tracer `protobuf_oneof:"tracer"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Tracing) Reset()         { *m = Tracing{} }
func (m *Tracing) String() string { return proto.CompactTextString(m) }
func (*Tracing) ProtoMessage()    {}
func (*Tracing) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0}
}
func (m *Tracing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing.Merge(m, src)
}
func (m *Tracing) XXX_Size() int {
	return m.Size()
}
func (m *Tracing) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing proto.InternalMessageInfo

type isTracing_Tracer interface {
	isTracing_Tracer()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Tracing_Zipkin_ struct {
	Zipkin *Tracing_Zipkin `protobuf:"bytes,1,opt,name=zipkin,proto3,oneof"`
}
type Tracing_Lightstep_ struct {
	Lightstep *Tracing_Lightstep `protobuf:"bytes,2,opt,name=lightstep,proto3,oneof"`
}
type Tracing_Datadog_ struct {
	Datadog *Tracing_Datadog `protobuf:"bytes,3,opt,name=datadog,proto3,oneof"`
}
type Tracing_Stackdriver_ struct {
	Stackdriver *Tracing_Stackdriver `protobuf:"bytes,4,opt,name=stackdriver,proto3,oneof"`
}

func (*Tracing_Zipkin_) isTracing_Tracer()      {}
func (*Tracing_Lightstep_) isTracing_Tracer()   {}
func (*Tracing_Datadog_) isTracing_Tracer()     {}
func (*Tracing_Stackdriver_) isTracing_Tracer() {}

func (m *Tracing) GetTracer() isTracing_Tracer {
	if m != nil {
		return m.Tracer
	}
	return nil
}

func (m *Tracing) GetZipkin() *Tracing_Zipkin {
	if x, ok := m.GetTracer().(*Tracing_Zipkin_); ok {
		return x.Zipkin
	}
	return nil
}

func (m *Tracing) GetLightstep() *Tracing_Lightstep {
	if x, ok := m.GetTracer().(*Tracing_Lightstep_); ok {
		return x.Lightstep
	}
	return nil
}

func (m *Tracing) GetDatadog() *Tracing_Datadog {
	if x, ok := m.GetTracer().(*Tracing_Datadog_); ok {
		return x.Datadog
	}
	return nil
}

func (m *Tracing) GetStackdriver() *Tracing_Stackdriver {
	if x, ok := m.GetTracer().(*Tracing_Stackdriver_); ok {
		return x.Stackdriver
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Tracing) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Tracing_OneofMarshaler, _Tracing_OneofUnmarshaler, _Tracing_OneofSizer, []interface{}{
		(*Tracing_Zipkin_)(nil),
		(*Tracing_Lightstep_)(nil),
		(*Tracing_Datadog_)(nil),
		(*Tracing_Stackdriver_)(nil),
	}
}

func _Tracing_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Tracing)
	// tracer
	switch x := m.Tracer.(type) {
	case *Tracing_Zipkin_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Zipkin); err != nil {
			return err
		}
	case *Tracing_Lightstep_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Lightstep); err != nil {
			return err
		}
	case *Tracing_Datadog_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Datadog); err != nil {
			return err
		}
	case *Tracing_Stackdriver_:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Stackdriver); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Tracing.Tracer has unexpected type %T", x)
	}
	return nil
}

func _Tracing_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Tracing)
	switch tag {
	case 1: // tracer.zipkin
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Tracing_Zipkin)
		err := b.DecodeMessage(msg)
		m.Tracer = &Tracing_Zipkin_{msg}
		return true, err
	case 2: // tracer.lightstep
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Tracing_Lightstep)
		err := b.DecodeMessage(msg)
		m.Tracer = &Tracing_Lightstep_{msg}
		return true, err
	case 3: // tracer.datadog
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Tracing_Datadog)
		err := b.DecodeMessage(msg)
		m.Tracer = &Tracing_Datadog_{msg}
		return true, err
	case 4: // tracer.stackdriver
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Tracing_Stackdriver)
		err := b.DecodeMessage(msg)
		m.Tracer = &Tracing_Stackdriver_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Tracing_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Tracing)
	// tracer
	switch x := m.Tracer.(type) {
	case *Tracing_Zipkin_:
		s := proto.Size(x.Zipkin)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Tracing_Lightstep_:
		s := proto.Size(x.Lightstep)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Tracing_Datadog_:
		s := proto.Size(x.Datadog)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Tracing_Stackdriver_:
		s := proto.Size(x.Stackdriver)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Zipkin defines configuration for a Zipkin tracer.
type Tracing_Zipkin struct {
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Zipkin) Reset()         { *m = Tracing_Zipkin{} }
func (m *Tracing_Zipkin) String() string { return proto.CompactTextString(m) }
func (*Tracing_Zipkin) ProtoMessage()    {}
func (*Tracing_Zipkin) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 0}
}
func (m *Tracing_Zipkin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Zipkin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Zipkin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Zipkin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Zipkin.Merge(m, src)
}
func (m *Tracing_Zipkin) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Zipkin) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Zipkin.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Zipkin proto.InternalMessageInfo

func (m *Tracing_Zipkin) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// Defines configuration for a LightStep tracer.
type Tracing_Lightstep struct {
	// Address of the LightStep Satellite pool.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// The LightStep access token.
	AccessToken string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// True if a secure connection should be used when communicating with the pool.
	Secure bool `protobuf:"varint,3,opt,name=secure,proto3" json:"secure,omitempty"`
	// Path to the trusted cacert used to authenticate the pool.
	CacertPath           string   `protobuf:"bytes,4,opt,name=cacert_path,json=cacertPath,proto3" json:"cacert_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Lightstep) Reset()         { *m = Tracing_Lightstep{} }
func (m *Tracing_Lightstep) String() string { return proto.CompactTextString(m) }
func (*Tracing_Lightstep) ProtoMessage()    {}
func (*Tracing_Lightstep) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 1}
}
func (m *Tracing_Lightstep) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Lightstep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Lightstep.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Lightstep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Lightstep.Merge(m, src)
}
func (m *Tracing_Lightstep) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Lightstep) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Lightstep.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Lightstep proto.InternalMessageInfo

func (m *Tracing_Lightstep) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Tracing_Lightstep) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *Tracing_Lightstep) GetSecure() bool {
	if m != nil {
		return m.Secure
	}
	return false
}

func (m *Tracing_Lightstep) GetCacertPath() string {
	if m != nil {
		return m.CacertPath
	}
	return ""
}

// Datadog defines configuration for a Datadog tracer.
type Tracing_Datadog struct {
	// Address of the Datadog Agent.
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Datadog) Reset()         { *m = Tracing_Datadog{} }
func (m *Tracing_Datadog) String() string { return proto.CompactTextString(m) }
func (*Tracing_Datadog) ProtoMessage()    {}
func (*Tracing_Datadog) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 2}
}
func (m *Tracing_Datadog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Datadog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Datadog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Datadog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Datadog.Merge(m, src)
}
func (m *Tracing_Datadog) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Datadog) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Datadog.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Datadog proto.InternalMessageInfo

func (m *Tracing_Datadog) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// Stackdriver defines configuration for a Stackdriver tracer.
// See [Opencensus trace config](https://github.com/census-instrumentation/opencensus-proto/blob/master/src/opencensus/proto/trace/v1/trace_config.proto) for details.
type Tracing_Stackdriver struct {
	// debug enables trace output to stdout.
	// $hide_from_docs
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAttributes *types.Int64Value `protobuf:"bytes,2,opt,name=max_number_of_attributes,json=maxNumberOfAttributes,proto3" json:"max_number_of_attributes,omitempty"`
	// The global default max number of annotation events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAnnotations *types.Int64Value `protobuf:"bytes,3,opt,name=max_number_of_annotations,json=maxNumberOfAnnotations,proto3" json:"max_number_of_annotations,omitempty"`
	// The global default max number of message events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfMessageEvents *types.Int64Value `protobuf:"bytes,4,opt,name=max_number_of_message_events,json=maxNumberOfMessageEvents,proto3" json:"max_number_of_message_events,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}          `json:"-"`
	XXX_unrecognized         []byte            `json:"-"`
	XXX_sizecache            int32             `json:"-"`
}

func (m *Tracing_Stackdriver) Reset()         { *m = Tracing_Stackdriver{} }
func (m *Tracing_Stackdriver) String() string { return proto.CompactTextString(m) }
func (*Tracing_Stackdriver) ProtoMessage()    {}
func (*Tracing_Stackdriver) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 3}
}
func (m *Tracing_Stackdriver) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Stackdriver) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Stackdriver.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Stackdriver) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Stackdriver.Merge(m, src)
}
func (m *Tracing_Stackdriver) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Stackdriver) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Stackdriver.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Stackdriver proto.InternalMessageInfo

func (m *Tracing_Stackdriver) GetDebug() bool {
	if m != nil {
		return m.Debug
	}
	return false
}

func (m *Tracing_Stackdriver) GetMaxNumberOfAttributes() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAttributes
	}
	return nil
}

func (m *Tracing_Stackdriver) GetMaxNumberOfAnnotations() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAnnotations
	}
	return nil
}

func (m *Tracing_Stackdriver) GetMaxNumberOfMessageEvents() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfMessageEvents
	}
	return nil
}

// SDS defines secret discovery service(SDS) configuration to be used by the proxy.
// For workload, its values are set in sidecar injector(passed as arguments to istio-proxy container).
// For pilot/mixer, it's passed as arguments to istio-proxy container in pilot/mixer deployment yaml files directly.
type SDS struct {
	// True if SDS is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Path of k8s service account JWT path.
	K8SSaJwtPath         string   `protobuf:"bytes,2,opt,name=k8s_sa_jwt_path,json=k8sSaJwtPath,proto3" json:"k8s_sa_jwt_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SDS) Reset()         { *m = SDS{} }
func (m *SDS) String() string { return proto.CompactTextString(m) }
func (*SDS) ProtoMessage()    {}
func (*SDS) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{1}
}
func (m *SDS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SDS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SDS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SDS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SDS.Merge(m, src)
}
func (m *SDS) XXX_Size() int {
	return m.Size()
}
func (m *SDS) XXX_DiscardUnknown() {
	xxx_messageInfo_SDS.DiscardUnknown(m)
}

var xxx_messageInfo_SDS proto.InternalMessageInfo

func (m *SDS) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *SDS) GetK8SSaJwtPath() string {
	if m != nil {
		return m.K8SSaJwtPath
	}
	return ""
}

// ProxyConfig defines variables for individual Envoy instances.
type ProxyConfig struct {
	// Path to the generated configuration file directory.
	// Proxy agent generates the actual configuration and stores it in this directory.
	ConfigPath string `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3" json:"config_path,omitempty"`
	// Path to the proxy binary
	BinaryPath string `protobuf:"bytes,2,opt,name=binary_path,json=binaryPath,proto3" json:"binary_path,omitempty"`
	// Service cluster defines the name for the service_cluster that is
	// shared by all Envoy instances. This setting corresponds to
	// _--service-cluster_ flag in Envoy.  In a typical Envoy deployment, the
	// _service-cluster_ flag is used to identify the caller, for
	// source-based routing scenarios.
	//
	// Since Istio does not assign a local service/service version to each
	// Envoy instance, the name is same for all of them.  However, the
	// source/caller's identity (e.g., IP address) is encoded in the
	// _--service-node_ flag when launching Envoy.  When the RDS service
	// receives API calls from Envoy, it uses the value of the _service-node_
	// flag to compute routes that are relative to the service instances
	// located at that IP address.
	ServiceCluster string `protobuf:"bytes,3,opt,name=service_cluster,json=serviceCluster,proto3" json:"service_cluster,omitempty"`
	// The time in seconds that Envoy will drain connections during a hot
	// restart. MUST be >=1s (e.g., _1s/1m/1h_)
	DrainDuration *types.Duration `protobuf:"bytes,4,opt,name=drain_duration,json=drainDuration,proto3" json:"drain_duration,omitempty"`
	// The time in seconds that Envoy will wait before shutting down the
	// parent process during a hot restart. MUST be >=1s (e.g., _1s/1m/1h_).
	// MUST BE greater than _drain_duration_ parameter.
	ParentShutdownDuration *types.Duration `protobuf:"bytes,5,opt,name=parent_shutdown_duration,json=parentShutdownDuration,proto3" json:"parent_shutdown_duration,omitempty"`
	// Address of the discovery service exposing xDS with mTLS connection.
	DiscoveryAddress string `protobuf:"bytes,6,opt,name=discovery_address,json=discoveryAddress,proto3" json:"discovery_address,omitempty"`
	// $hide_from_docs
	DiscoveryRefreshDelay *types.Duration `protobuf:"bytes,7,opt,name=discovery_refresh_delay,json=discoveryRefreshDelay,proto3" json:"discovery_refresh_delay,omitempty"` // Deprecated: Do not use.
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	// DEPRECATED: Use [tracing][istio.mesh.v1alpha1.ProxyConfig.tracing] instead.
	ZipkinAddress string `protobuf:"bytes,8,opt,name=zipkin_address,json=zipkinAddress,proto3" json:"zipkin_address,omitempty"` // Deprecated: Do not use.
	// Connection timeout used by Envoy for supporting services. (MUST BE >=1ms)
	ConnectTimeout *types.Duration `protobuf:"bytes,9,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// IP Address and Port of a statsd UDP listener (e.g. _10.75.241.127:9125_).
	StatsdUdpAddress string `protobuf:"bytes,10,opt,name=statsd_udp_address,json=statsdUdpAddress,proto3" json:"statsd_udp_address,omitempty"`
	// $hide_from_docs
	EnvoyMetricsServiceAddress string `protobuf:"bytes,20,opt,name=envoy_metrics_service_address,json=envoyMetricsServiceAddress,proto3" json:"envoy_metrics_service_address,omitempty"` // Deprecated: Do not use.
	// Port on which Envoy should listen for administrative commands.
	ProxyAdminPort int32 `protobuf:"varint,11,opt,name=proxy_admin_port,json=proxyAdminPort,proto3" json:"proxy_admin_port,omitempty"`
	// $hide_from_docs
	AvailabilityZone string `protobuf:"bytes,12,opt,name=availability_zone,json=availabilityZone,proto3" json:"availability_zone,omitempty"` // Deprecated: Do not use.
	// Authentication policy defines the global switch to control authentication
	// for Envoy-to-Envoy communication for istio components Mixer and Pilot.
	ControlPlaneAuthPolicy AuthenticationPolicy `protobuf:"varint,13,opt,name=control_plane_auth_policy,json=controlPlaneAuthPolicy,proto3,enum=istio.mesh.v1alpha1.AuthenticationPolicy" json:"control_plane_auth_policy,omitempty"`
	// File path of custom proxy configuration, currently used by proxies
	// in front of Mixer and Pilot.
	CustomConfigFile string `protobuf:"bytes,14,opt,name=custom_config_file,json=customConfigFile,proto3" json:"custom_config_file,omitempty"`
	// Maximum length of name field in Envoy's metrics. The length of the name field
	// is determined by the length of a name field in a service and the set of labels that
	// comprise a particular version of the service. The default value is set to 189 characters.
	// Envoy's internal metrics take up 67 characters, for a total of 256 character name per metric.
	// Increase the value of this field if you find that the metrics from Envoys are truncated.
	StatNameLength int32 `protobuf:"varint,15,opt,name=stat_name_length,json=statNameLength,proto3" json:"stat_name_length,omitempty"`
	// The number of worker threads to run. Default value is number of cores on the machine.
	Concurrency int32 `protobuf:"varint,16,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	// Path to the proxy bootstrap template file
	ProxyBootstrapTemplatePath string `protobuf:"bytes,17,opt,name=proxy_bootstrap_template_path,json=proxyBootstrapTemplatePath,proto3" json:"proxy_bootstrap_template_path,omitempty"`
	// The mode used to redirect inbound traffic to Envoy.
	InterceptionMode ProxyConfig_InboundInterceptionMode `protobuf:"varint,18,opt,name=interception_mode,json=interceptionMode,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode" json:"interception_mode,omitempty"`
	// Tracing configuration to be used by the proxy.
	Tracing *Tracing `protobuf:"bytes,19,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// secret discovery service(SDS) configuration to be used by the proxy.
	Sds *SDS `protobuf:"bytes,21,opt,name=sds,proto3" json:"sds,omitempty"`
	// Address of the service to which access logs from Envoys should be
	// sent. (e.g. accesslog-service:15000). See [Access Log
	// Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/accesslog/v2/als.proto)
	// for details about Envoy's gRPC Access Log Service API.
	EnvoyAccessLogService *RemoteService `protobuf:"bytes,22,opt,name=envoy_access_log_service,json=envoyAccessLogService,proto3" json:"envoy_access_log_service,omitempty"`
	// Address of the Envoy Metrics Service implementation (e.g. metrics-service:15000).
	// See [Metric Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/metrics/v2/metrics_service.proto)
	// for details about Envoy's Metrics Service API.
	EnvoyMetricsService  *RemoteService `protobuf:"bytes,23,opt,name=envoy_metrics_service,json=envoyMetricsService,proto3" json:"envoy_metrics_service,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ProxyConfig) Reset()         { *m = ProxyConfig{} }
func (m *ProxyConfig) String() string { return proto.CompactTextString(m) }
func (*ProxyConfig) ProtoMessage()    {}
func (*ProxyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{2}
}
func (m *ProxyConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProxyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProxyConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProxyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyConfig.Merge(m, src)
}
func (m *ProxyConfig) XXX_Size() int {
	return m.Size()
}
func (m *ProxyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyConfig proto.InternalMessageInfo

func (m *ProxyConfig) GetConfigPath() string {
	if m != nil {
		return m.ConfigPath
	}
	return ""
}

func (m *ProxyConfig) GetBinaryPath() string {
	if m != nil {
		return m.BinaryPath
	}
	return ""
}

func (m *ProxyConfig) GetServiceCluster() string {
	if m != nil {
		return m.ServiceCluster
	}
	return ""
}

func (m *ProxyConfig) GetDrainDuration() *types.Duration {
	if m != nil {
		return m.DrainDuration
	}
	return nil
}

func (m *ProxyConfig) GetParentShutdownDuration() *types.Duration {
	if m != nil {
		return m.ParentShutdownDuration
	}
	return nil
}

func (m *ProxyConfig) GetDiscoveryAddress() string {
	if m != nil {
		return m.DiscoveryAddress
	}
	return ""
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetDiscoveryRefreshDelay() *types.Duration {
	if m != nil {
		return m.DiscoveryRefreshDelay
	}
	return nil
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetZipkinAddress() string {
	if m != nil {
		return m.ZipkinAddress
	}
	return ""
}

func (m *ProxyConfig) GetConnectTimeout() *types.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *ProxyConfig) GetStatsdUdpAddress() string {
	if m != nil {
		return m.StatsdUdpAddress
	}
	return ""
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetEnvoyMetricsServiceAddress() string {
	if m != nil {
		return m.EnvoyMetricsServiceAddress
	}
	return ""
}

func (m *ProxyConfig) GetProxyAdminPort() int32 {
	if m != nil {
		return m.ProxyAdminPort
	}
	return 0
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetAvailabilityZone() string {
	if m != nil {
		return m.AvailabilityZone
	}
	return ""
}

func (m *ProxyConfig) GetControlPlaneAuthPolicy() AuthenticationPolicy {
	if m != nil {
		return m.ControlPlaneAuthPolicy
	}
	return AuthenticationPolicy_NONE
}

func (m *ProxyConfig) GetCustomConfigFile() string {
	if m != nil {
		return m.CustomConfigFile
	}
	return ""
}

func (m *ProxyConfig) GetStatNameLength() int32 {
	if m != nil {
		return m.StatNameLength
	}
	return 0
}

func (m *ProxyConfig) GetConcurrency() int32 {
	if m != nil {
		return m.Concurrency
	}
	return 0
}

func (m *ProxyConfig) GetProxyBootstrapTemplatePath() string {
	if m != nil {
		return m.ProxyBootstrapTemplatePath
	}
	return ""
}

func (m *ProxyConfig) GetInterceptionMode() ProxyConfig_InboundInterceptionMode {
	if m != nil {
		return m.InterceptionMode
	}
	return ProxyConfig_REDIRECT
}

func (m *ProxyConfig) GetTracing() *Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

func (m *ProxyConfig) GetSds() *SDS {
	if m != nil {
		return m.Sds
	}
	return nil
}

func (m *ProxyConfig) GetEnvoyAccessLogService() *RemoteService {
	if m != nil {
		return m.EnvoyAccessLogService
	}
	return nil
}

func (m *ProxyConfig) GetEnvoyMetricsService() *RemoteService {
	if m != nil {
		return m.EnvoyMetricsService
	}
	return nil
}

type RemoteService struct {
	// Address of a remove service used for various purposes (access log
	// receiver, metrics receiver, etc.). Can be IP address or a fully
	// qualified DNS name.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tls_settings to specify the tls mode to use. If the remote service
	// uses Istio mutual TLS and shares the root CA with Pilot, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.TLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive         *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                  `json:"-"`
	XXX_unrecognized     []byte                                                    `json:"-"`
	XXX_sizecache        int32                                                     `json:"-"`
}

func (m *RemoteService) Reset()         { *m = RemoteService{} }
func (m *RemoteService) String() string { return proto.CompactTextString(m) }
func (*RemoteService) ProtoMessage()    {}
func (*RemoteService) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{3}
}
func (m *RemoteService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoteService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoteService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoteService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteService.Merge(m, src)
}
func (m *RemoteService) XXX_Size() int {
	return m.Size()
}
func (m *RemoteService) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteService.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteService proto.InternalMessageInfo

func (m *RemoteService) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *RemoteService) GetTlsSettings() *v1alpha3.TLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

func (m *RemoteService) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.mesh.v1alpha1.AuthenticationPolicy", AuthenticationPolicy_name, AuthenticationPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode", ProxyConfig_InboundInterceptionMode_name, ProxyConfig_InboundInterceptionMode_value)
	proto.RegisterType((*Tracing)(nil), "istio.mesh.v1alpha1.Tracing")
	proto.RegisterType((*Tracing_Zipkin)(nil), "istio.mesh.v1alpha1.Tracing.Zipkin")
	proto.RegisterType((*Tracing_Lightstep)(nil), "istio.mesh.v1alpha1.Tracing.Lightstep")
	proto.RegisterType((*Tracing_Datadog)(nil), "istio.mesh.v1alpha1.Tracing.Datadog")
	proto.RegisterType((*Tracing_Stackdriver)(nil), "istio.mesh.v1alpha1.Tracing.Stackdriver")
	proto.RegisterType((*SDS)(nil), "istio.mesh.v1alpha1.SDS")
	proto.RegisterType((*ProxyConfig)(nil), "istio.mesh.v1alpha1.ProxyConfig")
	proto.RegisterType((*RemoteService)(nil), "istio.mesh.v1alpha1.RemoteService")
}

func init() { proto.RegisterFile("mesh/v1alpha1/proxy.proto", fileDescriptor_5efecd978cf3d28d) }

var fileDescriptor_5efecd978cf3d28d = []byte{
	// 1284 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x1b, 0x8e, 0xfb, 0x63, 0x27, 0xb4, 0xe3, 0x38, 0x6c, 0x93, 0x2a, 0xfe, 0xda, 0x7c, 0x99, 0xbb,
	0x9f, 0xb4, 0x1b, 0x6c, 0xb4, 0x19, 0x8a, 0x9e, 0x6c, 0xa8, 0xf3, 0x53, 0xc4, 0x9d, 0x93, 0x1a,
	0xb2, 0x53, 0x6c, 0xed, 0x01, 0x41, 0x4b, 0x6f, 0x6c, 0xce, 0x12, 0x29, 0x90, 0x94, 0x53, 0xf7,
	0x6c, 0x77, 0x33, 0xec, 0x60, 0xd7, 0xb1, 0xc3, 0x5d, 0xc2, 0x50, 0x60, 0xc0, 0x2e, 0x63, 0x10,
	0x29, 0x39, 0x6e, 0xeb, 0xba, 0x3b, 0x13, 0x5f, 0x3e, 0xcf, 0xc3, 0xf7, 0x97, 0x14, 0xda, 0x0a,
	0x41, 0x0d, 0x1b, 0xe3, 0x07, 0x34, 0x88, 0x86, 0xf4, 0x41, 0x23, 0x92, 0xe2, 0xf5, 0xa4, 0x1e,
	0x49, 0xa1, 0x05, 0xbe, 0xc1, 0x94, 0x66, 0xa2, 0x9e, 0x00, 0xea, 0x19, 0xa0, 0xba, 0x3d, 0x10,
	0x62, 0x10, 0x40, 0xc3, 0x40, 0xfa, 0xf1, 0x79, 0xc3, 0x8f, 0x25, 0xd5, 0x4c, 0x70, 0x4b, 0xfa,
	0x70, 0xff, 0x42, 0xd2, 0x28, 0x02, 0xa9, 0xd2, 0xfd, 0xfb, 0x1c, 0xf4, 0x85, 0x90, 0x23, 0xc6,
	0x07, 0xd9, 0xa9, 0x7b, 0x0d, 0x1f, 0x94, 0x66, 0xdc, 0xc8, 0x10, 0x19, 0x07, 0x60, 0xb1, 0xb5,
	0x5f, 0xf3, 0xa8, 0xd0, 0x93, 0xd4, 0x63, 0x7c, 0x80, 0xbf, 0x43, 0xf9, 0x37, 0x2c, 0x1a, 0x31,
	0xee, 0xe4, 0x76, 0x72, 0xbb, 0xc5, 0x87, 0x77, 0xeb, 0x73, 0xbc, 0xab, 0xa7, 0xe8, 0xfa, 0x4b,
	0x03, 0x3d, 0x5e, 0x72, 0x53, 0x12, 0x7e, 0x8a, 0x56, 0x02, 0x36, 0x18, 0x6a, 0xa5, 0x21, 0x72,
	0xae, 0x18, 0x85, 0x2f, 0x17, 0x2a, 0xb4, 0x33, 0xf4, 0xf1, 0x92, 0x7b, 0x49, 0xc5, 0x4f, 0x50,
	0xc1, 0xa7, 0x9a, 0xfa, 0x62, 0xe0, 0x5c, 0x35, 0x2a, 0x9f, 0x2f, 0x54, 0x39, 0xb4, 0xd8, 0xe3,
	0x25, 0x37, 0xa3, 0xe1, 0x36, 0x2a, 0x2a, 0x4d, 0xbd, 0x91, 0x2f, 0xd9, 0x18, 0xa4, 0x73, 0xcd,
	0xa8, 0xec, 0x2e, 0x54, 0xe9, 0x5e, 0xe2, 0x8f, 0x97, 0xdc, 0x59, 0x7a, 0xb5, 0x86, 0xf2, 0x36,
	0x56, 0xec, 0xa0, 0x02, 0xf5, 0x7d, 0x09, 0x4a, 0x99, 0x0c, 0xad, 0xb8, 0xd9, 0xb2, 0xfa, 0x4b,
	0x0e, 0xad, 0x4c, 0xc3, 0xf9, 0x38, 0x0e, 0x7f, 0x86, 0x4a, 0xd4, 0xf3, 0x40, 0x29, 0xa2, 0xc5,
	0x08, 0xb8, 0x49, 0xd3, 0x8a, 0x5b, 0xb4, 0xb6, 0x5e, 0x62, 0xc2, 0x9b, 0x28, 0xaf, 0xc0, 0x8b,
	0x25, 0x98, 0xe8, 0x97, 0xdd, 0x74, 0x85, 0xff, 0x8f, 0x8a, 0x1e, 0xf5, 0x40, 0x6a, 0x12, 0x51,
	0x3d, 0x34, 0x41, 0xad, 0xb8, 0xc8, 0x9a, 0x3a, 0x54, 0x0f, 0xab, 0x77, 0x51, 0x21, 0xcd, 0xc5,
	0x02, 0x47, 0x7f, 0xbf, 0x82, 0x8a, 0x33, 0xb1, 0xe2, 0x9b, 0xe8, 0xba, 0x0f, 0xfd, 0x78, 0x60,
	0x70, 0xcb, 0xae, 0x5d, 0xe0, 0x1e, 0x72, 0x42, 0xfa, 0x9a, 0xf0, 0x38, 0xec, 0x83, 0x24, 0xe2,
	0x9c, 0x50, 0xad, 0x25, 0xeb, 0xc7, 0x1a, 0x54, 0x5a, 0xd9, 0xff, 0xd5, 0x6d, 0x13, 0xd6, 0xb3,
	0x26, 0xac, 0xb7, 0xb8, 0x7e, 0xf4, 0xed, 0x0b, 0x1a, 0xc4, 0xe0, 0x6e, 0x84, 0xf4, 0xf5, 0xa9,
	0xe1, 0x3e, 0x3f, 0x6f, 0x4e, 0x99, 0xf8, 0x05, 0xda, 0x7a, 0x4f, 0x95, 0x73, 0xa1, 0x4d, 0x4b,
	0xaa, 0xb4, 0xd4, 0x0b, 0x65, 0x37, 0x67, 0x65, 0x2f, 0xa9, 0xf8, 0x15, 0xba, 0xfd, 0xae, 0x6e,
	0x08, 0x4a, 0xd1, 0x01, 0x10, 0x18, 0x03, 0xd7, 0x2a, 0xad, 0xff, 0x42, 0x69, 0x67, 0x46, 0xfa,
	0xc4, 0xb2, 0x8f, 0x0c, 0x79, 0x7f, 0x19, 0xe5, 0xb5, 0x4c, 0x92, 0x5c, 0x7b, 0x8a, 0xae, 0x76,
	0x0f, 0xbb, 0x49, 0x6e, 0x81, 0xd3, 0x7e, 0x00, 0x7e, 0x9a, 0xb3, 0x6c, 0x89, 0xbf, 0x40, 0x6b,
	0xa3, 0xc7, 0x8a, 0x28, 0x4a, 0x7e, 0xbe, 0x48, 0xab, 0x64, 0xeb, 0x5b, 0x1a, 0x3d, 0x56, 0x5d,
	0xfa, 0xec, 0xc2, 0xd4, 0xa9, 0xf6, 0x5b, 0x11, 0x15, 0x3b, 0xc9, 0x1d, 0x70, 0x20, 0xf8, 0x39,
	0x1b, 0x98, 0xc2, 0x9a, 0x2f, 0x4b, 0xc9, 0xa5, 0x85, 0x35, 0xa6, 0x84, 0x90, 0x00, 0xfa, 0x8c,
	0x53, 0x39, 0x99, 0xd5, 0x44, 0xd6, 0x64, 0x00, 0x5f, 0xa1, 0x35, 0x05, 0x72, 0xcc, 0x3c, 0x20,
	0x5e, 0x10, 0x2b, 0x0d, 0xd2, 0xa4, 0x73, 0xc5, 0x2d, 0xa7, 0xe6, 0x03, 0x6b, 0xc5, 0x4f, 0x50,
	0xd9, 0x97, 0x94, 0x71, 0x92, 0xdd, 0x28, 0x69, 0x6e, 0xb6, 0x3e, 0xc8, 0xcd, 0x61, 0x0a, 0x70,
	0x57, 0x0d, 0x21, 0x5b, 0xe2, 0x2e, 0x72, 0x22, 0x2a, 0x81, 0x6b, 0xa2, 0x86, 0xb1, 0xf6, 0xc5,
	0xc5, 0x8c, 0xd6, 0xf5, 0x4f, 0x69, 0x6d, 0x5a, 0x6a, 0x37, 0x65, 0x4e, 0x45, 0xbf, 0x46, 0xeb,
	0x3e, 0x53, 0x9e, 0x18, 0x83, 0x9c, 0x90, 0xac, 0x71, 0xf3, 0x26, 0x82, 0xca, 0x74, 0xa3, 0x99,
	0x8e, 0xd0, 0x19, 0xba, 0x75, 0x09, 0x96, 0x70, 0x2e, 0x41, 0x0d, 0x89, 0x0f, 0x01, 0x9d, 0x38,
	0x85, 0x4f, 0x38, 0xb0, 0x7f, 0xc5, 0xc9, 0xb9, 0x1b, 0x53, 0xb6, 0x6b, 0xc9, 0x87, 0x09, 0x17,
	0xdf, 0x43, 0x65, 0x7b, 0x8f, 0x4d, 0x1d, 0x58, 0x4e, 0x1c, 0x30, 0x94, 0x55, 0xbb, 0x93, 0x79,
	0xb0, 0x8f, 0xd6, 0x3c, 0xc1, 0x39, 0x78, 0x9a, 0x68, 0x16, 0x82, 0x88, 0xb5, 0xb3, 0xf2, 0xa9,
	0xd0, 0xcb, 0x29, 0xa3, 0x67, 0x09, 0xf8, 0x1b, 0x84, 0x95, 0xa6, 0x5a, 0xf9, 0x24, 0xf6, 0xa3,
	0xe9, 0x91, 0xc8, 0xc6, 0x6c, 0x77, 0xce, 0xfc, 0x28, 0x3b, 0xf1, 0x08, 0xdd, 0x01, 0x3e, 0x16,
	0x13, 0x12, 0x82, 0x96, 0xcc, 0x53, 0x24, 0x2b, 0x77, 0x46, 0xbc, 0x39, 0xf5, 0xb5, 0x6a, 0x80,
	0x27, 0x16, 0xd7, 0xb5, 0xb0, 0x4c, 0x66, 0x17, 0x55, 0xcc, 0xe3, 0x43, 0xa8, 0x1f, 0x32, 0x4e,
	0x22, 0x21, 0xb5, 0x53, 0xdc, 0xc9, 0xed, 0x5e, 0x77, 0xcb, 0xc6, 0xde, 0x4c, 0xcc, 0x1d, 0x21,
	0x35, 0x6e, 0xa0, 0x75, 0x3a, 0xa6, 0x2c, 0xa0, 0x7d, 0x16, 0x30, 0x3d, 0x21, 0x6f, 0x04, 0x07,
	0xa7, 0x34, 0x3d, 0xa4, 0x32, 0xbb, 0xf9, 0x52, 0x70, 0xc0, 0x3e, 0xda, 0xf2, 0x04, 0xd7, 0x52,
	0x04, 0x24, 0x0a, 0x28, 0x07, 0x42, 0x63, 0x3d, 0x24, 0x91, 0x08, 0x98, 0x37, 0x71, 0x56, 0x77,
	0x72, 0xbb, 0xe5, 0x87, 0xf7, 0xe6, 0x5e, 0xc0, 0xcd, 0x58, 0x0f, 0x81, 0x6b, 0xe6, 0x99, 0x3c,
	0x75, 0x0c, 0xc1, 0xdd, 0x4c, 0xb5, 0x3a, 0x89, 0x54, 0x82, 0xb0, 0xf6, 0x24, 0x6b, 0x5e, 0xac,
	0xb4, 0x08, 0x49, 0x3a, 0x31, 0xe7, 0x2c, 0x00, 0xa7, 0x6c, 0xb3, 0x66, 0x77, 0xec, 0x50, 0x3d,
	0x65, 0x01, 0x24, 0xe1, 0x26, 0x99, 0x24, 0x9c, 0x86, 0x40, 0x02, 0xe0, 0x03, 0x3d, 0x74, 0xd6,
	0x6c, 0xb8, 0x89, 0xfd, 0x94, 0x86, 0xd0, 0x36, 0x56, 0xbc, 0x63, 0x46, 0xd0, 0x8b, 0xa5, 0x04,
	0xee, 0x4d, 0x9c, 0x8a, 0x01, 0xcd, 0x9a, 0x70, 0x13, 0xdd, 0xb1, 0xa9, 0xeb, 0x0b, 0xa1, 0x95,
	0x96, 0x34, 0x22, 0x1a, 0xc2, 0x28, 0xa0, 0x1a, 0xec, 0x54, 0xae, 0x1b, 0x27, 0xaa, 0x06, 0xb4,
	0x9f, 0x61, 0x7a, 0x29, 0xc4, 0x4c, 0x29, 0xa0, 0x75, 0xc6, 0x35, 0x48, 0x0f, 0x22, 0xf3, 0x0a,
	0x87, 0xc2, 0x07, 0x07, 0x9b, 0xd4, 0x3c, 0x9e, 0x9b, 0x9a, 0x99, 0x4b, 0xa2, 0xde, 0xe2, 0x7d,
	0x11, 0x73, 0xbf, 0x35, 0x23, 0x70, 0x22, 0x7c, 0x70, 0x2b, 0xec, 0x3d, 0x0b, 0x7e, 0x84, 0x0a,
	0xda, 0x3e, 0x6a, 0xce, 0x0d, 0xd3, 0x95, 0xb7, 0x17, 0x3d, 0x7c, 0x6e, 0x06, 0xc6, 0xf7, 0xd1,
	0x55, 0xe5, 0x2b, 0x67, 0xc3, 0x70, 0x9c, 0xb9, 0x9c, 0xee, 0x61, 0xd7, 0x4d, 0x40, 0xf8, 0x15,
	0x72, 0x6c, 0x3f, 0xa6, 0x8f, 0x59, 0x20, 0x06, 0x59, 0x4b, 0x3a, 0x9b, 0x46, 0xa0, 0x36, 0x57,
	0xc0, 0x85, 0x50, 0x68, 0x48, 0xbb, 0xd2, 0xdd, 0x30, 0x1a, 0x4d, 0x23, 0xd1, 0x16, 0x83, 0xd4,
	0x8c, 0x5f, 0xa0, 0x8d, 0xb9, 0xcd, 0xee, 0xdc, 0xfa, 0xcf, 0xca, 0x37, 0xe6, 0x0c, 0x41, 0x6d,
	0x0f, 0xdd, 0xfa, 0x48, 0x16, 0x71, 0x09, 0x2d, 0xbb, 0x47, 0x87, 0x2d, 0xf7, 0xe8, 0xa0, 0x57,
	0x59, 0xc2, 0x08, 0xe5, 0x7b, 0x1d, 0xf7, 0xf9, 0x8f, 0x3f, 0x55, 0x72, 0xb5, 0xbf, 0x73, 0x68,
	0xf5, 0x1d, 0xed, 0x05, 0x8f, 0x7b, 0x0b, 0x95, 0x74, 0x90, 0xb8, 0xab, 0x35, 0xe3, 0x03, 0xf5,
	0xde, 0x3f, 0xd0, 0xe5, 0x4f, 0x59, 0xe6, 0xf5, 0x5e, 0xbd, 0xd7, 0xee, 0x76, 0x53, 0xb4, 0x5b,
	0xd4, 0x81, 0xca, 0x16, 0x58, 0xa0, 0x55, 0xed, 0x45, 0x64, 0x04, 0x10, 0xd1, 0x80, 0x8d, 0x21,
	0x7d, 0x1e, 0x9f, 0x2d, 0xd0, 0x3a, 0xb0, 0x17, 0x8c, 0x19, 0x22, 0x11, 0x64, 0x4a, 0xf5, 0xde,
	0x41, 0xe7, 0xf2, 0xdb, 0x8b, 0x7e, 0xc8, 0x14, 0xdd, 0x92, 0x9e, 0x59, 0xdd, 0xff, 0x1e, 0xdd,
	0x9c, 0x37, 0x89, 0x78, 0x19, 0x5d, 0x3b, 0x7d, 0x7e, 0x7a, 0x54, 0x59, 0xc2, 0x65, 0x84, 0x4e,
	0xce, 0x7a, 0x67, 0xcd, 0x36, 0xe9, 0xb5, 0xbb, 0x95, 0x1c, 0x2e, 0xa1, 0x42, 0xeb, 0xf4, 0xf8,
	0xc8, 0x6d, 0xf5, 0x2a, 0xff, 0x14, 0xf6, 0x77, 0xff, 0x78, 0xbb, 0x9d, 0xfb, 0xf3, 0xed, 0x76,
	0xee, 0xaf, 0xb7, 0xdb, 0xb9, 0x97, 0x55, 0xeb, 0x26, 0x13, 0x0d, 0x1a, 0xb1, 0xc6, 0x3b, 0xbf,
	0xbf, 0xfd, 0xbc, 0xb9, 0x1c, 0xf7, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xdb, 0x16, 0x46, 0x98,
	0x16, 0x0b, 0x00, 0x00,
}

func (m *Tracing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Tracer != nil {
		{
			size := m.Tracer.Size()
			i -= size
			if _, err := m.Tracer.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Zipkin_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Tracing_Zipkin_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Zipkin != nil {
		{
			size, err := m.Zipkin.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Lightstep_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Tracing_Lightstep_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Lightstep != nil {
		{
			size, err := m.Lightstep.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Datadog_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Tracing_Datadog_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Datadog != nil {
		{
			size, err := m.Datadog.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Stackdriver_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Tracing_Stackdriver_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stackdriver != nil {
		{
			size, err := m.Stackdriver.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Zipkin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Zipkin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Zipkin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Lightstep) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Lightstep) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Lightstep) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CacertPath) > 0 {
		i -= len(m.CacertPath)
		copy(dAtA[i:], m.CacertPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.CacertPath)))
		i--
		dAtA[i] = 0x22
	}
	if m.Secure {
		i--
		if m.Secure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.AccessToken) > 0 {
		i -= len(m.AccessToken)
		copy(dAtA[i:], m.AccessToken)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.AccessToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Datadog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Datadog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Datadog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Stackdriver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Stackdriver) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Stackdriver) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxNumberOfMessageEvents != nil {
		{
			size, err := m.MaxNumberOfMessageEvents.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MaxNumberOfAnnotations != nil {
		{
			size, err := m.MaxNumberOfAnnotations.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxNumberOfAttributes != nil {
		{
			size, err := m.MaxNumberOfAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Debug {
		i--
		if m.Debug {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SDS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SDS) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SDS) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.K8SSaJwtPath) > 0 {
		i -= len(m.K8SSaJwtPath)
		copy(dAtA[i:], m.K8SSaJwtPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.K8SSaJwtPath)))
		i--
		dAtA[i] = 0x12
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProxyConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProxyConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProxyConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.EnvoyMetricsService != nil {
		{
			size, err := m.EnvoyMetricsService.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if m.EnvoyAccessLogService != nil {
		{
			size, err := m.EnvoyAccessLogService.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.Sds != nil {
		{
			size, err := m.Sds.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.EnvoyMetricsServiceAddress) > 0 {
		i -= len(m.EnvoyMetricsServiceAddress)
		copy(dAtA[i:], m.EnvoyMetricsServiceAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.EnvoyMetricsServiceAddress)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.Tracing != nil {
		{
			size, err := m.Tracing.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if m.InterceptionMode != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.InterceptionMode))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if len(m.ProxyBootstrapTemplatePath) > 0 {
		i -= len(m.ProxyBootstrapTemplatePath)
		copy(dAtA[i:], m.ProxyBootstrapTemplatePath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ProxyBootstrapTemplatePath)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Concurrency != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.Concurrency))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.StatNameLength != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.StatNameLength))
		i--
		dAtA[i] = 0x78
	}
	if len(m.CustomConfigFile) > 0 {
		i -= len(m.CustomConfigFile)
		copy(dAtA[i:], m.CustomConfigFile)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.CustomConfigFile)))
		i--
		dAtA[i] = 0x72
	}
	if m.ControlPlaneAuthPolicy != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.ControlPlaneAuthPolicy))
		i--
		dAtA[i] = 0x68
	}
	if len(m.AvailabilityZone) > 0 {
		i -= len(m.AvailabilityZone)
		copy(dAtA[i:], m.AvailabilityZone)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.AvailabilityZone)))
		i--
		dAtA[i] = 0x62
	}
	if m.ProxyAdminPort != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.ProxyAdminPort))
		i--
		dAtA[i] = 0x58
	}
	if len(m.StatsdUdpAddress) > 0 {
		i -= len(m.StatsdUdpAddress)
		copy(dAtA[i:], m.StatsdUdpAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.StatsdUdpAddress)))
		i--
		dAtA[i] = 0x52
	}
	if m.ConnectTimeout != nil {
		{
			size, err := m.ConnectTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ZipkinAddress) > 0 {
		i -= len(m.ZipkinAddress)
		copy(dAtA[i:], m.ZipkinAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ZipkinAddress)))
		i--
		dAtA[i] = 0x42
	}
	if m.DiscoveryRefreshDelay != nil {
		{
			size, err := m.DiscoveryRefreshDelay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.DiscoveryAddress) > 0 {
		i -= len(m.DiscoveryAddress)
		copy(dAtA[i:], m.DiscoveryAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.DiscoveryAddress)))
		i--
		dAtA[i] = 0x32
	}
	if m.ParentShutdownDuration != nil {
		{
			size, err := m.ParentShutdownDuration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.DrainDuration != nil {
		{
			size, err := m.DrainDuration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ServiceCluster) > 0 {
		i -= len(m.ServiceCluster)
		copy(dAtA[i:], m.ServiceCluster)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ServiceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BinaryPath) > 0 {
		i -= len(m.BinaryPath)
		copy(dAtA[i:], m.BinaryPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.BinaryPath)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ConfigPath) > 0 {
		i -= len(m.ConfigPath)
		copy(dAtA[i:], m.ConfigPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ConfigPath)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoteService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteService) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoteService) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TcpKeepalive != nil {
		{
			size, err := m.TcpKeepalive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.TlsSettings != nil {
		{
			size, err := m.TlsSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintProxy(dAtA []byte, offset int, v uint64) int {
	offset -= sovProxy(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Tracing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Tracer != nil {
		n += m.Tracer.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Zipkin_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Zipkin != nil {
		l = m.Zipkin.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Lightstep_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Lightstep != nil {
		l = m.Lightstep.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Datadog_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Datadog != nil {
		l = m.Datadog.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Stackdriver_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stackdriver != nil {
		l = m.Stackdriver.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Zipkin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Lightstep) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.AccessToken)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.Secure {
		n += 2
	}
	l = len(m.CacertPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Datadog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Stackdriver) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Debug {
		n += 2
	}
	if m.MaxNumberOfAttributes != nil {
		l = m.MaxNumberOfAttributes.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.MaxNumberOfAnnotations != nil {
		l = m.MaxNumberOfAnnotations.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.MaxNumberOfMessageEvents != nil {
		l = m.MaxNumberOfMessageEvents.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SDS) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled {
		n += 2
	}
	l = len(m.K8SSaJwtPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProxyConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ConfigPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.BinaryPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.ServiceCluster)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.DrainDuration != nil {
		l = m.DrainDuration.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ParentShutdownDuration != nil {
		l = m.ParentShutdownDuration.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.DiscoveryAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.DiscoveryRefreshDelay != nil {
		l = m.DiscoveryRefreshDelay.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.ZipkinAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.StatsdUdpAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ProxyAdminPort != 0 {
		n += 1 + sovProxy(uint64(m.ProxyAdminPort))
	}
	l = len(m.AvailabilityZone)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ControlPlaneAuthPolicy != 0 {
		n += 1 + sovProxy(uint64(m.ControlPlaneAuthPolicy))
	}
	l = len(m.CustomConfigFile)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.StatNameLength != 0 {
		n += 1 + sovProxy(uint64(m.StatNameLength))
	}
	if m.Concurrency != 0 {
		n += 2 + sovProxy(uint64(m.Concurrency))
	}
	l = len(m.ProxyBootstrapTemplatePath)
	if l > 0 {
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.InterceptionMode != 0 {
		n += 2 + sovProxy(uint64(m.InterceptionMode))
	}
	if m.Tracing != nil {
		l = m.Tracing.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	l = len(m.EnvoyMetricsServiceAddress)
	if l > 0 {
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.Sds != nil {
		l = m.Sds.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.EnvoyAccessLogService != nil {
		l = m.EnvoyAccessLogService.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.EnvoyMetricsService != nil {
		l = m.EnvoyMetricsService.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RemoteService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProxy(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProxy(x uint64) (n int) {
	return sovProxy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tracing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tracing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tracing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zipkin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Zipkin{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Zipkin_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lightstep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Lightstep{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Lightstep_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datadog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Datadog{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Datadog_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stackdriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Stackdriver{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Stackdriver_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Zipkin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Zipkin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Zipkin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Lightstep) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lightstep: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lightstep: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Secure = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacertPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CacertPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Datadog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Datadog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Datadog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Stackdriver) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stackdriver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stackdriver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Debug", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Debug = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAttributes == nil {
				m.MaxNumberOfAttributes = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAnnotations == nil {
				m.MaxNumberOfAnnotations = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAnnotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfMessageEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfMessageEvents == nil {
				m.MaxNumberOfMessageEvents = &types.Int64Value{}
			}
			if err := m.MaxNumberOfMessageEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SDS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SDS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SDS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field K8SSaJwtPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.K8SSaJwtPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProxyConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinaryPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinaryPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DrainDuration == nil {
				m.DrainDuration = &types.Duration{}
			}
			if err := m.DrainDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentShutdownDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentShutdownDuration == nil {
				m.ParentShutdownDuration = &types.Duration{}
			}
			if err := m.ParentShutdownDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DiscoveryAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DiscoveryRefreshDelay == nil {
				m.DiscoveryRefreshDelay = &types.Duration{}
			}
			if err := m.DiscoveryRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZipkinAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ZipkinAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &types.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsdUdpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsdUdpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyAdminPort", wireType)
			}
			m.ProxyAdminPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyAdminPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailabilityZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AvailabilityZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ControlPlaneAuthPolicy", wireType)
			}
			m.ControlPlaneAuthPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ControlPlaneAuthPolicy |= AuthenticationPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomConfigFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomConfigFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatNameLength", wireType)
			}
			m.StatNameLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StatNameLength |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Concurrency", wireType)
			}
			m.Concurrency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Concurrency |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyBootstrapTemplatePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyBootstrapTemplatePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InterceptionMode", wireType)
			}
			m.InterceptionMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InterceptionMode |= ProxyConfig_InboundInterceptionMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracing == nil {
				m.Tracing = &Tracing{}
			}
			if err := m.Tracing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyMetricsServiceAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvoyMetricsServiceAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sds == nil {
				m.Sds = &SDS{}
			}
			if err := m.Sds.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyAccessLogService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnvoyAccessLogService == nil {
				m.EnvoyAccessLogService = &RemoteService{}
			}
			if err := m.EnvoyAccessLogService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyMetricsService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnvoyMetricsService == nil {
				m.EnvoyMetricsService = &RemoteService{}
			}
			if err := m.EnvoyMetricsService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.TLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProxy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProxy
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthProxy
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProxy
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProxy(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthProxy
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProxy = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProxy   = fmt.Errorf("proto: integer overflow")
)
