// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mcp/v1alpha1/mcp.proto

package v1alpha1

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	rpc "istio.io/gogo-genproto/googleapis/google/rpc"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Identifies a specific MCP sink node instance. The node identifier is
// presented to the resource source, which may use this identifier
// to distinguish per sink configuration for serving. This
// information is not authoritative. Authoritative identity should come
// from the underlying transport layer (e.g. rpc credentials).
type SinkNode struct {
	// An opaque identifier for the MCP node.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Opaque annotations extending the node identifier.
	Annotations          map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SinkNode) Reset()         { *m = SinkNode{} }
func (m *SinkNode) String() string { return proto.CompactTextString(m) }
func (*SinkNode) ProtoMessage()    {}
func (*SinkNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{0}
}
func (m *SinkNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SinkNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SinkNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SinkNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SinkNode.Merge(m, src)
}
func (m *SinkNode) XXX_Size() int {
	return m.Size()
}
func (m *SinkNode) XXX_DiscardUnknown() {
	xxx_messageInfo_SinkNode.DiscardUnknown(m)
}

var xxx_messageInfo_SinkNode proto.InternalMessageInfo

func (m *SinkNode) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SinkNode) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// A MeshConfigRequest requests a set of versioned resources of the
// same type for a given client.
type MeshConfigRequest struct {
	// The version_info provided in the request messages will be the
	// version_info received with the most recent successfully processed
	// response or empty on the first request. It is expected that no
	// new request is sent after a response is received until the client
	// instance is ready to ACK/NACK the new configuration. ACK/NACK
	// takes place by returning the new API config version as applied or
	// the previous API config version respectively. Each type_url (see
	// below) has an independent version associated with it.
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The sink node making the request.
	SinkNode *SinkNode `protobuf:"bytes,2,opt,name=sink_node,json=sinkNode,proto3" json:"sink_node,omitempty"`
	// Type of the resource that is being requested, e.g.
	// "type.googleapis.com/istio.io.networking.v1alpha3.VirtualService".
	TypeUrl string `protobuf:"bytes,3,opt,name=type_url,json=typeUrl,proto3" json:"type_url,omitempty"`
	// The nonce corresponding to MeshConfigResponse being
	// ACK/NACKed. See above discussion on version_info and the
	// MeshConfigResponse nonce comment. This may be empty if no nonce is
	// available, e.g. at startup.
	ResponseNonce string `protobuf:"bytes,4,opt,name=response_nonce,json=responseNonce,proto3" json:"response_nonce,omitempty"`
	// This is populated when the previous MeshConfigResponse failed to
	// update configuration. The *message* field in *error_details*
	// provides the client internal exception related to the failure. It
	// is only intended for consumption during manual debugging, the
	// string provided is not guaranteed to be stable across client
	// versions.
	ErrorDetail          *rpc.Status `protobuf:"bytes,5,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MeshConfigRequest) Reset()         { *m = MeshConfigRequest{} }
func (m *MeshConfigRequest) String() string { return proto.CompactTextString(m) }
func (*MeshConfigRequest) ProtoMessage()    {}
func (*MeshConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{1}
}
func (m *MeshConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfigRequest.Merge(m, src)
}
func (m *MeshConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfigRequest proto.InternalMessageInfo

func (m *MeshConfigRequest) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *MeshConfigRequest) GetSinkNode() *SinkNode {
	if m != nil {
		return m.SinkNode
	}
	return nil
}

func (m *MeshConfigRequest) GetTypeUrl() string {
	if m != nil {
		return m.TypeUrl
	}
	return ""
}

func (m *MeshConfigRequest) GetResponseNonce() string {
	if m != nil {
		return m.ResponseNonce
	}
	return ""
}

func (m *MeshConfigRequest) GetErrorDetail() *rpc.Status {
	if m != nil {
		return m.ErrorDetail
	}
	return nil
}

// A MeshConfigResponse delivers a set of versioned resources of the
// same type in response to a MeshConfigRequest.
type MeshConfigResponse struct {
	// The version of the response data.
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The response resources wrapped in the common MCP *Resource*
	// message.
	Resources []Resource `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources"`
	// Type URL for resources wrapped in the provided resources(s). This
	// must be consistent with the type_url in the wrapper messages if
	// resources is non-empty.
	TypeUrl string `protobuf:"bytes,3,opt,name=type_url,json=typeUrl,proto3" json:"type_url,omitempty"`
	// The nonce provides a way to explicitly ack a specific
	// MeshConfigResponse in a following MeshConfigRequest. Additional
	// messages may have been sent by client to the management server for
	// the previous version on the stream prior to this
	// MeshConfigResponse, that were unprocessed at response send
	// time. The nonce allows the management server to ignore any
	// further MeshConfigRequests for the previous version until a
	// MeshConfigRequest bearing the nonce.
	Nonce                string   `protobuf:"bytes,4,opt,name=nonce,proto3" json:"nonce,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfigResponse) Reset()         { *m = MeshConfigResponse{} }
func (m *MeshConfigResponse) String() string { return proto.CompactTextString(m) }
func (*MeshConfigResponse) ProtoMessage()    {}
func (*MeshConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{2}
}
func (m *MeshConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfigResponse.Merge(m, src)
}
func (m *MeshConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfigResponse proto.InternalMessageInfo

func (m *MeshConfigResponse) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *MeshConfigResponse) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *MeshConfigResponse) GetTypeUrl() string {
	if m != nil {
		return m.TypeUrl
	}
	return ""
}

func (m *MeshConfigResponse) GetNonce() string {
	if m != nil {
		return m.Nonce
	}
	return ""
}

// IncrementalMeshConfigRequest are be sent in 2 situations:
//
//   1. Initial message in a MCP bidirectional gRPC stream.
//
//   2. As a ACK or NACK response to a previous IncrementalMeshConfigResponse.
//      In this case the response_nonce is set to the nonce value in the Response.
//      ACK or NACK is determined by the absence or presence of error_detail.
type IncrementalMeshConfigRequest struct {
	// The sink node making the request.
	SinkNode *SinkNode `protobuf:"bytes,1,opt,name=sink_node,json=sinkNode,proto3" json:"sink_node,omitempty"`
	// Type of the resource that is being requested, e.g.
	// "type.googleapis.com/istio.io.networking.v1alpha3.VirtualService".
	TypeUrl string `protobuf:"bytes,2,opt,name=type_url,json=typeUrl,proto3" json:"type_url,omitempty"`
	// When the IncrementalMeshConfigRequest is the first in a stream,
	// the initial_resource_versions must be populated. Otherwise,
	// initial_resource_versions must be omitted. The keys are the
	// resources names of the MCP resources known to the MCP client. The
	// values in the map are the associated resource level version info.
	InitialResourceVersions map[string]string `protobuf:"bytes,3,rep,name=initial_resource_versions,json=initialResourceVersions,proto3" json:"initial_resource_versions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// When the IncrementalMeshConfigRequest is a ACK or NACK message in response
	// to a previous IncrementalMeshConfigResponse, the response_nonce must be the
	// nonce in the IncrementalMeshConfigResponse.
	// Otherwise response_nonce must be omitted.
	ResponseNonce string `protobuf:"bytes,4,opt,name=response_nonce,json=responseNonce,proto3" json:"response_nonce,omitempty"`
	// This is populated when the previous IncrementalMeshConfigResponses
	// failed to update configuration. The *message* field in *error_details*
	// provides the client internal exception related to the failure.
	ErrorDetail          *rpc.Status `protobuf:"bytes,5,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *IncrementalMeshConfigRequest) Reset()         { *m = IncrementalMeshConfigRequest{} }
func (m *IncrementalMeshConfigRequest) String() string { return proto.CompactTextString(m) }
func (*IncrementalMeshConfigRequest) ProtoMessage()    {}
func (*IncrementalMeshConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{3}
}
func (m *IncrementalMeshConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IncrementalMeshConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IncrementalMeshConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IncrementalMeshConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncrementalMeshConfigRequest.Merge(m, src)
}
func (m *IncrementalMeshConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *IncrementalMeshConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IncrementalMeshConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IncrementalMeshConfigRequest proto.InternalMessageInfo

func (m *IncrementalMeshConfigRequest) GetSinkNode() *SinkNode {
	if m != nil {
		return m.SinkNode
	}
	return nil
}

func (m *IncrementalMeshConfigRequest) GetTypeUrl() string {
	if m != nil {
		return m.TypeUrl
	}
	return ""
}

func (m *IncrementalMeshConfigRequest) GetInitialResourceVersions() map[string]string {
	if m != nil {
		return m.InitialResourceVersions
	}
	return nil
}

func (m *IncrementalMeshConfigRequest) GetResponseNonce() string {
	if m != nil {
		return m.ResponseNonce
	}
	return ""
}

func (m *IncrementalMeshConfigRequest) GetErrorDetail() *rpc.Status {
	if m != nil {
		return m.ErrorDetail
	}
	return nil
}

// IncrementalMeshConfigResponses do not need to include a full
// snapshot of the tracked resources. Instead they are a diff to the
// state of a MCP client. Per resource versions allow servers and
// clients to track state at the resource granularity. An MCP
// incremental session is always in the context of a gRPC
// bidirectional stream. This allows the MCP server to keep track of
// the state of MCP clients connected to it.
//
// In Incremental MCP the nonce field is required and used to pair
// IncrementalMeshConfigResponse to an IncrementalMeshConfigRequest
// ACK or NACK.  Optionally, a response message level
// system_version_info is present for debugging purposes only.
type IncrementalMeshConfigResponse struct {
	// The version of the response data (used for debugging).
	SystemVersionInfo string `protobuf:"bytes,1,opt,name=system_version_info,json=systemVersionInfo,proto3" json:"system_version_info,omitempty"`
	// The response resources wrapped in the common MCP *Resource*
	// message. These are typed resources that match the type url in the
	// IncrementalMeshConfigRequest.
	Resources []Resource `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources"`
	// Resources names of resources that have be deleted and to be
	// removed from the MCP Client.  Removed resources for missing
	// resources can be ignored.
	RemovedResources []string `protobuf:"bytes,3,rep,name=removed_resources,json=removedResources,proto3" json:"removed_resources,omitempty"`
	// The nonce provides a way for IncrementalMeshConfigRequests to
	// uniquely reference an IncrementalMeshConfigResponse. The nonce is
	// required.
	Nonce                string   `protobuf:"bytes,4,opt,name=nonce,proto3" json:"nonce,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncrementalMeshConfigResponse) Reset()         { *m = IncrementalMeshConfigResponse{} }
func (m *IncrementalMeshConfigResponse) String() string { return proto.CompactTextString(m) }
func (*IncrementalMeshConfigResponse) ProtoMessage()    {}
func (*IncrementalMeshConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{4}
}
func (m *IncrementalMeshConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IncrementalMeshConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IncrementalMeshConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IncrementalMeshConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncrementalMeshConfigResponse.Merge(m, src)
}
func (m *IncrementalMeshConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *IncrementalMeshConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IncrementalMeshConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IncrementalMeshConfigResponse proto.InternalMessageInfo

func (m *IncrementalMeshConfigResponse) GetSystemVersionInfo() string {
	if m != nil {
		return m.SystemVersionInfo
	}
	return ""
}

func (m *IncrementalMeshConfigResponse) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *IncrementalMeshConfigResponse) GetRemovedResources() []string {
	if m != nil {
		return m.RemovedResources
	}
	return nil
}

func (m *IncrementalMeshConfigResponse) GetNonce() string {
	if m != nil {
		return m.Nonce
	}
	return ""
}

// A RequestResource can be sent in two situations:
//
// Initial message in an MCP bidirectional change stream
// as an ACK or NACK response to a previous Resources. In
// this case the response_nonce is set to the nonce value
// in the Resources. ACK/NACK is determined by the presence
// of error_detail.
//
// * ACK  (nonce!="",error_details==nil)
// * NACK (nonce!="",error_details!=nil)
// * New/Update request (nonce=="",error_details ignored)
//
type RequestResources struct {
	// The sink node making the request.
	SinkNode *SinkNode `protobuf:"bytes,1,opt,name=sink_node,json=sinkNode,proto3" json:"sink_node,omitempty"`
	// Type of resource collection that is being requested, e.g.
	//
	// istio/networking/v1alpha3/VirtualService
	// k8s/<apiVersion>/<kind>
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	// When the RequestResources is the first in a stream, the initial_resource_versions must
	// be populated. Otherwise, initial_resource_versions must be omitted. The keys are the
	// resources names of the MCP resources known to the MCP client. The values in the map
	// are the associated resource level version info.
	InitialResourceVersions map[string]string `protobuf:"bytes,3,rep,name=initial_resource_versions,json=initialResourceVersions,proto3" json:"initial_resource_versions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// When the RequestResources is an ACK or NACK message in response to a previous RequestResources,
	// the response_nonce must be the nonce in the RequestResources. Otherwise response_nonce must
	// be omitted.
	ResponseNonce string `protobuf:"bytes,4,opt,name=response_nonce,json=responseNonce,proto3" json:"response_nonce,omitempty"`
	// This is populated when the previously received resources could not be applied
	// The *message* field in *error_details* provides the source internal error
	// related to the failure.
	ErrorDetail *rpc.Status `protobuf:"bytes,5,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
	// Request an incremental update for the specified collection. The source may choose to
	// honor this request or ignore and and provide a full-state update in the corresponding
	// `Resource` response.
	Incremental          bool     `protobuf:"varint,6,opt,name=incremental,proto3" json:"incremental,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestResources) Reset()         { *m = RequestResources{} }
func (m *RequestResources) String() string { return proto.CompactTextString(m) }
func (*RequestResources) ProtoMessage()    {}
func (*RequestResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{5}
}
func (m *RequestResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestResources.Merge(m, src)
}
func (m *RequestResources) XXX_Size() int {
	return m.Size()
}
func (m *RequestResources) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestResources.DiscardUnknown(m)
}

var xxx_messageInfo_RequestResources proto.InternalMessageInfo

func (m *RequestResources) GetSinkNode() *SinkNode {
	if m != nil {
		return m.SinkNode
	}
	return nil
}

func (m *RequestResources) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *RequestResources) GetInitialResourceVersions() map[string]string {
	if m != nil {
		return m.InitialResourceVersions
	}
	return nil
}

func (m *RequestResources) GetResponseNonce() string {
	if m != nil {
		return m.ResponseNonce
	}
	return ""
}

func (m *RequestResources) GetErrorDetail() *rpc.Status {
	if m != nil {
		return m.ErrorDetail
	}
	return nil
}

func (m *RequestResources) GetIncremental() bool {
	if m != nil {
		return m.Incremental
	}
	return false
}

// Resources do not need to include a full snapshot of the tracked
// resources. Instead they are a diff to the state of a MCP client.
// Per resource versions allow sources and sinks to track state at
// the resource granularity. An MCP incremental session is always
// in the context of a gRPC bidirectional stream. This allows the
// MCP source to keep track of the state of MCP sink connected to
// it.
//
// In Incremental MCP the nonce field is required and used to pair
// Resources to an RequestResources ACK or NACK.
type Resources struct {
	// The version of the response data (used for debugging).
	SystemVersionInfo string `protobuf:"bytes,1,opt,name=system_version_info,json=systemVersionInfo,proto3" json:"system_version_info,omitempty"`
	// Type of resource collection that is being requested, e.g.
	//
	// istio/networking/v1alpha3/VirtualService
	// k8s/<apiVersion>/<kind>
	Collection string `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	// The response resources wrapped in the common MCP *Resource* message.
	// These are typed resources that match the type url in the
	// RequestResources message.
	//
	// When `incremental` is true, this contains an array of resources to add/update
	// for the specified collection. This modifies the existing collection at the sink
	//
	// When `incremental` is false, this contains the full set of resources for the
	// specified collection. This replaces any previously delivered resources.
	Resources []Resource `protobuf:"bytes,3,rep,name=resources,proto3" json:"resources"`
	// Names of resources that have been deleted and to be
	// removed from the MCP sink node. Removed resources for missing
	// resources can be ignored.
	//
	// When `incremental` is true, this contains an array of resource names to remove
	// for the specified collection. This modifies the existing resource collection at
	// the sink.
	//
	// When `incremental` is false, this field should be ignored.
	RemovedResources []string `protobuf:"bytes,4,rep,name=removed_resources,json=removedResources,proto3" json:"removed_resources,omitempty"`
	// Required. The nonce provides a way for RequestChange to uniquely
	// reference a RequestResources.
	Nonce string `protobuf:"bytes,5,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// This resource response is an incremental update. The source should only send
	// incremental updates if the sink requested them.
	Incremental          bool     `protobuf:"varint,6,opt,name=incremental,proto3" json:"incremental,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_0713683a7297bd65, []int{6}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return m.Size()
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetSystemVersionInfo() string {
	if m != nil {
		return m.SystemVersionInfo
	}
	return ""
}

func (m *Resources) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *Resources) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Resources) GetRemovedResources() []string {
	if m != nil {
		return m.RemovedResources
	}
	return nil
}

func (m *Resources) GetNonce() string {
	if m != nil {
		return m.Nonce
	}
	return ""
}

func (m *Resources) GetIncremental() bool {
	if m != nil {
		return m.Incremental
	}
	return false
}

func init() {
	proto.RegisterType((*SinkNode)(nil), "istio.mcp.v1alpha1.SinkNode")
	proto.RegisterMapType((map[string]string)(nil), "istio.mcp.v1alpha1.SinkNode.AnnotationsEntry")
	proto.RegisterType((*MeshConfigRequest)(nil), "istio.mcp.v1alpha1.MeshConfigRequest")
	proto.RegisterType((*MeshConfigResponse)(nil), "istio.mcp.v1alpha1.MeshConfigResponse")
	proto.RegisterType((*IncrementalMeshConfigRequest)(nil), "istio.mcp.v1alpha1.IncrementalMeshConfigRequest")
	proto.RegisterMapType((map[string]string)(nil), "istio.mcp.v1alpha1.IncrementalMeshConfigRequest.InitialResourceVersionsEntry")
	proto.RegisterType((*IncrementalMeshConfigResponse)(nil), "istio.mcp.v1alpha1.IncrementalMeshConfigResponse")
	proto.RegisterType((*RequestResources)(nil), "istio.mcp.v1alpha1.RequestResources")
	proto.RegisterMapType((map[string]string)(nil), "istio.mcp.v1alpha1.RequestResources.InitialResourceVersionsEntry")
	proto.RegisterType((*Resources)(nil), "istio.mcp.v1alpha1.Resources")
}

func init() { proto.RegisterFile("mcp/v1alpha1/mcp.proto", fileDescriptor_0713683a7297bd65) }

var fileDescriptor_0713683a7297bd65 = []byte{
	// 774 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcd, 0x6e, 0xeb, 0x44,
	0x14, 0xbe, 0xe3, 0x34, 0x97, 0xe4, 0xa4, 0x54, 0xe9, 0x50, 0x51, 0xc7, 0xf7, 0xde, 0x10, 0x22,
	0x8a, 0x22, 0x55, 0x38, 0x6d, 0x10, 0x12, 0xb0, 0x40, 0xb4, 0xd0, 0x45, 0x91, 0x5a, 0x24, 0x47,
	0x74, 0xc1, 0xc6, 0x72, 0xed, 0xa9, 0x3b, 0x8a, 0x33, 0x63, 0x66, 0x26, 0x91, 0xb2, 0x60, 0xc3,
	0x0e, 0xf1, 0x0c, 0xec, 0x51, 0x79, 0x01, 0x1e, 0xa1, 0x4b, 0x16, 0xac, 0x11, 0xca, 0x92, 0xa7,
	0x40, 0xfe, 0xab, 0x1d, 0xea, 0x26, 0x0d, 0x14, 0x89, 0x8d, 0x35, 0x73, 0xce, 0x99, 0xef, 0xfc,
	0x7c, 0xdf, 0x8c, 0x0c, 0x6f, 0x8e, 0xdd, 0xb0, 0x3f, 0x3d, 0x74, 0x82, 0xf0, 0xda, 0x39, 0xec,
	0x8f, 0xdd, 0xd0, 0x0c, 0x05, 0x57, 0x1c, 0x63, 0x2a, 0x15, 0xe5, 0x66, 0x64, 0xc8, 0xbc, 0xc6,
	0xae, 0xcf, 0xb9, 0x1f, 0x90, 0xbe, 0x08, 0xdd, 0xbe, 0x54, 0x8e, 0x9a, 0xc8, 0x24, 0xd8, 0xd8,
	0xf1, 0xb9, 0xcf, 0xe3, 0x65, 0x3f, 0x5a, 0xa5, 0xd6, 0x17, 0x0b, 0xd0, 0x82, 0x48, 0x3e, 0x11,
	0x2e, 0x49, 0x9c, 0xdd, 0x9f, 0x11, 0xd4, 0x86, 0x94, 0x8d, 0xce, 0xb9, 0x47, 0xf0, 0x16, 0x68,
	0xd4, 0xd3, 0x51, 0x07, 0xf5, 0xea, 0x96, 0x46, 0x3d, 0xfc, 0x25, 0x34, 0x1c, 0xc6, 0xb8, 0x72,
	0x14, 0xe5, 0x4c, 0xea, 0x5a, 0xa7, 0xd2, 0x6b, 0x0c, 0xde, 0x33, 0xef, 0x97, 0x64, 0x66, 0x10,
	0xe6, 0x51, 0x1e, 0x7f, 0xc2, 0x94, 0x98, 0x59, 0x45, 0x04, 0xe3, 0x13, 0x68, 0xfe, 0x3d, 0x00,
	0x37, 0xa1, 0x32, 0x22, 0xb3, 0x34, 0x6b, 0xb4, 0xc4, 0x3b, 0x50, 0x9d, 0x3a, 0xc1, 0x84, 0xe8,
	0x5a, 0x6c, 0x4b, 0x36, 0x1f, 0x6b, 0x1f, 0xa2, 0xee, 0x9f, 0x08, 0xb6, 0xcf, 0x88, 0xbc, 0xfe,
	0x8c, 0xb3, 0x2b, 0xea, 0x5b, 0xe4, 0x9b, 0x09, 0x91, 0x0a, 0xbf, 0x0d, 0x9b, 0x53, 0x22, 0x24,
	0xe5, 0xcc, 0xa6, 0xec, 0x8a, 0xa7, 0x50, 0x8d, 0xd4, 0x76, 0xca, 0xae, 0x38, 0xfe, 0x08, 0xea,
	0x92, 0xb2, 0x91, 0xcd, 0xb8, 0x97, 0xc0, 0x36, 0x06, 0x2f, 0x97, 0xf5, 0x61, 0xd5, 0x64, 0x36,
	0x94, 0x16, 0xd4, 0xd4, 0x2c, 0x24, 0xf6, 0x44, 0x04, 0x7a, 0x25, 0x46, 0x7e, 0x2d, 0xda, 0x7f,
	0x25, 0x02, 0xbc, 0x07, 0x5b, 0x82, 0xc8, 0x90, 0x33, 0x49, 0x6c, 0xc6, 0x99, 0x4b, 0xf4, 0x8d,
	0x38, 0xe0, 0xf5, 0xcc, 0x7a, 0x1e, 0x19, 0xf1, 0x07, 0xb0, 0x49, 0x84, 0xe0, 0xc2, 0xf6, 0x88,
	0x72, 0x68, 0xa0, 0x57, 0xe3, 0xfc, 0xd8, 0x4c, 0x68, 0x34, 0x45, 0xe8, 0x9a, 0xc3, 0x98, 0x46,
	0xab, 0x11, 0xc7, 0x7d, 0x1e, 0x87, 0x75, 0x6f, 0x10, 0xe0, 0x62, 0xb3, 0x09, 0xe4, 0x63, 0xba,
	0xfd, 0x14, 0xea, 0x19, 0xcd, 0x19, 0x6b, 0xa5, 0xdd, 0x5a, 0x69, 0xd0, 0xf1, 0xc6, 0xed, 0xef,
	0x6f, 0x3d, 0xb3, 0xf2, 0x43, 0xcb, 0x9a, 0xde, 0x81, 0x6a, 0xb1, 0xd7, 0x64, 0xd3, 0xbd, 0xa9,
	0xc0, 0xcb, 0x53, 0xe6, 0x0a, 0x32, 0x26, 0x4c, 0x39, 0xc1, 0x7d, 0x92, 0x16, 0x18, 0x40, 0xff,
	0x98, 0x01, 0x6d, 0xb1, 0x98, 0xef, 0x11, 0xb4, 0x28, 0xa3, 0x8a, 0x3a, 0x81, 0x9d, 0x55, 0x6f,
	0xa7, 0xa3, 0x90, 0x7a, 0x25, 0x6e, 0xfd, 0xac, 0x2c, 0xcd, 0xb2, 0x5a, 0xcd, 0xd3, 0x04, 0x31,
	0x1b, 0xcf, 0x45, 0x8a, 0x97, 0x08, 0x7a, 0x97, 0x96, 0x7b, 0xff, 0x5b, 0x35, 0x18, 0x5f, 0x44,
	0xf3, 0x7d, 0xb8, 0xac, 0xb5, 0xae, 0xd1, 0x6f, 0x08, 0x5e, 0x3d, 0x30, 0x80, 0x54, 0x64, 0x26,
	0xbc, 0x21, 0x67, 0x52, 0x91, 0xb1, 0x5d, 0xa2, 0xb5, 0xed, 0xc4, 0x75, 0xf1, 0xa4, 0x8a, 0xdb,
	0x87, 0x6d, 0x41, 0xc6, 0x7c, 0x4a, 0x3c, 0x3b, 0x47, 0x8a, 0x08, 0xac, 0x5b, 0xcd, 0xd4, 0x61,
	0xdd, 0x05, 0x97, 0x6b, 0xf0, 0x97, 0x0a, 0x34, 0x53, 0x0a, 0xf3, 0xd0, 0x7f, 0xa1, 0xbb, 0x36,
	0x80, 0xcb, 0x83, 0x80, 0xb8, 0xd1, 0x6b, 0x95, 0x4e, 0xb1, 0x60, 0xc1, 0xdf, 0xae, 0xd6, 0xde,
	0x51, 0xf9, 0x10, 0x16, 0x6b, 0xfc, 0x3f, 0xea, 0x0d, 0x77, 0xa0, 0x41, 0x73, 0x89, 0xe8, 0xcf,
	0x3b, 0xa8, 0x57, 0xb3, 0x8a, 0xa6, 0x27, 0x55, 0xe4, 0x77, 0x1a, 0xd4, 0x73, 0xce, 0xd6, 0x55,
	0xdf, 0x2a, 0xa2, 0x16, 0xd4, 0x59, 0x79, 0x32, 0x75, 0x6e, 0xac, 0x52, 0x67, 0xb5, 0xa0, 0xce,
	0xd5, 0x03, 0x1d, 0xfc, 0xa8, 0xc1, 0x8b, 0x23, 0xdf, 0x17, 0xc4, 0x77, 0x14, 0xf1, 0xf2, 0x5b,
	0x39, 0x24, 0x62, 0x4a, 0x5d, 0x82, 0x43, 0x68, 0x0d, 0x95, 0x20, 0xce, 0x38, 0x0f, 0xca, 0x93,
	0xee, 0x95, 0x35, 0x74, 0xef, 0x69, 0x33, 0xde, 0x5d, 0x15, 0x96, 0x48, 0xa7, 0xfb, 0xac, 0x87,
	0x0e, 0x10, 0xfe, 0x01, 0x41, 0xbb, 0xf0, 0x50, 0x94, 0xe5, 0x3d, 0x58, 0xf7, 0x75, 0x35, 0x0e,
	0xd7, 0x38, 0x51, 0xac, 0x66, 0x30, 0x85, 0xad, 0x2c, 0xef, 0x30, 0xfe, 0x62, 0x0f, 0x76, 0x4f,
	0xa4, 0x72, 0x2e, 0x03, 0x2a, 0xaf, 0xef, 0x5c, 0xf1, 0x88, 0xf0, 0x3b, 0x8f, 0xb9, 0x79, 0xc6,
	0xab, 0x65, 0x32, 0x90, 0x69, 0x5e, 0x05, 0x9b, 0x77, 0xe0, 0x94, 0x8d, 0x96, 0x65, 0x5d, 0x8e,
	0x67, 0x3c, 0xaa, 0xa8, 0x24, 0xeb, 0xf1, 0xfe, 0x4f, 0xf3, 0x36, 0xba, 0x9d, 0xb7, 0xd1, 0xaf,
	0xf3, 0x36, 0xfa, 0x63, 0xde, 0x46, 0x5f, 0xb7, 0x92, 0xc3, 0x94, 0xf7, 0x9d, 0x90, 0xf6, 0x8b,
	0x7f, 0x75, 0x97, 0xcf, 0xe3, 0xbf, 0xb9, 0xf7, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x4e, 0x31,
	0xdd, 0xdb, 0x47, 0x0a, 0x00, 0x00,
}

func (this *SinkNode) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SinkNode)
	if !ok {
		that2, ok := that.(SinkNode)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if this.Annotations[i] != that1.Annotations[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MeshConfigRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MeshConfigRequest)
	if !ok {
		that2, ok := that.(MeshConfigRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VersionInfo != that1.VersionInfo {
		return false
	}
	if !this.SinkNode.Equal(that1.SinkNode) {
		return false
	}
	if this.TypeUrl != that1.TypeUrl {
		return false
	}
	if this.ResponseNonce != that1.ResponseNonce {
		return false
	}
	if !this.ErrorDetail.Equal(that1.ErrorDetail) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MeshConfigResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MeshConfigResponse)
	if !ok {
		that2, ok := that.(MeshConfigResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VersionInfo != that1.VersionInfo {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if this.TypeUrl != that1.TypeUrl {
		return false
	}
	if this.Nonce != that1.Nonce {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *IncrementalMeshConfigRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IncrementalMeshConfigRequest)
	if !ok {
		that2, ok := that.(IncrementalMeshConfigRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SinkNode.Equal(that1.SinkNode) {
		return false
	}
	if this.TypeUrl != that1.TypeUrl {
		return false
	}
	if len(this.InitialResourceVersions) != len(that1.InitialResourceVersions) {
		return false
	}
	for i := range this.InitialResourceVersions {
		if this.InitialResourceVersions[i] != that1.InitialResourceVersions[i] {
			return false
		}
	}
	if this.ResponseNonce != that1.ResponseNonce {
		return false
	}
	if !this.ErrorDetail.Equal(that1.ErrorDetail) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *IncrementalMeshConfigResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IncrementalMeshConfigResponse)
	if !ok {
		that2, ok := that.(IncrementalMeshConfigResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SystemVersionInfo != that1.SystemVersionInfo {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if len(this.RemovedResources) != len(that1.RemovedResources) {
		return false
	}
	for i := range this.RemovedResources {
		if this.RemovedResources[i] != that1.RemovedResources[i] {
			return false
		}
	}
	if this.Nonce != that1.Nonce {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RequestResources) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestResources)
	if !ok {
		that2, ok := that.(RequestResources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SinkNode.Equal(that1.SinkNode) {
		return false
	}
	if this.Collection != that1.Collection {
		return false
	}
	if len(this.InitialResourceVersions) != len(that1.InitialResourceVersions) {
		return false
	}
	for i := range this.InitialResourceVersions {
		if this.InitialResourceVersions[i] != that1.InitialResourceVersions[i] {
			return false
		}
	}
	if this.ResponseNonce != that1.ResponseNonce {
		return false
	}
	if !this.ErrorDetail.Equal(that1.ErrorDetail) {
		return false
	}
	if this.Incremental != that1.Incremental {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resources) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Resources)
	if !ok {
		that2, ok := that.(Resources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SystemVersionInfo != that1.SystemVersionInfo {
		return false
	}
	if this.Collection != that1.Collection {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if len(this.RemovedResources) != len(that1.RemovedResources) {
		return false
	}
	for i := range this.RemovedResources {
		if this.RemovedResources[i] != that1.RemovedResources[i] {
			return false
		}
	}
	if this.Nonce != that1.Nonce {
		return false
	}
	if this.Incremental != that1.Incremental {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AggregatedMeshConfigServiceClient is the client API for AggregatedMeshConfigService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AggregatedMeshConfigServiceClient interface {
	// StreamAggregatedResources provides the ability to carefully
	// sequence updates across multiple resource types. A single stream
	// is used with multiple independent MeshConfigRequest /
	// MeshConfigResponses sequences multiplexed via the type URL.
	StreamAggregatedResources(ctx context.Context, opts ...grpc.CallOption) (AggregatedMeshConfigService_StreamAggregatedResourcesClient, error)
	// IncrementalAggregatedResources provides the ability to incrementally
	// update the resources on the client. This supports the goal of
	// scalability of MCP resources.
	IncrementalAggregatedResources(ctx context.Context, opts ...grpc.CallOption) (AggregatedMeshConfigService_IncrementalAggregatedResourcesClient, error)
}

type aggregatedMeshConfigServiceClient struct {
	cc *grpc.ClientConn
}

func NewAggregatedMeshConfigServiceClient(cc *grpc.ClientConn) AggregatedMeshConfigServiceClient {
	return &aggregatedMeshConfigServiceClient{cc}
}

func (c *aggregatedMeshConfigServiceClient) StreamAggregatedResources(ctx context.Context, opts ...grpc.CallOption) (AggregatedMeshConfigService_StreamAggregatedResourcesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AggregatedMeshConfigService_serviceDesc.Streams[0], "/istio.mcp.v1alpha1.AggregatedMeshConfigService/StreamAggregatedResources", opts...)
	if err != nil {
		return nil, err
	}
	x := &aggregatedMeshConfigServiceStreamAggregatedResourcesClient{stream}
	return x, nil
}

type AggregatedMeshConfigService_StreamAggregatedResourcesClient interface {
	Send(*MeshConfigRequest) error
	Recv() (*MeshConfigResponse, error)
	grpc.ClientStream
}

type aggregatedMeshConfigServiceStreamAggregatedResourcesClient struct {
	grpc.ClientStream
}

func (x *aggregatedMeshConfigServiceStreamAggregatedResourcesClient) Send(m *MeshConfigRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *aggregatedMeshConfigServiceStreamAggregatedResourcesClient) Recv() (*MeshConfigResponse, error) {
	m := new(MeshConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aggregatedMeshConfigServiceClient) IncrementalAggregatedResources(ctx context.Context, opts ...grpc.CallOption) (AggregatedMeshConfigService_IncrementalAggregatedResourcesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AggregatedMeshConfigService_serviceDesc.Streams[1], "/istio.mcp.v1alpha1.AggregatedMeshConfigService/IncrementalAggregatedResources", opts...)
	if err != nil {
		return nil, err
	}
	x := &aggregatedMeshConfigServiceIncrementalAggregatedResourcesClient{stream}
	return x, nil
}

type AggregatedMeshConfigService_IncrementalAggregatedResourcesClient interface {
	Send(*IncrementalMeshConfigRequest) error
	Recv() (*IncrementalMeshConfigResponse, error)
	grpc.ClientStream
}

type aggregatedMeshConfigServiceIncrementalAggregatedResourcesClient struct {
	grpc.ClientStream
}

func (x *aggregatedMeshConfigServiceIncrementalAggregatedResourcesClient) Send(m *IncrementalMeshConfigRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *aggregatedMeshConfigServiceIncrementalAggregatedResourcesClient) Recv() (*IncrementalMeshConfigResponse, error) {
	m := new(IncrementalMeshConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// AggregatedMeshConfigServiceServer is the server API for AggregatedMeshConfigService service.
type AggregatedMeshConfigServiceServer interface {
	// StreamAggregatedResources provides the ability to carefully
	// sequence updates across multiple resource types. A single stream
	// is used with multiple independent MeshConfigRequest /
	// MeshConfigResponses sequences multiplexed via the type URL.
	StreamAggregatedResources(AggregatedMeshConfigService_StreamAggregatedResourcesServer) error
	// IncrementalAggregatedResources provides the ability to incrementally
	// update the resources on the client. This supports the goal of
	// scalability of MCP resources.
	IncrementalAggregatedResources(AggregatedMeshConfigService_IncrementalAggregatedResourcesServer) error
}

// UnimplementedAggregatedMeshConfigServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAggregatedMeshConfigServiceServer struct {
}

func (*UnimplementedAggregatedMeshConfigServiceServer) StreamAggregatedResources(srv AggregatedMeshConfigService_StreamAggregatedResourcesServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamAggregatedResources not implemented")
}
func (*UnimplementedAggregatedMeshConfigServiceServer) IncrementalAggregatedResources(srv AggregatedMeshConfigService_IncrementalAggregatedResourcesServer) error {
	return status.Errorf(codes.Unimplemented, "method IncrementalAggregatedResources not implemented")
}

func RegisterAggregatedMeshConfigServiceServer(s *grpc.Server, srv AggregatedMeshConfigServiceServer) {
	s.RegisterService(&_AggregatedMeshConfigService_serviceDesc, srv)
}

func _AggregatedMeshConfigService_StreamAggregatedResources_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AggregatedMeshConfigServiceServer).StreamAggregatedResources(&aggregatedMeshConfigServiceStreamAggregatedResourcesServer{stream})
}

type AggregatedMeshConfigService_StreamAggregatedResourcesServer interface {
	Send(*MeshConfigResponse) error
	Recv() (*MeshConfigRequest, error)
	grpc.ServerStream
}

type aggregatedMeshConfigServiceStreamAggregatedResourcesServer struct {
	grpc.ServerStream
}

func (x *aggregatedMeshConfigServiceStreamAggregatedResourcesServer) Send(m *MeshConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *aggregatedMeshConfigServiceStreamAggregatedResourcesServer) Recv() (*MeshConfigRequest, error) {
	m := new(MeshConfigRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _AggregatedMeshConfigService_IncrementalAggregatedResources_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AggregatedMeshConfigServiceServer).IncrementalAggregatedResources(&aggregatedMeshConfigServiceIncrementalAggregatedResourcesServer{stream})
}

type AggregatedMeshConfigService_IncrementalAggregatedResourcesServer interface {
	Send(*IncrementalMeshConfigResponse) error
	Recv() (*IncrementalMeshConfigRequest, error)
	grpc.ServerStream
}

type aggregatedMeshConfigServiceIncrementalAggregatedResourcesServer struct {
	grpc.ServerStream
}

func (x *aggregatedMeshConfigServiceIncrementalAggregatedResourcesServer) Send(m *IncrementalMeshConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *aggregatedMeshConfigServiceIncrementalAggregatedResourcesServer) Recv() (*IncrementalMeshConfigRequest, error) {
	m := new(IncrementalMeshConfigRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _AggregatedMeshConfigService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mcp.v1alpha1.AggregatedMeshConfigService",
	HandlerType: (*AggregatedMeshConfigServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamAggregatedResources",
			Handler:       _AggregatedMeshConfigService_StreamAggregatedResources_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "IncrementalAggregatedResources",
			Handler:       _AggregatedMeshConfigService_IncrementalAggregatedResources_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "mcp/v1alpha1/mcp.proto",
}

// ResourceSourceClient is the client API for ResourceSource service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceSourceClient interface {
	// The sink, acting as gRPC client, establishes a new resource stream
	// with the source. The sink sends RequestResources message to
	// and receives Resources messages from the source.
	EstablishResourceStream(ctx context.Context, opts ...grpc.CallOption) (ResourceSource_EstablishResourceStreamClient, error)
}

type resourceSourceClient struct {
	cc *grpc.ClientConn
}

func NewResourceSourceClient(cc *grpc.ClientConn) ResourceSourceClient {
	return &resourceSourceClient{cc}
}

func (c *resourceSourceClient) EstablishResourceStream(ctx context.Context, opts ...grpc.CallOption) (ResourceSource_EstablishResourceStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ResourceSource_serviceDesc.Streams[0], "/istio.mcp.v1alpha1.ResourceSource/EstablishResourceStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &resourceSourceEstablishResourceStreamClient{stream}
	return x, nil
}

type ResourceSource_EstablishResourceStreamClient interface {
	Send(*RequestResources) error
	Recv() (*Resources, error)
	grpc.ClientStream
}

type resourceSourceEstablishResourceStreamClient struct {
	grpc.ClientStream
}

func (x *resourceSourceEstablishResourceStreamClient) Send(m *RequestResources) error {
	return x.ClientStream.SendMsg(m)
}

func (x *resourceSourceEstablishResourceStreamClient) Recv() (*Resources, error) {
	m := new(Resources)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ResourceSourceServer is the server API for ResourceSource service.
type ResourceSourceServer interface {
	// The sink, acting as gRPC client, establishes a new resource stream
	// with the source. The sink sends RequestResources message to
	// and receives Resources messages from the source.
	EstablishResourceStream(ResourceSource_EstablishResourceStreamServer) error
}

// UnimplementedResourceSourceServer can be embedded to have forward compatible implementations.
type UnimplementedResourceSourceServer struct {
}

func (*UnimplementedResourceSourceServer) EstablishResourceStream(srv ResourceSource_EstablishResourceStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method EstablishResourceStream not implemented")
}

func RegisterResourceSourceServer(s *grpc.Server, srv ResourceSourceServer) {
	s.RegisterService(&_ResourceSource_serviceDesc, srv)
}

func _ResourceSource_EstablishResourceStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ResourceSourceServer).EstablishResourceStream(&resourceSourceEstablishResourceStreamServer{stream})
}

type ResourceSource_EstablishResourceStreamServer interface {
	Send(*Resources) error
	Recv() (*RequestResources, error)
	grpc.ServerStream
}

type resourceSourceEstablishResourceStreamServer struct {
	grpc.ServerStream
}

func (x *resourceSourceEstablishResourceStreamServer) Send(m *Resources) error {
	return x.ServerStream.SendMsg(m)
}

func (x *resourceSourceEstablishResourceStreamServer) Recv() (*RequestResources, error) {
	m := new(RequestResources)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ResourceSource_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mcp.v1alpha1.ResourceSource",
	HandlerType: (*ResourceSourceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EstablishResourceStream",
			Handler:       _ResourceSource_EstablishResourceStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "mcp/v1alpha1/mcp.proto",
}

// ResourceSinkClient is the client API for ResourceSink service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceSinkClient interface {
	// The source, acting as gRPC client, establishes a new resource stream
	// with the sink. The sink sends RequestResources message to and
	// receives Resources messages from the source.
	EstablishResourceStream(ctx context.Context, opts ...grpc.CallOption) (ResourceSink_EstablishResourceStreamClient, error)
}

type resourceSinkClient struct {
	cc *grpc.ClientConn
}

func NewResourceSinkClient(cc *grpc.ClientConn) ResourceSinkClient {
	return &resourceSinkClient{cc}
}

func (c *resourceSinkClient) EstablishResourceStream(ctx context.Context, opts ...grpc.CallOption) (ResourceSink_EstablishResourceStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ResourceSink_serviceDesc.Streams[0], "/istio.mcp.v1alpha1.ResourceSink/EstablishResourceStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &resourceSinkEstablishResourceStreamClient{stream}
	return x, nil
}

type ResourceSink_EstablishResourceStreamClient interface {
	Send(*Resources) error
	Recv() (*RequestResources, error)
	grpc.ClientStream
}

type resourceSinkEstablishResourceStreamClient struct {
	grpc.ClientStream
}

func (x *resourceSinkEstablishResourceStreamClient) Send(m *Resources) error {
	return x.ClientStream.SendMsg(m)
}

func (x *resourceSinkEstablishResourceStreamClient) Recv() (*RequestResources, error) {
	m := new(RequestResources)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ResourceSinkServer is the server API for ResourceSink service.
type ResourceSinkServer interface {
	// The source, acting as gRPC client, establishes a new resource stream
	// with the sink. The sink sends RequestResources message to and
	// receives Resources messages from the source.
	EstablishResourceStream(ResourceSink_EstablishResourceStreamServer) error
}

// UnimplementedResourceSinkServer can be embedded to have forward compatible implementations.
type UnimplementedResourceSinkServer struct {
}

func (*UnimplementedResourceSinkServer) EstablishResourceStream(srv ResourceSink_EstablishResourceStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method EstablishResourceStream not implemented")
}

func RegisterResourceSinkServer(s *grpc.Server, srv ResourceSinkServer) {
	s.RegisterService(&_ResourceSink_serviceDesc, srv)
}

func _ResourceSink_EstablishResourceStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ResourceSinkServer).EstablishResourceStream(&resourceSinkEstablishResourceStreamServer{stream})
}

type ResourceSink_EstablishResourceStreamServer interface {
	Send(*RequestResources) error
	Recv() (*Resources, error)
	grpc.ServerStream
}

type resourceSinkEstablishResourceStreamServer struct {
	grpc.ServerStream
}

func (x *resourceSinkEstablishResourceStreamServer) Send(m *RequestResources) error {
	return x.ServerStream.SendMsg(m)
}

func (x *resourceSinkEstablishResourceStreamServer) Recv() (*Resources, error) {
	m := new(Resources)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ResourceSink_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mcp.v1alpha1.ResourceSink",
	HandlerType: (*ResourceSinkServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EstablishResourceStream",
			Handler:       _ResourceSink_EstablishResourceStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "mcp/v1alpha1/mcp.proto",
}

func (m *SinkNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SinkNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SinkNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMcp(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMcp(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMcp(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ErrorDetail != nil {
		{
			size, err := m.ErrorDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ResponseNonce) > 0 {
		i -= len(m.ResponseNonce)
		copy(dAtA[i:], m.ResponseNonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.ResponseNonce)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.TypeUrl) > 0 {
		i -= len(m.TypeUrl)
		copy(dAtA[i:], m.TypeUrl)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.TypeUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if m.SinkNode != nil {
		{
			size, err := m.SinkNode.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.VersionInfo) > 0 {
		i -= len(m.VersionInfo)
		copy(dAtA[i:], m.VersionInfo)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.VersionInfo)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.TypeUrl) > 0 {
		i -= len(m.TypeUrl)
		copy(dAtA[i:], m.TypeUrl)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.TypeUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Resources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMcp(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.VersionInfo) > 0 {
		i -= len(m.VersionInfo)
		copy(dAtA[i:], m.VersionInfo)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.VersionInfo)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IncrementalMeshConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementalMeshConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IncrementalMeshConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ErrorDetail != nil {
		{
			size, err := m.ErrorDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ResponseNonce) > 0 {
		i -= len(m.ResponseNonce)
		copy(dAtA[i:], m.ResponseNonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.ResponseNonce)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.InitialResourceVersions) > 0 {
		for k := range m.InitialResourceVersions {
			v := m.InitialResourceVersions[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMcp(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMcp(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMcp(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.TypeUrl) > 0 {
		i -= len(m.TypeUrl)
		copy(dAtA[i:], m.TypeUrl)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.TypeUrl)))
		i--
		dAtA[i] = 0x12
	}
	if m.SinkNode != nil {
		{
			size, err := m.SinkNode.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IncrementalMeshConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementalMeshConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IncrementalMeshConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RemovedResources) > 0 {
		for iNdEx := len(m.RemovedResources) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemovedResources[iNdEx])
			copy(dAtA[i:], m.RemovedResources[iNdEx])
			i = encodeVarintMcp(dAtA, i, uint64(len(m.RemovedResources[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Resources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMcp(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SystemVersionInfo) > 0 {
		i -= len(m.SystemVersionInfo)
		copy(dAtA[i:], m.SystemVersionInfo)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.SystemVersionInfo)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RequestResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Incremental {
		i--
		if m.Incremental {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.ErrorDetail != nil {
		{
			size, err := m.ErrorDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ResponseNonce) > 0 {
		i -= len(m.ResponseNonce)
		copy(dAtA[i:], m.ResponseNonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.ResponseNonce)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.InitialResourceVersions) > 0 {
		for k := range m.InitialResourceVersions {
			v := m.InitialResourceVersions[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMcp(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMcp(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMcp(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Collection) > 0 {
		i -= len(m.Collection)
		copy(dAtA[i:], m.Collection)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Collection)))
		i--
		dAtA[i] = 0x12
	}
	if m.SinkNode != nil {
		{
			size, err := m.SinkNode.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMcp(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Resources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Resources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Incremental {
		i--
		if m.Incremental {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.RemovedResources) > 0 {
		for iNdEx := len(m.RemovedResources) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemovedResources[iNdEx])
			copy(dAtA[i:], m.RemovedResources[iNdEx])
			i = encodeVarintMcp(dAtA, i, uint64(len(m.RemovedResources[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Resources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMcp(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Collection) > 0 {
		i -= len(m.Collection)
		copy(dAtA[i:], m.Collection)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.Collection)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SystemVersionInfo) > 0 {
		i -= len(m.SystemVersionInfo)
		copy(dAtA[i:], m.SystemVersionInfo)
		i = encodeVarintMcp(dAtA, i, uint64(len(m.SystemVersionInfo)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMcp(dAtA []byte, offset int, v uint64) int {
	offset -= sovMcp(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SinkNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMcp(uint64(len(k))) + 1 + len(v) + sovMcp(uint64(len(v)))
			n += mapEntrySize + 1 + sovMcp(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.SinkNode != nil {
		l = m.SinkNode.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.TypeUrl)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.ResponseNonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.ErrorDetail != nil {
		l = m.ErrorDetail.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMcp(uint64(l))
		}
	}
	l = len(m.TypeUrl)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IncrementalMeshConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SinkNode != nil {
		l = m.SinkNode.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.TypeUrl)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.InitialResourceVersions) > 0 {
		for k, v := range m.InitialResourceVersions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMcp(uint64(len(k))) + 1 + len(v) + sovMcp(uint64(len(v)))
			n += mapEntrySize + 1 + sovMcp(uint64(mapEntrySize))
		}
	}
	l = len(m.ResponseNonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.ErrorDetail != nil {
		l = m.ErrorDetail.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IncrementalMeshConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SystemVersionInfo)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMcp(uint64(l))
		}
	}
	if len(m.RemovedResources) > 0 {
		for _, s := range m.RemovedResources {
			l = len(s)
			n += 1 + l + sovMcp(uint64(l))
		}
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RequestResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SinkNode != nil {
		l = m.SinkNode.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.Collection)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.InitialResourceVersions) > 0 {
		for k, v := range m.InitialResourceVersions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMcp(uint64(len(k))) + 1 + len(v) + sovMcp(uint64(len(v)))
			n += mapEntrySize + 1 + sovMcp(uint64(mapEntrySize))
		}
	}
	l = len(m.ResponseNonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.ErrorDetail != nil {
		l = m.ErrorDetail.Size()
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.Incremental {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SystemVersionInfo)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	l = len(m.Collection)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMcp(uint64(l))
		}
	}
	if len(m.RemovedResources) > 0 {
		for _, s := range m.RemovedResources {
			l = len(s)
			n += 1 + l + sovMcp(uint64(l))
		}
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovMcp(uint64(l))
	}
	if m.Incremental {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMcp(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMcp(x uint64) (n int) {
	return sovMcp(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SinkNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SinkNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SinkNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMcp
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMcp(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMcp
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinkNode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SinkNode == nil {
				m.SinkNode = &SinkNode{}
			}
			if err := m.SinkNode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseNonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseNonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ErrorDetail == nil {
				m.ErrorDetail = &rpc.Status{}
			}
			if err := m.ErrorDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfigResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshConfigResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshConfigResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementalMeshConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementalMeshConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementalMeshConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinkNode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SinkNode == nil {
				m.SinkNode = &SinkNode{}
			}
			if err := m.SinkNode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialResourceVersions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitialResourceVersions == nil {
				m.InitialResourceVersions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMcp
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMcp(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMcp
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.InitialResourceVersions[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseNonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseNonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ErrorDetail == nil {
				m.ErrorDetail = &rpc.Status{}
			}
			if err := m.ErrorDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementalMeshConfigResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementalMeshConfigResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementalMeshConfigResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemVersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SystemVersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovedResources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemovedResources = append(m.RemovedResources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinkNode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SinkNode == nil {
				m.SinkNode = &SinkNode{}
			}
			if err := m.SinkNode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Collection = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialResourceVersions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitialResourceVersions == nil {
				m.InitialResourceVersions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMcp
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMcp
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMcp
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMcp(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMcp
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.InitialResourceVersions[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseNonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseNonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ErrorDetail == nil {
				m.ErrorDetail = &rpc.Status{}
			}
			if err := m.ErrorDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Incremental", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Incremental = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemVersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SystemVersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Collection = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovedResources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemovedResources = append(m.RemovedResources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMcp
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMcp
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Incremental", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Incremental = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMcp(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMcp
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMcp(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMcp
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMcp
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMcp
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthMcp
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMcp
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMcp(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthMcp
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMcp = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMcp   = fmt.Errorf("proto: integer overflow")
)
