// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/network/tcp_proxy/v2/tcp_proxy.proto

package v2

import (
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	v2 "github.com/envoyproxy/go-control-plane/envoy/config/filter/accesslog/v2"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type TcpProxy struct {
	// The prefix to use when emitting :ref:`statistics
	// <config_network_filters_tcp_proxy_stats>`.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Types that are valid to be assigned to ClusterSpecifier:
	//	*TcpProxy_Cluster
	//	*TcpProxy_WeightedClusters
	ClusterSpecifier isTcpProxy_ClusterSpecifier `protobuf_oneof:"cluster_specifier"`
	// Optional endpoint metadata match criteria. Only endpoints in the upstream
	// cluster with metadata matching that set in metadata_match will be
	// considered. The filter name should be specified as *envoy.lb*.
	MetadataMatch *core.Metadata `protobuf:"bytes,9,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	// The idle timeout for connections managed by the TCP proxy filter. The idle timeout
	// is defined as the period in which there are no bytes sent or received on either
	// the upstream or downstream connection. If not set, connections will never be closed
	// by the TCP proxy due to being idle.
	IdleTimeout *time.Duration `protobuf:"bytes,8,opt,name=idle_timeout,json=idleTimeout,proto3,stdduration" json:"idle_timeout,omitempty"`
	// [#not-implemented-hide:] The idle timeout for connections managed by the TCP proxy
	// filter. The idle timeout is defined as the period in which there is no
	// active traffic. If not set, there is no idle timeout. When the idle timeout
	// is reached the connection will be closed. The distinction between
	// downstream_idle_timeout/upstream_idle_timeout provides a means to set
	// timeout based on the last byte sent on the downstream/upstream connection.
	DownstreamIdleTimeout *types.Duration `protobuf:"bytes,3,opt,name=downstream_idle_timeout,json=downstreamIdleTimeout,proto3" json:"downstream_idle_timeout,omitempty"`
	// [#not-implemented-hide:]
	UpstreamIdleTimeout *types.Duration `protobuf:"bytes,4,opt,name=upstream_idle_timeout,json=upstreamIdleTimeout,proto3" json:"upstream_idle_timeout,omitempty"`
	// Configuration for :ref:`access logs <arch_overview_access_logs>`
	// emitted by the this tcp_proxy.
	AccessLog []*v2.AccessLog `protobuf:"bytes,5,rep,name=access_log,json=accessLog,proto3" json:"access_log,omitempty"`
	// [#not-implemented-hide:] Deprecated.
	DeprecatedV1 *TcpProxy_DeprecatedV1 `protobuf:"bytes,6,opt,name=deprecated_v1,json=deprecatedV1,proto3" json:"deprecated_v1,omitempty"` // Deprecated: Do not use.
	// The maximum number of unsuccessful connection attempts that will be made before
	// giving up. If the parameter is not specified, 1 connection attempt will be made.
	MaxConnectAttempts   *types.UInt32Value `protobuf:"bytes,7,opt,name=max_connect_attempts,json=maxConnectAttempts,proto3" json:"max_connect_attempts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TcpProxy) Reset()         { *m = TcpProxy{} }
func (m *TcpProxy) String() string { return proto.CompactTextString(m) }
func (*TcpProxy) ProtoMessage()    {}
func (*TcpProxy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f6b35dbcbad27ba, []int{0}
}
func (m *TcpProxy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpProxy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpProxy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpProxy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpProxy.Merge(m, src)
}
func (m *TcpProxy) XXX_Size() int {
	return m.Size()
}
func (m *TcpProxy) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpProxy.DiscardUnknown(m)
}

var xxx_messageInfo_TcpProxy proto.InternalMessageInfo

type isTcpProxy_ClusterSpecifier interface {
	isTcpProxy_ClusterSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TcpProxy_Cluster struct {
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3,oneof"`
}
type TcpProxy_WeightedClusters struct {
	WeightedClusters *TcpProxy_WeightedCluster `protobuf:"bytes,10,opt,name=weighted_clusters,json=weightedClusters,proto3,oneof"`
}

func (*TcpProxy_Cluster) isTcpProxy_ClusterSpecifier()          {}
func (*TcpProxy_WeightedClusters) isTcpProxy_ClusterSpecifier() {}

func (m *TcpProxy) GetClusterSpecifier() isTcpProxy_ClusterSpecifier {
	if m != nil {
		return m.ClusterSpecifier
	}
	return nil
}

func (m *TcpProxy) GetStatPrefix() string {
	if m != nil {
		return m.StatPrefix
	}
	return ""
}

func (m *TcpProxy) GetCluster() string {
	if x, ok := m.GetClusterSpecifier().(*TcpProxy_Cluster); ok {
		return x.Cluster
	}
	return ""
}

func (m *TcpProxy) GetWeightedClusters() *TcpProxy_WeightedCluster {
	if x, ok := m.GetClusterSpecifier().(*TcpProxy_WeightedClusters); ok {
		return x.WeightedClusters
	}
	return nil
}

func (m *TcpProxy) GetMetadataMatch() *core.Metadata {
	if m != nil {
		return m.MetadataMatch
	}
	return nil
}

func (m *TcpProxy) GetIdleTimeout() *time.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

func (m *TcpProxy) GetDownstreamIdleTimeout() *types.Duration {
	if m != nil {
		return m.DownstreamIdleTimeout
	}
	return nil
}

func (m *TcpProxy) GetUpstreamIdleTimeout() *types.Duration {
	if m != nil {
		return m.UpstreamIdleTimeout
	}
	return nil
}

func (m *TcpProxy) GetAccessLog() []*v2.AccessLog {
	if m != nil {
		return m.AccessLog
	}
	return nil
}

// Deprecated: Do not use.
func (m *TcpProxy) GetDeprecatedV1() *TcpProxy_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

func (m *TcpProxy) GetMaxConnectAttempts() *types.UInt32Value {
	if m != nil {
		return m.MaxConnectAttempts
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TcpProxy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TcpProxy_OneofMarshaler, _TcpProxy_OneofUnmarshaler, _TcpProxy_OneofSizer, []interface{}{
		(*TcpProxy_Cluster)(nil),
		(*TcpProxy_WeightedClusters)(nil),
	}
}

func _TcpProxy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TcpProxy)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *TcpProxy_Cluster:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Cluster)
	case *TcpProxy_WeightedClusters:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WeightedClusters); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TcpProxy.ClusterSpecifier has unexpected type %T", x)
	}
	return nil
}

func _TcpProxy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TcpProxy)
	switch tag {
	case 2: // cluster_specifier.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ClusterSpecifier = &TcpProxy_Cluster{x}
		return true, err
	case 10: // cluster_specifier.weighted_clusters
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TcpProxy_WeightedCluster)
		err := b.DecodeMessage(msg)
		m.ClusterSpecifier = &TcpProxy_WeightedClusters{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TcpProxy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TcpProxy)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *TcpProxy_Cluster:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Cluster)))
		n += len(x.Cluster)
	case *TcpProxy_WeightedClusters:
		s := proto.Size(x.WeightedClusters)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// [#not-implemented-hide:] Deprecated.
// TCP Proxy filter configuration using V1 format.
type TcpProxy_DeprecatedV1 struct {
	// The route table for the filter. All filter instances must have a route
	// table, even if it is empty.
	Routes               []*TcpProxy_DeprecatedV1_TCPRoute `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *TcpProxy_DeprecatedV1) Reset()         { *m = TcpProxy_DeprecatedV1{} }
func (m *TcpProxy_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*TcpProxy_DeprecatedV1) ProtoMessage()    {}
func (*TcpProxy_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f6b35dbcbad27ba, []int{0, 0}
}
func (m *TcpProxy_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpProxy_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpProxy_DeprecatedV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpProxy_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpProxy_DeprecatedV1.Merge(m, src)
}
func (m *TcpProxy_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *TcpProxy_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpProxy_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_TcpProxy_DeprecatedV1 proto.InternalMessageInfo

func (m *TcpProxy_DeprecatedV1) GetRoutes() []*TcpProxy_DeprecatedV1_TCPRoute {
	if m != nil {
		return m.Routes
	}
	return nil
}

// A TCP proxy route consists of a set of optional L4 criteria and the
// name of a cluster. If a downstream connection matches all the
// specified criteria, the cluster in the route is used for the
// corresponding upstream connection. Routes are tried in the order
// specified until a match is found. If no match is found, the connection
// is closed. A route with no criteria is valid and always produces a
// match.
type TcpProxy_DeprecatedV1_TCPRoute struct {
	// The cluster to connect to when a the downstream network connection
	// matches the specified criteria.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// An optional list of IP address subnets in the form
	// “ip_address/xx”. The criteria is satisfied if the destination IP
	// address of the downstream connection is contained in at least one of
	// the specified subnets. If the parameter is not specified or the list
	// is empty, the destination IP address is ignored. The destination IP
	// address of the downstream connection might be different from the
	// addresses on which the proxy is listening if the connection has been
	// redirected.
	DestinationIpList []*core.CidrRange `protobuf:"bytes,2,rep,name=destination_ip_list,json=destinationIpList,proto3" json:"destination_ip_list,omitempty"`
	// An optional string containing a comma-separated list of port numbers
	// or ranges. The criteria is satisfied if the destination port of the
	// downstream connection is contained in at least one of the specified
	// ranges. If the parameter is not specified, the destination port is
	// ignored. The destination port address of the downstream connection
	// might be different from the port on which the proxy is listening if
	// the connection has been redirected.
	DestinationPorts string `protobuf:"bytes,3,opt,name=destination_ports,json=destinationPorts,proto3" json:"destination_ports,omitempty"`
	// An optional list of IP address subnets in the form
	// “ip_address/xx”. The criteria is satisfied if the source IP address
	// of the downstream connection is contained in at least one of the
	// specified subnets. If the parameter is not specified or the list is
	// empty, the source IP address is ignored.
	SourceIpList []*core.CidrRange `protobuf:"bytes,4,rep,name=source_ip_list,json=sourceIpList,proto3" json:"source_ip_list,omitempty"`
	// An optional string containing a comma-separated list of port numbers
	// or ranges. The criteria is satisfied if the source port of the
	// downstream connection is contained in at least one of the specified
	// ranges. If the parameter is not specified, the source port is
	// ignored.
	SourcePorts          string   `protobuf:"bytes,5,opt,name=source_ports,json=sourcePorts,proto3" json:"source_ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) Reset()         { *m = TcpProxy_DeprecatedV1_TCPRoute{} }
func (m *TcpProxy_DeprecatedV1_TCPRoute) String() string { return proto.CompactTextString(m) }
func (*TcpProxy_DeprecatedV1_TCPRoute) ProtoMessage()    {}
func (*TcpProxy_DeprecatedV1_TCPRoute) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f6b35dbcbad27ba, []int{0, 0, 0}
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpProxy_DeprecatedV1_TCPRoute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpProxy_DeprecatedV1_TCPRoute.Merge(m, src)
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) XXX_Size() int {
	return m.Size()
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpProxy_DeprecatedV1_TCPRoute.DiscardUnknown(m)
}

var xxx_messageInfo_TcpProxy_DeprecatedV1_TCPRoute proto.InternalMessageInfo

func (m *TcpProxy_DeprecatedV1_TCPRoute) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) GetDestinationIpList() []*core.CidrRange {
	if m != nil {
		return m.DestinationIpList
	}
	return nil
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) GetDestinationPorts() string {
	if m != nil {
		return m.DestinationPorts
	}
	return ""
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) GetSourceIpList() []*core.CidrRange {
	if m != nil {
		return m.SourceIpList
	}
	return nil
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) GetSourcePorts() string {
	if m != nil {
		return m.SourcePorts
	}
	return ""
}

// Allows for specification of multiple upstream clusters along with weights
// that indicate the percentage of traffic to be forwarded to each cluster.
// The router selects an upstream cluster based on these weights.
type TcpProxy_WeightedCluster struct {
	// Specifies one or more upstream clusters associated with the route.
	Clusters             []*TcpProxy_WeightedCluster_ClusterWeight `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *TcpProxy_WeightedCluster) Reset()         { *m = TcpProxy_WeightedCluster{} }
func (m *TcpProxy_WeightedCluster) String() string { return proto.CompactTextString(m) }
func (*TcpProxy_WeightedCluster) ProtoMessage()    {}
func (*TcpProxy_WeightedCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f6b35dbcbad27ba, []int{0, 1}
}
func (m *TcpProxy_WeightedCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpProxy_WeightedCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpProxy_WeightedCluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpProxy_WeightedCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpProxy_WeightedCluster.Merge(m, src)
}
func (m *TcpProxy_WeightedCluster) XXX_Size() int {
	return m.Size()
}
func (m *TcpProxy_WeightedCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpProxy_WeightedCluster.DiscardUnknown(m)
}

var xxx_messageInfo_TcpProxy_WeightedCluster proto.InternalMessageInfo

func (m *TcpProxy_WeightedCluster) GetClusters() []*TcpProxy_WeightedCluster_ClusterWeight {
	if m != nil {
		return m.Clusters
	}
	return nil
}

type TcpProxy_WeightedCluster_ClusterWeight struct {
	// Name of the upstream cluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// When a request matches the route, the choice of an upstream cluster is
	// determined by its weight. The sum of weights across all entries in the
	// clusters array determines the total weight.
	Weight               uint32   `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TcpProxy_WeightedCluster_ClusterWeight) Reset() {
	*m = TcpProxy_WeightedCluster_ClusterWeight{}
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) String() string { return proto.CompactTextString(m) }
func (*TcpProxy_WeightedCluster_ClusterWeight) ProtoMessage()    {}
func (*TcpProxy_WeightedCluster_ClusterWeight) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f6b35dbcbad27ba, []int{0, 1, 0}
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpProxy_WeightedCluster_ClusterWeight.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpProxy_WeightedCluster_ClusterWeight.Merge(m, src)
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) XXX_Size() int {
	return m.Size()
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpProxy_WeightedCluster_ClusterWeight.DiscardUnknown(m)
}

var xxx_messageInfo_TcpProxy_WeightedCluster_ClusterWeight proto.InternalMessageInfo

func (m *TcpProxy_WeightedCluster_ClusterWeight) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TcpProxy_WeightedCluster_ClusterWeight) GetWeight() uint32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func init() {
	proto.RegisterType((*TcpProxy)(nil), "envoy.config.filter.network.tcp_proxy.v2.TcpProxy")
	proto.RegisterType((*TcpProxy_DeprecatedV1)(nil), "envoy.config.filter.network.tcp_proxy.v2.TcpProxy.DeprecatedV1")
	proto.RegisterType((*TcpProxy_DeprecatedV1_TCPRoute)(nil), "envoy.config.filter.network.tcp_proxy.v2.TcpProxy.DeprecatedV1.TCPRoute")
	proto.RegisterType((*TcpProxy_WeightedCluster)(nil), "envoy.config.filter.network.tcp_proxy.v2.TcpProxy.WeightedCluster")
	proto.RegisterType((*TcpProxy_WeightedCluster_ClusterWeight)(nil), "envoy.config.filter.network.tcp_proxy.v2.TcpProxy.WeightedCluster.ClusterWeight")
}

func init() {
	proto.RegisterFile("envoy/config/filter/network/tcp_proxy/v2/tcp_proxy.proto", fileDescriptor_1f6b35dbcbad27ba)
}

var fileDescriptor_1f6b35dbcbad27ba = []byte{
	// 815 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0xcf, 0x6e, 0x1b, 0x45,
	0x18, 0xcf, 0xac, 0x93, 0xd4, 0x1e, 0xc7, 0xa5, 0x99, 0xb6, 0xea, 0x62, 0x42, 0x9a, 0xc2, 0xc5,
	0x4a, 0xa5, 0x5d, 0xea, 0x4a, 0x88, 0x1b, 0xea, 0xa6, 0x87, 0x04, 0x25, 0x92, 0xbb, 0x0a, 0x45,
	0xe5, 0xb2, 0x9a, 0xec, 0x8e, 0x37, 0x23, 0xd6, 0x3b, 0xc3, 0xcc, 0xac, 0xed, 0xbe, 0x05, 0x70,
	0x42, 0x3c, 0x02, 0x4f, 0x80, 0x38, 0xf5, 0xc8, 0x91, 0x27, 0x00, 0x94, 0x5b, 0xdf, 0x02, 0xcd,
	0x9f, 0xb5, 0x37, 0xc4, 0xa8, 0x51, 0x73, 0xda, 0x99, 0xef, 0xfb, 0x7e, 0xbf, 0xdf, 0x7e, 0xff,
	0x06, 0x7e, 0x41, 0xca, 0x29, 0x7b, 0x1d, 0xa6, 0xac, 0x1c, 0xd3, 0x3c, 0x1c, 0xd3, 0x42, 0x11,
	0x11, 0x96, 0x44, 0xcd, 0x98, 0xf8, 0x2e, 0x54, 0x29, 0x4f, 0xb8, 0x60, 0xf3, 0xd7, 0xe1, 0x74,
	0xb8, 0xbc, 0x04, 0x5c, 0x30, 0xc5, 0xd0, 0xc0, 0x20, 0x03, 0x8b, 0x0c, 0x2c, 0x32, 0x70, 0xc8,
	0x60, 0x19, 0x3c, 0x1d, 0xf6, 0x3f, 0x5b, 0xa5, 0x81, 0xd3, 0x94, 0x48, 0x59, 0xb0, 0x5c, 0x73,
	0x2f, 0x2e, 0x96, 0xbb, 0xff, 0xd0, 0x22, 0x30, 0xa7, 0xda, 0x9b, 0x32, 0x41, 0x42, 0x9c, 0x65,
	0x82, 0x48, 0xe9, 0x02, 0x76, 0xae, 0x06, 0x9c, 0x61, 0x49, 0x9c, 0x77, 0x37, 0x67, 0x2c, 0x2f,
	0x48, 0x68, 0x6e, 0x67, 0xd5, 0x38, 0xcc, 0x2a, 0x81, 0x15, 0x65, 0xe5, 0xff, 0xf9, 0x67, 0x02,
	0x73, 0x4e, 0x44, 0xcd, 0xfe, 0x60, 0x8a, 0x0b, 0x9a, 0x61, 0x45, 0xc2, 0xfa, 0xe0, 0x1c, 0xf7,
	0x72, 0x96, 0x33, 0x73, 0x0c, 0xf5, 0xc9, 0x5a, 0x3f, 0xf9, 0xa5, 0x0b, 0xdb, 0xa7, 0x29, 0x1f,
	0xe9, 0x7c, 0xd1, 0x3e, 0xec, 0x4a, 0x85, 0x55, 0xc2, 0x05, 0x19, 0xd3, 0xb9, 0x0f, 0xf6, 0xc0,
	0xa0, 0x13, 0x75, 0x7e, 0x7f, 0xfb, 0xa6, 0xb5, 0x2e, 0xbc, 0x3d, 0x10, 0x43, 0xed, 0x1d, 0x19,
	0x27, 0xea, 0xc3, 0x5b, 0x69, 0x51, 0x49, 0x45, 0x84, 0xef, 0xe9, 0xb8, 0xc3, 0xb5, 0xb8, 0x36,
	0xa0, 0xef, 0xe1, 0xf6, 0x8c, 0xd0, 0xfc, 0x5c, 0x91, 0x2c, 0x71, 0x36, 0xe9, 0xc3, 0x3d, 0x30,
	0xe8, 0x0e, 0xa3, 0xe0, 0xba, 0xa5, 0x0f, 0xea, 0xdf, 0x0a, 0xbe, 0x71, 0x5c, 0x07, 0x96, 0xea,
	0x70, 0x2d, 0xbe, 0x33, 0xbb, 0x6c, 0x92, 0x28, 0x82, 0xb7, 0x27, 0x44, 0xe1, 0x0c, 0x2b, 0x9c,
	0x4c, 0xb0, 0x4a, 0xcf, 0xfd, 0x8e, 0xd1, 0xfb, 0xc8, 0xe9, 0x61, 0x4e, 0x35, 0xa7, 0xae, 0x76,
	0x70, 0xe2, 0x02, 0xe3, 0x5e, 0x0d, 0x39, 0xd1, 0x08, 0x74, 0x0c, 0xb7, 0x68, 0x56, 0x90, 0x44,
	0xd1, 0x09, 0x61, 0x95, 0xf2, 0xdb, 0x86, 0xe1, 0xc3, 0xc0, 0x56, 0x3c, 0xa8, 0x2b, 0x1e, 0x3c,
	0x77, 0x1d, 0x89, 0x6e, 0xff, 0xfc, 0xf7, 0x43, 0xa0, 0xcb, 0xb3, 0xf1, 0x2b, 0xf0, 0xf6, 0xd7,
	0xe2, 0xae, 0x86, 0x9f, 0x5a, 0x34, 0x7a, 0x01, 0x1f, 0x64, 0x6c, 0x56, 0x4a, 0x25, 0x08, 0x9e,
	0x24, 0x97, 0x88, 0x5b, 0xef, 0x20, 0x8e, 0xef, 0x2f, 0x91, 0x47, 0x0d, 0xca, 0x13, 0x78, 0xbf,
	0xe2, 0xab, 0x08, 0xd7, 0xdf, 0x45, 0x78, 0xb7, 0xc6, 0x35, 0xe9, 0xbe, 0x82, 0xd0, 0x0e, 0x6f,
	0x52, 0xb0, 0xdc, 0xdf, 0xd8, 0x6b, 0x0d, 0xba, 0xc3, 0xc7, 0x2b, 0xfb, 0xb3, 0x9c, 0xf1, 0xe9,
	0x30, 0x78, 0x66, 0x2e, 0xc7, 0x2c, 0x8f, 0x3b, 0xb8, 0x3e, 0xa2, 0x73, 0xd8, 0xcb, 0x08, 0x17,
	0x24, 0xc5, 0xba, 0xe9, 0xd3, 0x27, 0xfe, 0xa6, 0xf9, 0xa5, 0x2f, 0xdf, 0xa3, 0xdd, 0xcf, 0x17,
	0x3c, 0x2f, 0x9f, 0x44, 0x9e, 0x0f, 0xe2, 0xad, 0xac, 0x61, 0x41, 0xaf, 0xe0, 0xbd, 0x09, 0x9e,
	0x27, 0x29, 0x2b, 0x4b, 0x92, 0xaa, 0x04, 0x2b, 0x45, 0x26, 0x5c, 0x49, 0xff, 0x96, 0x11, 0xdc,
	0xb9, 0x52, 0x83, 0xaf, 0x8f, 0x4a, 0xf5, 0x74, 0xf8, 0x12, 0x17, 0x15, 0x71, 0xb3, 0xbc, 0xef,
	0x0d, 0x40, 0x8c, 0x26, 0x78, 0x7e, 0x60, 0x39, 0x9e, 0x39, 0x8a, 0xfe, 0x0f, 0x2d, 0xb8, 0xd5,
	0x54, 0x47, 0x05, 0xdc, 0x14, 0xac, 0x52, 0x44, 0xfa, 0xc0, 0x54, 0xe7, 0xf0, 0x86, 0xe9, 0x04,
	0xa7, 0x07, 0xa3, 0x58, 0x13, 0x46, 0xd0, 0x8c, 0xcd, 0x4f, 0xc0, 0x6b, 0x83, 0xd8, 0x69, 0xf4,
	0x7f, 0xf4, 0x60, 0xbb, 0x0e, 0x40, 0x9f, 0x2e, 0xf7, 0xeb, 0xca, 0x1e, 0x2e, 0x16, 0xed, 0x18,
	0xde, 0xcd, 0x88, 0x54, 0xb4, 0x34, 0x5d, 0x4e, 0x28, 0x4f, 0x0a, 0x2a, 0x95, 0xef, 0x99, 0x9f,
	0xdd, 0x59, 0x31, 0xfa, 0x07, 0x34, 0x13, 0x31, 0x2e, 0x73, 0x12, 0x6f, 0x37, 0x80, 0x47, 0xfc,
	0x98, 0x4a, 0x85, 0x1e, 0xc3, 0xa6, 0x31, 0xe1, 0x4c, 0x28, 0x69, 0x66, 0xb5, 0x13, 0xdf, 0x69,
	0x38, 0x46, 0xda, 0xae, 0x17, 0x4e, 0xb2, 0x4a, 0xa4, 0x64, 0xa1, 0xba, 0x7e, 0x0d, 0xd5, 0x2d,
	0x8b, 0x71, 0x82, 0x8f, 0xa0, 0xbb, 0x3b, 0xad, 0x0d, 0xa3, 0xd5, 0xb5, 0x36, 0x23, 0xd3, 0xff,
	0x0b, 0xc0, 0x0f, 0xfe, 0xb3, 0xff, 0x68, 0x0e, 0xdb, 0x8b, 0x57, 0xc5, 0xf6, 0x65, 0x74, 0xf3,
	0x57, 0x25, 0x70, 0x5f, 0x6b, 0xbe, 0xd4, 0x9f, 0x85, 0x5a, 0xff, 0x05, 0xec, 0x5d, 0x0a, 0x43,
	0x1f, 0xc3, 0xf5, 0x12, 0x4f, 0xc8, 0xd5, 0x16, 0x19, 0x33, 0x7a, 0x04, 0x37, 0xed, 0x4b, 0x65,
	0xde, 0xc8, 0x5e, 0x73, 0xfe, 0x9c, 0x23, 0xea, 0xc3, 0x6d, 0x47, 0x9f, 0x48, 0x4e, 0x52, 0x3a,
	0xa6, 0x44, 0xa0, 0x8d, 0xdf, 0xde, 0xbe, 0x69, 0x81, 0xe8, 0xd5, 0x1f, 0x17, 0xbb, 0xe0, 0xcf,
	0x8b, 0x5d, 0xf0, 0xcf, 0xc5, 0x2e, 0x80, 0x9f, 0x53, 0x66, 0xd3, 0xb4, 0xb9, 0x5c, 0x37, 0xe3,
	0xa8, 0x57, 0xa7, 0x3c, 0xd2, 0x2b, 0x31, 0x02, 0xdf, 0x7a, 0xd3, 0xe1, 0xd9, 0xa6, 0xd9, 0x8f,
	0xa7, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x50, 0x89, 0xe2, 0x7f, 0x44, 0x07, 0x00, 0x00,
}

func (m *TcpProxy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpProxy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StatPrefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.StatPrefix)))
		i += copy(dAtA[i:], m.StatPrefix)
	}
	if m.ClusterSpecifier != nil {
		nn1, err := m.ClusterSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.DownstreamIdleTimeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.DownstreamIdleTimeout.Size()))
		n2, err := m.DownstreamIdleTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.UpstreamIdleTimeout != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.UpstreamIdleTimeout.Size()))
		n3, err := m.UpstreamIdleTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.AccessLog) > 0 {
		for _, msg := range m.AccessLog {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintTcpProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n4, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.MaxConnectAttempts != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.MaxConnectAttempts.Size()))
		n5, err := m.MaxConnectAttempts.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.IdleTimeout != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)))
		n6, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.IdleTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.MetadataMatch != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.MetadataMatch.Size()))
		n7, err := m.MetadataMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TcpProxy_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.Cluster)))
	i += copy(dAtA[i:], m.Cluster)
	return i, nil
}
func (m *TcpProxy_WeightedClusters) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WeightedClusters != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.WeightedClusters.Size()))
		n8, err := m.WeightedClusters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *TcpProxy_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpProxy_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Routes) > 0 {
		for _, msg := range m.Routes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTcpProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cluster) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if len(m.DestinationIpList) > 0 {
		for _, msg := range m.DestinationIpList {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTcpProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DestinationPorts) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.DestinationPorts)))
		i += copy(dAtA[i:], m.DestinationPorts)
	}
	if len(m.SourceIpList) > 0 {
		for _, msg := range m.SourceIpList {
			dAtA[i] = 0x22
			i++
			i = encodeVarintTcpProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SourcePorts) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.SourcePorts)))
		i += copy(dAtA[i:], m.SourcePorts)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TcpProxy_WeightedCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpProxy_WeightedCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, msg := range m.Clusters {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTcpProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TcpProxy_WeightedCluster_ClusterWeight) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpProxy_WeightedCluster_ClusterWeight) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Weight != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTcpProxy(dAtA, i, uint64(m.Weight))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintTcpProxy(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TcpProxy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StatPrefix)
	if l > 0 {
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.ClusterSpecifier != nil {
		n += m.ClusterSpecifier.Size()
	}
	if m.DownstreamIdleTimeout != nil {
		l = m.DownstreamIdleTimeout.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.UpstreamIdleTimeout != nil {
		l = m.UpstreamIdleTimeout.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if len(m.AccessLog) > 0 {
		for _, e := range m.AccessLog {
			l = e.Size()
			n += 1 + l + sovTcpProxy(uint64(l))
		}
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.MaxConnectAttempts != nil {
		l = m.MaxConnectAttempts.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.IdleTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.MetadataMatch != nil {
		l = m.MetadataMatch.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TcpProxy_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	n += 1 + l + sovTcpProxy(uint64(l))
	return n
}
func (m *TcpProxy_WeightedClusters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WeightedClusters != nil {
		l = m.WeightedClusters.Size()
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	return n
}
func (m *TcpProxy_DeprecatedV1) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovTcpProxy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TcpProxy_DeprecatedV1_TCPRoute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if len(m.DestinationIpList) > 0 {
		for _, e := range m.DestinationIpList {
			l = e.Size()
			n += 1 + l + sovTcpProxy(uint64(l))
		}
	}
	l = len(m.DestinationPorts)
	if l > 0 {
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if len(m.SourceIpList) > 0 {
		for _, e := range m.SourceIpList {
			l = e.Size()
			n += 1 + l + sovTcpProxy(uint64(l))
		}
	}
	l = len(m.SourcePorts)
	if l > 0 {
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TcpProxy_WeightedCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovTcpProxy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TcpProxy_WeightedCluster_ClusterWeight) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTcpProxy(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovTcpProxy(uint64(m.Weight))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovTcpProxy(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTcpProxy(x uint64) (n int) {
	return sovTcpProxy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TcpProxy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpProxy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpProxy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterSpecifier = &TcpProxy_Cluster{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DownstreamIdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DownstreamIdleTimeout == nil {
				m.DownstreamIdleTimeout = &types.Duration{}
			}
			if err := m.DownstreamIdleTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamIdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamIdleTimeout == nil {
				m.UpstreamIdleTimeout = &types.Duration{}
			}
			if err := m.UpstreamIdleTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLog = append(m.AccessLog, &v2.AccessLog{})
			if err := m.AccessLog[len(m.AccessLog)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &TcpProxy_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConnectAttempts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxConnectAttempts == nil {
				m.MaxConnectAttempts = &types.UInt32Value{}
			}
			if err := m.MaxConnectAttempts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdleTimeout == nil {
				m.IdleTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.IdleTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataMatch == nil {
				m.MetadataMatch = &core.Metadata{}
			}
			if err := m.MetadataMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightedClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TcpProxy_WeightedCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ClusterSpecifier = &TcpProxy_WeightedClusters{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTcpProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpProxy_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &TcpProxy_DeprecatedV1_TCPRoute{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTcpProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpProxy_DeprecatedV1_TCPRoute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPRoute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPRoute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIpList", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationIpList = append(m.DestinationIpList, &core.CidrRange{})
			if err := m.DestinationIpList[len(m.DestinationIpList)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPorts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationPorts = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIpList", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIpList = append(m.SourceIpList, &core.CidrRange{})
			if err := m.SourceIpList[len(m.SourceIpList)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePorts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePorts = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTcpProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpProxy_WeightedCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &TcpProxy_WeightedCluster_ClusterWeight{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTcpProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpProxy_WeightedCluster_ClusterWeight) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterWeight: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterWeight: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTcpProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTcpProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTcpProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTcpProxy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTcpProxy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTcpProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTcpProxy
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthTcpProxy
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTcpProxy
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTcpProxy(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthTcpProxy
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTcpProxy = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTcpProxy   = fmt.Errorf("proto: integer overflow")
)
