// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/network/redis_proxy/v2/redis_proxy.proto

package v2

import (
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ReadPolicy controls how Envoy routes read commands to Redis nodes. This is currently
// supported for Redis Cluster. All ReadPolicy settings except MASTER may return stale data
// because replication is asynchronous and requires some delay. You need to ensure that your
// application can tolerate stale data.
type RedisProxy_ConnPoolSettings_ReadPolicy int32

const (
	// Default mode. Read from the current master node.
	RedisProxy_ConnPoolSettings_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 0
	// Read from the master, but if it is unavailable, read from replica nodes.
	RedisProxy_ConnPoolSettings_PREFER_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 1
	// Read from replica nodes. If multiple replica nodes are present within a shard, a random
	// node is selected. Healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 2
	// Read from the replica nodes (similar to REPLICA), but if all replicas are unavailable (not
	// present or unhealthy), read from the master.
	RedisProxy_ConnPoolSettings_PREFER_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 3
	// Read from any node of the cluster. A random node is selected among the master and replicas,
	// healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_ANY RedisProxy_ConnPoolSettings_ReadPolicy = 4
)

var RedisProxy_ConnPoolSettings_ReadPolicy_name = map[int32]string{
	0: "MASTER",
	1: "PREFER_MASTER",
	2: "REPLICA",
	3: "PREFER_REPLICA",
	4: "ANY",
}

var RedisProxy_ConnPoolSettings_ReadPolicy_value = map[string]int32{
	"MASTER":         0,
	"PREFER_MASTER":  1,
	"REPLICA":        2,
	"PREFER_REPLICA": 3,
	"ANY":            4,
}

func (x RedisProxy_ConnPoolSettings_ReadPolicy) String() string {
	return proto.EnumName(RedisProxy_ConnPoolSettings_ReadPolicy_name, int32(x))
}

func (RedisProxy_ConnPoolSettings_ReadPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0, 0, 0}
}

type RedisProxy struct {
	// The prefix to use when emitting :ref:`statistics <config_network_filters_redis_proxy_stats>`.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Name of cluster from cluster manager. See the :ref:`configuration section
	// <arch_overview_redis_configuration>` of the architecture overview for recommendations on
	// configuring the backing cluster.
	//
	// .. attention::
	//
	//   This field is deprecated. Use a :ref:`catch_all
	//   route<envoy_api_field_config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.catch_all_route>`
	//   instead.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"` // Deprecated: Do not use.
	// Network settings for the connection pool to the upstream clusters.
	Settings *RedisProxy_ConnPoolSettings `protobuf:"bytes,3,opt,name=settings,proto3" json:"settings,omitempty"`
	// Indicates that latency stat should be computed in microseconds. By default it is computed in
	// milliseconds.
	LatencyInMicros bool `protobuf:"varint,4,opt,name=latency_in_micros,json=latencyInMicros,proto3" json:"latency_in_micros,omitempty"`
	// List of **unique** prefixes used to separate keys from different workloads to different
	// clusters. Envoy will always favor the longest match first in case of overlap. A catch-all
	// cluster can be used to forward commands when there is no match. Time complexity of the
	// lookups are in O(min(longest key prefix, key length)).
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//    prefix_routes:
	//      routes:
	//        - prefix: "ab"
	//          cluster: "cluster_a"
	//        - prefix: "abc"
	//          cluster: "cluster_b"
	//
	// When using the above routes, the following prefixes would be sent to:
	//
	// * 'get abc:users' would retrive the key 'abc:users' from cluster_b.
	// * 'get ab:users' would retrive the key 'ab:users' from cluster_a.
	// * 'get z:users' would return a NoUpstreamHost error. A :ref:`catch-all
	//   route<envoy_api_field_config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.catch_all_route>`
	//   would have retrieved the key from that cluster instead.
	//
	// See the :ref:`configuration section
	// <arch_overview_redis_configuration>` of the architecture overview for recommendations on
	// configuring the backing clusters.
	PrefixRoutes *RedisProxy_PrefixRoutes `protobuf:"bytes,5,opt,name=prefix_routes,json=prefixRoutes,proto3" json:"prefix_routes,omitempty"`
	// Authenticate Redis client connections locally by forcing downstream clients to issue a 'Redis
	// AUTH command <https://redis.io/commands/auth>`_ with this password before enabling any other
	// command. If an AUTH command's password matches this password, an "OK" response will be returned
	// to the client. If the AUTH command password does not match this password, then an "ERR invalid
	// password" error will be returned. If any other command is received before AUTH when this
	// password is set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no password is set" error will be returned.
	DownstreamAuthPassword *core.DataSource `protobuf:"bytes,6,opt,name=downstream_auth_password,json=downstreamAuthPassword,proto3" json:"downstream_auth_password,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}         `json:"-"`
	XXX_unrecognized       []byte           `json:"-"`
	XXX_sizecache          int32            `json:"-"`
}

func (m *RedisProxy) Reset()         { *m = RedisProxy{} }
func (m *RedisProxy) String() string { return proto.CompactTextString(m) }
func (*RedisProxy) ProtoMessage()    {}
func (*RedisProxy) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0}
}
func (m *RedisProxy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProxy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProxy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProxy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProxy.Merge(m, src)
}
func (m *RedisProxy) XXX_Size() int {
	return m.Size()
}
func (m *RedisProxy) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProxy.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProxy proto.InternalMessageInfo

func (m *RedisProxy) GetStatPrefix() string {
	if m != nil {
		return m.StatPrefix
	}
	return ""
}

// Deprecated: Do not use.
func (m *RedisProxy) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *RedisProxy) GetSettings() *RedisProxy_ConnPoolSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *RedisProxy) GetLatencyInMicros() bool {
	if m != nil {
		return m.LatencyInMicros
	}
	return false
}

func (m *RedisProxy) GetPrefixRoutes() *RedisProxy_PrefixRoutes {
	if m != nil {
		return m.PrefixRoutes
	}
	return nil
}

func (m *RedisProxy) GetDownstreamAuthPassword() *core.DataSource {
	if m != nil {
		return m.DownstreamAuthPassword
	}
	return nil
}

// Redis connection pool settings.
type RedisProxy_ConnPoolSettings struct {
	// Per-operation timeout in milliseconds. The timer starts when the first
	// command of a pipeline is written to the backend connection. Each response received from Redis
	// resets the timer since it signifies that the next command is being processed by the backend.
	// The only exception to this behavior is when a connection to a backend is not yet established.
	// In that case, the connect timeout on the cluster will govern the timeout until the connection
	// is ready.
	OpTimeout *time.Duration `protobuf:"bytes,1,opt,name=op_timeout,json=opTimeout,proto3,stdduration" json:"op_timeout,omitempty"`
	// Use hash tagging on every redis key to guarantee that keys with the same hash tag will be
	// forwarded to the same upstream. The hash key used for determining the upstream in a
	// consistent hash ring configuration will be computed from the hash tagged key instead of the
	// whole key. The algorithm used to compute the hash tag is identical to the `redis-cluster
	// implementation <https://redis.io/topics/cluster-spec#keys-hash-tags>`_.
	//
	// Examples:
	//
	// * '{user1000}.following' and '{user1000}.followers' **will** be sent to the same upstream
	// * '{user1000}.following' and '{user1001}.following' **might** be sent to the same upstream
	EnableHashtagging bool `protobuf:"varint,2,opt,name=enable_hashtagging,json=enableHashtagging,proto3" json:"enable_hashtagging,omitempty"`
	// Accept `moved and ask redirection
	// <https://redis.io/topics/cluster-spec#redirection-and-resharding>`_ errors from upstream
	// redis servers, and retry commands to the specified target server. The target server does not
	// need to be known to the cluster manager. If the command cannot be redirected, then the
	// original error is passed downstream unchanged. By default, this support is not enabled.
	EnableRedirection bool `protobuf:"varint,3,opt,name=enable_redirection,json=enableRedirection,proto3" json:"enable_redirection,omitempty"`
	// Maximum size of encoded request buffer before flush is triggered and encoded requests
	// are sent upstream. If this is unset, the buffer flushes whenever it receives data
	// and performs no batching.
	// This feature makes it possible for multiple clients to send requests to Envoy and have
	// them batched- for example if one is running several worker processes, each with its own
	// Redis connection. There is no benefit to using this with a single downstream process.
	// Recommended size (if enabled) is 1024 bytes.
	MaxBufferSizeBeforeFlush uint32 `protobuf:"varint,4,opt,name=max_buffer_size_before_flush,json=maxBufferSizeBeforeFlush,proto3" json:"max_buffer_size_before_flush,omitempty"`
	// The encoded request buffer is flushed N milliseconds after the first request has been
	// encoded, unless the buffer size has already exceeded `max_buffer_size_before_flush`.
	// If `max_buffer_size_before_flush` is not set, this flush timer is not used. Otherwise,
	// the timer should be set according to the number of clients, overall request rate and
	// desired maximum latency for a single command. For example, if there are many requests
	// being batched together at a high rate, the buffer will likely be filled before the timer
	// fires. Alternatively, if the request rate is lower the buffer will not be filled as often
	// before the timer fires.
	// If `max_buffer_size_before_flush` is set, but `buffer_flush_timeout` is not, the latter
	// defaults to 3ms.
	BufferFlushTimeout *time.Duration `protobuf:"bytes,5,opt,name=buffer_flush_timeout,json=bufferFlushTimeout,proto3,stdduration" json:"buffer_flush_timeout,omitempty"`
	// `max_upstream_unknown_connections` controls how many upstream connections to unknown hosts
	// can be created at any given time by any given worker thread (see `enable_redirection` for
	// more details). If the host is unknown and a connection cannot be created due to enforcing
	// this limit, then redirection will fail and the original redirection error will be passed
	// downstream unchanged. This limit defaults to 100.
	MaxUpstreamUnknownConnections *types.UInt32Value `protobuf:"bytes,6,opt,name=max_upstream_unknown_connections,json=maxUpstreamUnknownConnections,proto3" json:"max_upstream_unknown_connections,omitempty"`
	// Read policy. The default is to read from the master.
	ReadPolicy           RedisProxy_ConnPoolSettings_ReadPolicy `protobuf:"varint,7,opt,name=read_policy,json=readPolicy,proto3,enum=envoy.config.filter.network.redis_proxy.v2.RedisProxy_ConnPoolSettings_ReadPolicy" json:"read_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *RedisProxy_ConnPoolSettings) Reset()         { *m = RedisProxy_ConnPoolSettings{} }
func (m *RedisProxy_ConnPoolSettings) String() string { return proto.CompactTextString(m) }
func (*RedisProxy_ConnPoolSettings) ProtoMessage()    {}
func (*RedisProxy_ConnPoolSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0, 0}
}
func (m *RedisProxy_ConnPoolSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProxy_ConnPoolSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProxy_ConnPoolSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProxy_ConnPoolSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProxy_ConnPoolSettings.Merge(m, src)
}
func (m *RedisProxy_ConnPoolSettings) XXX_Size() int {
	return m.Size()
}
func (m *RedisProxy_ConnPoolSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProxy_ConnPoolSettings.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProxy_ConnPoolSettings proto.InternalMessageInfo

func (m *RedisProxy_ConnPoolSettings) GetOpTimeout() *time.Duration {
	if m != nil {
		return m.OpTimeout
	}
	return nil
}

func (m *RedisProxy_ConnPoolSettings) GetEnableHashtagging() bool {
	if m != nil {
		return m.EnableHashtagging
	}
	return false
}

func (m *RedisProxy_ConnPoolSettings) GetEnableRedirection() bool {
	if m != nil {
		return m.EnableRedirection
	}
	return false
}

func (m *RedisProxy_ConnPoolSettings) GetMaxBufferSizeBeforeFlush() uint32 {
	if m != nil {
		return m.MaxBufferSizeBeforeFlush
	}
	return 0
}

func (m *RedisProxy_ConnPoolSettings) GetBufferFlushTimeout() *time.Duration {
	if m != nil {
		return m.BufferFlushTimeout
	}
	return nil
}

func (m *RedisProxy_ConnPoolSettings) GetMaxUpstreamUnknownConnections() *types.UInt32Value {
	if m != nil {
		return m.MaxUpstreamUnknownConnections
	}
	return nil
}

func (m *RedisProxy_ConnPoolSettings) GetReadPolicy() RedisProxy_ConnPoolSettings_ReadPolicy {
	if m != nil {
		return m.ReadPolicy
	}
	return RedisProxy_ConnPoolSettings_MASTER
}

type RedisProxy_PrefixRoutes struct {
	// List of prefix routes.
	Routes []*RedisProxy_PrefixRoutes_Route `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// Indicates that prefix matching should be case insensitive.
	CaseInsensitive bool `protobuf:"varint,2,opt,name=case_insensitive,json=caseInsensitive,proto3" json:"case_insensitive,omitempty"`
	// Optional catch-all route to forward commands that doesn't match any of the routes. The
	// catch-all route becomes required when no routes are specified.
	// .. attention::
	//
	//   This field is deprecated. Use a :ref:`catch_all
	//   route<envoy_api_field_config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.catch_all_route>`
	//   instead.
	CatchAllCluster string `protobuf:"bytes,3,opt,name=catch_all_cluster,json=catchAllCluster,proto3" json:"catch_all_cluster,omitempty"` // Deprecated: Do not use.
	// Optional catch-all route to forward commands that doesn't match any of the routes. The
	// catch-all route becomes required when no routes are specified.
	CatchAllRoute        *RedisProxy_PrefixRoutes_Route `protobuf:"bytes,4,opt,name=catch_all_route,json=catchAllRoute,proto3" json:"catch_all_route,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *RedisProxy_PrefixRoutes) Reset()         { *m = RedisProxy_PrefixRoutes{} }
func (m *RedisProxy_PrefixRoutes) String() string { return proto.CompactTextString(m) }
func (*RedisProxy_PrefixRoutes) ProtoMessage()    {}
func (*RedisProxy_PrefixRoutes) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0, 1}
}
func (m *RedisProxy_PrefixRoutes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProxy_PrefixRoutes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProxy_PrefixRoutes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProxy_PrefixRoutes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProxy_PrefixRoutes.Merge(m, src)
}
func (m *RedisProxy_PrefixRoutes) XXX_Size() int {
	return m.Size()
}
func (m *RedisProxy_PrefixRoutes) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProxy_PrefixRoutes.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProxy_PrefixRoutes proto.InternalMessageInfo

func (m *RedisProxy_PrefixRoutes) GetRoutes() []*RedisProxy_PrefixRoutes_Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *RedisProxy_PrefixRoutes) GetCaseInsensitive() bool {
	if m != nil {
		return m.CaseInsensitive
	}
	return false
}

// Deprecated: Do not use.
func (m *RedisProxy_PrefixRoutes) GetCatchAllCluster() string {
	if m != nil {
		return m.CatchAllCluster
	}
	return ""
}

func (m *RedisProxy_PrefixRoutes) GetCatchAllRoute() *RedisProxy_PrefixRoutes_Route {
	if m != nil {
		return m.CatchAllRoute
	}
	return nil
}

type RedisProxy_PrefixRoutes_Route struct {
	// String prefix that must match the beginning of the keys. Envoy will always favor the
	// longest match.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Indicates if the prefix needs to be removed from the key when forwarded.
	RemovePrefix bool `protobuf:"varint,2,opt,name=remove_prefix,json=removePrefix,proto3" json:"remove_prefix,omitempty"`
	// Upstream cluster to forward the command to.
	Cluster string `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Indicates that the route has a request mirroring policy.
	RequestMirrorPolicy  []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy `protobuf:"bytes,4,rep,name=request_mirror_policy,json=requestMirrorPolicy,proto3" json:"request_mirror_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                             `json:"-"`
	XXX_unrecognized     []byte                                               `json:"-"`
	XXX_sizecache        int32                                                `json:"-"`
}

func (m *RedisProxy_PrefixRoutes_Route) Reset()         { *m = RedisProxy_PrefixRoutes_Route{} }
func (m *RedisProxy_PrefixRoutes_Route) String() string { return proto.CompactTextString(m) }
func (*RedisProxy_PrefixRoutes_Route) ProtoMessage()    {}
func (*RedisProxy_PrefixRoutes_Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0, 1, 0}
}
func (m *RedisProxy_PrefixRoutes_Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProxy_PrefixRoutes_Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProxy_PrefixRoutes_Route.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProxy_PrefixRoutes_Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProxy_PrefixRoutes_Route.Merge(m, src)
}
func (m *RedisProxy_PrefixRoutes_Route) XXX_Size() int {
	return m.Size()
}
func (m *RedisProxy_PrefixRoutes_Route) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProxy_PrefixRoutes_Route.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProxy_PrefixRoutes_Route proto.InternalMessageInfo

func (m *RedisProxy_PrefixRoutes_Route) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *RedisProxy_PrefixRoutes_Route) GetRemovePrefix() bool {
	if m != nil {
		return m.RemovePrefix
	}
	return false
}

func (m *RedisProxy_PrefixRoutes_Route) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *RedisProxy_PrefixRoutes_Route) GetRequestMirrorPolicy() []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy {
	if m != nil {
		return m.RequestMirrorPolicy
	}
	return nil
}

// The router is capable of shadowing traffic from one cluster to another. The current
// implementation is "fire and forget," meaning Envoy will not wait for the shadow cluster to
// respond before returning the response from the primary cluster. All normal statistics are
// collected for the shadow cluster making this feature useful for testing.
type RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy struct {
	// Specifies the cluster that requests will be mirrored to. The cluster must
	// exist in the cluster manager configuration.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// If not specified or the runtime key is not present, all requests to the target cluster
	// will be mirrored.
	//
	// If specified, Envoy will lookup the runtime key to get the percentage of requests to the
	// mirror.
	//
	// Parsing this field is implemented such that the runtime key's data may be represented
	// as a :ref:`FractionalPercent <envoy_api_msg_type.FractionalPercent>` proto represented
	// as JSON/YAML and may also be represented as an integer with the assumption that the value
	// is an integral percentage out of 100. For instance, a runtime key lookup returning the
	// value "42" would parse as a `FractionalPercent` whose numerator is 42 and denominator is
	// HUNDRED.
	RuntimeFraction *core.RuntimeFractionalPercent `protobuf:"bytes,2,opt,name=runtime_fraction,json=runtimeFraction,proto3" json:"runtime_fraction,omitempty"`
	// Set this to TRUE to only mirror write commands, this is effectively replicating the
	// writes in a "fire and forget" manner.
	ExcludeReadCommands  bool     `protobuf:"varint,3,opt,name=exclude_read_commands,json=excludeReadCommands,proto3" json:"exclude_read_commands,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Reset() {
	*m = RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy{}
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) String() string {
	return proto.CompactTextString(m)
}
func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ProtoMessage() {}
func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{0, 1, 0, 0}
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.Merge(m, src)
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) XXX_Size() int {
	return m.Size()
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy proto.InternalMessageInfo

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetRuntimeFraction() *core.RuntimeFractionalPercent {
	if m != nil {
		return m.RuntimeFraction
	}
	return nil
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetExcludeReadCommands() bool {
	if m != nil {
		return m.ExcludeReadCommands
	}
	return false
}

// RedisProtocolOptions specifies Redis upstream protocol options. This object is used in
// :ref:`extension_protocol_options<envoy_api_field_Cluster.extension_protocol_options>`, keyed
// by the name `envoy.redis_proxy`.
type RedisProtocolOptions struct {
	// Upstream server password as defined by the `requirepass directive
	// <https://redis.io/topics/config>`_ in the server's configuration file.
	AuthPassword         *core.DataSource `protobuf:"bytes,1,opt,name=auth_password,json=authPassword,proto3" json:"auth_password,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RedisProtocolOptions) Reset()         { *m = RedisProtocolOptions{} }
func (m *RedisProtocolOptions) String() string { return proto.CompactTextString(m) }
func (*RedisProtocolOptions) ProtoMessage()    {}
func (*RedisProtocolOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_67e7179f1292d5ae, []int{1}
}
func (m *RedisProtocolOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedisProtocolOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RedisProtocolOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RedisProtocolOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedisProtocolOptions.Merge(m, src)
}
func (m *RedisProtocolOptions) XXX_Size() int {
	return m.Size()
}
func (m *RedisProtocolOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_RedisProtocolOptions.DiscardUnknown(m)
}

var xxx_messageInfo_RedisProtocolOptions proto.InternalMessageInfo

func (m *RedisProtocolOptions) GetAuthPassword() *core.DataSource {
	if m != nil {
		return m.AuthPassword
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.config.filter.network.redis_proxy.v2.RedisProxy_ConnPoolSettings_ReadPolicy", RedisProxy_ConnPoolSettings_ReadPolicy_name, RedisProxy_ConnPoolSettings_ReadPolicy_value)
	proto.RegisterType((*RedisProxy)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProxy")
	proto.RegisterType((*RedisProxy_ConnPoolSettings)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProxy.ConnPoolSettings")
	proto.RegisterType((*RedisProxy_PrefixRoutes)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes")
	proto.RegisterType((*RedisProxy_PrefixRoutes_Route)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.Route")
	proto.RegisterType((*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy")
	proto.RegisterType((*RedisProtocolOptions)(nil), "envoy.config.filter.network.redis_proxy.v2.RedisProtocolOptions")
}

func init() {
	proto.RegisterFile("envoy/config/filter/network/redis_proxy/v2/redis_proxy.proto", fileDescriptor_67e7179f1292d5ae)
}

var fileDescriptor_67e7179f1292d5ae = []byte{
	// 1017 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0xcd, 0x6e, 0x1b, 0x45,
	0x1c, 0x67, 0xec, 0xc4, 0x49, 0xc6, 0x71, 0xec, 0x4c, 0xd2, 0x62, 0xac, 0x34, 0x58, 0xe1, 0x12,
	0x82, 0x58, 0x4b, 0xee, 0x85, 0x03, 0x42, 0x8a, 0xdd, 0x84, 0x46, 0x22, 0x60, 0x26, 0x4d, 0x11,
	0x95, 0xaa, 0xd1, 0x78, 0x3d, 0xb6, 0x47, 0xdd, 0x9d, 0xd9, 0xce, 0xcc, 0x3a, 0x4e, 0x2f, 0x48,
	0x9c, 0x10, 0xe2, 0xc2, 0x8d, 0x67, 0xe0, 0x11, 0x38, 0x71, 0xaa, 0x38, 0xf6, 0x0d, 0x40, 0xb9,
	0xf1, 0x16, 0x68, 0x67, 0x66, 0x6d, 0x87, 0xb6, 0x22, 0x42, 0x39, 0xed, 0xce, 0xff, 0xf7, 0xff,
	0xfe, 0xf8, 0xc1, 0x4f, 0x99, 0x98, 0xc8, 0xcb, 0x56, 0x28, 0xc5, 0x90, 0x8f, 0x5a, 0x43, 0x1e,
	0x19, 0xa6, 0x5a, 0x82, 0x99, 0x0b, 0xa9, 0x9e, 0xb5, 0x14, 0x1b, 0x70, 0x4d, 0x12, 0x25, 0xa7,
	0x97, 0xad, 0x49, 0x7b, 0xf1, 0x19, 0x24, 0x4a, 0x1a, 0x89, 0x0e, 0xac, 0x75, 0xe0, 0xac, 0x03,
	0x67, 0x1d, 0x78, 0xeb, 0x60, 0x51, 0x7d, 0xd2, 0x6e, 0xec, 0xb8, 0x48, 0x34, 0xe1, 0x99, 0xaf,
	0x50, 0x2a, 0xd6, 0xea, 0x53, 0xcd, 0x9c, 0xa7, 0xc6, 0xee, 0x48, 0xca, 0x51, 0xc4, 0x5a, 0xf6,
	0xd5, 0x4f, 0x87, 0xad, 0x41, 0xaa, 0xa8, 0xe1, 0x52, 0xbc, 0x0d, 0xbf, 0x50, 0x34, 0x49, 0x98,
	0xd2, 0x1e, 0x7f, 0x77, 0x42, 0x23, 0x3e, 0xa0, 0x86, 0xb5, 0xf2, 0x1f, 0x0f, 0x6c, 0x8f, 0xe4,
	0x48, 0xda, 0xdf, 0x56, 0xf6, 0xe7, 0xa4, 0x7b, 0xaf, 0x36, 0x20, 0xc4, 0x59, 0x7e, 0xbd, 0x2c,
	0x3d, 0x74, 0x00, 0xcb, 0xda, 0x50, 0x43, 0x12, 0xc5, 0x86, 0x7c, 0x5a, 0x07, 0x4d, 0xb0, 0xbf,
	0xd6, 0x59, 0xfb, 0xed, 0xef, 0xdf, 0x8b, 0x4b, 0xaa, 0xd0, 0x04, 0x18, 0x66, 0x68, 0xcf, 0x82,
	0x68, 0x07, 0xae, 0x84, 0x51, 0xaa, 0x0d, 0x53, 0xf5, 0x82, 0xd5, 0x2b, 0xd4, 0x01, 0xce, 0x45,
	0x48, 0xc2, 0x55, 0xcd, 0x8c, 0xe1, 0x62, 0xa4, 0xeb, 0xc5, 0x26, 0xd8, 0x2f, 0xb7, 0x3f, 0x0f,
	0x6e, 0xde, 0xa4, 0x60, 0x9e, 0x53, 0xd0, 0x95, 0x42, 0xf4, 0xa4, 0x8c, 0xce, 0xbc, 0xbb, 0x0e,
	0xcc, 0xf2, 0x59, 0xfe, 0x11, 0x14, 0x6a, 0x00, 0xcf, 0x82, 0xa0, 0x03, 0xb8, 0x19, 0x51, 0xc3,
	0x44, 0x78, 0x49, 0xb8, 0x20, 0x31, 0x0f, 0x95, 0xd4, 0xf5, 0xa5, 0x26, 0xd8, 0x5f, 0xc5, 0x55,
	0x0f, 0x9c, 0x88, 0x53, 0x2b, 0x46, 0x63, 0x58, 0x71, 0x15, 0x12, 0x25, 0x53, 0xc3, 0x74, 0x7d,
	0xd9, 0x66, 0xd8, 0xfd, 0x9f, 0x19, 0xba, 0x86, 0x60, 0xeb, 0x0a, 0xaf, 0x27, 0x0b, 0x2f, 0xf4,
	0x0d, 0xac, 0x0f, 0xe4, 0x85, 0xd0, 0x46, 0x31, 0x1a, 0x13, 0x9a, 0x9a, 0x31, 0x49, 0xa8, 0xd6,
	0x17, 0x52, 0x0d, 0xea, 0x25, 0x1b, 0xf4, 0x9e, 0x0f, 0x4a, 0x13, 0x9e, 0xb9, 0xcd, 0xf6, 0x21,
	0x78, 0x40, 0x0d, 0x3d, 0x93, 0xa9, 0x0a, 0x19, 0xbe, 0x3b, 0x37, 0x3f, 0x4c, 0xcd, 0xb8, 0xe7,
	0x8d, 0x1b, 0x3f, 0x2d, 0xc3, 0xda, 0xbf, 0x3b, 0x83, 0x1e, 0x42, 0x28, 0x13, 0x62, 0x78, 0xcc,
	0x64, 0x6a, 0xec, 0xf4, 0xca, 0xed, 0xf7, 0x02, 0xb7, 0x31, 0x41, 0xbe, 0x31, 0xc1, 0x03, 0xbf,
	0x51, 0x9d, 0x8d, 0x5f, 0xfe, 0x7c, 0x1f, 0xd8, 0x66, 0xfe, 0x0a, 0x0a, 0xab, 0x00, 0xaf, 0xc9,
	0xe4, 0x91, 0xb3, 0x45, 0x1f, 0x43, 0xc4, 0x04, 0xed, 0x47, 0x8c, 0x8c, 0xa9, 0x1e, 0x1b, 0x3a,
	0x1a, 0x71, 0x31, 0xb2, 0x73, 0x5e, 0xc5, 0x9b, 0x0e, 0x79, 0x38, 0x07, 0x16, 0xd4, 0xb3, 0x2e,
	0x29, 0x16, 0x66, 0xfe, 0xed, 0xdc, 0x67, 0xea, 0x78, 0x0e, 0xa0, 0xcf, 0xe0, 0x4e, 0x4c, 0xa7,
	0xa4, 0x9f, 0x0e, 0x87, 0x4c, 0x11, 0xcd, 0x5f, 0x30, 0xd2, 0x67, 0x43, 0xa9, 0x18, 0x19, 0x46,
	0xa9, 0x1e, 0xdb, 0xb1, 0x55, 0x70, 0x3d, 0xa6, 0xd3, 0x8e, 0x55, 0x39, 0xe3, 0x2f, 0x58, 0xc7,
	0x2a, 0x1c, 0x67, 0x38, 0xfa, 0x1a, 0x6e, 0x7b, 0x5b, 0xab, 0x3f, 0xab, 0x78, 0xf9, 0xbf, 0x2a,
	0x5e, 0xca, 0x2a, 0xc6, 0xc8, 0x19, 0x5b, 0x5f, 0x79, 0xc1, 0x0c, 0x36, 0xb3, 0x94, 0xd2, 0xc4,
	0x8f, 0x2a, 0x15, 0xcf, 0x84, 0xbc, 0x10, 0x24, 0x94, 0x42, 0xb8, 0xac, 0xb5, 0x1f, 0xd8, 0xce,
	0x6b, 0xee, 0xcf, 0x4f, 0x84, 0xb9, 0xdf, 0x7e, 0x4c, 0xa3, 0x94, 0xe1, 0x7b, 0x31, 0x9d, 0x9e,
	0x7b, 0x27, 0xe7, 0xce, 0x47, 0x77, 0xee, 0x02, 0x7d, 0x07, 0xcb, 0x8a, 0xd1, 0x01, 0x49, 0x64,
	0xc4, 0xc3, 0xcb, 0xfa, 0x4a, 0x13, 0xec, 0x6f, 0xb4, 0xf1, 0x2d, 0x5d, 0x46, 0x80, 0x19, 0x1d,
	0xf4, 0xac, 0x67, 0x7f, 0x24, 0xdf, 0xdb, 0x23, 0x81, 0x6a, 0x26, 0xdf, 0x3b, 0xcf, 0xee, 0x3d,
	0x7f, 0x21, 0x08, 0x4b, 0xa7, 0x87, 0x67, 0x8f, 0x8e, 0x70, 0xed, 0x1d, 0xb4, 0x09, 0x2b, 0x3d,
	0x7c, 0x74, 0x7c, 0x84, 0x89, 0x17, 0x01, 0x54, 0x86, 0x2b, 0xf8, 0xa8, 0xf7, 0xc5, 0x49, 0xf7,
	0xb0, 0x56, 0x40, 0x08, 0x6e, 0x78, 0x3c, 0x97, 0x15, 0xd1, 0x0a, 0x2c, 0x1e, 0x7e, 0xf9, 0x6d,
	0x6d, 0xa9, 0xf1, 0x43, 0x09, 0xae, 0x2f, 0x9e, 0x01, 0xa2, 0xb0, 0xe4, 0x6f, 0x0b, 0x34, 0x8b,
	0xfb, 0xe5, 0xf6, 0xc9, 0x2d, 0xdc, 0x56, 0x60, 0x3f, 0xd8, 0x3b, 0x46, 0x1f, 0xc2, 0x5a, 0x48,
	0x35, 0x23, 0x5c, 0x68, 0x26, 0x34, 0x37, 0x7c, 0xc2, 0xfc, 0x86, 0x56, 0x33, 0xf9, 0xc9, 0x5c,
	0x8c, 0x02, 0xb8, 0x19, 0x52, 0x13, 0x8e, 0x09, 0x8d, 0x22, 0x92, 0xb3, 0x56, 0x71, 0xc6, 0x5a,
	0x55, 0x0b, 0x1e, 0x46, 0x51, 0xd7, 0xb3, 0xd7, 0x73, 0x58, 0x9d, 0xeb, 0xdb, 0x70, 0x76, 0x27,
	0x6f, 0xb5, 0x8c, 0x4a, 0x1e, 0xd4, 0x3e, 0x1b, 0x2f, 0x8b, 0x70, 0xd9, 0xfe, 0xa1, 0xbb, 0xb0,
	0xb4, 0xc8, 0xbf, 0xd8, 0xbf, 0xd0, 0x07, 0xb0, 0xa2, 0x58, 0x2c, 0x27, 0x2c, 0xa7, 0x67, 0x57,
	0xec, 0xba, 0x13, 0xf6, 0x72, 0xa5, 0x95, 0xeb, 0xf5, 0x2d, 0xb0, 0xf7, 0x8c, 0x9c, 0x7f, 0x06,
	0xf0, 0x8e, 0x62, 0xcf, 0x53, 0xa6, 0x0d, 0x89, 0xb9, 0x52, 0x52, 0xe5, 0x0b, 0xb9, 0x64, 0x87,
	0xf5, 0xf4, 0xd6, 0xaa, 0x0c, 0xb0, 0x0b, 0x73, 0x6a, 0xa3, 0xb8, 0xad, 0xc3, 0x5b, 0xea, 0x75,
	0x61, 0xe3, 0x25, 0x80, 0x5b, 0x6f, 0x50, 0x5e, 0x2c, 0x08, 0xbc, 0xb5, 0xa0, 0xc7, 0xb0, 0xa6,
	0x52, 0x91, 0xd1, 0x00, 0x19, 0x2a, 0xea, 0xd8, 0xa7, 0x60, 0x07, 0xf6, 0xd1, 0x1b, 0xe8, 0x15,
	0x3b, 0xd5, 0x63, 0xaf, 0x49, 0xa3, 0x1e, 0x53, 0x21, 0x13, 0x06, 0x57, 0xd5, 0x75, 0x04, 0xb5,
	0xe1, 0x1d, 0x36, 0x0d, 0xa3, 0x74, 0x90, 0x11, 0x1b, 0x1d, 0x90, 0x50, 0xc6, 0x31, 0x15, 0x03,
	0xed, 0xa9, 0x6d, 0xcb, 0x83, 0xd9, 0x45, 0x75, 0x3d, 0xb4, 0xf7, 0x04, 0x6e, 0xe7, 0x2d, 0x31,
	0x32, 0x94, 0xd1, 0x57, 0x89, 0x3b, 0xfd, 0x0e, 0xac, 0x5c, 0xe7, 0x7f, 0x70, 0x13, 0xfe, 0x5f,
	0xa7, 0x0b, 0xac, 0xdf, 0x79, 0xfa, 0xc7, 0xd5, 0x2e, 0x78, 0x75, 0xb5, 0x0b, 0xfe, 0xba, 0xda,
	0x05, 0xf0, 0x13, 0x2e, 0x9d, 0xb1, 0x9b, 0xc5, 0xcd, 0x67, 0xd6, 0xa9, 0xce, 0x87, 0x66, 0xd3,
	0xec, 0x81, 0x27, 0x85, 0x49, 0xbb, 0x5f, 0xb2, 0x94, 0x76, 0xff, 0x9f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x48, 0x9c, 0xd4, 0x30, 0x0d, 0x09, 0x00, 0x00,
}

func (m *RedisProxy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProxy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StatPrefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.StatPrefix)))
		i += copy(dAtA[i:], m.StatPrefix)
	}
	if len(m.Cluster) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if m.Settings != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.Settings.Size()))
		n1, err := m.Settings.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.LatencyInMicros {
		dAtA[i] = 0x20
		i++
		if m.LatencyInMicros {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PrefixRoutes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.PrefixRoutes.Size()))
		n2, err := m.PrefixRoutes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DownstreamAuthPassword != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.DownstreamAuthPassword.Size()))
		n3, err := m.DownstreamAuthPassword.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedisProxy_ConnPoolSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProxy_ConnPoolSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OpTimeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.OpTimeout)))
		n4, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.OpTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.EnableHashtagging {
		dAtA[i] = 0x10
		i++
		if m.EnableHashtagging {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.EnableRedirection {
		dAtA[i] = 0x18
		i++
		if m.EnableRedirection {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxBufferSizeBeforeFlush != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.MaxBufferSizeBeforeFlush))
	}
	if m.BufferFlushTimeout != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.BufferFlushTimeout)))
		n5, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.BufferFlushTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.MaxUpstreamUnknownConnections != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.MaxUpstreamUnknownConnections.Size()))
		n6, err := m.MaxUpstreamUnknownConnections.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.ReadPolicy != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.ReadPolicy))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedisProxy_PrefixRoutes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProxy_PrefixRoutes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Routes) > 0 {
		for _, msg := range m.Routes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRedisProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.CaseInsensitive {
		dAtA[i] = 0x10
		i++
		if m.CaseInsensitive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.CatchAllCluster) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.CatchAllCluster)))
		i += copy(dAtA[i:], m.CatchAllCluster)
	}
	if m.CatchAllRoute != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.CatchAllRoute.Size()))
		n7, err := m.CatchAllRoute.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedisProxy_PrefixRoutes_Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProxy_PrefixRoutes_Route) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Prefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if m.RemovePrefix {
		dAtA[i] = 0x10
		i++
		if m.RemovePrefix {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Cluster) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if len(m.RequestMirrorPolicy) > 0 {
		for _, msg := range m.RequestMirrorPolicy {
			dAtA[i] = 0x22
			i++
			i = encodeVarintRedisProxy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cluster) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if m.RuntimeFraction != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.RuntimeFraction.Size()))
		n8, err := m.RuntimeFraction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.ExcludeReadCommands {
		dAtA[i] = 0x18
		i++
		if m.ExcludeReadCommands {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedisProtocolOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedisProtocolOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AuthPassword != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRedisProxy(dAtA, i, uint64(m.AuthPassword.Size()))
		n9, err := m.AuthPassword.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintRedisProxy(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RedisProxy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StatPrefix)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.Settings != nil {
		l = m.Settings.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.LatencyInMicros {
		n += 2
	}
	if m.PrefixRoutes != nil {
		l = m.PrefixRoutes.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.DownstreamAuthPassword != nil {
		l = m.DownstreamAuthPassword.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedisProxy_ConnPoolSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.OpTimeout)
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.EnableHashtagging {
		n += 2
	}
	if m.EnableRedirection {
		n += 2
	}
	if m.MaxBufferSizeBeforeFlush != 0 {
		n += 1 + sovRedisProxy(uint64(m.MaxBufferSizeBeforeFlush))
	}
	if m.BufferFlushTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.BufferFlushTimeout)
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.MaxUpstreamUnknownConnections != nil {
		l = m.MaxUpstreamUnknownConnections.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.ReadPolicy != 0 {
		n += 1 + sovRedisProxy(uint64(m.ReadPolicy))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedisProxy_PrefixRoutes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovRedisProxy(uint64(l))
		}
	}
	if m.CaseInsensitive {
		n += 2
	}
	l = len(m.CatchAllCluster)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.CatchAllRoute != nil {
		l = m.CatchAllRoute.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedisProxy_PrefixRoutes_Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.RemovePrefix {
		n += 2
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if len(m.RequestMirrorPolicy) > 0 {
		for _, e := range m.RequestMirrorPolicy {
			l = e.Size()
			n += 1 + l + sovRedisProxy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.RuntimeFraction != nil {
		l = m.RuntimeFraction.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.ExcludeReadCommands {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedisProtocolOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AuthPassword != nil {
		l = m.AuthPassword.Size()
		n += 1 + l + sovRedisProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRedisProxy(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRedisProxy(x uint64) (n int) {
	return sovRedisProxy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RedisProxy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RedisProxy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RedisProxy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Settings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Settings == nil {
				m.Settings = &RedisProxy_ConnPoolSettings{}
			}
			if err := m.Settings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatencyInMicros", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LatencyInMicros = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRoutes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrefixRoutes == nil {
				m.PrefixRoutes = &RedisProxy_PrefixRoutes{}
			}
			if err := m.PrefixRoutes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DownstreamAuthPassword", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DownstreamAuthPassword == nil {
				m.DownstreamAuthPassword = &core.DataSource{}
			}
			if err := m.DownstreamAuthPassword.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedisProxy_ConnPoolSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnPoolSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnPoolSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OpTimeout == nil {
				m.OpTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.OpTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableHashtagging", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableHashtagging = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableRedirection", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableRedirection = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBufferSizeBeforeFlush", wireType)
			}
			m.MaxBufferSizeBeforeFlush = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxBufferSizeBeforeFlush |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BufferFlushTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BufferFlushTimeout == nil {
				m.BufferFlushTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.BufferFlushTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUpstreamUnknownConnections", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxUpstreamUnknownConnections == nil {
				m.MaxUpstreamUnknownConnections = &types.UInt32Value{}
			}
			if err := m.MaxUpstreamUnknownConnections.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadPolicy", wireType)
			}
			m.ReadPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadPolicy |= RedisProxy_ConnPoolSettings_ReadPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedisProxy_PrefixRoutes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrefixRoutes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrefixRoutes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &RedisProxy_PrefixRoutes_Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaseInsensitive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CaseInsensitive = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CatchAllCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CatchAllCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CatchAllRoute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CatchAllRoute == nil {
				m.CatchAllRoute = &RedisProxy_PrefixRoutes_Route{}
			}
			if err := m.CatchAllRoute.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedisProxy_PrefixRoutes_Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovePrefix", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RemovePrefix = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMirrorPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestMirrorPolicy = append(m.RequestMirrorPolicy, &RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy{})
			if err := m.RequestMirrorPolicy[len(m.RequestMirrorPolicy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestMirrorPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestMirrorPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeFraction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RuntimeFraction == nil {
				m.RuntimeFraction = &core.RuntimeFractionalPercent{}
			}
			if err := m.RuntimeFraction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludeReadCommands", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExcludeReadCommands = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedisProtocolOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RedisProtocolOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RedisProtocolOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthPassword", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRedisProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AuthPassword == nil {
				m.AuthPassword = &core.DataSource{}
			}
			if err := m.AuthPassword.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRedisProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRedisProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRedisProxy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRedisProxy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRedisProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRedisProxy
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthRedisProxy
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRedisProxy
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRedisProxy(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthRedisProxy
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRedisProxy = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRedisProxy   = fmt.Errorf("proto: integer overflow")
)
