// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/lds.proto

package v2

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	listener "github.com/envoyproxy/go-control-plane/envoy/api/v2/listener"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Listener_DrainType int32

const (
	// Drain in response to calling /healthcheck/fail admin endpoint (along with the health check
	// filter), listener removal/modification, and hot restart.
	Listener_DEFAULT Listener_DrainType = 0
	// Drain in response to listener removal/modification and hot restart. This setting does not
	// include /healthcheck/fail. This setting may be desirable if Envoy is hosting both ingress
	// and egress listeners.
	Listener_MODIFY_ONLY Listener_DrainType = 1
)

var Listener_DrainType_name = map[int32]string{
	0: "DEFAULT",
	1: "MODIFY_ONLY",
}

var Listener_DrainType_value = map[string]int32{
	"DEFAULT":     0,
	"MODIFY_ONLY": 1,
}

func (x Listener_DrainType) String() string {
	return proto.EnumName(Listener_DrainType_name, int32(x))
}

func (Listener_DrainType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_34e2cd84a105bcd1, []int{0, 0}
}

// [#comment:next free field: 18]
type Listener struct {
	// The unique name by which this listener is known. If no name is provided,
	// Envoy will allocate an internal UUID for the listener. If the listener is to be dynamically
	// updated or removed via :ref:`LDS <config_listeners_lds>` a unique name must be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The address that the listener should listen on. In general, the address must be unique, though
	// that is governed by the bind rules of the OS. E.g., multiple listeners can listen on port 0 on
	// Linux as the actual port will be allocated by the OS.
	Address *core.Address `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// A list of filter chains to consider for this listener. The
	// :ref:`FilterChain <envoy_api_msg_listener.FilterChain>` with the most specific
	// :ref:`FilterChainMatch <envoy_api_msg_listener.FilterChainMatch>` criteria is used on a
	// connection.
	//
	// Example using SNI for filter chain selection can be found in the
	// :ref:`FAQ entry <faq_how_to_setup_sni>`.
	FilterChains []*listener.FilterChain `protobuf:"bytes,3,rep,name=filter_chains,json=filterChains,proto3" json:"filter_chains,omitempty"`
	// If a connection is redirected using *iptables*, the port on which the proxy
	// receives it might be different from the original destination address. When this flag is set to
	// true, the listener hands off redirected connections to the listener associated with the
	// original destination address. If there is no listener associated with the original destination
	// address, the connection is handled by the listener that receives it. Defaults to false.
	//
	// .. attention::
	//
	//   This field is deprecated. Use :ref:`an original_dst <config_listener_filters_original_dst>`
	//   :ref:`listener filter <envoy_api_field_Listener.listener_filters>` instead.
	//
	//   Note that hand off to another listener is *NOT* performed without this flag. Once
	//   :ref:`FilterChainMatch <envoy_api_msg_listener.FilterChainMatch>` is implemented this flag
	//   will be removed, as filter chain matching can be used to select a filter chain based on the
	//   restored destination address.
	UseOriginalDst *types.BoolValue `protobuf:"bytes,4,opt,name=use_original_dst,json=useOriginalDst,proto3" json:"use_original_dst,omitempty"` // Deprecated: Do not use.
	// Soft limit on size of the listener’s new connection read and write buffers.
	// If unspecified, an implementation defined default is applied (1MiB).
	PerConnectionBufferLimitBytes *types.UInt32Value `protobuf:"bytes,5,opt,name=per_connection_buffer_limit_bytes,json=perConnectionBufferLimitBytes,proto3" json:"per_connection_buffer_limit_bytes,omitempty"`
	// Listener metadata.
	Metadata *core.Metadata `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// [#not-implemented-hide:]
	DeprecatedV1 *Listener_DeprecatedV1 `protobuf:"bytes,7,opt,name=deprecated_v1,json=deprecatedV1,proto3" json:"deprecated_v1,omitempty"`
	// The type of draining to perform at a listener-wide level.
	DrainType Listener_DrainType `protobuf:"varint,8,opt,name=drain_type,json=drainType,proto3,enum=envoy.api.v2.Listener_DrainType" json:"drain_type,omitempty"`
	// Listener filters have the opportunity to manipulate and augment the connection metadata that
	// is used in connection filter chain matching, for example. These filters are run before any in
	// :ref:`filter_chains <envoy_api_field_Listener.filter_chains>`. Order matters as the
	// filters are processed sequentially right after a socket has been accepted by the listener, and
	// before a connection is created.
	// UDP Listener filters can be specified when the protocol in the listener socket address in
	// :ref:`protocol <envoy_api_field_core.SocketAddress.protocol>` is :ref:'UDP
	// <envoy_api_field_core.Protocol.UDP>`.
	// UDP listeners currently support a single filter.
	ListenerFilters []*listener.ListenerFilter `protobuf:"bytes,9,rep,name=listener_filters,json=listenerFilters,proto3" json:"listener_filters,omitempty"`
	// The timeout to wait for all listener filters to complete operation. If the timeout is reached,
	// the accepted socket is closed without a connection being created unless
	// `continue_on_listener_filters_timeout` is set to true. Specify 0 to disable the
	// timeout. If not specified, a default timeout of 15s is used.
	ListenerFiltersTimeout *time.Duration `protobuf:"bytes,15,opt,name=listener_filters_timeout,json=listenerFiltersTimeout,proto3,stdduration" json:"listener_filters_timeout,omitempty"`
	// Whether a connection should be created when listener filters timeout. Default is false.
	//
	// .. attention::
	//
	//   Some listener filters, such as :ref:`Proxy Protocol filter
	//   <config_listener_filters_proxy_protocol>`, should not be used with this option. It will cause
	//   unexpected behavior when a connection is created.
	ContinueOnListenerFiltersTimeout bool `protobuf:"varint,17,opt,name=continue_on_listener_filters_timeout,json=continueOnListenerFiltersTimeout,proto3" json:"continue_on_listener_filters_timeout,omitempty"`
	// Whether the listener should be set as a transparent socket.
	// When this flag is set to true, connections can be redirected to the listener using an
	// *iptables* *TPROXY* target, in which case the original source and destination addresses and
	// ports are preserved on accepted connections. This flag should be used in combination with
	// :ref:`an original_dst <config_listener_filters_original_dst>` :ref:`listener filter
	// <envoy_api_field_Listener.listener_filters>` to mark the connections' local addresses as
	// "restored." This can be used to hand off each redirected connection to another listener
	// associated with the connection's destination address. Direct connections to the socket without
	// using *TPROXY* cannot be distinguished from connections redirected using *TPROXY* and are
	// therefore treated as if they were redirected.
	// When this flag is set to false, the listener's socket is explicitly reset as non-transparent.
	// Setting this flag requires Envoy to run with the *CAP_NET_ADMIN* capability.
	// When this flag is not set (default), the socket is not modified, i.e. the transparent option
	// is neither set nor reset.
	Transparent *types.BoolValue `protobuf:"bytes,10,opt,name=transparent,proto3" json:"transparent,omitempty"`
	// Whether the listener should set the *IP_FREEBIND* socket option. When this
	// flag is set to true, listeners can be bound to an IP address that is not
	// configured on the system running Envoy. When this flag is set to false, the
	// option *IP_FREEBIND* is disabled on the socket. When this flag is not set
	// (default), the socket is not modified, i.e. the option is neither enabled
	// nor disabled.
	Freebind *types.BoolValue `protobuf:"bytes,11,opt,name=freebind,proto3" json:"freebind,omitempty"`
	// Additional socket options that may not be present in Envoy source code or
	// precompiled binaries.
	SocketOptions []*core.SocketOption `protobuf:"bytes,13,rep,name=socket_options,json=socketOptions,proto3" json:"socket_options,omitempty"`
	// Whether the listener should accept TCP Fast Open (TFO) connections.
	// When this flag is set to a value greater than 0, the option TCP_FASTOPEN is enabled on
	// the socket, with a queue length of the specified size
	// (see `details in RFC7413 <https://tools.ietf.org/html/rfc7413#section-5.1>`_).
	// When this flag is set to 0, the option TCP_FASTOPEN is disabled on the socket.
	// When this flag is not set (default), the socket is not modified,
	// i.e. the option is neither enabled nor disabled.
	//
	// On Linux, the net.ipv4.tcp_fastopen kernel parameter must include flag 0x2 to enable
	// TCP_FASTOPEN.
	// See `ip-sysctl.txt <https://www.kernel.org/doc/Documentation/networking/ip-sysctl.txt>`_.
	//
	// On macOS, only values of 0, 1, and unset are valid; other values may result in an error.
	// To set the queue length on macOS, set the net.inet.tcp.fastopen_backlog kernel parameter.
	TcpFastOpenQueueLength *types.UInt32Value `protobuf:"bytes,12,opt,name=tcp_fast_open_queue_length,json=tcpFastOpenQueueLength,proto3" json:"tcp_fast_open_queue_length,omitempty"`
	// Specifies the intended direction of the traffic relative to the local Envoy.
	TrafficDirection     core.TrafficDirection `protobuf:"varint,16,opt,name=traffic_direction,json=trafficDirection,proto3,enum=envoy.api.v2.core.TrafficDirection" json:"traffic_direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Listener) Reset()         { *m = Listener{} }
func (m *Listener) String() string { return proto.CompactTextString(m) }
func (*Listener) ProtoMessage()    {}
func (*Listener) Descriptor() ([]byte, []int) {
	return fileDescriptor_34e2cd84a105bcd1, []int{0}
}
func (m *Listener) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Listener) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Listener.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Listener) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Listener.Merge(m, src)
}
func (m *Listener) XXX_Size() int {
	return m.Size()
}
func (m *Listener) XXX_DiscardUnknown() {
	xxx_messageInfo_Listener.DiscardUnknown(m)
}

var xxx_messageInfo_Listener proto.InternalMessageInfo

func (m *Listener) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Listener) GetAddress() *core.Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Listener) GetFilterChains() []*listener.FilterChain {
	if m != nil {
		return m.FilterChains
	}
	return nil
}

// Deprecated: Do not use.
func (m *Listener) GetUseOriginalDst() *types.BoolValue {
	if m != nil {
		return m.UseOriginalDst
	}
	return nil
}

func (m *Listener) GetPerConnectionBufferLimitBytes() *types.UInt32Value {
	if m != nil {
		return m.PerConnectionBufferLimitBytes
	}
	return nil
}

func (m *Listener) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Listener) GetDeprecatedV1() *Listener_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

func (m *Listener) GetDrainType() Listener_DrainType {
	if m != nil {
		return m.DrainType
	}
	return Listener_DEFAULT
}

func (m *Listener) GetListenerFilters() []*listener.ListenerFilter {
	if m != nil {
		return m.ListenerFilters
	}
	return nil
}

func (m *Listener) GetListenerFiltersTimeout() *time.Duration {
	if m != nil {
		return m.ListenerFiltersTimeout
	}
	return nil
}

func (m *Listener) GetContinueOnListenerFiltersTimeout() bool {
	if m != nil {
		return m.ContinueOnListenerFiltersTimeout
	}
	return false
}

func (m *Listener) GetTransparent() *types.BoolValue {
	if m != nil {
		return m.Transparent
	}
	return nil
}

func (m *Listener) GetFreebind() *types.BoolValue {
	if m != nil {
		return m.Freebind
	}
	return nil
}

func (m *Listener) GetSocketOptions() []*core.SocketOption {
	if m != nil {
		return m.SocketOptions
	}
	return nil
}

func (m *Listener) GetTcpFastOpenQueueLength() *types.UInt32Value {
	if m != nil {
		return m.TcpFastOpenQueueLength
	}
	return nil
}

func (m *Listener) GetTrafficDirection() core.TrafficDirection {
	if m != nil {
		return m.TrafficDirection
	}
	return core.TrafficDirection_UNSPECIFIED
}

// [#not-implemented-hide:]
type Listener_DeprecatedV1 struct {
	// Whether the listener should bind to the port. A listener that doesn't
	// bind can only receive connections redirected from other listeners that
	// set use_original_dst parameter to true. Default is true.
	//
	// [V2-API-DIFF] This is deprecated in v2, all Listeners will bind to their
	// port. An additional filter chain must be created for every original
	// destination port this listener may redirect to in v2, with the original
	// port specified in the FilterChainMatch destination_port field.
	//
	// [#comment:TODO(PiotrSikora): Remove this once verified that we no longer need it.]
	BindToPort           *types.BoolValue `protobuf:"bytes,1,opt,name=bind_to_port,json=bindToPort,proto3" json:"bind_to_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Listener_DeprecatedV1) Reset()         { *m = Listener_DeprecatedV1{} }
func (m *Listener_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*Listener_DeprecatedV1) ProtoMessage()    {}
func (*Listener_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_34e2cd84a105bcd1, []int{0, 0}
}
func (m *Listener_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Listener_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Listener_DeprecatedV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Listener_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Listener_DeprecatedV1.Merge(m, src)
}
func (m *Listener_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *Listener_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_Listener_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_Listener_DeprecatedV1 proto.InternalMessageInfo

func (m *Listener_DeprecatedV1) GetBindToPort() *types.BoolValue {
	if m != nil {
		return m.BindToPort
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.api.v2.Listener_DrainType", Listener_DrainType_name, Listener_DrainType_value)
	proto.RegisterType((*Listener)(nil), "envoy.api.v2.Listener")
	proto.RegisterType((*Listener_DeprecatedV1)(nil), "envoy.api.v2.Listener.DeprecatedV1")
}

func init() { proto.RegisterFile("envoy/api/v2/lds.proto", fileDescriptor_34e2cd84a105bcd1) }

var fileDescriptor_34e2cd84a105bcd1 = []byte{
	// 919 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xc7, 0x3b, 0x49, 0xda, 0x38, 0x63, 0xc7, 0x71, 0x47, 0x28, 0x5d, 0x4c, 0x70, 0x8c, 0x1b,
	0x24, 0xc3, 0xc1, 0xa6, 0xae, 0x04, 0x52, 0xa9, 0x04, 0x75, 0x8d, 0x69, 0x91, 0x5b, 0x87, 0x4d,
	0x5a, 0x35, 0xa7, 0xd1, 0x78, 0xf7, 0xad, 0x33, 0x62, 0x3d, 0xb3, 0x9d, 0x99, 0x35, 0xf8, 0x8a,
	0x84, 0x84, 0xb8, 0x72, 0xe1, 0x23, 0xf0, 0x19, 0x38, 0x71, 0xe4, 0x84, 0x90, 0xf8, 0x00, 0xa0,
	0x88, 0x0b, 0xdf, 0x02, 0xed, 0x78, 0xd7, 0xb5, 0x1d, 0xbb, 0xe5, 0xd0, 0xdb, 0x9b, 0x79, 0xbf,
	0xf7, 0x9f, 0xf1, 0xff, 0xbd, 0x1d, 0xe3, 0x7d, 0x10, 0x63, 0x39, 0x69, 0xb2, 0x88, 0x37, 0xc7,
	0xad, 0x66, 0xe8, 0xeb, 0x46, 0xa4, 0xa4, 0x91, 0xa4, 0x60, 0xf7, 0x1b, 0x2c, 0xe2, 0x8d, 0x71,
	0xab, 0x7c, 0xb8, 0x40, 0x79, 0x52, 0x41, 0x93, 0xf9, 0xbe, 0x02, 0x9d, 0xe2, 0xe5, 0x83, 0xcb,
	0xc0, 0x80, 0x69, 0x58, 0x99, 0xf5, 0xb9, 0xf6, 0xe4, 0x18, 0xd4, 0x24, 0xcd, 0x1e, 0x2d, 0x5e,
	0x81, 0x6b, 0x03, 0x02, 0xd4, 0x2c, 0xc8, 0x34, 0x86, 0x52, 0x0e, 0x43, 0xb0, 0x18, 0x13, 0x42,
	0x1a, 0x66, 0xb8, 0x14, 0xd9, 0xf9, 0x95, 0x34, 0x6b, 0x57, 0x83, 0x38, 0x68, 0xfa, 0xb1, 0xb2,
	0xc0, 0xba, 0xfc, 0xd7, 0x8a, 0x45, 0x11, 0xa8, 0xac, 0xfe, 0xc6, 0x98, 0x85, 0xdc, 0x67, 0x06,
	0x9a, 0x59, 0x90, 0x26, 0xde, 0x18, 0xca, 0xa1, 0xb4, 0x61, 0x33, 0x89, 0xa6, 0xbb, 0xb5, 0xef,
	0x30, 0xce, 0xf5, 0xd2, 0xfb, 0x11, 0x82, 0xb7, 0x04, 0x1b, 0x81, 0x83, 0xaa, 0xa8, 0xbe, 0xe3,
	0xda, 0x98, 0x7c, 0x8a, 0xb7, 0x53, 0x83, 0x9c, 0x8d, 0x2a, 0xaa, 0xe7, 0x5b, 0xe5, 0xc6, 0xbc,
	0xa1, 0x8d, 0xc4, 0xa1, 0xc6, 0xbd, 0x29, 0xd1, 0xc6, 0xbf, 0xfc, 0xfb, 0xeb, 0xe6, 0xd5, 0x1f,
	0xd0, 0x46, 0x09, 0xb9, 0x59, 0x19, 0xf9, 0x1c, 0xef, 0x06, 0x3c, 0x34, 0xa0, 0xa8, 0x77, 0xce,
	0xb8, 0xd0, 0xce, 0x66, 0x75, 0xb3, 0x9e, 0x6f, 0xd5, 0x16, 0x75, 0x66, 0x26, 0x75, 0x2d, 0x7b,
	0x3f, 0x41, 0xdd, 0x42, 0xf0, 0x62, 0xa1, 0xc9, 0x03, 0x5c, 0x8a, 0x35, 0x50, 0xa9, 0xf8, 0x90,
	0x0b, 0x16, 0x52, 0x5f, 0x1b, 0x67, 0x2b, 0xbd, 0xd3, 0xd4, 0x95, 0x46, 0xe6, 0x4a, 0xa3, 0x2d,
	0x65, 0xf8, 0x94, 0x85, 0x31, 0xb4, 0x37, 0x1c, 0xe4, 0x16, 0x63, 0x0d, 0xfd, 0xb4, 0xac, 0xa3,
	0x0d, 0x09, 0xf0, 0x3b, 0x51, 0x72, 0x1f, 0x29, 0x04, 0x78, 0x89, 0xb9, 0x74, 0x10, 0x07, 0x01,
	0x28, 0x1a, 0xf2, 0x11, 0x37, 0x74, 0x30, 0x31, 0xa0, 0x9d, 0xab, 0x56, 0xfa, 0xe0, 0x92, 0xf4,
	0x93, 0x87, 0xc2, 0xdc, 0x6e, 0x59, 0x71, 0xf7, 0xed, 0x08, 0xd4, 0xfd, 0x99, 0x4a, 0xdb, 0x8a,
	0xf4, 0x12, 0x8d, 0x76, 0x22, 0x41, 0x3e, 0xc2, 0xb9, 0x11, 0x18, 0xe6, 0x33, 0xc3, 0x9c, 0x6b,
	0x56, 0xee, 0xad, 0x15, 0xee, 0x3d, 0x4a, 0x11, 0x77, 0x06, 0x93, 0x07, 0x78, 0xd7, 0x87, 0x48,
	0x81, 0xc7, 0x0c, 0xf8, 0x74, 0x7c, 0xcb, 0xd9, 0xb6, 0xd5, 0x37, 0x17, 0xab, 0xb3, 0xc6, 0x35,
	0x3a, 0x33, 0xf6, 0xe9, 0x2d, 0xb7, 0xe0, 0xcf, 0xad, 0xc8, 0x27, 0x18, 0xfb, 0x8a, 0x71, 0x41,
	0xcd, 0x24, 0x02, 0x27, 0x57, 0x45, 0xf5, 0x62, 0xab, 0xba, 0x4e, 0x26, 0x01, 0x4f, 0x27, 0x11,
	0xb8, 0x3b, 0x7e, 0x16, 0x92, 0x63, 0x5c, 0xca, 0x7a, 0x43, 0xa7, 0xed, 0xd0, 0xce, 0x8e, 0xed,
	0xe0, 0xbb, 0x6b, 0x3a, 0x98, 0xe9, 0x4d, 0x3b, 0xe9, 0xee, 0x85, 0x0b, 0x6b, 0x4d, 0xce, 0xb0,
	0xb3, 0xac, 0x48, 0x0d, 0x1f, 0x81, 0x8c, 0x8d, 0xb3, 0x67, 0x7f, 0xe7, 0x9b, 0x97, 0x4c, 0xef,
	0xa4, 0x5f, 0x41, 0x7b, 0xeb, 0xa7, 0xbf, 0x0e, 0x91, 0xbb, 0xbf, 0xa4, 0x79, 0x3a, 0x2d, 0x27,
	0x8f, 0xf1, 0x91, 0x27, 0x85, 0xe1, 0x22, 0x06, 0x2a, 0x05, 0x5d, 0x7b, 0xcc, 0xf5, 0x2a, 0xaa,
	0xe7, 0xdc, 0x6a, 0xc6, 0xf6, 0x45, 0x6f, 0xb5, 0xde, 0x5d, 0x9c, 0x37, 0x8a, 0x09, 0x1d, 0x31,
	0x05, 0xc2, 0x38, 0xf8, 0x55, 0xd3, 0xe6, 0xce, 0xe3, 0xe4, 0x43, 0x9c, 0x0b, 0x14, 0xc0, 0x80,
	0x0b, 0xdf, 0xc9, 0xbf, 0xb2, 0x74, 0xc6, 0x92, 0x2e, 0x2e, 0x6a, 0xe9, 0x7d, 0x05, 0x86, 0xca,
	0xc8, 0xbe, 0x0d, 0xce, 0xae, 0x35, 0xfc, 0x70, 0xc5, 0xf0, 0x9c, 0x58, 0xb0, 0x6f, 0x39, 0x77,
	0x57, 0xcf, 0xad, 0x34, 0x79, 0x86, 0xcb, 0xc6, 0x8b, 0x68, 0xc0, 0x74, 0xa2, 0x04, 0x82, 0x3e,
	0x8f, 0x21, 0x06, 0x1a, 0x82, 0x18, 0x9a, 0x73, 0xa7, 0xf0, 0x3f, 0xe6, 0x7b, 0xdf, 0x78, 0x51,
	0x97, 0x69, 0xd3, 0x8f, 0x40, 0x7c, 0x99, 0x14, 0xf7, 0x6c, 0x2d, 0x39, 0xc6, 0xd7, 0x8d, 0x62,
	0x41, 0xc0, 0x3d, 0xea, 0x73, 0x35, 0x9d, 0x7e, 0xa7, 0x64, 0x87, 0xeb, 0xe6, 0x8a, 0x4b, 0x9e,
	0x4e, 0xd9, 0x4e, 0x86, 0xba, 0x25, 0xb3, 0xb4, 0x53, 0xee, 0xe1, 0xc2, 0xfc, 0x14, 0x93, 0xbb,
	0xb8, 0x90, 0x78, 0x41, 0x8d, 0xa4, 0x91, 0x54, 0xc6, 0xbe, 0x49, 0x2f, 0xf7, 0x0f, 0x27, 0xfc,
	0xa9, 0x3c, 0x96, 0xca, 0xd4, 0xde, 0xc3, 0x3b, 0xb3, 0x61, 0x26, 0x79, 0xbc, 0xdd, 0xf9, 0xac,
	0x7b, 0xef, 0x49, 0xef, 0xb4, 0x74, 0x85, 0xec, 0xe1, 0xfc, 0xa3, 0x7e, 0xe7, 0x61, 0xf7, 0x8c,
	0xf6, 0x1f, 0xf7, 0xce, 0x4a, 0xe8, 0x8b, 0xad, 0x5c, 0xb1, 0xb4, 0xd7, 0xfa, 0x7d, 0x03, 0x3b,
	0xd9, 0x0c, 0x74, 0xb2, 0x67, 0xfd, 0x04, 0xd4, 0x98, 0x7b, 0x40, 0x18, 0x2e, 0x76, 0x20, 0x34,
	0x2c, 0x03, 0x34, 0x59, 0xfa, 0x91, 0x36, 0x3b, 0x2b, 0x73, 0xe1, 0x79, 0x0c, 0xda, 0x94, 0x8f,
	0x5e, 0x0e, 0xe9, 0x48, 0x0a, 0x0d, 0xb5, 0x2b, 0x75, 0xf4, 0x01, 0x22, 0xcf, 0xf0, 0xde, 0x89,
	0x51, 0xc0, 0x46, 0x2f, 0xce, 0xa8, 0x2c, 0x95, 0x2f, 0xcb, 0x1f, 0xae, 0xcd, 0x2f, 0x28, 0xc7,
	0xb8, 0xd8, 0x05, 0xe3, 0x9d, 0xbf, 0x46, 0xe1, 0xda, 0xb7, 0x7f, 0xfe, 0xf3, 0xe3, 0xc6, 0x41,
	0xed, 0xc6, 0xc2, 0x9f, 0xe0, 0x9d, 0xec, 0x6b, 0xd3, 0x77, 0xd0, 0xfb, 0xed, 0x8f, 0x7f, 0xbe,
	0xa8, 0xa0, 0xdf, 0x2e, 0x2a, 0xe8, 0x8f, 0x8b, 0x0a, 0xfa, 0xfb, 0xa2, 0x82, 0x70, 0x99, 0xcb,
	0xa9, 0x70, 0xa4, 0xe4, 0x37, 0x93, 0x85, 0x33, 0xda, 0xb9, 0x9e, 0xaf, 0x8f, 0x93, 0x96, 0x1e,
	0xa3, 0xef, 0x11, 0x1a, 0x5c, 0xb3, 0xed, 0xbd, 0xfd, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf1,
	0xba, 0x69, 0x1b, 0xd4, 0x07, 0x00, 0x00,
}

func (this *Listener) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Listener)
	if !ok {
		that2, ok := that.(Listener)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Address.Equal(that1.Address) {
		return false
	}
	if len(this.FilterChains) != len(that1.FilterChains) {
		return false
	}
	for i := range this.FilterChains {
		if !this.FilterChains[i].Equal(that1.FilterChains[i]) {
			return false
		}
	}
	if !this.UseOriginalDst.Equal(that1.UseOriginalDst) {
		return false
	}
	if !this.PerConnectionBufferLimitBytes.Equal(that1.PerConnectionBufferLimitBytes) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	if this.DrainType != that1.DrainType {
		return false
	}
	if len(this.ListenerFilters) != len(that1.ListenerFilters) {
		return false
	}
	for i := range this.ListenerFilters {
		if !this.ListenerFilters[i].Equal(that1.ListenerFilters[i]) {
			return false
		}
	}
	if this.ListenerFiltersTimeout != nil && that1.ListenerFiltersTimeout != nil {
		if *this.ListenerFiltersTimeout != *that1.ListenerFiltersTimeout {
			return false
		}
	} else if this.ListenerFiltersTimeout != nil {
		return false
	} else if that1.ListenerFiltersTimeout != nil {
		return false
	}
	if this.ContinueOnListenerFiltersTimeout != that1.ContinueOnListenerFiltersTimeout {
		return false
	}
	if !this.Transparent.Equal(that1.Transparent) {
		return false
	}
	if !this.Freebind.Equal(that1.Freebind) {
		return false
	}
	if len(this.SocketOptions) != len(that1.SocketOptions) {
		return false
	}
	for i := range this.SocketOptions {
		if !this.SocketOptions[i].Equal(that1.SocketOptions[i]) {
			return false
		}
	}
	if !this.TcpFastOpenQueueLength.Equal(that1.TcpFastOpenQueueLength) {
		return false
	}
	if this.TrafficDirection != that1.TrafficDirection {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Listener_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Listener_DeprecatedV1)
	if !ok {
		that2, ok := that.(Listener_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.BindToPort.Equal(that1.BindToPort) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ListenerDiscoveryServiceClient is the client API for ListenerDiscoveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ListenerDiscoveryServiceClient interface {
	DeltaListeners(ctx context.Context, opts ...grpc.CallOption) (ListenerDiscoveryService_DeltaListenersClient, error)
	StreamListeners(ctx context.Context, opts ...grpc.CallOption) (ListenerDiscoveryService_StreamListenersClient, error)
	FetchListeners(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error)
}

type listenerDiscoveryServiceClient struct {
	cc *grpc.ClientConn
}

func NewListenerDiscoveryServiceClient(cc *grpc.ClientConn) ListenerDiscoveryServiceClient {
	return &listenerDiscoveryServiceClient{cc}
}

func (c *listenerDiscoveryServiceClient) DeltaListeners(ctx context.Context, opts ...grpc.CallOption) (ListenerDiscoveryService_DeltaListenersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ListenerDiscoveryService_serviceDesc.Streams[0], "/envoy.api.v2.ListenerDiscoveryService/DeltaListeners", opts...)
	if err != nil {
		return nil, err
	}
	x := &listenerDiscoveryServiceDeltaListenersClient{stream}
	return x, nil
}

type ListenerDiscoveryService_DeltaListenersClient interface {
	Send(*DeltaDiscoveryRequest) error
	Recv() (*DeltaDiscoveryResponse, error)
	grpc.ClientStream
}

type listenerDiscoveryServiceDeltaListenersClient struct {
	grpc.ClientStream
}

func (x *listenerDiscoveryServiceDeltaListenersClient) Send(m *DeltaDiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *listenerDiscoveryServiceDeltaListenersClient) Recv() (*DeltaDiscoveryResponse, error) {
	m := new(DeltaDiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *listenerDiscoveryServiceClient) StreamListeners(ctx context.Context, opts ...grpc.CallOption) (ListenerDiscoveryService_StreamListenersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ListenerDiscoveryService_serviceDesc.Streams[1], "/envoy.api.v2.ListenerDiscoveryService/StreamListeners", opts...)
	if err != nil {
		return nil, err
	}
	x := &listenerDiscoveryServiceStreamListenersClient{stream}
	return x, nil
}

type ListenerDiscoveryService_StreamListenersClient interface {
	Send(*DiscoveryRequest) error
	Recv() (*DiscoveryResponse, error)
	grpc.ClientStream
}

type listenerDiscoveryServiceStreamListenersClient struct {
	grpc.ClientStream
}

func (x *listenerDiscoveryServiceStreamListenersClient) Send(m *DiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *listenerDiscoveryServiceStreamListenersClient) Recv() (*DiscoveryResponse, error) {
	m := new(DiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *listenerDiscoveryServiceClient) FetchListeners(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error) {
	out := new(DiscoveryResponse)
	err := c.cc.Invoke(ctx, "/envoy.api.v2.ListenerDiscoveryService/FetchListeners", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ListenerDiscoveryServiceServer is the server API for ListenerDiscoveryService service.
type ListenerDiscoveryServiceServer interface {
	DeltaListeners(ListenerDiscoveryService_DeltaListenersServer) error
	StreamListeners(ListenerDiscoveryService_StreamListenersServer) error
	FetchListeners(context.Context, *DiscoveryRequest) (*DiscoveryResponse, error)
}

func RegisterListenerDiscoveryServiceServer(s *grpc.Server, srv ListenerDiscoveryServiceServer) {
	s.RegisterService(&_ListenerDiscoveryService_serviceDesc, srv)
}

func _ListenerDiscoveryService_DeltaListeners_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ListenerDiscoveryServiceServer).DeltaListeners(&listenerDiscoveryServiceDeltaListenersServer{stream})
}

type ListenerDiscoveryService_DeltaListenersServer interface {
	Send(*DeltaDiscoveryResponse) error
	Recv() (*DeltaDiscoveryRequest, error)
	grpc.ServerStream
}

type listenerDiscoveryServiceDeltaListenersServer struct {
	grpc.ServerStream
}

func (x *listenerDiscoveryServiceDeltaListenersServer) Send(m *DeltaDiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *listenerDiscoveryServiceDeltaListenersServer) Recv() (*DeltaDiscoveryRequest, error) {
	m := new(DeltaDiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ListenerDiscoveryService_StreamListeners_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ListenerDiscoveryServiceServer).StreamListeners(&listenerDiscoveryServiceStreamListenersServer{stream})
}

type ListenerDiscoveryService_StreamListenersServer interface {
	Send(*DiscoveryResponse) error
	Recv() (*DiscoveryRequest, error)
	grpc.ServerStream
}

type listenerDiscoveryServiceStreamListenersServer struct {
	grpc.ServerStream
}

func (x *listenerDiscoveryServiceStreamListenersServer) Send(m *DiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *listenerDiscoveryServiceStreamListenersServer) Recv() (*DiscoveryRequest, error) {
	m := new(DiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ListenerDiscoveryService_FetchListeners_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ListenerDiscoveryServiceServer).FetchListeners(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/envoy.api.v2.ListenerDiscoveryService/FetchListeners",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ListenerDiscoveryServiceServer).FetchListeners(ctx, req.(*DiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ListenerDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "envoy.api.v2.ListenerDiscoveryService",
	HandlerType: (*ListenerDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchListeners",
			Handler:    _ListenerDiscoveryService_FetchListeners_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "DeltaListeners",
			Handler:       _ListenerDiscoveryService_DeltaListeners_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamListeners",
			Handler:       _ListenerDiscoveryService_StreamListeners_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "envoy/api/v2/lds.proto",
}

func (m *Listener) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Listener) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLds(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Address != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.Address.Size()))
		n1, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.FilterChains) > 0 {
		for _, msg := range m.FilterChains {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintLds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseOriginalDst != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.UseOriginalDst.Size()))
		n2, err := m.UseOriginalDst.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.PerConnectionBufferLimitBytes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.PerConnectionBufferLimitBytes.Size()))
		n3, err := m.PerConnectionBufferLimitBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Metadata != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.Metadata.Size()))
		n4, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n5, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.DrainType != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.DrainType))
	}
	if len(m.ListenerFilters) > 0 {
		for _, msg := range m.ListenerFilters {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintLds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Transparent != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.Transparent.Size()))
		n6, err := m.Transparent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Freebind != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.Freebind.Size()))
		n7, err := m.Freebind.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.TcpFastOpenQueueLength != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.TcpFastOpenQueueLength.Size()))
		n8, err := m.TcpFastOpenQueueLength.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if len(m.SocketOptions) > 0 {
		for _, msg := range m.SocketOptions {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintLds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ListenerFiltersTimeout != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintLds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ListenerFiltersTimeout)))
		n9, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ListenerFiltersTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.TrafficDirection != 0 {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.TrafficDirection))
	}
	if m.ContinueOnListenerFiltersTimeout {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		if m.ContinueOnListenerFiltersTimeout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Listener_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Listener_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BindToPort != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLds(dAtA, i, uint64(m.BindToPort.Size()))
		n10, err := m.BindToPort.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintLds(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Listener) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovLds(uint64(l))
	}
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if len(m.FilterChains) > 0 {
		for _, e := range m.FilterChains {
			l = e.Size()
			n += 1 + l + sovLds(uint64(l))
		}
	}
	if m.UseOriginalDst != nil {
		l = m.UseOriginalDst.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.PerConnectionBufferLimitBytes != nil {
		l = m.PerConnectionBufferLimitBytes.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.DrainType != 0 {
		n += 1 + sovLds(uint64(m.DrainType))
	}
	if len(m.ListenerFilters) > 0 {
		for _, e := range m.ListenerFilters {
			l = e.Size()
			n += 1 + l + sovLds(uint64(l))
		}
	}
	if m.Transparent != nil {
		l = m.Transparent.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.Freebind != nil {
		l = m.Freebind.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.TcpFastOpenQueueLength != nil {
		l = m.TcpFastOpenQueueLength.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if len(m.SocketOptions) > 0 {
		for _, e := range m.SocketOptions {
			l = e.Size()
			n += 1 + l + sovLds(uint64(l))
		}
	}
	if m.ListenerFiltersTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ListenerFiltersTimeout)
		n += 1 + l + sovLds(uint64(l))
	}
	if m.TrafficDirection != 0 {
		n += 2 + sovLds(uint64(m.TrafficDirection))
	}
	if m.ContinueOnListenerFiltersTimeout {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Listener_DeprecatedV1) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BindToPort != nil {
		l = m.BindToPort.Size()
		n += 1 + l + sovLds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovLds(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozLds(x uint64) (n int) {
	return sovLds(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Listener) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Listener: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Listener: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &core.Address{}
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterChains", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilterChains = append(m.FilterChains, &listener.FilterChain{})
			if err := m.FilterChains[len(m.FilterChains)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseOriginalDst", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseOriginalDst == nil {
				m.UseOriginalDst = &types.BoolValue{}
			}
			if err := m.UseOriginalDst.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerConnectionBufferLimitBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerConnectionBufferLimitBytes == nil {
				m.PerConnectionBufferLimitBytes = &types.UInt32Value{}
			}
			if err := m.PerConnectionBufferLimitBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Listener_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainType", wireType)
			}
			m.DrainType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DrainType |= Listener_DrainType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerFilters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ListenerFilters = append(m.ListenerFilters, &listener.ListenerFilter{})
			if err := m.ListenerFilters[len(m.ListenerFilters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transparent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transparent == nil {
				m.Transparent = &types.BoolValue{}
			}
			if err := m.Transparent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Freebind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Freebind == nil {
				m.Freebind = &types.BoolValue{}
			}
			if err := m.Freebind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpFastOpenQueueLength", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpFastOpenQueueLength == nil {
				m.TcpFastOpenQueueLength = &types.UInt32Value{}
			}
			if err := m.TcpFastOpenQueueLength.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SocketOptions = append(m.SocketOptions, &core.SocketOption{})
			if err := m.SocketOptions[len(m.SocketOptions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerFiltersTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListenerFiltersTimeout == nil {
				m.ListenerFiltersTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ListenerFiltersTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficDirection", wireType)
			}
			m.TrafficDirection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TrafficDirection |= core.TrafficDirection(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContinueOnListenerFiltersTimeout", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContinueOnListenerFiltersTimeout = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Listener_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindToPort", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BindToPort == nil {
				m.BindToPort = &types.BoolValue{}
			}
			if err := m.BindToPort.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLds(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLds
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLds
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthLds
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowLds
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipLds(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthLds
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthLds = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLds   = fmt.Errorf("proto: integer overflow")
)
