// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/endpoint/load_report.proto

package endpoint

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// These are stats Envoy reports to GLB every so often. Report frequency is
// defined by
// :ref:`LoadStatsResponse.load_reporting_interval<envoy_api_field_load_stats.LoadStatsResponse.load_reporting_interval>`.
// Stats per upstream region/zone and optionally per subzone.
// [#not-implemented-hide:] Not configuration. TBD how to doc proto APIs.
type UpstreamLocalityStats struct {
	// Name of zone, region and optionally endpoint group these metrics were
	// collected from. Zone and region names could be empty if unknown.
	Locality *core.Locality `protobuf:"bytes,1,opt,name=locality,proto3" json:"locality,omitempty"`
	// The total number of requests successfully completed by the endpoints in the
	// locality.
	TotalSuccessfulRequests uint64 `protobuf:"varint,2,opt,name=total_successful_requests,json=totalSuccessfulRequests,proto3" json:"total_successful_requests,omitempty"`
	// The total number of unfinished requests
	TotalRequestsInProgress uint64 `protobuf:"varint,3,opt,name=total_requests_in_progress,json=totalRequestsInProgress,proto3" json:"total_requests_in_progress,omitempty"`
	// The total number of requests that failed due to errors at the endpoint,
	// aggregated over all endpoints in the locality.
	TotalErrorRequests uint64 `protobuf:"varint,4,opt,name=total_error_requests,json=totalErrorRequests,proto3" json:"total_error_requests,omitempty"`
	// The total number of requests that were issued by this Envoy since
	// the last report. This information is aggregated over all the
	// upstream endpoints in the locality.
	TotalIssuedRequests uint64 `protobuf:"varint,8,opt,name=total_issued_requests,json=totalIssuedRequests,proto3" json:"total_issued_requests,omitempty"`
	// Stats for multi-dimensional load balancing.
	LoadMetricStats []*EndpointLoadMetricStats `protobuf:"bytes,5,rep,name=load_metric_stats,json=loadMetricStats,proto3" json:"load_metric_stats,omitempty"`
	// Endpoint granularity stats information for this locality. This information
	// is populated if the Server requests it by setting
	// :ref:`LoadStatsResponse.report_endpoint_granularity<envoy_api_field_load_stats.LoadStatsResponse.report_endpoint_granularity>`.
	UpstreamEndpointStats []*UpstreamEndpointStats `protobuf:"bytes,7,rep,name=upstream_endpoint_stats,json=upstreamEndpointStats,proto3" json:"upstream_endpoint_stats,omitempty"`
	// [#not-implemented-hide:] The priority of the endpoint group these metrics
	// were collected from.
	Priority             uint32   `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpstreamLocalityStats) Reset()         { *m = UpstreamLocalityStats{} }
func (m *UpstreamLocalityStats) String() string { return proto.CompactTextString(m) }
func (*UpstreamLocalityStats) ProtoMessage()    {}
func (*UpstreamLocalityStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5134f8f33d8f8d01, []int{0}
}
func (m *UpstreamLocalityStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamLocalityStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamLocalityStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpstreamLocalityStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamLocalityStats.Merge(m, src)
}
func (m *UpstreamLocalityStats) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamLocalityStats) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamLocalityStats.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamLocalityStats proto.InternalMessageInfo

func (m *UpstreamLocalityStats) GetLocality() *core.Locality {
	if m != nil {
		return m.Locality
	}
	return nil
}

func (m *UpstreamLocalityStats) GetTotalSuccessfulRequests() uint64 {
	if m != nil {
		return m.TotalSuccessfulRequests
	}
	return 0
}

func (m *UpstreamLocalityStats) GetTotalRequestsInProgress() uint64 {
	if m != nil {
		return m.TotalRequestsInProgress
	}
	return 0
}

func (m *UpstreamLocalityStats) GetTotalErrorRequests() uint64 {
	if m != nil {
		return m.TotalErrorRequests
	}
	return 0
}

func (m *UpstreamLocalityStats) GetTotalIssuedRequests() uint64 {
	if m != nil {
		return m.TotalIssuedRequests
	}
	return 0
}

func (m *UpstreamLocalityStats) GetLoadMetricStats() []*EndpointLoadMetricStats {
	if m != nil {
		return m.LoadMetricStats
	}
	return nil
}

func (m *UpstreamLocalityStats) GetUpstreamEndpointStats() []*UpstreamEndpointStats {
	if m != nil {
		return m.UpstreamEndpointStats
	}
	return nil
}

func (m *UpstreamLocalityStats) GetPriority() uint32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

type UpstreamEndpointStats struct {
	// Upstream host address.
	Address *core.Address `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Opaque and implementation dependent metadata of the
	// endpoint. Envoy will pass this directly to the management server.
	Metadata *types.Struct `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The total number of requests successfully completed by the endpoints in the
	// locality. These include non-5xx responses for HTTP, where errors
	// originate at the client and the endpoint responded successfully. For gRPC,
	// the grpc-status values are those not covered by total_error_requests below.
	TotalSuccessfulRequests uint64 `protobuf:"varint,2,opt,name=total_successful_requests,json=totalSuccessfulRequests,proto3" json:"total_successful_requests,omitempty"`
	// The total number of unfinished requests for this endpoint.
	TotalRequestsInProgress uint64 `protobuf:"varint,3,opt,name=total_requests_in_progress,json=totalRequestsInProgress,proto3" json:"total_requests_in_progress,omitempty"`
	// The total number of requests that failed due to errors at the endpoint.
	// For HTTP these are responses with 5xx status codes and for gRPC the
	// grpc-status values:
	//
	//   - DeadlineExceeded
	//   - Unimplemented
	//   - Internal
	//   - Unavailable
	//   - Unknown
	//   - DataLoss
	TotalErrorRequests uint64 `protobuf:"varint,4,opt,name=total_error_requests,json=totalErrorRequests,proto3" json:"total_error_requests,omitempty"`
	// The total number of requests that were issued to this endpoint
	// since the last report. A single TCP connection, HTTP or gRPC
	// request or stream is counted as one request.
	TotalIssuedRequests uint64 `protobuf:"varint,7,opt,name=total_issued_requests,json=totalIssuedRequests,proto3" json:"total_issued_requests,omitempty"`
	// Stats for multi-dimensional load balancing.
	LoadMetricStats      []*EndpointLoadMetricStats `protobuf:"bytes,5,rep,name=load_metric_stats,json=loadMetricStats,proto3" json:"load_metric_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *UpstreamEndpointStats) Reset()         { *m = UpstreamEndpointStats{} }
func (m *UpstreamEndpointStats) String() string { return proto.CompactTextString(m) }
func (*UpstreamEndpointStats) ProtoMessage()    {}
func (*UpstreamEndpointStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5134f8f33d8f8d01, []int{1}
}
func (m *UpstreamEndpointStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamEndpointStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamEndpointStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpstreamEndpointStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamEndpointStats.Merge(m, src)
}
func (m *UpstreamEndpointStats) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamEndpointStats) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamEndpointStats.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamEndpointStats proto.InternalMessageInfo

func (m *UpstreamEndpointStats) GetAddress() *core.Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *UpstreamEndpointStats) GetMetadata() *types.Struct {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *UpstreamEndpointStats) GetTotalSuccessfulRequests() uint64 {
	if m != nil {
		return m.TotalSuccessfulRequests
	}
	return 0
}

func (m *UpstreamEndpointStats) GetTotalRequestsInProgress() uint64 {
	if m != nil {
		return m.TotalRequestsInProgress
	}
	return 0
}

func (m *UpstreamEndpointStats) GetTotalErrorRequests() uint64 {
	if m != nil {
		return m.TotalErrorRequests
	}
	return 0
}

func (m *UpstreamEndpointStats) GetTotalIssuedRequests() uint64 {
	if m != nil {
		return m.TotalIssuedRequests
	}
	return 0
}

func (m *UpstreamEndpointStats) GetLoadMetricStats() []*EndpointLoadMetricStats {
	if m != nil {
		return m.LoadMetricStats
	}
	return nil
}

// [#not-implemented-hide:] Not configuration. TBD how to doc proto APIs.
type EndpointLoadMetricStats struct {
	// Name of the metric; may be empty.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// Number of calls that finished and included this metric.
	NumRequestsFinishedWithMetric uint64 `protobuf:"varint,2,opt,name=num_requests_finished_with_metric,json=numRequestsFinishedWithMetric,proto3" json:"num_requests_finished_with_metric,omitempty"`
	// Sum of metric values across all calls that finished with this metric for
	// load_reporting_interval.
	TotalMetricValue     float64  `protobuf:"fixed64,3,opt,name=total_metric_value,json=totalMetricValue,proto3" json:"total_metric_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EndpointLoadMetricStats) Reset()         { *m = EndpointLoadMetricStats{} }
func (m *EndpointLoadMetricStats) String() string { return proto.CompactTextString(m) }
func (*EndpointLoadMetricStats) ProtoMessage()    {}
func (*EndpointLoadMetricStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5134f8f33d8f8d01, []int{2}
}
func (m *EndpointLoadMetricStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointLoadMetricStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointLoadMetricStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointLoadMetricStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointLoadMetricStats.Merge(m, src)
}
func (m *EndpointLoadMetricStats) XXX_Size() int {
	return m.Size()
}
func (m *EndpointLoadMetricStats) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointLoadMetricStats.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointLoadMetricStats proto.InternalMessageInfo

func (m *EndpointLoadMetricStats) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func (m *EndpointLoadMetricStats) GetNumRequestsFinishedWithMetric() uint64 {
	if m != nil {
		return m.NumRequestsFinishedWithMetric
	}
	return 0
}

func (m *EndpointLoadMetricStats) GetTotalMetricValue() float64 {
	if m != nil {
		return m.TotalMetricValue
	}
	return 0
}

// Per cluster load stats. Envoy reports these stats a management server in a
// :ref:`LoadStatsRequest<envoy_api_msg_load_stats.LoadStatsRequest>`
// [#not-implemented-hide:] Not configuration. TBD how to doc proto APIs.
// Next ID: 7
type ClusterStats struct {
	// The name of the cluster.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// The eds_cluster_config service_name of the cluster.
	// It's possible that two clusters send the same service_name to EDS,
	// in that case, the management server is supposed to do aggregation on the load reports.
	ClusterServiceName string `protobuf:"bytes,6,opt,name=cluster_service_name,json=clusterServiceName,proto3" json:"cluster_service_name,omitempty"`
	// Need at least one.
	UpstreamLocalityStats []*UpstreamLocalityStats `protobuf:"bytes,2,rep,name=upstream_locality_stats,json=upstreamLocalityStats,proto3" json:"upstream_locality_stats,omitempty"`
	// Cluster-level stats such as total_successful_requests may be computed by
	// summing upstream_locality_stats. In addition, below there are additional
	// cluster-wide stats.
	//
	// The total number of dropped requests. This covers requests
	// deliberately dropped by the drop_overload policy and circuit breaking.
	TotalDroppedRequests uint64 `protobuf:"varint,3,opt,name=total_dropped_requests,json=totalDroppedRequests,proto3" json:"total_dropped_requests,omitempty"`
	// Information about deliberately dropped requests for each category specified
	// in the DropOverload policy.
	DroppedRequests []*ClusterStats_DroppedRequests `protobuf:"bytes,5,rep,name=dropped_requests,json=droppedRequests,proto3" json:"dropped_requests,omitempty"`
	// Period over which the actual load report occurred. This will be guaranteed to include every
	// request reported. Due to system load and delays between the *LoadStatsRequest* sent from Envoy
	// and the *LoadStatsResponse* message sent from the management server, this may be longer than
	// the requested load reporting interval in the *LoadStatsResponse*.
	LoadReportInterval   *types.Duration `protobuf:"bytes,4,opt,name=load_report_interval,json=loadReportInterval,proto3" json:"load_report_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ClusterStats) Reset()         { *m = ClusterStats{} }
func (m *ClusterStats) String() string { return proto.CompactTextString(m) }
func (*ClusterStats) ProtoMessage()    {}
func (*ClusterStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5134f8f33d8f8d01, []int{3}
}
func (m *ClusterStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterStats.Merge(m, src)
}
func (m *ClusterStats) XXX_Size() int {
	return m.Size()
}
func (m *ClusterStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterStats.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterStats proto.InternalMessageInfo

func (m *ClusterStats) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ClusterStats) GetClusterServiceName() string {
	if m != nil {
		return m.ClusterServiceName
	}
	return ""
}

func (m *ClusterStats) GetUpstreamLocalityStats() []*UpstreamLocalityStats {
	if m != nil {
		return m.UpstreamLocalityStats
	}
	return nil
}

func (m *ClusterStats) GetTotalDroppedRequests() uint64 {
	if m != nil {
		return m.TotalDroppedRequests
	}
	return 0
}

func (m *ClusterStats) GetDroppedRequests() []*ClusterStats_DroppedRequests {
	if m != nil {
		return m.DroppedRequests
	}
	return nil
}

func (m *ClusterStats) GetLoadReportInterval() *types.Duration {
	if m != nil {
		return m.LoadReportInterval
	}
	return nil
}

type ClusterStats_DroppedRequests struct {
	// Identifier for the policy specifying the drop.
	Category string `protobuf:"bytes,1,opt,name=category,proto3" json:"category,omitempty"`
	// Total number of deliberately dropped requests for the category.
	DroppedCount         uint64   `protobuf:"varint,2,opt,name=dropped_count,json=droppedCount,proto3" json:"dropped_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterStats_DroppedRequests) Reset()         { *m = ClusterStats_DroppedRequests{} }
func (m *ClusterStats_DroppedRequests) String() string { return proto.CompactTextString(m) }
func (*ClusterStats_DroppedRequests) ProtoMessage()    {}
func (*ClusterStats_DroppedRequests) Descriptor() ([]byte, []int) {
	return fileDescriptor_5134f8f33d8f8d01, []int{3, 0}
}
func (m *ClusterStats_DroppedRequests) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterStats_DroppedRequests) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterStats_DroppedRequests.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterStats_DroppedRequests) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterStats_DroppedRequests.Merge(m, src)
}
func (m *ClusterStats_DroppedRequests) XXX_Size() int {
	return m.Size()
}
func (m *ClusterStats_DroppedRequests) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterStats_DroppedRequests.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterStats_DroppedRequests proto.InternalMessageInfo

func (m *ClusterStats_DroppedRequests) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *ClusterStats_DroppedRequests) GetDroppedCount() uint64 {
	if m != nil {
		return m.DroppedCount
	}
	return 0
}

func init() {
	proto.RegisterType((*UpstreamLocalityStats)(nil), "envoy.api.v2.endpoint.UpstreamLocalityStats")
	proto.RegisterType((*UpstreamEndpointStats)(nil), "envoy.api.v2.endpoint.UpstreamEndpointStats")
	proto.RegisterType((*EndpointLoadMetricStats)(nil), "envoy.api.v2.endpoint.EndpointLoadMetricStats")
	proto.RegisterType((*ClusterStats)(nil), "envoy.api.v2.endpoint.ClusterStats")
	proto.RegisterType((*ClusterStats_DroppedRequests)(nil), "envoy.api.v2.endpoint.ClusterStats.DroppedRequests")
}

func init() {
	proto.RegisterFile("envoy/api/v2/endpoint/load_report.proto", fileDescriptor_5134f8f33d8f8d01)
}

var fileDescriptor_5134f8f33d8f8d01 = []byte{
	// 786 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x55, 0xcd, 0x6e, 0xd3, 0x4a,
	0x18, 0x95, 0x93, 0xb4, 0x4d, 0x27, 0xad, 0xd2, 0x3b, 0x37, 0xb9, 0x49, 0x73, 0xef, 0x4d, 0x73,
	0x53, 0x5d, 0x91, 0x45, 0x65, 0x57, 0x69, 0x25, 0x24, 0x58, 0x91, 0xb6, 0x88, 0x8a, 0x82, 0x2a,
	0x47, 0x80, 0x84, 0x04, 0xd6, 0xd4, 0x9e, 0xa6, 0x23, 0x39, 0x1e, 0x33, 0x33, 0x0e, 0xe4, 0x21,
	0xd8, 0xf0, 0x08, 0x3c, 0x02, 0x4b, 0x24, 0x24, 0x96, 0x2c, 0x79, 0x04, 0xd4, 0x1d, 0x6f, 0x81,
	0x3c, 0x3f, 0xce, 0x6f, 0x25, 0x76, 0x48, 0xec, 0xc6, 0xdf, 0x39, 0xc7, 0xdf, 0xdf, 0x19, 0x1b,
	0xdc, 0xc2, 0xd1, 0x88, 0x8e, 0x1d, 0x14, 0x13, 0x67, 0xd4, 0x75, 0x70, 0x14, 0xc4, 0x94, 0x44,
	0xc2, 0x09, 0x29, 0x0a, 0x3c, 0x86, 0x63, 0xca, 0x84, 0x1d, 0x33, 0x2a, 0x28, 0xac, 0x4a, 0xa2,
	0x8d, 0x62, 0x62, 0x8f, 0xba, 0xb6, 0x21, 0x36, 0x76, 0x66, 0xf4, 0x3e, 0x65, 0xd8, 0x41, 0x41,
	0xc0, 0x30, 0xe7, 0x4a, 0xd7, 0xf8, 0x67, 0x91, 0x70, 0x81, 0x38, 0xd6, 0x68, 0x73, 0x40, 0xe9,
	0x20, 0xc4, 0x8e, 0x7c, 0xba, 0x48, 0x2e, 0x9d, 0x20, 0x61, 0x48, 0x10, 0x1a, 0x19, 0xf5, 0x3c,
	0xce, 0x05, 0x4b, 0x7c, 0x5d, 0x53, 0xa3, 0x36, 0x42, 0x21, 0x09, 0x90, 0xc0, 0x8e, 0x39, 0x68,
	0xa0, 0x32, 0xa0, 0x03, 0x2a, 0x8f, 0x4e, 0x7a, 0x52, 0xd1, 0xf6, 0xdb, 0x02, 0xa8, 0x3e, 0x89,
	0xb9, 0x60, 0x18, 0x0d, 0xcf, 0xa8, 0x8f, 0x42, 0x22, 0xc6, 0x7d, 0x81, 0x04, 0x87, 0xb7, 0x41,
	0x31, 0xd4, 0x81, 0xba, 0xd5, 0xb2, 0x3a, 0xa5, 0xee, 0xdf, 0xf6, 0x4c, 0xbf, 0x69, 0xdd, 0xb6,
	0xd1, 0xb8, 0x19, 0x19, 0xde, 0x01, 0xdb, 0x82, 0x0a, 0x14, 0x7a, 0x3c, 0xf1, 0x7d, 0xcc, 0xf9,
	0x65, 0x12, 0x7a, 0x0c, 0xbf, 0x4a, 0x30, 0x17, 0xbc, 0x9e, 0x6b, 0x59, 0x9d, 0x82, 0x5b, 0x93,
	0x84, 0x7e, 0x86, 0xbb, 0x1a, 0x86, 0x77, 0x41, 0x43, 0x69, 0x8d, 0xc0, 0x23, 0x91, 0x17, 0x33,
	0x3a, 0x48, 0xa7, 0x57, 0xcf, 0x4f, 0x89, 0x8d, 0xe4, 0x34, 0x3a, 0xd7, 0x30, 0xdc, 0x07, 0x15,
	0x25, 0xc6, 0x8c, 0x51, 0x36, 0xc9, 0x59, 0x90, 0x32, 0x28, 0xb1, 0x93, 0x14, 0xca, 0xd2, 0x75,
	0x41, 0x55, 0x29, 0x08, 0xe7, 0x09, 0x0e, 0x26, 0x92, 0xa2, 0x94, 0xfc, 0x29, 0xc1, 0x53, 0x89,
	0x65, 0x9a, 0xe7, 0xe0, 0x0f, 0xe9, 0x84, 0x21, 0x16, 0x8c, 0xf8, 0x1e, 0x4f, 0x87, 0x55, 0x5f,
	0x69, 0xe5, 0x3b, 0xa5, 0xae, 0x6d, 0x2f, 0x35, 0x84, 0x7d, 0xa2, 0x0f, 0x67, 0x14, 0x05, 0x8f,
	0xa4, 0x4c, 0x8e, 0xd8, 0x2d, 0x87, 0xb3, 0x01, 0x18, 0x80, 0x5a, 0xa2, 0x97, 0xe1, 0x19, 0xb5,
	0xce, 0xb0, 0x26, 0x33, 0xec, 0xdd, 0x90, 0xc1, 0xac, 0xd0, 0x64, 0x52, 0xef, 0xaf, 0x26, 0xcb,
	0xc2, 0xb0, 0x01, 0x8a, 0x31, 0x23, 0x94, 0xa5, 0x9b, 0x5d, 0x6d, 0x59, 0x9d, 0x4d, 0x37, 0x7b,
	0x6e, 0x7f, 0xca, 0x4f, 0xfc, 0x30, 0xab, 0x3a, 0x04, 0x6b, 0xda, 0xc5, 0xda, 0x0e, 0x8d, 0x25,
	0x76, 0xb8, 0xa7, 0x18, 0xae, 0xa1, 0xc2, 0x03, 0x50, 0x1c, 0x62, 0x81, 0x02, 0x24, 0x90, 0xcc,
	0x55, 0xea, 0xd6, 0x6c, 0xe5, 0x5f, 0xdb, 0xf8, 0xd7, 0xee, 0x4b, 0xff, 0xba, 0x19, 0xf1, 0xb7,
	0x70, 0xd0, 0xda, 0x2f, 0x71, 0x50, 0xfb, 0x83, 0x05, 0x6a, 0x37, 0x90, 0xe1, 0x0e, 0x28, 0xe9,
	0x94, 0x11, 0x1a, 0x62, 0xb9, 0xc5, 0x75, 0x17, 0xa8, 0xd0, 0x63, 0x34, 0xc4, 0xf0, 0x01, 0xf8,
	0x2f, 0x4a, 0x86, 0x93, 0xc9, 0x5d, 0x92, 0x88, 0xf0, 0x2b, 0x1c, 0x78, 0xaf, 0x89, 0xb8, 0xd2,
	0xe5, 0xea, 0xf9, 0xff, 0x1b, 0x25, 0x43, 0xd3, 0xd0, 0x7d, 0x4d, 0x7b, 0x46, 0xc4, 0x95, 0xca,
	0x07, 0xf7, 0x80, 0x1a, 0x96, 0xe9, 0x71, 0x84, 0xc2, 0x04, 0xcb, 0xe9, 0x5b, 0xee, 0x96, 0x44,
	0x14, 0xf1, 0x69, 0x1a, 0x6f, 0xbf, 0x2f, 0x80, 0x8d, 0xa3, 0x30, 0xe1, 0x02, 0x33, 0x55, 0xe9,
	0x1e, 0xd8, 0xf0, 0xd5, 0xf3, 0x54, 0xa9, 0xbd, 0xf5, 0x8f, 0xdf, 0x3f, 0xe7, 0x0b, 0x2c, 0xd7,
	0xb2, 0xdc, 0x92, 0x86, 0x65, 0xd9, 0xfb, 0xa0, 0x62, 0xd8, 0x1c, 0xb3, 0x11, 0xf1, 0xb1, 0x52,
	0xad, 0xca, 0x06, 0xa1, 0xc6, 0xfa, 0x0a, 0x92, 0x8a, 0x78, 0xea, 0x9e, 0x99, 0xef, 0x96, 0xde,
	0x43, 0xee, 0xa7, 0xee, 0xd9, 0xcc, 0xa7, 0xb2, 0x07, 0xd2, 0xc2, 0x56, 0xde, 0x59, 0xb9, 0xa2,
	0x35, 0xb9, 0x73, 0xb3, 0x5f, 0xd3, 0x43, 0xf0, 0x97, 0x1a, 0x48, 0xc0, 0x68, 0x1c, 0x4f, 0x1b,
	0x45, 0x59, 0x52, 0xf9, 0xee, 0x58, 0x81, 0x99, 0x53, 0x5e, 0x82, 0xad, 0x05, 0xbe, 0x32, 0xca,
	0xc1, 0x0d, 0x05, 0x4e, 0x8f, 0xd1, 0x9e, 0x7b, 0x9d, 0x5b, 0x0e, 0xe6, 0xde, 0xff, 0x10, 0x54,
	0xa6, 0xfe, 0x6a, 0x1e, 0x89, 0x04, 0x66, 0x23, 0x14, 0x4a, 0xbf, 0x97, 0xba, 0xdb, 0x0b, 0x37,
	0xf5, 0x58, 0xff, 0x89, 0x5c, 0x98, 0xca, 0x5c, 0xa9, 0x3a, 0xd5, 0xa2, 0xc6, 0x0b, 0x50, 0x9e,
	0xaf, 0xff, 0x7f, 0x50, 0xf4, 0x91, 0xc0, 0x03, 0xca, 0xc6, 0x8b, 0x3b, 0xcc, 0x20, 0xb8, 0x0b,
	0x36, 0x4d, 0x9b, 0x3e, 0x4d, 0x22, 0xa1, 0x3d, 0xb6, 0xa1, 0x83, 0x47, 0x69, 0xac, 0x77, 0xfc,
	0xe5, 0xba, 0x69, 0x7d, 0xbd, 0x6e, 0x5a, 0xdf, 0xae, 0x9b, 0x16, 0xd8, 0x25, 0x54, 0x4d, 0x20,
	0x66, 0xf4, 0xcd, 0x78, 0xf9, 0x30, 0x7a, 0xe5, 0xb3, 0xac, 0xca, 0xf3, 0xb4, 0x85, 0x73, 0xeb,
	0x62, 0x55, 0xf6, 0x72, 0xf0, 0x23, 0x00, 0x00, 0xff, 0xff, 0x24, 0x8c, 0x0b, 0xa9, 0xe4, 0x07,
	0x00, 0x00,
}

func (m *UpstreamLocalityStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamLocalityStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Locality != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.Locality.Size()))
		n1, err := m.Locality.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.TotalSuccessfulRequests != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalSuccessfulRequests))
	}
	if m.TotalRequestsInProgress != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalRequestsInProgress))
	}
	if m.TotalErrorRequests != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalErrorRequests))
	}
	if len(m.LoadMetricStats) > 0 {
		for _, msg := range m.LoadMetricStats {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintLoadReport(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Priority != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.Priority))
	}
	if len(m.UpstreamEndpointStats) > 0 {
		for _, msg := range m.UpstreamEndpointStats {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintLoadReport(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.TotalIssuedRequests != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalIssuedRequests))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamEndpointStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamEndpointStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Address != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.Address.Size()))
		n2, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.TotalSuccessfulRequests != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalSuccessfulRequests))
	}
	if m.TotalRequestsInProgress != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalRequestsInProgress))
	}
	if m.TotalErrorRequests != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalErrorRequests))
	}
	if len(m.LoadMetricStats) > 0 {
		for _, msg := range m.LoadMetricStats {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintLoadReport(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Metadata != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.Metadata.Size()))
		n3, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.TotalIssuedRequests != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalIssuedRequests))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EndpointLoadMetricStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointLoadMetricStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MetricName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(len(m.MetricName)))
		i += copy(dAtA[i:], m.MetricName)
	}
	if m.NumRequestsFinishedWithMetric != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.NumRequestsFinishedWithMetric))
	}
	if m.TotalMetricValue != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.TotalMetricValue))))
		i += 8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.UpstreamLocalityStats) > 0 {
		for _, msg := range m.UpstreamLocalityStats {
			dAtA[i] = 0x12
			i++
			i = encodeVarintLoadReport(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.TotalDroppedRequests != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.TotalDroppedRequests))
	}
	if m.LoadReportInterval != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.LoadReportInterval.Size()))
		n4, err := m.LoadReportInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.DroppedRequests) > 0 {
		for _, msg := range m.DroppedRequests {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintLoadReport(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ClusterServiceName) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(len(m.ClusterServiceName)))
		i += copy(dAtA[i:], m.ClusterServiceName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterStats_DroppedRequests) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterStats_DroppedRequests) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Category) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(len(m.Category)))
		i += copy(dAtA[i:], m.Category)
	}
	if m.DroppedCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintLoadReport(dAtA, i, uint64(m.DroppedCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintLoadReport(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *UpstreamLocalityStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Locality != nil {
		l = m.Locality.Size()
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.TotalSuccessfulRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalSuccessfulRequests))
	}
	if m.TotalRequestsInProgress != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalRequestsInProgress))
	}
	if m.TotalErrorRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalErrorRequests))
	}
	if len(m.LoadMetricStats) > 0 {
		for _, e := range m.LoadMetricStats {
			l = e.Size()
			n += 1 + l + sovLoadReport(uint64(l))
		}
	}
	if m.Priority != 0 {
		n += 1 + sovLoadReport(uint64(m.Priority))
	}
	if len(m.UpstreamEndpointStats) > 0 {
		for _, e := range m.UpstreamEndpointStats {
			l = e.Size()
			n += 1 + l + sovLoadReport(uint64(l))
		}
	}
	if m.TotalIssuedRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalIssuedRequests))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamEndpointStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.TotalSuccessfulRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalSuccessfulRequests))
	}
	if m.TotalRequestsInProgress != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalRequestsInProgress))
	}
	if m.TotalErrorRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalErrorRequests))
	}
	if len(m.LoadMetricStats) > 0 {
		for _, e := range m.LoadMetricStats {
			l = e.Size()
			n += 1 + l + sovLoadReport(uint64(l))
		}
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.TotalIssuedRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalIssuedRequests))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EndpointLoadMetricStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MetricName)
	if l > 0 {
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.NumRequestsFinishedWithMetric != 0 {
		n += 1 + sovLoadReport(uint64(m.NumRequestsFinishedWithMetric))
	}
	if m.TotalMetricValue != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if len(m.UpstreamLocalityStats) > 0 {
		for _, e := range m.UpstreamLocalityStats {
			l = e.Size()
			n += 1 + l + sovLoadReport(uint64(l))
		}
	}
	if m.TotalDroppedRequests != 0 {
		n += 1 + sovLoadReport(uint64(m.TotalDroppedRequests))
	}
	if m.LoadReportInterval != nil {
		l = m.LoadReportInterval.Size()
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if len(m.DroppedRequests) > 0 {
		for _, e := range m.DroppedRequests {
			l = e.Size()
			n += 1 + l + sovLoadReport(uint64(l))
		}
	}
	l = len(m.ClusterServiceName)
	if l > 0 {
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterStats_DroppedRequests) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Category)
	if l > 0 {
		n += 1 + l + sovLoadReport(uint64(l))
	}
	if m.DroppedCount != 0 {
		n += 1 + sovLoadReport(uint64(m.DroppedCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovLoadReport(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozLoadReport(x uint64) (n int) {
	return sovLoadReport(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *UpstreamLocalityStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamLocalityStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamLocalityStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locality == nil {
				m.Locality = &core.Locality{}
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalSuccessfulRequests", wireType)
			}
			m.TotalSuccessfulRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalSuccessfulRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRequestsInProgress", wireType)
			}
			m.TotalRequestsInProgress = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRequestsInProgress |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalErrorRequests", wireType)
			}
			m.TotalErrorRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalErrorRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadMetricStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LoadMetricStats = append(m.LoadMetricStats, &EndpointLoadMetricStats{})
			if err := m.LoadMetricStats[len(m.LoadMetricStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamEndpointStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpstreamEndpointStats = append(m.UpstreamEndpointStats, &UpstreamEndpointStats{})
			if err := m.UpstreamEndpointStats[len(m.UpstreamEndpointStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalIssuedRequests", wireType)
			}
			m.TotalIssuedRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalIssuedRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLoadReport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamEndpointStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamEndpointStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamEndpointStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &core.Address{}
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalSuccessfulRequests", wireType)
			}
			m.TotalSuccessfulRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalSuccessfulRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRequestsInProgress", wireType)
			}
			m.TotalRequestsInProgress = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRequestsInProgress |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalErrorRequests", wireType)
			}
			m.TotalErrorRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalErrorRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadMetricStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LoadMetricStats = append(m.LoadMetricStats, &EndpointLoadMetricStats{})
			if err := m.LoadMetricStats[len(m.LoadMetricStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &types.Struct{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalIssuedRequests", wireType)
			}
			m.TotalIssuedRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalIssuedRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLoadReport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointLoadMetricStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointLoadMetricStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointLoadMetricStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetricName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRequestsFinishedWithMetric", wireType)
			}
			m.NumRequestsFinishedWithMetric = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumRequestsFinishedWithMetric |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalMetricValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.TotalMetricValue = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipLoadReport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamLocalityStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpstreamLocalityStats = append(m.UpstreamLocalityStats, &UpstreamLocalityStats{})
			if err := m.UpstreamLocalityStats[len(m.UpstreamLocalityStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDroppedRequests", wireType)
			}
			m.TotalDroppedRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalDroppedRequests |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadReportInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadReportInterval == nil {
				m.LoadReportInterval = &types.Duration{}
			}
			if err := m.LoadReportInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedRequests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DroppedRequests = append(m.DroppedRequests, &ClusterStats_DroppedRequests{})
			if err := m.DroppedRequests[len(m.DroppedRequests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLoadReport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterStats_DroppedRequests) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DroppedRequests: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DroppedRequests: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLoadReport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLoadReport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Category = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedCount", wireType)
			}
			m.DroppedCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLoadReport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLoadReport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLoadReport(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLoadReport
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLoadReport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLoadReport
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthLoadReport
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowLoadReport
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipLoadReport(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthLoadReport
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthLoadReport = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLoadReport   = fmt.Errorf("proto: integer overflow")
)
