// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/health_check.proto

package core

import (
	bytes "bytes"
	fmt "fmt"
	_type "github.com/envoyproxy/go-control-plane/envoy/type"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Endpoint health status.
type HealthStatus int32

const (
	// The health status is not known. This is interpreted by Envoy as *HEALTHY*.
	HealthStatus_UNKNOWN HealthStatus = 0
	// Healthy.
	HealthStatus_HEALTHY HealthStatus = 1
	// Unhealthy.
	HealthStatus_UNHEALTHY HealthStatus = 2
	// Connection draining in progress. E.g.,
	// `<https://aws.amazon.com/blogs/aws/elb-connection-draining-remove-instances-from-service-with-care/>`_
	// or
	// `<https://cloud.google.com/compute/docs/load-balancing/enabling-connection-draining>`_.
	// This is interpreted by Envoy as *UNHEALTHY*.
	HealthStatus_DRAINING HealthStatus = 3
	// Health check timed out. This is part of HDS and is interpreted by Envoy as
	// *UNHEALTHY*.
	HealthStatus_TIMEOUT HealthStatus = 4
	// Degraded.
	HealthStatus_DEGRADED HealthStatus = 5
)

var HealthStatus_name = map[int32]string{
	0: "UNKNOWN",
	1: "HEALTHY",
	2: "UNHEALTHY",
	3: "DRAINING",
	4: "TIMEOUT",
	5: "DEGRADED",
}

var HealthStatus_value = map[string]int32{
	"UNKNOWN":   0,
	"HEALTHY":   1,
	"UNHEALTHY": 2,
	"DRAINING":  3,
	"TIMEOUT":   4,
	"DEGRADED":  5,
}

func (x HealthStatus) String() string {
	return proto.EnumName(HealthStatus_name, int32(x))
}

func (HealthStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0}
}

type HealthCheck struct {
	// The time to wait for a health check response. If the timeout is reached the
	// health check attempt will be considered a failure.
	Timeout *time.Duration `protobuf:"bytes,1,opt,name=timeout,proto3,stdduration" json:"timeout,omitempty"`
	// The interval between health checks.
	Interval *time.Duration `protobuf:"bytes,2,opt,name=interval,proto3,stdduration" json:"interval,omitempty"`
	// An optional jitter amount in milliseconds. If specified, Envoy will start health
	// checking after for a random time in ms between 0 and initial_jitter. This only
	// applies to the first health check.
	InitialJitter *types.Duration `protobuf:"bytes,20,opt,name=initial_jitter,json=initialJitter,proto3" json:"initial_jitter,omitempty"`
	// An optional jitter amount in milliseconds. If specified, during every
	// interval Envoy will add interval_jitter to the wait time.
	IntervalJitter *types.Duration `protobuf:"bytes,3,opt,name=interval_jitter,json=intervalJitter,proto3" json:"interval_jitter,omitempty"`
	// An optional jitter amount as a percentage of interval_ms. If specified,
	// during every interval Envoy will add interval_ms *
	// interval_jitter_percent / 100 to the wait time.
	//
	// If interval_jitter_ms and interval_jitter_percent are both set, both of
	// them will be used to increase the wait time.
	IntervalJitterPercent uint32 `protobuf:"varint,18,opt,name=interval_jitter_percent,json=intervalJitterPercent,proto3" json:"interval_jitter_percent,omitempty"`
	// The number of unhealthy health checks required before a host is marked
	// unhealthy. Note that for *http* health checking if a host responds with 503
	// this threshold is ignored and the host is considered unhealthy immediately.
	UnhealthyThreshold *types.UInt32Value `protobuf:"bytes,4,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3" json:"unhealthy_threshold,omitempty"`
	// The number of healthy health checks required before a host is marked
	// healthy. Note that during startup, only a single successful health check is
	// required to mark a host healthy.
	HealthyThreshold *types.UInt32Value `protobuf:"bytes,5,opt,name=healthy_threshold,json=healthyThreshold,proto3" json:"healthy_threshold,omitempty"`
	// [#not-implemented-hide:] Non-serving port for health checking.
	AltPort *types.UInt32Value `protobuf:"bytes,6,opt,name=alt_port,json=altPort,proto3" json:"alt_port,omitempty"`
	// Reuse health check connection between health checks. Default is true.
	ReuseConnection *types.BoolValue `protobuf:"bytes,7,opt,name=reuse_connection,json=reuseConnection,proto3" json:"reuse_connection,omitempty"`
	// Types that are valid to be assigned to HealthChecker:
	//	*HealthCheck_HttpHealthCheck_
	//	*HealthCheck_TcpHealthCheck_
	//	*HealthCheck_GrpcHealthCheck_
	//	*HealthCheck_CustomHealthCheck_
	HealthChecker isHealthCheck_HealthChecker `protobuf_oneof:"health_checker"`
	// The "no traffic interval" is a special health check interval that is used when a cluster has
	// never had traffic routed to it. This lower interval allows cluster information to be kept up to
	// date, without sending a potentially large amount of active health checking traffic for no
	// reason. Once a cluster has been used for traffic routing, Envoy will shift back to using the
	// standard health check interval that is defined. Note that this interval takes precedence over
	// any other.
	//
	// The default value for "no traffic interval" is 60 seconds.
	NoTrafficInterval *types.Duration `protobuf:"bytes,12,opt,name=no_traffic_interval,json=noTrafficInterval,proto3" json:"no_traffic_interval,omitempty"`
	// The "unhealthy interval" is a health check interval that is used for hosts that are marked as
	// unhealthy. As soon as the host is marked as healthy, Envoy will shift back to using the
	// standard health check interval that is defined.
	//
	// The default value for "unhealthy interval" is the same as "interval".
	UnhealthyInterval *types.Duration `protobuf:"bytes,14,opt,name=unhealthy_interval,json=unhealthyInterval,proto3" json:"unhealthy_interval,omitempty"`
	// The "unhealthy edge interval" is a special health check interval that is used for the first
	// health check right after a host is marked as unhealthy. For subsequent health checks
	// Envoy will shift back to using either "unhealthy interval" if present or the standard health
	// check interval that is defined.
	//
	// The default value for "unhealthy edge interval" is the same as "unhealthy interval".
	UnhealthyEdgeInterval *types.Duration `protobuf:"bytes,15,opt,name=unhealthy_edge_interval,json=unhealthyEdgeInterval,proto3" json:"unhealthy_edge_interval,omitempty"`
	// The "healthy edge interval" is a special health check interval that is used for the first
	// health check right after a host is marked as healthy. For subsequent health checks
	// Envoy will shift back to using the standard health check interval that is defined.
	//
	// The default value for "healthy edge interval" is the same as the default interval.
	HealthyEdgeInterval *types.Duration `protobuf:"bytes,16,opt,name=healthy_edge_interval,json=healthyEdgeInterval,proto3" json:"healthy_edge_interval,omitempty"`
	// Specifies the path to the :ref:`health check event log <arch_overview_health_check_logging>`.
	// If empty, no event log will be written.
	EventLogPath string `protobuf:"bytes,17,opt,name=event_log_path,json=eventLogPath,proto3" json:"event_log_path,omitempty"`
	// If set to true, health check failure events will always be logged. If set to false, only the
	// initial health check failure event will be logged.
	// The default value is false.
	AlwaysLogHealthCheckFailures bool     `protobuf:"varint,19,opt,name=always_log_health_check_failures,json=alwaysLogHealthCheckFailures,proto3" json:"always_log_health_check_failures,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	XXX_unrecognized             []byte   `json:"-"`
	XXX_sizecache                int32    `json:"-"`
}

func (m *HealthCheck) Reset()         { *m = HealthCheck{} }
func (m *HealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck) ProtoMessage()    {}
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0}
}
func (m *HealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck.Merge(m, src)
}
func (m *HealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck proto.InternalMessageInfo

type isHealthCheck_HealthChecker interface {
	isHealthCheck_HealthChecker()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HealthCheck_HttpHealthCheck_ struct {
	HttpHealthCheck *HealthCheck_HttpHealthCheck `protobuf:"bytes,8,opt,name=http_health_check,json=httpHealthCheck,proto3,oneof"`
}
type HealthCheck_TcpHealthCheck_ struct {
	TcpHealthCheck *HealthCheck_TcpHealthCheck `protobuf:"bytes,9,opt,name=tcp_health_check,json=tcpHealthCheck,proto3,oneof"`
}
type HealthCheck_GrpcHealthCheck_ struct {
	GrpcHealthCheck *HealthCheck_GrpcHealthCheck `protobuf:"bytes,11,opt,name=grpc_health_check,json=grpcHealthCheck,proto3,oneof"`
}
type HealthCheck_CustomHealthCheck_ struct {
	CustomHealthCheck *HealthCheck_CustomHealthCheck `protobuf:"bytes,13,opt,name=custom_health_check,json=customHealthCheck,proto3,oneof"`
}

func (*HealthCheck_HttpHealthCheck_) isHealthCheck_HealthChecker()   {}
func (*HealthCheck_TcpHealthCheck_) isHealthCheck_HealthChecker()    {}
func (*HealthCheck_GrpcHealthCheck_) isHealthCheck_HealthChecker()   {}
func (*HealthCheck_CustomHealthCheck_) isHealthCheck_HealthChecker() {}

func (m *HealthCheck) GetHealthChecker() isHealthCheck_HealthChecker {
	if m != nil {
		return m.HealthChecker
	}
	return nil
}

func (m *HealthCheck) GetTimeout() *time.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *HealthCheck) GetInterval() *time.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *HealthCheck) GetInitialJitter() *types.Duration {
	if m != nil {
		return m.InitialJitter
	}
	return nil
}

func (m *HealthCheck) GetIntervalJitter() *types.Duration {
	if m != nil {
		return m.IntervalJitter
	}
	return nil
}

func (m *HealthCheck) GetIntervalJitterPercent() uint32 {
	if m != nil {
		return m.IntervalJitterPercent
	}
	return 0
}

func (m *HealthCheck) GetUnhealthyThreshold() *types.UInt32Value {
	if m != nil {
		return m.UnhealthyThreshold
	}
	return nil
}

func (m *HealthCheck) GetHealthyThreshold() *types.UInt32Value {
	if m != nil {
		return m.HealthyThreshold
	}
	return nil
}

func (m *HealthCheck) GetAltPort() *types.UInt32Value {
	if m != nil {
		return m.AltPort
	}
	return nil
}

func (m *HealthCheck) GetReuseConnection() *types.BoolValue {
	if m != nil {
		return m.ReuseConnection
	}
	return nil
}

func (m *HealthCheck) GetHttpHealthCheck() *HealthCheck_HttpHealthCheck {
	if x, ok := m.GetHealthChecker().(*HealthCheck_HttpHealthCheck_); ok {
		return x.HttpHealthCheck
	}
	return nil
}

func (m *HealthCheck) GetTcpHealthCheck() *HealthCheck_TcpHealthCheck {
	if x, ok := m.GetHealthChecker().(*HealthCheck_TcpHealthCheck_); ok {
		return x.TcpHealthCheck
	}
	return nil
}

func (m *HealthCheck) GetGrpcHealthCheck() *HealthCheck_GrpcHealthCheck {
	if x, ok := m.GetHealthChecker().(*HealthCheck_GrpcHealthCheck_); ok {
		return x.GrpcHealthCheck
	}
	return nil
}

func (m *HealthCheck) GetCustomHealthCheck() *HealthCheck_CustomHealthCheck {
	if x, ok := m.GetHealthChecker().(*HealthCheck_CustomHealthCheck_); ok {
		return x.CustomHealthCheck
	}
	return nil
}

func (m *HealthCheck) GetNoTrafficInterval() *types.Duration {
	if m != nil {
		return m.NoTrafficInterval
	}
	return nil
}

func (m *HealthCheck) GetUnhealthyInterval() *types.Duration {
	if m != nil {
		return m.UnhealthyInterval
	}
	return nil
}

func (m *HealthCheck) GetUnhealthyEdgeInterval() *types.Duration {
	if m != nil {
		return m.UnhealthyEdgeInterval
	}
	return nil
}

func (m *HealthCheck) GetHealthyEdgeInterval() *types.Duration {
	if m != nil {
		return m.HealthyEdgeInterval
	}
	return nil
}

func (m *HealthCheck) GetEventLogPath() string {
	if m != nil {
		return m.EventLogPath
	}
	return ""
}

func (m *HealthCheck) GetAlwaysLogHealthCheckFailures() bool {
	if m != nil {
		return m.AlwaysLogHealthCheckFailures
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HealthCheck) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HealthCheck_OneofMarshaler, _HealthCheck_OneofUnmarshaler, _HealthCheck_OneofSizer, []interface{}{
		(*HealthCheck_HttpHealthCheck_)(nil),
		(*HealthCheck_TcpHealthCheck_)(nil),
		(*HealthCheck_GrpcHealthCheck_)(nil),
		(*HealthCheck_CustomHealthCheck_)(nil),
	}
}

func _HealthCheck_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HealthCheck)
	// health_checker
	switch x := m.HealthChecker.(type) {
	case *HealthCheck_HttpHealthCheck_:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpHealthCheck); err != nil {
			return err
		}
	case *HealthCheck_TcpHealthCheck_:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TcpHealthCheck); err != nil {
			return err
		}
	case *HealthCheck_GrpcHealthCheck_:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GrpcHealthCheck); err != nil {
			return err
		}
	case *HealthCheck_CustomHealthCheck_:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CustomHealthCheck); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HealthCheck.HealthChecker has unexpected type %T", x)
	}
	return nil
}

func _HealthCheck_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HealthCheck)
	switch tag {
	case 8: // health_checker.http_health_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HealthCheck_HttpHealthCheck)
		err := b.DecodeMessage(msg)
		m.HealthChecker = &HealthCheck_HttpHealthCheck_{msg}
		return true, err
	case 9: // health_checker.tcp_health_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HealthCheck_TcpHealthCheck)
		err := b.DecodeMessage(msg)
		m.HealthChecker = &HealthCheck_TcpHealthCheck_{msg}
		return true, err
	case 11: // health_checker.grpc_health_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HealthCheck_GrpcHealthCheck)
		err := b.DecodeMessage(msg)
		m.HealthChecker = &HealthCheck_GrpcHealthCheck_{msg}
		return true, err
	case 13: // health_checker.custom_health_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HealthCheck_CustomHealthCheck)
		err := b.DecodeMessage(msg)
		m.HealthChecker = &HealthCheck_CustomHealthCheck_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HealthCheck_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HealthCheck)
	// health_checker
	switch x := m.HealthChecker.(type) {
	case *HealthCheck_HttpHealthCheck_:
		s := proto.Size(x.HttpHealthCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HealthCheck_TcpHealthCheck_:
		s := proto.Size(x.TcpHealthCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HealthCheck_GrpcHealthCheck_:
		s := proto.Size(x.GrpcHealthCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HealthCheck_CustomHealthCheck_:
		s := proto.Size(x.CustomHealthCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes the encoding of the payload bytes in the payload.
type HealthCheck_Payload struct {
	// Types that are valid to be assigned to Payload:
	//	*HealthCheck_Payload_Text
	//	*HealthCheck_Payload_Binary
	Payload              isHealthCheck_Payload_Payload `protobuf_oneof:"payload"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *HealthCheck_Payload) Reset()         { *m = HealthCheck_Payload{} }
func (m *HealthCheck_Payload) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_Payload) ProtoMessage()    {}
func (*HealthCheck_Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 0}
}
func (m *HealthCheck_Payload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_Payload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_Payload.Merge(m, src)
}
func (m *HealthCheck_Payload) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_Payload proto.InternalMessageInfo

type isHealthCheck_Payload_Payload interface {
	isHealthCheck_Payload_Payload()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HealthCheck_Payload_Text struct {
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}
type HealthCheck_Payload_Binary struct {
	Binary []byte `protobuf:"bytes,2,opt,name=binary,proto3,oneof"`
}

func (*HealthCheck_Payload_Text) isHealthCheck_Payload_Payload()   {}
func (*HealthCheck_Payload_Binary) isHealthCheck_Payload_Payload() {}

func (m *HealthCheck_Payload) GetPayload() isHealthCheck_Payload_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *HealthCheck_Payload) GetText() string {
	if x, ok := m.GetPayload().(*HealthCheck_Payload_Text); ok {
		return x.Text
	}
	return ""
}

func (m *HealthCheck_Payload) GetBinary() []byte {
	if x, ok := m.GetPayload().(*HealthCheck_Payload_Binary); ok {
		return x.Binary
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HealthCheck_Payload) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HealthCheck_Payload_OneofMarshaler, _HealthCheck_Payload_OneofUnmarshaler, _HealthCheck_Payload_OneofSizer, []interface{}{
		(*HealthCheck_Payload_Text)(nil),
		(*HealthCheck_Payload_Binary)(nil),
	}
}

func _HealthCheck_Payload_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HealthCheck_Payload)
	// payload
	switch x := m.Payload.(type) {
	case *HealthCheck_Payload_Text:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Text)
	case *HealthCheck_Payload_Binary:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.Binary)
	case nil:
	default:
		return fmt.Errorf("HealthCheck_Payload.Payload has unexpected type %T", x)
	}
	return nil
}

func _HealthCheck_Payload_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HealthCheck_Payload)
	switch tag {
	case 1: // payload.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Payload = &HealthCheck_Payload_Text{x}
		return true, err
	case 2: // payload.binary
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Payload = &HealthCheck_Payload_Binary{x}
		return true, err
	default:
		return false, nil
	}
}

func _HealthCheck_Payload_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HealthCheck_Payload)
	// payload
	switch x := m.Payload.(type) {
	case *HealthCheck_Payload_Text:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Text)))
		n += len(x.Text)
	case *HealthCheck_Payload_Binary:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Binary)))
		n += len(x.Binary)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// [#comment:next free field: 10]
type HealthCheck_HttpHealthCheck struct {
	// The value of the host header in the HTTP health check request. If
	// left empty (default value), the name of the cluster this health check is associated
	// with will be used.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Specifies the HTTP path that will be requested during health checking. For example
	// */healthcheck*.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// [#not-implemented-hide:] HTTP specific payload.
	Send *HealthCheck_Payload `protobuf:"bytes,3,opt,name=send,proto3" json:"send,omitempty"`
	// [#not-implemented-hide:] HTTP specific response.
	Receive *HealthCheck_Payload `protobuf:"bytes,4,opt,name=receive,proto3" json:"receive,omitempty"`
	// An optional service name parameter which is used to validate the identity of
	// the health checked cluster. See the :ref:`architecture overview
	// <arch_overview_health_checking_identity>` for more information.
	ServiceName string `protobuf:"bytes,5,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Specifies a list of HTTP headers that should be added to each request that is sent to the
	// health checked cluster. For more information, including details on header value syntax, see
	// the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*HeaderValueOption `protobuf:"bytes,6,rep,name=request_headers_to_add,json=requestHeadersToAdd,proto3" json:"request_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each request that is sent to the
	// health checked cluster.
	RequestHeadersToRemove []string `protobuf:"bytes,8,rep,name=request_headers_to_remove,json=requestHeadersToRemove,proto3" json:"request_headers_to_remove,omitempty"`
	// If set, health checks will be made using http/2.
	UseHttp2 bool `protobuf:"varint,7,opt,name=use_http2,json=useHttp2,proto3" json:"use_http2,omitempty"`
	// Specifies a list of HTTP response statuses considered healthy. If provided, replaces default
	// 200-only policy - 200 must be included explicitly as needed. Ranges follow half-open
	// semantics of :ref:`Int64Range <envoy_api_msg_type.Int64Range>`.
	ExpectedStatuses     []*_type.Int64Range `protobuf:"bytes,9,rep,name=expected_statuses,json=expectedStatuses,proto3" json:"expected_statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *HealthCheck_HttpHealthCheck) Reset()         { *m = HealthCheck_HttpHealthCheck{} }
func (m *HealthCheck_HttpHealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_HttpHealthCheck) ProtoMessage()    {}
func (*HealthCheck_HttpHealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 1}
}
func (m *HealthCheck_HttpHealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_HttpHealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_HttpHealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_HttpHealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_HttpHealthCheck.Merge(m, src)
}
func (m *HealthCheck_HttpHealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_HttpHealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_HttpHealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_HttpHealthCheck proto.InternalMessageInfo

func (m *HealthCheck_HttpHealthCheck) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HealthCheck_HttpHealthCheck) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HealthCheck_HttpHealthCheck) GetSend() *HealthCheck_Payload {
	if m != nil {
		return m.Send
	}
	return nil
}

func (m *HealthCheck_HttpHealthCheck) GetReceive() *HealthCheck_Payload {
	if m != nil {
		return m.Receive
	}
	return nil
}

func (m *HealthCheck_HttpHealthCheck) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *HealthCheck_HttpHealthCheck) GetRequestHeadersToAdd() []*HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *HealthCheck_HttpHealthCheck) GetRequestHeadersToRemove() []string {
	if m != nil {
		return m.RequestHeadersToRemove
	}
	return nil
}

func (m *HealthCheck_HttpHealthCheck) GetUseHttp2() bool {
	if m != nil {
		return m.UseHttp2
	}
	return false
}

func (m *HealthCheck_HttpHealthCheck) GetExpectedStatuses() []*_type.Int64Range {
	if m != nil {
		return m.ExpectedStatuses
	}
	return nil
}

type HealthCheck_TcpHealthCheck struct {
	// Empty payloads imply a connect-only health check.
	Send *HealthCheck_Payload `protobuf:"bytes,1,opt,name=send,proto3" json:"send,omitempty"`
	// When checking the response, “fuzzy” matching is performed such that each
	// binary block must be found, and in the order specified, but not
	// necessarily contiguous.
	Receive              []*HealthCheck_Payload `protobuf:"bytes,2,rep,name=receive,proto3" json:"receive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *HealthCheck_TcpHealthCheck) Reset()         { *m = HealthCheck_TcpHealthCheck{} }
func (m *HealthCheck_TcpHealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_TcpHealthCheck) ProtoMessage()    {}
func (*HealthCheck_TcpHealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 2}
}
func (m *HealthCheck_TcpHealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_TcpHealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_TcpHealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_TcpHealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_TcpHealthCheck.Merge(m, src)
}
func (m *HealthCheck_TcpHealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_TcpHealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_TcpHealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_TcpHealthCheck proto.InternalMessageInfo

func (m *HealthCheck_TcpHealthCheck) GetSend() *HealthCheck_Payload {
	if m != nil {
		return m.Send
	}
	return nil
}

func (m *HealthCheck_TcpHealthCheck) GetReceive() []*HealthCheck_Payload {
	if m != nil {
		return m.Receive
	}
	return nil
}

type HealthCheck_RedisHealthCheck struct {
	// If set, optionally perform ``EXISTS <key>`` instead of ``PING``. A return value
	// from Redis of 0 (does not exist) is considered a passing healthcheck. A return value other
	// than 0 is considered a failure. This allows the user to mark a Redis instance for maintenance
	// by setting the specified key to any value and waiting for traffic to drain.
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheck_RedisHealthCheck) Reset()         { *m = HealthCheck_RedisHealthCheck{} }
func (m *HealthCheck_RedisHealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_RedisHealthCheck) ProtoMessage()    {}
func (*HealthCheck_RedisHealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 3}
}
func (m *HealthCheck_RedisHealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_RedisHealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_RedisHealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_RedisHealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_RedisHealthCheck.Merge(m, src)
}
func (m *HealthCheck_RedisHealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_RedisHealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_RedisHealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_RedisHealthCheck proto.InternalMessageInfo

func (m *HealthCheck_RedisHealthCheck) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

// `grpc.health.v1.Health
// <https://github.com/grpc/grpc/blob/master/src/proto/grpc/health/v1/health.proto>`_-based
// healthcheck. See `gRPC doc <https://github.com/grpc/grpc/blob/master/doc/health-checking.md>`_
// for details.
type HealthCheck_GrpcHealthCheck struct {
	// An optional service name parameter which will be sent to gRPC service in
	// `grpc.health.v1.HealthCheckRequest
	// <https://github.com/grpc/grpc/blob/master/src/proto/grpc/health/v1/health.proto#L20>`_.
	// message. See `gRPC health-checking overview
	// <https://github.com/grpc/grpc/blob/master/doc/health-checking.md>`_ for more information.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The value of the :authority header in the gRPC health check request. If
	// left empty (default value), the name of the cluster this health check is associated
	// with will be used.
	Authority            string   `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheck_GrpcHealthCheck) Reset()         { *m = HealthCheck_GrpcHealthCheck{} }
func (m *HealthCheck_GrpcHealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_GrpcHealthCheck) ProtoMessage()    {}
func (*HealthCheck_GrpcHealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 4}
}
func (m *HealthCheck_GrpcHealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_GrpcHealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_GrpcHealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_GrpcHealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_GrpcHealthCheck.Merge(m, src)
}
func (m *HealthCheck_GrpcHealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_GrpcHealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_GrpcHealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_GrpcHealthCheck proto.InternalMessageInfo

func (m *HealthCheck_GrpcHealthCheck) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *HealthCheck_GrpcHealthCheck) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

// Custom health check.
type HealthCheck_CustomHealthCheck struct {
	// The registered name of the custom health checker.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A custom health checker specific configuration which depends on the custom health checker
	// being instantiated. See :api:`envoy/config/health_checker` for reference.
	//
	// Types that are valid to be assigned to ConfigType:
	//	*HealthCheck_CustomHealthCheck_Config
	//	*HealthCheck_CustomHealthCheck_TypedConfig
	ConfigType           isHealthCheck_CustomHealthCheck_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *HealthCheck_CustomHealthCheck) Reset()         { *m = HealthCheck_CustomHealthCheck{} }
func (m *HealthCheck_CustomHealthCheck) String() string { return proto.CompactTextString(m) }
func (*HealthCheck_CustomHealthCheck) ProtoMessage()    {}
func (*HealthCheck_CustomHealthCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b6ca44dd529b90bd, []int{0, 5}
}
func (m *HealthCheck_CustomHealthCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HealthCheck_CustomHealthCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HealthCheck_CustomHealthCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HealthCheck_CustomHealthCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheck_CustomHealthCheck.Merge(m, src)
}
func (m *HealthCheck_CustomHealthCheck) XXX_Size() int {
	return m.Size()
}
func (m *HealthCheck_CustomHealthCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheck_CustomHealthCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheck_CustomHealthCheck proto.InternalMessageInfo

type isHealthCheck_CustomHealthCheck_ConfigType interface {
	isHealthCheck_CustomHealthCheck_ConfigType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HealthCheck_CustomHealthCheck_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type HealthCheck_CustomHealthCheck_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*HealthCheck_CustomHealthCheck_Config) isHealthCheck_CustomHealthCheck_ConfigType()      {}
func (*HealthCheck_CustomHealthCheck_TypedConfig) isHealthCheck_CustomHealthCheck_ConfigType() {}

func (m *HealthCheck_CustomHealthCheck) GetConfigType() isHealthCheck_CustomHealthCheck_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *HealthCheck_CustomHealthCheck) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HealthCheck_CustomHealthCheck) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*HealthCheck_CustomHealthCheck_Config); ok {
		return x.Config
	}
	return nil
}

func (m *HealthCheck_CustomHealthCheck) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*HealthCheck_CustomHealthCheck_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HealthCheck_CustomHealthCheck) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HealthCheck_CustomHealthCheck_OneofMarshaler, _HealthCheck_CustomHealthCheck_OneofUnmarshaler, _HealthCheck_CustomHealthCheck_OneofSizer, []interface{}{
		(*HealthCheck_CustomHealthCheck_Config)(nil),
		(*HealthCheck_CustomHealthCheck_TypedConfig)(nil),
	}
}

func _HealthCheck_CustomHealthCheck_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HealthCheck_CustomHealthCheck)
	// config_type
	switch x := m.ConfigType.(type) {
	case *HealthCheck_CustomHealthCheck_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *HealthCheck_CustomHealthCheck_TypedConfig:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HealthCheck_CustomHealthCheck.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _HealthCheck_CustomHealthCheck_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HealthCheck_CustomHealthCheck)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &HealthCheck_CustomHealthCheck_Config{msg}
		return true, err
	case 3: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &HealthCheck_CustomHealthCheck_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HealthCheck_CustomHealthCheck_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HealthCheck_CustomHealthCheck)
	// config_type
	switch x := m.ConfigType.(type) {
	case *HealthCheck_CustomHealthCheck_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HealthCheck_CustomHealthCheck_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("envoy.api.v2.core.HealthStatus", HealthStatus_name, HealthStatus_value)
	proto.RegisterType((*HealthCheck)(nil), "envoy.api.v2.core.HealthCheck")
	proto.RegisterType((*HealthCheck_Payload)(nil), "envoy.api.v2.core.HealthCheck.Payload")
	proto.RegisterType((*HealthCheck_HttpHealthCheck)(nil), "envoy.api.v2.core.HealthCheck.HttpHealthCheck")
	proto.RegisterType((*HealthCheck_TcpHealthCheck)(nil), "envoy.api.v2.core.HealthCheck.TcpHealthCheck")
	proto.RegisterType((*HealthCheck_RedisHealthCheck)(nil), "envoy.api.v2.core.HealthCheck.RedisHealthCheck")
	proto.RegisterType((*HealthCheck_GrpcHealthCheck)(nil), "envoy.api.v2.core.HealthCheck.GrpcHealthCheck")
	proto.RegisterType((*HealthCheck_CustomHealthCheck)(nil), "envoy.api.v2.core.HealthCheck.CustomHealthCheck")
}

func init() {
	proto.RegisterFile("envoy/api/v2/core/health_check.proto", fileDescriptor_b6ca44dd529b90bd)
}

var fileDescriptor_b6ca44dd529b90bd = []byte{
	// 1224 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x96, 0xcb, 0x6e, 0xdb, 0x46,
	0x17, 0xc7, 0x45, 0x4b, 0xb6, 0xa4, 0x23, 0x59, 0xa6, 0x46, 0x89, 0xcd, 0xe8, 0xf3, 0xe7, 0xa8,
	0x85, 0x51, 0x18, 0x01, 0x2a, 0xb5, 0x4a, 0x91, 0x22, 0x5d, 0xc5, 0xb2, 0x15, 0x4b, 0x69, 0xa2,
	0x18, 0x13, 0x39, 0x45, 0x80, 0x16, 0xec, 0x98, 0x1c, 0x53, 0x6c, 0x68, 0x0e, 0x3b, 0x1c, 0x2a,
	0xd1, 0x4b, 0x74, 0xd1, 0x55, 0x1f, 0xa1, 0xc8, 0xa6, 0xdb, 0xa2, 0xab, 0x2c, 0xbb, 0xec, 0x1b,
	0xb4, 0xf0, 0xaa, 0xe9, 0x23, 0x74, 0x55, 0xcc, 0x90, 0x92, 0x75, 0x71, 0x61, 0x1b, 0xdd, 0x71,
	0xce, 0x39, 0xff, 0xdf, 0x5c, 0xce, 0x05, 0x84, 0x6d, 0xea, 0x0f, 0xd9, 0xa8, 0x41, 0x02, 0xb7,
	0x31, 0x6c, 0x36, 0x2c, 0xc6, 0x69, 0x63, 0x40, 0x89, 0x27, 0x06, 0xa6, 0x35, 0xa0, 0xd6, 0xcb,
	0x7a, 0xc0, 0x99, 0x60, 0xa8, 0xac, 0xa2, 0xea, 0x24, 0x70, 0xeb, 0xc3, 0x66, 0x5d, 0x46, 0x55,
	0x37, 0x17, 0x85, 0xc7, 0x24, 0xa4, 0xb1, 0xa0, 0xba, 0x1e, 0x7b, 0xc5, 0x28, 0xa0, 0x0d, 0x4e,
	0x7c, 0x67, 0x6c, 0xbf, 0xe5, 0x30, 0xe6, 0x78, 0xb4, 0xa1, 0x56, 0xc7, 0xd1, 0x49, 0x83, 0xf8,
	0xa3, 0xc4, 0xb5, 0x35, 0xef, 0xb2, 0x23, 0x4e, 0x84, 0xcb, 0xfc, 0xc4, 0xbf, 0x39, 0xef, 0x0f,
	0x05, 0x8f, 0x2c, 0xf1, 0x6f, 0xea, 0x57, 0x9c, 0x04, 0x01, 0xe5, 0x61, 0xe2, 0xdf, 0x18, 0x12,
	0xcf, 0xb5, 0x89, 0xa0, 0x8d, 0xf1, 0x47, 0xe2, 0xb8, 0xe1, 0x30, 0x87, 0xa9, 0xcf, 0x86, 0xfc,
	0x8a, 0xad, 0xef, 0xff, 0x5d, 0x81, 0x42, 0x47, 0xbd, 0xc3, 0x9e, 0x7c, 0x06, 0xd4, 0x86, 0xac,
	0x70, 0x4f, 0x29, 0x8b, 0x84, 0xa1, 0xd5, 0xb4, 0x9d, 0x42, 0xf3, 0x56, 0x3d, 0xde, 0xb0, 0x3e,
	0xde, 0xb0, 0xbe, 0x9f, 0x1c, 0xb7, 0xa5, 0xff, 0xf0, 0xfb, 0x6d, 0xed, 0x97, 0x77, 0x6f, 0xd3,
	0xd9, 0x37, 0x5a, 0x26, 0xa7, 0xdd, 0x49, 0xe1, 0xb1, 0x16, 0x1d, 0x40, 0xce, 0xf5, 0x05, 0xe5,
	0x43, 0xe2, 0x19, 0x4b, 0xd7, 0xe7, 0x4c, 0xc4, 0xe8, 0x01, 0x94, 0x5c, 0xdf, 0x15, 0x2e, 0xf1,
	0xcc, 0x6f, 0x5c, 0x21, 0x28, 0x37, 0x6e, 0x5c, 0x82, 0xc3, 0xab, 0x89, 0xe0, 0x91, 0x8a, 0x47,
	0x2d, 0x58, 0x1b, 0xd3, 0xc6, 0x88, 0xf4, 0x65, 0x88, 0xd2, 0x58, 0x91, 0x30, 0xee, 0xc1, 0xc6,
	0x1c, 0xc3, 0x0c, 0x28, 0xb7, 0xa8, 0x2f, 0x0c, 0x54, 0xd3, 0x76, 0x56, 0xf1, 0xcd, 0x59, 0xc1,
	0x61, 0xec, 0x44, 0x4f, 0xa0, 0x12, 0xf9, 0x71, 0x99, 0x8d, 0x4c, 0x31, 0xe0, 0x34, 0x1c, 0x30,
	0xcf, 0x36, 0x32, 0x6a, 0xff, 0xcd, 0x85, 0xfd, 0x8f, 0xba, 0xbe, 0xb8, 0xdb, 0x7c, 0x4e, 0xbc,
	0x88, 0x62, 0x34, 0x11, 0xf6, 0xc7, 0x3a, 0xd4, 0x85, 0xf2, 0x22, 0x6c, 0xf9, 0x0a, 0x30, 0x7d,
	0x01, 0xf5, 0x29, 0xe4, 0x88, 0x27, 0xcc, 0x80, 0x71, 0x61, 0xac, 0x5c, 0x81, 0x90, 0x25, 0x9e,
	0x38, 0x64, 0x5c, 0xa0, 0x36, 0xe8, 0x9c, 0x46, 0x21, 0x35, 0x2d, 0xe6, 0xfb, 0xd4, 0x92, 0xcf,
	0x65, 0x64, 0x15, 0xa0, 0xba, 0x00, 0x68, 0x31, 0xe6, 0xc5, 0xf2, 0x35, 0xa5, 0xd9, 0x9b, 0x48,
	0xd0, 0x97, 0x50, 0x1e, 0x08, 0x11, 0x98, 0xd3, 0x3d, 0x68, 0xe4, 0x14, 0xa7, 0x5e, 0x5f, 0x68,
	0xc2, 0xfa, 0x54, 0x89, 0xd6, 0x3b, 0x42, 0x04, 0x53, 0xeb, 0x4e, 0x0a, 0xaf, 0x0d, 0x66, 0x4d,
	0xe8, 0x05, 0xe8, 0xc2, 0x9a, 0x83, 0xe7, 0x15, 0xfc, 0xc3, 0x4b, 0xe0, 0x7d, 0x6b, 0x8e, 0x5d,
	0x12, 0x33, 0x16, 0x79, 0x70, 0x87, 0x07, 0xd6, 0x2c, 0xbb, 0x70, 0xa5, 0x83, 0x1f, 0xf0, 0xc0,
	0x9a, 0x3b, 0xb8, 0x33, 0x6b, 0x42, 0xc7, 0x50, 0xb1, 0xa2, 0x50, 0xb0, 0xd3, 0x59, 0xfe, 0xaa,
	0xe2, 0x7f, 0x74, 0x09, 0x7f, 0x4f, 0x29, 0x67, 0x77, 0x28, 0x5b, 0xf3, 0x46, 0x74, 0x04, 0x15,
	0x9f, 0x99, 0x82, 0x93, 0x93, 0x13, 0xd7, 0x32, 0x27, 0x6d, 0x5a, 0xbc, 0xac, 0x4d, 0x41, 0xb6,
	0xe8, 0xf2, 0x1b, 0x6d, 0xe9, 0x4e, 0x0a, 0x97, 0x7d, 0xd6, 0x8f, 0x01, 0xdd, 0x71, 0xa7, 0xf6,
	0xe1, 0xbc, 0x64, 0xcf, 0xa9, 0xa5, 0x6b, 0x51, 0x27, 0x80, 0x09, 0xf5, 0x2b, 0xd8, 0x38, 0xa7,
	0x52, 0xdb, 0xa1, 0xe7, 0xe8, 0xb5, 0xeb, 0xa0, 0x6f, 0x4e, 0x28, 0x6d, 0xdb, 0xa1, 0x13, 0xfc,
	0x0b, 0xb8, 0x79, 0x31, 0x5c, 0xbf, 0x0e, 0xbc, 0x72, 0x11, 0x7a, 0x1b, 0x4a, 0x74, 0x48, 0x7d,
	0x61, 0x7a, 0xcc, 0x31, 0x03, 0x22, 0x06, 0x46, 0xb9, 0xa6, 0xed, 0xe4, 0x71, 0x51, 0x59, 0x1f,
	0x33, 0xe7, 0x90, 0x88, 0x01, 0x7a, 0x08, 0x35, 0xe2, 0xbd, 0x22, 0xa3, 0x50, 0x85, 0x4d, 0x27,
	0xdd, 0x3c, 0x21, 0xae, 0x17, 0x71, 0x1a, 0x1a, 0x95, 0x9a, 0xb6, 0x93, 0xc3, 0x9b, 0x71, 0xdc,
	0x63, 0xe6, 0x4c, 0x25, 0xf3, 0x61, 0x12, 0x53, 0x7d, 0x0e, 0xd9, 0x43, 0x32, 0xf2, 0x18, 0xb1,
	0xd1, 0x6d, 0xc8, 0x08, 0xfa, 0x3a, 0x9e, 0xdf, 0xf9, 0x56, 0x5e, 0x9e, 0x33, 0xc3, 0x97, 0x6a,
	0x5a, 0x27, 0x85, 0x95, 0x03, 0x19, 0xb0, 0x72, 0xec, 0xfa, 0x84, 0x8f, 0xd4, 0x68, 0x2e, 0x76,
	0x52, 0x38, 0x59, 0xb7, 0x74, 0xc8, 0x06, 0x09, 0x65, 0xf9, 0xe7, 0x77, 0x6f, 0xd3, 0x5a, 0xf5,
	0xaf, 0x34, 0xac, 0xcd, 0x35, 0x1c, 0x42, 0x90, 0x19, 0xb0, 0x30, 0xd9, 0x00, 0xab, 0x6f, 0xf4,
	0x7f, 0xc8, 0xa8, 0x3b, 0x2e, 0xcd, 0x6d, 0x8a, 0x95, 0x19, 0x7d, 0x06, 0x99, 0x90, 0xfa, 0x76,
	0x32, 0x79, 0x3f, 0xb8, 0xa4, 0x90, 0x93, 0x9b, 0x60, 0xa5, 0x41, 0x0f, 0x20, 0xcb, 0xa9, 0x45,
	0xdd, 0x21, 0x4d, 0x06, 0xe7, 0x55, 0xe5, 0x63, 0x19, 0x7a, 0x0f, 0x8a, 0x21, 0xe5, 0x43, 0xd7,
	0xa2, 0xa6, 0x4f, 0x4e, 0xa9, 0x1a, 0x99, 0x79, 0x5c, 0x48, 0x6c, 0x3d, 0x72, 0x4a, 0xd1, 0x09,
	0xac, 0x73, 0xfa, 0x6d, 0x44, 0x43, 0x21, 0x93, 0x60, 0x53, 0x1e, 0x9a, 0x82, 0x99, 0xc4, 0xb6,
	0x8d, 0x95, 0x5a, 0x7a, 0xa7, 0xd0, 0xdc, 0xbe, 0x78, 0x4f, 0x9b, 0x72, 0x35, 0xe0, 0x9e, 0x06,
	0xaa, 0x28, 0x0a, 0xf2, 0xde, 0x2b, 0xdf, 0x6b, 0x69, 0xfd, 0xcf, 0x2c, 0xae, 0x24, 0xc0, 0x38,
	0x2c, 0xec, 0xb3, 0x5d, 0xdb, 0x46, 0xf7, 0xe1, 0xd6, 0x05, 0xfb, 0x70, 0x7a, 0xca, 0x86, 0xd4,
	0xc8, 0xd5, 0xd2, 0x3b, 0x79, 0xbc, 0x3e, 0xaf, 0xc3, 0xca, 0x8b, 0xfe, 0x07, 0x79, 0x39, 0x77,
	0xe5, 0xac, 0x6b, 0xaa, 0x91, 0x9b, 0xc3, 0xb9, 0x28, 0xa4, 0x32, 0x3b, 0x4d, 0xb4, 0x07, 0x65,
	0xfa, 0x3a, 0xa0, 0x96, 0xa0, 0xb6, 0x19, 0x0a, 0x22, 0xa2, 0x90, 0x86, 0x46, 0x5e, 0x1d, 0x7d,
	0x3d, 0x39, 0xba, 0xfc, 0x47, 0xa9, 0x77, 0x7d, 0x71, 0xef, 0x13, 0x2c, 0x7f, 0x54, 0xb0, 0x3e,
	0x16, 0x3c, 0x4b, 0xe2, 0xab, 0xdf, 0x69, 0x50, 0x9a, 0x1d, 0x80, 0x93, 0xc4, 0x69, 0xff, 0x2d,
	0x71, 0x4b, 0xea, 0x24, 0xd7, 0x4d, 0x5c, 0x75, 0x1b, 0x74, 0x4c, 0x6d, 0x37, 0x9c, 0x3e, 0x91,
	0x0e, 0xe9, 0x97, 0x74, 0x94, 0x14, 0x9f, 0xfc, 0xac, 0x62, 0x58, 0x9b, 0x1b, 0xad, 0x0b, 0x19,
	0xd7, 0x16, 0x33, 0xbe, 0x09, 0x79, 0x12, 0x89, 0x01, 0xe3, 0xae, 0x88, 0x1b, 0x21, 0x8f, 0xcf,
	0x0d, 0xd5, 0x9f, 0x34, 0x28, 0x2f, 0xcc, 0x53, 0x59, 0xe5, 0xe7, 0xb8, 0x99, 0x2a, 0x97, 0x66,
	0xf4, 0x31, 0xac, 0x58, 0xcc, 0x3f, 0x71, 0x9d, 0xe4, 0x9f, 0x67, 0x63, 0x61, 0x7c, 0x3c, 0x53,
	0xbf, 0x72, 0xb2, 0xe3, 0xe2, 0x40, 0x74, 0x1f, 0x8a, 0x32, 0x2f, 0xb6, 0x99, 0x08, 0xe3, 0x06,
	0xb9, 0xb1, 0x20, 0xdc, 0xf5, 0x47, 0x9d, 0x14, 0x2e, 0xa8, 0xd8, 0x3d, 0x15, 0xda, 0x5a, 0x85,
	0x42, 0x2c, 0x32, 0xa5, 0xb5, 0xb5, 0x01, 0xa5, 0xe9, 0xf1, 0x41, 0x79, 0xd2, 0xc2, 0x8f, 0x32,
	0x39, 0xd0, 0x0b, 0x18, 0x71, 0xf9, 0x90, 0x33, 0x13, 0xe6, 0xce, 0xd7, 0x50, 0x8c, 0x6f, 0x17,
	0x57, 0x00, 0x2a, 0x40, 0xf6, 0xa8, 0xf7, 0x79, 0xef, 0xe9, 0x17, 0x3d, 0x3d, 0x25, 0x17, 0x9d,
	0xf6, 0xee, 0xe3, 0x7e, 0xe7, 0x85, 0xae, 0xa1, 0x55, 0xc8, 0x1f, 0xf5, 0xc6, 0xcb, 0x25, 0x54,
	0x84, 0xdc, 0x3e, 0xde, 0xed, 0xf6, 0xba, 0xbd, 0x03, 0x3d, 0x2d, 0x23, 0xfb, 0xdd, 0x27, 0xed,
	0xa7, 0x47, 0x7d, 0x3d, 0xa3, 0x5c, 0xed, 0x03, 0xbc, 0xbb, 0xdf, 0xde, 0xd7, 0x97, 0x5b, 0xed,
	0x1f, 0xcf, 0xb6, 0xb4, 0x5f, 0xcf, 0xb6, 0xb4, 0xdf, 0xce, 0xb6, 0xb4, 0x3f, 0xce, 0xb6, 0x34,
	0xb8, 0xed, 0xb2, 0xb8, 0x0a, 0x02, 0xce, 0x5e, 0x8f, 0x16, 0x0b, 0xa2, 0xa5, 0x4f, 0x3d, 0xf8,
	0xa1, 0xbc, 0xfe, 0xa1, 0x76, 0xbc, 0xa2, 0xde, 0xe1, 0xee, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff,
	0x36, 0x02, 0xaa, 0xc6, 0xc5, 0x0b, 0x00, 0x00,
}

func (this *HealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Timeout != nil && that1.Timeout != nil {
		if *this.Timeout != *that1.Timeout {
			return false
		}
	} else if this.Timeout != nil {
		return false
	} else if that1.Timeout != nil {
		return false
	}
	if this.Interval != nil && that1.Interval != nil {
		if *this.Interval != *that1.Interval {
			return false
		}
	} else if this.Interval != nil {
		return false
	} else if that1.Interval != nil {
		return false
	}
	if !this.InitialJitter.Equal(that1.InitialJitter) {
		return false
	}
	if !this.IntervalJitter.Equal(that1.IntervalJitter) {
		return false
	}
	if this.IntervalJitterPercent != that1.IntervalJitterPercent {
		return false
	}
	if !this.UnhealthyThreshold.Equal(that1.UnhealthyThreshold) {
		return false
	}
	if !this.HealthyThreshold.Equal(that1.HealthyThreshold) {
		return false
	}
	if !this.AltPort.Equal(that1.AltPort) {
		return false
	}
	if !this.ReuseConnection.Equal(that1.ReuseConnection) {
		return false
	}
	if that1.HealthChecker == nil {
		if this.HealthChecker != nil {
			return false
		}
	} else if this.HealthChecker == nil {
		return false
	} else if !this.HealthChecker.Equal(that1.HealthChecker) {
		return false
	}
	if !this.NoTrafficInterval.Equal(that1.NoTrafficInterval) {
		return false
	}
	if !this.UnhealthyInterval.Equal(that1.UnhealthyInterval) {
		return false
	}
	if !this.UnhealthyEdgeInterval.Equal(that1.UnhealthyEdgeInterval) {
		return false
	}
	if !this.HealthyEdgeInterval.Equal(that1.HealthyEdgeInterval) {
		return false
	}
	if this.EventLogPath != that1.EventLogPath {
		return false
	}
	if this.AlwaysLogHealthCheckFailures != that1.AlwaysLogHealthCheckFailures {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_HttpHealthCheck_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_HttpHealthCheck_)
	if !ok {
		that2, ok := that.(HealthCheck_HttpHealthCheck_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HttpHealthCheck.Equal(that1.HttpHealthCheck) {
		return false
	}
	return true
}
func (this *HealthCheck_TcpHealthCheck_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_TcpHealthCheck_)
	if !ok {
		that2, ok := that.(HealthCheck_TcpHealthCheck_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TcpHealthCheck.Equal(that1.TcpHealthCheck) {
		return false
	}
	return true
}
func (this *HealthCheck_GrpcHealthCheck_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_GrpcHealthCheck_)
	if !ok {
		that2, ok := that.(HealthCheck_GrpcHealthCheck_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.GrpcHealthCheck.Equal(that1.GrpcHealthCheck) {
		return false
	}
	return true
}
func (this *HealthCheck_CustomHealthCheck_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_CustomHealthCheck_)
	if !ok {
		that2, ok := that.(HealthCheck_CustomHealthCheck_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CustomHealthCheck.Equal(that1.CustomHealthCheck) {
		return false
	}
	return true
}
func (this *HealthCheck_Payload) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_Payload)
	if !ok {
		that2, ok := that.(HealthCheck_Payload)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Payload == nil {
		if this.Payload != nil {
			return false
		}
	} else if this.Payload == nil {
		return false
	} else if !this.Payload.Equal(that1.Payload) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_Payload_Text) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_Payload_Text)
	if !ok {
		that2, ok := that.(HealthCheck_Payload_Text)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Text != that1.Text {
		return false
	}
	return true
}
func (this *HealthCheck_Payload_Binary) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_Payload_Binary)
	if !ok {
		that2, ok := that.(HealthCheck_Payload_Binary)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Binary, that1.Binary) {
		return false
	}
	return true
}
func (this *HealthCheck_HttpHealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_HttpHealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck_HttpHealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !this.Send.Equal(that1.Send) {
		return false
	}
	if !this.Receive.Equal(that1.Receive) {
		return false
	}
	if this.ServiceName != that1.ServiceName {
		return false
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToRemove) != len(that1.RequestHeadersToRemove) {
		return false
	}
	for i := range this.RequestHeadersToRemove {
		if this.RequestHeadersToRemove[i] != that1.RequestHeadersToRemove[i] {
			return false
		}
	}
	if this.UseHttp2 != that1.UseHttp2 {
		return false
	}
	if len(this.ExpectedStatuses) != len(that1.ExpectedStatuses) {
		return false
	}
	for i := range this.ExpectedStatuses {
		if !this.ExpectedStatuses[i].Equal(that1.ExpectedStatuses[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_TcpHealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_TcpHealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck_TcpHealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Send.Equal(that1.Send) {
		return false
	}
	if len(this.Receive) != len(that1.Receive) {
		return false
	}
	for i := range this.Receive {
		if !this.Receive[i].Equal(that1.Receive[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_RedisHealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_RedisHealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck_RedisHealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_GrpcHealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_GrpcHealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck_GrpcHealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ServiceName != that1.ServiceName {
		return false
	}
	if this.Authority != that1.Authority {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_CustomHealthCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_CustomHealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck_CustomHealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.ConfigType == nil {
		if this.ConfigType != nil {
			return false
		}
	} else if this.ConfigType == nil {
		return false
	} else if !this.ConfigType.Equal(that1.ConfigType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_CustomHealthCheck_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_CustomHealthCheck_Config)
	if !ok {
		that2, ok := that.(HealthCheck_CustomHealthCheck_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *HealthCheck_CustomHealthCheck_TypedConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HealthCheck_CustomHealthCheck_TypedConfig)
	if !ok {
		that2, ok := that.(HealthCheck_CustomHealthCheck_TypedConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	return true
}
func (m *HealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)))
		n1, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Timeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Interval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Interval)))
		n2, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Interval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.IntervalJitter != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.IntervalJitter.Size()))
		n3, err := m.IntervalJitter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.UnhealthyThreshold != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.UnhealthyThreshold.Size()))
		n4, err := m.UnhealthyThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.HealthyThreshold != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.HealthyThreshold.Size()))
		n5, err := m.HealthyThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.AltPort != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.AltPort.Size()))
		n6, err := m.AltPort.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.ReuseConnection != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.ReuseConnection.Size()))
		n7, err := m.ReuseConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.HealthChecker != nil {
		nn8, err := m.HealthChecker.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn8
	}
	if m.NoTrafficInterval != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.NoTrafficInterval.Size()))
		n9, err := m.NoTrafficInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.UnhealthyInterval != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.UnhealthyInterval.Size()))
		n10, err := m.UnhealthyInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.UnhealthyEdgeInterval != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.UnhealthyEdgeInterval.Size()))
		n11, err := m.UnhealthyEdgeInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.HealthyEdgeInterval != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.HealthyEdgeInterval.Size()))
		n12, err := m.HealthyEdgeInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if len(m.EventLogPath) > 0 {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.EventLogPath)))
		i += copy(dAtA[i:], m.EventLogPath)
	}
	if m.IntervalJitterPercent != 0 {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.IntervalJitterPercent))
	}
	if m.AlwaysLogHealthCheckFailures {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		if m.AlwaysLogHealthCheckFailures {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.InitialJitter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.InitialJitter.Size()))
		n13, err := m.InitialJitter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_HttpHealthCheck_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HttpHealthCheck != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.HttpHealthCheck.Size()))
		n14, err := m.HttpHealthCheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *HealthCheck_TcpHealthCheck_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TcpHealthCheck != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.TcpHealthCheck.Size()))
		n15, err := m.TcpHealthCheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *HealthCheck_GrpcHealthCheck_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GrpcHealthCheck != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.GrpcHealthCheck.Size()))
		n16, err := m.GrpcHealthCheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *HealthCheck_CustomHealthCheck_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CustomHealthCheck != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.CustomHealthCheck.Size()))
		n17, err := m.CustomHealthCheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *HealthCheck_Payload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_Payload) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Payload != nil {
		nn18, err := m.Payload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_Payload_Text) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Text)))
	i += copy(dAtA[i:], m.Text)
	return i, nil
}
func (m *HealthCheck_Payload_Binary) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Binary != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Binary)))
		i += copy(dAtA[i:], m.Binary)
	}
	return i, nil
}
func (m *HealthCheck_HttpHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_HttpHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Host) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Host)))
		i += copy(dAtA[i:], m.Host)
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.Send != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.Send.Size()))
		n19, err := m.Send.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Receive != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.Receive.Size()))
		n20, err := m.Receive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if len(m.ServiceName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.ServiceName)))
		i += copy(dAtA[i:], m.ServiceName)
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x32
			i++
			i = encodeVarintHealthCheck(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseHttp2 {
		dAtA[i] = 0x38
		i++
		if m.UseHttp2 {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			dAtA[i] = 0x42
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ExpectedStatuses) > 0 {
		for _, msg := range m.ExpectedStatuses {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintHealthCheck(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_TcpHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_TcpHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Send != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.Send.Size()))
		n21, err := m.Send.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.Receive) > 0 {
		for _, msg := range m.Receive {
			dAtA[i] = 0x12
			i++
			i = encodeVarintHealthCheck(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_RedisHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_RedisHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_GrpcHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_GrpcHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServiceName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.ServiceName)))
		i += copy(dAtA[i:], m.ServiceName)
	}
	if len(m.Authority) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Authority)))
		i += copy(dAtA[i:], m.Authority)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_CustomHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_CustomHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn22, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_CustomHealthCheck_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.Config.Size()))
		n23, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}
func (m *HealthCheck_CustomHealthCheck_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHealthCheck(dAtA, i, uint64(m.TypedConfig.Size()))
		n24, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}
func encodeVarintHealthCheck(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.Interval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Interval)
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.IntervalJitter != nil {
		l = m.IntervalJitter.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.UnhealthyThreshold != nil {
		l = m.UnhealthyThreshold.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.HealthyThreshold != nil {
		l = m.HealthyThreshold.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.AltPort != nil {
		l = m.AltPort.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.ReuseConnection != nil {
		l = m.ReuseConnection.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.HealthChecker != nil {
		n += m.HealthChecker.Size()
	}
	if m.NoTrafficInterval != nil {
		l = m.NoTrafficInterval.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.UnhealthyInterval != nil {
		l = m.UnhealthyInterval.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.UnhealthyEdgeInterval != nil {
		l = m.UnhealthyEdgeInterval.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.HealthyEdgeInterval != nil {
		l = m.HealthyEdgeInterval.Size()
		n += 2 + l + sovHealthCheck(uint64(l))
	}
	l = len(m.EventLogPath)
	if l > 0 {
		n += 2 + l + sovHealthCheck(uint64(l))
	}
	if m.IntervalJitterPercent != 0 {
		n += 2 + sovHealthCheck(uint64(m.IntervalJitterPercent))
	}
	if m.AlwaysLogHealthCheckFailures {
		n += 3
	}
	if m.InitialJitter != nil {
		l = m.InitialJitter.Size()
		n += 2 + l + sovHealthCheck(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_HttpHealthCheck_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpHealthCheck != nil {
		l = m.HttpHealthCheck.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_TcpHealthCheck_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TcpHealthCheck != nil {
		l = m.TcpHealthCheck.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_GrpcHealthCheck_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GrpcHealthCheck != nil {
		l = m.GrpcHealthCheck.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_CustomHealthCheck_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CustomHealthCheck != nil {
		l = m.CustomHealthCheck.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_Payload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Payload != nil {
		n += m.Payload.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_Payload_Text) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Text)
	n += 1 + l + sovHealthCheck(uint64(l))
	return n
}
func (m *HealthCheck_Payload_Binary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Binary != nil {
		l = len(m.Binary)
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_HttpHealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.Send != nil {
		l = m.Send.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.Receive != nil {
		l = m.Receive.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovHealthCheck(uint64(l))
		}
	}
	if m.UseHttp2 {
		n += 2
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			l = len(s)
			n += 1 + l + sovHealthCheck(uint64(l))
		}
	}
	if len(m.ExpectedStatuses) > 0 {
		for _, e := range m.ExpectedStatuses {
			l = e.Size()
			n += 1 + l + sovHealthCheck(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_TcpHealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Send != nil {
		l = m.Send.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if len(m.Receive) > 0 {
		for _, e := range m.Receive {
			l = e.Size()
			n += 1 + l + sovHealthCheck(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_RedisHealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_GrpcHealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	l = len(m.Authority)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_CustomHealthCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_CustomHealthCheck_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}
func (m *HealthCheck_CustomHealthCheck_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovHealthCheck(uint64(l))
	}
	return n
}

func sovHealthCheck(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozHealthCheck(x uint64) (n int) {
	return sovHealthCheck(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Interval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalJitter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IntervalJitter == nil {
				m.IntervalJitter = &types.Duration{}
			}
			if err := m.IntervalJitter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnhealthyThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnhealthyThreshold == nil {
				m.UnhealthyThreshold = &types.UInt32Value{}
			}
			if err := m.UnhealthyThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthyThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthyThreshold == nil {
				m.HealthyThreshold = &types.UInt32Value{}
			}
			if err := m.HealthyThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AltPort", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AltPort == nil {
				m.AltPort = &types.UInt32Value{}
			}
			if err := m.AltPort.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReuseConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReuseConnection == nil {
				m.ReuseConnection = &types.BoolValue{}
			}
			if err := m.ReuseConnection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpHealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HealthCheck_HttpHealthCheck{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthChecker = &HealthCheck_HttpHealthCheck_{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpHealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HealthCheck_TcpHealthCheck{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthChecker = &HealthCheck_TcpHealthCheck_{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcHealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HealthCheck_GrpcHealthCheck{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthChecker = &HealthCheck_GrpcHealthCheck_{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoTrafficInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NoTrafficInterval == nil {
				m.NoTrafficInterval = &types.Duration{}
			}
			if err := m.NoTrafficInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomHealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HealthCheck_CustomHealthCheck{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthChecker = &HealthCheck_CustomHealthCheck_{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnhealthyInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnhealthyInterval == nil {
				m.UnhealthyInterval = &types.Duration{}
			}
			if err := m.UnhealthyInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnhealthyEdgeInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnhealthyEdgeInterval == nil {
				m.UnhealthyEdgeInterval = &types.Duration{}
			}
			if err := m.UnhealthyEdgeInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthyEdgeInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthyEdgeInterval == nil {
				m.HealthyEdgeInterval = &types.Duration{}
			}
			if err := m.HealthyEdgeInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventLogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventLogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalJitterPercent", wireType)
			}
			m.IntervalJitterPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntervalJitterPercent |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlwaysLogHealthCheckFailures", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AlwaysLogHealthCheckFailures = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialJitter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitialJitter == nil {
				m.InitialJitter = &types.Duration{}
			}
			if err := m.InitialJitter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_Payload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = &HealthCheck_Payload_Text{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Binary", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Payload = &HealthCheck_Payload_Binary{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_HttpHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Send == nil {
				m.Send = &HealthCheck_Payload{}
			}
			if err := m.Send.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Receive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Receive == nil {
				m.Receive = &HealthCheck_Payload{}
			}
			if err := m.Receive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseHttp2", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseHttp2 = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToRemove = append(m.RequestHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectedStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExpectedStatuses = append(m.ExpectedStatuses, &_type.Int64Range{})
			if err := m.ExpectedStatuses[len(m.ExpectedStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_TcpHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Send == nil {
				m.Send = &HealthCheck_Payload{}
			}
			if err := m.Send.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Receive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Receive = append(m.Receive, &HealthCheck_Payload{})
			if err := m.Receive[len(m.Receive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_RedisHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RedisHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RedisHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_GrpcHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GrpcHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GrpcHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authority", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authority = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_CustomHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &HealthCheck_CustomHealthCheck_Config{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHealthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &HealthCheck_CustomHealthCheck_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHealthCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHealthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHealthCheck(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHealthCheck
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHealthCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHealthCheck
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthHealthCheck
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowHealthCheck
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipHealthCheck(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthHealthCheck
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthHealthCheck = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHealthCheck   = fmt.Errorf("proto: integer overflow")
)
