// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/auth/cert.proto

package auth

import (
	bytes "bytes"
	fmt "fmt"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type TlsParameters_TlsProtocol int32

const (
	// Envoy will choose the optimal TLS version.
	TlsParameters_TLS_AUTO TlsParameters_TlsProtocol = 0
	// TLS 1.0
	TlsParameters_TLSv1_0 TlsParameters_TlsProtocol = 1
	// TLS 1.1
	TlsParameters_TLSv1_1 TlsParameters_TlsProtocol = 2
	// TLS 1.2
	TlsParameters_TLSv1_2 TlsParameters_TlsProtocol = 3
	// TLS 1.3
	TlsParameters_TLSv1_3 TlsParameters_TlsProtocol = 4
)

var TlsParameters_TlsProtocol_name = map[int32]string{
	0: "TLS_AUTO",
	1: "TLSv1_0",
	2: "TLSv1_1",
	3: "TLSv1_2",
	4: "TLSv1_3",
}

var TlsParameters_TlsProtocol_value = map[string]int32{
	"TLS_AUTO": 0,
	"TLSv1_0":  1,
	"TLSv1_1":  2,
	"TLSv1_2":  3,
	"TLSv1_3":  4,
}

func (x TlsParameters_TlsProtocol) String() string {
	return proto.EnumName(TlsParameters_TlsProtocol_name, int32(x))
}

func (TlsParameters_TlsProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{0, 0}
}

type TlsParameters struct {
	// Minimum TLS protocol version. By default, it's ``TLSv1_0``.
	TlsMinimumProtocolVersion TlsParameters_TlsProtocol `protobuf:"varint,1,opt,name=tls_minimum_protocol_version,json=tlsMinimumProtocolVersion,proto3,enum=envoy.api.v2.auth.TlsParameters_TlsProtocol" json:"tls_minimum_protocol_version,omitempty"`
	// Maximum TLS protocol version. By default, it's ``TLSv1_3`` for servers in non-FIPS builds, and
	// ``TLSv1_2`` for clients and for servers using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`.
	TlsMaximumProtocolVersion TlsParameters_TlsProtocol `protobuf:"varint,2,opt,name=tls_maximum_protocol_version,json=tlsMaximumProtocolVersion,proto3,enum=envoy.api.v2.auth.TlsParameters_TlsProtocol" json:"tls_maximum_protocol_version,omitempty"`
	// If specified, the TLS listener will only support the specified `cipher list
	// <https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration>`_
	// when negotiating TLS 1.0-1.2 (this setting has no effect when negotiating TLS 1.3). If not
	// specified, the default list will be used.
	//
	// In non-FIPS builds, the default cipher list is:
	//
	// .. code-block:: none
	//
	//   [ECDHE-ECDSA-AES128-GCM-SHA256|ECDHE-ECDSA-CHACHA20-POLY1305]
	//   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-RSA-CHACHA20-POLY1305]
	//   ECDHE-ECDSA-AES128-SHA
	//   ECDHE-RSA-AES128-SHA
	//   AES128-GCM-SHA256
	//   AES128-SHA
	//   ECDHE-ECDSA-AES256-GCM-SHA384
	//   ECDHE-RSA-AES256-GCM-SHA384
	//   ECDHE-ECDSA-AES256-SHA
	//   ECDHE-RSA-AES256-SHA
	//   AES256-GCM-SHA384
	//   AES256-SHA
	//
	// In builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the default cipher list is:
	//
	// .. code-block:: none
	//
	//   ECDHE-ECDSA-AES128-GCM-SHA256
	//   ECDHE-RSA-AES128-GCM-SHA256
	//   ECDHE-ECDSA-AES128-SHA
	//   ECDHE-RSA-AES128-SHA
	//   AES128-GCM-SHA256
	//   AES128-SHA
	//   ECDHE-ECDSA-AES256-GCM-SHA384
	//   ECDHE-RSA-AES256-GCM-SHA384
	//   ECDHE-ECDSA-AES256-SHA
	//   ECDHE-RSA-AES256-SHA
	//   AES256-GCM-SHA384
	//   AES256-SHA
	CipherSuites []string `protobuf:"bytes,3,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
	// If specified, the TLS connection will only support the specified ECDH
	// curves. If not specified, the default curves will be used.
	//
	// In non-FIPS builds, the default curves are:
	//
	// .. code-block:: none
	//
	//   X25519
	//   P-256
	//
	// In builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the default curve is:
	//
	// .. code-block:: none
	//
	//   P-256
	EcdhCurves           []string `protobuf:"bytes,4,rep,name=ecdh_curves,json=ecdhCurves,proto3" json:"ecdh_curves,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TlsParameters) Reset()         { *m = TlsParameters{} }
func (m *TlsParameters) String() string { return proto.CompactTextString(m) }
func (*TlsParameters) ProtoMessage()    {}
func (*TlsParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{0}
}
func (m *TlsParameters) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsParameters.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TlsParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsParameters.Merge(m, src)
}
func (m *TlsParameters) XXX_Size() int {
	return m.Size()
}
func (m *TlsParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsParameters.DiscardUnknown(m)
}

var xxx_messageInfo_TlsParameters proto.InternalMessageInfo

func (m *TlsParameters) GetTlsMinimumProtocolVersion() TlsParameters_TlsProtocol {
	if m != nil {
		return m.TlsMinimumProtocolVersion
	}
	return TlsParameters_TLS_AUTO
}

func (m *TlsParameters) GetTlsMaximumProtocolVersion() TlsParameters_TlsProtocol {
	if m != nil {
		return m.TlsMaximumProtocolVersion
	}
	return TlsParameters_TLS_AUTO
}

func (m *TlsParameters) GetCipherSuites() []string {
	if m != nil {
		return m.CipherSuites
	}
	return nil
}

func (m *TlsParameters) GetEcdhCurves() []string {
	if m != nil {
		return m.EcdhCurves
	}
	return nil
}

type TlsCertificate struct {
	// The TLS certificate chain.
	CertificateChain *core.DataSource `protobuf:"bytes,1,opt,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
	// The TLS private key.
	PrivateKey *core.DataSource `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// The password to decrypt the TLS private key. If this field is not set, it is assumed that the
	// TLS private key is not password encrypted.
	Password *core.DataSource `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// [#not-implemented-hide:]
	OcspStaple *core.DataSource `protobuf:"bytes,4,opt,name=ocsp_staple,json=ocspStaple,proto3" json:"ocsp_staple,omitempty"`
	// [#not-implemented-hide:]
	SignedCertificateTimestamp []*core.DataSource `protobuf:"bytes,5,rep,name=signed_certificate_timestamp,json=signedCertificateTimestamp,proto3" json:"signed_certificate_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}           `json:"-"`
	XXX_unrecognized           []byte             `json:"-"`
	XXX_sizecache              int32              `json:"-"`
}

func (m *TlsCertificate) Reset()         { *m = TlsCertificate{} }
func (m *TlsCertificate) String() string { return proto.CompactTextString(m) }
func (*TlsCertificate) ProtoMessage()    {}
func (*TlsCertificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{1}
}
func (m *TlsCertificate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsCertificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsCertificate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TlsCertificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsCertificate.Merge(m, src)
}
func (m *TlsCertificate) XXX_Size() int {
	return m.Size()
}
func (m *TlsCertificate) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsCertificate.DiscardUnknown(m)
}

var xxx_messageInfo_TlsCertificate proto.InternalMessageInfo

func (m *TlsCertificate) GetCertificateChain() *core.DataSource {
	if m != nil {
		return m.CertificateChain
	}
	return nil
}

func (m *TlsCertificate) GetPrivateKey() *core.DataSource {
	if m != nil {
		return m.PrivateKey
	}
	return nil
}

func (m *TlsCertificate) GetPassword() *core.DataSource {
	if m != nil {
		return m.Password
	}
	return nil
}

func (m *TlsCertificate) GetOcspStaple() *core.DataSource {
	if m != nil {
		return m.OcspStaple
	}
	return nil
}

func (m *TlsCertificate) GetSignedCertificateTimestamp() []*core.DataSource {
	if m != nil {
		return m.SignedCertificateTimestamp
	}
	return nil
}

type TlsSessionTicketKeys struct {
	// Keys for encrypting and decrypting TLS session tickets. The
	// first key in the array contains the key to encrypt all new sessions created by this context.
	// All keys are candidates for decrypting received tickets. This allows for easy rotation of keys
	// by, for example, putting the new key first, and the previous key second.
	//
	// If :ref:`session_ticket_keys <envoy_api_field_auth.DownstreamTlsContext.session_ticket_keys>`
	// is not specified, the TLS library will still support resuming sessions via tickets, but it will
	// use an internally-generated and managed key, so sessions cannot be resumed across hot restarts
	// or on different hosts.
	//
	// Each key must contain exactly 80 bytes of cryptographically-secure random data. For
	// example, the output of ``openssl rand 80``.
	//
	// .. attention::
	//
	//   Using this feature has serious security considerations and risks. Improper handling of keys
	//   may result in loss of secrecy in connections, even if ciphers supporting perfect forward
	//   secrecy are used. See https://www.imperialviolet.org/2013/06/27/botchingpfs.html for some
	//   discussion. To minimize the risk, you must:
	//
	//   * Keep the session ticket keys at least as secure as your TLS certificate private keys
	//   * Rotate session ticket keys at least daily, and preferably hourly
	//   * Always generate keys using a cryptographically-secure random data source
	Keys                 []*core.DataSource `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TlsSessionTicketKeys) Reset()         { *m = TlsSessionTicketKeys{} }
func (m *TlsSessionTicketKeys) String() string { return proto.CompactTextString(m) }
func (*TlsSessionTicketKeys) ProtoMessage()    {}
func (*TlsSessionTicketKeys) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{2}
}
func (m *TlsSessionTicketKeys) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsSessionTicketKeys) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsSessionTicketKeys.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TlsSessionTicketKeys) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsSessionTicketKeys.Merge(m, src)
}
func (m *TlsSessionTicketKeys) XXX_Size() int {
	return m.Size()
}
func (m *TlsSessionTicketKeys) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsSessionTicketKeys.DiscardUnknown(m)
}

var xxx_messageInfo_TlsSessionTicketKeys proto.InternalMessageInfo

func (m *TlsSessionTicketKeys) GetKeys() []*core.DataSource {
	if m != nil {
		return m.Keys
	}
	return nil
}

type CertificateValidationContext struct {
	// TLS certificate data containing certificate authority certificates to use in verifying
	// a presented peer certificate (e.g. server certificate for clusters or client certificate
	// for listeners). If not specified and a peer certificate is presented it will not be
	// verified. By default, a client certificate is optional, unless one of the additional
	// options (:ref:`require_client_certificate
	// <envoy_api_field_auth.DownstreamTlsContext.require_client_certificate>`,
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>`,
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>`, or
	// :ref:`verify_subject_alt_name
	// <envoy_api_field_auth.CertificateValidationContext.verify_subject_alt_name>`) is also
	// specified.
	//
	// It can optionally contain certificate revocation lists, in which case Envoy will verify
	// that the presented peer certificate has not been revoked by one of the included CRLs.
	//
	// See :ref:`the TLS overview <arch_overview_ssl_enabling_verification>` for a list of common
	// system CA locations.
	TrustedCa *core.DataSource `protobuf:"bytes,1,opt,name=trusted_ca,json=trustedCa,proto3" json:"trusted_ca,omitempty"`
	// An optional list of base64-encoded SHA-256 hashes. If specified, Envoy will verify that the
	// SHA-256 of the DER-encoded Subject Public Key Information (SPKI) of the presented certificate
	// matches one of the specified values.
	//
	// A base64-encoded SHA-256 of the Subject Public Key Information (SPKI) of the certificate
	// can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -noout -pubkey \
	//     | openssl pkey -pubin -outform DER \
	//     | openssl dgst -sha256 -binary \
	//     | openssl enc -base64
	//   NvqYIYSbgK2vCJpQhObf77vv+bQWtc5ek5RIOwPiC9A=
	//
	// This is the format used in HTTP Public Key Pinning.
	//
	// When both:
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>` and
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>` are specified,
	// a hash matching value from either of the lists will result in the certificate being accepted.
	//
	// .. attention::
	//
	//   This option is preferred over :ref:`verify_certificate_hash
	//   <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>`,
	//   because SPKI is tied to a private key, so it doesn't change when the certificate
	//   is renewed using the same private key.
	VerifyCertificateSpki []string `protobuf:"bytes,3,rep,name=verify_certificate_spki,json=verifyCertificateSpki,proto3" json:"verify_certificate_spki,omitempty"`
	// An optional list of hex-encoded SHA-256 hashes. If specified, Envoy will verify that
	// the SHA-256 of the DER-encoded presented certificate matches one of the specified values.
	//
	// A hex-encoded SHA-256 of the certificate can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -outform DER | openssl dgst -sha256 | cut -d" " -f2
	//   df6ff72fe9116521268f6f2dd4966f51df479883fe7037b39f75916ac3049d1a
	//
	// A long hex-encoded and colon-separated SHA-256 (a.k.a. "fingerprint") of the certificate
	// can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -noout -fingerprint -sha256 | cut -d"=" -f2
	//   DF:6F:F7:2F:E9:11:65:21:26:8F:6F:2D:D4:96:6F:51:DF:47:98:83:FE:70:37:B3:9F:75:91:6A:C3:04:9D:1A
	//
	// Both of those formats are acceptable.
	//
	// When both:
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>` and
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>` are specified,
	// a hash matching value from either of the lists will result in the certificate being accepted.
	VerifyCertificateHash []string `protobuf:"bytes,2,rep,name=verify_certificate_hash,json=verifyCertificateHash,proto3" json:"verify_certificate_hash,omitempty"`
	// An optional list of Subject Alternative Names. If specified, Envoy will verify that the
	// Subject Alternative Name of the presented certificate matches one of the specified values.
	//
	// .. attention::
	//
	//   Subject Alternative Names are easily spoofable and verifying only them is insecure,
	//   therefore this option must be used together with :ref:`trusted_ca
	//   <envoy_api_field_auth.CertificateValidationContext.trusted_ca>`.
	VerifySubjectAltName []string `protobuf:"bytes,4,rep,name=verify_subject_alt_name,json=verifySubjectAltName,proto3" json:"verify_subject_alt_name,omitempty"`
	// [#not-implemented-hide:] Must present a signed time-stamped OCSP response.
	RequireOcspStaple *types.BoolValue `protobuf:"bytes,5,opt,name=require_ocsp_staple,json=requireOcspStaple,proto3" json:"require_ocsp_staple,omitempty"`
	// [#not-implemented-hide:] Must present signed certificate time-stamp.
	RequireSignedCertificateTimestamp *types.BoolValue `protobuf:"bytes,6,opt,name=require_signed_certificate_timestamp,json=requireSignedCertificateTimestamp,proto3" json:"require_signed_certificate_timestamp,omitempty"`
	// An optional `certificate revocation list
	// <https://en.wikipedia.org/wiki/Certificate_revocation_list>`_
	// (in PEM format). If specified, Envoy will verify that the presented peer
	// certificate has not been revoked by this CRL. If this DataSource contains
	// multiple CRLs, all of them will be used.
	Crl *core.DataSource `protobuf:"bytes,7,opt,name=crl,proto3" json:"crl,omitempty"`
	// If specified, Envoy will not reject expired certificates.
	AllowExpiredCertificate bool     `protobuf:"varint,8,opt,name=allow_expired_certificate,json=allowExpiredCertificate,proto3" json:"allow_expired_certificate,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *CertificateValidationContext) Reset()         { *m = CertificateValidationContext{} }
func (m *CertificateValidationContext) String() string { return proto.CompactTextString(m) }
func (*CertificateValidationContext) ProtoMessage()    {}
func (*CertificateValidationContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{3}
}
func (m *CertificateValidationContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CertificateValidationContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CertificateValidationContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CertificateValidationContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertificateValidationContext.Merge(m, src)
}
func (m *CertificateValidationContext) XXX_Size() int {
	return m.Size()
}
func (m *CertificateValidationContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CertificateValidationContext.DiscardUnknown(m)
}

var xxx_messageInfo_CertificateValidationContext proto.InternalMessageInfo

func (m *CertificateValidationContext) GetTrustedCa() *core.DataSource {
	if m != nil {
		return m.TrustedCa
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifyCertificateSpki() []string {
	if m != nil {
		return m.VerifyCertificateSpki
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifyCertificateHash() []string {
	if m != nil {
		return m.VerifyCertificateHash
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifySubjectAltName() []string {
	if m != nil {
		return m.VerifySubjectAltName
	}
	return nil
}

func (m *CertificateValidationContext) GetRequireOcspStaple() *types.BoolValue {
	if m != nil {
		return m.RequireOcspStaple
	}
	return nil
}

func (m *CertificateValidationContext) GetRequireSignedCertificateTimestamp() *types.BoolValue {
	if m != nil {
		return m.RequireSignedCertificateTimestamp
	}
	return nil
}

func (m *CertificateValidationContext) GetCrl() *core.DataSource {
	if m != nil {
		return m.Crl
	}
	return nil
}

func (m *CertificateValidationContext) GetAllowExpiredCertificate() bool {
	if m != nil {
		return m.AllowExpiredCertificate
	}
	return false
}

// TLS context shared by both client and server TLS contexts.
type CommonTlsContext struct {
	// TLS protocol versions, cipher suites etc.
	TlsParams *TlsParameters `protobuf:"bytes,1,opt,name=tls_params,json=tlsParams,proto3" json:"tls_params,omitempty"`
	// :ref:`Multiple TLS certificates <arch_overview_ssl_cert_select>` can be associated with the
	// same context to allow both RSA and ECDSA certificates.
	//
	// Only a single TLS certificate is supported in client contexts. In server contexts, the first
	// RSA certificate is used for clients that only support RSA and the first ECDSA certificate is
	// used for clients that support ECDSA.
	TlsCertificates []*TlsCertificate `protobuf:"bytes,2,rep,name=tls_certificates,json=tlsCertificates,proto3" json:"tls_certificates,omitempty"`
	// Configs for fetching TLS certificates via SDS API.
	TlsCertificateSdsSecretConfigs []*SdsSecretConfig `protobuf:"bytes,6,rep,name=tls_certificate_sds_secret_configs,json=tlsCertificateSdsSecretConfigs,proto3" json:"tls_certificate_sds_secret_configs,omitempty"`
	// Types that are valid to be assigned to ValidationContextType:
	//	*CommonTlsContext_ValidationContext
	//	*CommonTlsContext_ValidationContextSdsSecretConfig
	//	*CommonTlsContext_CombinedValidationContext
	ValidationContextType isCommonTlsContext_ValidationContextType `protobuf_oneof:"validation_context_type"`
	// Supplies the list of ALPN protocols that the listener should expose. In
	// practice this is likely to be set to one of two values (see the
	// :ref:`codec_type
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.codec_type>`
	// parameter in the HTTP connection manager for more information):
	//
	// * "h2,http/1.1" If the listener is going to support both HTTP/2 and HTTP/1.1.
	// * "http/1.1" If the listener is only going to support HTTP/1.1.
	//
	// There is no default for this parameter. If empty, Envoy will not expose ALPN.
	AlpnProtocols        []string `protobuf:"bytes,4,rep,name=alpn_protocols,json=alpnProtocols,proto3" json:"alpn_protocols,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommonTlsContext) Reset()         { *m = CommonTlsContext{} }
func (m *CommonTlsContext) String() string { return proto.CompactTextString(m) }
func (*CommonTlsContext) ProtoMessage()    {}
func (*CommonTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{4}
}
func (m *CommonTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommonTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommonTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommonTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonTlsContext.Merge(m, src)
}
func (m *CommonTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *CommonTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_CommonTlsContext proto.InternalMessageInfo

type isCommonTlsContext_ValidationContextType interface {
	isCommonTlsContext_ValidationContextType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type CommonTlsContext_ValidationContext struct {
	ValidationContext *CertificateValidationContext `protobuf:"bytes,3,opt,name=validation_context,json=validationContext,proto3,oneof"`
}
type CommonTlsContext_ValidationContextSdsSecretConfig struct {
	ValidationContextSdsSecretConfig *SdsSecretConfig `protobuf:"bytes,7,opt,name=validation_context_sds_secret_config,json=validationContextSdsSecretConfig,proto3,oneof"`
}
type CommonTlsContext_CombinedValidationContext struct {
	CombinedValidationContext *CommonTlsContext_CombinedCertificateValidationContext `protobuf:"bytes,8,opt,name=combined_validation_context,json=combinedValidationContext,proto3,oneof"`
}

func (*CommonTlsContext_ValidationContext) isCommonTlsContext_ValidationContextType()                {}
func (*CommonTlsContext_ValidationContextSdsSecretConfig) isCommonTlsContext_ValidationContextType() {}
func (*CommonTlsContext_CombinedValidationContext) isCommonTlsContext_ValidationContextType()        {}

func (m *CommonTlsContext) GetValidationContextType() isCommonTlsContext_ValidationContextType {
	if m != nil {
		return m.ValidationContextType
	}
	return nil
}

func (m *CommonTlsContext) GetTlsParams() *TlsParameters {
	if m != nil {
		return m.TlsParams
	}
	return nil
}

func (m *CommonTlsContext) GetTlsCertificates() []*TlsCertificate {
	if m != nil {
		return m.TlsCertificates
	}
	return nil
}

func (m *CommonTlsContext) GetTlsCertificateSdsSecretConfigs() []*SdsSecretConfig {
	if m != nil {
		return m.TlsCertificateSdsSecretConfigs
	}
	return nil
}

func (m *CommonTlsContext) GetValidationContext() *CertificateValidationContext {
	if x, ok := m.GetValidationContextType().(*CommonTlsContext_ValidationContext); ok {
		return x.ValidationContext
	}
	return nil
}

func (m *CommonTlsContext) GetValidationContextSdsSecretConfig() *SdsSecretConfig {
	if x, ok := m.GetValidationContextType().(*CommonTlsContext_ValidationContextSdsSecretConfig); ok {
		return x.ValidationContextSdsSecretConfig
	}
	return nil
}

func (m *CommonTlsContext) GetCombinedValidationContext() *CommonTlsContext_CombinedCertificateValidationContext {
	if x, ok := m.GetValidationContextType().(*CommonTlsContext_CombinedValidationContext); ok {
		return x.CombinedValidationContext
	}
	return nil
}

func (m *CommonTlsContext) GetAlpnProtocols() []string {
	if m != nil {
		return m.AlpnProtocols
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommonTlsContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommonTlsContext_OneofMarshaler, _CommonTlsContext_OneofUnmarshaler, _CommonTlsContext_OneofSizer, []interface{}{
		(*CommonTlsContext_ValidationContext)(nil),
		(*CommonTlsContext_ValidationContextSdsSecretConfig)(nil),
		(*CommonTlsContext_CombinedValidationContext)(nil),
	}
}

func _CommonTlsContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommonTlsContext)
	// validation_context_type
	switch x := m.ValidationContextType.(type) {
	case *CommonTlsContext_ValidationContext:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContext); err != nil {
			return err
		}
	case *CommonTlsContext_ValidationContextSdsSecretConfig:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContextSdsSecretConfig); err != nil {
			return err
		}
	case *CommonTlsContext_CombinedValidationContext:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CombinedValidationContext); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommonTlsContext.ValidationContextType has unexpected type %T", x)
	}
	return nil
}

func _CommonTlsContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommonTlsContext)
	switch tag {
	case 3: // validation_context_type.validation_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CertificateValidationContext)
		err := b.DecodeMessage(msg)
		m.ValidationContextType = &CommonTlsContext_ValidationContext{msg}
		return true, err
	case 7: // validation_context_type.validation_context_sds_secret_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdsSecretConfig)
		err := b.DecodeMessage(msg)
		m.ValidationContextType = &CommonTlsContext_ValidationContextSdsSecretConfig{msg}
		return true, err
	case 8: // validation_context_type.combined_validation_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CommonTlsContext_CombinedCertificateValidationContext)
		err := b.DecodeMessage(msg)
		m.ValidationContextType = &CommonTlsContext_CombinedValidationContext{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommonTlsContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommonTlsContext)
	// validation_context_type
	switch x := m.ValidationContextType.(type) {
	case *CommonTlsContext_ValidationContext:
		s := proto.Size(x.ValidationContext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CommonTlsContext_ValidationContextSdsSecretConfig:
		s := proto.Size(x.ValidationContextSdsSecretConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CommonTlsContext_CombinedValidationContext:
		s := proto.Size(x.CombinedValidationContext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CommonTlsContext_CombinedCertificateValidationContext struct {
	// How to validate peer certificates.
	DefaultValidationContext *CertificateValidationContext `protobuf:"bytes,1,opt,name=default_validation_context,json=defaultValidationContext,proto3" json:"default_validation_context,omitempty"`
	// Config for fetching validation context via SDS API.
	ValidationContextSdsSecretConfig *SdsSecretConfig `protobuf:"bytes,2,opt,name=validation_context_sds_secret_config,json=validationContextSdsSecretConfig,proto3" json:"validation_context_sds_secret_config,omitempty"`
	XXX_NoUnkeyedLiteral             struct{}         `json:"-"`
	XXX_unrecognized                 []byte           `json:"-"`
	XXX_sizecache                    int32            `json:"-"`
}

func (m *CommonTlsContext_CombinedCertificateValidationContext) Reset() {
	*m = CommonTlsContext_CombinedCertificateValidationContext{}
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) String() string {
	return proto.CompactTextString(m)
}
func (*CommonTlsContext_CombinedCertificateValidationContext) ProtoMessage() {}
func (*CommonTlsContext_CombinedCertificateValidationContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{4, 0}
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommonTlsContext_CombinedCertificateValidationContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonTlsContext_CombinedCertificateValidationContext.Merge(m, src)
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) XXX_Size() int {
	return m.Size()
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonTlsContext_CombinedCertificateValidationContext.DiscardUnknown(m)
}

var xxx_messageInfo_CommonTlsContext_CombinedCertificateValidationContext proto.InternalMessageInfo

func (m *CommonTlsContext_CombinedCertificateValidationContext) GetDefaultValidationContext() *CertificateValidationContext {
	if m != nil {
		return m.DefaultValidationContext
	}
	return nil
}

func (m *CommonTlsContext_CombinedCertificateValidationContext) GetValidationContextSdsSecretConfig() *SdsSecretConfig {
	if m != nil {
		return m.ValidationContextSdsSecretConfig
	}
	return nil
}

type UpstreamTlsContext struct {
	// Common TLS context settings.
	CommonTlsContext *CommonTlsContext `protobuf:"bytes,1,opt,name=common_tls_context,json=commonTlsContext,proto3" json:"common_tls_context,omitempty"`
	// SNI string to use when creating TLS backend connections.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
	// If true, server-initiated TLS renegotiation will be allowed.
	//
	// .. attention::
	//
	//   TLS renegotiation is considered insecure and shouldn't be used unless absolutely necessary.
	AllowRenegotiation bool `protobuf:"varint,3,opt,name=allow_renegotiation,json=allowRenegotiation,proto3" json:"allow_renegotiation,omitempty"`
	// Maximum number of session keys (Pre-Shared Keys for TLSv1.3+, Session IDs and Session Tickets
	// for TLSv1.2 and older) to store for the purpose of session resumption.
	//
	// Defaults to 1, setting this to 0 disables session resumption.
	MaxSessionKeys       *types.UInt32Value `protobuf:"bytes,4,opt,name=max_session_keys,json=maxSessionKeys,proto3" json:"max_session_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpstreamTlsContext) Reset()         { *m = UpstreamTlsContext{} }
func (m *UpstreamTlsContext) String() string { return proto.CompactTextString(m) }
func (*UpstreamTlsContext) ProtoMessage()    {}
func (*UpstreamTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{5}
}
func (m *UpstreamTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpstreamTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamTlsContext.Merge(m, src)
}
func (m *UpstreamTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamTlsContext proto.InternalMessageInfo

func (m *UpstreamTlsContext) GetCommonTlsContext() *CommonTlsContext {
	if m != nil {
		return m.CommonTlsContext
	}
	return nil
}

func (m *UpstreamTlsContext) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

func (m *UpstreamTlsContext) GetAllowRenegotiation() bool {
	if m != nil {
		return m.AllowRenegotiation
	}
	return false
}

func (m *UpstreamTlsContext) GetMaxSessionKeys() *types.UInt32Value {
	if m != nil {
		return m.MaxSessionKeys
	}
	return nil
}

type DownstreamTlsContext struct {
	// Common TLS context settings.
	CommonTlsContext *CommonTlsContext `protobuf:"bytes,1,opt,name=common_tls_context,json=commonTlsContext,proto3" json:"common_tls_context,omitempty"`
	// If specified, Envoy will reject connections without a valid client
	// certificate.
	RequireClientCertificate *types.BoolValue `protobuf:"bytes,2,opt,name=require_client_certificate,json=requireClientCertificate,proto3" json:"require_client_certificate,omitempty"`
	// If specified, Envoy will reject connections without a valid and matching SNI.
	// [#not-implemented-hide:]
	RequireSni *types.BoolValue `protobuf:"bytes,3,opt,name=require_sni,json=requireSni,proto3" json:"require_sni,omitempty"`
	// Types that are valid to be assigned to SessionTicketKeysType:
	//	*DownstreamTlsContext_SessionTicketKeys
	//	*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig
	SessionTicketKeysType isDownstreamTlsContext_SessionTicketKeysType `protobuf_oneof:"session_ticket_keys_type"`
	XXX_NoUnkeyedLiteral  struct{}                                     `json:"-"`
	XXX_unrecognized      []byte                                       `json:"-"`
	XXX_sizecache         int32                                        `json:"-"`
}

func (m *DownstreamTlsContext) Reset()         { *m = DownstreamTlsContext{} }
func (m *DownstreamTlsContext) String() string { return proto.CompactTextString(m) }
func (*DownstreamTlsContext) ProtoMessage()    {}
func (*DownstreamTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{6}
}
func (m *DownstreamTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DownstreamTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DownstreamTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DownstreamTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownstreamTlsContext.Merge(m, src)
}
func (m *DownstreamTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *DownstreamTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_DownstreamTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_DownstreamTlsContext proto.InternalMessageInfo

type isDownstreamTlsContext_SessionTicketKeysType interface {
	isDownstreamTlsContext_SessionTicketKeysType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type DownstreamTlsContext_SessionTicketKeys struct {
	SessionTicketKeys *TlsSessionTicketKeys `protobuf:"bytes,4,opt,name=session_ticket_keys,json=sessionTicketKeys,proto3,oneof"`
}
type DownstreamTlsContext_SessionTicketKeysSdsSecretConfig struct {
	SessionTicketKeysSdsSecretConfig *SdsSecretConfig `protobuf:"bytes,5,opt,name=session_ticket_keys_sds_secret_config,json=sessionTicketKeysSdsSecretConfig,proto3,oneof"`
}

func (*DownstreamTlsContext_SessionTicketKeys) isDownstreamTlsContext_SessionTicketKeysType() {}
func (*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) isDownstreamTlsContext_SessionTicketKeysType() {
}

func (m *DownstreamTlsContext) GetSessionTicketKeysType() isDownstreamTlsContext_SessionTicketKeysType {
	if m != nil {
		return m.SessionTicketKeysType
	}
	return nil
}

func (m *DownstreamTlsContext) GetCommonTlsContext() *CommonTlsContext {
	if m != nil {
		return m.CommonTlsContext
	}
	return nil
}

func (m *DownstreamTlsContext) GetRequireClientCertificate() *types.BoolValue {
	if m != nil {
		return m.RequireClientCertificate
	}
	return nil
}

func (m *DownstreamTlsContext) GetRequireSni() *types.BoolValue {
	if m != nil {
		return m.RequireSni
	}
	return nil
}

func (m *DownstreamTlsContext) GetSessionTicketKeys() *TlsSessionTicketKeys {
	if x, ok := m.GetSessionTicketKeysType().(*DownstreamTlsContext_SessionTicketKeys); ok {
		return x.SessionTicketKeys
	}
	return nil
}

func (m *DownstreamTlsContext) GetSessionTicketKeysSdsSecretConfig() *SdsSecretConfig {
	if x, ok := m.GetSessionTicketKeysType().(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig); ok {
		return x.SessionTicketKeysSdsSecretConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DownstreamTlsContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DownstreamTlsContext_OneofMarshaler, _DownstreamTlsContext_OneofUnmarshaler, _DownstreamTlsContext_OneofSizer, []interface{}{
		(*DownstreamTlsContext_SessionTicketKeys)(nil),
		(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)(nil),
	}
}

func _DownstreamTlsContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DownstreamTlsContext)
	// session_ticket_keys_type
	switch x := m.SessionTicketKeysType.(type) {
	case *DownstreamTlsContext_SessionTicketKeys:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeys); err != nil {
			return err
		}
	case *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeysSdsSecretConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DownstreamTlsContext.SessionTicketKeysType has unexpected type %T", x)
	}
	return nil
}

func _DownstreamTlsContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DownstreamTlsContext)
	switch tag {
	case 4: // session_ticket_keys_type.session_ticket_keys
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsSessionTicketKeys)
		err := b.DecodeMessage(msg)
		m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeys{msg}
		return true, err
	case 5: // session_ticket_keys_type.session_ticket_keys_sds_secret_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdsSecretConfig)
		err := b.DecodeMessage(msg)
		m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeysSdsSecretConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DownstreamTlsContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DownstreamTlsContext)
	// session_ticket_keys_type
	switch x := m.SessionTicketKeysType.(type) {
	case *DownstreamTlsContext_SessionTicketKeys:
		s := proto.Size(x.SessionTicketKeys)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig:
		s := proto.Size(x.SessionTicketKeysSdsSecretConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// [#proto-status: experimental]
type SdsSecretConfig struct {
	// Name (FQDN, UUID, SPKI, SHA256, etc.) by which the secret can be uniquely referred to.
	// When both name and config are specified, then secret can be fetched and/or reloaded via SDS.
	// When only name is specified, then secret will be loaded from static resources [V2-API-DIFF].
	Name                 string             `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	SdsConfig            *core.ConfigSource `protobuf:"bytes,2,opt,name=sds_config,json=sdsConfig,proto3" json:"sds_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdsSecretConfig) Reset()         { *m = SdsSecretConfig{} }
func (m *SdsSecretConfig) String() string { return proto.CompactTextString(m) }
func (*SdsSecretConfig) ProtoMessage()    {}
func (*SdsSecretConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{7}
}
func (m *SdsSecretConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SdsSecretConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SdsSecretConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SdsSecretConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdsSecretConfig.Merge(m, src)
}
func (m *SdsSecretConfig) XXX_Size() int {
	return m.Size()
}
func (m *SdsSecretConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SdsSecretConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SdsSecretConfig proto.InternalMessageInfo

func (m *SdsSecretConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdsSecretConfig) GetSdsConfig() *core.ConfigSource {
	if m != nil {
		return m.SdsConfig
	}
	return nil
}

// [#proto-status: experimental]
type Secret struct {
	// Name (FQDN, UUID, SPKI, SHA256, etc.) by which the secret can be uniquely referred to.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to Type:
	//	*Secret_TlsCertificate
	//	*Secret_SessionTicketKeys
	//	*Secret_ValidationContext
	Type                 isSecret_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_0c3851c0865b2745, []int{8}
}
func (m *Secret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return m.Size()
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

type isSecret_Type interface {
	isSecret_Type()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Secret_TlsCertificate struct {
	TlsCertificate *TlsCertificate `protobuf:"bytes,2,opt,name=tls_certificate,json=tlsCertificate,proto3,oneof"`
}
type Secret_SessionTicketKeys struct {
	SessionTicketKeys *TlsSessionTicketKeys `protobuf:"bytes,3,opt,name=session_ticket_keys,json=sessionTicketKeys,proto3,oneof"`
}
type Secret_ValidationContext struct {
	ValidationContext *CertificateValidationContext `protobuf:"bytes,4,opt,name=validation_context,json=validationContext,proto3,oneof"`
}

func (*Secret_TlsCertificate) isSecret_Type()    {}
func (*Secret_SessionTicketKeys) isSecret_Type() {}
func (*Secret_ValidationContext) isSecret_Type() {}

func (m *Secret) GetType() isSecret_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Secret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret) GetTlsCertificate() *TlsCertificate {
	if x, ok := m.GetType().(*Secret_TlsCertificate); ok {
		return x.TlsCertificate
	}
	return nil
}

func (m *Secret) GetSessionTicketKeys() *TlsSessionTicketKeys {
	if x, ok := m.GetType().(*Secret_SessionTicketKeys); ok {
		return x.SessionTicketKeys
	}
	return nil
}

func (m *Secret) GetValidationContext() *CertificateValidationContext {
	if x, ok := m.GetType().(*Secret_ValidationContext); ok {
		return x.ValidationContext
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Secret) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Secret_OneofMarshaler, _Secret_OneofUnmarshaler, _Secret_OneofSizer, []interface{}{
		(*Secret_TlsCertificate)(nil),
		(*Secret_SessionTicketKeys)(nil),
		(*Secret_ValidationContext)(nil),
	}
}

func _Secret_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Secret)
	// type
	switch x := m.Type.(type) {
	case *Secret_TlsCertificate:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TlsCertificate); err != nil {
			return err
		}
	case *Secret_SessionTicketKeys:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeys); err != nil {
			return err
		}
	case *Secret_ValidationContext:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContext); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Secret.Type has unexpected type %T", x)
	}
	return nil
}

func _Secret_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Secret)
	switch tag {
	case 2: // type.tls_certificate
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsCertificate)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_TlsCertificate{msg}
		return true, err
	case 3: // type.session_ticket_keys
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsSessionTicketKeys)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_SessionTicketKeys{msg}
		return true, err
	case 4: // type.validation_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CertificateValidationContext)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_ValidationContext{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Secret_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Secret)
	// type
	switch x := m.Type.(type) {
	case *Secret_TlsCertificate:
		s := proto.Size(x.TlsCertificate)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Secret_SessionTicketKeys:
		s := proto.Size(x.SessionTicketKeys)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Secret_ValidationContext:
		s := proto.Size(x.ValidationContext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("envoy.api.v2.auth.TlsParameters_TlsProtocol", TlsParameters_TlsProtocol_name, TlsParameters_TlsProtocol_value)
	proto.RegisterType((*TlsParameters)(nil), "envoy.api.v2.auth.TlsParameters")
	proto.RegisterType((*TlsCertificate)(nil), "envoy.api.v2.auth.TlsCertificate")
	proto.RegisterType((*TlsSessionTicketKeys)(nil), "envoy.api.v2.auth.TlsSessionTicketKeys")
	proto.RegisterType((*CertificateValidationContext)(nil), "envoy.api.v2.auth.CertificateValidationContext")
	proto.RegisterType((*CommonTlsContext)(nil), "envoy.api.v2.auth.CommonTlsContext")
	proto.RegisterType((*CommonTlsContext_CombinedCertificateValidationContext)(nil), "envoy.api.v2.auth.CommonTlsContext.CombinedCertificateValidationContext")
	proto.RegisterType((*UpstreamTlsContext)(nil), "envoy.api.v2.auth.UpstreamTlsContext")
	proto.RegisterType((*DownstreamTlsContext)(nil), "envoy.api.v2.auth.DownstreamTlsContext")
	proto.RegisterType((*SdsSecretConfig)(nil), "envoy.api.v2.auth.SdsSecretConfig")
	proto.RegisterType((*Secret)(nil), "envoy.api.v2.auth.Secret")
}

func init() { proto.RegisterFile("envoy/api/v2/auth/cert.proto", fileDescriptor_0c3851c0865b2745) }

var fileDescriptor_0c3851c0865b2745 = []byte{
	// 1325 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xbf, 0x73, 0x1b, 0x45,
	0x14, 0xf6, 0x49, 0xb2, 0x23, 0x3f, 0x25, 0xce, 0x79, 0x63, 0xc6, 0x67, 0x61, 0x1c, 0x45, 0x49,
	0x06, 0x17, 0x19, 0x89, 0x28, 0x43, 0xc1, 0xaf, 0x40, 0xa4, 0xc0, 0x98, 0xc4, 0x90, 0x70, 0x92,
	0x33, 0x40, 0x73, 0xac, 0x4f, 0x6b, 0x69, 0xf1, 0xdd, 0xed, 0xb1, 0xbb, 0x92, 0x2d, 0x0a, 0x0a,
	0xca, 0x94, 0xa9, 0x69, 0xe8, 0xe8, 0xe8, 0xa9, 0x28, 0x69, 0x98, 0xe1, 0x4f, 0x60, 0xdc, 0xd1,
	0xa4, 0xa6, 0x02, 0x66, 0xf7, 0x4e, 0xf6, 0x49, 0x77, 0x89, 0x04, 0x93, 0xa1, 0xbb, 0xdd, 0xb7,
	0xef, 0xfb, 0x76, 0xdf, 0xfb, 0xde, 0x7b, 0x07, 0x9b, 0x24, 0x18, 0xb2, 0x51, 0x1d, 0x87, 0xb4,
	0x3e, 0x6c, 0xd4, 0xf1, 0x40, 0xf6, 0xeb, 0x2e, 0xe1, 0xb2, 0x16, 0x72, 0x26, 0x19, 0x5a, 0xd5,
	0xd6, 0x1a, 0x0e, 0x69, 0x6d, 0xd8, 0xa8, 0x29, 0x6b, 0x79, 0xd2, 0xc1, 0x65, 0x9c, 0xd4, 0xf7,
	0xb1, 0x20, 0x91, 0x43, 0xf9, 0x7a, 0xda, 0xea, 0xb2, 0xe0, 0x80, 0xf6, 0x1c, 0xc1, 0x06, 0xdc,
	0x1d, 0x1f, 0xdb, 0xea, 0x31, 0xd6, 0xf3, 0x48, 0x5d, 0xaf, 0xf6, 0x07, 0x07, 0xf5, 0x23, 0x8e,
	0xc3, 0x90, 0x70, 0x11, 0xdb, 0xd7, 0x87, 0xd8, 0xa3, 0x5d, 0x2c, 0x49, 0x7d, 0xfc, 0x11, 0x1b,
	0xd6, 0x7a, 0xac, 0xc7, 0xf4, 0x67, 0x5d, 0x7d, 0x45, 0xbb, 0xd5, 0xef, 0xf2, 0x70, 0xa1, 0xe3,
	0x89, 0x87, 0x98, 0x63, 0x9f, 0x48, 0xc2, 0x05, 0x1a, 0xc1, 0xa6, 0xf4, 0x84, 0xe3, 0xd3, 0x80,
	0xfa, 0x03, 0xdf, 0xd1, 0xc7, 0x5c, 0xe6, 0x39, 0x43, 0xc2, 0x05, 0x65, 0x81, 0x65, 0x54, 0x8c,
	0xed, 0x95, 0xc6, 0x8d, 0x5a, 0xea, 0x7d, 0xb5, 0x09, 0x1c, 0xbd, 0x8a, 0x7d, 0x9b, 0xf0, 0xd3,
	0x1f, 0x3f, 0xe7, 0x17, 0xbf, 0x35, 0x72, 0xa6, 0x61, 0x6f, 0x48, 0x4f, 0x7c, 0x14, 0x81, 0x8f,
	0xed, 0x8f, 0x22, 0xe8, 0x53, 0x6a, 0x7c, 0x9c, 0x4d, 0x9d, 0x7b, 0x11, 0xd4, 0x11, 0xf8, 0x34,
	0xf5, 0x55, 0xb8, 0xe0, 0xd2, 0xb0, 0x4f, 0xb8, 0x23, 0x06, 0x54, 0x12, 0x61, 0xe5, 0x2b, 0xf9,
	0xed, 0x65, 0xfb, 0x7c, 0xb4, 0xd9, 0xd6, 0x7b, 0xe8, 0x32, 0x94, 0x88, 0xdb, 0xed, 0x3b, 0xee,
	0x80, 0x0f, 0x89, 0xb0, 0x0a, 0xfa, 0x08, 0xa8, 0xad, 0x96, 0xde, 0xa9, 0x3e, 0x80, 0x52, 0x82,
	0x1b, 0x9d, 0x87, 0x62, 0x67, 0xb7, 0xed, 0xdc, 0xd9, 0xeb, 0x3c, 0x30, 0x17, 0x50, 0x09, 0xce,
	0x75, 0x76, 0xdb, 0xc3, 0x9b, 0xce, 0x6b, 0xa6, 0x71, 0xb6, 0xb8, 0x69, 0xe6, 0xce, 0x16, 0x0d,
	0x33, 0x7f, 0xb6, 0xb8, 0x65, 0x16, 0xaa, 0x7f, 0xe6, 0x60, 0xa5, 0xe3, 0x89, 0x16, 0xe1, 0x92,
	0x1e, 0x50, 0x17, 0x4b, 0x82, 0xee, 0xc1, 0xaa, 0x7b, 0xb6, 0x74, 0xdc, 0x3e, 0xa6, 0x51, 0x52,
	0x4a, 0x8d, 0x57, 0x26, 0x23, 0xa3, 0x34, 0x54, 0xbb, 0x8b, 0x25, 0x6e, 0x6b, 0x01, 0xd9, 0x66,
	0xc2, 0xaf, 0xa5, 0xdc, 0xd0, 0x6d, 0x28, 0x85, 0x9c, 0x0e, 0x15, 0xce, 0x21, 0x19, 0xe9, 0xf8,
	0xce, 0x44, 0x81, 0xd8, 0xe3, 0x3e, 0x19, 0xa1, 0x37, 0xa0, 0x18, 0x62, 0x21, 0x8e, 0x18, 0xef,
	0x5a, 0xf9, 0x79, 0x9c, 0x4f, 0x8f, 0x2b, 0x6a, 0xe6, 0x8a, 0xd0, 0x11, 0x12, 0x87, 0x1e, 0xb1,
	0x0a, 0x73, 0x51, 0x2b, 0x8f, 0xb6, 0x76, 0x40, 0x0e, 0x6c, 0x0a, 0xda, 0x0b, 0x48, 0xd7, 0x49,
	0x46, 0x43, 0x52, 0x9f, 0x08, 0x89, 0xfd, 0xd0, 0x5a, 0xac, 0xe4, 0x67, 0x03, 0x96, 0x23, 0x88,
	0x44, 0x78, 0x3b, 0x63, 0x80, 0xea, 0x1e, 0xac, 0x75, 0x3c, 0xd1, 0x26, 0x42, 0xe9, 0xa3, 0x43,
	0xdd, 0x43, 0x22, 0xef, 0x93, 0x91, 0x40, 0xef, 0x40, 0xe1, 0x90, 0x8c, 0x84, 0x65, 0xcc, 0x41,
	0x10, 0xab, 0xef, 0x89, 0x91, 0x2b, 0x1a, 0xb6, 0x76, 0xab, 0xfe, 0x5a, 0x80, 0xcd, 0x04, 0xdf,
	0xa3, 0xa8, 0x48, 0x29, 0x0b, 0x5a, 0x2c, 0x90, 0xe4, 0x58, 0xa2, 0xb7, 0x01, 0x24, 0x1f, 0x08,
	0xa9, 0x5e, 0x86, 0xe7, 0x4b, 0xec, 0x72, 0xec, 0xd0, 0xc2, 0x68, 0x07, 0xd6, 0x87, 0x84, 0xd3,
	0x83, 0xd1, 0x44, 0x58, 0x44, 0x78, 0x48, 0x23, 0x45, 0x37, 0x4d, 0x75, 0xa3, 0xd2, 0x13, 0xa3,
	0x58, 0x5d, 0xe2, 0x85, 0xca, 0x8d, 0xed, 0x1b, 0xf6, 0x4b, 0x91, 0x43, 0xe2, 0x52, 0xed, 0xf0,
	0x90, 0x3e, 0x03, 0xa9, 0x8f, 0x45, 0xdf, 0xca, 0x65, 0x20, 0xbd, 0xb7, 0xed, 0x64, 0x20, 0xed,
	0x60, 0xd1, 0x47, 0xaf, 0x9f, 0x22, 0x89, 0xc1, 0xfe, 0x97, 0xc4, 0x95, 0x0e, 0xf6, 0xa4, 0x13,
	0x60, 0x9f, 0xc4, 0x25, 0xb4, 0x16, 0x99, 0xdb, 0x91, 0xf5, 0x8e, 0x27, 0x3f, 0xc6, 0xbe, 0x12,
	0xfa, 0x25, 0x4e, 0xbe, 0x1a, 0x50, 0x4e, 0x9c, 0xa4, 0x52, 0x16, 0x75, 0x44, 0xca, 0xb5, 0xa8,
	0x0f, 0xd6, 0xc6, 0x7d, 0xb0, 0xd6, 0x64, 0xcc, 0x7b, 0x84, 0xbd, 0x01, 0xb1, 0x57, 0x63, 0xb7,
	0x07, 0x67, 0x6a, 0x39, 0x84, 0x6b, 0x63, 0xac, 0xe7, 0xaa, 0x66, 0x69, 0x26, 0xf8, 0x95, 0x18,
	0xa7, 0xfd, 0x4c, 0xe5, 0xa0, 0x3a, 0xe4, 0x5d, 0xee, 0x59, 0xe7, 0xe6, 0x49, 0x9d, 0x3a, 0x89,
	0xde, 0x84, 0x0d, 0xec, 0x79, 0xec, 0xc8, 0x21, 0xc7, 0x21, 0xe5, 0x93, 0x97, 0xb3, 0x8a, 0x15,
	0x63, 0xbb, 0x68, 0xaf, 0xeb, 0x03, 0xef, 0x47, 0xf6, 0x04, 0x6b, 0xf5, 0xe9, 0x39, 0x30, 0x5b,
	0xcc, 0xf7, 0x59, 0xa0, 0xfa, 0x44, 0xac, 0xa1, 0x77, 0x01, 0x54, 0x23, 0x0d, 0x55, 0x4b, 0x14,
	0xb1, 0x86, 0x2a, 0xb3, 0xda, 0xa6, 0xbd, 0x2c, 0xe3, 0xa5, 0x40, 0xbb, 0x60, 0x2a, 0x80, 0xc4,
	0x3d, 0x84, 0xce, 0x7a, 0xa9, 0x71, 0x25, 0x1b, 0x26, 0x71, 0x25, 0xfb, 0xa2, 0x9c, 0x58, 0x0b,
	0xf4, 0x35, 0x54, 0xa7, 0xd0, 0x1c, 0xd1, 0x15, 0x8e, 0x20, 0x2e, 0x27, 0xd2, 0x89, 0xa6, 0x9c,
	0xb0, 0x96, 0x34, 0x7e, 0x35, 0x03, 0xbf, 0xdd, 0x15, 0x6d, 0x7d, 0xb6, 0xa5, 0x8f, 0x9e, 0x55,
	0x95, 0x69, 0xd8, 0x5b, 0x93, 0x64, 0x53, 0x47, 0x05, 0xfa, 0x02, 0xd0, 0xf0, 0xb4, 0xc6, 0x14,
	0x97, 0x0a, 0x50, 0xdc, 0xac, 0xea, 0x19, 0x5c, 0xcf, 0xab, 0xcd, 0x9d, 0x05, 0x7b, 0x75, 0x98,
	0x2a, 0x58, 0x09, 0xd7, 0xd2, 0x0c, 0xe9, 0x07, 0xc6, 0x7a, 0x98, 0xe3, 0x7d, 0x3b, 0x0b, 0x76,
	0x25, 0x45, 0x33, 0x75, 0x06, 0x3d, 0x36, 0xe0, 0x65, 0x97, 0xf9, 0xfb, 0x54, 0x89, 0x39, 0xe3,
	0x85, 0x45, 0xcd, 0xb6, 0x93, 0xf5, 0xc2, 0x29, 0xb5, 0xa8, 0x0d, 0x0d, 0x33, 0xe3, 0xe9, 0x1b,
	0x63, 0xba, 0x74, 0xcf, 0xba, 0x0e, 0x2b, 0xd8, 0x0b, 0x83, 0xd3, 0x89, 0x3d, 0x9e, 0x8d, 0x17,
	0xd4, 0xee, 0x78, 0x1c, 0x8a, 0xf2, 0xf7, 0x39, 0xb8, 0x36, 0x0f, 0x19, 0x1a, 0x41, 0xb9, 0x4b,
	0x0e, 0xf0, 0xc0, 0x93, 0x59, 0x4f, 0x33, 0xfe, 0x53, 0xf2, 0x62, 0xd5, 0x3c, 0xd6, 0xaa, 0xb1,
	0x62, 0xf8, 0x34, 0xf5, 0x37, 0x73, 0x66, 0x33, 0x37, 0x6f, 0x36, 0x27, 0x78, 0x67, 0xe6, 0xb5,
	0xb9, 0x01, 0xeb, 0x19, 0xfc, 0x72, 0x14, 0x92, 0x7b, 0x85, 0xe2, 0xa2, 0xb9, 0x54, 0xfd, 0xcb,
	0x00, 0xb4, 0x17, 0x0a, 0xc9, 0x09, 0xf6, 0x13, 0x25, 0xff, 0x09, 0x20, 0x57, 0x27, 0xd6, 0xd1,
	0xa5, 0x36, 0x11, 0xaa, 0xab, 0x73, 0xa8, 0xc0, 0x36, 0xdd, 0xe9, 0x2e, 0xb2, 0x09, 0x79, 0x11,
	0x50, 0xfd, 0xd2, 0xe5, 0xf8, 0x15, 0x3c, 0xbf, 0xfd, 0xb7, 0x61, 0xab, 0x6d, 0x54, 0x87, 0x4b,
	0x51, 0xd3, 0xe2, 0x24, 0x20, 0x3d, 0x26, 0xa9, 0xbe, 0xb1, 0xae, 0xac, 0xa2, 0x8d, 0xb4, 0xc9,
	0x4e, 0x5a, 0xd0, 0x07, 0x60, 0xfa, 0xf8, 0xd8, 0x11, 0xd1, 0x44, 0x75, 0xf4, 0x10, 0x8d, 0xc6,
	0xfe, 0x66, 0xaa, 0xdf, 0xee, 0x7d, 0x18, 0xc8, 0x5b, 0x8d, 0xa8, 0xe3, 0xae, 0xf8, 0xf8, 0x38,
	0x1e, 0xc3, 0x6a, 0x00, 0x57, 0x9f, 0xe6, 0x61, 0xed, 0x2e, 0x3b, 0x0a, 0xfe, 0x8f, 0x10, 0x7c,
	0x0a, 0xe5, 0xf1, 0xdc, 0x70, 0x3d, 0x4a, 0x02, 0x39, 0xd1, 0x9a, 0x73, 0x33, 0xa7, 0x85, 0x15,
	0x7b, 0xb7, 0xb4, 0x73, 0xf2, 0x37, 0xee, 0x2d, 0x28, 0x9d, 0x4e, 0xa4, 0x80, 0xc6, 0x0d, 0xe9,
	0x79, 0x50, 0x30, 0x1e, 0x3c, 0x01, 0x45, 0x9f, 0xc1, 0xa5, 0x71, 0x18, 0xa5, 0xfe, 0x33, 0x49,
	0x46, 0xf3, 0xd5, 0xec, 0x0e, 0x9d, 0xfa, 0x93, 0x51, 0xdd, 0x4c, 0xa4, 0x7e, 0x6f, 0x06, 0x70,
	0x3d, 0x03, 0x3a, 0xa3, 0x00, 0x16, 0xff, 0x4d, 0x3b, 0x4b, 0xf1, 0x4c, 0xcb, 0xbe, 0x0c, 0x56,
	0x16, 0xad, 0xd2, 0x7d, 0x95, 0xc0, 0xc5, 0xe9, 0xee, 0x87, 0xa0, 0xa0, 0xff, 0x1f, 0x54, 0x72,
	0x97, 0x6d, 0xfd, 0x8d, 0x6e, 0x03, 0xa8, 0x5b, 0x4e, 0xd4, 0xe7, 0xe5, 0x8c, 0xe9, 0x1b, 0x41,
	0x8c, 0x7f, 0x9d, 0x44, 0x57, 0x44, 0x1b, 0xd5, 0x1f, 0x73, 0xb0, 0x14, 0x91, 0x64, 0xc2, 0xef,
	0xc2, 0xc5, 0xa9, 0x21, 0x16, 0x73, 0xcc, 0x9e, 0x88, 0x3b, 0x0b, 0xf6, 0xca, 0xe4, 0x98, 0x7a,
	0x56, 0x06, 0xf3, 0x2f, 0x20, 0x83, 0xd9, 0x13, 0xaf, 0xf0, 0xe2, 0x26, 0x5e, 0x73, 0x09, 0x0a,
	0x2a, 0x31, 0xcd, 0xbb, 0x3f, 0x9c, 0x6c, 0x19, 0xbf, 0x9c, 0x6c, 0x19, 0xbf, 0x9d, 0x6c, 0x19,
	0xbf, 0x9f, 0x6c, 0x19, 0x70, 0x99, 0xb2, 0x88, 0x21, 0xe4, 0xec, 0x78, 0x94, 0x26, 0x6b, 0x2e,
	0x2b, 0x36, 0x3d, 0x11, 0x1e, 0x1a, 0x9f, 0x17, 0xd4, 0xd6, 0xfe, 0x92, 0x16, 0xfb, 0xad, 0x7f,
	0x02, 0x00, 0x00, 0xff, 0xff, 0xa2, 0xd6, 0xa7, 0x9e, 0x50, 0x0f, 0x00, 0x00,
}

func (this *TlsParameters) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsParameters)
	if !ok {
		that2, ok := that.(TlsParameters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TlsMinimumProtocolVersion != that1.TlsMinimumProtocolVersion {
		return false
	}
	if this.TlsMaximumProtocolVersion != that1.TlsMaximumProtocolVersion {
		return false
	}
	if len(this.CipherSuites) != len(that1.CipherSuites) {
		return false
	}
	for i := range this.CipherSuites {
		if this.CipherSuites[i] != that1.CipherSuites[i] {
			return false
		}
	}
	if len(this.EcdhCurves) != len(that1.EcdhCurves) {
		return false
	}
	for i := range this.EcdhCurves {
		if this.EcdhCurves[i] != that1.EcdhCurves[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TlsCertificate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsCertificate)
	if !ok {
		that2, ok := that.(TlsCertificate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CertificateChain.Equal(that1.CertificateChain) {
		return false
	}
	if !this.PrivateKey.Equal(that1.PrivateKey) {
		return false
	}
	if !this.Password.Equal(that1.Password) {
		return false
	}
	if !this.OcspStaple.Equal(that1.OcspStaple) {
		return false
	}
	if len(this.SignedCertificateTimestamp) != len(that1.SignedCertificateTimestamp) {
		return false
	}
	for i := range this.SignedCertificateTimestamp {
		if !this.SignedCertificateTimestamp[i].Equal(that1.SignedCertificateTimestamp[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TlsSessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsSessionTicketKeys)
	if !ok {
		that2, ok := that.(TlsSessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if !this.Keys[i].Equal(that1.Keys[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CertificateValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CertificateValidationContext)
	if !ok {
		that2, ok := that.(CertificateValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TrustedCa.Equal(that1.TrustedCa) {
		return false
	}
	if len(this.VerifyCertificateSpki) != len(that1.VerifyCertificateSpki) {
		return false
	}
	for i := range this.VerifyCertificateSpki {
		if this.VerifyCertificateSpki[i] != that1.VerifyCertificateSpki[i] {
			return false
		}
	}
	if len(this.VerifyCertificateHash) != len(that1.VerifyCertificateHash) {
		return false
	}
	for i := range this.VerifyCertificateHash {
		if this.VerifyCertificateHash[i] != that1.VerifyCertificateHash[i] {
			return false
		}
	}
	if len(this.VerifySubjectAltName) != len(that1.VerifySubjectAltName) {
		return false
	}
	for i := range this.VerifySubjectAltName {
		if this.VerifySubjectAltName[i] != that1.VerifySubjectAltName[i] {
			return false
		}
	}
	if !this.RequireOcspStaple.Equal(that1.RequireOcspStaple) {
		return false
	}
	if !this.RequireSignedCertificateTimestamp.Equal(that1.RequireSignedCertificateTimestamp) {
		return false
	}
	if !this.Crl.Equal(that1.Crl) {
		return false
	}
	if this.AllowExpiredCertificate != that1.AllowExpiredCertificate {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommonTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext)
	if !ok {
		that2, ok := that.(CommonTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TlsParams.Equal(that1.TlsParams) {
		return false
	}
	if len(this.TlsCertificates) != len(that1.TlsCertificates) {
		return false
	}
	for i := range this.TlsCertificates {
		if !this.TlsCertificates[i].Equal(that1.TlsCertificates[i]) {
			return false
		}
	}
	if len(this.TlsCertificateSdsSecretConfigs) != len(that1.TlsCertificateSdsSecretConfigs) {
		return false
	}
	for i := range this.TlsCertificateSdsSecretConfigs {
		if !this.TlsCertificateSdsSecretConfigs[i].Equal(that1.TlsCertificateSdsSecretConfigs[i]) {
			return false
		}
	}
	if that1.ValidationContextType == nil {
		if this.ValidationContextType != nil {
			return false
		}
	} else if this.ValidationContextType == nil {
		return false
	} else if !this.ValidationContextType.Equal(that1.ValidationContextType) {
		return false
	}
	if len(this.AlpnProtocols) != len(that1.AlpnProtocols) {
		return false
	}
	for i := range this.AlpnProtocols {
		if this.AlpnProtocols[i] != that1.AlpnProtocols[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommonTlsContext_ValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_ValidationContext)
	if !ok {
		that2, ok := that.(CommonTlsContext_ValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContext.Equal(that1.ValidationContext) {
		return false
	}
	return true
}
func (this *CommonTlsContext_ValidationContextSdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_ValidationContextSdsSecretConfig)
	if !ok {
		that2, ok := that.(CommonTlsContext_ValidationContextSdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContextSdsSecretConfig.Equal(that1.ValidationContextSdsSecretConfig) {
		return false
	}
	return true
}
func (this *CommonTlsContext_CombinedValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_CombinedValidationContext)
	if !ok {
		that2, ok := that.(CommonTlsContext_CombinedValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CombinedValidationContext.Equal(that1.CombinedValidationContext) {
		return false
	}
	return true
}
func (this *CommonTlsContext_CombinedCertificateValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_CombinedCertificateValidationContext)
	if !ok {
		that2, ok := that.(CommonTlsContext_CombinedCertificateValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.DefaultValidationContext.Equal(that1.DefaultValidationContext) {
		return false
	}
	if !this.ValidationContextSdsSecretConfig.Equal(that1.ValidationContextSdsSecretConfig) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamTlsContext)
	if !ok {
		that2, ok := that.(UpstreamTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CommonTlsContext.Equal(that1.CommonTlsContext) {
		return false
	}
	if this.Sni != that1.Sni {
		return false
	}
	if this.AllowRenegotiation != that1.AllowRenegotiation {
		return false
	}
	if !this.MaxSessionKeys.Equal(that1.MaxSessionKeys) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext)
	if !ok {
		that2, ok := that.(DownstreamTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CommonTlsContext.Equal(that1.CommonTlsContext) {
		return false
	}
	if !this.RequireClientCertificate.Equal(that1.RequireClientCertificate) {
		return false
	}
	if !this.RequireSni.Equal(that1.RequireSni) {
		return false
	}
	if that1.SessionTicketKeysType == nil {
		if this.SessionTicketKeysType != nil {
			return false
		}
	} else if this.SessionTicketKeysType == nil {
		return false
	} else if !this.SessionTicketKeysType.Equal(that1.SessionTicketKeysType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext_SessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext_SessionTicketKeys)
	if !ok {
		that2, ok := that.(DownstreamTlsContext_SessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeys.Equal(that1.SessionTicketKeys) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)
	if !ok {
		that2, ok := that.(DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeysSdsSecretConfig.Equal(that1.SessionTicketKeysSdsSecretConfig) {
		return false
	}
	return true
}
func (this *SdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SdsSecretConfig)
	if !ok {
		that2, ok := that.(SdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.SdsConfig.Equal(that1.SdsConfig) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Secret) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret)
	if !ok {
		that2, ok := that.(Secret)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.Type == nil {
		if this.Type != nil {
			return false
		}
	} else if this.Type == nil {
		return false
	} else if !this.Type.Equal(that1.Type) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Secret_TlsCertificate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_TlsCertificate)
	if !ok {
		that2, ok := that.(Secret_TlsCertificate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TlsCertificate.Equal(that1.TlsCertificate) {
		return false
	}
	return true
}
func (this *Secret_SessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_SessionTicketKeys)
	if !ok {
		that2, ok := that.(Secret_SessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeys.Equal(that1.SessionTicketKeys) {
		return false
	}
	return true
}
func (this *Secret_ValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_ValidationContext)
	if !ok {
		that2, ok := that.(Secret_ValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContext.Equal(that1.ValidationContext) {
		return false
	}
	return true
}
func (m *TlsParameters) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsParameters) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TlsMinimumProtocolVersion != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsMinimumProtocolVersion))
	}
	if m.TlsMaximumProtocolVersion != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsMaximumProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.EcdhCurves) > 0 {
		for _, s := range m.EcdhCurves {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TlsCertificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsCertificate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CertificateChain != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CertificateChain.Size()))
		n1, err := m.CertificateChain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.PrivateKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.PrivateKey.Size()))
		n2, err := m.PrivateKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Password != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.Password.Size()))
		n3, err := m.Password.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.OcspStaple != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.OcspStaple.Size()))
		n4, err := m.OcspStaple.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.SignedCertificateTimestamp) > 0 {
		for _, msg := range m.SignedCertificateTimestamp {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TlsSessionTicketKeys) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsSessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CertificateValidationContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificateValidationContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TrustedCa != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TrustedCa.Size()))
		n5, err := m.TrustedCa.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.VerifySubjectAltName) > 0 {
		for _, s := range m.VerifySubjectAltName {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.RequireOcspStaple != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireOcspStaple.Size()))
		n6, err := m.RequireOcspStaple.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.RequireSignedCertificateTimestamp != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireSignedCertificateTimestamp.Size()))
		n7, err := m.RequireSignedCertificateTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Crl != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.Crl.Size()))
		n8, err := m.Crl.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.AllowExpiredCertificate {
		dAtA[i] = 0x40
		i++
		if m.AllowExpiredCertificate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommonTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommonTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TlsParams != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsParams.Size()))
		n9, err := m.TlsParams.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.TlsCertificates) > 0 {
		for _, msg := range m.TlsCertificates {
			dAtA[i] = 0x12
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ValidationContextType != nil {
		nn10, err := m.ValidationContextType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn10
	}
	if len(m.AlpnProtocols) > 0 {
		for _, s := range m.AlpnProtocols {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.TlsCertificateSdsSecretConfigs) > 0 {
		for _, msg := range m.TlsCertificateSdsSecretConfigs {
			dAtA[i] = 0x32
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommonTlsContext_ValidationContext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContext != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContext.Size()))
		n11, err := m.ValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *CommonTlsContext_ValidationContextSdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContextSdsSecretConfig != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContextSdsSecretConfig.Size()))
		n12, err := m.ValidationContextSdsSecretConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *CommonTlsContext_CombinedValidationContext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CombinedValidationContext != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CombinedValidationContext.Size()))
		n13, err := m.CombinedValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommonTlsContext_CombinedCertificateValidationContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DefaultValidationContext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.DefaultValidationContext.Size()))
		n14, err := m.DefaultValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.ValidationContextSdsSecretConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContextSdsSecretConfig.Size()))
		n15, err := m.ValidationContextSdsSecretConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CommonTlsContext.Size()))
		n16, err := m.CommonTlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.Sni) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Sni)))
		i += copy(dAtA[i:], m.Sni)
	}
	if m.AllowRenegotiation {
		dAtA[i] = 0x18
		i++
		if m.AllowRenegotiation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxSessionKeys != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.MaxSessionKeys.Size()))
		n17, err := m.MaxSessionKeys.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownstreamTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownstreamTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CommonTlsContext.Size()))
		n18, err := m.CommonTlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.RequireClientCertificate != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireClientCertificate.Size()))
		n19, err := m.RequireClientCertificate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.RequireSni != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireSni.Size()))
		n20, err := m.RequireSni.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.SessionTicketKeysType != nil {
		nn21, err := m.SessionTicketKeysType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn21
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownstreamTlsContext_SessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeys != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeys.Size()))
		n22, err := m.SessionTicketKeys.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}
func (m *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeysSdsSecretConfig != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeysSdsSecretConfig.Size()))
		n23, err := m.SessionTicketKeysSdsSecretConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}
func (m *SdsSecretConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.SdsConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SdsConfig.Size()))
		n24, err := m.SdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Secret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Type != nil {
		nn25, err := m.Type.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn25
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Secret_TlsCertificate) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TlsCertificate != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsCertificate.Size()))
		n26, err := m.TlsCertificate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *Secret_SessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeys != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeys.Size()))
		n27, err := m.SessionTicketKeys.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *Secret_ValidationContext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContext != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContext.Size()))
		n28, err := m.ValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func encodeVarintCert(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TlsParameters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TlsMinimumProtocolVersion != 0 {
		n += 1 + sovCert(uint64(m.TlsMinimumProtocolVersion))
	}
	if m.TlsMaximumProtocolVersion != 0 {
		n += 1 + sovCert(uint64(m.TlsMaximumProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.EcdhCurves) > 0 {
		for _, s := range m.EcdhCurves {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TlsCertificate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CertificateChain != nil {
		l = m.CertificateChain.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.PrivateKey != nil {
		l = m.PrivateKey.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Password != nil {
		l = m.Password.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.OcspStaple != nil {
		l = m.OcspStaple.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.SignedCertificateTimestamp) > 0 {
		for _, e := range m.SignedCertificateTimestamp {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TlsSessionTicketKeys) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CertificateValidationContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TrustedCa != nil {
		l = m.TrustedCa.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.VerifySubjectAltName) > 0 {
		for _, s := range m.VerifySubjectAltName {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.RequireOcspStaple != nil {
		l = m.RequireOcspStaple.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireSignedCertificateTimestamp != nil {
		l = m.RequireSignedCertificateTimestamp.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Crl != nil {
		l = m.Crl.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.AllowExpiredCertificate {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommonTlsContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TlsParams != nil {
		l = m.TlsParams.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.TlsCertificates) > 0 {
		for _, e := range m.TlsCertificates {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.ValidationContextType != nil {
		n += m.ValidationContextType.Size()
	}
	if len(m.AlpnProtocols) > 0 {
		for _, s := range m.AlpnProtocols {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.TlsCertificateSdsSecretConfigs) > 0 {
		for _, e := range m.TlsCertificateSdsSecretConfigs {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommonTlsContext_ValidationContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ValidationContext != nil {
		l = m.ValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *CommonTlsContext_ValidationContextSdsSecretConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ValidationContextSdsSecretConfig != nil {
		l = m.ValidationContextSdsSecretConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *CommonTlsContext_CombinedValidationContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CombinedValidationContext != nil {
		l = m.CombinedValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DefaultValidationContext != nil {
		l = m.DefaultValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.ValidationContextSdsSecretConfig != nil {
		l = m.ValidationContextSdsSecretConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamTlsContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		l = m.CommonTlsContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.AllowRenegotiation {
		n += 2
	}
	if m.MaxSessionKeys != nil {
		l = m.MaxSessionKeys.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownstreamTlsContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		l = m.CommonTlsContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireClientCertificate != nil {
		l = m.RequireClientCertificate.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireSni != nil {
		l = m.RequireSni.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.SessionTicketKeysType != nil {
		n += m.SessionTicketKeysType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownstreamTlsContext_SessionTicketKeys) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SessionTicketKeys != nil {
		l = m.SessionTicketKeys.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SessionTicketKeysSdsSecretConfig != nil {
		l = m.SessionTicketKeysSdsSecretConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *SdsSecretConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.SdsConfig != nil {
		l = m.SdsConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Secret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Type != nil {
		n += m.Type.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Secret_TlsCertificate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TlsCertificate != nil {
		l = m.TlsCertificate.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *Secret_SessionTicketKeys) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SessionTicketKeys != nil {
		l = m.SessionTicketKeys.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *Secret_ValidationContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ValidationContext != nil {
		l = m.ValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}

func sovCert(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCert(x uint64) (n int) {
	return sovCert(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TlsParameters) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsParameters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsParameters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsMinimumProtocolVersion", wireType)
			}
			m.TlsMinimumProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TlsMinimumProtocolVersion |= TlsParameters_TlsProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsMaximumProtocolVersion", wireType)
			}
			m.TlsMaximumProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TlsMaximumProtocolVersion |= TlsParameters_TlsProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherSuites", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherSuites = append(m.CipherSuites, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EcdhCurves", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EcdhCurves = append(m.EcdhCurves, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TlsCertificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsCertificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsCertificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificateChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CertificateChain == nil {
				m.CertificateChain = &core.DataSource{}
			}
			if err := m.CertificateChain.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrivateKey == nil {
				m.PrivateKey = &core.DataSource{}
			}
			if err := m.PrivateKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Password == nil {
				m.Password = &core.DataSource{}
			}
			if err := m.Password.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OcspStaple", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OcspStaple == nil {
				m.OcspStaple = &core.DataSource{}
			}
			if err := m.OcspStaple.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignedCertificateTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignedCertificateTimestamp = append(m.SignedCertificateTimestamp, &core.DataSource{})
			if err := m.SignedCertificateTimestamp[len(m.SignedCertificateTimestamp)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TlsSessionTicketKeys) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsSessionTicketKeys: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsSessionTicketKeys: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, &core.DataSource{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificateValidationContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateValidationContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateValidationContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustedCa", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrustedCa == nil {
				m.TrustedCa = &core.DataSource{}
			}
			if err := m.TrustedCa.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateHash = append(m.VerifyCertificateHash, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateSpki", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateSpki = append(m.VerifyCertificateSpki, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifySubjectAltName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifySubjectAltName = append(m.VerifySubjectAltName, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireOcspStaple", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireOcspStaple == nil {
				m.RequireOcspStaple = &types.BoolValue{}
			}
			if err := m.RequireOcspStaple.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireSignedCertificateTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireSignedCertificateTimestamp == nil {
				m.RequireSignedCertificateTimestamp = &types.BoolValue{}
			}
			if err := m.RequireSignedCertificateTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Crl == nil {
				m.Crl = &core.DataSource{}
			}
			if err := m.Crl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowExpiredCertificate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowExpiredCertificate = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommonTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsParams == nil {
				m.TlsParams = &TlsParameters{}
			}
			if err := m.TlsParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCertificates = append(m.TlsCertificates, &TlsCertificate{})
			if err := m.TlsCertificates[len(m.TlsCertificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CertificateValidationContext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ValidationContextType = &CommonTlsContext_ValidationContext{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlpnProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlpnProtocols = append(m.AlpnProtocols, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificateSdsSecretConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCertificateSdsSecretConfigs = append(m.TlsCertificateSdsSecretConfigs, &SdsSecretConfig{})
			if err := m.TlsCertificateSdsSecretConfigs[len(m.TlsCertificateSdsSecretConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContextSdsSecretConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SdsSecretConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ValidationContextType = &CommonTlsContext_ValidationContextSdsSecretConfig{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CombinedValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CommonTlsContext_CombinedCertificateValidationContext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ValidationContextType = &CommonTlsContext_CombinedValidationContext{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommonTlsContext_CombinedCertificateValidationContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CombinedCertificateValidationContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CombinedCertificateValidationContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultValidationContext == nil {
				m.DefaultValidationContext = &CertificateValidationContext{}
			}
			if err := m.DefaultValidationContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContextSdsSecretConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidationContextSdsSecretConfig == nil {
				m.ValidationContextSdsSecretConfig = &SdsSecretConfig{}
			}
			if err := m.ValidationContextSdsSecretConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonTlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonTlsContext == nil {
				m.CommonTlsContext = &CommonTlsContext{}
			}
			if err := m.CommonTlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowRenegotiation", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowRenegotiation = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSessionKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxSessionKeys == nil {
				m.MaxSessionKeys = &types.UInt32Value{}
			}
			if err := m.MaxSessionKeys.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownstreamTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownstreamTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownstreamTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonTlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonTlsContext == nil {
				m.CommonTlsContext = &CommonTlsContext{}
			}
			if err := m.CommonTlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireClientCertificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireClientCertificate == nil {
				m.RequireClientCertificate = &types.BoolValue{}
			}
			if err := m.RequireClientCertificate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireSni", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireSni == nil {
				m.RequireSni = &types.BoolValue{}
			}
			if err := m.RequireSni.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsSessionTicketKeys{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeys{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeysSdsSecretConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SdsSecretConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeysSdsSecretConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SdsSecretConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SdsSecretConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SdsSecretConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SdsConfig == nil {
				m.SdsConfig = &core.ConfigSource{}
			}
			if err := m.SdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Secret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Secret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Secret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsCertificate{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_TlsCertificate{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsSessionTicketKeys{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_SessionTicketKeys{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CertificateValidationContext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_ValidationContext{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCert(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCert
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCert
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCert
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCert
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCert(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCert
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCert = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCert   = fmt.Errorf("proto: integer overflow")
)
