// Code generated by go-bindata.
// sources:
// ../../../testdata/config/attributes.yaml
// ../../../template/apikey/template.yaml
// ../../../template/authorization/template.yaml
// ../../../template/checknothing/template.yaml
// ../../../template/listentry/template.yaml
// ../../../template/logentry/template.yaml
// ../../../template/metric/template.yaml
// ../../../template/quota/template.yaml
// ../../../template/reportnothing/template.yaml
// ../../../template/tracespan/tracespan.yaml
// ../../../test/spyAdapter/template/apa/tmpl.yaml
// ../../../test/spyAdapter/template/checkoutput/tmpl.yaml
// DO NOT EDIT!

package test

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _TestdataConfigAttributesYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: istio-proxy
  namespace: istio-system
spec:
  attributes:
    origin.ip:
      valueType: IP_ADDRESS
    origin.uid:
      valueType: STRING
    origin.user:
      valueType: STRING
    request.headers:
      valueType: STRING_MAP
    request.id:
      valueType: STRING
    request.host:
      valueType: STRING
    request.method:
      valueType: STRING
    request.path:
      valueType: STRING
    request.url_path:
      valueType: STRING
    request.query_params:
      valueType: STRING_MAP
    request.reason:
      valueType: STRING
    request.referer:
      valueType: STRING
    request.scheme:
      valueType: STRING
    request.total_size:
      valueType: INT64
    request.size:
      valueType: INT64
    request.time:
      valueType: TIMESTAMP
    request.useragent:
      valueType: STRING
    response.code:
      valueType: INT64
    response.duration:
      valueType: DURATION
    response.headers:
      valueType: STRING_MAP
    response.total_size:
      valueType: INT64
    response.size:
      valueType: INT64
    response.time:
      valueType: TIMESTAMP
    response.grpc_status:
      valueType: STRING
    response.grpc_message:
      valueType: STRING
    source.uid:
      valueType: STRING
    source.user: # DEPRECATED
      valueType: STRING
    source.principal:
      valueType: STRING
    destination.uid:
      valueType: STRING
    destination.principal:
      valueType: STRING
    destination.port:
      valueType: INT64
    connection.event:
      valueType: STRING
    connection.id:
      valueType: STRING
    connection.received.bytes:
      valueType: INT64
    connection.received.bytes_total:
      valueType: INT64
    connection.sent.bytes:
      valueType: INT64
    connection.sent.bytes_total:
      valueType: INT64
    connection.duration:
      valueType: DURATION
    connection.mtls:
      valueType: BOOL
    connection.requested_server_name:
      valueType: STRING
    context.protocol:
      valueType: STRING
    context.proxy_error_code:
      valueType: STRING
    context.timestamp:
      valueType: TIMESTAMP
    context.time:
      valueType: TIMESTAMP
    # Deprecated, kept for compatibility
    context.reporter.local:
      valueType: BOOL
    context.reporter.kind:
      valueType: STRING
    context.reporter.uid:
      valueType: STRING
    api.service:
      valueType: STRING
    api.version:
      valueType: STRING
    api.operation:
      valueType: STRING
    api.protocol:
      valueType: STRING
    request.auth.principal:
      valueType: STRING
    request.auth.audiences:
      valueType: STRING
    request.auth.presenter:
      valueType: STRING
    request.auth.claims:
      valueType: STRING_MAP
    request.auth.raw_claims:
      valueType: STRING
    request.api_key:
      valueType: STRING
    rbac.permissive.response_code:
      valueType: STRING
    rbac.permissive.effective_policy_id:
      valueType: STRING
    check.error_code:
      valueType: INT64
    check.error_message:
      valueType: STRING
    check.cache_hit:
      valueType: BOOL
    quota.cache_hit:
      valueType: BOOL
---
apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: kubernetes
  namespace: istio-system
spec:
   attributes:
      source.ip:
        valueType: IP_ADDRESS
      source.labels:
        valueType: STRING_MAP
      source.name:
        valueType: STRING
      source.namespace:
        valueType: STRING
      source.owner:
        valueType: STRING
      source.serviceAccount:
        valueType: STRING
      source.services:
        valueType: STRING
      source.workload.uid:
        valueType: STRING
      source.workload.name:
        valueType: STRING
      source.workload.namespace:
        valueType: STRING
      destination.ip:
        valueType: IP_ADDRESS
      destination.labels:
        valueType: STRING_MAP
      destination.metadata:
        valueType: STRING_MAP
      destination.name:
        valueType: STRING
      destination.namespace:
        valueType: STRING
      destination.owner:
        valueType: STRING
      destination.service.uid:
        valueType: STRING
      destination.service.name:
        valueType: STRING
      destination.service.namespace:
        valueType: STRING
      destination.service.host:
        valueType: STRING
      destination.serviceAccount:
        valueType: STRING
      destination.workload.uid:
        valueType: STRING
      destination.workload.name:
        valueType: STRING
      destination.workload.namespace:
        valueType: STRING
      destination.container.name:
        valueType: STRING
`)

func TestdataConfigAttributesYamlBytes() ([]byte, error) {
	return _TestdataConfigAttributesYaml, nil
}

func TestdataConfigAttributesYaml() (*asset, error) {
	bytes, err := TestdataConfigAttributesYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../testdata/config/attributes.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateApikeyTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/apikey/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/apikey/template.yaml -n apikey
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: apikey
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateApikeyTemplateYamlBytes() ([]byte, error) {
	return _TemplateApikeyTemplateYaml, nil
}

func TemplateApikeyTemplateYaml() (*asset, error) {
	bytes, err := TemplateApikeyTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/apikey/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateAuthorizationTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/authorization/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/authorization/template.yaml -n authorization
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: authorization
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateAuthorizationTemplateYamlBytes() ([]byte, error) {
	return _TemplateAuthorizationTemplateYaml, nil
}

func TemplateAuthorizationTemplateYaml() (*asset, error) {
	bytes, err := TemplateAuthorizationTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/authorization/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateChecknothingTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/checknothing/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/checknothing/template.yaml -n checknothing
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: checknothing
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateChecknothingTemplateYamlBytes() ([]byte, error) {
	return _TemplateChecknothingTemplateYaml, nil
}

func TemplateChecknothingTemplateYaml() (*asset, error) {
	bytes, err := TemplateChecknothingTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/checknothing/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateListentryTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/listentry/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/listentry/template.yaml -n listentry
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: listentry
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateListentryTemplateYamlBytes() ([]byte, error) {
	return _TemplateListentryTemplateYaml, nil
}

func TemplateListentryTemplateYaml() (*asset, error) {
	bytes, err := TemplateListentryTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/listentry/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateLogentryTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/logentry/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/logentry/template.yaml -n logentry
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: logentry
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateLogentryTemplateYamlBytes() ([]byte, error) {
	return _TemplateLogentryTemplateYaml, nil
}

func TemplateLogentryTemplateYaml() (*asset, error) {
	bytes, err := TemplateLogentryTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/logentry/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateMetricTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/metric/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/metric/template.yaml -n metric
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: metric
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateMetricTemplateYamlBytes() ([]byte, error) {
	return _TemplateMetricTemplateYaml, nil
}

func TemplateMetricTemplateYaml() (*asset, error) {
	bytes, err := TemplateMetricTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/metric/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateQuotaTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/quota/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/quota/template.yaml -n quota
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: quota
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateQuotaTemplateYamlBytes() ([]byte, error) {
	return _TemplateQuotaTemplateYaml, nil
}

func TemplateQuotaTemplateYaml() (*asset, error) {
	bytes, err := TemplateQuotaTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/quota/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateReportnothingTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $GOPATH/src/istio.io/istio/mixer/template/reportnothing/template_handler_service.descriptor_set -o $GOPATH/src/istio.io/istio/mixer/template/reportnothing/template.yaml -n reportnothing
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: reportnothing
  namespace: istio-system
spec:
  descriptor: "Csv5AgogZ29vZ2xlL3Byb3RvYnVmL2Rlc2NyaXB0b3IucHJvdG8SD2dvb2dsZS5wcm90b2J1ZiJNChFGaWxlRGVzY3JpcHRvclNldBI4CgRmaWxlGAEgAygLMiQuZ29vZ2xlLnByb3RvYnVmLkZpbGVEZXNjcmlwdG9yUHJvdG9SBGZpbGUi5AQKE0ZpbGVEZXNjcmlwdG9yUHJvdG8SEgoEbmFtZRgBIAEoCVIEbmFtZRIYCgdwYWNrYWdlGAIgASgJUgdwYWNrYWdlEh4KCmRlcGVuZGVuY3kYAyADKAlSCmRlcGVuZGVuY3kSKwoRcHVibGljX2RlcGVuZGVuY3kYCiADKAVSEHB1YmxpY0RlcGVuZGVuY3kSJwoPd2Vha19kZXBlbmRlbmN5GAsgAygFUg53ZWFrRGVwZW5kZW5jeRJDCgxtZXNzYWdlX3R5cGUYBCADKAsyIC5nb29nbGUucHJvdG9idWYuRGVzY3JpcHRvclByb3RvUgttZXNzYWdlVHlwZRJBCgllbnVtX3R5cGUYBSADKAsyJC5nb29nbGUucHJvdG9idWYuRW51bURlc2NyaXB0b3JQcm90b1IIZW51bVR5cGUSQQoHc2VydmljZRgGIAMoCzInLmdvb2dsZS5wcm90b2J1Zi5TZXJ2aWNlRGVzY3JpcHRvclByb3RvUgdzZXJ2aWNlEkMKCWV4dGVuc2lvbhgHIAMoCzIlLmdvb2dsZS5wcm90b2J1Zi5GaWVsZERlc2NyaXB0b3JQcm90b1IJZXh0ZW5zaW9uEjYKB29wdGlvbnMYCCABKAsyHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnNSB29wdGlvbnMSSQoQc291cmNlX2NvZGVfaW5mbxgJIAEoCzIfLmdvb2dsZS5wcm90b2J1Zi5Tb3VyY2VDb2RlSW5mb1IOc291cmNlQ29kZUluZm8SFgoGc3ludGF4GAwgASgJUgZzeW50YXgiuQYKD0Rlc2NyaXB0b3JQcm90bxISCgRuYW1lGAEgASgJUgRuYW1lEjsKBWZpZWxkGAIgAygLMiUuZ29vZ2xlLnByb3RvYnVmLkZpZWxkRGVzY3JpcHRvclByb3RvUgVmaWVsZBJDCglleHRlbnNpb24YBiADKAsyJS5nb29nbGUucHJvdG9idWYuRmllbGREZXNjcmlwdG9yUHJvdG9SCWV4dGVuc2lvbhJBCgtuZXN0ZWRfdHlwZRgDIAMoCzIgLmdvb2dsZS5wcm90b2J1Zi5EZXNjcmlwdG9yUHJvdG9SCm5lc3RlZFR5cGUSQQoJZW51bV90eXBlGAQgAygLMiQuZ29vZ2xlLnByb3RvYnVmLkVudW1EZXNjcmlwdG9yUHJvdG9SCGVudW1UeXBlElgKD2V4dGVuc2lvbl9yYW5nZRgFIAMoCzIvLmdvb2dsZS5wcm90b2J1Zi5EZXNjcmlwdG9yUHJvdG8uRXh0ZW5zaW9uUmFuZ2VSDmV4dGVuc2lvblJhbmdlEkQKCm9uZW9mX2RlY2wYCCADKAsyJS5nb29nbGUucHJvdG9idWYuT25lb2ZEZXNjcmlwdG9yUHJvdG9SCW9uZW9mRGVjbBI5CgdvcHRpb25zGAcgASgLMh8uZ29vZ2xlLnByb3RvYnVmLk1lc3NhZ2VPcHRpb25zUgdvcHRpb25zElUKDnJlc2VydmVkX3JhbmdlGAkgAygLMi4uZ29vZ2xlLnByb3RvYnVmLkRlc2NyaXB0b3JQcm90by5SZXNlcnZlZFJhbmdlUg1yZXNlcnZlZFJhbmdlEiMKDXJlc2VydmVkX25hbWUYCiADKAlSDHJlc2VydmVkTmFtZRp6Cg5FeHRlbnNpb25SYW5nZRIUCgVzdGFydBgBIAEoBVIFc3RhcnQSEAoDZW5kGAIgASgFUgNlbmQSQAoHb3B0aW9ucxgDIAEoCzImLmdvb2dsZS5wcm90b2J1Zi5FeHRlbnNpb25SYW5nZU9wdGlvbnNSB29wdGlvbnMaNwoNUmVzZXJ2ZWRSYW5nZRIUCgVzdGFydBgBIAEoBVIFc3RhcnQSEAoDZW5kGAIgASgFUgNlbmQifAoVRXh0ZW5zaW9uUmFuZ2VPcHRpb25zElgKFHVuaW50ZXJwcmV0ZWRfb3B0aW9uGOcHIAMoCzIkLmdvb2dsZS5wcm90b2J1Zi5VbmludGVycHJldGVkT3B0aW9uUhN1bmludGVycHJldGVkT3B0aW9uKgkI6AcQgICAgAIimAYKFEZpZWxkRGVzY3JpcHRvclByb3RvEhIKBG5hbWUYASABKAlSBG5hbWUSFgoGbnVtYmVyGAMgASgFUgZudW1iZXISQQoFbGFiZWwYBCABKA4yKy5nb29nbGUucHJvdG9idWYuRmllbGREZXNjcmlwdG9yUHJvdG8uTGFiZWxSBWxhYmVsEj4KBHR5cGUYBSABKA4yKi5nb29nbGUucHJvdG9idWYuRmllbGREZXNjcmlwdG9yUHJvdG8uVHlwZVIEdHlwZRIbCgl0eXBlX25hbWUYBiABKAlSCHR5cGVOYW1lEhoKCGV4dGVuZGVlGAIgASgJUghleHRlbmRlZRIjCg1kZWZhdWx0X3ZhbHVlGAcgASgJUgxkZWZhdWx0VmFsdWUSHwoLb25lb2ZfaW5kZXgYCSABKAVSCm9uZW9mSW5kZXgSGwoJanNvbl9uYW1lGAogASgJUghqc29uTmFtZRI3CgdvcHRpb25zGAggASgLMh0uZ29vZ2xlLnByb3RvYnVmLkZpZWxkT3B0aW9uc1IHb3B0aW9ucyK2AgoEVHlwZRIPCgtUWVBFX0RPVUJMRRABEg4KClRZUEVfRkxPQVQQAhIOCgpUWVBFX0lOVDY0EAMSDwoLVFlQRV9VSU5UNjQQBBIOCgpUWVBFX0lOVDMyEAUSEAoMVFlQRV9GSVhFRDY0EAYSEAoMVFlQRV9GSVhFRDMyEAcSDQoJVFlQRV9CT09MEAgSDwoLVFlQRV9TVFJJTkcQCRIOCgpUWVBFX0dST1VQEAoSEAoMVFlQRV9NRVNTQUdFEAsSDgoKVFlQRV9CWVRFUxAMEg8KC1RZUEVfVUlOVDMyEA0SDQoJVFlQRV9FTlVNEA4SEQoNVFlQRV9TRklYRUQzMhAPEhEKDVRZUEVfU0ZJWEVENjQQEBIPCgtUWVBFX1NJTlQzMhAREg8KC1RZUEVfU0lOVDY0EBIiQwoFTGFiZWwSEgoOTEFCRUxfT1BUSU9OQUwQARISCg5MQUJFTF9SRVFVSVJFRBACEhIKDkxBQkVMX1JFUEVBVEVEEAMiYwoUT25lb2ZEZXNjcmlwdG9yUHJvdG8SEgoEbmFtZRgBIAEoCVIEbmFtZRI3CgdvcHRpb25zGAIgASgLMh0uZ29vZ2xlLnByb3RvYnVmLk9uZW9mT3B0aW9uc1IHb3B0aW9ucyLjAgoTRW51bURlc2NyaXB0b3JQcm90bxISCgRuYW1lGAEgASgJUgRuYW1lEj8KBXZhbHVlGAIgAygLMikuZ29vZ2xlLnByb3RvYnVmLkVudW1WYWx1ZURlc2NyaXB0b3JQcm90b1IFdmFsdWUSNgoHb3B0aW9ucxgDIAEoCzIcLmdvb2dsZS5wcm90b2J1Zi5FbnVtT3B0aW9uc1IHb3B0aW9ucxJdCg5yZXNlcnZlZF9yYW5nZRgEIAMoCzI2Lmdvb2dsZS5wcm90b2J1Zi5FbnVtRGVzY3JpcHRvclByb3RvLkVudW1SZXNlcnZlZFJhbmdlUg1yZXNlcnZlZFJhbmdlEiMKDXJlc2VydmVkX25hbWUYBSADKAlSDHJlc2VydmVkTmFtZRo7ChFFbnVtUmVzZXJ2ZWRSYW5nZRIUCgVzdGFydBgBIAEoBVIFc3RhcnQSEAoDZW5kGAIgASgFUgNlbmQigwEKGEVudW1WYWx1ZURlc2NyaXB0b3JQcm90bxISCgRuYW1lGAEgASgJUgRuYW1lEhYKBm51bWJlchgCIAEoBVIGbnVtYmVyEjsKB29wdGlvbnMYAyABKAsyIS5nb29nbGUucHJvdG9idWYuRW51bVZhbHVlT3B0aW9uc1IHb3B0aW9ucyKnAQoWU2VydmljZURlc2NyaXB0b3JQcm90bxISCgRuYW1lGAEgASgJUgRuYW1lEj4KBm1ldGhvZBgCIAMoCzImLmdvb2dsZS5wcm90b2J1Zi5NZXRob2REZXNjcmlwdG9yUHJvdG9SBm1ldGhvZBI5CgdvcHRpb25zGAMgASgLMh8uZ29vZ2xlLnByb3RvYnVmLlNlcnZpY2VPcHRpb25zUgdvcHRpb25zIokCChVNZXRob2REZXNjcmlwdG9yUHJvdG8SEgoEbmFtZRgBIAEoCVIEbmFtZRIdCgppbnB1dF90eXBlGAIgASgJUglpbnB1dFR5cGUSHwoLb3V0cHV0X3R5cGUYAyABKAlSCm91dHB1dFR5cGUSOAoHb3B0aW9ucxgEIAEoCzIeLmdvb2dsZS5wcm90b2J1Zi5NZXRob2RPcHRpb25zUgdvcHRpb25zEjAKEGNsaWVudF9zdHJlYW1pbmcYBSABKAg6BWZhbHNlUg9jbGllbnRTdHJlYW1pbmcSMAoQc2VydmVyX3N0cmVhbWluZxgGIAEoCDoFZmFsc2VSD3NlcnZlclN0cmVhbWluZyKSCQoLRmlsZU9wdGlvbnMSIQoMamF2YV9wYWNrYWdlGAEgASgJUgtqYXZhUGFja2FnZRIwChRqYXZhX291dGVyX2NsYXNzbmFtZRgIIAEoCVISamF2YU91dGVyQ2xhc3NuYW1lEjUKE2phdmFfbXVsdGlwbGVfZmlsZXMYCiABKAg6BWZhbHNlUhFqYXZhTXVsdGlwbGVGaWxlcxJECh1qYXZhX2dlbmVyYXRlX2VxdWFsc19hbmRfaGFzaBgUIAEoCEICGAFSGWphdmFHZW5lcmF0ZUVxdWFsc0FuZEhhc2gSOgoWamF2YV9zdHJpbmdfY2hlY2tfdXRmOBgbIAEoCDoFZmFsc2VSE2phdmFTdHJpbmdDaGVja1V0ZjgSUwoMb3B0aW1pemVfZm9yGAkgASgOMikuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zLk9wdGltaXplTW9kZToFU1BFRURSC29wdGltaXplRm9yEh0KCmdvX3BhY2thZ2UYCyABKAlSCWdvUGFja2FnZRI1ChNjY19nZW5lcmljX3NlcnZpY2VzGBAgASgIOgVmYWxzZVIRY2NHZW5lcmljU2VydmljZXMSOQoVamF2YV9nZW5lcmljX3NlcnZpY2VzGBEgASgIOgVmYWxzZVITamF2YUdlbmVyaWNTZXJ2aWNlcxI1ChNweV9nZW5lcmljX3NlcnZpY2VzGBIgASgIOgVmYWxzZVIRcHlHZW5lcmljU2VydmljZXMSNwoUcGhwX2dlbmVyaWNfc2VydmljZXMYKiABKAg6BWZhbHNlUhJwaHBHZW5lcmljU2VydmljZXMSJQoKZGVwcmVjYXRlZBgXIAEoCDoFZmFsc2VSCmRlcHJlY2F0ZWQSLwoQY2NfZW5hYmxlX2FyZW5hcxgfIAEoCDoFZmFsc2VSDmNjRW5hYmxlQXJlbmFzEioKEW9iamNfY2xhc3NfcHJlZml4GCQgASgJUg9vYmpjQ2xhc3NQcmVmaXgSKQoQY3NoYXJwX25hbWVzcGFjZRglIAEoCVIPY3NoYXJwTmFtZXNwYWNlEiEKDHN3aWZ0X3ByZWZpeBgnIAEoCVILc3dpZnRQcmVmaXgSKAoQcGhwX2NsYXNzX3ByZWZpeBgoIAEoCVIOcGhwQ2xhc3NQcmVmaXgSIwoNcGhwX25hbWVzcGFjZRgpIAEoCVIMcGhwTmFtZXNwYWNlEjQKFnBocF9tZXRhZGF0YV9uYW1lc3BhY2UYLCABKAlSFHBocE1ldGFkYXRhTmFtZXNwYWNlEiEKDHJ1YnlfcGFja2FnZRgtIAEoCVILcnVieVBhY2thZ2USWAoUdW5pbnRlcnByZXRlZF9vcHRpb24Y5wcgAygLMiQuZ29vZ2xlLnByb3RvYnVmLlVuaW50ZXJwcmV0ZWRPcHRpb25SE3VuaW50ZXJwcmV0ZWRPcHRpb24iOgoMT3B0aW1pemVNb2RlEgkKBVNQRUVEEAESDQoJQ09ERV9TSVpFEAISEAoMTElURV9SVU5USU1FEAMqCQjoBxCAgICAAkoECCYQJyLRAgoOTWVzc2FnZU9wdGlvbnMSPAoXbWVzc2FnZV9zZXRfd2lyZV9mb3JtYXQYASABKAg6BWZhbHNlUhRtZXNzYWdlU2V0V2lyZUZvcm1hdBJMCh9ub19zdGFuZGFyZF9kZXNjcmlwdG9yX2FjY2Vzc29yGAIgASgIOgVmYWxzZVIcbm9TdGFuZGFyZERlc2NyaXB0b3JBY2Nlc3NvchIlCgpkZXByZWNhdGVkGAMgASgIOgVmYWxzZVIKZGVwcmVjYXRlZBIbCgltYXBfZW50cnkYByABKAhSCG1hcEVudHJ5ElgKFHVuaW50ZXJwcmV0ZWRfb3B0aW9uGOcHIAMoCzIkLmdvb2dsZS5wcm90b2J1Zi5VbmludGVycHJldGVkT3B0aW9uUhN1bmludGVycHJldGVkT3B0aW9uKgkI6AcQgICAgAJKBAgIEAlKBAgJEAoi4gMKDEZpZWxkT3B0aW9ucxJBCgVjdHlwZRgBIAEoDjIjLmdvb2dsZS5wcm90b2J1Zi5GaWVsZE9wdGlvbnMuQ1R5cGU6BlNUUklOR1IFY3R5cGUSFgoGcGFja2VkGAIgASgIUgZwYWNrZWQSRwoGanN0eXBlGAYgASgOMiQuZ29vZ2xlLnByb3RvYnVmLkZpZWxkT3B0aW9ucy5KU1R5cGU6CUpTX05PUk1BTFIGanN0eXBlEhkKBGxhenkYBSABKAg6BWZhbHNlUgRsYXp5EiUKCmRlcHJlY2F0ZWQYAyABKAg6BWZhbHNlUgpkZXByZWNhdGVkEhkKBHdlYWsYCiABKAg6BWZhbHNlUgR3ZWFrElgKFHVuaW50ZXJwcmV0ZWRfb3B0aW9uGOcHIAMoCzIkLmdvb2dsZS5wcm90b2J1Zi5VbmludGVycHJldGVkT3B0aW9uUhN1bmludGVycHJldGVkT3B0aW9uIi8KBUNUeXBlEgoKBlNUUklORxAAEggKBENPUkQQARIQCgxTVFJJTkdfUElFQ0UQAiI1CgZKU1R5cGUSDQoJSlNfTk9STUFMEAASDQoJSlNfU1RSSU5HEAESDQoJSlNfTlVNQkVSEAIqCQjoBxCAgICAAkoECAQQBSJzCgxPbmVvZk9wdGlvbnMSWAoUdW5pbnRlcnByZXRlZF9vcHRpb24Y5wcgAygLMiQuZ29vZ2xlLnByb3RvYnVmLlVuaW50ZXJwcmV0ZWRPcHRpb25SE3VuaW50ZXJwcmV0ZWRPcHRpb24qCQjoBxCAgICAAiLAAQoLRW51bU9wdGlvbnMSHwoLYWxsb3dfYWxpYXMYAiABKAhSCmFsbG93QWxpYXMSJQoKZGVwcmVjYXRlZBgDIAEoCDoFZmFsc2VSCmRlcHJlY2F0ZWQSWAoUdW5pbnRlcnByZXRlZF9vcHRpb24Y5wcgAygLMiQuZ29vZ2xlLnByb3RvYnVmLlVuaW50ZXJwcmV0ZWRPcHRpb25SE3VuaW50ZXJwcmV0ZWRPcHRpb24qCQjoBxCAgICAAkoECAUQBiKeAQoQRW51bVZhbHVlT3B0aW9ucxIlCgpkZXByZWNhdGVkGAEgASgIOgVmYWxzZVIKZGVwcmVjYXRlZBJYChR1bmludGVycHJldGVkX29wdGlvbhjnByADKAsyJC5nb29nbGUucHJvdG9idWYuVW5pbnRlcnByZXRlZE9wdGlvblITdW5pbnRlcnByZXRlZE9wdGlvbioJCOgHEICAgIACIpwBCg5TZXJ2aWNlT3B0aW9ucxIlCgpkZXByZWNhdGVkGCEgASgIOgVmYWxzZVIKZGVwcmVjYXRlZBJYChR1bmludGVycHJldGVkX29wdGlvbhjnByADKAsyJC5nb29nbGUucHJvdG9idWYuVW5pbnRlcnByZXRlZE9wdGlvblITdW5pbnRlcnByZXRlZE9wdGlvbioJCOgHEICAgIACIuACCg1NZXRob2RPcHRpb25zEiUKCmRlcHJlY2F0ZWQYISABKAg6BWZhbHNlUgpkZXByZWNhdGVkEnEKEWlkZW1wb3RlbmN5X2xldmVsGCIgASgOMi8uZ29vZ2xlLnByb3RvYnVmLk1ldGhvZE9wdGlvbnMuSWRlbXBvdGVuY3lMZXZlbDoTSURFTVBPVEVOQ1lfVU5LTk9XTlIQaWRlbXBvdGVuY3lMZXZlbBJYChR1bmludGVycHJldGVkX29wdGlvbhjnByADKAsyJC5nb29nbGUucHJvdG9idWYuVW5pbnRlcnByZXRlZE9wdGlvblITdW5pbnRlcnByZXRlZE9wdGlvbiJQChBJZGVtcG90ZW5jeUxldmVsEhcKE0lERU1QT1RFTkNZX1VOS05PV04QABITCg9OT19TSURFX0VGRkVDVFMQARIOCgpJREVNUE9URU5UEAIqCQjoBxCAgICAAiKaAwoTVW5pbnRlcnByZXRlZE9wdGlvbhJBCgRuYW1lGAIgAygLMi0uZ29vZ2xlLnByb3RvYnVmLlVuaW50ZXJwcmV0ZWRPcHRpb24uTmFtZVBhcnRSBG5hbWUSKQoQaWRlbnRpZmllcl92YWx1ZRgDIAEoCVIPaWRlbnRpZmllclZhbHVlEiwKEnBvc2l0aXZlX2ludF92YWx1ZRgEIAEoBFIQcG9zaXRpdmVJbnRWYWx1ZRIsChJuZWdhdGl2ZV9pbnRfdmFsdWUYBSABKANSEG5lZ2F0aXZlSW50VmFsdWUSIQoMZG91YmxlX3ZhbHVlGAYgASgBUgtkb3VibGVWYWx1ZRIhCgxzdHJpbmdfdmFsdWUYByABKAxSC3N0cmluZ1ZhbHVlEicKD2FnZ3JlZ2F0ZV92YWx1ZRgIIAEoCVIOYWdncmVnYXRlVmFsdWUaSgoITmFtZVBhcnQSGwoJbmFtZV9wYXJ0GAEgAigJUghuYW1lUGFydBIhCgxpc19leHRlbnNpb24YAiACKAhSC2lzRXh0ZW5zaW9uIqcCCg5Tb3VyY2VDb2RlSW5mbxJECghsb2NhdGlvbhgBIAMoCzIoLmdvb2dsZS5wcm90b2J1Zi5Tb3VyY2VDb2RlSW5mby5Mb2NhdGlvblIIbG9jYXRpb24azgEKCExvY2F0aW9uEhYKBHBhdGgYASADKAVCAhABUgRwYXRoEhYKBHNwYW4YAiADKAVCAhABUgRzcGFuEikKEGxlYWRpbmdfY29tbWVudHMYAyABKAlSD2xlYWRpbmdDb21tZW50cxIrChF0cmFpbGluZ19jb21tZW50cxgEIAEoCVIQdHJhaWxpbmdDb21tZW50cxI6ChlsZWFkaW5nX2RldGFjaGVkX2NvbW1lbnRzGAYgAygJUhdsZWFkaW5nRGV0YWNoZWRDb21tZW50cyLRAQoRR2VuZXJhdGVkQ29kZUluZm8STQoKYW5ub3RhdGlvbhgBIAMoCzItLmdvb2dsZS5wcm90b2J1Zi5HZW5lcmF0ZWRDb2RlSW5mby5Bbm5vdGF0aW9uUgphbm5vdGF0aW9uGm0KCkFubm90YXRpb24SFgoEcGF0aBgBIAMoBUICEAFSBHBhdGgSHwoLc291cmNlX2ZpbGUYAiABKAlSCnNvdXJjZUZpbGUSFAoFYmVnaW4YAyABKAVSBWJlZ2luEhAKA2VuZBgEIAEoBVIDZW5kQo8BChNjb20uZ29vZ2xlLnByb3RvYnVmQhBEZXNjcmlwdG9yUHJvdG9zSAFaPmdpdGh1Yi5jb20vZ29sYW5nL3Byb3RvYnVmL3Byb3RvYy1nZW4tZ28vZGVzY3JpcHRvcjtkZXNjcmlwdG9y+AEBogIDR1BCqgIaR29vZ2xlLlByb3RvYnVmLlJlZmxlY3Rpb25KrL4CCgcSBScA8gYBCqoPCgEMEgMnABIywQwgUHJvdG9jb2wgQnVmZmVycyAtIEdvb2dsZSdzIGRhdGEgaW50ZXJjaGFuZ2UgZm9ybWF0CiBDb3B5cmlnaHQgMjAwOCBHb29nbGUgSW5jLiAgQWxsIHJpZ2h0cyByZXNlcnZlZC4KIGh0dHBzOi8vZGV2ZWxvcGVycy5nb29nbGUuY29tL3Byb3RvY29sLWJ1ZmZlcnMvCgogUmVkaXN0cmlidXRpb24gYW5kIHVzZSBpbiBzb3VyY2UgYW5kIGJpbmFyeSBmb3Jtcywgd2l0aCBvciB3aXRob3V0CiBtb2RpZmljYXRpb24sIGFyZSBwZXJtaXR0ZWQgcHJvdmlkZWQgdGhhdCB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnMgYXJlCiBtZXQ6CgogICAgICogUmVkaXN0cmlidXRpb25zIG9mIHNvdXJjZSBjb2RlIG11c3QgcmV0YWluIHRoZSBhYm92ZSBjb3B5cmlnaHQKIG5vdGljZSwgdGhpcyBsaXN0IG9mIGNvbmRpdGlvbnMgYW5kIHRoZSBmb2xsb3dpbmcgZGlzY2xhaW1lci4KICAgICAqIFJlZGlzdHJpYnV0aW9ucyBpbiBiaW5hcnkgZm9ybSBtdXN0IHJlcHJvZHVjZSB0aGUgYWJvdmUKIGNvcHlyaWdodCBub3RpY2UsIHRoaXMgbGlzdCBvZiBjb25kaXRpb25zIGFuZCB0aGUgZm9sbG93aW5nIGRpc2NsYWltZXIKIGluIHRoZSBkb2N1bWVudGF0aW9uIGFuZC9vciBvdGhlciBtYXRlcmlhbHMgcHJvdmlkZWQgd2l0aCB0aGUKIGRpc3RyaWJ1dGlvbi4KICAgICAqIE5laXRoZXIgdGhlIG5hbWUgb2YgR29vZ2xlIEluYy4gbm9yIHRoZSBuYW1lcyBvZiBpdHMKIGNvbnRyaWJ1dG9ycyBtYXkgYmUgdXNlZCB0byBlbmRvcnNlIG9yIHByb21vdGUgcHJvZHVjdHMgZGVyaXZlZCBmcm9tCiB0aGlzIHNvZnR3YXJlIHdpdGhvdXQgc3BlY2lmaWMgcHJpb3Igd3JpdHRlbiBwZXJtaXNzaW9uLgoKIFRISVMgU09GVFdBUkUgSVMgUFJPVklERUQgQlkgVEhFIENPUFlSSUdIVCBIT0xERVJTIEFORCBDT05UUklCVVRPUlMKICJBUyBJUyIgQU5EIEFOWSBFWFBSRVNTIE9SIElNUExJRUQgV0FSUkFOVElFUywgSU5DTFVESU5HLCBCVVQgTk9UCiBMSU1JVEVEIFRPLCBUSEUgSU1QTElFRCBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSBBTkQgRklUTkVTUyBGT1IKIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFSRSBESVNDTEFJTUVELiBJTiBOTyBFVkVOVCBTSEFMTCBUSEUgQ09QWVJJR0hUCiBPV05FUiBPUiBDT05UUklCVVRPUlMgQkUgTElBQkxFIEZPUiBBTlkgRElSRUNULCBJTkRJUkVDVCwgSU5DSURFTlRBTCwKIFNQRUNJQUwsIEVYRU1QTEFSWSwgT1IgQ09OU0VRVUVOVElBTCBEQU1BR0VTIChJTkNMVURJTkcsIEJVVCBOT1QKIExJTUlURUQgVE8sIFBST0NVUkVNRU5UIE9GIFNVQlNUSVRVVEUgR09PRFMgT1IgU0VSVklDRVM7IExPU1MgT0YgVVNFLAogREFUQSwgT1IgUFJPRklUUzsgT1IgQlVTSU5FU1MgSU5URVJSVVBUSU9OKSBIT1dFVkVSIENBVVNFRCBBTkQgT04gQU5ZCiBUSEVPUlkgT0YgTElBQklMSVRZLCBXSEVUSEVSIElOIENPTlRSQUNULCBTVFJJQ1QgTElBQklMSVRZLCBPUiBUT1JUCiAoSU5DTFVESU5HIE5FR0xJR0VOQ0UgT1IgT1RIRVJXSVNFKSBBUklTSU5HIElOIEFOWSBXQVkgT1VUIE9GIFRIRSBVU0UKIE9GIFRISVMgU09GVFdBUkUsIEVWRU4gSUYgQURWSVNFRCBPRiBUSEUgUE9TU0lCSUxJVFkgT0YgU1VDSCBEQU1BR0UuCjLbAiBBdXRob3I6IGtlbnRvbkBnb29nbGUuY29tIChLZW50b24gVmFyZGEpCiAgQmFzZWQgb24gb3JpZ2luYWwgUHJvdG9jb2wgQnVmZmVycyBkZXNpZ24gYnkKICBTYW5qYXkgR2hlbWF3YXQsIEplZmYgRGVhbiwgYW5kIG90aGVycy4KCiBUaGUgbWVzc2FnZXMgaW4gdGhpcyBmaWxlIGRlc2NyaWJlIHRoZSBkZWZpbml0aW9ucyBmb3VuZCBpbiAucHJvdG8gZmlsZXMuCiBBIHZhbGlkIC5wcm90byBmaWxlIGNhbiBiZSB0cmFuc2xhdGVkIGRpcmVjdGx5IHRvIGEgRmlsZURlc2NyaXB0b3JQcm90bwogd2l0aG91dCBhbnkgb3RoZXIgaW5mb3JtYXRpb24gKGUuZy4gd2l0aG91dCByZWFkaW5nIGl0cyBpbXBvcnRzKS4KCggKAQISAykIFwoICgEIEgMqAFUKCQoCCAsSAyoAVQoICgEIEgMrACwKCQoCCAESAysALAoICgEIEgMsADEKCQoCCAgSAywAMQoICgEIEgMtADcKCQoCCCUSAy0ANwoICgEIEgMuACEKCQoCCCQSAy4AIQoICgEIEgMvAB8KCQoCCB8SAy8AHwoICgEIEgMzABwKfwoCCAkSAzMAHBp0IGRlc2NyaXB0b3IucHJvdG8gbXVzdCBiZSBvcHRpbWl6ZWQgZm9yIHNwZWVkIGJlY2F1c2UgcmVmbGVjdGlvbi1iYXNlZAogYWxnb3JpdGhtcyBkb24ndCB3b3JrIGR1cmluZyBib290c3RyYXBwaW5nLgoKagoCBAASBDcAOQEaXiBUaGUgcHJvdG9jb2wgY29tcGlsZXIgY2FuIG91dHB1dCBhIEZpbGVEZXNjcmlwdG9yU2V0IGNvbnRhaW5pbmcgdGhlIC5wcm90bwogZmlsZXMgaXQgcGFyc2VzLgoKCgoDBAABEgM3CBkKCwoEBAACABIDOAIoCgwKBQQAAgAEEgM4AgoKDAoFBAACAAYSAzgLHgoMCgUEAAIAARIDOB8jCgwKBQQAAgADEgM4JicKLwoCBAESBDwAWQEaIyBEZXNjcmliZXMgYSBjb21wbGV0ZSAucHJvdG8gZmlsZS4KCgoKAwQBARIDPAgbCjkKBAQBAgASAz0CGyIsIGZpbGUgbmFtZSwgcmVsYXRpdmUgdG8gcm9vdCBvZiBzb3VyY2UgdHJlZQoKDAoFBAECAAQSAz0CCgoMCgUEAQIABRIDPQsRCgwKBQQBAgABEgM9EhYKDAoFBAECAAMSAz0ZGgoqCgQEAQIBEgM+Ah4iHSBlLmcuICJmb28iLCAiZm9vLmJhciIsIGV0Yy4KCgwKBQQBAgEEEgM+AgoKDAoFBAECAQUSAz4LEQoMCgUEAQIBARIDPhIZCgwKBQQBAgEDEgM+HB0KNAoEBAECAhIDQQIhGicgTmFtZXMgb2YgZmlsZXMgaW1wb3J0ZWQgYnkgdGhpcyBmaWxlLgoKDAoFBAECAgQSA0ECCgoMCgUEAQICBRIDQQsRCgwKBQQBAgIBEgNBEhwKDAoFBAECAgMSA0EfIApRCgQEAQIDEgNDAigaRCBJbmRleGVzIG9mIHRoZSBwdWJsaWMgaW1wb3J0ZWQgZmlsZXMgaW4gdGhlIGRlcGVuZGVuY3kgbGlzdCBhYm92ZS4KCgwKBQQBAgMEEgNDAgoKDAoFBAECAwUSA0MLEAoMCgUEAQIDARIDQxEiCgwKBQQBAgMDEgNDJScKegoEBAECBBIDRgImGm0gSW5kZXhlcyBvZiB0aGUgd2VhayBpbXBvcnRlZCBmaWxlcyBpbiB0aGUgZGVwZW5kZW5jeSBsaXN0LgogRm9yIEdvb2dsZS1pbnRlcm5hbCBtaWdyYXRpb24gb25seS4gRG8gbm90IHVzZS4KCgwKBQQBAgQEEgNGAgoKDAoFBAECBAUSA0YLEAoMCgUEAQIEARIDRhEgCgwKBQQBAgQDEgNGIyUKNgoEBAECBRIDSQIsGikgQWxsIHRvcC1sZXZlbCBkZWZpbml0aW9ucyBpbiB0aGlzIGZpbGUuCgoMCgUEAQIFBBIDSQIKCgwKBQQBAgUGEgNJCxoKDAoFBAECBQESA0kbJwoMCgUEAQIFAxIDSSorCgsKBAQBAgYSA0oCLQoMCgUEAQIGBBIDSgIKCgwKBQQBAgYGEgNKCx4KDAoFBAECBgESA0ofKAoMCgUEAQIGAxIDSissCgsKBAQBAgcSA0sCLgoMCgUEAQIHBBIDSwIKCgwKBQQBAgcGEgNLCyEKDAoFBAECBwESA0siKQoMCgUEAQIHAxIDSywtCgsKBAQBAggSA0wCLgoMCgUEAQIIBBIDTAIKCgwKBQQBAggGEgNMCx8KDAoFBAECCAESA0wgKQoMCgUEAQIIAxIDTCwtCgsKBAQBAgkSA04CIwoMCgUEAQIJBBIDTgIKCgwKBQQBAgkGEgNOCxYKDAoFBAECCQESA04XHgoMCgUEAQIJAxIDTiEiCvQBCgQEAQIKEgNUAi8a5gEgVGhpcyBmaWVsZCBjb250YWlucyBvcHRpb25hbCBpbmZvcm1hdGlvbiBhYm91dCB0aGUgb3JpZ2luYWwgc291cmNlIGNvZGUuCiBZb3UgbWF5IHNhZmVseSByZW1vdmUgdGhpcyBlbnRpcmUgZmllbGQgd2l0aG91dCBoYXJtaW5nIHJ1bnRpbWUKIGZ1bmN0aW9uYWxpdHkgb2YgdGhlIGRlc2NyaXB0b3JzIC0tIHRoZSBpbmZvcm1hdGlvbiBpcyBuZWVkZWQgb25seSBieQogZGV2ZWxvcG1lbnQgdG9vbHMuCgoMCgUEAQIKBBIDVAIKCgwKBQQBAgoGEgNUCxkKDAoFBAECCgESA1QaKgoMCgUEAQIKAxIDVC0uCl0KBAQBAgsSA1gCHhpQIFRoZSBzeW50YXggb2YgdGhlIHByb3RvIGZpbGUuCiBUaGUgc3VwcG9ydGVkIHZhbHVlcyBhcmUgInByb3RvMiIgYW5kICJwcm90bzMiLgoKDAoFBAECCwQSA1gCCgoMCgUEAQILBRIDWAsRCgwKBQQBAgsBEgNYEhgKDAoFBAECCwMSA1gbHQonCgIEAhIEXAB8ARobIERlc2NyaWJlcyBhIG1lc3NhZ2UgdHlwZS4KCgoKAwQCARIDXAgXCgsKBAQCAgASA10CGwoMCgUEAgIABBIDXQIKCgwKBQQCAgAFEgNdCxEKDAoFBAICAAESA10SFgoMCgUEAgIAAxIDXRkaCgsKBAQCAgESA18CKgoMCgUEAgIBBBIDXwIKCgwKBQQCAgEGEgNfCx8KDAoFBAICAQESA18gJQoMCgUEAgIBAxIDXygpCgsKBAQCAgISA2ACLgoMCgUEAgICBBIDYAIKCgwKBQQCAgIGEgNgCx8KDAoFBAICAgESA2AgKQoMCgUEAgICAxIDYCwtCgsKBAQCAgMSA2ICKwoMCgUEAgIDBBIDYgIKCgwKBQQCAgMGEgNiCxoKDAoFBAICAwESA2IbJgoMCgUEAgIDAxIDYikqCgsKBAQCAgQSA2MCLQoMCgUEAgIEBBIDYwIKCgwKBQQCAgQGEgNjCx4KDAoFBAICBAESA2MfKAoMCgUEAgIEAxIDYyssCgwKBAQCAwASBGUCagMKDAoFBAIDAAESA2UKGAoNCgYEAgMAAgASA2YEHQoOCgcEAgMAAgAEEgNmBAwKDgoHBAIDAAIABRIDZg0SCg4KBwQCAwACAAESA2YTGAoOCgcEAgMAAgADEgNmGxwKDQoGBAIDAAIBEgNnBBsKDgoHBAIDAAIBBBIDZwQMCg4KBwQCAwACAQUSA2cNEgoOCgcEAgMAAgEBEgNnExYKDgoHBAIDAAIBAxIDZxkaCg0KBgQCAwACAhIDaQQvCg4KBwQCAwACAgQSA2kEDAoOCgcEAgMAAgIGEgNpDSIKDgoHBAIDAAICARIDaSMqCg4KBwQCAwACAgMSA2ktLgoLCgQEAgIFEgNrAi4KDAoFBAICBQQSA2sCCgoMCgUEAgIFBhIDawsZCgwKBQQCAgUBEgNrGikKDAoFBAICBQMSA2ssLQoLCgQEAgIGEgNtAi8KDAoFBAICBgQSA20CCgoMCgUEAgIGBhIDbQsfCgwKBQQCAgYBEgNtICoKDAoFBAICBgMSA20tLgoLCgQEAgIHEgNvAiYKDAoFBAICBwQSA28CCgoMCgUEAgIHBhIDbwsZCgwKBQQCAgcBEgNvGiEKDAoFBAICBwMSA28kJQqqAQoEBAIDARIEdAJ3AxqbASBSYW5nZSBvZiByZXNlcnZlZCB0YWcgbnVtYmVycy4gUmVzZXJ2ZWQgdGFnIG51bWJlcnMgbWF5IG5vdCBiZSB1c2VkIGJ5CiBmaWVsZHMgb3IgZXh0ZW5zaW9uIHJhbmdlcyBpbiB0aGUgc2FtZSBtZXNzYWdlLiBSZXNlcnZlZCByYW5nZXMgbWF5CiBub3Qgb3ZlcmxhcC4KCgwKBQQCAwEBEgN0ChcKGwoGBAIDAQIAEgN1BB0iDCBJbmNsdXNpdmUuCgoOCgcEAgMBAgAEEgN1BAwKDgoHBAIDAQIABRIDdQ0SCg4KBwQCAwECAAESA3UTGAoOCgcEAgMBAgADEgN1GxwKGwoGBAIDAQIBEgN2BBsiDCBFeGNsdXNpdmUuCgoOCgcEAgMBAgEEEgN2BAwKDgoHBAIDAQIBBRIDdg0SCg4KBwQCAwECAQESA3YTFgoOCgcEAgMBAgEDEgN2GRoKCwoEBAICCBIDeAIsCgwKBQQCAggEEgN4AgoKDAoFBAICCAYSA3gLGAoMCgUEAgIIARIDeBknCgwKBQQCAggDEgN4KisKggEKBAQCAgkSA3sCJRp1IFJlc2VydmVkIGZpZWxkIG5hbWVzLCB3aGljaCBtYXkgbm90IGJlIHVzZWQgYnkgZmllbGRzIGluIHRoZSBzYW1lIG1lc3NhZ2UuCiBBIGdpdmVuIG5hbWUgbWF5IG9ubHkgYmUgcmVzZXJ2ZWQgb25jZS4KCgwKBQQCAgkEEgN7AgoKDAoFBAICCQUSA3sLEQoMCgUEAgIJARIDexIfCgwKBQQCAgkDEgN7IiQKCwoCBAMSBX4AhAEBCgoKAwQDARIDfggdCk8KBAQDAgASBIABAjoaQSBUaGUgcGFyc2VyIHN0b3JlcyBvcHRpb25zIGl0IGRvZXNuJ3QgcmVjb2duaXplIGhlcmUuIFNlZSBhYm92ZS4KCg0KBQQDAgAEEgSAAQIKCg0KBQQDAgAGEgSAAQseCg0KBQQDAgABEgSAAR8zCg0KBQQDAgADEgSAATY5CloKAwQDBRIEgwECGRpNIENsaWVudHMgY2FuIGRlZmluZSBjdXN0b20gb3B0aW9ucyBpbiBleHRlbnNpb25zIG9mIHRoaXMgbWVzc2FnZS4gU2VlIGFib3ZlLgoKDAoEBAMFABIEgwENGAoNCgUEAwUAARIEgwENEQoNCgUEAwUAAhIEgwEVGAozCgIEBBIGhwEA1QEBGiUgRGVzY3JpYmVzIGEgZmllbGQgd2l0aGluIGEgbWVzc2FnZS4KCgsKAwQEARIEhwEIHAoOCgQEBAQAEgaIAQKnAQMKDQoFBAQEAAESBIgBBwsKUwoGBAQEAAIAEgSLAQQcGkMgMCBpcyByZXNlcnZlZCBmb3IgZXJyb3JzLgogT3JkZXIgaXMgd2VpcmQgZm9yIGhpc3RvcmljYWwgcmVhc29ucy4KCg8KBwQEBAACAAESBIsBBA8KDwoHBAQEAAIAAhIEiwEaGwoOCgYEBAQAAgESBIwBBBwKDwoHBAQEAAIBARIEjAEEDgoPCgcEBAQAAgECEgSMARobCncKBgQEBAACAhIEjwEEHBpnIE5vdCBaaWdaYWcgZW5jb2RlZC4gIE5lZ2F0aXZlIG51bWJlcnMgdGFrZSAxMCBieXRlcy4gIFVzZSBUWVBFX1NJTlQ2NCBpZgogbmVnYXRpdmUgdmFsdWVzIGFyZSBsaWtlbHkuCgoPCgcEBAQAAgIBEgSPAQQOCg8KBwQEBAACAgISBI8BGhsKDgoGBAQEAAIDEgSQAQQcCg8KBwQEBAACAwESBJABBA8KDwoHBAQEAAIDAhIEkAEaGwp3CgYEBAQAAgQSBJMBBBwaZyBOb3QgWmlnWmFnIGVuY29kZWQuICBOZWdhdGl2ZSBudW1iZXJzIHRha2UgMTAgYnl0ZXMuICBVc2UgVFlQRV9TSU5UMzIgaWYKIG5lZ2F0aXZlIHZhbHVlcyBhcmUgbGlrZWx5LgoKDwoHBAQEAAIEARIEkwEEDgoPCgcEBAQAAgQCEgSTARobCg4KBgQEBAACBRIElAEEHAoPCgcEBAQAAgUBEgSUAQQQCg8KBwQEBAACBQISBJQBGhsKDgoGBAQEAAIGEgSVAQQcCg8KBwQEBAACBgESBJUBBBAKDwoHBAQEAAIGAhIElQEaGwoOCgYEBAQAAgcSBJYBBBwKDwoHBAQEAAIHARIElgEEDQoPCgcEBAQAAgcCEgSWARobCg4KBgQEBAACCBIElwEEHAoPCgcEBAQAAggBEgSXAQQPCg8KBwQEBAACCAISBJcBGhsK4gEKBgQEBAACCRIEnAEEHRrRASBUYWctZGVsaW1pdGVkIGFnZ3JlZ2F0ZS4KIEdyb3VwIHR5cGUgaXMgZGVwcmVjYXRlZCBhbmQgbm90IHN1cHBvcnRlZCBpbiBwcm90bzMuIEhvd2V2ZXIsIFByb3RvMwogaW1wbGVtZW50YXRpb25zIHNob3VsZCBzdGlsbCBiZSBhYmxlIHRvIHBhcnNlIHRoZSBncm91cCB3aXJlIGZvcm1hdCBhbmQKIHRyZWF0IGdyb3VwIGZpZWxkcyBhcyB1bmtub3duIGZpZWxkcy4KCg8KBwQEBAACCQESBJwBBA4KDwoHBAQEAAIJAhIEnAEaHAotCgYEBAQAAgoSBJ0BBB0iHSBMZW5ndGgtZGVsaW1pdGVkIGFnZ3JlZ2F0ZS4KCg8KBwQEBAACCgESBJ0BBBAKDwoHBAQEAAIKAhIEnQEaHAojCgYEBAQAAgsSBKABBB0aEyBOZXcgaW4gdmVyc2lvbiAyLgoKDwoHBAQEAAILARIEoAEEDgoPCgcEBAQAAgsCEgSgARocCg4KBgQEBAACDBIEoQEEHQoPCgcEBAQAAgwBEgShAQQPCg8KBwQEBAACDAISBKEBGhwKDgoGBAQEAAINEgSiAQQdCg8KBwQEBAACDQESBKIBBA0KDwoHBAQEAAINAhIEogEaHAoOCgYEBAQAAg4SBKMBBB0KDwoHBAQEAAIOARIEowEEEQoPCgcEBAQAAg4CEgSjARocCg4KBgQEBAACDxIEpAEEHQoPCgcEBAQAAg8BEgSkAQQRCg8KBwQEBAACDwISBKQBGhwKJwoGBAQEAAIQEgSlAQQdIhcgVXNlcyBaaWdaYWcgZW5jb2RpbmcuCgoPCgcEBAQAAhABEgSlAQQPCg8KBwQEBAACEAISBKUBGhwKJwoGBAQEAAIREgSmAQQdIhcgVXNlcyBaaWdaYWcgZW5jb2RpbmcuCgoPCgcEBAQAAhEBEgSmAQQPCg8KBwQEBAACEQISBKYBGhwKDgoEBAQEARIGqQECrgEDCg0KBQQEBAEBEgSpAQcMCioKBgQEBAECABIEqwEEHBoaIDAgaXMgcmVzZXJ2ZWQgZm9yIGVycm9ycwoKDwoHBAQEAQIAARIEqwEEEgoPCgcEBAQBAgACEgSrARobCg4KBgQEBAECARIErAEEHAoPCgcEBAQBAgEBEgSsAQQSCg8KBwQEBAECAQISBKwBGhsKDgoGBAQEAQICEgStAQQcCg8KBwQEBAECAgESBK0BBBIKDwoHBAQEAQICAhIErQEaGwoMCgQEBAIAEgSwAQIbCg0KBQQEAgAEEgSwAQIKCg0KBQQEAgAFEgSwAQsRCg0KBQQEAgABEgSwARIWCg0KBQQEAgADEgSwARkaCgwKBAQEAgESBLEBAhwKDQoFBAQCAQQSBLEBAgoKDQoFBAQCAQUSBLEBCxAKDQoFBAQCAQESBLEBERcKDQoFBAQCAQMSBLEBGhsKDAoEBAQCAhIEsgECGwoNCgUEBAICBBIEsgECCgoNCgUEBAICBhIEsgELEAoNCgUEBAICARIEsgERFgoNCgUEBAICAxIEsgEZGgqcAQoEBAQCAxIEtgECGRqNASBJZiB0eXBlX25hbWUgaXMgc2V0LCB0aGlzIG5lZWQgbm90IGJlIHNldC4gIElmIGJvdGggdGhpcyBhbmQgdHlwZV9uYW1lCiBhcmUgc2V0LCB0aGlzIG11c3QgYmUgb25lIG9mIFRZUEVfRU5VTSwgVFlQRV9NRVNTQUdFIG9yIFRZUEVfR1JPVVAuCgoNCgUEBAIDBBIEtgECCgoNCgUEBAIDBhIEtgELDwoNCgUEBAIDARIEtgEQFAoNCgUEBAIDAxIEtgEXGAq3AgoEBAQCBBIEvQECIBqoAiBGb3IgbWVzc2FnZSBhbmQgZW51bSB0eXBlcywgdGhpcyBpcyB0aGUgbmFtZSBvZiB0aGUgdHlwZS4gIElmIHRoZSBuYW1lCiBzdGFydHMgd2l0aCBhICcuJywgaXQgaXMgZnVsbHktcXVhbGlmaWVkLiAgT3RoZXJ3aXNlLCBDKystbGlrZSBzY29waW5nCiBydWxlcyBhcmUgdXNlZCB0byBmaW5kIHRoZSB0eXBlIChpLmUuIGZpcnN0IHRoZSBuZXN0ZWQgdHlwZXMgd2l0aGluIHRoaXMKIG1lc3NhZ2UgYXJlIHNlYXJjaGVkLCB0aGVuIHdpdGhpbiB0aGUgcGFyZW50LCBvbiB1cCB0byB0aGUgcm9vdAogbmFtZXNwYWNlKS4KCg0KBQQEAgQEEgS9AQIKCg0KBQQEAgQFEgS9AQsRCg0KBQQEAgQBEgS9ARIbCg0KBQQEAgQDEgS9AR4fCn4KBAQEAgUSBMEBAh8acCBGb3IgZXh0ZW5zaW9ucywgdGhpcyBpcyB0aGUgbmFtZSBvZiB0aGUgdHlwZSBiZWluZyBleHRlbmRlZC4gIEl0IGlzCiByZXNvbHZlZCBpbiB0aGUgc2FtZSBtYW5uZXIgYXMgdHlwZV9uYW1lLgoKDQoFBAQCBQQSBMEBAgoKDQoFBAQCBQUSBMEBCxEKDQoFBAQCBQESBMEBEhoKDQoFBAQCBQMSBMEBHR4KsQIKBAQEAgYSBMgBAiQaogIgRm9yIG51bWVyaWMgdHlwZXMsIGNvbnRhaW5zIHRoZSBvcmlnaW5hbCB0ZXh0IHJlcHJlc2VudGF0aW9uIG9mIHRoZSB2YWx1ZS4KIEZvciBib29sZWFucywgInRydWUiIG9yICJmYWxzZSIuCiBGb3Igc3RyaW5ncywgY29udGFpbnMgdGhlIGRlZmF1bHQgdGV4dCBjb250ZW50cyAobm90IGVzY2FwZWQgaW4gYW55IHdheSkuCiBGb3IgYnl0ZXMsIGNvbnRhaW5zIHRoZSBDIGVzY2FwZWQgdmFsdWUuICBBbGwgYnl0ZXMgPj0gMTI4IGFyZSBlc2NhcGVkLgogVE9ETyhrZW50b24pOiAgQmFzZS02NCBlbmNvZGU/CgoNCgUEBAIGBBIEyAECCgoNCgUEBAIGBRIEyAELEQoNCgUEBAIGARIEyAESHwoNCgUEBAIGAxIEyAEiIwqEAQoEBAQCBxIEzAECIRp2IElmIHNldCwgZ2l2ZXMgdGhlIGluZGV4IG9mIGEgb25lb2YgaW4gdGhlIGNvbnRhaW5pbmcgdHlwZSdzIG9uZW9mX2RlY2wKIGxpc3QuICBUaGlzIGZpZWxkIGlzIGEgbWVtYmVyIG9mIHRoYXQgb25lb2YuCgoNCgUEBAIHBBIEzAECCgoNCgUEBAIHBRIEzAELEAoNCgUEBAIHARIEzAERHAoNCgUEBAIHAxIEzAEfIAr6AQoEBAQCCBIE0gECIRrrASBKU09OIG5hbWUgb2YgdGhpcyBmaWVsZC4gVGhlIHZhbHVlIGlzIHNldCBieSBwcm90b2NvbCBjb21waWxlci4gSWYgdGhlCiB1c2VyIGhhcyBzZXQgYSAianNvbl9uYW1lIiBvcHRpb24gb24gdGhpcyBmaWVsZCwgdGhhdCBvcHRpb24ncyB2YWx1ZQogd2lsbCBiZSB1c2VkLiBPdGhlcndpc2UsIGl0J3MgZGVkdWNlZCBmcm9tIHRoZSBmaWVsZCdzIG5hbWUgYnkgY29udmVydGluZwogaXQgdG8gY2FtZWxDYXNlLgoKDQoFBAQCCAQSBNIBAgoKDQoFBAQCCAUSBNIBCxEKDQoFBAQCCAESBNIBEhsKDQoFBAQCCAMSBNIBHiAKDAoEBAQCCRIE1AECJAoNCgUEBAIJBBIE1AECCgoNCgUEBAIJBhIE1AELFwoNCgUEBAIJARIE1AEYHwoNCgUEBAIJAxIE1AEiIwoiCgIEBRIG2AEA2wEBGhQgRGVzY3JpYmVzIGEgb25lb2YuCgoLCgMEBQESBNgBCBwKDAoEBAUCABIE2QECGwoNCgUEBQIABBIE2QECCgoNCgUEBQIABRIE2QELEQoNCgUEBQIAARIE2QESFgoNCgUEBQIAAxIE2QEZGgoMCgQEBQIBEgTaAQIkCg0KBQQFAgEEEgTaAQIKCg0KBQQFAgEGEgTaAQsXCg0KBQQFAgEBEgTaARgfCg0KBQQFAgEDEgTaASIjCicKAgQGEgbeAQD4AQEaGSBEZXNjcmliZXMgYW4gZW51bSB0eXBlLgoKCwoDBAYBEgTeAQgbCgwKBAQGAgASBN8BAhsKDQoFBAYCAAQSBN8BAgoKDQoFBAYCAAUSBN8BCxEKDQoFBAYCAAESBN8BEhYKDQoFBAYCAAMSBN8BGRoKDAoEBAYCARIE4QECLgoNCgUEBgIBBBIE4QECCgoNCgUEBgIBBhIE4QELIwoNCgUEBgIBARIE4QEkKQoNCgUEBgIBAxIE4QEsLQoMCgQEBgICEgTjAQIjCg0KBQQGAgIEEgTjAQIKCg0KBQQGAgIGEgTjAQsWCg0KBQQGAgIBEgTjARceCg0KBQQGAgIDEgTjASEiCq8CCgQEBgMAEgbrAQLuAQMangIgUmFuZ2Ugb2YgcmVzZXJ2ZWQgbnVtZXJpYyB2YWx1ZXMuIFJlc2VydmVkIHZhbHVlcyBtYXkgbm90IGJlIHVzZWQgYnkKIGVudHJpZXMgaW4gdGhlIHNhbWUgZW51bS4gUmVzZXJ2ZWQgcmFuZ2VzIG1heSBub3Qgb3ZlcmxhcC4KCiBOb3RlIHRoYXQgdGhpcyBpcyBkaXN0aW5jdCBmcm9tIERlc2NyaXB0b3JQcm90by5SZXNlcnZlZFJhbmdlIGluIHRoYXQgaXQKIGlzIGluY2x1c2l2ZSBzdWNoIHRoYXQgaXQgY2FuIGFwcHJvcHJpYXRlbHkgcmVwcmVzZW50IHRoZSBlbnRpcmUgaW50MzIKIGRvbWFpbi4KCg0KBQQGAwABEgTrAQobChwKBgQGAwACABIE7AEEHSIMIEluY2x1c2l2ZS4KCg8KBwQGAwACAAQSBOwBBAwKDwoHBAYDAAIABRIE7AENEgoPCgcEBgMAAgABEgTsARMYCg8KBwQGAwACAAMSBOwBGxwKHAoGBAYDAAIBEgTtAQQbIgwgSW5jbHVzaXZlLgoKDwoHBAYDAAIBBBIE7QEEDAoPCgcEBgMAAgEFEgTtAQ0SCg8KBwQGAwACAQESBO0BExYKDwoHBAYDAAIBAxIE7QEZGgqqAQoEBAYCAxIE8wECMBqbASBSYW5nZSBvZiByZXNlcnZlZCBudW1lcmljIHZhbHVlcy4gUmVzZXJ2ZWQgbnVtZXJpYyB2YWx1ZXMgbWF5IG5vdCBiZSB1c2VkCiBieSBlbnVtIHZhbHVlcyBpbiB0aGUgc2FtZSBlbnVtIGRlY2xhcmF0aW9uLiBSZXNlcnZlZCByYW5nZXMgbWF5IG5vdAogb3ZlcmxhcC4KCg0KBQQGAgMEEgTzAQIKCg0KBQQGAgMGEgTzAQscCg0KBQQGAgMBEgTzAR0rCg0KBQQGAgMDEgTzAS4vCmwKBAQGAgQSBPcBAiQaXiBSZXNlcnZlZCBlbnVtIHZhbHVlIG5hbWVzLCB3aGljaCBtYXkgbm90IGJlIHJldXNlZC4gQSBnaXZlbiBuYW1lIG1heSBvbmx5CiBiZSByZXNlcnZlZCBvbmNlLgoKDQoFBAYCBAQSBPcBAgoKDQoFBAYCBAUSBPcBCxEKDQoFBAYCBAESBPcBEh8KDQoFBAYCBAMSBPcBIiMKMQoCBAcSBvsBAIACARojIERlc2NyaWJlcyBhIHZhbHVlIHdpdGhpbiBhbiBlbnVtLgoKCwoDBAcBEgT7AQggCgwKBAQHAgASBPwBAhsKDQoFBAcCAAQSBPwBAgoKDQoFBAcCAAUSBPwBCxEKDQoFBAcCAAESBPwBEhYKDQoFBAcCAAMSBPwBGRoKDAoEBAcCARIE/QECHAoNCgUEBwIBBBIE/QECCgoNCgUEBwIBBRIE/QELEAoNCgUEBwIBARIE/QERFwoNCgUEBwIBAxIE/QEaGwoMCgQEBwICEgT/AQIoCg0KBQQHAgIEEgT/AQIKCg0KBQQHAgIGEgT/AQsbCg0KBQQHAgIBEgT/ARwjCg0KBQQHAgIDEgT/ASYnCiQKAgQIEgaDAgCIAgEaFiBEZXNjcmliZXMgYSBzZXJ2aWNlLgoKCwoDBAgBEgSDAggeCgwKBAQIAgASBIQCAhsKDQoFBAgCAAQSBIQCAgoKDQoFBAgCAAUSBIQCCxEKDQoFBAgCAAESBIQCEhYKDQoFBAgCAAMSBIQCGRoKDAoEBAgCARIEhQICLAoNCgUECAIBBBIEhQICCgoNCgUECAIBBhIEhQILIAoNCgUECAIBARIEhQIhJwoNCgUECAIBAxIEhQIqKwoMCgQECAICEgSHAgImCg0KBQQIAgIEEgSHAgIKCg0KBQQIAgIGEgSHAgsZCg0KBQQIAgIBEgSHAhohCg0KBQQIAgIDEgSHAiQlCjAKAgQJEgaLAgCZAgEaIiBEZXNjcmliZXMgYSBtZXRob2Qgb2YgYSBzZXJ2aWNlLgoKCwoDBAkBEgSLAggdCgwKBAQJAgASBIwCAhsKDQoFBAkCAAQSBIwCAgoKDQoFBAkCAAUSBIwCCxEKDQoFBAkCAAESBIwCEhYKDQoFBAkCAAMSBIwCGRoKlwEKBAQJAgESBJACAiEaiAEgSW5wdXQgYW5kIG91dHB1dCB0eXBlIG5hbWVzLiAgVGhlc2UgYXJlIHJlc29sdmVkIGluIHRoZSBzYW1lIHdheSBhcwogRmllbGREZXNjcmlwdG9yUHJvdG8udHlwZV9uYW1lLCBidXQgbXVzdCByZWZlciB0byBhIG1lc3NhZ2UgdHlwZS4KCg0KBQQJAgEEEgSQAgIKCg0KBQQJAgEFEgSQAgsRCg0KBQQJAgEBEgSQAhIcCg0KBQQJAgEDEgSQAh8gCgwKBAQJAgISBJECAiIKDQoFBAkCAgQSBJECAgoKDQoFBAkCAgUSBJECCxEKDQoFBAkCAgESBJECEh0KDQoFBAkCAgMSBJECICEKDAoEBAkCAxIEkwICJQoNCgUECQIDBBIEkwICCgoNCgUECQIDBhIEkwILGAoNCgUECQIDARIEkwIZIAoNCgUECQIDAxIEkwIjJApFCgQECQIEEgSWAgI1GjcgSWRlbnRpZmllcyBpZiBjbGllbnQgc3RyZWFtcyBtdWx0aXBsZSBjbGllbnQgbWVzc2FnZXMKCg0KBQQJAgQEEgSWAgIKCg0KBQQJAgQFEgSWAgsPCg0KBQQJAgQBEgSWAhAgCg0KBQQJAgQDEgSWAiMkCg0KBQQJAgQIEgSWAiU0Cg0KBQQJAgQHEgSWAi4zCkUKBAQJAgUSBJgCAjUaNyBJZGVudGlmaWVzIGlmIHNlcnZlciBzdHJlYW1zIG11bHRpcGxlIHNlcnZlciBtZXNzYWdlcwoKDQoFBAkCBQQSBJgCAgoKDQoFBAkCBQUSBJgCCw8KDQoFBAkCBQESBJgCECAKDQoFBAkCBQMSBJgCIyQKDQoFBAkCBQgSBJgCJTQKDQoFBAkCBQcSBJgCLjMKrw4KAgQKEga9AgC3AwEyTiA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09CiBPcHRpb25zCjLQDSBFYWNoIG9mIHRoZSBkZWZpbml0aW9ucyBhYm92ZSBtYXkgaGF2ZSAib3B0aW9ucyIgYXR0YWNoZWQuICBUaGVzZSBhcmUKIGp1c3QgYW5ub3RhdGlvbnMgd2hpY2ggbWF5IGNhdXNlIGNvZGUgdG8gYmUgZ2VuZXJhdGVkIHNsaWdodGx5IGRpZmZlcmVudGx5CiBvciBtYXkgY29udGFpbiBoaW50cyBmb3IgY29kZSB0aGF0IG1hbmlwdWxhdGVzIHByb3RvY29sIG1lc3NhZ2VzLgoKIENsaWVudHMgbWF5IGRlZmluZSBjdXN0b20gb3B0aW9ucyBhcyBleHRlbnNpb25zIG9mIHRoZSAqT3B0aW9ucyBtZXNzYWdlcy4KIFRoZXNlIGV4dGVuc2lvbnMgbWF5IG5vdCB5ZXQgYmUga25vd24gYXQgcGFyc2luZyB0aW1lLCBzbyB0aGUgcGFyc2VyIGNhbm5vdAogc3RvcmUgdGhlIHZhbHVlcyBpbiB0aGVtLiAgSW5zdGVhZCBpdCBzdG9yZXMgdGhlbSBpbiBhIGZpZWxkIGluIHRoZSAqT3B0aW9ucwogbWVzc2FnZSBjYWxsZWQgdW5pbnRlcnByZXRlZF9vcHRpb24uIFRoaXMgZmllbGQgbXVzdCBoYXZlIHRoZSBzYW1lIG5hbWUKIGFjcm9zcyBhbGwgKk9wdGlvbnMgbWVzc2FnZXMuIFdlIHRoZW4gdXNlIHRoaXMgZmllbGQgdG8gcG9wdWxhdGUgdGhlCiBleHRlbnNpb25zIHdoZW4gd2UgYnVpbGQgYSBkZXNjcmlwdG9yLCBhdCB3aGljaCBwb2ludCBhbGwgcHJvdG9zIGhhdmUgYmVlbgogcGFyc2VkIGFuZCBzbyBhbGwgZXh0ZW5zaW9ucyBhcmUga25vd24uCgogRXh0ZW5zaW9uIG51bWJlcnMgZm9yIGN1c3RvbSBvcHRpb25zIG1heSBiZSBjaG9zZW4gYXMgZm9sbG93czoKICogRm9yIG9wdGlvbnMgd2hpY2ggd2lsbCBvbmx5IGJlIHVzZWQgd2l0aGluIGEgc2luZ2xlIGFwcGxpY2F0aW9uIG9yCiAgIG9yZ2FuaXphdGlvbiwgb3IgZm9yIGV4cGVyaW1lbnRhbCBvcHRpb25zLCB1c2UgZmllbGQgbnVtYmVycyA1MDAwMAogICB0aHJvdWdoIDk5OTk5LiAgSXQgaXMgdXAgdG8geW91IHRvIGVuc3VyZSB0aGF0IHlvdSBkbyBub3QgdXNlIHRoZQogICBzYW1lIG51bWJlciBmb3IgbXVsdGlwbGUgb3B0aW9ucy4KICogRm9yIG9wdGlvbnMgd2hpY2ggd2lsbCBiZSBwdWJsaXNoZWQgYW5kIHVzZWQgcHVibGljbHkgYnkgbXVsdGlwbGUKICAgaW5kZXBlbmRlbnQgZW50aXRpZXMsIGUtbWFpbCBwcm90b2J1Zi1nbG9iYWwtZXh0ZW5zaW9uLXJlZ2lzdHJ5QGdvb2dsZS5jb20KICAgdG8gcmVzZXJ2ZSBleHRlbnNpb24gbnVtYmVycy4gU2ltcGx5IHByb3ZpZGUgeW91ciBwcm9qZWN0IG5hbWUgKGUuZy4KICAgT2JqZWN0aXZlLUMgcGx1Z2luKSBhbmQgeW91ciBwcm9qZWN0IHdlYnNpdGUgKGlmIGF2YWlsYWJsZSkgLS0gdGhlcmUncyBubwogICBuZWVkIHRvIGV4cGxhaW4gaG93IHlvdSBpbnRlbmQgdG8gdXNlIHRoZW0uIFVzdWFsbHkgeW91IG9ubHkgbmVlZCBvbmUKICAgZXh0ZW5zaW9uIG51bWJlci4gWW91IGNhbiBkZWNsYXJlIG11bHRpcGxlIG9wdGlvbnMgd2l0aCBvbmx5IG9uZSBleHRlbnNpb24KICAgbnVtYmVyIGJ5IHB1dHRpbmcgdGhlbSBpbiBhIHN1Yi1tZXNzYWdlLiBTZWUgdGhlIEN1c3RvbSBPcHRpb25zIHNlY3Rpb24gb2YKICAgdGhlIGRvY3MgZm9yIGV4YW1wbGVzOgogICBodHRwczovL2RldmVsb3BlcnMuZ29vZ2xlLmNvbS9wcm90b2NvbC1idWZmZXJzL2RvY3MvcHJvdG8jb3B0aW9ucwogICBJZiB0aGlzIHR1cm5zIG91dCB0byBiZSBwb3B1bGFyLCBhIHdlYiBzZXJ2aWNlIHdpbGwgYmUgc2V0IHVwCiAgIHRvIGF1dG9tYXRpY2FsbHkgYXNzaWduIG9wdGlvbiBudW1iZXJzLgoKCwoDBAoBEgS9AggTCvQBCgQECgIAEgTDAgIjGuUBIFNldHMgdGhlIEphdmEgcGFja2FnZSB3aGVyZSBjbGFzc2VzIGdlbmVyYXRlZCBmcm9tIHRoaXMgLnByb3RvIHdpbGwgYmUKIHBsYWNlZC4gIEJ5IGRlZmF1bHQsIHRoZSBwcm90byBwYWNrYWdlIGlzIHVzZWQsIGJ1dCB0aGlzIGlzIG9mdGVuCiBpbmFwcHJvcHJpYXRlIGJlY2F1c2UgcHJvdG8gcGFja2FnZXMgZG8gbm90IG5vcm1hbGx5IHN0YXJ0IHdpdGggYmFja3dhcmRzCiBkb21haW4gbmFtZXMuCgoNCgUECgIABBIEwwICCgoNCgUECgIABRIEwwILEQoNCgUECgIAARIEwwISHgoNCgUECgIAAxIEwwIhIgq/AgoEBAoCARIEywICKxqwAiBJZiBzZXQsIGFsbCB0aGUgY2xhc3NlcyBmcm9tIHRoZSAucHJvdG8gZmlsZSBhcmUgd3JhcHBlZCBpbiBhIHNpbmdsZQogb3V0ZXIgY2xhc3Mgd2l0aCB0aGUgZ2l2ZW4gbmFtZS4gIFRoaXMgYXBwbGllcyB0byBib3RoIFByb3RvMQogKGVxdWl2YWxlbnQgdG8gdGhlIG9sZCAiLS1vbmVfamF2YV9maWxlIiBvcHRpb24pIGFuZCBQcm90bzIgKHdoZXJlCiBhIC5wcm90byBhbHdheXMgdHJhbnNsYXRlcyB0byBhIHNpbmdsZSBjbGFzcywgYnV0IHlvdSBtYXkgd2FudCB0bwogZXhwbGljaXRseSBjaG9vc2UgdGhlIGNsYXNzIG5hbWUpLgoKDQoFBAoCAQQSBMsCAgoKDQoFBAoCAQUSBMsCCxEKDQoFBAoCAQESBMsCEiYKDQoFBAoCAQMSBMsCKSoKowMKBAQKAgISBNMCAjkalAMgSWYgc2V0IHRydWUsIHRoZW4gdGhlIEphdmEgY29kZSBnZW5lcmF0b3Igd2lsbCBnZW5lcmF0ZSBhIHNlcGFyYXRlIC5qYXZhCiBmaWxlIGZvciBlYWNoIHRvcC1sZXZlbCBtZXNzYWdlLCBlbnVtLCBhbmQgc2VydmljZSBkZWZpbmVkIGluIHRoZSAucHJvdG8KIGZpbGUuICBUaHVzLCB0aGVzZSB0eXBlcyB3aWxsICpub3QqIGJlIG5lc3RlZCBpbnNpZGUgdGhlIG91dGVyIGNsYXNzCiBuYW1lZCBieSBqYXZhX291dGVyX2NsYXNzbmFtZS4gIEhvd2V2ZXIsIHRoZSBvdXRlciBjbGFzcyB3aWxsIHN0aWxsIGJlCiBnZW5lcmF0ZWQgdG8gY29udGFpbiB0aGUgZmlsZSdzIGdldERlc2NyaXB0b3IoKSBtZXRob2QgYXMgd2VsbCBhcyBhbnkKIHRvcC1sZXZlbCBleHRlbnNpb25zIGRlZmluZWQgaW4gdGhlIGZpbGUuCgoNCgUECgICBBIE0wICCgoNCgUECgICBRIE0wILDwoNCgUECgICARIE0wIQIwoNCgUECgICAxIE0wImKAoNCgUECgICCBIE0wIpOAoNCgUECgICBxIE0wIyNwopCgQECgIDEgTWAgJFGhsgVGhpcyBvcHRpb24gZG9lcyBub3RoaW5nLgoKDQoFBAoCAwQSBNYCAgoKDQoFBAoCAwUSBNYCCw8KDQoFBAoCAwESBNYCEC0KDQoFBAoCAwMSBNYCMDIKDQoFBAoCAwgSBNYCM0QKDgoGBAoCAwgDEgTWAjRDCuYCCgQECgIEEgTeAgI8GtcCIElmIHNldCB0cnVlLCB0aGVuIHRoZSBKYXZhMiBjb2RlIGdlbmVyYXRvciB3aWxsIGdlbmVyYXRlIGNvZGUgdGhhdAogdGhyb3dzIGFuIGV4Y2VwdGlvbiB3aGVuZXZlciBhbiBhdHRlbXB0IGlzIG1hZGUgdG8gYXNzaWduIGEgbm9uLVVURi04CiBieXRlIHNlcXVlbmNlIHRvIGEgc3RyaW5nIGZpZWxkLgogTWVzc2FnZSByZWZsZWN0aW9uIHdpbGwgZG8gdGhlIHNhbWUuCiBIb3dldmVyLCBhbiBleHRlbnNpb24gZmllbGQgc3RpbGwgYWNjZXB0cyBub24tVVRGLTggYnl0ZSBzZXF1ZW5jZXMuCiBUaGlzIG9wdGlvbiBoYXMgbm8gZWZmZWN0IG9uIHdoZW4gdXNlZCB3aXRoIHRoZSBsaXRlIHJ1bnRpbWUuCgoNCgUECgIEBBIE3gICCgoNCgUECgIEBRIE3gILDwoNCgUECgIEARIE3gIQJgoNCgUECgIEAxIE3gIpKwoNCgUECgIECBIE3gIsOwoNCgUECgIEBxIE3gI1OgpMCgQECgQAEgbiAgLnAgMaPCBHZW5lcmF0ZWQgY2xhc3NlcyBjYW4gYmUgb3B0aW1pemVkIGZvciBzcGVlZCBvciBjb2RlIHNpemUuCgoNCgUECgQAARIE4gIHEwpECgYECgQAAgASBOMCBA4iNCBHZW5lcmF0ZSBjb21wbGV0ZSBjb2RlIGZvciBwYXJzaW5nLCBzZXJpYWxpemF0aW9uLAoKDwoHBAoEAAIAARIE4wIECQoPCgcECgQAAgACEgTjAgwNCkcKBgQKBAACARIE5QIEEhoGIGV0Yy4KIi8gVXNlIFJlZmxlY3Rpb25PcHMgdG8gaW1wbGVtZW50IHRoZXNlIG1ldGhvZHMuCgoPCgcECgQAAgEBEgTlAgQNCg8KBwQKBAACAQISBOUCEBEKRwoGBAoEAAICEgTmAgQVIjcgR2VuZXJhdGUgY29kZSB1c2luZyBNZXNzYWdlTGl0ZSBhbmQgdGhlIGxpdGUgcnVudGltZS4KCg8KBwQKBAACAgESBOYCBBAKDwoHBAoEAAICAhIE5gITFAoMCgQECgIFEgToAgI5Cg0KBQQKAgUEEgToAgIKCg0KBQQKAgUGEgToAgsXCg0KBQQKAgUBEgToAhgkCg0KBQQKAgUDEgToAicoCg0KBQQKAgUIEgToAik4Cg0KBQQKAgUHEgToAjI3CuICCgQECgIGEgTvAgIiGtMCIFNldHMgdGhlIEdvIHBhY2thZ2Ugd2hlcmUgc3RydWN0cyBnZW5lcmF0ZWQgZnJvbSB0aGlzIC5wcm90byB3aWxsIGJlCiBwbGFjZWQuIElmIG9taXR0ZWQsIHRoZSBHbyBwYWNrYWdlIHdpbGwgYmUgZGVyaXZlZCBmcm9tIHRoZSBmb2xsb3dpbmc6CiAgIC0gVGhlIGJhc2VuYW1lIG9mIHRoZSBwYWNrYWdlIGltcG9ydCBwYXRoLCBpZiBwcm92aWRlZC4KICAgLSBPdGhlcndpc2UsIHRoZSBwYWNrYWdlIHN0YXRlbWVudCBpbiB0aGUgLnByb3RvIGZpbGUsIGlmIHByZXNlbnQuCiAgIC0gT3RoZXJ3aXNlLCB0aGUgYmFzZW5hbWUgb2YgdGhlIC5wcm90byBmaWxlLCB3aXRob3V0IGV4dGVuc2lvbi4KCg0KBQQKAgYEEgTvAgIKCg0KBQQKAgYFEgTvAgsRCg0KBQQKAgYBEgTvAhIcCg0KBQQKAgYDEgTvAh8hCtQECgQECgIHEgT9AgI5GsUEIFNob3VsZCBnZW5lcmljIHNlcnZpY2VzIGJlIGdlbmVyYXRlZCBpbiBlYWNoIGxhbmd1YWdlPyAgIkdlbmVyaWMiIHNlcnZpY2VzCiBhcmUgbm90IHNwZWNpZmljIHRvIGFueSBwYXJ0aWN1bGFyIFJQQyBzeXN0ZW0uICBUaGV5IGFyZSBnZW5lcmF0ZWQgYnkgdGhlCiBtYWluIGNvZGUgZ2VuZXJhdG9ycyBpbiBlYWNoIGxhbmd1YWdlICh3aXRob3V0IGFkZGl0aW9uYWwgcGx1Z2lucykuCiBHZW5lcmljIHNlcnZpY2VzIHdlcmUgdGhlIG9ubHkga2luZCBvZiBzZXJ2aWNlIGdlbmVyYXRpb24gc3VwcG9ydGVkIGJ5CiBlYXJseSB2ZXJzaW9ucyBvZiBnb29nbGUucHJvdG9idWYuCgogR2VuZXJpYyBzZXJ2aWNlcyBhcmUgbm93IGNvbnNpZGVyZWQgZGVwcmVjYXRlZCBpbiBmYXZvciBvZiB1c2luZyBwbHVnaW5zCiB0aGF0IGdlbmVyYXRlIGNvZGUgc3BlY2lmaWMgdG8geW91ciBwYXJ0aWN1bGFyIFJQQyBzeXN0ZW0uICBUaGVyZWZvcmUsCiB0aGVzZSBkZWZhdWx0IHRvIGZhbHNlLiAgT2xkIGNvZGUgd2hpY2ggZGVwZW5kcyBvbiBnZW5lcmljIHNlcnZpY2VzIHNob3VsZAogZXhwbGljaXRseSBzZXQgdGhlbSB0byB0cnVlLgoKDQoFBAoCBwQSBP0CAgoKDQoFBAoCBwUSBP0CCw8KDQoFBAoCBwESBP0CECMKDQoFBAoCBwMSBP0CJigKDQoFBAoCBwgSBP0CKTgKDQoFBAoCBwcSBP0CMjcKDAoEBAoCCBIE/gICOwoNCgUECgIIBBIE/gICCgoNCgUECgIIBRIE/gILDwoNCgUECgIIARIE/gIQJQoNCgUECgIIAxIE/gIoKgoNCgUECgIICBIE/gIrOgoNCgUECgIIBxIE/gI0OQoMCgQECgIJEgT/AgI5Cg0KBQQKAgkEEgT/AgIKCg0KBQQKAgkFEgT/AgsPCg0KBQQKAgkBEgT/AhAjCg0KBQQKAgkDEgT/AiYoCg0KBQQKAgkIEgT/Aik4Cg0KBQQKAgkHEgT/AjI3CgwKBAQKAgoSBIADAjoKDQoFBAoCCgQSBIADAgoKDQoFBAoCCgUSBIADCw8KDQoFBAoCCgESBIADECQKDQoFBAoCCgMSBIADJykKDQoFBAoCCggSBIADKjkKDQoFBAoCCgcSBIADMzgK8wEKBAQKAgsSBIYDAjAa5AEgSXMgdGhpcyBmaWxlIGRlcHJlY2F0ZWQ/CiBEZXBlbmRpbmcgb24gdGhlIHRhcmdldCBwbGF0Zm9ybSwgdGhpcyBjYW4gZW1pdCBEZXByZWNhdGVkIGFubm90YXRpb25zCiBmb3IgZXZlcnl0aGluZyBpbiB0aGUgZmlsZSwgb3IgaXQgd2lsbCBiZSBjb21wbGV0ZWx5IGlnbm9yZWQ7IGluIHRoZSB2ZXJ5CiBsZWFzdCwgdGhpcyBpcyBhIGZvcm1hbGl6YXRpb24gZm9yIGRlcHJlY2F0aW5nIGZpbGVzLgoKDQoFBAoCCwQSBIYDAgoKDQoFBAoCCwUSBIYDCw8KDQoFBAoCCwESBIYDEBoKDQoFBAoCCwMSBIYDHR8KDQoFBAoCCwgSBIYDIC8KDQoFBAoCCwcSBIYDKS4KfwoEBAoCDBIEigMCNhpxIEVuYWJsZXMgdGhlIHVzZSBvZiBhcmVuYXMgZm9yIHRoZSBwcm90byBtZXNzYWdlcyBpbiB0aGlzIGZpbGUuIFRoaXMgYXBwbGllcwogb25seSB0byBnZW5lcmF0ZWQgY2xhc3NlcyBmb3IgQysrLgoKDQoFBAoCDAQSBIoDAgoKDQoFBAoCDAUSBIoDCw8KDQoFBAoCDAESBIoDECAKDQoFBAoCDAMSBIoDIyUKDQoFBAoCDAgSBIoDJjUKDQoFBAoCDAcSBIoDLzQKkgEKBAQKAg0SBI8DAikagwEgU2V0cyB0aGUgb2JqZWN0aXZlIGMgY2xhc3MgcHJlZml4IHdoaWNoIGlzIHByZXBlbmRlZCB0byBhbGwgb2JqZWN0aXZlIGMKIGdlbmVyYXRlZCBjbGFzc2VzIGZyb20gdGhpcyAucHJvdG8uIFRoZXJlIGlzIG5vIGRlZmF1bHQuCgoNCgUECgINBBIEjwMCCgoNCgUECgINBRIEjwMLEQoNCgUECgINARIEjwMSIwoNCgUECgINAxIEjwMmKApJCgQECgIOEgSSAwIoGjsgTmFtZXNwYWNlIGZvciBnZW5lcmF0ZWQgY2xhc3NlczsgZGVmYXVsdHMgdG8gdGhlIHBhY2thZ2UuCgoNCgUECgIOBBIEkgMCCgoNCgUECgIOBRIEkgMLEQoNCgUECgIOARIEkgMSIgoNCgUECgIOAxIEkgMlJwqRAgoEBAoCDxIEmAMCJBqCAiBCeSBkZWZhdWx0IFN3aWZ0IGdlbmVyYXRvcnMgd2lsbCB0YWtlIHRoZSBwcm90byBwYWNrYWdlIGFuZCBDYW1lbENhc2UgaXQKIHJlcGxhY2luZyAnLicgd2l0aCB1bmRlcnNjb3JlIGFuZCB1c2UgdGhhdCB0byBwcmVmaXggdGhlIHR5cGVzL3N5bWJvbHMKIGRlZmluZWQuIFdoZW4gdGhpcyBvcHRpb25zIGlzIHByb3ZpZGVkLCB0aGV5IHdpbGwgdXNlIHRoaXMgdmFsdWUgaW5zdGVhZAogdG8gcHJlZml4IHRoZSB0eXBlcy9zeW1ib2xzIGRlZmluZWQuCgoNCgUECgIPBBIEmAMCCgoNCgUECgIPBRIEmAMLEQoNCgUECgIPARIEmAMSHgoNCgUECgIPAxIEmAMhIwp+CgQECgIQEgScAwIoGnAgU2V0cyB0aGUgcGhwIGNsYXNzIHByZWZpeCB3aGljaCBpcyBwcmVwZW5kZWQgdG8gYWxsIHBocCBnZW5lcmF0ZWQgY2xhc3NlcwogZnJvbSB0aGlzIC5wcm90by4gRGVmYXVsdCBpcyBlbXB0eS4KCg0KBQQKAhAEEgScAwIKCg0KBQQKAhAFEgScAwsRCg0KBQQKAhABEgScAxIiCg0KBQQKAhADEgScAyUnCr4BCgQECgIREgShAwIlGq8BIFVzZSB0aGlzIG9wdGlvbiB0byBjaGFuZ2UgdGhlIG5hbWVzcGFjZSBvZiBwaHAgZ2VuZXJhdGVkIGNsYXNzZXMuIERlZmF1bHQKIGlzIGVtcHR5LiBXaGVuIHRoaXMgb3B0aW9uIGlzIGVtcHR5LCB0aGUgcGFja2FnZSBuYW1lIHdpbGwgYmUgdXNlZCBmb3IKIGRldGVybWluaW5nIHRoZSBuYW1lc3BhY2UuCgoNCgUECgIRBBIEoQMCCgoNCgUECgIRBRIEoQMLEQoNCgUECgIRARIEoQMSHwoNCgUECgIRAxIEoQMiJArKAQoEBAoCEhIEpwMCLhq7ASBVc2UgdGhpcyBvcHRpb24gdG8gY2hhbmdlIHRoZSBuYW1lc3BhY2Ugb2YgcGhwIGdlbmVyYXRlZCBtZXRhZGF0YSBjbGFzc2VzLgogRGVmYXVsdCBpcyBlbXB0eS4gV2hlbiB0aGlzIG9wdGlvbiBpcyBlbXB0eSwgdGhlIHByb3RvIGZpbGUgbmFtZSB3aWxsIGJlIHVzZWQKIGZvciBkZXRlcm1pbmluZyB0aGUgbmFtZXNwYWNlLgoKDQoFBAoCEgQSBKcDAgoKDQoFBAoCEgUSBKcDCxEKDQoFBAoCEgESBKcDEigKDQoFBAoCEgMSBKcDKy0KwgEKBAQKAhMSBKwDAiQaswEgVXNlIHRoaXMgb3B0aW9uIHRvIGNoYW5nZSB0aGUgcGFja2FnZSBvZiBydWJ5IGdlbmVyYXRlZCBjbGFzc2VzLiBEZWZhdWx0CiBpcyBlbXB0eS4gV2hlbiB0aGlzIG9wdGlvbiBpcyBub3Qgc2V0LCB0aGUgcGFja2FnZSBuYW1lIHdpbGwgYmUgdXNlZCBmb3IKIGRldGVybWluaW5nIHRoZSBydWJ5IHBhY2thZ2UuCgoNCgUECgITBBIErAMCCgoNCgUECgITBRIErAMLEQoNCgUECgITARIErAMSHgoNCgUECgITAxIErAMhIwp8CgQECgIUEgSwAwI6Gm4gVGhlIHBhcnNlciBzdG9yZXMgb3B0aW9ucyBpdCBkb2Vzbid0IHJlY29nbml6ZSBoZXJlLgogU2VlIHRoZSBkb2N1bWVudGF0aW9uIGZvciB0aGUgIk9wdGlvbnMiIHNlY3Rpb24gYWJvdmUuCgoNCgUECgIUBBIEsAMCCgoNCgUECgIUBhIEsAMLHgoNCgUECgIUARIEsAMfMwoNCgUECgIUAxIEsAM2OQqHAQoDBAoFEgS0AwIZGnogQ2xpZW50cyBjYW4gZGVmaW5lIGN1c3RvbSBvcHRpb25zIGluIGV4dGVuc2lvbnMgb2YgdGhpcyBtZXNzYWdlLgogU2VlIHRoZSBkb2N1bWVudGF0aW9uIGZvciB0aGUgIk9wdGlvbnMiIHNlY3Rpb24gYWJvdmUuCgoMCgQECgUAEgS0Aw0YCg0KBQQKBQABEgS0Aw0RCg0KBQQKBQACEgS0AxUYCgsKAwQKCRIEtgMLDgoMCgQECgkAEgS2AwsNCg0KBQQKCQABEgS2AwsNCg0KBQQKCQACEgS2AwsNCgwKAgQLEga5AwD4AwEKCwoDBAsBEgS5AwgWCtgFCgQECwIAEgTMAwI8GskFIFNldCB0cnVlIHRvIHVzZSB0aGUgb2xkIHByb3RvMSBNZXNzYWdlU2V0IHdpcmUgZm9ybWF0IGZvciBleHRlbnNpb25zLgogVGhpcyBpcyBwcm92aWRlZCBmb3IgYmFja3dhcmRzLWNvbXBhdGliaWxpdHkgd2l0aCB0aGUgTWVzc2FnZVNldCB3aXJlCiBmb3JtYXQuICBZb3Ugc2hvdWxkIG5vdCB1c2UgdGhpcyBmb3IgYW55IG90aGVyIHJlYXNvbjogIEl0J3MgbGVzcwogZWZmaWNpZW50LCBoYXMgZmV3ZXIgZmVhdHVyZXMsIGFuZCBpcyBtb3JlIGNvbXBsaWNhdGVkLgoKIFRoZSBtZXNzYWdlIG11c3QgYmUgZGVmaW5lZCBleGFjdGx5IGFzIGZvbGxvd3M6CiAgIG1lc3NhZ2UgRm9vIHsKICAgICBvcHRpb24gbWVzc2FnZV9zZXRfd2lyZV9mb3JtYXQgPSB0cnVlOwogICAgIGV4dGVuc2lvbnMgNCB0byBtYXg7CiAgIH0KIE5vdGUgdGhhdCB0aGUgbWVzc2FnZSBjYW5ub3QgaGF2ZSBhbnkgZGVmaW5lZCBmaWVsZHM7IE1lc3NhZ2VTZXRzIG9ubHkKIGhhdmUgZXh0ZW5zaW9ucy4KCiBBbGwgZXh0ZW5zaW9ucyBvZiB5b3VyIHR5cGUgbXVzdCBiZSBzaW5ndWxhciBtZXNzYWdlczsgZS5nLiB0aGV5IGNhbm5vdAogYmUgaW50MzJzLCBlbnVtcywgb3IgcmVwZWF0ZWQgbWVzc2FnZXMuCgogQmVjYXVzZSB0aGlzIGlzIGFuIG9wdGlvbiwgdGhlIGFib3ZlIHR3byByZXN0cmljdGlvbnMgYXJlIG5vdCBlbmZvcmNlZCBieQogdGhlIHByb3RvY29sIGNvbXBpbGVyLgoKDQoFBAsCAAQSBMwDAgoKDQoFBAsCAAUSBMwDCw8KDQoFBAsCAAESBMwDECcKDQoFBAsCAAMSBMwDKisKDQoFBAsCAAgSBMwDLDsKDQoFBAsCAAcSBMwDNToK6wEKBAQLAgESBNEDAkQa3AEgRGlzYWJsZXMgdGhlIGdlbmVyYXRpb24gb2YgdGhlIHN0YW5kYXJkICJkZXNjcmlwdG9yKCkiIGFjY2Vzc29yLCB3aGljaCBjYW4KIGNvbmZsaWN0IHdpdGggYSBmaWVsZCBvZiB0aGUgc2FtZSBuYW1lLiAgVGhpcyBpcyBtZWFudCB0byBtYWtlIG1pZ3JhdGlvbgogZnJvbSBwcm90bzEgZWFzaWVyOyBuZXcgY29kZSBzaG91bGQgYXZvaWQgZmllbGRzIG5hbWVkICJkZXNjcmlwdG9yIi4KCg0KBQQLAgEEEgTRAwIKCg0KBQQLAgEFEgTRAwsPCg0KBQQLAgEBEgTRAxAvCg0KBQQLAgEDEgTRAzIzCg0KBQQLAgEIEgTRAzRDCg0KBQQLAgEHEgTRAz1CCu4BCgQECwICEgTXAwIvGt8BIElzIHRoaXMgbWVzc2FnZSBkZXByZWNhdGVkPwogRGVwZW5kaW5nIG9uIHRoZSB0YXJnZXQgcGxhdGZvcm0sIHRoaXMgY2FuIGVtaXQgRGVwcmVjYXRlZCBhbm5vdGF0aW9ucwogZm9yIHRoZSBtZXNzYWdlLCBvciBpdCB3aWxsIGJlIGNvbXBsZXRlbHkgaWdub3JlZDsgaW4gdGhlIHZlcnkgbGVhc3QsCiB0aGlzIGlzIGEgZm9ybWFsaXphdGlvbiBmb3IgZGVwcmVjYXRpbmcgbWVzc2FnZXMuCgoNCgUECwICBBIE1wMCCgoNCgUECwICBRIE1wMLDwoNCgUECwICARIE1wMQGgoNCgUECwICAxIE1wMdHgoNCgUECwICCBIE1wMfLgoNCgUECwICBxIE1wMoLQqeBgoEBAsCAxIE7gMCHhqPBiBXaGV0aGVyIHRoZSBtZXNzYWdlIGlzIGFuIGF1dG9tYXRpY2FsbHkgZ2VuZXJhdGVkIG1hcCBlbnRyeSB0eXBlIGZvciB0aGUKIG1hcHMgZmllbGQuCgogRm9yIG1hcHMgZmllbGRzOgogICAgIG1hcDxLZXlUeXBlLCBWYWx1ZVR5cGU+IG1hcF9maWVsZCA9IDE7CiBUaGUgcGFyc2VkIGRlc2NyaXB0b3IgbG9va3MgbGlrZToKICAgICBtZXNzYWdlIE1hcEZpZWxkRW50cnkgewogICAgICAgICBvcHRpb24gbWFwX2VudHJ5ID0gdHJ1ZTsKICAgICAgICAgb3B0aW9uYWwgS2V5VHlwZSBrZXkgPSAxOwogICAgICAgICBvcHRpb25hbCBWYWx1ZVR5cGUgdmFsdWUgPSAyOwogICAgIH0KICAgICByZXBlYXRlZCBNYXBGaWVsZEVudHJ5IG1hcF9maWVsZCA9IDE7CgogSW1wbGVtZW50YXRpb25zIG1heSBjaG9vc2Ugbm90IHRvIGdlbmVyYXRlIHRoZSBtYXBfZW50cnk9dHJ1ZSBtZXNzYWdlLCBidXQKIHVzZSBhIG5hdGl2ZSBtYXAgaW4gdGhlIHRhcmdldCBsYW5ndWFnZSB0byBob2xkIHRoZSBrZXlzIGFuZCB2YWx1ZXMuCiBUaGUgcmVmbGVjdGlvbiBBUElzIGluIHN1Y2ggaW1wbGVtZW50aW9ucyBzdGlsbCBuZWVkIHRvIHdvcmsgYXMKIGlmIHRoZSBmaWVsZCBpcyBhIHJlcGVhdGVkIG1lc3NhZ2UgZmllbGQuCgogTk9URTogRG8gbm90IHNldCB0aGUgb3B0aW9uIGluIC5wcm90byBmaWxlcy4gQWx3YXlzIHVzZSB0aGUgbWFwcyBzeW50YXgKIGluc3RlYWQuIFRoZSBvcHRpb24gc2hvdWxkIG9ubHkgYmUgaW1wbGljaXRseSBzZXQgYnkgdGhlIHByb3RvIGNvbXBpbGVyCiBwYXJzZXIuCgoNCgUECwIDBBIE7gMCCgoNCgUECwIDBRIE7gMLDwoNCgUECwIDARIE7gMQGQoNCgUECwIDAxIE7gMcHQokCgMECwkSBPADCw0iFyBqYXZhbGl0ZV9zZXJpYWxpemFibGUKCgwKBAQLCQASBPADCwwKDQoFBAsJAAESBPADCwwKDQoFBAsJAAISBPADCwwKHwoDBAsJEgTxAwsNIhIgamF2YW5hbm9fYXNfbGl0ZQoKDAoEBAsJARIE8QMLDAoNCgUECwkBARIE8QMLDAoNCgUECwkBAhIE8QMLDApPCgQECwIEEgT0AwI6GkEgVGhlIHBhcnNlciBzdG9yZXMgb3B0aW9ucyBpdCBkb2Vzbid0IHJlY29nbml6ZSBoZXJlLiBTZWUgYWJvdmUuCgoNCgUECwIEBBIE9AMCCgoNCgUECwIEBhIE9AMLHgoNCgUECwIEARIE9AMfMwoNCgUECwIEAxIE9AM2OQpaCgMECwUSBPcDAhkaTSBDbGllbnRzIGNhbiBkZWZpbmUgY3VzdG9tIG9wdGlvbnMgaW4gZXh0ZW5zaW9ucyBvZiB0aGlzIG1lc3NhZ2UuIFNlZSBhYm92ZS4KCgwKBAQLBQASBPcDDRgKDQoFBAsFAAESBPcDDREKDQoFBAsFAAISBPcDFRgKDAoCBAwSBvoDANUEAQoLCgMEDAESBPoDCBQKowIKBAQMAgASBP8DAi4alAIgVGhlIGN0eXBlIG9wdGlvbiBpbnN0cnVjdHMgdGhlIEMrKyBjb2RlIGdlbmVyYXRvciB0byB1c2UgYSBkaWZmZXJlbnQKIHJlcHJlc2VudGF0aW9uIG9mIHRoZSBmaWVsZCB0aGFuIGl0IG5vcm1hbGx5IHdvdWxkLiAgU2VlIHRoZSBzcGVjaWZpYwogb3B0aW9ucyBiZWxvdy4gIFRoaXMgb3B0aW9uIGlzIG5vdCB5ZXQgaW1wbGVtZW50ZWQgaW4gdGhlIG9wZW4gc291cmNlCiByZWxlYXNlIC0tIHNvcnJ5LCB3ZSdsbCB0cnkgdG8gaW5jbHVkZSBpdCBpbiBhIGZ1dHVyZSB2ZXJzaW9uIQoKDQoFBAwCAAQSBP8DAgoKDQoFBAwCAAYSBP8DCxAKDQoFBAwCAAESBP8DERYKDQoFBAwCAAMSBP8DGRoKDQoFBAwCAAgSBP8DGy0KDQoFBAwCAAcSBP8DJiwKDgoEBAwEABIGgAQChwQDCg0KBQQMBAABEgSABAcMCh8KBgQMBAACABIEggQEDxoPIERlZmF1bHQgbW9kZS4KCg8KBwQMBAACAAESBIIEBAoKDwoHBAwEAAIAAhIEggQNDgoOCgYEDAQAAgESBIQEBA0KDwoHBAwEAAIBARIEhAQECAoPCgcEDAQAAgECEgSEBAsMCg4KBgQMBAACAhIEhgQEFQoPCgcEDAQAAgIBEgSGBAQQCg8KBwQMBAACAgISBIYEExQK2gIKBAQMAgESBI0EAhsaywIgVGhlIHBhY2tlZCBvcHRpb24gY2FuIGJlIGVuYWJsZWQgZm9yIHJlcGVhdGVkIHByaW1pdGl2ZSBmaWVsZHMgdG8gZW5hYmxlCiBhIG1vcmUgZWZmaWNpZW50IHJlcHJlc2VudGF0aW9uIG9uIHRoZSB3aXJlLiBSYXRoZXIgdGhhbiByZXBlYXRlZGx5CiB3cml0aW5nIHRoZSB0YWcgYW5kIHR5cGUgZm9yIGVhY2ggZWxlbWVudCwgdGhlIGVudGlyZSBhcnJheSBpcyBlbmNvZGVkIGFzCiBhIHNpbmdsZSBsZW5ndGgtZGVsaW1pdGVkIGJsb2IuIEluIHByb3RvMywgb25seSBleHBsaWNpdCBzZXR0aW5nIGl0IHRvCiBmYWxzZSB3aWxsIGF2b2lkIHVzaW5nIHBhY2tlZCBlbmNvZGluZy4KCg0KBQQMAgEEEgSNBAIKCg0KBQQMAgEFEgSNBAsPCg0KBQQMAgEBEgSNBBAWCg0KBQQMAgEDEgSNBBkaCpoFCgQEDAICEgSaBAIzGosFIFRoZSBqc3R5cGUgb3B0aW9uIGRldGVybWluZXMgdGhlIEphdmFTY3JpcHQgdHlwZSB1c2VkIGZvciB2YWx1ZXMgb2YgdGhlCiBmaWVsZC4gIFRoZSBvcHRpb24gaXMgcGVybWl0dGVkIG9ubHkgZm9yIDY0IGJpdCBpbnRlZ3JhbCBhbmQgZml4ZWQgdHlwZXMKIChpbnQ2NCwgdWludDY0LCBzaW50NjQsIGZpeGVkNjQsIHNmaXhlZDY0KS4gIEEgZmllbGQgd2l0aCBqc3R5cGUgSlNfU1RSSU5HCiBpcyByZXByZXNlbnRlZCBhcyBKYXZhU2NyaXB0IHN0cmluZywgd2hpY2ggYXZvaWRzIGxvc3Mgb2YgcHJlY2lzaW9uIHRoYXQKIGNhbiBoYXBwZW4gd2hlbiBhIGxhcmdlIHZhbHVlIGlzIGNvbnZlcnRlZCB0byBhIGZsb2F0aW5nIHBvaW50IEphdmFTY3JpcHQuCiBTcGVjaWZ5aW5nIEpTX05VTUJFUiBmb3IgdGhlIGpzdHlwZSBjYXVzZXMgdGhlIGdlbmVyYXRlZCBKYXZhU2NyaXB0IGNvZGUgdG8KIHVzZSB0aGUgSmF2YVNjcmlwdCAibnVtYmVyIiB0eXBlLiAgVGhlIGJlaGF2aW9yIG9mIHRoZSBkZWZhdWx0IG9wdGlvbgogSlNfTk9STUFMIGlzIGltcGxlbWVudGF0aW9uIGRlcGVuZGVudC4KCiBUaGlzIG9wdGlvbiBpcyBhbiBlbnVtIHRvIHBlcm1pdCBhZGRpdGlvbmFsIHR5cGVzIHRvIGJlIGFkZGVkLCBlLmcuCiBnb29nLm1hdGguSW50ZWdlci4KCg0KBQQMAgIEEgSaBAIKCg0KBQQMAgIGEgSaBAsRCg0KBQQMAgIBEgSaBBIYCg0KBQQMAgIDEgSaBBscCg0KBQQMAgIIEgSaBB0yCg0KBQQMAgIHEgSaBCgxCg4KBAQMBAESBpsEAqQEAwoNCgUEDAQBARIEmwQHDQonCgYEDAQBAgASBJ0EBBIaFyBVc2UgdGhlIGRlZmF1bHQgdHlwZS4KCg8KBwQMBAECAAESBJ0EBA0KDwoHBAwEAQIAAhIEnQQQEQopCgYEDAQBAgESBKAEBBIaGSBVc2UgSmF2YVNjcmlwdCBzdHJpbmdzLgoKDwoHBAwEAQIBARIEoAQEDQoPCgcEDAQBAgECEgSgBBARCikKBgQMBAECAhIEowQEEhoZIFVzZSBKYXZhU2NyaXB0IG51bWJlcnMuCgoPCgcEDAQBAgIBEgSjBAQNCg8KBwQMBAECAgISBKMEEBEK7wwKBAQMAgMSBMIEAika4AwgU2hvdWxkIHRoaXMgZmllbGQgYmUgcGFyc2VkIGxhemlseT8gIExhenkgYXBwbGllcyBvbmx5IHRvIG1lc3NhZ2UtdHlwZQogZmllbGRzLiAgSXQgbWVhbnMgdGhhdCB3aGVuIHRoZSBvdXRlciBtZXNzYWdlIGlzIGluaXRpYWxseSBwYXJzZWQsIHRoZQogaW5uZXIgbWVzc2FnZSdzIGNvbnRlbnRzIHdpbGwgbm90IGJlIHBhcnNlZCBidXQgaW5zdGVhZCBzdG9yZWQgaW4gZW5jb2RlZAogZm9ybS4gIFRoZSBpbm5lciBtZXNzYWdlIHdpbGwgYWN0dWFsbHkgYmUgcGFyc2VkIHdoZW4gaXQgaXMgZmlyc3QgYWNjZXNzZWQuCgogVGhpcyBpcyBvbmx5IGEgaGludC4gIEltcGxlbWVudGF0aW9ucyBhcmUgZnJlZSB0byBjaG9vc2Ugd2hldGhlciB0byB1c2UKIGVhZ2VyIG9yIGxhenkgcGFyc2luZyByZWdhcmRsZXNzIG9mIHRoZSB2YWx1ZSBvZiB0aGlzIG9wdGlvbi4gIEhvd2V2ZXIsCiBzZXR0aW5nIHRoaXMgb3B0aW9uIHRydWUgc3VnZ2VzdHMgdGhhdCB0aGUgcHJvdG9jb2wgYXV0aG9yIGJlbGlldmVzIHRoYXQKIHVzaW5nIGxhenkgcGFyc2luZyBvbiB0aGlzIGZpZWxkIGlzIHdvcnRoIHRoZSBhZGRpdGlvbmFsIGJvb2trZWVwaW5nCiBvdmVyaGVhZCB0eXBpY2FsbHkgbmVlZGVkIHRvIGltcGxlbWVudCBpdC4KCiBUaGlzIG9wdGlvbiBkb2VzIG5vdCBhZmZlY3QgdGhlIHB1YmxpYyBpbnRlcmZhY2Ugb2YgYW55IGdlbmVyYXRlZCBjb2RlOwogYWxsIG1ldGhvZCBzaWduYXR1cmVzIHJlbWFpbiB0aGUgc2FtZS4gIEZ1cnRoZXJtb3JlLCB0aHJlYWQtc2FmZXR5IG9mIHRoZQogaW50ZXJmYWNlIGlzIG5vdCBhZmZlY3RlZCBieSB0aGlzIG9wdGlvbjsgY29uc3QgbWV0aG9kcyByZW1haW4gc2FmZSB0bwogY2FsbCBmcm9tIG11bHRpcGxlIHRocmVhZHMgY29uY3VycmVudGx5LCB3aGlsZSBub24tY29uc3QgbWV0aG9kcyBjb250aW51ZQogdG8gcmVxdWlyZSBleGNsdXNpdmUgYWNjZXNzLgoKCiBOb3RlIHRoYXQgaW1wbGVtZW50YXRpb25zIG1heSBjaG9vc2Ugbm90IHRvIGNoZWNrIHJlcXVpcmVkIGZpZWxkcyB3aXRoaW4KIGEgbGF6eSBzdWItbWVzc2FnZS4gIFRoYXQgaXMsIGNhbGxpbmcgSXNJbml0aWFsaXplZCgpIG9uIHRoZSBvdXRlciBtZXNzYWdlCiBtYXkgcmV0dXJuIHRydWUgZXZlbiBpZiB0aGUgaW5uZXIgbWVzc2FnZSBoYXMgbWlzc2luZyByZXF1aXJlZCBmaWVsZHMuCiBUaGlzIGlzIG5lY2Vzc2FyeSBiZWNhdXNlIG90aGVyd2lzZSB0aGUgaW5uZXIgbWVzc2FnZSB3b3VsZCBoYXZlIHRvIGJlCiBwYXJzZWQgaW4gb3JkZXIgdG8gcGVyZm9ybSB0aGUgY2hlY2ssIGRlZmVhdGluZyB0aGUgcHVycG9zZSBvZiBsYXp5CiBwYXJzaW5nLiAgQW4gaW1wbGVtZW50YXRpb24gd2hpY2ggY2hvb3NlcyBub3QgdG8gY2hlY2sgcmVxdWlyZWQgZmllbGRzCiBtdXN0IGJlIGNvbnNpc3RlbnQgYWJvdXQgaXQuICBUaGF0IGlzLCBmb3IgYW55IHBhcnRpY3VsYXIgc3ViLW1lc3NhZ2UsIHRoZQogaW1wbGVtZW50YXRpb24gbXVzdCBlaXRoZXIgKmFsd2F5cyogY2hlY2sgaXRzIHJlcXVpcmVkIGZpZWxkcywgb3IgKm5ldmVyKgogY2hlY2sgaXRzIHJlcXVpcmVkIGZpZWxkcywgcmVnYXJkbGVzcyBvZiB3aGV0aGVyIG9yIG5vdCB0aGUgbWVzc2FnZSBoYXMKIGJlZW4gcGFyc2VkLgoKDQoFBAwCAwQSBMIEAgoKDQoFBAwCAwUSBMIECw8KDQoFBAwCAwESBMIEEBQKDQoFBAwCAwMSBMIEFxgKDQoFBAwCAwgSBMIEGSgKDQoFBAwCAwcSBMIEIicK6AEKBAQMAgQSBMgEAi8a2QEgSXMgdGhpcyBmaWVsZCBkZXByZWNhdGVkPwogRGVwZW5kaW5nIG9uIHRoZSB0YXJnZXQgcGxhdGZvcm0sIHRoaXMgY2FuIGVtaXQgRGVwcmVjYXRlZCBhbm5vdGF0aW9ucwogZm9yIGFjY2Vzc29ycywgb3IgaXQgd2lsbCBiZSBjb21wbGV0ZWx5IGlnbm9yZWQ7IGluIHRoZSB2ZXJ5IGxlYXN0LCB0aGlzCiBpcyBhIGZvcm1hbGl6YXRpb24gZm9yIGRlcHJlY2F0aW5nIGZpZWxkcy4KCg0KBQQMAgQEEgTIBAIKCg0KBQQMAgQFEgTIBAsPCg0KBQQMAgQBEgTIBBAaCg0KBQQMAgQDEgTIBB0eCg0KBQQMAgQIEgTIBB8uCg0KBQQMAgQHEgTIBCgtCj8KBAQMAgUSBMsEAioaMSBGb3IgR29vZ2xlLWludGVybmFsIG1pZ3JhdGlvbiBvbmx5LiBEbyBub3QgdXNlLgoKDQoFBAwCBQQSBMsEAgoKDQoFBAwCBQUSBMsECw8KDQoFBAwCBQESBMsEEBQKDQoFBAwCBQMSBMsEFxkKDQoFBAwCBQgSBMsEGikKDQoFBAwCBQcSBMsEIygKTwoEBAwCBhIEzwQCOhpBIFRoZSBwYXJzZXIgc3RvcmVzIG9wdGlvbnMgaXQgZG9lc24ndCByZWNvZ25pemUgaGVyZS4gU2VlIGFib3ZlLgoKDQoFBAwCBgQSBM8EAgoKDQoFBAwCBgYSBM8ECx4KDQoFBAwCBgESBM8EHzMKDQoFBAwCBgMSBM8ENjkKWgoDBAwFEgTSBAIZGk0gQ2xpZW50cyBjYW4gZGVmaW5lIGN1c3RvbSBvcHRpb25zIGluIGV4dGVuc2lvbnMgb2YgdGhpcyBtZXNzYWdlLiBTZWUgYWJvdmUuCgoMCgQEDAUAEgTSBA0YCg0KBQQMBQABEgTSBA0RCg0KBQQMBQACEgTSBBUYChwKAwQMCRIE1AQLDSIPIHJlbW92ZWQganR5cGUKCgwKBAQMCQASBNQECwwKDQoFBAwJAAESBNQECwwKDQoFBAwJAAISBNQECwwKDAoCBA0SBtcEAN0EAQoLCgMEDQESBNcECBQKTwoEBA0CABIE2QQCOhpBIFRoZSBwYXJzZXIgc3RvcmVzIG9wdGlvbnMgaXQgZG9lc24ndCByZWNvZ25pemUgaGVyZS4gU2VlIGFib3ZlLgoKDQoFBA0CAAQSBNkEAgoKDQoFBA0CAAYSBNkECx4KDQoFBA0CAAESBNkEHzMKDQoFBA0CAAMSBNkENjkKWgoDBA0FEgTcBAIZGk0gQ2xpZW50cyBjYW4gZGVmaW5lIGN1c3RvbSBvcHRpb25zIGluIGV4dGVuc2lvbnMgb2YgdGhpcyBtZXNzYWdlLiBTZWUgYWJvdmUuCgoMCgQEDQUAEgTcBA0YCg0KBQQNBQABEgTcBA0RCg0KBQQNBQACEgTcBBUYCgwKAgQOEgbfBADyBAEKCwoDBA4BEgTfBAgTCmAKBAQOAgASBOMEAiAaUiBTZXQgdGhpcyBvcHRpb24gdG8gdHJ1ZSB0byBhbGxvdyBtYXBwaW5nIGRpZmZlcmVudCB0YWcgbmFtZXMgdG8gdGhlIHNhbWUKIHZhbHVlLgoKDQoFBA4CAAQSBOMEAgoKDQoFBA4CAAUSBOMECw8KDQoFBA4CAAESBOMEEBsKDQoFBA4CAAMSBOMEHh8K5QEKBAQOAgESBOkEAi8a1gEgSXMgdGhpcyBlbnVtIGRlcHJlY2F0ZWQ/CiBEZXBlbmRpbmcgb24gdGhlIHRhcmdldCBwbGF0Zm9ybSwgdGhpcyBjYW4gZW1pdCBEZXByZWNhdGVkIGFubm90YXRpb25zCiBmb3IgdGhlIGVudW0sIG9yIGl0IHdpbGwgYmUgY29tcGxldGVseSBpZ25vcmVkOyBpbiB0aGUgdmVyeSBsZWFzdCwgdGhpcwogaXMgYSBmb3JtYWxpemF0aW9uIGZvciBkZXByZWNhdGluZyBlbnVtcy4KCg0KBQQOAgEEEgTpBAIKCg0KBQQOAgEFEgTpBAsPCg0KBQQOAgEBEgTpBBAaCg0KBQQOAgEDEgTpBB0eCg0KBQQOAgEIEgTpBB8uCg0KBQQOAgEHEgTpBCgtCh8KAwQOCRIE6wQLDSISIGphdmFuYW5vX2FzX2xpdGUKCgwKBAQOCQASBOsECwwKDQoFBA4JAAESBOsECwwKDQoFBA4JAAISBOsECwwKTwoEBA4CAhIE7gQCOhpBIFRoZSBwYXJzZXIgc3RvcmVzIG9wdGlvbnMgaXQgZG9lc24ndCByZWNvZ25pemUgaGVyZS4gU2VlIGFib3ZlLgoKDQoFBA4CAgQSBO4EAgoKDQoFBA4CAgYSBO4ECx4KDQoFBA4CAgESBO4EHzMKDQoFBA4CAgMSBO4ENjkKWgoDBA4FEgTxBAIZGk0gQ2xpZW50cyBjYW4gZGVmaW5lIGN1c3RvbSBvcHRpb25zIGluIGV4dGVuc2lvbnMgb2YgdGhpcyBtZXNzYWdlLiBTZWUgYWJvdmUuCgoMCgQEDgUAEgTxBA0YCg0KBQQOBQABEgTxBA0RCg0KBQQOBQACEgTxBBUYCgwKAgQPEgb0BACABQEKCwoDBA8BEgT0BAgYCvcBCgQEDwIAEgT5BAIvGugBIElzIHRoaXMgZW51bSB2YWx1ZSBkZXByZWNhdGVkPwogRGVwZW5kaW5nIG9uIHRoZSB0YXJnZXQgcGxhdGZvcm0sIHRoaXMgY2FuIGVtaXQgRGVwcmVjYXRlZCBhbm5vdGF0aW9ucwogZm9yIHRoZSBlbnVtIHZhbHVlLCBvciBpdCB3aWxsIGJlIGNvbXBsZXRlbHkgaWdub3JlZDsgaW4gdGhlIHZlcnkgbGVhc3QsCiB0aGlzIGlzIGEgZm9ybWFsaXphdGlvbiBmb3IgZGVwcmVjYXRpbmcgZW51bSB2YWx1ZXMuCgoNCgUEDwIABBIE+QQCCgoNCgUEDwIABRIE+QQLDwoNCgUEDwIAARIE+QQQGgoNCgUEDwIAAxIE+QQdHgoNCgUEDwIACBIE+QQfLgoNCgUEDwIABxIE+QQoLQpPCgQEDwIBEgT8BAI6GkEgVGhlIHBhcnNlciBzdG9yZXMgb3B0aW9ucyBpdCBkb2Vzbid0IHJlY29nbml6ZSBoZXJlLiBTZWUgYWJvdmUuCgoNCgUEDwIBBBIE/AQCCgoNCgUEDwIBBhIE/AQLHgoNCgUEDwIBARIE/AQfMwoNCgUEDwIBAxIE/AQ2OQpaCgMEDwUSBP8EAhkaTSBDbGllbnRzIGNhbiBkZWZpbmUgY3VzdG9tIG9wdGlvbnMgaW4gZXh0ZW5zaW9ucyBvZiB0aGlzIG1lc3NhZ2UuIFNlZSBhYm92ZS4KCgwKBAQPBQASBP8EDRgKDQoFBA8FAAESBP8EDREKDQoFBA8FAAISBP8EFRgKDAoCBBASBoIFAJQFAQoLCgMEEAESBIIFCBYK2QMKBAQQAgASBI0FAjAa3wEgSXMgdGhpcyBzZXJ2aWNlIGRlcHJlY2F0ZWQ/CiBEZXBlbmRpbmcgb24gdGhlIHRhcmdldCBwbGF0Zm9ybSwgdGhpcyBjYW4gZW1pdCBEZXByZWNhdGVkIGFubm90YXRpb25zCiBmb3IgdGhlIHNlcnZpY2UsIG9yIGl0IHdpbGwgYmUgY29tcGxldGVseSBpZ25vcmVkOyBpbiB0aGUgdmVyeSBsZWFzdCwKIHRoaXMgaXMgYSBmb3JtYWxpemF0aW9uIGZvciBkZXByZWNhdGluZyBzZXJ2aWNlcy4KMugBIE5vdGU6ICBGaWVsZCBudW1iZXJzIDEgdGhyb3VnaCAzMiBhcmUgcmVzZXJ2ZWQgZm9yIEdvb2dsZSdzIGludGVybmFsIFJQQwogICBmcmFtZXdvcmsuICBXZSBhcG9sb2dpemUgZm9yIGhvYXJkaW5nIHRoZXNlIG51bWJlcnMgdG8gb3Vyc2VsdmVzLCBidXQKICAgd2Ugd2VyZSBhbHJlYWR5IHVzaW5nIHRoZW0gbG9uZyBiZWZvcmUgd2UgZGVjaWRlZCB0byByZWxlYXNlIFByb3RvY29sCiAgIEJ1ZmZlcnMuCgoNCgUEEAIABBIEjQUCCgoNCgUEEAIABRIEjQULDwoNCgUEEAIAARIEjQUQGgoNCgUEEAIAAxIEjQUdHwoNCgUEEAIACBIEjQUgLwoNCgUEEAIABxIEjQUpLgpPCgQEEAIBEgSQBQI6GkEgVGhlIHBhcnNlciBzdG9yZXMgb3B0aW9ucyBpdCBkb2Vzbid0IHJlY29nbml6ZSBoZXJlLiBTZWUgYWJvdmUuCgoNCgUEEAIBBBIEkAUCCgoNCgUEEAIBBhIEkAULHgoNCgUEEAIBARIEkAUfMwoNCgUEEAIBAxIEkAU2OQpaCgMEEAUSBJMFAhkaTSBDbGllbnRzIGNhbiBkZWZpbmUgY3VzdG9tIG9wdGlvbnMgaW4gZXh0ZW5zaW9ucyBvZiB0aGlzIG1lc3NhZ2UuIFNlZSBhYm92ZS4KCgwKBAQQBQASBJMFDRgKDQoFBBAFAAESBJMFDREKDQoFBBAFAAISBJMFFRgKDAoCBBESBpYFALMFAQoLCgMEEQESBJYFCBUK1gMKBAQRAgASBKEFAjAa3AEgSXMgdGhpcyBtZXRob2QgZGVwcmVjYXRlZD8KIERlcGVuZGluZyBvbiB0aGUgdGFyZ2V0IHBsYXRmb3JtLCB0aGlzIGNhbiBlbWl0IERlcHJlY2F0ZWQgYW5ub3RhdGlvbnMKIGZvciB0aGUgbWV0aG9kLCBvciBpdCB3aWxsIGJlIGNvbXBsZXRlbHkgaWdub3JlZDsgaW4gdGhlIHZlcnkgbGVhc3QsCiB0aGlzIGlzIGEgZm9ybWFsaXphdGlvbiBmb3IgZGVwcmVjYXRpbmcgbWV0aG9kcy4KMugBIE5vdGU6ICBGaWVsZCBudW1iZXJzIDEgdGhyb3VnaCAzMiBhcmUgcmVzZXJ2ZWQgZm9yIEdvb2dsZSdzIGludGVybmFsIFJQQwogICBmcmFtZXdvcmsuICBXZSBhcG9sb2dpemUgZm9yIGhvYXJkaW5nIHRoZXNlIG51bWJlcnMgdG8gb3Vyc2VsdmVzLCBidXQKICAgd2Ugd2VyZSBhbHJlYWR5IHVzaW5nIHRoZW0gbG9uZyBiZWZvcmUgd2UgZGVjaWRlZCB0byByZWxlYXNlIFByb3RvY29sCiAgIEJ1ZmZlcnMuCgoNCgUEEQIABBIEoQUCCgoNCgUEEQIABRIEoQULDwoNCgUEEQIAARIEoQUQGgoNCgUEEQIAAxIEoQUdHwoNCgUEEQIACBIEoQUgLwoNCgUEEQIABxIEoQUpLgrwAQoEBBEEABIGpgUCqgUDGt8BIElzIHRoaXMgbWV0aG9kIHNpZGUtZWZmZWN0LWZyZWUgKG9yIHNhZmUgaW4gSFRUUCBwYXJsYW5jZSksIG9yIGlkZW1wb3RlbnQsCiBvciBuZWl0aGVyPyBIVFRQIGJhc2VkIFJQQyBpbXBsZW1lbnRhdGlvbiBtYXkgY2hvb3NlIEdFVCB2ZXJiIGZvciBzYWZlCiBtZXRob2RzLCBhbmQgUFVUIHZlcmIgZm9yIGlkZW1wb3RlbnQgbWV0aG9kcyBpbnN0ZWFkIG9mIHRoZSBkZWZhdWx0IFBPU1QuCgoNCgUEEQQAARIEpgUHFwoOCgYEEQQAAgASBKcFBBwKDwoHBBEEAAIAARIEpwUEFwoPCgcEEQQAAgACEgSnBRobCiQKBgQRBAACARIEqAUEHCIUIGltcGxpZXMgaWRlbXBvdGVudAoKDwoHBBEEAAIBARIEqAUEEwoPCgcEEQQAAgECEgSoBRobCjcKBgQRBAACAhIEqQUEHCInIGlkZW1wb3RlbnQsIGJ1dCBtYXkgaGF2ZSBzaWRlIGVmZmVjdHMKCg8KBwQRBAACAgESBKkFBA4KDwoHBBEEAAICAhIEqQUaGwoOCgQEEQIBEgarBQKsBScKDQoFBBECAQQSBKsFAgoKDQoFBBECAQYSBKsFCxsKDQoFBBECAQESBKsFHC0KDQoFBBECAQMSBKwFBggKDQoFBBECAQgSBKwFCSYKDQoFBBECAQcSBKwFEiUKTwoEBBECAhIErwUCOhpBIFRoZSBwYXJzZXIgc3RvcmVzIG9wdGlvbnMgaXQgZG9lc24ndCByZWNvZ25pemUgaGVyZS4gU2VlIGFib3ZlLgoKDQoFBBECAgQSBK8FAgoKDQoFBBECAgYSBK8FCx4KDQoFBBECAgESBK8FHzMKDQoFBBECAgMSBK8FNjkKWgoDBBEFEgSyBQIZGk0gQ2xpZW50cyBjYW4gZGVmaW5lIGN1c3RvbSBvcHRpb25zIGluIGV4dGVuc2lvbnMgb2YgdGhpcyBtZXNzYWdlLiBTZWUgYWJvdmUuCgoMCgQEEQUAEgSyBQ0YCg0KBQQRBQABEgSyBQ0RCg0KBQQRBQACEgSyBRUYCosDCgIEEhIGvAUA0AUBGvwCIEEgbWVzc2FnZSByZXByZXNlbnRpbmcgYSBvcHRpb24gdGhlIHBhcnNlciBkb2VzIG5vdCByZWNvZ25pemUuIFRoaXMgb25seQogYXBwZWFycyBpbiBvcHRpb25zIHByb3RvcyBjcmVhdGVkIGJ5IHRoZSBjb21waWxlcjo6UGFyc2VyIGNsYXNzLgogRGVzY3JpcHRvclBvb2wgcmVzb2x2ZXMgdGhlc2Ugd2hlbiBidWlsZGluZyBEZXNjcmlwdG9yIG9iamVjdHMuIFRoZXJlZm9yZSwKIG9wdGlvbnMgcHJvdG9zIGluIGRlc2NyaXB0b3Igb2JqZWN0cyAoZS5nLiByZXR1cm5lZCBieSBEZXNjcmlwdG9yOjpvcHRpb25zKCksCiBvciBwcm9kdWNlZCBieSBEZXNjcmlwdG9yOjpDb3B5VG8oKSkgd2lsbCBuZXZlciBoYXZlIFVuaW50ZXJwcmV0ZWRPcHRpb25zCiBpbiB0aGVtLgoKCwoDBBIBEgS8BQgbCssCCgQEEgMAEgbCBQLFBQMaugIgVGhlIG5hbWUgb2YgdGhlIHVuaW50ZXJwcmV0ZWQgb3B0aW9uLiAgRWFjaCBzdHJpbmcgcmVwcmVzZW50cyBhIHNlZ21lbnQgaW4KIGEgZG90LXNlcGFyYXRlZCBuYW1lLiAgaXNfZXh0ZW5zaW9uIGlzIHRydWUgaWZmIGEgc2VnbWVudCByZXByZXNlbnRzIGFuCiBleHRlbnNpb24gKGRlbm90ZWQgd2l0aCBwYXJlbnRoZXNlcyBpbiBvcHRpb25zIHNwZWNzIGluIC5wcm90byBmaWxlcykuCiBFLmcuLHsgWyJmb28iLCBmYWxzZV0sIFsiYmFyLmJheiIsIHRydWVdLCBbInF1eCIsIGZhbHNlXSB9IHJlcHJlc2VudHMKICJmb28uKGJhci5iYXopLnF1eCIuCgoNCgUEEgMAARIEwgUKEgoOCgYEEgMAAgASBMMFBCIKDwoHBBIDAAIABBIEwwUEDAoPCgcEEgMAAgAFEgTDBQ0TCg8KBwQSAwACAAESBMMFFB0KDwoHBBIDAAIAAxIEwwUgIQoOCgYEEgMAAgESBMQFBCMKDwoHBBIDAAIBBBIExAUEDAoPCgcEEgMAAgEFEgTEBQ0RCg8KBwQSAwACAQESBMQFEh4KDwoHBBIDAAIBAxIExAUhIgoMCgQEEgIAEgTGBQIdCg0KBQQSAgAEEgTGBQIKCg0KBQQSAgAGEgTGBQsTCg0KBQQSAgABEgTGBRQYCg0KBQQSAgADEgTGBRscCpwBCgQEEgIBEgTKBQInGo0BIFRoZSB2YWx1ZSBvZiB0aGUgdW5pbnRlcnByZXRlZCBvcHRpb24sIGluIHdoYXRldmVyIHR5cGUgdGhlIHRva2VuaXplcgogaWRlbnRpZmllZCBpdCBhcyBkdXJpbmcgcGFyc2luZy4gRXhhY3RseSBvbmUgb2YgdGhlc2Ugc2hvdWxkIGJlIHNldC4KCg0KBQQSAgEEEgTKBQIKCg0KBQQSAgEFEgTKBQsRCg0KBQQSAgEBEgTKBRIiCg0KBQQSAgEDEgTKBSUmCgwKBAQSAgISBMsFAikKDQoFBBICAgQSBMsFAgoKDQoFBBICAgUSBMsFCxEKDQoFBBICAgESBMsFEiQKDQoFBBICAgMSBMsFJygKDAoEBBICAxIEzAUCKAoNCgUEEgIDBBIEzAUCCgoNCgUEEgIDBRIEzAULEAoNCgUEEgIDARIEzAURIwoNCgUEEgIDAxIEzAUmJwoMCgQEEgIEEgTNBQIjCg0KBQQSAgQEEgTNBQIKCg0KBQQSAgQFEgTNBQsRCg0KBQQSAgQBEgTNBRIeCg0KBQQSAgQDEgTNBSEiCgwKBAQSAgUSBM4FAiIKDQoFBBICBQQSBM4FAgoKDQoFBBICBQUSBM4FCxAKDQoFBBICBQESBM4FER0KDQoFBBICBQMSBM4FICEKDAoEBBICBhIEzwUCJgoNCgUEEgIGBBIEzwUCCgoNCgUEEgIGBRIEzwULEQoNCgUEEgIGARIEzwUSIQoNCgUEEgIGAxIEzwUkJQraAQoCBBMSBtcFANgGARpqIEVuY2Fwc3VsYXRlcyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgb3JpZ2luYWwgc291cmNlIGZpbGUgZnJvbSB3aGljaCBhCiBGaWxlRGVzY3JpcHRvclByb3RvIHdhcyBnZW5lcmF0ZWQuCjJgID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KIE9wdGlvbmFsIHNvdXJjZSBjb2RlIGluZm8KCgsKAwQTARIE1wUIFgqCEQoEBBMCABIEgwYCIRrzECBBIExvY2F0aW9uIGlkZW50aWZpZXMgYSBwaWVjZSBvZiBzb3VyY2UgY29kZSBpbiBhIC5wcm90byBmaWxlIHdoaWNoCiBjb3JyZXNwb25kcyB0byBhIHBhcnRpY3VsYXIgZGVmaW5pdGlvbi4gIFRoaXMgaW5mb3JtYXRpb24gaXMgaW50ZW5kZWQKIHRvIGJlIHVzZWZ1bCB0byBJREVzLCBjb2RlIGluZGV4ZXJzLCBkb2N1bWVudGF0aW9uIGdlbmVyYXRvcnMsIGFuZCBzaW1pbGFyCiB0b29scy4KCiBGb3IgZXhhbXBsZSwgc2F5IHdlIGhhdmUgYSBmaWxlIGxpa2U6CiAgIG1lc3NhZ2UgRm9vIHsKICAgICBvcHRpb25hbCBzdHJpbmcgZm9vID0gMTsKICAgfQogTGV0J3MgbG9vayBhdCBqdXN0IHRoZSBmaWVsZCBkZWZpbml0aW9uOgogICBvcHRpb25hbCBzdHJpbmcgZm9vID0gMTsKICAgXiAgICAgICBeXiAgICAgXl4gIF4gIF5eXgogICBhICAgICAgIGJjICAgICBkZSAgZiAgZ2hpCiBXZSBoYXZlIHRoZSBmb2xsb3dpbmcgbG9jYXRpb25zOgogICBzcGFuICAgcGF0aCAgICAgICAgICAgICAgIHJlcHJlc2VudHMKICAgW2EsaSkgIFsgNCwgMCwgMiwgMCBdICAgICBUaGUgd2hvbGUgZmllbGQgZGVmaW5pdGlvbi4KICAgW2EsYikgIFsgNCwgMCwgMiwgMCwgNCBdICBUaGUgbGFiZWwgKG9wdGlvbmFsKS4KICAgW2MsZCkgIFsgNCwgMCwgMiwgMCwgNSBdICBUaGUgdHlwZSAoc3RyaW5nKS4KICAgW2UsZikgIFsgNCwgMCwgMiwgMCwgMSBdICBUaGUgbmFtZSAoZm9vKS4KICAgW2csaCkgIFsgNCwgMCwgMiwgMCwgMyBdICBUaGUgbnVtYmVyICgxKS4KCiBOb3RlczoKIC0gQSBsb2NhdGlvbiBtYXkgcmVmZXIgdG8gYSByZXBlYXRlZCBmaWVsZCBpdHNlbGYgKGkuZS4gbm90IHRvIGFueQogICBwYXJ0aWN1bGFyIGluZGV4IHdpdGhpbiBpdCkuICBUaGlzIGlzIHVzZWQgd2hlbmV2ZXIgYSBzZXQgb2YgZWxlbWVudHMgYXJlCiAgIGxvZ2ljYWxseSBlbmNsb3NlZCBpbiBhIHNpbmdsZSBjb2RlIHNlZ21lbnQuICBGb3IgZXhhbXBsZSwgYW4gZW50aXJlCiAgIGV4dGVuZCBibG9jayAocG9zc2libHkgY29udGFpbmluZyBtdWx0aXBsZSBleHRlbnNpb24gZGVmaW5pdGlvbnMpIHdpbGwKICAgaGF2ZSBhbiBvdXRlciBsb2NhdGlvbiB3aG9zZSBwYXRoIHJlZmVycyB0byB0aGUgImV4dGVuc2lvbnMiIHJlcGVhdGVkCiAgIGZpZWxkIHdpdGhvdXQgYW4gaW5kZXguCiAtIE11bHRpcGxlIGxvY2F0aW9ucyBtYXkgaGF2ZSB0aGUgc2FtZSBwYXRoLiAgVGhpcyBoYXBwZW5zIHdoZW4gYSBzaW5nbGUKICAgbG9naWNhbCBkZWNsYXJhdGlvbiBpcyBzcHJlYWQgb3V0IGFjcm9zcyBtdWx0aXBsZSBwbGFjZXMuICBUaGUgbW9zdAogICBvYnZpb3VzIGV4YW1wbGUgaXMgdGhlICJleHRlbmQiIGJsb2NrIGFnYWluIC0tIHRoZXJlIG1heSBiZSBtdWx0aXBsZQogICBleHRlbmQgYmxvY2tzIGluIHRoZSBzYW1lIHNjb3BlLCBlYWNoIG9mIHdoaWNoIHdpbGwgaGF2ZSB0aGUgc2FtZSBwYXRoLgogLSBBIGxvY2F0aW9uJ3Mgc3BhbiBpcyBub3QgYWx3YXlzIGEgc3Vic2V0IG9mIGl0cyBwYXJlbnQncyBzcGFuLiAgRm9yCiAgIGV4YW1wbGUsIHRoZSAiZXh0ZW5kZWUiIG9mIGFuIGV4dGVuc2lvbiBkZWNsYXJhdGlvbiBhcHBlYXJzIGF0IHRoZQogICBiZWdpbm5pbmcgb2YgdGhlICJleHRlbmQiIGJsb2NrIGFuZCBpcyBzaGFyZWQgYnkgYWxsIGV4dGVuc2lvbnMgd2l0aGluCiAgIHRoZSBibG9jay4KIC0gSnVzdCBiZWNhdXNlIGEgbG9jYXRpb24ncyBzcGFuIGlzIGEgc3Vic2V0IG9mIHNvbWUgb3RoZXIgbG9jYXRpb24ncyBzcGFuCiAgIGRvZXMgbm90IG1lYW4gdGhhdCBpdCBpcyBhIGRlc2NlbmRlbnQuICBGb3IgZXhhbXBsZSwgYSAiZ3JvdXAiIGRlZmluZXMKICAgYm90aCBhIHR5cGUgYW5kIGEgZmllbGQgaW4gYSBzaW5nbGUgZGVjbGFyYXRpb24uICBUaHVzLCB0aGUgbG9jYXRpb25zCiAgIGNvcnJlc3BvbmRpbmcgdG8gdGhlIHR5cGUgYW5kIGZpZWxkIGFuZCB0aGVpciBjb21wb25lbnRzIHdpbGwgb3ZlcmxhcC4KIC0gQ29kZSB3aGljaCB0cmllcyB0byBpbnRlcnByZXQgbG9jYXRpb25zIHNob3VsZCBwcm9iYWJseSBiZSBkZXNpZ25lZCB0bwogICBpZ25vcmUgdGhvc2UgdGhhdCBpdCBkb2Vzbid0IHVuZGVyc3RhbmQsIGFzIG1vcmUgdHlwZXMgb2YgbG9jYXRpb25zIGNvdWxkCiAgIGJlIHJlY29yZGVkIGluIHRoZSBmdXR1cmUuCgoNCgUEEwIABBIEgwYCCgoNCgUEEwIABhIEgwYLEwoNCgUEEwIAARIEgwYUHAoNCgUEEwIAAxIEgwYfIAoOCgQEEwMAEgaEBgLXBgMKDQoFBBMDAAESBIQGChIKgwcKBgQTAwACABIEnAYEKhryBiBJZGVudGlmaWVzIHdoaWNoIHBhcnQgb2YgdGhlIEZpbGVEZXNjcmlwdG9yUHJvdG8gd2FzIGRlZmluZWQgYXQgdGhpcwogbG9jYXRpb24uCgogRWFjaCBlbGVtZW50IGlzIGEgZmllbGQgbnVtYmVyIG9yIGFuIGluZGV4LiAgVGhleSBmb3JtIGEgcGF0aCBmcm9tCiB0aGUgcm9vdCBGaWxlRGVzY3JpcHRvclByb3RvIHRvIHRoZSBwbGFjZSB3aGVyZSB0aGUgZGVmaW5pdGlvbi4gIEZvcgogZXhhbXBsZSwgdGhpcyBwYXRoOgogICBbIDQsIDMsIDIsIDcsIDEgXQogcmVmZXJzIHRvOgogICBmaWxlLm1lc3NhZ2VfdHlwZSgzKSAgLy8gNCwgMwogICAgICAgLmZpZWxkKDcpICAgICAgICAgLy8gMiwgNwogICAgICAgLm5hbWUoKSAgICAgICAgICAgLy8gMQogVGhpcyBpcyBiZWNhdXNlIEZpbGVEZXNjcmlwdG9yUHJvdG8ubWVzc2FnZV90eXBlIGhhcyBmaWVsZCBudW1iZXIgNDoKICAgcmVwZWF0ZWQgRGVzY3JpcHRvclByb3RvIG1lc3NhZ2VfdHlwZSA9IDQ7CiBhbmQgRGVzY3JpcHRvclByb3RvLmZpZWxkIGhhcyBmaWVsZCBudW1iZXIgMjoKICAgcmVwZWF0ZWQgRmllbGREZXNjcmlwdG9yUHJvdG8gZmllbGQgPSAyOwogYW5kIEZpZWxkRGVzY3JpcHRvclByb3RvLm5hbWUgaGFzIGZpZWxkIG51bWJlciAxOgogICBvcHRpb25hbCBzdHJpbmcgbmFtZSA9IDE7CgogVGh1cywgdGhlIGFib3ZlIHBhdGggZ2l2ZXMgdGhlIGxvY2F0aW9uIG9mIGEgZmllbGQgbmFtZS4gIElmIHdlIHJlbW92ZWQKIHRoZSBsYXN0IGVsZW1lbnQ6CiAgIFsgNCwgMywgMiwgNyBdCiB0aGlzIHBhdGggcmVmZXJzIHRvIHRoZSB3aG9sZSBmaWVsZCBkZWNsYXJhdGlvbiAoZnJvbSB0aGUgYmVnaW5uaW5nCiBvZiB0aGUgbGFiZWwgdG8gdGhlIHRlcm1pbmF0aW5nIHNlbWljb2xvbikuCgoPCgcEEwMAAgAEEgScBgQMCg8KBwQTAwACAAUSBJwGDRIKDwoHBBMDAAIAARIEnAYTFwoPCgcEEwMAAgADEgScBhobCg8KBwQTAwACAAgSBJwGHCkKEAoIBBMDAAIACAISBJwGHSgK0gIKBgQTAwACARIEowYEKhrBAiBBbHdheXMgaGFzIGV4YWN0bHkgdGhyZWUgb3IgZm91ciBlbGVtZW50czogc3RhcnQgbGluZSwgc3RhcnQgY29sdW1uLAogZW5kIGxpbmUgKG9wdGlvbmFsLCBvdGhlcndpc2UgYXNzdW1lZCBzYW1lIGFzIHN0YXJ0IGxpbmUpLCBlbmQgY29sdW1uLgogVGhlc2UgYXJlIHBhY2tlZCBpbnRvIGEgc2luZ2xlIGZpZWxkIGZvciBlZmZpY2llbmN5LiAgTm90ZSB0aGF0IGxpbmUKIGFuZCBjb2x1bW4gbnVtYmVycyBhcmUgemVyby1iYXNlZCAtLSB0eXBpY2FsbHkgeW91IHdpbGwgd2FudCB0byBhZGQKIDEgdG8gZWFjaCBiZWZvcmUgZGlzcGxheWluZyB0byBhIHVzZXIuCgoPCgcEEwMAAgEEEgSjBgQMCg8KBwQTAwACAQUSBKMGDRIKDwoHBBMDAAIBARIEowYTFwoPCgcEEwMAAgEDEgSjBhobCg8KBwQTAwACAQgSBKMGHCkKEAoIBBMDAAIBCAISBKMGHSgKpQwKBgQTAwACAhIE1AYEKRqUDCBJZiB0aGlzIFNvdXJjZUNvZGVJbmZvIHJlcHJlc2VudHMgYSBjb21wbGV0ZSBkZWNsYXJhdGlvbiwgdGhlc2UgYXJlIGFueQogY29tbWVudHMgYXBwZWFyaW5nIGJlZm9yZSBhbmQgYWZ0ZXIgdGhlIGRlY2xhcmF0aW9uIHdoaWNoIGFwcGVhciB0byBiZQogYXR0YWNoZWQgdG8gdGhlIGRlY2xhcmF0aW9uLgoKIEEgc2VyaWVzIG9mIGxpbmUgY29tbWVudHMgYXBwZWFyaW5nIG9uIGNvbnNlY3V0aXZlIGxpbmVzLCB3aXRoIG5vIG90aGVyCiB0b2tlbnMgYXBwZWFyaW5nIG9uIHRob3NlIGxpbmVzLCB3aWxsIGJlIHRyZWF0ZWQgYXMgYSBzaW5nbGUgY29tbWVudC4KCiBsZWFkaW5nX2RldGFjaGVkX2NvbW1lbnRzIHdpbGwga2VlcCBwYXJhZ3JhcGhzIG9mIGNvbW1lbnRzIHRoYXQgYXBwZWFyCiBiZWZvcmUgKGJ1dCBub3QgY29ubmVjdGVkIHRvKSB0aGUgY3VycmVudCBlbGVtZW50LiBFYWNoIHBhcmFncmFwaCwKIHNlcGFyYXRlZCBieSBlbXB0eSBsaW5lcywgd2lsbCBiZSBvbmUgY29tbWVudCBlbGVtZW50IGluIHRoZSByZXBlYXRlZAogZmllbGQuCgogT25seSB0aGUgY29tbWVudCBjb250ZW50IGlzIHByb3ZpZGVkOyBjb21tZW50IG1hcmtlcnMgKGUuZy4gLy8pIGFyZQogc3RyaXBwZWQgb3V0LiAgRm9yIGJsb2NrIGNvbW1lbnRzLCBsZWFkaW5nIHdoaXRlc3BhY2UgYW5kIGFuIGFzdGVyaXNrCiB3aWxsIGJlIHN0cmlwcGVkIGZyb20gdGhlIGJlZ2lubmluZyBvZiBlYWNoIGxpbmUgb3RoZXIgdGhhbiB0aGUgZmlyc3QuCiBOZXdsaW5lcyBhcmUgaW5jbHVkZWQgaW4gdGhlIG91dHB1dC4KCiBFeGFtcGxlczoKCiAgIG9wdGlvbmFsIGludDMyIGZvbyA9IDE7ICAvLyBDb21tZW50IGF0dGFjaGVkIHRvIGZvby4KICAgLy8gQ29tbWVudCBhdHRhY2hlZCB0byBiYXIuCiAgIG9wdGlvbmFsIGludDMyIGJhciA9IDI7CgogICBvcHRpb25hbCBzdHJpbmcgYmF6ID0gMzsKICAgLy8gQ29tbWVudCBhdHRhY2hlZCB0byBiYXouCiAgIC8vIEFub3RoZXIgbGluZSBhdHRhY2hlZCB0byBiYXouCgogICAvLyBDb21tZW50IGF0dGFjaGVkIHRvIHF1eC4KICAgLy8KICAgLy8gQW5vdGhlciBsaW5lIGF0dGFjaGVkIHRvIHF1eC4KICAgb3B0aW9uYWwgZG91YmxlIHF1eCA9IDQ7CgogICAvLyBEZXRhY2hlZCBjb21tZW50IGZvciBjb3JnZS4gVGhpcyBpcyBub3QgbGVhZGluZyBvciB0cmFpbGluZyBjb21tZW50cwogICAvLyB0byBxdXggb3IgY29yZ2UgYmVjYXVzZSB0aGVyZSBhcmUgYmxhbmsgbGluZXMgc2VwYXJhdGluZyBpdCBmcm9tCiAgIC8vIGJvdGguCgogICAvLyBEZXRhY2hlZCBjb21tZW50IGZvciBjb3JnZSBwYXJhZ3JhcGggMi4KCiAgIG9wdGlvbmFsIHN0cmluZyBjb3JnZSA9IDU7CiAgIC8qIEJsb2NrIGNvbW1lbnQgYXR0YWNoZWQKICAgICogdG8gY29yZ2UuICBMZWFkaW5nIGFzdGVyaXNrcwogICAgKiB3aWxsIGJlIHJlbW92ZWQuICovCiAgIC8qIEJsb2NrIGNvbW1lbnQgYXR0YWNoZWQgdG8KICAgICogZ3JhdWx0LiAqLwogICBvcHRpb25hbCBpbnQzMiBncmF1bHQgPSA2OwoKICAgLy8gaWdub3JlZCBkZXRhY2hlZCBjb21tZW50cy4KCg8KBwQTAwACAgQSBNQGBAwKDwoHBBMDAAICBRIE1AYNEwoPCgcEEwMAAgIBEgTUBhQkCg8KBwQTAwACAgMSBNQGJygKDgoGBBMDAAIDEgTVBgQqCg8KBwQTAwACAwQSBNUGBAwKDwoHBBMDAAIDBRIE1QYNEwoPCgcEEwMAAgMBEgTVBhQlCg8KBwQTAwACAwMSBNUGKCkKDgoGBBMDAAIEEgTWBgQyCg8KBwQTAwACBAQSBNYGBAwKDwoHBBMDAAIEBRIE1gYNEwoPCgcEEwMAAgQBEgTWBhQtCg8KBwQTAwACBAMSBNYGMDEK7gEKAgQUEgbdBgDyBgEa3wEgRGVzY3JpYmVzIHRoZSByZWxhdGlvbnNoaXAgYmV0d2VlbiBnZW5lcmF0ZWQgY29kZSBhbmQgaXRzIG9yaWdpbmFsIHNvdXJjZQogZmlsZS4gQSBHZW5lcmF0ZWRDb2RlSW5mbyBtZXNzYWdlIGlzIGFzc29jaWF0ZWQgd2l0aCBvbmx5IG9uZSBnZW5lcmF0ZWQKIHNvdXJjZSBmaWxlLCBidXQgbWF5IGNvbnRhaW4gcmVmZXJlbmNlcyB0byBkaWZmZXJlbnQgc291cmNlIC5wcm90byBmaWxlcy4KCgsKAwQUARIE3QYIGQp4CgQEFAIAEgTgBgIlGmogQW4gQW5ub3RhdGlvbiBjb25uZWN0cyBzb21lIHNwYW4gb2YgdGV4dCBpbiBnZW5lcmF0ZWQgY29kZSB0byBhbiBlbGVtZW50CiBvZiBpdHMgZ2VuZXJhdGluZyAucHJvdG8gZmlsZS4KCg0KBQQUAgAEEgTgBgIKCg0KBQQUAgAGEgTgBgsVCg0KBQQUAgABEgTgBhYgCg0KBQQUAgADEgTgBiMkCg4KBAQUAwASBuEGAvEGAwoNCgUEFAMAARIE4QYKFAqPAQoGBBQDAAIAEgTkBgQqGn8gSWRlbnRpZmllcyB0aGUgZWxlbWVudCBpbiB0aGUgb3JpZ2luYWwgc291cmNlIC5wcm90byBmaWxlLiBUaGlzIGZpZWxkCiBpcyBmb3JtYXR0ZWQgdGhlIHNhbWUgYXMgU291cmNlQ29kZUluZm8uTG9jYXRpb24ucGF0aC4KCg8KBwQUAwACAAQSBOQGBAwKDwoHBBQDAAIABRIE5AYNEgoPCgcEFAMAAgABEgTkBhMXCg8KBwQUAwACAAMSBOQGGhsKDwoHBBQDAAIACBIE5AYcKQoQCggEFAMAAgAIAhIE5AYdKApPCgYEFAMAAgESBOcGBCQaPyBJZGVudGlmaWVzIHRoZSBmaWxlc3lzdGVtIHBhdGggdG8gdGhlIG9yaWdpbmFsIHNvdXJjZSAucHJvdG8uCgoPCgcEFAMAAgEEEgTnBgQMCg8KBwQUAwACAQUSBOcGDRMKDwoHBBQDAAIBARIE5wYUHwoPCgcEFAMAAgEDEgTnBiIjCncKBgQUAwACAhIE6wYEHRpnIElkZW50aWZpZXMgdGhlIHN0YXJ0aW5nIG9mZnNldCBpbiBieXRlcyBpbiB0aGUgZ2VuZXJhdGVkIGNvZGUKIHRoYXQgcmVsYXRlcyB0byB0aGUgaWRlbnRpZmllZCBvYmplY3QuCgoPCgcEFAMAAgIEEgTrBgQMCg8KBwQUAwACAgUSBOsGDRIKDwoHBBQDAAICARIE6wYTGAoPCgcEFAMAAgIDEgTrBhscCtsBCgYEFAMAAgMSBPAGBBsaygEgSWRlbnRpZmllcyB0aGUgZW5kaW5nIG9mZnNldCBpbiBieXRlcyBpbiB0aGUgZ2VuZXJhdGVkIGNvZGUgdGhhdAogcmVsYXRlcyB0byB0aGUgaWRlbnRpZmllZCBvZmZzZXQuIFRoZSBlbmQgb2Zmc2V0IHNob3VsZCBiZSBvbmUgcGFzdAogdGhlIGxhc3QgcmVsZXZhbnQgYnl0ZSAoc28gdGhlIGxlbmd0aCBvZiB0aGUgdGV4dCA9IGVuZCAtIGJlZ2luKS4KCg8KBwQUAwACAwQSBPAGBAwKDwoHBBQDAAIDBRIE8AYNEgoPCgcEFAMAAgMBEgTwBhMWCg8KBwQUAwACAwMSBPAGGRoKgWIKFGdvZ29wcm90by9nb2dvLnByb3RvEglnb2dvcHJvdG8aIGdvb2dsZS9wcm90b2J1Zi9kZXNjcmlwdG9yLnByb3RvOk4KE2dvcHJvdG9fZW51bV9wcmVmaXgSHC5nb29nbGUucHJvdG9idWYuRW51bU9wdGlvbnMYseQDIAEoCFIRZ29wcm90b0VudW1QcmVmaXg6UgoVZ29wcm90b19lbnVtX3N0cmluZ2VyEhwuZ29vZ2xlLnByb3RvYnVmLkVudW1PcHRpb25zGMXkAyABKAhSE2dvcHJvdG9FbnVtU3RyaW5nZXI6QwoNZW51bV9zdHJpbmdlchIcLmdvb2dsZS5wcm90b2J1Zi5FbnVtT3B0aW9ucxjG5AMgASgIUgxlbnVtU3RyaW5nZXI6RwoPZW51bV9jdXN0b21uYW1lEhwuZ29vZ2xlLnByb3RvYnVmLkVudW1PcHRpb25zGMfkAyABKAlSDmVudW1DdXN0b21uYW1lOjoKCGVudW1kZWNsEhwuZ29vZ2xlLnByb3RvYnVmLkVudW1PcHRpb25zGMjkAyABKAhSCGVudW1kZWNsOlYKFGVudW12YWx1ZV9jdXN0b21uYW1lEiEuZ29vZ2xlLnByb3RvYnVmLkVudW1WYWx1ZU9wdGlvbnMY0YMEIAEoCVITZW51bXZhbHVlQ3VzdG9tbmFtZTpOChNnb3Byb3RvX2dldHRlcnNfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGJnsAyABKAhSEWdvcHJvdG9HZXR0ZXJzQWxsOlUKF2dvcHJvdG9fZW51bV9wcmVmaXhfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGJrsAyABKAhSFGdvcHJvdG9FbnVtUHJlZml4QWxsOlAKFGdvcHJvdG9fc3RyaW5nZXJfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGJvsAyABKAhSEmdvcHJvdG9TdHJpbmdlckFsbDpKChF2ZXJib3NlX2VxdWFsX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxic7AMgASgIUg92ZXJib3NlRXF1YWxBbGw6OQoIZmFjZV9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYnewDIAEoCFIHZmFjZUFsbDpBCgxnb3N0cmluZ19hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYnuwDIAEoCFILZ29zdHJpbmdBbGw6QQoMcG9wdWxhdGVfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGJ/sAyABKAhSC3BvcHVsYXRlQWxsOkEKDHN0cmluZ2VyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxig7AMgASgIUgtzdHJpbmdlckFsbDo/Cgtvbmx5b25lX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxih7AMgASgIUgpvbmx5b25lQWxsOjsKCWVxdWFsX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxil7AMgASgIUghlcXVhbEFsbDpHCg9kZXNjcmlwdGlvbl9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYpuwDIAEoCFIOZGVzY3JpcHRpb25BbGw6PwoLdGVzdGdlbl9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYp+wDIAEoCFIKdGVzdGdlbkFsbDpBCgxiZW5jaGdlbl9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYqOwDIAEoCFILYmVuY2hnZW5BbGw6QwoNbWFyc2hhbGVyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxip7AMgASgIUgxtYXJzaGFsZXJBbGw6RwoPdW5tYXJzaGFsZXJfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGKrsAyABKAhSDnVubWFyc2hhbGVyQWxsOlAKFHN0YWJsZV9tYXJzaGFsZXJfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGKvsAyABKAhSEnN0YWJsZU1hcnNoYWxlckFsbDo7CglzaXplcl9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYrOwDIAEoCFIIc2l6ZXJBbGw6WQoZZ29wcm90b19lbnVtX3N0cmluZ2VyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxit7AMgASgIUhZnb3Byb3RvRW51bVN0cmluZ2VyQWxsOkoKEWVudW1fc3RyaW5nZXJfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGK7sAyABKAhSD2VudW1TdHJpbmdlckFsbDpQChR1bnNhZmVfbWFyc2hhbGVyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxiv7AMgASgIUhJ1bnNhZmVNYXJzaGFsZXJBbGw6VAoWdW5zYWZlX3VubWFyc2hhbGVyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxiw7AMgASgIUhR1bnNhZmVVbm1hcnNoYWxlckFsbDpbChpnb3Byb3RvX2V4dGVuc2lvbnNfbWFwX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxix7AMgASgIUhdnb3Byb3RvRXh0ZW5zaW9uc01hcEFsbDpYChhnb3Byb3RvX3VucmVjb2duaXplZF9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYsuwDIAEoCFIWZ29wcm90b1VucmVjb2duaXplZEFsbDpJChBnb2dvcHJvdG9faW1wb3J0EhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGLPsAyABKAhSD2dvZ29wcm90b0ltcG9ydDpFCg5wcm90b3NpemVyX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxi07AMgASgIUg1wcm90b3NpemVyQWxsOj8KC2NvbXBhcmVfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGLXsAyABKAhSCmNvbXBhcmVBbGw6QQoMdHlwZWRlY2xfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGLbsAyABKAhSC3R5cGVkZWNsQWxsOkEKDGVudW1kZWNsX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxi37AMgASgIUgtlbnVtZGVjbEFsbDpRChRnb3Byb3RvX3JlZ2lzdHJhdGlvbhIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxi47AMgASgIUhNnb3Byb3RvUmVnaXN0cmF0aW9uOkcKD21lc3NhZ2VuYW1lX2FsbBIcLmdvb2dsZS5wcm90b2J1Zi5GaWxlT3B0aW9ucxi57AMgASgIUg5tZXNzYWdlbmFtZUFsbDpSChVnb3Byb3RvX3NpemVjYWNoZV9hbGwSHC5nb29nbGUucHJvdG9idWYuRmlsZU9wdGlvbnMYuuwDIAEoCFITZ29wcm90b1NpemVjYWNoZUFsbDpOChNnb3Byb3RvX3Vua2V5ZWRfYWxsEhwuZ29vZ2xlLnByb3RvYnVmLkZpbGVPcHRpb25zGLvsAyABKAhSEWdvcHJvdG9VbmtleWVkQWxsOkoKD2dvcHJvdG9fZ2V0dGVycxIfLmdvb2dsZS5wcm90b2J1Zi5NZXNzYWdlT3B0aW9ucxiB9AMgASgIUg5nb3Byb3RvR2V0dGVyczpMChBnb3Byb3RvX3N0cmluZ2VyEh8uZ29vZ2xlLnByb3RvYnVmLk1lc3NhZ2VPcHRpb25zGIP0AyABKAhSD2dvcHJvdG9TdHJpbmdlcjpGCg12ZXJib3NlX2VxdWFsEh8uZ29vZ2xlLnByb3RvYnVmLk1lc3NhZ2VPcHRpb25zGIT0AyABKAhSDHZlcmJvc2VFcXVhbDo1CgRmYWNlEh8uZ29vZ2xlLnByb3RvYnVmLk1lc3NhZ2VPcHRpb25zGIX0AyABKAhSBGZhY2U6PQoIZ29zdHJpbmcSHy5nb29nbGUucHJvdG9idWYuTWVzc2FnZU9wdGlvbnMYhvQDIAEoCFIIZ29zdHJpbmc6PQoIcG9wdWxhdGUSHy5nb29nbGUucHJvdG9idWYuTWVzc2FnZU9wdGlvbnMYh/QDIAEoCFIIcG9wdWxhdGU6PQoIc3RyaW5nZXISHy5nb29nbGUucHJvdG9idWYuTWVzc2FnZU9wdGlvbnMYwIsEIAEoCFIIc3RyaW5nZXI6OwoHb25seW9uZRIfLmdvb2dsZS5wcm90b2J1Zi5NZXNzYWdlT3B0aW9ucxiJ9AMgASgIUgdvbmx5b25lOjcKBWVxdWFsEh8uZ29vZ2xlLnByb3RvYnVmLk1lc3NhZ2VPcHRpb25zGI30AyABKAhSBWVxdW