// Copyright 2019 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package groups_test

import (
	"testing"

	. "github.com/onsi/gomega"

	"istio.io/istio/galley/pkg/metadata"
	"istio.io/istio/galley/pkg/runtime/groups"
)

func TestDefault(t *testing.T) {
	g := NewGomegaWithT(t)
	actual := groups.IndexFunction("bogus", nil)
	g.Expect(actual).To(Equal(groups.Default))
}

func TestSyntheticServiceEntry(t *testing.T) {
	g := NewGomegaWithT(t)
	actual := groups.IndexFunction(metadata.IstioNetworkingV1alpha3SyntheticServiceentries.Collection.String(), nil)
	g.Expect(actual).To(Equal(groups.SyntheticServiceEntry))
}
